// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v2.0.1
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Component2_exec.h"
#include "tao/Messaging/Messaging.h"

namespace CIAO_Threading_Component2_Impl
{

  /**
   * Facet Executor Implementation Class: prov_interface_2_exec_i
   */

  prov_interface_2_exec_i::prov_interface_2_exec_i (
        ::Threading::CCM_Component2_Context_ptr ctx)
    : ciao_context_ (
        ::Threading::CCM_Component2_Context::_duplicate (ctx))
  {
  }

  prov_interface_2_exec_i::~prov_interface_2_exec_i (void)
  {
  }

  // Operations from ::Threading::interface_2

  void
  prov_interface_2_exec_i::invoke_on_interface_2 (void)
  {
    ACE_DEBUG ((LM_DEBUG, "prov_interface_2_exec_i::invoke_on_interface_2 - "
                          "Call received -> invoking 'invoke_on_interface_1' on Component1\n"));

    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    ::CORBA::ORB_var orb;
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        orb = ccm_object->_get_orb ();
      }

    CORBA::Object_var object =
      orb->resolve_initial_references ("PolicyCurrent");

    CORBA::PolicyCurrent_var policy_current =
      CORBA::PolicyCurrent::_narrow (object.in ());

    TimeBase::TimeT timeout_period = 100 * 100000;

    CORBA::Any timeout_as_any;
    timeout_as_any <<= timeout_period;

    CORBA::PolicyList policy_list (1);
    policy_list.length (1);
    policy_list[0] =
      orb->create_policy (Messaging::RELATIVE_RT_TIMEOUT_POLICY_TYPE,
                                  timeout_as_any);

    policy_current->set_policy_overrides (policy_list,
                                          CORBA::ADD_OVERRIDE);

    policy_list[0]->destroy();

    ::Threading::interface_1_var interface_1 =
      this->ciao_context_->get_connection_use_interface_1 ();

    bool except = false;
    try
      {
        interface_1->invoke_on_interface_1 ();
      }
    catch (const CORBA::TIMEOUT&)
      {
        except = true;
        ACE_DEBUG ((LM_DEBUG,
                    "invoke_on_interface_1 ping received an expected except.\n"));
      }

    if (!except)
      {
        ACE_DEBUG ((LM_DEBUG, "ERROR prov_interface_2_exec_i::invoke_on_interface_2 - "
                              "Is not blocking!!\n"));
      }
  }

  /**
   * Component Executor Implementation Class: Component2_exec_i
   */

  Component2_exec_i::Component2_exec_i (void){
  }

  Component2_exec_i::~Component2_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::Threading::CCM_interface_2_ptr
  Component2_exec_i::get_prov_interface_2 (void)
  {
    if ( ::CORBA::is_nil (this->ciao_prov_interface_2_.in ()))
      {
        prov_interface_2_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          prov_interface_2_exec_i (
            this->ciao_context_.in ()),
            ::Threading::CCM_interface_2::_nil ());

          this->ciao_prov_interface_2_ = tmp;
      }

    return
      ::Threading::CCM_interface_2::_duplicate (
        this->ciao_prov_interface_2_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Component2_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Threading::CCM_Component2_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Component2_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Component2_exec_i::ccm_activate (void)
  {
    /* Your code here. */
  }

  void
  Component2_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Component2_exec_i::ccm_remove (void)
  {
    /* Your code here. */
  }

  extern "C" COMPONENT2_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Threading_Component2_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Component2_exec_i);

    return retval;
  }
}
