// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v2.0.2
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Sender_exec.h"

namespace CIAO_Hello_Sender_Impl
{

  /**
   * Facet Executor Implementation Class: push_message_exec_i
   */

  push_message_exec_i::push_message_exec_i (
        ::Hello::CCM_Sender_Context_ptr ctx,
        Sender_exec_i& sender)
    : ciao_context_ (
        ::Hello::CCM_Sender_Context::_duplicate (ctx))
    , sender_ (sender)
  {
  }

  push_message_exec_i::~push_message_exec_i (void)
  {
  }

  // Operations from ::Hello::ReadMessage

  char *
  push_message_exec_i::get_message (void)
  {
    /* Your code here. */
    CORBA::String_var message = this->sender_.local_message();
    ACE_DEBUG ((LM_EMERGENCY, "Sender returning message: [%C]\n",
                message.in ()));
    return CORBA::string_dup (message.in ());
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
    : local_message_ ("Hello, world!")
  {
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Supported operations and attributes.

  void
  Sender_exec_i::start (void)
  {
    /* Your code here. */
    Hello::TimeOut_var event = new OBV_Hello::TimeOut;
    event->data ("ACE/TAO/CIAO");
    ACE_DEBUG ((LM_EMERGENCY, "Sender initiates the process.\n"));
    this->ciao_context_->push_click_out (event.in ());
  }

  // Component attributes and port operations.

  ::Hello::CCM_ReadMessage_ptr
  Sender_exec_i::get_push_message (void)
  {
    if ( ::CORBA::is_nil (this->ciao_push_message_.in ()))
      {
        push_message_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          push_message_exec_i (
            this->ciao_context_.in (),
            *this),
            ::Hello::CCM_ReadMessage::_nil ());

          this->ciao_push_message_ = tmp;
      }

    return
      ::Hello::CCM_ReadMessage::_duplicate (
        this->ciao_push_message_.in ());
  }

  char *
  Sender_exec_i::local_message (void)
  {
    return ::CORBA::string_dup (this->local_message_.in ());
  }

  void
  Sender_exec_i::local_message (
    const char * local_message)
  {
    this->local_message_ = ::CORBA::string_dup (local_message);
  }

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Hello::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
    ACE_DEBUG ((LM_EMERGENCY,
                "Sender_exec_i::configuration_complete\n"));
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    /* Your code here. */
    ACE_DEBUG ((LM_EMERGENCY,
                "Sender_exec_i::ccm_activate\n"));
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
    ACE_DEBUG ((LM_EMERGENCY, "Sender_exec_i::ccm_passivate\n"));
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    /* Your code here. */
    ACE_DEBUG ((LM_EMERGENCY, "Sender_exec_i::ccm_remove\n"));
  }

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Hello_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
