// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Hello_Sender_exec.h"

#include "ace/OS_NS_unistd.h"

namespace CIAO_Hello_Sender_Impl
{
  //============================================================
  // Worker thread for synchronous invocations for MyFoo
  //============================================================
  synch_foo_generator::synch_foo_generator (
     ::Hello::CCM_Sender_Context_ptr context)
  : ciao_context_(::Hello::CCM_Sender_Context::_duplicate (context))
  {
  }

  int synch_foo_generator::svc ()
  {
    ACE_OS::sleep (3);
    ::Hello::MyFoo_var my_foo_ami_ =
         ciao_context_->get_connection_run_my_foo ();

    //run synch calls
    CORBA::String_var out_str;
    for (int i = 0; i < 5; ++i)
      {
        CORBA::Long result = my_foo_ami_->foo ("Do something synchronous",
                                                out_str.out ());
        ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH):\tInvoked synchronous call (FOO)")
                ACE_TEXT(" result <%u> answer <%C>\n"), result, out_str.in ()));

        CORBA::Long answer;
        my_foo_ami_->hello (answer);
        ACE_DEBUG ((LM_DEBUG,
                 ACE_TEXT("Sender (SYNCH):\tInvoked synchronous call ")
                 ACE_TEXT("(HELLO) answer <%u>\n"), answer));

        try
          {
            CORBA::Short rw_attrib = my_foo_ami_->rw_attrib ();
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH):\tInvoked synchronous call ")
                ACE_TEXT("(GET_RW_ATTRIB) answer <%u>\n"), rw_attrib));
          }
        catch (const Hello::InternalError& ex)
          {
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH FOO) :\tExpected Except caught :")
                ACE_TEXT(" <%u> <%C>\n"), ex.id, ex.error_string.in ()));
          }

        try
          {
            my_foo_ami_->rw_attrib (15);
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH):\tInvoked synchronous call ")
                ACE_TEXT("(SET_RW_ATTRIB) to <15>\n")));
          }
        catch (const Hello::InternalError& ex)
          {
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH FOO) :\tExpected Except caught :")
                ACE_TEXT(" <%u> <%C>\n"), ex.id, ex.error_string.in ()));
          }

        try
          {
            CORBA::Short ro_attrib = my_foo_ami_->ro_attrib ();
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH):\tInvoked synchronous call ")
                ACE_TEXT("(GET_RO_ATTRIB) answer <%u>\n"), ro_attrib));
          }
        catch (const Hello::InternalError& ex)
          {
            ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH FOO) :\tExpected Except caught :")
                ACE_TEXT(" <%u> <%C>\n"), ex.id, ex.error_string.in ()));
          }
      }
    try
      {
        CORBA::Long result = my_foo_ami_->foo ("", out_str.out ());
        ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH) :\tInvoked synchronous call result ")
                ACE_TEXT("<%u> answer <%C>\n"), result, out_str.in ()));
      }
    catch (const Hello::InternalError& ex)
      {
        ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH FOO) :\tExpected Except caught : ")
                ACE_TEXT("<%u> <%C>\n"), ex.id, ex.error_string.in ()));
      }
    try
      {
        my_foo_ami_->rw_attrib (0);
        ACE_DEBUG ((LM_DEBUG,
            ACE_TEXT("Sender (SYNCH) :\tInvoked synchronous call rw_attrib\n")));
      }
    catch (const Hello::InternalError& ex)
      {
        ACE_DEBUG ((LM_DEBUG,
                ACE_TEXT("Sender (SYNCH RW_ATTRIB) :\tExpected Except caught :")
                ACE_TEXT(" <%u> <%C>\n"), ex.id, ex.error_string.in ()));
      }
    catch (const CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Caught unexpected except:");
      }
    return 0;
  }

  //============================================================
  // Component Executor Implementation Class: Sender_exec_i
  //============================================================
  Sender_exec_i::Sender_exec_i (void) :
    synch_foo_gen_ (0)
  {
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes.

  // Port operations.
  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
     ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Hello::CCM_Sender_Context::_narrow (ctx);
    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    this->synch_foo_gen_ =
       new synch_foo_generator (this->ciao_context_.in());
    this->synch_foo_gen_->activate (THR_NEW_LWP | THR_JOINABLE, 1);
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    delete this->synch_foo_gen_;
    this->synch_foo_gen_ = 0;
  }

  extern "C" HELLO_SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Hello_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
