// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.2
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "UL_ResetTopic_Sender_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

namespace CIAO_UL_ResetTopic_Sender_Impl
{

  /**
   * Timeout_Handler
   */

  Timeout_Handler::Timeout_Handler (Sender_exec_i &callback)
    : callback_ (callback)
  {
  }

  int
  Timeout_Handler::handle_timeout (const ACE_Time_Value &, const void *)
  {
    // Notify the subscribers
    this->callback_.start_event_test ();
    return 0;
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
    : iterations_ (0)
    , keys_ (0)
    , to_handler_ (0)
    , topic_name_ ("TopicI")
    , old_topic_name_ ("TopicI")
    {
     ACE_NEW_THROW_EX (this->to_handler_,
                       Timeout_Handler (*this),
                       ::CORBA::INTERNAL ());
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
    delete this->to_handler_;
  }

  // Supported operations and attributes.
  ACE_Reactor*
  Sender_exec_i::reactor (void)
  {
    ACE_Reactor* reactor = 0;
    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        ::CORBA::ORB_var orb = ccm_object->_get_orb ();
        if (! ::CORBA::is_nil (orb.in ()))
          {
            reactor = orb->orb_core ()->reactor ();
          }
      }
    if (reactor == 0)
      {
        throw ::CORBA::INTERNAL ();
      }
    return reactor;
  }

  void Sender_exec_i::create_samples (void)
  {
    ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, _guard,
                      this->keys_lock_);

    for (CORBA::UShort i = 1; i < this->keys_ + 1; ++i)
      {
        char key[7];
        UL_ResetTopicTest *new_key = new UL_ResetTopicTest;
        ACE_OS::sprintf (key, "KEY_%d", i);
        new_key->key = CORBA::string_dup(key);
        new_key->iteration = 0;
        this->tests_[key] = new_key;

        ::UL_ResetTopic::UL_ResetTopicTestConnector::Updater_var updater =
          this->ciao_context_->get_connection_info_update_data();

        updater->create_one (*new_key);
        ACE_DEBUG ((LM_DEBUG, "Sender_exec_i::create_samples - "
                  "Sample <%C> created\n",
                  key));
      }
    this->last_key_ = this->tests_.begin ();
  }

  void Sender_exec_i::set_new_topic (const char * topic_name)
  {
    ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, guard, this->topic_name_lock_);

    this->old_topic_name_ = this->topic_name_;
    this->topic_name_ = topic_name;
    ACE_DEBUG ((LM_DEBUG, "Sender_exec_i::set_new_topic - "
              "New topic name set <%C>\n",
              topic_name));
  }

  void
  Sender_exec_i::set_topic_name_updater (const char * topic_name)
  {
    try
      {
        if (ACE_OS::strcmp (topic_name, this->old_topic_name_.c_str()) != 0)
          {
            ACE_DEBUG ((LM_DEBUG, "Sender_exec_i::set_topic_name_updater - "
                      "Setting topic to <%C>\n",
                      topic_name));
            this->old_topic_name_ = topic_name;
            ::UL_ResetTopic::UL_ResetTopicTestConnector:: Updater_var updater =
              this->ciao_context_->get_connection_info_update_data ();
            if (::CORBA::is_nil (updater.in ()))
              {
                ACE_ERROR ((LM_ERROR, "ERROR: Sender_exec_i::set_topic_name_updater - "
                                      "Unable to get updater interface\n"));
                throw ::CORBA::INTERNAL ();
              }
            ::CORBA::Object_var cmp = updater->_get_component ();
            if (::CORBA::is_nil (cmp.in ()))
              {
                ACE_ERROR ((LM_ERROR, "ERROR: Sender_exec_i::set_topic_name_updater - "
                                      "Unable to get component interface\n"));
                throw ::CORBA::INTERNAL ();
              }
            ::UL_ResetTopic::UL_ResetTopicTestConnector::CCM_DDS_State_var conn =
              ::UL_ResetTopic::UL_ResetTopicTestConnector::CCM_DDS_State::_narrow (cmp.in ());
            if (::CORBA::is_nil (conn.in ()))
              {
                ACE_ERROR ((LM_ERROR, "ERROR: Sender_exec_i::set_topic_name_updater - "
                                      "Unable to narrow connector interface\n"));
                throw ::CORBA::INTERNAL ();
              }
            {
              ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, guard, this->topic_name_lock_);
              conn->topic_name (topic_name);
            }
            this->create_samples ();
          }
      }
    catch (const ::CCM_DDS::NonChangeable &)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: Sender_exec_i::set_topic_name_writer - "
                    "Caught NonChangeable exception.\n"));
      }
  }

  void
  Sender_exec_i::start_event_test (void)
  {
    // Set the topic name on the connector first. Therefor we need to
    // get to the connector first.
    ACE_DEBUG ((LM_DEBUG, "Sender_exec_i::start_event_test - Start\n"));
    try
      {
        if (this->last_key_ != this->tests_.end ())
          {
            try
              {
                this->set_topic_name_updater (this->topic_name_.c_str ());
                ::UL_ResetTopic::UL_ResetTopicTestConnector:: Updater_var updater =
                  this->ciao_context_->get_connection_info_update_data ();

                {
                  ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, guard, this->keys_lock_)
                  ++this->last_key_->second->iteration;
                  updater->update_one (this->last_key_->second, ::DDS::HANDLE_NIL);

                  ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Updated key <%C> with <%d>\n"),
                          this->last_key_->first.c_str (),
                          this->last_key_->second->iteration));
                }
              }
            catch (const CCM_DDS::InternalError& )
              {
                ACE_ERROR ((LM_ERROR, "ERROR: Internal Error while writing KeyedTest info for <%C>.\n",
                            this->last_key_->first.c_str ()));
              }
            {
              ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, guard, this->keys_lock_)
              ++this->last_key_;
            }
          }
        else
          {
            // Onto the next iteration
            {
              ACE_GUARD (TAO_SYNCH_RECURSIVE_MUTEX, guard, this->keys_lock_)
              this->last_key_ = this->tests_.begin ();
              while (this->last_key_ != this->tests_.end ())
                {
                  if (this->last_key_->second->iteration == this->iterations_)
                    {
                      ++this->last_key_;
                    }
                  else
                    {
                      break;
                    }
                }
            }
          }
      }
    catch (const ::CORBA::Exception & ex)
      {
        ex._tao_print_exception("ERROR:");
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR, "Sender_exec_i::start_event_test - "
                    "ERROR: Unexpected and unknown exception caught.\n"));
      }
  }

  // Component attributes and port operations.

  ::CORBA::UShort
  Sender_exec_i::iterations (void)
  {
    return this->iterations_;
  }

  void
  Sender_exec_i::iterations (
    const ::CORBA::UShort iterations)
  {
    this->iterations_ = iterations;
  }

  ::CORBA::UShort
  Sender_exec_i::keys (void)
  {
    return this->keys_;
  }

  void
  Sender_exec_i::keys (
    const ::CORBA::UShort keys)
  {
    this->keys_ = keys;
  }

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::UL_ResetTopic::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    this->create_samples ();

    if (this->reactor ()->schedule_timer (
                this->to_handler_,
                0,
                ACE_Time_Value (2, 0),
                ACE_Time_Value (0, 500000)) == -1)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Sender_exec_i::start : ")
                              ACE_TEXT ("Error scheduling timer")));
      }
  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    this->reactor()->cancel_timer(this->to_handler_);
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    /* Your code here. */
  }

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_UL_ResetTopic_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
