// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "ReadGet_Test_Receiver_exec.h"
#include "tao/ORB_Core.h"
#include "ace/Reactor.h"

#include "dds4ccm/impl/dds4ccm_conf.h"

#define QUERY_GETTER_PORT "( (iteration > %0) AND (iteration < %1) )"
#define QUERY_READER_PORT "( (iteration < %0) OR (iteration > %1) )"

// initial values set in deploymentplan as well.
// Need to be the same
#define ITER1_VALUE1 "2"
#define ITER1_VALUE2 "5"

#define ITER2_VALUE1 "22"
#define ITER2_VALUE2 "34"

// Samples received on the getter port:
// 2 during the first run.
// 12 during the second run
// Beware that the last key (key no 5) is
// not read by the getter since this one is
// already read during check_last
// (see constructor Receiver_exec_i).
#define SAMPLES_PER_KEY_GETTER (2 + 11)

// Samples received on the Reader port depend on the
// number of iterations send. The sender informs the
// Receiver about this number by invoking set_reader_properties.
// The number of expected samples on the receiver port are set
// when the iterations are set (see Receiver_exec_i::iterations).
// Besides this, this test also reads on the reader port. This'll
// result in the same amount of samples of the read on the getter
// port.

namespace CIAO_ReadGet_Test_Receiver_Impl
{
  /**
   * read_action_Generator
   */

  read_action_Generator::read_action_Generator (Receiver_exec_i &callback,
                                                int run)
    : callback_ (callback),
      run_ (run)
  {
  }

  read_action_Generator::~read_action_Generator ()
  {
  }

  int
  read_action_Generator::handle_timeout (const ACE_Time_Value &, const void *)
  {
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Checking if last sample ")
                          ACE_TEXT ("is available in DDS...\n")));
    if (this->run_ == 1 || this->callback_.check_last ())
      {
        this->callback_.run (this->run_);
      }
    return 0;
  }

  /**
   * Facet Executor Implementation Class: get_port_status_exec_i
   */

  get_port_status_exec_i::get_port_status_exec_i (
        ::ReadGet_Test::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::ReadGet_Test::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  get_port_status_exec_i::~get_port_status_exec_i (void)
  {
  }

  // Operations from ::CCM_DDS::PortStatusListener

  void
  get_port_status_exec_i::on_requested_deadline_missed (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::RequestedDeadlineMissedStatus & /* status */)
  {
    /* Your code here. */
  }

  void
  get_port_status_exec_i::on_sample_lost (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::SampleLostStatus & /* status */)
  {
    /* Your code here. */
  }

  /**
   * Facet Executor Implementation Class: read_port_status_exec_i
   */

  read_port_status_exec_i::read_port_status_exec_i (
        ::ReadGet_Test::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::ReadGet_Test::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  read_port_status_exec_i::~read_port_status_exec_i (void)
  {
  }

  // Operations from ::CCM_DDS::PortStatusListener

  void
  read_port_status_exec_i::on_requested_deadline_missed (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::RequestedDeadlineMissedStatus & /* status */)
  {
    /* Your code here. */
  }

  void
  read_port_status_exec_i::on_sample_lost (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::SampleLostStatus & /* status */)
  {
    /* Your code here. */
  }

  /**
   * Facet Executor Implementation Class: reader_start_exec_i
   */

  reader_start_exec_i::reader_start_exec_i (
        ::ReadGet_Test::CCM_Receiver_Context_ptr ctx,
        Receiver_exec_i & callback)
    : ciao_context_ (
        ::ReadGet_Test::CCM_Receiver_Context::_duplicate (ctx))
      , callback_ (callback)
  {
  }

  reader_start_exec_i::~reader_start_exec_i (void)
  {
  }

  // Operations from ::ReadGetStarter

  void
  reader_start_exec_i::set_reader_properties (::CORBA::UShort nr_keys,
  ::CORBA::UShort nr_iterations)
  {
    this->callback_.keys (nr_keys);
    this->callback_.iterations (nr_iterations);
  }

  void
  reader_start_exec_i::start_read (::CORBA::UShort run)
  {
    this->callback_.start_read (run);
  }

  /**
   * Component Executor Implementation Class: Receiver_exec_i
   */

  Receiver_exec_i::Receiver_exec_i (void)
    : iterations_ (20),
      keys_ (5),
      has_run_ (false),
      current_iter_value1_ (ACE_OS::atoi (ITER1_VALUE1)),
      current_iter_value2_ (ACE_OS::atoi (ITER1_VALUE2)),
      ticker_ (0),
      samples_expected_reader_ (0),
      samples_received_reader_ (0),
      samples_expected_getter_ (0),
      samples_received_getter_ (0)
  {
  }

  Receiver_exec_i::~Receiver_exec_i (void)
  {
    delete this->ticker_;
  }

  // Supported operations and attributes.
  ACE_Reactor*
  Receiver_exec_i::reactor (void)
  {
    ACE_Reactor* reactor = 0;
    ::CORBA::Object_var ccm_object =
      this->ciao_context_->get_CCM_object();
    if (! ::CORBA::is_nil (ccm_object.in ()))
      {
        ::CORBA::ORB_var orb = ccm_object->_get_orb ();
        if (! ::CORBA::is_nil (orb.in ()))
          {
            reactor = orb->orb_core ()->reactor ();
          }
      }
    if (reactor == 0)
      {
        throw ::CORBA::INTERNAL ();
      }
    return reactor;
  }

  bool
  Receiver_exec_i::check_last ()
  {
    bool retvalue = false;
    try
      {
        ::ReadGet_Test::QueryConditionTestConnector::Reader_var get_reader =
          this->ciao_context_->get_connection_get_port_data ();
        if (::CORBA::is_nil (get_reader.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_last - ")
                                  ACE_TEXT ("Reader of DDS_Get is nil.\n")));
            return false;
          }
        QueryConditionTest queryfiltertest_info;
        ::CCM_DDS::ReadInfo readinfo;
        char key[10];
        ACE_OS::sprintf (key, "KEY_%d", this->keys_);
        queryfiltertest_info.symbol = CORBA::string_dup (key);
        get_reader->read_one_last (
                queryfiltertest_info,
                readinfo,
                ::DDS::HANDLE_NIL);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::check_last - ")
                              ACE_TEXT ("last iteration <%d> - <%d>\n"),
                              queryfiltertest_info.iteration,
                              this->current_iter_value2_ - 1));
        retvalue = queryfiltertest_info.iteration >= this->current_iter_value2_ - 1;
      }
    catch (const ::CCM_DDS::InternalError &)
      {
        retvalue = false;
      }
    catch (const ::CCM_DDS::NonExistent &)
      {
        retvalue = false;
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR, "Receiver_exec_i::check_last: "
                              "ERROR: Unexpected exception caught\n"));
        retvalue = false;
      }
    return retvalue;
  }

  // Supported operations and attributes.
  void
  Receiver_exec_i::check_iter_on_reader_port (const QueryConditionTest & sample)
  {
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("READ ALL ON READER PORT : ")
        ACE_TEXT ("sample received for <%C>: iteration <%u>\n"),
        sample.symbol.in (),
        sample.iteration));
    if (sample.iteration > this->current_iter_value1_ &&
        sample.iteration < this->current_iter_value2_ &&
        sample.iteration > 20) //don't count the first run...
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: READ ALL ON READER PORT : ")
                              ACE_TEXT ("Didn't expect samples between ")
                              ACE_TEXT ("%d and %d\n"),
                              this->current_iter_value1_,
                              this->current_iter_value2_));
      }
  }

  void
  Receiver_exec_i::check_iter_on_getter_port (const QueryConditionTest & sample,
                                              const char * test)
  {
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("%C ALL ON GETTER PORT : ")
        ACE_TEXT ("sample received for <%C>: iteration <%u>\n"),
        test,
        sample.symbol.in (),
        sample.iteration));
    if (sample.iteration <= ACE_OS::atoi (ITER1_VALUE1))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: %C ALL ON GETTER PORT : ")
                              ACE_TEXT ("Didn't expect samples with iterations ")
                              ACE_TEXT ("<= %d\n"),
                              test,
                              this->current_iter_value1_));
      }
    if (sample.iteration > this->current_iter_value2_)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: %C ALL ON GETTER PORT : ")
                              ACE_TEXT ("Didn't expect samples with iterations ")
                              ACE_TEXT ("> %d\n"),
                              test,
                              this->current_iter_value2_));
      }
  }

  void
  Receiver_exec_i::read_all_on_reader_port (void)
  {
    ::ReadGet_Test::QueryConditionTestConnector::Reader_var read_reader =
      this->ciao_context_->get_connection_read_port_data ();

    if (::CORBA::is_nil (read_reader))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Receiver_exec_i::read_all_on_reader_port - ")
                              ACE_TEXT ("ERROR: No Reader on Reader port\n")));
        return;
      }
    QueryConditionTestSeq queryfiltertest_info_seq;
    ::CCM_DDS::ReadInfoSeq readinfo_seq;
    read_reader->read_all (queryfiltertest_info_seq, readinfo_seq);
    if (queryfiltertest_info_seq.length () == 0)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR : Receiver_exec_i::read_all_on_reader_port : ")
                              ACE_TEXT ("No samples available in Reader!\n")));
      }
    for (CORBA::ULong it = 0; it < queryfiltertest_info_seq.length (); ++it)
      {
        this->check_iter_on_reader_port (queryfiltertest_info_seq[it]);
      }
    this->samples_received_reader_ += queryfiltertest_info_seq.length ();
  }

  void
  Receiver_exec_i::read_all_on_getter_port (void)
  {
    ::ReadGet_Test::QueryConditionTestConnector::Reader_var get_reader =
      this->ciao_context_->get_connection_get_port_data ();

    if (::CORBA::is_nil (get_reader))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::read_all_on_getter_port - ")
                              ACE_TEXT ("No Reader on Getter port\n")));
        return;
      }
    QueryConditionTestSeq queryfiltertest_info_seq;
    ::CCM_DDS::ReadInfoSeq readinfo_seq;
    get_reader->read_all (queryfiltertest_info_seq, readinfo_seq);
    if (queryfiltertest_info_seq.length () == 0)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR : Receiver_exec_i::read_all_on_getter_port : ")
                              ACE_TEXT ("No samples available in Reader!\n")));
      }
    for (CORBA::ULong it = 0; it < queryfiltertest_info_seq.length (); ++it)
      {
        this->check_iter_on_getter_port (queryfiltertest_info_seq[it], "READ");
      }
    this->samples_received_reader_ += queryfiltertest_info_seq.length ();
  }

  void
  Receiver_exec_i::get_all_on_getter_port (void)
  {
    ::ReadGet_Test::QueryConditionTestConnector::Getter_var get_getter =
      this->ciao_context_->get_connection_get_port_fresh_data ();

    if (::CORBA::is_nil (get_getter))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::get_all_on_getter_port - ")
                              ACE_TEXT ("No Getter on Getter port\n")));
        return;
      }
    // Set time_out on getter
    DDS::Duration_t to;
    to.sec = 5;
    to.nanosec = 0;
    get_getter->time_out (to);

    QueryConditionTest_var qf_info;
    ::CCM_DDS::ReadInfo readinfo;
    CORBA::Boolean result = get_getter->get_one (qf_info.out (), readinfo);
    if (result)
      {
        if (ACE_OS::strlen (qf_info->symbol.in ()) == 0)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::get_all_on_getter_port - ")
                                  ACE_TEXT ("Name of key seems to be empty-> bailing out\n")));
            return;
          }
        this->check_iter_on_getter_port (*qf_info, "GET");
        ++this->samples_received_getter_;
      }
    else
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::get_all_on_getter_port - ")
                              ACE_TEXT ("time out when retrieving ")
                              ACE_TEXT ("first sample.\n")));
      }
    while (result)
      {
        result = get_getter->get_one (qf_info.out (), readinfo);
        if (result)
          {
            this->check_iter_on_getter_port (*qf_info, "GET");
            ++this->samples_received_getter_;
          }
      }
  }

  void
  Receiver_exec_i::test_all ()
  {
    const char * test = "GET ALL";
    try
      {
        get_all_on_getter_port ();
        ACE_DEBUG ((LM_DEBUG, "=================================="
                              "==================================\n"));

        test = "READ ALL GETTER";
        read_all_on_getter_port ();
        ACE_DEBUG ((LM_DEBUG, "=================================="
                              "==================================\n"));

        test = "READ ALL READER";
        read_all_on_reader_port ();
        ACE_DEBUG ((LM_DEBUG, "=================================="
                              "==================================\n"));
      }
    catch (const CCM_DDS::NonExistent& ex)
      {
        for (CORBA::ULong i = 0; i < ex.indexes.length (); ++i)
          {
            ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("ERROR %C: ")
                  ACE_TEXT ("caught expected exception: index <%u>\n"),
                  test,
                  ex.indexes[i]));
          }
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: %C: ")
              ACE_TEXT ("caught InternalError exception: retval <%u>\n"),
              test,
              ex.error_code));
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception (test);
        ACE_ERROR ((LM_ERROR,
          ACE_TEXT ("ERROR: Receiver_exec_i::test_all : Exception caught\n")));
      }
  }

  void
  Receiver_exec_i::check_filter ()
  {
    this->check_filter_getter ();
    this->check_filter_reader ();
  }

  void
  Receiver_exec_i::check_filter_getter (void)
  {
    ::CCM_DDS::QueryFilter_var filter;
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::check_filter <GETTER> - ")
                          ACE_TEXT ("checking filter\n")));

    try
      {
        ::ReadGet_Test::QueryConditionTestConnector::Getter_var get_getter =
          this->ciao_context_->get_connection_get_port_fresh_data ();
        if (::CORBA::is_nil (get_getter.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Unable to get getter interface\n")));
            throw ::CCM_DDS::InternalError ();
          }
        CORBA::Object_var cmp = get_getter->_get_component ();
        if (::CORBA::is_nil (cmp.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Unable to get component interface\n")));
            throw ::CCM_DDS::InternalError ();
          }
        ::ReadGet_Test::QueryConditionTestConnector::CCM_DDS_State_var conn =
          ::ReadGet_Test::QueryConditionTestConnector::CCM_DDS_State::_narrow (cmp.in ());
        if (::CORBA::is_nil (conn.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Unable to narrow connector interface\n")));
            throw ::CCM_DDS::InternalError ();
          }

        filter = conn->pull_observer_filter ();
        if (!filter)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Filter is nil\n")));
            return;
          }
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("caught InternalError exception: retval <%u>\n"),
                              ex.error_code));
        return;
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Receiver_exec_i::check_filter: ");
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("Exception caught\n")));
        return;
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("caught unknown exception\n")));
        return;
      }

    //check query
    bool error = false;
    ::CORBA::String_var expression = filter->expression.in ();
    if (ACE_OS::strcmp (expression.in (), QUERY_GETTER_PORT) != 0)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("Unexpected query when retrieving filter: ")
                              ACE_TEXT ("expected <%C> - received <%C>\n"),
                              QUERY_GETTER_PORT, expression.in ()));
        error = true;
      }
    //check current parameters.
    if (filter->parameters.length () != 2)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("Unexpected number of parameters: ")
                              ACE_TEXT ("expected <%d> - received <%d>\n"),
                              2, filter->parameters.length ()));
        error = true;
      }

    if (filter->parameters.length () >= 1)
      {
        CORBA::String_var param = ::CORBA::string_dup (filter->parameters[0].in ());
        if (ACE_OS::atoi (param.in ()) != this->current_iter_value1_)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Unexpected param value: ")
                                  ACE_TEXT ("expected <%d> - received <%C>\n"),
                                  this->current_iter_value1_,
                                  param.in ()));
            error = true;
          }
      }
    if (filter->parameters.length () >= 2)
      {
        CORBA::String_var param = ::CORBA::string_dup (filter->parameters[1].in ());
        if (ACE_OS::atoi (param.in ()) != this->current_iter_value2_)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <GETTER> - ")
                                  ACE_TEXT ("Unexpected param value: ")
                                  ACE_TEXT ("expected <%d> - received <%C>\n"),
                                  this->current_iter_value2_,
                                  param.in ()));
            error = true;
          }
      }
    if (!error)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::check_filter <GETTER> - ")
                              ACE_TEXT ("Passed check_filter test.\n")));
      }
  }

  void
  Receiver_exec_i::check_filter_reader (void)
  {
    ::CCM_DDS::QueryFilter_var filter;
    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::check_filter <READER> - ")
                          ACE_TEXT ("checking filter\n")));

    try
      {
        ::ReadGet_Test::QueryConditionTestConnector::Reader_var reader =
          this->ciao_context_->get_connection_read_port_data ();
        if (::CORBA::is_nil (reader.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Unable to get getter interface\n")));
            throw ::CCM_DDS::InternalError ();
          }
        CORBA::Object_var cmp = reader->_get_component ();
        if (::CORBA::is_nil (cmp.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Unable to get component interface\n")));
            throw ::CCM_DDS::InternalError ();
          }
        ::ReadGet_Test::QueryConditionTestConnector::CCM_DDS_State_var conn =
          ::ReadGet_Test::QueryConditionTestConnector::CCM_DDS_State::_narrow (cmp.in ());
        if (::CORBA::is_nil (conn.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Unable to narrow connector interface\n")));
            throw ::CCM_DDS::InternalError ();
          }

        filter = conn->passive_observer_filter ();
        if (!filter)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Filter is nil\n")));
            return;
          }
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("caught InternalError exception: retval <%u>\n"),
                              ex.error_code));
        return;
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Receiver_exec_i::check_filter: ");
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("Exception caught\n")));
        return;
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("caught unknown exception\n")));
        return;
      }

    //check query
    bool error = false;
    ::CORBA::String_var expression = ::CORBA::string_dup (filter->expression.in  ());
    if (ACE_OS::strcmp (expression.in (), QUERY_READER_PORT) != 0)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("Unexpected query when retrieving filter: ")
                              ACE_TEXT ("expected <%C> - received <%C>\n"),
                              QUERY_READER_PORT, expression.in ()));
        error = true;
      }
    //check current parameters.
    if (filter->parameters.length () != 2)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("Unexpected number of parameters: ")
                              ACE_TEXT ("expected <%d> - received <%d>\n"),
                              2, filter->parameters.length ()));
        error = true;
      }

    if (filter->parameters.length () >= 1)
      {
        CORBA::String_var param = ::CORBA::string_dup (filter->parameters[0].in ());
        if (ACE_OS::atoi (param.in ()) != this->current_iter_value1_)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Unexpected param value: ")
                                  ACE_TEXT ("expected <%d> - received <%C>\n"),
                                  this->current_iter_value1_,
                                  param.in ()));
            error = true;
          }
      }
    if (filter->parameters.length () >= 2)
      {
        CORBA::String_var param = ::CORBA::string_dup (filter->parameters[1].in ());
        if (ACE_OS::atoi (param.in ()) != this->current_iter_value2_)
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::check_filter <READER> - ")
                                  ACE_TEXT ("Unexpected param value: ")
                                  ACE_TEXT ("expected <%d> - received <%C>\n"),
                                  this->current_iter_value2_,
                                  param.in ()));
            error = true;
          }
      }
    if (!error)
      {
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::check_filter <READER> - ")
                              ACE_TEXT ("Passed check_filter test.\n")));
      }
  }

  void
  Receiver_exec_i::test_set_query_parameters ()
  {
    try
      {
        ::CCM_DDS::ContentFilterSetting_var get_filter_setting =
          this->ciao_context_->get_connection_get_port_filter_config ();
        if (::CORBA::is_nil (get_filter_setting.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::test_set_query_parameters - ")
                                  ACE_TEXT ("Filter config interface for Getter port is nil.\n")));
            throw ::CCM_DDS::InternalError ();
          }
        ::CCM_DDS::ContentFilterSetting_var read_filter_setting =
          this->ciao_context_->get_connection_read_port_filter_config ();
        if (::CORBA::is_nil (read_filter_setting.in ()))
          {
            ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::test_set_query_parameters - ")
                                  ACE_TEXT ("Filter config interface for Reader port is nil.\n")));
            throw ::CCM_DDS::InternalError ();
          }

        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::test_set_query_parameters: Set parameters\n")));
        ::DDS::StringSeq parameters;
        parameters.length (2);
        parameters[0] = ::CORBA::string_dup (ITER2_VALUE1);
        parameters[1] = ::CORBA::string_dup (ITER2_VALUE2);
        get_filter_setting->set_filter_parameters (parameters);
        read_filter_setting->set_filter_parameters (parameters);

        this->current_iter_value1_ = ACE_OS::atoi (ITER2_VALUE1);
        this->current_iter_value2_ = ACE_OS::atoi (ITER2_VALUE2);
        ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("DONE Receiver_exec_i::test_set_query_parameters\n")));
      }
    catch (const CCM_DDS::InternalError& ex)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::test_set_query_parameters - ")
                              ACE_TEXT ("caught InternalError exception: retval <%u>\n"),
                              ex.error_code));
        return;
      }
    catch (const ::CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Receiver_exec_i::test_set_query_parameters: ");
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::test_set_query_parameters - ")
                              ACE_TEXT ("Exception caught\n")));
        return;
      }
    catch (...)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::test_set_query_parameters - ")
                              ACE_TEXT ("caught unknown exception\n")));
        return;
      }
  }

  void
  Receiver_exec_i::start_read (CORBA::UShort run)
  {
    ACE_NEW_THROW_EX (this->ticker_,
                      read_action_Generator (*this, run),
                      ::CORBA::INTERNAL ());

    if (this->reactor ()->schedule_timer (this->ticker_,
                                          0,
                                          ACE_Time_Value(1, 0),
                                          ACE_Time_Value(1, 0)) == -1)
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("Unable to schedule Timer\n")));
      }
  }

  void
  Receiver_exec_i::run (CORBA::UShort run)
  {
    if (this->ticker_)
      {
        this->reactor ()->cancel_timer (this->ticker_);
        delete this->ticker_;
        this->ticker_ = 0;
      }

    ReadGetRestarter_var restarter = this->ciao_context_->get_connection_writer_restart ();
    if (::CORBA::is_nil (restarter.in ()))
      {
        ACE_ERROR ((LM_ERROR, ACE_TEXT ("ERROR: Receiver_exec_i::run - ")
                              ACE_TEXT ("Unable to start run since restarter ")
                              ACE_TEXT ("is nil.\n")));
        return;
      }

    this->has_run_ = true;

    ACE_DEBUG ((LM_DEBUG, ACE_TEXT ("Receiver_exec_i::run - ")
                          ACE_TEXT ("Starting run number <%d>\n"),
                          run));
    switch (run)
    {
      case 1:
        {
          check_filter ();
          restarter->restart_write ();
        }
        break;
      case 2:
        {
          test_all ();
          check_filter ();
          test_set_query_parameters ();
          restarter->restart_write ();
        }
        break;
      case 3:
        {
          test_all ();
          check_filter ();
        }
        break;
    }
  }

  void
  Receiver_exec_i::iterations (::CORBA::UShort iterations)
  {
    this->iterations_ = iterations;
    // during first iteration, 2,3,4 and 5 are filtered out
    // during the second iteration 22-34 are fitered out but the
    // iterations of the first run are also received during the
    // second run
    // The last addition is from the read action on the getter port.
    // During the first run, two samples are received. The second run
    // includes the two samples from the first run and 11 samples (22-34)
    // from the second run.
    this->samples_expected_reader_ =
      ((this->iterations_ - 4) * this->keys_ * 2) +
      ((this->iterations_ - 13) * this->keys_) +
      ((2 + 2 + 11) * this->keys_);
  }

  void
  Receiver_exec_i::keys (::CORBA::UShort keys)
  {
    this->keys_ = keys;
    this->samples_expected_getter_ = (keys_ - 1) * SAMPLES_PER_KEY_GETTER;
  }

  // Component attributes and port operations.

  ::CCM_DDS::CCM_PortStatusListener_ptr
  Receiver_exec_i::get_get_port_status (void)
  {
    if ( ::CORBA::is_nil (this->ciao_get_port_status_.in ()))
      {
        get_port_status_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          get_port_status_exec_i (
            this->ciao_context_.in ()),
            ::CCM_DDS::CCM_PortStatusListener::_nil ());

          this->ciao_get_port_status_ = tmp;
      }

    return
      ::CCM_DDS::CCM_PortStatusListener::_duplicate (
        this->ciao_get_port_status_.in ());
  }

  ::CCM_DDS::CCM_PortStatusListener_ptr
  Receiver_exec_i::get_read_port_status (void)
  {
    if ( ::CORBA::is_nil (this->ciao_read_port_status_.in ()))
      {
        read_port_status_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          read_port_status_exec_i (
            this->ciao_context_.in ()),
            ::CCM_DDS::CCM_PortStatusListener::_nil ());

          this->ciao_read_port_status_ = tmp;
      }

    return
      ::CCM_DDS::CCM_PortStatusListener::_duplicate (
        this->ciao_read_port_status_.in ());
  }

  ::CCM_ReadGetStarter_ptr
  Receiver_exec_i::get_reader_start (void)
  {
    if ( ::CORBA::is_nil (this->ciao_reader_start_.in ()))
      {
        reader_start_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          reader_start_exec_i (
            this->ciao_context_.in (),
            *this),
            ::CCM_ReadGetStarter::_nil ());

          this->ciao_reader_start_ = tmp;
      }

    return
      ::CCM_ReadGetStarter::_duplicate (
        this->ciao_reader_start_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Receiver_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::ReadGet_Test::CCM_Receiver_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Receiver_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_activate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_passivate (void)
  {
    if (this->ticker_)
      {
        this->reactor ()->cancel_timer (this->ticker_);
      }
  }

  void
  Receiver_exec_i::ccm_remove (void)
  {
    if (this->samples_received_reader_ != this->samples_expected_reader_)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: READGET READER: "
                              "Unexpected number of samples received: "
                              "expected <%d> - received <%d>\n",
                              this->samples_expected_reader_,
                              this->samples_received_reader_));
      }
    else
      {
        ACE_DEBUG ((LM_DEBUG, "READGET READER: "
                              "Expected number of samples received: "
                              "expected <%d> - received <%d>\n",
                              this->samples_expected_reader_,
                              this->samples_received_reader_));
      }
    if (this->samples_received_getter_ != this->samples_expected_getter_)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: READGET GETTER: "
                              "Unexpected number of samples received: "
                              "expected <%d> - received <%d>\n",
                              this->samples_expected_getter_,
                              this->samples_received_getter_));
      }
    else
      {
        ACE_DEBUG ((LM_DEBUG, "READGET GETTER: "
                              "Expected number of samples received: "
                              "expected <%d> - received <%d>\n",
                              this->samples_expected_getter_,
                              this->samples_received_getter_));
      }
  }

  extern "C" RECEIVER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_ReadGet_Test_Receiver_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Receiver_exec_i);

    return retval;
  }
}
