// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/
#ifndef CIAO_THROUGHPUT_SENDER_EXEC_1FSOUB_H_
#define CIAO_THROUGHPUT_SENDER_EXEC_1FSOUB_H_

#include /**/ "ace/pre.h"

#include "Throughput_SenderEC.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include /**/ "Sender_exec_export.h"
#include "tao/LocalObject.h"

namespace CIAO_Throughput_Sender_Impl
{
  class Sender_exec_i;

  typedef ACE_Atomic_Op <TAO_SYNCH_MUTEX, CORBA::Boolean > Atomic_Boolean;

  /**
   * WriteTicker
   */

  class WriteTicker :
    public ACE_Event_Handler
  {
  public:
    WriteTicker (Sender_exec_i &callback,
                 Atomic_Boolean &running);
    int handle_timeout (const ACE_Time_Value &, const void *);
  private:
    Sender_exec_i &callback_;
    Atomic_Boolean running_;
  };

  /**
   * Provider Executor Implementation Class: connector_status_exec_i
   */

  class connector_status_exec_i
    : public virtual ::CCM_DDS::CCM_ConnectorStatusListener,
      public virtual ::CORBA::LocalObject
  {
  public:
    connector_status_exec_i (
      ::Throughput::CCM_Sender_Context_ptr ctx,
      int number_of_subscribers,
      Sender_exec_i &callback);
    virtual ~connector_status_exec_i (void);

    //@{
    /** Operations and attributes from CCM_DDS::ConnectorStatusListener. */

    virtual
    void on_inconsistent_topic (::DDS::Topic_ptr the_topic,
    const ::DDS::InconsistentTopicStatus & status);

    virtual
    void on_requested_incompatible_qos (::DDS::DataReader_ptr the_reader,
    const ::DDS::RequestedIncompatibleQosStatus & status);

    virtual
    void on_sample_rejected (::DDS::DataReader_ptr the_reader,
    const ::DDS::SampleRejectedStatus & status);

    virtual
    void on_offered_deadline_missed (::DDS::DataWriter_ptr the_writer,
    const ::DDS::OfferedDeadlineMissedStatus & status);

    virtual
    void on_offered_incompatible_qos (::DDS::DataWriter_ptr the_writer,
    const ::DDS::OfferedIncompatibleQosStatus & status);

    virtual
    void on_unexpected_status (::DDS::Entity_ptr the_entity,
    ::DDS::StatusKind status_kind);
    //@}

  private:
    ::Throughput::CCM_Sender_Context_var ciao_context_;
    int number_of_subscribers_;
    Sender_exec_i &callback_;
    Atomic_Boolean started_;
  };

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  class Sender_exec_i
    : public virtual Sender_Exec,
      public virtual ::CORBA::LocalObject
  {
  public:
    Sender_exec_i (void);
    virtual ~Sender_exec_i (void);

    //@{
    /** Supported operations and attributes. */

    //@}

    //@{
    /** Component attributes and port operations. */

    virtual ::CCM_DDS::CCM_ConnectorStatusListener_ptr
    get_connector_status (void);

    virtual ::CORBA::ULong start_load (void);

    virtual void start_load (::CORBA::ULong start_load);

    virtual ::CORBA::ULong incr_load (void);

    virtual void incr_load (::CORBA::ULong incr_load);

    virtual ::CORBA::ULongLong max_load (void);

    virtual void max_load (::CORBA::ULongLong max_load);

    virtual ::CORBA::UShort recover_time (void);

    virtual void recover_time (::CORBA::UShort recover_time);

    virtual ::CORBA::UShort datalen (void);

    virtual void datalen (::CORBA::UShort datalen);

    virtual ::CORBA::UShort number_of_sub (void);

    virtual void number_of_sub (::CORBA::UShort number_of_sub);
    //@}

    //@{
    /** Operations from Components::SessionComponent. */
    virtual void set_session_context (::Components::SessionContext_ptr ctx);
    virtual void configuration_complete (void);
    virtual void ccm_activate (void);
    virtual void ccm_passivate (void);
    virtual void ccm_remove (void);
    //@}

    //@{
    /** User defined public operations. */
    void write (void);
    void start (void);

    //@}

  private:
    ::Throughput::CCM_Sender_Context_var ciao_context_;

    //@{
    /** Component attributes. */
    ::CCM_DDS::CCM_ConnectorStatusListener_var ciao_connector_status_;

    ::CORBA::ULong start_load_;

    ::CORBA::ULong incr_load_;

    ::CORBA::ULongLong max_load_;

    ::CORBA::UShort recover_time_;

    ::CORBA::UShort datalen_;

    ::CORBA::UShort number_of_sub_;
    //@}

    //@{
    /** User defined members. */
    ::Throughput::ThroughputTestConn::Writer_var writer_;
    ::Throughput::ThroughputCommandConn::Writer_var cmd_writer_;

    WriteTicker *ticker_;

    ACE_UINT64 duration_run_;
    ::CORBA::ULongLong number_of_msg_;
    ::CORBA::ULongLong load_;
    ::CORBA::UShort overhead_size_;

    ThroughputTest test_topic_;
    ThroughputCommand test_topic_cmd_;
    ::CORBA::Octet* buffer_;

    Atomic_Boolean running_;

    //@}

    //@{
    /** User defined private operations. */
    void stop (void);

    //@}

    /// Get the ACE_Reactor
    ACE_Reactor* reactor (void);
  };

  extern "C" SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Throughput_Sender_Impl (void);
}

#include /**/ "ace/post.h"

#endif /* ifndef */
