// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/
#ifndef CIAO_DISTRIBUTOR_EXEC_SBNFU0_H_
#define CIAO_DISTRIBUTOR_EXEC_SBNFU0_H_

#include /**/ "ace/pre.h"

#include "DistributorEC.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include /**/ "Distributor_exec_export.h"
#include "tao/LocalObject.h"

#include <map>

namespace CIAO_Quoter_Distributor_Impl
{
  class Distributor_exec_i;

  /**
  * @class pulse generator
  *
  * @brief An active object used by StockDistributor to perform periodical
  * write action to DDS
  *
  */
  class pulse_Generator : public ACE_Event_Handler
  {
  public:
    pulse_Generator (Distributor_exec_i &callback);

    virtual ~pulse_Generator ();

    virtual int handle_timeout (const ACE_Time_Value &tv,
                                const void *arg);
  private:
    Distributor_exec_i &pulse_callback_;
  };

  /**
   * Provider Executor Implementation Class: info_out_connector_status_exec_i
   */

  class info_out_connector_status_exec_i
    : public virtual ::CCM_DDS::CCM_ConnectorStatusListener,
      public virtual ::CORBA::LocalObject
  {
  public:
    info_out_connector_status_exec_i (
      ::Quoter::CCM_Distributor_Context_ptr ctx);
    virtual ~info_out_connector_status_exec_i (void);

    //@{
    /** Operations and attributes from CCM_DDS::ConnectorStatusListener. */

    virtual
    void on_inconsistent_topic (::DDS::Topic_ptr the_topic,
    const ::DDS::InconsistentTopicStatus & status);

    virtual
    void on_requested_incompatible_qos (::DDS::DataReader_ptr the_reader,
    const ::DDS::RequestedIncompatibleQosStatus & status);

    virtual
    void on_sample_rejected (::DDS::DataReader_ptr the_reader,
    const ::DDS::SampleRejectedStatus & status);

    virtual
    void on_offered_deadline_missed (::DDS::DataWriter_ptr the_writer,
    const ::DDS::OfferedDeadlineMissedStatus & status);

    virtual
    void on_offered_incompatible_qos (::DDS::DataWriter_ptr the_writer,
    const ::DDS::OfferedIncompatibleQosStatus & status);

    virtual
    void on_unexpected_status (::DDS::Entity_ptr the_entity,
    ::DDS::StatusKind status_kind);
    //@}

  private:
    ::Quoter::CCM_Distributor_Context_var ciao_context_;
  };

  /**
   * Component Executor Implementation Class: Distributor_exec_i
   */

  class Distributor_exec_i
    : public virtual Distributor_Exec,
      public virtual ::CORBA::LocalObject
  {
  public:
    Distributor_exec_i (void);
    virtual ~Distributor_exec_i (void);

    //@{
    /** Supported operations and attributes. */

    virtual void add_stock (const char * stock);

    virtual void del_stock (const char * stock);

    virtual void start (void);

    virtual void stop (void);

    //@}

    //@{
    /** Component attributes and port operations. */

    virtual ::CCM_DDS::CCM_ConnectorStatusListener_ptr
    get_info_out_connector_status (void);

    virtual ::CORBA::ULong rate (void);

    virtual void rate (::CORBA::ULong rate);
    //@}

    //@{
    /** Operations from Components::SessionComponent. */
    virtual void set_session_context (::Components::SessionContext_ptr ctx);
    virtual void configuration_complete (void);
    virtual void ccm_activate (void);
    virtual void ccm_passivate (void);
    virtual void ccm_remove (void);
    //@}

    //@{
    /** User defined public operations. */
    void tick (void);

    //@}

  private:
    ::Quoter::CCM_Distributor_Context_var ciao_context_;

    //@{
    /** Component attributes. */
    ::CCM_DDS::CCM_ConnectorStatusListener_var ciao_info_out_connector_status_;

    ::CORBA::ULong rate_;
    //@}

    //@{
    /** User defined members. */
    pulse_Generator * ticker_;

    TAO_SYNCH_MUTEX mutex_;
    typedef std::map<ACE_CString, Quoter::Stock_Info_var> Stock_Table;
    Stock_Table stocks_;

    //@}

    //@{
    /** User defined private operations. */

    //@}

    /// Get the ACE_Reactor
    ACE_Reactor* reactor (void);
  };

  extern "C" DISTRIBUTOR_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Quoter_Distributor_Impl (void);
}

#include /**/ "ace/post.h"

#endif /* ifndef */
