// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "Broker_exec.h"
#include "ace/OS_NS_time.h"

namespace CIAO_Quoter_Broker_Impl
{

  /**
   * Facet Executor Implementation Class: info_out_data_listener_exec_i
   */

  info_out_data_listener_exec_i::info_out_data_listener_exec_i (
        ::Quoter::CCM_Broker_Context_ptr ctx)
    : ciao_context_ (
        ::Quoter::CCM_Broker_Context::_duplicate (ctx))
  {
  }

  info_out_data_listener_exec_i::~info_out_data_listener_exec_i (void)
  {
  }

  // Operations from ::Quoter::Listener

  void
  info_out_data_listener_exec_i::on_one_data (const ::Quoter::Stock_Info & datum,
  const ::CCM_DDS::ReadInfo & /* info */)
  {
    ACE_DEBUG ((LM_DEBUG, "Stock_Info_Listener: received a stock_info for <%C> at %u:%u:%u\n",
            datum.symbol.in (),
            datum.low,
            datum.current,
            datum.high));
  }

  void
  info_out_data_listener_exec_i::on_many_data (const ::Quoter::Stock_InfoSeq & /* data */,
  const ::CCM_DDS::ReadInfoSeq & /* infos */)
  {
    /* Your code here. */
  }

  /**
   * Facet Executor Implementation Class: info_out_status_exec_i
   */

  info_out_status_exec_i::info_out_status_exec_i (
        ::Quoter::CCM_Broker_Context_ptr ctx)
    : ciao_context_ (
        ::Quoter::CCM_Broker_Context::_duplicate (ctx))
  {
  }

  info_out_status_exec_i::~info_out_status_exec_i (void)
  {
  }

  // Operations from ::CCM_DDS::PortStatusListener

  void
  info_out_status_exec_i::on_requested_deadline_missed (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::RequestedDeadlineMissedStatus & /* status */)
  {
    ACE_DEBUG ((LM_DEBUG, "####### deadline missed ######\n"));
  }

  void
  info_out_status_exec_i::on_sample_lost (::DDS::DataReader_ptr /* the_reader */,
  const ::DDS::SampleLostStatus & status)
  {
    ACE_DEBUG ((LM_DEBUG, "####### sample lost ######\n"));
    ACE_DEBUG ((LM_DEBUG, " status.total_count = %d\n", status.total_count));
    ACE_DEBUG ((LM_DEBUG, " status.total_count_change = %d\n", status.total_count_change));
  }

  /**
   * Component Executor Implementation Class: Broker_exec_i
   */

  Broker_exec_i::Broker_exec_i (void)
  {
    ACE_OS::srand (static_cast <u_int> (ACE_OS::time ()));
  }

  Broker_exec_i::~Broker_exec_i (void)
  {
    ACE_DEBUG ((LM_DEBUG, "Broker_exec_i::~Broker_exec_i\n"));
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::Quoter::CCM_Listener_ptr
  Broker_exec_i::get_info_out_data_listener (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_out_data_listener_.in ()))
      {
        info_out_data_listener_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_out_data_listener_exec_i (
            this->ciao_context_.in ()),
            ::Quoter::CCM_Listener::_nil ());

          this->ciao_info_out_data_listener_ = tmp;
      }

    return
      ::Quoter::CCM_Listener::_duplicate (
        this->ciao_info_out_data_listener_.in ());
  }

  ::CCM_DDS::CCM_PortStatusListener_ptr
  Broker_exec_i::get_info_out_status (void)
  {
    if ( ::CORBA::is_nil (this->ciao_info_out_status_.in ()))
      {
        info_out_status_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          info_out_status_exec_i (
            this->ciao_context_.in ()),
            ::CCM_DDS::CCM_PortStatusListener::_nil ());

          this->ciao_info_out_status_ = tmp;
      }

    return
      ::CCM_DDS::CCM_PortStatusListener::_duplicate (
        this->ciao_info_out_status_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Broker_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::Quoter::CCM_Broker_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Broker_exec_i::configuration_complete (void)
  {
    ACE_DEBUG ((LM_DEBUG, ">>> Broker_exec_i::configuration_complete\n"));
  }

  void
  Broker_exec_i::ccm_activate (void)
  {
    ACE_DEBUG ((LM_DEBUG, ">>> Broker_exec_i::ccm_activate\n"));
    ::CCM_DDS::DataListenerControl_var lc =
    this->ciao_context_->get_connection_info_out_data_control ();

    if (::CORBA::is_nil (lc.in ()))
      {
        ACE_DEBUG ((LM_DEBUG, "Error:  Listener control receptacle is null!\n"));
        throw ::CORBA::INTERNAL ();
      }
    lc->mode ( ::CCM_DDS::ONE_BY_ONE);
  }

  void
  Broker_exec_i::ccm_passivate (void)
  {
    ACE_DEBUG ((LM_DEBUG, ">>> Broker_exec_i::ccm_passivate\n"));
  }

  void
  Broker_exec_i::ccm_remove (void)
  {
    ACE_DEBUG ((LM_DEBUG, ">>> Broker_exec_i::ccm_remove\n"));
  }

  extern "C" BROKER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_Quoter_Broker_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Broker_exec_i);

    return retval;
  }
}
