// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "NoReplyH_Receiver_exec.h"
#include "ace/OS_NS_unistd.h"

namespace CIAO_NoReplyH_Receiver_Impl
{

  /**
   * Facet Executor Implementation Class: do_my_foo_exec_i
   */

  do_my_foo_exec_i::do_my_foo_exec_i (
        ::NoReplyH::CCM_Receiver_Context_ptr ctx,
         Atomic_UShort &calls)
    : ciao_context_ (
        ::NoReplyH::CCM_Receiver_Context::_duplicate (ctx)),
      attrib_ (0),
      calls_(calls)
  {
  }

  do_my_foo_exec_i::~do_my_foo_exec_i (void)
  {
  }

  // Operations from ::NoReplyH::MyFoo

  ::CORBA::Long
  do_my_foo_exec_i::foo (const char * in_str,
  ::CORBA::String_out answer)
  {
    ++this->calls_;
    if (ACE_OS::strlen (in_str) == 0)
      {
        NoReplyH::InternalError ex (42, "Hello world");
        throw ex;
      }
    else
      {
        ACE_OS::sleep (ACE_OS::rand () % 2);
        answer = CORBA::string_dup ("This is my answer : Hi");
        return 1;
      }
  }

  void
  do_my_foo_exec_i::hello (::CORBA::Long_out answer)
  {
    ++this->calls_;
    ACE_OS::sleep (ACE_OS::rand () % 2);
    answer = 4;
 }

  ::CORBA::Short
  do_my_foo_exec_i::rw_attrib (void)
  {
    ++this->calls_;
    ACE_OS::sleep (ACE_OS::rand () % 2);
    return 2;
  }

  void
  do_my_foo_exec_i::rw_attrib (::CORBA::Short rw_attrib)
  {
    ++this->calls_;
    if (rw_attrib == 0)
      {
        NoReplyH::InternalError ex (42, "Hello world");
        throw ex;
      }
    else
      {
        ACE_OS::sleep (ACE_OS::rand () % 2);
      }
  }

  ::CORBA::Short
  do_my_foo_exec_i::ro_attrib (void)
  {
    ++this->calls_;
    return 3;
  }

  /**
   * Component Executor Implementation Class: Receiver_exec_i
   */

  Receiver_exec_i::Receiver_exec_i (void)
  :calls_(0)
  {
  }

  Receiver_exec_i::~Receiver_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::NoReplyH::CCM_MyFoo_ptr
  Receiver_exec_i::get_do_my_foo (void)
  {
    if ( ::CORBA::is_nil (this->ciao_do_my_foo_.in ()))
      {
        do_my_foo_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          do_my_foo_exec_i (
            this->ciao_context_.in (),
            this->calls_),
            ::NoReplyH::CCM_MyFoo::_nil ());

          this->ciao_do_my_foo_ = tmp;
      }

    return
      ::NoReplyH::CCM_MyFoo::_duplicate (
        this->ciao_do_my_foo_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Receiver_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::NoReplyH::CCM_Receiver_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Receiver_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_activate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_remove (void)
  {
    if (this->calls_.value() != 10)
       {
         ACE_ERROR ((LM_ERROR, "ERROR: not received the expected number of"
                               "calls"
                               "Expected: 10, Received: %u.\n",
                               this->calls_.value()));
       }
     else
       {
         ACE_DEBUG ((LM_DEBUG, "OK: Receiver received the expected "
                               "number of calls. "
                               "Expected: 10, Received: %u.\n",
                               this->calls_.value()));
       }
  }

  extern "C" NOREPLYH_RECEIVER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_NoReplyH_Receiver_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Receiver_exec_i);

    return retval;
  }
}
