// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "InterInArgsT_Sender_exec.h"
#include "ace/OS_NS_unistd.h"

namespace CIAO_InterInArgsT_Sender_Impl
{
  CORBA::Short nr_of_excep_received = 0;
  CORBA::UShort update_val = InterInArgsT::update_val;
  CORBA::UShort cmd_synch_ok = 1;
  CORBA::UShort cmd_synch_nok = 2;
  CORBA::UShort cmd_asynch_ok = 3;
  CORBA::UShort cmd_asynch_nok = 4;

  void HandleException (
      long id,
      long expect_id,
      const char* error_string,
      const char* func)
  {
    //expected exception
    if ( id == expect_id)
      {
        ACE_DEBUG ((LM_DEBUG, "Sender: Caught correct exception <%u,"
                              "%C> for %C\n",
                              id, error_string, func));
        ++nr_of_excep_received;
      }
    else
      {
        ACE_ERROR ((LM_ERROR, "ERROR Sender: wrong exception received"
                              " for %C\n", func));
      }
  }
  //============================================================
      // Worker thread for asynchronous invocations for MyFoo
      //============================================================
  asynch_foo_generator::asynch_foo_generator (
    ::InterInArgsT::CCM_Sender_Context_ptr context,
     Atomic_UShort  &nr_of_received)
  : context_(::InterInArgsT::CCM_Sender_Context::_duplicate (context)),
    nr_of_received_(nr_of_received)
  {
  }

  int asynch_foo_generator::svc ()
  {
    ACE_OS::sleep (3);
    ::InterInArgsT::AMI4CCM_MyFoo_var my_foo_ami_  =
       context_->get_connection_sendc_run_my_foo();

    if (CORBA::is_nil (my_foo_ami_))
      {
        ACE_ERROR ((LM_ERROR, "ERROR Sender (ASYNCH) :\tfoo_ami is NIL !\n"));
        return 1;
      }
    else
      {
        ::InterInArgsT::CCM_AMI4CCM_MyFooReplyHandler_var cb =
          new AMI4CCM_MyFooReplyHandler_run_my_foo_i (
          this->nr_of_received_);
        //Invoke Asynchronous calls to test
        my_foo_ami_->sendc_foo ( cb.in(),"Hi", cmd_asynch_ok);
        //this shoukd invoke a exception
        my_foo_ami_->sendc_foo (cb.in(), "", cmd_asynch_nok);
        my_foo_ami_->sendc_var_ins (cb.in(), "Here a double for you.", 1.6);

        InterInArgsT::TestTopic test_topic;
        test_topic.key = "aaa";
        test_topic.x = 10;
        InterInArgsT::TopicString topic_str;
        topic_str.key = "bbb";
        topic_str.x_str = "ccc";
        InterInArgsT::TestArray topic_arr;
        for ( CORBA::UShort i = 0; i < 5; i ++)
          {
            topic_arr[i].key = CORBA::string_dup("ddd");
            for (CORBA::UShort y = 0; y < 5; y ++)
              {
                topic_arr[i].x_array[y] = i * 100 + y ;
              }
          }
        my_foo_ami_->sendc_var_div_ins (cb.in(), test_topic,topic_str,topic_arr);

        InterInArgsT::X_Union topic_union;
        topic_union.x_long(11);
        InterInArgsT::test ttt;
        ttt.x_test = 12;
        ttt.x_teststr = "fff" ;
        InterInArgsT::test_seq seq;
        seq.length(2);
        seq[0] = ttt;

        my_foo_ami_->sendc_var_div2_ins (cb.in(), topic_union, seq);
        InterInArgsT::test_enum in_test;
        in_test = ::InterInArgsT::ONE;
        my_foo_ami_->sendc_enum_in(cb.in(), in_test);
      }
    return 0;
  }

  //============================================================
  // Worker thread for synchronous invocations for MyFoo
  //============================================================
  synch_foo_generator::synch_foo_generator (
   ::InterInArgsT::CCM_Sender_Context_ptr context,
    Atomic_UShort  &nr_of_received)
  : context_(::InterInArgsT::CCM_Sender_Context::_duplicate (context)),
    nr_of_received_(nr_of_received)
  {
  }

  int synch_foo_generator::svc ()
  {
    ::InterInArgsT::MyFoo_var my_foo_ami_ =
         context_->get_connection_run_my_foo ();

    ACE_OS::sleep (3);
    //run some synch calls
    CORBA::String_var out_str;
    try
      {
        CORBA::Long result = my_foo_ami_->foo ("Do something synchronous",
                                                cmd_synch_ok ,
                                                out_str.out ());
        if (result == (update_val + cmd_synch_ok))
          {
            ++this->nr_of_received_;
          }
      }
    catch (const InterInArgsT::InternalError&)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: synch_foo_generator::foo: "
                              "Unexpected exception.\n"));
      }
    try
      {
        my_foo_ami_->foo ("",cmd_synch_nok, out_str);
      }
    catch (const InterInArgsT::InternalError& ex)
      {
          HandleException (ex.id, (update_val + cmd_synch_nok),ex.error_string.in(),
                           "synch foo");
      }
    return 0;
  }

  /**
   * Component Executor Implementation Class: Sender_exec_i
   */

  Sender_exec_i::Sender_exec_i (void)
  : asynch_foo_gen (0),
    synch_foo_gen (0),
    nr_of_received_(0)
  {
  }

  Sender_exec_i::~Sender_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  // Operations from Components::SessionComponent.

  void
  Sender_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::InterInArgsT::CCM_Sender_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Sender_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_activate (void)
  {
    this->asynch_foo_gen =
      new asynch_foo_generator (this->ciao_context_.in (),
                                this->nr_of_received_);
    this->asynch_foo_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);

    this->synch_foo_gen =
       new synch_foo_generator (this->ciao_context_.in(),
                                this->nr_of_received_);
    this->synch_foo_gen->activate (THR_NEW_LWP | THR_JOINABLE, 1);  }

  void
  Sender_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Sender_exec_i::ccm_remove (void)
  {
    if (nr_of_excep_received != 2)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: not received the expected number of"
                              " exceptions"
                              "Expected: 2, Received: %u.\n",
                              nr_of_excep_received));
      }
    if (this->nr_of_received_.value() != 6)
      {
        ACE_ERROR ((LM_ERROR, "ERROR: Sender not received the expected number"
                              " of callbacks and returns  for syn- and "
                              "asynchronous calls. Expected: 6,"
                              " Received: %u.\n",
                              this->nr_of_received_.value()));
      }
    if ((this->nr_of_received_.value() == 6) && (nr_of_excep_received == 2))
      {
        ACE_DEBUG ((LM_DEBUG, "OK: Sender received the expected number of"
                              " callbacks and exceptions for syn- and "
                              "asynchronous calls\n"));
      }
    delete this->asynch_foo_gen;
    this->asynch_foo_gen = 0;
    delete this->synch_foo_gen;
    this->synch_foo_gen = 0;
  }

  AMI4CCM_MyFooReplyHandler_run_my_foo_i::AMI4CCM_MyFooReplyHandler_run_my_foo_i (
      Atomic_UShort &nr_of_received)
  : nr_of_received_(nr_of_received)
  {
  }

  AMI4CCM_MyFooReplyHandler_run_my_foo_i::~AMI4CCM_MyFooReplyHandler_run_my_foo_i (void)
  {
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::foo (
      ::CORBA::Long ami_return_val,
        const char * /*answer*/)
  {
    if ( ami_return_val == ( cmd_asynch_ok + update_val ))
      {
        ++this->nr_of_received_;
      }
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::foo_excep (
      ::CCM_AMI::ExceptionHolder * excep_holder)
  {
    try
      {
        excep_holder->raise_exception ();
      }
    catch (const InterInArgsT::InternalError& ex)
      {
        CIAO_InterInArgsT_Sender_Impl::HandleException (ex.id,
                        (cmd_asynch_nok + update_val),
                         ex.error_string.in(), "asynch foo");
      }
    catch (const CORBA::Exception& ex)
      {
        ex._tao_print_exception ("ERROR: Caught unexpected exception:");
      }
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_ins (
      const char * /*answer*/)
  {
    ++this->nr_of_received_;
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_ins_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_div_ins (const char * /* answer */)
  {
    ++this->nr_of_received_;
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_div_ins_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_div2_ins (const char * /* answer */)
  {
    ++this->nr_of_received_;
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::var_div2_ins_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::enum_in (const char * /* answer */)
  {
    ++this->nr_of_received_;
  }

  void
  AMI4CCM_MyFooReplyHandler_run_my_foo_i::enum_in_excep (
      ::CCM_AMI::ExceptionHolder_ptr excep_holder)
  {
    excep_holder->raise_exception ();
  }

  extern "C" INTERINARGS_T_SENDER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_InterInArgsT_Sender_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Sender_exec_i);

    return retval;
  }
}
