// -*- C++ -*-
// $Id$

/**
 * Code generated by the The ACE ORB (TAO) IDL Compiler v1.8.3
 * TAO and the TAO IDL Compiler have been developed by:
 *       Center for Distributed Object Computing
 *       Washington University
 *       St. Louis, MO
 *       USA
 *       http://www.cs.wustl.edu/~schmidt/doc-center.html
 * and
 *       Distributed Object Computing Laboratory
 *       University of California at Irvine
 *       Irvine, CA
 *       USA
 * and
 *       Institute for Software Integrated Systems
 *       Vanderbilt University
 *       Nashville, TN
 *       USA
 *       http://www.isis.vanderbilt.edu/
 *
 * Information about TAO is available at:
 *     http://www.cs.wustl.edu/~schmidt/TAO.html
 **/

#include "InterInArgsT_Receiver_exec.h"

namespace CIAO_InterInArgsT_Receiver_Impl
{
  CORBA::UShort nr_of_received = 0;
  CORBA::UShort update_val = InterInArgsT::update_val;
  /**
   * Facet Executor Implementation Class: do_my_foo_exec_i
   */

  do_my_foo_exec_i::do_my_foo_exec_i (
        ::InterInArgsT::CCM_Receiver_Context_ptr ctx)
    : ciao_context_ (
        ::InterInArgsT::CCM_Receiver_Context::_duplicate (ctx))
  {
  }

  do_my_foo_exec_i::~do_my_foo_exec_i (void)
  {
  }

  // Operations from ::InterInArgsT::MyFoo

  ::CORBA::Long
  do_my_foo_exec_i::foo (const char * in_str,::CORBA::Long cmd,
      ::CORBA::String_out answer)
  {
    if (ACE_OS::strlen (in_str) == 0)
      {
        InterInArgsT::InternalError ex (cmd + update_val,
                         "foo thrown by receiver");
        throw ex;
      }
    else
      {
        answer = CORBA::string_dup ("This is my answer : Hi");
        ++nr_of_received;
        return (cmd + update_val);
      }
  }

  void
  do_my_foo_exec_i::var_ins (const char * /*in_str*/,
      ::CORBA::String_out answer,
      ::CORBA::Double cmd)
  {
    if ( cmd != 1.6)
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_ins: "
           "received the wrong double, expected 1.6,"
           " received %2.2f\n",
           cmd));
      }
    else
      {
        ++nr_of_received;
      }
    answer = CORBA::string_alloc(20);
    ACE_OS::sprintf(answer,"double was %2.2f",cmd);
  }

  void
  do_my_foo_exec_i::var_div_ins (
      const ::InterInArgsT::TestTopic &test_topic,
      const ::InterInArgsT::TopicString &topic_str,
      const ::InterInArgsT::TestArray topic_arr,
      ::CORBA::String_out answer)
  {
    CORBA::Boolean error = false;
    if ((ACE_OS::strcmp (test_topic.key, "aaa") != 0) || (test_topic.x != 10))
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_div_ins: "
            "received the wrong struct, "
            "expected key 'aaa', x = 10,"
            " received key '%C' , x = %u\n",
            test_topic.key.in(),test_topic.x));
        error = true;
      }
    if ((ACE_OS::strcmp (topic_str.key, "bbb") != 0) ||
        (ACE_OS::strcmp (topic_str.x_str, "ccc") != 0))
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_div_ins: "
            "received the wrong struct, "
            "expected key 'bbb', x = 'ccc',"
            " received key '%C' , x = %C\n",
            topic_str.key.in() ,topic_str.x_str.in()));
        error = true;
      }
    if ((ACE_OS::strcmp (topic_arr[0].key, "ddd") != 0) ||
        (topic_arr[1].x_array[2] != 102))
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_div_ins: "
       "received the wrong struct, "
       "expected key 'ddd', elem 102"
       " received key '%C', elem %u\n",
       topic_arr[0].key.in(),topic_arr[1].x_array[2] ));
        error = true;
      }
    answer = CORBA::string_dup ("This is my answer from var_div_ins");
    if(error == false)
      {
        ++nr_of_received;
      }
  }

  void
  do_my_foo_exec_i::var_div2_ins (const ::InterInArgsT::X_Union &topic_union,
      const ::InterInArgsT::test_seq &seq,
      ::CORBA::String_out answer)
  {
    CORBA::Boolean error = false;
    if (topic_union.x_long() != 11)
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_div2_ins: "
            "received the wrong union, "
            "expected x = 11,"
            " received x = %u\n",
            topic_union.x_long()));
        error = true;
      }
    if ((ACE_OS::strcmp (seq[0].x_teststr, "fff") != 0)||
        ( seq[0].x_test != 12))
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::var_div2_ins: "
            "received the wrong struct, "
            "expected key 'fff', x = 10,"
            " received key '%C' , x = %u\n",
            seq[0].x_teststr.in(),seq[0].x_test));
        error = true;
      }
    answer = CORBA::string_dup ("This is my answer from var_div2_ins");
    if(error == false)
      {
        ++nr_of_received;
      }
  }

  void
  do_my_foo_exec_i::enum_in (::CORBA::String_out answer,
      InterInArgsT::test_enum in_test)
  {
    if ( in_test != InterInArgsT::ONE)
      {
        ACE_ERROR ((LM_ERROR, "MyFoo_exec_i::enum_in: "
            "received the wrong enum value, expected ONE,"
            " received %u\n",
            in_test));
      }
    else
      {
        ++nr_of_received;
      }
    answer = CORBA::string_dup ("This is my answer from enum_in");
  }

  /**
   * Component Executor Implementation Class: Receiver_exec_i
   */

  Receiver_exec_i::Receiver_exec_i (void){
  }

  Receiver_exec_i::~Receiver_exec_i (void)
  {
  }

  // Supported operations and attributes.

  // Component attributes and port operations.

  ::InterInArgsT::CCM_MyFoo_ptr
  Receiver_exec_i::get_do_my_foo (void)
  {
    if ( ::CORBA::is_nil (this->ciao_do_my_foo_.in ()))
      {
        do_my_foo_exec_i *tmp = 0;
        ACE_NEW_RETURN (
          tmp,
          do_my_foo_exec_i (
            this->ciao_context_.in ()),
            ::InterInArgsT::CCM_MyFoo::_nil ());

          this->ciao_do_my_foo_ = tmp;
      }

    return
      ::InterInArgsT::CCM_MyFoo::_duplicate (
        this->ciao_do_my_foo_.in ());
  }

  // Operations from Components::SessionComponent.

  void
  Receiver_exec_i::set_session_context (
    ::Components::SessionContext_ptr ctx)
  {
    this->ciao_context_ =
      ::InterInArgsT::CCM_Receiver_Context::_narrow (ctx);

    if ( ::CORBA::is_nil (this->ciao_context_.in ()))
      {
        throw ::CORBA::INTERNAL ();
      }
  }

  void
  Receiver_exec_i::configuration_complete (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_activate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_passivate (void)
  {
    /* Your code here. */
  }

  void
  Receiver_exec_i::ccm_remove (void)
  {
    if (nr_of_received == 6)
       {
         ACE_DEBUG ((LM_DEBUG, "OK: Receiver received all expected data"
                               " from syn- and asynchronous calls\n"));
       }
     else
       {
         ACE_ERROR ((LM_ERROR, "ERROR: Receiver didn't receive all"
                               " expected data  (%u of 6)"
                               " from syn- and asynchronous calls\n",
                               nr_of_received));
       }
  }

  extern "C" INTERINARGS_T_RECEIVER_EXEC_Export ::Components::EnterpriseComponent_ptr
  create_InterInArgsT_Receiver_Impl (void)
  {
    ::Components::EnterpriseComponent_ptr retval =
      ::Components::EnterpriseComponent::_nil ();

    ACE_NEW_NORETURN (
      retval,
      Receiver_exec_i);

    return retval;
  }
}
