/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given z80
   Copyright (C) 1991-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_z80

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"

#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"

/* --- \begin{z80.em} */
/* Codes for machine types, bitwise or gives the code to use for the
   output.  */
#define M_Z80STRICT 1
#define M_Z80 3
#define M_Z80FULL 7
#define M_R800 11
#define M_Z80ANY 15

/* Bitwise or of the machine types seen so far.  */
static int result_mach_type;

static void
gldz80_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("z80", bfd_arch_unknown);
#endif /* not TARGET_ */
  result_mach_type = M_Z80STRICT;
}


/* Update result_mach_type.  */
static bfd_boolean
gldz80_recognized_file (lang_input_statement_type *entry)
{
  unsigned long mach_type;

  mach_type = bfd_get_mach (entry->the_bfd);
  switch (mach_type)
    {
    case bfd_mach_z80strict:
      result_mach_type |= M_Z80STRICT;
      break;
    case bfd_mach_z80:
      result_mach_type |= M_Z80;
      break;
    case bfd_mach_z80full:
      result_mach_type |= M_Z80FULL;
      break;
    case bfd_mach_r800:
      result_mach_type |= M_R800;
      break;
    default:
      result_mach_type |= M_Z80ANY;
    }
  return FALSE;
}

/* Set the machine type of the output file based on result_mach_type.  */
static void
gldz80_after_open (void)
{
  unsigned long mach_type;

  after_open_default ();

  switch (result_mach_type)
    {
    case M_Z80STRICT:
      mach_type = bfd_mach_z80strict;
      break;
    case M_Z80:
      mach_type = bfd_mach_z80;
      break;
    case M_Z80FULL:
      mach_type = bfd_mach_z80full;
      break;
    case M_R800:
      mach_type = bfd_mach_r800;
      break;
    default:
      mach_type = 0;
    }
  bfd_set_arch_mach (link_info.output_bfd, bfd_arch_z80, mach_type);
}
/* --- \end{z80.em} */

static char *
gldz80_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/z80.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/z80.xr";
  else if (!config.text_read_only)
    return "ldscripts/z80.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/z80.xn";
  else
    return "ldscripts/z80.x";
}

struct ld_emulation_xfer_struct ld_z80_emulation =
{
  gldz80_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  gldz80_after_open,
  after_allocation_default,
  set_output_arch_default,
  ldemul_default_target,
  before_allocation_default,
  gldz80_get_script,
  "z80",
  "coff-z80",
  finish_default,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  gldz80_recognized_file,
  NULL,
  NULL,
  NULL
};
