/* This file is is generated by a shell script.  DO NOT EDIT! */

/* Emulate the original gld for the given msp430X
   Copyright (C) 2014-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com
   Extended for the MSP430 by Nick Clifton  nickc@redhat.com
   
   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_msp430X

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include "libiberty.h"

#include "elf-bfd.h"


static void
gldmsp430X_map_segments (bfd_boolean need_layout)
{
  int tries = 10;

  do
    {
      lang_relax_sections (need_layout);
      need_layout = FALSE;

      if (link_info.output_bfd->xvec->flavour == bfd_target_elf_flavour
	  && !bfd_link_relocatable (&link_info))
	{
	  bfd_size_type phdr_size;

	  phdr_size = elf_program_header_size (link_info.output_bfd);
	  /* If we don't have user supplied phdrs, throw away any
	     previous linker generated program headers.  */
	  if (lang_phdr_list == NULL)
	    elf_seg_map (link_info.output_bfd) = NULL;
	  if (!_bfd_elf_map_sections_to_segments (link_info.output_bfd,
						  &link_info))
	    einfo ("%F%P: map sections to segments failed: %E\n");

	  if (phdr_size != elf_program_header_size (link_info.output_bfd))
	    {
	      if (tries > 6)
		/* The first few times we allow any change to
		   phdr_size .  */
		need_layout = TRUE;
	      else if (phdr_size
		       < elf_program_header_size (link_info.output_bfd))
		/* After that we only allow the size to grow.  */
		need_layout = TRUE;
	      else
		elf_program_header_size (link_info.output_bfd) = phdr_size;
	    }
	}
    }
  while (need_layout && --tries);

  if (tries == 0)
    einfo (_("%P%F: looping in map_segments"));
}

static void
gldmsp430X_after_open (void)
{
  bfd *ibfd;
  asection *sec;
  asymbol **syms;

  after_open_default ();

  if (bfd_link_relocatable (&link_info))
    for (ibfd = link_info.input_bfds; ibfd != NULL; ibfd = ibfd->link.next)
      if ((syms = bfd_get_outsymbols (ibfd)) != NULL
	  && bfd_get_flavour (ibfd) == bfd_target_elf_flavour)
	for (sec = ibfd->sections; sec != NULL; sec = sec->next)
	  if ((sec->flags & (SEC_GROUP | SEC_LINKER_CREATED)) == SEC_GROUP)
	    {
	      struct bfd_elf_section_data *sec_data = elf_section_data (sec);
	      elf_group_id (sec) = syms[sec_data->this_hdr.sh_info - 1];
	    }
}

static void
gldmsp430X_before_allocation (void)
{
  if (bfd_link_relocatable (&link_info)
      && !_bfd_elf_size_group_sections (&link_info))
    einfo ("%X%P: can not size group sections: %E\n");
  before_allocation_default ();
}

static void
gldmsp430X_after_allocation (void)
{
  gldmsp430X_map_segments (FALSE);
}

static void
gldmsp430X_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("MSP430x43", bfd_arch_unknown);
#endif /* not TARGET_ */

  /* The MSP430 port *needs* linker relaxtion in order to cope with large
     functions where conditional branches do not fit into a +/- 1024 byte range.  */
  if (!bfd_link_relocatable (&link_info))
    TARGET_ENABLE_RELAXATION;
}


static char *
gldmsp430X_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/msp430X.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/msp430X.xr";
  else if (!config.text_read_only)
    return "ldscripts/msp430X.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/msp430X.xn";
  else
    return "ldscripts/msp430X.x";
}

/* Helper function for place_orphan that computes the size
   of sections already mapped to the given statement.  */

static bfd_size_type
scan_children (lang_statement_union_type * l)
{
  bfd_size_type amount = 0;

  while (l != NULL)
    {
      switch (l->header.type)
	{
	case lang_input_section_enum:
	  if (l->input_section.section->flags & SEC_ALLOC)
	    amount += l->input_section.section->size;
	  break;

	case lang_constructors_statement_enum:
	case lang_assignment_statement_enum:
	  break;

	case lang_wild_statement_enum:
	  amount += scan_children (l->wild_statement.children.head);	  
	  break;

	default:
	  fprintf (stderr, "msp430 orphan placer: unhandled lang type %d\n", l->header.type);
	  break;
	}

      l = l->header.next;
    }

  return amount;
}
  
/* Place an orphan section.  We use this to put .either sections
   into either their lower or their upper equivalents.  */

static lang_output_section_statement_type *
gldmsp430X_place_orphan (asection * s,
				   const char * secname,
				   int constraint)
{
  char * lower_name;
  char * upper_name;
  char * name;
  char * buf = NULL;
  lang_output_section_statement_type * lower;
  lang_output_section_statement_type * upper;
  lang_output_section_statement_type * os;

  if ((s->flags & SEC_ALLOC) == 0)
    return NULL;

  if (bfd_link_relocatable (&link_info))
    return NULL;

  /* If constraints are involved let the linker handle the placement normally.  */
  if (constraint != 0)
    return NULL;

  /* We only need special handling for .either sections.  */
  if (strncmp (secname, ".either.", 8) != 0)
    return NULL;

  /* Skip the .either prefix.  */
  secname += 7;

  /* Compute the names of the corresponding upper and lower
     sections.  If the input section name contains another period,
     only use the part of the name before the second dot.  */
  if (strchr (secname + 1, '.') != NULL)
    {
      buf = name = xstrdup (secname);

      * strchr (name + 1, '.') = 0;
    }
  else
    name = (char *) secname;
  
  lower_name = concat (".lower", name, NULL);
  upper_name = concat (".upper", name, NULL);

  /* Find the corresponding lower and upper sections.  */
  lower = lang_output_section_find (lower_name);
  upper = lang_output_section_find (upper_name);
  /* If the upper section does not exist, try again without the suffix.  */
  if (upper == NULL)
    upper = lang_output_section_find (name);

  if (lower == NULL)
    {
      os = upper;
      if (upper == NULL)
        {
          einfo ("%P: error: no section named %s or %s in linker script\n", lower_name, upper_name);
	  goto end;
	}
    }
  else if (upper == NULL)
    os = lower;
  else if (lower->region == NULL)
    os = lower;
  /* If the section is too big for the region containing
     the lower section then do not even try to use it.  */
  else if (lower->region->length < s->size)
    os = upper;
  else
    {
      bfd_size_type amount = 0;
      struct lang_output_section_statement_struct * p;

      amount += scan_children (lower->children.head);

      /* Also check forwards for other statements assigned to the same region.  */
      for (p = lower->next; p != NULL; p = p->next)
	if (p->region == lower->region)
	  amount += scan_children (p->children.head);

      /* Scan backwards as well.  */      
      for (p = lower->prev; p != NULL; p = p->prev)
	if (p->region == lower->region)
	  amount += scan_children (p->children.head);

      if (amount + s->size >= lower->region->length)
	os = upper;
      else
	os = lower;
    }

  lang_add_section (& os->children, s, NULL, os);
 end:
  free (upper_name);
  free (lower_name);
  if (buf)
    free (buf);
  return os;
}

struct ld_emulation_xfer_struct ld_msp430X_emulation =
{
  gldmsp430X_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  gldmsp430X_after_open,
  gldmsp430X_after_allocation,
  set_output_arch_default,
  ldemul_default_target,
  gldmsp430X_before_allocation,
  gldmsp430X_get_script,
  "msp430X",
  "elf32-msp430",
  finish_default,
  NULL,
  NULL,
  gldmsp430X_place_orphan,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};
