/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given mn10200
   Copyright (C) 1991-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_mn10200

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"

#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"

#include "elf-bfd.h"


static void
gldmn10200_map_segments (bfd_boolean need_layout)
{
  int tries = 10;

  do
    {
      lang_relax_sections (need_layout);
      need_layout = FALSE;

      if (link_info.output_bfd->xvec->flavour == bfd_target_elf_flavour
	  && !bfd_link_relocatable (&link_info))
	{
	  bfd_size_type phdr_size;

	  phdr_size = elf_program_header_size (link_info.output_bfd);
	  /* If we don't have user supplied phdrs, throw away any
	     previous linker generated program headers.  */
	  if (lang_phdr_list == NULL)
	    elf_seg_map (link_info.output_bfd) = NULL;
	  if (!_bfd_elf_map_sections_to_segments (link_info.output_bfd,
						  &link_info))
	    einfo ("%F%P: map sections to segments failed: %E\n");

	  if (phdr_size != elf_program_header_size (link_info.output_bfd))
	    {
	      if (tries > 6)
		/* The first few times we allow any change to
		   phdr_size .  */
		need_layout = TRUE;
	      else if (phdr_size
		       < elf_program_header_size (link_info.output_bfd))
		/* After that we only allow the size to grow.  */
		need_layout = TRUE;
	      else
		elf_program_header_size (link_info.output_bfd) = phdr_size;
	    }
	}
    }
  while (need_layout && --tries);

  if (tries == 0)
    einfo (_("%P%F: looping in map_segments"));
}

static void
gldmn10200_after_open (void)
{
  bfd *ibfd;
  asection *sec;
  asymbol **syms;

  after_open_default ();

  if (bfd_link_relocatable (&link_info))
    for (ibfd = link_info.input_bfds; ibfd != NULL; ibfd = ibfd->link.next)
      if ((syms = bfd_get_outsymbols (ibfd)) != NULL
	  && bfd_get_flavour (ibfd) == bfd_target_elf_flavour)
	for (sec = ibfd->sections; sec != NULL; sec = sec->next)
	  if ((sec->flags & (SEC_GROUP | SEC_LINKER_CREATED)) == SEC_GROUP)
	    {
	      struct bfd_elf_section_data *sec_data = elf_section_data (sec);
	      elf_group_id (sec) = syms[sec_data->this_hdr.sh_info - 1];
	    }
}

static void
gldmn10200_before_allocation (void)
{
  if (bfd_link_relocatable (&link_info)
      && !_bfd_elf_size_group_sections (&link_info))
    einfo ("%X%P: can not size group sections: %E\n");
  before_allocation_default ();
}

static void
gldmn10200_after_allocation (void)
{
  gldmn10200_map_segments (FALSE);
}

static void
gldmn10200_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("mn10200", bfd_arch_unknown);
#endif /* not TARGET_ */
}


static char *
gldmn10200_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/mn10200.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/mn10200.xr";
  else if (!config.text_read_only)
    return "ldscripts/mn10200.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/mn10200.xn";
  else
    return "ldscripts/mn10200.x";
}

struct ld_emulation_xfer_struct ld_mn10200_emulation =
{
  gldmn10200_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  gldmn10200_after_open,
  gldmn10200_after_allocation,
  set_output_arch_default,
  ldemul_default_target,
  gldmn10200_before_allocation,
  gldmn10200_get_script,
  "mn10200",
  "elf32-mn10200",
  finish_default,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};
