/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given mmo
   Copyright (C) 1991-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_mmo

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"

#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"

/* Need to have this macro defined before mmix-elfnmmo, which uses the
   name for the before_allocation function, defined in ldemul.c (for
   the mmo "emulation") or in elf32.em (for the elf64mmix
   "emulation").  */
#define gldmmo_before_allocation before_allocation_default

/* We include this header *not* because we expect to handle ELF here
   but because we re-use the map_segments function in elf-generic.em,
   a file which is rightly somewhat ELF-centric.  But this is only to
   get a weird testcase right; ld-mmix/bpo-22, forcing ELF to be
   output from the mmo emulation: -m mmo --oformat elf64-mmix!  */
#include "elf-bfd.h"

static void gldmmo_after_allocation (void);

static void
gldmmo_map_segments (bfd_boolean need_layout)
{
  int tries = 10;

  do
    {
      lang_relax_sections (need_layout);
      need_layout = FALSE;

      if (link_info.output_bfd->xvec->flavour == bfd_target_elf_flavour
	  && !bfd_link_relocatable (&link_info))
	{
	  bfd_size_type phdr_size;

	  phdr_size = elf_program_header_size (link_info.output_bfd);
	  /* If we don't have user supplied phdrs, throw away any
	     previous linker generated program headers.  */
	  if (lang_phdr_list == NULL)
	    elf_seg_map (link_info.output_bfd) = NULL;
	  if (!_bfd_elf_map_sections_to_segments (link_info.output_bfd,
						  &link_info))
	    einfo ("%F%P: map sections to segments failed: %E\n");

	  if (phdr_size != elf_program_header_size (link_info.output_bfd))
	    {
	      if (tries > 6)
		/* The first few times we allow any change to
		   phdr_size .  */
		need_layout = TRUE;
	      else if (phdr_size
		       < elf_program_header_size (link_info.output_bfd))
		/* After that we only allow the size to grow.  */
		need_layout = TRUE;
	      else
		elf_program_header_size (link_info.output_bfd) = phdr_size;
	    }
	}
    }
  while (need_layout && --tries);

  if (tries == 0)
    einfo (_("%P%F: looping in map_segments"));
}
#include "elf/mmix.h"

/* Set up handling of linker-allocated global registers.  */

static void
mmix_before_allocation (void)
{
  /* Call the default first.  */
  gldmmo_before_allocation ();

  /* There's a needrelax.em which uses this ..._before_allocation-hook and
     just has the statement below as payload.  It's more of a hassle to
     use that than to just include these two lines and take the
     maintenance burden to keep them in sync.  (Of course we lose the
     maintenance burden of checking that it still does what we need.)  */

  /* Force -relax on (regardless of whether we're doing a relocatable
     link).  */
  ENABLE_RELAXATION;

  if (!_bfd_mmix_before_linker_allocation (link_info.output_bfd, &link_info))
    einfo ("%X%P: Internal problems setting up section %s",
	   MMIX_LD_ALLOCATED_REG_CONTENTS_SECTION_NAME);
}

/* We need to set the VMA of the .MMIX.reg_contents section when it has
   been allocated, and produce the final settings for the linker-generated
   GREGs.  */

static void
mmix_after_allocation (void)
{
  asection *sec;
  bfd_signed_vma regvma;

  gldmmo_after_allocation ();

  /* If there's no register section, we don't need to do anything.  On the
     other hand, if there's a non-standard linker-script without a mapping
     from MMIX_LD_ALLOCATED_REG_CONTENTS_SECTION_NAME when that section is
     present (as in the ld test "NOCROSSREFS 2"), that section (1) will be
     orphaned; not inserted in MMIX_REG_CONTENTS_SECTION_NAME and (2) we
     will not do the necessary preparations for those relocations that
     caused it to be created.  We'll SEGV from the latter error.  The
     former error in separation will result in a non-working binary, but
     that's expected when you play tricks with linker scripts.  The
     "NOCROSSREFS 2" test does not run the output so it does not matter
     there.  */
  sec = bfd_get_section_by_name (link_info.output_bfd,
				 MMIX_REG_CONTENTS_SECTION_NAME);
  if (sec == NULL)
    sec
      = bfd_get_section_by_name (link_info.output_bfd,
				 MMIX_LD_ALLOCATED_REG_CONTENTS_SECTION_NAME);
  if (sec == NULL)
    return;

  regvma = 256 * 8 - sec->size - 8;

  /* If we start on a local register, we have too many global registers.
     We treat this error as nonfatal (meaning processing will continue in
     search for other errors), because it's a link error in the same way
     as an undefined symbol.  */
  if (regvma < 32 * 8)
    {
      einfo ("%X%P: Too many global registers: %u, max 223\n",
	     (unsigned) sec->size / 8);
      regvma = 32 * 8;
    }

  /* Set vma to correspond to first such register number * 8.  */
  bfd_set_section_vma (link_info.output_bfd, sec, (bfd_vma) regvma);

  /* Simplify symbol output for the register section (without contents;
     created for register symbols) by setting the output offset to 0.
     This section is only present when there are register symbols.  */
  sec = bfd_get_section_by_name (link_info.output_bfd, MMIX_REG_SECTION_NAME);
  if (sec != NULL)
    bfd_set_section_vma (sec->owner, sec, 0);

  if (!_bfd_mmix_after_linker_allocation (link_info.output_bfd, &link_info))
    {
      /* This is a fatal error; make einfo call not return.  */
      einfo ("%F%P: Can't finalize linker-allocated global registers\n");
    }
}

/* Place an orphan section.  We use this to put random SEC_CODE or
   SEC_READONLY sections right after MMO_TEXT_SECTION_NAME.  Much borrowed
   from elf32.em.  */

static lang_output_section_statement_type *
mmo_place_orphan (asection *s,
		  const char *secname,
		  int constraint ATTRIBUTE_UNUSED)
{
  static struct
  {
    flagword nonzero_flags;
    struct orphan_save orphansave;
  } holds[] =
      {
	{
	  SEC_CODE | SEC_READONLY,
	  {
	    MMO_TEXT_SECTION_NAME,
	    SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_CODE,
	    0, 0, 0, 0
	  }
	},
	{
	  SEC_LOAD | SEC_DATA,
	  {
	    MMO_DATA_SECTION_NAME,
	    SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_DATA,
	    0, 0, 0, 0
	  }
	},
	{
	  SEC_ALLOC,
	  {
	    ".bss",
	    SEC_ALLOC,
	    0, 0, 0, 0
	  }
	}
      };

  struct orphan_save *place = NULL;
  lang_output_section_statement_type *after;
  lang_output_section_statement_type *os;
  size_t i;
  flagword flags;
  asection *nexts;

  /* We have nothing to say for anything other than a final link or
     for sections that are excluded.  */
  if (bfd_link_relocatable (&link_info)
      || (s->flags & SEC_EXCLUDE) != 0)
    return NULL;

  os = lang_output_section_find (secname);

  /* We have an output section by this name.  Place the section inside it
     (regardless of whether the linker script lists it as input).  */
  if (os != NULL)
    {
      lang_add_section (&os->children, s, NULL, os);
      return os;
    }

  flags = s->flags;
  if (!bfd_link_relocatable (&link_info))
    {
      nexts = s;
      while ((nexts = bfd_get_next_section_by_name (nexts->owner, nexts))
	     != NULL)
	if (nexts->output_section == NULL
	    && (nexts->flags & SEC_EXCLUDE) == 0
	    && ((nexts->flags ^ flags) & (SEC_LOAD | SEC_ALLOC)) == 0
	    && (nexts->owner->flags & DYNAMIC) == 0
	    && nexts->owner->usrdata != NULL
	    && !(((lang_input_statement_type *) nexts->owner->usrdata)
		 ->flags.just_syms))
	  flags = (((flags ^ SEC_READONLY) | (nexts->flags ^ SEC_READONLY))
		   ^ SEC_READONLY);
    }

  /* Check for matching section type flags for sections we care about.
     A section without contents can have SEC_LOAD == 0, but we still
     want it attached to a sane section so the symbols appear as
     expected.  */

  if ((flags & (SEC_ALLOC | SEC_READONLY)) != SEC_READONLY)
    for (i = 0; i < sizeof (holds) / sizeof (holds[0]); i++)
      if ((flags & holds[i].nonzero_flags) != 0)
	{
	  place = &holds[i].orphansave;
	  if (place->os == NULL)
	    place->os = lang_output_section_find (place->name);
	  break;
	}

  if (place == NULL)
    {
      /* For other combinations, we have to give up, except we make
	 sure not to place the orphan section after the
	 linker-generated register section; that'd make it continue
	 the reg section and we never want that to happen for orphan
	 sections.  */
      lang_output_section_statement_type *before;
      lang_output_section_statement_type *lookup;
      static struct orphan_save hold_nonreg =
	{
	  NULL,
	  SEC_READONLY,
	  0, 0, 0, 0
	};

      if (hold_nonreg.os == NULL)
	{
	  before = lang_output_section_find (MMIX_REG_CONTENTS_SECTION_NAME);

	  /* If we have no such section, all fine; we don't care where
	     it's placed.  */
	  if (before == NULL)
	    return NULL;

	  /* We have to find the oss before this one, so we can use that as
	     "after".  */
	  for (lookup = &lang_output_section_statement.head->output_section_statement;
	       lookup != NULL && lookup->next != before;
	       lookup = lookup->next)
	    ;

	  hold_nonreg.os = lookup;
	}

      place = &hold_nonreg;
    }

  after = place->os;
  if (after == NULL)
    return NULL;

  /* If there's an output section by *this* name, we'll use it, regardless
     of actual section flags, in contrast to what's done in elf32.em.  */
  os = lang_insert_orphan (s, secname, 0, after, place, NULL, NULL);

  return os;
}

/* Remove the spurious settings of SEC_RELOC that make it to the output at
   link time.  We are as confused as elflink.h:elf_bfd_final_link, and
   paper over the bug similarly.  */

static void
mmo_wipe_sec_reloc_flag (bfd *abfd, asection *sec, void *ptr ATTRIBUTE_UNUSED)
{
  bfd_set_section_flags (abfd, sec,
			 bfd_get_section_flags (abfd, sec) & ~SEC_RELOC);
}

/* Iterate with bfd_map_over_sections over mmo_wipe_sec_reloc_flag... */

static void
gldmmo_after_allocation (void)
{
  bfd_map_over_sections (link_info.output_bfd, mmo_wipe_sec_reloc_flag, NULL);
  gldmmo_map_segments (FALSE);
}

/* To get on-demand global register allocation right, we need to parse the
   relocs, like what happens when linking to ELF.  It needs to be done
   before all input sections are supposed to be present.  When linking to
   ELF, it's done when reading symbols.  When linking to mmo, we do it
   when all input files are seen, which is equivalent.  */

static void
mmo_after_open (void)
{
  /* When there's a mismatch between the output format and the emulation
     (using weird combinations like "-m mmo --oformat elf64-mmix" for
     example), we'd count relocs twice because they'd also be counted
     along the usual route for ELF-only linking, which would lead to an
     internal accounting error.  */
  if (bfd_get_flavour (link_info.output_bfd) != bfd_target_elf_flavour)
    {
      LANG_FOR_EACH_INPUT_STATEMENT (is)
	{
	  if (bfd_get_flavour (is->the_bfd) == bfd_target_elf_flavour
	      && !_bfd_mmix_check_all_relocs (is->the_bfd, &link_info))
	    einfo ("%X%P: Internal problems scanning %B after opening it",
		   is->the_bfd);
	}
    }
  after_open_default ();
}

static void
gldmmo_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("mmix", bfd_arch_unknown);
#endif /* not TARGET_ */
}


static char *
gldmmo_get_script (int *isfile)
{
  *isfile = 0;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return
"/* Script for ld -Ur: link w/out relocation, do create constructors */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-mmix\")\n\
OUTPUT_ARCH(mmix)\n\
SECTIONS\n\
{\n\
  .text :\n\
  {\n\
    *(.text)\n\
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */\n\
    /* FIXME: Align ctors, dtors, ehframe.  */\n\
  }\n\
  /* The following NOP assignment and those after .data and .bss, are\n\
     necessary to get orphan sections adopted by the .text inserted before\n\
     the following end-section symbols.  An output section would also serve\n\
     this purpose, but we can't do that.  */\n\
  . = .;\n\
  .data :\n\
  {\n\
    *(.data);\n\
  }\n\
  . = .;\n"
"  /* Deprecated, use __Edata.  */\n\
  /* At the moment, although perhaps we should, we can't map sections\n\
     without contents to sections *with* contents due to FIXME: a BFD bug.\n\
     Anyway, the mmo back-end ignores sections without contents when\n\
     writing out sections, so this works fine.   */\n\
  .bss :\n\
  {\n\
  }\n\
  . = .;\n\
  /* Deprecated, use __Ebss or __Eall as appropriate.  */\n\
  .stab 0 : { *(.stab) }\n\
  .stabstr 0 : { *(.stabstr) }\n\
  .stab.excl 0 : { *(.stab.excl) }\n\
  .stab.exclstr 0 : { *(.stab.exclstr) }\n\
  .stab.index 0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n"
"  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .MMIX.reg_contents :\n\
  {\n\
    /* Note that this section always has a fixed VMA - that of its\n\
       first register * 8.  */\n"
"    *(.MMIX.reg_contents.linker_allocated);\n\
    *(.MMIX.reg_contents);\n\
  }\n\
  /* By default, put the high end of the stack where the register stack\n\
     begins.  They grow in opposite directions.  */\n\
  PROVIDE (__Stack_start = 0x6000000000000000);\n\
  /* Unfortunately, stabs are not mappable from ELF to MMO.\n\
     It can probably be fixed with some amount of work.  */\n\
  /DISCARD/ :\n\
  {  }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else if (bfd_link_relocatable (&link_info)) return
"/* Script for ld -r: link without relocation */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-mmix\")\n\
OUTPUT_ARCH(mmix)\n\
SECTIONS\n\
{\n\
  .text :\n\
  {\n\
    *(.text)\n\
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */\n\
    /* FIXME: Align ctors, dtors, ehframe.  */\n\
  }\n\
  /* The following NOP assignment and those after .data and .bss, are\n\
     necessary to get orphan sections adopted by the .text inserted before\n\
     the following end-section symbols.  An output section would also serve\n\
     this purpose, but we can't do that.  */\n\
  . = .;\n\
  .data :\n\
  {\n\
    *(.data);\n\
  }\n\
  . = .;\n"
"  /* Deprecated, use __Edata.  */\n\
  /* At the moment, although perhaps we should, we can't map sections\n\
     without contents to sections *with* contents due to FIXME: a BFD bug.\n\
     Anyway, the mmo back-end ignores sections without contents when\n\
     writing out sections, so this works fine.   */\n\
  .bss :\n\
  {\n\
  }\n\
  . = .;\n\
  /* Deprecated, use __Ebss or __Eall as appropriate.  */\n\
  .stab 0 : { *(.stab) }\n\
  .stabstr 0 : { *(.stabstr) }\n\
  .stab.excl 0 : { *(.stab.excl) }\n\
  .stab.exclstr 0 : { *(.stab.exclstr) }\n\
  .stab.index 0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n"
"  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .MMIX.reg_contents :\n\
  {\n\
    /* Note that this section always has a fixed VMA - that of its\n\
       first register * 8.  */\n"
"    *(.MMIX.reg_contents.linker_allocated);\n\
    *(.MMIX.reg_contents);\n\
  }\n\
  /* By default, put the high end of the stack where the register stack\n\
     begins.  They grow in opposite directions.  */\n\
  PROVIDE (__Stack_start = 0x6000000000000000);\n\
  /* Unfortunately, stabs are not mappable from ELF to MMO.\n\
     It can probably be fixed with some amount of work.  */\n\
  /DISCARD/ :\n\
  {  }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N: mix text and data on same page; don't align data */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"mmo\")\n\
OUTPUT_ARCH(mmix)\n\
ENTRY(Main)\n\
SECTIONS\n\
{\n\
  .text  DEFINED (__.MMIX.start..text) ? __.MMIX.start..text : 0:\n\
  {\n\
    *(.text)\n\
    *(.text.*)\n\
    *(.gnu.linkonce.t*)\n\
    *(.rodata)\n\
    *(.rodata.*)\n\
    *(.gnu.linkonce.r*)\n\
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */\n\
     PROVIDE (_init_start = .);\n\
     PROVIDE (_init = .);\n\
     KEEP (*(SORT_NONE(.init)))\n\
     PROVIDE (_init_end = .);\n\
     PROVIDE (_fini_start = .);\n\
     PROVIDE (_fini = .);\n"
"     KEEP (*(SORT_NONE(.fini)))\n\
     PROVIDE (_fini_end = .);\n\
    /* FIXME: Align ctors, dtors, ehframe.  */\n\
     PROVIDE (_ctors_start = .);\n\
     PROVIDE (__ctors_start = .);\n\
     PROVIDE (_ctors = .);\n\
     PROVIDE (__ctors = .);\n\
     KEEP (*crtbegin.o(.ctors))\n\
     KEEP (*crtbegin?.o(.ctors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .ctors))\n\
     KEEP (*(SORT(.ctors.*)))\n\
     KEEP (*(.ctors))\n\
     PROVIDE (_ctors_end = .);\n\
     PROVIDE (__ctors_end = .);\n\
     PROVIDE (_dtors_start = .);\n\
     PROVIDE (__dtors_start = .);\n\
     PROVIDE (_dtors = .);\n\
     PROVIDE (__dtors = .);\n\
     KEEP (*crtbegin.o(.dtors))\n\
     KEEP (*crtbegin?.o(.dtors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .dtors))\n\
     KEEP (*(SORT(.dtors.*)))\n\
     KEEP (*(.dtors))\n\
     PROVIDE (_dtors_end = .);\n\
     PROVIDE (__dtors_end = .);\n"
"    KEEP (*(.jcr))\n\
    KEEP (*(.eh_frame))\n\
    *(.gcc_except_table)\n\
    Main = DEFINED (Main) ? Main : (DEFINED (_start) ? _start : ADDR (.text));\n\
  }\n\
  /* The following NOP assignment and those after .data and .bss, are\n\
     necessary to get orphan sections adopted by the .text inserted before\n\
     the following end-section symbols.  An output section would also serve\n\
     this purpose, but we can't do that.  */\n\
  . = .;\n\
   PROVIDE(etext = .);\n\
   PROVIDE(_etext = .);\n\
   PROVIDE(__etext = .);\n\
  .data  DEFINED (__.MMIX.start..data) ? __.MMIX.start..data : 0x2000000000000000:\n\
  {\n\
     PROVIDE(__Sdata = .);\n\
    *(.data);\n\
    *(.data.*)\n\
    *(.gnu.linkonce.d*)\n\
  }\n\
  . = .;\n\
   PROVIDE(__Edata = .);\n\
  /* Deprecated, use __Edata.  */\n\
   PROVIDE(edata = .);\n\
   PROVIDE(_edata = .);\n"
"   PROVIDE(__edata = .);\n\
  /* At the moment, although perhaps we should, we can't map sections\n\
     without contents to sections *with* contents due to FIXME: a BFD bug.\n\
     Anyway, the mmo back-end ignores sections without contents when\n\
     writing out sections, so this works fine.   */\n\
  .bss :\n\
  {\n\
     PROVIDE(__Sbss = .);\n\
     PROVIDE(__bss_start = .);\n\
     *(.sbss);\n\
     *(.bss);\n\
    *(.bss.*)\n\
     *(COMMON);\n\
  }\n\
  . = .;\n\
   PROVIDE(__Ebss = .);\n\
  /* Deprecated, use __Ebss or __Eall as appropriate.  */\n\
   PROVIDE(end = .);\n\
   PROVIDE(_end = .);\n\
   PROVIDE(__end = .);\n\
   PROVIDE(__Eall = .);\n\
  .stab 0 : { *(.stab) }\n\
  .stabstr 0 : { *(.stabstr) }\n\
  .stab.excl 0 : { *(.stab.excl) }\n\
  .stab.exclstr 0 : { *(.stab.exclstr) }\n"
"  .stab.index 0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .MMIX.reg_contents :\n\
  {\n\
    /* Note that this section always has a fixed VMA - that of its\n\
       first register * 8.  */\n\
    *(.MMIX.reg_contents.linker_allocated);\n\
    *(.MMIX.reg_contents);\n\
  }\n\
  /* By default, put the high end of the stack where the register stack\n\
     begins.  They grow in opposite directions.  */\n\
  PROVIDE (__Stack_start = 0x6000000000000000);\n\
  /* Unfortunately, stabs are not mappable from ELF to MMO.\n\
     It can probably be fixed with some amount of work.  */\n\
  /DISCARD/ :\n\
  {  *(.gnu.warning.*); }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n: mix text and data on same page */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"mmo\")\n\
OUTPUT_ARCH(mmix)\n\
ENTRY(Main)\n\
SECTIONS\n\
{\n\
  .text  DEFINED (__.MMIX.start..text) ? __.MMIX.start..text : 0:\n\
  {\n\
    *(.text)\n\
    *(.text.*)\n\
    *(.gnu.linkonce.t*)\n\
    *(.rodata)\n\
    *(.rodata.*)\n\
    *(.gnu.linkonce.r*)\n\
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */\n\
     PROVIDE (_init_start = .);\n\
     PROVIDE (_init = .);\n\
     KEEP (*(SORT_NONE(.init)))\n\
     PROVIDE (_init_end = .);\n\
     PROVIDE (_fini_start = .);\n\
     PROVIDE (_fini = .);\n"
"     KEEP (*(SORT_NONE(.fini)))\n\
     PROVIDE (_fini_end = .);\n\
    /* FIXME: Align ctors, dtors, ehframe.  */\n\
     PROVIDE (_ctors_start = .);\n\
     PROVIDE (__ctors_start = .);\n\
     PROVIDE (_ctors = .);\n\
     PROVIDE (__ctors = .);\n\
     KEEP (*crtbegin.o(.ctors))\n\
     KEEP (*crtbegin?.o(.ctors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .ctors))\n\
     KEEP (*(SORT(.ctors.*)))\n\
     KEEP (*(.ctors))\n\
     PROVIDE (_ctors_end = .);\n\
     PROVIDE (__ctors_end = .);\n\
     PROVIDE (_dtors_start = .);\n\
     PROVIDE (__dtors_start = .);\n\
     PROVIDE (_dtors = .);\n\
     PROVIDE (__dtors = .);\n\
     KEEP (*crtbegin.o(.dtors))\n\
     KEEP (*crtbegin?.o(.dtors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .dtors))\n\
     KEEP (*(SORT(.dtors.*)))\n\
     KEEP (*(.dtors))\n\
     PROVIDE (_dtors_end = .);\n\
     PROVIDE (__dtors_end = .);\n"
"    KEEP (*(.jcr))\n\
    KEEP (*(.eh_frame))\n\
    *(.gcc_except_table)\n\
    Main = DEFINED (Main) ? Main : (DEFINED (_start) ? _start : ADDR (.text));\n\
  }\n\
  /* The following NOP assignment and those after .data and .bss, are\n\
     necessary to get orphan sections adopted by the .text inserted before\n\
     the following end-section symbols.  An output section would also serve\n\
     this purpose, but we can't do that.  */\n\
  . = .;\n\
   PROVIDE(etext = .);\n\
   PROVIDE(_etext = .);\n\
   PROVIDE(__etext = .);\n\
  .data  DEFINED (__.MMIX.start..data) ? __.MMIX.start..data : 0x2000000000000000:\n\
  {\n\
     PROVIDE(__Sdata = .);\n\
    *(.data);\n\
    *(.data.*)\n\
    *(.gnu.linkonce.d*)\n\
  }\n\
  . = .;\n\
   PROVIDE(__Edata = .);\n\
  /* Deprecated, use __Edata.  */\n\
   PROVIDE(edata = .);\n\
   PROVIDE(_edata = .);\n"
"   PROVIDE(__edata = .);\n\
  /* At the moment, although perhaps we should, we can't map sections\n\
     without contents to sections *with* contents due to FIXME: a BFD bug.\n\
     Anyway, the mmo back-end ignores sections without contents when\n\
     writing out sections, so this works fine.   */\n\
  .bss :\n\
  {\n\
     PROVIDE(__Sbss = .);\n\
     PROVIDE(__bss_start = .);\n\
     *(.sbss);\n\
     *(.bss);\n\
    *(.bss.*)\n\
     *(COMMON);\n\
  }\n\
  . = .;\n\
   PROVIDE(__Ebss = .);\n\
  /* Deprecated, use __Ebss or __Eall as appropriate.  */\n\
   PROVIDE(end = .);\n\
   PROVIDE(_end = .);\n\
   PROVIDE(__end = .);\n\
   PROVIDE(__Eall = .);\n\
  .stab 0 : { *(.stab) }\n\
  .stabstr 0 : { *(.stabstr) }\n\
  .stab.excl 0 : { *(.stab.excl) }\n\
  .stab.exclstr 0 : { *(.stab.exclstr) }\n"
"  .stab.index 0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .MMIX.reg_contents :\n\
  {\n\
    /* Note that this section always has a fixed VMA - that of its\n\
       first register * 8.  */\n\
    *(.MMIX.reg_contents.linker_allocated);\n\
    *(.MMIX.reg_contents);\n\
  }\n\
  /* By default, put the high end of the stack where the register stack\n\
     begins.  They grow in opposite directions.  */\n\
  PROVIDE (__Stack_start = 0x6000000000000000);\n\
  /* Unfortunately, stabs are not mappable from ELF to MMO.\n\
     It can probably be fixed with some amount of work.  */\n\
  /DISCARD/ :\n\
  {  *(.gnu.warning.*); }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"mmo\")\n\
OUTPUT_ARCH(mmix)\n\
ENTRY(Main)\n\
SECTIONS\n\
{\n\
  .text  DEFINED (__.MMIX.start..text) ? __.MMIX.start..text : 0:\n\
  {\n\
    *(.text)\n\
    *(.text.*)\n\
    *(.gnu.linkonce.t*)\n\
    *(.rodata)\n\
    *(.rodata.*)\n\
    *(.gnu.linkonce.r*)\n\
    /* FIXME: Move .init, .fini, .ctors and .dtors to their own sections.  */\n\
     PROVIDE (_init_start = .);\n\
     PROVIDE (_init = .);\n\
     KEEP (*(SORT_NONE(.init)))\n\
     PROVIDE (_init_end = .);\n\
     PROVIDE (_fini_start = .);\n\
     PROVIDE (_fini = .);\n"
"     KEEP (*(SORT_NONE(.fini)))\n\
     PROVIDE (_fini_end = .);\n\
    /* FIXME: Align ctors, dtors, ehframe.  */\n\
     PROVIDE (_ctors_start = .);\n\
     PROVIDE (__ctors_start = .);\n\
     PROVIDE (_ctors = .);\n\
     PROVIDE (__ctors = .);\n\
     KEEP (*crtbegin.o(.ctors))\n\
     KEEP (*crtbegin?.o(.ctors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .ctors))\n\
     KEEP (*(SORT(.ctors.*)))\n\
     KEEP (*(.ctors))\n\
     PROVIDE (_ctors_end = .);\n\
     PROVIDE (__ctors_end = .);\n\
     PROVIDE (_dtors_start = .);\n\
     PROVIDE (__dtors_start = .);\n\
     PROVIDE (_dtors = .);\n\
     PROVIDE (__dtors = .);\n\
     KEEP (*crtbegin.o(.dtors))\n\
     KEEP (*crtbegin?.o(.dtors))\n\
     KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o) .dtors))\n\
     KEEP (*(SORT(.dtors.*)))\n\
     KEEP (*(.dtors))\n\
     PROVIDE (_dtors_end = .);\n\
     PROVIDE (__dtors_end = .);\n"
"    KEEP (*(.jcr))\n\
    KEEP (*(.eh_frame))\n\
    *(.gcc_except_table)\n\
    Main = DEFINED (Main) ? Main : (DEFINED (_start) ? _start : ADDR (.text));\n\
  }\n\
  /* The following NOP assignment and those after .data and .bss, are\n\
     necessary to get orphan sections adopted by the .text inserted before\n\
     the following end-section symbols.  An output section would also serve\n\
     this purpose, but we can't do that.  */\n\
  . = .;\n\
   PROVIDE(etext = .);\n\
   PROVIDE(_etext = .);\n\
   PROVIDE(__etext = .);\n\
  .data  DEFINED (__.MMIX.start..data) ? __.MMIX.start..data : 0x2000000000000000:\n\
  {\n\
     PROVIDE(__Sdata = .);\n\
    *(.data);\n\
    *(.data.*)\n\
    *(.gnu.linkonce.d*)\n\
  }\n\
  . = .;\n\
   PROVIDE(__Edata = .);\n\
  /* Deprecated, use __Edata.  */\n\
   PROVIDE(edata = .);\n\
   PROVIDE(_edata = .);\n"
"   PROVIDE(__edata = .);\n\
  /* At the moment, although perhaps we should, we can't map sections\n\
     without contents to sections *with* contents due to FIXME: a BFD bug.\n\
     Anyway, the mmo back-end ignores sections without contents when\n\
     writing out sections, so this works fine.   */\n\
  .bss :\n\
  {\n\
     PROVIDE(__Sbss = .);\n\
     PROVIDE(__bss_start = .);\n\
     *(.sbss);\n\
     *(.bss);\n\
    *(.bss.*)\n\
     *(COMMON);\n\
  }\n\
  . = .;\n\
   PROVIDE(__Ebss = .);\n\
  /* Deprecated, use __Ebss or __Eall as appropriate.  */\n\
   PROVIDE(end = .);\n\
   PROVIDE(_end = .);\n\
   PROVIDE(__end = .);\n\
   PROVIDE(__Eall = .);\n\
  .stab 0 : { *(.stab) }\n\
  .stabstr 0 : { *(.stabstr) }\n\
  .stab.excl 0 : { *(.stab.excl) }\n\
  .stab.exclstr 0 : { *(.stab.exclstr) }\n"
"  .stab.index 0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .MMIX.reg_contents :\n\
  {\n\
    /* Note that this section always has a fixed VMA - that of its\n\
       first register * 8.  */\n\
    *(.MMIX.reg_contents.linker_allocated);\n\
    *(.MMIX.reg_contents);\n\
  }\n\
  /* By default, put the high end of the stack where the register stack\n\
     begins.  They grow in opposite directions.  */\n\
  PROVIDE (__Stack_start = 0x6000000000000000);\n\
  /* Unfortunately, stabs are not mappable from ELF to MMO.\n\
     It can probably be fixed with some amount of work.  */\n\
  /DISCARD/ :\n\
  {  *(.gnu.warning.*); }\n\
  .gnu.attributes 0 : { KEEP (*(.gnu.attributes)) }\n\
}\n\n"
; }

struct ld_emulation_xfer_struct ld_mmo_emulation =
{
  gldmmo_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  mmo_after_open,
  mmix_after_allocation,
  set_output_arch_default,
  ldemul_default_target,
  mmix_before_allocation,
  gldmmo_get_script,
  "mmo",
  "mmo",
  finish_default,
  NULL,
  NULL,
  mmo_place_orphan,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};
