/* This file is is generated by a shell script.  DO NOT EDIT! */

/* Handle embedded relocs for m68k.
   Copyright (C) 2000-2016 Free Software Foundation, Inc.
   Written by Michael Sokolov <msokolov@ivan.Harhan.ORG>, based on generic.em
   by Steve Chamberlain <steve@cygnus.com>, embedded relocs code based on
   mipsecoff.em by Ian Lance Taylor <ian@cygnus.com> (now removed).

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_m68kcoff

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include "ldmisc.h"

static void check_sections (bfd *, asection *, void *);

static void
gldm68kcoff_before_parse (void)
{
#ifndef TARGET_			/* I.e., if not generic.  */
  ldfile_set_output_arch ("m68k", bfd_arch_unknown);
#endif /* not TARGET_ */
}

/* This function is run after all the input files have been opened.
   We create a .emreloc section for each input file with a non zero
   .data section.  The BFD backend will fill in these sections with
   magic numbers which can be used to relocate the data section at run
   time.  */

static void
gldm68kcoff_after_open (void)
{
  bfd *abfd;

  after_open_default ();

  if (! command_line.embedded_relocs
      || bfd_link_relocatable (&link_info))
    return;

  for (abfd = link_info.input_bfds; abfd != NULL; abfd = abfd->link.next)
    {
      asection *datasec;

      /* As first-order business, make sure that each input BFD is COFF. It
         better be, as we are directly calling a COFF backend function.  */
      if (bfd_get_flavour (abfd) != bfd_target_coff_flavour)
	einfo ("%F%B: all input objects must be COFF for --embedded-relocs\n");

      datasec = bfd_get_section_by_name (abfd, ".data");

      /* Note that we assume that the reloc_count field has already
         been set up.  We could call bfd_get_reloc_upper_bound, but
         that returns the size of a memory buffer rather than a reloc
         count.  We do not want to call bfd_canonicalize_reloc,
         because although it would always work it would force us to
         read in the relocs into BFD canonical form, which would waste
         a significant amount of time and memory.  */
      if (datasec != NULL && datasec->reloc_count > 0)
	{
	  asection *relsec;

	  relsec = bfd_make_section_with_flags (abfd, ".emreloc",
						(SEC_ALLOC
						 | SEC_LOAD
						 | SEC_HAS_CONTENTS
						 | SEC_IN_MEMORY));
	  if (relsec == NULL
	      || ! bfd_set_section_alignment (abfd, relsec, 2)
	      || ! bfd_set_section_size (abfd, relsec,
					 datasec->reloc_count * 12))
	    einfo ("%F%B: can not create .emreloc section: %E\n");
	}

      /* Double check that all other data sections are empty, as is
         required for embedded PIC code.  */
      bfd_map_over_sections (abfd, check_sections, datasec);
    }
}

/* Check that of the data sections, only the .data section has
   relocs.  This is called via bfd_map_over_sections.  */

static void
check_sections (bfd *abfd, asection *sec, void *datasec)
{
  if ((bfd_get_section_flags (abfd, sec) & SEC_DATA)
      && sec != datasec
      && sec->reloc_count != 0)
    einfo ("%B%X: section %s has relocs; can not use --embedded-relocs\n",
	   abfd, bfd_get_section_name (abfd, sec));
}

/* This function is called after the section sizes and offsets have
   been set.  If we are generating embedded relocs, it calls a special
   BFD backend routine to do the work.  */

static void
gldm68kcoff_after_allocation (void)
{
  bfd *abfd;

  if (! command_line.embedded_relocs
      || bfd_link_relocatable (&link_info))
    return;

  for (abfd = link_info.input_bfds; abfd != NULL; abfd = abfd->link.next)
    {
      asection *datasec, *relsec;
      char *errmsg;

      datasec = bfd_get_section_by_name (abfd, ".data");

      if (datasec == NULL || datasec->reloc_count == 0)
	continue;

      relsec = bfd_get_section_by_name (abfd, ".emreloc");
      ASSERT (relsec != NULL);

      if (! bfd_m68k_coff_create_embedded_relocs (abfd, &link_info,
						   datasec, relsec,
						   &errmsg))
	{
	  if (errmsg == NULL)
	    einfo ("%B%X: can not create runtime reloc information: %E\n",
		   abfd);
	  else
	    einfo ("%X%B: can not create runtime reloc information: %s\n",
		   abfd, errmsg);
	}
    }
}

static char *
gldm68kcoff_get_script (int *isfile)
{
  *isfile = 1;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return "ldscripts/m68kcoff.xu";
  else if (bfd_link_relocatable (&link_info))
    return "ldscripts/m68kcoff.xr";
  else if (!config.text_read_only)
    return "ldscripts/m68kcoff.xbn";
  else if (!config.magic_demand_paged)
    return "ldscripts/m68kcoff.xn";
  else
    return "ldscripts/m68kcoff.x";
}

struct ld_emulation_xfer_struct ld_m68kcoff_emulation =
{
  gldm68kcoff_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  gldm68kcoff_after_open,
  gldm68kcoff_after_allocation,
  set_output_arch_default,
  ldemul_default_target,
  before_allocation_default,
  gldm68kcoff_get_script,
  "m68kcoff",
  "coff-m68k",
  finish_default,
  NULL,	/* create output section statements */
  NULL,	/* open dynamic archive */
  NULL,	/* place orphan */
  NULL,	/* set symbols */
  NULL,	/* parse args */
  NULL,	/* add_options */
  NULL,	/* handle_option */
  NULL,	/* unrecognized file */
  NULL,	/* list options */
  NULL,	/* recognized file */
  NULL,	/* find_potential_libraries */
  NULL,	/* new_vers_pattern */
  NULL	/* extra_map_file_text */
};
