/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given elf64_ia64_vms
   Copyright (C) 1991-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_elf64_ia64_vms

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"

#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"

#include "getopt.h"

static void
gldelf64_ia64_vms_before_parse (void)
{
  ldfile_set_output_arch ("ia64", bfd_arch_ia64);
  input_flags.dynamic = TRUE;
  config.has_shared = FALSE; /* Not yet.  */

  /* For ia64, harmless for alpha.  */
  link_info.emit_hash = FALSE;
  link_info.spare_dynamic_tags = 0;
}

/* This is called before the input files are opened.  We add the
   standard library.  */

static void
gldelf64_ia64_vms_create_output_section_statements (void)
{
  lang_add_input_file ("imagelib", lang_input_file_is_l_enum, NULL);
  lang_add_input_file ("starlet", lang_input_file_is_l_enum, NULL);
  lang_add_input_file ("sys$public_vectors", lang_input_file_is_l_enum, NULL);
}

/* Try to open a dynamic archive.  This is where we know that VMS
   shared images (dynamic libraries) have an extension of .exe.  */

static bfd_boolean
gldelf64_ia64_vms_open_dynamic_archive (const char *arch ATTRIBUTE_UNUSED,
                                           search_dirs_type *search,
                                           lang_input_statement_type *entry)
{
  char *string;

  if (! entry->flags.maybe_archive || entry->flags.full_name_provided)
    return FALSE;

  string = (char *) xmalloc (strlen (search->name)
			     + strlen (entry->filename)
			     + sizeof "/.exe");

  sprintf (string, "%s/%s.exe", search->name, entry->filename);

  if (! ldfile_try_open_bfd (string, entry))
    {
      free (string);
      return FALSE;
    }

  entry->filename = string;

  return TRUE;
}

static int
gldelf64_ia64_vms_find_potential_libraries
  (char *name, lang_input_statement_type *entry)
{
  return ldfile_open_file_search (name, entry, "", ".olb");
}

/* Place an orphan section.  We use this to put random OVR sections.
   Much borrowed from elf32.em.  */

static lang_output_section_statement_type *
vms_place_orphan (asection *s,
		  const char *secname ATTRIBUTE_UNUSED,
		  int constraint ATTRIBUTE_UNUSED)
{
  static struct orphan_save hold_data =
    {
      "$DATA$",
      SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_DATA,
      0, 0, 0, 0
    };

  /* We have nothing to say for anything other than a final link or an excluded
     section.  */
  if (bfd_link_relocatable (&link_info)
      || (s->flags & (SEC_EXCLUDE | SEC_LOAD)) != SEC_LOAD)
    return NULL;

  /* FIXME: we should place sections by VMS program section flags.  */

  /* Only handle data sections.  */
  if ((s->flags & SEC_DATA) == 0)
    return NULL;

  if (hold_data.os == NULL)
    hold_data.os = lang_output_section_find (hold_data.name);

  if (hold_data.os != NULL)
    {
      lang_add_section (&hold_data.os->children, s, NULL, hold_data.os);
      return hold_data.os;
    }
  else
    return NULL;
}

/* VMS specific options.  */
#define OPTION_IDENTIFICATION		(300  + 1)

static void
gldelf64_ia64_vms_add_options
  (int ns ATTRIBUTE_UNUSED,
   char **shortopts ATTRIBUTE_UNUSED,
   int nl,
   struct option **longopts,
   int nrl ATTRIBUTE_UNUSED,
   struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const struct option xtra_long[] =
  {
    {"identification", required_argument, NULL, OPTION_IDENTIFICATION},
    {NULL, no_argument, NULL, 0}
  };

  *longopts
    = xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

static void
gldelf64_ia64_vms_list_options (FILE *file)
{
  fprintf (file, _("  --identification <string>          Set the identification of the output\n"));
}

static bfd_boolean
gldelf64_ia64_vms_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return FALSE;

    case OPTION_IDENTIFICATION:
      /* Currently ignored.  */
      break;
    }

  return TRUE;
}

#include "elf-bfd.h"

static void
gldelf64_ia64_vms_map_segments (bfd_boolean need_layout)
{
  int tries = 10;

  do
    {
      lang_relax_sections (need_layout);
      need_layout = FALSE;

      if (link_info.output_bfd->xvec->flavour == bfd_target_elf_flavour
	  && !bfd_link_relocatable (&link_info))
	{
	  bfd_size_type phdr_size;

	  phdr_size = elf_program_header_size (link_info.output_bfd);
	  /* If we don't have user supplied phdrs, throw away any
	     previous linker generated program headers.  */
	  if (lang_phdr_list == NULL)
	    elf_seg_map (link_info.output_bfd) = NULL;
	  if (!_bfd_elf_map_sections_to_segments (link_info.output_bfd,
						  &link_info))
	    einfo ("%F%P: map sections to segments failed: %E\n");

	  if (phdr_size != elf_program_header_size (link_info.output_bfd))
	    {
	      if (tries > 6)
		/* The first few times we allow any change to
		   phdr_size .  */
		need_layout = TRUE;
	      else if (phdr_size
		       < elf_program_header_size (link_info.output_bfd))
		/* After that we only allow the size to grow.  */
		need_layout = TRUE;
	      else
		elf_program_header_size (link_info.output_bfd) = phdr_size;
	    }
	}
    }
  while (need_layout && --tries);

  if (tries == 0)
    einfo (_("%P%F: looping in map_segments"));
}

/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldelf64_ia64_vms_before_allocation (void)
{
  const struct elf_backend_data *bed;

  if (!is_elf_hash_table (link_info.hash))
    return;

  bed = get_elf_backend_data (link_info.output_bfd);

  /* The backend must work out the sizes of all the other dynamic
     sections.  */
  if (elf_hash_table (&link_info)->dynamic_sections_created
      && bed->elf_backend_size_dynamic_sections
      && ! (*bed->elf_backend_size_dynamic_sections) (link_info.output_bfd,
                                                      &link_info))
    einfo ("%P%F: failed to set dynamic section sizes: %E\n");

  before_allocation_default ();
}

static void
gldelf64_ia64_vms_after_allocation (void)
{
  int need_layout = bfd_elf_discard_info (link_info.output_bfd, &link_info);

  if (need_layout < 0)
    einfo ("%X%P: .eh_frame/.stab edit: %E\n");
  else
    gldelf64_ia64_vms_map_segments (need_layout);
}

static void
gldelf64_ia64_vms_after_parse (void)
{
  link_info.relax_pass = 2;
  after_parse_default ();
}

static void
need_relax_elf64_ia64_vms_before_allocation (void)
{
  /* Call main function; we're just extending it.  */
  gldelf64_ia64_vms_before_allocation ();

  /* Force -relax on if not doing a relocatable link.  */
  if (!bfd_link_relocatable (&link_info))
    ENABLE_RELAXATION;
}

static char *
gldelf64_ia64_vms_get_script (int *isfile)
{
  *isfile = 0;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return
"/* Script for ld -Ur: link w/out relocation, do create constructors */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-ia64-vms\")\n\
ENTRY(__entry)\n\
SECTIONS\n\
{\n\
  /* RW segment.  */\n\
  $DATA$ ALIGN (0x200) : {\n\
    *($DATA$ .data .data.*)\n\
    *($BSS$ .bss .bss.*)\n\
  }\n\
  /* Code segment.  Note: name must be $CODE$ */\n\
  $CODE$ ALIGN (0x200) : {\n\
    *($CODE$ .text .text.*)\n\
  }\n\
  .plt ALIGN (8) : {\n\
    *(.plt)\n\
  }\n\
  /* RO segment.  */\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x200) : {\n\
    *($LITERAL$)\n"
"    *($READONLY$ .rodata .rodata.*)\n\
    *(.jcr)\n\
    *(.ctors)\n\
    *(.dtors)\n\
    *(.opd)\n\
    *(.gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  /* Short segment.  */\n\
  .srodata : {\n\
    *(.srodata .srodata.*)\n\
  }\n\
  .got ALIGN (8) : {\n\
    *(.got)\n\
  }\n\
  .IA_64.pltoff ALIGN (16) : {\n\
    *(.IA_64.pltoff)\n\
  }\n\
  $TFR$ ALIGN (16) : {\n\
    /* Tranfer vector.  */\n\
    __entry = .;\n"
"    *(.transfer)\n\
  }\n\
  $RW_SHORT$ ALIGN (0x200) : {\n\
    *(.sdata .sdata.*)\n\
    *(.sbss .sbss.*)\n\
  }\n\
  .IA_64.unwind ALIGN (0x200) : {\n\
    *(.IA_64.unwind .IA_64.unwind.*)\n\
  }\n\
  .IA_64.unwind_info ALIGN (8) : {\n\
    *(.IA_64.unwind_info .IA_64.unwind_info.*)\n\
  }\n\
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {\n\
    *(.dynamic)\n\
    *(.vmsdynstr)\n\
    *(.fixups)\n\
  }\n\
  .dynstr : { *(.dynstr) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .rela.got : { *(.rela.got) }\n\
  .got.plt : { *(.got.plt) }\n\
  .gnu.version_d : { *(.gnu.version_d) }\n\
  .gnu.version : { *(.gnu.version) }\n\
  .gnu.version_r : { *(.gnu.version_r) }\n\
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }\n"
"  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n"
"  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .note : { *(.vms.note) }\n\
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }\n\
}\n\n"
  ; else if (bfd_link_relocatable (&link_info)) return
"/* Script for ld -r: link without relocation */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-ia64-vms\")\n\
ENTRY(__entry)\n\
SECTIONS\n\
{\n\
  /* RW segment.  */\n\
  $DATA$ ALIGN (0x200) : {\n\
    *($DATA$ .data .data.*)\n\
    *($BSS$ .bss .bss.*)\n\
  }\n\
  /* Code segment.  Note: name must be $CODE$ */\n\
  $CODE$ ALIGN (0x200) : {\n\
    *($CODE$ .text .text.*)\n\
  }\n\
  .plt ALIGN (8) : {\n\
    *(.plt)\n\
  }\n\
  /* RO segment.  */\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x200) : {\n\
    *($LITERAL$)\n"
"    *($READONLY$ .rodata .rodata.*)\n\
    *(.jcr)\n\
    *(.ctors)\n\
    *(.dtors)\n\
    *(.opd)\n\
    *(.gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  /* Short segment.  */\n\
  .srodata : {\n\
    *(.srodata .srodata.*)\n\
  }\n\
  .got ALIGN (8) : {\n\
    *(.got)\n\
  }\n\
  .IA_64.pltoff ALIGN (16) : {\n\
    *(.IA_64.pltoff)\n\
  }\n\
  $TFR$ ALIGN (16) : {\n\
    /* Tranfer vector.  */\n\
    __entry = .;\n"
"    *(.transfer)\n\
  }\n\
  $RW_SHORT$ ALIGN (0x200) : {\n\
    *(.sdata .sdata.*)\n\
    *(.sbss .sbss.*)\n\
  }\n\
  .IA_64.unwind ALIGN (0x200) : {\n\
    *(.IA_64.unwind .IA_64.unwind.*)\n\
  }\n\
  .IA_64.unwind_info ALIGN (8) : {\n\
    *(.IA_64.unwind_info .IA_64.unwind_info.*)\n\
  }\n\
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {\n\
    *(.dynamic)\n\
    *(.vmsdynstr)\n\
    *(.fixups)\n\
  }\n\
  .dynstr : { *(.dynstr) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .rela.got : { *(.rela.got) }\n\
  .got.plt : { *(.got.plt) }\n\
  .gnu.version_d : { *(.gnu.version_d) }\n\
  .gnu.version : { *(.gnu.version) }\n\
  .gnu.version_r : { *(.gnu.version_r) }\n\
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }\n"
"  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n"
"  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .note : { *(.vms.note) }\n\
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N: mix text and data on same page; don't align data */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-ia64-vms\")\n\
ENTRY(__entry)\n\
SECTIONS\n\
{\n\
  /* RW segment.  */\n\
  . = 0x10000;\n\
  $DATA$ ALIGN (0x200) : {\n\
    *($DATA$ .data .data.*)\n\
    *($BSS$ .bss .bss.*)\n\
  }\n\
  /* Code segment.  Note: name must be $CODE$ */\n\
  . = ALIGN (0x10000);\n\
  $CODE$ ALIGN (0x200) : {\n\
    *($CODE$ .text .text.*)\n\
  }\n\
  .plt ALIGN (8) : {\n\
    *(.plt)\n\
  }\n\
  /* RO segment.  */\n\
  . = ALIGN (0x10000);\n"
"  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x200) : {\n\
    *($LITERAL$)\n\
    *($READONLY$ .rodata .rodata.*)\n\
    *(.jcr)\n\
    *(.ctors)\n\
    *(.dtors)\n\
    *(.opd)\n\
    *(.gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  /* Short segment.  */\n\
  . = ALIGN (0x10000);\n\
  .srodata : {\n\
    *(.srodata .srodata.*)\n\
  }\n\
  .got ALIGN (8) : {\n\
    *(.got)\n\
  }\n\
  .IA_64.pltoff ALIGN (16) : {\n\
    *(.IA_64.pltoff)\n"
"  }\n\
  $TFR$ ALIGN (16) : {\n\
    /* Tranfer vector.  */\n\
    __entry = .;\n\
    *(.transfer)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  $RW_SHORT$ ALIGN (0x200) : {\n\
    *(.sdata .sdata.*)\n\
    *(.sbss .sbss.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .IA_64.unwind ALIGN (0x200) : {\n\
    *(.IA_64.unwind .IA_64.unwind.*)\n\
  }\n\
  .IA_64.unwind_info ALIGN (8) : {\n\
    *(.IA_64.unwind_info .IA_64.unwind_info.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {\n\
    *(.dynamic)\n\
    *(.vmsdynstr)\n\
    *(.fixups)\n\
  }\n\
  . = ALIGN (0x10000);\n"
"  .dynstr : { *(.dynstr) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .rela.got : { *(.rela.got) }\n\
  .got.plt : { *(.got.plt) }\n\
  .gnu.version_d : { *(.gnu.version_d) }\n\
  .gnu.version : { *(.gnu.version) }\n\
  .gnu.version_r : { *(.gnu.version_r) }\n\
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n"
"  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .note : { *(.vms.note) }\n\
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n: mix text and data on same page */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-ia64-vms\")\n\
ENTRY(__entry)\n\
SECTIONS\n\
{\n\
  /* RW segment.  */\n\
  . = 0x10000;\n\
  $DATA$ ALIGN (0x200) : {\n\
    *($DATA$ .data .data.*)\n\
    *($BSS$ .bss .bss.*)\n\
  }\n\
  /* Code segment.  Note: name must be $CODE$ */\n\
  . = ALIGN (0x10000);\n\
  $CODE$ ALIGN (0x200) : {\n\
    *($CODE$ .text .text.*)\n\
  }\n\
  .plt ALIGN (8) : {\n\
    *(.plt)\n\
  }\n\
  /* RO segment.  */\n\
  . = ALIGN (0x10000);\n"
"  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x200) : {\n\
    *($LITERAL$)\n\
    *($READONLY$ .rodata .rodata.*)\n\
    *(.jcr)\n\
    *(.ctors)\n\
    *(.dtors)\n\
    *(.opd)\n\
    *(.gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  /* Short segment.  */\n\
  . = ALIGN (0x10000);\n\
  .srodata : {\n\
    *(.srodata .srodata.*)\n\
  }\n\
  .got ALIGN (8) : {\n\
    *(.got)\n\
  }\n\
  .IA_64.pltoff ALIGN (16) : {\n\
    *(.IA_64.pltoff)\n"
"  }\n\
  $TFR$ ALIGN (16) : {\n\
    /* Tranfer vector.  */\n\
    __entry = .;\n\
    *(.transfer)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  $RW_SHORT$ ALIGN (0x200) : {\n\
    *(.sdata .sdata.*)\n\
    *(.sbss .sbss.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .IA_64.unwind ALIGN (0x200) : {\n\
    *(.IA_64.unwind .IA_64.unwind.*)\n\
  }\n\
  .IA_64.unwind_info ALIGN (8) : {\n\
    *(.IA_64.unwind_info .IA_64.unwind_info.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {\n\
    *(.dynamic)\n\
    *(.vmsdynstr)\n\
    *(.fixups)\n\
  }\n\
  . = ALIGN (0x10000);\n"
"  .dynstr : { *(.dynstr) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .rela.got : { *(.rela.got) }\n\
  .got.plt : { *(.got.plt) }\n\
  .gnu.version_d : { *(.gnu.version_d) }\n\
  .gnu.version : { *(.gnu.version) }\n\
  .gnu.version_r : { *(.gnu.version_r) }\n\
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n"
"  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .note : { *(.vms.note) }\n\
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"elf64-ia64-vms\")\n\
ENTRY(__entry)\n\
SECTIONS\n\
{\n\
  /* RW segment.  */\n\
  . = 0x10000;\n\
  $DATA$ ALIGN (0x200) : {\n\
    *($DATA$ .data .data.*)\n\
    *($BSS$ .bss .bss.*)\n\
  }\n\
  /* Code segment.  Note: name must be $CODE$ */\n\
  . = ALIGN (0x10000);\n\
  $CODE$ ALIGN (0x200) : {\n\
    *($CODE$ .text .text.*)\n\
  }\n\
  .plt ALIGN (8) : {\n\
    *(.plt)\n\
  }\n\
  /* RO segment.  */\n\
  . = ALIGN (0x10000);\n"
"  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x200) : {\n\
    *($LITERAL$)\n\
    *($READONLY$ .rodata .rodata.*)\n\
    *(.jcr)\n\
    *(.ctors)\n\
    *(.dtors)\n\
    *(.opd)\n\
    *(.gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  /* Short segment.  */\n\
  . = ALIGN (0x10000);\n\
  .srodata : {\n\
    *(.srodata .srodata.*)\n\
  }\n\
  .got ALIGN (8) : {\n\
    *(.got)\n\
  }\n\
  .IA_64.pltoff ALIGN (16) : {\n\
    *(.IA_64.pltoff)\n"
"  }\n\
  $TFR$ ALIGN (16) : {\n\
    /* Tranfer vector.  */\n\
    __entry = .;\n\
    *(.transfer)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  $RW_SHORT$ ALIGN (0x200) : {\n\
    *(.sdata .sdata.*)\n\
    *(.sbss .sbss.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .IA_64.unwind ALIGN (0x200) : {\n\
    *(.IA_64.unwind .IA_64.unwind.*)\n\
  }\n\
  .IA_64.unwind_info ALIGN (8) : {\n\
    *(.IA_64.unwind_info .IA_64.unwind_info.*)\n\
  }\n\
  . = ALIGN (0x10000);\n\
  .dynamic /* $DYNAMIC$ */ ALIGN (0x200) : {\n\
    *(.dynamic)\n\
    *(.vmsdynstr)\n\
    *(.fixups)\n\
  }\n\
  . = ALIGN (0x10000);\n"
"  .dynstr : { *(.dynstr) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .rela.got : { *(.rela.got) }\n\
  .got.plt : { *(.got.plt) }\n\
  .gnu.version_d : { *(.gnu.version_d) }\n\
  .gnu.version : { *(.gnu.version) }\n\
  .gnu.version_r : { *(.gnu.version_r) }\n\
  .rela.IA_64.pltoff : { *(.rela.IA_64.pltoff) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line .debug_line.* .debug_line_end ) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n"
"  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /* DWARF 3 */\n\
  .debug_pubtypes 0 : { *(.debug_pubtypes) }\n\
  .debug_ranges   0 : { *(.debug_ranges) }\n\
  /* DWARF Extension.  */\n\
  .debug_macro    0 : { *(.debug_macro) }\n\
  .note : { *(.vms.note) }\n\
  /DISCARD/ : { *(.note) *(.vms_display_name_info) }\n\
}\n\n"
; }

struct ld_emulation_xfer_struct ld_elf64_ia64_vms_emulation =
{
  gldelf64_ia64_vms_before_parse,
  syslib_default,
  hll_default,
  gldelf64_ia64_vms_after_parse,
  after_open_default,
  gldelf64_ia64_vms_after_allocation,
  set_output_arch_default,
  ldemul_default_target,
  need_relax_elf64_ia64_vms_before_allocation,
  gldelf64_ia64_vms_get_script,
  "elf64_ia64_vms",
  "elf64-ia64-vms",
  finish_default,
  gldelf64_ia64_vms_create_output_section_statements,
  gldelf64_ia64_vms_open_dynamic_archive,
  vms_place_orphan,
  NULL,
  NULL,
  gldelf64_ia64_vms_add_options,
  gldelf64_ia64_vms_handle_option,
  NULL,
  gldelf64_ia64_vms_list_options,
  NULL,
  gldelf64_ia64_vms_find_potential_libraries,
  NULL,
  NULL
};
