/* This file is is generated by a shell script.  DO NOT EDIT! */

/* emulate the original gld for the given alphavms
   Copyright (C) 1991-2016 Free Software Foundation, Inc.
   Written by Steve Chamberlain steve@cygnus.com

   This file is part of the GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define TARGET_IS_alphavms

#include "sysdep.h"
#include "bfd.h"
#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"

#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"

#include "getopt.h"

static void
gldalphavms_before_parse (void)
{
  ldfile_set_output_arch ("alpha", bfd_arch_alpha);
  input_flags.dynamic = TRUE;
  config.has_shared = FALSE; /* Not yet.  */

  /* For ia64, harmless for alpha.  */
  link_info.emit_hash = FALSE;
  link_info.spare_dynamic_tags = 0;
}

/* This is called before the input files are opened.  We add the
   standard library.  */

static void
gldalphavms_create_output_section_statements (void)
{
  lang_add_input_file ("imagelib", lang_input_file_is_l_enum, NULL);
  lang_add_input_file ("starlet", lang_input_file_is_l_enum, NULL);
  lang_add_input_file ("sys$public_vectors", lang_input_file_is_l_enum, NULL);
}

/* Try to open a dynamic archive.  This is where we know that VMS
   shared images (dynamic libraries) have an extension of .exe.  */

static bfd_boolean
gldalphavms_open_dynamic_archive (const char *arch ATTRIBUTE_UNUSED,
                                           search_dirs_type *search,
                                           lang_input_statement_type *entry)
{
  char *string;

  if (! entry->flags.maybe_archive || entry->flags.full_name_provided)
    return FALSE;

  string = (char *) xmalloc (strlen (search->name)
			     + strlen (entry->filename)
			     + sizeof "/.exe");

  sprintf (string, "%s/%s.exe", search->name, entry->filename);

  if (! ldfile_try_open_bfd (string, entry))
    {
      free (string);
      return FALSE;
    }

  entry->filename = string;

  return TRUE;
}

static int
gldalphavms_find_potential_libraries
  (char *name, lang_input_statement_type *entry)
{
  return ldfile_open_file_search (name, entry, "", ".olb");
}

/* Place an orphan section.  We use this to put random OVR sections.
   Much borrowed from elf32.em.  */

static lang_output_section_statement_type *
vms_place_orphan (asection *s,
		  const char *secname ATTRIBUTE_UNUSED,
		  int constraint ATTRIBUTE_UNUSED)
{
  static struct orphan_save hold_data =
    {
      "$DATA$",
      SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_DATA,
      0, 0, 0, 0
    };

  /* We have nothing to say for anything other than a final link or an excluded
     section.  */
  if (bfd_link_relocatable (&link_info)
      || (s->flags & (SEC_EXCLUDE | SEC_LOAD)) != SEC_LOAD)
    return NULL;

  /* FIXME: we should place sections by VMS program section flags.  */

  /* Only handle data sections.  */
  if ((s->flags & SEC_DATA) == 0)
    return NULL;

  if (hold_data.os == NULL)
    hold_data.os = lang_output_section_find (hold_data.name);

  if (hold_data.os != NULL)
    {
      lang_add_section (&hold_data.os->children, s, NULL, hold_data.os);
      return hold_data.os;
    }
  else
    return NULL;
}

/* VMS specific options.  */
#define OPTION_IDENTIFICATION		(300  + 1)

static void
gldalphavms_add_options
  (int ns ATTRIBUTE_UNUSED,
   char **shortopts ATTRIBUTE_UNUSED,
   int nl,
   struct option **longopts,
   int nrl ATTRIBUTE_UNUSED,
   struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const struct option xtra_long[] =
  {
    {"identification", required_argument, NULL, OPTION_IDENTIFICATION},
    {NULL, no_argument, NULL, 0}
  };

  *longopts
    = xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

static void
gldalphavms_list_options (FILE *file)
{
  fprintf (file, _("  --identification <string>          Set the identification of the output\n"));
}

static bfd_boolean
gldalphavms_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return FALSE;

    case OPTION_IDENTIFICATION:
      /* Currently ignored.  */
      break;
    }

  return TRUE;
}


static char *
gldalphavms_get_script (int *isfile)
{
  *isfile = 0;

  if (bfd_link_relocatable (&link_info) && config.build_constructors)
    return
"/* Script for ld -Ur: link w/out relocation, do create constructors */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"vms-alpha\")\n\
SECTIONS\n\
{\n\
  /* RW initialized data.  */\n\
  $DATA$ ALIGN (0x10000) : {\n\
    *($DATA$)\n\
  }\n\
  /* RW data unmodified (zero-initialized).  */\n\
  $BSS$ ALIGN (0x10000) : {\n\
    *($BSS$)\n\
  }\n\
  /* RO, executable code.  */\n\
  $CODE$ ALIGN (0x10000) : {\n\
    *($CODE$ *$CODE*)\n\
  }\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x10000) : {\n\
    *($LINK$)\n\
    *($LITERAL$)\n\
    *($READONLY$)\n"
"    *($READONLY_ADDR$)\n\
    *(eh_frame)\n\
    *(jcr)\n\
    *(ctors)\n\
    *(dtors)\n\
    *(gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  $DWARF$ ALIGN (0x10000) : {\n\
    $dwarf2.debug_pubtypes = .;\n\
    *(debug_pubtypes)\n\
    $dwarf2.debug_ranges = .;\n\
    *(debug_ranges)\n\
    $dwarf2.debug_abbrev = .;\n\
    *(debug_abbrev)\n\
    $dwarf2.debug_aranges = .;\n\
    *(debug_aranges)\n\
    $dwarf2.debug_frame = .;\n\
    *(debug_frame)\n\
    $dwarf2.debug_info = .;\n\
    *(debug_info)\n"
"    $dwarf2.debug_line = .;\n\
    *(debug_line)\n\
    $dwarf2.debug_loc = .;\n\
    *(debug_loc)\n\
    $dwarf2.debug_macinfo = .;\n\
    *(debug_macinfo)\n\
    $dwarf2.debug_macro = .;\n\
    *(debug_macro)\n\
    $dwarf2.debug_pubnames = .;\n\
    *(debug_pubnames)\n\
    $dwarf2.debug_str = .;\n\
    *(debug_str)\n\
    $dwarf2.debug_zzzzzz = .;\n\
  }\n\
  $DST$ 0 : {\n\
    *($DST$)\n\
  }\n\
}\n\n"
  ; else if (bfd_link_relocatable (&link_info)) return
"/* Script for ld -r: link without relocation */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"vms-alpha\")\n\
SECTIONS\n\
{\n\
  /* RW initialized data.  */\n\
  $DATA$ ALIGN (0x10000) : {\n\
    *($DATA$)\n\
  }\n\
  /* RW data unmodified (zero-initialized).  */\n\
  $BSS$ ALIGN (0x10000) : {\n\
    *($BSS$)\n\
  }\n\
  /* RO, executable code.  */\n\
  $CODE$ ALIGN (0x10000) : {\n\
    *($CODE$ *$CODE*)\n\
  }\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x10000) : {\n\
    *($LINK$)\n\
    *($LITERAL$)\n\
    *($READONLY$)\n"
"    *($READONLY_ADDR$)\n\
    *(eh_frame)\n\
    *(jcr)\n\
    *(ctors)\n\
    *(dtors)\n\
    *(gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  $DWARF$ ALIGN (0x10000) : {\n\
    $dwarf2.debug_pubtypes = .;\n\
    *(debug_pubtypes)\n\
    $dwarf2.debug_ranges = .;\n\
    *(debug_ranges)\n\
    $dwarf2.debug_abbrev = .;\n\
    *(debug_abbrev)\n\
    $dwarf2.debug_aranges = .;\n\
    *(debug_aranges)\n\
    $dwarf2.debug_frame = .;\n\
    *(debug_frame)\n\
    $dwarf2.debug_info = .;\n\
    *(debug_info)\n"
"    $dwarf2.debug_line = .;\n\
    *(debug_line)\n\
    $dwarf2.debug_loc = .;\n\
    *(debug_loc)\n\
    $dwarf2.debug_macinfo = .;\n\
    *(debug_macinfo)\n\
    $dwarf2.debug_macro = .;\n\
    *(debug_macro)\n\
    $dwarf2.debug_pubnames = .;\n\
    *(debug_pubnames)\n\
    $dwarf2.debug_str = .;\n\
    *(debug_str)\n\
    $dwarf2.debug_zzzzzz = .;\n\
  }\n\
  $DST$ 0 : {\n\
    *($DST$)\n\
  }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N: mix text and data on same page; don't align data */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"vms-alpha\")\n\
SECTIONS\n\
{\n\
  . = 0x10000;\n\
  /* RW initialized data.  */\n\
  $DATA$ ALIGN (0x10000) : {\n\
    *($DATA$)\n\
  }\n\
  /* RW data unmodified (zero-initialized).  */\n\
  $BSS$ ALIGN (0x10000) : {\n\
    *($BSS$)\n\
  }\n\
  /* RO, executable code.  */\n\
  $CODE$ ALIGN (0x10000) : {\n\
    *($CODE$ *$CODE*)\n\
  }\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x10000) : {\n\
    *($LINK$)\n\
    *($LITERAL$)\n"
"    *($READONLY$)\n\
    *($READONLY_ADDR$)\n\
    *(eh_frame)\n\
    *(jcr)\n\
    *(ctors)\n\
    *(dtors)\n\
    *(gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  $DWARF$ ALIGN (0x10000) : {\n\
    $dwarf2.debug_pubtypes = .;\n\
    *(debug_pubtypes)\n\
    $dwarf2.debug_ranges = .;\n\
    *(debug_ranges)\n\
    $dwarf2.debug_abbrev = .;\n\
    *(debug_abbrev)\n\
    $dwarf2.debug_aranges = .;\n\
    *(debug_aranges)\n\
    $dwarf2.debug_frame = .;\n\
    *(debug_frame)\n\
    $dwarf2.debug_info = .;\n"
"    *(debug_info)\n\
    $dwarf2.debug_line = .;\n\
    *(debug_line)\n\
    $dwarf2.debug_loc = .;\n\
    *(debug_loc)\n\
    $dwarf2.debug_macinfo = .;\n\
    *(debug_macinfo)\n\
    $dwarf2.debug_macro = .;\n\
    *(debug_macro)\n\
    $dwarf2.debug_pubnames = .;\n\
    *(debug_pubnames)\n\
    $dwarf2.debug_str = .;\n\
    *(debug_str)\n\
    $dwarf2.debug_zzzzzz = .;\n\
  }\n\
  $DST$ 0 : {\n\
    *($DST$)\n\
  }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n: mix text and data on same page */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"vms-alpha\")\n\
SECTIONS\n\
{\n\
  . = 0x10000;\n\
  /* RW initialized data.  */\n\
  $DATA$ ALIGN (0x10000) : {\n\
    *($DATA$)\n\
  }\n\
  /* RW data unmodified (zero-initialized).  */\n\
  $BSS$ ALIGN (0x10000) : {\n\
    *($BSS$)\n\
  }\n\
  /* RO, executable code.  */\n\
  $CODE$ ALIGN (0x10000) : {\n\
    *($CODE$ *$CODE*)\n\
  }\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x10000) : {\n\
    *($LINK$)\n\
    *($LITERAL$)\n"
"    *($READONLY$)\n\
    *($READONLY_ADDR$)\n\
    *(eh_frame)\n\
    *(jcr)\n\
    *(ctors)\n\
    *(dtors)\n\
    *(gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  $DWARF$ ALIGN (0x10000) : {\n\
    $dwarf2.debug_pubtypes = .;\n\
    *(debug_pubtypes)\n\
    $dwarf2.debug_ranges = .;\n\
    *(debug_ranges)\n\
    $dwarf2.debug_abbrev = .;\n\
    *(debug_abbrev)\n\
    $dwarf2.debug_aranges = .;\n\
    *(debug_aranges)\n\
    $dwarf2.debug_frame = .;\n\
    *(debug_frame)\n\
    $dwarf2.debug_info = .;\n"
"    *(debug_info)\n\
    $dwarf2.debug_line = .;\n\
    *(debug_line)\n\
    $dwarf2.debug_loc = .;\n\
    *(debug_loc)\n\
    $dwarf2.debug_macinfo = .;\n\
    *(debug_macinfo)\n\
    $dwarf2.debug_macro = .;\n\
    *(debug_macro)\n\
    $dwarf2.debug_pubnames = .;\n\
    *(debug_pubnames)\n\
    $dwarf2.debug_str = .;\n\
    *(debug_str)\n\
    $dwarf2.debug_zzzzzz = .;\n\
  }\n\
  $DST$ 0 : {\n\
    *($DST$)\n\
  }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
/* Copyright (C) 2014-2016 Free Software Foundation, Inc.\n\
   Copying and distribution of this script, with or without modification,\n\
   are permitted in any medium without royalty provided the copyright\n\
   notice and this notice are preserved.  */\n\
OUTPUT_FORMAT(\"vms-alpha\")\n\
SECTIONS\n\
{\n\
  . = 0x10000;\n\
  /* RW initialized data.  */\n\
  $DATA$ ALIGN (0x10000) : {\n\
    *($DATA$)\n\
  }\n\
  /* RW data unmodified (zero-initialized).  */\n\
  $BSS$ ALIGN (0x10000) : {\n\
    *($BSS$)\n\
  }\n\
  /* RO, executable code.  */\n\
  $CODE$ ALIGN (0x10000) : {\n\
    *($CODE$ *$CODE*)\n\
  }\n\
  /* RO initialized data.  */\n\
  $LITERAL$ ALIGN (0x10000) : {\n\
    *($LINK$)\n\
    *($LITERAL$)\n"
"    *($READONLY$)\n\
    *($READONLY_ADDR$)\n\
    *(eh_frame)\n\
    *(jcr)\n\
    *(ctors)\n\
    *(dtors)\n\
    *(gcc_except_table)\n\
    /* LIB stuff.  */\n\
    *(LIB$INITIALIZDZ)	/* Start marker.  */\n\
    *(LIB$INITIALIZD_)	/* Hi priority.  */\n\
    *(LIB$INITIALIZE)	/* User.  */\n\
    *(LIB$INITIALIZE$)	/* End marker.  */\n\
  }\n\
  $DWARF$ ALIGN (0x10000) : {\n\
    $dwarf2.debug_pubtypes = .;\n\
    *(debug_pubtypes)\n\
    $dwarf2.debug_ranges = .;\n\
    *(debug_ranges)\n\
    $dwarf2.debug_abbrev = .;\n\
    *(debug_abbrev)\n\
    $dwarf2.debug_aranges = .;\n\
    *(debug_aranges)\n\
    $dwarf2.debug_frame = .;\n\
    *(debug_frame)\n\
    $dwarf2.debug_info = .;\n"
"    *(debug_info)\n\
    $dwarf2.debug_line = .;\n\
    *(debug_line)\n\
    $dwarf2.debug_loc = .;\n\
    *(debug_loc)\n\
    $dwarf2.debug_macinfo = .;\n\
    *(debug_macinfo)\n\
    $dwarf2.debug_macro = .;\n\
    *(debug_macro)\n\
    $dwarf2.debug_pubnames = .;\n\
    *(debug_pubnames)\n\
    $dwarf2.debug_str = .;\n\
    *(debug_str)\n\
    $dwarf2.debug_zzzzzz = .;\n\
  }\n\
  $DST$ 0 : {\n\
    *($DST$)\n\
  }\n\
}\n\n"
; }

struct ld_emulation_xfer_struct ld_alphavms_emulation =
{
  gldalphavms_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  after_open_default,
  after_allocation_default,
  set_output_arch_default,
  ldemul_default_target,
  before_allocation_default,
  gldalphavms_get_script,
  "alphavms",
  "vms-alpha",
  finish_default,
  gldalphavms_create_output_section_statements,
  gldalphavms_open_dynamic_archive,
  vms_place_orphan,
  NULL,
  NULL,
  gldalphavms_add_options,
  gldalphavms_handle_option,
  NULL,
  gldalphavms_list_options,
  NULL,
  gldalphavms_find_potential_libraries,
  NULL,
  NULL
};
