
/**
 * @file onebox_per.h
 * @author 
 * @version 1.0
 *
 * @section LICENSE
 *
 * This software embodies materials and concepts that are confidential to Redpine
 * Signals and is made available solely pursuant to the terms of a written license
 * agreement with Redpine Signals
 *
 * @section DESCRIPTION
 *
 * This file contians the datastructures / macros and function prototypes 
 * related to CW mode in PER driver.
 * 
 */

#ifndef __ONEBOX_PER_H__
#define __ONEBOX_PER_H__

static unsigned short cw_mode_buf_write_array_1[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0 , 0x00FF , 0x0040 , 1 , 0x84EC, 0x0041 , 2 , 0xD0B4 , 0x0042 , 3 , 0xB061 , 0x0043 ,
	4 , 0xFC00 , 0x0043 , 5 , 0xB39E, 0x0043 , 6 , 0xD34B , 0x0042 , 7 , 0x8713 , 0x0041 ,
	8 , 0x0300 , 0x0040 , 9 , 0x7B13, 0x004E , 10 , 0x2F4B , 0x004D , 11 , 0x4F9E , 0x004C ,
	12 , 0x03FF , 0x004C , 13 , 0x4C61 , 0x004C , 14 , 0x2CB4 , 0x004D , 15 , 0x78EC , 0x004E ,
	16 , 0xFCFF , 0x004F , 17 , 0x84EC , 0x0041 , 18 , 0xD0B4 , 0x0042 , 19 , 0xB061 , 0x0043 ,
	20 , 0xFFFF , 0x0043 , 21 , 0xB39E , 0x0043 , 22 , 0xD34B , 0x0042 , 23 , 0x8713 , 0x0041 ,
	24 , 0x0300 , 0x0040 , 25 , 0x7B13 , 0x004E , 26 , 0x2F4B , 0x004D , 27 , 0x4F9E , 0x004C ,
	28 , 0x03FF , 0x004C , 29 , 0x4C61 , 0x004C , 30 , 0x2CB4 , 0x004D , 31 , 0x78EC , 0x004E ,
	32 , 0xFCFF , 0x004F , 33 , 0x84EC , 0x0041 , 34 , 0xD0B4 , 0x0042 , 35 , 0xB061 , 0x0043 ,
	36 , 0xFC00 , 0x0043 , 37 , 0xB39E , 0x0043 , 38 , 0xD34B , 0x0042 , 39 , 0x8713 , 0x0041 ,
	40 , 0xFF00 , 0x004F , 41 , 0x7B13 , 0x004E , 42 , 0x2F4B , 0x004D , 43 , 0x4F9E , 0x004C ,
	44 , 0x03FF , 0x004C , 45 , 0x4C61 , 0x004C , 46 , 0x2CB4 , 0x004D , 47 , 0x78EC , 0x004E ,
	48 , 0xFCFF , 0x004F , 49 , 0x84EC , 0x0041 , 50 , 0xD0B4 , 0x0042 , 51 , 0xB061 , 0x0043 ,
	52 , 0xFFFF , 0x0043 , 53 , 0xB39E , 0x0043 , 54 , 0xD34B , 0x0042 , 55 , 0x8713 , 0x0041 ,
	56 , 0x0300 , 0x0040 , 57 , 0x7B13 , 0x004E , 58 , 0x2F4B , 0x004D , 59 , 0x4F9E , 0x004C ,
	60 , 0x0000 , 0x004C , 61 , 0x4C61 , 0x004C , 62 , 0x2CB4 , 0x004D , 63 , 0x78EC , 0x004E ,
	64 , 0xFCFF , 0x004F , 65 , 0x84EC , 0x0041 , 66 , 0xD0B4 , 0x0042 , 67 , 0xB061 , 0x0043 ,
	68 , 0xFC00 , 0x0043 , 69 , 0xB39E , 0x0043 , 70 , 0xD34B , 0x0042 , 71 , 0x8713 , 0x0041 ,
	72 , 0x0300 , 0x0040 , 73 , 0x7B13 , 0x004E , 74 , 0x2F4B , 0x004D , 75 , 0x4F9E , 0x004C ,
	76 , 0x03FF , 0x004C , 77 , 0x4C61 , 0x004C , 78 , 0x2CB4 , 0x004D , 79 , 0x78EC , 0x004E ,
	80 , 0x00FF , 0x0040 , 81 , 0x84EC , 0x0041 , 82 , 0xD0B4 , 0x0042 , 83 , 0xB061 , 0x0043 ,
	84 , 0xFC00 , 0x0043 , 85 , 0xB39E , 0x0043 , 86 , 0xD34B , 0x0042 , 87 , 0x8713 , 0x0041 ,
	88 , 0x0300 , 0x0040 , 89 , 0x7B13 , 0x004E , 90 , 0x2F4B , 0x004D , 91 , 0x4F9E , 0x004C ,
	92 , 0x03FF , 0x004C , 93 , 0x4C61 , 0x004C , 94 , 0x2CB4 , 0x004D , 95 , 0x78EC , 0x004E ,
	96 , 0xFCFF , 0x004F , 97 , 0x84EC , 0x0041 , 98 , 0xD0B4 , 0x0042 , 99 , 0xB061 , 0x0043 ,
	100 , 0xFFFF , 0x0043 , 101 , 0xB39E , 0x0043 , 102 , 0xD34B , 0x0042 , 103 , 0x8713 , 0x0041 ,
	104 , 0xFF00 , 0x004F , 105 , 0x7B13 , 0x004E , 106 , 0x2F4B , 0x004D , 107 , 0x4F9E , 0x004C ,
	108 , 0x0000 , 0x004C , 109 , 0x4C61 , 0x004C , 110 , 0x2CB4 , 0x004D , 111 , 0x78EC , 0x004E ,
	112 , 0xFCFF , 0x004F , 113 , 0x84EC , 0x0041 , 114 , 0xD0B4 , 0x0042 , 115 , 0xB061 , 0x0043 ,
	116 , 0xFFFF , 0x0043 , 117 , 0xB39E , 0x0043 , 118 , 0xD34B , 0x0042 , 119 , 0x8713 , 0x0041 ,
	120 , 0xFF00 , 0x004F , 121 , 0x7B13 , 0x004E , 122 , 0x2F4B , 0x004D , 123 , 0x4F9E , 0x004C ,
	124 , 0x03FF , 0x004C , 125 , 0x4C61 , 0x004C , 126 , 0x2CB4 , 0x004D , 127 , 0x78EC , 0x004E ,
	128 , 0x00FF , 0x0040 , 129 , 0x84EC , 0x0041 , 130 , 0xD0B4 , 0x0042 , 131 , 0xB061 , 0x0043 ,
	132 , 0xFC00 , 0x0043 , 133 , 0xB39E , 0x0043 , 134 , 0xD34B , 0x0042 , 135 , 0x8713 , 0x0041 ,
	136 , 0x0300 , 0x0040 , 137 , 0x7B13 , 0x004E , 138 , 0x2F4B , 0x004D , 139 , 0x4F9E , 0x004C ,
	140 , 0x03FF , 0x004C , 141 , 0x4C61 , 0x004C , 142 , 0x2CB4 , 0x004D , 143 , 0x78EC , 0x004E ,
	144 , 0xFCFF , 0x004F , 145 , 0x84EC , 0x0041 , 146 , 0xD0B4 , 0x0042 , 147 , 0xB061 , 0x0043 ,
	148 , 0xFFFF , 0x0043 , 149 , 0xB39E , 0x0043 , 150 , 0xD34B , 0x0042 , 151 , 0x8713 , 0x0041 ,
	152 , 0x0300 , 0x0040 , 153 , 0x7B13 , 0x004E , 154 , 0x2F4B , 0x004D , 155 , 0x4F9E , 0x004C ,
	156 , 0x03FF , 0x004C , 157 , 0x4C61 , 0x004C , 158 , 0x2CB4 , 0x004D , 159 , 0x78EC , 0x004E ,
	160 , 0xFCFF , 0x004F , 161 , 0x84EC , 0x0041 , 162 , 0xD0B4 , 0x0042 , 163 , 0xB061 , 0x0043 ,
	164 , 0xFC00 , 0x0043 , 165 , 0xB39E , 0x0043 , 166 , 0xD34B , 0x0042 , 167 , 0x8713 , 0x0041 ,
	168 , 0xFF00 , 0x004F , 169 , 0x7B13 , 0x004E , 170 , 0x2F4B , 0x004D , 171 , 0x4F9E , 0x004C ,
	172 , 0x03FF , 0x004C , 173 , 0x4C61 , 0x004C , 174 , 0x2CB4 , 0x004D , 175 , 0x78EC , 0x004E ,
	176 , 0xFCFF , 0x004F , 177 , 0x84EC , 0x0041 , 178 , 0xD0B4 , 0x0042 , 179 , 0xB061 , 0x0043 ,
	180 , 0xFFFF , 0x0043 , 181 , 0xB39E , 0x0043 , 182 , 0xD34B , 0x0042 , 183 , 0x8713 , 0x0041 ,
	184 , 0x0300 , 0x0040 , 185 , 0x7B13 , 0x004E , 186 , 0x2F4B , 0x004D , 187 , 0x4F9E , 0x004C ,
	188 , 0x0000 , 0x004C , 189 , 0x4C61 , 0x004C , 190 , 0x2CB4 , 0x004D , 191 , 0x78EC , 0x004E ,
	192 , 0xFCFF , 0x004F , 193 , 0x84EC , 0x0041 , 194 , 0xD0B4 , 0x0042 , 195 , 0xB061 , 0x0043 ,
	196 , 0xFC00 , 0x0043 , 197 , 0xB39E , 0x0043 , 198 , 0xD34B , 0x0042 , 199 , 0x8713 , 0x0041 ,
	200 , 0x0300 , 0x0040 , 201 , 0x7B13 , 0x004E , 202 , 0x2F4B , 0x004D , 203 , 0x4F9E , 0x004C ,
	204 , 0x03FF , 0x004C , 205 , 0x4C61 , 0x004C , 206 , 0x2CB4 , 0x004D , 207 , 0x78EC , 0x004E ,
	208 , 0x00FF , 0x0040 , 209 , 0x84EC , 0x0041 , 210 , 0xD0B4 , 0x0042 , 211 , 0xB061 , 0x0043 ,
	212 , 0xFC00 , 0x0043 , 213 , 0xB39E , 0x0043 , 214 , 0xD34B , 0x0042 , 215 , 0x8713 , 0x0041 ,
	216 , 0x0300 , 0x0040 , 217 , 0x7B13 , 0x004E , 218 , 0x2F4B , 0x004D , 219 , 0x4F9E , 0x004C ,
	220 , 0x03FF , 0x004C , 221 , 0x4C61 , 0x004C , 222 , 0x2CB4 , 0x004D , 223 , 0x78EC , 0x004E ,
	224 , 0xFCFF , 0x004F , 225 , 0x84EC , 0x0041 , 226 , 0xD0B4 , 0x0042 , 227 , 0xB061 , 0x0043 ,
	228 , 0xFFFF , 0x0043 , 229 , 0xB39E , 0x0043 , 230 , 0xD34B , 0x0042 , 231 , 0x8713 , 0x0041 ,
	232 , 0xFF00 , 0x004F , 233 , 0x7B13 , 0x004E , 234 , 0x2F4B , 0x004D , 235 , 0x4F9E , 0x004C ,
	236 , 0x0000 , 0x004C , 237 , 0x4C61 , 0x004C , 238 , 0x2CB4 , 0x004D , 239 , 0x78EC , 0x004E ,
	240 , 0xFCFF , 0x004F , 241 , 0x84EC , 0x0041 , 242 , 0xD0B4 , 0x0042 , 243 , 0xB061 , 0x0043 ,
	244 , 0xFFFF , 0x0043 , 245 , 0xB39E , 0x0043 , 246 , 0xD34B , 0x0042 , 247 , 0x8713 , 0x0041 ,
	248 , 0xFF00 , 0x004F , 249 , 0x7B13 , 0x004E , 250 , 0x2F4B , 0x004D , 251 , 0x4F9E , 0x004C ,
	252 , 0x03FF , 0x004C , 253 , 0x4C61 , 0x004C , 254 , 0x2CB4 , 0x004D , 255 , 0x78EC , 0x004E ,
	}; 

static unsigned short cw_mode_buf_write_array_4[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0x0000, 0xC7E9, 0x0041, 0x0001, 0x380B, 0x0041, 0x0002, 0xE817, 0x0040, 0x0003, 0xF802, 0x0040, 
	0x0004, 0xE7F2, 0x0040, 0x0005, 0x5809, 0x0040, 0x0006, 0xD02D, 0x004F, 0x0007, 0xF828, 0x004F, 
	0x0008, 0xA7ED, 0x0040, 0x0009, 0xE3A8, 0x0040, 0x000A, 0x0F94, 0x0040, 0x000B, 0xBFBF, 0x004E, 
	0x000C, 0x1C0B, 0x004E, 0x000D, 0xC84B, 0x004E, 0x000E, 0x2868, 0x0040, 0x000F, 0x2060, 0x0041, 
	0x0010, 0x0C43, 0x0041, 0x0011, 0x282A, 0x0040, 0x0012, 0x3C26, 0x004F, 0x0013, 0xF430, 0x004E, 
	0x0014, 0x7829, 0x004F, 0x0015, 0x4BFD, 0x0040, 0x0016, 0x9FC4, 0x0040, 0x0017, 0x17AE, 0x0040, 
	0x0018, 0x27D2, 0x004F, 0x0019, 0xA80B, 0x004E, 0x001A, 0x0823, 0x004F, 0x001B, 0xB80A, 0x004F, 
	0x001C, 0xEFDF, 0x004F, 0x001D, 0x93C3, 0x004F, 0x001E, 0x77B5, 0x004F, 0x001F, 0x23A1, 0x0040, 
	0x0020, 0x0F8E, 0x0041, 0x0021, 0x2B97, 0x0041, 0x0022, 0x3FBB, 0x0040, 0x0023, 0x63DA, 0x004F, 
	0x0024, 0x9BDA, 0x004F, 0x0025, 0x97D3, 0x0040, 0x0026, 0xF3F5, 0x0040, 0x0027, 0x003D, 0x0040, 
	0x0028, 0xA46D, 0x004E, 0x0029, 0x4851, 0x004E, 0x002A, 0x2809, 0x004F, 0x002B, 0x17E4, 0x0040, 
	0x002C, 0xF401, 0x004F, 0x002D, 0x1823, 0x004F, 0x002E, 0xAC04, 0x004E, 0x002F, 0x53B3, 0x004F, 
	0x0030, 0x5B8E, 0x0040, 0x0031, 0xD7D0, 0x0040, 0x0032, 0x9846, 0x0040, 0x0033, 0x3486, 0x0040, 
	0x0034, 0x0464, 0x0040, 0x0035, 0xD812, 0x004F, 0x0036, 0x9FD9, 0x004F, 0x0037, 0x9FCD, 0x004F, 
	0x0038, 0x27D2, 0x0040, 0x0039, 0xCBDC, 0x0040, 0x003A, 0xBFFE, 0x0040, 0x003B, 0xE43D, 0x004F, 
	0x003C, 0x286E, 0x004F, 0x003D, 0x7860, 0x004F, 0x003E, 0xB01E, 0x0040, 0x003F, 0xB7E7, 0x0041, 
	0x0040, 0xC7E9, 0x0041, 0x0041, 0x380B, 0x0041, 0x0042, 0xE817, 0x0040, 0x0043, 0xF802, 0x0040, 
	0x0044, 0xE7F2, 0x0040, 0x0045, 0x5809, 0x0040, 0x0046, 0xD02D, 0x004F, 0x0047, 0xF828, 0x004F, 
	0x0048, 0xA7ED, 0x0040, 0x0049, 0xE3A8, 0x0040, 0x004A, 0x0F94, 0x0040, 0x004B, 0xBFBF, 0x004E, 
	0x004C, 0x1C0B, 0x004E, 0x004D, 0xC84B, 0x004E, 0x004E, 0x2868, 0x0040, 0x004F, 0x2060, 0x0041, 
	0x0050, 0x0C43, 0x0041, 0x0051, 0x282A, 0x0040, 0x0052, 0x3C26, 0x004F, 0x0053, 0xF430, 0x004E, 
	0x0054, 0x7829, 0x004F, 0x0055, 0x4BFD, 0x0040, 0x0056, 0x9FC4, 0x0040, 0x0057, 0x17AE, 0x0040, 
	0x0058, 0x27D2, 0x004F, 0x0059, 0xA80B, 0x004E, 0x005A, 0x0823, 0x004F, 0x005B, 0xB80A, 0x004F, 
	0x005C, 0xEFDF, 0x004F, 0x005D, 0x93C3, 0x004F, 0x005E, 0x77B5, 0x004F, 0x005F, 0x23A1, 0x0040, 
	0x0060, 0x0F8E, 0x0041, 0x0061, 0x2B97, 0x0041, 0x0062, 0x3FBB, 0x0040, 0x0063, 0x63DA, 0x004F, 
	0x0064, 0x9BDA, 0x004F, 0x0065, 0x97D3, 0x0040, 0x0066, 0xF3F5, 0x0040, 0x0067, 0x003D, 0x0040, 
	0x0068, 0xA46D, 0x004E, 0x0069, 0x4851, 0x004E, 0x006A, 0x2809, 0x004F, 0x006B, 0x17E4, 0x0040, 
	0x006C, 0xF401, 0x004F, 0x006D, 0x1823, 0x004F, 0x006E, 0xAC04, 0x004E, 0x006F, 0x53B3, 0x004F, 
	0x0070, 0x5B8E, 0x0040, 0x0071, 0xD7D0, 0x0040, 0x0072, 0x9846, 0x0040, 0x0073, 0x3486, 0x0040, 
	0x0074, 0x0464, 0x0040, 0x0075, 0xD812, 0x004F, 0x0076, 0x9FD9, 0x004F, 0x0077, 0x9FCD, 0x004F, 
	0x0078, 0x27D2, 0x0040, 0x0079, 0xCBDC, 0x0040, 0x007A, 0xBFFE, 0x0040, 0x007B, 0xE43D, 0x004F, 
	0x007C, 0x286E, 0x004F, 0x007D, 0x7860, 0x004F, 0x007E, 0xB01E, 0x0040, 0x007F, 0xB7E7, 0x0041, 
	0x0080, 0xA416, 0x004F, 0x0081, 0x042A, 0x004F, 0x0082, 0x4016, 0x004E, 0x0083, 0x37E7, 0x004E, 
	0x0084, 0x13CE, 0x004F, 0x0085, 0x07EC, 0x0040, 0x0086, 0x6429, 0x0040, 0x0087, 0x644A, 0x0040, 
	0x0088, 0xC030, 0x0040, 0x0089, 0x7801, 0x0041, 0x008A, 0xD3FB, 0x0041, 0x008B, 0x4029, 0x0041, 
	0x008C, 0x3C59, 0x0040, 0x008D, 0xA05C, 0x004F, 0x008E, 0xBC3D, 0x004F, 0x008F, 0x0827, 0x0040, 
	0x0090, 0x002D, 0x0040, 0x0091, 0xC436, 0x004F, 0x0092, 0xD02A, 0x004F, 0x0093, 0x1415, 0x0040, 
	0x0094, 0x0810, 0x0040, 0x0095, 0x7817, 0x004F, 0x0096, 0xF40A, 0x004E, 0x0097, 0x27E3, 0x004F, 
	0x0098, 0x0BC2, 0x0040, 0x0099, 0xE3CA, 0x0040, 0x009A, 0x0FEE, 0x0041, 0x009B, 0xAC03, 0x0040, 
	0x009C, 0x4403, 0x0040, 0x009D, 0x0C0F, 0x0040, 0x009E, 0xDC3B, 0x004F, 0x009F, 0xA855, 0x004F, 
	0x00A0, 0xA416, 0x004F, 0x00A1, 0xFF89, 0x004F, 0x00A2, 0x6B17, 0x0040, 0x00A3, 0x6726, 0x0040, 
	0x00A4, 0xBBA4, 0x004F, 0x00A5, 0xCC1A, 0x004E, 0x00A6, 0x3C2D, 0x004E, 0x00A7, 0x6BF5, 0x004E, 
	0x00A8, 0x43D0, 0x004F, 0x00A9, 0x57E7, 0x0040, 0x00AA, 0x140F, 0x0041, 0x00AB, 0xEC11, 0x0040, 
	0x00AC, 0xF7F4, 0x004F, 0x00AD, 0x13E8, 0x004F, 0x00AE, 0x4400, 0x004F, 0x00AF, 0xB015, 0x0040, 
	0x00B0, 0x1C00, 0x0042, 0x00B1, 0x33D6, 0x0042, 0x00B2, 0xEBCD, 0x0040, 0x00B3, 0xB3F5, 0x004F, 
	0x00B4, 0xC022, 0x004F, 0x00B5, 0xB021, 0x0040, 0x00B6, 0xFFF8, 0x0040, 0x00B7, 0xF3D7, 0x004F, 
	0x00B8, 0x8BE2, 0x004E, 0x00B9, 0x4C0C, 0x004E, 0x00BA, 0x742B, 0x004F, 0x00BB, 0xB828, 0x0040, 
	0x00BC, 0xEC0A, 0x0040, 0x00BD, 0x3FEA, 0x0040, 0x00BE, 0xB3E0, 0x004F, 0x00BF, 0xB3F3, 0x004F, 
	0x00C0, 0xA416, 0x004F, 0x00C1, 0x042A, 0x004F, 0x00C2, 0x4016, 0x004E, 0x00C3, 0x37E7, 0x004E, 
	0x00C4, 0x13CE, 0x004F, 0x00C5, 0x07EC, 0x0040, 0x00C6, 0x6429, 0x0040, 0x00C7, 0x644A, 0x0040, 
	0x00C8, 0xC030, 0x0040, 0x00C9, 0x7801, 0x0041, 0x00CA, 0xD3FB, 0x0041, 0x00CB, 0x4029, 0x0041, 
	0x00CC, 0x3C59, 0x0040, 0x00CD, 0xA05C, 0x004F, 0x00CE, 0xBC3D, 0x004F, 0x00CF, 0x0827, 0x0040, 
	0x00D0, 0x002D, 0x0040, 0x00D1, 0xC436, 0x004F, 0x00D2, 0xD02A, 0x004F, 0x00D3, 0x1415, 0x0040, 
	0x00D4, 0x0810, 0x0040, 0x00D5, 0x7817, 0x004F, 0x00D6, 0xF40A, 0x004E, 0x00D7, 0x27E3, 0x004F, 
	0x00D8, 0x0BC2, 0x0040, 0x00D9, 0xE3CA, 0x0040, 0x00DA, 0x0FEE, 0x0041, 0x00DB, 0xAC03, 0x0040, 
	0x00DC, 0x4403, 0x0040, 0x00DD, 0x0C0F, 0x0040, 0x00DE, 0xDC3B, 0x004F, 0x00DF, 0xA855, 0x004F, 
	0x00E0, 0xA416, 0x004F, 0x00E1, 0xFF89, 0x004F, 0x00E2, 0x6B17, 0x0040, 0x00E3, 0x6726, 0x0040, 
	0x00E4, 0xBBA4, 0x004F, 0x00E5, 0xCC1A, 0x004E, 0x00E6, 0x3C2D, 0x004E, 0x00E7, 0x6BF5, 0x004E, 
	0x00E8, 0x43D0, 0x004F, 0x00E9, 0x57E7, 0x0040, 0x00EA, 0x140F, 0x0041, 0x00EB, 0xEC11, 0x0040, 
	0x00EC, 0xF7F4, 0x004F, 0x00ED, 0x13E8, 0x004F, 0x00EE, 0x4400, 0x004F, 0x00EF, 0xB015, 0x0040, 
	0x00F0, 0x1C00, 0x0042, 0x00F1, 0x33D6, 0x0042, 0x00F2, 0xEBCD, 0x0040, 0x00F3, 0xB3F5, 0x004F, 
	0x00F4, 0xC022, 0x004F, 0x00F5, 0xB021, 0x0040, 0x00F6, 0xFFF8, 0x0040, 0x00F7, 0xF3D7, 0x004F, 
	0x00F8, 0x8BE2, 0x004E, 0x00F9, 0x4C0C, 0x004E, 0x00FA, 0x742B, 0x004F, 0x00FB, 0xB828, 0x0040, 
	0x00FC, 0xEC0A, 0x0040, 0x00FD, 0x3FEA, 0x0040, 0x00FE, 0xB3E0, 0x004F, 0x00FF, 0xB3F3, 0x004F,
	
	}; 

static unsigned short cw_mode_buf_write_array_3[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0x0000, 0x3000, 0x0043, 0x0001, 0xDC56, 0x0042, 0x0002, 0xF097, 0x0041, 0x0003, 0xB0B3, 0x0040,
	0x0004, 0x78A7, 0x004F, 0x0005, 0x9479, 0x004E, 0x0006, 0x343D, 0x004E, 0x0007, 0x5805, 0x004E,
	0x0008, 0xDFE2, 0x004E, 0x0009, 0x7BDB, 0x004F, 0x000A, 0xEBEC, 0x004F, 0x000B, 0xF809, 0x004F,
	0x000C, 0xA421, 0x004F, 0x000D, 0x1023, 0x004F, 0x000E, 0x7C09, 0x004E, 0x000F, 0x37D6, 0x004E,
	0x0010, 0x6799, 0x004E, 0x0011, 0x2365, 0x004F, 0x0012, 0x474C, 0x0040, 0x0013, 0x8F5A, 0x0041,
	0x0014, 0x9F90, 0x0042, 0x0015, 0x2BE1, 0x0043, 0x0016, 0x0C3B, 0x0043, 0x0017, 0x4C85, 0x0042,
	0x0018, 0x20AE, 0x0041, 0x0019, 0xDCAF, 0x004F, 0x001A, 0xD48B, 0x004E, 0x001B, 0x4451, 0x004E,
	0x001C, 0x4016, 0x004E, 0x001D, 0xAFEA, 0x004E, 0x001E, 0x4BDA, 0x004F, 0x001F, 0xCFE4, 0x004F,
	0x0020, 0x03FF, 0x0040, 0x0021, 0xCC1B, 0x004F, 0x0022, 0x4825, 0x004F, 0x0023, 0xAC15, 0x004E,
	0x0024, 0x43E9, 0x004E, 0x0025, 0x47AE, 0x004E, 0x0026, 0xD774, 0x004E, 0x0027, 0xDF50, 0x004F,
	0x0028, 0x2351, 0x0041, 0x0029, 0x4F7A, 0x0042, 0x002A, 0x0FC4, 0x0043, 0x002B, 0x281E, 0x0043,
	0x002C, 0x9C6F, 0x0042, 0x002D, 0x8CA5, 0x0041, 0x002E, 0x44B3, 0x0040, 0x002F, 0x209A, 0x004F,
	0x0030, 0x6466, 0x004E, 0x0031, 0x3429, 0x004E, 0x0032, 0x7FF6, 0x004E, 0x0033, 0x13DC, 0x004F,
	0x0034, 0xA7DE, 0x004F, 0x0035, 0xFBF6, 0x004F, 0x0036, 0xE813, 0x004F, 0x0037, 0x7824, 0x004F,
	0x0038, 0xDC1D, 0x004E, 0x0039, 0x5BFA, 0x004E, 0x003A, 0x37C2, 0x004E, 0x003B, 0x9786, 0x004E,
	0x003C, 0x7B58, 0x004F, 0x003D, 0xB34C, 0x0040, 0x003E, 0xF368, 0x0041, 0x003F, 0xDFA9, 0x0042,
	0x0040, 0x33FF, 0x0043, 0x0041, 0xDC56, 0x0042, 0x0042, 0xF097, 0x0041, 0x0043, 0xB0B3, 0x0040,
	0x0044, 0x78A7, 0x004F, 0x0045, 0x9479, 0x004E, 0x0046, 0x343D, 0x004E, 0x0047, 0x5805, 0x004E,
	0x0048, 0xDFE2, 0x004E, 0x0049, 0x7BDB, 0x004F, 0x004A, 0xEBEC, 0x004F, 0x004B, 0xF809, 0x004F,
	0x004C, 0xA421, 0x004F, 0x004D, 0x1023, 0x004F, 0x004E, 0x7C09, 0x004E, 0x004F, 0x37D6, 0x004E,
	0x0050, 0x6799, 0x004E, 0x0051, 0x2365, 0x004F, 0x0052, 0x474C, 0x0040, 0x0053, 0x8F5A, 0x0041,
	0x0054, 0x9F90, 0x0042, 0x0055, 0x2BE1, 0x0043, 0x0056, 0x0C3B, 0x0043, 0x0057, 0x4C85, 0x0042,
	0x0058, 0x20AE, 0x0041, 0x0059, 0xDCAF, 0x004F, 0x005A, 0xD48B, 0x004E, 0x005B, 0x4451, 0x004E,
	0x005C, 0x4016, 0x004E, 0x005D, 0xAFEA, 0x004E, 0x005E, 0x4BDA, 0x004F, 0x005F, 0xCFE4, 0x004F,
	0x0060, 0x03FF, 0x0040, 0x0061, 0xCC1B, 0x004F, 0x0062, 0x4825, 0x004F, 0x0063, 0xAC15, 0x004E,
	0x0064, 0x43E9, 0x004E, 0x0065, 0x47AE, 0x004E, 0x0066, 0xD774, 0x004E, 0x0067, 0xDF50, 0x004F,
	0x0068, 0x2351, 0x0041, 0x0069, 0x4F7A, 0x0042, 0x006A, 0x0FC4, 0x0043, 0x006B, 0x281E, 0x0043,
	0x006C, 0x9C6F, 0x0042, 0x006D, 0x8CA5, 0x0041, 0x006E, 0x44B3, 0x0040, 0x006F, 0x209A, 0x004F,
	0x0070, 0x6466, 0x004E, 0x0071, 0x3429, 0x004E, 0x0072, 0x7FF6, 0x004E, 0x0073, 0x13DC, 0x004F,
	0x0074, 0xA7DE, 0x004F, 0x0075, 0xFBF6, 0x004F, 0x0076, 0xE813, 0x004F, 0x0077, 0x7824, 0x004F,
	0x0078, 0xDC1D, 0x004E, 0x0079, 0x5BFA, 0x004E, 0x007A, 0x37C2, 0x004E, 0x007B, 0x9786, 0x004E,
	0x007C, 0x7B58, 0x004F, 0x007D, 0xB34C, 0x0040, 0x007E, 0xF368, 0x0041, 0x007F, 0xDFA9, 0x0042,
	0x0080, 0x3000, 0x0043, 0x0081, 0xDC56, 0x0042, 0x0082, 0xF097, 0x0041, 0x0083, 0xB0B3, 0x0040,
	0x0084, 0x78A7, 0x004F, 0x0085, 0x9479, 0x004E, 0x0086, 0x343D, 0x004E, 0x0087, 0x5805, 0x004E,
	0x0088, 0xDFE2, 0x004E, 0x0089, 0x7BDB, 0x004F, 0x008A, 0xEBEC, 0x004F, 0x008B, 0xF809, 0x004F,
	0x008C, 0xA421, 0x004F, 0x008D, 0x1023, 0x004F, 0x008E, 0x7C09, 0x004E, 0x008F, 0x37D6, 0x004E,
	0x0090, 0x6799, 0x004E, 0x0091, 0x2365, 0x004F, 0x0092, 0x474C, 0x0040, 0x0093, 0x8F5A, 0x0041,
	0x0094, 0x9F90, 0x0042, 0x0095, 0x2BE1, 0x0043, 0x0096, 0x0C3B, 0x0043, 0x0097, 0x4C85, 0x0042,
	0x0098, 0x20AE, 0x0041, 0x0099, 0xDCAF, 0x004F, 0x009A, 0xD48B, 0x004E, 0x009B, 0x4451, 0x004E,
	0x009C, 0x4016, 0x004E, 0x009D, 0xAFEA, 0x004E, 0x009E, 0x4BDA, 0x004F, 0x009F, 0xCFE4, 0x004F,
	0x00A0, 0x03FF, 0x0040, 0x00A1, 0xCC1B, 0x004F, 0x00A2, 0x4825, 0x004F, 0x00A3, 0xAC15, 0x004E,
	0x00A4, 0x43E9, 0x004E, 0x00A5, 0x47AE, 0x004E, 0x00A6, 0xD774, 0x004E, 0x00A7, 0xDF50, 0x004F,
	0x00A8, 0x2351, 0x0041, 0x00A9, 0x4F7A, 0x0042, 0x00AA, 0x0FC4, 0x0043, 0x00AB, 0x281E, 0x0043,
	0x00AC, 0x9C6F, 0x0042, 0x00AD, 0x8CA5, 0x0041, 0x00AE, 0x44B3, 0x0040, 0x00AF, 0x209A, 0x004F,
	0x00B0, 0x6466, 0x004E, 0x00B1, 0x3429, 0x004E, 0x00B2, 0x7FF6, 0x004E, 0x00B3, 0x13DC, 0x004F,
	0x00B4, 0xA7DE, 0x004F, 0x00B5, 0xFBF6, 0x004F, 0x00B6, 0xE813, 0x004F, 0x00B7, 0x7824, 0x004F,
	0x00B8, 0xDC1D, 0x004E, 0x00B9, 0x5BFA, 0x004E, 0x00BA, 0x37C2, 0x004E, 0x00BB, 0x9786, 0x004E,
	0x00BC, 0x7B58, 0x004F, 0x00BD, 0xB34C, 0x0040, 0x00BE, 0xF368, 0x0041, 0x00BF, 0xDFA9, 0x0042,
	0x00C0, 0x33FF, 0x0043, 0x00C1, 0xDC56, 0x0042, 0x00C2, 0xF097, 0x0041, 0x00C3, 0xB0B3, 0x0040,
	0x00C4, 0x78A7, 0x004F, 0x00C5, 0x9479, 0x004E, 0x00C6, 0x343D, 0x004E, 0x00C7, 0x5805, 0x004E,
	0x00C8, 0xDFE2, 0x004E, 0x00C9, 0x7BDB, 0x004F, 0x00CA, 0xEBEC, 0x004F, 0x00CB, 0xF809, 0x004F,
	0x00CC, 0xA421, 0x004F, 0x00CD, 0x1023, 0x004F, 0x00CE, 0x7C09, 0x004E, 0x00CF, 0x37D6, 0x004E,
	0x00D0, 0x6799, 0x004E, 0x00D1, 0x2365, 0x004F, 0x00D2, 0x474C, 0x0040, 0x00D3, 0x8F5A, 0x0041,
	0x00D4, 0x9F90, 0x0042, 0x00D5, 0x2BE1, 0x0043, 0x00D6, 0x0C3B, 0x0043, 0x00D7, 0x4C85, 0x0042,
	0x00D8, 0x20AE, 0x0041, 0x00D9, 0xDCAF, 0x004F, 0x00DA, 0xD48B, 0x004E, 0x00DB, 0x4451, 0x004E,
	0x00DC, 0x4016, 0x004E, 0x00DD, 0xAFEA, 0x004E, 0x00DE, 0x4BDA, 0x004F, 0x00DF, 0xCFE4, 0x004F,
	0x00E0, 0x03FF, 0x0040, 0x00E1, 0xCC1B, 0x004F, 0x00E2, 0x4825, 0x004F, 0x00E3, 0xAC15, 0x004E,
	0x00E4, 0x43E9, 0x004E, 0x00E5, 0x47AE, 0x004E, 0x00E6, 0xD774, 0x004E, 0x00E7, 0xDF50, 0x004F,
	0x00E8, 0x2351, 0x0041, 0x00E9, 0x4F7A, 0x0042, 0x00EA, 0x0FC4, 0x0043, 0x00EB, 0x281E, 0x0043,
	0x00EC, 0x9C6F, 0x0042, 0x00ED, 0x8CA5, 0x0041, 0x00EE, 0x44B3, 0x0040, 0x00EF, 0x209A, 0x004F,
	0x00F0, 0x6466, 0x004E, 0x00F1, 0x3429, 0x004E, 0x00F2, 0x7FF6, 0x004E, 0x00F3, 0x13DC, 0x004F,
	0x00F4, 0xA7DE, 0x004F, 0x00F5, 0xFBF6, 0x004F, 0x00F6, 0xE813, 0x004F, 0x00F7, 0x7824, 0x004F,
	0x00F8, 0xDC1D, 0x004E, 0x00F9, 0x5BFA, 0x004E, 0x00FA, 0x37C2, 0x004E, 0x00FB, 0x9786, 0x004E,
	0x00FC, 0x7B58, 0x004F, 0x00FD, 0xB34C, 0x0040, 0x00FE, 0xF368, 0x0041, 0x00FF, 0xDFA9, 0x0042,
	}; 

static unsigned short cw_mode_buf_write_array_2[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0x0000, 0x9800, 0x0041, 0x0001, 0x2048, 0x0041, 0x0002, 0x0066, 0x0040, 0x0003, 0xDC48, 0x004E,
	0x0004, 0x6400, 0x004E, 0x0005, 0xDFB7, 0x004E, 0x0006, 0xFF99, 0x004F, 0x0007, 0x23B7, 0x0041,
	0x0008, 0x9BFF, 0x0041, 0x0009, 0x2048, 0x0041, 0x000A, 0xFC66, 0x004F, 0x000B, 0xDC48, 0x004E,
	0x000C, 0x6400, 0x004E, 0x000D, 0xDFB7, 0x004E, 0x000E, 0xFF99, 0x004F, 0x000F, 0x23B7, 0x0041,
	0x0010, 0x9BFF, 0x0041, 0x0011, 0x2048, 0x0041, 0x0012, 0x0066, 0x0040, 0x0013, 0xDC48, 0x004E,
	0x0014, 0x67FF, 0x004E, 0x0015, 0xDFB7, 0x004E, 0x0016, 0xFF99, 0x004F, 0x0017, 0x23B7, 0x0041,
	0x0018, 0x9BFF, 0x0041, 0x0019, 0x2048, 0x0041, 0x001A, 0xFC66, 0x004F, 0x001B, 0xDC48, 0x004E,
	0x001C, 0x6400, 0x004E, 0x001D, 0xDFB7, 0x004E, 0x001E, 0x0399, 0x0040, 0x001F, 0x23B7, 0x0041,
	0x0020, 0x9BFF, 0x0041, 0x0021, 0x2048, 0x0041, 0x0022, 0x0066, 0x0040, 0x0023, 0xDC48, 0x004E,
	0x0024, 0x6400, 0x004E, 0x0025, 0xDFB7, 0x004E, 0x0026, 0xFF99, 0x004F, 0x0027, 0x23B7, 0x0041,
	0x0028, 0x9800, 0x0041, 0x0029, 0x2048, 0x0041, 0x002A, 0x0066, 0x0040, 0x002B, 0xDC48, 0x004E,
	0x002C, 0x6400, 0x004E, 0x002D, 0xDFB7, 0x004E, 0x002E, 0xFF99, 0x004F, 0x002F, 0x23B7, 0x0041,
	0x0030, 0x9BFF, 0x0041, 0x0031, 0x2048, 0x0041, 0x0032, 0xFC66, 0x004F, 0x0033, 0xDC48, 0x004E,
	0x0034, 0x67FF, 0x004E, 0x0035, 0xDFB7, 0x004E, 0x0036, 0x0399, 0x0040, 0x0037, 0x23B7, 0x0041,
	0x0038, 0x9BFF, 0x0041, 0x0039, 0x2048, 0x0041, 0x003A, 0xFC66, 0x004F, 0x003B, 0xDC48, 0x004E,
	0x003C, 0x67FF, 0x004E, 0x003D, 0xDFB7, 0x004E, 0x003E, 0xFF99, 0x004F, 0x003F, 0x23B7, 0x0041,
	0x0040, 0x9BFF, 0x0041, 0x0041, 0x2048, 0x0041, 0x0042, 0x0066, 0x0040, 0x0043, 0xDC48, 0x004E,
	0x0044, 0x6400, 0x004E, 0x0045, 0xDFB7, 0x004E, 0x0046, 0x0399, 0x0040, 0x0047, 0x23B7, 0x0041,
	0x0048, 0x9BFF, 0x0041, 0x0049, 0x2048, 0x0041, 0x004A, 0x0066, 0x0040, 0x004B, 0xDC48, 0x004E,
	0x004C, 0x6400, 0x004E, 0x004D, 0xDFB7, 0x004E, 0x004E, 0x0399, 0x0040, 0x004F, 0x23B7, 0x0041,
	0x0050, 0x9800, 0x0041, 0x0051, 0x2048, 0x0041, 0x0052, 0xFC66, 0x004F, 0x0053, 0xDC48, 0x004E,
	0x0054, 0x6400, 0x004E, 0x0055, 0xDFB7, 0x004E, 0x0056, 0xFF99, 0x004F, 0x0057, 0x23B7, 0x0041,
	0x0058, 0x9BFF, 0x0041, 0x0059, 0x2048, 0x0041, 0x005A, 0x0066, 0x0040, 0x005B, 0xDC48, 0x004E,
	0x005C, 0x6400, 0x004E, 0x005D, 0xDFB7, 0x004E, 0x005E, 0x0399, 0x0040, 0x005F, 0x23B7, 0x0041,
	0x0060, 0x9BFF, 0x0041, 0x0061, 0x2048, 0x0041, 0x0062, 0x0066, 0x0040, 0x0063, 0xDC48, 0x004E,
	0x0064, 0x67FF, 0x004E, 0x0065, 0xDFB7, 0x004E, 0x0066, 0xFF99, 0x004F, 0x0067, 0x23B7, 0x0041,
	0x0068, 0x9800, 0x0041, 0x0069, 0x2048, 0x0041, 0x006A, 0x0066, 0x0040, 0x006B, 0xDC48, 0x004E,
	0x006C, 0x67FF, 0x004E, 0x006D, 0xDFB7, 0x004E, 0x006E, 0xFF99, 0x004F, 0x006F, 0x23B7, 0x0041,
	0x0070, 0x9BFF, 0x0041, 0x0071, 0x2048, 0x0041, 0x0072, 0x0066, 0x0040, 0x0073, 0xDC48, 0x004E,
	0x0074, 0x67FF, 0x004E, 0x0075, 0xDFB7, 0x004E, 0x0076, 0xFF99, 0x004F, 0x0077, 0x23B7, 0x0041,
	0x0078, 0x9800, 0x0041, 0x0079, 0x2048, 0x0041, 0x007A, 0x0066, 0x0040, 0x007B, 0xDC48, 0x004E,
	0x007C, 0x6400, 0x004E, 0x007D, 0xDFB7, 0x004E, 0x007E, 0x0399, 0x0040, 0x007F, 0x23B7, 0x0041,
	0x0080, 0x9800, 0x0041, 0x0081, 0x2048, 0x0041, 0x0082, 0x0066, 0x0040, 0x0083, 0xDC48, 0x004E,
	0x0084, 0x6400, 0x004E, 0x0085, 0xDFB7, 0x004E, 0x0086, 0xFF99, 0x004F, 0x0087, 0x23B7, 0x0041,
	0x0088, 0x9BFF, 0x0041, 0x0089, 0x2048, 0x0041, 0x008A, 0xFC66, 0x004F, 0x008B, 0xDC48, 0x004E,
	0x008C, 0x6400, 0x004E, 0x008D, 0xDFB7, 0x004E, 0x008E, 0xFF99, 0x004F, 0x008F, 0x23B7, 0x0041,
	0x0090, 0x9BFF, 0x0041, 0x0091, 0x2048, 0x0041, 0x0092, 0x0066, 0x0040, 0x0093, 0xDC48, 0x004E,
	0x0094, 0x67FF, 0x004E, 0x0095, 0xDFB7, 0x004E, 0x0096, 0xFF99, 0x004F, 0x0097, 0x23B7, 0x0041,
	0x0098, 0x9BFF, 0x0041, 0x0099, 0x2048, 0x0041, 0x009A, 0xFC66, 0x004F, 0x009B, 0xDC48, 0x004E,
	0x009C, 0x6400, 0x004E, 0x009D, 0xDFB7, 0x004E, 0x009E, 0x0399, 0x0040, 0x009F, 0x23B7, 0x0041,
	0x00A0, 0x9BFF, 0x0041, 0x00A1, 0x2048, 0x0041, 0x00A2, 0x0066, 0x0040, 0x00A3, 0xDC48, 0x004E,
	0x00A4, 0x6400, 0x004E, 0x00A5, 0xDFB7, 0x004E, 0x00A6, 0xFF99, 0x004F, 0x00A7, 0x23B7, 0x0041,
	0x00A8, 0x9800, 0x0041, 0x00A9, 0x2048, 0x0041, 0x00AA, 0x0066, 0x0040, 0x00AB, 0xDC48, 0x004E,
	0x00AC, 0x6400, 0x004E, 0x00AD, 0xDFB7, 0x004E, 0x00AE, 0xFF99, 0x004F, 0x00AF, 0x23B7, 0x0041,
	0x00B0, 0x9BFF, 0x0041, 0x00B1, 0x2048, 0x0041, 0x00B2, 0xFC66, 0x004F, 0x00B3, 0xDC48, 0x004E,
	0x00B4, 0x67FF, 0x004E, 0x00B5, 0xDFB7, 0x004E, 0x00B6, 0x0399, 0x0040, 0x00B7, 0x23B7, 0x0041,
	0x00B8, 0x9BFF, 0x0041, 0x00B9, 0x2048, 0x0041, 0x00BA, 0xFC66, 0x004F, 0x00BB, 0xDC48, 0x004E,
	0x00BC, 0x67FF, 0x004E, 0x00BD, 0xDFB7, 0x004E, 0x00BE, 0xFF99, 0x004F, 0x00BF, 0x23B7, 0x0041,
	0x00C0, 0x9BFF, 0x0041, 0x00C1, 0x2048, 0x0041, 0x00C2, 0x0066, 0x0040, 0x00C3, 0xDC48, 0x004E,
	0x00C4, 0x6400, 0x004E, 0x00C5, 0xDFB7, 0x004E, 0x00C6, 0x0399, 0x0040, 0x00C7, 0x23B7, 0x0041,
	0x00C8, 0x9BFF, 0x0041, 0x00C9, 0x2048, 0x0041, 0x00CA, 0x0066, 0x0040, 0x00CB, 0xDC48, 0x004E,
	0x00CC, 0x6400, 0x004E, 0x00CD, 0xDFB7, 0x004E, 0x00CE, 0x0399, 0x0040, 0x00CF, 0x23B7, 0x0041,
	0x00D0, 0x9800, 0x0041, 0x00D1, 0x2048, 0x0041, 0x00D2, 0xFC66, 0x004F, 0x00D3, 0xDC48, 0x004E,
	0x00D4, 0x6400, 0x004E, 0x00D5, 0xDFB7, 0x004E, 0x00D6, 0xFF99, 0x004F, 0x00D7, 0x23B7, 0x0041,
	0x00D8, 0x9BFF, 0x0041, 0x00D9, 0x2048, 0x0041, 0x00DA, 0x0066, 0x0040, 0x00DB, 0xDC48, 0x004E,
	0x00DC, 0x6400, 0x004E, 0x00DD, 0xDFB7, 0x004E, 0x00DE, 0x0399, 0x0040, 0x00DF, 0x23B7, 0x0041,
	0x00E0, 0x9BFF, 0x0041, 0x00E1, 0x2048, 0x0041, 0x00E2, 0x0066, 0x0040, 0x00E3, 0xDC48, 0x004E,
	0x00E4, 0x67FF, 0x004E, 0x00E5, 0xDFB7, 0x004E, 0x00E6, 0xFF99, 0x004F, 0x00E7, 0x23B7, 0x0041,
	0x00E8, 0x9800, 0x0041, 0x00E9, 0x2048, 0x0041, 0x00EA, 0x0066, 0x0040, 0x00EB, 0xDC48, 0x004E,
	0x00EC, 0x67FF, 0x004E, 0x00ED, 0xDFB7, 0x004E, 0x00EE, 0xFF99, 0x004F, 0x00EF, 0x23B7, 0x0041,
	0x00F0, 0x9BFF, 0x0041, 0x00F1, 0x2048, 0x0041, 0x00F2, 0x0066, 0x0040, 0x00F3, 0xDC48, 0x004E,
	0x00F4, 0x67FF, 0x004E, 0x00F5, 0xDFB7, 0x004E, 0x00F6, 0xFF99, 0x004F, 0x00F7, 0x23B7, 0x0041,
	0x00F8, 0x9800, 0x0041, 0x00F9, 0x2048, 0x0041, 0x00FA, 0x0066, 0x0040, 0x00FB, 0xDC48, 0x004E,
	0x00FC, 0x6400, 0x004E, 0x00FD, 0xDFB7, 0x004E, 0x00FE, 0x0399, 0x0040, 0x00FF, 0x23B7, 0x0041,
	}; 

static unsigned short cw_mode_buf_write_array_5[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0x0000, 0xC7E9, 0x0041, 0x0001, 0x380B, 0x0041, 0x0002, 0xE817, 0x0040, 0x0003, 0xF802, 0x0040,
	0x0004, 0xE7F2, 0x0040, 0x0005, 0x5809, 0x0040, 0x0006, 0xD02D, 0x004F, 0x0007, 0xF828, 0x004F,
	0x0008, 0xA7ED, 0x0040, 0x0009, 0xE3A8, 0x0040, 0x000A, 0x0F94, 0x0040, 0x000B, 0xBFBF, 0x004E,
	0x000C, 0x1C0B, 0x004E, 0x000D, 0xC84B, 0x004E, 0x000E, 0x2868, 0x0040, 0x000F, 0x2060, 0x0041,
	0x0010, 0x0C43, 0x0041, 0x0011, 0x282A, 0x0040, 0x0012, 0x3C26, 0x004F, 0x0013, 0xF430, 0x004E,
	0x0014, 0x7829, 0x004F, 0x0015, 0x4BFD, 0x0040, 0x0016, 0x9FC4, 0x0040, 0x0017, 0x17AE, 0x0040,
	0x0018, 0x27D2, 0x004F, 0x0019, 0xA80B, 0x004E, 0x001A, 0x0823, 0x004F, 0x001B, 0xB80A, 0x004F,
	0x001C, 0xEFDF, 0x004F, 0x001D, 0x93C3, 0x004F, 0x001E, 0x77B5, 0x004F, 0x001F, 0x23A1, 0x0040,
	0x0020, 0x0F8E, 0x0041, 0x0021, 0x2B97, 0x0041, 0x0022, 0x3FBB, 0x0040, 0x0023, 0x63DA, 0x004F,
	0x0024, 0x9BDA, 0x004F, 0x0025, 0x97D3, 0x0040, 0x0026, 0xF3F5, 0x0040, 0x0027, 0x003D, 0x0040,
	0x0028, 0xA46D, 0x004E, 0x0029, 0x4851, 0x004E, 0x002A, 0x2809, 0x004F, 0x002B, 0x17E4, 0x0040,
	0x002C, 0xF401, 0x004F, 0x002D, 0x1823, 0x004F, 0x002E, 0xAC04, 0x004E, 0x002F, 0x53B3, 0x004F,
	0x0030, 0x5B8E, 0x0040, 0x0031, 0xD7D0, 0x0040, 0x0032, 0x9846, 0x0040, 0x0033, 0x3486, 0x0040,
	0x0034, 0x0464, 0x0040, 0x0035, 0xD812, 0x004F, 0x0036, 0x9FD9, 0x004F, 0x0037, 0x9FCD, 0x004F,
	0x0038, 0x27D2, 0x0040, 0x0039, 0xCBDC, 0x0040, 0x003A, 0xBFFE, 0x0040, 0x003B, 0xE43D, 0x004F,
	0x003C, 0x286E, 0x004F, 0x003D, 0x7860, 0x004F, 0x003E, 0xB01E, 0x0040, 0x003F, 0xB7E7, 0x0041,
	0x0040, 0xC7E9, 0x0041, 0x0041, 0x380B, 0x0041, 0x0042, 0xE817, 0x0040, 0x0043, 0xF802, 0x0040,
	0x0044, 0xE7F2, 0x0040, 0x0045, 0x5809, 0x0040, 0x0046, 0xD02D, 0x004F, 0x0047, 0xF828, 0x004F,
	0x0048, 0xA7ED, 0x0040, 0x0049, 0xE3A8, 0x0040, 0x004A, 0x0F94, 0x0040, 0x004B, 0xBFBF, 0x004E,
	0x004C, 0x1C0B, 0x004E, 0x004D, 0xC84B, 0x004E, 0x004E, 0x2868, 0x0040, 0x004F, 0x2060, 0x0041,
	0x0050, 0x0C43, 0x0041, 0x0051, 0x282A, 0x0040, 0x0052, 0x3C26, 0x004F, 0x0053, 0xF430, 0x004E,
	0x0054, 0x7829, 0x004F, 0x0055, 0x4BFD, 0x0040, 0x0056, 0x9FC4, 0x0040, 0x0057, 0x17AE, 0x0040,
	0x0058, 0x27D2, 0x004F, 0x0059, 0xA80B, 0x004E, 0x005A, 0x0823, 0x004F, 0x005B, 0xB80A, 0x004F,
	0x005C, 0xEFDF, 0x004F, 0x005D, 0x93C3, 0x004F, 0x005E, 0x77B5, 0x004F, 0x005F, 0x23A1, 0x0040,
	0x0060, 0x0F8E, 0x0041, 0x0061, 0x2B97, 0x0041, 0x0062, 0x3FBB, 0x0040, 0x0063, 0x63DA, 0x004F,
	0x0064, 0x9BDA, 0x004F, 0x0065, 0x97D3, 0x0040, 0x0066, 0xF3F5, 0x0040, 0x0067, 0x003D, 0x0040,
	0x0068, 0xA46D, 0x004E, 0x0069, 0x4851, 0x004E, 0x006A, 0x2809, 0x004F, 0x006B, 0x17E4, 0x0040,
	0x006C, 0xF401, 0x004F, 0x006D, 0x1823, 0x004F, 0x006E, 0xAC04, 0x004E, 0x006F, 0x53B3, 0x004F,
	0x0070, 0x5B8E, 0x0040, 0x0071, 0xD7D0, 0x0040, 0x0072, 0x9846, 0x0040, 0x0073, 0x3486, 0x0040,
	0x0074, 0x0464, 0x0040, 0x0075, 0xD812, 0x004F, 0x0076, 0x9FD9, 0x004F, 0x0077, 0x9FCD, 0x004F,
	0x0078, 0x27D2, 0x0040, 0x0079, 0xCBDC, 0x0040, 0x007A, 0xBFFE, 0x0040, 0x007B, 0xE43D, 0x004F,
	0x007C, 0x286E, 0x004F, 0x007D, 0x7860, 0x004F, 0x007E, 0xB01E, 0x0040, 0x007F, 0xB7E7, 0x0041,
	0x0080, 0xA416, 0x004F, 0x0081, 0x042A, 0x004F, 0x0082, 0x4016, 0x004E, 0x0083, 0x37E7, 0x004E,
	0x0084, 0x13CE, 0x004F, 0x0085, 0x07EC, 0x0040, 0x0086, 0x6429, 0x0040, 0x0087, 0x644A, 0x0040,
	0x0088, 0xC030, 0x0040, 0x0089, 0x7801, 0x0041, 0x008A, 0xD3FB, 0x0041, 0x008B, 0x4029, 0x0041,
	0x008C, 0x3C59, 0x0040, 0x008D, 0xA05C, 0x004F, 0x008E, 0xBC3D, 0x004F, 0x008F, 0x0827, 0x0040,
	0x0090, 0x002D, 0x0040, 0x0091, 0xC436, 0x004F, 0x0092, 0xD02A, 0x004F, 0x0093, 0x1415, 0x0040,
	0x0094, 0x0810, 0x0040, 0x0095, 0x7817, 0x004F, 0x0096, 0xF40A, 0x004E, 0x0097, 0x27E3, 0x004F,
	0x0098, 0x0BC2, 0x0040, 0x0099, 0xE3CA, 0x0040, 0x009A, 0x0FEE, 0x0041, 0x009B, 0xAC03, 0x0040,
	0x009C, 0x4403, 0x0040, 0x009D, 0x0C0F, 0x0040, 0x009E, 0xDC3B, 0x004F, 0x009F, 0xA855, 0x004F,
	0x00A0, 0xA416, 0x004F, 0x00A1, 0xFF89, 0x004F, 0x00A2, 0x6B17, 0x0040, 0x00A3, 0x6726, 0x0040,
	0x00A4, 0xBBA4, 0x004F, 0x00A5, 0xCC1A, 0x004E, 0x00A6, 0x3C2D, 0x004E, 0x00A7, 0x6BF5, 0x004E,
	0x00A8, 0x43D0, 0x004F, 0x00A9, 0x57E7, 0x0040, 0x00AA, 0x140F, 0x0041, 0x00AB, 0xEC11, 0x0040,
	0x00AC, 0xF7F4, 0x004F, 0x00AD, 0x13E8, 0x004F, 0x00AE, 0x4400, 0x004F, 0x00AF, 0xB015, 0x0040,
	0x00B0, 0x1C00, 0x0042, 0x00B1, 0x33D6, 0x0042, 0x00B2, 0xEBCD, 0x0040, 0x00B3, 0xB3F5, 0x004F,
	0x00B4, 0xC022, 0x004F, 0x00B5, 0xB021, 0x0040, 0x00B6, 0xFFF8, 0x0040, 0x00B7, 0xF3D7, 0x004F,
	0x00B8, 0x8BE2, 0x004E, 0x00B9, 0x4C0C, 0x004E, 0x00BA, 0x742B, 0x004F, 0x00BB, 0xB828, 0x0040,
	0x00BC, 0xEC0A, 0x0040, 0x00BD, 0x3FEA, 0x0040, 0x00BE, 0xB3E0, 0x004F, 0x00BF, 0xB3F3, 0x004F,
	0x00C0, 0xA416, 0x004F, 0x00C1, 0x042A, 0x004F, 0x00C2, 0x4016, 0x004E, 0x00C3, 0x37E7, 0x004E,
	0x00C4, 0x13CE, 0x004F, 0x00C5, 0x07EC, 0x0040, 0x00C6, 0x6429, 0x0040, 0x00C7, 0x644A, 0x0040,
	0x00C8, 0xC030, 0x0040, 0x00C9, 0x7801, 0x0041, 0x00CA, 0xD3FB, 0x0041, 0x00CB, 0x4029, 0x0041,
	0x00CC, 0x3C59, 0x0040, 0x00CD, 0xA05C, 0x004F, 0x00CE, 0xBC3D, 0x004F, 0x00CF, 0x0827, 0x0040,
	0x00D0, 0x002D, 0x0040, 0x00D1, 0xC436, 0x004F, 0x00D2, 0xD02A, 0x004F, 0x00D3, 0x1415, 0x0040,
	0x00D4, 0x0810, 0x0040, 0x00D5, 0x7817, 0x004F, 0x00D6, 0xF40A, 0x004E, 0x00D7, 0x27E3, 0x004F,
	0x00D8, 0x0BC2, 0x0040, 0x00D9, 0xE3CA, 0x0040, 0x00DA, 0x0FEE, 0x0041, 0x00DB, 0xAC03, 0x0040,
	0x00DC, 0x4403, 0x0040, 0x00DD, 0x0C0F, 0x0040, 0x00DE, 0xDC3B, 0x004F, 0x00DF, 0xA855, 0x004F,
	0x00E0, 0xA416, 0x004F, 0x00E1, 0xFF89, 0x004F, 0x00E2, 0x6B17, 0x0040, 0x00E3, 0x6726, 0x0040,
	0x00E4, 0xBBA4, 0x004F, 0x00E5, 0xCC1A, 0x004E, 0x00E6, 0x3C2D, 0x004E, 0x00E7, 0x6BF5, 0x004E,
	0x00E8, 0x43D0, 0x004F, 0x00E9, 0x57E7, 0x0040, 0x00EA, 0x140F, 0x0041, 0x00EB, 0xEC11, 0x0040,
	0x00EC, 0xF7F4, 0x004F, 0x00ED, 0x13E8, 0x004F, 0x00EE, 0x4400, 0x004F, 0x00EF, 0xB015, 0x0040,
	0x00F0, 0x1C00, 0x0042, 0x00F1, 0x33D6, 0x0042, 0x00F2, 0xEBCD, 0x0040, 0x00F3, 0xB3F5, 0x004F,
	0x00F4, 0xC022, 0x004F, 0x00F5, 0xB021, 0x0040, 0x00F6, 0xFFF8, 0x0040, 0x00F7, 0xF3D7, 0x004F,
	0x00F8, 0x8BE2, 0x004E, 0x00F9, 0x4C0C, 0x004E, 0x00FA, 0x742B, 0x004F, 0x00FB, 0xB828, 0x0040,
	0x00FC, 0xEC0A, 0x0040, 0x00FD, 0x3FEA, 0x0040, 0x00FE, 0xB3E0, 0x004F, 0x00FF, 0xB3F3, 0x004F,
	}; 
unsigned short cw_mode_buf_write_dc_tone[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	0x0000 ,0xe400 ,0x0041, 0x0001 ,0xe400 ,0x0041, 0x0002 ,0xe400 ,0x0041, 0x0003 ,0xe400 ,0x0041,
	0x0004 ,0xe400 ,0x0041, 0x0005 ,0xe400 ,0x0041, 0x0006 ,0xe400 ,0x0041, 0x0007 ,0xe400 ,0x0041,
	0x0008 ,0xe400 ,0x0041, 0x0009 ,0xe400 ,0x0041, 0x000a ,0xe400 ,0x0041, 0x000b ,0xe400 ,0x0041,
	0x000c ,0xe400 ,0x0041, 0x000d ,0xe400 ,0x0041, 0x000e ,0xe400 ,0x0041, 0x000f ,0xe400 ,0x0041,
	0x0010 ,0xe400 ,0x0041, 0x0011 ,0xe400 ,0x0041, 0x0012 ,0xe400 ,0x0041, 0x0013 ,0xe400 ,0x0041,
	0x0014 ,0xe400 ,0x0041, 0x0015 ,0xe400 ,0x0041, 0x0016 ,0xe400 ,0x0041, 0x0017 ,0xe400 ,0x0041,
	0x0018 ,0xe400 ,0x0041, 0x0019 ,0xe400 ,0x0041, 0x001a ,0xe400 ,0x0041, 0x001b ,0xe400 ,0x0041,
	0x001c ,0xe400 ,0x0041, 0x001d ,0xe400 ,0x0041, 0x001e ,0xe400 ,0x0041, 0x001f ,0xe400 ,0x0041,
	0x0020 ,0xe400 ,0x0041, 0x0021 ,0xe400 ,0x0041, 0x0022 ,0xe400 ,0x0041, 0x0023 ,0xe400 ,0x0041,
	0x0024 ,0xe400 ,0x0041, 0x0025 ,0xe400 ,0x0041, 0x0026 ,0xe400 ,0x0041, 0x0027 ,0xe400 ,0x0041,
	0x0028 ,0xe400 ,0x0041, 0x0029 ,0xe400 ,0x0041, 0x002a ,0xe400 ,0x0041, 0x002b ,0xe400 ,0x0041,
	0x002c ,0xe400 ,0x0041, 0x002d ,0xe400 ,0x0041, 0x002e ,0xe400 ,0x0041, 0x002f ,0xe400 ,0x0041,
	0x0030 ,0xe400 ,0x0041, 0x0031 ,0xe400 ,0x0041, 0x0032 ,0xe400 ,0x0041, 0x0033 ,0xe400 ,0x0041,
	0x0034 ,0xe400 ,0x0041, 0x0035 ,0xe400 ,0x0041, 0x0036 ,0xe400 ,0x0041, 0x0037 ,0xe400 ,0x0041,
	0x0038 ,0xe400 ,0x0041, 0x0039 ,0xe400 ,0x0041, 0x003a ,0xe400 ,0x0041, 0x003b ,0xe400 ,0x0041,
	0x003c ,0xe400 ,0x0041, 0x003d ,0xe400 ,0x0041, 0x003e ,0xe400 ,0x0041, 0x003f ,0xe400 ,0x0041,
	0x0040 ,0xe400 ,0x0041, 0x0041 ,0xe400 ,0x0041, 0x0042 ,0xe400 ,0x0041, 0x0043 ,0xe400 ,0x0041,
	0x0044 ,0xe400 ,0x0041, 0x0045 ,0xe400 ,0x0041, 0x0046 ,0xe400 ,0x0041, 0x0047 ,0xe400 ,0x0041,
	0x0048 ,0xe400 ,0x0041, 0x0049 ,0xe400 ,0x0041, 0x004a ,0xe400 ,0x0041, 0x004b ,0xe400 ,0x0041,
	0x004c ,0xe400 ,0x0041, 0x004d ,0xe400 ,0x0041, 0x004e ,0xe400 ,0x0041, 0x004f ,0xe400 ,0x0041,
	0x0050 ,0xe400 ,0x0041, 0x0051 ,0xe400 ,0x0041, 0x0052 ,0xe400 ,0x0041, 0x0053 ,0xe400 ,0x0041,
	0x0054 ,0xe400 ,0x0041, 0x0055 ,0xe400 ,0x0041, 0x0056 ,0xe400 ,0x0041, 0x0057 ,0xe400 ,0x0041,
	0x0058 ,0xe400 ,0x0041, 0x0059 ,0xe400 ,0x0041, 0x005a ,0xe400 ,0x0041, 0x005b ,0xe400 ,0x0041,
	0x005c ,0xe400 ,0x0041, 0x005d ,0xe400 ,0x0041, 0x005e ,0xe400 ,0x0041, 0x005f ,0xe400 ,0x0041,
	0x0060 ,0xe400 ,0x0041, 0x0061 ,0xe400 ,0x0041, 0x0062 ,0xe400 ,0x0041, 0x0063 ,0xe400 ,0x0041,
	0x0064 ,0xe400 ,0x0041, 0x0065 ,0xe400 ,0x0041, 0x0066 ,0xe400 ,0x0041, 0x0067 ,0xe400 ,0x0041,
	0x0068 ,0xe400 ,0x0041, 0x0069 ,0xe400 ,0x0041, 0x006a ,0xe400 ,0x0041, 0x006b ,0xe400 ,0x0041,
	0x006c ,0xe400 ,0x0041, 0x006d ,0xe400 ,0x0041, 0x006e ,0xe400 ,0x0041, 0x006f ,0xe400 ,0x0041,
	0x0070 ,0xe400 ,0x0041, 0x0071 ,0xe400 ,0x0041, 0x0072 ,0xe400 ,0x0041, 0x0073 ,0xe400 ,0x0041,
	0x0074 ,0xe400 ,0x0041, 0x0075 ,0xe400 ,0x0041, 0x0076 ,0xe400 ,0x0041, 0x0077 ,0xe400 ,0x0041,
	0x0078 ,0xe400 ,0x0041, 0x0079 ,0xe400 ,0x0041, 0x007a ,0xe400 ,0x0041, 0x007b ,0xe400 ,0x0041,
	0x007c ,0xe400 ,0x0041, 0x007d ,0xe400 ,0x0041, 0x007e ,0xe400 ,0x0041, 0x007f ,0xe400 ,0x0041,
	0x0080 ,0xe400 ,0x0041, 0x0081 ,0xe400 ,0x0041, 0x0082 ,0xe400 ,0x0041, 0x0083 ,0xe400 ,0x0041,
	0x0084 ,0xe400 ,0x0041, 0x0085 ,0xe400 ,0x0041, 0x0086 ,0xe400 ,0x0041, 0x0087 ,0xe400 ,0x0041,
	0x0088 ,0xe400 ,0x0041, 0x0089 ,0xe400 ,0x0041, 0x008a ,0xe400 ,0x0041, 0x008b ,0xe400 ,0x0041,
	0x008c ,0xe400 ,0x0041, 0x008d ,0xe400 ,0x0041, 0x008e ,0xe400 ,0x0041, 0x008f ,0xe400 ,0x0041,
	0x0090 ,0xe400 ,0x0041, 0x0091 ,0xe400 ,0x0041, 0x0092 ,0xe400 ,0x0041, 0x0093 ,0xe400 ,0x0041,
	0x0094 ,0xe400 ,0x0041, 0x0095 ,0xe400 ,0x0041, 0x0096 ,0xe400 ,0x0041, 0x0097 ,0xe400 ,0x0041,
	0x0098 ,0xe400 ,0x0041, 0x0099 ,0xe400 ,0x0041, 0x009a ,0xe400 ,0x0041, 0x009b ,0xe400 ,0x0041,
	0x009c ,0xe400 ,0x0041, 0x009d ,0xe400 ,0x0041, 0x009e ,0xe400 ,0x0041, 0x009f ,0xe400 ,0x0041,
	0x00a0 ,0xe400 ,0x0041, 0x00a1 ,0xe400 ,0x0041, 0x00a2 ,0xe400 ,0x0041, 0x00a3 ,0xe400 ,0x0041,
	0x00a4 ,0xe400 ,0x0041, 0x00a5 ,0xe400 ,0x0041, 0x00a6 ,0xe400 ,0x0041, 0x00a7 ,0xe400 ,0x0041,
	0x00a8 ,0xe400 ,0x0041, 0x00a9 ,0xe400 ,0x0041, 0x00aa ,0xe400 ,0x0041, 0x00ab ,0xe400 ,0x0041,
	0x00ac ,0xe400 ,0x0041, 0x00ad ,0xe400 ,0x0041, 0x00ae ,0xe400 ,0x0041, 0x00af ,0xe400 ,0x0041,
	0x00b0 ,0xe400 ,0x0041, 0x00b1 ,0xe400 ,0x0041, 0x00b2 ,0xe400 ,0x0041, 0x00b3 ,0xe400 ,0x0041,
	0x00b4 ,0xe400 ,0x0041, 0x00b5 ,0xe400 ,0x0041, 0x00b6 ,0xe400 ,0x0041, 0x00b7 ,0xe400 ,0x0041,
	0x00b8 ,0xe400 ,0x0041, 0x00b9 ,0xe400 ,0x0041, 0x00ba ,0xe400 ,0x0041, 0x00bb ,0xe400 ,0x0041,
	0x00bc ,0xe400 ,0x0041, 0x00bd ,0xe400 ,0x0041, 0x00be ,0xe400 ,0x0041, 0x00bf ,0xe400 ,0x0041,
	0x00c0 ,0xe400 ,0x0041, 0x00c1 ,0xe400 ,0x0041, 0x00c2 ,0xe400 ,0x0041, 0x00c3 ,0xe400 ,0x0041,
	0x00c4 ,0xe400 ,0x0041, 0x00c5 ,0xe400 ,0x0041, 0x00c6 ,0xe400 ,0x0041, 0x00c7 ,0xe400 ,0x0041,
	0x00c8 ,0xe400 ,0x0041, 0x00c9 ,0xe400 ,0x0041, 0x00ca ,0xe400 ,0x0041, 0x00cb ,0xe400 ,0x0041,
	0x00cc ,0xe400 ,0x0041, 0x00cd ,0xe400 ,0x0041, 0x00ce ,0xe400 ,0x0041, 0x00cf ,0xe400 ,0x0041,
	0x00d0 ,0xe400 ,0x0041, 0x00d1 ,0xe400 ,0x0041, 0x00d2 ,0xe400 ,0x0041, 0x00d3 ,0xe400 ,0x0041,
	0x00d4 ,0xe400 ,0x0041, 0x00d5 ,0xe400 ,0x0041, 0x00d6 ,0xe400 ,0x0041, 0x00d7 ,0xe400 ,0x0041,
	0x00d8 ,0xe400 ,0x0041, 0x00d9 ,0xe400 ,0x0041, 0x00da ,0xe400 ,0x0041, 0x00db ,0xe400 ,0x0041,
	0x00dc ,0xe400 ,0x0041, 0x00dd ,0xe400 ,0x0041, 0x00de ,0xe400 ,0x0041, 0x00df ,0xe400 ,0x0041,
	0x00e0 ,0xe400 ,0x0041, 0x00e1 ,0xe400 ,0x0041, 0x00e2 ,0xe400 ,0x0041, 0x00e3 ,0xe400 ,0x0041,
	0x00e4 ,0xe400 ,0x0041, 0x00e5 ,0xe400 ,0x0041, 0x00e6 ,0xe400 ,0x0041, 0x00e7 ,0xe400 ,0x0041,
	0x00e8 ,0xe400 ,0x0041, 0x00e9 ,0xe400 ,0x0041, 0x00ea ,0xe400 ,0x0041, 0x00eb ,0xe400 ,0x0041,
	0x00ec ,0xe400 ,0x0041, 0x00ed ,0xe400 ,0x0041, 0x00ee ,0xe400 ,0x0041, 0x00ef ,0xe400 ,0x0041,
	0x00f0 ,0xe400 ,0x0041, 0x00f1 ,0xe400 ,0x0041, 0x00f2 ,0xe400 ,0x0041, 0x00f3 ,0xe400 ,0x0041,
	0x00f4 ,0xe400 ,0x0041, 0x00f5 ,0xe400 ,0x0041, 0x00f6 ,0xe400 ,0x0041, 0x00f7 ,0xe400 ,0x0041,
	0x00f8 ,0xe400 ,0x0041, 0x00f9 ,0xe400 ,0x0041, 0x00fa ,0xe400 ,0x0041, 0x00fb ,0xe400 ,0x0041,
	0x00fc ,0xe400 ,0x0041, 0x00fd ,0xe400 ,0x0041, 0x00fe ,0xe400 ,0x0041, 0x00ff ,0xe400 ,0x0041,
};

static unsigned short cw_mode_buf_write_array_6[] = {
	0x07, 0x000, 0x0315, 0x0316, 0x0317, 0x0100,
	}; 
#endif
