# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is machine-generated by lib/unicore/mktables from the Unicode
# database, Version 7.0.0.  Any changes made here will be lost!

use strict;
use warnings;

# Test qr/\X/ and the \p{} regular expression constructs.  This file is
# constructed by mktables from the tables it generates, so if mktables is
# buggy, this won't necessarily catch those bugs.  Tests are generated for all
# feasible properties; a few aren't currently feasible; see
# is_code_point_usable() in mktables for details.

# Standard test packages are not used because this manipulates SIG_WARN.  It
# exits 0 if every non-skipped test succeeded; -1 if any failed.

my $Tests = 0;
my $Fails = 0;

sub Expect($$$$) {
    my $expected = shift;
    my $ord = shift;
    my $regex  = shift;
    my $warning_type = shift;   # Type of warning message, like 'deprecated'
                                # or empty if none
    my $line   = (caller)[2];

    # Convert the code point to hex form
    my $string = sprintf "\"\\x{%04X}\"", $ord;

    my @tests = "";

    # The first time through, use all warnings.  If the input should generate
    # a warning, add another time through with them turned off
    push @tests, "no warnings '$warning_type';" if $warning_type;

    foreach my $no_warnings (@tests) {

        # Store any warning messages instead of outputting them
        local $SIG{__WARN__} = $SIG{__WARN__};
        my $warning_message;
        $SIG{__WARN__} = sub { $warning_message = $_[0] };

        $Tests++;

        # A string eval is needed because of the 'no warnings'.
        # Assumes no parens in the regular expression
        my $result = eval "$no_warnings
                            my \$RegObj = qr($regex);
                            $string =~ \$RegObj ? 1 : 0";
        if (not defined $result) {
            print "not ok $Tests - couldn't compile /$regex/; line $line: $@\n";
            $Fails++;
        }
        elsif ($result ^ $expected) {
            print "not ok $Tests - expected $expected but got $result for $string =~ qr/$regex/; line $line\n";
            $Fails++;
        }
        elsif ($warning_message) {
            if (! $warning_type || ($warning_type && $no_warnings)) {
                print "not ok $Tests - for qr/$regex/ did not expect warning message '$warning_message'; line $line\n";
                $Fails++;
            }
            else {
                print "ok $Tests - expected and got a warning message for qr/$regex/; line $line\n";
            }
        }
        elsif ($warning_type && ! $no_warnings) {
            print "not ok $Tests - for qr/$regex/ expected a $warning_type warning message, but got none; line $line\n";
            $Fails++;
        }
        else {
            print "ok $Tests - got $result for $string =~ qr/$regex/; line $line\n";
        }
    }
    return;
}

sub Error($) {
    my $regex  = shift;
    $Tests++;
    if (eval { 'x' =~ qr/$regex/; 1 }) {
        $Fails++;
        my $line = (caller)[2];
        print "not ok $Tests - re compiled ok, but expected error for qr/$regex/; line $line: $@\n";
    }
    else {
        my $line = (caller)[2];
        print "ok $Tests - got and expected error for qr/$regex/; line $line\n";
    }
    return;
}

# Break test files (e.g. GCBTest.txt) character that break allowed here
my $breakable_utf8 = my $breakable = chr(utf8::unicode_to_native(0xF7));
utf8::upgrade($breakable_utf8);

# Break test files (e.g. GCBTest.txt) character that indicates can't break
# here
my $nobreak_utf8 = my $nobreak = chr(utf8::unicode_to_native(0xD7));
utf8::upgrade($nobreak_utf8);

use Config;
my $utf8_locale;
chdir 't' if -d 't';
eval { require "./loc_tools.pl" };
$utf8_locale = &find_utf8_ctype_locale if defined &find_utf8_ctype_locale;

sub _test_break($$) {
    # Test qr/\X/ matches.  The input is a line from auxiliary/GCBTest.txt
    # Each such line is a sequence of code points given by their hex numbers,
    # separated by the two characters defined just before this subroutine that
    # indicate that either there can or cannot be a break between the adjacent
    # code points.  If there isn't a break, that means the sequence forms an
    # extended grapheme cluster, which means that \X should match the whole
    # thing.  If there is a break, \X should stop there.  This is all
    # converted by this routine into a match:
    #   $string =~ /(\X)/,
    # Each \X should match the next cluster; and that is what is checked.

    my $template = shift;
    my $break_type = shift;

    my $line   = (caller 1)[2];   # Line number

    # The line contains characters above the ASCII range, but in Latin1.  It
    # may or may not be in utf8, and if it is, it may or may not know it.  So,
    # convert these characters to 8 bits.  If knows is in utf8, simply
    # downgrade.
    if (utf8::is_utf8($template)) {
        utf8::downgrade($template);
    } else {

        # Otherwise, if it is in utf8, but doesn't know it, the next lines
        # convert the two problematic characters to their 8-bit equivalents.
        # If it isn't in utf8, they don't harm anything.
        use bytes;
        $template =~ s/$nobreak_utf8/$nobreak/g;
        $template =~ s/$breakable_utf8/$breakable/g;
    }

    # The input is just the break/no-break symbols and sequences of Unicode
    # code points as hex digits separated by spaces for legibility. e.g.:
    # ÷ 0020 × 0308 ÷ 0020 ÷
    # Convert to native \x format
    $template =~ s/ \s* ( [[:xdigit:]]+ ) \s* /sprintf("\\x{%02X}", utf8::unicode_to_native(hex $1))/gex;
    $template =~ s/ \s* //gx;   # Probably the line above removed all spaces;
                                # but be sure

    # Make a copy of the input with the symbols replaced by \b{} and \B{} as
    # appropriate
    my $break_pattern = $template =~ s/ $breakable /\\b{$break_type}/grx;
    $break_pattern =~ s/ $nobreak /\\B{$break_type}/gx;

    my $display_string = $template =~ s/[$breakable$nobreak]//gr;
    my $string = eval "\"$display_string\"";

    # The remaining massaging of the input is for the \X tests.  Get rid of
    # the leading and trailing breakables
    $template =~ s/^ \s* $breakable \s* //x;
    $template =~ s/ \s* $breakable \s* $ //x;

    # Delete no-breaks
    $template =~ s/ \s* $nobreak \s* //xg;

    # Split the input into segments that are breakable between them.
    my @should_display = split /\s*$breakable\s*/, $template;
    my @should_match = map { eval "\"$_\"" } @should_display;

    # If a string can be represented in both non-ut8 and utf8, test both cases
    my $display_upgrade = "";
    UPGRADE:
    for my $to_upgrade (0 .. 1) {

        if ($to_upgrade) {

            # If already in utf8, would just be a repeat
            next UPGRADE if utf8::is_utf8($string);

            utf8::upgrade($string);
            $display_upgrade = " (utf8-upgraded)";
        }

        # The /l modifier has C after it to indicate the locale to try
        my @modifiers = qw(a aa d lC u i);
        push @modifiers, "l$utf8_locale" if defined $utf8_locale;

        # Test for each of the regex modifiers.
        for my $modifier (@modifiers) {
            my $display_locale = "";

            # For /l, set the locale to what it says to.
            if ($modifier =~ / ^ l (.*) /x) {
                my $locale = $1;
                $display_locale = "(locale = $locale)";
                use Config;
                if (defined $Config{d_setlocale}) {
                    eval { require POSIX; import POSIX 'locale_h'; };
                    if (defined &POSIX::LC_CTYPE) {
                        POSIX::setlocale(&POSIX::LC_CTYPE, $locale);
                    }
                }
                $modifier = 'l';
            }

            no warnings qw(locale regexp surrogate);
            my $pattern = "(?$modifier:$break_pattern)";

            # Actually do the test
            my $matched = $string =~ qr/$pattern/;
            print "not " unless $matched;

            # Fancy display of test results
            $matched = ($matched) ? "matched" : "failed to match";
            print "ok ", ++$Tests, " - \"$display_string\" $matched /$pattern/$display_upgrade; line $line $display_locale\n";

            # Repeat with the first \B{} in the pattern.  This makes sure the
            # code in regexec.c:find_byclass() for \B gets executed
            if ($pattern =~ / ( .*? : ) .* ( \\B\{ .* ) /x) {
                my $B_pattern = "$1$2";
                $matched = $string =~ qr/$B_pattern/;
                print "not " unless $matched;
                print "ok ", ++$Tests, " - \"$display_string\" $matched /$B_pattern/$display_upgrade; line $line $display_locale\n";
            }
        }

        next if $break_type ne 'gcb';

        # Finally, do the \X match.
        my @matches = $string =~ /(\X)/g;

        # Look through each matched cluster to verify that it matches what we
        # expect.
        my $min = (@matches < @should_match) ? @matches : @should_match;
        for my $i (0 .. $min - 1) {
            $Tests++;
            if ($matches[$i] eq $should_match[$i]) {
                print "ok $Tests - ";
                if ($i == 0) {
                    print "In \"$display_string\" =~ /(\\X)/g, \\X #1";
                } else {
                    print "And \\X #", $i + 1,
                }
                print " correctly matched $should_display[$i]; line $line\n";
            } else {
                $matches[$i] = join("", map { sprintf "\\x{%04X}", $_ }
                                                    split "", $matches[$i]);
                print "not ok $Tests - In \"$display_string\" =~ /(\\X)/g, \\X #",
                    $i + 1,
                    " should have matched $should_display[$i]",
                    " but instead matched $matches[$i]",
                    ".  Abandoning rest of line $line\n";
                next UPGRADE;
            }
        }

        # And the number of matches should equal the number of expected matches.
        $Tests++;
        if (@matches == @should_match) {
            print "ok $Tests - Nothing was left over; line $line\n";
        } else {
            print "not ok $Tests - There were ", scalar @should_match, " \\X matches expected, but got ", scalar @matches, " instead; line $line\n";
        }
    }

    return;
}

sub Test_GCB($) {
    _test_break(shift, 'gcb');
}

sub Test_SB($) {
    _test_break(shift, 'sb');
}

sub Test_WB($) {
    _test_break(shift, 'wb');
}

sub Finished() {
    print "1..$Tests\n";
    exit($Fails ? -1 : 0);
}

Error('\p{Script=InGreek}');    # Bug #69018
Test_GCB("1100 $nobreak 1161");  # Bug #70940
Expect(0, 0x2028, '\p{Print}', ""); # Bug # 71722
Expect(0, 0x2029, '\p{Print}', ""); # Bug # 71722
Expect(1, 0xFF10, '\p{XDigit}', ""); # Bug # 71726
Error('\p{ASCII_Hex_Digit=:=	No}');
Error('\P{ASCII_Hex_Digit=:=	No}');
Expect(1, 103, '\p{ASCII_Hex_Digit=no}', "");
Expect(0, 103, '\p{^ASCII_Hex_Digit=no}', "");
Expect(0, 103, '\P{ASCII_Hex_Digit=no}', "");
Expect(1, 103, '\P{^ASCII_Hex_Digit=no}', "");
Expect(0, 102, '\p{ASCII_Hex_Digit=no}', "");
Expect(1, 102, '\p{^ASCII_Hex_Digit=no}', "");
Expect(1, 102, '\P{ASCII_Hex_Digit=no}', "");
Expect(0, 102, '\P{^ASCII_Hex_Digit=no}', "");
Expect(1, 103, '\p{ASCII_Hex_Digit=--No}', "");
Expect(0, 103, '\p{^ASCII_Hex_Digit=--No}', "");
Expect(0, 103, '\P{ASCII_Hex_Digit=--No}', "");
Expect(1, 103, '\P{^ASCII_Hex_Digit=--No}', "");
Expect(0, 102, '\p{ASCII_Hex_Digit=--No}', "");
Expect(1, 102, '\p{^ASCII_Hex_Digit=--No}', "");
Expect(1, 102, '\P{ASCII_Hex_Digit=--No}', "");
Expect(0, 102, '\P{^ASCII_Hex_Digit=--No}', "");
Error('\p{AHex=		N:=}');
Error('\P{AHex=		N:=}');
Expect(1, 103, '\p{AHex=n}', "");
Expect(0, 103, '\p{^AHex=n}', "");
Expect(0, 103, '\P{AHex=n}', "");
Expect(1, 103, '\P{^AHex=n}', "");
Expect(0, 102, '\p{AHex=n}', "");
Expect(1, 102, '\p{^AHex=n}', "");
Expect(1, 102, '\P{AHex=n}', "");
Expect(0, 102, '\P{^AHex=n}', "");
Expect(1, 103, '\p{AHex:	N}', "");
Expect(0, 103, '\p{^AHex:	N}', "");
Expect(0, 103, '\P{AHex:	N}', "");
Expect(1, 103, '\P{^AHex:	N}', "");
Expect(0, 102, '\p{AHex:	N}', "");
Expect(1, 102, '\p{^AHex:	N}', "");
Expect(1, 102, '\P{AHex:	N}', "");
Expect(0, 102, '\P{^AHex:	N}', "");
Error('\p{Is_ASCII_Hex_Digit=/a/		F}');
Error('\P{Is_ASCII_Hex_Digit=/a/		F}');
Expect(1, 103, '\p{Is_ASCII_Hex_Digit=f}', "");
Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=f}', "");
Expect(0, 103, '\P{Is_ASCII_Hex_Digit=f}', "");
Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=f}', "");
Expect(0, 102, '\p{Is_ASCII_Hex_Digit=f}', "");
Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=f}', "");
Expect(1, 102, '\P{Is_ASCII_Hex_Digit=f}', "");
Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=f}', "");
Expect(1, 103, '\p{Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 103, '\p{^Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 103, '\P{Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 103, '\P{^Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 102, '\p{Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 102, '\p{^Is_ASCII_Hex_Digit=-F}', "");
Expect(1, 102, '\P{Is_ASCII_Hex_Digit=-F}', "");
Expect(0, 102, '\P{^Is_ASCII_Hex_Digit=-F}', "");
Error('\p{Is_AHex=		False/a/}');
Error('\P{Is_AHex=		False/a/}');
Expect(1, 103, '\p{Is_AHex=false}', "");
Expect(0, 103, '\p{^Is_AHex=false}', "");
Expect(0, 103, '\P{Is_AHex=false}', "");
Expect(1, 103, '\P{^Is_AHex=false}', "");
Expect(0, 102, '\p{Is_AHex=false}', "");
Expect(1, 102, '\p{^Is_AHex=false}', "");
Expect(1, 102, '\P{Is_AHex=false}', "");
Expect(0, 102, '\P{^Is_AHex=false}', "");
Expect(1, 103, '\p{Is_AHex=_-false}', "");
Expect(0, 103, '\p{^Is_AHex=_-false}', "");
Expect(0, 103, '\P{Is_AHex=_-false}', "");
Expect(1, 103, '\P{^Is_AHex=_-false}', "");
Expect(0, 102, '\p{Is_AHex=_-false}', "");
Expect(1, 102, '\p{^Is_AHex=_-false}', "");
Expect(1, 102, '\P{Is_AHex=_-false}', "");
Expect(0, 102, '\P{^Is_AHex=_-false}', "");
Error('\p{ASCII_Hex_Digit=_ YES:=}');
Error('\P{ASCII_Hex_Digit=_ YES:=}');
Expect(1, 102, '\p{ASCII_Hex_Digit=yes}', "");
Expect(0, 102, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(0, 102, '\P{ASCII_Hex_Digit=yes}', "");
Expect(1, 102, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(0, 103, '\p{ASCII_Hex_Digit=yes}', "");
Expect(1, 103, '\p{^ASCII_Hex_Digit=yes}', "");
Expect(1, 103, '\P{ASCII_Hex_Digit=yes}', "");
Expect(0, 103, '\P{^ASCII_Hex_Digit=yes}', "");
Expect(1, 102, '\p{ASCII_Hex_Digit=_	yes}', "");
Expect(0, 102, '\p{^ASCII_Hex_Digit=_	yes}', "");
Expect(0, 102, '\P{ASCII_Hex_Digit=_	yes}', "");
Expect(1, 102, '\P{^ASCII_Hex_Digit=_	yes}', "");
Expect(0, 103, '\p{ASCII_Hex_Digit=_	yes}', "");
Expect(1, 103, '\p{^ASCII_Hex_Digit=_	yes}', "");
Expect(1, 103, '\P{ASCII_Hex_Digit=_	yes}', "");
Expect(0, 103, '\P{^ASCII_Hex_Digit=_	yes}', "");
Error('\p{AHex:   /a/	Y}');
Error('\P{AHex:   /a/	Y}');
Expect(1, 102, '\p{AHex=y}', "");
Expect(0, 102, '\p{^AHex=y}', "");
Expect(0, 102, '\P{AHex=y}', "");
Expect(1, 102, '\P{^AHex=y}', "");
Expect(0, 103, '\p{AHex=y}', "");
Expect(1, 103, '\p{^AHex=y}', "");
Expect(1, 103, '\P{AHex=y}', "");
Expect(0, 103, '\P{^AHex=y}', "");
Expect(1, 102, '\p{AHex= y}', "");
Expect(0, 102, '\p{^AHex= y}', "");
Expect(0, 102, '\P{AHex= y}', "");
Expect(1, 102, '\P{^AHex= y}', "");
Expect(0, 103, '\p{AHex= y}', "");
Expect(1, 103, '\p{^AHex= y}', "");
Expect(1, 103, '\P{AHex= y}', "");
Expect(0, 103, '\P{^AHex= y}', "");
Error('\p{Is_ASCII_Hex_Digit::=-	T}');
Error('\P{Is_ASCII_Hex_Digit::=-	T}');
Expect(1, 102, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 102, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 102, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 102, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(0, 103, '\p{Is_ASCII_Hex_Digit=t}', "");
Expect(1, 103, '\p{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 103, '\P{Is_ASCII_Hex_Digit=t}', "");
Expect(0, 103, '\P{^Is_ASCII_Hex_Digit=t}', "");
Expect(1, 102, '\p{Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 102, '\p{^Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 102, '\P{Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 102, '\P{^Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 103, '\p{Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 103, '\p{^Is_ASCII_Hex_Digit:  T}', "");
Expect(1, 103, '\P{Is_ASCII_Hex_Digit:  T}', "");
Expect(0, 103, '\P{^Is_ASCII_Hex_Digit:  T}', "");
Error('\p{Is_AHex=	:=True}');
Error('\P{Is_AHex=	:=True}');
Expect(1, 102, '\p{Is_AHex=true}', "");
Expect(0, 102, '\p{^Is_AHex=true}', "");
Expect(0, 102, '\P{Is_AHex=true}', "");
Expect(1, 102, '\P{^Is_AHex=true}', "");
Expect(0, 103, '\p{Is_AHex=true}', "");
Expect(1, 103, '\p{^Is_AHex=true}', "");
Expect(1, 103, '\P{Is_AHex=true}', "");
Expect(0, 103, '\P{^Is_AHex=true}', "");
Expect(1, 102, '\p{Is_AHex=_	True}', "");
Expect(0, 102, '\p{^Is_AHex=_	True}', "");
Expect(0, 102, '\P{Is_AHex=_	True}', "");
Expect(1, 102, '\P{^Is_AHex=_	True}', "");
Expect(0, 103, '\p{Is_AHex=_	True}', "");
Expect(1, 103, '\p{^Is_AHex=_	True}', "");
Expect(1, 103, '\P{Is_AHex=_	True}', "");
Expect(0, 103, '\P{^Is_AHex=_	True}', "");
Error('\p{Alphabetic= No:=}');
Error('\P{Alphabetic= No:=}');
Expect(1, 195102, '\p{Alphabetic=no}', "");
Expect(0, 195102, '\p{^Alphabetic=no}', "");
Expect(0, 195102, '\P{Alphabetic=no}', "");
Expect(1, 195102, '\P{^Alphabetic=no}', "");
Expect(0, 195101, '\p{Alphabetic=no}', "");
Expect(1, 195101, '\p{^Alphabetic=no}', "");
Expect(1, 195101, '\P{Alphabetic=no}', "");
Expect(0, 195101, '\P{^Alphabetic=no}', "");
Expect(1, 195102, '\p{Alphabetic:   -_No}', "");
Expect(0, 195102, '\p{^Alphabetic:   -_No}', "");
Expect(0, 195102, '\P{Alphabetic:   -_No}', "");
Expect(1, 195102, '\P{^Alphabetic:   -_No}', "");
Expect(0, 195101, '\p{Alphabetic:   -_No}', "");
Expect(1, 195101, '\p{^Alphabetic:   -_No}', "");
Expect(1, 195101, '\P{Alphabetic:   -_No}', "");
Expect(0, 195101, '\P{^Alphabetic:   -_No}', "");
Error('\p{Alpha=-_n/a/}');
Error('\P{Alpha=-_n/a/}');
Expect(1, 195102, '\p{Alpha=n}', "");
Expect(0, 195102, '\p{^Alpha=n}', "");
Expect(0, 195102, '\P{Alpha=n}', "");
Expect(1, 195102, '\P{^Alpha=n}', "");
Expect(0, 195101, '\p{Alpha=n}', "");
Expect(1, 195101, '\p{^Alpha=n}', "");
Expect(1, 195101, '\P{Alpha=n}', "");
Expect(0, 195101, '\P{^Alpha=n}', "");
Expect(1, 195102, '\p{Alpha=	 N}', "");
Expect(0, 195102, '\p{^Alpha=	 N}', "");
Expect(0, 195102, '\P{Alpha=	 N}', "");
Expect(1, 195102, '\P{^Alpha=	 N}', "");
Expect(0, 195101, '\p{Alpha=	 N}', "");
Expect(1, 195101, '\p{^Alpha=	 N}', "");
Expect(1, 195101, '\P{Alpha=	 N}', "");
Expect(0, 195101, '\P{^Alpha=	 N}', "");
Error('\p{Is_Alphabetic:	:=_F}');
Error('\P{Is_Alphabetic:	:=_F}');
Expect(1, 195102, '\p{Is_Alphabetic=f}', "");
Expect(0, 195102, '\p{^Is_Alphabetic=f}', "");
Expect(0, 195102, '\P{Is_Alphabetic=f}', "");
Expect(1, 195102, '\P{^Is_Alphabetic=f}', "");
Expect(0, 195101, '\p{Is_Alphabetic=f}', "");
Expect(1, 195101, '\p{^Is_Alphabetic=f}', "");
Expect(1, 195101, '\P{Is_Alphabetic=f}', "");
Expect(0, 195101, '\P{^Is_Alphabetic=f}', "");
Expect(1, 195102, '\p{Is_Alphabetic= F}', "");
Expect(0, 195102, '\p{^Is_Alphabetic= F}', "");
Expect(0, 195102, '\P{Is_Alphabetic= F}', "");
Expect(1, 195102, '\P{^Is_Alphabetic= F}', "");
Expect(0, 195101, '\p{Is_Alphabetic= F}', "");
Expect(1, 195101, '\p{^Is_Alphabetic= F}', "");
Expect(1, 195101, '\P{Is_Alphabetic= F}', "");
Expect(0, 195101, '\P{^Is_Alphabetic= F}', "");
Error('\p{Is_Alpha=/a/--false}');
Error('\P{Is_Alpha=/a/--false}');
Expect(1, 195102, '\p{Is_Alpha=false}', "");
Expect(0, 195102, '\p{^Is_Alpha=false}', "");
Expect(0, 195102, '\P{Is_Alpha=false}', "");
Expect(1, 195102, '\P{^Is_Alpha=false}', "");
Expect(0, 195101, '\p{Is_Alpha=false}', "");
Expect(1, 195101, '\p{^Is_Alpha=false}', "");
Expect(1, 195101, '\P{Is_Alpha=false}', "");
Expect(0, 195101, '\P{^Is_Alpha=false}', "");
Expect(1, 195102, '\p{Is_Alpha: false}', "");
Expect(0, 195102, '\p{^Is_Alpha: false}', "");
Expect(0, 195102, '\P{Is_Alpha: false}', "");
Expect(1, 195102, '\P{^Is_Alpha: false}', "");
Expect(0, 195101, '\p{Is_Alpha: false}', "");
Expect(1, 195101, '\p{^Is_Alpha: false}', "");
Expect(1, 195101, '\P{Is_Alpha: false}', "");
Expect(0, 195101, '\P{^Is_Alpha: false}', "");
Error('\p{Alphabetic= Yes/a/}');
Error('\P{Alphabetic= Yes/a/}');
Expect(1, 195101, '\p{Alphabetic=yes}', "");
Expect(0, 195101, '\p{^Alphabetic=yes}', "");
Expect(0, 195101, '\P{Alphabetic=yes}', "");
Expect(1, 195101, '\P{^Alphabetic=yes}', "");
Expect(0, 195102, '\p{Alphabetic=yes}', "");
Expect(1, 195102, '\p{^Alphabetic=yes}', "");
Expect(1, 195102, '\P{Alphabetic=yes}', "");
Expect(0, 195102, '\P{^Alphabetic=yes}', "");
Expect(1, 195101, '\p{Alphabetic=-	yes}', "");
Expect(0, 195101, '\p{^Alphabetic=-	yes}', "");
Expect(0, 195101, '\P{Alphabetic=-	yes}', "");
Expect(1, 195101, '\P{^Alphabetic=-	yes}', "");
Expect(0, 195102, '\p{Alphabetic=-	yes}', "");
Expect(1, 195102, '\p{^Alphabetic=-	yes}', "");
Expect(1, 195102, '\P{Alphabetic=-	yes}', "");
Expect(0, 195102, '\P{^Alphabetic=-	yes}', "");
Error('\p{Alpha=:=Y}');
Error('\P{Alpha=:=Y}');
Expect(1, 195101, '\p{Alpha=y}', "");
Expect(0, 195101, '\p{^Alpha=y}', "");
Expect(0, 195101, '\P{Alpha=y}', "");
Expect(1, 195101, '\P{^Alpha=y}', "");
Expect(0, 195102, '\p{Alpha=y}', "");
Expect(1, 195102, '\p{^Alpha=y}', "");
Expect(1, 195102, '\P{Alpha=y}', "");
Expect(0, 195102, '\P{^Alpha=y}', "");
Expect(1, 195101, '\p{Alpha=__Y}', "");
Expect(0, 195101, '\p{^Alpha=__Y}', "");
Expect(0, 195101, '\P{Alpha=__Y}', "");
Expect(1, 195101, '\P{^Alpha=__Y}', "");
Expect(0, 195102, '\p{Alpha=__Y}', "");
Expect(1, 195102, '\p{^Alpha=__Y}', "");
Expect(1, 195102, '\P{Alpha=__Y}', "");
Expect(0, 195102, '\P{^Alpha=__Y}', "");
Error('\p{Is_Alphabetic=	T/a/}');
Error('\P{Is_Alphabetic=	T/a/}');
Expect(1, 195101, '\p{Is_Alphabetic:t}', "");
Expect(0, 195101, '\p{^Is_Alphabetic:t}', "");
Expect(0, 195101, '\P{Is_Alphabetic:t}', "");
Expect(1, 195101, '\P{^Is_Alphabetic:t}', "");
Expect(0, 195102, '\p{Is_Alphabetic:t}', "");
Expect(1, 195102, '\p{^Is_Alphabetic:t}', "");
Expect(1, 195102, '\P{Is_Alphabetic:t}', "");
Expect(0, 195102, '\P{^Is_Alphabetic:t}', "");
Expect(1, 195101, '\p{Is_Alphabetic=_-T}', "");
Expect(0, 195101, '\p{^Is_Alphabetic=_-T}', "");
Expect(0, 195101, '\P{Is_Alphabetic=_-T}', "");
Expect(1, 195101, '\P{^Is_Alphabetic=_-T}', "");
Expect(0, 195102, '\p{Is_Alphabetic=_-T}', "");
Expect(1, 195102, '\p{^Is_Alphabetic=_-T}', "");
Expect(1, 195102, '\P{Is_Alphabetic=_-T}', "");
Expect(0, 195102, '\P{^Is_Alphabetic=_-T}', "");
Error('\p{Is_Alpha=/a/		True}');
Error('\P{Is_Alpha=/a/		True}');
Expect(1, 195101, '\p{Is_Alpha=true}', "");
Expect(0, 195101, '\p{^Is_Alpha=true}', "");
Expect(0, 195101, '\P{Is_Alpha=true}', "");
Expect(1, 195101, '\P{^Is_Alpha=true}', "");
Expect(0, 195102, '\p{Is_Alpha=true}', "");
Expect(1, 195102, '\p{^Is_Alpha=true}', "");
Expect(1, 195102, '\P{Is_Alpha=true}', "");
Expect(0, 195102, '\P{^Is_Alpha=true}', "");
Expect(1, 195101, '\p{Is_Alpha=	-TRUE}', "");
Expect(0, 195101, '\p{^Is_Alpha=	-TRUE}', "");
Expect(0, 195101, '\P{Is_Alpha=	-TRUE}', "");
Expect(1, 195101, '\P{^Is_Alpha=	-TRUE}', "");
Expect(0, 195102, '\p{Is_Alpha=	-TRUE}', "");
Expect(1, 195102, '\p{^Is_Alpha=	-TRUE}', "");
Expect(1, 195102, '\P{Is_Alpha=	-TRUE}', "");
Expect(0, 195102, '\P{^Is_Alpha=	-TRUE}', "");
Error('\p{Bidi_Control=-no:=}');
Error('\P{Bidi_Control=-no:=}');
Expect(1, 8298, '\p{Bidi_Control=no}', "");
Expect(0, 8298, '\p{^Bidi_Control=no}', "");
Expect(0, 8298, '\P{Bidi_Control=no}', "");
Expect(1, 8298, '\P{^Bidi_Control=no}', "");
Expect(0, 8297, '\p{Bidi_Control=no}', "");
Expect(1, 8297, '\p{^Bidi_Control=no}', "");
Expect(1, 8297, '\P{Bidi_Control=no}', "");
Expect(0, 8297, '\P{^Bidi_Control=no}', "");
Expect(1, 8298, '\p{Bidi_Control= NO}', "");
Expect(0, 8298, '\p{^Bidi_Control= NO}', "");
Expect(0, 8298, '\P{Bidi_Control= NO}', "");
Expect(1, 8298, '\P{^Bidi_Control= NO}', "");
Expect(0, 8297, '\p{Bidi_Control= NO}', "");
Expect(1, 8297, '\p{^Bidi_Control= NO}', "");
Expect(1, 8297, '\P{Bidi_Control= NO}', "");
Expect(0, 8297, '\P{^Bidi_Control= NO}', "");
Error('\p{Bidi_C=/a/	-N}');
Error('\P{Bidi_C=/a/	-N}');
Expect(1, 8298, '\p{Bidi_C=n}', "");
Expect(0, 8298, '\p{^Bidi_C=n}', "");
Expect(0, 8298, '\P{Bidi_C=n}', "");
Expect(1, 8298, '\P{^Bidi_C=n}', "");
Expect(0, 8297, '\p{Bidi_C=n}', "");
Expect(1, 8297, '\p{^Bidi_C=n}', "");
Expect(1, 8297, '\P{Bidi_C=n}', "");
Expect(0, 8297, '\P{^Bidi_C=n}', "");
Expect(1, 8298, '\p{Bidi_C=-n}', "");
Expect(0, 8298, '\p{^Bidi_C=-n}', "");
Expect(0, 8298, '\P{Bidi_C=-n}', "");
Expect(1, 8298, '\P{^Bidi_C=-n}', "");
Expect(0, 8297, '\p{Bidi_C=-n}', "");
Expect(1, 8297, '\p{^Bidi_C=-n}', "");
Expect(1, 8297, '\P{Bidi_C=-n}', "");
Expect(0, 8297, '\P{^Bidi_C=-n}', "");
Error('\p{Is_Bidi_Control=	 F:=}');
Error('\P{Is_Bidi_Control=	 F:=}');
Expect(1, 8298, '\p{Is_Bidi_Control=f}', "");
Expect(0, 8298, '\p{^Is_Bidi_Control=f}', "");
Expect(0, 8298, '\P{Is_Bidi_Control=f}', "");
Expect(1, 8298, '\P{^Is_Bidi_Control=f}', "");
Expect(0, 8297, '\p{Is_Bidi_Control=f}', "");
Expect(1, 8297, '\p{^Is_Bidi_Control=f}', "");
Expect(1, 8297, '\P{Is_Bidi_Control=f}', "");
Expect(0, 8297, '\P{^Is_Bidi_Control=f}', "");
Expect(1, 8298, '\p{Is_Bidi_Control=  F}', "");
Expect(0, 8298, '\p{^Is_Bidi_Control=  F}', "");
Expect(0, 8298, '\P{Is_Bidi_Control=  F}', "");
Expect(1, 8298, '\P{^Is_Bidi_Control=  F}', "");
Expect(0, 8297, '\p{Is_Bidi_Control=  F}', "");
Expect(1, 8297, '\p{^Is_Bidi_Control=  F}', "");
Expect(1, 8297, '\P{Is_Bidi_Control=  F}', "");
Expect(0, 8297, '\P{^Is_Bidi_Control=  F}', "");
Error('\p{Is_Bidi_C=-False/a/}');
Error('\P{Is_Bidi_C=-False/a/}');
Expect(1, 8298, '\p{Is_Bidi_C=false}', "");
Expect(0, 8298, '\p{^Is_Bidi_C=false}', "");
Expect(0, 8298, '\P{Is_Bidi_C=false}', "");
Expect(1, 8298, '\P{^Is_Bidi_C=false}', "");
Expect(0, 8297, '\p{Is_Bidi_C=false}', "");
Expect(1, 8297, '\p{^Is_Bidi_C=false}', "");
Expect(1, 8297, '\P{Is_Bidi_C=false}', "");
Expect(0, 8297, '\P{^Is_Bidi_C=false}', "");
Expect(1, 8298, '\p{Is_Bidi_C=FALSE}', "");
Expect(0, 8298, '\p{^Is_Bidi_C=FALSE}', "");
Expect(0, 8298, '\P{Is_Bidi_C=FALSE}', "");
Expect(1, 8298, '\P{^Is_Bidi_C=FALSE}', "");
Expect(0, 8297, '\p{Is_Bidi_C=FALSE}', "");
Expect(1, 8297, '\p{^Is_Bidi_C=FALSE}', "");
Expect(1, 8297, '\P{Is_Bidi_C=FALSE}', "");
Expect(0, 8297, '\P{^Is_Bidi_C=FALSE}', "");
Error('\p{Bidi_Control=--Yes/a/}');
Error('\P{Bidi_Control=--Yes/a/}');
Expect(1, 8297, '\p{Bidi_Control=yes}', "");
Expect(0, 8297, '\p{^Bidi_Control=yes}', "");
Expect(0, 8297, '\P{Bidi_Control=yes}', "");
Expect(1, 8297, '\P{^Bidi_Control=yes}', "");
Expect(0, 8298, '\p{Bidi_Control=yes}', "");
Expect(1, 8298, '\p{^Bidi_Control=yes}', "");
Expect(1, 8298, '\P{Bidi_Control=yes}', "");
Expect(0, 8298, '\P{^Bidi_Control=yes}', "");
Expect(1, 8297, '\p{Bidi_Control=	_Yes}', "");
Expect(0, 8297, '\p{^Bidi_Control=	_Yes}', "");
Expect(0, 8297, '\P{Bidi_Control=	_Yes}', "");
Expect(1, 8297, '\P{^Bidi_Control=	_Yes}', "");
Expect(0, 8298, '\p{Bidi_Control=	_Yes}', "");
Expect(1, 8298, '\p{^Bidi_Control=	_Yes}', "");
Expect(1, 8298, '\P{Bidi_Control=	_Yes}', "");
Expect(0, 8298, '\P{^Bidi_Control=	_Yes}', "");
Error('\p{Bidi_C=:= _Y}');
Error('\P{Bidi_C=:= _Y}');
Expect(1, 8297, '\p{Bidi_C=y}', "");
Expect(0, 8297, '\p{^Bidi_C=y}', "");
Expect(0, 8297, '\P{Bidi_C=y}', "");
Expect(1, 8297, '\P{^Bidi_C=y}', "");
Expect(0, 8298, '\p{Bidi_C=y}', "");
Expect(1, 8298, '\p{^Bidi_C=y}', "");
Expect(1, 8298, '\P{Bidi_C=y}', "");
Expect(0, 8298, '\P{^Bidi_C=y}', "");
Expect(1, 8297, '\p{Bidi_C=_Y}', "");
Expect(0, 8297, '\p{^Bidi_C=_Y}', "");
Expect(0, 8297, '\P{Bidi_C=_Y}', "");
Expect(1, 8297, '\P{^Bidi_C=_Y}', "");
Expect(0, 8298, '\p{Bidi_C=_Y}', "");
Expect(1, 8298, '\p{^Bidi_C=_Y}', "");
Expect(1, 8298, '\P{Bidi_C=_Y}', "");
Expect(0, 8298, '\P{^Bidi_C=_Y}', "");
Error('\p{Is_Bidi_Control= -T/a/}');
Error('\P{Is_Bidi_Control= -T/a/}');
Expect(1, 8297, '\p{Is_Bidi_Control=t}', "");
Expect(0, 8297, '\p{^Is_Bidi_Control=t}', "");
Expect(0, 8297, '\P{Is_Bidi_Control=t}', "");
Expect(1, 8297, '\P{^Is_Bidi_Control=t}', "");
Expect(0, 8298, '\p{Is_Bidi_Control=t}', "");
Expect(1, 8298, '\p{^Is_Bidi_Control=t}', "");
Expect(1, 8298, '\P{Is_Bidi_Control=t}', "");
Expect(0, 8298, '\P{^Is_Bidi_Control=t}', "");
Expect(1, 8297, '\p{Is_Bidi_Control= -T}', "");
Expect(0, 8297, '\p{^Is_Bidi_Control= -T}', "");
Expect(0, 8297, '\P{Is_Bidi_Control= -T}', "");
Expect(1, 8297, '\P{^Is_Bidi_Control= -T}', "");
Expect(0, 8298, '\p{Is_Bidi_Control= -T}', "");
Expect(1, 8298, '\p{^Is_Bidi_Control= -T}', "");
Expect(1, 8298, '\P{Is_Bidi_Control= -T}', "");
Expect(0, 8298, '\P{^Is_Bidi_Control= -T}', "");
Error('\p{Is_Bidi_C=		TRUE/a/}');
Error('\P{Is_Bidi_C=		TRUE/a/}');
Expect(1, 8297, '\p{Is_Bidi_C=true}', "");
Expect(0, 8297, '\p{^Is_Bidi_C=true}', "");
Expect(0, 8297, '\P{Is_Bidi_C=true}', "");
Expect(1, 8297, '\P{^Is_Bidi_C=true}', "");
Expect(0, 8298, '\p{Is_Bidi_C=true}', "");
Expect(1, 8298, '\p{^Is_Bidi_C=true}', "");
Expect(1, 8298, '\P{Is_Bidi_C=true}', "");
Expect(0, 8298, '\P{^Is_Bidi_C=true}', "");
Expect(1, 8297, '\p{Is_Bidi_C=  true}', "");
Expect(0, 8297, '\p{^Is_Bidi_C=  true}', "");
Expect(0, 8297, '\P{Is_Bidi_C=  true}', "");
Expect(1, 8297, '\P{^Is_Bidi_C=  true}', "");
Expect(0, 8298, '\p{Is_Bidi_C=  true}', "");
Expect(1, 8298, '\p{^Is_Bidi_C=  true}', "");
Expect(1, 8298, '\P{Is_Bidi_C=  true}', "");
Expect(0, 8298, '\P{^Is_Bidi_C=  true}', "");
Error('\p{Bidi_Mirrored=		No:=}');
Error('\P{Bidi_Mirrored=		No:=}');
Expect(1, 120772, '\p{Bidi_Mirrored=no}', "");
Expect(0, 120772, '\p{^Bidi_Mirrored=no}', "");
Expect(0, 120772, '\P{Bidi_Mirrored=no}', "");
Expect(1, 120772, '\P{^Bidi_Mirrored=no}', "");
Expect(0, 120771, '\p{Bidi_Mirrored=no}', "");
Expect(1, 120771, '\p{^Bidi_Mirrored=no}', "");
Expect(1, 120771, '\P{Bidi_Mirrored=no}', "");
Expect(0, 120771, '\P{^Bidi_Mirrored=no}', "");
Expect(1, 120772, '\p{Bidi_Mirrored=No}', "");
Expect(0, 120772, '\p{^Bidi_Mirrored=No}', "");
Expect(0, 120772, '\P{Bidi_Mirrored=No}', "");
Expect(1, 120772, '\P{^Bidi_Mirrored=No}', "");
Expect(0, 120771, '\p{Bidi_Mirrored=No}', "");
Expect(1, 120771, '\p{^Bidi_Mirrored=No}', "");
Expect(1, 120771, '\P{Bidi_Mirrored=No}', "");
Expect(0, 120771, '\P{^Bidi_Mirrored=No}', "");
Error('\p{Bidi_M= :=N}');
Error('\P{Bidi_M= :=N}');
Expect(1, 120772, '\p{Bidi_M=n}', "");
Expect(0, 120772, '\p{^Bidi_M=n}', "");
Expect(0, 120772, '\P{Bidi_M=n}', "");
Expect(1, 120772, '\P{^Bidi_M=n}', "");
Expect(0, 120771, '\p{Bidi_M=n}', "");
Expect(1, 120771, '\p{^Bidi_M=n}', "");
Expect(1, 120771, '\P{Bidi_M=n}', "");
Expect(0, 120771, '\P{^Bidi_M=n}', "");
Expect(1, 120772, '\p{Bidi_M=  N}', "");
Expect(0, 120772, '\p{^Bidi_M=  N}', "");
Expect(0, 120772, '\P{Bidi_M=  N}', "");
Expect(1, 120772, '\P{^Bidi_M=  N}', "");
Expect(0, 120771, '\p{Bidi_M=  N}', "");
Expect(1, 120771, '\p{^Bidi_M=  N}', "");
Expect(1, 120771, '\P{Bidi_M=  N}', "");
Expect(0, 120771, '\P{^Bidi_M=  N}', "");
Error('\p{Is_Bidi_Mirrored=/a/-F}');
Error('\P{Is_Bidi_Mirrored=/a/-F}');
Expect(1, 120772, '\p{Is_Bidi_Mirrored=f}', "");
Expect(0, 120772, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(0, 120772, '\P{Is_Bidi_Mirrored=f}', "");
Expect(1, 120772, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(0, 120771, '\p{Is_Bidi_Mirrored=f}', "");
Expect(1, 120771, '\p{^Is_Bidi_Mirrored=f}', "");
Expect(1, 120771, '\P{Is_Bidi_Mirrored=f}', "");
Expect(0, 120771, '\P{^Is_Bidi_Mirrored=f}', "");
Expect(1, 120772, '\p{Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120772, '\p{^Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120772, '\P{Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120772, '\P{^Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120771, '\p{Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120771, '\p{^Is_Bidi_Mirrored=	 F}', "");
Expect(1, 120771, '\P{Is_Bidi_Mirrored=	 F}', "");
Expect(0, 120771, '\P{^Is_Bidi_Mirrored=	 F}', "");
Error('\p{Is_Bidi_M: _-false/a/}');
Error('\P{Is_Bidi_M: _-false/a/}');
Expect(1, 120772, '\p{Is_Bidi_M=false}', "");
Expect(0, 120772, '\p{^Is_Bidi_M=false}', "");
Expect(0, 120772, '\P{Is_Bidi_M=false}', "");
Expect(1, 120772, '\P{^Is_Bidi_M=false}', "");
Expect(0, 120771, '\p{Is_Bidi_M=false}', "");
Expect(1, 120771, '\p{^Is_Bidi_M=false}', "");
Expect(1, 120771, '\P{Is_Bidi_M=false}', "");
Expect(0, 120771, '\P{^Is_Bidi_M=false}', "");
Expect(1, 120772, '\p{Is_Bidi_M= 	False}', "");
Expect(0, 120772, '\p{^Is_Bidi_M= 	False}', "");
Expect(0, 120772, '\P{Is_Bidi_M= 	False}', "");
Expect(1, 120772, '\P{^Is_Bidi_M= 	False}', "");
Expect(0, 120771, '\p{Is_Bidi_M= 	False}', "");
Expect(1, 120771, '\p{^Is_Bidi_M= 	False}', "");
Expect(1, 120771, '\P{Is_Bidi_M= 	False}', "");
Expect(0, 120771, '\P{^Is_Bidi_M= 	False}', "");
Error('\p{Bidi_Mirrored:	/a/	-YES}');
Error('\P{Bidi_Mirrored:	/a/	-YES}');
Expect(1, 120771, '\p{Bidi_Mirrored=yes}', "");
Expect(0, 120771, '\p{^Bidi_Mirrored=yes}', "");
Expect(0, 120771, '\P{Bidi_Mirrored=yes}', "");
Expect(1, 120771, '\P{^Bidi_Mirrored=yes}', "");
Expect(0, 120772, '\p{Bidi_Mirrored=yes}', "");
Expect(1, 120772, '\p{^Bidi_Mirrored=yes}', "");
Expect(1, 120772, '\P{Bidi_Mirrored=yes}', "");
Expect(0, 120772, '\P{^Bidi_Mirrored=yes}', "");
Expect(1, 120771, '\p{Bidi_Mirrored=  Yes}', "");
Expect(0, 120771, '\p{^Bidi_Mirrored=  Yes}', "");
Expect(0, 120771, '\P{Bidi_Mirrored=  Yes}', "");
Expect(1, 120771, '\P{^Bidi_Mirrored=  Yes}', "");
Expect(0, 120772, '\p{Bidi_Mirrored=  Yes}', "");
Expect(1, 120772, '\p{^Bidi_Mirrored=  Yes}', "");
Expect(1, 120772, '\P{Bidi_Mirrored=  Yes}', "");
Expect(0, 120772, '\P{^Bidi_Mirrored=  Yes}', "");
Error('\p{Bidi_M=-	y:=}');
Error('\P{Bidi_M=-	y:=}');
Expect(1, 120771, '\p{Bidi_M=y}', "");
Expect(0, 120771, '\p{^Bidi_M=y}', "");
Expect(0, 120771, '\P{Bidi_M=y}', "");
Expect(1, 120771, '\P{^Bidi_M=y}', "");
Expect(0, 120772, '\p{Bidi_M=y}', "");
Expect(1, 120772, '\p{^Bidi_M=y}', "");
Expect(1, 120772, '\P{Bidi_M=y}', "");
Expect(0, 120772, '\P{^Bidi_M=y}', "");
Expect(1, 120771, '\p{Bidi_M=	_y}', "");
Expect(0, 120771, '\p{^Bidi_M=	_y}', "");
Expect(0, 120771, '\P{Bidi_M=	_y}', "");
Expect(1, 120771, '\P{^Bidi_M=	_y}', "");
Expect(0, 120772, '\p{Bidi_M=	_y}', "");
Expect(1, 120772, '\p{^Bidi_M=	_y}', "");
Expect(1, 120772, '\P{Bidi_M=	_y}', "");
Expect(0, 120772, '\P{^Bidi_M=	_y}', "");
Error('\p{Is_Bidi_Mirrored=_	T/a/}');
Error('\P{Is_Bidi_Mirrored=_	T/a/}');
Expect(1, 120771, '\p{Is_Bidi_Mirrored=t}', "");
Expect(0, 120771, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(0, 120771, '\P{Is_Bidi_Mirrored=t}', "");
Expect(1, 120771, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(0, 120772, '\p{Is_Bidi_Mirrored=t}', "");
Expect(1, 120772, '\p{^Is_Bidi_Mirrored=t}', "");
Expect(1, 120772, '\P{Is_Bidi_Mirrored=t}', "");
Expect(0, 120772, '\P{^Is_Bidi_Mirrored=t}', "");
Expect(1, 120771, '\p{Is_Bidi_Mirrored=-t}', "");
Expect(0, 120771, '\p{^Is_Bidi_Mirrored=-t}', "");
Expect(0, 120771, '\P{Is_Bidi_Mirrored=-t}', "");
Expect(1, 120771, '\P{^Is_Bidi_Mirrored=-t}', "");
Expect(0, 120772, '\p{Is_Bidi_Mirrored=-t}', "");
Expect(1, 120772, '\p{^Is_Bidi_Mirrored=-t}', "");
Expect(1, 120772, '\P{Is_Bidi_Mirrored=-t}', "");
Expect(0, 120772, '\P{^Is_Bidi_Mirrored=-t}', "");
Error('\p{Is_Bidi_M=	/a/TRUE}');
Error('\P{Is_Bidi_M=	/a/TRUE}');
Expect(1, 120771, '\p{Is_Bidi_M=true}', "");
Expect(0, 120771, '\p{^Is_Bidi_M=true}', "");
Expect(0, 120771, '\P{Is_Bidi_M=true}', "");
Expect(1, 120771, '\P{^Is_Bidi_M=true}', "");
Expect(0, 120772, '\p{Is_Bidi_M=true}', "");
Expect(1, 120772, '\p{^Is_Bidi_M=true}', "");
Expect(1, 120772, '\P{Is_Bidi_M=true}', "");
Expect(0, 120772, '\P{^Is_Bidi_M=true}', "");
Expect(1, 120771, '\p{Is_Bidi_M:	-_True}', "");
Expect(0, 120771, '\p{^Is_Bidi_M:	-_True}', "");
Expect(0, 120771, '\P{Is_Bidi_M:	-_True}', "");
Expect(1, 120771, '\P{^Is_Bidi_M:	-_True}', "");
Expect(0, 120772, '\p{Is_Bidi_M:	-_True}', "");
Expect(1, 120772, '\p{^Is_Bidi_M:	-_True}', "");
Expect(1, 120772, '\P{Is_Bidi_M:	-_True}', "");
Expect(0, 120772, '\P{^Is_Bidi_M:	-_True}', "");
Error('\p{Composition_Exclusion=:=-_NO}');
Error('\P{Composition_Exclusion=:=-_NO}');
Expect(1, 119233, '\p{Composition_Exclusion:no}', "");
Expect(0, 119233, '\p{^Composition_Exclusion:no}', "");
Expect(0, 119233, '\P{Composition_Exclusion:no}', "");
Expect(1, 119233, '\P{^Composition_Exclusion:no}', "");
Expect(0, 119232, '\p{Composition_Exclusion:no}', "");
Expect(1, 119232, '\p{^Composition_Exclusion:no}', "");
Expect(1, 119232, '\P{Composition_Exclusion:no}', "");
Expect(0, 119232, '\P{^Composition_Exclusion:no}', "");
Expect(1, 119233, '\p{Composition_Exclusion=_	NO}', "");
Expect(0, 119233, '\p{^Composition_Exclusion=_	NO}', "");
Expect(0, 119233, '\P{Composition_Exclusion=_	NO}', "");
Expect(1, 119233, '\P{^Composition_Exclusion=_	NO}', "");
Expect(0, 119232, '\p{Composition_Exclusion=_	NO}', "");
Expect(1, 119232, '\p{^Composition_Exclusion=_	NO}', "");
Expect(1, 119232, '\P{Composition_Exclusion=_	NO}', "");
Expect(0, 119232, '\P{^Composition_Exclusion=_	NO}', "");
Error('\p{CE=_/a/N}');
Error('\P{CE=_/a/N}');
Expect(1, 119233, '\p{CE=n}', "");
Expect(0, 119233, '\p{^CE=n}', "");
Expect(0, 119233, '\P{CE=n}', "");
Expect(1, 119233, '\P{^CE=n}', "");
Expect(0, 119232, '\p{CE=n}', "");
Expect(1, 119232, '\p{^CE=n}', "");
Expect(1, 119232, '\P{CE=n}', "");
Expect(0, 119232, '\P{^CE=n}', "");
Expect(1, 119233, '\p{CE=N}', "");
Expect(0, 119233, '\p{^CE=N}', "");
Expect(0, 119233, '\P{CE=N}', "");
Expect(1, 119233, '\P{^CE=N}', "");
Expect(0, 119232, '\p{CE=N}', "");
Expect(1, 119232, '\p{^CE=N}', "");
Expect(1, 119232, '\P{CE=N}', "");
Expect(0, 119232, '\P{^CE=N}', "");
Error('\p{Is_Composition_Exclusion=__F:=}');
Error('\P{Is_Composition_Exclusion=__F:=}');
Expect(1, 119233, '\p{Is_Composition_Exclusion=f}', "");
Expect(0, 119233, '\p{^Is_Composition_Exclusion=f}', "");
Expect(0, 119233, '\P{Is_Composition_Exclusion=f}', "");
Expect(1, 119233, '\P{^Is_Composition_Exclusion=f}', "");
Expect(0, 119232, '\p{Is_Composition_Exclusion=f}', "");
Expect(1, 119232, '\p{^Is_Composition_Exclusion=f}', "");
Expect(1, 119232, '\P{Is_Composition_Exclusion=f}', "");
Expect(0, 119232, '\P{^Is_Composition_Exclusion=f}', "");
Expect(1, 119233, '\p{Is_Composition_Exclusion=_-F}', "");
Expect(0, 119233, '\p{^Is_Composition_Exclusion=_-F}', "");
Expect(0, 119233, '\P{Is_Composition_Exclusion=_-F}', "");
Expect(1, 119233, '\P{^Is_Composition_Exclusion=_-F}', "");
Expect(0, 119232, '\p{Is_Composition_Exclusion=_-F}', "");
Expect(1, 119232, '\p{^Is_Composition_Exclusion=_-F}', "");
Expect(1, 119232, '\P{Is_Composition_Exclusion=_-F}', "");
Expect(0, 119232, '\P{^Is_Composition_Exclusion=_-F}', "");
Error('\p{Is_CE=--false/a/}');
Error('\P{Is_CE=--false/a/}');
Expect(1, 119233, '\p{Is_CE=false}', "");
Expect(0, 119233, '\p{^Is_CE=false}', "");
Expect(0, 119233, '\P{Is_CE=false}', "");
Expect(1, 119233, '\P{^Is_CE=false}', "");
Expect(0, 119232, '\p{Is_CE=false}', "");
Expect(1, 119232, '\p{^Is_CE=false}', "");
Expect(1, 119232, '\P{Is_CE=false}', "");
Expect(0, 119232, '\P{^Is_CE=false}', "");
Expect(1, 119233, '\p{Is_CE:    false}', "");
Expect(0, 119233, '\p{^Is_CE:    false}', "");
Expect(0, 119233, '\P{Is_CE:    false}', "");
Expect(1, 119233, '\P{^Is_CE:    false}', "");
Expect(0, 119232, '\p{Is_CE:    false}', "");
Expect(1, 119232, '\p{^Is_CE:    false}', "");
Expect(1, 119232, '\P{Is_CE:    false}', "");
Expect(0, 119232, '\P{^Is_CE:    false}', "");
Error('\p{Composition_Exclusion=:=_yes}');
Error('\P{Composition_Exclusion=:=_yes}');
Expect(1, 119232, '\p{Composition_Exclusion:yes}', "");
Expect(0, 119232, '\p{^Composition_Exclusion:yes}', "");
Expect(0, 119232, '\P{Composition_Exclusion:yes}', "");
Expect(1, 119232, '\P{^Composition_Exclusion:yes}', "");
Expect(0, 119233, '\p{Composition_Exclusion:yes}', "");
Expect(1, 119233, '\p{^Composition_Exclusion:yes}', "");
Expect(1, 119233, '\P{Composition_Exclusion:yes}', "");
Expect(0, 119233, '\P{^Composition_Exclusion:yes}', "");
Expect(1, 119232, '\p{Composition_Exclusion=_	Yes}', "");
Expect(0, 119232, '\p{^Composition_Exclusion=_	Yes}', "");
Expect(0, 119232, '\P{Composition_Exclusion=_	Yes}', "");
Expect(1, 119232, '\P{^Composition_Exclusion=_	Yes}', "");
Expect(0, 119233, '\p{Composition_Exclusion=_	Yes}', "");
Expect(1, 119233, '\p{^Composition_Exclusion=_	Yes}', "");
Expect(1, 119233, '\P{Composition_Exclusion=_	Yes}', "");
Expect(0, 119233, '\P{^Composition_Exclusion=_	Yes}', "");
Error('\p{CE=--y:=}');
Error('\P{CE=--y:=}');
Expect(1, 119232, '\p{CE=y}', "");
Expect(0, 119232, '\p{^CE=y}', "");
Expect(0, 119232, '\P{CE=y}', "");
Expect(1, 119232, '\P{^CE=y}', "");
Expect(0, 119233, '\p{CE=y}', "");
Expect(1, 119233, '\p{^CE=y}', "");
Expect(1, 119233, '\P{CE=y}', "");
Expect(0, 119233, '\P{^CE=y}', "");
Expect(1, 119232, '\p{CE=__y}', "");
Expect(0, 119232, '\p{^CE=__y}', "");
Expect(0, 119232, '\P{CE=__y}', "");
Expect(1, 119232, '\P{^CE=__y}', "");
Expect(0, 119233, '\p{CE=__y}', "");
Expect(1, 119233, '\p{^CE=__y}', "");
Expect(1, 119233, '\P{CE=__y}', "");
Expect(0, 119233, '\P{^CE=__y}', "");
Error('\p{Is_Composition_Exclusion=:=		T}');
Error('\P{Is_Composition_Exclusion=:=		T}');
Expect(1, 119232, '\p{Is_Composition_Exclusion=t}', "");
Expect(0, 119232, '\p{^Is_Composition_Exclusion=t}', "");
Expect(0, 119232, '\P{Is_Composition_Exclusion=t}', "");
Expect(1, 119232, '\P{^Is_Composition_Exclusion=t}', "");
Expect(0, 119233, '\p{Is_Composition_Exclusion=t}', "");
Expect(1, 119233, '\p{^Is_Composition_Exclusion=t}', "");
Expect(1, 119233, '\P{Is_Composition_Exclusion=t}', "");
Expect(0, 119233, '\P{^Is_Composition_Exclusion=t}', "");
Expect(1, 119232, '\p{Is_Composition_Exclusion=__t}', "");
Expect(0, 119232, '\p{^Is_Composition_Exclusion=__t}', "");
Expect(0, 119232, '\P{Is_Composition_Exclusion=__t}', "");
Expect(1, 119232, '\P{^Is_Composition_Exclusion=__t}', "");
Expect(0, 119233, '\p{Is_Composition_Exclusion=__t}', "");
Expect(1, 119233, '\p{^Is_Composition_Exclusion=__t}', "");
Expect(1, 119233, '\P{Is_Composition_Exclusion=__t}', "");
Expect(0, 119233, '\P{^Is_Composition_Exclusion=__t}', "");
Error('\p{Is_CE=_:=true}');
Error('\P{Is_CE=_:=true}');
Expect(1, 119232, '\p{Is_CE=true}', "");
Expect(0, 119232, '\p{^Is_CE=true}', "");
Expect(0, 119232, '\P{Is_CE=true}', "");
Expect(1, 119232, '\P{^Is_CE=true}', "");
Expect(0, 119233, '\p{Is_CE=true}', "");
Expect(1, 119233, '\p{^Is_CE=true}', "");
Expect(1, 119233, '\P{Is_CE=true}', "");
Expect(0, 119233, '\P{^Is_CE=true}', "");
Expect(1, 119232, '\p{Is_CE=_true}', "");
Expect(0, 119232, '\p{^Is_CE=_true}', "");
Expect(0, 119232, '\P{Is_CE=_true}', "");
Expect(1, 119232, '\P{^Is_CE=_true}', "");
Expect(0, 119233, '\p{Is_CE=_true}', "");
Expect(1, 119233, '\p{^Is_CE=_true}', "");
Expect(1, 119233, '\P{Is_CE=_true}', "");
Expect(0, 119233, '\P{^Is_CE=_true}', "");
Error('\p{Case_Ignorable=/a/no}');
Error('\P{Case_Ignorable=/a/no}');
Expect(1, 918000, '\p{Case_Ignorable=no}', "");
Expect(0, 918000, '\p{^Case_Ignorable=no}', "");
Expect(0, 918000, '\P{Case_Ignorable=no}', "");
Expect(1, 918000, '\P{^Case_Ignorable=no}', "");
Expect(0, 917999, '\p{Case_Ignorable=no}', "");
Expect(1, 917999, '\p{^Case_Ignorable=no}', "");
Expect(1, 917999, '\P{Case_Ignorable=no}', "");
Expect(0, 917999, '\P{^Case_Ignorable=no}', "");
Expect(1, 918000, '\p{Case_Ignorable=__No}', "");
Expect(0, 918000, '\p{^Case_Ignorable=__No}', "");
Expect(0, 918000, '\P{Case_Ignorable=__No}', "");
Expect(1, 918000, '\P{^Case_Ignorable=__No}', "");
Expect(0, 917999, '\p{Case_Ignorable=__No}', "");
Expect(1, 917999, '\p{^Case_Ignorable=__No}', "");
Expect(1, 917999, '\P{Case_Ignorable=__No}', "");
Expect(0, 917999, '\P{^Case_Ignorable=__No}', "");
Error('\p{CI:/a/		N}');
Error('\P{CI:/a/		N}');
Expect(1, 918000, '\p{CI=n}', "");
Expect(0, 918000, '\p{^CI=n}', "");
Expect(0, 918000, '\P{CI=n}', "");
Expect(1, 918000, '\P{^CI=n}', "");
Expect(0, 917999, '\p{CI=n}', "");
Expect(1, 917999, '\p{^CI=n}', "");
Expect(1, 917999, '\P{CI=n}', "");
Expect(0, 917999, '\P{^CI=n}', "");
Expect(1, 918000, '\p{CI:   _N}', "");
Expect(0, 918000, '\p{^CI:   _N}', "");
Expect(0, 918000, '\P{CI:   _N}', "");
Expect(1, 918000, '\P{^CI:   _N}', "");
Expect(0, 917999, '\p{CI:   _N}', "");
Expect(1, 917999, '\p{^CI:   _N}', "");
Expect(1, 917999, '\P{CI:   _N}', "");
Expect(0, 917999, '\P{^CI:   _N}', "");
Error('\p{Is_Case_Ignorable=-/a/F}');
Error('\P{Is_Case_Ignorable=-/a/F}');
Expect(1, 918000, '\p{Is_Case_Ignorable=f}', "");
Expect(0, 918000, '\p{^Is_Case_Ignorable=f}', "");
Expect(0, 918000, '\P{Is_Case_Ignorable=f}', "");
Expect(1, 918000, '\P{^Is_Case_Ignorable=f}', "");
Expect(0, 917999, '\p{Is_Case_Ignorable=f}', "");
Expect(1, 917999, '\p{^Is_Case_Ignorable=f}', "");
Expect(1, 917999, '\P{Is_Case_Ignorable=f}', "");
Expect(0, 917999, '\P{^Is_Case_Ignorable=f}', "");
Expect(1, 918000, '\p{Is_Case_Ignorable= -F}', "");
Expect(0, 918000, '\p{^Is_Case_Ignorable= -F}', "");
Expect(0, 918000, '\P{Is_Case_Ignorable= -F}', "");
Expect(1, 918000, '\P{^Is_Case_Ignorable= -F}', "");
Expect(0, 917999, '\p{Is_Case_Ignorable= -F}', "");
Expect(1, 917999, '\p{^Is_Case_Ignorable= -F}', "");
Expect(1, 917999, '\P{Is_Case_Ignorable= -F}', "");
Expect(0, 917999, '\P{^Is_Case_Ignorable= -F}', "");
Error('\p{Is_CI=	 False/a/}');
Error('\P{Is_CI=	 False/a/}');
Expect(1, 918000, '\p{Is_CI=false}', "");
Expect(0, 918000, '\p{^Is_CI=false}', "");
Expect(0, 918000, '\P{Is_CI=false}', "");
Expect(1, 918000, '\P{^Is_CI=false}', "");
Expect(0, 917999, '\p{Is_CI=false}', "");
Expect(1, 917999, '\p{^Is_CI=false}', "");
Expect(1, 917999, '\P{Is_CI=false}', "");
Expect(0, 917999, '\P{^Is_CI=false}', "");
Expect(1, 918000, '\p{Is_CI=- FALSE}', "");
Expect(0, 918000, '\p{^Is_CI=- FALSE}', "");
Expect(0, 918000, '\P{Is_CI=- FALSE}', "");
Expect(1, 918000, '\P{^Is_CI=- FALSE}', "");
Expect(0, 917999, '\p{Is_CI=- FALSE}', "");
Expect(1, 917999, '\p{^Is_CI=- FALSE}', "");
Expect(1, 917999, '\P{Is_CI=- FALSE}', "");
Expect(0, 917999, '\P{^Is_CI=- FALSE}', "");
Error('\p{Case_Ignorable=:= Yes}');
Error('\P{Case_Ignorable=:= Yes}');
Expect(1, 917999, '\p{Case_Ignorable:yes}', "");
Expect(0, 917999, '\p{^Case_Ignorable:yes}', "");
Expect(0, 917999, '\P{Case_Ignorable:yes}', "");
Expect(1, 917999, '\P{^Case_Ignorable:yes}', "");
Expect(0, 918000, '\p{Case_Ignorable:yes}', "");
Expect(1, 918000, '\p{^Case_Ignorable:yes}', "");
Expect(1, 918000, '\P{Case_Ignorable:yes}', "");
Expect(0, 918000, '\P{^Case_Ignorable:yes}', "");
Expect(1, 917999, '\p{Case_Ignorable:	_-yes}', "");
Expect(0, 917999, '\p{^Case_Ignorable:	_-yes}', "");
Expect(0, 917999, '\P{Case_Ignorable:	_-yes}', "");
Expect(1, 917999, '\P{^Case_Ignorable:	_-yes}', "");
Expect(0, 918000, '\p{Case_Ignorable:	_-yes}', "");
Expect(1, 918000, '\p{^Case_Ignorable:	_-yes}', "");
Expect(1, 918000, '\P{Case_Ignorable:	_-yes}', "");
Expect(0, 918000, '\P{^Case_Ignorable:	_-yes}', "");
Error('\p{CI:  :=y}');
Error('\P{CI:  :=y}');
Expect(1, 917999, '\p{CI=y}', "");
Expect(0, 917999, '\p{^CI=y}', "");
Expect(0, 917999, '\P{CI=y}', "");
Expect(1, 917999, '\P{^CI=y}', "");
Expect(0, 918000, '\p{CI=y}', "");
Expect(1, 918000, '\p{^CI=y}', "");
Expect(1, 918000, '\P{CI=y}', "");
Expect(0, 918000, '\P{^CI=y}', "");
Expect(1, 917999, '\p{CI=__Y}', "");
Expect(0, 917999, '\p{^CI=__Y}', "");
Expect(0, 917999, '\P{CI=__Y}', "");
Expect(1, 917999, '\P{^CI=__Y}', "");
Expect(0, 918000, '\p{CI=__Y}', "");
Expect(1, 918000, '\p{^CI=__Y}', "");
Expect(1, 918000, '\P{CI=__Y}', "");
Expect(0, 918000, '\P{^CI=__Y}', "");
Error('\p{Is_Case_Ignorable:   -:=T}');
Error('\P{Is_Case_Ignorable:   -:=T}');
Expect(1, 917999, '\p{Is_Case_Ignorable=t}', "");
Expect(0, 917999, '\p{^Is_Case_Ignorable=t}', "");
Expect(0, 917999, '\P{Is_Case_Ignorable=t}', "");
Expect(1, 917999, '\P{^Is_Case_Ignorable=t}', "");
Expect(0, 918000, '\p{Is_Case_Ignorable=t}', "");
Expect(1, 918000, '\p{^Is_Case_Ignorable=t}', "");
Expect(1, 918000, '\P{Is_Case_Ignorable=t}', "");
Expect(0, 918000, '\P{^Is_Case_Ignorable=t}', "");
Expect(1, 917999, '\p{Is_Case_Ignorable= T}', "");
Expect(0, 917999, '\p{^Is_Case_Ignorable= T}', "");
Expect(0, 917999, '\P{Is_Case_Ignorable= T}', "");
Expect(1, 917999, '\P{^Is_Case_Ignorable= T}', "");
Expect(0, 918000, '\p{Is_Case_Ignorable= T}', "");
Expect(1, 918000, '\p{^Is_Case_Ignorable= T}', "");
Expect(1, 918000, '\P{Is_Case_Ignorable= T}', "");
Expect(0, 918000, '\P{^Is_Case_Ignorable= T}', "");
Error('\p{Is_CI=/a/TRUE}');
Error('\P{Is_CI=/a/TRUE}');
Expect(1, 917999, '\p{Is_CI:	true}', "");
Expect(0, 917999, '\p{^Is_CI:	true}', "");
Expect(0, 917999, '\P{Is_CI:	true}', "");
Expect(1, 917999, '\P{^Is_CI:	true}', "");
Expect(0, 918000, '\p{Is_CI:	true}', "");
Expect(1, 918000, '\p{^Is_CI:	true}', "");
Expect(1, 918000, '\P{Is_CI:	true}', "");
Expect(0, 918000, '\P{^Is_CI:	true}', "");
Expect(1, 917999, '\p{Is_CI= -True}', "");
Expect(0, 917999, '\p{^Is_CI= -True}', "");
Expect(0, 917999, '\P{Is_CI= -True}', "");
Expect(1, 917999, '\P{^Is_CI= -True}', "");
Expect(0, 918000, '\p{Is_CI= -True}', "");
Expect(1, 918000, '\p{^Is_CI= -True}', "");
Expect(1, 918000, '\P{Is_CI= -True}', "");
Expect(0, 918000, '\P{^Is_CI= -True}', "");
Error('\p{Changes_When_Casefolded=:=_	no}');
Error('\P{Changes_When_Casefolded=:=_	no}');
Expect(1, 71872, '\p{Changes_When_Casefolded=no}', "");
Expect(0, 71872, '\p{^Changes_When_Casefolded=no}', "");
Expect(0, 71872, '\P{Changes_When_Casefolded=no}', "");
Expect(1, 71872, '\P{^Changes_When_Casefolded=no}', "");
Expect(0, 71871, '\p{Changes_When_Casefolded=no}', "");
Expect(1, 71871, '\p{^Changes_When_Casefolded=no}', "");
Expect(1, 71871, '\P{Changes_When_Casefolded=no}', "");
Expect(0, 71871, '\P{^Changes_When_Casefolded=no}', "");
Expect(1, 71872, '\p{Changes_When_Casefolded:--No}', "");
Expect(0, 71872, '\p{^Changes_When_Casefolded:--No}', "");
Expect(0, 71872, '\P{Changes_When_Casefolded:--No}', "");
Expect(1, 71872, '\P{^Changes_When_Casefolded:--No}', "");
Expect(0, 71871, '\p{Changes_When_Casefolded:--No}', "");
Expect(1, 71871, '\p{^Changes_When_Casefolded:--No}', "");
Expect(1, 71871, '\P{Changes_When_Casefolded:--No}', "");
Expect(0, 71871, '\P{^Changes_When_Casefolded:--No}', "");
Error('\p{CWCF=_/a/N}');
Error('\P{CWCF=_/a/N}');
Expect(1, 71872, '\p{CWCF=n}', "");
Expect(0, 71872, '\p{^CWCF=n}', "");
Expect(0, 71872, '\P{CWCF=n}', "");
Expect(1, 71872, '\P{^CWCF=n}', "");
Expect(0, 71871, '\p{CWCF=n}', "");
Expect(1, 71871, '\p{^CWCF=n}', "");
Expect(1, 71871, '\P{CWCF=n}', "");
Expect(0, 71871, '\P{^CWCF=n}', "");
Expect(1, 71872, '\p{CWCF:   N}', "");
Expect(0, 71872, '\p{^CWCF:   N}', "");
Expect(0, 71872, '\P{CWCF:   N}', "");
Expect(1, 71872, '\P{^CWCF:   N}', "");
Expect(0, 71871, '\p{CWCF:   N}', "");
Expect(1, 71871, '\p{^CWCF:   N}', "");
Expect(1, 71871, '\P{CWCF:   N}', "");
Expect(0, 71871, '\P{^CWCF:   N}', "");
Error('\p{Is_Changes_When_Casefolded=	/a/F}');
Error('\P{Is_Changes_When_Casefolded=	/a/F}');
Expect(1, 71872, '\p{Is_Changes_When_Casefolded=f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Casefolded=f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Casefolded=f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Casefolded=f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Casefolded=f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Casefolded=f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Casefolded=f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Casefolded=f}', "");
Expect(1, 71872, '\p{Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Casefolded= -f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Casefolded= -f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Casefolded= -f}', "");
Error('\p{Is_CWCF= :=False}');
Error('\P{Is_CWCF= :=False}');
Expect(1, 71872, '\p{Is_CWCF=false}', "");
Expect(0, 71872, '\p{^Is_CWCF=false}', "");
Expect(0, 71872, '\P{Is_CWCF=false}', "");
Expect(1, 71872, '\P{^Is_CWCF=false}', "");
Expect(0, 71871, '\p{Is_CWCF=false}', "");
Expect(1, 71871, '\p{^Is_CWCF=false}', "");
Expect(1, 71871, '\P{Is_CWCF=false}', "");
Expect(0, 71871, '\P{^Is_CWCF=false}', "");
Expect(1, 71872, '\p{Is_CWCF=	_false}', "");
Expect(0, 71872, '\p{^Is_CWCF=	_false}', "");
Expect(0, 71872, '\P{Is_CWCF=	_false}', "");
Expect(1, 71872, '\P{^Is_CWCF=	_false}', "");
Expect(0, 71871, '\p{Is_CWCF=	_false}', "");
Expect(1, 71871, '\p{^Is_CWCF=	_false}', "");
Expect(1, 71871, '\P{Is_CWCF=	_false}', "");
Expect(0, 71871, '\P{^Is_CWCF=	_false}', "");
Error('\p{Changes_When_Casefolded= -Yes:=}');
Error('\P{Changes_When_Casefolded= -Yes:=}');
Expect(1, 71871, '\p{Changes_When_Casefolded=yes}', "");
Expect(0, 71871, '\p{^Changes_When_Casefolded=yes}', "");
Expect(0, 71871, '\P{Changes_When_Casefolded=yes}', "");
Expect(1, 71871, '\P{^Changes_When_Casefolded=yes}', "");
Expect(0, 71872, '\p{Changes_When_Casefolded=yes}', "");
Expect(1, 71872, '\p{^Changes_When_Casefolded=yes}', "");
Expect(1, 71872, '\P{Changes_When_Casefolded=yes}', "");
Expect(0, 71872, '\P{^Changes_When_Casefolded=yes}', "");
Expect(1, 71871, '\p{Changes_When_Casefolded=_Yes}', "");
Expect(0, 71871, '\p{^Changes_When_Casefolded=_Yes}', "");
Expect(0, 71871, '\P{Changes_When_Casefolded=_Yes}', "");
Expect(1, 71871, '\P{^Changes_When_Casefolded=_Yes}', "");
Expect(0, 71872, '\p{Changes_When_Casefolded=_Yes}', "");
Expect(1, 71872, '\p{^Changes_When_Casefolded=_Yes}', "");
Expect(1, 71872, '\P{Changes_When_Casefolded=_Yes}', "");
Expect(0, 71872, '\P{^Changes_When_Casefolded=_Yes}', "");
Error('\p{CWCF=/a/ 	Y}');
Error('\P{CWCF=/a/ 	Y}');
Expect(1, 71871, '\p{CWCF:y}', "");
Expect(0, 71871, '\p{^CWCF:y}', "");
Expect(0, 71871, '\P{CWCF:y}', "");
Expect(1, 71871, '\P{^CWCF:y}', "");
Expect(0, 71872, '\p{CWCF:y}', "");
Expect(1, 71872, '\p{^CWCF:y}', "");
Expect(1, 71872, '\P{CWCF:y}', "");
Expect(0, 71872, '\P{^CWCF:y}', "");
Expect(1, 71871, '\p{CWCF=-y}', "");
Expect(0, 71871, '\p{^CWCF=-y}', "");
Expect(0, 71871, '\P{CWCF=-y}', "");
Expect(1, 71871, '\P{^CWCF=-y}', "");
Expect(0, 71872, '\p{CWCF=-y}', "");
Expect(1, 71872, '\p{^CWCF=-y}', "");
Expect(1, 71872, '\P{CWCF=-y}', "");
Expect(0, 71872, '\P{^CWCF=-y}', "");
Error('\p{Is_Changes_When_Casefolded= :=T}');
Error('\P{Is_Changes_When_Casefolded= :=T}');
Expect(1, 71871, '\p{Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71871, '\P{Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71872, '\p{Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71872, '\P{Is_Changes_When_Casefolded:   t}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Casefolded:   t}', "");
Expect(1, 71871, '\p{Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71871, '\P{Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71872, '\p{Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Casefolded=_-T}', "");
Expect(1, 71872, '\P{Is_Changes_When_Casefolded=_-T}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Casefolded=_-T}', "");
Error('\p{Is_CWCF=TRUE/a/}');
Error('\P{Is_CWCF=TRUE/a/}');
Expect(1, 71871, '\p{Is_CWCF=true}', "");
Expect(0, 71871, '\p{^Is_CWCF=true}', "");
Expect(0, 71871, '\P{Is_CWCF=true}', "");
Expect(1, 71871, '\P{^Is_CWCF=true}', "");
Expect(0, 71872, '\p{Is_CWCF=true}', "");
Expect(1, 71872, '\p{^Is_CWCF=true}', "");
Expect(1, 71872, '\P{Is_CWCF=true}', "");
Expect(0, 71872, '\P{^Is_CWCF=true}', "");
Expect(1, 71871, '\p{Is_CWCF=-True}', "");
Expect(0, 71871, '\p{^Is_CWCF=-True}', "");
Expect(0, 71871, '\P{Is_CWCF=-True}', "");
Expect(1, 71871, '\P{^Is_CWCF=-True}', "");
Expect(0, 71872, '\p{Is_CWCF=-True}', "");
Expect(1, 71872, '\p{^Is_CWCF=-True}', "");
Expect(1, 71872, '\P{Is_CWCF=-True}', "");
Expect(0, 71872, '\P{^Is_CWCF=-True}', "");
Error('\p{Changes_When_Casemapped= /a/No}');
Error('\P{Changes_When_Casemapped= /a/No}');
Expect(1, 71904, '\p{Changes_When_Casemapped=no}', "");
Expect(0, 71904, '\p{^Changes_When_Casemapped=no}', "");
Expect(0, 71904, '\P{Changes_When_Casemapped=no}', "");
Expect(1, 71904, '\P{^Changes_When_Casemapped=no}', "");
Expect(0, 71903, '\p{Changes_When_Casemapped=no}', "");
Expect(1, 71903, '\p{^Changes_When_Casemapped=no}', "");
Expect(1, 71903, '\P{Changes_When_Casemapped=no}', "");
Expect(0, 71903, '\P{^Changes_When_Casemapped=no}', "");
Expect(1, 71904, '\p{Changes_When_Casemapped=	-no}', "");
Expect(0, 71904, '\p{^Changes_When_Casemapped=	-no}', "");
Expect(0, 71904, '\P{Changes_When_Casemapped=	-no}', "");
Expect(1, 71904, '\P{^Changes_When_Casemapped=	-no}', "");
Expect(0, 71903, '\p{Changes_When_Casemapped=	-no}', "");
Expect(1, 71903, '\p{^Changes_When_Casemapped=	-no}', "");
Expect(1, 71903, '\P{Changes_When_Casemapped=	-no}', "");
Expect(0, 71903, '\P{^Changes_When_Casemapped=	-no}', "");
Error('\p{CWCM:-N/a/}');
Error('\P{CWCM:-N/a/}');
Expect(1, 71904, '\p{CWCM=n}', "");
Expect(0, 71904, '\p{^CWCM=n}', "");
Expect(0, 71904, '\P{CWCM=n}', "");
Expect(1, 71904, '\P{^CWCM=n}', "");
Expect(0, 71903, '\p{CWCM=n}', "");
Expect(1, 71903, '\p{^CWCM=n}', "");
Expect(1, 71903, '\P{CWCM=n}', "");
Expect(0, 71903, '\P{^CWCM=n}', "");
Expect(1, 71904, '\p{CWCM=_	n}', "");
Expect(0, 71904, '\p{^CWCM=_	n}', "");
Expect(0, 71904, '\P{CWCM=_	n}', "");
Expect(1, 71904, '\P{^CWCM=_	n}', "");
Expect(0, 71903, '\p{CWCM=_	n}', "");
Expect(1, 71903, '\p{^CWCM=_	n}', "");
Expect(1, 71903, '\P{CWCM=_	n}', "");
Expect(0, 71903, '\P{^CWCM=_	n}', "");
Error('\p{Is_Changes_When_Casemapped=/a/-F}');
Error('\P{Is_Changes_When_Casemapped=/a/-F}');
Expect(1, 71904, '\p{Is_Changes_When_Casemapped=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Casemapped=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Casemapped=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Casemapped=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Casemapped=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Casemapped=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Casemapped=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Casemapped=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Casemapped=--F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Casemapped=--F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Casemapped=--F}', "");
Error('\p{Is_CWCM=	/a/False}');
Error('\P{Is_CWCM=	/a/False}');
Expect(1, 71904, '\p{Is_CWCM=false}', "");
Expect(0, 71904, '\p{^Is_CWCM=false}', "");
Expect(0, 71904, '\P{Is_CWCM=false}', "");
Expect(1, 71904, '\P{^Is_CWCM=false}', "");
Expect(0, 71903, '\p{Is_CWCM=false}', "");
Expect(1, 71903, '\p{^Is_CWCM=false}', "");
Expect(1, 71903, '\P{Is_CWCM=false}', "");
Expect(0, 71903, '\P{^Is_CWCM=false}', "");
Expect(1, 71904, '\p{Is_CWCM=-_false}', "");
Expect(0, 71904, '\p{^Is_CWCM=-_false}', "");
Expect(0, 71904, '\P{Is_CWCM=-_false}', "");
Expect(1, 71904, '\P{^Is_CWCM=-_false}', "");
Expect(0, 71903, '\p{Is_CWCM=-_false}', "");
Expect(1, 71903, '\p{^Is_CWCM=-_false}', "");
Expect(1, 71903, '\P{Is_CWCM=-_false}', "");
Expect(0, 71903, '\P{^Is_CWCM=-_false}', "");
Error('\p{Changes_When_Casemapped=_/a/YES}');
Error('\P{Changes_When_Casemapped=_/a/YES}');
Expect(1, 71903, '\p{Changes_When_Casemapped=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Casemapped=yes}', "");
Expect(0, 71903, '\P{Changes_When_Casemapped=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Casemapped=yes}', "");
Expect(0, 71904, '\p{Changes_When_Casemapped=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Casemapped=yes}', "");
Expect(1, 71904, '\P{Changes_When_Casemapped=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Casemapped=yes}', "");
Expect(1, 71903, '\p{Changes_When_Casemapped=-	yes}', "");
Expect(0, 71903, '\p{^Changes_When_Casemapped=-	yes}', "");
Expect(0, 71903, '\P{Changes_When_Casemapped=-	yes}', "");
Expect(1, 71903, '\P{^Changes_When_Casemapped=-	yes}', "");
Expect(0, 71904, '\p{Changes_When_Casemapped=-	yes}', "");
Expect(1, 71904, '\p{^Changes_When_Casemapped=-	yes}', "");
Expect(1, 71904, '\P{Changes_When_Casemapped=-	yes}', "");
Expect(0, 71904, '\P{^Changes_When_Casemapped=-	yes}', "");
Error('\p{CWCM=-:=Y}');
Error('\P{CWCM=-:=Y}');
Expect(1, 71903, '\p{CWCM=y}', "");
Expect(0, 71903, '\p{^CWCM=y}', "");
Expect(0, 71903, '\P{CWCM=y}', "");
Expect(1, 71903, '\P{^CWCM=y}', "");
Expect(0, 71904, '\p{CWCM=y}', "");
Expect(1, 71904, '\p{^CWCM=y}', "");
Expect(1, 71904, '\P{CWCM=y}', "");
Expect(0, 71904, '\P{^CWCM=y}', "");
Expect(1, 71903, '\p{CWCM=_ Y}', "");
Expect(0, 71903, '\p{^CWCM=_ Y}', "");
Expect(0, 71903, '\P{CWCM=_ Y}', "");
Expect(1, 71903, '\P{^CWCM=_ Y}', "");
Expect(0, 71904, '\p{CWCM=_ Y}', "");
Expect(1, 71904, '\p{^CWCM=_ Y}', "");
Expect(1, 71904, '\P{CWCM=_ Y}', "");
Expect(0, 71904, '\P{^CWCM=_ Y}', "");
Error('\p{Is_Changes_When_Casemapped=	 T/a/}');
Error('\P{Is_Changes_When_Casemapped=	 T/a/}');
Expect(1, 71903, '\p{Is_Changes_When_Casemapped=t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Casemapped=t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Casemapped=t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Casemapped=t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Casemapped=t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Casemapped=t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Casemapped=t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Casemapped=t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Casemapped:	 t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Casemapped:	 t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Casemapped:	 t}', "");
Error('\p{Is_CWCM=:=True}');
Error('\P{Is_CWCM=:=True}');
Expect(1, 71903, '\p{Is_CWCM=true}', "");
Expect(0, 71903, '\p{^Is_CWCM=true}', "");
Expect(0, 71903, '\P{Is_CWCM=true}', "");
Expect(1, 71903, '\P{^Is_CWCM=true}', "");
Expect(0, 71904, '\p{Is_CWCM=true}', "");
Expect(1, 71904, '\p{^Is_CWCM=true}', "");
Expect(1, 71904, '\P{Is_CWCM=true}', "");
Expect(0, 71904, '\P{^Is_CWCM=true}', "");
Expect(1, 71903, '\p{Is_CWCM=_-TRUE}', "");
Expect(0, 71903, '\p{^Is_CWCM=_-TRUE}', "");
Expect(0, 71903, '\P{Is_CWCM=_-TRUE}', "");
Expect(1, 71903, '\P{^Is_CWCM=_-TRUE}', "");
Expect(0, 71904, '\p{Is_CWCM=_-TRUE}', "");
Expect(1, 71904, '\p{^Is_CWCM=_-TRUE}', "");
Expect(1, 71904, '\P{Is_CWCM=_-TRUE}', "");
Expect(0, 71904, '\P{^Is_CWCM=_-TRUE}', "");
Error('\p{Changes_When_NFKC_Casefolded=-_NO/a/}');
Error('\P{Changes_When_NFKC_Casefolded=-_NO/a/}');
Expect(1, 921600, '\p{Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921600, '\p{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921600, '\P{Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921600, '\P{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921599, '\p{Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921599, '\p{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921599, '\P{Changes_When_NFKC_Casefolded:   no}', "");
Expect(0, 921599, '\P{^Changes_When_NFKC_Casefolded:   no}', "");
Expect(1, 921600, '\p{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921600, '\p{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921600, '\P{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921600, '\P{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921599, '\p{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921599, '\p{^Changes_When_NFKC_Casefolded=	-no}', "");
Expect(1, 921599, '\P{Changes_When_NFKC_Casefolded=	-no}', "");
Expect(0, 921599, '\P{^Changes_When_NFKC_Casefolded=	-no}', "");
Error('\p{CWKCF=/a/	n}');
Error('\P{CWKCF=/a/	n}');
Expect(1, 921600, '\p{CWKCF=n}', "");
Expect(0, 921600, '\p{^CWKCF=n}', "");
Expect(0, 921600, '\P{CWKCF=n}', "");
Expect(1, 921600, '\P{^CWKCF=n}', "");
Expect(0, 921599, '\p{CWKCF=n}', "");
Expect(1, 921599, '\p{^CWKCF=n}', "");
Expect(1, 921599, '\P{CWKCF=n}', "");
Expect(0, 921599, '\P{^CWKCF=n}', "");
Expect(1, 921600, '\p{CWKCF:   -N}', "");
Expect(0, 921600, '\p{^CWKCF:   -N}', "");
Expect(0, 921600, '\P{CWKCF:   -N}', "");
Expect(1, 921600, '\P{^CWKCF:   -N}', "");
Expect(0, 921599, '\p{CWKCF:   -N}', "");
Expect(1, 921599, '\p{^CWKCF:   -N}', "");
Expect(1, 921599, '\P{CWKCF:   -N}', "");
Expect(0, 921599, '\P{^CWKCF:   -N}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded=/a/  F}');
Error('\P{Is_Changes_When_NFKC_Casefolded=/a/  F}');
Expect(1, 921600, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921600, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921600, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921600, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921599, '\p{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921599, '\p{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921599, '\P{Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(0, 921599, '\P{^Is_Changes_When_NFKC_Casefolded=f}', "");
Expect(1, 921600, '\p{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921600, '\p{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921600, '\P{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921600, '\P{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921599, '\p{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921599, '\p{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(1, 921599, '\P{Is_Changes_When_NFKC_Casefolded:    	f}', "");
Expect(0, 921599, '\P{^Is_Changes_When_NFKC_Casefolded:    	f}', "");
Error('\p{Is_CWKCF=	 False:=}');
Error('\P{Is_CWKCF=	 False:=}');
Expect(1, 921600, '\p{Is_CWKCF=false}', "");
Expect(0, 921600, '\p{^Is_CWKCF=false}', "");
Expect(0, 921600, '\P{Is_CWKCF=false}', "");
Expect(1, 921600, '\P{^Is_CWKCF=false}', "");
Expect(0, 921599, '\p{Is_CWKCF=false}', "");
Expect(1, 921599, '\p{^Is_CWKCF=false}', "");
Expect(1, 921599, '\P{Is_CWKCF=false}', "");
Expect(0, 921599, '\P{^Is_CWKCF=false}', "");
Expect(1, 921600, '\p{Is_CWKCF=_-FALSE}', "");
Expect(0, 921600, '\p{^Is_CWKCF=_-FALSE}', "");
Expect(0, 921600, '\P{Is_CWKCF=_-FALSE}', "");
Expect(1, 921600, '\P{^Is_CWKCF=_-FALSE}', "");
Expect(0, 921599, '\p{Is_CWKCF=_-FALSE}', "");
Expect(1, 921599, '\p{^Is_CWKCF=_-FALSE}', "");
Expect(1, 921599, '\P{Is_CWKCF=_-FALSE}', "");
Expect(0, 921599, '\P{^Is_CWKCF=_-FALSE}', "");
Error('\p{Changes_When_NFKC_Casefolded=/a/		Yes}');
Error('\P{Changes_When_NFKC_Casefolded=/a/		Yes}');
Expect(1, 921599, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921599, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921599, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921599, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921600, '\p{Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921600, '\p{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921600, '\P{Changes_When_NFKC_Casefolded=yes}', "");
Expect(0, 921600, '\P{^Changes_When_NFKC_Casefolded=yes}', "");
Expect(1, 921599, '\p{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921599, '\p{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921599, '\P{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921599, '\P{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921600, '\p{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921600, '\p{^Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(1, 921600, '\P{Changes_When_NFKC_Casefolded=	-yes}', "");
Expect(0, 921600, '\P{^Changes_When_NFKC_Casefolded=	-yes}', "");
Error('\p{CWKCF=		Y:=}');
Error('\P{CWKCF=		Y:=}');
Expect(1, 921599, '\p{CWKCF=y}', "");
Expect(0, 921599, '\p{^CWKCF=y}', "");
Expect(0, 921599, '\P{CWKCF=y}', "");
Expect(1, 921599, '\P{^CWKCF=y}', "");
Expect(0, 921600, '\p{CWKCF=y}', "");
Expect(1, 921600, '\p{^CWKCF=y}', "");
Expect(1, 921600, '\P{CWKCF=y}', "");
Expect(0, 921600, '\P{^CWKCF=y}', "");
Expect(1, 921599, '\p{CWKCF=-Y}', "");
Expect(0, 921599, '\p{^CWKCF=-Y}', "");
Expect(0, 921599, '\P{CWKCF=-Y}', "");
Expect(1, 921599, '\P{^CWKCF=-Y}', "");
Expect(0, 921600, '\p{CWKCF=-Y}', "");
Expect(1, 921600, '\p{^CWKCF=-Y}', "");
Expect(1, 921600, '\P{CWKCF=-Y}', "");
Expect(0, 921600, '\P{^CWKCF=-Y}', "");
Error('\p{Is_Changes_When_NFKC_Casefolded= 	t:=}');
Error('\P{Is_Changes_When_NFKC_Casefolded= 	t:=}');
Expect(1, 921599, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921599, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921599, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921599, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921600, '\p{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921600, '\p{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921600, '\P{Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(0, 921600, '\P{^Is_Changes_When_NFKC_Casefolded=t}', "");
Expect(1, 921599, '\p{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921599, '\p{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921599, '\P{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921599, '\P{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921600, '\p{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921600, '\p{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(1, 921600, '\P{Is_Changes_When_NFKC_Casefolded= _T}', "");
Expect(0, 921600, '\P{^Is_Changes_When_NFKC_Casefolded= _T}', "");
Error('\p{Is_CWKCF=:=	true}');
Error('\P{Is_CWKCF=:=	true}');
Expect(1, 921599, '\p{Is_CWKCF=true}', "");
Expect(0, 921599, '\p{^Is_CWKCF=true}', "");
Expect(0, 921599, '\P{Is_CWKCF=true}', "");
Expect(1, 921599, '\P{^Is_CWKCF=true}', "");
Expect(0, 921600, '\p{Is_CWKCF=true}', "");
Expect(1, 921600, '\p{^Is_CWKCF=true}', "");
Expect(1, 921600, '\P{Is_CWKCF=true}', "");
Expect(0, 921600, '\P{^Is_CWKCF=true}', "");
Expect(1, 921599, '\p{Is_CWKCF=- True}', "");
Expect(0, 921599, '\p{^Is_CWKCF=- True}', "");
Expect(0, 921599, '\P{Is_CWKCF=- True}', "");
Expect(1, 921599, '\P{^Is_CWKCF=- True}', "");
Expect(0, 921600, '\p{Is_CWKCF=- True}', "");
Expect(1, 921600, '\p{^Is_CWKCF=- True}', "");
Expect(1, 921600, '\P{Is_CWKCF=- True}', "");
Expect(0, 921600, '\P{^Is_CWKCF=- True}', "");
Error('\p{Changes_When_Lowercased=_No/a/}');
Error('\P{Changes_When_Lowercased=_No/a/}');
Expect(1, 71872, '\p{Changes_When_Lowercased=no}', "");
Expect(0, 71872, '\p{^Changes_When_Lowercased=no}', "");
Expect(0, 71872, '\P{Changes_When_Lowercased=no}', "");
Expect(1, 71872, '\P{^Changes_When_Lowercased=no}', "");
Expect(0, 71871, '\p{Changes_When_Lowercased=no}', "");
Expect(1, 71871, '\p{^Changes_When_Lowercased=no}', "");
Expect(1, 71871, '\P{Changes_When_Lowercased=no}', "");
Expect(0, 71871, '\P{^Changes_When_Lowercased=no}', "");
Expect(1, 71872, '\p{Changes_When_Lowercased=-	No}', "");
Expect(0, 71872, '\p{^Changes_When_Lowercased=-	No}', "");
Expect(0, 71872, '\P{Changes_When_Lowercased=-	No}', "");
Expect(1, 71872, '\P{^Changes_When_Lowercased=-	No}', "");
Expect(0, 71871, '\p{Changes_When_Lowercased=-	No}', "");
Expect(1, 71871, '\p{^Changes_When_Lowercased=-	No}', "");
Expect(1, 71871, '\P{Changes_When_Lowercased=-	No}', "");
Expect(0, 71871, '\P{^Changes_When_Lowercased=-	No}', "");
Error('\p{CWL=-/a/N}');
Error('\P{CWL=-/a/N}');
Expect(1, 71872, '\p{CWL=n}', "");
Expect(0, 71872, '\p{^CWL=n}', "");
Expect(0, 71872, '\P{CWL=n}', "");
Expect(1, 71872, '\P{^CWL=n}', "");
Expect(0, 71871, '\p{CWL=n}', "");
Expect(1, 71871, '\p{^CWL=n}', "");
Expect(1, 71871, '\P{CWL=n}', "");
Expect(0, 71871, '\P{^CWL=n}', "");
Expect(1, 71872, '\p{CWL:	_N}', "");
Expect(0, 71872, '\p{^CWL:	_N}', "");
Expect(0, 71872, '\P{CWL:	_N}', "");
Expect(1, 71872, '\P{^CWL:	_N}', "");
Expect(0, 71871, '\p{CWL:	_N}', "");
Expect(1, 71871, '\p{^CWL:	_N}', "");
Expect(1, 71871, '\P{CWL:	_N}', "");
Expect(0, 71871, '\P{^CWL:	_N}', "");
Error('\p{Is_Changes_When_Lowercased=/a/f}');
Error('\P{Is_Changes_When_Lowercased=/a/f}');
Expect(1, 71872, '\p{Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71872, '\P{Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71871, '\p{Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71871, '\P{Is_Changes_When_Lowercased:	f}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Lowercased:	f}', "");
Expect(1, 71872, '\p{Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71872, '\p{^Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71872, '\P{Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71872, '\P{^Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71871, '\p{Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71871, '\p{^Is_Changes_When_Lowercased=_-F}', "");
Expect(1, 71871, '\P{Is_Changes_When_Lowercased=_-F}', "");
Expect(0, 71871, '\P{^Is_Changes_When_Lowercased=_-F}', "");
Error('\p{Is_CWL=_-False:=}');
Error('\P{Is_CWL=_-False:=}');
Expect(1, 71872, '\p{Is_CWL=false}', "");
Expect(0, 71872, '\p{^Is_CWL=false}', "");
Expect(0, 71872, '\P{Is_CWL=false}', "");
Expect(1, 71872, '\P{^Is_CWL=false}', "");
Expect(0, 71871, '\p{Is_CWL=false}', "");
Expect(1, 71871, '\p{^Is_CWL=false}', "");
Expect(1, 71871, '\P{Is_CWL=false}', "");
Expect(0, 71871, '\P{^Is_CWL=false}', "");
Expect(1, 71872, '\p{Is_CWL=  false}', "");
Expect(0, 71872, '\p{^Is_CWL=  false}', "");
Expect(0, 71872, '\P{Is_CWL=  false}', "");
Expect(1, 71872, '\P{^Is_CWL=  false}', "");
Expect(0, 71871, '\p{Is_CWL=  false}', "");
Expect(1, 71871, '\p{^Is_CWL=  false}', "");
Expect(1, 71871, '\P{Is_CWL=  false}', "");
Expect(0, 71871, '\P{^Is_CWL=  false}', "");
Error('\p{Changes_When_Lowercased=_	Yes:=}');
Error('\P{Changes_When_Lowercased=_	Yes:=}');
Expect(1, 71871, '\p{Changes_When_Lowercased=yes}', "");
Expect(0, 71871, '\p{^Changes_When_Lowercased=yes}', "");
Expect(0, 71871, '\P{Changes_When_Lowercased=yes}', "");
Expect(1, 71871, '\P{^Changes_When_Lowercased=yes}', "");
Expect(0, 71872, '\p{Changes_When_Lowercased=yes}', "");
Expect(1, 71872, '\p{^Changes_When_Lowercased=yes}', "");
Expect(1, 71872, '\P{Changes_When_Lowercased=yes}', "");
Expect(0, 71872, '\P{^Changes_When_Lowercased=yes}', "");
Expect(1, 71871, '\p{Changes_When_Lowercased=	Yes}', "");
Expect(0, 71871, '\p{^Changes_When_Lowercased=	Yes}', "");
Expect(0, 71871, '\P{Changes_When_Lowercased=	Yes}', "");
Expect(1, 71871, '\P{^Changes_When_Lowercased=	Yes}', "");
Expect(0, 71872, '\p{Changes_When_Lowercased=	Yes}', "");
Expect(1, 71872, '\p{^Changes_When_Lowercased=	Yes}', "");
Expect(1, 71872, '\P{Changes_When_Lowercased=	Yes}', "");
Expect(0, 71872, '\P{^Changes_When_Lowercased=	Yes}', "");
Error('\p{CWL=	Y/a/}');
Error('\P{CWL=	Y/a/}');
Expect(1, 71871, '\p{CWL=y}', "");
Expect(0, 71871, '\p{^CWL=y}', "");
Expect(0, 71871, '\P{CWL=y}', "");
Expect(1, 71871, '\P{^CWL=y}', "");
Expect(0, 71872, '\p{CWL=y}', "");
Expect(1, 71872, '\p{^CWL=y}', "");
Expect(1, 71872, '\P{CWL=y}', "");
Expect(0, 71872, '\P{^CWL=y}', "");
Expect(1, 71871, '\p{CWL=_	Y}', "");
Expect(0, 71871, '\p{^CWL=_	Y}', "");
Expect(0, 71871, '\P{CWL=_	Y}', "");
Expect(1, 71871, '\P{^CWL=_	Y}', "");
Expect(0, 71872, '\p{CWL=_	Y}', "");
Expect(1, 71872, '\p{^CWL=_	Y}', "");
Expect(1, 71872, '\P{CWL=_	Y}', "");
Expect(0, 71872, '\P{^CWL=_	Y}', "");
Error('\p{Is_Changes_When_Lowercased= /a/T}');
Error('\P{Is_Changes_When_Lowercased= /a/T}');
Expect(1, 71871, '\p{Is_Changes_When_Lowercased=t}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Lowercased=t}', "");
Expect(0, 71871, '\P{Is_Changes_When_Lowercased=t}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Lowercased=t}', "");
Expect(0, 71872, '\p{Is_Changes_When_Lowercased=t}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Lowercased=t}', "");
Expect(1, 71872, '\P{Is_Changes_When_Lowercased=t}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Lowercased=t}', "");
Expect(1, 71871, '\p{Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71871, '\p{^Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71871, '\P{Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71871, '\P{^Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71872, '\p{Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71872, '\p{^Is_Changes_When_Lowercased=- T}', "");
Expect(1, 71872, '\P{Is_Changes_When_Lowercased=- T}', "");
Expect(0, 71872, '\P{^Is_Changes_When_Lowercased=- T}', "");
Error('\p{Is_CWL:   :=	 True}');
Error('\P{Is_CWL:   :=	 True}');
Expect(1, 71871, '\p{Is_CWL=true}', "");
Expect(0, 71871, '\p{^Is_CWL=true}', "");
Expect(0, 71871, '\P{Is_CWL=true}', "");
Expect(1, 71871, '\P{^Is_CWL=true}', "");
Expect(0, 71872, '\p{Is_CWL=true}', "");
Expect(1, 71872, '\p{^Is_CWL=true}', "");
Expect(1, 71872, '\P{Is_CWL=true}', "");
Expect(0, 71872, '\P{^Is_CWL=true}', "");
Expect(1, 71871, '\p{Is_CWL=-True}', "");
Expect(0, 71871, '\p{^Is_CWL=-True}', "");
Expect(0, 71871, '\P{Is_CWL=-True}', "");
Expect(1, 71871, '\P{^Is_CWL=-True}', "");
Expect(0, 71872, '\p{Is_CWL=-True}', "");
Expect(1, 71872, '\p{^Is_CWL=-True}', "");
Expect(1, 71872, '\P{Is_CWL=-True}', "");
Expect(0, 71872, '\P{^Is_CWL=-True}', "");
Error('\p{Changes_When_Titlecased: -/a/No}');
Error('\P{Changes_When_Titlecased: -/a/No}');
Expect(1, 71904, '\p{Changes_When_Titlecased=no}', "");
Expect(0, 71904, '\p{^Changes_When_Titlecased=no}', "");
Expect(0, 71904, '\P{Changes_When_Titlecased=no}', "");
Expect(1, 71904, '\P{^Changes_When_Titlecased=no}', "");
Expect(0, 71903, '\p{Changes_When_Titlecased=no}', "");
Expect(1, 71903, '\p{^Changes_When_Titlecased=no}', "");
Expect(1, 71903, '\P{Changes_When_Titlecased=no}', "");
Expect(0, 71903, '\P{^Changes_When_Titlecased=no}', "");
Expect(1, 71904, '\p{Changes_When_Titlecased= _No}', "");
Expect(0, 71904, '\p{^Changes_When_Titlecased= _No}', "");
Expect(0, 71904, '\P{Changes_When_Titlecased= _No}', "");
Expect(1, 71904, '\P{^Changes_When_Titlecased= _No}', "");
Expect(0, 71903, '\p{Changes_When_Titlecased= _No}', "");
Expect(1, 71903, '\p{^Changes_When_Titlecased= _No}', "");
Expect(1, 71903, '\P{Changes_When_Titlecased= _No}', "");
Expect(0, 71903, '\P{^Changes_When_Titlecased= _No}', "");
Error('\p{CWT=/a/		N}');
Error('\P{CWT=/a/		N}');
Expect(1, 71904, '\p{CWT=n}', "");
Expect(0, 71904, '\p{^CWT=n}', "");
Expect(0, 71904, '\P{CWT=n}', "");
Expect(1, 71904, '\P{^CWT=n}', "");
Expect(0, 71903, '\p{CWT=n}', "");
Expect(1, 71903, '\p{^CWT=n}', "");
Expect(1, 71903, '\P{CWT=n}', "");
Expect(0, 71903, '\P{^CWT=n}', "");
Expect(1, 71904, '\p{CWT:	_n}', "");
Expect(0, 71904, '\p{^CWT:	_n}', "");
Expect(0, 71904, '\P{CWT:	_n}', "");
Expect(1, 71904, '\P{^CWT:	_n}', "");
Expect(0, 71903, '\p{CWT:	_n}', "");
Expect(1, 71903, '\p{^CWT:	_n}', "");
Expect(1, 71903, '\P{CWT:	_n}', "");
Expect(0, 71903, '\P{^CWT:	_n}', "");
Error('\p{Is_Changes_When_Titlecased=  F/a/}');
Error('\P{Is_Changes_When_Titlecased=  F/a/}');
Expect(1, 71904, '\p{Is_Changes_When_Titlecased=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Titlecased=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Titlecased=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Titlecased=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Titlecased=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Titlecased=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Titlecased=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Titlecased=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Titlecased=	_F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Titlecased=	_F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Titlecased=	_F}', "");
Error('\p{Is_CWT=/a/	 FALSE}');
Error('\P{Is_CWT=/a/	 FALSE}');
Expect(1, 71904, '\p{Is_CWT=false}', "");
Expect(0, 71904, '\p{^Is_CWT=false}', "");
Expect(0, 71904, '\P{Is_CWT=false}', "");
Expect(1, 71904, '\P{^Is_CWT=false}', "");
Expect(0, 71903, '\p{Is_CWT=false}', "");
Expect(1, 71903, '\p{^Is_CWT=false}', "");
Expect(1, 71903, '\P{Is_CWT=false}', "");
Expect(0, 71903, '\P{^Is_CWT=false}', "");
Expect(1, 71904, '\p{Is_CWT=	false}', "");
Expect(0, 71904, '\p{^Is_CWT=	false}', "");
Expect(0, 71904, '\P{Is_CWT=	false}', "");
Expect(1, 71904, '\P{^Is_CWT=	false}', "");
Expect(0, 71903, '\p{Is_CWT=	false}', "");
Expect(1, 71903, '\p{^Is_CWT=	false}', "");
Expect(1, 71903, '\P{Is_CWT=	false}', "");
Expect(0, 71903, '\P{^Is_CWT=	false}', "");
Error('\p{Changes_When_Titlecased=:=	YES}');
Error('\P{Changes_When_Titlecased=:=	YES}');
Expect(1, 71903, '\p{Changes_When_Titlecased=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Titlecased=yes}', "");
Expect(0, 71903, '\P{Changes_When_Titlecased=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Titlecased=yes}', "");
Expect(0, 71904, '\p{Changes_When_Titlecased=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Titlecased=yes}', "");
Expect(1, 71904, '\P{Changes_When_Titlecased=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Titlecased=yes}', "");
Expect(1, 71903, '\p{Changes_When_Titlecased= 	yes}', "");
Expect(0, 71903, '\p{^Changes_When_Titlecased= 	yes}', "");
Expect(0, 71903, '\P{Changes_When_Titlecased= 	yes}', "");
Expect(1, 71903, '\P{^Changes_When_Titlecased= 	yes}', "");
Expect(0, 71904, '\p{Changes_When_Titlecased= 	yes}', "");
Expect(1, 71904, '\p{^Changes_When_Titlecased= 	yes}', "");
Expect(1, 71904, '\P{Changes_When_Titlecased= 	yes}', "");
Expect(0, 71904, '\P{^Changes_When_Titlecased= 	yes}', "");
Error('\p{CWT=:=Y}');
Error('\P{CWT=:=Y}');
Expect(1, 71903, '\p{CWT=y}', "");
Expect(0, 71903, '\p{^CWT=y}', "");
Expect(0, 71903, '\P{CWT=y}', "");
Expect(1, 71903, '\P{^CWT=y}', "");
Expect(0, 71904, '\p{CWT=y}', "");
Expect(1, 71904, '\p{^CWT=y}', "");
Expect(1, 71904, '\P{CWT=y}', "");
Expect(0, 71904, '\P{^CWT=y}', "");
Expect(1, 71903, '\p{CWT=_ Y}', "");
Expect(0, 71903, '\p{^CWT=_ Y}', "");
Expect(0, 71903, '\P{CWT=_ Y}', "");
Expect(1, 71903, '\P{^CWT=_ Y}', "");
Expect(0, 71904, '\p{CWT=_ Y}', "");
Expect(1, 71904, '\p{^CWT=_ Y}', "");
Expect(1, 71904, '\P{CWT=_ Y}', "");
Expect(0, 71904, '\P{^CWT=_ Y}', "");
Error('\p{Is_Changes_When_Titlecased=/a/_T}');
Error('\P{Is_Changes_When_Titlecased=/a/_T}');
Expect(1, 71903, '\p{Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Titlecased:   t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Titlecased:   t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71903, '\P{Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71904, '\p{Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Titlecased=- T}', "");
Expect(1, 71904, '\P{Is_Changes_When_Titlecased=- T}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Titlecased=- T}', "");
Error('\p{Is_CWT:   _-True/a/}');
Error('\P{Is_CWT:   _-True/a/}');
Expect(1, 71903, '\p{Is_CWT=true}', "");
Expect(0, 71903, '\p{^Is_CWT=true}', "");
Expect(0, 71903, '\P{Is_CWT=true}', "");
Expect(1, 71903, '\P{^Is_CWT=true}', "");
Expect(0, 71904, '\p{Is_CWT=true}', "");
Expect(1, 71904, '\p{^Is_CWT=true}', "");
Expect(1, 71904, '\P{Is_CWT=true}', "");
Expect(0, 71904, '\P{^Is_CWT=true}', "");
Expect(1, 71903, '\p{Is_CWT=_true}', "");
Expect(0, 71903, '\p{^Is_CWT=_true}', "");
Expect(0, 71903, '\P{Is_CWT=_true}', "");
Expect(1, 71903, '\P{^Is_CWT=_true}', "");
Expect(0, 71904, '\p{Is_CWT=_true}', "");
Expect(1, 71904, '\p{^Is_CWT=_true}', "");
Expect(1, 71904, '\P{Is_CWT=_true}', "");
Expect(0, 71904, '\P{^Is_CWT=_true}', "");
Error('\p{Changes_When_Uppercased=/a/_NO}');
Error('\P{Changes_When_Uppercased=/a/_NO}');
Expect(1, 71904, '\p{Changes_When_Uppercased=no}', "");
Expect(0, 71904, '\p{^Changes_When_Uppercased=no}', "");
Expect(0, 71904, '\P{Changes_When_Uppercased=no}', "");
Expect(1, 71904, '\P{^Changes_When_Uppercased=no}', "");
Expect(0, 71903, '\p{Changes_When_Uppercased=no}', "");
Expect(1, 71903, '\p{^Changes_When_Uppercased=no}', "");
Expect(1, 71903, '\P{Changes_When_Uppercased=no}', "");
Expect(0, 71903, '\P{^Changes_When_Uppercased=no}', "");
Expect(1, 71904, '\p{Changes_When_Uppercased=-No}', "");
Expect(0, 71904, '\p{^Changes_When_Uppercased=-No}', "");
Expect(0, 71904, '\P{Changes_When_Uppercased=-No}', "");
Expect(1, 71904, '\P{^Changes_When_Uppercased=-No}', "");
Expect(0, 71903, '\p{Changes_When_Uppercased=-No}', "");
Expect(1, 71903, '\p{^Changes_When_Uppercased=-No}', "");
Expect(1, 71903, '\P{Changes_When_Uppercased=-No}', "");
Expect(0, 71903, '\P{^Changes_When_Uppercased=-No}', "");
Error('\p{CWU=-N/a/}');
Error('\P{CWU=-N/a/}');
Expect(1, 71904, '\p{CWU=n}', "");
Expect(0, 71904, '\p{^CWU=n}', "");
Expect(0, 71904, '\P{CWU=n}', "");
Expect(1, 71904, '\P{^CWU=n}', "");
Expect(0, 71903, '\p{CWU=n}', "");
Expect(1, 71903, '\p{^CWU=n}', "");
Expect(1, 71903, '\P{CWU=n}', "");
Expect(0, 71903, '\P{^CWU=n}', "");
Expect(1, 71904, '\p{CWU=_-n}', "");
Expect(0, 71904, '\p{^CWU=_-n}', "");
Expect(0, 71904, '\P{CWU=_-n}', "");
Expect(1, 71904, '\P{^CWU=_-n}', "");
Expect(0, 71903, '\p{CWU=_-n}', "");
Expect(1, 71903, '\p{^CWU=_-n}', "");
Expect(1, 71903, '\P{CWU=_-n}', "");
Expect(0, 71903, '\P{^CWU=_-n}', "");
Error('\p{Is_Changes_When_Uppercased= _F/a/}');
Error('\P{Is_Changes_When_Uppercased= _F/a/}');
Expect(1, 71904, '\p{Is_Changes_When_Uppercased=f}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Uppercased=f}', "");
Expect(0, 71904, '\P{Is_Changes_When_Uppercased=f}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Uppercased=f}', "");
Expect(0, 71903, '\p{Is_Changes_When_Uppercased=f}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Uppercased=f}', "");
Expect(1, 71903, '\P{Is_Changes_When_Uppercased=f}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Uppercased=f}', "");
Expect(1, 71904, '\p{Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71904, '\p{^Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71904, '\P{Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71904, '\P{^Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71903, '\p{Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71903, '\p{^Is_Changes_When_Uppercased=  F}', "");
Expect(1, 71903, '\P{Is_Changes_When_Uppercased=  F}', "");
Expect(0, 71903, '\P{^Is_Changes_When_Uppercased=  F}', "");
Error('\p{Is_CWU=	_False:=}');
Error('\P{Is_CWU=	_False:=}');
Expect(1, 71904, '\p{Is_CWU=false}', "");
Expect(0, 71904, '\p{^Is_CWU=false}', "");
Expect(0, 71904, '\P{Is_CWU=false}', "");
Expect(1, 71904, '\P{^Is_CWU=false}', "");
Expect(0, 71903, '\p{Is_CWU=false}', "");
Expect(1, 71903, '\p{^Is_CWU=false}', "");
Expect(1, 71903, '\P{Is_CWU=false}', "");
Expect(0, 71903, '\P{^Is_CWU=false}', "");
Expect(1, 71904, '\p{Is_CWU= -False}', "");
Expect(0, 71904, '\p{^Is_CWU= -False}', "");
Expect(0, 71904, '\P{Is_CWU= -False}', "");
Expect(1, 71904, '\P{^Is_CWU= -False}', "");
Expect(0, 71903, '\p{Is_CWU= -False}', "");
Expect(1, 71903, '\p{^Is_CWU= -False}', "");
Expect(1, 71903, '\P{Is_CWU= -False}', "");
Expect(0, 71903, '\P{^Is_CWU= -False}', "");
Error('\p{Changes_When_Uppercased=:=_Yes}');
Error('\P{Changes_When_Uppercased=:=_Yes}');
Expect(1, 71903, '\p{Changes_When_Uppercased=yes}', "");
Expect(0, 71903, '\p{^Changes_When_Uppercased=yes}', "");
Expect(0, 71903, '\P{Changes_When_Uppercased=yes}', "");
Expect(1, 71903, '\P{^Changes_When_Uppercased=yes}', "");
Expect(0, 71904, '\p{Changes_When_Uppercased=yes}', "");
Expect(1, 71904, '\p{^Changes_When_Uppercased=yes}', "");
Expect(1, 71904, '\P{Changes_When_Uppercased=yes}', "");
Expect(0, 71904, '\P{^Changes_When_Uppercased=yes}', "");
Expect(1, 71903, '\p{Changes_When_Uppercased=_YES}', "");
Expect(0, 71903, '\p{^Changes_When_Uppercased=_YES}', "");
Expect(0, 71903, '\P{Changes_When_Uppercased=_YES}', "");
Expect(1, 71903, '\P{^Changes_When_Uppercased=_YES}', "");
Expect(0, 71904, '\p{Changes_When_Uppercased=_YES}', "");
Expect(1, 71904, '\p{^Changes_When_Uppercased=_YES}', "");
Expect(1, 71904, '\P{Changes_When_Uppercased=_YES}', "");
Expect(0, 71904, '\P{^Changes_When_Uppercased=_YES}', "");
Error('\p{CWU=:= 	Y}');
Error('\P{CWU=:= 	Y}');
Expect(1, 71903, '\p{CWU=y}', "");
Expect(0, 71903, '\p{^CWU=y}', "");
Expect(0, 71903, '\P{CWU=y}', "");
Expect(1, 71903, '\P{^CWU=y}', "");
Expect(0, 71904, '\p{CWU=y}', "");
Expect(1, 71904, '\p{^CWU=y}', "");
Expect(1, 71904, '\P{CWU=y}', "");
Expect(0, 71904, '\P{^CWU=y}', "");
Expect(1, 71903, '\p{CWU=_ Y}', "");
Expect(0, 71903, '\p{^CWU=_ Y}', "");
Expect(0, 71903, '\P{CWU=_ Y}', "");
Expect(1, 71903, '\P{^CWU=_ Y}', "");
Expect(0, 71904, '\p{CWU=_ Y}', "");
Expect(1, 71904, '\p{^CWU=_ Y}', "");
Expect(1, 71904, '\P{CWU=_ Y}', "");
Expect(0, 71904, '\P{^CWU=_ Y}', "");
Error('\p{Is_Changes_When_Uppercased=/a/T}');
Error('\P{Is_Changes_When_Uppercased=/a/T}');
Expect(1, 71903, '\p{Is_Changes_When_Uppercased=t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Uppercased=t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Uppercased=t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Uppercased=t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Uppercased=t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Uppercased=t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Uppercased=t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Uppercased=t}', "");
Expect(1, 71903, '\p{Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71903, '\p{^Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71903, '\P{Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71903, '\P{^Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71904, '\p{Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71904, '\p{^Is_Changes_When_Uppercased=	t}', "");
Expect(1, 71904, '\P{Is_Changes_When_Uppercased=	t}', "");
Expect(0, 71904, '\P{^Is_Changes_When_Uppercased=	t}', "");
Error('\p{Is_CWU=	:=True}');
Error('\P{Is_CWU=	:=True}');
Expect(1, 71903, '\p{Is_CWU=true}', "");
Expect(0, 71903, '\p{^Is_CWU=true}', "");
Expect(0, 71903, '\P{Is_CWU=true}', "");
Expect(1, 71903, '\P{^Is_CWU=true}', "");
Expect(0, 71904, '\p{Is_CWU=true}', "");
Expect(1, 71904, '\p{^Is_CWU=true}', "");
Expect(1, 71904, '\P{Is_CWU=true}', "");
Expect(0, 71904, '\P{^Is_CWU=true}', "");
Expect(1, 71903, '\p{Is_CWU=_True}', "");
Expect(0, 71903, '\p{^Is_CWU=_True}', "");
Expect(0, 71903, '\P{Is_CWU=_True}', "");
Expect(1, 71903, '\P{^Is_CWU=_True}', "");
Expect(0, 71904, '\p{Is_CWU=_True}', "");
Expect(1, 71904, '\p{^Is_CWU=_True}', "");
Expect(1, 71904, '\P{Is_CWU=_True}', "");
Expect(0, 71904, '\P{^Is_CWU=_True}', "");
Error('\p{Cased=:= _no}');
Error('\P{Cased=:= _no}');
Expect(1, 127370, '\p{Cased=no}', "");
Expect(0, 127370, '\p{^Cased=no}', "");
Expect(0, 127370, '\P{Cased=no}', "");
Expect(1, 127370, '\P{^Cased=no}', "");
Expect(0, 127369, '\p{Cased=no}', "");
Expect(1, 127369, '\p{^Cased=no}', "");
Expect(1, 127369, '\P{Cased=no}', "");
Expect(0, 127369, '\P{^Cased=no}', "");
Expect(1, 127370, '\p{Cased=No}', "");
Expect(0, 127370, '\p{^Cased=No}', "");
Expect(0, 127370, '\P{Cased=No}', "");
Expect(1, 127370, '\P{^Cased=No}', "");
Expect(0, 127369, '\p{Cased=No}', "");
Expect(1, 127369, '\p{^Cased=No}', "");
Expect(1, 127369, '\P{Cased=No}', "");
Expect(0, 127369, '\P{^Cased=No}', "");
Error('\p{Is_Cased=:= -n}');
Error('\P{Is_Cased=:= -n}');
Expect(1, 127370, '\p{Is_Cased=n}', "");
Expect(0, 127370, '\p{^Is_Cased=n}', "");
Expect(0, 127370, '\P{Is_Cased=n}', "");
Expect(1, 127370, '\P{^Is_Cased=n}', "");
Expect(0, 127369, '\p{Is_Cased=n}', "");
Expect(1, 127369, '\p{^Is_Cased=n}', "");
Expect(1, 127369, '\P{Is_Cased=n}', "");
Expect(0, 127369, '\P{^Is_Cased=n}', "");
Expect(1, 127370, '\p{Is_Cased=- n}', "");
Expect(0, 127370, '\p{^Is_Cased=- n}', "");
Expect(0, 127370, '\P{Is_Cased=- n}', "");
Expect(1, 127370, '\P{^Is_Cased=- n}', "");
Expect(0, 127369, '\p{Is_Cased=- n}', "");
Expect(1, 127369, '\p{^Is_Cased=- n}', "");
Expect(1, 127369, '\P{Is_Cased=- n}', "");
Expect(0, 127369, '\P{^Is_Cased=- n}', "");
Error('\p{Cased=__f/a/}');
Error('\P{Cased=__f/a/}');
Expect(1, 127370, '\p{Cased=f}', "");
Expect(0, 127370, '\p{^Cased=f}', "");
Expect(0, 127370, '\P{Cased=f}', "");
Expect(1, 127370, '\P{^Cased=f}', "");
Expect(0, 127369, '\p{Cased=f}', "");
Expect(1, 127369, '\p{^Cased=f}', "");
Expect(1, 127369, '\P{Cased=f}', "");
Expect(0, 127369, '\P{^Cased=f}', "");
Expect(1, 127370, '\p{Cased=F}', "");
Expect(0, 127370, '\p{^Cased=F}', "");
Expect(0, 127370, '\P{Cased=F}', "");
Expect(1, 127370, '\P{^Cased=F}', "");
Expect(0, 127369, '\p{Cased=F}', "");
Expect(1, 127369, '\p{^Cased=F}', "");
Expect(1, 127369, '\P{Cased=F}', "");
Expect(0, 127369, '\P{^Cased=F}', "");
Error('\p{Is_Cased=_ False:=}');
Error('\P{Is_Cased=_ False:=}');
Expect(1, 127370, '\p{Is_Cased=false}', "");
Expect(0, 127370, '\p{^Is_Cased=false}', "");
Expect(0, 127370, '\P{Is_Cased=false}', "");
Expect(1, 127370, '\P{^Is_Cased=false}', "");
Expect(0, 127369, '\p{Is_Cased=false}', "");
Expect(1, 127369, '\p{^Is_Cased=false}', "");
Expect(1, 127369, '\P{Is_Cased=false}', "");
Expect(0, 127369, '\P{^Is_Cased=false}', "");
Expect(1, 127370, '\p{Is_Cased=- false}', "");
Expect(0, 127370, '\p{^Is_Cased=- false}', "");
Expect(0, 127370, '\P{Is_Cased=- false}', "");
Expect(1, 127370, '\P{^Is_Cased=- false}', "");
Expect(0, 127369, '\p{Is_Cased=- false}', "");
Expect(1, 127369, '\p{^Is_Cased=- false}', "");
Expect(1, 127369, '\P{Is_Cased=- false}', "");
Expect(0, 127369, '\P{^Is_Cased=- false}', "");
Error('\p{Cased=_Yes:=}');
Error('\P{Cased=_Yes:=}');
Expect(1, 127369, '\p{Cased=yes}', "");
Expect(0, 127369, '\p{^Cased=yes}', "");
Expect(0, 127369, '\P{Cased=yes}', "");
Expect(1, 127369, '\P{^Cased=yes}', "");
Expect(0, 127370, '\p{Cased=yes}', "");
Expect(1, 127370, '\p{^Cased=yes}', "");
Expect(1, 127370, '\P{Cased=yes}', "");
Expect(0, 127370, '\P{^Cased=yes}', "");
Expect(1, 127369, '\p{Cased=_yes}', "");
Expect(0, 127369, '\p{^Cased=_yes}', "");
Expect(0, 127369, '\P{Cased=_yes}', "");
Expect(1, 127369, '\P{^Cased=_yes}', "");
Expect(0, 127370, '\p{Cased=_yes}', "");
Expect(1, 127370, '\p{^Cased=_yes}', "");
Expect(1, 127370, '\P{Cased=_yes}', "");
Expect(0, 127370, '\P{^Cased=_yes}', "");
Error('\p{Is_Cased=_/a/Y}');
Error('\P{Is_Cased=_/a/Y}');
Expect(1, 127369, '\p{Is_Cased=y}', "");
Expect(0, 127369, '\p{^Is_Cased=y}', "");
Expect(0, 127369, '\P{Is_Cased=y}', "");
Expect(1, 127369, '\P{^Is_Cased=y}', "");
Expect(0, 127370, '\p{Is_Cased=y}', "");
Expect(1, 127370, '\p{^Is_Cased=y}', "");
Expect(1, 127370, '\P{Is_Cased=y}', "");
Expect(0, 127370, '\P{^Is_Cased=y}', "");
Expect(1, 127369, '\p{Is_Cased=_ Y}', "");
Expect(0, 127369, '\p{^Is_Cased=_ Y}', "");
Expect(0, 127369, '\P{Is_Cased=_ Y}', "");
Expect(1, 127369, '\P{^Is_Cased=_ Y}', "");
Expect(0, 127370, '\p{Is_Cased=_ Y}', "");
Expect(1, 127370, '\p{^Is_Cased=_ Y}', "");
Expect(1, 127370, '\P{Is_Cased=_ Y}', "");
Expect(0, 127370, '\P{^Is_Cased=_ Y}', "");
Error('\p{Cased=/a/-_T}');
Error('\P{Cased=/a/-_T}');
Expect(1, 127369, '\p{Cased=t}', "");
Expect(0, 127369, '\p{^Cased=t}', "");
Expect(0, 127369, '\P{Cased=t}', "");
Expect(1, 127369, '\P{^Cased=t}', "");
Expect(0, 127370, '\p{Cased=t}', "");
Expect(1, 127370, '\p{^Cased=t}', "");
Expect(1, 127370, '\P{Cased=t}', "");
Expect(0, 127370, '\P{^Cased=t}', "");
Expect(1, 127369, '\p{Cased=_ T}', "");
Expect(0, 127369, '\p{^Cased=_ T}', "");
Expect(0, 127369, '\P{Cased=_ T}', "");
Expect(1, 127369, '\P{^Cased=_ T}', "");
Expect(0, 127370, '\p{Cased=_ T}', "");
Expect(1, 127370, '\p{^Cased=_ T}', "");
Expect(1, 127370, '\P{Cased=_ T}', "");
Expect(0, 127370, '\P{^Cased=_ T}', "");
Error('\p{Is_Cased=__true:=}');
Error('\P{Is_Cased=__true:=}');
Expect(1, 127369, '\p{Is_Cased=true}', "");
Expect(0, 127369, '\p{^Is_Cased=true}', "");
Expect(0, 127369, '\P{Is_Cased=true}', "");
Expect(1, 127369, '\P{^Is_Cased=true}', "");
Expect(0, 127370, '\p{Is_Cased=true}', "");
Expect(1, 127370, '\p{^Is_Cased=true}', "");
Expect(1, 127370, '\P{Is_Cased=true}', "");
Expect(0, 127370, '\P{^Is_Cased=true}', "");
Expect(1, 127369, '\p{Is_Cased:_true}', "");
Expect(0, 127369, '\p{^Is_Cased:_true}', "");
Expect(0, 127369, '\P{Is_Cased:_true}', "");
Expect(1, 127369, '\P{^Is_Cased:_true}', "");
Expect(0, 127370, '\p{Is_Cased:_true}', "");
Expect(1, 127370, '\p{^Is_Cased:_true}', "");
Expect(1, 127370, '\P{Is_Cased:_true}', "");
Expect(0, 127370, '\P{^Is_Cased:_true}', "");
Error('\p{Full_Composition_Exclusion= :=NO}');
Error('\P{Full_Composition_Exclusion= :=NO}');
Expect(1, 195102, '\p{Full_Composition_Exclusion=no}', "");
Expect(0, 195102, '\p{^Full_Composition_Exclusion=no}', "");
Expect(0, 195102, '\P{Full_Composition_Exclusion=no}', "");
Expect(1, 195102, '\P{^Full_Composition_Exclusion=no}', "");
Expect(0, 195101, '\p{Full_Composition_Exclusion=no}', "");
Expect(1, 195101, '\p{^Full_Composition_Exclusion=no}', "");
Expect(1, 195101, '\P{Full_Composition_Exclusion=no}', "");
Expect(0, 195101, '\P{^Full_Composition_Exclusion=no}', "");
Expect(1, 195102, '\p{Full_Composition_Exclusion:	no}', "");
Expect(0, 195102, '\p{^Full_Composition_Exclusion:	no}', "");
Expect(0, 195102, '\P{Full_Composition_Exclusion:	no}', "");
Expect(1, 195102, '\P{^Full_Composition_Exclusion:	no}', "");
Expect(0, 195101, '\p{Full_Composition_Exclusion:	no}', "");
Expect(1, 195101, '\p{^Full_Composition_Exclusion:	no}', "");
Expect(1, 195101, '\P{Full_Composition_Exclusion:	no}', "");
Expect(0, 195101, '\P{^Full_Composition_Exclusion:	no}', "");
Error('\p{Comp_Ex:- N:=}');
Error('\P{Comp_Ex:- N:=}');
Expect(1, 195102, '\p{Comp_Ex=n}', "");
Expect(0, 195102, '\p{^Comp_Ex=n}', "");
Expect(0, 195102, '\P{Comp_Ex=n}', "");
Expect(1, 195102, '\P{^Comp_Ex=n}', "");
Expect(0, 195101, '\p{Comp_Ex=n}', "");
Expect(1, 195101, '\p{^Comp_Ex=n}', "");
Expect(1, 195101, '\P{Comp_Ex=n}', "");
Expect(0, 195101, '\P{^Comp_Ex=n}', "");
Expect(1, 195102, '\p{Comp_Ex=__n}', "");
Expect(0, 195102, '\p{^Comp_Ex=__n}', "");
Expect(0, 195102, '\P{Comp_Ex=__n}', "");
Expect(1, 195102, '\P{^Comp_Ex=__n}', "");
Expect(0, 195101, '\p{Comp_Ex=__n}', "");
Expect(1, 195101, '\p{^Comp_Ex=__n}', "");
Expect(1, 195101, '\P{Comp_Ex=__n}', "");
Expect(0, 195101, '\P{^Comp_Ex=__n}', "");
Error('\p{Is_Full_Composition_Exclusion:	-	f/a/}');
Error('\P{Is_Full_Composition_Exclusion:	-	f/a/}');
Expect(1, 195102, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195102, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195102, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195102, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195101, '\p{Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195101, '\p{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195101, '\P{Is_Full_Composition_Exclusion=f}', "");
Expect(0, 195101, '\P{^Is_Full_Composition_Exclusion=f}', "");
Expect(1, 195102, '\p{Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195102, '\p{^Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195102, '\P{Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195102, '\P{^Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195101, '\p{Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195101, '\p{^Is_Full_Composition_Exclusion= F}', "");
Expect(1, 195101, '\P{Is_Full_Composition_Exclusion= F}', "");
Expect(0, 195101, '\P{^Is_Full_Composition_Exclusion= F}', "");
Error('\p{Is_Comp_Ex=/a/__FALSE}');
Error('\P{Is_Comp_Ex=/a/__FALSE}');
Expect(1, 195102, '\p{Is_Comp_Ex=false}', "");
Expect(0, 195102, '\p{^Is_Comp_Ex=false}', "");
Expect(0, 195102, '\P{Is_Comp_Ex=false}', "");
Expect(1, 195102, '\P{^Is_Comp_Ex=false}', "");
Expect(0, 195101, '\p{Is_Comp_Ex=false}', "");
Expect(1, 195101, '\p{^Is_Comp_Ex=false}', "");
Expect(1, 195101, '\P{Is_Comp_Ex=false}', "");
Expect(0, 195101, '\P{^Is_Comp_Ex=false}', "");
Expect(1, 195102, '\p{Is_Comp_Ex= FALSE}', "");
Expect(0, 195102, '\p{^Is_Comp_Ex= FALSE}', "");
Expect(0, 195102, '\P{Is_Comp_Ex= FALSE}', "");
Expect(1, 195102, '\P{^Is_Comp_Ex= FALSE}', "");
Expect(0, 195101, '\p{Is_Comp_Ex= FALSE}', "");
Expect(1, 195101, '\p{^Is_Comp_Ex= FALSE}', "");
Expect(1, 195101, '\P{Is_Comp_Ex= FALSE}', "");
Expect(0, 195101, '\P{^Is_Comp_Ex= FALSE}', "");
Error('\p{Full_Composition_Exclusion=	/a/Yes}');
Error('\P{Full_Composition_Exclusion=	/a/Yes}');
Expect(1, 195101, '\p{Full_Composition_Exclusion: yes}', "");
Expect(0, 195101, '\p{^Full_Composition_Exclusion: yes}', "");
Expect(0, 195101, '\P{Full_Composition_Exclusion: yes}', "");
Expect(1, 195101, '\P{^Full_Composition_Exclusion: yes}', "");
Expect(0, 195102, '\p{Full_Composition_Exclusion: yes}', "");
Expect(1, 195102, '\p{^Full_Composition_Exclusion: yes}', "");
Expect(1, 195102, '\P{Full_Composition_Exclusion: yes}', "");
Expect(0, 195102, '\P{^Full_Composition_Exclusion: yes}', "");
Expect(1, 195101, '\p{Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195101, '\p{^Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195101, '\P{Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195101, '\P{^Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195102, '\p{Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195102, '\p{^Full_Composition_Exclusion=_	YES}', "");
Expect(1, 195102, '\P{Full_Composition_Exclusion=_	YES}', "");
Expect(0, 195102, '\P{^Full_Composition_Exclusion=_	YES}', "");
Error('\p{Comp_Ex:		:=Y}');
Error('\P{Comp_Ex:		:=Y}');
Expect(1, 195101, '\p{Comp_Ex=y}', "");
Expect(0, 195101, '\p{^Comp_Ex=y}', "");
Expect(0, 195101, '\P{Comp_Ex=y}', "");
Expect(1, 195101, '\P{^Comp_Ex=y}', "");
Expect(0, 195102, '\p{Comp_Ex=y}', "");
Expect(1, 195102, '\p{^Comp_Ex=y}', "");
Expect(1, 195102, '\P{Comp_Ex=y}', "");
Expect(0, 195102, '\P{^Comp_Ex=y}', "");
Expect(1, 195101, '\p{Comp_Ex=--Y}', "");
Expect(0, 195101, '\p{^Comp_Ex=--Y}', "");
Expect(0, 195101, '\P{Comp_Ex=--Y}', "");
Expect(1, 195101, '\P{^Comp_Ex=--Y}', "");
Expect(0, 195102, '\p{Comp_Ex=--Y}', "");
Expect(1, 195102, '\p{^Comp_Ex=--Y}', "");
Expect(1, 195102, '\P{Comp_Ex=--Y}', "");
Expect(0, 195102, '\P{^Comp_Ex=--Y}', "");
Error('\p{Is_Full_Composition_Exclusion= :=t}');
Error('\P{Is_Full_Composition_Exclusion= :=t}');
Expect(1, 195101, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195101, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195101, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195101, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195102, '\p{Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195102, '\p{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195102, '\P{Is_Full_Composition_Exclusion=t}', "");
Expect(0, 195102, '\P{^Is_Full_Composition_Exclusion=t}', "");
Expect(1, 195101, '\p{Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195101, '\p{^Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195101, '\P{Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195101, '\P{^Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195102, '\p{Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195102, '\p{^Is_Full_Composition_Exclusion= _T}', "");
Expect(1, 195102, '\P{Is_Full_Composition_Exclusion= _T}', "");
Expect(0, 195102, '\P{^Is_Full_Composition_Exclusion= _T}', "");
Error('\p{Is_Comp_Ex:	True:=}');
Error('\P{Is_Comp_Ex:	True:=}');
Expect(1, 195101, '\p{Is_Comp_Ex=true}', "");
Expect(0, 195101, '\p{^Is_Comp_Ex=true}', "");
Expect(0, 195101, '\P{Is_Comp_Ex=true}', "");
Expect(1, 195101, '\P{^Is_Comp_Ex=true}', "");
Expect(0, 195102, '\p{Is_Comp_Ex=true}', "");
Expect(1, 195102, '\p{^Is_Comp_Ex=true}', "");
Expect(1, 195102, '\P{Is_Comp_Ex=true}', "");
Expect(0, 195102, '\P{^Is_Comp_Ex=true}', "");
Expect(1, 195101, '\p{Is_Comp_Ex:	True}', "");
Expect(0, 195101, '\p{^Is_Comp_Ex:	True}', "");
Expect(0, 195101, '\P{Is_Comp_Ex:	True}', "");
Expect(1, 195101, '\P{^Is_Comp_Ex:	True}', "");
Expect(0, 195102, '\p{Is_Comp_Ex:	True}', "");
Expect(1, 195102, '\p{^Is_Comp_Ex:	True}', "");
Expect(1, 195102, '\P{Is_Comp_Ex:	True}', "");
Expect(0, 195102, '\P{^Is_Comp_Ex:	True}', "");
Error('\p{Default_Ignorable_Code_Point=	-NO:=}');
Error('\P{Default_Ignorable_Code_Point=	-NO:=}');
Expect(1, 921600, '\p{Default_Ignorable_Code_Point=no}', "");
Expect(0, 921600, '\p{^Default_Ignorable_Code_Point=no}', "");
Expect(0, 921600, '\P{Default_Ignorable_Code_Point=no}', "");
Expect(1, 921600, '\P{^Default_Ignorable_Code_Point=no}', "");
Expect(0, 921599, '\p{Default_Ignorable_Code_Point=no}', "");
Expect(1, 921599, '\p{^Default_Ignorable_Code_Point=no}', "");
Expect(1, 921599, '\P{Default_Ignorable_Code_Point=no}', "");
Expect(0, 921599, '\P{^Default_Ignorable_Code_Point=no}', "");
Expect(1, 921600, '\p{Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921600, '\p{^Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921600, '\P{Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921600, '\P{^Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921599, '\p{Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921599, '\p{^Default_Ignorable_Code_Point=_No}', "");
Expect(1, 921599, '\P{Default_Ignorable_Code_Point=_No}', "");
Expect(0, 921599, '\P{^Default_Ignorable_Code_Point=_No}', "");
Error('\p{DI=	:=N}');
Error('\P{DI=	:=N}');
Expect(1, 921600, '\p{DI=n}', "");
Expect(0, 921600, '\p{^DI=n}', "");
Expect(0, 921600, '\P{DI=n}', "");
Expect(1, 921600, '\P{^DI=n}', "");
Expect(0, 921599, '\p{DI=n}', "");
Expect(1, 921599, '\p{^DI=n}', "");
Expect(1, 921599, '\P{DI=n}', "");
Expect(0, 921599, '\P{^DI=n}', "");
Expect(1, 921600, '\p{DI:_	N}', "");
Expect(0, 921600, '\p{^DI:_	N}', "");
Expect(0, 921600, '\P{DI:_	N}', "");
Expect(1, 921600, '\P{^DI:_	N}', "");
Expect(0, 921599, '\p{DI:_	N}', "");
Expect(1, 921599, '\p{^DI:_	N}', "");
Expect(1, 921599, '\P{DI:_	N}', "");
Expect(0, 921599, '\P{^DI:_	N}', "");
Error('\p{Is_Default_Ignorable_Code_Point=:=  f}');
Error('\P{Is_Default_Ignorable_Code_Point=:=  f}');
Expect(1, 921600, '\p{Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921600, '\p{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921600, '\P{Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921600, '\P{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921599, '\p{Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921599, '\p{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921599, '\P{Is_Default_Ignorable_Code_Point=f}', "");
Expect(0, 921599, '\P{^Is_Default_Ignorable_Code_Point=f}', "");
Expect(1, 921600, '\p{Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921600, '\p{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921600, '\P{Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921600, '\P{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921599, '\p{Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921599, '\p{^Is_Default_Ignorable_Code_Point= F}', "");
Expect(1, 921599, '\P{Is_Default_Ignorable_Code_Point= F}', "");
Expect(0, 921599, '\P{^Is_Default_Ignorable_Code_Point= F}', "");
Error('\p{Is_DI= 	False:=}');
Error('\P{Is_DI= 	False:=}');
Expect(1, 921600, '\p{Is_DI=false}', "");
Expect(0, 921600, '\p{^Is_DI=false}', "");
Expect(0, 921600, '\P{Is_DI=false}', "");
Expect(1, 921600, '\P{^Is_DI=false}', "");
Expect(0, 921599, '\p{Is_DI=false}', "");
Expect(1, 921599, '\p{^Is_DI=false}', "");
Expect(1, 921599, '\P{Is_DI=false}', "");
Expect(0, 921599, '\P{^Is_DI=false}', "");
Expect(1, 921600, '\p{Is_DI=_-False}', "");
Expect(0, 921600, '\p{^Is_DI=_-False}', "");
Expect(0, 921600, '\P{Is_DI=_-False}', "");
Expect(1, 921600, '\P{^Is_DI=_-False}', "");
Expect(0, 921599, '\p{Is_DI=_-False}', "");
Expect(1, 921599, '\p{^Is_DI=_-False}', "");
Expect(1, 921599, '\P{Is_DI=_-False}', "");
Expect(0, 921599, '\P{^Is_DI=_-False}', "");
Error('\p{Default_Ignorable_Code_Point:	yes:=}');
Error('\P{Default_Ignorable_Code_Point:	yes:=}');
Expect(1, 921599, '\p{Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921599, '\p{^Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921599, '\P{Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921599, '\P{^Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921600, '\p{Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921600, '\p{^Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921600, '\P{Default_Ignorable_Code_Point=yes}', "");
Expect(0, 921600, '\P{^Default_Ignorable_Code_Point=yes}', "");
Expect(1, 921599, '\p{Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921599, '\p{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921599, '\P{Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921599, '\P{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921600, '\p{Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921600, '\p{^Default_Ignorable_Code_Point=_	yes}', "");
Expect(1, 921600, '\P{Default_Ignorable_Code_Point=_	yes}', "");
Expect(0, 921600, '\P{^Default_Ignorable_Code_Point=_	yes}', "");
Error('\p{DI= 	Y/a/}');
Error('\P{DI= 	Y/a/}');
Expect(1, 921599, '\p{DI=y}', "");
Expect(0, 921599, '\p{^DI=y}', "");
Expect(0, 921599, '\P{DI=y}', "");
Expect(1, 921599, '\P{^DI=y}', "");
Expect(0, 921600, '\p{DI=y}', "");
Expect(1, 921600, '\p{^DI=y}', "");
Expect(1, 921600, '\P{DI=y}', "");
Expect(0, 921600, '\P{^DI=y}', "");
Expect(1, 921599, '\p{DI=-Y}', "");
Expect(0, 921599, '\p{^DI=-Y}', "");
Expect(0, 921599, '\P{DI=-Y}', "");
Expect(1, 921599, '\P{^DI=-Y}', "");
Expect(0, 921600, '\p{DI=-Y}', "");
Expect(1, 921600, '\p{^DI=-Y}', "");
Expect(1, 921600, '\P{DI=-Y}', "");
Expect(0, 921600, '\P{^DI=-Y}', "");
Error('\p{Is_Default_Ignorable_Code_Point=	T:=}');
Error('\P{Is_Default_Ignorable_Code_Point=	T:=}');
Expect(1, 921599, '\p{Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921599, '\p{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921599, '\P{Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921599, '\P{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921600, '\p{Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921600, '\p{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921600, '\P{Is_Default_Ignorable_Code_Point=t}', "");
Expect(0, 921600, '\P{^Is_Default_Ignorable_Code_Point=t}', "");
Expect(1, 921599, '\p{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921599, '\p{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921599, '\P{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921599, '\P{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921600, '\p{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921600, '\p{^Is_Default_Ignorable_Code_Point=	T}', "");
Expect(1, 921600, '\P{Is_Default_Ignorable_Code_Point=	T}', "");
Expect(0, 921600, '\P{^Is_Default_Ignorable_Code_Point=	T}', "");
Error('\p{Is_DI: -_TRUE:=}');
Error('\P{Is_DI: -_TRUE:=}');
Expect(1, 921599, '\p{Is_DI=true}', "");
Expect(0, 921599, '\p{^Is_DI=true}', "");
Expect(0, 921599, '\P{Is_DI=true}', "");
Expect(1, 921599, '\P{^Is_DI=true}', "");
Expect(0, 921600, '\p{Is_DI=true}', "");
Expect(1, 921600, '\p{^Is_DI=true}', "");
Expect(1, 921600, '\P{Is_DI=true}', "");
Expect(0, 921600, '\P{^Is_DI=true}', "");
Expect(1, 921599, '\p{Is_DI: 	_TRUE}', "");
Expect(0, 921599, '\p{^Is_DI: 	_TRUE}', "");
Expect(0, 921599, '\P{Is_DI: 	_TRUE}', "");
Expect(1, 921599, '\P{^Is_DI: 	_TRUE}', "");
Expect(0, 921600, '\p{Is_DI: 	_TRUE}', "");
Expect(1, 921600, '\p{^Is_DI: 	_TRUE}', "");
Expect(1, 921600, '\P{Is_DI: 	_TRUE}', "");
Expect(0, 921600, '\P{^Is_DI: 	_TRUE}', "");
Error('\p{Dash=_-No/a/}');
Error('\P{Dash=_-No/a/}');
Expect(1, 65294, '\p{Dash: no}', "");
Expect(0, 65294, '\p{^Dash: no}', "");
Expect(0, 65294, '\P{Dash: no}', "");
Expect(1, 65294, '\P{^Dash: no}', "");
Expect(0, 65293, '\p{Dash: no}', "");
Expect(1, 65293, '\p{^Dash: no}', "");
Expect(1, 65293, '\P{Dash: no}', "");
Expect(0, 65293, '\P{^Dash: no}', "");
Expect(1, 65294, '\p{Dash= _NO}', "");
Expect(0, 65294, '\p{^Dash= _NO}', "");
Expect(0, 65294, '\P{Dash= _NO}', "");
Expect(1, 65294, '\P{^Dash= _NO}', "");
Expect(0, 65293, '\p{Dash= _NO}', "");
Expect(1, 65293, '\p{^Dash= _NO}', "");
Expect(1, 65293, '\P{Dash= _NO}', "");
Expect(0, 65293, '\P{^Dash= _NO}', "");
Error('\p{Is_Dash=	:=N}');
Error('\P{Is_Dash=	:=N}');
Expect(1, 65294, '\p{Is_Dash=n}', "");
Expect(0, 65294, '\p{^Is_Dash=n}', "");
Expect(0, 65294, '\P{Is_Dash=n}', "");
Expect(1, 65294, '\P{^Is_Dash=n}', "");
Expect(0, 65293, '\p{Is_Dash=n}', "");
Expect(1, 65293, '\p{^Is_Dash=n}', "");
Expect(1, 65293, '\P{Is_Dash=n}', "");
Expect(0, 65293, '\P{^Is_Dash=n}', "");
Expect(1, 65294, '\p{Is_Dash= 	N}', "");
Expect(0, 65294, '\p{^Is_Dash= 	N}', "");
Expect(0, 65294, '\P{Is_Dash= 	N}', "");
Expect(1, 65294, '\P{^Is_Dash= 	N}', "");
Expect(0, 65293, '\p{Is_Dash= 	N}', "");
Expect(1, 65293, '\p{^Is_Dash= 	N}', "");
Expect(1, 65293, '\P{Is_Dash= 	N}', "");
Expect(0, 65293, '\P{^Is_Dash= 	N}', "");
Error('\p{Dash= /a/F}');
Error('\P{Dash= /a/F}');
Expect(1, 65294, '\p{Dash=f}', "");
Expect(0, 65294, '\p{^Dash=f}', "");
Expect(0, 65294, '\P{Dash=f}', "");
Expect(1, 65294, '\P{^Dash=f}', "");
Expect(0, 65293, '\p{Dash=f}', "");
Expect(1, 65293, '\p{^Dash=f}', "");
Expect(1, 65293, '\P{Dash=f}', "");
Expect(0, 65293, '\P{^Dash=f}', "");
Expect(1, 65294, '\p{Dash=	 f}', "");
Expect(0, 65294, '\p{^Dash=	 f}', "");
Expect(0, 65294, '\P{Dash=	 f}', "");
Expect(1, 65294, '\P{^Dash=	 f}', "");
Expect(0, 65293, '\p{Dash=	 f}', "");
Expect(1, 65293, '\p{^Dash=	 f}', "");
Expect(1, 65293, '\P{Dash=	 f}', "");
Expect(0, 65293, '\P{^Dash=	 f}', "");
Error('\p{Is_Dash=:=_-False}');
Error('\P{Is_Dash=:=_-False}');
Expect(1, 65294, '\p{Is_Dash: false}', "");
Expect(0, 65294, '\p{^Is_Dash: false}', "");
Expect(0, 65294, '\P{Is_Dash: false}', "");
Expect(1, 65294, '\P{^Is_Dash: false}', "");
Expect(0, 65293, '\p{Is_Dash: false}', "");
Expect(1, 65293, '\p{^Is_Dash: false}', "");
Expect(1, 65293, '\P{Is_Dash: false}', "");
Expect(0, 65293, '\P{^Is_Dash: false}', "");
Expect(1, 65294, '\p{Is_Dash=-false}', "");
Expect(0, 65294, '\p{^Is_Dash=-false}', "");
Expect(0, 65294, '\P{Is_Dash=-false}', "");
Expect(1, 65294, '\P{^Is_Dash=-false}', "");
Expect(0, 65293, '\p{Is_Dash=-false}', "");
Expect(1, 65293, '\p{^Is_Dash=-false}', "");
Expect(1, 65293, '\P{Is_Dash=-false}', "");
Expect(0, 65293, '\P{^Is_Dash=-false}', "");
Error('\p{Dash:  :=yes}');
Error('\P{Dash:  :=yes}');
Expect(1, 65293, '\p{Dash=yes}', "");
Expect(0, 65293, '\p{^Dash=yes}', "");
Expect(0, 65293, '\P{Dash=yes}', "");
Expect(1, 65293, '\P{^Dash=yes}', "");
Expect(0, 65294, '\p{Dash=yes}', "");
Expect(1, 65294, '\p{^Dash=yes}', "");
Expect(1, 65294, '\P{Dash=yes}', "");
Expect(0, 65294, '\P{^Dash=yes}', "");
Expect(1, 65293, '\p{Dash=--Yes}', "");
Expect(0, 65293, '\p{^Dash=--Yes}', "");
Expect(0, 65293, '\P{Dash=--Yes}', "");
Expect(1, 65293, '\P{^Dash=--Yes}', "");
Expect(0, 65294, '\p{Dash=--Yes}', "");
Expect(1, 65294, '\p{^Dash=--Yes}', "");
Expect(1, 65294, '\P{Dash=--Yes}', "");
Expect(0, 65294, '\P{^Dash=--Yes}', "");
Error('\p{Is_Dash=	/a/Y}');
Error('\P{Is_Dash=	/a/Y}');
Expect(1, 65293, '\p{Is_Dash=y}', "");
Expect(0, 65293, '\p{^Is_Dash=y}', "");
Expect(0, 65293, '\P{Is_Dash=y}', "");
Expect(1, 65293, '\P{^Is_Dash=y}', "");
Expect(0, 65294, '\p{Is_Dash=y}', "");
Expect(1, 65294, '\p{^Is_Dash=y}', "");
Expect(1, 65294, '\P{Is_Dash=y}', "");
Expect(0, 65294, '\P{^Is_Dash=y}', "");
Expect(1, 65293, '\p{Is_Dash=	-y}', "");
Expect(0, 65293, '\p{^Is_Dash=	-y}', "");
Expect(0, 65293, '\P{Is_Dash=	-y}', "");
Expect(1, 65293, '\P{^Is_Dash=	-y}', "");
Expect(0, 65294, '\p{Is_Dash=	-y}', "");
Expect(1, 65294, '\p{^Is_Dash=	-y}', "");
Expect(1, 65294, '\P{Is_Dash=	-y}', "");
Expect(0, 65294, '\P{^Is_Dash=	-y}', "");
Error('\p{Dash= T/a/}');
Error('\P{Dash= T/a/}');
Expect(1, 65293, '\p{Dash=t}', "");
Expect(0, 65293, '\p{^Dash=t}', "");
Expect(0, 65293, '\P{Dash=t}', "");
Expect(1, 65293, '\P{^Dash=t}', "");
Expect(0, 65294, '\p{Dash=t}', "");
Expect(1, 65294, '\p{^Dash=t}', "");
Expect(1, 65294, '\P{Dash=t}', "");
Expect(0, 65294, '\P{^Dash=t}', "");
Expect(1, 65293, '\p{Dash=-T}', "");
Expect(0, 65293, '\p{^Dash=-T}', "");
Expect(0, 65293, '\P{Dash=-T}', "");
Expect(1, 65293, '\P{^Dash=-T}', "");
Expect(0, 65294, '\p{Dash=-T}', "");
Expect(1, 65294, '\p{^Dash=-T}', "");
Expect(1, 65294, '\P{Dash=-T}', "");
Expect(0, 65294, '\P{^Dash=-T}', "");
Error('\p{Is_Dash=-:=TRUE}');
Error('\P{Is_Dash=-:=TRUE}');
Expect(1, 65293, '\p{Is_Dash=true}', "");
Expect(0, 65293, '\p{^Is_Dash=true}', "");
Expect(0, 65293, '\P{Is_Dash=true}', "");
Expect(1, 65293, '\P{^Is_Dash=true}', "");
Expect(0, 65294, '\p{Is_Dash=true}', "");
Expect(1, 65294, '\p{^Is_Dash=true}', "");
Expect(1, 65294, '\P{Is_Dash=true}', "");
Expect(0, 65294, '\P{^Is_Dash=true}', "");
Expect(1, 65293, '\p{Is_Dash= _True}', "");
Expect(0, 65293, '\p{^Is_Dash= _True}', "");
Expect(0, 65293, '\P{Is_Dash= _True}', "");
Expect(1, 65293, '\P{^Is_Dash= _True}', "");
Expect(0, 65294, '\p{Is_Dash= _True}', "");
Expect(1, 65294, '\p{^Is_Dash= _True}', "");
Expect(1, 65294, '\P{Is_Dash= _True}', "");
Expect(0, 65294, '\P{^Is_Dash= _True}', "");
Error('\p{Deprecated=-/a/NO}');
Error('\P{Deprecated=-/a/NO}');
Expect(1, 917632, '\p{Deprecated=no}', "");
Expect(0, 917632, '\p{^Deprecated=no}', "");
Expect(0, 917632, '\P{Deprecated=no}', "");
Expect(1, 917632, '\P{^Deprecated=no}', "");
Expect(0, 917631, '\p{Deprecated=no}', "");
Expect(1, 917631, '\p{^Deprecated=no}', "");
Expect(1, 917631, '\P{Deprecated=no}', "");
Expect(0, 917631, '\P{^Deprecated=no}', "");
Expect(1, 917632, '\p{Deprecated:   - No}', "");
Expect(0, 917632, '\p{^Deprecated:   - No}', "");
Expect(0, 917632, '\P{Deprecated:   - No}', "");
Expect(1, 917632, '\P{^Deprecated:   - No}', "");
Expect(0, 917631, '\p{Deprecated:   - No}', "");
Expect(1, 917631, '\p{^Deprecated:   - No}', "");
Expect(1, 917631, '\P{Deprecated:   - No}', "");
Expect(0, 917631, '\P{^Deprecated:   - No}', "");
Error('\p{Dep=_:=N}');
Error('\P{Dep=_:=N}');
Expect(1, 917632, '\p{Dep=n}', "");
Expect(0, 917632, '\p{^Dep=n}', "");
Expect(0, 917632, '\P{Dep=n}', "");
Expect(1, 917632, '\P{^Dep=n}', "");
Expect(0, 917631, '\p{Dep=n}', "");
Expect(1, 917631, '\p{^Dep=n}', "");
Expect(1, 917631, '\P{Dep=n}', "");
Expect(0, 917631, '\P{^Dep=n}', "");
Expect(1, 917632, '\p{Dep= N}', "");
Expect(0, 917632, '\p{^Dep= N}', "");
Expect(0, 917632, '\P{Dep= N}', "");
Expect(1, 917632, '\P{^Dep= N}', "");
Expect(0, 917631, '\p{Dep= N}', "");
Expect(1, 917631, '\p{^Dep= N}', "");
Expect(1, 917631, '\P{Dep= N}', "");
Expect(0, 917631, '\P{^Dep= N}', "");
Error('\p{Is_Deprecated= /a/F}');
Error('\P{Is_Deprecated= /a/F}');
Expect(1, 917632, '\p{Is_Deprecated=f}', "");
Expect(0, 917632, '\p{^Is_Deprecated=f}', "");
Expect(0, 917632, '\P{Is_Deprecated=f}', "");
Expect(1, 917632, '\P{^Is_Deprecated=f}', "");
Expect(0, 917631, '\p{Is_Deprecated=f}', "");
Expect(1, 917631, '\p{^Is_Deprecated=f}', "");
Expect(1, 917631, '\P{Is_Deprecated=f}', "");
Expect(0, 917631, '\P{^Is_Deprecated=f}', "");
Expect(1, 917632, '\p{Is_Deprecated=-_F}', "");
Expect(0, 917632, '\p{^Is_Deprecated=-_F}', "");
Expect(0, 917632, '\P{Is_Deprecated=-_F}', "");
Expect(1, 917632, '\P{^Is_Deprecated=-_F}', "");
Expect(0, 917631, '\p{Is_Deprecated=-_F}', "");
Expect(1, 917631, '\p{^Is_Deprecated=-_F}', "");
Expect(1, 917631, '\P{Is_Deprecated=-_F}', "");
Expect(0, 917631, '\P{^Is_Deprecated=-_F}', "");
Error('\p{Is_Dep:		:=FALSE}');
Error('\P{Is_Dep:		:=FALSE}');
Expect(1, 917632, '\p{Is_Dep: false}', "");
Expect(0, 917632, '\p{^Is_Dep: false}', "");
Expect(0, 917632, '\P{Is_Dep: false}', "");
Expect(1, 917632, '\P{^Is_Dep: false}', "");
Expect(0, 917631, '\p{Is_Dep: false}', "");
Expect(1, 917631, '\p{^Is_Dep: false}', "");
Expect(1, 917631, '\P{Is_Dep: false}', "");
Expect(0, 917631, '\P{^Is_Dep: false}', "");
Expect(1, 917632, '\p{Is_Dep=		False}', "");
Expect(0, 917632, '\p{^Is_Dep=		False}', "");
Expect(0, 917632, '\P{Is_Dep=		False}', "");
Expect(1, 917632, '\P{^Is_Dep=		False}', "");
Expect(0, 917631, '\p{Is_Dep=		False}', "");
Expect(1, 917631, '\p{^Is_Dep=		False}', "");
Expect(1, 917631, '\P{Is_Dep=		False}', "");
Expect(0, 917631, '\P{^Is_Dep=		False}', "");
Error('\p{Deprecated=/a/	-yes}');
Error('\P{Deprecated=/a/	-yes}');
Expect(1, 917631, '\p{Deprecated=yes}', "");
Expect(0, 917631, '\p{^Deprecated=yes}', "");
Expect(0, 917631, '\P{Deprecated=yes}', "");
Expect(1, 917631, '\P{^Deprecated=yes}', "");
Expect(0, 917632, '\p{Deprecated=yes}', "");
Expect(1, 917632, '\p{^Deprecated=yes}', "");
Expect(1, 917632, '\P{Deprecated=yes}', "");
Expect(0, 917632, '\P{^Deprecated=yes}', "");
Expect(1, 917631, '\p{Deprecated=__Yes}', "");
Expect(0, 917631, '\p{^Deprecated=__Yes}', "");
Expect(0, 917631, '\P{Deprecated=__Yes}', "");
Expect(1, 917631, '\P{^Deprecated=__Yes}', "");
Expect(0, 917632, '\p{Deprecated=__Yes}', "");
Expect(1, 917632, '\p{^Deprecated=__Yes}', "");
Expect(1, 917632, '\P{Deprecated=__Yes}', "");
Expect(0, 917632, '\P{^Deprecated=__Yes}', "");
Error('\p{Dep=_/a/Y}');
Error('\P{Dep=_/a/Y}');
Expect(1, 917631, '\p{Dep=y}', "");
Expect(0, 917631, '\p{^Dep=y}', "");
Expect(0, 917631, '\P{Dep=y}', "");
Expect(1, 917631, '\P{^Dep=y}', "");
Expect(0, 917632, '\p{Dep=y}', "");
Expect(1, 917632, '\p{^Dep=y}', "");
Expect(1, 917632, '\P{Dep=y}', "");
Expect(0, 917632, '\P{^Dep=y}', "");
Expect(1, 917631, '\p{Dep= y}', "");
Expect(0, 917631, '\p{^Dep= y}', "");
Expect(0, 917631, '\P{Dep= y}', "");
Expect(1, 917631, '\P{^Dep= y}', "");
Expect(0, 917632, '\p{Dep= y}', "");
Expect(1, 917632, '\p{^Dep= y}', "");
Expect(1, 917632, '\P{Dep= y}', "");
Expect(0, 917632, '\P{^Dep= y}', "");
Error('\p{Is_Deprecated:   	/a/t}');
Error('\P{Is_Deprecated:   	/a/t}');
Expect(1, 917631, '\p{Is_Deprecated=t}', "");
Expect(0, 917631, '\p{^Is_Deprecated=t}', "");
Expect(0, 917631, '\P{Is_Deprecated=t}', "");
Expect(1, 917631, '\P{^Is_Deprecated=t}', "");
Expect(0, 917632, '\p{Is_Deprecated=t}', "");
Expect(1, 917632, '\p{^Is_Deprecated=t}', "");
Expect(1, 917632, '\P{Is_Deprecated=t}', "");
Expect(0, 917632, '\P{^Is_Deprecated=t}', "");
Expect(1, 917631, '\p{Is_Deprecated=--T}', "");
Expect(0, 917631, '\p{^Is_Deprecated=--T}', "");
Expect(0, 917631, '\P{Is_Deprecated=--T}', "");
Expect(1, 917631, '\P{^Is_Deprecated=--T}', "");
Expect(0, 917632, '\p{Is_Deprecated=--T}', "");
Expect(1, 917632, '\p{^Is_Deprecated=--T}', "");
Expect(1, 917632, '\P{Is_Deprecated=--T}', "");
Expect(0, 917632, '\P{^Is_Deprecated=--T}', "");
Error('\p{Is_Dep=True/a/}');
Error('\P{Is_Dep=True/a/}');
Expect(1, 917631, '\p{Is_Dep=true}', "");
Expect(0, 917631, '\p{^Is_Dep=true}', "");
Expect(0, 917631, '\P{Is_Dep=true}', "");
Expect(1, 917631, '\P{^Is_Dep=true}', "");
Expect(0, 917632, '\p{Is_Dep=true}', "");
Expect(1, 917632, '\p{^Is_Dep=true}', "");
Expect(1, 917632, '\P{Is_Dep=true}', "");
Expect(0, 917632, '\P{^Is_Dep=true}', "");
Expect(1, 917631, '\p{Is_Dep=--True}', "");
Expect(0, 917631, '\p{^Is_Dep=--True}', "");
Expect(0, 917631, '\P{Is_Dep=--True}', "");
Expect(1, 917631, '\P{^Is_Dep=--True}', "");
Expect(0, 917632, '\p{Is_Dep=--True}', "");
Expect(1, 917632, '\p{^Is_Dep=--True}', "");
Expect(1, 917632, '\P{Is_Dep=--True}', "");
Expect(0, 917632, '\P{^Is_Dep=--True}', "");
Error('\p{Diacritic:		/a/NO}');
Error('\P{Diacritic:		/a/NO}');
Expect(1, 125143, '\p{Diacritic=no}', "");
Expect(0, 125143, '\p{^Diacritic=no}', "");
Expect(0, 125143, '\P{Diacritic=no}', "");
Expect(1, 125143, '\P{^Diacritic=no}', "");
Expect(0, 125142, '\p{Diacritic=no}', "");
Expect(1, 125142, '\p{^Diacritic=no}', "");
Expect(1, 125142, '\P{Diacritic=no}', "");
Expect(0, 125142, '\P{^Diacritic=no}', "");
Expect(1, 125143, '\p{Diacritic=- NO}', "");
Expect(0, 125143, '\p{^Diacritic=- NO}', "");
Expect(0, 125143, '\P{Diacritic=- NO}', "");
Expect(1, 125143, '\P{^Diacritic=- NO}', "");
Expect(0, 125142, '\p{Diacritic=- NO}', "");
Expect(1, 125142, '\p{^Diacritic=- NO}', "");
Expect(1, 125142, '\P{Diacritic=- NO}', "");
Expect(0, 125142, '\P{^Diacritic=- NO}', "");
Error('\p{Dia=/a/  N}');
Error('\P{Dia=/a/  N}');
Expect(1, 125143, '\p{Dia=n}', "");
Expect(0, 125143, '\p{^Dia=n}', "");
Expect(0, 125143, '\P{Dia=n}', "");
Expect(1, 125143, '\P{^Dia=n}', "");
Expect(0, 125142, '\p{Dia=n}', "");
Expect(1, 125142, '\p{^Dia=n}', "");
Expect(1, 125142, '\P{Dia=n}', "");
Expect(0, 125142, '\P{^Dia=n}', "");
Expect(1, 125143, '\p{Dia=-_N}', "");
Expect(0, 125143, '\p{^Dia=-_N}', "");
Expect(0, 125143, '\P{Dia=-_N}', "");
Expect(1, 125143, '\P{^Dia=-_N}', "");
Expect(0, 125142, '\p{Dia=-_N}', "");
Expect(1, 125142, '\p{^Dia=-_N}', "");
Expect(1, 125142, '\P{Dia=-_N}', "");
Expect(0, 125142, '\P{^Dia=-_N}', "");
Error('\p{Is_Diacritic=F:=}');
Error('\P{Is_Diacritic=F:=}');
Expect(1, 125143, '\p{Is_Diacritic=f}', "");
Expect(0, 125143, '\p{^Is_Diacritic=f}', "");
Expect(0, 125143, '\P{Is_Diacritic=f}', "");
Expect(1, 125143, '\P{^Is_Diacritic=f}', "");
Expect(0, 125142, '\p{Is_Diacritic=f}', "");
Expect(1, 125142, '\p{^Is_Diacritic=f}', "");
Expect(1, 125142, '\P{Is_Diacritic=f}', "");
Expect(0, 125142, '\P{^Is_Diacritic=f}', "");
Expect(1, 125143, '\p{Is_Diacritic= 	F}', "");
Expect(0, 125143, '\p{^Is_Diacritic= 	F}', "");
Expect(0, 125143, '\P{Is_Diacritic= 	F}', "");
Expect(1, 125143, '\P{^Is_Diacritic= 	F}', "");
Expect(0, 125142, '\p{Is_Diacritic= 	F}', "");
Expect(1, 125142, '\p{^Is_Diacritic= 	F}', "");
Expect(1, 125142, '\P{Is_Diacritic= 	F}', "");
Expect(0, 125142, '\P{^Is_Diacritic= 	F}', "");
Error('\p{Is_Dia= -False:=}');
Error('\P{Is_Dia= -False:=}');
Expect(1, 125143, '\p{Is_Dia=false}', "");
Expect(0, 125143, '\p{^Is_Dia=false}', "");
Expect(0, 125143, '\P{Is_Dia=false}', "");
Expect(1, 125143, '\P{^Is_Dia=false}', "");
Expect(0, 125142, '\p{Is_Dia=false}', "");
Expect(1, 125142, '\p{^Is_Dia=false}', "");
Expect(1, 125142, '\P{Is_Dia=false}', "");
Expect(0, 125142, '\P{^Is_Dia=false}', "");
Expect(1, 125143, '\p{Is_Dia=- False}', "");
Expect(0, 125143, '\p{^Is_Dia=- False}', "");
Expect(0, 125143, '\P{Is_Dia=- False}', "");
Expect(1, 125143, '\P{^Is_Dia=- False}', "");
Expect(0, 125142, '\p{Is_Dia=- False}', "");
Expect(1, 125142, '\p{^Is_Dia=- False}', "");
Expect(1, 125142, '\P{Is_Dia=- False}', "");
Expect(0, 125142, '\P{^Is_Dia=- False}', "");
Error('\p{Diacritic=-:=Yes}');
Error('\P{Diacritic=-:=Yes}');
Expect(1, 125142, '\p{Diacritic:	yes}', "");
Expect(0, 125142, '\p{^Diacritic:	yes}', "");
Expect(0, 125142, '\P{Diacritic:	yes}', "");
Expect(1, 125142, '\P{^Diacritic:	yes}', "");
Expect(0, 125143, '\p{Diacritic:	yes}', "");
Expect(1, 125143, '\p{^Diacritic:	yes}', "");
Expect(1, 125143, '\P{Diacritic:	yes}', "");
Expect(0, 125143, '\P{^Diacritic:	yes}', "");
Expect(1, 125142, '\p{Diacritic= 	yes}', "");
Expect(0, 125142, '\p{^Diacritic= 	yes}', "");
Expect(0, 125142, '\P{Diacritic= 	yes}', "");
Expect(1, 125142, '\P{^Diacritic= 	yes}', "");
Expect(0, 125143, '\p{Diacritic= 	yes}', "");
Expect(1, 125143, '\p{^Diacritic= 	yes}', "");
Expect(1, 125143, '\P{Diacritic= 	yes}', "");
Expect(0, 125143, '\P{^Diacritic= 	yes}', "");
Error('\p{Dia=_:=Y}');
Error('\P{Dia=_:=Y}');
Expect(1, 125142, '\p{Dia=y}', "");
Expect(0, 125142, '\p{^Dia=y}', "");
Expect(0, 125142, '\P{Dia=y}', "");
Expect(1, 125142, '\P{^Dia=y}', "");
Expect(0, 125143, '\p{Dia=y}', "");
Expect(1, 125143, '\p{^Dia=y}', "");
Expect(1, 125143, '\P{Dia=y}', "");
Expect(0, 125143, '\P{^Dia=y}', "");
Expect(1, 125142, '\p{Dia=	Y}', "");
Expect(0, 125142, '\p{^Dia=	Y}', "");
Expect(0, 125142, '\P{Dia=	Y}', "");
Expect(1, 125142, '\P{^Dia=	Y}', "");
Expect(0, 125143, '\p{Dia=	Y}', "");
Expect(1, 125143, '\p{^Dia=	Y}', "");
Expect(1, 125143, '\P{Dia=	Y}', "");
Expect(0, 125143, '\P{^Dia=	Y}', "");
Error('\p{Is_Diacritic:/a/_T}');
Error('\P{Is_Diacritic:/a/_T}');
Expect(1, 125142, '\p{Is_Diacritic=t}', "");
Expect(0, 125142, '\p{^Is_Diacritic=t}', "");
Expect(0, 125142, '\P{Is_Diacritic=t}', "");
Expect(1, 125142, '\P{^Is_Diacritic=t}', "");
Expect(0, 125143, '\p{Is_Diacritic=t}', "");
Expect(1, 125143, '\p{^Is_Diacritic=t}', "");
Expect(1, 125143, '\P{Is_Diacritic=t}', "");
Expect(0, 125143, '\P{^Is_Diacritic=t}', "");
Expect(1, 125142, '\p{Is_Diacritic=_	T}', "");
Expect(0, 125142, '\p{^Is_Diacritic=_	T}', "");
Expect(0, 125142, '\P{Is_Diacritic=_	T}', "");
Expect(1, 125142, '\P{^Is_Diacritic=_	T}', "");
Expect(0, 125143, '\p{Is_Diacritic=_	T}', "");
Expect(1, 125143, '\p{^Is_Diacritic=_	T}', "");
Expect(1, 125143, '\P{Is_Diacritic=_	T}', "");
Expect(0, 125143, '\P{^Is_Diacritic=_	T}', "");
Error('\p{Is_Dia=:=_TRUE}');
Error('\P{Is_Dia=:=_TRUE}');
Expect(1, 125142, '\p{Is_Dia:   true}', "");
Expect(0, 125142, '\p{^Is_Dia:   true}', "");
Expect(0, 125142, '\P{Is_Dia:   true}', "");
Expect(1, 125142, '\P{^Is_Dia:   true}', "");
Expect(0, 125143, '\p{Is_Dia:   true}', "");
Expect(1, 125143, '\p{^Is_Dia:   true}', "");
Expect(1, 125143, '\P{Is_Dia:   true}', "");
Expect(0, 125143, '\P{^Is_Dia:   true}', "");
Expect(1, 125142, '\p{Is_Dia:	-TRUE}', "");
Expect(0, 125142, '\p{^Is_Dia:	-TRUE}', "");
Expect(0, 125142, '\P{Is_Dia:	-TRUE}', "");
Expect(1, 125142, '\P{^Is_Dia:	-TRUE}', "");
Expect(0, 125143, '\p{Is_Dia:	-TRUE}', "");
Expect(1, 125143, '\p{^Is_Dia:	-TRUE}', "");
Expect(1, 125143, '\P{Is_Dia:	-TRUE}', "");
Expect(0, 125143, '\P{^Is_Dia:	-TRUE}', "");
Error('\p{Extender=:= 	no}');
Error('\P{Extender=:= 	no}');
Expect(1, 92996, '\p{Extender=no}', "");
Expect(0, 92996, '\p{^Extender=no}', "");
Expect(0, 92996, '\P{Extender=no}', "");
Expect(1, 92996, '\P{^Extender=no}', "");
Expect(0, 92995, '\p{Extender=no}', "");
Expect(1, 92995, '\p{^Extender=no}', "");
Expect(1, 92995, '\P{Extender=no}', "");
Expect(0, 92995, '\P{^Extender=no}', "");
Expect(1, 92996, '\p{Extender= no}', "");
Expect(0, 92996, '\p{^Extender= no}', "");
Expect(0, 92996, '\P{Extender= no}', "");
Expect(1, 92996, '\P{^Extender= no}', "");
Expect(0, 92995, '\p{Extender= no}', "");
Expect(1, 92995, '\p{^Extender= no}', "");
Expect(1, 92995, '\P{Extender= no}', "");
Expect(0, 92995, '\P{^Extender= no}', "");
Error('\p{Ext= /a/N}');
Error('\P{Ext= /a/N}');
Expect(1, 92996, '\p{Ext=n}', "");
Expect(0, 92996, '\p{^Ext=n}', "");
Expect(0, 92996, '\P{Ext=n}', "");
Expect(1, 92996, '\P{^Ext=n}', "");
Expect(0, 92995, '\p{Ext=n}', "");
Expect(1, 92995, '\p{^Ext=n}', "");
Expect(1, 92995, '\P{Ext=n}', "");
Expect(0, 92995, '\P{^Ext=n}', "");
Expect(1, 92996, '\p{Ext= n}', "");
Expect(0, 92996, '\p{^Ext= n}', "");
Expect(0, 92996, '\P{Ext= n}', "");
Expect(1, 92996, '\P{^Ext= n}', "");
Expect(0, 92995, '\p{Ext= n}', "");
Expect(1, 92995, '\p{^Ext= n}', "");
Expect(1, 92995, '\P{Ext= n}', "");
Expect(0, 92995, '\P{^Ext= n}', "");
Error('\p{Is_Extender=:= _F}');
Error('\P{Is_Extender=:= _F}');
Expect(1, 92996, '\p{Is_Extender=f}', "");
Expect(0, 92996, '\p{^Is_Extender=f}', "");
Expect(0, 92996, '\P{Is_Extender=f}', "");
Expect(1, 92996, '\P{^Is_Extender=f}', "");
Expect(0, 92995, '\p{Is_Extender=f}', "");
Expect(1, 92995, '\p{^Is_Extender=f}', "");
Expect(1, 92995, '\P{Is_Extender=f}', "");
Expect(0, 92995, '\P{^Is_Extender=f}', "");
Expect(1, 92996, '\p{Is_Extender=-F}', "");
Expect(0, 92996, '\p{^Is_Extender=-F}', "");
Expect(0, 92996, '\P{Is_Extender=-F}', "");
Expect(1, 92996, '\P{^Is_Extender=-F}', "");
Expect(0, 92995, '\p{Is_Extender=-F}', "");
Expect(1, 92995, '\p{^Is_Extender=-F}', "");
Expect(1, 92995, '\P{Is_Extender=-F}', "");
Expect(0, 92995, '\P{^Is_Extender=-F}', "");
Error('\p{Is_Ext=/a/-False}');
Error('\P{Is_Ext=/a/-False}');
Expect(1, 92996, '\p{Is_Ext=false}', "");
Expect(0, 92996, '\p{^Is_Ext=false}', "");
Expect(0, 92996, '\P{Is_Ext=false}', "");
Expect(1, 92996, '\P{^Is_Ext=false}', "");
Expect(0, 92995, '\p{Is_Ext=false}', "");
Expect(1, 92995, '\p{^Is_Ext=false}', "");
Expect(1, 92995, '\P{Is_Ext=false}', "");
Expect(0, 92995, '\P{^Is_Ext=false}', "");
Expect(1, 92996, '\p{Is_Ext=		False}', "");
Expect(0, 92996, '\p{^Is_Ext=		False}', "");
Expect(0, 92996, '\P{Is_Ext=		False}', "");
Expect(1, 92996, '\P{^Is_Ext=		False}', "");
Expect(0, 92995, '\p{Is_Ext=		False}', "");
Expect(1, 92995, '\p{^Is_Ext=		False}', "");
Expect(1, 92995, '\P{Is_Ext=		False}', "");
Expect(0, 92995, '\P{^Is_Ext=		False}', "");
Error('\p{Extender=	 Yes:=}');
Error('\P{Extender=	 Yes:=}');
Expect(1, 92995, '\p{Extender=yes}', "");
Expect(0, 92995, '\p{^Extender=yes}', "");
Expect(0, 92995, '\P{Extender=yes}', "");
Expect(1, 92995, '\P{^Extender=yes}', "");
Expect(0, 92996, '\p{Extender=yes}', "");
Expect(1, 92996, '\p{^Extender=yes}', "");
Expect(1, 92996, '\P{Extender=yes}', "");
Expect(0, 92996, '\P{^Extender=yes}', "");
Expect(1, 92995, '\p{Extender= yes}', "");
Expect(0, 92995, '\p{^Extender= yes}', "");
Expect(0, 92995, '\P{Extender= yes}', "");
Expect(1, 92995, '\P{^Extender= yes}', "");
Expect(0, 92996, '\p{Extender= yes}', "");
Expect(1, 92996, '\p{^Extender= yes}', "");
Expect(1, 92996, '\P{Extender= yes}', "");
Expect(0, 92996, '\P{^Extender= yes}', "");
Error('\p{Ext= _Y:=}');
Error('\P{Ext= _Y:=}');
Expect(1, 92995, '\p{Ext:   y}', "");
Expect(0, 92995, '\p{^Ext:   y}', "");
Expect(0, 92995, '\P{Ext:   y}', "");
Expect(1, 92995, '\P{^Ext:   y}', "");
Expect(0, 92996, '\p{Ext:   y}', "");
Expect(1, 92996, '\p{^Ext:   y}', "");
Expect(1, 92996, '\P{Ext:   y}', "");
Expect(0, 92996, '\P{^Ext:   y}', "");
Expect(1, 92995, '\p{Ext=	_y}', "");
Expect(0, 92995, '\p{^Ext=	_y}', "");
Expect(0, 92995, '\P{Ext=	_y}', "");
Expect(1, 92995, '\P{^Ext=	_y}', "");
Expect(0, 92996, '\p{Ext=	_y}', "");
Expect(1, 92996, '\p{^Ext=	_y}', "");
Expect(1, 92996, '\P{Ext=	_y}', "");
Expect(0, 92996, '\P{^Ext=	_y}', "");
Error('\p{Is_Extender=	:=T}');
Error('\P{Is_Extender=	:=T}');
Expect(1, 92995, '\p{Is_Extender=t}', "");
Expect(0, 92995, '\p{^Is_Extender=t}', "");
Expect(0, 92995, '\P{Is_Extender=t}', "");
Expect(1, 92995, '\P{^Is_Extender=t}', "");
Expect(0, 92996, '\p{Is_Extender=t}', "");
Expect(1, 92996, '\p{^Is_Extender=t}', "");
Expect(1, 92996, '\P{Is_Extender=t}', "");
Expect(0, 92996, '\P{^Is_Extender=t}', "");
Expect(1, 92995, '\p{Is_Extender= T}', "");
Expect(0, 92995, '\p{^Is_Extender= T}', "");
Expect(0, 92995, '\P{Is_Extender= T}', "");
Expect(1, 92995, '\P{^Is_Extender= T}', "");
Expect(0, 92996, '\p{Is_Extender= T}', "");
Expect(1, 92996, '\p{^Is_Extender= T}', "");
Expect(1, 92996, '\P{Is_Extender= T}', "");
Expect(0, 92996, '\P{^Is_Extender= T}', "");
Error('\p{Is_Ext=/a/		True}');
Error('\P{Is_Ext=/a/		True}');
Expect(1, 92995, '\p{Is_Ext:	true}', "");
Expect(0, 92995, '\p{^Is_Ext:	true}', "");
Expect(0, 92995, '\P{Is_Ext:	true}', "");
Expect(1, 92995, '\P{^Is_Ext:	true}', "");
Expect(0, 92996, '\p{Is_Ext:	true}', "");
Expect(1, 92996, '\p{^Is_Ext:	true}', "");
Expect(1, 92996, '\P{Is_Ext:	true}', "");
Expect(0, 92996, '\P{^Is_Ext:	true}', "");
Expect(1, 92995, '\p{Is_Ext=		true}', "");
Expect(0, 92995, '\p{^Is_Ext=		true}', "");
Expect(0, 92995, '\P{Is_Ext=		true}', "");
Expect(1, 92995, '\P{^Is_Ext=		true}', "");
Expect(0, 92996, '\p{Is_Ext=		true}', "");
Expect(1, 92996, '\p{^Is_Ext=		true}', "");
Expect(1, 92996, '\P{Is_Ext=		true}', "");
Expect(0, 92996, '\P{^Is_Ext=		true}', "");
Error('\p{Grapheme_Cluster_Break=/a/	-Control}');
Error('\P{Grapheme_Cluster_Break=/a/	-Control}');
Expect(1, 921599, '\p{Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\P{Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\p{Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\p{^Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\P{Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\P{^Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\p{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921599, '\p{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921599, '\P{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921599, '\P{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921600, '\p{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921600, '\p{^Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(1, 921600, '\P{Grapheme_Cluster_Break=_-CONTROL}', "");
Expect(0, 921600, '\P{^Grapheme_Cluster_Break=_-CONTROL}', "");
Error('\p{GCB=_/a/CN}');
Error('\P{GCB=_/a/CN}');
Expect(1, 921599, '\p{GCB:cn}', "");
Expect(0, 921599, '\p{^GCB:cn}', "");
Expect(0, 921599, '\P{GCB:cn}', "");
Expect(1, 921599, '\P{^GCB:cn}', "");
Expect(0, 921600, '\p{GCB:cn}', "");
Expect(1, 921600, '\p{^GCB:cn}', "");
Expect(1, 921600, '\P{GCB:cn}', "");
Expect(0, 921600, '\P{^GCB:cn}', "");
Expect(1, 921599, '\p{GCB=		CN}', "");
Expect(0, 921599, '\p{^GCB=		CN}', "");
Expect(0, 921599, '\P{GCB=		CN}', "");
Expect(1, 921599, '\P{^GCB=		CN}', "");
Expect(0, 921600, '\p{GCB=		CN}', "");
Expect(1, 921600, '\p{^GCB=		CN}', "");
Expect(1, 921600, '\P{GCB=		CN}', "");
Expect(0, 921600, '\P{^GCB=		CN}', "");
Error('\p{Is_Grapheme_Cluster_Break=-/a/Control}');
Error('\P{Is_Grapheme_Cluster_Break=-/a/Control}');
Expect(1, 921599, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921599, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\p{Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\p{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921600, '\P{Is_Grapheme_Cluster_Break=control}', "");
Expect(0, 921600, '\P{^Is_Grapheme_Cluster_Break=control}', "");
Expect(1, 921599, '\p{Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921599, '\p{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921599, '\P{Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921599, '\P{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921600, '\p{Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921600, '\p{^Is_Grapheme_Cluster_Break=	control}', "");
Expect(1, 921600, '\P{Is_Grapheme_Cluster_Break=	control}', "");
Expect(0, 921600, '\P{^Is_Grapheme_Cluster_Break=	control}', "");
Error('\p{Is_GCB:	- CN/a/}');
Error('\P{Is_GCB:	- CN/a/}');
Expect(1, 921599, '\p{Is_GCB=cn}', "");
Expect(0, 921599, '\p{^Is_GCB=cn}', "");
Expect(0, 921599, '\P{Is_GCB=cn}', "");
Expect(1, 921599, '\P{^Is_GCB=cn}', "");
Expect(0, 921600, '\p{Is_GCB=cn}', "");
Expect(1, 921600, '\p{^Is_GCB=cn}', "");
Expect(1, 921600, '\P{Is_GCB=cn}', "");
Expect(0, 921600, '\P{^Is_GCB=cn}', "");
Expect(1, 921599, '\p{Is_GCB=	cn}', "");
Expect(0, 921599, '\p{^Is_GCB=	cn}', "");
Expect(0, 921599, '\P{Is_GCB=	cn}', "");
Expect(1, 921599, '\P{^Is_GCB=	cn}', "");
Expect(0, 921600, '\p{Is_GCB=	cn}', "");
Expect(1, 921600, '\p{^Is_GCB=	cn}', "");
Expect(1, 921600, '\P{Is_GCB=	cn}', "");
Expect(0, 921600, '\P{^Is_GCB=	cn}', "");
Error('\p{Grapheme_Cluster_Break=/a/ _CR}');
Error('\P{Grapheme_Cluster_Break=/a/ _CR}');
Expect(1, 13, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\p{Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\p{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\P{Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\P{^Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Grapheme_Cluster_Break= CR}', "");
Expect(0, 13, '\p{^Grapheme_Cluster_Break= CR}', "");
Expect(0, 13, '\P{Grapheme_Cluster_Break= CR}', "");
Expect(1, 13, '\P{^Grapheme_Cluster_Break= CR}', "");
Expect(0, 14, '\p{Grapheme_Cluster_Break= CR}', "");
Expect(1, 14, '\p{^Grapheme_Cluster_Break= CR}', "");
Expect(1, 14, '\P{Grapheme_Cluster_Break= CR}', "");
Expect(0, 14, '\P{^Grapheme_Cluster_Break= CR}', "");
Error('\p{GCB=:=	 CR}');
Error('\P{GCB=:=	 CR}');
Expect(1, 13, '\p{GCB=cr}', "");
Expect(0, 13, '\p{^GCB=cr}', "");
Expect(0, 13, '\P{GCB=cr}', "");
Expect(1, 13, '\P{^GCB=cr}', "");
Expect(0, 14, '\p{GCB=cr}', "");
Expect(1, 14, '\p{^GCB=cr}', "");
Expect(1, 14, '\P{GCB=cr}', "");
Expect(0, 14, '\P{^GCB=cr}', "");
Expect(1, 13, '\p{GCB= 	CR}', "");
Expect(0, 13, '\p{^GCB= 	CR}', "");
Expect(0, 13, '\P{GCB= 	CR}', "");
Expect(1, 13, '\P{^GCB= 	CR}', "");
Expect(0, 14, '\p{GCB= 	CR}', "");
Expect(1, 14, '\p{^GCB= 	CR}', "");
Expect(1, 14, '\P{GCB= 	CR}', "");
Expect(0, 14, '\P{^GCB= 	CR}', "");
Error('\p{Is_Grapheme_Cluster_Break=	-cr/a/}');
Error('\P{Is_Grapheme_Cluster_Break=	-cr/a/}');
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\p{Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\p{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 14, '\P{Is_Grapheme_Cluster_Break=cr}', "");
Expect(0, 14, '\P{^Is_Grapheme_Cluster_Break=cr}', "");
Expect(1, 13, '\p{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 13, '\p{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 13, '\P{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 13, '\P{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 14, '\p{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 14, '\p{^Is_Grapheme_Cluster_Break=-CR}', "");
Expect(1, 14, '\P{Is_Grapheme_Cluster_Break=-CR}', "");
Expect(0, 14, '\P{^Is_Grapheme_Cluster_Break=-CR}', "");
Error('\p{Is_GCB= -cr/a/}');
Error('\P{Is_GCB= -cr/a/}');
Expect(1, 13, '\p{Is_GCB=cr}', "");
Expect(0, 13, '\p{^Is_GCB=cr}', "");
Expect(0, 13, '\P{Is_GCB=cr}', "");
Expect(1, 13, '\P{^Is_GCB=cr}', "");
Expect(0, 14, '\p{Is_GCB=cr}', "");
Expect(1, 14, '\p{^Is_GCB=cr}', "");
Expect(1, 14, '\P{Is_GCB=cr}', "");
Expect(0, 14, '\P{^Is_GCB=cr}', "");
Expect(1, 13, '\p{Is_GCB= 	cr}', "");
Expect(0, 13, '\p{^Is_GCB= 	cr}', "");
Expect(0, 13, '\P{Is_GCB= 	cr}', "");
Expect(1, 13, '\P{^Is_GCB= 	cr}', "");
Expect(0, 14, '\p{Is_GCB= 	cr}', "");
Expect(1, 14, '\p{^Is_GCB= 	cr}', "");
Expect(1, 14, '\P{Is_GCB= 	cr}', "");
Expect(0, 14, '\P{^Is_GCB= 	cr}', "");
Error('\p{Grapheme_Cluster_Break=_extend:=}');
Error('\P{Grapheme_Cluster_Break=_extend:=}');
Expect(1, 917999, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\p{Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\p{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\P{Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\P{^Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\p{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 917999, '\p{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 917999, '\P{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 917999, '\P{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 918000, '\p{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 918000, '\p{^Grapheme_Cluster_Break=  EXTEND}', "");
Expect(1, 918000, '\P{Grapheme_Cluster_Break=  EXTEND}', "");
Expect(0, 918000, '\P{^Grapheme_Cluster_Break=  EXTEND}', "");
Error('\p{GCB=:= EX}');
Error('\P{GCB=:= EX}');
Expect(1, 917999, '\p{GCB=ex}', "");
Expect(0, 917999, '\p{^GCB=ex}', "");
Expect(0, 917999, '\P{GCB=ex}', "");
Expect(1, 917999, '\P{^GCB=ex}', "");
Expect(0, 918000, '\p{GCB=ex}', "");
Expect(1, 918000, '\p{^GCB=ex}', "");
Expect(1, 918000, '\P{GCB=ex}', "");
Expect(0, 918000, '\P{^GCB=ex}', "");
Expect(1, 917999, '\p{GCB:	 EX}', "");
Expect(0, 917999, '\p{^GCB:	 EX}', "");
Expect(0, 917999, '\P{GCB:	 EX}', "");
Expect(1, 917999, '\P{^GCB:	 EX}', "");
Expect(0, 918000, '\p{GCB:	 EX}', "");
Expect(1, 918000, '\p{^GCB:	 EX}', "");
Expect(1, 918000, '\P{GCB:	 EX}', "");
Expect(0, 918000, '\P{^GCB:	 EX}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=	_extend}');
Error('\P{Is_Grapheme_Cluster_Break=:=	_extend}');
Expect(1, 917999, '\p{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 917999, '\P{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\p{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 918000, '\P{Is_Grapheme_Cluster_Break:	extend}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Cluster_Break:	extend}', "");
Expect(1, 917999, '\p{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 917999, '\P{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 918000, '\p{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(1, 918000, '\P{Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Cluster_Break=	 EXTEND}', "");
Error('\p{Is_GCB=:= 	EX}');
Error('\P{Is_GCB=:= 	EX}');
Expect(1, 917999, '\p{Is_GCB=ex}', "");
Expect(0, 917999, '\p{^Is_GCB=ex}', "");
Expect(0, 917999, '\P{Is_GCB=ex}', "");
Expect(1, 917999, '\P{^Is_GCB=ex}', "");
Expect(0, 918000, '\p{Is_GCB=ex}', "");
Expect(1, 918000, '\p{^Is_GCB=ex}', "");
Expect(1, 918000, '\P{Is_GCB=ex}', "");
Expect(0, 918000, '\P{^Is_GCB=ex}', "");
Expect(1, 917999, '\p{Is_GCB=- EX}', "");
Expect(0, 917999, '\p{^Is_GCB=- EX}', "");
Expect(0, 917999, '\P{Is_GCB=- EX}', "");
Expect(1, 917999, '\P{^Is_GCB=- EX}', "");
Expect(0, 918000, '\p{Is_GCB=- EX}', "");
Expect(1, 918000, '\p{^Is_GCB=- EX}', "");
Expect(1, 918000, '\P{Is_GCB=- EX}', "");
Expect(0, 918000, '\P{^Is_GCB=- EX}', "");
Error('\p{Grapheme_Cluster_Break=	l/a/}');
Error('\P{Grapheme_Cluster_Break=	l/a/}');
Expect(1, 43388, '\p{Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\P{Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\p{Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\p{^Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\P{Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\P{^Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\p{Grapheme_Cluster_Break=__L}', "");
Expect(0, 43388, '\p{^Grapheme_Cluster_Break=__L}', "");
Expect(0, 43388, '\P{Grapheme_Cluster_Break=__L}', "");
Expect(1, 43388, '\P{^Grapheme_Cluster_Break=__L}', "");
Expect(0, 43389, '\p{Grapheme_Cluster_Break=__L}', "");
Expect(1, 43389, '\p{^Grapheme_Cluster_Break=__L}', "");
Expect(1, 43389, '\P{Grapheme_Cluster_Break=__L}', "");
Expect(0, 43389, '\P{^Grapheme_Cluster_Break=__L}', "");
Error('\p{GCB=  L:=}');
Error('\P{GCB=  L:=}');
Expect(1, 43388, '\p{GCB=l}', "");
Expect(0, 43388, '\p{^GCB=l}', "");
Expect(0, 43388, '\P{GCB=l}', "");
Expect(1, 43388, '\P{^GCB=l}', "");
Expect(0, 43389, '\p{GCB=l}', "");
Expect(1, 43389, '\p{^GCB=l}', "");
Expect(1, 43389, '\P{GCB=l}', "");
Expect(0, 43389, '\P{^GCB=l}', "");
Expect(1, 43388, '\p{GCB= -L}', "");
Expect(0, 43388, '\p{^GCB= -L}', "");
Expect(0, 43388, '\P{GCB= -L}', "");
Expect(1, 43388, '\P{^GCB= -L}', "");
Expect(0, 43389, '\p{GCB= -L}', "");
Expect(1, 43389, '\p{^GCB= -L}', "");
Expect(1, 43389, '\P{GCB= -L}', "");
Expect(0, 43389, '\P{^GCB= -L}', "");
Error('\p{Is_Grapheme_Cluster_Break:	  l:=}');
Error('\P{Is_Grapheme_Cluster_Break:	  l:=}');
Expect(1, 43388, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43388, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\p{Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\p{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43389, '\P{Is_Grapheme_Cluster_Break=l}', "");
Expect(0, 43389, '\P{^Is_Grapheme_Cluster_Break=l}', "");
Expect(1, 43388, '\p{Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43388, '\p{^Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43388, '\P{Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43388, '\P{^Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43389, '\p{Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43389, '\p{^Is_Grapheme_Cluster_Break=L}', "");
Expect(1, 43389, '\P{Is_Grapheme_Cluster_Break=L}', "");
Expect(0, 43389, '\P{^Is_Grapheme_Cluster_Break=L}', "");
Error('\p{Is_GCB=	_L:=}');
Error('\P{Is_GCB=	_L:=}');
Expect(1, 43388, '\p{Is_GCB=l}', "");
Expect(0, 43388, '\p{^Is_GCB=l}', "");
Expect(0, 43388, '\P{Is_GCB=l}', "");
Expect(1, 43388, '\P{^Is_GCB=l}', "");
Expect(0, 43389, '\p{Is_GCB=l}', "");
Expect(1, 43389, '\p{^Is_GCB=l}', "");
Expect(1, 43389, '\P{Is_GCB=l}', "");
Expect(0, 43389, '\P{^Is_GCB=l}', "");
Expect(1, 43388, '\p{Is_GCB=-_L}', "");
Expect(0, 43388, '\p{^Is_GCB=-_L}', "");
Expect(0, 43388, '\P{Is_GCB=-_L}', "");
Expect(1, 43388, '\P{^Is_GCB=-_L}', "");
Expect(0, 43389, '\p{Is_GCB=-_L}', "");
Expect(1, 43389, '\p{^Is_GCB=-_L}', "");
Expect(1, 43389, '\P{Is_GCB=-_L}', "");
Expect(0, 43389, '\P{^Is_GCB=-_L}', "");
Error('\p{Grapheme_Cluster_Break:  LF:=}');
Error('\P{Grapheme_Cluster_Break:  LF:=}');
Expect(1, 10, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\p{Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\p{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\P{Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\P{^Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Grapheme_Cluster_Break=__LF}', "");
Expect(0, 10, '\p{^Grapheme_Cluster_Break=__LF}', "");
Expect(0, 10, '\P{Grapheme_Cluster_Break=__LF}', "");
Expect(1, 10, '\P{^Grapheme_Cluster_Break=__LF}', "");
Expect(0, 11, '\p{Grapheme_Cluster_Break=__LF}', "");
Expect(1, 11, '\p{^Grapheme_Cluster_Break=__LF}', "");
Expect(1, 11, '\P{Grapheme_Cluster_Break=__LF}', "");
Expect(0, 11, '\P{^Grapheme_Cluster_Break=__LF}', "");
Error('\p{GCB= :=lf}');
Error('\P{GCB= :=lf}');
Expect(1, 10, '\p{GCB:   lf}', "");
Expect(0, 10, '\p{^GCB:   lf}', "");
Expect(0, 10, '\P{GCB:   lf}', "");
Expect(1, 10, '\P{^GCB:   lf}', "");
Expect(0, 11, '\p{GCB:   lf}', "");
Expect(1, 11, '\p{^GCB:   lf}', "");
Expect(1, 11, '\P{GCB:   lf}', "");
Expect(0, 11, '\P{^GCB:   lf}', "");
Expect(1, 10, '\p{GCB=	_LF}', "");
Expect(0, 10, '\p{^GCB=	_LF}', "");
Expect(0, 10, '\P{GCB=	_LF}', "");
Expect(1, 10, '\P{^GCB=	_LF}', "");
Expect(0, 11, '\p{GCB=	_LF}', "");
Expect(1, 11, '\p{^GCB=	_LF}', "");
Expect(1, 11, '\P{GCB=	_LF}', "");
Expect(0, 11, '\P{^GCB=	_LF}', "");
Error('\p{Is_Grapheme_Cluster_Break=	-LF/a/}');
Error('\P{Is_Grapheme_Cluster_Break=	-LF/a/}');
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\p{Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\p{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 11, '\P{Is_Grapheme_Cluster_Break=lf}', "");
Expect(0, 11, '\P{^Is_Grapheme_Cluster_Break=lf}', "");
Expect(1, 10, '\p{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 10, '\p{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 10, '\P{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 10, '\P{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 11, '\p{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 11, '\p{^Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(1, 11, '\P{Is_Grapheme_Cluster_Break=	_LF}', "");
Expect(0, 11, '\P{^Is_Grapheme_Cluster_Break=	_LF}', "");
Error('\p{Is_GCB::=	lf}');
Error('\P{Is_GCB::=	lf}');
Expect(1, 10, '\p{Is_GCB: lf}', "");
Expect(0, 10, '\p{^Is_GCB: lf}', "");
Expect(0, 10, '\P{Is_GCB: lf}', "");
Expect(1, 10, '\P{^Is_GCB: lf}', "");
Expect(0, 11, '\p{Is_GCB: lf}', "");
Expect(1, 11, '\p{^Is_GCB: lf}', "");
Expect(1, 11, '\P{Is_GCB: lf}', "");
Expect(0, 11, '\P{^Is_GCB: lf}', "");
Expect(1, 10, '\p{Is_GCB= LF}', "");
Expect(0, 10, '\p{^Is_GCB= LF}', "");
Expect(0, 10, '\P{Is_GCB= LF}', "");
Expect(1, 10, '\P{^Is_GCB= LF}', "");
Expect(0, 11, '\p{Is_GCB= LF}', "");
Expect(1, 11, '\p{^Is_GCB= LF}', "");
Expect(1, 11, '\P{Is_GCB= LF}', "");
Expect(0, 11, '\P{^Is_GCB= LF}', "");
Error('\p{Grapheme_Cluster_Break=  lv/a/}');
Error('\P{Grapheme_Cluster_Break=  lv/a/}');
Expect(1, 55176, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\p{Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\p{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\P{Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\P{^Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\p{Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55176, '\p{^Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55176, '\P{Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55176, '\P{^Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55177, '\p{Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55177, '\p{^Grapheme_Cluster_Break:	-LV}', "");
Expect(1, 55177, '\P{Grapheme_Cluster_Break:	-LV}', "");
Expect(0, 55177, '\P{^Grapheme_Cluster_Break:	-LV}', "");
Error('\p{GCB=	LV:=}');
Error('\P{GCB=	LV:=}');
Expect(1, 55176, '\p{GCB: lv}', "");
Expect(0, 55176, '\p{^GCB: lv}', "");
Expect(0, 55176, '\P{GCB: lv}', "");
Expect(1, 55176, '\P{^GCB: lv}', "");
Expect(0, 55177, '\p{GCB: lv}', "");
Expect(1, 55177, '\p{^GCB: lv}', "");
Expect(1, 55177, '\P{GCB: lv}', "");
Expect(0, 55177, '\P{^GCB: lv}', "");
Expect(1, 55176, '\p{GCB=_ lv}', "");
Expect(0, 55176, '\p{^GCB=_ lv}', "");
Expect(0, 55176, '\P{GCB=_ lv}', "");
Expect(1, 55176, '\P{^GCB=_ lv}', "");
Expect(0, 55177, '\p{GCB=_ lv}', "");
Expect(1, 55177, '\p{^GCB=_ lv}', "");
Expect(1, 55177, '\P{GCB=_ lv}', "");
Expect(0, 55177, '\P{^GCB=_ lv}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=- LV}');
Error('\P{Is_Grapheme_Cluster_Break=:=- LV}');
Expect(1, 55176, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55176, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\p{Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\p{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55177, '\P{Is_Grapheme_Cluster_Break=lv}', "");
Expect(0, 55177, '\P{^Is_Grapheme_Cluster_Break=lv}', "");
Expect(1, 55176, '\p{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55176, '\p{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55176, '\P{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55176, '\P{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55177, '\p{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55177, '\p{^Is_Grapheme_Cluster_Break=-LV}', "");
Expect(1, 55177, '\P{Is_Grapheme_Cluster_Break=-LV}', "");
Expect(0, 55177, '\P{^Is_Grapheme_Cluster_Break=-LV}', "");
Error('\p{Is_GCB=_	LV:=}');
Error('\P{Is_GCB=_	LV:=}');
Expect(1, 55176, '\p{Is_GCB=lv}', "");
Expect(0, 55176, '\p{^Is_GCB=lv}', "");
Expect(0, 55176, '\P{Is_GCB=lv}', "");
Expect(1, 55176, '\P{^Is_GCB=lv}', "");
Expect(0, 55177, '\p{Is_GCB=lv}', "");
Expect(1, 55177, '\p{^Is_GCB=lv}', "");
Expect(1, 55177, '\P{Is_GCB=lv}', "");
Expect(0, 55177, '\P{^Is_GCB=lv}', "");
Expect(1, 55176, '\p{Is_GCB=	_lv}', "");
Expect(0, 55176, '\p{^Is_GCB=	_lv}', "");
Expect(0, 55176, '\P{Is_GCB=	_lv}', "");
Expect(1, 55176, '\P{^Is_GCB=	_lv}', "");
Expect(0, 55177, '\p{Is_GCB=	_lv}', "");
Expect(1, 55177, '\p{^Is_GCB=	_lv}', "");
Expect(1, 55177, '\P{Is_GCB=	_lv}', "");
Expect(0, 55177, '\P{^Is_GCB=	_lv}', "");
Error('\p{Grapheme_Cluster_Break=__lvt/a/}');
Error('\P{Grapheme_Cluster_Break=__lvt/a/}');
Expect(1, 55203, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55203, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55203, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55203, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55204, '\p{Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55204, '\p{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55204, '\P{Grapheme_Cluster_Break=lvt}', "");
Expect(0, 55204, '\P{^Grapheme_Cluster_Break=lvt}', "");
Expect(1, 55203, '\p{Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55203, '\p{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55203, '\P{Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55203, '\P{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55204, '\p{Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55204, '\p{^Grapheme_Cluster_Break=	 lvt}', "");
Expect(1, 55204, '\P{Grapheme_Cluster_Break=	 lvt}', "");
Expect(0, 55204, '\P{^Grapheme_Cluster_Break=	 lvt}', "");
Error('\p{GCB= LVT/a/}');
Error('\P{GCB= LVT/a/}');
Expect(1, 55203, '\p{GCB=lvt}', "");
Expect(0, 55203, '\p{^GCB=lvt}', "");
Expect(0, 55203, '\P{GCB=lvt}', "");
Expect(1, 55203, '\P{^GCB=lvt}', "");
Expect(0, 55204, '\p{GCB=lvt}', "");
Expect(1, 55204, '\p{^GCB=lvt}', "");
Expect(1, 55204, '\P{GCB=lvt}', "");
Expect(0, 55204, '\P{^GCB=lvt}', "");
Expect(1, 55203, '\p{GCB=_ LVT}', "");
Expect(0, 55203, '\p{^GCB=_ LVT}', "");
Expect(0, 55203, '\P{GCB=_ LVT}', "");
Expect(1, 55203, '\P{^GCB=_ LVT}', "");
Expect(0, 55204, '\p{GCB=_ LVT}', "");
Expect(1, 55204, '\p{^GCB=_ LVT}', "");
Expect(1, 55204, '\P{GCB=_ LVT}', "");
Expect(0, 55204, '\P{^GCB=_ LVT}', "");
Error('\p{Is_Grapheme_Cluster_Break=--LVT/a/}');
Error('\P{Is_Grapheme_Cluster_Break=--LVT/a/}');
Expect(1, 55203, '\p{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55203, '\p{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55203, '\P{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55203, '\P{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55204, '\p{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55204, '\p{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55204, '\P{Is_Grapheme_Cluster_Break: lvt}', "");
Expect(0, 55204, '\P{^Is_Grapheme_Cluster_Break: lvt}', "");
Expect(1, 55203, '\p{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55203, '\p{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55203, '\P{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55203, '\P{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55204, '\p{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55204, '\p{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(1, 55204, '\P{Is_Grapheme_Cluster_Break:   - LVT}', "");
Expect(0, 55204, '\P{^Is_Grapheme_Cluster_Break:   - LVT}', "");
Error('\p{Is_GCB=-:=LVT}');
Error('\P{Is_GCB=-:=LVT}');
Expect(1, 55203, '\p{Is_GCB=lvt}', "");
Expect(0, 55203, '\p{^Is_GCB=lvt}', "");
Expect(0, 55203, '\P{Is_GCB=lvt}', "");
Expect(1, 55203, '\P{^Is_GCB=lvt}', "");
Expect(0, 55204, '\p{Is_GCB=lvt}', "");
Expect(1, 55204, '\p{^Is_GCB=lvt}', "");
Expect(1, 55204, '\P{Is_GCB=lvt}', "");
Expect(0, 55204, '\P{^Is_GCB=lvt}', "");
Expect(1, 55203, '\p{Is_GCB=-_lvt}', "");
Expect(0, 55203, '\p{^Is_GCB=-_lvt}', "");
Expect(0, 55203, '\P{Is_GCB=-_lvt}', "");
Expect(1, 55203, '\P{^Is_GCB=-_lvt}', "");
Expect(0, 55204, '\p{Is_GCB=-_lvt}', "");
Expect(1, 55204, '\p{^Is_GCB=-_lvt}', "");
Expect(1, 55204, '\P{Is_GCB=-_lvt}', "");
Expect(0, 55204, '\P{^Is_GCB=-_lvt}', "");
Error('\p{Grapheme_Cluster_Break=:=_ Prepend}');
Error('\P{Grapheme_Cluster_Break=:=_ Prepend}');
Expect(0, 1, '\p{Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\p{^Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\P{Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\P{^Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\p{Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(1, 1, '\p{^Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(1, 1, '\P{Grapheme_Cluster_Break= 	PREPEND}', "");
Expect(0, 1, '\P{^Grapheme_Cluster_Break= 	PREPEND}', "");
Error('\p{GCB:- PP/a/}');
Error('\P{GCB:- PP/a/}');
Expect(0, 1, '\p{GCB=pp}', "");
Expect(1, 1, '\p{^GCB=pp}', "");
Expect(1, 1, '\P{GCB=pp}', "");
Expect(0, 1, '\P{^GCB=pp}', "");
Expect(0, 1, '\p{GCB=_PP}', "");
Expect(1, 1, '\p{^GCB=_PP}', "");
Expect(1, 1, '\P{GCB=_PP}', "");
Expect(0, 1, '\P{^GCB=_PP}', "");
Error('\p{Is_Grapheme_Cluster_Break=:=-_prepend}');
Error('\P{Is_Grapheme_Cluster_Break=:=-_prepend}');
Expect(0, 1, '\p{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\p{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(1, 1, '\P{Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\P{^Is_Grapheme_Cluster_Break=prepend}', "");
Expect(0, 1, '\p{Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(1, 1, '\p{^Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(1, 1, '\P{Is_Grapheme_Cluster_Break=-_Prepend}', "");
Expect(0, 1, '\P{^Is_Grapheme_Cluster_Break=-_Prepend}', "");
Error('\p{Is_GCB=/a/__PP}');
Error('\P{Is_GCB=/a/__PP}');
Expect(0, 1, '\p{Is_GCB=pp}', "");
Expect(1, 1, '\p{^Is_GCB=pp}', "");
Expect(1, 1, '\P{Is_GCB=pp}', "");
Expect(0, 1, '\P{^Is_GCB=pp}', "");
Expect(0, 1, '\p{Is_GCB=_PP}', "");
Expect(1, 1, '\p{^Is_GCB=_PP}', "");
Expect(1, 1, '\P{Is_GCB=_PP}', "");
Expect(0, 1, '\P{^Is_GCB=_PP}', "");
Error('\p{Grapheme_Cluster_Break=:= regional_indicator}');
Error('\P{Grapheme_Cluster_Break=:= regional_indicator}');
Expect(1, 127487, '\p{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\p{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\P{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127487, '\P{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\p{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\p{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\P{Grapheme_Cluster_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\P{^Grapheme_Cluster_Break= -Regional_Indicator}', "");
Error('\p{GCB=__RI/a/}');
Error('\P{GCB=__RI/a/}');
Expect(1, 127487, '\p{GCB=ri}', "");
Expect(0, 127487, '\p{^GCB=ri}', "");
Expect(0, 127487, '\P{GCB=ri}', "");
Expect(1, 127487, '\P{^GCB=ri}', "");
Expect(0, 127488, '\p{GCB=ri}', "");
Expect(1, 127488, '\p{^GCB=ri}', "");
Expect(1, 127488, '\P{GCB=ri}', "");
Expect(0, 127488, '\P{^GCB=ri}', "");
Expect(1, 127487, '\p{GCB:    ri}', "");
Expect(0, 127487, '\p{^GCB:    ri}', "");
Expect(0, 127487, '\P{GCB:    ri}', "");
Expect(1, 127487, '\P{^GCB:    ri}', "");
Expect(0, 127488, '\p{GCB:    ri}', "");
Expect(1, 127488, '\p{^GCB:    ri}', "");
Expect(1, 127488, '\P{GCB:    ri}', "");
Expect(0, 127488, '\P{^GCB:    ri}', "");
Error('\p{Is_Grapheme_Cluster_Break= 	regional_indicator/a/}');
Error('\P{Is_Grapheme_Cluster_Break= 	regional_indicator/a/}');
Expect(1, 127487, '\p{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Is_Grapheme_Cluster_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127487, '\p{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127487, '\P{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127487, '\P{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127488, '\p{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127488, '\p{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(1, 127488, '\P{Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Expect(0, 127488, '\P{^Is_Grapheme_Cluster_Break=-Regional_Indicator}', "");
Error('\p{Is_GCB=-:=RI}');
Error('\P{Is_GCB=-:=RI}');
Expect(1, 127487, '\p{Is_GCB=ri}', "");
Expect(0, 127487, '\p{^Is_GCB=ri}', "");
Expect(0, 127487, '\P{Is_GCB=ri}', "");
Expect(1, 127487, '\P{^Is_GCB=ri}', "");
Expect(0, 127488, '\p{Is_GCB=ri}', "");
Expect(1, 127488, '\p{^Is_GCB=ri}', "");
Expect(1, 127488, '\P{Is_GCB=ri}', "");
Expect(0, 127488, '\P{^Is_GCB=ri}', "");
Expect(1, 127487, '\p{Is_GCB= RI}', "");
Expect(0, 127487, '\p{^Is_GCB= RI}', "");
Expect(0, 127487, '\P{Is_GCB= RI}', "");
Expect(1, 127487, '\P{^Is_GCB= RI}', "");
Expect(0, 127488, '\p{Is_GCB= RI}', "");
Expect(1, 127488, '\p{^Is_GCB= RI}', "");
Expect(1, 127488, '\P{Is_GCB= RI}', "");
Expect(0, 127488, '\P{^Is_GCB= RI}', "");
Error('\p{Grapheme_Cluster_Break=:=--SPACINGMARK}');
Error('\P{Grapheme_Cluster_Break=:=--SPACINGMARK}');
Expect(1, 119149, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\p{Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\p{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\P{Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\P{^Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\p{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119149, '\p{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119149, '\P{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119149, '\P{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119150, '\p{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119150, '\p{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(1, 119150, '\P{Grapheme_Cluster_Break= SPACINGMARK}', "");
Expect(0, 119150, '\P{^Grapheme_Cluster_Break= SPACINGMARK}', "");
Error('\p{GCB= SM:=}');
Error('\P{GCB= SM:=}');
Expect(1, 119149, '\p{GCB:sm}', "");
Expect(0, 119149, '\p{^GCB:sm}', "");
Expect(0, 119149, '\P{GCB:sm}', "");
Expect(1, 119149, '\P{^GCB:sm}', "");
Expect(0, 119150, '\p{GCB:sm}', "");
Expect(1, 119150, '\p{^GCB:sm}', "");
Expect(1, 119150, '\P{GCB:sm}', "");
Expect(0, 119150, '\P{^GCB:sm}', "");
Expect(1, 119149, '\p{GCB=-_sm}', "");
Expect(0, 119149, '\p{^GCB=-_sm}', "");
Expect(0, 119149, '\P{GCB=-_sm}', "");
Expect(1, 119149, '\P{^GCB=-_sm}', "");
Expect(0, 119150, '\p{GCB=-_sm}', "");
Expect(1, 119150, '\p{^GCB=-_sm}', "");
Expect(1, 119150, '\P{GCB=-_sm}', "");
Expect(0, 119150, '\P{^GCB=-_sm}', "");
Error('\p{Is_Grapheme_Cluster_Break= -SpacingMark/a/}');
Error('\P{Is_Grapheme_Cluster_Break= -SpacingMark/a/}');
Expect(1, 119149, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119149, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\p{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\p{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119150, '\P{Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(0, 119150, '\P{^Is_Grapheme_Cluster_Break=spacingmark}', "");
Expect(1, 119149, '\p{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119149, '\p{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119149, '\P{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119149, '\P{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119150, '\p{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119150, '\p{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(1, 119150, '\P{Is_Grapheme_Cluster_Break=__spacingmark}', "");
Expect(0, 119150, '\P{^Is_Grapheme_Cluster_Break=__spacingmark}', "");
Error('\p{Is_GCB=  SM/a/}');
Error('\P{Is_GCB=  SM/a/}');
Expect(1, 119149, '\p{Is_GCB=sm}', "");
Expect(0, 119149, '\p{^Is_GCB=sm}', "");
Expect(0, 119149, '\P{Is_GCB=sm}', "");
Expect(1, 119149, '\P{^Is_GCB=sm}', "");
Expect(0, 119150, '\p{Is_GCB=sm}', "");
Expect(1, 119150, '\p{^Is_GCB=sm}', "");
Expect(1, 119150, '\P{Is_GCB=sm}', "");
Expect(0, 119150, '\P{^Is_GCB=sm}', "");
Expect(1, 119149, '\p{Is_GCB= -SM}', "");
Expect(0, 119149, '\p{^Is_GCB= -SM}', "");
Expect(0, 119149, '\P{Is_GCB= -SM}', "");
Expect(1, 119149, '\P{^Is_GCB= -SM}', "");
Expect(0, 119150, '\p{Is_GCB= -SM}', "");
Expect(1, 119150, '\p{^Is_GCB= -SM}', "");
Expect(1, 119150, '\P{Is_GCB= -SM}', "");
Expect(0, 119150, '\P{^Is_GCB= -SM}', "");
Error('\p{Grapheme_Cluster_Break=/a/_-t}');
Error('\P{Grapheme_Cluster_Break=/a/_-t}');
Expect(1, 55291, '\p{Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\P{Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\p{Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\p{^Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\P{Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\P{^Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\p{Grapheme_Cluster_Break= T}', "");
Expect(0, 55291, '\p{^Grapheme_Cluster_Break= T}', "");
Expect(0, 55291, '\P{Grapheme_Cluster_Break= T}', "");
Expect(1, 55291, '\P{^Grapheme_Cluster_Break= T}', "");
Expect(0, 55292, '\p{Grapheme_Cluster_Break= T}', "");
Expect(1, 55292, '\p{^Grapheme_Cluster_Break= T}', "");
Expect(1, 55292, '\P{Grapheme_Cluster_Break= T}', "");
Expect(0, 55292, '\P{^Grapheme_Cluster_Break= T}', "");
Error('\p{GCB=:=-T}');
Error('\P{GCB=:=-T}');
Expect(1, 55291, '\p{GCB:   t}', "");
Expect(0, 55291, '\p{^GCB:   t}', "");
Expect(0, 55291, '\P{GCB:   t}', "");
Expect(1, 55291, '\P{^GCB:   t}', "");
Expect(0, 55292, '\p{GCB:   t}', "");
Expect(1, 55292, '\p{^GCB:   t}', "");
Expect(1, 55292, '\P{GCB:   t}', "");
Expect(0, 55292, '\P{^GCB:   t}', "");
Expect(1, 55291, '\p{GCB=_-t}', "");
Expect(0, 55291, '\p{^GCB=_-t}', "");
Expect(0, 55291, '\P{GCB=_-t}', "");
Expect(1, 55291, '\P{^GCB=_-t}', "");
Expect(0, 55292, '\p{GCB=_-t}', "");
Expect(1, 55292, '\p{^GCB=_-t}', "");
Expect(1, 55292, '\P{GCB=_-t}', "");
Expect(0, 55292, '\P{^GCB=_-t}', "");
Error('\p{Is_Grapheme_Cluster_Break=-/a/T}');
Error('\P{Is_Grapheme_Cluster_Break=-/a/T}');
Expect(1, 55291, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55291, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\p{Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\p{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55292, '\P{Is_Grapheme_Cluster_Break=t}', "");
Expect(0, 55292, '\P{^Is_Grapheme_Cluster_Break=t}', "");
Expect(1, 55291, '\p{Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55291, '\p{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55291, '\P{Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55291, '\P{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55292, '\p{Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55292, '\p{^Is_Grapheme_Cluster_Break=_T}', "");
Expect(1, 55292, '\P{Is_Grapheme_Cluster_Break=_T}', "");
Expect(0, 55292, '\P{^Is_Grapheme_Cluster_Break=_T}', "");
Error('\p{Is_GCB=	T/a/}');
Error('\P{Is_GCB=	T/a/}');
Expect(1, 55291, '\p{Is_GCB=t}', "");
Expect(0, 55291, '\p{^Is_GCB=t}', "");
Expect(0, 55291, '\P{Is_GCB=t}', "");
Expect(1, 55291, '\P{^Is_GCB=t}', "");
Expect(0, 55292, '\p{Is_GCB=t}', "");
Expect(1, 55292, '\p{^Is_GCB=t}', "");
Expect(1, 55292, '\P{Is_GCB=t}', "");
Expect(0, 55292, '\P{^Is_GCB=t}', "");
Expect(1, 55291, '\p{Is_GCB=	t}', "");
Expect(0, 55291, '\p{^Is_GCB=	t}', "");
Expect(0, 55291, '\P{Is_GCB=	t}', "");
Expect(1, 55291, '\P{^Is_GCB=	t}', "");
Expect(0, 55292, '\p{Is_GCB=	t}', "");
Expect(1, 55292, '\p{^Is_GCB=	t}', "");
Expect(1, 55292, '\P{Is_GCB=	t}', "");
Expect(0, 55292, '\P{^Is_GCB=	t}', "");
Error('\p{Grapheme_Cluster_Break=--V:=}');
Error('\P{Grapheme_Cluster_Break=--V:=}');
Expect(1, 55238, '\p{Grapheme_Cluster_Break:	v}', "");
Expect(0, 55238, '\p{^Grapheme_Cluster_Break:	v}', "");
Expect(0, 55238, '\P{Grapheme_Cluster_Break:	v}', "");
Expect(1, 55238, '\P{^Grapheme_Cluster_Break:	v}', "");
Expect(0, 55239, '\p{Grapheme_Cluster_Break:	v}', "");
Expect(1, 55239, '\p{^Grapheme_Cluster_Break:	v}', "");
Expect(1, 55239, '\P{Grapheme_Cluster_Break:	v}', "");
Expect(0, 55239, '\P{^Grapheme_Cluster_Break:	v}', "");
Expect(1, 55238, '\p{Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55238, '\p{^Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55238, '\P{Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55238, '\P{^Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55239, '\p{Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55239, '\p{^Grapheme_Cluster_Break=_ V}', "");
Expect(1, 55239, '\P{Grapheme_Cluster_Break=_ V}', "");
Expect(0, 55239, '\P{^Grapheme_Cluster_Break=_ V}', "");
Error('\p{GCB=/a/-_V}');
Error('\P{GCB=/a/-_V}');
Expect(1, 55238, '\p{GCB=v}', "");
Expect(0, 55238, '\p{^GCB=v}', "");
Expect(0, 55238, '\P{GCB=v}', "");
Expect(1, 55238, '\P{^GCB=v}', "");
Expect(0, 55239, '\p{GCB=v}', "");
Expect(1, 55239, '\p{^GCB=v}', "");
Expect(1, 55239, '\P{GCB=v}', "");
Expect(0, 55239, '\P{^GCB=v}', "");
Expect(1, 55238, '\p{GCB=	 V}', "");
Expect(0, 55238, '\p{^GCB=	 V}', "");
Expect(0, 55238, '\P{GCB=	 V}', "");
Expect(1, 55238, '\P{^GCB=	 V}', "");
Expect(0, 55239, '\p{GCB=	 V}', "");
Expect(1, 55239, '\p{^GCB=	 V}', "");
Expect(1, 55239, '\P{GCB=	 V}', "");
Expect(0, 55239, '\P{^GCB=	 V}', "");
Error('\p{Is_Grapheme_Cluster_Break=/a/V}');
Error('\P{Is_Grapheme_Cluster_Break=/a/V}');
Expect(1, 55238, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55238, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55238, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55238, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55239, '\p{Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55239, '\p{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55239, '\P{Is_Grapheme_Cluster_Break=v}', "");
Expect(0, 55239, '\P{^Is_Grapheme_Cluster_Break=v}', "");
Expect(1, 55238, '\p{Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55238, '\p{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55238, '\P{Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55238, '\P{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55239, '\p{Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55239, '\p{^Is_Grapheme_Cluster_Break=__V}', "");
Expect(1, 55239, '\P{Is_Grapheme_Cluster_Break=__V}', "");
Expect(0, 55239, '\P{^Is_Grapheme_Cluster_Break=__V}', "");
Error('\p{Is_GCB=:= V}');
Error('\P{Is_GCB=:= V}');
Expect(1, 55238, '\p{Is_GCB:v}', "");
Expect(0, 55238, '\p{^Is_GCB:v}', "");
Expect(0, 55238, '\P{Is_GCB:v}', "");
Expect(1, 55238, '\P{^Is_GCB:v}', "");
Expect(0, 55239, '\p{Is_GCB:v}', "");
Expect(1, 55239, '\p{^Is_GCB:v}', "");
Expect(1, 55239, '\P{Is_GCB:v}', "");
Expect(0, 55239, '\P{^Is_GCB:v}', "");
Expect(1, 55238, '\p{Is_GCB=_v}', "");
Expect(0, 55238, '\p{^Is_GCB=_v}', "");
Expect(0, 55238, '\P{Is_GCB=_v}', "");
Expect(1, 55238, '\P{^Is_GCB=_v}', "");
Expect(0, 55239, '\p{Is_GCB=_v}', "");
Expect(1, 55239, '\p{^Is_GCB=_v}', "");
Expect(1, 55239, '\P{Is_GCB=_v}', "");
Expect(0, 55239, '\P{^Is_GCB=_v}', "");
Error('\p{Grapheme_Cluster_Break=/a/ 	Other}');
Error('\P{Grapheme_Cluster_Break=/a/ 	Other}');
Expect(1, 921600, '\p{Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\P{Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\p{Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\p{^Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\P{Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\P{^Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921600, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921600, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921600, '\P{^Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921599, '\p{Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921599, '\p{^Grapheme_Cluster_Break=	Other}', "");
Expect(1, 921599, '\P{Grapheme_Cluster_Break=	Other}', "");
Expect(0, 921599, '\P{^Grapheme_Cluster_Break=	Other}', "");
Error('\p{GCB:	-/a/xx}');
Error('\P{GCB:	-/a/xx}');
Expect(1, 921600, '\p{GCB=xx}', "");
Expect(0, 921600, '\p{^GCB=xx}', "");
Expect(0, 921600, '\P{GCB=xx}', "");
Expect(1, 921600, '\P{^GCB=xx}', "");
Expect(0, 921599, '\p{GCB=xx}', "");
Expect(1, 921599, '\p{^GCB=xx}', "");
Expect(1, 921599, '\P{GCB=xx}', "");
Expect(0, 921599, '\P{^GCB=xx}', "");
Expect(1, 921600, '\p{GCB=XX}', "");
Expect(0, 921600, '\p{^GCB=XX}', "");
Expect(0, 921600, '\P{GCB=XX}', "");
Expect(1, 921600, '\P{^GCB=XX}', "");
Expect(0, 921599, '\p{GCB=XX}', "");
Expect(1, 921599, '\p{^GCB=XX}', "");
Expect(1, 921599, '\P{GCB=XX}', "");
Expect(0, 921599, '\P{^GCB=XX}', "");
Error('\p{Is_Grapheme_Cluster_Break:	-_Other:=}');
Error('\P{Is_Grapheme_Cluster_Break:	-_Other:=}');
Expect(1, 921600, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921600, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\p{Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\p{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921599, '\P{Is_Grapheme_Cluster_Break=other}', "");
Expect(0, 921599, '\P{^Is_Grapheme_Cluster_Break=other}', "");
Expect(1, 921600, '\p{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921600, '\p{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921600, '\P{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921600, '\P{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921599, '\p{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921599, '\p{^Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(1, 921599, '\P{Is_Grapheme_Cluster_Break=_	Other}', "");
Expect(0, 921599, '\P{^Is_Grapheme_Cluster_Break=_	Other}', "");
Error('\p{Is_GCB=:=		xx}');
Error('\P{Is_GCB=:=		xx}');
Expect(1, 921600, '\p{Is_GCB=xx}', "");
Expect(0, 921600, '\p{^Is_GCB=xx}', "");
Expect(0, 921600, '\P{Is_GCB=xx}', "");
Expect(1, 921600, '\P{^Is_GCB=xx}', "");
Expect(0, 921599, '\p{Is_GCB=xx}', "");
Expect(1, 921599, '\p{^Is_GCB=xx}', "");
Expect(1, 921599, '\P{Is_GCB=xx}', "");
Expect(0, 921599, '\P{^Is_GCB=xx}', "");
Expect(1, 921600, '\p{Is_GCB=_	XX}', "");
Expect(0, 921600, '\p{^Is_GCB=_	XX}', "");
Expect(0, 921600, '\P{Is_GCB=_	XX}', "");
Expect(1, 921600, '\P{^Is_GCB=_	XX}', "");
Expect(0, 921599, '\p{Is_GCB=_	XX}', "");
Expect(1, 921599, '\p{^Is_GCB=_	XX}', "");
Expect(1, 921599, '\P{Is_GCB=_	XX}', "");
Expect(0, 921599, '\P{^Is_GCB=_	XX}', "");
Error('\p{Grapheme_Base:/a/		no}');
Error('\P{Grapheme_Base:/a/		no}');
Expect(1, 195102, '\p{Grapheme_Base:no}', "");
Expect(0, 195102, '\p{^Grapheme_Base:no}', "");
Expect(0, 195102, '\P{Grapheme_Base:no}', "");
Expect(1, 195102, '\P{^Grapheme_Base:no}', "");
Expect(0, 195101, '\p{Grapheme_Base:no}', "");
Expect(1, 195101, '\p{^Grapheme_Base:no}', "");
Expect(1, 195101, '\P{Grapheme_Base:no}', "");
Expect(0, 195101, '\P{^Grapheme_Base:no}', "");
Expect(1, 195102, '\p{Grapheme_Base=__No}', "");
Expect(0, 195102, '\p{^Grapheme_Base=__No}', "");
Expect(0, 195102, '\P{Grapheme_Base=__No}', "");
Expect(1, 195102, '\P{^Grapheme_Base=__No}', "");
Expect(0, 195101, '\p{Grapheme_Base=__No}', "");
Expect(1, 195101, '\p{^Grapheme_Base=__No}', "");
Expect(1, 195101, '\P{Grapheme_Base=__No}', "");
Expect(0, 195101, '\P{^Grapheme_Base=__No}', "");
Error('\p{Gr_Base=:=_ n}');
Error('\P{Gr_Base=:=_ n}');
Expect(1, 195102, '\p{Gr_Base=n}', "");
Expect(0, 195102, '\p{^Gr_Base=n}', "");
Expect(0, 195102, '\P{Gr_Base=n}', "");
Expect(1, 195102, '\P{^Gr_Base=n}', "");
Expect(0, 195101, '\p{Gr_Base=n}', "");
Expect(1, 195101, '\p{^Gr_Base=n}', "");
Expect(1, 195101, '\P{Gr_Base=n}', "");
Expect(0, 195101, '\P{^Gr_Base=n}', "");
Expect(1, 195102, '\p{Gr_Base=	_N}', "");
Expect(0, 195102, '\p{^Gr_Base=	_N}', "");
Expect(0, 195102, '\P{Gr_Base=	_N}', "");
Expect(1, 195102, '\P{^Gr_Base=	_N}', "");
Expect(0, 195101, '\p{Gr_Base=	_N}', "");
Expect(1, 195101, '\p{^Gr_Base=	_N}', "");
Expect(1, 195101, '\P{Gr_Base=	_N}', "");
Expect(0, 195101, '\P{^Gr_Base=	_N}', "");
Error('\p{Is_Grapheme_Base:   -	f/a/}');
Error('\P{Is_Grapheme_Base:   -	f/a/}');
Expect(1, 195102, '\p{Is_Grapheme_Base=f}', "");
Expect(0, 195102, '\p{^Is_Grapheme_Base=f}', "");
Expect(0, 195102, '\P{Is_Grapheme_Base=f}', "");
Expect(1, 195102, '\P{^Is_Grapheme_Base=f}', "");
Expect(0, 195101, '\p{Is_Grapheme_Base=f}', "");
Expect(1, 195101, '\p{^Is_Grapheme_Base=f}', "");
Expect(1, 195101, '\P{Is_Grapheme_Base=f}', "");
Expect(0, 195101, '\P{^Is_Grapheme_Base=f}', "");
Expect(1, 195102, '\p{Is_Grapheme_Base=	f}', "");
Expect(0, 195102, '\p{^Is_Grapheme_Base=	f}', "");
Expect(0, 195102, '\P{Is_Grapheme_Base=	f}', "");
Expect(1, 195102, '\P{^Is_Grapheme_Base=	f}', "");
Expect(0, 195101, '\p{Is_Grapheme_Base=	f}', "");
Expect(1, 195101, '\p{^Is_Grapheme_Base=	f}', "");
Expect(1, 195101, '\P{Is_Grapheme_Base=	f}', "");
Expect(0, 195101, '\P{^Is_Grapheme_Base=	f}', "");
Error('\p{Is_Gr_Base= _False:=}');
Error('\P{Is_Gr_Base= _False:=}');
Expect(1, 195102, '\p{Is_Gr_Base=false}', "");
Expect(0, 195102, '\p{^Is_Gr_Base=false}', "");
Expect(0, 195102, '\P{Is_Gr_Base=false}', "");
Expect(1, 195102, '\P{^Is_Gr_Base=false}', "");
Expect(0, 195101, '\p{Is_Gr_Base=false}', "");
Expect(1, 195101, '\p{^Is_Gr_Base=false}', "");
Expect(1, 195101, '\P{Is_Gr_Base=false}', "");
Expect(0, 195101, '\P{^Is_Gr_Base=false}', "");
Expect(1, 195102, '\p{Is_Gr_Base=_-False}', "");
Expect(0, 195102, '\p{^Is_Gr_Base=_-False}', "");
Expect(0, 195102, '\P{Is_Gr_Base=_-False}', "");
Expect(1, 195102, '\P{^Is_Gr_Base=_-False}', "");
Expect(0, 195101, '\p{Is_Gr_Base=_-False}', "");
Expect(1, 195101, '\p{^Is_Gr_Base=_-False}', "");
Expect(1, 195101, '\P{Is_Gr_Base=_-False}', "");
Expect(0, 195101, '\P{^Is_Gr_Base=_-False}', "");
Error('\p{Grapheme_Base=- YES/a/}');
Error('\P{Grapheme_Base=- YES/a/}');
Expect(1, 195101, '\p{Grapheme_Base=yes}', "");
Expect(0, 195101, '\p{^Grapheme_Base=yes}', "");
Expect(0, 195101, '\P{Grapheme_Base=yes}', "");
Expect(1, 195101, '\P{^Grapheme_Base=yes}', "");
Expect(0, 195102, '\p{Grapheme_Base=yes}', "");
Expect(1, 195102, '\p{^Grapheme_Base=yes}', "");
Expect(1, 195102, '\P{Grapheme_Base=yes}', "");
Expect(0, 195102, '\P{^Grapheme_Base=yes}', "");
Expect(1, 195101, '\p{Grapheme_Base=-Yes}', "");
Expect(0, 195101, '\p{^Grapheme_Base=-Yes}', "");
Expect(0, 195101, '\P{Grapheme_Base=-Yes}', "");
Expect(1, 195101, '\P{^Grapheme_Base=-Yes}', "");
Expect(0, 195102, '\p{Grapheme_Base=-Yes}', "");
Expect(1, 195102, '\p{^Grapheme_Base=-Yes}', "");
Expect(1, 195102, '\P{Grapheme_Base=-Yes}', "");
Expect(0, 195102, '\P{^Grapheme_Base=-Yes}', "");
Error('\p{Gr_Base=-/a/y}');
Error('\P{Gr_Base=-/a/y}');
Expect(1, 195101, '\p{Gr_Base=y}', "");
Expect(0, 195101, '\p{^Gr_Base=y}', "");
Expect(0, 195101, '\P{Gr_Base=y}', "");
Expect(1, 195101, '\P{^Gr_Base=y}', "");
Expect(0, 195102, '\p{Gr_Base=y}', "");
Expect(1, 195102, '\p{^Gr_Base=y}', "");
Expect(1, 195102, '\P{Gr_Base=y}', "");
Expect(0, 195102, '\P{^Gr_Base=y}', "");
Expect(1, 195101, '\p{Gr_Base= _Y}', "");
Expect(0, 195101, '\p{^Gr_Base= _Y}', "");
Expect(0, 195101, '\P{Gr_Base= _Y}', "");
Expect(1, 195101, '\P{^Gr_Base= _Y}', "");
Expect(0, 195102, '\p{Gr_Base= _Y}', "");
Expect(1, 195102, '\p{^Gr_Base= _Y}', "");
Expect(1, 195102, '\P{Gr_Base= _Y}', "");
Expect(0, 195102, '\P{^Gr_Base= _Y}', "");
Error('\p{Is_Grapheme_Base=:=T}');
Error('\P{Is_Grapheme_Base=:=T}');
Expect(1, 195101, '\p{Is_Grapheme_Base=t}', "");
Expect(0, 195101, '\p{^Is_Grapheme_Base=t}', "");
Expect(0, 195101, '\P{Is_Grapheme_Base=t}', "");
Expect(1, 195101, '\P{^Is_Grapheme_Base=t}', "");
Expect(0, 195102, '\p{Is_Grapheme_Base=t}', "");
Expect(1, 195102, '\p{^Is_Grapheme_Base=t}', "");
Expect(1, 195102, '\P{Is_Grapheme_Base=t}', "");
Expect(0, 195102, '\P{^Is_Grapheme_Base=t}', "");
Expect(1, 195101, '\p{Is_Grapheme_Base:   	_T}', "");
Expect(0, 195101, '\p{^Is_Grapheme_Base:   	_T}', "");
Expect(0, 195101, '\P{Is_Grapheme_Base:   	_T}', "");
Expect(1, 195101, '\P{^Is_Grapheme_Base:   	_T}', "");
Expect(0, 195102, '\p{Is_Grapheme_Base:   	_T}', "");
Expect(1, 195102, '\p{^Is_Grapheme_Base:   	_T}', "");
Expect(1, 195102, '\P{Is_Grapheme_Base:   	_T}', "");
Expect(0, 195102, '\P{^Is_Grapheme_Base:   	_T}', "");
Error('\p{Is_Gr_Base=-:=TRUE}');
Error('\P{Is_Gr_Base=-:=TRUE}');
Expect(1, 195101, '\p{Is_Gr_Base=true}', "");
Expect(0, 195101, '\p{^Is_Gr_Base=true}', "");
Expect(0, 195101, '\P{Is_Gr_Base=true}', "");
Expect(1, 195101, '\P{^Is_Gr_Base=true}', "");
Expect(0, 195102, '\p{Is_Gr_Base=true}', "");
Expect(1, 195102, '\p{^Is_Gr_Base=true}', "");
Expect(1, 195102, '\P{Is_Gr_Base=true}', "");
Expect(0, 195102, '\P{^Is_Gr_Base=true}', "");
Expect(1, 195101, '\p{Is_Gr_Base=_TRUE}', "");
Expect(0, 195101, '\p{^Is_Gr_Base=_TRUE}', "");
Expect(0, 195101, '\P{Is_Gr_Base=_TRUE}', "");
Expect(1, 195101, '\P{^Is_Gr_Base=_TRUE}', "");
Expect(0, 195102, '\p{Is_Gr_Base=_TRUE}', "");
Expect(1, 195102, '\p{^Is_Gr_Base=_TRUE}', "");
Expect(1, 195102, '\P{Is_Gr_Base=_TRUE}', "");
Expect(0, 195102, '\P{^Is_Gr_Base=_TRUE}', "");
Error('\p{Grapheme_Extend=-_No/a/}');
Error('\P{Grapheme_Extend=-_No/a/}');
Expect(1, 918000, '\p{Grapheme_Extend=no}', "");
Expect(0, 918000, '\p{^Grapheme_Extend=no}', "");
Expect(0, 918000, '\P{Grapheme_Extend=no}', "");
Expect(1, 918000, '\P{^Grapheme_Extend=no}', "");
Expect(0, 917999, '\p{Grapheme_Extend=no}', "");
Expect(1, 917999, '\p{^Grapheme_Extend=no}', "");
Expect(1, 917999, '\P{Grapheme_Extend=no}', "");
Expect(0, 917999, '\P{^Grapheme_Extend=no}', "");
Expect(1, 918000, '\p{Grapheme_Extend=	 No}', "");
Expect(0, 918000, '\p{^Grapheme_Extend=	 No}', "");
Expect(0, 918000, '\P{Grapheme_Extend=	 No}', "");
Expect(1, 918000, '\P{^Grapheme_Extend=	 No}', "");
Expect(0, 917999, '\p{Grapheme_Extend=	 No}', "");
Expect(1, 917999, '\p{^Grapheme_Extend=	 No}', "");
Expect(1, 917999, '\P{Grapheme_Extend=	 No}', "");
Expect(0, 917999, '\P{^Grapheme_Extend=	 No}', "");
Error('\p{Gr_Ext=_/a/N}');
Error('\P{Gr_Ext=_/a/N}');
Expect(1, 918000, '\p{Gr_Ext=n}', "");
Expect(0, 918000, '\p{^Gr_Ext=n}', "");
Expect(0, 918000, '\P{Gr_Ext=n}', "");
Expect(1, 918000, '\P{^Gr_Ext=n}', "");
Expect(0, 917999, '\p{Gr_Ext=n}', "");
Expect(1, 917999, '\p{^Gr_Ext=n}', "");
Expect(1, 917999, '\P{Gr_Ext=n}', "");
Expect(0, 917999, '\P{^Gr_Ext=n}', "");
Expect(1, 918000, '\p{Gr_Ext=_-N}', "");
Expect(0, 918000, '\p{^Gr_Ext=_-N}', "");
Expect(0, 918000, '\P{Gr_Ext=_-N}', "");
Expect(1, 918000, '\P{^Gr_Ext=_-N}', "");
Expect(0, 917999, '\p{Gr_Ext=_-N}', "");
Expect(1, 917999, '\p{^Gr_Ext=_-N}', "");
Expect(1, 917999, '\P{Gr_Ext=_-N}', "");
Expect(0, 917999, '\P{^Gr_Ext=_-N}', "");
Error('\p{Is_Grapheme_Extend=-:=F}');
Error('\P{Is_Grapheme_Extend=-:=F}');
Expect(1, 918000, '\p{Is_Grapheme_Extend=f}', "");
Expect(0, 918000, '\p{^Is_Grapheme_Extend=f}', "");
Expect(0, 918000, '\P{Is_Grapheme_Extend=f}', "");
Expect(1, 918000, '\P{^Is_Grapheme_Extend=f}', "");
Expect(0, 917999, '\p{Is_Grapheme_Extend=f}', "");
Expect(1, 917999, '\p{^Is_Grapheme_Extend=f}', "");
Expect(1, 917999, '\P{Is_Grapheme_Extend=f}', "");
Expect(0, 917999, '\P{^Is_Grapheme_Extend=f}', "");
Expect(1, 918000, '\p{Is_Grapheme_Extend=-f}', "");
Expect(0, 918000, '\p{^Is_Grapheme_Extend=-f}', "");
Expect(0, 918000, '\P{Is_Grapheme_Extend=-f}', "");
Expect(1, 918000, '\P{^Is_Grapheme_Extend=-f}', "");
Expect(0, 917999, '\p{Is_Grapheme_Extend=-f}', "");
Expect(1, 917999, '\p{^Is_Grapheme_Extend=-f}', "");
Expect(1, 917999, '\P{Is_Grapheme_Extend=-f}', "");
Expect(0, 917999, '\P{^Is_Grapheme_Extend=-f}', "");
Error('\p{Is_Gr_Ext= False/a/}');
Error('\P{Is_Gr_Ext= False/a/}');
Expect(1, 918000, '\p{Is_Gr_Ext=false}', "");
Expect(0, 918000, '\p{^Is_Gr_Ext=false}', "");
Expect(0, 918000, '\P{Is_Gr_Ext=false}', "");
Expect(1, 918000, '\P{^Is_Gr_Ext=false}', "");
Expect(0, 917999, '\p{Is_Gr_Ext=false}', "");
Expect(1, 917999, '\p{^Is_Gr_Ext=false}', "");
Expect(1, 917999, '\P{Is_Gr_Ext=false}', "");
Expect(0, 917999, '\P{^Is_Gr_Ext=false}', "");
Expect(1, 918000, '\p{Is_Gr_Ext=	 False}', "");
Expect(0, 918000, '\p{^Is_Gr_Ext=	 False}', "");
Expect(0, 918000, '\P{Is_Gr_Ext=	 False}', "");
Expect(1, 918000, '\P{^Is_Gr_Ext=	 False}', "");
Expect(0, 917999, '\p{Is_Gr_Ext=	 False}', "");
Expect(1, 917999, '\p{^Is_Gr_Ext=	 False}', "");
Expect(1, 917999, '\P{Is_Gr_Ext=	 False}', "");
Expect(0, 917999, '\P{^Is_Gr_Ext=	 False}', "");
Error('\p{Grapheme_Extend= yes/a/}');
Error('\P{Grapheme_Extend= yes/a/}');
Expect(1, 917999, '\p{Grapheme_Extend=yes}', "");
Expect(0, 917999, '\p{^Grapheme_Extend=yes}', "");
Expect(0, 917999, '\P{Grapheme_Extend=yes}', "");
Expect(1, 917999, '\P{^Grapheme_Extend=yes}', "");
Expect(0, 918000, '\p{Grapheme_Extend=yes}', "");
Expect(1, 918000, '\p{^Grapheme_Extend=yes}', "");
Expect(1, 918000, '\P{Grapheme_Extend=yes}', "");
Expect(0, 918000, '\P{^Grapheme_Extend=yes}', "");
Expect(1, 917999, '\p{Grapheme_Extend=--Yes}', "");
Expect(0, 917999, '\p{^Grapheme_Extend=--Yes}', "");
Expect(0, 917999, '\P{Grapheme_Extend=--Yes}', "");
Expect(1, 917999, '\P{^Grapheme_Extend=--Yes}', "");
Expect(0, 918000, '\p{Grapheme_Extend=--Yes}', "");
Expect(1, 918000, '\p{^Grapheme_Extend=--Yes}', "");
Expect(1, 918000, '\P{Grapheme_Extend=--Yes}', "");
Expect(0, 918000, '\P{^Grapheme_Extend=--Yes}', "");
Error('\p{Gr_Ext=	:=y}');
Error('\P{Gr_Ext=	:=y}');
Expect(1, 917999, '\p{Gr_Ext=y}', "");
Expect(0, 917999, '\p{^Gr_Ext=y}', "");
Expect(0, 917999, '\P{Gr_Ext=y}', "");
Expect(1, 917999, '\P{^Gr_Ext=y}', "");
Expect(0, 918000, '\p{Gr_Ext=y}', "");
Expect(1, 918000, '\p{^Gr_Ext=y}', "");
Expect(1, 918000, '\P{Gr_Ext=y}', "");
Expect(0, 918000, '\P{^Gr_Ext=y}', "");
Expect(1, 917999, '\p{Gr_Ext= 	Y}', "");
Expect(0, 917999, '\p{^Gr_Ext= 	Y}', "");
Expect(0, 917999, '\P{Gr_Ext= 	Y}', "");
Expect(1, 917999, '\P{^Gr_Ext= 	Y}', "");
Expect(0, 918000, '\p{Gr_Ext= 	Y}', "");
Expect(1, 918000, '\p{^Gr_Ext= 	Y}', "");
Expect(1, 918000, '\P{Gr_Ext= 	Y}', "");
Expect(0, 918000, '\P{^Gr_Ext= 	Y}', "");
Error('\p{Is_Grapheme_Extend: - T:=}');
Error('\P{Is_Grapheme_Extend: - T:=}');
Expect(1, 917999, '\p{Is_Grapheme_Extend=t}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Extend=t}', "");
Expect(0, 917999, '\P{Is_Grapheme_Extend=t}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Extend=t}', "");
Expect(0, 918000, '\p{Is_Grapheme_Extend=t}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Extend=t}', "");
Expect(1, 918000, '\P{Is_Grapheme_Extend=t}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Extend=t}', "");
Expect(1, 917999, '\p{Is_Grapheme_Extend=--t}', "");
Expect(0, 917999, '\p{^Is_Grapheme_Extend=--t}', "");
Expect(0, 917999, '\P{Is_Grapheme_Extend=--t}', "");
Expect(1, 917999, '\P{^Is_Grapheme_Extend=--t}', "");
Expect(0, 918000, '\p{Is_Grapheme_Extend=--t}', "");
Expect(1, 918000, '\p{^Is_Grapheme_Extend=--t}', "");
Expect(1, 918000, '\P{Is_Grapheme_Extend=--t}', "");
Expect(0, 918000, '\P{^Is_Grapheme_Extend=--t}', "");
Error('\p{Is_Gr_Ext=/a/ -TRUE}');
Error('\P{Is_Gr_Ext=/a/ -TRUE}');
Expect(1, 917999, '\p{Is_Gr_Ext=true}', "");
Expect(0, 917999, '\p{^Is_Gr_Ext=true}', "");
Expect(0, 917999, '\P{Is_Gr_Ext=true}', "");
Expect(1, 917999, '\P{^Is_Gr_Ext=true}', "");
Expect(0, 918000, '\p{Is_Gr_Ext=true}', "");
Expect(1, 918000, '\p{^Is_Gr_Ext=true}', "");
Expect(1, 918000, '\P{Is_Gr_Ext=true}', "");
Expect(0, 918000, '\P{^Is_Gr_Ext=true}', "");
Expect(1, 917999, '\p{Is_Gr_Ext=_true}', "");
Expect(0, 917999, '\p{^Is_Gr_Ext=_true}', "");
Expect(0, 917999, '\P{Is_Gr_Ext=_true}', "");
Expect(1, 917999, '\P{^Is_Gr_Ext=_true}', "");
Expect(0, 918000, '\p{Is_Gr_Ext=_true}', "");
Expect(1, 918000, '\p{^Is_Gr_Ext=_true}', "");
Expect(1, 918000, '\P{Is_Gr_Ext=_true}', "");
Expect(0, 918000, '\P{^Is_Gr_Ext=_true}', "");
Error('\p{Grapheme_Link=No}');
Error('\P{Grapheme_Link=No}');
Error('\p{Gr_Link=N}');
Error('\P{Gr_Link=N}');
Error('\p{Is_Grapheme_Link=F}');
Error('\P{Is_Grapheme_Link=F}');
Error('\p{Is_Gr_Link=False}');
Error('\P{Is_Gr_Link=False}');
Error('\p{Grapheme_Link:	Yes}');
Error('\P{Grapheme_Link:	Yes}');
Error('\p{Gr_Link=Y}');
Error('\P{Gr_Link=Y}');
Error('\p{Is_Grapheme_Link=T}');
Error('\P{Is_Grapheme_Link=T}');
Error('\p{Is_Gr_Link=True}');
Error('\P{Is_Gr_Link=True}');
Error('\p{Hex_Digit:   := NO}');
Error('\P{Hex_Digit:   := NO}');
Expect(1, 65351, '\p{Hex_Digit=no}', "");
Expect(0, 65351, '\p{^Hex_Digit=no}', "");
Expect(0, 65351, '\P{Hex_Digit=no}', "");
Expect(1, 65351, '\P{^Hex_Digit=no}', "");
Expect(0, 65350, '\p{Hex_Digit=no}', "");
Expect(1, 65350, '\p{^Hex_Digit=no}', "");
Expect(1, 65350, '\P{Hex_Digit=no}', "");
Expect(0, 65350, '\P{^Hex_Digit=no}', "");
Expect(1, 65351, '\p{Hex_Digit=--No}', "");
Expect(0, 65351, '\p{^Hex_Digit=--No}', "");
Expect(0, 65351, '\P{Hex_Digit=--No}', "");
Expect(1, 65351, '\P{^Hex_Digit=--No}', "");
Expect(0, 65350, '\p{Hex_Digit=--No}', "");
Expect(1, 65350, '\p{^Hex_Digit=--No}', "");
Expect(1, 65350, '\P{Hex_Digit=--No}', "");
Expect(0, 65350, '\P{^Hex_Digit=--No}', "");
Error('\p{Hex=- N/a/}');
Error('\P{Hex=- N/a/}');
Expect(1, 65351, '\p{Hex=n}', "");
Expect(0, 65351, '\p{^Hex=n}', "");
Expect(0, 65351, '\P{Hex=n}', "");
Expect(1, 65351, '\P{^Hex=n}', "");
Expect(0, 65350, '\p{Hex=n}', "");
Expect(1, 65350, '\p{^Hex=n}', "");
Expect(1, 65350, '\P{Hex=n}', "");
Expect(0, 65350, '\P{^Hex=n}', "");
Expect(1, 65351, '\p{Hex= -N}', "");
Expect(0, 65351, '\p{^Hex= -N}', "");
Expect(0, 65351, '\P{Hex= -N}', "");
Expect(1, 65351, '\P{^Hex= -N}', "");
Expect(0, 65350, '\p{Hex= -N}', "");
Expect(1, 65350, '\p{^Hex= -N}', "");
Expect(1, 65350, '\P{Hex= -N}', "");
Expect(0, 65350, '\P{^Hex= -N}', "");
Error('\p{Is_Hex_Digit=-F:=}');
Error('\P{Is_Hex_Digit=-F:=}');
Expect(1, 65351, '\p{Is_Hex_Digit=f}', "");
Expect(0, 65351, '\p{^Is_Hex_Digit=f}', "");
Expect(0, 65351, '\P{Is_Hex_Digit=f}', "");
Expect(1, 65351, '\P{^Is_Hex_Digit=f}', "");
Expect(0, 65350, '\p{Is_Hex_Digit=f}', "");
Expect(1, 65350, '\p{^Is_Hex_Digit=f}', "");
Expect(1, 65350, '\P{Is_Hex_Digit=f}', "");
Expect(0, 65350, '\P{^Is_Hex_Digit=f}', "");
Expect(1, 65351, '\p{Is_Hex_Digit=	 f}', "");
Expect(0, 65351, '\p{^Is_Hex_Digit=	 f}', "");
Expect(0, 65351, '\P{Is_Hex_Digit=	 f}', "");
Expect(1, 65351, '\P{^Is_Hex_Digit=	 f}', "");
Expect(0, 65350, '\p{Is_Hex_Digit=	 f}', "");
Expect(1, 65350, '\p{^Is_Hex_Digit=	 f}', "");
Expect(1, 65350, '\P{Is_Hex_Digit=	 f}', "");
Expect(0, 65350, '\P{^Is_Hex_Digit=	 f}', "");
Error('\p{Is_Hex=:= False}');
Error('\P{Is_Hex=:= False}');
Expect(1, 65351, '\p{Is_Hex=false}', "");
Expect(0, 65351, '\p{^Is_Hex=false}', "");
Expect(0, 65351, '\P{Is_Hex=false}', "");
Expect(1, 65351, '\P{^Is_Hex=false}', "");
Expect(0, 65350, '\p{Is_Hex=false}', "");
Expect(1, 65350, '\p{^Is_Hex=false}', "");
Expect(1, 65350, '\P{Is_Hex=false}', "");
Expect(0, 65350, '\P{^Is_Hex=false}', "");
Expect(1, 65351, '\p{Is_Hex=-false}', "");
Expect(0, 65351, '\p{^Is_Hex=-false}', "");
Expect(0, 65351, '\P{Is_Hex=-false}', "");
Expect(1, 65351, '\P{^Is_Hex=-false}', "");
Expect(0, 65350, '\p{Is_Hex=-false}', "");
Expect(1, 65350, '\p{^Is_Hex=-false}', "");
Expect(1, 65350, '\P{Is_Hex=-false}', "");
Expect(0, 65350, '\P{^Is_Hex=-false}', "");
Error('\p{Hex_Digit=:= Yes}');
Error('\P{Hex_Digit=:= Yes}');
Expect(1, 65350, '\p{Hex_Digit=yes}', "");
Expect(0, 65350, '\p{^Hex_Digit=yes}', "");
Expect(0, 65350, '\P{Hex_Digit=yes}', "");
Expect(1, 65350, '\P{^Hex_Digit=yes}', "");
Expect(0, 65351, '\p{Hex_Digit=yes}', "");
Expect(1, 65351, '\p{^Hex_Digit=yes}', "");
Expect(1, 65351, '\P{Hex_Digit=yes}', "");
Expect(0, 65351, '\P{^Hex_Digit=yes}', "");
Expect(1, 65350, '\p{Hex_Digit:	-Yes}', "");
Expect(0, 65350, '\p{^Hex_Digit:	-Yes}', "");
Expect(0, 65350, '\P{Hex_Digit:	-Yes}', "");
Expect(1, 65350, '\P{^Hex_Digit:	-Yes}', "");
Expect(0, 65351, '\p{Hex_Digit:	-Yes}', "");
Expect(1, 65351, '\p{^Hex_Digit:	-Yes}', "");
Expect(1, 65351, '\P{Hex_Digit:	-Yes}', "");
Expect(0, 65351, '\P{^Hex_Digit:	-Yes}', "");
Error('\p{Hex=_/a/Y}');
Error('\P{Hex=_/a/Y}');
Expect(1, 65350, '\p{Hex=y}', "");
Expect(0, 65350, '\p{^Hex=y}', "");
Expect(0, 65350, '\P{Hex=y}', "");
Expect(1, 65350, '\P{^Hex=y}', "");
Expect(0, 65351, '\p{Hex=y}', "");
Expect(1, 65351, '\p{^Hex=y}', "");
Expect(1, 65351, '\P{Hex=y}', "");
Expect(0, 65351, '\P{^Hex=y}', "");
Expect(1, 65350, '\p{Hex=-	y}', "");
Expect(0, 65350, '\p{^Hex=-	y}', "");
Expect(0, 65350, '\P{Hex=-	y}', "");
Expect(1, 65350, '\P{^Hex=-	y}', "");
Expect(0, 65351, '\p{Hex=-	y}', "");
Expect(1, 65351, '\p{^Hex=-	y}', "");
Expect(1, 65351, '\P{Hex=-	y}', "");
Expect(0, 65351, '\P{^Hex=-	y}', "");
Error('\p{Is_Hex_Digit=/a/-T}');
Error('\P{Is_Hex_Digit=/a/-T}');
Expect(1, 65350, '\p{Is_Hex_Digit=t}', "");
Expect(0, 65350, '\p{^Is_Hex_Digit=t}', "");
Expect(0, 65350, '\P{Is_Hex_Digit=t}', "");
Expect(1, 65350, '\P{^Is_Hex_Digit=t}', "");
Expect(0, 65351, '\p{Is_Hex_Digit=t}', "");
Expect(1, 65351, '\p{^Is_Hex_Digit=t}', "");
Expect(1, 65351, '\P{Is_Hex_Digit=t}', "");
Expect(0, 65351, '\P{^Is_Hex_Digit=t}', "");
Expect(1, 65350, '\p{Is_Hex_Digit=_	T}', "");
Expect(0, 65350, '\p{^Is_Hex_Digit=_	T}', "");
Expect(0, 65350, '\P{Is_Hex_Digit=_	T}', "");
Expect(1, 65350, '\P{^Is_Hex_Digit=_	T}', "");
Expect(0, 65351, '\p{Is_Hex_Digit=_	T}', "");
Expect(1, 65351, '\p{^Is_Hex_Digit=_	T}', "");
Expect(1, 65351, '\P{Is_Hex_Digit=_	T}', "");
Expect(0, 65351, '\P{^Is_Hex_Digit=_	T}', "");
Error('\p{Is_Hex=-TRUE:=}');
Error('\P{Is_Hex=-TRUE:=}');
Expect(1, 65350, '\p{Is_Hex=true}', "");
Expect(0, 65350, '\p{^Is_Hex=true}', "");
Expect(0, 65350, '\P{Is_Hex=true}', "");
Expect(1, 65350, '\P{^Is_Hex=true}', "");
Expect(0, 65351, '\p{Is_Hex=true}', "");
Expect(1, 65351, '\p{^Is_Hex=true}', "");
Expect(1, 65351, '\P{Is_Hex=true}', "");
Expect(0, 65351, '\P{^Is_Hex=true}', "");
Expect(1, 65350, '\p{Is_Hex= _True}', "");
Expect(0, 65350, '\p{^Is_Hex= _True}', "");
Expect(0, 65350, '\P{Is_Hex= _True}', "");
Expect(1, 65350, '\P{^Is_Hex= _True}', "");
Expect(0, 65351, '\p{Is_Hex= _True}', "");
Expect(1, 65351, '\p{^Is_Hex= _True}', "");
Expect(1, 65351, '\P{Is_Hex= _True}', "");
Expect(0, 65351, '\P{^Is_Hex= _True}', "");
Error('\p{Hyphen=:=_No}');
Error('\P{Hyphen=:=_No}');
Expect(1, 65382, '\p{Hyphen=no}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=no}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=no}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=no}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=no}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=no}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=no}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=no}', 'deprecated');
Expect(1, 65382, '\p{Hyphen= No}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen= No}', 'deprecated');
Expect(0, 65382, '\P{Hyphen= No}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen= No}', 'deprecated');
Expect(0, 65381, '\p{Hyphen= No}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen= No}', 'deprecated');
Expect(1, 65381, '\P{Hyphen= No}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen= No}', 'deprecated');
Error('\p{Is_Hyphen=_:=N}');
Error('\P{Is_Hyphen=_:=N}');
Expect(1, 65382, '\p{Is_Hyphen=n}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=n}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=n}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=n}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=n}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=n}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=n}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=n}', 'deprecated');
Expect(1, 65382, '\p{Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=	-N}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=	-N}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=	-N}', 'deprecated');
Error('\p{Hyphen=	_F/a/}');
Error('\P{Hyphen=	_F/a/}');
Expect(1, 65382, '\p{Hyphen=f}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=f}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=f}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=f}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=f}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=f}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=f}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=f}', 'deprecated');
Expect(1, 65382, '\p{Hyphen=		F}', 'deprecated');
Expect(0, 65382, '\p{^Hyphen=		F}', 'deprecated');
Expect(0, 65382, '\P{Hyphen=		F}', 'deprecated');
Expect(1, 65382, '\P{^Hyphen=		F}', 'deprecated');
Expect(0, 65381, '\p{Hyphen=		F}', 'deprecated');
Expect(1, 65381, '\p{^Hyphen=		F}', 'deprecated');
Expect(1, 65381, '\P{Hyphen=		F}', 'deprecated');
Expect(0, 65381, '\P{^Hyphen=		F}', 'deprecated');
Error('\p{Is_Hyphen=-	FALSE/a/}');
Error('\P{Is_Hyphen=-	FALSE/a/}');
Expect(1, 65382, '\p{Is_Hyphen=false}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=false}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=false}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=false}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=false}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=false}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=false}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=false}', 'deprecated');
Expect(1, 65382, '\p{Is_Hyphen=--False}', 'deprecated');
Expect(0, 65382, '\p{^Is_Hyphen=--False}', 'deprecated');
Expect(0, 65382, '\P{Is_Hyphen=--False}', 'deprecated');
Expect(1, 65382, '\P{^Is_Hyphen=--False}', 'deprecated');
Expect(0, 65381, '\p{Is_Hyphen=--False}', 'deprecated');
Expect(1, 65381, '\p{^Is_Hyphen=--False}', 'deprecated');
Expect(1, 65381, '\P{Is_Hyphen=--False}', 'deprecated');
Expect(0, 65381, '\P{^Is_Hyphen=--False}', 'deprecated');
Error('\p{Hyphen: /a/YES}');
Error('\P{Hyphen: /a/YES}');
Expect(1, 65381, '\p{Hyphen=yes}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=yes}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=yes}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=yes}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=yes}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=yes}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=yes}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=yes}', 'deprecated');
Expect(1, 65381, '\p{Hyphen=	-yes}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=	-yes}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=	-yes}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=	-yes}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=	-yes}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=	-yes}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=	-yes}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=	-yes}', 'deprecated');
Error('\p{Is_Hyphen=:=	Y}');
Error('\P{Is_Hyphen=:=	Y}');
Expect(1, 65381, '\p{Is_Hyphen=y}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=y}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=y}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=y}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=y}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=y}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=y}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=y}', 'deprecated');
Expect(1, 65381, '\p{Is_Hyphen=-y}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=-y}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=-y}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=-y}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=-y}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=-y}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=-y}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=-y}', 'deprecated');
Error('\p{Hyphen=/a/_T}');
Error('\P{Hyphen=/a/_T}');
Expect(1, 65381, '\p{Hyphen=t}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=t}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=t}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=t}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=t}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=t}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=t}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=t}', 'deprecated');
Expect(1, 65381, '\p{Hyphen=_	t}', 'deprecated');
Expect(0, 65381, '\p{^Hyphen=_	t}', 'deprecated');
Expect(0, 65381, '\P{Hyphen=_	t}', 'deprecated');
Expect(1, 65381, '\P{^Hyphen=_	t}', 'deprecated');
Expect(0, 65382, '\p{Hyphen=_	t}', 'deprecated');
Expect(1, 65382, '\p{^Hyphen=_	t}', 'deprecated');
Expect(1, 65382, '\P{Hyphen=_	t}', 'deprecated');
Expect(0, 65382, '\P{^Hyphen=_	t}', 'deprecated');
Error('\p{Is_Hyphen=-/a/true}');
Error('\P{Is_Hyphen=-/a/true}');
Expect(1, 65381, '\p{Is_Hyphen=true}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=true}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=true}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=true}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=true}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=true}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=true}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=true}', 'deprecated');
Expect(1, 65381, '\p{Is_Hyphen=	True}', 'deprecated');
Expect(0, 65381, '\p{^Is_Hyphen=	True}', 'deprecated');
Expect(0, 65381, '\P{Is_Hyphen=	True}', 'deprecated');
Expect(1, 65381, '\P{^Is_Hyphen=	True}', 'deprecated');
Expect(0, 65382, '\p{Is_Hyphen=	True}', 'deprecated');
Expect(1, 65382, '\p{^Is_Hyphen=	True}', 'deprecated');
Expect(1, 65382, '\P{Is_Hyphen=	True}', 'deprecated');
Expect(0, 65382, '\P{^Is_Hyphen=	True}', 'deprecated');
Error('\p{ID_Continue= /a/no}');
Error('\P{ID_Continue= /a/no}');
Expect(1, 918000, '\p{ID_Continue=no}', "");
Expect(0, 918000, '\p{^ID_Continue=no}', "");
Expect(0, 918000, '\P{ID_Continue=no}', "");
Expect(1, 918000, '\P{^ID_Continue=no}', "");
Expect(0, 917999, '\p{ID_Continue=no}', "");
Expect(1, 917999, '\p{^ID_Continue=no}', "");
Expect(1, 917999, '\P{ID_Continue=no}', "");
Expect(0, 917999, '\P{^ID_Continue=no}', "");
Expect(1, 918000, '\p{ID_Continue=-	No}', "");
Expect(0, 918000, '\p{^ID_Continue=-	No}', "");
Expect(0, 918000, '\P{ID_Continue=-	No}', "");
Expect(1, 918000, '\P{^ID_Continue=-	No}', "");
Expect(0, 917999, '\p{ID_Continue=-	No}', "");
Expect(1, 917999, '\p{^ID_Continue=-	No}', "");
Expect(1, 917999, '\P{ID_Continue=-	No}', "");
Expect(0, 917999, '\P{^ID_Continue=-	No}', "");
Error('\p{IDC:  N:=}');
Error('\P{IDC:  N:=}');
Expect(1, 918000, '\p{IDC:	n}', "");
Expect(0, 918000, '\p{^IDC:	n}', "");
Expect(0, 918000, '\P{IDC:	n}', "");
Expect(1, 918000, '\P{^IDC:	n}', "");
Expect(0, 917999, '\p{IDC:	n}', "");
Expect(1, 917999, '\p{^IDC:	n}', "");
Expect(1, 917999, '\P{IDC:	n}', "");
Expect(0, 917999, '\P{^IDC:	n}', "");
Expect(1, 918000, '\p{IDC=_ n}', "");
Expect(0, 918000, '\p{^IDC=_ n}', "");
Expect(0, 918000, '\P{IDC=_ n}', "");
Expect(1, 918000, '\P{^IDC=_ n}', "");
Expect(0, 917999, '\p{IDC=_ n}', "");
Expect(1, 917999, '\p{^IDC=_ n}', "");
Expect(1, 917999, '\P{IDC=_ n}', "");
Expect(0, 917999, '\P{^IDC=_ n}', "");
Error('\p{Is_ID_Continue= F:=}');
Error('\P{Is_ID_Continue= F:=}');
Expect(1, 918000, '\p{Is_ID_Continue=f}', "");
Expect(0, 918000, '\p{^Is_ID_Continue=f}', "");
Expect(0, 918000, '\P{Is_ID_Continue=f}', "");
Expect(1, 918000, '\P{^Is_ID_Continue=f}', "");
Expect(0, 917999, '\p{Is_ID_Continue=f}', "");
Expect(1, 917999, '\p{^Is_ID_Continue=f}', "");
Expect(1, 917999, '\P{Is_ID_Continue=f}', "");
Expect(0, 917999, '\P{^Is_ID_Continue=f}', "");
Expect(1, 918000, '\p{Is_ID_Continue=--F}', "");
Expect(0, 918000, '\p{^Is_ID_Continue=--F}', "");
Expect(0, 918000, '\P{Is_ID_Continue=--F}', "");
Expect(1, 918000, '\P{^Is_ID_Continue=--F}', "");
Expect(0, 917999, '\p{Is_ID_Continue=--F}', "");
Expect(1, 917999, '\p{^Is_ID_Continue=--F}', "");
Expect(1, 917999, '\P{Is_ID_Continue=--F}', "");
Expect(0, 917999, '\P{^Is_ID_Continue=--F}', "");
Error('\p{Is_IDC=_:=false}');
Error('\P{Is_IDC=_:=false}');
Expect(1, 918000, '\p{Is_IDC=false}', "");
Expect(0, 918000, '\p{^Is_IDC=false}', "");
Expect(0, 918000, '\P{Is_IDC=false}', "");
Expect(1, 918000, '\P{^Is_IDC=false}', "");
Expect(0, 917999, '\p{Is_IDC=false}', "");
Expect(1, 917999, '\p{^Is_IDC=false}', "");
Expect(1, 917999, '\P{Is_IDC=false}', "");
Expect(0, 917999, '\P{^Is_IDC=false}', "");
Expect(1, 918000, '\p{Is_IDC= _False}', "");
Expect(0, 918000, '\p{^Is_IDC= _False}', "");
Expect(0, 918000, '\P{Is_IDC= _False}', "");
Expect(1, 918000, '\P{^Is_IDC= _False}', "");
Expect(0, 917999, '\p{Is_IDC= _False}', "");
Expect(1, 917999, '\p{^Is_IDC= _False}', "");
Expect(1, 917999, '\P{Is_IDC= _False}', "");
Expect(0, 917999, '\P{^Is_IDC= _False}', "");
Error('\p{ID_Continue=:=  Yes}');
Error('\P{ID_Continue=:=  Yes}');
Expect(1, 917999, '\p{ID_Continue=yes}', "");
Expect(0, 917999, '\p{^ID_Continue=yes}', "");
Expect(0, 917999, '\P{ID_Continue=yes}', "");
Expect(1, 917999, '\P{^ID_Continue=yes}', "");
Expect(0, 918000, '\p{ID_Continue=yes}', "");
Expect(1, 918000, '\p{^ID_Continue=yes}', "");
Expect(1, 918000, '\P{ID_Continue=yes}', "");
Expect(0, 918000, '\P{^ID_Continue=yes}', "");
Expect(1, 917999, '\p{ID_Continue=__yes}', "");
Expect(0, 917999, '\p{^ID_Continue=__yes}', "");
Expect(0, 917999, '\P{ID_Continue=__yes}', "");
Expect(1, 917999, '\P{^ID_Continue=__yes}', "");
Expect(0, 918000, '\p{ID_Continue=__yes}', "");
Expect(1, 918000, '\p{^ID_Continue=__yes}', "");
Expect(1, 918000, '\P{ID_Continue=__yes}', "");
Expect(0, 918000, '\P{^ID_Continue=__yes}', "");
Error('\p{IDC=:=Y}');
Error('\P{IDC=:=Y}');
Expect(1, 917999, '\p{IDC=y}', "");
Expect(0, 917999, '\p{^IDC=y}', "");
Expect(0, 917999, '\P{IDC=y}', "");
Expect(1, 917999, '\P{^IDC=y}', "");
Expect(0, 918000, '\p{IDC=y}', "");
Expect(1, 918000, '\p{^IDC=y}', "");
Expect(1, 918000, '\P{IDC=y}', "");
Expect(0, 918000, '\P{^IDC=y}', "");
Expect(1, 917999, '\p{IDC=-_Y}', "");
Expect(0, 917999, '\p{^IDC=-_Y}', "");
Expect(0, 917999, '\P{IDC=-_Y}', "");
Expect(1, 917999, '\P{^IDC=-_Y}', "");
Expect(0, 918000, '\p{IDC=-_Y}', "");
Expect(1, 918000, '\p{^IDC=-_Y}', "");
Expect(1, 918000, '\P{IDC=-_Y}', "");
Expect(0, 918000, '\P{^IDC=-_Y}', "");
Error('\p{Is_ID_Continue=	-T/a/}');
Error('\P{Is_ID_Continue=	-T/a/}');
Expect(1, 917999, '\p{Is_ID_Continue=t}', "");
Expect(0, 917999, '\p{^Is_ID_Continue=t}', "");
Expect(0, 917999, '\P{Is_ID_Continue=t}', "");
Expect(1, 917999, '\P{^Is_ID_Continue=t}', "");
Expect(0, 918000, '\p{Is_ID_Continue=t}', "");
Expect(1, 918000, '\p{^Is_ID_Continue=t}', "");
Expect(1, 918000, '\P{Is_ID_Continue=t}', "");
Expect(0, 918000, '\P{^Is_ID_Continue=t}', "");
Expect(1, 917999, '\p{Is_ID_Continue:_T}', "");
Expect(0, 917999, '\p{^Is_ID_Continue:_T}', "");
Expect(0, 917999, '\P{Is_ID_Continue:_T}', "");
Expect(1, 917999, '\P{^Is_ID_Continue:_T}', "");
Expect(0, 918000, '\p{Is_ID_Continue:_T}', "");
Expect(1, 918000, '\p{^Is_ID_Continue:_T}', "");
Expect(1, 918000, '\P{Is_ID_Continue:_T}', "");
Expect(0, 918000, '\P{^Is_ID_Continue:_T}', "");
Error('\p{Is_IDC=_:=true}');
Error('\P{Is_IDC=_:=true}');
Expect(1, 917999, '\p{Is_IDC=true}', "");
Expect(0, 917999, '\p{^Is_IDC=true}', "");
Expect(0, 917999, '\P{Is_IDC=true}', "");
Expect(1, 917999, '\P{^Is_IDC=true}', "");
Expect(0, 918000, '\p{Is_IDC=true}', "");
Expect(1, 918000, '\p{^Is_IDC=true}', "");
Expect(1, 918000, '\P{Is_IDC=true}', "");
Expect(0, 918000, '\P{^Is_IDC=true}', "");
Expect(1, 917999, '\p{Is_IDC=True}', "");
Expect(0, 917999, '\p{^Is_IDC=True}', "");
Expect(0, 917999, '\P{Is_IDC=True}', "");
Expect(1, 917999, '\P{^Is_IDC=True}', "");
Expect(0, 918000, '\p{Is_IDC=True}', "");
Expect(1, 918000, '\p{^Is_IDC=True}', "");
Expect(1, 918000, '\P{Is_IDC=True}', "");
Expect(0, 918000, '\P{^Is_IDC=True}', "");
Error('\p{ID_Start=/a/- No}');
Error('\P{ID_Start=/a/- No}');
Expect(1, 195102, '\p{ID_Start=no}', "");
Expect(0, 195102, '\p{^ID_Start=no}', "");
Expect(0, 195102, '\P{ID_Start=no}', "");
Expect(1, 195102, '\P{^ID_Start=no}', "");
Expect(0, 195101, '\p{ID_Start=no}', "");
Expect(1, 195101, '\p{^ID_Start=no}', "");
Expect(1, 195101, '\P{ID_Start=no}', "");
Expect(0, 195101, '\P{^ID_Start=no}', "");
Expect(1, 195102, '\p{ID_Start=--NO}', "");
Expect(0, 195102, '\p{^ID_Start=--NO}', "");
Expect(0, 195102, '\P{ID_Start=--NO}', "");
Expect(1, 195102, '\P{^ID_Start=--NO}', "");
Expect(0, 195101, '\p{ID_Start=--NO}', "");
Expect(1, 195101, '\p{^ID_Start=--NO}', "");
Expect(1, 195101, '\P{ID_Start=--NO}', "");
Expect(0, 195101, '\P{^ID_Start=--NO}', "");
Error('\p{IDS=	:=N}');
Error('\P{IDS=	:=N}');
Expect(1, 195102, '\p{IDS=n}', "");
Expect(0, 195102, '\p{^IDS=n}', "");
Expect(0, 195102, '\P{IDS=n}', "");
Expect(1, 195102, '\P{^IDS=n}', "");
Expect(0, 195101, '\p{IDS=n}', "");
Expect(1, 195101, '\p{^IDS=n}', "");
Expect(1, 195101, '\P{IDS=n}', "");
Expect(0, 195101, '\P{^IDS=n}', "");
Expect(1, 195102, '\p{IDS=-N}', "");
Expect(0, 195102, '\p{^IDS=-N}', "");
Expect(0, 195102, '\P{IDS=-N}', "");
Expect(1, 195102, '\P{^IDS=-N}', "");
Expect(0, 195101, '\p{IDS=-N}', "");
Expect(1, 195101, '\p{^IDS=-N}', "");
Expect(1, 195101, '\P{IDS=-N}', "");
Expect(0, 195101, '\P{^IDS=-N}', "");
Error('\p{Is_ID_Start= _F/a/}');
Error('\P{Is_ID_Start= _F/a/}');
Expect(1, 195102, '\p{Is_ID_Start=f}', "");
Expect(0, 195102, '\p{^Is_ID_Start=f}', "");
Expect(0, 195102, '\P{Is_ID_Start=f}', "");
Expect(1, 195102, '\P{^Is_ID_Start=f}', "");
Expect(0, 195101, '\p{Is_ID_Start=f}', "");
Expect(1, 195101, '\p{^Is_ID_Start=f}', "");
Expect(1, 195101, '\P{Is_ID_Start=f}', "");
Expect(0, 195101, '\P{^Is_ID_Start=f}', "");
Expect(1, 195102, '\p{Is_ID_Start=-	F}', "");
Expect(0, 195102, '\p{^Is_ID_Start=-	F}', "");
Expect(0, 195102, '\P{Is_ID_Start=-	F}', "");
Expect(1, 195102, '\P{^Is_ID_Start=-	F}', "");
Expect(0, 195101, '\p{Is_ID_Start=-	F}', "");
Expect(1, 195101, '\p{^Is_ID_Start=-	F}', "");
Expect(1, 195101, '\P{Is_ID_Start=-	F}', "");
Expect(0, 195101, '\P{^Is_ID_Start=-	F}', "");
Error('\p{Is_IDS= 	False:=}');
Error('\P{Is_IDS= 	False:=}');
Expect(1, 195102, '\p{Is_IDS=false}', "");
Expect(0, 195102, '\p{^Is_IDS=false}', "");
Expect(0, 195102, '\P{Is_IDS=false}', "");
Expect(1, 195102, '\P{^Is_IDS=false}', "");
Expect(0, 195101, '\p{Is_IDS=false}', "");
Expect(1, 195101, '\p{^Is_IDS=false}', "");
Expect(1, 195101, '\P{Is_IDS=false}', "");
Expect(0, 195101, '\P{^Is_IDS=false}', "");
Expect(1, 195102, '\p{Is_IDS= FALSE}', "");
Expect(0, 195102, '\p{^Is_IDS= FALSE}', "");
Expect(0, 195102, '\P{Is_IDS= FALSE}', "");
Expect(1, 195102, '\P{^Is_IDS= FALSE}', "");
Expect(0, 195101, '\p{Is_IDS= FALSE}', "");
Expect(1, 195101, '\p{^Is_IDS= FALSE}', "");
Expect(1, 195101, '\P{Is_IDS= FALSE}', "");
Expect(0, 195101, '\P{^Is_IDS= FALSE}', "");
Error('\p{ID_Start=:=		YES}');
Error('\P{ID_Start=:=		YES}');
Expect(1, 195101, '\p{ID_Start=yes}', "");
Expect(0, 195101, '\p{^ID_Start=yes}', "");
Expect(0, 195101, '\P{ID_Start=yes}', "");
Expect(1, 195101, '\P{^ID_Start=yes}', "");
Expect(0, 195102, '\p{ID_Start=yes}', "");
Expect(1, 195102, '\p{^ID_Start=yes}', "");
Expect(1, 195102, '\P{ID_Start=yes}', "");
Expect(0, 195102, '\P{^ID_Start=yes}', "");
Expect(1, 195101, '\p{ID_Start= _YES}', "");
Expect(0, 195101, '\p{^ID_Start= _YES}', "");
Expect(0, 195101, '\P{ID_Start= _YES}', "");
Expect(1, 195101, '\P{^ID_Start= _YES}', "");
Expect(0, 195102, '\p{ID_Start= _YES}', "");
Expect(1, 195102, '\p{^ID_Start= _YES}', "");
Expect(1, 195102, '\P{ID_Start= _YES}', "");
Expect(0, 195102, '\P{^ID_Start= _YES}', "");
Error('\p{IDS=-	y:=}');
Error('\P{IDS=-	y:=}');
Expect(1, 195101, '\p{IDS=y}', "");
Expect(0, 195101, '\p{^IDS=y}', "");
Expect(0, 195101, '\P{IDS=y}', "");
Expect(1, 195101, '\P{^IDS=y}', "");
Expect(0, 195102, '\p{IDS=y}', "");
Expect(1, 195102, '\p{^IDS=y}', "");
Expect(1, 195102, '\P{IDS=y}', "");
Expect(0, 195102, '\P{^IDS=y}', "");
Expect(1, 195101, '\p{IDS=_-Y}', "");
Expect(0, 195101, '\p{^IDS=_-Y}', "");
Expect(0, 195101, '\P{IDS=_-Y}', "");
Expect(1, 195101, '\P{^IDS=_-Y}', "");
Expect(0, 195102, '\p{IDS=_-Y}', "");
Expect(1, 195102, '\p{^IDS=_-Y}', "");
Expect(1, 195102, '\P{IDS=_-Y}', "");
Expect(0, 195102, '\P{^IDS=_-Y}', "");
Error('\p{Is_ID_Start=	/a/T}');
Error('\P{Is_ID_Start=	/a/T}');
Expect(1, 195101, '\p{Is_ID_Start:	t}', "");
Expect(0, 195101, '\p{^Is_ID_Start:	t}', "");
Expect(0, 195101, '\P{Is_ID_Start:	t}', "");
Expect(1, 195101, '\P{^Is_ID_Start:	t}', "");
Expect(0, 195102, '\p{Is_ID_Start:	t}', "");
Expect(1, 195102, '\p{^Is_ID_Start:	t}', "");
Expect(1, 195102, '\P{Is_ID_Start:	t}', "");
Expect(0, 195102, '\P{^Is_ID_Start:	t}', "");
Expect(1, 195101, '\p{Is_ID_Start=_ T}', "");
Expect(0, 195101, '\p{^Is_ID_Start=_ T}', "");
Expect(0, 195101, '\P{Is_ID_Start=_ T}', "");
Expect(1, 195101, '\P{^Is_ID_Start=_ T}', "");
Expect(0, 195102, '\p{Is_ID_Start=_ T}', "");
Expect(1, 195102, '\p{^Is_ID_Start=_ T}', "");
Expect(1, 195102, '\P{Is_ID_Start=_ T}', "");
Expect(0, 195102, '\P{^Is_ID_Start=_ T}', "");
Error('\p{Is_IDS:	_True/a/}');
Error('\P{Is_IDS:	_True/a/}');
Expect(1, 195101, '\p{Is_IDS:	true}', "");
Expect(0, 195101, '\p{^Is_IDS:	true}', "");
Expect(0, 195101, '\P{Is_IDS:	true}', "");
Expect(1, 195101, '\P{^Is_IDS:	true}', "");
Expect(0, 195102, '\p{Is_IDS:	true}', "");
Expect(1, 195102, '\p{^Is_IDS:	true}', "");
Expect(1, 195102, '\P{Is_IDS:	true}', "");
Expect(0, 195102, '\P{^Is_IDS:	true}', "");
Expect(1, 195101, '\p{Is_IDS:	_True}', "");
Expect(0, 195101, '\p{^Is_IDS:	_True}', "");
Expect(0, 195101, '\P{Is_IDS:	_True}', "");
Expect(1, 195101, '\P{^Is_IDS:	_True}', "");
Expect(0, 195102, '\p{Is_IDS:	_True}', "");
Expect(1, 195102, '\p{^Is_IDS:	_True}', "");
Expect(1, 195102, '\P{Is_IDS:	_True}', "");
Expect(0, 195102, '\P{^Is_IDS:	_True}', "");
Error('\p{IDS_Binary_Operator=	NO/a/}');
Error('\P{IDS_Binary_Operator=	NO/a/}');
Expect(1, 12284, '\p{IDS_Binary_Operator=no}', "");
Expect(0, 12284, '\p{^IDS_Binary_Operator=no}', "");
Expect(0, 12284, '\P{IDS_Binary_Operator=no}', "");
Expect(1, 12284, '\P{^IDS_Binary_Operator=no}', "");
Expect(0, 12283, '\p{IDS_Binary_Operator=no}', "");
Expect(1, 12283, '\p{^IDS_Binary_Operator=no}', "");
Expect(1, 12283, '\P{IDS_Binary_Operator=no}', "");
Expect(0, 12283, '\P{^IDS_Binary_Operator=no}', "");
Expect(1, 12284, '\p{IDS_Binary_Operator=-NO}', "");
Expect(0, 12284, '\p{^IDS_Binary_Operator=-NO}', "");
Expect(0, 12284, '\P{IDS_Binary_Operator=-NO}', "");
Expect(1, 12284, '\P{^IDS_Binary_Operator=-NO}', "");
Expect(0, 12283, '\p{IDS_Binary_Operator=-NO}', "");
Expect(1, 12283, '\p{^IDS_Binary_Operator=-NO}', "");
Expect(1, 12283, '\P{IDS_Binary_Operator=-NO}', "");
Expect(0, 12283, '\P{^IDS_Binary_Operator=-NO}', "");
Error('\p{IDSB:   --N/a/}');
Error('\P{IDSB:   --N/a/}');
Expect(1, 12284, '\p{IDSB:n}', "");
Expect(0, 12284, '\p{^IDSB:n}', "");
Expect(0, 12284, '\P{IDSB:n}', "");
Expect(1, 12284, '\P{^IDSB:n}', "");
Expect(0, 12283, '\p{IDSB:n}', "");
Expect(1, 12283, '\p{^IDSB:n}', "");
Expect(1, 12283, '\P{IDSB:n}', "");
Expect(0, 12283, '\P{^IDSB:n}', "");
Expect(1, 12284, '\p{IDSB=	-n}', "");
Expect(0, 12284, '\p{^IDSB=	-n}', "");
Expect(0, 12284, '\P{IDSB=	-n}', "");
Expect(1, 12284, '\P{^IDSB=	-n}', "");
Expect(0, 12283, '\p{IDSB=	-n}', "");
Expect(1, 12283, '\p{^IDSB=	-n}', "");
Expect(1, 12283, '\P{IDSB=	-n}', "");
Expect(0, 12283, '\P{^IDSB=	-n}', "");
Error('\p{Is_IDS_Binary_Operator= _F/a/}');
Error('\P{Is_IDS_Binary_Operator= _F/a/}');
Expect(1, 12284, '\p{Is_IDS_Binary_Operator=f}', "");
Expect(0, 12284, '\p{^Is_IDS_Binary_Operator=f}', "");
Expect(0, 12284, '\P{Is_IDS_Binary_Operator=f}', "");
Expect(1, 12284, '\P{^Is_IDS_Binary_Operator=f}', "");
Expect(0, 12283, '\p{Is_IDS_Binary_Operator=f}', "");
Expect(1, 12283, '\p{^Is_IDS_Binary_Operator=f}', "");
Expect(1, 12283, '\P{Is_IDS_Binary_Operator=f}', "");
Expect(0, 12283, '\P{^Is_IDS_Binary_Operator=f}', "");
Expect(1, 12284, '\p{Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12284, '\p{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12284, '\P{Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12284, '\P{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12283, '\p{Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12283, '\p{^Is_IDS_Binary_Operator:   -	f}', "");
Expect(1, 12283, '\P{Is_IDS_Binary_Operator:   -	f}', "");
Expect(0, 12283, '\P{^Is_IDS_Binary_Operator:   -	f}', "");
Error('\p{Is_IDSB=	/a/False}');
Error('\P{Is_IDSB=	/a/False}');
Expect(1, 12284, '\p{Is_IDSB=false}', "");
Expect(0, 12284, '\p{^Is_IDSB=false}', "");
Expect(0, 12284, '\P{Is_IDSB=false}', "");
Expect(1, 12284, '\P{^Is_IDSB=false}', "");
Expect(0, 12283, '\p{Is_IDSB=false}', "");
Expect(1, 12283, '\p{^Is_IDSB=false}', "");
Expect(1, 12283, '\P{Is_IDSB=false}', "");
Expect(0, 12283, '\P{^Is_IDSB=false}', "");
Expect(1, 12284, '\p{Is_IDSB=FALSE}', "");
Expect(0, 12284, '\p{^Is_IDSB=FALSE}', "");
Expect(0, 12284, '\P{Is_IDSB=FALSE}', "");
Expect(1, 12284, '\P{^Is_IDSB=FALSE}', "");
Expect(0, 12283, '\p{Is_IDSB=FALSE}', "");
Expect(1, 12283, '\p{^Is_IDSB=FALSE}', "");
Expect(1, 12283, '\P{Is_IDSB=FALSE}', "");
Expect(0, 12283, '\P{^Is_IDSB=FALSE}', "");
Error('\p{IDS_Binary_Operator= _Yes:=}');
Error('\P{IDS_Binary_Operator= _Yes:=}');
Expect(1, 12283, '\p{IDS_Binary_Operator=yes}', "");
Expect(0, 12283, '\p{^IDS_Binary_Operator=yes}', "");
Expect(0, 12283, '\P{IDS_Binary_Operator=yes}', "");
Expect(1, 12283, '\P{^IDS_Binary_Operator=yes}', "");
Expect(0, 12284, '\p{IDS_Binary_Operator=yes}', "");
Expect(1, 12284, '\p{^IDS_Binary_Operator=yes}', "");
Expect(1, 12284, '\P{IDS_Binary_Operator=yes}', "");
Expect(0, 12284, '\P{^IDS_Binary_Operator=yes}', "");
Expect(1, 12283, '\p{IDS_Binary_Operator=Yes}', "");
Expect(0, 12283, '\p{^IDS_Binary_Operator=Yes}', "");
Expect(0, 12283, '\P{IDS_Binary_Operator=Yes}', "");
Expect(1, 12283, '\P{^IDS_Binary_Operator=Yes}', "");
Expect(0, 12284, '\p{IDS_Binary_Operator=Yes}', "");
Expect(1, 12284, '\p{^IDS_Binary_Operator=Yes}', "");
Expect(1, 12284, '\P{IDS_Binary_Operator=Yes}', "");
Expect(0, 12284, '\P{^IDS_Binary_Operator=Yes}', "");
Error('\p{IDSB=- Y:=}');
Error('\P{IDSB=- Y:=}');
Expect(1, 12283, '\p{IDSB=y}', "");
Expect(0, 12283, '\p{^IDSB=y}', "");
Expect(0, 12283, '\P{IDSB=y}', "");
Expect(1, 12283, '\P{^IDSB=y}', "");
Expect(0, 12284, '\p{IDSB=y}', "");
Expect(1, 12284, '\p{^IDSB=y}', "");
Expect(1, 12284, '\P{IDSB=y}', "");
Expect(0, 12284, '\P{^IDSB=y}', "");
Expect(1, 12283, '\p{IDSB=_y}', "");
Expect(0, 12283, '\p{^IDSB=_y}', "");
Expect(0, 12283, '\P{IDSB=_y}', "");
Expect(1, 12283, '\P{^IDSB=_y}', "");
Expect(0, 12284, '\p{IDSB=_y}', "");
Expect(1, 12284, '\p{^IDSB=_y}', "");
Expect(1, 12284, '\P{IDSB=_y}', "");
Expect(0, 12284, '\P{^IDSB=_y}', "");
Error('\p{Is_IDS_Binary_Operator= :=T}');
Error('\P{Is_IDS_Binary_Operator= :=T}');
Expect(1, 12283, '\p{Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12283, '\p{^Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12283, '\P{Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12283, '\P{^Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12284, '\p{Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12284, '\p{^Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12284, '\P{Is_IDS_Binary_Operator:	t}', "");
Expect(0, 12284, '\P{^Is_IDS_Binary_Operator:	t}', "");
Expect(1, 12283, '\p{Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12283, '\p{^Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12283, '\P{Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12283, '\P{^Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12284, '\p{Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12284, '\p{^Is_IDS_Binary_Operator=__T}', "");
Expect(1, 12284, '\P{Is_IDS_Binary_Operator=__T}', "");
Expect(0, 12284, '\P{^Is_IDS_Binary_Operator=__T}', "");
Error('\p{Is_IDSB=- true/a/}');
Error('\P{Is_IDSB=- true/a/}');
Expect(1, 12283, '\p{Is_IDSB=true}', "");
Expect(0, 12283, '\p{^Is_IDSB=true}', "");
Expect(0, 12283, '\P{Is_IDSB=true}', "");
Expect(1, 12283, '\P{^Is_IDSB=true}', "");
Expect(0, 12284, '\p{Is_IDSB=true}', "");
Expect(1, 12284, '\p{^Is_IDSB=true}', "");
Expect(1, 12284, '\P{Is_IDSB=true}', "");
Expect(0, 12284, '\P{^Is_IDSB=true}', "");
Expect(1, 12283, '\p{Is_IDSB: -TRUE}', "");
Expect(0, 12283, '\p{^Is_IDSB: -TRUE}', "");
Expect(0, 12283, '\P{Is_IDSB: -TRUE}', "");
Expect(1, 12283, '\P{^Is_IDSB: -TRUE}', "");
Expect(0, 12284, '\p{Is_IDSB: -TRUE}', "");
Expect(1, 12284, '\p{^Is_IDSB: -TRUE}', "");
Expect(1, 12284, '\P{Is_IDSB: -TRUE}', "");
Expect(0, 12284, '\P{^Is_IDSB: -TRUE}', "");
Error('\p{IDS_Trinary_Operator=	:=No}');
Error('\P{IDS_Trinary_Operator=	:=No}');
Expect(1, 12276, '\p{IDS_Trinary_Operator=no}', "");
Expect(0, 12276, '\p{^IDS_Trinary_Operator=no}', "");
Expect(0, 12276, '\P{IDS_Trinary_Operator=no}', "");
Expect(1, 12276, '\P{^IDS_Trinary_Operator=no}', "");
Expect(0, 12275, '\p{IDS_Trinary_Operator=no}', "");
Expect(1, 12275, '\p{^IDS_Trinary_Operator=no}', "");
Expect(1, 12275, '\P{IDS_Trinary_Operator=no}', "");
Expect(0, 12275, '\P{^IDS_Trinary_Operator=no}', "");
Expect(1, 12276, '\p{IDS_Trinary_Operator=	No}', "");
Expect(0, 12276, '\p{^IDS_Trinary_Operator=	No}', "");
Expect(0, 12276, '\P{IDS_Trinary_Operator=	No}', "");
Expect(1, 12276, '\P{^IDS_Trinary_Operator=	No}', "");
Expect(0, 12275, '\p{IDS_Trinary_Operator=	No}', "");
Expect(1, 12275, '\p{^IDS_Trinary_Operator=	No}', "");
Expect(1, 12275, '\P{IDS_Trinary_Operator=	No}', "");
Expect(0, 12275, '\P{^IDS_Trinary_Operator=	No}', "");
Error('\p{IDST=/a/__N}');
Error('\P{IDST=/a/__N}');
Expect(1, 12276, '\p{IDST=n}', "");
Expect(0, 12276, '\p{^IDST=n}', "");
Expect(0, 12276, '\P{IDST=n}', "");
Expect(1, 12276, '\P{^IDST=n}', "");
Expect(0, 12275, '\p{IDST=n}', "");
Expect(1, 12275, '\p{^IDST=n}', "");
Expect(1, 12275, '\P{IDST=n}', "");
Expect(0, 12275, '\P{^IDST=n}', "");
Expect(1, 12276, '\p{IDST=_	N}', "");
Expect(0, 12276, '\p{^IDST=_	N}', "");
Expect(0, 12276, '\P{IDST=_	N}', "");
Expect(1, 12276, '\P{^IDST=_	N}', "");
Expect(0, 12275, '\p{IDST=_	N}', "");
Expect(1, 12275, '\p{^IDST=_	N}', "");
Expect(1, 12275, '\P{IDST=_	N}', "");
Expect(0, 12275, '\P{^IDST=_	N}', "");
Error('\p{Is_IDS_Trinary_Operator=-:=F}');
Error('\P{Is_IDS_Trinary_Operator=-:=F}');
Expect(1, 12276, '\p{Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12276, '\p{^Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12276, '\P{Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12276, '\P{^Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12275, '\p{Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12275, '\p{^Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12275, '\P{Is_IDS_Trinary_Operator=f}', "");
Expect(0, 12275, '\P{^Is_IDS_Trinary_Operator=f}', "");
Expect(1, 12276, '\p{Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12276, '\p{^Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12276, '\P{Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12276, '\P{^Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12275, '\p{Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12275, '\p{^Is_IDS_Trinary_Operator=_F}', "");
Expect(1, 12275, '\P{Is_IDS_Trinary_Operator=_F}', "");
Expect(0, 12275, '\P{^Is_IDS_Trinary_Operator=_F}', "");
Error('\p{Is_IDST=:=--False}');
Error('\P{Is_IDST=:=--False}');
Expect(1, 12276, '\p{Is_IDST=false}', "");
Expect(0, 12276, '\p{^Is_IDST=false}', "");
Expect(0, 12276, '\P{Is_IDST=false}', "");
Expect(1, 12276, '\P{^Is_IDST=false}', "");
Expect(0, 12275, '\p{Is_IDST=false}', "");
Expect(1, 12275, '\p{^Is_IDST=false}', "");
Expect(1, 12275, '\P{Is_IDST=false}', "");
Expect(0, 12275, '\P{^Is_IDST=false}', "");
Expect(1, 12276, '\p{Is_IDST=_-False}', "");
Expect(0, 12276, '\p{^Is_IDST=_-False}', "");
Expect(0, 12276, '\P{Is_IDST=_-False}', "");
Expect(1, 12276, '\P{^Is_IDST=_-False}', "");
Expect(0, 12275, '\p{Is_IDST=_-False}', "");
Expect(1, 12275, '\p{^Is_IDST=_-False}', "");
Expect(1, 12275, '\P{Is_IDST=_-False}', "");
Expect(0, 12275, '\P{^Is_IDST=_-False}', "");
Error('\p{IDS_Trinary_Operator=/a/-Yes}');
Error('\P{IDS_Trinary_Operator=/a/-Yes}');
Expect(1, 12275, '\p{IDS_Trinary_Operator:	yes}', "");
Expect(0, 12275, '\p{^IDS_Trinary_Operator:	yes}', "");
Expect(0, 12275, '\P{IDS_Trinary_Operator:	yes}', "");
Expect(1, 12275, '\P{^IDS_Trinary_Operator:	yes}', "");
Expect(0, 12276, '\p{IDS_Trinary_Operator:	yes}', "");
Expect(1, 12276, '\p{^IDS_Trinary_Operator:	yes}', "");
Expect(1, 12276, '\P{IDS_Trinary_Operator:	yes}', "");
Expect(0, 12276, '\P{^IDS_Trinary_Operator:	yes}', "");
Expect(1, 12275, '\p{IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12275, '\p{^IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12275, '\P{IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12275, '\P{^IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12276, '\p{IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12276, '\p{^IDS_Trinary_Operator=-Yes}', "");
Expect(1, 12276, '\P{IDS_Trinary_Operator=-Yes}', "");
Expect(0, 12276, '\P{^IDS_Trinary_Operator=-Yes}', "");
Error('\p{IDST= /a/Y}');
Error('\P{IDST= /a/Y}');
Expect(1, 12275, '\p{IDST=y}', "");
Expect(0, 12275, '\p{^IDST=y}', "");
Expect(0, 12275, '\P{IDST=y}', "");
Expect(1, 12275, '\P{^IDST=y}', "");
Expect(0, 12276, '\p{IDST=y}', "");
Expect(1, 12276, '\p{^IDST=y}', "");
Expect(1, 12276, '\P{IDST=y}', "");
Expect(0, 12276, '\P{^IDST=y}', "");
Expect(1, 12275, '\p{IDST=-_Y}', "");
Expect(0, 12275, '\p{^IDST=-_Y}', "");
Expect(0, 12275, '\P{IDST=-_Y}', "");
Expect(1, 12275, '\P{^IDST=-_Y}', "");
Expect(0, 12276, '\p{IDST=-_Y}', "");
Expect(1, 12276, '\p{^IDST=-_Y}', "");
Expect(1, 12276, '\P{IDST=-_Y}', "");
Expect(0, 12276, '\P{^IDST=-_Y}', "");
Error('\p{Is_IDS_Trinary_Operator: 	/a/T}');
Error('\P{Is_IDS_Trinary_Operator: 	/a/T}');
Expect(1, 12275, '\p{Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12275, '\p{^Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12275, '\P{Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12275, '\P{^Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12276, '\p{Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12276, '\p{^Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12276, '\P{Is_IDS_Trinary_Operator=t}', "");
Expect(0, 12276, '\P{^Is_IDS_Trinary_Operator=t}', "");
Expect(1, 12275, '\p{Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12275, '\p{^Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12275, '\P{Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12275, '\P{^Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12276, '\p{Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12276, '\p{^Is_IDS_Trinary_Operator=- T}', "");
Expect(1, 12276, '\P{Is_IDS_Trinary_Operator=- T}', "");
Expect(0, 12276, '\P{^Is_IDS_Trinary_Operator=- T}', "");
Error('\p{Is_IDST=:=-true}');
Error('\P{Is_IDST=:=-true}');
Expect(1, 12275, '\p{Is_IDST=true}', "");
Expect(0, 12275, '\p{^Is_IDST=true}', "");
Expect(0, 12275, '\P{Is_IDST=true}', "");
Expect(1, 12275, '\P{^Is_IDST=true}', "");
Expect(0, 12276, '\p{Is_IDST=true}', "");
Expect(1, 12276, '\p{^Is_IDST=true}', "");
Expect(1, 12276, '\P{Is_IDST=true}', "");
Expect(0, 12276, '\P{^Is_IDST=true}', "");
Expect(1, 12275, '\p{Is_IDST=	-true}', "");
Expect(0, 12275, '\p{^Is_IDST=	-true}', "");
Expect(0, 12275, '\P{Is_IDST=	-true}', "");
Expect(1, 12275, '\P{^Is_IDST=	-true}', "");
Expect(0, 12276, '\p{Is_IDST=	-true}', "");
Expect(1, 12276, '\p{^Is_IDST=	-true}', "");
Expect(1, 12276, '\P{Is_IDST=	-true}', "");
Expect(0, 12276, '\P{^Is_IDST=	-true}', "");
Error('\p{Ideographic= _No/a/}');
Error('\P{Ideographic= _No/a/}');
Expect(1, 195102, '\p{Ideographic=no}', "");
Expect(0, 195102, '\p{^Ideographic=no}', "");
Expect(0, 195102, '\P{Ideographic=no}', "");
Expect(1, 195102, '\P{^Ideographic=no}', "");
Expect(0, 195101, '\p{Ideographic=no}', "");
Expect(1, 195101, '\p{^Ideographic=no}', "");
Expect(1, 195101, '\P{Ideographic=no}', "");
Expect(0, 195101, '\P{^Ideographic=no}', "");
Expect(1, 195102, '\p{Ideographic=-_no}', "");
Expect(0, 195102, '\p{^Ideographic=-_no}', "");
Expect(0, 195102, '\P{Ideographic=-_no}', "");
Expect(1, 195102, '\P{^Ideographic=-_no}', "");
Expect(0, 195101, '\p{Ideographic=-_no}', "");
Expect(1, 195101, '\p{^Ideographic=-_no}', "");
Expect(1, 195101, '\P{Ideographic=-_no}', "");
Expect(0, 195101, '\P{^Ideographic=-_no}', "");
Error('\p{Ideo= N/a/}');
Error('\P{Ideo= N/a/}');
Expect(1, 195102, '\p{Ideo=n}', "");
Expect(0, 195102, '\p{^Ideo=n}', "");
Expect(0, 195102, '\P{Ideo=n}', "");
Expect(1, 195102, '\P{^Ideo=n}', "");
Expect(0, 195101, '\p{Ideo=n}', "");
Expect(1, 195101, '\p{^Ideo=n}', "");
Expect(1, 195101, '\P{Ideo=n}', "");
Expect(0, 195101, '\P{^Ideo=n}', "");
Expect(1, 195102, '\p{Ideo= 	N}', "");
Expect(0, 195102, '\p{^Ideo= 	N}', "");
Expect(0, 195102, '\P{Ideo= 	N}', "");
Expect(1, 195102, '\P{^Ideo= 	N}', "");
Expect(0, 195101, '\p{Ideo= 	N}', "");
Expect(1, 195101, '\p{^Ideo= 	N}', "");
Expect(1, 195101, '\P{Ideo= 	N}', "");
Expect(0, 195101, '\P{^Ideo= 	N}', "");
Error('\p{Is_Ideographic=/a/f}');
Error('\P{Is_Ideographic=/a/f}');
Expect(1, 195102, '\p{Is_Ideographic=f}', "");
Expect(0, 195102, '\p{^Is_Ideographic=f}', "");
Expect(0, 195102, '\P{Is_Ideographic=f}', "");
Expect(1, 195102, '\P{^Is_Ideographic=f}', "");
Expect(0, 195101, '\p{Is_Ideographic=f}', "");
Expect(1, 195101, '\p{^Is_Ideographic=f}', "");
Expect(1, 195101, '\P{Is_Ideographic=f}', "");
Expect(0, 195101, '\P{^Is_Ideographic=f}', "");
Expect(1, 195102, '\p{Is_Ideographic=- F}', "");
Expect(0, 195102, '\p{^Is_Ideographic=- F}', "");
Expect(0, 195102, '\P{Is_Ideographic=- F}', "");
Expect(1, 195102, '\P{^Is_Ideographic=- F}', "");
Expect(0, 195101, '\p{Is_Ideographic=- F}', "");
Expect(1, 195101, '\p{^Is_Ideographic=- F}', "");
Expect(1, 195101, '\P{Is_Ideographic=- F}', "");
Expect(0, 195101, '\P{^Is_Ideographic=- F}', "");
Error('\p{Is_Ideo=__False/a/}');
Error('\P{Is_Ideo=__False/a/}');
Expect(1, 195102, '\p{Is_Ideo=false}', "");
Expect(0, 195102, '\p{^Is_Ideo=false}', "");
Expect(0, 195102, '\P{Is_Ideo=false}', "");
Expect(1, 195102, '\P{^Is_Ideo=false}', "");
Expect(0, 195101, '\p{Is_Ideo=false}', "");
Expect(1, 195101, '\p{^Is_Ideo=false}', "");
Expect(1, 195101, '\P{Is_Ideo=false}', "");
Expect(0, 195101, '\P{^Is_Ideo=false}', "");
Expect(1, 195102, '\p{Is_Ideo=_	False}', "");
Expect(0, 195102, '\p{^Is_Ideo=_	False}', "");
Expect(0, 195102, '\P{Is_Ideo=_	False}', "");
Expect(1, 195102, '\P{^Is_Ideo=_	False}', "");
Expect(0, 195101, '\p{Is_Ideo=_	False}', "");
Expect(1, 195101, '\p{^Is_Ideo=_	False}', "");
Expect(1, 195101, '\P{Is_Ideo=_	False}', "");
Expect(0, 195101, '\P{^Is_Ideo=_	False}', "");
Error('\p{Ideographic=/a/	-YES}');
Error('\P{Ideographic=/a/	-YES}');
Expect(1, 195101, '\p{Ideographic=yes}', "");
Expect(0, 195101, '\p{^Ideographic=yes}', "");
Expect(0, 195101, '\P{Ideographic=yes}', "");
Expect(1, 195101, '\P{^Ideographic=yes}', "");
Expect(0, 195102, '\p{Ideographic=yes}', "");
Expect(1, 195102, '\p{^Ideographic=yes}', "");
Expect(1, 195102, '\P{Ideographic=yes}', "");
Expect(0, 195102, '\P{^Ideographic=yes}', "");
Expect(1, 195101, '\p{Ideographic=--yes}', "");
Expect(0, 195101, '\p{^Ideographic=--yes}', "");
Expect(0, 195101, '\P{Ideographic=--yes}', "");
Expect(1, 195101, '\P{^Ideographic=--yes}', "");
Expect(0, 195102, '\p{Ideographic=--yes}', "");
Expect(1, 195102, '\p{^Ideographic=--yes}', "");
Expect(1, 195102, '\P{Ideographic=--yes}', "");
Expect(0, 195102, '\P{^Ideographic=--yes}', "");
Error('\p{Ideo=_Y/a/}');
Error('\P{Ideo=_Y/a/}');
Expect(1, 195101, '\p{Ideo:	y}', "");
Expect(0, 195101, '\p{^Ideo:	y}', "");
Expect(0, 195101, '\P{Ideo:	y}', "");
Expect(1, 195101, '\P{^Ideo:	y}', "");
Expect(0, 195102, '\p{Ideo:	y}', "");
Expect(1, 195102, '\p{^Ideo:	y}', "");
Expect(1, 195102, '\P{Ideo:	y}', "");
Expect(0, 195102, '\P{^Ideo:	y}', "");
Expect(1, 195101, '\p{Ideo=_Y}', "");
Expect(0, 195101, '\p{^Ideo=_Y}', "");
Expect(0, 195101, '\P{Ideo=_Y}', "");
Expect(1, 195101, '\P{^Ideo=_Y}', "");
Expect(0, 195102, '\p{Ideo=_Y}', "");
Expect(1, 195102, '\p{^Ideo=_Y}', "");
Expect(1, 195102, '\P{Ideo=_Y}', "");
Expect(0, 195102, '\P{^Ideo=_Y}', "");
Error('\p{Is_Ideographic=_/a/T}');
Error('\P{Is_Ideographic=_/a/T}');
Expect(1, 195101, '\p{Is_Ideographic=t}', "");
Expect(0, 195101, '\p{^Is_Ideographic=t}', "");
Expect(0, 195101, '\P{Is_Ideographic=t}', "");
Expect(1, 195101, '\P{^Is_Ideographic=t}', "");
Expect(0, 195102, '\p{Is_Ideographic=t}', "");
Expect(1, 195102, '\p{^Is_Ideographic=t}', "");
Expect(1, 195102, '\P{Is_Ideographic=t}', "");
Expect(0, 195102, '\P{^Is_Ideographic=t}', "");
Expect(1, 195101, '\p{Is_Ideographic=- t}', "");
Expect(0, 195101, '\p{^Is_Ideographic=- t}', "");
Expect(0, 195101, '\P{Is_Ideographic=- t}', "");
Expect(1, 195101, '\P{^Is_Ideographic=- t}', "");
Expect(0, 195102, '\p{Is_Ideographic=- t}', "");
Expect(1, 195102, '\p{^Is_Ideographic=- t}', "");
Expect(1, 195102, '\P{Is_Ideographic=- t}', "");
Expect(0, 195102, '\P{^Is_Ideographic=- t}', "");
Error('\p{Is_Ideo=:= True}');
Error('\P{Is_Ideo=:= True}');
Expect(1, 195101, '\p{Is_Ideo=true}', "");
Expect(0, 195101, '\p{^Is_Ideo=true}', "");
Expect(0, 195101, '\P{Is_Ideo=true}', "");
Expect(1, 195101, '\P{^Is_Ideo=true}', "");
Expect(0, 195102, '\p{Is_Ideo=true}', "");
Expect(1, 195102, '\p{^Is_Ideo=true}', "");
Expect(1, 195102, '\P{Is_Ideo=true}', "");
Expect(0, 195102, '\P{^Is_Ideo=true}', "");
Expect(1, 195101, '\p{Is_Ideo:  True}', "");
Expect(0, 195101, '\p{^Is_Ideo:  True}', "");
Expect(0, 195101, '\P{Is_Ideo:  True}', "");
Expect(1, 195101, '\P{^Is_Ideo:  True}', "");
Expect(0, 195102, '\p{Is_Ideo:  True}', "");
Expect(1, 195102, '\p{^Is_Ideo:  True}', "");
Expect(1, 195102, '\P{Is_Ideo:  True}', "");
Expect(0, 195102, '\P{^Is_Ideo:  True}', "");
Error('\p{Present_In=	:=00001.1}');
Error('\P{Present_In=	:=00001.1}');
Expect(1, 65533, '\p{Present_In=+00001.1}', "");
Expect(0, 65533, '\p{^Present_In=+00001.1}', "");
Expect(0, 65533, '\P{Present_In=+00001.1}', "");
Expect(1, 65533, '\P{^Present_In=+00001.1}', "");
Expect(0, 65536, '\p{Present_In=+00001.1}', "");
Expect(1, 65536, '\p{^Present_In=+00001.1}', "");
Expect(1, 65536, '\P{Present_In=+00001.1}', "");
Expect(0, 65536, '\P{^Present_In=+00001.1}', "");
Error('\p{In= 1.1/a/}');
Error('\P{In= 1.1/a/}');
Expect(1, 65533, '\p{In=0000_0000_1.1}', "");
Expect(0, 65533, '\p{^In=0000_0000_1.1}', "");
Expect(0, 65533, '\P{In=0000_0000_1.1}', "");
Expect(1, 65533, '\P{^In=0000_0000_1.1}', "");
Expect(0, 65536, '\p{In=0000_0000_1.1}', "");
Expect(1, 65536, '\p{^In=0000_0000_1.1}', "");
Expect(1, 65536, '\P{In=0000_0000_1.1}', "");
Expect(0, 65536, '\P{^In=0000_0000_1.1}', "");
Error('\p{Is_Present_In=- +00_1.1/a/}');
Error('\P{Is_Present_In=- +00_1.1/a/}');
Expect(1, 65533, '\p{Is_Present_In=+000001.1}', "");
Expect(0, 65533, '\p{^Is_Present_In=+000001.1}', "");
Expect(0, 65533, '\P{Is_Present_In=+000001.1}', "");
Expect(1, 65533, '\P{^Is_Present_In=+000001.1}', "");
Expect(0, 65536, '\p{Is_Present_In=+000001.1}', "");
Expect(1, 65536, '\p{^Is_Present_In=+000001.1}', "");
Expect(1, 65536, '\P{Is_Present_In=+000001.1}', "");
Expect(0, 65536, '\P{^Is_Present_In=+000001.1}', "");
Error('\p{Is_In=-/a/+00000001.1}');
Error('\P{Is_In=-/a/+00000001.1}');
Expect(1, 65533, '\p{Is_In=0_1.1}', "");
Expect(0, 65533, '\p{^Is_In=0_1.1}', "");
Expect(0, 65533, '\P{Is_In=0_1.1}', "");
Expect(1, 65533, '\P{^Is_In=0_1.1}', "");
Expect(0, 65536, '\p{Is_In=0_1.1}', "");
Expect(1, 65536, '\p{^Is_In=0_1.1}', "");
Expect(1, 65536, '\P{Is_In=0_1.1}', "");
Expect(0, 65536, '\P{^Is_In=0_1.1}', "");
Error('\p{Present_In=/a/ -2.0}');
Error('\P{Present_In=/a/ -2.0}');
Expect(1, 983040, '\p{Present_In:+00000002.0}', "");
Expect(0, 983040, '\p{^Present_In:+00000002.0}', "");
Expect(0, 983040, '\P{Present_In:+00000002.0}', "");
Expect(1, 983040, '\P{^Present_In:+00000002.0}', "");
Expect(0, 983037, '\p{Present_In:+00000002.0}', "");
Expect(1, 983037, '\p{^Present_In:+00000002.0}', "");
Expect(1, 983037, '\P{Present_In:+00000002.0}', "");
Expect(0, 983037, '\P{^Present_In:+00000002.0}', "");
Error('\p{In: _ 0002.0:=}');
Error('\P{In: _ 0002.0:=}');
Expect(1, 983040, '\p{In=+0000002.0}', "");
Expect(0, 983040, '\p{^In=+0000002.0}', "");
Expect(0, 983040, '\P{In=+0000002.0}', "");
Expect(1, 983040, '\P{^In=+0000002.0}', "");
Expect(0, 983037, '\p{In=+0000002.0}', "");
Expect(1, 983037, '\p{^In=+0000002.0}', "");
Expect(1, 983037, '\P{In=+0000002.0}', "");
Expect(0, 983037, '\P{^In=+0000002.0}', "");
Error('\p{Is_Present_In= -0000000002.0/a/}');
Error('\P{Is_Present_In= -0000000002.0/a/}');
Expect(1, 983040, '\p{Is_Present_In=+000_000_2.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=+000_000_2.0}', "");
Expect(0, 983040, '\P{Is_Present_In=+000_000_2.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=+000_000_2.0}', "");
Expect(0, 983037, '\p{Is_Present_In=+000_000_2.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=+000_000_2.0}', "");
Expect(1, 983037, '\P{Is_Present_In=+000_000_2.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=+000_000_2.0}', "");
Error('\p{Is_In=:= _0_2.0}');
Error('\P{Is_In=:= _0_2.0}');
Expect(1, 983040, '\p{Is_In=000002.0}', "");
Expect(0, 983040, '\p{^Is_In=000002.0}', "");
Expect(0, 983040, '\P{Is_In=000002.0}', "");
Expect(1, 983040, '\P{^Is_In=000002.0}', "");
Expect(0, 983037, '\p{Is_In=000002.0}', "");
Expect(1, 983037, '\p{^Is_In=000002.0}', "");
Expect(1, 983037, '\P{Is_In=000002.0}', "");
Expect(0, 983037, '\P{^Is_In=000002.0}', "");
Error('\p{Present_In=- 000_000_000_2.1/a/}');
Error('\P{Present_In=- 000_000_000_2.1/a/}');
Expect(1, 983040, '\p{Present_In=00_00_2.1}', "");
Expect(0, 983040, '\p{^Present_In=00_00_2.1}', "");
Expect(0, 983040, '\P{Present_In=00_00_2.1}', "");
Expect(1, 983040, '\P{^Present_In=00_00_2.1}', "");
Expect(0, 983037, '\p{Present_In=00_00_2.1}', "");
Expect(1, 983037, '\p{^Present_In=00_00_2.1}', "");
Expect(1, 983037, '\P{Present_In=00_00_2.1}', "");
Expect(0, 983037, '\P{^Present_In=00_00_2.1}', "");
Error('\p{In=:=000002.1}');
Error('\P{In=:=000002.1}');
Expect(1, 983040, '\p{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983040, '\p{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983040, '\P{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983040, '\P{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983037, '\p{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983037, '\p{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(1, 983037, '\P{In=+0_0_0_0_0_0_0_0_02.1}', "");
Expect(0, 983037, '\P{^In=+0_0_0_0_0_0_0_0_02.1}', "");
Error('\p{Is_Present_In=-:=0_0_0_0_002.1}');
Error('\P{Is_Present_In=-:=0_0_0_0_002.1}');
Expect(1, 983040, '\p{Is_Present_In=+0000002.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=+0000002.1}', "");
Expect(0, 983040, '\P{Is_Present_In=+0000002.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=+0000002.1}', "");
Expect(0, 983037, '\p{Is_Present_In=+0000002.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=+0000002.1}', "");
Expect(1, 983037, '\P{Is_Present_In=+0000002.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=+0000002.1}', "");
Error('\p{Is_In=_/a/+000_000_000_2.1}');
Error('\P{Is_In=_/a/+000_000_000_2.1}');
Expect(1, 983040, '\p{Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983040, '\p{^Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983040, '\P{Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983040, '\P{^Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983037, '\p{Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983037, '\p{^Is_In=0_0_0_0_0002.1}', "");
Expect(1, 983037, '\P{Is_In=0_0_0_0_0002.1}', "");
Expect(0, 983037, '\P{^Is_In=0_0_0_0_0002.1}', "");
Error('\p{Present_In=	-+0003.0:=}');
Error('\P{Present_In=	-+0003.0:=}');
Expect(1, 983040, '\p{Present_In=000003.0}', "");
Expect(0, 983040, '\p{^Present_In=000003.0}', "");
Expect(0, 983040, '\P{Present_In=000003.0}', "");
Expect(1, 983040, '\P{^Present_In=000003.0}', "");
Expect(0, 983037, '\p{Present_In=000003.0}', "");
Expect(1, 983037, '\p{^Present_In=000003.0}', "");
Expect(1, 983037, '\P{Present_In=000003.0}', "");
Expect(0, 983037, '\P{^Present_In=000003.0}', "");
Error('\p{In=/a/+0_0_0_0_0003.0}');
Error('\P{In=/a/+0_0_0_0_0003.0}');
Expect(1, 983040, '\p{In=000_3.0}', "");
Expect(0, 983040, '\p{^In=000_3.0}', "");
Expect(0, 983040, '\P{In=000_3.0}', "");
Expect(1, 983040, '\P{^In=000_3.0}', "");
Expect(0, 983037, '\p{In=000_3.0}', "");
Expect(1, 983037, '\p{^In=000_3.0}', "");
Expect(1, 983037, '\P{In=000_3.0}', "");
Expect(0, 983037, '\P{^In=000_3.0}', "");
Error('\p{Is_Present_In=:= +0_3.0}');
Error('\P{Is_Present_In=:= +0_3.0}');
Expect(1, 983040, '\p{Is_Present_In:   3.0}', "");
Expect(0, 983040, '\p{^Is_Present_In:   3.0}', "");
Expect(0, 983040, '\P{Is_Present_In:   3.0}', "");
Expect(1, 983040, '\P{^Is_Present_In:   3.0}', "");
Expect(0, 983037, '\p{Is_Present_In:   3.0}', "");
Expect(1, 983037, '\p{^Is_Present_In:   3.0}', "");
Expect(1, 983037, '\P{Is_Present_In:   3.0}', "");
Expect(0, 983037, '\P{^Is_Present_In:   3.0}', "");
Error('\p{Is_In=	:=0000_0000_3.0}');
Error('\P{Is_In=	:=0000_0000_3.0}');
Expect(1, 983040, '\p{Is_In=+03.0}', "");
Expect(0, 983040, '\p{^Is_In=+03.0}', "");
Expect(0, 983040, '\P{Is_In=+03.0}', "");
Expect(1, 983040, '\P{^Is_In=+03.0}', "");
Expect(0, 983037, '\p{Is_In=+03.0}', "");
Expect(1, 983037, '\p{^Is_In=+03.0}', "");
Expect(1, 983037, '\P{Is_In=+03.0}', "");
Expect(0, 983037, '\P{^Is_In=+03.0}', "");
Error('\p{Present_In=/a/	_+0000000003.1}');
Error('\P{Present_In=/a/	_+0000000003.1}');
Expect(1, 983040, '\p{Present_In=003.1}', "");
Expect(0, 983040, '\p{^Present_In=003.1}', "");
Expect(0, 983040, '\P{Present_In=003.1}', "");
Expect(1, 983040, '\P{^Present_In=003.1}', "");
Expect(0, 983037, '\p{Present_In=003.1}', "");
Expect(1, 983037, '\p{^Present_In=003.1}', "");
Expect(1, 983037, '\P{Present_In=003.1}', "");
Expect(0, 983037, '\P{^Present_In=003.1}', "");
Error('\p{In=_ +00_00_3.1/a/}');
Error('\P{In=_ +00_00_3.1/a/}');
Expect(1, 983040, '\p{In=+0000000003.1}', "");
Expect(0, 983040, '\p{^In=+0000000003.1}', "");
Expect(0, 983040, '\P{In=+0000000003.1}', "");
Expect(1, 983040, '\P{^In=+0000000003.1}', "");
Expect(0, 983037, '\p{In=+0000000003.1}', "");
Expect(1, 983037, '\p{^In=+0000000003.1}', "");
Expect(1, 983037, '\P{In=+0000000003.1}', "");
Expect(0, 983037, '\P{^In=+0000000003.1}', "");
Error('\p{Is_Present_In=	_0000000003.1:=}');
Error('\P{Is_Present_In=	_0000000003.1:=}');
Expect(1, 983040, '\p{Is_Present_In=3.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=3.1}', "");
Expect(0, 983040, '\P{Is_Present_In=3.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=3.1}', "");
Expect(0, 983037, '\p{Is_Present_In=3.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=3.1}', "");
Expect(1, 983037, '\P{Is_Present_In=3.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=3.1}', "");
Error('\p{Is_In=:=_+000_000_03.1}');
Error('\P{Is_In=:=_+000_000_03.1}');
Expect(1, 983040, '\p{Is_In:0000003.1}', "");
Expect(0, 983040, '\p{^Is_In:0000003.1}', "");
Expect(0, 983040, '\P{Is_In:0000003.1}', "");
Expect(1, 983040, '\P{^Is_In:0000003.1}', "");
Expect(0, 983037, '\p{Is_In:0000003.1}', "");
Expect(1, 983037, '\p{^Is_In:0000003.1}', "");
Expect(1, 983037, '\P{Is_In:0000003.1}', "");
Expect(0, 983037, '\P{^Is_In:0000003.1}', "");
Error('\p{Present_In=:= 	+03.2}');
Error('\P{Present_In=:= 	+03.2}');
Expect(1, 983040, '\p{Present_In=+0000000_3.2}', "");
Expect(0, 983040, '\p{^Present_In=+0000000_3.2}', "");
Expect(0, 983040, '\P{Present_In=+0000000_3.2}', "");
Expect(1, 983040, '\P{^Present_In=+0000000_3.2}', "");
Expect(0, 983037, '\p{Present_In=+0000000_3.2}', "");
Expect(1, 983037, '\p{^Present_In=+0000000_3.2}', "");
Expect(1, 983037, '\P{Present_In=+0000000_3.2}', "");
Expect(0, 983037, '\P{^Present_In=+0000000_3.2}', "");
Error('\p{In=_/a/00000_3.2}');
Error('\P{In=_/a/00000_3.2}');
Expect(1, 983040, '\p{In=00000000_3.2}', "");
Expect(0, 983040, '\p{^In=00000000_3.2}', "");
Expect(0, 983040, '\P{In=00000000_3.2}', "");
Expect(1, 983040, '\P{^In=00000000_3.2}', "");
Expect(0, 983037, '\p{In=00000000_3.2}', "");
Expect(1, 983037, '\p{^In=00000000_3.2}', "");
Expect(1, 983037, '\P{In=00000000_3.2}', "");
Expect(0, 983037, '\P{^In=00000000_3.2}', "");
Error('\p{Is_Present_In:	:=--000000000_3.2}');
Error('\P{Is_Present_In:	:=--000000000_3.2}');
Expect(1, 983040, '\p{Is_Present_In=0003.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=0003.2}', "");
Expect(0, 983040, '\P{Is_Present_In=0003.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=0003.2}', "");
Expect(0, 983037, '\p{Is_Present_In=0003.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=0003.2}', "");
Expect(1, 983037, '\P{Is_Present_In=0003.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=0003.2}', "");
Error('\p{Is_In=	/a/+3.2}');
Error('\P{Is_In=	/a/+3.2}');
Expect(1, 983040, '\p{Is_In:	+000_000_03.2}', "");
Expect(0, 983040, '\p{^Is_In:	+000_000_03.2}', "");
Expect(0, 983040, '\P{Is_In:	+000_000_03.2}', "");
Expect(1, 983040, '\P{^Is_In:	+000_000_03.2}', "");
Expect(0, 983037, '\p{Is_In:	+000_000_03.2}', "");
Expect(1, 983037, '\p{^Is_In:	+000_000_03.2}', "");
Expect(1, 983037, '\P{Is_In:	+000_000_03.2}', "");
Expect(0, 983037, '\P{^Is_In:	+000_000_03.2}', "");
Error('\p{Present_In=-+0_0_0_004.0:=}');
Error('\P{Present_In=-+0_0_0_004.0:=}');
Expect(1, 983040, '\p{Present_In=0004.0}', "");
Expect(0, 983040, '\p{^Present_In=0004.0}', "");
Expect(0, 983040, '\P{Present_In=0004.0}', "");
Expect(1, 983040, '\P{^Present_In=0004.0}', "");
Expect(0, 983037, '\p{Present_In=0004.0}', "");
Expect(1, 983037, '\p{^Present_In=0004.0}', "");
Expect(1, 983037, '\P{Present_In=0004.0}', "");
Expect(0, 983037, '\P{^Present_In=0004.0}', "");
Error('\p{In=- +0000000004.0:=}');
Error('\P{In=- +0000000004.0:=}');
Expect(1, 983040, '\p{In=+4.0}', "");
Expect(0, 983040, '\p{^In=+4.0}', "");
Expect(0, 983040, '\P{In=+4.0}', "");
Expect(1, 983040, '\P{^In=+4.0}', "");
Expect(0, 983037, '\p{In=+4.0}', "");
Expect(1, 983037, '\p{^In=+4.0}', "");
Expect(1, 983037, '\P{In=+4.0}', "");
Expect(0, 983037, '\P{^In=+4.0}', "");
Error('\p{Is_Present_In=:=000_000_4.0}');
Error('\P{Is_Present_In=:=000_000_4.0}');
Expect(1, 983040, '\p{Is_Present_In=+0004.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=+0004.0}', "");
Expect(0, 983040, '\P{Is_Present_In=+0004.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=+0004.0}', "");
Expect(0, 983037, '\p{Is_Present_In=+0004.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=+0004.0}', "");
Expect(1, 983037, '\P{Is_Present_In=+0004.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=+0004.0}', "");
Error('\p{Is_In=/a/	-004.0}');
Error('\P{Is_In=/a/	-004.0}');
Expect(1, 983040, '\p{Is_In=0004.0}', "");
Expect(0, 983040, '\p{^Is_In=0004.0}', "");
Expect(0, 983040, '\P{Is_In=0004.0}', "");
Expect(1, 983040, '\P{^Is_In=0004.0}', "");
Expect(0, 983037, '\p{Is_In=0004.0}', "");
Expect(1, 983037, '\p{^Is_In=0004.0}', "");
Expect(1, 983037, '\P{Is_In=0004.0}', "");
Expect(0, 983037, '\P{^Is_In=0004.0}', "");
Error('\p{Present_In:	 /a/4.1}');
Error('\P{Present_In:	 /a/4.1}');
Expect(1, 983040, '\p{Present_In=0000004.1}', "");
Expect(0, 983040, '\p{^Present_In=0000004.1}', "");
Expect(0, 983040, '\P{Present_In=0000004.1}', "");
Expect(1, 983040, '\P{^Present_In=0000004.1}', "");
Expect(0, 983037, '\p{Present_In=0000004.1}', "");
Expect(1, 983037, '\p{^Present_In=0000004.1}', "");
Expect(1, 983037, '\P{Present_In=0000004.1}', "");
Expect(0, 983037, '\P{^Present_In=0000004.1}', "");
Error('\p{In=:=4.1}');
Error('\P{In=:=4.1}');
Expect(1, 983040, '\p{In:   +004.1}', "");
Expect(0, 983040, '\p{^In:   +004.1}', "");
Expect(0, 983040, '\P{In:   +004.1}', "");
Expect(1, 983040, '\P{^In:   +004.1}', "");
Expect(0, 983037, '\p{In:   +004.1}', "");
Expect(1, 983037, '\p{^In:   +004.1}', "");
Expect(1, 983037, '\P{In:   +004.1}', "");
Expect(0, 983037, '\P{^In:   +004.1}', "");
Error('\p{Is_Present_In=/a/+00000004.1}');
Error('\P{Is_Present_In=/a/+00000004.1}');
Expect(1, 983040, '\p{Is_Present_In=00000004.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=00000004.1}', "");
Expect(0, 983040, '\P{Is_Present_In=00000004.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=00000004.1}', "");
Expect(0, 983037, '\p{Is_Present_In=00000004.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=00000004.1}', "");
Expect(1, 983037, '\P{Is_Present_In=00000004.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=00000004.1}', "");
Error('\p{Is_In=/a/  +0004.1}');
Error('\P{Is_In=/a/  +0004.1}');
Expect(1, 983040, '\p{Is_In=0004.1}', "");
Expect(0, 983040, '\p{^Is_In=0004.1}', "");
Expect(0, 983040, '\P{Is_In=0004.1}', "");
Expect(1, 983040, '\P{^Is_In=0004.1}', "");
Expect(0, 983037, '\p{Is_In=0004.1}', "");
Expect(1, 983037, '\p{^Is_In=0004.1}', "");
Expect(1, 983037, '\P{Is_In=0004.1}', "");
Expect(0, 983037, '\P{^Is_In=0004.1}', "");
Error('\p{Present_In=:=_0000005.0}');
Error('\P{Present_In=:=_0000005.0}');
Expect(1, 983040, '\p{Present_In=005.0}', "");
Expect(0, 983040, '\p{^Present_In=005.0}', "");
Expect(0, 983040, '\P{Present_In=005.0}', "");
Expect(1, 983040, '\P{^Present_In=005.0}', "");
Expect(0, 983037, '\p{Present_In=005.0}', "");
Expect(1, 983037, '\p{^Present_In=005.0}', "");
Expect(1, 983037, '\P{Present_In=005.0}', "");
Expect(0, 983037, '\P{^Present_In=005.0}', "");
Error('\p{In:	/a/00000000_5.0}');
Error('\P{In:	/a/00000000_5.0}');
Expect(1, 983040, '\p{In=+00_00_5.0}', "");
Expect(0, 983040, '\p{^In=+00_00_5.0}', "");
Expect(0, 983040, '\P{In=+00_00_5.0}', "");
Expect(1, 983040, '\P{^In=+00_00_5.0}', "");
Expect(0, 983037, '\p{In=+00_00_5.0}', "");
Expect(1, 983037, '\p{^In=+00_00_5.0}', "");
Expect(1, 983037, '\P{In=+00_00_5.0}', "");
Expect(0, 983037, '\P{^In=+00_00_5.0}', "");
Error('\p{Is_Present_In=:=	-00000005.0}');
Error('\P{Is_Present_In=:=	-00000005.0}');
Expect(1, 983040, '\p{Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983040, '\P{Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983037, '\p{Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=0_0_0_05.0}', "");
Expect(1, 983037, '\P{Is_Present_In=0_0_0_05.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=0_0_0_05.0}', "");
Error('\p{Is_In=/a/	-5.0}');
Error('\P{Is_In=/a/	-5.0}');
Expect(1, 983040, '\p{Is_In=000000005.0}', "");
Expect(0, 983040, '\p{^Is_In=000000005.0}', "");
Expect(0, 983040, '\P{Is_In=000000005.0}', "");
Expect(1, 983040, '\P{^Is_In=000000005.0}', "");
Expect(0, 983037, '\p{Is_In=000000005.0}', "");
Expect(1, 983037, '\p{^Is_In=000000005.0}', "");
Expect(1, 983037, '\P{Is_In=000000005.0}', "");
Expect(0, 983037, '\P{^Is_In=000000005.0}', "");
Error('\p{Present_In=__00000_5.1:=}');
Error('\P{Present_In=__00000_5.1:=}');
Expect(1, 983040, '\p{Present_In=0_0_0_05.1}', "");
Expect(0, 983040, '\p{^Present_In=0_0_0_05.1}', "");
Expect(0, 983040, '\P{Present_In=0_0_0_05.1}', "");
Expect(1, 983040, '\P{^Present_In=0_0_0_05.1}', "");
Expect(0, 983037, '\p{Present_In=0_0_0_05.1}', "");
Expect(1, 983037, '\p{^Present_In=0_0_0_05.1}', "");
Expect(1, 983037, '\P{Present_In=0_0_0_05.1}', "");
Expect(0, 983037, '\P{^Present_In=0_0_0_05.1}', "");
Error('\p{In::=-+0_0_0_0_0_05.1}');
Error('\P{In::=-+0_0_0_0_0_05.1}');
Expect(1, 983040, '\p{In=0000000005.1}', "");
Expect(0, 983040, '\p{^In=0000000005.1}', "");
Expect(0, 983040, '\P{In=0000000005.1}', "");
Expect(1, 983040, '\P{^In=0000000005.1}', "");
Expect(0, 983037, '\p{In=0000000005.1}', "");
Expect(1, 983037, '\p{^In=0000000005.1}', "");
Expect(1, 983037, '\P{In=0000000005.1}', "");
Expect(0, 983037, '\P{^In=0000000005.1}', "");
Error('\p{Is_Present_In=	:=00000_5.1}');
Error('\P{Is_Present_In=	:=00000_5.1}');
Expect(1, 983040, '\p{Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983040, '\p{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983040, '\P{Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983040, '\P{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983037, '\p{Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983037, '\p{^Is_Present_In=0_0_0_0_05.1}', "");
Expect(1, 983037, '\P{Is_Present_In=0_0_0_0_05.1}', "");
Expect(0, 983037, '\P{^Is_Present_In=0_0_0_0_05.1}', "");
Error('\p{Is_In: 	-0_5.1:=}');
Error('\P{Is_In: 	-0_5.1:=}');
Expect(1, 983040, '\p{Is_In=0_0_0_0_005.1}', "");
Expect(0, 983040, '\p{^Is_In=0_0_0_0_005.1}', "");
Expect(0, 983040, '\P{Is_In=0_0_0_0_005.1}', "");
Expect(1, 983040, '\P{^Is_In=0_0_0_0_005.1}', "");
Expect(0, 983037, '\p{Is_In=0_0_0_0_005.1}', "");
Expect(1, 983037, '\p{^Is_In=0_0_0_0_005.1}', "");
Expect(1, 983037, '\P{Is_In=0_0_0_0_005.1}', "");
Expect(0, 983037, '\P{^Is_In=0_0_0_0_005.1}', "");
Error('\p{Present_In:		/a/0_0_05.2}');
Error('\P{Present_In:		/a/0_0_05.2}');
Expect(1, 983040, '\p{Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983040, '\p{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983040, '\P{Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983040, '\P{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983037, '\p{Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983037, '\p{^Present_In=0_0_0_0_0_00005.2}', "");
Expect(1, 983037, '\P{Present_In=0_0_0_0_0_00005.2}', "");
Expect(0, 983037, '\P{^Present_In=0_0_0_0_0_00005.2}', "");
Error('\p{In=-:=+005.2}');
Error('\P{In=-:=+005.2}');
Expect(1, 983040, '\p{In:	00000005.2}', "");
Expect(0, 983040, '\p{^In:	00000005.2}', "");
Expect(0, 983040, '\P{In:	00000005.2}', "");
Expect(1, 983040, '\P{^In:	00000005.2}', "");
Expect(0, 983037, '\p{In:	00000005.2}', "");
Expect(1, 983037, '\p{^In:	00000005.2}', "");
Expect(1, 983037, '\P{In:	00000005.2}', "");
Expect(0, 983037, '\P{^In:	00000005.2}', "");
Error('\p{Is_Present_In=	:=+0_0_0_0_0_0_0_05.2}');
Error('\P{Is_Present_In=	:=+0_0_0_0_0_0_0_05.2}');
Expect(1, 983040, '\p{Is_Present_In=+00005.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=+00005.2}', "");
Expect(0, 983040, '\P{Is_Present_In=+00005.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=+00005.2}', "");
Expect(0, 983037, '\p{Is_Present_In=+00005.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=+00005.2}', "");
Expect(1, 983037, '\P{Is_Present_In=+00005.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=+00005.2}', "");
Error('\p{Is_In: := 	+00000005.2}');
Error('\P{Is_In: := 	+00000005.2}');
Expect(1, 983040, '\p{Is_In=0_5.2}', "");
Expect(0, 983040, '\p{^Is_In=0_5.2}', "");
Expect(0, 983040, '\P{Is_In=0_5.2}', "");
Expect(1, 983040, '\P{^Is_In=0_5.2}', "");
Expect(0, 983037, '\p{Is_In=0_5.2}', "");
Expect(1, 983037, '\p{^Is_In=0_5.2}', "");
Expect(1, 983037, '\P{Is_In=0_5.2}', "");
Expect(0, 983037, '\P{^Is_In=0_5.2}', "");
Error('\p{Present_In::=_-+00_00_06.0}');
Error('\P{Present_In::=_-+00_00_06.0}');
Expect(1, 983040, '\p{Present_In=06.0}', "");
Expect(0, 983040, '\p{^Present_In=06.0}', "");
Expect(0, 983040, '\P{Present_In=06.0}', "");
Expect(1, 983040, '\P{^Present_In=06.0}', "");
Expect(0, 983037, '\p{Present_In=06.0}', "");
Expect(1, 983037, '\p{^Present_In=06.0}', "");
Expect(1, 983037, '\P{Present_In=06.0}', "");
Expect(0, 983037, '\P{^Present_In=06.0}', "");
Error('\p{In=:=	 006.0}');
Error('\P{In=:=	 006.0}');
Expect(1, 983040, '\p{In=+0006.0}', "");
Expect(0, 983040, '\p{^In=+0006.0}', "");
Expect(0, 983040, '\P{In=+0006.0}', "");
Expect(1, 983040, '\P{^In=+0006.0}', "");
Expect(0, 983037, '\p{In=+0006.0}', "");
Expect(1, 983037, '\p{^In=+0006.0}', "");
Expect(1, 983037, '\P{In=+0006.0}', "");
Expect(0, 983037, '\P{^In=+0006.0}', "");
Error('\p{Is_Present_In=/a/ 0_0_06.0}');
Error('\P{Is_Present_In=/a/ 0_0_06.0}');
Expect(1, 983040, '\p{Is_Present_In=000000_6.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=000000_6.0}', "");
Expect(0, 983040, '\P{Is_Present_In=000000_6.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=000000_6.0}', "");
Expect(0, 983037, '\p{Is_Present_In=000000_6.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=000000_6.0}', "");
Expect(1, 983037, '\P{Is_Present_In=000000_6.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=000000_6.0}', "");
Error('\p{Is_In=__0006.0:=}');
Error('\P{Is_In=__0006.0:=}');
Expect(1, 983040, '\p{Is_In=6.0}', "");
Expect(0, 983040, '\p{^Is_In=6.0}', "");
Expect(0, 983040, '\P{Is_In=6.0}', "");
Expect(1, 983040, '\P{^Is_In=6.0}', "");
Expect(0, 983037, '\p{Is_In=6.0}', "");
Expect(1, 983037, '\p{^Is_In=6.0}', "");
Expect(1, 983037, '\P{Is_In=6.0}', "");
Expect(0, 983037, '\P{^Is_In=6.0}', "");
Error('\p{Present_In=:=00000006.1}');
Error('\P{Present_In=:=00000006.1}');
Expect(1, 983040, '\p{Present_In=+000_000_06.1}', "");
Expect(0, 983040, '\p{^Present_In=+000_000_06.1}', "");
Expect(0, 983040, '\P{Present_In=+000_000_06.1}', "");
Expect(1, 983040, '\P{^Present_In=+000_000_06.1}', "");
Expect(0, 983037, '\p{Present_In=+000_000_06.1}', "");
Expect(1, 983037, '\p{^Present_In=+000_000_06.1}', "");
Expect(1, 983037, '\P{Present_In=+000_000_06.1}', "");
Expect(0, 983037, '\P{^Present_In=+000_000_06.1}', "");
Error('\p{In=	/a/+6.1}');
Error('\P{In=	/a/+6.1}');
Expect(1, 983040, '\p{In=+00_6.1}', "");
Expect(0, 983040, '\p{^In=+00_6.1}', "");
Expect(0, 983040, '\P{In=+00_6.1}', "");
Expect(1, 983040, '\P{^In=+00_6.1}', "");
Expect(0, 983037, '\p{In=+00_6.1}', "");
Expect(1, 983037, '\p{^In=+00_6.1}', "");
Expect(1, 983037, '\P{In=+00_6.1}', "");
Expect(0, 983037, '\P{^In=+00_6.1}', "");
Error('\p{Is_Present_In=/a/	6.1}');
Error('\P{Is_Present_In=/a/	6.1}');
Expect(1, 983040, '\p{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983040, '\p{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983040, '\P{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983040, '\P{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983037, '\p{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983037, '\p{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(1, 983037, '\P{Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Expect(0, 983037, '\P{^Is_Present_In:	+0_0_0_0_0_0006.1}', "");
Error('\p{Is_In:	:=-	+0_0_0_0_0_006.1}');
Error('\P{Is_In:	:=-	+0_0_0_0_0_006.1}');
Expect(1, 983040, '\p{Is_In=0000000006.1}', "");
Expect(0, 983040, '\p{^Is_In=0000000006.1}', "");
Expect(0, 983040, '\P{Is_In=0000000006.1}', "");
Expect(1, 983040, '\P{^Is_In=0000000006.1}', "");
Expect(0, 983037, '\p{Is_In=0000000006.1}', "");
Expect(1, 983037, '\p{^Is_In=0000000006.1}', "");
Expect(1, 983037, '\P{Is_In=0000000006.1}', "");
Expect(0, 983037, '\P{^Is_In=0000000006.1}', "");
Error('\p{Present_In=:=		000006.2}');
Error('\P{Present_In=:=		000006.2}');
Expect(1, 983040, '\p{Present_In=+000006.2}', "");
Expect(0, 983040, '\p{^Present_In=+000006.2}', "");
Expect(0, 983040, '\P{Present_In=+000006.2}', "");
Expect(1, 983040, '\P{^Present_In=+000006.2}', "");
Expect(0, 983037, '\p{Present_In=+000006.2}', "");
Expect(1, 983037, '\p{^Present_In=+000006.2}', "");
Expect(1, 983037, '\P{Present_In=+000006.2}', "");
Expect(0, 983037, '\P{^Present_In=+000006.2}', "");
Error('\p{In=_/a/0000_6.2}');
Error('\P{In=_/a/0000_6.2}');
Expect(1, 983040, '\p{In=000000_6.2}', "");
Expect(0, 983040, '\p{^In=000000_6.2}', "");
Expect(0, 983040, '\P{In=000000_6.2}', "");
Expect(1, 983040, '\P{^In=000000_6.2}', "");
Expect(0, 983037, '\p{In=000000_6.2}', "");
Expect(1, 983037, '\p{^In=000000_6.2}', "");
Expect(1, 983037, '\P{In=000000_6.2}', "");
Expect(0, 983037, '\P{^In=000000_6.2}', "");
Error('\p{Is_Present_In=:=	 +00_00_6.2}');
Error('\P{Is_Present_In=:=	 +00_00_6.2}');
Expect(1, 983040, '\p{Is_Present_In=0000006.2}', "");
Expect(0, 983040, '\p{^Is_Present_In=0000006.2}', "");
Expect(0, 983040, '\P{Is_Present_In=0000006.2}', "");
Expect(1, 983040, '\P{^Is_Present_In=0000006.2}', "");
Expect(0, 983037, '\p{Is_Present_In=0000006.2}', "");
Expect(1, 983037, '\p{^Is_Present_In=0000006.2}', "");
Expect(1, 983037, '\P{Is_Present_In=0000006.2}', "");
Expect(0, 983037, '\P{^Is_Present_In=0000006.2}', "");
Error('\p{Is_In=/a/_ 000000006.2}');
Error('\P{Is_In=/a/_ 000000006.2}');
Expect(1, 983040, '\p{Is_In=6.2}', "");
Expect(0, 983040, '\p{^Is_In=6.2}', "");
Expect(0, 983040, '\P{Is_In=6.2}', "");
Expect(1, 983040, '\P{^Is_In=6.2}', "");
Expect(0, 983037, '\p{Is_In=6.2}', "");
Expect(1, 983037, '\p{^Is_In=6.2}', "");
Expect(1, 983037, '\P{Is_In=6.2}', "");
Expect(0, 983037, '\P{^Is_In=6.2}', "");
Error('\p{Present_In= +006.3/a/}');
Error('\P{Present_In= +006.3/a/}');
Expect(1, 983040, '\p{Present_In=000_000_06.3}', "");
Expect(0, 983040, '\p{^Present_In=000_000_06.3}', "");
Expect(0, 983040, '\P{Present_In=000_000_06.3}', "");
Expect(1, 983040, '\P{^Present_In=000_000_06.3}', "");
Expect(0, 983037, '\p{Present_In=000_000_06.3}', "");
Expect(1, 983037, '\p{^Present_In=000_000_06.3}', "");
Expect(1, 983037, '\P{Present_In=000_000_06.3}', "");
Expect(0, 983037, '\P{^Present_In=000_000_06.3}', "");
Error('\p{In=--+00_00_00_006.3/a/}');
Error('\P{In=--+00_00_00_006.3/a/}');
Expect(1, 983040, '\p{In=000006.3}', "");
Expect(0, 983040, '\p{^In=000006.3}', "");
Expect(0, 983040, '\P{In=000006.3}', "");
Expect(1, 983040, '\P{^In=000006.3}', "");
Expect(0, 983037, '\p{In=000006.3}', "");
Expect(1, 983037, '\p{^In=000006.3}', "");
Expect(1, 983037, '\P{In=000006.3}', "");
Expect(0, 983037, '\P{^In=000006.3}', "");
Error('\p{Is_Present_In=-000000006.3/a/}');
Error('\P{Is_Present_In=-000000006.3/a/}');
Expect(1, 983040, '\p{Is_Present_In=000006.3}', "");
Expect(0, 983040, '\p{^Is_Present_In=000006.3}', "");
Expect(0, 983040, '\P{Is_Present_In=000006.3}', "");
Expect(1, 983040, '\P{^Is_Present_In=000006.3}', "");
Expect(0, 983037, '\p{Is_Present_In=000006.3}', "");
Expect(1, 983037, '\p{^Is_Present_In=000006.3}', "");
Expect(1, 983037, '\P{Is_Present_In=000006.3}', "");
Expect(0, 983037, '\P{^Is_Present_In=000006.3}', "");
Error('\p{Is_In=_/a/06.3}');
Error('\P{Is_In=_/a/06.3}');
Expect(1, 983040, '\p{Is_In=+000000006.3}', "");
Expect(0, 983040, '\p{^Is_In=+000000006.3}', "");
Expect(0, 983040, '\P{Is_In=+000000006.3}', "");
Expect(1, 983040, '\P{^Is_In=+000000006.3}', "");
Expect(0, 983037, '\p{Is_In=+000000006.3}', "");
Expect(1, 983037, '\p{^Is_In=+000000006.3}', "");
Expect(1, 983037, '\P{Is_In=+000000006.3}', "");
Expect(0, 983037, '\P{^Is_In=+000000006.3}', "");
Error('\p{Present_In=_:=+0_0_0_0_0_0_0_007.0}');
Error('\P{Present_In=_:=+0_0_0_0_0_0_0_007.0}');
Expect(1, 983040, '\p{Present_In=00007.0}', "");
Expect(0, 983040, '\p{^Present_In=00007.0}', "");
Expect(0, 983040, '\P{Present_In=00007.0}', "");
Expect(1, 983040, '\P{^Present_In=00007.0}', "");
Expect(0, 983037, '\p{Present_In=00007.0}', "");
Expect(1, 983037, '\p{^Present_In=00007.0}', "");
Expect(1, 983037, '\P{Present_In=00007.0}', "");
Expect(0, 983037, '\P{^Present_In=00007.0}', "");
Error('\p{In=/a/000_7.0}');
Error('\P{In=/a/000_7.0}');
Expect(1, 983040, '\p{In=00_00_07.0}', "");
Expect(0, 983040, '\p{^In=00_00_07.0}', "");
Expect(0, 983040, '\P{In=00_00_07.0}', "");
Expect(1, 983040, '\P{^In=00_00_07.0}', "");
Expect(0, 983037, '\p{In=00_00_07.0}', "");
Expect(1, 983037, '\p{^In=00_00_07.0}', "");
Expect(1, 983037, '\P{In=00_00_07.0}', "");
Expect(0, 983037, '\P{^In=00_00_07.0}', "");
Error('\p{Is_Present_In=	:=0_0_0_0_0_07.0}');
Error('\P{Is_Present_In=	:=0_0_0_0_0_07.0}');
Expect(1, 983040, '\p{Is_Present_In=000007.0}', "");
Expect(0, 983040, '\p{^Is_Present_In=000007.0}', "");
Expect(0, 983040, '\P{Is_Present_In=000007.0}', "");
Expect(1, 983040, '\P{^Is_Present_In=000007.0}', "");
Expect(0, 983037, '\p{Is_Present_In=000007.0}', "");
Expect(1, 983037, '\p{^Is_Present_In=000007.0}', "");
Expect(1, 983037, '\P{Is_Present_In=000007.0}', "");
Expect(0, 983037, '\P{^Is_Present_In=000007.0}', "");
Error('\p{Is_In= 	00007.0/a/}');
Error('\P{Is_In= 	00007.0/a/}');
Expect(1, 983040, '\p{Is_In=00_00_7.0}', "");
Expect(0, 983040, '\p{^Is_In=00_00_7.0}', "");
Expect(0, 983040, '\P{Is_In=00_00_7.0}', "");
Expect(1, 983040, '\P{^Is_In=00_00_7.0}', "");
Expect(0, 983037, '\p{Is_In=00_00_7.0}', "");
Expect(1, 983037, '\p{^Is_In=00_00_7.0}', "");
Expect(1, 983037, '\P{Is_In=00_00_7.0}', "");
Expect(0, 983037, '\P{^Is_In=00_00_7.0}', "");
Error('\p{Present_In=	:=Unassigned}');
Error('\P{Present_In=	:=Unassigned}');
Expect(1, 983037, '\p{Present_In=unassigned}', "");
Expect(0, 983037, '\p{^Present_In=unassigned}', "");
Expect(0, 983037, '\P{Present_In=unassigned}', "");
Expect(1, 983037, '\P{^Present_In=unassigned}', "");
Expect(0, 983040, '\p{Present_In=unassigned}', "");
Expect(1, 983040, '\p{^Present_In=unassigned}', "");
Expect(1, 983040, '\P{Present_In=unassigned}', "");
Expect(0, 983040, '\P{^Present_In=unassigned}', "");
Expect(1, 983037, '\p{Present_In=		UNASSIGNED}', "");
Expect(0, 983037, '\p{^Present_In=		UNASSIGNED}', "");
Expect(0, 983037, '\P{Present_In=		UNASSIGNED}', "");
Expect(1, 983037, '\P{^Present_In=		UNASSIGNED}', "");
Expect(0, 983040, '\p{Present_In=		UNASSIGNED}', "");
Expect(1, 983040, '\p{^Present_In=		UNASSIGNED}', "");
Expect(1, 983040, '\P{Present_In=		UNASSIGNED}', "");
Expect(0, 983040, '\P{^Present_In=		UNASSIGNED}', "");
Error('\p{In=/a/__unassigned}');
Error('\P{In=/a/__unassigned}');
Expect(1, 983037, '\p{In=unassigned}', "");
Expect(0, 983037, '\p{^In=unassigned}', "");
Expect(0, 983037, '\P{In=unassigned}', "");
Expect(1, 983037, '\P{^In=unassigned}', "");
Expect(0, 983040, '\p{In=unassigned}', "");
Expect(1, 983040, '\p{^In=unassigned}', "");
Expect(1, 983040, '\P{In=unassigned}', "");
Expect(0, 983040, '\P{^In=unassigned}', "");
Expect(1, 983037, '\p{In=-Unassigned}', "");
Expect(0, 983037, '\p{^In=-Unassigned}', "");
Expect(0, 983037, '\P{In=-Unassigned}', "");
Expect(1, 983037, '\P{^In=-Unassigned}', "");
Expect(0, 983040, '\p{In=-Unassigned}', "");
Expect(1, 983040, '\p{^In=-Unassigned}', "");
Expect(1, 983040, '\P{In=-Unassigned}', "");
Expect(0, 983040, '\P{^In=-Unassigned}', "");
Error('\p{Is_Present_In=-UNASSIGNED:=}');
Error('\P{Is_Present_In=-UNASSIGNED:=}');
Expect(1, 983037, '\p{Is_Present_In=unassigned}', "");
Expect(0, 983037, '\p{^Is_Present_In=unassigned}', "");
Expect(0, 983037, '\P{Is_Present_In=unassigned}', "");
Expect(1, 983037, '\P{^Is_Present_In=unassigned}', "");
Expect(0, 983040, '\p{Is_Present_In=unassigned}', "");
Expect(1, 983040, '\p{^Is_Present_In=unassigned}', "");
Expect(1, 983040, '\P{Is_Present_In=unassigned}', "");
Expect(0, 983040, '\P{^Is_Present_In=unassigned}', "");
Expect(1, 983037, '\p{Is_Present_In=	 unassigned}', "");
Expect(0, 983037, '\p{^Is_Present_In=	 unassigned}', "");
Expect(0, 983037, '\P{Is_Present_In=	 unassigned}', "");
Expect(1, 983037, '\P{^Is_Present_In=	 unassigned}', "");
Expect(0, 983040, '\p{Is_Present_In=	 unassigned}', "");
Expect(1, 983040, '\p{^Is_Present_In=	 unassigned}', "");
Expect(1, 983040, '\P{Is_Present_In=	 unassigned}', "");
Expect(0, 983040, '\P{^Is_Present_In=	 unassigned}', "");
Error('\p{Is_In:-:=UNASSIGNED}');
Error('\P{Is_In:-:=UNASSIGNED}');
Expect(1, 983037, '\p{Is_In=unassigned}', "");
Expect(0, 983037, '\p{^Is_In=unassigned}', "");
Expect(0, 983037, '\P{Is_In=unassigned}', "");
Expect(1, 983037, '\P{^Is_In=unassigned}', "");
Expect(0, 983040, '\p{Is_In=unassigned}', "");
Expect(1, 983040, '\p{^Is_In=unassigned}', "");
Expect(1, 983040, '\P{Is_In=unassigned}', "");
Expect(0, 983040, '\P{^Is_In=unassigned}', "");
Expect(1, 983037, '\p{Is_In=_Unassigned}', "");
Expect(0, 983037, '\p{^Is_In=_Unassigned}', "");
Expect(0, 983037, '\P{Is_In=_Unassigned}', "");
Expect(1, 983037, '\P{^Is_In=_Unassigned}', "");
Expect(0, 983040, '\p{Is_In=_Unassigned}', "");
Expect(1, 983040, '\p{^Is_In=_Unassigned}', "");
Expect(1, 983040, '\P{Is_In=_Unassigned}', "");
Expect(0, 983040, '\P{^Is_In=_Unassigned}', "");
Error('\p{Indic_Matra_Category=Bottom}');
Error('\P{Indic_Matra_Category=Bottom}');
Error('\p{InMC=Bottom}');
Error('\P{InMC=Bottom}');
Error('\p{Is_Indic_Matra_Category=Bottom}');
Error('\P{Is_Indic_Matra_Category=Bottom}');
Error('\p{Is_InMC=Bottom}');
Error('\P{Is_InMC=Bottom}');
Error('\p{Indic_Matra_Category:	Bottom_And_Right}');
Error('\P{Indic_Matra_Category:	Bottom_And_Right}');
Error('\p{InMC:Bottom_And_Right}');
Error('\P{InMC:Bottom_And_Right}');
Error('\p{Is_Indic_Matra_Category:Bottom_And_Right}');
Error('\P{Is_Indic_Matra_Category:Bottom_And_Right}');
Error('\p{Is_InMC=Bottom_And_Right}');
Error('\P{Is_InMC=Bottom_And_Right}');
Error('\p{Indic_Matra_Category:	Left}');
Error('\P{Indic_Matra_Category:	Left}');
Error('\p{InMC=Left}');
Error('\P{InMC=Left}');
Error('\p{Is_Indic_Matra_Category=Left}');
Error('\P{Is_Indic_Matra_Category=Left}');
Error('\p{Is_InMC=Left}');
Error('\P{Is_InMC=Left}');
Error('\p{Indic_Matra_Category: Left_And_Right}');
Error('\P{Indic_Matra_Category: Left_And_Right}');
Error('\p{InMC=Left_And_Right}');
Error('\P{InMC=Left_And_Right}');
Error('\p{Is_Indic_Matra_Category=Left_And_Right}');
Error('\P{Is_Indic_Matra_Category=Left_And_Right}');
Error('\p{Is_InMC=Left_And_Right}');
Error('\P{Is_InMC=Left_And_Right}');
Error('\p{Indic_Matra_Category=NA}');
Error('\P{Indic_Matra_Category=NA}');
Error('\p{InMC=NA}');
Error('\P{InMC=NA}');
Error('\p{Is_Indic_Matra_Category=NA}');
Error('\P{Is_Indic_Matra_Category=NA}');
Error('\p{Is_InMC=NA}');
Error('\P{Is_InMC=NA}');
Error('\p{Indic_Matra_Category=Overstruck}');
Error('\P{Indic_Matra_Category=Overstruck}');
Error('\p{InMC=Overstruck}');
Error('\P{InMC=Overstruck}');
Error('\p{Is_Indic_Matra_Category:	Overstruck}');
Error('\P{Is_Indic_Matra_Category:	Overstruck}');
Error('\p{Is_InMC=Overstruck}');
Error('\P{Is_InMC=Overstruck}');
Error('\p{Indic_Matra_Category=Right}');
Error('\P{Indic_Matra_Category=Right}');
Error('\p{InMC=Right}');
Error('\P{InMC=Right}');
Error('\p{Is_Indic_Matra_Category=Right}');
Error('\P{Is_Indic_Matra_Category=Right}');
Error('\p{Is_InMC=Right}');
Error('\P{Is_InMC=Right}');
Error('\p{Indic_Matra_Category=Top}');
Error('\P{Indic_Matra_Category=Top}');
Error('\p{InMC=Top}');
Error('\P{InMC=Top}');
Error('\p{Is_Indic_Matra_Category=Top}');
Error('\P{Is_Indic_Matra_Category=Top}');
Error('\p{Is_InMC=Top}');
Error('\P{Is_InMC=Top}');
Error('\p{Indic_Matra_Category=Top_And_Bottom}');
Error('\P{Indic_Matra_Category=Top_And_Bottom}');
Error('\p{InMC:   Top_And_Bottom}');
Error('\P{InMC:   Top_And_Bottom}');
Error('\p{Is_Indic_Matra_Category=Top_And_Bottom}');
Error('\P{Is_Indic_Matra_Category=Top_And_Bottom}');
Error('\p{Is_InMC=Top_And_Bottom}');
Error('\P{Is_InMC=Top_And_Bottom}');
Error('\p{Indic_Matra_Category:Top_And_Bottom_And_Right}');
Error('\P{Indic_Matra_Category:Top_And_Bottom_And_Right}');
Error('\p{InMC=Top_And_Bottom_And_Right}');
Error('\P{InMC=Top_And_Bottom_And_Right}');
Error('\p{Is_Indic_Matra_Category: Top_And_Bottom_And_Right}');
Error('\P{Is_Indic_Matra_Category: Top_And_Bottom_And_Right}');
Error('\p{Is_InMC:Top_And_Bottom_And_Right}');
Error('\P{Is_InMC:Top_And_Bottom_And_Right}');
Error('\p{Indic_Matra_Category=Top_And_Left}');
Error('\P{Indic_Matra_Category=Top_And_Left}');
Error('\p{InMC=Top_And_Left}');
Error('\P{InMC=Top_And_Left}');
Error('\p{Is_Indic_Matra_Category=Top_And_Left}');
Error('\P{Is_Indic_Matra_Category=Top_And_Left}');
Error('\p{Is_InMC=Top_And_Left}');
Error('\P{Is_InMC=Top_And_Left}');
Error('\p{Indic_Matra_Category=Top_And_Left_And_Right}');
Error('\P{Indic_Matra_Category=Top_And_Left_And_Right}');
Error('\p{InMC=Top_And_Left_And_Right}');
Error('\P{InMC=Top_And_Left_And_Right}');
Error('\p{Is_Indic_Matra_Category=Top_And_Left_And_Right}');
Error('\P{Is_Indic_Matra_Category=Top_And_Left_And_Right}');
Error('\p{Is_InMC:   Top_And_Left_And_Right}');
Error('\P{Is_InMC:   Top_And_Left_And_Right}');
Error('\p{Indic_Matra_Category=Top_And_Right}');
Error('\P{Indic_Matra_Category=Top_And_Right}');
Error('\p{InMC=Top_And_Right}');
Error('\P{InMC=Top_And_Right}');
Error('\p{Is_Indic_Matra_Category=Top_And_Right}');
Error('\P{Is_Indic_Matra_Category=Top_And_Right}');
Error('\p{Is_InMC=Top_And_Right}');
Error('\P{Is_InMC=Top_And_Right}');
Error('\p{Indic_Matra_Category=Visual_Order_Left}');
Error('\P{Indic_Matra_Category=Visual_Order_Left}');
Error('\p{InMC=Visual_Order_Left}');
Error('\P{InMC=Visual_Order_Left}');
Error('\p{Is_Indic_Matra_Category=Visual_Order_Left}');
Error('\P{Is_Indic_Matra_Category=Visual_Order_Left}');
Error('\p{Is_InMC=Visual_Order_Left}');
Error('\P{Is_InMC=Visual_Order_Left}');
Error('\p{Indic_Syllabic_Category=Avagraha}');
Error('\P{Indic_Syllabic_Category=Avagraha}');
Error('\p{InSC: Avagraha}');
Error('\P{InSC: Avagraha}');
Error('\p{Is_Indic_Syllabic_Category=Avagraha}');
Error('\P{Is_Indic_Syllabic_Category=Avagraha}');
Error('\p{Is_InSC=Avagraha}');
Error('\P{Is_InSC=Avagraha}');
Error('\p{Indic_Syllabic_Category=Bindu}');
Error('\P{Indic_Syllabic_Category=Bindu}');
Error('\p{InSC=Bindu}');
Error('\P{InSC=Bindu}');
Error('\p{Is_Indic_Syllabic_Category:Bindu}');
Error('\P{Is_Indic_Syllabic_Category:Bindu}');
Error('\p{Is_InSC=Bindu}');
Error('\P{Is_InSC=Bindu}');
Error('\p{Indic_Syllabic_Category=Brahmi_Joining_Number}');
Error('\P{Indic_Syllabic_Category=Brahmi_Joining_Number}');
Error('\p{InSC=Brahmi_Joining_Number}');
Error('\P{InSC=Brahmi_Joining_Number}');
Error('\p{Is_Indic_Syllabic_Category=Brahmi_Joining_Number}');
Error('\P{Is_Indic_Syllabic_Category=Brahmi_Joining_Number}');
Error('\p{Is_InSC=Brahmi_Joining_Number}');
Error('\P{Is_InSC=Brahmi_Joining_Number}');
Error('\p{Indic_Syllabic_Category:Cantillation_Mark}');
Error('\P{Indic_Syllabic_Category:Cantillation_Mark}');
Error('\p{InSC=Cantillation_Mark}');
Error('\P{InSC=Cantillation_Mark}');
Error('\p{Is_Indic_Syllabic_Category:   Cantillation_Mark}');
Error('\P{Is_Indic_Syllabic_Category:   Cantillation_Mark}');
Error('\p{Is_InSC=Cantillation_Mark}');
Error('\P{Is_InSC=Cantillation_Mark}');
Error('\p{Indic_Syllabic_Category=Consonant}');
Error('\P{Indic_Syllabic_Category=Consonant}');
Error('\p{InSC=Consonant}');
Error('\P{InSC=Consonant}');
Error('\p{Is_Indic_Syllabic_Category:Consonant}');
Error('\P{Is_Indic_Syllabic_Category:Consonant}');
Error('\p{Is_InSC=Consonant}');
Error('\P{Is_InSC=Consonant}');
Error('\p{Indic_Syllabic_Category:Consonant_Dead}');
Error('\P{Indic_Syllabic_Category:Consonant_Dead}');
Error('\p{InSC:	Consonant_Dead}');
Error('\P{InSC:	Consonant_Dead}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Dead}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Dead}');
Error('\p{Is_InSC=Consonant_Dead}');
Error('\P{Is_InSC=Consonant_Dead}');
Error('\p{Indic_Syllabic_Category=Consonant_Final}');
Error('\P{Indic_Syllabic_Category=Consonant_Final}');
Error('\p{InSC=Consonant_Final}');
Error('\P{InSC=Consonant_Final}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Final}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Final}');
Error('\p{Is_InSC=Consonant_Final}');
Error('\P{Is_InSC=Consonant_Final}');
Error('\p{Indic_Syllabic_Category=Consonant_Head_Letter}');
Error('\P{Indic_Syllabic_Category=Consonant_Head_Letter}');
Error('\p{InSC=Consonant_Head_Letter}');
Error('\P{InSC=Consonant_Head_Letter}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Head_Letter}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Head_Letter}');
Error('\p{Is_InSC=Consonant_Head_Letter}');
Error('\P{Is_InSC=Consonant_Head_Letter}');
Error('\p{Indic_Syllabic_Category=Consonant_Medial}');
Error('\P{Indic_Syllabic_Category=Consonant_Medial}');
Error('\p{InSC=Consonant_Medial}');
Error('\P{InSC=Consonant_Medial}');
Error('\p{Is_Indic_Syllabic_Category:   Consonant_Medial}');
Error('\P{Is_Indic_Syllabic_Category:   Consonant_Medial}');
Error('\p{Is_InSC=Consonant_Medial}');
Error('\P{Is_InSC=Consonant_Medial}');
Error('\p{Indic_Syllabic_Category=Consonant_Placeholder}');
Error('\P{Indic_Syllabic_Category=Consonant_Placeholder}');
Error('\p{InSC=Consonant_Placeholder}');
Error('\P{InSC=Consonant_Placeholder}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Placeholder}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Placeholder}');
Error('\p{Is_InSC=Consonant_Placeholder}');
Error('\P{Is_InSC=Consonant_Placeholder}');
Error('\p{Indic_Syllabic_Category=Consonant_Preceding_Repha}');
Error('\P{Indic_Syllabic_Category=Consonant_Preceding_Repha}');
Error('\p{InSC=Consonant_Preceding_Repha}');
Error('\P{InSC=Consonant_Preceding_Repha}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Preceding_Repha}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Preceding_Repha}');
Error('\p{Is_InSC=Consonant_Preceding_Repha}');
Error('\P{Is_InSC=Consonant_Preceding_Repha}');
Error('\p{Indic_Syllabic_Category=Consonant_Subjoined}');
Error('\P{Indic_Syllabic_Category=Consonant_Subjoined}');
Error('\p{InSC=Consonant_Subjoined}');
Error('\P{InSC=Consonant_Subjoined}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Subjoined}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Subjoined}');
Error('\p{Is_InSC=Consonant_Subjoined}');
Error('\P{Is_InSC=Consonant_Subjoined}');
Error('\p{Indic_Syllabic_Category=Consonant_Succeeding_Repha}');
Error('\P{Indic_Syllabic_Category=Consonant_Succeeding_Repha}');
Error('\p{InSC=Consonant_Succeeding_Repha}');
Error('\P{InSC=Consonant_Succeeding_Repha}');
Error('\p{Is_Indic_Syllabic_Category=Consonant_Succeeding_Repha}');
Error('\P{Is_Indic_Syllabic_Category=Consonant_Succeeding_Repha}');
Error('\p{Is_InSC=Consonant_Succeeding_Repha}');
Error('\P{Is_InSC=Consonant_Succeeding_Repha}');
Error('\p{Indic_Syllabic_Category=Gemination_Mark}');
Error('\P{Indic_Syllabic_Category=Gemination_Mark}');
Error('\p{InSC=Gemination_Mark}');
Error('\P{InSC=Gemination_Mark}');
Error('\p{Is_Indic_Syllabic_Category=Gemination_Mark}');
Error('\P{Is_Indic_Syllabic_Category=Gemination_Mark}');
Error('\p{Is_InSC=Gemination_Mark}');
Error('\P{Is_InSC=Gemination_Mark}');
Error('\p{Indic_Syllabic_Category=Invisible_Stacker}');
Error('\P{Indic_Syllabic_Category=Invisible_Stacker}');
Error('\p{InSC=Invisible_Stacker}');
Error('\P{InSC=Invisible_Stacker}');
Error('\p{Is_Indic_Syllabic_Category=Invisible_Stacker}');
Error('\P{Is_Indic_Syllabic_Category=Invisible_Stacker}');
Error('\p{Is_InSC=Invisible_Stacker}');
Error('\P{Is_InSC=Invisible_Stacker}');
Error('\p{Indic_Syllabic_Category=Joiner}');
Error('\P{Indic_Syllabic_Category=Joiner}');
Error('\p{InSC=Joiner}');
Error('\P{InSC=Joiner}');
Error('\p{Is_Indic_Syllabic_Category=Joiner}');
Error('\P{Is_Indic_Syllabic_Category=Joiner}');
Error('\p{Is_InSC=Joiner}');
Error('\P{Is_InSC=Joiner}');
Error('\p{Indic_Syllabic_Category: Modifying_Letter}');
Error('\P{Indic_Syllabic_Category: Modifying_Letter}');
Error('\p{InSC=Modifying_Letter}');
Error('\P{InSC=Modifying_Letter}');
Error('\p{Is_Indic_Syllabic_Category:   Modifying_Letter}');
Error('\P{Is_Indic_Syllabic_Category:   Modifying_Letter}');
Error('\p{Is_InSC=Modifying_Letter}');
Error('\P{Is_InSC=Modifying_Letter}');
Error('\p{Indic_Syllabic_Category=Non_Joiner}');
Error('\P{Indic_Syllabic_Category=Non_Joiner}');
Error('\p{InSC=Non_Joiner}');
Error('\P{InSC=Non_Joiner}');
Error('\p{Is_Indic_Syllabic_Category:Non_Joiner}');
Error('\P{Is_Indic_Syllabic_Category:Non_Joiner}');
Error('\p{Is_InSC=Non_Joiner}');
Error('\P{Is_InSC=Non_Joiner}');
Error('\p{Indic_Syllabic_Category=Nukta}');
Error('\P{Indic_Syllabic_Category=Nukta}');
Error('\p{InSC=Nukta}');
Error('\P{InSC=Nukta}');
Error('\p{Is_Indic_Syllabic_Category:	Nukta}');
Error('\P{Is_Indic_Syllabic_Category:	Nukta}');
Error('\p{Is_InSC=Nukta}');
Error('\P{Is_InSC=Nukta}');
Error('\p{Indic_Syllabic_Category:   Number}');
Error('\P{Indic_Syllabic_Category:   Number}');
Error('\p{InSC=Number}');
Error('\P{InSC=Number}');
Error('\p{Is_Indic_Syllabic_Category=Number}');
Error('\P{Is_Indic_Syllabic_Category=Number}');
Error('\p{Is_InSC=Number}');
Error('\P{Is_InSC=Number}');
Error('\p{Indic_Syllabic_Category:   Number_Joiner}');
Error('\P{Indic_Syllabic_Category:   Number_Joiner}');
Error('\p{InSC=Number_Joiner}');
Error('\P{InSC=Number_Joiner}');
Error('\p{Is_Indic_Syllabic_Category=Number_Joiner}');
Error('\P{Is_Indic_Syllabic_Category=Number_Joiner}');
Error('\p{Is_InSC=Number_Joiner}');
Error('\P{Is_InSC=Number_Joiner}');
Error('\p{Indic_Syllabic_Category=Other}');
Error('\P{Indic_Syllabic_Category=Other}');
Error('\p{InSC=Other}');
Error('\P{InSC=Other}');
Error('\p{Is_Indic_Syllabic_Category=Other}');
Error('\P{Is_Indic_Syllabic_Category=Other}');
Error('\p{Is_InSC=Other}');
Error('\P{Is_InSC=Other}');
Error('\p{Indic_Syllabic_Category=Pure_Killer}');
Error('\P{Indic_Syllabic_Category=Pure_Killer}');
Error('\p{InSC=Pure_Killer}');
Error('\P{InSC=Pure_Killer}');
Error('\p{Is_Indic_Syllabic_Category=Pure_Killer}');
Error('\P{Is_Indic_Syllabic_Category=Pure_Killer}');
Error('\p{Is_InSC=Pure_Killer}');
Error('\P{Is_InSC=Pure_Killer}');
Error('\p{Indic_Syllabic_Category=Register_Shifter}');
Error('\P{Indic_Syllabic_Category=Register_Shifter}');
Error('\p{InSC=Register_Shifter}');
Error('\P{InSC=Register_Shifter}');
Error('\p{Is_Indic_Syllabic_Category=Register_Shifter}');
Error('\P{Is_Indic_Syllabic_Category=Register_Shifter}');
Error('\p{Is_InSC=Register_Shifter}');
Error('\P{Is_InSC=Register_Shifter}');
Error('\p{Indic_Syllabic_Category=Tone_Letter}');
Error('\P{Indic_Syllabic_Category=Tone_Letter}');
Error('\p{InSC=Tone_Letter}');
Error('\P{InSC=Tone_Letter}');
Error('\p{Is_Indic_Syllabic_Category=Tone_Letter}');
Error('\P{Is_Indic_Syllabic_Category=Tone_Letter}');
Error('\p{Is_InSC=Tone_Letter}');
Error('\P{Is_InSC=Tone_Letter}');
Error('\p{Indic_Syllabic_Category=Tone_Mark}');
Error('\P{Indic_Syllabic_Category=Tone_Mark}');
Error('\p{InSC=Tone_Mark}');
Error('\P{InSC=Tone_Mark}');
Error('\p{Is_Indic_Syllabic_Category=Tone_Mark}');
Error('\P{Is_Indic_Syllabic_Category=Tone_Mark}');
Error('\p{Is_InSC=Tone_Mark}');
Error('\P{Is_InSC=Tone_Mark}');
Error('\p{Indic_Syllabic_Category:Virama}');
Error('\P{Indic_Syllabic_Category:Virama}');
Error('\p{InSC=Virama}');
Error('\P{InSC=Virama}');
Error('\p{Is_Indic_Syllabic_Category=Virama}');
Error('\P{Is_Indic_Syllabic_Category=Virama}');
Error('\p{Is_InSC=Virama}');
Error('\P{Is_InSC=Virama}');
Error('\p{Indic_Syllabic_Category=Visarga}');
Error('\P{Indic_Syllabic_Category=Visarga}');
Error('\p{InSC=Visarga}');
Error('\P{InSC=Visarga}');
Error('\p{Is_Indic_Syllabic_Category=Visarga}');
Error('\P{Is_Indic_Syllabic_Category=Visarga}');
Error('\p{Is_InSC=Visarga}');
Error('\P{Is_InSC=Visarga}');
Error('\p{Indic_Syllabic_Category=Vowel}');
Error('\P{Indic_Syllabic_Category=Vowel}');
Error('\p{InSC=Vowel}');
Error('\P{InSC=Vowel}');
Error('\p{Is_Indic_Syllabic_Category:   Vowel}');
Error('\P{Is_Indic_Syllabic_Category:   Vowel}');
Error('\p{Is_InSC=Vowel}');
Error('\P{Is_InSC=Vowel}');
Error('\p{Indic_Syllabic_Category=Vowel_Dependent}');
Error('\P{Indic_Syllabic_Category=Vowel_Dependent}');
Error('\p{InSC=Vowel_Dependent}');
Error('\P{InSC=Vowel_Dependent}');
Error('\p{Is_Indic_Syllabic_Category=Vowel_Dependent}');
Error('\P{Is_Indic_Syllabic_Category=Vowel_Dependent}');
Error('\p{Is_InSC=Vowel_Dependent}');
Error('\P{Is_InSC=Vowel_Dependent}');
Error('\p{Indic_Syllabic_Category=Vowel_Independent}');
Error('\P{Indic_Syllabic_Category=Vowel_Independent}');
Error('\p{InSC=Vowel_Independent}');
Error('\P{InSC=Vowel_Independent}');
Error('\p{Is_Indic_Syllabic_Category=Vowel_Independent}');
Error('\P{Is_Indic_Syllabic_Category=Vowel_Independent}');
Error('\p{Is_InSC=Vowel_Independent}');
Error('\P{Is_InSC=Vowel_Independent}');
Error('\p{Jamo_Short_Name=A}');
Error('\P{Jamo_Short_Name=A}');
Error('\p{JSN=A}');
Error('\P{JSN=A}');
Error('\p{Is_Jamo_Short_Name=A}');
Error('\P{Is_Jamo_Short_Name=A}');
Error('\p{Is_JSN=A}');
Error('\P{Is_JSN=A}');
Error('\p{Jamo_Short_Name=AE}');
Error('\P{Jamo_Short_Name=AE}');
Error('\p{JSN=AE}');
Error('\P{JSN=AE}');
Error('\p{Is_Jamo_Short_Name: AE}');
Error('\P{Is_Jamo_Short_Name: AE}');
Error('\p{Is_JSN=AE}');
Error('\P{Is_JSN=AE}');
Error('\p{Jamo_Short_Name=B}');
Error('\P{Jamo_Short_Name=B}');
Error('\p{JSN=B}');
Error('\P{JSN=B}');
Error('\p{Is_Jamo_Short_Name: B}');
Error('\P{Is_Jamo_Short_Name: B}');
Error('\p{Is_JSN:B}');
Error('\P{Is_JSN:B}');
Error('\p{Jamo_Short_Name=BB}');
Error('\P{Jamo_Short_Name=BB}');
Error('\p{JSN=BB}');
Error('\P{JSN=BB}');
Error('\p{Is_Jamo_Short_Name=BB}');
Error('\P{Is_Jamo_Short_Name=BB}');
Error('\p{Is_JSN=BB}');
Error('\P{Is_JSN=BB}');
Error('\p{Jamo_Short_Name=BS}');
Error('\P{Jamo_Short_Name=BS}');
Error('\p{JSN=BS}');
Error('\P{JSN=BS}');
Error('\p{Is_Jamo_Short_Name=BS}');
Error('\P{Is_Jamo_Short_Name=BS}');
Error('\p{Is_JSN=BS}');
Error('\P{Is_JSN=BS}');
Error('\p{Jamo_Short_Name=C}');
Error('\P{Jamo_Short_Name=C}');
Error('\p{JSN:   C}');
Error('\P{JSN:   C}');
Error('\p{Is_Jamo_Short_Name=C}');
Error('\P{Is_Jamo_Short_Name=C}');
Error('\p{Is_JSN=C}');
Error('\P{Is_JSN=C}');
Error('\p{Jamo_Short_Name=D}');
Error('\P{Jamo_Short_Name=D}');
Error('\p{JSN=D}');
Error('\P{JSN=D}');
Error('\p{Is_Jamo_Short_Name=D}');
Error('\P{Is_Jamo_Short_Name=D}');
Error('\p{Is_JSN=D}');
Error('\P{Is_JSN=D}');
Error('\p{Jamo_Short_Name=DD}');
Error('\P{Jamo_Short_Name=DD}');
Error('\p{JSN=DD}');
Error('\P{JSN=DD}');
Error('\p{Is_Jamo_Short_Name=DD}');
Error('\P{Is_Jamo_Short_Name=DD}');
Error('\p{Is_JSN=DD}');
Error('\P{Is_JSN=DD}');
Error('\p{Jamo_Short_Name=E}');
Error('\P{Jamo_Short_Name=E}');
Error('\p{JSN=E}');
Error('\P{JSN=E}');
Error('\p{Is_Jamo_Short_Name=E}');
Error('\P{Is_Jamo_Short_Name=E}');
Error('\p{Is_JSN=E}');
Error('\P{Is_JSN=E}');
Error('\p{Jamo_Short_Name=EO}');
Error('\P{Jamo_Short_Name=EO}');
Error('\p{JSN=EO}');
Error('\P{JSN=EO}');
Error('\p{Is_Jamo_Short_Name=EO}');
Error('\P{Is_Jamo_Short_Name=EO}');
Error('\p{Is_JSN=EO}');
Error('\P{Is_JSN=EO}');
Error('\p{Jamo_Short_Name=EU}');
Error('\P{Jamo_Short_Name=EU}');
Error('\p{JSN=EU}');
Error('\P{JSN=EU}');
Error('\p{Is_Jamo_Short_Name=EU}');
Error('\P{Is_Jamo_Short_Name=EU}');
Error('\p{Is_JSN=EU}');
Error('\P{Is_JSN=EU}');
Error('\p{Jamo_Short_Name=G}');
Error('\P{Jamo_Short_Name=G}');
Error('\p{JSN=G}');
Error('\P{JSN=G}');
Error('\p{Is_Jamo_Short_Name=G}');
Error('\P{Is_Jamo_Short_Name=G}');
Error('\p{Is_JSN=G}');
Error('\P{Is_JSN=G}');
Error('\p{Jamo_Short_Name:	GG}');
Error('\P{Jamo_Short_Name:	GG}');
Error('\p{JSN=GG}');
Error('\P{JSN=GG}');
Error('\p{Is_Jamo_Short_Name=GG}');
Error('\P{Is_Jamo_Short_Name=GG}');
Error('\p{Is_JSN=GG}');
Error('\P{Is_JSN=GG}');
Error('\p{Jamo_Short_Name=GS}');
Error('\P{Jamo_Short_Name=GS}');
Error('\p{JSN=GS}');
Error('\P{JSN=GS}');
Error('\p{Is_Jamo_Short_Name: GS}');
Error('\P{Is_Jamo_Short_Name: GS}');
Error('\p{Is_JSN=GS}');
Error('\P{Is_JSN=GS}');
Error('\p{Jamo_Short_Name=H}');
Error('\P{Jamo_Short_Name=H}');
Error('\p{JSN=H}');
Error('\P{JSN=H}');
Error('\p{Is_Jamo_Short_Name=H}');
Error('\P{Is_Jamo_Short_Name=H}');
Error('\p{Is_JSN=H}');
Error('\P{Is_JSN=H}');
Error('\p{Jamo_Short_Name=I}');
Error('\P{Jamo_Short_Name=I}');
Error('\p{JSN:I}');
Error('\P{JSN:I}');
Error('\p{Is_Jamo_Short_Name=I}');
Error('\P{Is_Jamo_Short_Name=I}');
Error('\p{Is_JSN=I}');
Error('\P{Is_JSN=I}');
Error('\p{Jamo_Short_Name=J}');
Error('\P{Jamo_Short_Name=J}');
Error('\p{JSN=J}');
Error('\P{JSN=J}');
Error('\p{Is_Jamo_Short_Name=J}');
Error('\P{Is_Jamo_Short_Name=J}');
Error('\p{Is_JSN: J}');
Error('\P{Is_JSN: J}');
Error('\p{Jamo_Short_Name=JJ}');
Error('\P{Jamo_Short_Name=JJ}');
Error('\p{JSN=JJ}');
Error('\P{JSN=JJ}');
Error('\p{Is_Jamo_Short_Name=JJ}');
Error('\P{Is_Jamo_Short_Name=JJ}');
Error('\p{Is_JSN=JJ}');
Error('\P{Is_JSN=JJ}');
Error('\p{Jamo_Short_Name=K}');
Error('\P{Jamo_Short_Name=K}');
Error('\p{JSN=K}');
Error('\P{JSN=K}');
Error('\p{Is_Jamo_Short_Name=K}');
Error('\P{Is_Jamo_Short_Name=K}');
Error('\p{Is_JSN=K}');
Error('\P{Is_JSN=K}');
Error('\p{Jamo_Short_Name: L}');
Error('\P{Jamo_Short_Name: L}');
Error('\p{JSN=L}');
Error('\P{JSN=L}');
Error('\p{Is_Jamo_Short_Name:   L}');
Error('\P{Is_Jamo_Short_Name:   L}');
Error('\p{Is_JSN=L}');
Error('\P{Is_JSN=L}');
Error('\p{Jamo_Short_Name=LB}');
Error('\P{Jamo_Short_Name=LB}');
Error('\p{JSN=LB}');
Error('\P{JSN=LB}');
Error('\p{Is_Jamo_Short_Name=LB}');
Error('\P{Is_Jamo_Short_Name=LB}');
Error('\p{Is_JSN:   LB}');
Error('\P{Is_JSN:   LB}');
Error('\p{Jamo_Short_Name=LG}');
Error('\P{Jamo_Short_Name=LG}');
Error('\p{JSN:   LG}');
Error('\P{JSN:   LG}');
Error('\p{Is_Jamo_Short_Name=LG}');
Error('\P{Is_Jamo_Short_Name=LG}');
Error('\p{Is_JSN=LG}');
Error('\P{Is_JSN=LG}');
Error('\p{Jamo_Short_Name=LH}');
Error('\P{Jamo_Short_Name=LH}');
Error('\p{JSN=LH}');
Error('\P{JSN=LH}');
Error('\p{Is_Jamo_Short_Name=LH}');
Error('\P{Is_Jamo_Short_Name=LH}');
Error('\p{Is_JSN=LH}');
Error('\P{Is_JSN=LH}');
Error('\p{Jamo_Short_Name:LM}');
Error('\P{Jamo_Short_Name:LM}');
Error('\p{JSN=LM}');
Error('\P{JSN=LM}');
Error('\p{Is_Jamo_Short_Name=LM}');
Error('\P{Is_Jamo_Short_Name=LM}');
Error('\p{Is_JSN=LM}');
Error('\P{Is_JSN=LM}');
Error('\p{Jamo_Short_Name=LP}');
Error('\P{Jamo_Short_Name=LP}');
Error('\p{JSN=LP}');
Error('\P{JSN=LP}');
Error('\p{Is_Jamo_Short_Name:	LP}');
Error('\P{Is_Jamo_Short_Name:	LP}');
Error('\p{Is_JSN=LP}');
Error('\P{Is_JSN=LP}');
Error('\p{Jamo_Short_Name=LS}');
Error('\P{Jamo_Short_Name=LS}');
Error('\p{JSN: LS}');
Error('\P{JSN: LS}');
Error('\p{Is_Jamo_Short_Name=LS}');
Error('\P{Is_Jamo_Short_Name=LS}');
Error('\p{Is_JSN=LS}');
Error('\P{Is_JSN=LS}');
Error('\p{Jamo_Short_Name=LT}');
Error('\P{Jamo_Short_Name=LT}');
Error('\p{JSN=LT}');
Error('\P{JSN=LT}');
Error('\p{Is_Jamo_Short_Name=LT}');
Error('\P{Is_Jamo_Short_Name=LT}');
Error('\p{Is_JSN=LT}');
Error('\P{Is_JSN=LT}');
Error('\p{Jamo_Short_Name=M}');
Error('\P{Jamo_Short_Name=M}');
Error('\p{JSN=M}');
Error('\P{JSN=M}');
Error('\p{Is_Jamo_Short_Name: M}');
Error('\P{Is_Jamo_Short_Name: M}');
Error('\p{Is_JSN=M}');
Error('\P{Is_JSN=M}');
Error('\p{Jamo_Short_Name=N}');
Error('\P{Jamo_Short_Name=N}');
Error('\p{JSN=N}');
Error('\P{JSN=N}');
Error('\p{Is_Jamo_Short_Name=N}');
Error('\P{Is_Jamo_Short_Name=N}');
Error('\p{Is_JSN=N}');
Error('\P{Is_JSN=N}');
Error('\p{Jamo_Short_Name=NG}');
Error('\P{Jamo_Short_Name=NG}');
Error('\p{JSN=NG}');
Error('\P{JSN=NG}');
Error('\p{Is_Jamo_Short_Name=NG}');
Error('\P{Is_Jamo_Short_Name=NG}');
Error('\p{Is_JSN=NG}');
Error('\P{Is_JSN=NG}');
Error('\p{Jamo_Short_Name=NH}');
Error('\P{Jamo_Short_Name=NH}');
Error('\p{JSN=NH}');
Error('\P{JSN=NH}');
Error('\p{Is_Jamo_Short_Name:   NH}');
Error('\P{Is_Jamo_Short_Name:   NH}');
Error('\p{Is_JSN=NH}');
Error('\P{Is_JSN=NH}');
Error('\p{Jamo_Short_Name=NJ}');
Error('\P{Jamo_Short_Name=NJ}');
Error('\p{JSN=NJ}');
Error('\P{JSN=NJ}');
Error('\p{Is_Jamo_Short_Name=NJ}');
Error('\P{Is_Jamo_Short_Name=NJ}');
Error('\p{Is_JSN=NJ}');
Error('\P{Is_JSN=NJ}');
Error('\p{Jamo_Short_Name=O}');
Error('\P{Jamo_Short_Name=O}');
Error('\p{JSN=O}');
Error('\P{JSN=O}');
Error('\p{Is_Jamo_Short_Name=O}');
Error('\P{Is_Jamo_Short_Name=O}');
Error('\p{Is_JSN=O}');
Error('\P{Is_JSN=O}');
Error('\p{Jamo_Short_Name=OE}');
Error('\P{Jamo_Short_Name=OE}');
Error('\p{JSN:   OE}');
Error('\P{JSN:   OE}');
Error('\p{Is_Jamo_Short_Name=OE}');
Error('\P{Is_Jamo_Short_Name=OE}');
Error('\p{Is_JSN=OE}');
Error('\P{Is_JSN=OE}');
Error('\p{Jamo_Short_Name=P}');
Error('\P{Jamo_Short_Name=P}');
Error('\p{JSN=P}');
Error('\P{JSN=P}');
Error('\p{Is_Jamo_Short_Name=P}');
Error('\P{Is_Jamo_Short_Name=P}');
Error('\p{Is_JSN: P}');
Error('\P{Is_JSN: P}');
Error('\p{Jamo_Short_Name=R}');
Error('\P{Jamo_Short_Name=R}');
Error('\p{JSN=R}');
Error('\P{JSN=R}');
Error('\p{Is_Jamo_Short_Name=R}');
Error('\P{Is_Jamo_Short_Name=R}');
Error('\p{Is_JSN=R}');
Error('\P{Is_JSN=R}');
Error('\p{Jamo_Short_Name=S}');
Error('\P{Jamo_Short_Name=S}');
Error('\p{JSN=S}');
Error('\P{JSN=S}');
Error('\p{Is_Jamo_Short_Name=S}');
Error('\P{Is_Jamo_Short_Name=S}');
Error('\p{Is_JSN=S}');
Error('\P{Is_JSN=S}');
Error('\p{Jamo_Short_Name=SS}');
Error('\P{Jamo_Short_Name=SS}');
Error('\p{JSN=SS}');
Error('\P{JSN=SS}');
Error('\p{Is_Jamo_Short_Name=SS}');
Error('\P{Is_Jamo_Short_Name=SS}');
Error('\p{Is_JSN:SS}');
Error('\P{Is_JSN:SS}');
Error('\p{Jamo_Short_Name=T}');
Error('\P{Jamo_Short_Name=T}');
Error('\p{JSN=T}');
Error('\P{JSN=T}');
Error('\p{Is_Jamo_Short_Name=T}');
Error('\P{Is_Jamo_Short_Name=T}');
Error('\p{Is_JSN=T}');
Error('\P{Is_JSN=T}');
Error('\p{Jamo_Short_Name=U}');
Error('\P{Jamo_Short_Name=U}');
Error('\p{JSN=U}');
Error('\P{JSN=U}');
Error('\p{Is_Jamo_Short_Name=U}');
Error('\P{Is_Jamo_Short_Name=U}');
Error('\p{Is_JSN=U}');
Error('\P{Is_JSN=U}');
Error('\p{Jamo_Short_Name=WA}');
Error('\P{Jamo_Short_Name=WA}');
Error('\p{JSN=WA}');
Error('\P{JSN=WA}');
Error('\p{Is_Jamo_Short_Name=WA}');
Error('\P{Is_Jamo_Short_Name=WA}');
Error('\p{Is_JSN=WA}');
Error('\P{Is_JSN=WA}');
Error('\p{Jamo_Short_Name=WAE}');
Error('\P{Jamo_Short_Name=WAE}');
Error('\p{JSN=WAE}');
Error('\P{JSN=WAE}');
Error('\p{Is_Jamo_Short_Name=WAE}');
Error('\P{Is_Jamo_Short_Name=WAE}');
Error('\p{Is_JSN=WAE}');
Error('\P{Is_JSN=WAE}');
Error('\p{Jamo_Short_Name=WE}');
Error('\P{Jamo_Short_Name=WE}');
Error('\p{JSN=WE}');
Error('\P{JSN=WE}');
Error('\p{Is_Jamo_Short_Name=WE}');
Error('\P{Is_Jamo_Short_Name=WE}');
Error('\p{Is_JSN=WE}');
Error('\P{Is_JSN=WE}');
Error('\p{Jamo_Short_Name: WEO}');
Error('\P{Jamo_Short_Name: WEO}');
Error('\p{JSN=WEO}');
Error('\P{JSN=WEO}');
Error('\p{Is_Jamo_Short_Name:WEO}');
Error('\P{Is_Jamo_Short_Name:WEO}');
Error('\p{Is_JSN:   WEO}');
Error('\P{Is_JSN:   WEO}');
Error('\p{Jamo_Short_Name=WI}');
Error('\P{Jamo_Short_Name=WI}');
Error('\p{JSN=WI}');
Error('\P{JSN=WI}');
Error('\p{Is_Jamo_Short_Name=WI}');
Error('\P{Is_Jamo_Short_Name=WI}');
Error('\p{Is_JSN=WI}');
Error('\P{Is_JSN=WI}');
Error('\p{Jamo_Short_Name: YA}');
Error('\P{Jamo_Short_Name: YA}');
Error('\p{JSN=YA}');
Error('\P{JSN=YA}');
Error('\p{Is_Jamo_Short_Name=YA}');
Error('\P{Is_Jamo_Short_Name=YA}');
Error('\p{Is_JSN=YA}');
Error('\P{Is_JSN=YA}');
Error('\p{Jamo_Short_Name=YAE}');
Error('\P{Jamo_Short_Name=YAE}');
Error('\p{JSN=YAE}');
Error('\P{JSN=YAE}');
Error('\p{Is_Jamo_Short_Name=YAE}');
Error('\P{Is_Jamo_Short_Name=YAE}');
Error('\p{Is_JSN=YAE}');
Error('\P{Is_JSN=YAE}');
Error('\p{Jamo_Short_Name=YE}');
Error('\P{Jamo_Short_Name=YE}');
Error('\p{JSN=YE}');
Error('\P{JSN=YE}');
Error('\p{Is_Jamo_Short_Name=YE}');
Error('\P{Is_Jamo_Short_Name=YE}');
Error('\p{Is_JSN=YE}');
Error('\P{Is_JSN=YE}');
Error('\p{Jamo_Short_Name=YEO}');
Error('\P{Jamo_Short_Name=YEO}');
Error('\p{JSN=YEO}');
Error('\P{JSN=YEO}');
Error('\p{Is_Jamo_Short_Name=YEO}');
Error('\P{Is_Jamo_Short_Name=YEO}');
Error('\p{Is_JSN=YEO}');
Error('\P{Is_JSN=YEO}');
Error('\p{Jamo_Short_Name=YI}');
Error('\P{Jamo_Short_Name=YI}');
Error('\p{JSN=YI}');
Error('\P{JSN=YI}');
Error('\p{Is_Jamo_Short_Name=YI}');
Error('\P{Is_Jamo_Short_Name=YI}');
Error('\p{Is_JSN=YI}');
Error('\P{Is_JSN=YI}');
Error('\p{Jamo_Short_Name=YO}');
Error('\P{Jamo_Short_Name=YO}');
Error('\p{JSN=YO}');
Error('\P{JSN=YO}');
Error('\p{Is_Jamo_Short_Name:	YO}');
Error('\P{Is_Jamo_Short_Name:	YO}');
Error('\p{Is_JSN=YO}');
Error('\P{Is_JSN=YO}');
Error('\p{Jamo_Short_Name=YU}');
Error('\P{Jamo_Short_Name=YU}');
Error('\p{JSN=YU}');
Error('\P{JSN=YU}');
Error('\p{Is_Jamo_Short_Name=YU}');
Error('\P{Is_Jamo_Short_Name=YU}');
Error('\p{Is_JSN=YU}');
Error('\P{Is_JSN=YU}');
Error('\p{Join_Control=/a/- NO}');
Error('\P{Join_Control=/a/- NO}');
Expect(1, 8206, '\p{Join_Control:no}', "");
Expect(0, 8206, '\p{^Join_Control:no}', "");
Expect(0, 8206, '\P{Join_Control:no}', "");
Expect(1, 8206, '\P{^Join_Control:no}', "");
Expect(0, 8205, '\p{Join_Control:no}', "");
Expect(1, 8205, '\p{^Join_Control:no}', "");
Expect(1, 8205, '\P{Join_Control:no}', "");
Expect(0, 8205, '\P{^Join_Control:no}', "");
Expect(1, 8206, '\p{Join_Control:--NO}', "");
Expect(0, 8206, '\p{^Join_Control:--NO}', "");
Expect(0, 8206, '\P{Join_Control:--NO}', "");
Expect(1, 8206, '\P{^Join_Control:--NO}', "");
Expect(0, 8205, '\p{Join_Control:--NO}', "");
Expect(1, 8205, '\p{^Join_Control:--NO}', "");
Expect(1, 8205, '\P{Join_Control:--NO}', "");
Expect(0, 8205, '\P{^Join_Control:--NO}', "");
Error('\p{Join_C=_/a/N}');
Error('\P{Join_C=_/a/N}');
Expect(1, 8206, '\p{Join_C=n}', "");
Expect(0, 8206, '\p{^Join_C=n}', "");
Expect(0, 8206, '\P{Join_C=n}', "");
Expect(1, 8206, '\P{^Join_C=n}', "");
Expect(0, 8205, '\p{Join_C=n}', "");
Expect(1, 8205, '\p{^Join_C=n}', "");
Expect(1, 8205, '\P{Join_C=n}', "");
Expect(0, 8205, '\P{^Join_C=n}', "");
Expect(1, 8206, '\p{Join_C=_n}', "");
Expect(0, 8206, '\p{^Join_C=_n}', "");
Expect(0, 8206, '\P{Join_C=_n}', "");
Expect(1, 8206, '\P{^Join_C=_n}', "");
Expect(0, 8205, '\p{Join_C=_n}', "");
Expect(1, 8205, '\p{^Join_C=_n}', "");
Expect(1, 8205, '\P{Join_C=_n}', "");
Expect(0, 8205, '\P{^Join_C=_n}', "");
Error('\p{Is_Join_Control=:= _F}');
Error('\P{Is_Join_Control=:= _F}');
Expect(1, 8206, '\p{Is_Join_Control=f}', "");
Expect(0, 8206, '\p{^Is_Join_Control=f}', "");
Expect(0, 8206, '\P{Is_Join_Control=f}', "");
Expect(1, 8206, '\P{^Is_Join_Control=f}', "");
Expect(0, 8205, '\p{Is_Join_Control=f}', "");
Expect(1, 8205, '\p{^Is_Join_Control=f}', "");
Expect(1, 8205, '\P{Is_Join_Control=f}', "");
Expect(0, 8205, '\P{^Is_Join_Control=f}', "");
Expect(1, 8206, '\p{Is_Join_Control=--F}', "");
Expect(0, 8206, '\p{^Is_Join_Control=--F}', "");
Expect(0, 8206, '\P{Is_Join_Control=--F}', "");
Expect(1, 8206, '\P{^Is_Join_Control=--F}', "");
Expect(0, 8205, '\p{Is_Join_Control=--F}', "");
Expect(1, 8205, '\p{^Is_Join_Control=--F}', "");
Expect(1, 8205, '\P{Is_Join_Control=--F}', "");
Expect(0, 8205, '\P{^Is_Join_Control=--F}', "");
Error('\p{Is_Join_C=:=  FALSE}');
Error('\P{Is_Join_C=:=  FALSE}');
Expect(1, 8206, '\p{Is_Join_C=false}', "");
Expect(0, 8206, '\p{^Is_Join_C=false}', "");
Expect(0, 8206, '\P{Is_Join_C=false}', "");
Expect(1, 8206, '\P{^Is_Join_C=false}', "");
Expect(0, 8205, '\p{Is_Join_C=false}', "");
Expect(1, 8205, '\p{^Is_Join_C=false}', "");
Expect(1, 8205, '\P{Is_Join_C=false}', "");
Expect(0, 8205, '\P{^Is_Join_C=false}', "");
Expect(1, 8206, '\p{Is_Join_C= -FALSE}', "");
Expect(0, 8206, '\p{^Is_Join_C= -FALSE}', "");
Expect(0, 8206, '\P{Is_Join_C= -FALSE}', "");
Expect(1, 8206, '\P{^Is_Join_C= -FALSE}', "");
Expect(0, 8205, '\p{Is_Join_C= -FALSE}', "");
Expect(1, 8205, '\p{^Is_Join_C= -FALSE}', "");
Expect(1, 8205, '\P{Is_Join_C= -FALSE}', "");
Expect(0, 8205, '\P{^Is_Join_C= -FALSE}', "");
Error('\p{Join_Control=-/a/yes}');
Error('\P{Join_Control=-/a/yes}');
Expect(1, 8205, '\p{Join_Control=yes}', "");
Expect(0, 8205, '\p{^Join_Control=yes}', "");
Expect(0, 8205, '\P{Join_Control=yes}', "");
Expect(1, 8205, '\P{^Join_Control=yes}', "");
Expect(0, 8206, '\p{Join_Control=yes}', "");
Expect(1, 8206, '\p{^Join_Control=yes}', "");
Expect(1, 8206, '\P{Join_Control=yes}', "");
Expect(0, 8206, '\P{^Join_Control=yes}', "");
Expect(1, 8205, '\p{Join_Control=-	Yes}', "");
Expect(0, 8205, '\p{^Join_Control=-	Yes}', "");
Expect(0, 8205, '\P{Join_Control=-	Yes}', "");
Expect(1, 8205, '\P{^Join_Control=-	Yes}', "");
Expect(0, 8206, '\p{Join_Control=-	Yes}', "");
Expect(1, 8206, '\p{^Join_Control=-	Yes}', "");
Expect(1, 8206, '\P{Join_Control=-	Yes}', "");
Expect(0, 8206, '\P{^Join_Control=-	Yes}', "");
Error('\p{Join_C=-Y:=}');
Error('\P{Join_C=-Y:=}');
Expect(1, 8205, '\p{Join_C:	y}', "");
Expect(0, 8205, '\p{^Join_C:	y}', "");
Expect(0, 8205, '\P{Join_C:	y}', "");
Expect(1, 8205, '\P{^Join_C:	y}', "");
Expect(0, 8206, '\p{Join_C:	y}', "");
Expect(1, 8206, '\p{^Join_C:	y}', "");
Expect(1, 8206, '\P{Join_C:	y}', "");
Expect(0, 8206, '\P{^Join_C:	y}', "");
Expect(1, 8205, '\p{Join_C=  y}', "");
Expect(0, 8205, '\p{^Join_C=  y}', "");
Expect(0, 8205, '\P{Join_C=  y}', "");
Expect(1, 8205, '\P{^Join_C=  y}', "");
Expect(0, 8206, '\p{Join_C=  y}', "");
Expect(1, 8206, '\p{^Join_C=  y}', "");
Expect(1, 8206, '\P{Join_C=  y}', "");
Expect(0, 8206, '\P{^Join_C=  y}', "");
Error('\p{Is_Join_Control=/a/ t}');
Error('\P{Is_Join_Control=/a/ t}');
Expect(1, 8205, '\p{Is_Join_Control=t}', "");
Expect(0, 8205, '\p{^Is_Join_Control=t}', "");
Expect(0, 8205, '\P{Is_Join_Control=t}', "");
Expect(1, 8205, '\P{^Is_Join_Control=t}', "");
Expect(0, 8206, '\p{Is_Join_Control=t}', "");
Expect(1, 8206, '\p{^Is_Join_Control=t}', "");
Expect(1, 8206, '\P{Is_Join_Control=t}', "");
Expect(0, 8206, '\P{^Is_Join_Control=t}', "");
Expect(1, 8205, '\p{Is_Join_Control= 	T}', "");
Expect(0, 8205, '\p{^Is_Join_Control= 	T}', "");
Expect(0, 8205, '\P{Is_Join_Control= 	T}', "");
Expect(1, 8205, '\P{^Is_Join_Control= 	T}', "");
Expect(0, 8206, '\p{Is_Join_Control= 	T}', "");
Expect(1, 8206, '\p{^Is_Join_Control= 	T}', "");
Expect(1, 8206, '\P{Is_Join_Control= 	T}', "");
Expect(0, 8206, '\P{^Is_Join_Control= 	T}', "");
Error('\p{Is_Join_C=/a/__TRUE}');
Error('\P{Is_Join_C=/a/__TRUE}');
Expect(1, 8205, '\p{Is_Join_C=true}', "");
Expect(0, 8205, '\p{^Is_Join_C=true}', "");
Expect(0, 8205, '\P{Is_Join_C=true}', "");
Expect(1, 8205, '\P{^Is_Join_C=true}', "");
Expect(0, 8206, '\p{Is_Join_C=true}', "");
Expect(1, 8206, '\p{^Is_Join_C=true}', "");
Expect(1, 8206, '\P{Is_Join_C=true}', "");
Expect(0, 8206, '\P{^Is_Join_C=true}', "");
Expect(1, 8205, '\p{Is_Join_C=-True}', "");
Expect(0, 8205, '\p{^Is_Join_C=-True}', "");
Expect(0, 8205, '\P{Is_Join_C=-True}', "");
Expect(1, 8205, '\P{^Is_Join_C=-True}', "");
Expect(0, 8206, '\p{Is_Join_C=-True}', "");
Expect(1, 8206, '\p{^Is_Join_C=-True}', "");
Expect(1, 8206, '\P{Is_Join_C=-True}', "");
Expect(0, 8206, '\P{^Is_Join_C=-True}', "");
Error('\p{Logical_Order_Exception= /a/no}');
Error('\P{Logical_Order_Exception= /a/no}');
Expect(1, 43709, '\p{Logical_Order_Exception=no}', "");
Expect(0, 43709, '\p{^Logical_Order_Exception=no}', "");
Expect(0, 43709, '\P{Logical_Order_Exception=no}', "");
Expect(1, 43709, '\P{^Logical_Order_Exception=no}', "");
Expect(0, 43708, '\p{Logical_Order_Exception=no}', "");
Expect(1, 43708, '\p{^Logical_Order_Exception=no}', "");
Expect(1, 43708, '\P{Logical_Order_Exception=no}', "");
Expect(0, 43708, '\P{^Logical_Order_Exception=no}', "");
Expect(1, 43709, '\p{Logical_Order_Exception=_-No}', "");
Expect(0, 43709, '\p{^Logical_Order_Exception=_-No}', "");
Expect(0, 43709, '\P{Logical_Order_Exception=_-No}', "");
Expect(1, 43709, '\P{^Logical_Order_Exception=_-No}', "");
Expect(0, 43708, '\p{Logical_Order_Exception=_-No}', "");
Expect(1, 43708, '\p{^Logical_Order_Exception=_-No}', "");
Expect(1, 43708, '\P{Logical_Order_Exception=_-No}', "");
Expect(0, 43708, '\P{^Logical_Order_Exception=_-No}', "");
Error('\p{LOE=__N/a/}');
Error('\P{LOE=__N/a/}');
Expect(1, 43709, '\p{LOE=n}', "");
Expect(0, 43709, '\p{^LOE=n}', "");
Expect(0, 43709, '\P{LOE=n}', "");
Expect(1, 43709, '\P{^LOE=n}', "");
Expect(0, 43708, '\p{LOE=n}', "");
Expect(1, 43708, '\p{^LOE=n}', "");
Expect(1, 43708, '\P{LOE=n}', "");
Expect(0, 43708, '\P{^LOE=n}', "");
Expect(1, 43709, '\p{LOE=_ N}', "");
Expect(0, 43709, '\p{^LOE=_ N}', "");
Expect(0, 43709, '\P{LOE=_ N}', "");
Expect(1, 43709, '\P{^LOE=_ N}', "");
Expect(0, 43708, '\p{LOE=_ N}', "");
Expect(1, 43708, '\p{^LOE=_ N}', "");
Expect(1, 43708, '\P{LOE=_ N}', "");
Expect(0, 43708, '\P{^LOE=_ N}', "");
Error('\p{Is_Logical_Order_Exception=:=-_F}');
Error('\P{Is_Logical_Order_Exception=:=-_F}');
Expect(1, 43709, '\p{Is_Logical_Order_Exception:f}', "");
Expect(0, 43709, '\p{^Is_Logical_Order_Exception:f}', "");
Expect(0, 43709, '\P{Is_Logical_Order_Exception:f}', "");
Expect(1, 43709, '\P{^Is_Logical_Order_Exception:f}', "");
Expect(0, 43708, '\p{Is_Logical_Order_Exception:f}', "");
Expect(1, 43708, '\p{^Is_Logical_Order_Exception:f}', "");
Expect(1, 43708, '\P{Is_Logical_Order_Exception:f}', "");
Expect(0, 43708, '\P{^Is_Logical_Order_Exception:f}', "");
Expect(1, 43709, '\p{Is_Logical_Order_Exception=		f}', "");
Expect(0, 43709, '\p{^Is_Logical_Order_Exception=		f}', "");
Expect(0, 43709, '\P{Is_Logical_Order_Exception=		f}', "");
Expect(1, 43709, '\P{^Is_Logical_Order_Exception=		f}', "");
Expect(0, 43708, '\p{Is_Logical_Order_Exception=		f}', "");
Expect(1, 43708, '\p{^Is_Logical_Order_Exception=		f}', "");
Expect(1, 43708, '\P{Is_Logical_Order_Exception=		f}', "");
Expect(0, 43708, '\P{^Is_Logical_Order_Exception=		f}', "");
Error('\p{Is_LOE= false/a/}');
Error('\P{Is_LOE= false/a/}');
Expect(1, 43709, '\p{Is_LOE: false}', "");
Expect(0, 43709, '\p{^Is_LOE: false}', "");
Expect(0, 43709, '\P{Is_LOE: false}', "");
Expect(1, 43709, '\P{^Is_LOE: false}', "");
Expect(0, 43708, '\p{Is_LOE: false}', "");
Expect(1, 43708, '\p{^Is_LOE: false}', "");
Expect(1, 43708, '\P{Is_LOE: false}', "");
Expect(0, 43708, '\P{^Is_LOE: false}', "");
Expect(1, 43709, '\p{Is_LOE=	 False}', "");
Expect(0, 43709, '\p{^Is_LOE=	 False}', "");
Expect(0, 43709, '\P{Is_LOE=	 False}', "");
Expect(1, 43709, '\P{^Is_LOE=	 False}', "");
Expect(0, 43708, '\p{Is_LOE=	 False}', "");
Expect(1, 43708, '\p{^Is_LOE=	 False}', "");
Expect(1, 43708, '\P{Is_LOE=	 False}', "");
Expect(0, 43708, '\P{^Is_LOE=	 False}', "");
Error('\p{Logical_Order_Exception=	-yes/a/}');
Error('\P{Logical_Order_Exception=	-yes/a/}');
Expect(1, 43708, '\p{Logical_Order_Exception=yes}', "");
Expect(0, 43708, '\p{^Logical_Order_Exception=yes}', "");
Expect(0, 43708, '\P{Logical_Order_Exception=yes}', "");
Expect(1, 43708, '\P{^Logical_Order_Exception=yes}', "");
Expect(0, 43709, '\p{Logical_Order_Exception=yes}', "");
Expect(1, 43709, '\p{^Logical_Order_Exception=yes}', "");
Expect(1, 43709, '\P{Logical_Order_Exception=yes}', "");
Expect(0, 43709, '\P{^Logical_Order_Exception=yes}', "");
Expect(1, 43708, '\p{Logical_Order_Exception=	-Yes}', "");
Expect(0, 43708, '\p{^Logical_Order_Exception=	-Yes}', "");
Expect(0, 43708, '\P{Logical_Order_Exception=	-Yes}', "");
Expect(1, 43708, '\P{^Logical_Order_Exception=	-Yes}', "");
Expect(0, 43709, '\p{Logical_Order_Exception=	-Yes}', "");
Expect(1, 43709, '\p{^Logical_Order_Exception=	-Yes}', "");
Expect(1, 43709, '\P{Logical_Order_Exception=	-Yes}', "");
Expect(0, 43709, '\P{^Logical_Order_Exception=	-Yes}', "");
Error('\p{LOE=	/a/Y}');
Error('\P{LOE=	/a/Y}');
Expect(1, 43708, '\p{LOE=y}', "");
Expect(0, 43708, '\p{^LOE=y}', "");
Expect(0, 43708, '\P{LOE=y}', "");
Expect(1, 43708, '\P{^LOE=y}', "");
Expect(0, 43709, '\p{LOE=y}', "");
Expect(1, 43709, '\p{^LOE=y}', "");
Expect(1, 43709, '\P{LOE=y}', "");
Expect(0, 43709, '\P{^LOE=y}', "");
Expect(1, 43708, '\p{LOE=		Y}', "");
Expect(0, 43708, '\p{^LOE=		Y}', "");
Expect(0, 43708, '\P{LOE=		Y}', "");
Expect(1, 43708, '\P{^LOE=		Y}', "");
Expect(0, 43709, '\p{LOE=		Y}', "");
Expect(1, 43709, '\p{^LOE=		Y}', "");
Expect(1, 43709, '\P{LOE=		Y}', "");
Expect(0, 43709, '\P{^LOE=		Y}', "");
Error('\p{Is_Logical_Order_Exception=-/a/T}');
Error('\P{Is_Logical_Order_Exception=-/a/T}');
Expect(1, 43708, '\p{Is_Logical_Order_Exception=t}', "");
Expect(0, 43708, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(0, 43708, '\P{Is_Logical_Order_Exception=t}', "");
Expect(1, 43708, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(0, 43709, '\p{Is_Logical_Order_Exception=t}', "");
Expect(1, 43709, '\p{^Is_Logical_Order_Exception=t}', "");
Expect(1, 43709, '\P{Is_Logical_Order_Exception=t}', "");
Expect(0, 43709, '\P{^Is_Logical_Order_Exception=t}', "");
Expect(1, 43708, '\p{Is_Logical_Order_Exception=_T}', "");
Expect(0, 43708, '\p{^Is_Logical_Order_Exception=_T}', "");
Expect(0, 43708, '\P{Is_Logical_Order_Exception=_T}', "");
Expect(1, 43708, '\P{^Is_Logical_Order_Exception=_T}', "");
Expect(0, 43709, '\p{Is_Logical_Order_Exception=_T}', "");
Expect(1, 43709, '\p{^Is_Logical_Order_Exception=_T}', "");
Expect(1, 43709, '\P{Is_Logical_Order_Exception=_T}', "");
Expect(0, 43709, '\P{^Is_Logical_Order_Exception=_T}', "");
Error('\p{Is_LOE=_/a/True}');
Error('\P{Is_LOE=_/a/True}');
Expect(1, 43708, '\p{Is_LOE=true}', "");
Expect(0, 43708, '\p{^Is_LOE=true}', "");
Expect(0, 43708, '\P{Is_LOE=true}', "");
Expect(1, 43708, '\P{^Is_LOE=true}', "");
Expect(0, 43709, '\p{Is_LOE=true}', "");
Expect(1, 43709, '\p{^Is_LOE=true}', "");
Expect(1, 43709, '\P{Is_LOE=true}', "");
Expect(0, 43709, '\P{^Is_LOE=true}', "");
Expect(1, 43708, '\p{Is_LOE=		TRUE}', "");
Expect(0, 43708, '\p{^Is_LOE=		TRUE}', "");
Expect(0, 43708, '\P{Is_LOE=		TRUE}', "");
Expect(1, 43708, '\P{^Is_LOE=		TRUE}', "");
Expect(0, 43709, '\p{Is_LOE=		TRUE}', "");
Expect(1, 43709, '\p{^Is_LOE=		TRUE}', "");
Expect(1, 43709, '\P{Is_LOE=		TRUE}', "");
Expect(0, 43709, '\P{^Is_LOE=		TRUE}', "");
Error('\p{Lowercase=--NO:=}');
Error('\P{Lowercase=--NO:=}');
Expect(1, 120780, '\p{Lowercase=no}', "");
Expect(0, 120780, '\p{^Lowercase=no}', "");
Expect(0, 120780, '\P{Lowercase=no}', "");
Expect(1, 120780, '\P{^Lowercase=no}', "");
Expect(0, 120779, '\p{Lowercase=no}', "");
Expect(1, 120779, '\p{^Lowercase=no}', "");
Expect(1, 120779, '\P{Lowercase=no}', "");
Expect(0, 120779, '\P{^Lowercase=no}', "");
Expect(1, 120780, '\p{Lowercase:		no}', "");
Expect(0, 120780, '\p{^Lowercase:		no}', "");
Expect(0, 120780, '\P{Lowercase:		no}', "");
Expect(1, 120780, '\P{^Lowercase:		no}', "");
Expect(0, 120779, '\p{Lowercase:		no}', "");
Expect(1, 120779, '\p{^Lowercase:		no}', "");
Expect(1, 120779, '\P{Lowercase:		no}', "");
Expect(0, 120779, '\P{^Lowercase:		no}', "");
Error('\p{Lower=		N:=}');
Error('\P{Lower=		N:=}');
Expect(1, 120780, '\p{Lower=n}', "");
Expect(0, 120780, '\p{^Lower=n}', "");
Expect(0, 120780, '\P{Lower=n}', "");
Expect(1, 120780, '\P{^Lower=n}', "");
Expect(0, 120779, '\p{Lower=n}', "");
Expect(1, 120779, '\p{^Lower=n}', "");
Expect(1, 120779, '\P{Lower=n}', "");
Expect(0, 120779, '\P{^Lower=n}', "");
Expect(1, 120780, '\p{Lower= N}', "");
Expect(0, 120780, '\p{^Lower= N}', "");
Expect(0, 120780, '\P{Lower= N}', "");
Expect(1, 120780, '\P{^Lower= N}', "");
Expect(0, 120779, '\p{Lower= N}', "");
Expect(1, 120779, '\p{^Lower= N}', "");
Expect(1, 120779, '\P{Lower= N}', "");
Expect(0, 120779, '\P{^Lower= N}', "");
Error('\p{Is_Lowercase=_/a/F}');
Error('\P{Is_Lowercase=_/a/F}');
Expect(1, 120780, '\p{Is_Lowercase=f}', "");
Expect(0, 120780, '\p{^Is_Lowercase=f}', "");
Expect(0, 120780, '\P{Is_Lowercase=f}', "");
Expect(1, 120780, '\P{^Is_Lowercase=f}', "");
Expect(0, 120779, '\p{Is_Lowercase=f}', "");
Expect(1, 120779, '\p{^Is_Lowercase=f}', "");
Expect(1, 120779, '\P{Is_Lowercase=f}', "");
Expect(0, 120779, '\P{^Is_Lowercase=f}', "");
Expect(1, 120780, '\p{Is_Lowercase= -F}', "");
Expect(0, 120780, '\p{^Is_Lowercase= -F}', "");
Expect(0, 120780, '\P{Is_Lowercase= -F}', "");
Expect(1, 120780, '\P{^Is_Lowercase= -F}', "");
Expect(0, 120779, '\p{Is_Lowercase= -F}', "");
Expect(1, 120779, '\p{^Is_Lowercase= -F}', "");
Expect(1, 120779, '\P{Is_Lowercase= -F}', "");
Expect(0, 120779, '\P{^Is_Lowercase= -F}', "");
Error('\p{Is_Lower=__False/a/}');
Error('\P{Is_Lower=__False/a/}');
Expect(1, 120780, '\p{Is_Lower=false}', "");
Expect(0, 120780, '\p{^Is_Lower=false}', "");
Expect(0, 120780, '\P{Is_Lower=false}', "");
Expect(1, 120780, '\P{^Is_Lower=false}', "");
Expect(0, 120779, '\p{Is_Lower=false}', "");
Expect(1, 120779, '\p{^Is_Lower=false}', "");
Expect(1, 120779, '\P{Is_Lower=false}', "");
Expect(0, 120779, '\P{^Is_Lower=false}', "");
Expect(1, 120780, '\p{Is_Lower= false}', "");
Expect(0, 120780, '\p{^Is_Lower= false}', "");
Expect(0, 120780, '\P{Is_Lower= false}', "");
Expect(1, 120780, '\P{^Is_Lower= false}', "");
Expect(0, 120779, '\p{Is_Lower= false}', "");
Expect(1, 120779, '\p{^Is_Lower= false}', "");
Expect(1, 120779, '\P{Is_Lower= false}', "");
Expect(0, 120779, '\P{^Is_Lower= false}', "");
Error('\p{Lowercase=-	Yes/a/}');
Error('\P{Lowercase=-	Yes/a/}');
Expect(1, 120779, '\p{Lowercase:yes}', "");
Expect(0, 120779, '\p{^Lowercase:yes}', "");
Expect(0, 120779, '\P{Lowercase:yes}', "");
Expect(1, 120779, '\P{^Lowercase:yes}', "");
Expect(0, 120780, '\p{Lowercase:yes}', "");
Expect(1, 120780, '\p{^Lowercase:yes}', "");
Expect(1, 120780, '\P{Lowercase:yes}', "");
Expect(0, 120780, '\P{^Lowercase:yes}', "");
Expect(1, 120779, '\p{Lowercase=  Yes}', "");
Expect(0, 120779, '\p{^Lowercase=  Yes}', "");
Expect(0, 120779, '\P{Lowercase=  Yes}', "");
Expect(1, 120779, '\P{^Lowercase=  Yes}', "");
Expect(0, 120780, '\p{Lowercase=  Yes}', "");
Expect(1, 120780, '\p{^Lowercase=  Yes}', "");
Expect(1, 120780, '\P{Lowercase=  Yes}', "");
Expect(0, 120780, '\P{^Lowercase=  Yes}', "");
Error('\p{Lower=-:=Y}');
Error('\P{Lower=-:=Y}');
Expect(1, 120779, '\p{Lower=y}', "");
Expect(0, 120779, '\p{^Lower=y}', "");
Expect(0, 120779, '\P{Lower=y}', "");
Expect(1, 120779, '\P{^Lower=y}', "");
Expect(0, 120780, '\p{Lower=y}', "");
Expect(1, 120780, '\p{^Lower=y}', "");
Expect(1, 120780, '\P{Lower=y}', "");
Expect(0, 120780, '\P{^Lower=y}', "");
Expect(1, 120779, '\p{Lower= Y}', "");
Expect(0, 120779, '\p{^Lower= Y}', "");
Expect(0, 120779, '\P{Lower= Y}', "");
Expect(1, 120779, '\P{^Lower= Y}', "");
Expect(0, 120780, '\p{Lower= Y}', "");
Expect(1, 120780, '\p{^Lower= Y}', "");
Expect(1, 120780, '\P{Lower= Y}', "");
Expect(0, 120780, '\P{^Lower= Y}', "");
Error('\p{Is_Lowercase=:=__T}');
Error('\P{Is_Lowercase=:=__T}');
Expect(1, 120779, '\p{Is_Lowercase: t}', "");
Expect(0, 120779, '\p{^Is_Lowercase: t}', "");
Expect(0, 120779, '\P{Is_Lowercase: t}', "");
Expect(1, 120779, '\P{^Is_Lowercase: t}', "");
Expect(0, 120780, '\p{Is_Lowercase: t}', "");
Expect(1, 120780, '\p{^Is_Lowercase: t}', "");
Expect(1, 120780, '\P{Is_Lowercase: t}', "");
Expect(0, 120780, '\P{^Is_Lowercase: t}', "");
Expect(1, 120779, '\p{Is_Lowercase=_ T}', "");
Expect(0, 120779, '\p{^Is_Lowercase=_ T}', "");
Expect(0, 120779, '\P{Is_Lowercase=_ T}', "");
Expect(1, 120779, '\P{^Is_Lowercase=_ T}', "");
Expect(0, 120780, '\p{Is_Lowercase=_ T}', "");
Expect(1, 120780, '\p{^Is_Lowercase=_ T}', "");
Expect(1, 120780, '\P{Is_Lowercase=_ T}', "");
Expect(0, 120780, '\P{^Is_Lowercase=_ T}', "");
Error('\p{Is_Lower= /a/true}');
Error('\P{Is_Lower= /a/true}');
Expect(1, 120779, '\p{Is_Lower=true}', "");
Expect(0, 120779, '\p{^Is_Lower=true}', "");
Expect(0, 120779, '\P{Is_Lower=true}', "");
Expect(1, 120779, '\P{^Is_Lower=true}', "");
Expect(0, 120780, '\p{Is_Lower=true}', "");
Expect(1, 120780, '\p{^Is_Lower=true}', "");
Expect(1, 120780, '\P{Is_Lower=true}', "");
Expect(0, 120780, '\P{^Is_Lower=true}', "");
Expect(1, 120779, '\p{Is_Lower= True}', "");
Expect(0, 120779, '\p{^Is_Lower= True}', "");
Expect(0, 120779, '\P{Is_Lower= True}', "");
Expect(1, 120779, '\P{^Is_Lower= True}', "");
Expect(0, 120780, '\p{Is_Lower= True}', "");
Expect(1, 120780, '\p{^Is_Lower= True}', "");
Expect(1, 120780, '\P{Is_Lower= True}', "");
Expect(0, 120780, '\P{^Is_Lower= True}', "");
Error('\p{Math=	 no:=}');
Error('\P{Math=	 no:=}');
Expect(1, 126706, '\p{Math=no}', "");
Expect(0, 126706, '\p{^Math=no}', "");
Expect(0, 126706, '\P{Math=no}', "");
Expect(1, 126706, '\P{^Math=no}', "");
Expect(0, 126705, '\p{Math=no}', "");
Expect(1, 126705, '\p{^Math=no}', "");
Expect(1, 126705, '\P{Math=no}', "");
Expect(0, 126705, '\P{^Math=no}', "");
Expect(1, 126706, '\p{Math=-NO}', "");
Expect(0, 126706, '\p{^Math=-NO}', "");
Expect(0, 126706, '\P{Math=-NO}', "");
Expect(1, 126706, '\P{^Math=-NO}', "");
Expect(0, 126705, '\p{Math=-NO}', "");
Expect(1, 126705, '\p{^Math=-NO}', "");
Expect(1, 126705, '\P{Math=-NO}', "");
Expect(0, 126705, '\P{^Math=-NO}', "");
Error('\p{Is_Math=  N/a/}');
Error('\P{Is_Math=  N/a/}');
Expect(1, 126706, '\p{Is_Math=n}', "");
Expect(0, 126706, '\p{^Is_Math=n}', "");
Expect(0, 126706, '\P{Is_Math=n}', "");
Expect(1, 126706, '\P{^Is_Math=n}', "");
Expect(0, 126705, '\p{Is_Math=n}', "");
Expect(1, 126705, '\p{^Is_Math=n}', "");
Expect(1, 126705, '\P{Is_Math=n}', "");
Expect(0, 126705, '\P{^Is_Math=n}', "");
Expect(1, 126706, '\p{Is_Math=__N}', "");
Expect(0, 126706, '\p{^Is_Math=__N}', "");
Expect(0, 126706, '\P{Is_Math=__N}', "");
Expect(1, 126706, '\P{^Is_Math=__N}', "");
Expect(0, 126705, '\p{Is_Math=__N}', "");
Expect(1, 126705, '\p{^Is_Math=__N}', "");
Expect(1, 126705, '\P{Is_Math=__N}', "");
Expect(0, 126705, '\P{^Is_Math=__N}', "");
Error('\p{Math=/a/ 	F}');
Error('\P{Math=/a/ 	F}');
Expect(1, 126706, '\p{Math=f}', "");
Expect(0, 126706, '\p{^Math=f}', "");
Expect(0, 126706, '\P{Math=f}', "");
Expect(1, 126706, '\P{^Math=f}', "");
Expect(0, 126705, '\p{Math=f}', "");
Expect(1, 126705, '\p{^Math=f}', "");
Expect(1, 126705, '\P{Math=f}', "");
Expect(0, 126705, '\P{^Math=f}', "");
Expect(1, 126706, '\p{Math=	_f}', "");
Expect(0, 126706, '\p{^Math=	_f}', "");
Expect(0, 126706, '\P{Math=	_f}', "");
Expect(1, 126706, '\P{^Math=	_f}', "");
Expect(0, 126705, '\p{Math=	_f}', "");
Expect(1, 126705, '\p{^Math=	_f}', "");
Expect(1, 126705, '\P{Math=	_f}', "");
Expect(0, 126705, '\P{^Math=	_f}', "");
Error('\p{Is_Math=-/a/FALSE}');
Error('\P{Is_Math=-/a/FALSE}');
Expect(1, 126706, '\p{Is_Math=false}', "");
Expect(0, 126706, '\p{^Is_Math=false}', "");
Expect(0, 126706, '\P{Is_Math=false}', "");
Expect(1, 126706, '\P{^Is_Math=false}', "");
Expect(0, 126705, '\p{Is_Math=false}', "");
Expect(1, 126705, '\p{^Is_Math=false}', "");
Expect(1, 126705, '\P{Is_Math=false}', "");
Expect(0, 126705, '\P{^Is_Math=false}', "");
Expect(1, 126706, '\p{Is_Math:__FALSE}', "");
Expect(0, 126706, '\p{^Is_Math:__FALSE}', "");
Expect(0, 126706, '\P{Is_Math:__FALSE}', "");
Expect(1, 126706, '\P{^Is_Math:__FALSE}', "");
Expect(0, 126705, '\p{Is_Math:__FALSE}', "");
Expect(1, 126705, '\p{^Is_Math:__FALSE}', "");
Expect(1, 126705, '\P{Is_Math:__FALSE}', "");
Expect(0, 126705, '\P{^Is_Math:__FALSE}', "");
Error('\p{Math:  _Yes/a/}');
Error('\P{Math:  _Yes/a/}');
Expect(1, 126705, '\p{Math=yes}', "");
Expect(0, 126705, '\p{^Math=yes}', "");
Expect(0, 126705, '\P{Math=yes}', "");
Expect(1, 126705, '\P{^Math=yes}', "");
Expect(0, 126706, '\p{Math=yes}', "");
Expect(1, 126706, '\p{^Math=yes}', "");
Expect(1, 126706, '\P{Math=yes}', "");
Expect(0, 126706, '\P{^Math=yes}', "");
Expect(1, 126705, '\p{Math=_	Yes}', "");
Expect(0, 126705, '\p{^Math=_	Yes}', "");
Expect(0, 126705, '\P{Math=_	Yes}', "");
Expect(1, 126705, '\P{^Math=_	Yes}', "");
Expect(0, 126706, '\p{Math=_	Yes}', "");
Expect(1, 126706, '\p{^Math=_	Yes}', "");
Expect(1, 126706, '\P{Math=_	Yes}', "");
Expect(0, 126706, '\P{^Math=_	Yes}', "");
Error('\p{Is_Math=:=y}');
Error('\P{Is_Math=:=y}');
Expect(1, 126705, '\p{Is_Math=y}', "");
Expect(0, 126705, '\p{^Is_Math=y}', "");
Expect(0, 126705, '\P{Is_Math=y}', "");
Expect(1, 126705, '\P{^Is_Math=y}', "");
Expect(0, 126706, '\p{Is_Math=y}', "");
Expect(1, 126706, '\p{^Is_Math=y}', "");
Expect(1, 126706, '\P{Is_Math=y}', "");
Expect(0, 126706, '\P{^Is_Math=y}', "");
Expect(1, 126705, '\p{Is_Math=	Y}', "");
Expect(0, 126705, '\p{^Is_Math=	Y}', "");
Expect(0, 126705, '\P{Is_Math=	Y}', "");
Expect(1, 126705, '\P{^Is_Math=	Y}', "");
Expect(0, 126706, '\p{Is_Math=	Y}', "");
Expect(1, 126706, '\p{^Is_Math=	Y}', "");
Expect(1, 126706, '\P{Is_Math=	Y}', "");
Expect(0, 126706, '\P{^Is_Math=	Y}', "");
Error('\p{Math= _T:=}');
Error('\P{Math= _T:=}');
Expect(1, 126705, '\p{Math=t}', "");
Expect(0, 126705, '\p{^Math=t}', "");
Expect(0, 126705, '\P{Math=t}', "");
Expect(1, 126705, '\P{^Math=t}', "");
Expect(0, 126706, '\p{Math=t}', "");
Expect(1, 126706, '\p{^Math=t}', "");
Expect(1, 126706, '\P{Math=t}', "");
Expect(0, 126706, '\P{^Math=t}', "");
Expect(1, 126705, '\p{Math=_	T}', "");
Expect(0, 126705, '\p{^Math=_	T}', "");
Expect(0, 126705, '\P{Math=_	T}', "");
Expect(1, 126705, '\P{^Math=_	T}', "");
Expect(0, 126706, '\p{Math=_	T}', "");
Expect(1, 126706, '\p{^Math=_	T}', "");
Expect(1, 126706, '\P{Math=_	T}', "");
Expect(0, 126706, '\P{^Math=_	T}', "");
Error('\p{Is_Math=	:=True}');
Error('\P{Is_Math=	:=True}');
Expect(1, 126705, '\p{Is_Math=true}', "");
Expect(0, 126705, '\p{^Is_Math=true}', "");
Expect(0, 126705, '\P{Is_Math=true}', "");
Expect(1, 126705, '\P{^Is_Math=true}', "");
Expect(0, 126706, '\p{Is_Math=true}', "");
Expect(1, 126706, '\p{^Is_Math=true}', "");
Expect(1, 126706, '\P{Is_Math=true}', "");
Expect(0, 126706, '\P{^Is_Math=true}', "");
Expect(1, 126705, '\p{Is_Math=-TRUE}', "");
Expect(0, 126705, '\p{^Is_Math=-TRUE}', "");
Expect(0, 126705, '\P{Is_Math=-TRUE}', "");
Expect(1, 126705, '\P{^Is_Math=-TRUE}', "");
Expect(0, 126706, '\p{Is_Math=-TRUE}', "");
Expect(1, 126706, '\p{^Is_Math=-TRUE}', "");
Expect(1, 126706, '\P{Is_Math=-TRUE}', "");
Expect(0, 126706, '\P{^Is_Math=-TRUE}', "");
Error('\p{Noncharacter_Code_Point=:=-	NO}');
Error('\P{Noncharacter_Code_Point=:=-	NO}');
Expect(1, 1114109, '\p{Noncharacter_Code_Point=no}', "");
Expect(0, 1114109, '\p{^Noncharacter_Code_Point=no}', "");
Expect(0, 1114109, '\P{Noncharacter_Code_Point=no}', "");
Expect(1, 1114109, '\P{^Noncharacter_Code_Point=no}', "");
Expect(0, 1114111, '\p{Noncharacter_Code_Point=no}', "");
Expect(1, 1114111, '\p{^Noncharacter_Code_Point=no}', "");
Expect(1, 1114111, '\P{Noncharacter_Code_Point=no}', "");
Expect(0, 1114111, '\P{^Noncharacter_Code_Point=no}', "");
Expect(1, 1114109, '\p{Noncharacter_Code_Point= _No}', "");
Expect(0, 1114109, '\p{^Noncharacter_Code_Point= _No}', "");
Expect(0, 1114109, '\P{Noncharacter_Code_Point= _No}', "");
Expect(1, 1114109, '\P{^Noncharacter_Code_Point= _No}', "");
Expect(0, 1114111, '\p{Noncharacter_Code_Point= _No}', "");
Expect(1, 1114111, '\p{^Noncharacter_Code_Point= _No}', "");
Expect(1, 1114111, '\P{Noncharacter_Code_Point= _No}', "");
Expect(0, 1114111, '\P{^Noncharacter_Code_Point= _No}', "");
Error('\p{NChar=-_N:=}');
Error('\P{NChar=-_N:=}');
Expect(1, 1114109, '\p{NChar:	n}', "");
Expect(0, 1114109, '\p{^NChar:	n}', "");
Expect(0, 1114109, '\P{NChar:	n}', "");
Expect(1, 1114109, '\P{^NChar:	n}', "");
Expect(0, 1114111, '\p{NChar:	n}', "");
Expect(1, 1114111, '\p{^NChar:	n}', "");
Expect(1, 1114111, '\P{NChar:	n}', "");
Expect(0, 1114111, '\P{^NChar:	n}', "");
Expect(1, 1114109, '\p{NChar=_	N}', "");
Expect(0, 1114109, '\p{^NChar=_	N}', "");
Expect(0, 1114109, '\P{NChar=_	N}', "");
Expect(1, 1114109, '\P{^NChar=_	N}', "");
Expect(0, 1114111, '\p{NChar=_	N}', "");
Expect(1, 1114111, '\p{^NChar=_	N}', "");
Expect(1, 1114111, '\P{NChar=_	N}', "");
Expect(0, 1114111, '\P{^NChar=_	N}', "");
Error('\p{Is_Noncharacter_Code_Point=:= -F}');
Error('\P{Is_Noncharacter_Code_Point=:= -F}');
Expect(1, 1114109, '\p{Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114109, '\p{^Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114109, '\P{Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114109, '\P{^Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114111, '\p{Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114111, '\p{^Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114111, '\P{Is_Noncharacter_Code_Point=f}', "");
Expect(0, 1114111, '\P{^Is_Noncharacter_Code_Point=f}', "");
Expect(1, 1114109, '\p{Is_Noncharacter_Code_Point=-_f}', "");
Expect(0, 1114109, '\p{^Is_Noncharacter_Code_Point=-_f}', "");
Expect(0, 1114109, '\P{Is_Noncharacter_Code_Point=-_f}', "");
Expect(1, 1114109, '\P{^Is_Noncharacter_Code_Point=-_f}', "");
Expect(0, 1114111, '\p{Is_Noncharacter_Code_Point=-_f}', "");
Expect(1, 1114111, '\p{^Is_Noncharacter_Code_Point=-_f}', "");
Expect(1, 1114111, '\P{Is_Noncharacter_Code_Point=-_f}', "");
Expect(0, 1114111, '\P{^Is_Noncharacter_Code_Point=-_f}', "");
Error('\p{Is_NChar=	:=False}');
Error('\P{Is_NChar=	:=False}');
Expect(1, 1114109, '\p{Is_NChar=false}', "");
Expect(0, 1114109, '\p{^Is_NChar=false}', "");
Expect(0, 1114109, '\P{Is_NChar=false}', "");
Expect(1, 1114109, '\P{^Is_NChar=false}', "");
Expect(0, 1114111, '\p{Is_NChar=false}', "");
Expect(1, 1114111, '\p{^Is_NChar=false}', "");
Expect(1, 1114111, '\P{Is_NChar=false}', "");
Expect(0, 1114111, '\P{^Is_NChar=false}', "");
Expect(1, 1114109, '\p{Is_NChar=-FALSE}', "");
Expect(0, 1114109, '\p{^Is_NChar=-FALSE}', "");
Expect(0, 1114109, '\P{Is_NChar=-FALSE}', "");
Expect(1, 1114109, '\P{^Is_NChar=-FALSE}', "");
Expect(0, 1114111, '\p{Is_NChar=-FALSE}', "");
Expect(1, 1114111, '\p{^Is_NChar=-FALSE}', "");
Expect(1, 1114111, '\P{Is_NChar=-FALSE}', "");
Expect(0, 1114111, '\P{^Is_NChar=-FALSE}', "");
Error('\p{Noncharacter_Code_Point=YES/a/}');
Error('\P{Noncharacter_Code_Point=YES/a/}');
Expect(1, 1114111, '\p{Noncharacter_Code_Point=yes}', "");
Expect(0, 1114111, '\p{^Noncharacter_Code_Point=yes}', "");
Expect(0, 1114111, '\P{Noncharacter_Code_Point=yes}', "");
Expect(1, 1114111, '\P{^Noncharacter_Code_Point=yes}', "");
Expect(0, 1114109, '\p{Noncharacter_Code_Point=yes}', "");
Expect(1, 1114109, '\p{^Noncharacter_Code_Point=yes}', "");
Expect(1, 1114109, '\P{Noncharacter_Code_Point=yes}', "");
Expect(0, 1114109, '\P{^Noncharacter_Code_Point=yes}', "");
Expect(1, 1114111, '\p{Noncharacter_Code_Point=Yes}', "");
Expect(0, 1114111, '\p{^Noncharacter_Code_Point=Yes}', "");
Expect(0, 1114111, '\P{Noncharacter_Code_Point=Yes}', "");
Expect(1, 1114111, '\P{^Noncharacter_Code_Point=Yes}', "");
Expect(0, 1114109, '\p{Noncharacter_Code_Point=Yes}', "");
Expect(1, 1114109, '\p{^Noncharacter_Code_Point=Yes}', "");
Expect(1, 1114109, '\P{Noncharacter_Code_Point=Yes}', "");
Expect(0, 1114109, '\P{^Noncharacter_Code_Point=Yes}', "");
Error('\p{NChar=-/a/Y}');
Error('\P{NChar=-/a/Y}');
Expect(1, 1114111, '\p{NChar=y}', "");
Expect(0, 1114111, '\p{^NChar=y}', "");
Expect(0, 1114111, '\P{NChar=y}', "");
Expect(1, 1114111, '\P{^NChar=y}', "");
Expect(0, 1114109, '\p{NChar=y}', "");
Expect(1, 1114109, '\p{^NChar=y}', "");
Expect(1, 1114109, '\P{NChar=y}', "");
Expect(0, 1114109, '\P{^NChar=y}', "");
Expect(1, 1114111, '\p{NChar=- y}', "");
Expect(0, 1114111, '\p{^NChar=- y}', "");
Expect(0, 1114111, '\P{NChar=- y}', "");
Expect(1, 1114111, '\P{^NChar=- y}', "");
Expect(0, 1114109, '\p{NChar=- y}', "");
Expect(1, 1114109, '\p{^NChar=- y}', "");
Expect(1, 1114109, '\P{NChar=- y}', "");
Expect(0, 1114109, '\P{^NChar=- y}', "");
Error('\p{Is_Noncharacter_Code_Point=:=t}');
Error('\P{Is_Noncharacter_Code_Point=:=t}');
Expect(1, 1114111, '\p{Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114111, '\p{^Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114111, '\P{Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114111, '\P{^Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114109, '\p{Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114109, '\p{^Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114109, '\P{Is_Noncharacter_Code_Point=t}', "");
Expect(0, 1114109, '\P{^Is_Noncharacter_Code_Point=t}', "");
Expect(1, 1114111, '\p{Is_Noncharacter_Code_Point=	T}', "");
Expect(0, 1114111, '\p{^Is_Noncharacter_Code_Point=	T}', "");
Expect(0, 1114111, '\P{Is_Noncharacter_Code_Point=	T}', "");
Expect(1, 1114111, '\P{^Is_Noncharacter_Code_Point=	T}', "");
Expect(0, 1114109, '\p{Is_Noncharacter_Code_Point=	T}', "");
Expect(1, 1114109, '\p{^Is_Noncharacter_Code_Point=	T}', "");
Expect(1, 1114109, '\P{Is_Noncharacter_Code_Point=	T}', "");
Expect(0, 1114109, '\P{^Is_Noncharacter_Code_Point=	T}', "");
Error('\p{Is_NChar:   :=_	True}');
Error('\P{Is_NChar:   :=_	True}');
Expect(1, 1114111, '\p{Is_NChar:	true}', "");
Expect(0, 1114111, '\p{^Is_NChar:	true}', "");
Expect(0, 1114111, '\P{Is_NChar:	true}', "");
Expect(1, 1114111, '\P{^Is_NChar:	true}', "");
Expect(0, 1114109, '\p{Is_NChar:	true}', "");
Expect(1, 1114109, '\p{^Is_NChar:	true}', "");
Expect(1, 1114109, '\P{Is_NChar:	true}', "");
Expect(0, 1114109, '\P{^Is_NChar:	true}', "");
Expect(1, 1114111, '\p{Is_NChar=	 TRUE}', "");
Expect(0, 1114111, '\p{^Is_NChar=	 TRUE}', "");
Expect(0, 1114111, '\P{Is_NChar=	 TRUE}', "");
Expect(1, 1114111, '\P{^Is_NChar=	 TRUE}', "");
Expect(0, 1114109, '\p{Is_NChar=	 TRUE}', "");
Expect(1, 1114109, '\p{^Is_NChar=	 TRUE}', "");
Expect(1, 1114109, '\P{Is_NChar=	 TRUE}', "");
Expect(0, 1114109, '\P{^Is_NChar=	 TRUE}', "");
Error('\p{NFC_Quick_Check=/a/-Maybe}');
Error('\P{NFC_Quick_Check=/a/-Maybe}');
Expect(1, 71087, '\p{NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{NFC_Quick_Check=-maybe}', "");
Expect(0, 71087, '\p{^NFC_Quick_Check=-maybe}', "");
Expect(0, 71087, '\P{NFC_Quick_Check=-maybe}', "");
Expect(1, 71087, '\P{^NFC_Quick_Check=-maybe}', "");
Expect(0, 71088, '\p{NFC_Quick_Check=-maybe}', "");
Expect(1, 71088, '\p{^NFC_Quick_Check=-maybe}', "");
Expect(1, 71088, '\P{NFC_Quick_Check=-maybe}', "");
Expect(0, 71088, '\P{^NFC_Quick_Check=-maybe}', "");
Error('\p{NFC_QC=_:=M}');
Error('\P{NFC_QC=_:=M}');
Expect(1, 71087, '\p{NFC_QC=m}', "");
Expect(0, 71087, '\p{^NFC_QC=m}', "");
Expect(0, 71087, '\P{NFC_QC=m}', "");
Expect(1, 71087, '\P{^NFC_QC=m}', "");
Expect(0, 71088, '\p{NFC_QC=m}', "");
Expect(1, 71088, '\p{^NFC_QC=m}', "");
Expect(1, 71088, '\P{NFC_QC=m}', "");
Expect(0, 71088, '\P{^NFC_QC=m}', "");
Expect(1, 71087, '\p{NFC_QC: M}', "");
Expect(0, 71087, '\p{^NFC_QC: M}', "");
Expect(0, 71087, '\P{NFC_QC: M}', "");
Expect(1, 71087, '\P{^NFC_QC: M}', "");
Expect(0, 71088, '\p{NFC_QC: M}', "");
Expect(1, 71088, '\p{^NFC_QC: M}', "");
Expect(1, 71088, '\P{NFC_QC: M}', "");
Expect(0, 71088, '\P{^NFC_QC: M}', "");
Error('\p{Is_NFC_Quick_Check=:=	Maybe}');
Error('\P{Is_NFC_Quick_Check=:=	Maybe}');
Expect(1, 71087, '\p{Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{Is_NFC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^Is_NFC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{Is_NFC_Quick_Check=_maybe}', "");
Expect(0, 71087, '\p{^Is_NFC_Quick_Check=_maybe}', "");
Expect(0, 71087, '\P{Is_NFC_Quick_Check=_maybe}', "");
Expect(1, 71087, '\P{^Is_NFC_Quick_Check=_maybe}', "");
Expect(0, 71088, '\p{Is_NFC_Quick_Check=_maybe}', "");
Expect(1, 71088, '\p{^Is_NFC_Quick_Check=_maybe}', "");
Expect(1, 71088, '\P{Is_NFC_Quick_Check=_maybe}', "");
Expect(0, 71088, '\P{^Is_NFC_Quick_Check=_maybe}', "");
Error('\p{Is_NFC_QC=/a/_M}');
Error('\P{Is_NFC_QC=/a/_M}');
Expect(1, 71087, '\p{Is_NFC_QC=m}', "");
Expect(0, 71087, '\p{^Is_NFC_QC=m}', "");
Expect(0, 71087, '\P{Is_NFC_QC=m}', "");
Expect(1, 71087, '\P{^Is_NFC_QC=m}', "");
Expect(0, 71088, '\p{Is_NFC_QC=m}', "");
Expect(1, 71088, '\p{^Is_NFC_QC=m}', "");
Expect(1, 71088, '\P{Is_NFC_QC=m}', "");
Expect(0, 71088, '\P{^Is_NFC_QC=m}', "");
Expect(1, 71087, '\p{Is_NFC_QC=- M}', "");
Expect(0, 71087, '\p{^Is_NFC_QC=- M}', "");
Expect(0, 71087, '\P{Is_NFC_QC=- M}', "");
Expect(1, 71087, '\P{^Is_NFC_QC=- M}', "");
Expect(0, 71088, '\p{Is_NFC_QC=- M}', "");
Expect(1, 71088, '\p{^Is_NFC_QC=- M}', "");
Expect(1, 71088, '\P{Is_NFC_QC=- M}', "");
Expect(0, 71088, '\P{^Is_NFC_QC=- M}', "");
Error('\p{NFC_Quick_Check=-No:=}');
Error('\P{NFC_Quick_Check=-No:=}');
Expect(1, 195101, '\p{NFC_Quick_Check=no}', "");
Expect(0, 195101, '\p{^NFC_Quick_Check=no}', "");
Expect(0, 195101, '\P{NFC_Quick_Check=no}', "");
Expect(1, 195101, '\P{^NFC_Quick_Check=no}', "");
Expect(0, 195102, '\p{NFC_Quick_Check=no}', "");
Expect(1, 195102, '\p{^NFC_Quick_Check=no}', "");
Expect(1, 195102, '\P{NFC_Quick_Check=no}', "");
Expect(0, 195102, '\P{^NFC_Quick_Check=no}', "");
Expect(1, 195101, '\p{NFC_Quick_Check:  No}', "");
Expect(0, 195101, '\p{^NFC_Quick_Check:  No}', "");
Expect(0, 195101, '\P{NFC_Quick_Check:  No}', "");
Expect(1, 195101, '\P{^NFC_Quick_Check:  No}', "");
Expect(0, 195102, '\p{NFC_Quick_Check:  No}', "");
Expect(1, 195102, '\p{^NFC_Quick_Check:  No}', "");
Expect(1, 195102, '\P{NFC_Quick_Check:  No}', "");
Expect(0, 195102, '\P{^NFC_Quick_Check:  No}', "");
Error('\p{NFC_QC=:= 	n}');
Error('\P{NFC_QC=:= 	n}');
Expect(1, 195101, '\p{NFC_QC=n}', "");
Expect(0, 195101, '\p{^NFC_QC=n}', "");
Expect(0, 195101, '\P{NFC_QC=n}', "");
Expect(1, 195101, '\P{^NFC_QC=n}', "");
Expect(0, 195102, '\p{NFC_QC=n}', "");
Expect(1, 195102, '\p{^NFC_QC=n}', "");
Expect(1, 195102, '\P{NFC_QC=n}', "");
Expect(0, 195102, '\P{^NFC_QC=n}', "");
Expect(1, 195101, '\p{NFC_QC=--N}', "");
Expect(0, 195101, '\p{^NFC_QC=--N}', "");
Expect(0, 195101, '\P{NFC_QC=--N}', "");
Expect(1, 195101, '\P{^NFC_QC=--N}', "");
Expect(0, 195102, '\p{NFC_QC=--N}', "");
Expect(1, 195102, '\p{^NFC_QC=--N}', "");
Expect(1, 195102, '\P{NFC_QC=--N}', "");
Expect(0, 195102, '\P{^NFC_QC=--N}', "");
Error('\p{Is_NFC_Quick_Check=	no:=}');
Error('\P{Is_NFC_Quick_Check=	no:=}');
Expect(1, 195101, '\p{Is_NFC_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFC_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFC_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFC_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFC_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFC_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFC_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFC_Quick_Check=no}', "");
Expect(1, 195101, '\p{Is_NFC_Quick_Check=--No}', "");
Expect(0, 195101, '\p{^Is_NFC_Quick_Check=--No}', "");
Expect(0, 195101, '\P{Is_NFC_Quick_Check=--No}', "");
Expect(1, 195101, '\P{^Is_NFC_Quick_Check=--No}', "");
Expect(0, 195102, '\p{Is_NFC_Quick_Check=--No}', "");
Expect(1, 195102, '\p{^Is_NFC_Quick_Check=--No}', "");
Expect(1, 195102, '\P{Is_NFC_Quick_Check=--No}', "");
Expect(0, 195102, '\P{^Is_NFC_Quick_Check=--No}', "");
Error('\p{Is_NFC_QC=_-N:=}');
Error('\P{Is_NFC_QC=_-N:=}');
Expect(1, 195101, '\p{Is_NFC_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFC_QC=n}', "");
Expect(0, 195101, '\P{Is_NFC_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFC_QC=n}', "");
Expect(0, 195102, '\p{Is_NFC_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFC_QC=n}', "");
Expect(1, 195102, '\P{Is_NFC_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFC_QC=n}', "");
Expect(1, 195101, '\p{Is_NFC_QC=	-N}', "");
Expect(0, 195101, '\p{^Is_NFC_QC=	-N}', "");
Expect(0, 195101, '\P{Is_NFC_QC=	-N}', "");
Expect(1, 195101, '\P{^Is_NFC_QC=	-N}', "");
Expect(0, 195102, '\p{Is_NFC_QC=	-N}', "");
Expect(1, 195102, '\p{^Is_NFC_QC=	-N}', "");
Expect(1, 195102, '\P{Is_NFC_QC=	-N}', "");
Expect(0, 195102, '\P{^Is_NFC_QC=	-N}', "");
Error('\p{NFC_Quick_Check=- Yes:=}');
Error('\P{NFC_Quick_Check=- Yes:=}');
Expect(1, 195102, '\p{NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFC_Quick_Check=_Yes}', "");
Expect(0, 195102, '\p{^NFC_Quick_Check=_Yes}', "");
Expect(0, 195102, '\P{NFC_Quick_Check=_Yes}', "");
Expect(1, 195102, '\P{^NFC_Quick_Check=_Yes}', "");
Expect(0, 195101, '\p{NFC_Quick_Check=_Yes}', "");
Expect(1, 195101, '\p{^NFC_Quick_Check=_Yes}', "");
Expect(1, 195101, '\P{NFC_Quick_Check=_Yes}', "");
Expect(0, 195101, '\P{^NFC_Quick_Check=_Yes}', "");
Error('\p{NFC_QC=:=-	Y}');
Error('\P{NFC_QC=:=-	Y}');
Expect(1, 195102, '\p{NFC_QC:   y}', "");
Expect(0, 195102, '\p{^NFC_QC:   y}', "");
Expect(0, 195102, '\P{NFC_QC:   y}', "");
Expect(1, 195102, '\P{^NFC_QC:   y}', "");
Expect(0, 195101, '\p{NFC_QC:   y}', "");
Expect(1, 195101, '\p{^NFC_QC:   y}', "");
Expect(1, 195101, '\P{NFC_QC:   y}', "");
Expect(0, 195101, '\P{^NFC_QC:   y}', "");
Expect(1, 195102, '\p{NFC_QC=	Y}', "");
Expect(0, 195102, '\p{^NFC_QC=	Y}', "");
Expect(0, 195102, '\P{NFC_QC=	Y}', "");
Expect(1, 195102, '\P{^NFC_QC=	Y}', "");
Expect(0, 195101, '\p{NFC_QC=	Y}', "");
Expect(1, 195101, '\p{^NFC_QC=	Y}', "");
Expect(1, 195101, '\P{NFC_QC=	Y}', "");
Expect(0, 195101, '\P{^NFC_QC=	Y}', "");
Error('\p{Is_NFC_Quick_Check=:=--Yes}');
Error('\P{Is_NFC_Quick_Check=:=--Yes}');
Expect(1, 195102, '\p{Is_NFC_Quick_Check:yes}', "");
Expect(0, 195102, '\p{^Is_NFC_Quick_Check:yes}', "");
Expect(0, 195102, '\P{Is_NFC_Quick_Check:yes}', "");
Expect(1, 195102, '\P{^Is_NFC_Quick_Check:yes}', "");
Expect(0, 195101, '\p{Is_NFC_Quick_Check:yes}', "");
Expect(1, 195101, '\p{^Is_NFC_Quick_Check:yes}', "");
Expect(1, 195101, '\P{Is_NFC_Quick_Check:yes}', "");
Expect(0, 195101, '\P{^Is_NFC_Quick_Check:yes}', "");
Expect(1, 195102, '\p{Is_NFC_Quick_Check=YES}', "");
Expect(0, 195102, '\p{^Is_NFC_Quick_Check=YES}', "");
Expect(0, 195102, '\P{Is_NFC_Quick_Check=YES}', "");
Expect(1, 195102, '\P{^Is_NFC_Quick_Check=YES}', "");
Expect(0, 195101, '\p{Is_NFC_Quick_Check=YES}', "");
Expect(1, 195101, '\p{^Is_NFC_Quick_Check=YES}', "");
Expect(1, 195101, '\P{Is_NFC_Quick_Check=YES}', "");
Expect(0, 195101, '\P{^Is_NFC_Quick_Check=YES}', "");
Error('\p{Is_NFC_QC=/a/Y}');
Error('\P{Is_NFC_QC=/a/Y}');
Expect(1, 195102, '\p{Is_NFC_QC:	y}', "");
Expect(0, 195102, '\p{^Is_NFC_QC:	y}', "");
Expect(0, 195102, '\P{Is_NFC_QC:	y}', "");
Expect(1, 195102, '\P{^Is_NFC_QC:	y}', "");
Expect(0, 195101, '\p{Is_NFC_QC:	y}', "");
Expect(1, 195101, '\p{^Is_NFC_QC:	y}', "");
Expect(1, 195101, '\P{Is_NFC_QC:	y}', "");
Expect(0, 195101, '\P{^Is_NFC_QC:	y}', "");
Expect(1, 195102, '\p{Is_NFC_QC=_ Y}', "");
Expect(0, 195102, '\p{^Is_NFC_QC=_ Y}', "");
Expect(0, 195102, '\P{Is_NFC_QC=_ Y}', "");
Expect(1, 195102, '\P{^Is_NFC_QC=_ Y}', "");
Expect(0, 195101, '\p{Is_NFC_QC=_ Y}', "");
Expect(1, 195101, '\p{^Is_NFC_QC=_ Y}', "");
Expect(1, 195101, '\P{Is_NFC_QC=_ Y}', "");
Expect(0, 195101, '\P{^Is_NFC_QC=_ Y}', "");
Error('\p{NFD_Quick_Check:   _/a/No}');
Error('\P{NFD_Quick_Check:   _/a/No}');
Expect(1, 195101, '\p{NFD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^NFD_Quick_Check=no}', "");
Expect(0, 195101, '\P{NFD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^NFD_Quick_Check=no}', "");
Expect(0, 195102, '\p{NFD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^NFD_Quick_Check=no}', "");
Expect(1, 195102, '\P{NFD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^NFD_Quick_Check=no}', "");
Expect(1, 195101, '\p{NFD_Quick_Check=_No}', "");
Expect(0, 195101, '\p{^NFD_Quick_Check=_No}', "");
Expect(0, 195101, '\P{NFD_Quick_Check=_No}', "");
Expect(1, 195101, '\P{^NFD_Quick_Check=_No}', "");
Expect(0, 195102, '\p{NFD_Quick_Check=_No}', "");
Expect(1, 195102, '\p{^NFD_Quick_Check=_No}', "");
Expect(1, 195102, '\P{NFD_Quick_Check=_No}', "");
Expect(0, 195102, '\P{^NFD_Quick_Check=_No}', "");
Error('\p{NFD_QC=:=	N}');
Error('\P{NFD_QC=:=	N}');
Expect(1, 195101, '\p{NFD_QC=n}', "");
Expect(0, 195101, '\p{^NFD_QC=n}', "");
Expect(0, 195101, '\P{NFD_QC=n}', "");
Expect(1, 195101, '\P{^NFD_QC=n}', "");
Expect(0, 195102, '\p{NFD_QC=n}', "");
Expect(1, 195102, '\p{^NFD_QC=n}', "");
Expect(1, 195102, '\P{NFD_QC=n}', "");
Expect(0, 195102, '\P{^NFD_QC=n}', "");
Expect(1, 195101, '\p{NFD_QC=_-n}', "");
Expect(0, 195101, '\p{^NFD_QC=_-n}', "");
Expect(0, 195101, '\P{NFD_QC=_-n}', "");
Expect(1, 195101, '\P{^NFD_QC=_-n}', "");
Expect(0, 195102, '\p{NFD_QC=_-n}', "");
Expect(1, 195102, '\p{^NFD_QC=_-n}', "");
Expect(1, 195102, '\P{NFD_QC=_-n}', "");
Expect(0, 195102, '\P{^NFD_QC=_-n}', "");
Error('\p{Is_NFD_Quick_Check=	/a/No}');
Error('\P{Is_NFD_Quick_Check=	/a/No}');
Expect(1, 195101, '\p{Is_NFD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFD_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFD_Quick_Check=no}', "");
Expect(1, 195101, '\p{Is_NFD_Quick_Check=_No}', "");
Expect(0, 195101, '\p{^Is_NFD_Quick_Check=_No}', "");
Expect(0, 195101, '\P{Is_NFD_Quick_Check=_No}', "");
Expect(1, 195101, '\P{^Is_NFD_Quick_Check=_No}', "");
Expect(0, 195102, '\p{Is_NFD_Quick_Check=_No}', "");
Expect(1, 195102, '\p{^Is_NFD_Quick_Check=_No}', "");
Expect(1, 195102, '\P{Is_NFD_Quick_Check=_No}', "");
Expect(0, 195102, '\P{^Is_NFD_Quick_Check=_No}', "");
Error('\p{Is_NFD_QC= 	n/a/}');
Error('\P{Is_NFD_QC= 	n/a/}');
Expect(1, 195101, '\p{Is_NFD_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFD_QC=n}', "");
Expect(0, 195101, '\P{Is_NFD_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFD_QC=n}', "");
Expect(0, 195102, '\p{Is_NFD_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFD_QC=n}', "");
Expect(1, 195102, '\P{Is_NFD_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFD_QC=n}', "");
Expect(1, 195101, '\p{Is_NFD_QC= 	N}', "");
Expect(0, 195101, '\p{^Is_NFD_QC= 	N}', "");
Expect(0, 195101, '\P{Is_NFD_QC= 	N}', "");
Expect(1, 195101, '\P{^Is_NFD_QC= 	N}', "");
Expect(0, 195102, '\p{Is_NFD_QC= 	N}', "");
Expect(1, 195102, '\p{^Is_NFD_QC= 	N}', "");
Expect(1, 195102, '\P{Is_NFD_QC= 	N}', "");
Expect(0, 195102, '\P{^Is_NFD_QC= 	N}', "");
Error('\p{NFD_Quick_Check=-Yes/a/}');
Error('\P{NFD_Quick_Check=-Yes/a/}');
Expect(1, 195102, '\p{NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFD_Quick_Check= 	YES}', "");
Expect(0, 195102, '\p{^NFD_Quick_Check= 	YES}', "");
Expect(0, 195102, '\P{NFD_Quick_Check= 	YES}', "");
Expect(1, 195102, '\P{^NFD_Quick_Check= 	YES}', "");
Expect(0, 195101, '\p{NFD_Quick_Check= 	YES}', "");
Expect(1, 195101, '\p{^NFD_Quick_Check= 	YES}', "");
Expect(1, 195101, '\P{NFD_Quick_Check= 	YES}', "");
Expect(0, 195101, '\P{^NFD_Quick_Check= 	YES}', "");
Error('\p{NFD_QC=/a/	_Y}');
Error('\P{NFD_QC=/a/	_Y}');
Expect(1, 195102, '\p{NFD_QC=y}', "");
Expect(0, 195102, '\p{^NFD_QC=y}', "");
Expect(0, 195102, '\P{NFD_QC=y}', "");
Expect(1, 195102, '\P{^NFD_QC=y}', "");
Expect(0, 195101, '\p{NFD_QC=y}', "");
Expect(1, 195101, '\p{^NFD_QC=y}', "");
Expect(1, 195101, '\P{NFD_QC=y}', "");
Expect(0, 195101, '\P{^NFD_QC=y}', "");
Expect(1, 195102, '\p{NFD_QC=	_Y}', "");
Expect(0, 195102, '\p{^NFD_QC=	_Y}', "");
Expect(0, 195102, '\P{NFD_QC=	_Y}', "");
Expect(1, 195102, '\P{^NFD_QC=	_Y}', "");
Expect(0, 195101, '\p{NFD_QC=	_Y}', "");
Expect(1, 195101, '\p{^NFD_QC=	_Y}', "");
Expect(1, 195101, '\P{NFD_QC=	_Y}', "");
Expect(0, 195101, '\P{^NFD_QC=	_Y}', "");
Error('\p{Is_NFD_Quick_Check=:= Yes}');
Error('\P{Is_NFD_Quick_Check=:= Yes}');
Expect(1, 195102, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFD_Quick_Check=_Yes}', "");
Expect(0, 195102, '\p{^Is_NFD_Quick_Check=_Yes}', "");
Expect(0, 195102, '\P{Is_NFD_Quick_Check=_Yes}', "");
Expect(1, 195102, '\P{^Is_NFD_Quick_Check=_Yes}', "");
Expect(0, 195101, '\p{Is_NFD_Quick_Check=_Yes}', "");
Expect(1, 195101, '\p{^Is_NFD_Quick_Check=_Yes}', "");
Expect(1, 195101, '\P{Is_NFD_Quick_Check=_Yes}', "");
Expect(0, 195101, '\P{^Is_NFD_Quick_Check=_Yes}', "");
Error('\p{Is_NFD_QC=/a/_Y}');
Error('\P{Is_NFD_QC=/a/_Y}');
Expect(1, 195102, '\p{Is_NFD_QC=y}', "");
Expect(0, 195102, '\p{^Is_NFD_QC=y}', "");
Expect(0, 195102, '\P{Is_NFD_QC=y}', "");
Expect(1, 195102, '\P{^Is_NFD_QC=y}', "");
Expect(0, 195101, '\p{Is_NFD_QC=y}', "");
Expect(1, 195101, '\p{^Is_NFD_QC=y}', "");
Expect(1, 195101, '\P{Is_NFD_QC=y}', "");
Expect(0, 195101, '\P{^Is_NFD_QC=y}', "");
Expect(1, 195102, '\p{Is_NFD_QC=_	Y}', "");
Expect(0, 195102, '\p{^Is_NFD_QC=_	Y}', "");
Expect(0, 195102, '\P{Is_NFD_QC=_	Y}', "");
Expect(1, 195102, '\P{^Is_NFD_QC=_	Y}', "");
Expect(0, 195101, '\p{Is_NFD_QC=_	Y}', "");
Expect(1, 195101, '\p{^Is_NFD_QC=_	Y}', "");
Expect(1, 195101, '\P{Is_NFD_QC=_	Y}', "");
Expect(0, 195101, '\P{^Is_NFD_QC=_	Y}', "");
Error('\p{NFKC_Quick_Check=	/a/maybe}');
Error('\P{NFKC_Quick_Check=	/a/maybe}');
Expect(1, 71087, '\p{NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{NFKC_Quick_Check=	-Maybe}', "");
Expect(0, 71087, '\p{^NFKC_Quick_Check=	-Maybe}', "");
Expect(0, 71087, '\P{NFKC_Quick_Check=	-Maybe}', "");
Expect(1, 71087, '\P{^NFKC_Quick_Check=	-Maybe}', "");
Expect(0, 71088, '\p{NFKC_Quick_Check=	-Maybe}', "");
Expect(1, 71088, '\p{^NFKC_Quick_Check=	-Maybe}', "");
Expect(1, 71088, '\P{NFKC_Quick_Check=	-Maybe}', "");
Expect(0, 71088, '\P{^NFKC_Quick_Check=	-Maybe}', "");
Error('\p{NFKC_QC: /a/		m}');
Error('\P{NFKC_QC: /a/		m}');
Expect(1, 71087, '\p{NFKC_QC: m}', "");
Expect(0, 71087, '\p{^NFKC_QC: m}', "");
Expect(0, 71087, '\P{NFKC_QC: m}', "");
Expect(1, 71087, '\P{^NFKC_QC: m}', "");
Expect(0, 71088, '\p{NFKC_QC: m}', "");
Expect(1, 71088, '\p{^NFKC_QC: m}', "");
Expect(1, 71088, '\P{NFKC_QC: m}', "");
Expect(0, 71088, '\P{^NFKC_QC: m}', "");
Expect(1, 71087, '\p{NFKC_QC=--M}', "");
Expect(0, 71087, '\p{^NFKC_QC=--M}', "");
Expect(0, 71087, '\P{NFKC_QC=--M}', "");
Expect(1, 71087, '\P{^NFKC_QC=--M}', "");
Expect(0, 71088, '\p{NFKC_QC=--M}', "");
Expect(1, 71088, '\p{^NFKC_QC=--M}', "");
Expect(1, 71088, '\P{NFKC_QC=--M}', "");
Expect(0, 71088, '\P{^NFKC_QC=--M}', "");
Error('\p{Is_NFKC_Quick_Check=	-maybe:=}');
Error('\P{Is_NFKC_Quick_Check=	-maybe:=}');
Expect(1, 71087, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71087, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\p{Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\p{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71088, '\P{Is_NFKC_Quick_Check=maybe}', "");
Expect(0, 71088, '\P{^Is_NFKC_Quick_Check=maybe}', "");
Expect(1, 71087, '\p{Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(0, 71087, '\p{^Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(0, 71087, '\P{Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(1, 71087, '\P{^Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(0, 71088, '\p{Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(1, 71088, '\p{^Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(1, 71088, '\P{Is_NFKC_Quick_Check=		MAYBE}', "");
Expect(0, 71088, '\P{^Is_NFKC_Quick_Check=		MAYBE}', "");
Error('\p{Is_NFKC_QC=	/a/m}');
Error('\P{Is_NFKC_QC=	/a/m}');
Expect(1, 71087, '\p{Is_NFKC_QC:   m}', "");
Expect(0, 71087, '\p{^Is_NFKC_QC:   m}', "");
Expect(0, 71087, '\P{Is_NFKC_QC:   m}', "");
Expect(1, 71087, '\P{^Is_NFKC_QC:   m}', "");
Expect(0, 71088, '\p{Is_NFKC_QC:   m}', "");
Expect(1, 71088, '\p{^Is_NFKC_QC:   m}', "");
Expect(1, 71088, '\P{Is_NFKC_QC:   m}', "");
Expect(0, 71088, '\P{^Is_NFKC_QC:   m}', "");
Expect(1, 71087, '\p{Is_NFKC_QC=_	M}', "");
Expect(0, 71087, '\p{^Is_NFKC_QC=_	M}', "");
Expect(0, 71087, '\P{Is_NFKC_QC=_	M}', "");
Expect(1, 71087, '\P{^Is_NFKC_QC=_	M}', "");
Expect(0, 71088, '\p{Is_NFKC_QC=_	M}', "");
Expect(1, 71088, '\p{^Is_NFKC_QC=_	M}', "");
Expect(1, 71088, '\P{Is_NFKC_QC=_	M}', "");
Expect(0, 71088, '\P{^Is_NFKC_QC=_	M}', "");
Error('\p{NFKC_Quick_Check:   :=-_no}');
Error('\P{NFKC_Quick_Check:   :=-_no}');
Expect(1, 195101, '\p{NFKC_Quick_Check=no}', "");
Expect(0, 195101, '\p{^NFKC_Quick_Check=no}', "");
Expect(0, 195101, '\P{NFKC_Quick_Check=no}', "");
Expect(1, 195101, '\P{^NFKC_Quick_Check=no}', "");
Expect(0, 195102, '\p{NFKC_Quick_Check=no}', "");
Expect(1, 195102, '\p{^NFKC_Quick_Check=no}', "");
Expect(1, 195102, '\P{NFKC_Quick_Check=no}', "");
Expect(0, 195102, '\P{^NFKC_Quick_Check=no}', "");
Expect(1, 195101, '\p{NFKC_Quick_Check=	No}', "");
Expect(0, 195101, '\p{^NFKC_Quick_Check=	No}', "");
Expect(0, 195101, '\P{NFKC_Quick_Check=	No}', "");
Expect(1, 195101, '\P{^NFKC_Quick_Check=	No}', "");
Expect(0, 195102, '\p{NFKC_Quick_Check=	No}', "");
Expect(1, 195102, '\p{^NFKC_Quick_Check=	No}', "");
Expect(1, 195102, '\P{NFKC_Quick_Check=	No}', "");
Expect(0, 195102, '\P{^NFKC_Quick_Check=	No}', "");
Error('\p{NFKC_QC= _n/a/}');
Error('\P{NFKC_QC= _n/a/}');
Expect(1, 195101, '\p{NFKC_QC=n}', "");
Expect(0, 195101, '\p{^NFKC_QC=n}', "");
Expect(0, 195101, '\P{NFKC_QC=n}', "");
Expect(1, 195101, '\P{^NFKC_QC=n}', "");
Expect(0, 195102, '\p{NFKC_QC=n}', "");
Expect(1, 195102, '\p{^NFKC_QC=n}', "");
Expect(1, 195102, '\P{NFKC_QC=n}', "");
Expect(0, 195102, '\P{^NFKC_QC=n}', "");
Expect(1, 195101, '\p{NFKC_QC=_-N}', "");
Expect(0, 195101, '\p{^NFKC_QC=_-N}', "");
Expect(0, 195101, '\P{NFKC_QC=_-N}', "");
Expect(1, 195101, '\P{^NFKC_QC=_-N}', "");
Expect(0, 195102, '\p{NFKC_QC=_-N}', "");
Expect(1, 195102, '\p{^NFKC_QC=_-N}', "");
Expect(1, 195102, '\P{NFKC_QC=_-N}', "");
Expect(0, 195102, '\P{^NFKC_QC=_-N}', "");
Error('\p{Is_NFKC_Quick_Check:	/a/_	NO}');
Error('\P{Is_NFKC_Quick_Check:	/a/_	NO}');
Expect(1, 195101, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(0, 195101, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 195101, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(1, 195101, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(0, 195102, '\p{Is_NFKC_Quick_Check=no}', "");
Expect(1, 195102, '\p{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 195102, '\P{Is_NFKC_Quick_Check=no}', "");
Expect(0, 195102, '\P{^Is_NFKC_Quick_Check=no}', "");
Expect(1, 195101, '\p{Is_NFKC_Quick_Check=		no}', "");
Expect(0, 195101, '\p{^Is_NFKC_Quick_Check=		no}', "");
Expect(0, 195101, '\P{Is_NFKC_Quick_Check=		no}', "");
Expect(1, 195101, '\P{^Is_NFKC_Quick_Check=		no}', "");
Expect(0, 195102, '\p{Is_NFKC_Quick_Check=		no}', "");
Expect(1, 195102, '\p{^Is_NFKC_Quick_Check=		no}', "");
Expect(1, 195102, '\P{Is_NFKC_Quick_Check=		no}', "");
Expect(0, 195102, '\P{^Is_NFKC_Quick_Check=		no}', "");
Error('\p{Is_NFKC_QC=__N:=}');
Error('\P{Is_NFKC_QC=__N:=}');
Expect(1, 195101, '\p{Is_NFKC_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFKC_QC=n}', "");
Expect(0, 195101, '\P{Is_NFKC_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFKC_QC=n}', "");
Expect(0, 195102, '\p{Is_NFKC_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFKC_QC=n}', "");
Expect(1, 195102, '\P{Is_NFKC_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFKC_QC=n}', "");
Expect(1, 195101, '\p{Is_NFKC_QC=__N}', "");
Expect(0, 195101, '\p{^Is_NFKC_QC=__N}', "");
Expect(0, 195101, '\P{Is_NFKC_QC=__N}', "");
Expect(1, 195101, '\P{^Is_NFKC_QC=__N}', "");
Expect(0, 195102, '\p{Is_NFKC_QC=__N}', "");
Expect(1, 195102, '\p{^Is_NFKC_QC=__N}', "");
Expect(1, 195102, '\P{Is_NFKC_QC=__N}', "");
Expect(0, 195102, '\P{^Is_NFKC_QC=__N}', "");
Error('\p{NFKC_Quick_Check=-_yes:=}');
Error('\P{NFKC_Quick_Check=-_yes:=}');
Expect(1, 195102, '\p{NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFKC_Quick_Check= Yes}', "");
Expect(0, 195102, '\p{^NFKC_Quick_Check= Yes}', "");
Expect(0, 195102, '\P{NFKC_Quick_Check= Yes}', "");
Expect(1, 195102, '\P{^NFKC_Quick_Check= Yes}', "");
Expect(0, 195101, '\p{NFKC_Quick_Check= Yes}', "");
Expect(1, 195101, '\p{^NFKC_Quick_Check= Yes}', "");
Expect(1, 195101, '\P{NFKC_Quick_Check= Yes}', "");
Expect(0, 195101, '\P{^NFKC_Quick_Check= Yes}', "");
Error('\p{NFKC_QC=_/a/y}');
Error('\P{NFKC_QC=_/a/y}');
Expect(1, 195102, '\p{NFKC_QC=y}', "");
Expect(0, 195102, '\p{^NFKC_QC=y}', "");
Expect(0, 195102, '\P{NFKC_QC=y}', "");
Expect(1, 195102, '\P{^NFKC_QC=y}', "");
Expect(0, 195101, '\p{NFKC_QC=y}', "");
Expect(1, 195101, '\p{^NFKC_QC=y}', "");
Expect(1, 195101, '\P{NFKC_QC=y}', "");
Expect(0, 195101, '\P{^NFKC_QC=y}', "");
Expect(1, 195102, '\p{NFKC_QC=-Y}', "");
Expect(0, 195102, '\p{^NFKC_QC=-Y}', "");
Expect(0, 195102, '\P{NFKC_QC=-Y}', "");
Expect(1, 195102, '\P{^NFKC_QC=-Y}', "");
Expect(0, 195101, '\p{NFKC_QC=-Y}', "");
Expect(1, 195101, '\p{^NFKC_QC=-Y}', "");
Expect(1, 195101, '\P{NFKC_QC=-Y}', "");
Expect(0, 195101, '\P{^NFKC_QC=-Y}', "");
Error('\p{Is_NFKC_Quick_Check=:=	Yes}');
Error('\P{Is_NFKC_Quick_Check=:=	Yes}');
Expect(1, 195102, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFKC_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFKC_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFKC_Quick_Check=	 Yes}', "");
Expect(0, 195102, '\p{^Is_NFKC_Quick_Check=	 Yes}', "");
Expect(0, 195102, '\P{Is_NFKC_Quick_Check=	 Yes}', "");
Expect(1, 195102, '\P{^Is_NFKC_Quick_Check=	 Yes}', "");
Expect(0, 195101, '\p{Is_NFKC_Quick_Check=	 Yes}', "");
Expect(1, 195101, '\p{^Is_NFKC_Quick_Check=	 Yes}', "");
Expect(1, 195101, '\P{Is_NFKC_Quick_Check=	 Yes}', "");
Expect(0, 195101, '\P{^Is_NFKC_Quick_Check=	 Yes}', "");
Error('\p{Is_NFKC_QC=:=  Y}');
Error('\P{Is_NFKC_QC=:=  Y}');
Expect(1, 195102, '\p{Is_NFKC_QC=y}', "");
Expect(0, 195102, '\p{^Is_NFKC_QC=y}', "");
Expect(0, 195102, '\P{Is_NFKC_QC=y}', "");
Expect(1, 195102, '\P{^Is_NFKC_QC=y}', "");
Expect(0, 195101, '\p{Is_NFKC_QC=y}', "");
Expect(1, 195101, '\p{^Is_NFKC_QC=y}', "");
Expect(1, 195101, '\P{Is_NFKC_QC=y}', "");
Expect(0, 195101, '\P{^Is_NFKC_QC=y}', "");
Expect(1, 195102, '\p{Is_NFKC_QC= _Y}', "");
Expect(0, 195102, '\p{^Is_NFKC_QC= _Y}', "");
Expect(0, 195102, '\P{Is_NFKC_QC= _Y}', "");
Expect(1, 195102, '\P{^Is_NFKC_QC= _Y}', "");
Expect(0, 195101, '\p{Is_NFKC_QC= _Y}', "");
Expect(1, 195101, '\p{^Is_NFKC_QC= _Y}', "");
Expect(1, 195101, '\P{Is_NFKC_QC= _Y}', "");
Expect(0, 195101, '\P{^Is_NFKC_QC= _Y}', "");
Error('\p{NFKD_Quick_Check=/a/no}');
Error('\P{NFKD_Quick_Check=/a/no}');
Expect(1, 195101, '\p{NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\p{^NFKD_Quick_Check=no}', "");
Expect(0, 195101, '\P{NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\P{^NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\p{NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\p{^NFKD_Quick_Check=no}', "");
Expect(1, 195102, '\P{NFKD_Quick_Check=no}', "");
Expect(0, 195102, '\P{^NFKD_Quick_Check=no}', "");
Expect(1, 195101, '\p{NFKD_Quick_Check=_No}', "");
Expect(0, 195101, '\p{^NFKD_Quick_Check=_No}', "");
Expect(0, 195101, '\P{NFKD_Quick_Check=_No}', "");
Expect(1, 195101, '\P{^NFKD_Quick_Check=_No}', "");
Expect(0, 195102, '\p{NFKD_Quick_Check=_No}', "");
Expect(1, 195102, '\p{^NFKD_Quick_Check=_No}', "");
Expect(1, 195102, '\P{NFKD_Quick_Check=_No}', "");
Expect(0, 195102, '\P{^NFKD_Quick_Check=_No}', "");
Error('\p{NFKD_QC=/a/_N}');
Error('\P{NFKD_QC=/a/_N}');
Expect(1, 195101, '\p{NFKD_QC=n}', "");
Expect(0, 195101, '\p{^NFKD_QC=n}', "");
Expect(0, 195101, '\P{NFKD_QC=n}', "");
Expect(1, 195101, '\P{^NFKD_QC=n}', "");
Expect(0, 195102, '\p{NFKD_QC=n}', "");
Expect(1, 195102, '\p{^NFKD_QC=n}', "");
Expect(1, 195102, '\P{NFKD_QC=n}', "");
Expect(0, 195102, '\P{^NFKD_QC=n}', "");
Expect(1, 195101, '\p{NFKD_QC=_N}', "");
Expect(0, 195101, '\p{^NFKD_QC=_N}', "");
Expect(0, 195101, '\P{NFKD_QC=_N}', "");
Expect(1, 195101, '\P{^NFKD_QC=_N}', "");
Expect(0, 195102, '\p{NFKD_QC=_N}', "");
Expect(1, 195102, '\p{^NFKD_QC=_N}', "");
Expect(1, 195102, '\P{NFKD_QC=_N}', "");
Expect(0, 195102, '\P{^NFKD_QC=_N}', "");
Error('\p{Is_NFKD_Quick_Check=_:=No}');
Error('\P{Is_NFKD_Quick_Check=_:=No}');
Expect(1, 195101, '\p{Is_NFKD_Quick_Check:   no}', "");
Expect(0, 195101, '\p{^Is_NFKD_Quick_Check:   no}', "");
Expect(0, 195101, '\P{Is_NFKD_Quick_Check:   no}', "");
Expect(1, 195101, '\P{^Is_NFKD_Quick_Check:   no}', "");
Expect(0, 195102, '\p{Is_NFKD_Quick_Check:   no}', "");
Expect(1, 195102, '\p{^Is_NFKD_Quick_Check:   no}', "");
Expect(1, 195102, '\P{Is_NFKD_Quick_Check:   no}', "");
Expect(0, 195102, '\P{^Is_NFKD_Quick_Check:   no}', "");
Expect(1, 195101, '\p{Is_NFKD_Quick_Check=-No}', "");
Expect(0, 195101, '\p{^Is_NFKD_Quick_Check=-No}', "");
Expect(0, 195101, '\P{Is_NFKD_Quick_Check=-No}', "");
Expect(1, 195101, '\P{^Is_NFKD_Quick_Check=-No}', "");
Expect(0, 195102, '\p{Is_NFKD_Quick_Check=-No}', "");
Expect(1, 195102, '\p{^Is_NFKD_Quick_Check=-No}', "");
Expect(1, 195102, '\P{Is_NFKD_Quick_Check=-No}', "");
Expect(0, 195102, '\P{^Is_NFKD_Quick_Check=-No}', "");
Error('\p{Is_NFKD_QC=:=	-n}');
Error('\P{Is_NFKD_QC=:=	-n}');
Expect(1, 195101, '\p{Is_NFKD_QC=n}', "");
Expect(0, 195101, '\p{^Is_NFKD_QC=n}', "");
Expect(0, 195101, '\P{Is_NFKD_QC=n}', "");
Expect(1, 195101, '\P{^Is_NFKD_QC=n}', "");
Expect(0, 195102, '\p{Is_NFKD_QC=n}', "");
Expect(1, 195102, '\p{^Is_NFKD_QC=n}', "");
Expect(1, 195102, '\P{Is_NFKD_QC=n}', "");
Expect(0, 195102, '\P{^Is_NFKD_QC=n}', "");
Expect(1, 195101, '\p{Is_NFKD_QC=	-n}', "");
Expect(0, 195101, '\p{^Is_NFKD_QC=	-n}', "");
Expect(0, 195101, '\P{Is_NFKD_QC=	-n}', "");
Expect(1, 195101, '\P{^Is_NFKD_QC=	-n}', "");
Expect(0, 195102, '\p{Is_NFKD_QC=	-n}', "");
Expect(1, 195102, '\p{^Is_NFKD_QC=	-n}', "");
Expect(1, 195102, '\P{Is_NFKD_QC=	-n}', "");
Expect(0, 195102, '\P{^Is_NFKD_QC=	-n}', "");
Error('\p{NFKD_Quick_Check=__Yes/a/}');
Error('\P{NFKD_Quick_Check=__Yes/a/}');
Expect(1, 195102, '\p{NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{NFKD_Quick_Check= _yes}', "");
Expect(0, 195102, '\p{^NFKD_Quick_Check= _yes}', "");
Expect(0, 195102, '\P{NFKD_Quick_Check= _yes}', "");
Expect(1, 195102, '\P{^NFKD_Quick_Check= _yes}', "");
Expect(0, 195101, '\p{NFKD_Quick_Check= _yes}', "");
Expect(1, 195101, '\p{^NFKD_Quick_Check= _yes}', "");
Expect(1, 195101, '\P{NFKD_Quick_Check= _yes}', "");
Expect(0, 195101, '\P{^NFKD_Quick_Check= _yes}', "");
Error('\p{NFKD_QC=	/a/Y}');
Error('\P{NFKD_QC=	/a/Y}');
Expect(1, 195102, '\p{NFKD_QC=y}', "");
Expect(0, 195102, '\p{^NFKD_QC=y}', "");
Expect(0, 195102, '\P{NFKD_QC=y}', "");
Expect(1, 195102, '\P{^NFKD_QC=y}', "");
Expect(0, 195101, '\p{NFKD_QC=y}', "");
Expect(1, 195101, '\p{^NFKD_QC=y}', "");
Expect(1, 195101, '\P{NFKD_QC=y}', "");
Expect(0, 195101, '\P{^NFKD_QC=y}', "");
Expect(1, 195102, '\p{NFKD_QC=-Y}', "");
Expect(0, 195102, '\p{^NFKD_QC=-Y}', "");
Expect(0, 195102, '\P{NFKD_QC=-Y}', "");
Expect(1, 195102, '\P{^NFKD_QC=-Y}', "");
Expect(0, 195101, '\p{NFKD_QC=-Y}', "");
Expect(1, 195101, '\p{^NFKD_QC=-Y}', "");
Expect(1, 195101, '\P{NFKD_QC=-Y}', "");
Expect(0, 195101, '\P{^NFKD_QC=-Y}', "");
Error('\p{Is_NFKD_Quick_Check=  yes/a/}');
Error('\P{Is_NFKD_Quick_Check=  yes/a/}');
Expect(1, 195102, '\p{Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\p{^Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195102, '\P{Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\P{^Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\p{Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\p{^Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195101, '\P{Is_NFKD_Quick_Check=yes}', "");
Expect(0, 195101, '\P{^Is_NFKD_Quick_Check=yes}', "");
Expect(1, 195102, '\p{Is_NFKD_Quick_Check:	_Yes}', "");
Expect(0, 195102, '\p{^Is_NFKD_Quick_Check:	_Yes}', "");
Expect(0, 195102, '\P{Is_NFKD_Quick_Check:	_Yes}', "");
Expect(1, 195102, '\P{^Is_NFKD_Quick_Check:	_Yes}', "");
Expect(0, 195101, '\p{Is_NFKD_Quick_Check:	_Yes}', "");
Expect(1, 195101, '\p{^Is_NFKD_Quick_Check:	_Yes}', "");
Expect(1, 195101, '\P{Is_NFKD_Quick_Check:	_Yes}', "");
Expect(0, 195101, '\P{^Is_NFKD_Quick_Check:	_Yes}', "");
Error('\p{Is_NFKD_QC=-:=Y}');
Error('\P{Is_NFKD_QC=-:=Y}');
Expect(1, 195102, '\p{Is_NFKD_QC:   y}', "");
Expect(0, 195102, '\p{^Is_NFKD_QC:   y}', "");
Expect(0, 195102, '\P{Is_NFKD_QC:   y}', "");
Expect(1, 195102, '\P{^Is_NFKD_QC:   y}', "");
Expect(0, 195101, '\p{Is_NFKD_QC:   y}', "");
Expect(1, 195101, '\p{^Is_NFKD_QC:   y}', "");
Expect(1, 195101, '\P{Is_NFKD_QC:   y}', "");
Expect(0, 195101, '\P{^Is_NFKD_QC:   y}', "");
Expect(1, 195102, '\p{Is_NFKD_QC=_Y}', "");
Expect(0, 195102, '\p{^Is_NFKD_QC=_Y}', "");
Expect(0, 195102, '\P{Is_NFKD_QC=_Y}', "");
Expect(1, 195102, '\P{^Is_NFKD_QC=_Y}', "");
Expect(0, 195101, '\p{Is_NFKD_QC=_Y}', "");
Expect(1, 195101, '\p{^Is_NFKD_QC=_Y}', "");
Expect(1, 195101, '\P{Is_NFKD_QC=_Y}', "");
Expect(0, 195101, '\P{^Is_NFKD_QC=_Y}', "");
Error('\p{Other_Alphabetic=No}');
Error('\P{Other_Alphabetic=No}');
Error('\p{OAlpha=N}');
Error('\P{OAlpha=N}');
Error('\p{Is_Other_Alphabetic=F}');
Error('\P{Is_Other_Alphabetic=F}');
Error('\p{Is_OAlpha=False}');
Error('\P{Is_OAlpha=False}');
Error('\p{Other_Alphabetic=Yes}');
Error('\P{Other_Alphabetic=Yes}');
Error('\p{OAlpha=Y}');
Error('\P{OAlpha=Y}');
Error('\p{Is_Other_Alphabetic=T}');
Error('\P{Is_Other_Alphabetic=T}');
Error('\p{Is_OAlpha=True}');
Error('\P{Is_OAlpha=True}');
Error('\p{Other_Default_Ignorable_Code_Point=No}');
Error('\P{Other_Default_Ignorable_Code_Point=No}');
Error('\p{ODI=N}');
Error('\P{ODI=N}');
Error('\p{Is_Other_Default_Ignorable_Code_Point=F}');
Error('\P{Is_Other_Default_Ignorable_Code_Point=F}');
Error('\p{Is_ODI=False}');
Error('\P{Is_ODI=False}');
Error('\p{Other_Default_Ignorable_Code_Point=Yes}');
Error('\P{Other_Default_Ignorable_Code_Point=Yes}');
Error('\p{ODI=Y}');
Error('\P{ODI=Y}');
Error('\p{Is_Other_Default_Ignorable_Code_Point=T}');
Error('\P{Is_Other_Default_Ignorable_Code_Point=T}');
Error('\p{Is_ODI=True}');
Error('\P{Is_ODI=True}');
Error('\p{Other_Grapheme_Extend=No}');
Error('\P{Other_Grapheme_Extend=No}');
Error('\p{OGr_Ext=N}');
Error('\P{OGr_Ext=N}');
Error('\p{Is_Other_Grapheme_Extend=F}');
Error('\P{Is_Other_Grapheme_Extend=F}');
Error('\p{Is_OGr_Ext=False}');
Error('\P{Is_OGr_Ext=False}');
Error('\p{Other_Grapheme_Extend=Yes}');
Error('\P{Other_Grapheme_Extend=Yes}');
Error('\p{OGr_Ext=Y}');
Error('\P{OGr_Ext=Y}');
Error('\p{Is_Other_Grapheme_Extend=T}');
Error('\P{Is_Other_Grapheme_Extend=T}');
Error('\p{Is_OGr_Ext=True}');
Error('\P{Is_OGr_Ext=True}');
Error('\p{Other_ID_Continue: No}');
Error('\P{Other_ID_Continue: No}');
Error('\p{OIDC=N}');
Error('\P{OIDC=N}');
Error('\p{Is_Other_ID_Continue=F}');
Error('\P{Is_Other_ID_Continue=F}');
Error('\p{Is_OIDC=False}');
Error('\P{Is_OIDC=False}');
Error('\p{Other_ID_Continue=Yes}');
Error('\P{Other_ID_Continue=Yes}');
Error('\p{OIDC=Y}');
Error('\P{OIDC=Y}');
Error('\p{Is_Other_ID_Continue:   T}');
Error('\P{Is_Other_ID_Continue:   T}');
Error('\p{Is_OIDC=True}');
Error('\P{Is_OIDC=True}');
Error('\p{Other_ID_Start=No}');
Error('\P{Other_ID_Start=No}');
Error('\p{OIDS: N}');
Error('\P{OIDS: N}');
Error('\p{Is_Other_ID_Start=F}');
Error('\P{Is_Other_ID_Start=F}');
Error('\p{Is_OIDS=False}');
Error('\P{Is_OIDS=False}');
Error('\p{Other_ID_Start: Yes}');
Error('\P{Other_ID_Start: Yes}');
Error('\p{OIDS:Y}');
Error('\P{OIDS:Y}');
Error('\p{Is_Other_ID_Start=T}');
Error('\P{Is_Other_ID_Start=T}');
Error('\p{Is_OIDS=True}');
Error('\P{Is_OIDS=True}');
Error('\p{Other_Lowercase=No}');
Error('\P{Other_Lowercase=No}');
Error('\p{OLower=N}');
Error('\P{OLower=N}');
Error('\p{Is_Other_Lowercase=F}');
Error('\P{Is_Other_Lowercase=F}');
Error('\p{Is_OLower=False}');
Error('\P{Is_OLower=False}');
Error('\p{Other_Lowercase=Yes}');
Error('\P{Other_Lowercase=Yes}');
Error('\p{OLower=Y}');
Error('\P{OLower=Y}');
Error('\p{Is_Other_Lowercase=T}');
Error('\P{Is_Other_Lowercase=T}');
Error('\p{Is_OLower:   True}');
Error('\P{Is_OLower:   True}');
Error('\p{Other_Math=No}');
Error('\P{Other_Math=No}');
Error('\p{OMath=N}');
Error('\P{OMath=N}');
Error('\p{Is_Other_Math=F}');
Error('\P{Is_Other_Math=F}');
Error('\p{Is_OMath=False}');
Error('\P{Is_OMath=False}');
Error('\p{Other_Math:Yes}');
Error('\P{Other_Math:Yes}');
Error('\p{OMath=Y}');
Error('\P{OMath=Y}');
Error('\p{Is_Other_Math:T}');
Error('\P{Is_Other_Math:T}');
Error('\p{Is_OMath: True}');
Error('\P{Is_OMath: True}');
Error('\p{Other_Uppercase=No}');
Error('\P{Other_Uppercase=No}');
Error('\p{OUpper=N}');
Error('\P{OUpper=N}');
Error('\p{Is_Other_Uppercase=F}');
Error('\P{Is_Other_Uppercase=F}');
Error('\p{Is_OUpper=False}');
Error('\P{Is_OUpper=False}');
Error('\p{Other_Uppercase=Yes}');
Error('\P{Other_Uppercase=Yes}');
Error('\p{OUpper=Y}');
Error('\P{OUpper=Y}');
Error('\p{Is_Other_Uppercase:	T}');
Error('\P{Is_Other_Uppercase:	T}');
Error('\p{Is_OUpper=True}');
Error('\P{Is_OUpper=True}');
Error('\p{Pattern_Syntax=	/a/No}');
Error('\P{Pattern_Syntax=	/a/No}');
Expect(1, 65095, '\p{Pattern_Syntax=no}', "");
Expect(0, 65095, '\p{^Pattern_Syntax=no}', "");
Expect(0, 65095, '\P{Pattern_Syntax=no}', "");
Expect(1, 65095, '\P{^Pattern_Syntax=no}', "");
Expect(0, 65094, '\p{Pattern_Syntax=no}', "");
Expect(1, 65094, '\p{^Pattern_Syntax=no}', "");
Expect(1, 65094, '\P{Pattern_Syntax=no}', "");
Expect(0, 65094, '\P{^Pattern_Syntax=no}', "");
Expect(1, 65095, '\p{Pattern_Syntax=_	no}', "");
Expect(0, 65095, '\p{^Pattern_Syntax=_	no}', "");
Expect(0, 65095, '\P{Pattern_Syntax=_	no}', "");
Expect(1, 65095, '\P{^Pattern_Syntax=_	no}', "");
Expect(0, 65094, '\p{Pattern_Syntax=_	no}', "");
Expect(1, 65094, '\p{^Pattern_Syntax=_	no}', "");
Expect(1, 65094, '\P{Pattern_Syntax=_	no}', "");
Expect(0, 65094, '\P{^Pattern_Syntax=_	no}', "");
Error('\p{Pat_Syn=	 N/a/}');
Error('\P{Pat_Syn=	 N/a/}');
Expect(1, 65095, '\p{Pat_Syn=n}', "");
Expect(0, 65095, '\p{^Pat_Syn=n}', "");
Expect(0, 65095, '\P{Pat_Syn=n}', "");
Expect(1, 65095, '\P{^Pat_Syn=n}', "");
Expect(0, 65094, '\p{Pat_Syn=n}', "");
Expect(1, 65094, '\p{^Pat_Syn=n}', "");
Expect(1, 65094, '\P{Pat_Syn=n}', "");
Expect(0, 65094, '\P{^Pat_Syn=n}', "");
Expect(1, 65095, '\p{Pat_Syn=-N}', "");
Expect(0, 65095, '\p{^Pat_Syn=-N}', "");
Expect(0, 65095, '\P{Pat_Syn=-N}', "");
Expect(1, 65095, '\P{^Pat_Syn=-N}', "");
Expect(0, 65094, '\p{Pat_Syn=-N}', "");
Expect(1, 65094, '\p{^Pat_Syn=-N}', "");
Expect(1, 65094, '\P{Pat_Syn=-N}', "");
Expect(0, 65094, '\P{^Pat_Syn=-N}', "");
Error('\p{Is_Pattern_Syntax=/a/-F}');
Error('\P{Is_Pattern_Syntax=/a/-F}');
Expect(1, 65095, '\p{Is_Pattern_Syntax=f}', "");
Expect(0, 65095, '\p{^Is_Pattern_Syntax=f}', "");
Expect(0, 65095, '\P{Is_Pattern_Syntax=f}', "");
Expect(1, 65095, '\P{^Is_Pattern_Syntax=f}', "");
Expect(0, 65094, '\p{Is_Pattern_Syntax=f}', "");
Expect(1, 65094, '\p{^Is_Pattern_Syntax=f}', "");
Expect(1, 65094, '\P{Is_Pattern_Syntax=f}', "");
Expect(0, 65094, '\P{^Is_Pattern_Syntax=f}', "");
Expect(1, 65095, '\p{Is_Pattern_Syntax=-_F}', "");
Expect(0, 65095, '\p{^Is_Pattern_Syntax=-_F}', "");
Expect(0, 65095, '\P{Is_Pattern_Syntax=-_F}', "");
Expect(1, 65095, '\P{^Is_Pattern_Syntax=-_F}', "");
Expect(0, 65094, '\p{Is_Pattern_Syntax=-_F}', "");
Expect(1, 65094, '\p{^Is_Pattern_Syntax=-_F}', "");
Expect(1, 65094, '\P{Is_Pattern_Syntax=-_F}', "");
Expect(0, 65094, '\P{^Is_Pattern_Syntax=-_F}', "");
Error('\p{Is_Pat_Syn=/a/False}');
Error('\P{Is_Pat_Syn=/a/False}');
Expect(1, 65095, '\p{Is_Pat_Syn=false}', "");
Expect(0, 65095, '\p{^Is_Pat_Syn=false}', "");
Expect(0, 65095, '\P{Is_Pat_Syn=false}', "");
Expect(1, 65095, '\P{^Is_Pat_Syn=false}', "");
Expect(0, 65094, '\p{Is_Pat_Syn=false}', "");
Expect(1, 65094, '\p{^Is_Pat_Syn=false}', "");
Expect(1, 65094, '\P{Is_Pat_Syn=false}', "");
Expect(0, 65094, '\P{^Is_Pat_Syn=false}', "");
Expect(1, 65095, '\p{Is_Pat_Syn:-_false}', "");
Expect(0, 65095, '\p{^Is_Pat_Syn:-_false}', "");
Expect(0, 65095, '\P{Is_Pat_Syn:-_false}', "");
Expect(1, 65095, '\P{^Is_Pat_Syn:-_false}', "");
Expect(0, 65094, '\p{Is_Pat_Syn:-_false}', "");
Expect(1, 65094, '\p{^Is_Pat_Syn:-_false}', "");
Expect(1, 65094, '\P{Is_Pat_Syn:-_false}', "");
Expect(0, 65094, '\P{^Is_Pat_Syn:-_false}', "");
Error('\p{Pattern_Syntax=- yes/a/}');
Error('\P{Pattern_Syntax=- yes/a/}');
Expect(1, 65094, '\p{Pattern_Syntax=yes}', "");
Expect(0, 65094, '\p{^Pattern_Syntax=yes}', "");
Expect(0, 65094, '\P{Pattern_Syntax=yes}', "");
Expect(1, 65094, '\P{^Pattern_Syntax=yes}', "");
Expect(0, 65095, '\p{Pattern_Syntax=yes}', "");
Expect(1, 65095, '\p{^Pattern_Syntax=yes}', "");
Expect(1, 65095, '\P{Pattern_Syntax=yes}', "");
Expect(0, 65095, '\P{^Pattern_Syntax=yes}', "");
Expect(1, 65094, '\p{Pattern_Syntax=_	yes}', "");
Expect(0, 65094, '\p{^Pattern_Syntax=_	yes}', "");
Expect(0, 65094, '\P{Pattern_Syntax=_	yes}', "");
Expect(1, 65094, '\P{^Pattern_Syntax=_	yes}', "");
Expect(0, 65095, '\p{Pattern_Syntax=_	yes}', "");
Expect(1, 65095, '\p{^Pattern_Syntax=_	yes}', "");
Expect(1, 65095, '\P{Pattern_Syntax=_	yes}', "");
Expect(0, 65095, '\P{^Pattern_Syntax=_	yes}', "");
Error('\p{Pat_Syn=		Y:=}');
Error('\P{Pat_Syn=		Y:=}');
Expect(1, 65094, '\p{Pat_Syn=y}', "");
Expect(0, 65094, '\p{^Pat_Syn=y}', "");
Expect(0, 65094, '\P{Pat_Syn=y}', "");
Expect(1, 65094, '\P{^Pat_Syn=y}', "");
Expect(0, 65095, '\p{Pat_Syn=y}', "");
Expect(1, 65095, '\p{^Pat_Syn=y}', "");
Expect(1, 65095, '\P{Pat_Syn=y}', "");
Expect(0, 65095, '\P{^Pat_Syn=y}', "");
Expect(1, 65094, '\p{Pat_Syn= _Y}', "");
Expect(0, 65094, '\p{^Pat_Syn= _Y}', "");
Expect(0, 65094, '\P{Pat_Syn= _Y}', "");
Expect(1, 65094, '\P{^Pat_Syn= _Y}', "");
Expect(0, 65095, '\p{Pat_Syn= _Y}', "");
Expect(1, 65095, '\p{^Pat_Syn= _Y}', "");
Expect(1, 65095, '\P{Pat_Syn= _Y}', "");
Expect(0, 65095, '\P{^Pat_Syn= _Y}', "");
Error('\p{Is_Pattern_Syntax:   _/a/T}');
Error('\P{Is_Pattern_Syntax:   _/a/T}');
Expect(1, 65094, '\p{Is_Pattern_Syntax=t}', "");
Expect(0, 65094, '\p{^Is_Pattern_Syntax=t}', "");
Expect(0, 65094, '\P{Is_Pattern_Syntax=t}', "");
Expect(1, 65094, '\P{^Is_Pattern_Syntax=t}', "");
Expect(0, 65095, '\p{Is_Pattern_Syntax=t}', "");
Expect(1, 65095, '\p{^Is_Pattern_Syntax=t}', "");
Expect(1, 65095, '\P{Is_Pattern_Syntax=t}', "");
Expect(0, 65095, '\P{^Is_Pattern_Syntax=t}', "");
Expect(1, 65094, '\p{Is_Pattern_Syntax=	 T}', "");
Expect(0, 65094, '\p{^Is_Pattern_Syntax=	 T}', "");
Expect(0, 65094, '\P{Is_Pattern_Syntax=	 T}', "");
Expect(1, 65094, '\P{^Is_Pattern_Syntax=	 T}', "");
Expect(0, 65095, '\p{Is_Pattern_Syntax=	 T}', "");
Expect(1, 65095, '\p{^Is_Pattern_Syntax=	 T}', "");
Expect(1, 65095, '\P{Is_Pattern_Syntax=	 T}', "");
Expect(0, 65095, '\P{^Is_Pattern_Syntax=	 T}', "");
Error('\p{Is_Pat_Syn=:=--true}');
Error('\P{Is_Pat_Syn=:=--true}');
Expect(1, 65094, '\p{Is_Pat_Syn=true}', "");
Expect(0, 65094, '\p{^Is_Pat_Syn=true}', "");
Expect(0, 65094, '\P{Is_Pat_Syn=true}', "");
Expect(1, 65094, '\P{^Is_Pat_Syn=true}', "");
Expect(0, 65095, '\p{Is_Pat_Syn=true}', "");
Expect(1, 65095, '\p{^Is_Pat_Syn=true}', "");
Expect(1, 65095, '\P{Is_Pat_Syn=true}', "");
Expect(0, 65095, '\P{^Is_Pat_Syn=true}', "");
Expect(1, 65094, '\p{Is_Pat_Syn=_ True}', "");
Expect(0, 65094, '\p{^Is_Pat_Syn=_ True}', "");
Expect(0, 65094, '\P{Is_Pat_Syn=_ True}', "");
Expect(1, 65094, '\P{^Is_Pat_Syn=_ True}', "");
Expect(0, 65095, '\p{Is_Pat_Syn=_ True}', "");
Expect(1, 65095, '\p{^Is_Pat_Syn=_ True}', "");
Expect(1, 65095, '\P{Is_Pat_Syn=_ True}', "");
Expect(0, 65095, '\P{^Is_Pat_Syn=_ True}', "");
Error('\p{Pattern_White_Space=		No:=}');
Error('\P{Pattern_White_Space=		No:=}');
Expect(1, 8234, '\p{Pattern_White_Space=no}', "");
Expect(0, 8234, '\p{^Pattern_White_Space=no}', "");
Expect(0, 8234, '\P{Pattern_White_Space=no}', "");
Expect(1, 8234, '\P{^Pattern_White_Space=no}', "");
Expect(0, 8233, '\p{Pattern_White_Space=no}', "");
Expect(1, 8233, '\p{^Pattern_White_Space=no}', "");
Expect(1, 8233, '\P{Pattern_White_Space=no}', "");
Expect(0, 8233, '\P{^Pattern_White_Space=no}', "");
Expect(1, 8234, '\p{Pattern_White_Space=--no}', "");
Expect(0, 8234, '\p{^Pattern_White_Space=--no}', "");
Expect(0, 8234, '\P{Pattern_White_Space=--no}', "");
Expect(1, 8234, '\P{^Pattern_White_Space=--no}', "");
Expect(0, 8233, '\p{Pattern_White_Space=--no}', "");
Expect(1, 8233, '\p{^Pattern_White_Space=--no}', "");
Expect(1, 8233, '\P{Pattern_White_Space=--no}', "");
Expect(0, 8233, '\P{^Pattern_White_Space=--no}', "");
Error('\p{Pat_WS=  N/a/}');
Error('\P{Pat_WS=  N/a/}');
Expect(1, 8234, '\p{Pat_WS=n}', "");
Expect(0, 8234, '\p{^Pat_WS=n}', "");
Expect(0, 8234, '\P{Pat_WS=n}', "");
Expect(1, 8234, '\P{^Pat_WS=n}', "");
Expect(0, 8233, '\p{Pat_WS=n}', "");
Expect(1, 8233, '\p{^Pat_WS=n}', "");
Expect(1, 8233, '\P{Pat_WS=n}', "");
Expect(0, 8233, '\P{^Pat_WS=n}', "");
Expect(1, 8234, '\p{Pat_WS=_n}', "");
Expect(0, 8234, '\p{^Pat_WS=_n}', "");
Expect(0, 8234, '\P{Pat_WS=_n}', "");
Expect(1, 8234, '\P{^Pat_WS=_n}', "");
Expect(0, 8233, '\p{Pat_WS=_n}', "");
Expect(1, 8233, '\p{^Pat_WS=_n}', "");
Expect(1, 8233, '\P{Pat_WS=_n}', "");
Expect(0, 8233, '\P{^Pat_WS=_n}', "");
Error('\p{Is_Pattern_White_Space=_/a/F}');
Error('\P{Is_Pattern_White_Space=_/a/F}');
Expect(1, 8234, '\p{Is_Pattern_White_Space:	f}', "");
Expect(0, 8234, '\p{^Is_Pattern_White_Space:	f}', "");
Expect(0, 8234, '\P{Is_Pattern_White_Space:	f}', "");
Expect(1, 8234, '\P{^Is_Pattern_White_Space:	f}', "");
Expect(0, 8233, '\p{Is_Pattern_White_Space:	f}', "");
Expect(1, 8233, '\p{^Is_Pattern_White_Space:	f}', "");
Expect(1, 8233, '\P{Is_Pattern_White_Space:	f}', "");
Expect(0, 8233, '\P{^Is_Pattern_White_Space:	f}', "");
Expect(1, 8234, '\p{Is_Pattern_White_Space=_ F}', "");
Expect(0, 8234, '\p{^Is_Pattern_White_Space=_ F}', "");
Expect(0, 8234, '\P{Is_Pattern_White_Space=_ F}', "");
Expect(1, 8234, '\P{^Is_Pattern_White_Space=_ F}', "");
Expect(0, 8233, '\p{Is_Pattern_White_Space=_ F}', "");
Expect(1, 8233, '\p{^Is_Pattern_White_Space=_ F}', "");
Expect(1, 8233, '\P{Is_Pattern_White_Space=_ F}', "");
Expect(0, 8233, '\P{^Is_Pattern_White_Space=_ F}', "");
Error('\p{Is_Pat_WS=	/a/False}');
Error('\P{Is_Pat_WS=	/a/False}');
Expect(1, 8234, '\p{Is_Pat_WS=false}', "");
Expect(0, 8234, '\p{^Is_Pat_WS=false}', "");
Expect(0, 8234, '\P{Is_Pat_WS=false}', "");
Expect(1, 8234, '\P{^Is_Pat_WS=false}', "");
Expect(0, 8233, '\p{Is_Pat_WS=false}', "");
Expect(1, 8233, '\p{^Is_Pat_WS=false}', "");
Expect(1, 8233, '\P{Is_Pat_WS=false}', "");
Expect(0, 8233, '\P{^Is_Pat_WS=false}', "");
Expect(1, 8234, '\p{Is_Pat_WS=__False}', "");
Expect(0, 8234, '\p{^Is_Pat_WS=__False}', "");
Expect(0, 8234, '\P{Is_Pat_WS=__False}', "");
Expect(1, 8234, '\P{^Is_Pat_WS=__False}', "");
Expect(0, 8233, '\p{Is_Pat_WS=__False}', "");
Expect(1, 8233, '\p{^Is_Pat_WS=__False}', "");
Expect(1, 8233, '\P{Is_Pat_WS=__False}', "");
Expect(0, 8233, '\P{^Is_Pat_WS=__False}', "");
Error('\p{Pattern_White_Space=_/a/yes}');
Error('\P{Pattern_White_Space=_/a/yes}');
Expect(1, 8233, '\p{Pattern_White_Space=yes}', "");
Expect(0, 8233, '\p{^Pattern_White_Space=yes}', "");
Expect(0, 8233, '\P{Pattern_White_Space=yes}', "");
Expect(1, 8233, '\P{^Pattern_White_Space=yes}', "");
Expect(0, 8234, '\p{Pattern_White_Space=yes}', "");
Expect(1, 8234, '\p{^Pattern_White_Space=yes}', "");
Expect(1, 8234, '\P{Pattern_White_Space=yes}', "");
Expect(0, 8234, '\P{^Pattern_White_Space=yes}', "");
Expect(1, 8233, '\p{Pattern_White_Space=_ YES}', "");
Expect(0, 8233, '\p{^Pattern_White_Space=_ YES}', "");
Expect(0, 8233, '\P{Pattern_White_Space=_ YES}', "");
Expect(1, 8233, '\P{^Pattern_White_Space=_ YES}', "");
Expect(0, 8234, '\p{Pattern_White_Space=_ YES}', "");
Expect(1, 8234, '\p{^Pattern_White_Space=_ YES}', "");
Expect(1, 8234, '\P{Pattern_White_Space=_ YES}', "");
Expect(0, 8234, '\P{^Pattern_White_Space=_ YES}', "");
Error('\p{Pat_WS=_Y:=}');
Error('\P{Pat_WS=_Y:=}');
Expect(1, 8233, '\p{Pat_WS=y}', "");
Expect(0, 8233, '\p{^Pat_WS=y}', "");
Expect(0, 8233, '\P{Pat_WS=y}', "");
Expect(1, 8233, '\P{^Pat_WS=y}', "");
Expect(0, 8234, '\p{Pat_WS=y}', "");
Expect(1, 8234, '\p{^Pat_WS=y}', "");
Expect(1, 8234, '\P{Pat_WS=y}', "");
Expect(0, 8234, '\P{^Pat_WS=y}', "");
Expect(1, 8233, '\p{Pat_WS=- Y}', "");
Expect(0, 8233, '\p{^Pat_WS=- Y}', "");
Expect(0, 8233, '\P{Pat_WS=- Y}', "");
Expect(1, 8233, '\P{^Pat_WS=- Y}', "");
Expect(0, 8234, '\p{Pat_WS=- Y}', "");
Expect(1, 8234, '\p{^Pat_WS=- Y}', "");
Expect(1, 8234, '\P{Pat_WS=- Y}', "");
Expect(0, 8234, '\P{^Pat_WS=- Y}', "");
Error('\p{Is_Pattern_White_Space=:=	 t}');
Error('\P{Is_Pattern_White_Space=:=	 t}');
Expect(1, 8233, '\p{Is_Pattern_White_Space=t}', "");
Expect(0, 8233, '\p{^Is_Pattern_White_Space=t}', "");
Expect(0, 8233, '\P{Is_Pattern_White_Space=t}', "");
Expect(1, 8233, '\P{^Is_Pattern_White_Space=t}', "");
Expect(0, 8234, '\p{Is_Pattern_White_Space=t}', "");
Expect(1, 8234, '\p{^Is_Pattern_White_Space=t}', "");
Expect(1, 8234, '\P{Is_Pattern_White_Space=t}', "");
Expect(0, 8234, '\P{^Is_Pattern_White_Space=t}', "");
Expect(1, 8233, '\p{Is_Pattern_White_Space=	T}', "");
Expect(0, 8233, '\p{^Is_Pattern_White_Space=	T}', "");
Expect(0, 8233, '\P{Is_Pattern_White_Space=	T}', "");
Expect(1, 8233, '\P{^Is_Pattern_White_Space=	T}', "");
Expect(0, 8234, '\p{Is_Pattern_White_Space=	T}', "");
Expect(1, 8234, '\p{^Is_Pattern_White_Space=	T}', "");
Expect(1, 8234, '\P{Is_Pattern_White_Space=	T}', "");
Expect(0, 8234, '\P{^Is_Pattern_White_Space=	T}', "");
Error('\p{Is_Pat_WS=	-True/a/}');
Error('\P{Is_Pat_WS=	-True/a/}');
Expect(1, 8233, '\p{Is_Pat_WS=true}', "");
Expect(0, 8233, '\p{^Is_Pat_WS=true}', "");
Expect(0, 8233, '\P{Is_Pat_WS=true}', "");
Expect(1, 8233, '\P{^Is_Pat_WS=true}', "");
Expect(0, 8234, '\p{Is_Pat_WS=true}', "");
Expect(1, 8234, '\p{^Is_Pat_WS=true}', "");
Expect(1, 8234, '\P{Is_Pat_WS=true}', "");
Expect(0, 8234, '\P{^Is_Pat_WS=true}', "");
Expect(1, 8233, '\p{Is_Pat_WS=-	True}', "");
Expect(0, 8233, '\p{^Is_Pat_WS=-	True}', "");
Expect(0, 8233, '\P{Is_Pat_WS=-	True}', "");
Expect(1, 8233, '\P{^Is_Pat_WS=-	True}', "");
Expect(0, 8234, '\p{Is_Pat_WS=-	True}', "");
Expect(1, 8234, '\p{^Is_Pat_WS=-	True}', "");
Expect(1, 8234, '\P{Is_Pat_WS=-	True}', "");
Expect(0, 8234, '\P{^Is_Pat_WS=-	True}', "");
Error('\p{Quotation_Mark=	/a/no}');
Error('\P{Quotation_Mark=	/a/no}');
Expect(1, 65380, '\p{Quotation_Mark=no}', "");
Expect(0, 65380, '\p{^Quotation_Mark=no}', "");
Expect(0, 65380, '\P{Quotation_Mark=no}', "");
Expect(1, 65380, '\P{^Quotation_Mark=no}', "");
Expect(0, 65379, '\p{Quotation_Mark=no}', "");
Expect(1, 65379, '\p{^Quotation_Mark=no}', "");
Expect(1, 65379, '\P{Quotation_Mark=no}', "");
Expect(0, 65379, '\P{^Quotation_Mark=no}', "");
Expect(1, 65380, '\p{Quotation_Mark=- No}', "");
Expect(0, 65380, '\p{^Quotation_Mark=- No}', "");
Expect(0, 65380, '\P{Quotation_Mark=- No}', "");
Expect(1, 65380, '\P{^Quotation_Mark=- No}', "");
Expect(0, 65379, '\p{Quotation_Mark=- No}', "");
Expect(1, 65379, '\p{^Quotation_Mark=- No}', "");
Expect(1, 65379, '\P{Quotation_Mark=- No}', "");
Expect(0, 65379, '\P{^Quotation_Mark=- No}', "");
Error('\p{QMark= _N:=}');
Error('\P{QMark= _N:=}');
Expect(1, 65380, '\p{QMark:n}', "");
Expect(0, 65380, '\p{^QMark:n}', "");
Expect(0, 65380, '\P{QMark:n}', "");
Expect(1, 65380, '\P{^QMark:n}', "");
Expect(0, 65379, '\p{QMark:n}', "");
Expect(1, 65379, '\p{^QMark:n}', "");
Expect(1, 65379, '\P{QMark:n}', "");
Expect(0, 65379, '\P{^QMark:n}', "");
Expect(1, 65380, '\p{QMark:   		N}', "");
Expect(0, 65380, '\p{^QMark:   		N}', "");
Expect(0, 65380, '\P{QMark:   		N}', "");
Expect(1, 65380, '\P{^QMark:   		N}', "");
Expect(0, 65379, '\p{QMark:   		N}', "");
Expect(1, 65379, '\p{^QMark:   		N}', "");
Expect(1, 65379, '\P{QMark:   		N}', "");
Expect(0, 65379, '\P{^QMark:   		N}', "");
Error('\p{Is_Quotation_Mark= F:=}');
Error('\P{Is_Quotation_Mark= F:=}');
Expect(1, 65380, '\p{Is_Quotation_Mark=f}', "");
Expect(0, 65380, '\p{^Is_Quotation_Mark=f}', "");
Expect(0, 65380, '\P{Is_Quotation_Mark=f}', "");
Expect(1, 65380, '\P{^Is_Quotation_Mark=f}', "");
Expect(0, 65379, '\p{Is_Quotation_Mark=f}', "");
Expect(1, 65379, '\p{^Is_Quotation_Mark=f}', "");
Expect(1, 65379, '\P{Is_Quotation_Mark=f}', "");
Expect(0, 65379, '\P{^Is_Quotation_Mark=f}', "");
Expect(1, 65380, '\p{Is_Quotation_Mark=-F}', "");
Expect(0, 65380, '\p{^Is_Quotation_Mark=-F}', "");
Expect(0, 65380, '\P{Is_Quotation_Mark=-F}', "");
Expect(1, 65380, '\P{^Is_Quotation_Mark=-F}', "");
Expect(0, 65379, '\p{Is_Quotation_Mark=-F}', "");
Expect(1, 65379, '\p{^Is_Quotation_Mark=-F}', "");
Expect(1, 65379, '\P{Is_Quotation_Mark=-F}', "");
Expect(0, 65379, '\P{^Is_Quotation_Mark=-F}', "");
Error('\p{Is_QMark=:=-false}');
Error('\P{Is_QMark=:=-false}');
Expect(1, 65380, '\p{Is_QMark=false}', "");
Expect(0, 65380, '\p{^Is_QMark=false}', "");
Expect(0, 65380, '\P{Is_QMark=false}', "");
Expect(1, 65380, '\P{^Is_QMark=false}', "");
Expect(0, 65379, '\p{Is_QMark=false}', "");
Expect(1, 65379, '\p{^Is_QMark=false}', "");
Expect(1, 65379, '\P{Is_QMark=false}', "");
Expect(0, 65379, '\P{^Is_QMark=false}', "");
Expect(1, 65380, '\p{Is_QMark: -FALSE}', "");
Expect(0, 65380, '\p{^Is_QMark: -FALSE}', "");
Expect(0, 65380, '\P{Is_QMark: -FALSE}', "");
Expect(1, 65380, '\P{^Is_QMark: -FALSE}', "");
Expect(0, 65379, '\p{Is_QMark: -FALSE}', "");
Expect(1, 65379, '\p{^Is_QMark: -FALSE}', "");
Expect(1, 65379, '\P{Is_QMark: -FALSE}', "");
Expect(0, 65379, '\P{^Is_QMark: -FALSE}', "");
Error('\p{Quotation_Mark=_-YES/a/}');
Error('\P{Quotation_Mark=_-YES/a/}');
Expect(1, 65379, '\p{Quotation_Mark=yes}', "");
Expect(0, 65379, '\p{^Quotation_Mark=yes}', "");
Expect(0, 65379, '\P{Quotation_Mark=yes}', "");
Expect(1, 65379, '\P{^Quotation_Mark=yes}', "");
Expect(0, 65380, '\p{Quotation_Mark=yes}', "");
Expect(1, 65380, '\p{^Quotation_Mark=yes}', "");
Expect(1, 65380, '\P{Quotation_Mark=yes}', "");
Expect(0, 65380, '\P{^Quotation_Mark=yes}', "");
Expect(1, 65379, '\p{Quotation_Mark=	YES}', "");
Expect(0, 65379, '\p{^Quotation_Mark=	YES}', "");
Expect(0, 65379, '\P{Quotation_Mark=	YES}', "");
Expect(1, 65379, '\P{^Quotation_Mark=	YES}', "");
Expect(0, 65380, '\p{Quotation_Mark=	YES}', "");
Expect(1, 65380, '\p{^Quotation_Mark=	YES}', "");
Expect(1, 65380, '\P{Quotation_Mark=	YES}', "");
Expect(0, 65380, '\P{^Quotation_Mark=	YES}', "");
Error('\p{QMark= /a/Y}');
Error('\P{QMark= /a/Y}');
Expect(1, 65379, '\p{QMark=y}', "");
Expect(0, 65379, '\p{^QMark=y}', "");
Expect(0, 65379, '\P{QMark=y}', "");
Expect(1, 65379, '\P{^QMark=y}', "");
Expect(0, 65380, '\p{QMark=y}', "");
Expect(1, 65380, '\p{^QMark=y}', "");
Expect(1, 65380, '\P{QMark=y}', "");
Expect(0, 65380, '\P{^QMark=y}', "");
Error('\p{Is_Quotation_Mark::= t}');
Error('\P{Is_Quotation_Mark::= t}');
Expect(1, 65379, '\p{Is_Quotation_Mark=t}', "");
Expect(0, 65379, '\p{^Is_Quotation_Mark=t}', "");
Expect(0, 65379, '\P{Is_Quotation_Mark=t}', "");
Expect(1, 65379, '\P{^Is_Quotation_Mark=t}', "");
Expect(0, 65380, '\p{Is_Quotation_Mark=t}', "");
Expect(1, 65380, '\p{^Is_Quotation_Mark=t}', "");
Expect(1, 65380, '\P{Is_Quotation_Mark=t}', "");
Expect(0, 65380, '\P{^Is_Quotation_Mark=t}', "");
Expect(1, 65379, '\p{Is_Quotation_Mark=_	T}', "");
Expect(0, 65379, '\p{^Is_Quotation_Mark=_	T}', "");
Expect(0, 65379, '\P{Is_Quotation_Mark=_	T}', "");
Expect(1, 65379, '\P{^Is_Quotation_Mark=_	T}', "");
Expect(0, 65380, '\p{Is_Quotation_Mark=_	T}', "");
Expect(1, 65380, '\p{^Is_Quotation_Mark=_	T}', "");
Expect(1, 65380, '\P{Is_Quotation_Mark=_	T}', "");
Expect(0, 65380, '\P{^Is_Quotation_Mark=_	T}', "");
Error('\p{Is_QMark= True/a/}');
Error('\P{Is_QMark= True/a/}');
Expect(1, 65379, '\p{Is_QMark:   true}', "");
Expect(0, 65379, '\p{^Is_QMark:   true}', "");
Expect(0, 65379, '\P{Is_QMark:   true}', "");
Expect(1, 65379, '\P{^Is_QMark:   true}', "");
Expect(0, 65380, '\p{Is_QMark:   true}', "");
Expect(1, 65380, '\p{^Is_QMark:   true}', "");
Expect(1, 65380, '\P{Is_QMark:   true}', "");
Expect(0, 65380, '\P{^Is_QMark:   true}', "");
Expect(1, 65379, '\p{Is_QMark=	_True}', "");
Expect(0, 65379, '\p{^Is_QMark=	_True}', "");
Expect(0, 65379, '\P{Is_QMark=	_True}', "");
Expect(1, 65379, '\P{^Is_QMark=	_True}', "");
Expect(0, 65380, '\p{Is_QMark=	_True}', "");
Expect(1, 65380, '\p{^Is_QMark=	_True}', "");
Expect(1, 65380, '\P{Is_QMark=	_True}', "");
Expect(0, 65380, '\P{^Is_QMark=	_True}', "");
Error('\p{Radical:  	no/a/}');
Error('\P{Radical:  	no/a/}');
Expect(1, 12246, '\p{Radical=no}', "");
Expect(0, 12246, '\p{^Radical=no}', "");
Expect(0, 12246, '\P{Radical=no}', "");
Expect(1, 12246, '\P{^Radical=no}', "");
Expect(0, 12245, '\p{Radical=no}', "");
Expect(1, 12245, '\p{^Radical=no}', "");
Expect(1, 12245, '\P{Radical=no}', "");
Expect(0, 12245, '\P{^Radical=no}', "");
Expect(1, 12246, '\p{Radical=	No}', "");
Expect(0, 12246, '\p{^Radical=	No}', "");
Expect(0, 12246, '\P{Radical=	No}', "");
Expect(1, 12246, '\P{^Radical=	No}', "");
Expect(0, 12245, '\p{Radical=	No}', "");
Expect(1, 12245, '\p{^Radical=	No}', "");
Expect(1, 12245, '\P{Radical=	No}', "");
Expect(0, 12245, '\P{^Radical=	No}', "");
Error('\p{Is_Radical= N:=}');
Error('\P{Is_Radical= N:=}');
Expect(1, 12246, '\p{Is_Radical=n}', "");
Expect(0, 12246, '\p{^Is_Radical=n}', "");
Expect(0, 12246, '\P{Is_Radical=n}', "");
Expect(1, 12246, '\P{^Is_Radical=n}', "");
Expect(0, 12245, '\p{Is_Radical=n}', "");
Expect(1, 12245, '\p{^Is_Radical=n}', "");
Expect(1, 12245, '\P{Is_Radical=n}', "");
Expect(0, 12245, '\P{^Is_Radical=n}', "");
Expect(1, 12246, '\p{Is_Radical=		N}', "");
Expect(0, 12246, '\p{^Is_Radical=		N}', "");
Expect(0, 12246, '\P{Is_Radical=		N}', "");
Expect(1, 12246, '\P{^Is_Radical=		N}', "");
Expect(0, 12245, '\p{Is_Radical=		N}', "");
Expect(1, 12245, '\p{^Is_Radical=		N}', "");
Expect(1, 12245, '\P{Is_Radical=		N}', "");
Expect(0, 12245, '\P{^Is_Radical=		N}', "");
Error('\p{Radical=-f/a/}');
Error('\P{Radical=-f/a/}');
Expect(1, 12246, '\p{Radical=f}', "");
Expect(0, 12246, '\p{^Radical=f}', "");
Expect(0, 12246, '\P{Radical=f}', "");
Expect(1, 12246, '\P{^Radical=f}', "");
Expect(0, 12245, '\p{Radical=f}', "");
Expect(1, 12245, '\p{^Radical=f}', "");
Expect(1, 12245, '\P{Radical=f}', "");
Expect(0, 12245, '\P{^Radical=f}', "");
Expect(1, 12246, '\p{Radical=	_F}', "");
Expect(0, 12246, '\p{^Radical=	_F}', "");
Expect(0, 12246, '\P{Radical=	_F}', "");
Expect(1, 12246, '\P{^Radical=	_F}', "");
Expect(0, 12245, '\p{Radical=	_F}', "");
Expect(1, 12245, '\p{^Radical=	_F}', "");
Expect(1, 12245, '\P{Radical=	_F}', "");
Expect(0, 12245, '\P{^Radical=	_F}', "");
Error('\p{Is_Radical=/a/		false}');
Error('\P{Is_Radical=/a/		false}');
Expect(1, 12246, '\p{Is_Radical=false}', "");
Expect(0, 12246, '\p{^Is_Radical=false}', "");
Expect(0, 12246, '\P{Is_Radical=false}', "");
Expect(1, 12246, '\P{^Is_Radical=false}', "");
Expect(0, 12245, '\p{Is_Radical=false}', "");
Expect(1, 12245, '\p{^Is_Radical=false}', "");
Expect(1, 12245, '\P{Is_Radical=false}', "");
Expect(0, 12245, '\P{^Is_Radical=false}', "");
Expect(1, 12246, '\p{Is_Radical= -FALSE}', "");
Expect(0, 12246, '\p{^Is_Radical= -FALSE}', "");
Expect(0, 12246, '\P{Is_Radical= -FALSE}', "");
Expect(1, 12246, '\P{^Is_Radical= -FALSE}', "");
Expect(0, 12245, '\p{Is_Radical= -FALSE}', "");
Expect(1, 12245, '\p{^Is_Radical= -FALSE}', "");
Expect(1, 12245, '\P{Is_Radical= -FALSE}', "");
Expect(0, 12245, '\P{^Is_Radical= -FALSE}', "");
Error('\p{Radical=--yes:=}');
Error('\P{Radical=--yes:=}');
Expect(1, 12245, '\p{Radical=yes}', "");
Expect(0, 12245, '\p{^Radical=yes}', "");
Expect(0, 12245, '\P{Radical=yes}', "");
Expect(1, 12245, '\P{^Radical=yes}', "");
Expect(0, 12246, '\p{Radical=yes}', "");
Expect(1, 12246, '\p{^Radical=yes}', "");
Expect(1, 12246, '\P{Radical=yes}', "");
Expect(0, 12246, '\P{^Radical=yes}', "");
Expect(1, 12245, '\p{Radical=-Yes}', "");
Expect(0, 12245, '\p{^Radical=-Yes}', "");
Expect(0, 12245, '\P{Radical=-Yes}', "");
Expect(1, 12245, '\P{^Radical=-Yes}', "");
Expect(0, 12246, '\p{Radical=-Yes}', "");
Expect(1, 12246, '\p{^Radical=-Yes}', "");
Expect(1, 12246, '\P{Radical=-Yes}', "");
Expect(0, 12246, '\P{^Radical=-Yes}', "");
Error('\p{Is_Radical=_ y:=}');
Error('\P{Is_Radical=_ y:=}');
Expect(1, 12245, '\p{Is_Radical=y}', "");
Expect(0, 12245, '\p{^Is_Radical=y}', "");
Expect(0, 12245, '\P{Is_Radical=y}', "");
Expect(1, 12245, '\P{^Is_Radical=y}', "");
Expect(0, 12246, '\p{Is_Radical=y}', "");
Expect(1, 12246, '\p{^Is_Radical=y}', "");
Expect(1, 12246, '\P{Is_Radical=y}', "");
Expect(0, 12246, '\P{^Is_Radical=y}', "");
Expect(1, 12245, '\p{Is_Radical= 	y}', "");
Expect(0, 12245, '\p{^Is_Radical= 	y}', "");
Expect(0, 12245, '\P{Is_Radical= 	y}', "");
Expect(1, 12245, '\P{^Is_Radical= 	y}', "");
Expect(0, 12246, '\p{Is_Radical= 	y}', "");
Expect(1, 12246, '\p{^Is_Radical= 	y}', "");
Expect(1, 12246, '\P{Is_Radical= 	y}', "");
Expect(0, 12246, '\P{^Is_Radical= 	y}', "");
Error('\p{Radical=_T:=}');
Error('\P{Radical=_T:=}');
Expect(1, 12245, '\p{Radical=t}', "");
Expect(0, 12245, '\p{^Radical=t}', "");
Expect(0, 12245, '\P{Radical=t}', "");
Expect(1, 12245, '\P{^Radical=t}', "");
Expect(0, 12246, '\p{Radical=t}', "");
Expect(1, 12246, '\p{^Radical=t}', "");
Expect(1, 12246, '\P{Radical=t}', "");
Expect(0, 12246, '\P{^Radical=t}', "");
Expect(1, 12245, '\p{Radical=- t}', "");
Expect(0, 12245, '\p{^Radical=- t}', "");
Expect(0, 12245, '\P{Radical=- t}', "");
Expect(1, 12245, '\P{^Radical=- t}', "");
Expect(0, 12246, '\p{Radical=- t}', "");
Expect(1, 12246, '\p{^Radical=- t}', "");
Expect(1, 12246, '\P{Radical=- t}', "");
Expect(0, 12246, '\P{^Radical=- t}', "");
Error('\p{Is_Radical=:=-	TRUE}');
Error('\P{Is_Radical=:=-	TRUE}');
Expect(1, 12245, '\p{Is_Radical=true}', "");
Expect(0, 12245, '\p{^Is_Radical=true}', "");
Expect(0, 12245, '\P{Is_Radical=true}', "");
Expect(1, 12245, '\P{^Is_Radical=true}', "");
Expect(0, 12246, '\p{Is_Radical=true}', "");
Expect(1, 12246, '\p{^Is_Radical=true}', "");
Expect(1, 12246, '\P{Is_Radical=true}', "");
Expect(0, 12246, '\P{^Is_Radical=true}', "");
Expect(1, 12245, '\p{Is_Radical=-True}', "");
Expect(0, 12245, '\p{^Is_Radical=-True}', "");
Expect(0, 12245, '\P{Is_Radical=-True}', "");
Expect(1, 12245, '\P{^Is_Radical=-True}', "");
Expect(0, 12246, '\p{Is_Radical=-True}', "");
Expect(1, 12246, '\p{^Is_Radical=-True}', "");
Expect(1, 12246, '\P{Is_Radical=-True}', "");
Expect(0, 12246, '\P{^Is_Radical=-True}', "");
Error('\p{Sentence_Break=	_ATerm/a/}');
Error('\P{Sentence_Break=	_ATerm/a/}');
Expect(1, 65294, '\p{Sentence_Break=aterm}', "");
Expect(0, 65294, '\p{^Sentence_Break=aterm}', "");
Expect(0, 65294, '\P{Sentence_Break=aterm}', "");
Expect(1, 65294, '\P{^Sentence_Break=aterm}', "");
Expect(0, 65295, '\p{Sentence_Break=aterm}', "");
Expect(1, 65295, '\p{^Sentence_Break=aterm}', "");
Expect(1, 65295, '\P{Sentence_Break=aterm}', "");
Expect(0, 65295, '\P{^Sentence_Break=aterm}', "");
Expect(1, 65294, '\p{Sentence_Break=  aterm}', "");
Expect(0, 65294, '\p{^Sentence_Break=  aterm}', "");
Expect(0, 65294, '\P{Sentence_Break=  aterm}', "");
Expect(1, 65294, '\P{^Sentence_Break=  aterm}', "");
Expect(0, 65295, '\p{Sentence_Break=  aterm}', "");
Expect(1, 65295, '\p{^Sentence_Break=  aterm}', "");
Expect(1, 65295, '\P{Sentence_Break=  aterm}', "");
Expect(0, 65295, '\P{^Sentence_Break=  aterm}', "");
Error('\p{SB=:= AT}');
Error('\P{SB=:= AT}');
Expect(1, 65294, '\p{SB=at}', "");
Expect(0, 65294, '\p{^SB=at}', "");
Expect(0, 65294, '\P{SB=at}', "");
Expect(1, 65294, '\P{^SB=at}', "");
Expect(0, 65295, '\p{SB=at}', "");
Expect(1, 65295, '\p{^SB=at}', "");
Expect(1, 65295, '\P{SB=at}', "");
Expect(0, 65295, '\P{^SB=at}', "");
Expect(1, 65294, '\p{SB:	AT}', "");
Expect(0, 65294, '\p{^SB:	AT}', "");
Expect(0, 65294, '\P{SB:	AT}', "");
Expect(1, 65294, '\P{^SB:	AT}', "");
Expect(0, 65295, '\p{SB:	AT}', "");
Expect(1, 65295, '\p{^SB:	AT}', "");
Expect(1, 65295, '\P{SB:	AT}', "");
Expect(0, 65295, '\P{^SB:	AT}', "");
Error('\p{Is_Sentence_Break=:=- ATERM}');
Error('\P{Is_Sentence_Break=:=- ATERM}');
Expect(1, 65294, '\p{Is_Sentence_Break:   aterm}', "");
Expect(0, 65294, '\p{^Is_Sentence_Break:   aterm}', "");
Expect(0, 65294, '\P{Is_Sentence_Break:   aterm}', "");
Expect(1, 65294, '\P{^Is_Sentence_Break:   aterm}', "");
Expect(0, 65295, '\p{Is_Sentence_Break:   aterm}', "");
Expect(1, 65295, '\p{^Is_Sentence_Break:   aterm}', "");
Expect(1, 65295, '\P{Is_Sentence_Break:   aterm}', "");
Expect(0, 65295, '\P{^Is_Sentence_Break:   aterm}', "");
Expect(1, 65294, '\p{Is_Sentence_Break=		aterm}', "");
Expect(0, 65294, '\p{^Is_Sentence_Break=		aterm}', "");
Expect(0, 65294, '\P{Is_Sentence_Break=		aterm}', "");
Expect(1, 65294, '\P{^Is_Sentence_Break=		aterm}', "");
Expect(0, 65295, '\p{Is_Sentence_Break=		aterm}', "");
Expect(1, 65295, '\p{^Is_Sentence_Break=		aterm}', "");
Expect(1, 65295, '\P{Is_Sentence_Break=		aterm}', "");
Expect(0, 65295, '\P{^Is_Sentence_Break=		aterm}', "");
Error('\p{Is_SB=/a/ -AT}');
Error('\P{Is_SB=/a/ -AT}');
Expect(1, 65294, '\p{Is_SB=at}', "");
Expect(0, 65294, '\p{^Is_SB=at}', "");
Expect(0, 65294, '\P{Is_SB=at}', "");
Expect(1, 65294, '\P{^Is_SB=at}', "");
Expect(0, 65295, '\p{Is_SB=at}', "");
Expect(1, 65295, '\p{^Is_SB=at}', "");
Expect(1, 65295, '\P{Is_SB=at}', "");
Expect(0, 65295, '\P{^Is_SB=at}', "");
Expect(1, 65294, '\p{Is_SB=-	AT}', "");
Expect(0, 65294, '\p{^Is_SB=-	AT}', "");
Expect(0, 65294, '\P{Is_SB=-	AT}', "");
Expect(1, 65294, '\P{^Is_SB=-	AT}', "");
Expect(0, 65295, '\p{Is_SB=-	AT}', "");
Expect(1, 65295, '\p{^Is_SB=-	AT}', "");
Expect(1, 65295, '\P{Is_SB=-	AT}', "");
Expect(0, 65295, '\P{^Is_SB=-	AT}', "");
Error('\p{Sentence_Break=-:=CLOSE}');
Error('\P{Sentence_Break=-:=CLOSE}');
Expect(1, 128632, '\p{Sentence_Break=close}', "");
Expect(0, 128632, '\p{^Sentence_Break=close}', "");
Expect(0, 128632, '\P{Sentence_Break=close}', "");
Expect(1, 128632, '\P{^Sentence_Break=close}', "");
Expect(0, 128633, '\p{Sentence_Break=close}', "");
Expect(1, 128633, '\p{^Sentence_Break=close}', "");
Expect(1, 128633, '\P{Sentence_Break=close}', "");
Expect(0, 128633, '\P{^Sentence_Break=close}', "");
Expect(1, 128632, '\p{Sentence_Break=_-CLOSE}', "");
Expect(0, 128632, '\p{^Sentence_Break=_-CLOSE}', "");
Expect(0, 128632, '\P{Sentence_Break=_-CLOSE}', "");
Expect(1, 128632, '\P{^Sentence_Break=_-CLOSE}', "");
Expect(0, 128633, '\p{Sentence_Break=_-CLOSE}', "");
Expect(1, 128633, '\p{^Sentence_Break=_-CLOSE}', "");
Expect(1, 128633, '\P{Sentence_Break=_-CLOSE}', "");
Expect(0, 128633, '\P{^Sentence_Break=_-CLOSE}', "");
Error('\p{SB=:=	 CL}');
Error('\P{SB=:=	 CL}');
Expect(1, 128632, '\p{SB=cl}', "");
Expect(0, 128632, '\p{^SB=cl}', "");
Expect(0, 128632, '\P{SB=cl}', "");
Expect(1, 128632, '\P{^SB=cl}', "");
Expect(0, 128633, '\p{SB=cl}', "");
Expect(1, 128633, '\p{^SB=cl}', "");
Expect(1, 128633, '\P{SB=cl}', "");
Expect(0, 128633, '\P{^SB=cl}', "");
Expect(1, 128632, '\p{SB=-_cl}', "");
Expect(0, 128632, '\p{^SB=-_cl}', "");
Expect(0, 128632, '\P{SB=-_cl}', "");
Expect(1, 128632, '\P{^SB=-_cl}', "");
Expect(0, 128633, '\p{SB=-_cl}', "");
Expect(1, 128633, '\p{^SB=-_cl}', "");
Expect(1, 128633, '\P{SB=-_cl}', "");
Expect(0, 128633, '\P{^SB=-_cl}', "");
Error('\p{Is_Sentence_Break=  CLOSE/a/}');
Error('\P{Is_Sentence_Break=  CLOSE/a/}');
Expect(1, 128632, '\p{Is_Sentence_Break=close}', "");
Expect(0, 128632, '\p{^Is_Sentence_Break=close}', "");
Expect(0, 128632, '\P{Is_Sentence_Break=close}', "");
Expect(1, 128632, '\P{^Is_Sentence_Break=close}', "");
Expect(0, 128633, '\p{Is_Sentence_Break=close}', "");
Expect(1, 128633, '\p{^Is_Sentence_Break=close}', "");
Expect(1, 128633, '\P{Is_Sentence_Break=close}', "");
Expect(0, 128633, '\P{^Is_Sentence_Break=close}', "");
Expect(1, 128632, '\p{Is_Sentence_Break=	-close}', "");
Expect(0, 128632, '\p{^Is_Sentence_Break=	-close}', "");
Expect(0, 128632, '\P{Is_Sentence_Break=	-close}', "");
Expect(1, 128632, '\P{^Is_Sentence_Break=	-close}', "");
Expect(0, 128633, '\p{Is_Sentence_Break=	-close}', "");
Expect(1, 128633, '\p{^Is_Sentence_Break=	-close}', "");
Expect(1, 128633, '\P{Is_Sentence_Break=	-close}', "");
Expect(0, 128633, '\P{^Is_Sentence_Break=	-close}', "");
Error('\p{Is_SB=	CL:=}');
Error('\P{Is_SB=	CL:=}');
Expect(1, 128632, '\p{Is_SB=cl}', "");
Expect(0, 128632, '\p{^Is_SB=cl}', "");
Expect(0, 128632, '\P{Is_SB=cl}', "");
Expect(1, 128632, '\P{^Is_SB=cl}', "");
Expect(0, 128633, '\p{Is_SB=cl}', "");
Expect(1, 128633, '\p{^Is_SB=cl}', "");
Expect(1, 128633, '\P{Is_SB=cl}', "");
Expect(0, 128633, '\P{^Is_SB=cl}', "");
Expect(1, 128632, '\p{Is_SB= -CL}', "");
Expect(0, 128632, '\p{^Is_SB= -CL}', "");
Expect(0, 128632, '\P{Is_SB= -CL}', "");
Expect(1, 128632, '\P{^Is_SB= -CL}', "");
Expect(0, 128633, '\p{Is_SB= -CL}', "");
Expect(1, 128633, '\p{^Is_SB= -CL}', "");
Expect(1, 128633, '\P{Is_SB= -CL}', "");
Expect(0, 128633, '\P{^Is_SB= -CL}', "");
Error('\p{Sentence_Break=	CR/a/}');
Error('\P{Sentence_Break=	CR/a/}');
Expect(1, 13, '\p{Sentence_Break=cr}', "");
Expect(0, 13, '\p{^Sentence_Break=cr}', "");
Expect(0, 13, '\P{Sentence_Break=cr}', "");
Expect(1, 13, '\P{^Sentence_Break=cr}', "");
Expect(0, 14, '\p{Sentence_Break=cr}', "");
Expect(1, 14, '\p{^Sentence_Break=cr}', "");
Expect(1, 14, '\P{Sentence_Break=cr}', "");
Expect(0, 14, '\P{^Sentence_Break=cr}', "");
Expect(1, 13, '\p{Sentence_Break:_-cr}', "");
Expect(0, 13, '\p{^Sentence_Break:_-cr}', "");
Expect(0, 13, '\P{Sentence_Break:_-cr}', "");
Expect(1, 13, '\P{^Sentence_Break:_-cr}', "");
Expect(0, 14, '\p{Sentence_Break:_-cr}', "");
Expect(1, 14, '\p{^Sentence_Break:_-cr}', "");
Expect(1, 14, '\P{Sentence_Break:_-cr}', "");
Expect(0, 14, '\P{^Sentence_Break:_-cr}', "");
Error('\p{SB:   /a/ 	cr}');
Error('\P{SB:   /a/ 	cr}');
Expect(1, 13, '\p{SB=cr}', "");
Expect(0, 13, '\p{^SB=cr}', "");
Expect(0, 13, '\P{SB=cr}', "");
Expect(1, 13, '\P{^SB=cr}', "");
Expect(0, 14, '\p{SB=cr}', "");
Expect(1, 14, '\p{^SB=cr}', "");
Expect(1, 14, '\P{SB=cr}', "");
Expect(0, 14, '\P{^SB=cr}', "");
Expect(1, 13, '\p{SB=_CR}', "");
Expect(0, 13, '\p{^SB=_CR}', "");
Expect(0, 13, '\P{SB=_CR}', "");
Expect(1, 13, '\P{^SB=_CR}', "");
Expect(0, 14, '\p{SB=_CR}', "");
Expect(1, 14, '\p{^SB=_CR}', "");
Expect(1, 14, '\P{SB=_CR}', "");
Expect(0, 14, '\P{^SB=_CR}', "");
Error('\p{Is_Sentence_Break=/a/ CR}');
Error('\P{Is_Sentence_Break=/a/ CR}');
Expect(1, 13, '\p{Is_Sentence_Break=cr}', "");
Expect(0, 13, '\p{^Is_Sentence_Break=cr}', "");
Expect(0, 13, '\P{Is_Sentence_Break=cr}', "");
Expect(1, 13, '\P{^Is_Sentence_Break=cr}', "");
Expect(0, 14, '\p{Is_Sentence_Break=cr}', "");
Expect(1, 14, '\p{^Is_Sentence_Break=cr}', "");
Expect(1, 14, '\P{Is_Sentence_Break=cr}', "");
Expect(0, 14, '\P{^Is_Sentence_Break=cr}', "");
Expect(1, 13, '\p{Is_Sentence_Break=-CR}', "");
Expect(0, 13, '\p{^Is_Sentence_Break=-CR}', "");
Expect(0, 13, '\P{Is_Sentence_Break=-CR}', "");
Expect(1, 13, '\P{^Is_Sentence_Break=-CR}', "");
Expect(0, 14, '\p{Is_Sentence_Break=-CR}', "");
Expect(1, 14, '\p{^Is_Sentence_Break=-CR}', "");
Expect(1, 14, '\P{Is_Sentence_Break=-CR}', "");
Expect(0, 14, '\P{^Is_Sentence_Break=-CR}', "");
Error('\p{Is_SB=/a/	CR}');
Error('\P{Is_SB=/a/	CR}');
Expect(1, 13, '\p{Is_SB=cr}', "");
Expect(0, 13, '\p{^Is_SB=cr}', "");
Expect(0, 13, '\P{Is_SB=cr}', "");
Expect(1, 13, '\P{^Is_SB=cr}', "");
Expect(0, 14, '\p{Is_SB=cr}', "");
Expect(1, 14, '\p{^Is_SB=cr}', "");
Expect(1, 14, '\P{Is_SB=cr}', "");
Expect(0, 14, '\P{^Is_SB=cr}', "");
Expect(1, 13, '\p{Is_SB=__CR}', "");
Expect(0, 13, '\p{^Is_SB=__CR}', "");
Expect(0, 13, '\P{Is_SB=__CR}', "");
Expect(1, 13, '\P{^Is_SB=__CR}', "");
Expect(0, 14, '\p{Is_SB=__CR}', "");
Expect(1, 14, '\p{^Is_SB=__CR}', "");
Expect(1, 14, '\P{Is_SB=__CR}', "");
Expect(0, 14, '\P{^Is_SB=__CR}', "");
Error('\p{Sentence_Break= EXTEND/a/}');
Error('\P{Sentence_Break= EXTEND/a/}');
Expect(1, 917999, '\p{Sentence_Break=extend}', "");
Expect(0, 917999, '\p{^Sentence_Break=extend}', "");
Expect(0, 917999, '\P{Sentence_Break=extend}', "");
Expect(1, 917999, '\P{^Sentence_Break=extend}', "");
Expect(0, 918000, '\p{Sentence_Break=extend}', "");
Expect(1, 918000, '\p{^Sentence_Break=extend}', "");
Expect(1, 918000, '\P{Sentence_Break=extend}', "");
Expect(0, 918000, '\P{^Sentence_Break=extend}', "");
Expect(1, 917999, '\p{Sentence_Break=--EXTEND}', "");
Expect(0, 917999, '\p{^Sentence_Break=--EXTEND}', "");
Expect(0, 917999, '\P{Sentence_Break=--EXTEND}', "");
Expect(1, 917999, '\P{^Sentence_Break=--EXTEND}', "");
Expect(0, 918000, '\p{Sentence_Break=--EXTEND}', "");
Expect(1, 918000, '\p{^Sentence_Break=--EXTEND}', "");
Expect(1, 918000, '\P{Sentence_Break=--EXTEND}', "");
Expect(0, 918000, '\P{^Sentence_Break=--EXTEND}', "");
Error('\p{SB: :=	EX}');
Error('\P{SB: :=	EX}');
Expect(1, 917999, '\p{SB=ex}', "");
Expect(0, 917999, '\p{^SB=ex}', "");
Expect(0, 917999, '\P{SB=ex}', "");
Expect(1, 917999, '\P{^SB=ex}', "");
Expect(0, 918000, '\p{SB=ex}', "");
Expect(1, 918000, '\p{^SB=ex}', "");
Expect(1, 918000, '\P{SB=ex}', "");
Expect(0, 918000, '\P{^SB=ex}', "");
Expect(1, 917999, '\p{SB=_ex}', "");
Expect(0, 917999, '\p{^SB=_ex}', "");
Expect(0, 917999, '\P{SB=_ex}', "");
Expect(1, 917999, '\P{^SB=_ex}', "");
Expect(0, 918000, '\p{SB=_ex}', "");
Expect(1, 918000, '\p{^SB=_ex}', "");
Expect(1, 918000, '\P{SB=_ex}', "");
Expect(0, 918000, '\P{^SB=_ex}', "");
Error('\p{Is_Sentence_Break=_Extend:=}');
Error('\P{Is_Sentence_Break=_Extend:=}');
Expect(1, 917999, '\p{Is_Sentence_Break=extend}', "");
Expect(0, 917999, '\p{^Is_Sentence_Break=extend}', "");
Expect(0, 917999, '\P{Is_Sentence_Break=extend}', "");
Expect(1, 917999, '\P{^Is_Sentence_Break=extend}', "");
Expect(0, 918000, '\p{Is_Sentence_Break=extend}', "");
Expect(1, 918000, '\p{^Is_Sentence_Break=extend}', "");
Expect(1, 918000, '\P{Is_Sentence_Break=extend}', "");
Expect(0, 918000, '\P{^Is_Sentence_Break=extend}', "");
Expect(1, 917999, '\p{Is_Sentence_Break= _EXTEND}', "");
Expect(0, 917999, '\p{^Is_Sentence_Break= _EXTEND}', "");
Expect(0, 917999, '\P{Is_Sentence_Break= _EXTEND}', "");
Expect(1, 917999, '\P{^Is_Sentence_Break= _EXTEND}', "");
Expect(0, 918000, '\p{Is_Sentence_Break= _EXTEND}', "");
Expect(1, 918000, '\p{^Is_Sentence_Break= _EXTEND}', "");
Expect(1, 918000, '\P{Is_Sentence_Break= _EXTEND}', "");
Expect(0, 918000, '\P{^Is_Sentence_Break= _EXTEND}', "");
Error('\p{Is_SB=	_ex/a/}');
Error('\P{Is_SB=	_ex/a/}');
Expect(1, 917999, '\p{Is_SB=ex}', "");
Expect(0, 917999, '\p{^Is_SB=ex}', "");
Expect(0, 917999, '\P{Is_SB=ex}', "");
Expect(1, 917999, '\P{^Is_SB=ex}', "");
Expect(0, 918000, '\p{Is_SB=ex}', "");
Expect(1, 918000, '\p{^Is_SB=ex}', "");
Expect(1, 918000, '\P{Is_SB=ex}', "");
Expect(0, 918000, '\P{^Is_SB=ex}', "");
Expect(1, 917999, '\p{Is_SB=-	EX}', "");
Expect(0, 917999, '\p{^Is_SB=-	EX}', "");
Expect(0, 917999, '\P{Is_SB=-	EX}', "");
Expect(1, 917999, '\P{^Is_SB=-	EX}', "");
Expect(0, 918000, '\p{Is_SB=-	EX}', "");
Expect(1, 918000, '\p{^Is_SB=-	EX}', "");
Expect(1, 918000, '\P{Is_SB=-	EX}', "");
Expect(0, 918000, '\P{^Is_SB=-	EX}', "");
Error('\p{Sentence_Break=:=- FORMAT}');
Error('\P{Sentence_Break=:=- FORMAT}');
Expect(1, 917631, '\p{Sentence_Break=format}', "");
Expect(0, 917631, '\p{^Sentence_Break=format}', "");
Expect(0, 917631, '\P{Sentence_Break=format}', "");
Expect(1, 917631, '\P{^Sentence_Break=format}', "");
Expect(0, 917632, '\p{Sentence_Break=format}', "");
Expect(1, 917632, '\p{^Sentence_Break=format}', "");
Expect(1, 917632, '\P{Sentence_Break=format}', "");
Expect(0, 917632, '\P{^Sentence_Break=format}', "");
Expect(1, 917631, '\p{Sentence_Break=	_format}', "");
Expect(0, 917631, '\p{^Sentence_Break=	_format}', "");
Expect(0, 917631, '\P{Sentence_Break=	_format}', "");
Expect(1, 917631, '\P{^Sentence_Break=	_format}', "");
Expect(0, 917632, '\p{Sentence_Break=	_format}', "");
Expect(1, 917632, '\p{^Sentence_Break=	_format}', "");
Expect(1, 917632, '\P{Sentence_Break=	_format}', "");
Expect(0, 917632, '\P{^Sentence_Break=	_format}', "");
Error('\p{SB:_/a/FO}');
Error('\P{SB:_/a/FO}');
Expect(1, 917631, '\p{SB=fo}', "");
Expect(0, 917631, '\p{^SB=fo}', "");
Expect(0, 917631, '\P{SB=fo}', "");
Expect(1, 917631, '\P{^SB=fo}', "");
Expect(0, 917632, '\p{SB=fo}', "");
Expect(1, 917632, '\p{^SB=fo}', "");
Expect(1, 917632, '\P{SB=fo}', "");
Expect(0, 917632, '\P{^SB=fo}', "");
Expect(1, 917631, '\p{SB=_-fo}', "");
Expect(0, 917631, '\p{^SB=_-fo}', "");
Expect(0, 917631, '\P{SB=_-fo}', "");
Expect(1, 917631, '\P{^SB=_-fo}', "");
Expect(0, 917632, '\p{SB=_-fo}', "");
Expect(1, 917632, '\p{^SB=_-fo}', "");
Expect(1, 917632, '\P{SB=_-fo}', "");
Expect(0, 917632, '\P{^SB=_-fo}', "");
Error('\p{Is_Sentence_Break=_:=Format}');
Error('\P{Is_Sentence_Break=_:=Format}');
Expect(1, 917631, '\p{Is_Sentence_Break=format}', "");
Expect(0, 917631, '\p{^Is_Sentence_Break=format}', "");
Expect(0, 917631, '\P{Is_Sentence_Break=format}', "");
Expect(1, 917631, '\P{^Is_Sentence_Break=format}', "");
Expect(0, 917632, '\p{Is_Sentence_Break=format}', "");
Expect(1, 917632, '\p{^Is_Sentence_Break=format}', "");
Expect(1, 917632, '\P{Is_Sentence_Break=format}', "");
Expect(0, 917632, '\P{^Is_Sentence_Break=format}', "");
Expect(1, 917631, '\p{Is_Sentence_Break=_-format}', "");
Expect(0, 917631, '\p{^Is_Sentence_Break=_-format}', "");
Expect(0, 917631, '\P{Is_Sentence_Break=_-format}', "");
Expect(1, 917631, '\P{^Is_Sentence_Break=_-format}', "");
Expect(0, 917632, '\p{Is_Sentence_Break=_-format}', "");
Expect(1, 917632, '\p{^Is_Sentence_Break=_-format}', "");
Expect(1, 917632, '\P{Is_Sentence_Break=_-format}', "");
Expect(0, 917632, '\P{^Is_Sentence_Break=_-format}', "");
Error('\p{Is_SB=  fo/a/}');
Error('\P{Is_SB=  fo/a/}');
Expect(1, 917631, '\p{Is_SB=fo}', "");
Expect(0, 917631, '\p{^Is_SB=fo}', "");
Expect(0, 917631, '\P{Is_SB=fo}', "");
Expect(1, 917631, '\P{^Is_SB=fo}', "");
Expect(0, 917632, '\p{Is_SB=fo}', "");
Expect(1, 917632, '\p{^Is_SB=fo}', "");
Expect(1, 917632, '\P{Is_SB=fo}', "");
Expect(0, 917632, '\P{^Is_SB=fo}', "");
Expect(1, 917631, '\p{Is_SB=-FO}', "");
Expect(0, 917631, '\p{^Is_SB=-FO}', "");
Expect(0, 917631, '\P{Is_SB=-FO}', "");
Expect(1, 917631, '\P{^Is_SB=-FO}', "");
Expect(0, 917632, '\p{Is_SB=-FO}', "");
Expect(1, 917632, '\p{^Is_SB=-FO}', "");
Expect(1, 917632, '\P{Is_SB=-FO}', "");
Expect(0, 917632, '\P{^Is_SB=-FO}', "");
Error('\p{Sentence_Break=:=__OLetter}');
Error('\P{Sentence_Break=:=__OLetter}');
Expect(1, 195101, '\p{Sentence_Break=oletter}', "");
Expect(0, 195101, '\p{^Sentence_Break=oletter}', "");
Expect(0, 195101, '\P{Sentence_Break=oletter}', "");
Expect(1, 195101, '\P{^Sentence_Break=oletter}', "");
Expect(0, 195102, '\p{Sentence_Break=oletter}', "");
Expect(1, 195102, '\p{^Sentence_Break=oletter}', "");
Expect(1, 195102, '\P{Sentence_Break=oletter}', "");
Expect(0, 195102, '\P{^Sentence_Break=oletter}', "");
Expect(1, 195101, '\p{Sentence_Break=-oletter}', "");
Expect(0, 195101, '\p{^Sentence_Break=-oletter}', "");
Expect(0, 195101, '\P{Sentence_Break=-oletter}', "");
Expect(1, 195101, '\P{^Sentence_Break=-oletter}', "");
Expect(0, 195102, '\p{Sentence_Break=-oletter}', "");
Expect(1, 195102, '\p{^Sentence_Break=-oletter}', "");
Expect(1, 195102, '\P{Sentence_Break=-oletter}', "");
Expect(0, 195102, '\P{^Sentence_Break=-oletter}', "");
Error('\p{SB= le:=}');
Error('\P{SB= le:=}');
Expect(1, 195101, '\p{SB=le}', "");
Expect(0, 195101, '\p{^SB=le}', "");
Expect(0, 195101, '\P{SB=le}', "");
Expect(1, 195101, '\P{^SB=le}', "");
Expect(0, 195102, '\p{SB=le}', "");
Expect(1, 195102, '\p{^SB=le}', "");
Expect(1, 195102, '\P{SB=le}', "");
Expect(0, 195102, '\P{^SB=le}', "");
Expect(1, 195101, '\p{SB=	LE}', "");
Expect(0, 195101, '\p{^SB=	LE}', "");
Expect(0, 195101, '\P{SB=	LE}', "");
Expect(1, 195101, '\P{^SB=	LE}', "");
Expect(0, 195102, '\p{SB=	LE}', "");
Expect(1, 195102, '\p{^SB=	LE}', "");
Expect(1, 195102, '\P{SB=	LE}', "");
Expect(0, 195102, '\P{^SB=	LE}', "");
Error('\p{Is_Sentence_Break=-:=OLetter}');
Error('\P{Is_Sentence_Break=-:=OLetter}');
Expect(1, 195101, '\p{Is_Sentence_Break=oletter}', "");
Expect(0, 195101, '\p{^Is_Sentence_Break=oletter}', "");
Expect(0, 195101, '\P{Is_Sentence_Break=oletter}', "");
Expect(1, 195101, '\P{^Is_Sentence_Break=oletter}', "");
Expect(0, 195102, '\p{Is_Sentence_Break=oletter}', "");
Expect(1, 195102, '\p{^Is_Sentence_Break=oletter}', "");
Expect(1, 195102, '\P{Is_Sentence_Break=oletter}', "");
Expect(0, 195102, '\P{^Is_Sentence_Break=oletter}', "");
Expect(1, 195101, '\p{Is_Sentence_Break:   -OLetter}', "");
Expect(0, 195101, '\p{^Is_Sentence_Break:   -OLetter}', "");
Expect(0, 195101, '\P{Is_Sentence_Break:   -OLetter}', "");
Expect(1, 195101, '\P{^Is_Sentence_Break:   -OLetter}', "");
Expect(0, 195102, '\p{Is_Sentence_Break:   -OLetter}', "");
Expect(1, 195102, '\p{^Is_Sentence_Break:   -OLetter}', "");
Expect(1, 195102, '\P{Is_Sentence_Break:   -OLetter}', "");
Expect(0, 195102, '\P{^Is_Sentence_Break:   -OLetter}', "");
Error('\p{Is_SB=_LE:=}');
Error('\P{Is_SB=_LE:=}');
Expect(1, 195101, '\p{Is_SB=le}', "");
Expect(0, 195101, '\p{^Is_SB=le}', "");
Expect(0, 195101, '\P{Is_SB=le}', "");
Expect(1, 195101, '\P{^Is_SB=le}', "");
Expect(0, 195102, '\p{Is_SB=le}', "");
Expect(1, 195102, '\p{^Is_SB=le}', "");
Expect(1, 195102, '\P{Is_SB=le}', "");
Expect(0, 195102, '\P{^Is_SB=le}', "");
Expect(1, 195101, '\p{Is_SB=		le}', "");
Expect(0, 195101, '\p{^Is_SB=		le}', "");
Expect(0, 195101, '\P{Is_SB=		le}', "");
Expect(1, 195101, '\P{^Is_SB=		le}', "");
Expect(0, 195102, '\p{Is_SB=		le}', "");
Expect(1, 195102, '\p{^Is_SB=		le}', "");
Expect(1, 195102, '\P{Is_SB=		le}', "");
Expect(0, 195102, '\P{^Is_SB=		le}', "");
Error('\p{Sentence_Break=	:=LF}');
Error('\P{Sentence_Break=	:=LF}');
Expect(1, 10, '\p{Sentence_Break=lf}', "");
Expect(0, 10, '\p{^Sentence_Break=lf}', "");
Expect(0, 10, '\P{Sentence_Break=lf}', "");
Expect(1, 10, '\P{^Sentence_Break=lf}', "");
Expect(0, 11, '\p{Sentence_Break=lf}', "");
Expect(1, 11, '\p{^Sentence_Break=lf}', "");
Expect(1, 11, '\P{Sentence_Break=lf}', "");
Expect(0, 11, '\P{^Sentence_Break=lf}', "");
Expect(1, 10, '\p{Sentence_Break= LF}', "");
Expect(0, 10, '\p{^Sentence_Break= LF}', "");
Expect(0, 10, '\P{Sentence_Break= LF}', "");
Expect(1, 10, '\P{^Sentence_Break= LF}', "");
Expect(0, 11, '\p{Sentence_Break= LF}', "");
Expect(1, 11, '\p{^Sentence_Break= LF}', "");
Expect(1, 11, '\P{Sentence_Break= LF}', "");
Expect(0, 11, '\P{^Sentence_Break= LF}', "");
Error('\p{SB=	/a/LF}');
Error('\P{SB=	/a/LF}');
Expect(1, 10, '\p{SB=lf}', "");
Expect(0, 10, '\p{^SB=lf}', "");
Expect(0, 10, '\P{SB=lf}', "");
Expect(1, 10, '\P{^SB=lf}', "");
Expect(0, 11, '\p{SB=lf}', "");
Expect(1, 11, '\p{^SB=lf}', "");
Expect(1, 11, '\P{SB=lf}', "");
Expect(0, 11, '\P{^SB=lf}', "");
Expect(1, 10, '\p{SB=__LF}', "");
Expect(0, 10, '\p{^SB=__LF}', "");
Expect(0, 10, '\P{SB=__LF}', "");
Expect(1, 10, '\P{^SB=__LF}', "");
Expect(0, 11, '\p{SB=__LF}', "");
Expect(1, 11, '\p{^SB=__LF}', "");
Expect(1, 11, '\P{SB=__LF}', "");
Expect(0, 11, '\P{^SB=__LF}', "");
Error('\p{Is_Sentence_Break=	 lf:=}');
Error('\P{Is_Sentence_Break=	 lf:=}');
Expect(1, 10, '\p{Is_Sentence_Break=lf}', "");
Expect(0, 10, '\p{^Is_Sentence_Break=lf}', "");
Expect(0, 10, '\P{Is_Sentence_Break=lf}', "");
Expect(1, 10, '\P{^Is_Sentence_Break=lf}', "");
Expect(0, 11, '\p{Is_Sentence_Break=lf}', "");
Expect(1, 11, '\p{^Is_Sentence_Break=lf}', "");
Expect(1, 11, '\P{Is_Sentence_Break=lf}', "");
Expect(0, 11, '\P{^Is_Sentence_Break=lf}', "");
Expect(1, 10, '\p{Is_Sentence_Break: _ LF}', "");
Expect(0, 10, '\p{^Is_Sentence_Break: _ LF}', "");
Expect(0, 10, '\P{Is_Sentence_Break: _ LF}', "");
Expect(1, 10, '\P{^Is_Sentence_Break: _ LF}', "");
Expect(0, 11, '\p{Is_Sentence_Break: _ LF}', "");
Expect(1, 11, '\p{^Is_Sentence_Break: _ LF}', "");
Expect(1, 11, '\P{Is_Sentence_Break: _ LF}', "");
Expect(0, 11, '\P{^Is_Sentence_Break: _ LF}', "");
Error('\p{Is_SB=:=	LF}');
Error('\P{Is_SB=:=	LF}');
Expect(1, 10, '\p{Is_SB=lf}', "");
Expect(0, 10, '\p{^Is_SB=lf}', "");
Expect(0, 10, '\P{Is_SB=lf}', "");
Expect(1, 10, '\P{^Is_SB=lf}', "");
Expect(0, 11, '\p{Is_SB=lf}', "");
Expect(1, 11, '\p{^Is_SB=lf}', "");
Expect(1, 11, '\P{Is_SB=lf}', "");
Expect(0, 11, '\P{^Is_SB=lf}', "");
Expect(1, 10, '\p{Is_SB=_ LF}', "");
Expect(0, 10, '\p{^Is_SB=_ LF}', "");
Expect(0, 10, '\P{Is_SB=_ LF}', "");
Expect(1, 10, '\P{^Is_SB=_ LF}', "");
Expect(0, 11, '\p{Is_SB=_ LF}', "");
Expect(1, 11, '\p{^Is_SB=_ LF}', "");
Expect(1, 11, '\P{Is_SB=_ LF}', "");
Expect(0, 11, '\P{^Is_SB=_ LF}', "");
Error('\p{Sentence_Break=	/a/lower}');
Error('\P{Sentence_Break=	/a/lower}');
Expect(1, 120779, '\p{Sentence_Break=lower}', "");
Expect(0, 120779, '\p{^Sentence_Break=lower}', "");
Expect(0, 120779, '\P{Sentence_Break=lower}', "");
Expect(1, 120779, '\P{^Sentence_Break=lower}', "");
Expect(0, 120780, '\p{Sentence_Break=lower}', "");
Expect(1, 120780, '\p{^Sentence_Break=lower}', "");
Expect(1, 120780, '\P{Sentence_Break=lower}', "");
Expect(0, 120780, '\P{^Sentence_Break=lower}', "");
Expect(1, 120779, '\p{Sentence_Break=-LOWER}', "");
Expect(0, 120779, '\p{^Sentence_Break=-LOWER}', "");
Expect(0, 120779, '\P{Sentence_Break=-LOWER}', "");
Expect(1, 120779, '\P{^Sentence_Break=-LOWER}', "");
Expect(0, 120780, '\p{Sentence_Break=-LOWER}', "");
Expect(1, 120780, '\p{^Sentence_Break=-LOWER}', "");
Expect(1, 120780, '\P{Sentence_Break=-LOWER}', "");
Expect(0, 120780, '\P{^Sentence_Break=-LOWER}', "");
Error('\p{SB:	:= LO}');
Error('\P{SB:	:= LO}');
Expect(1, 120779, '\p{SB:lo}', "");
Expect(0, 120779, '\p{^SB:lo}', "");
Expect(0, 120779, '\P{SB:lo}', "");
Expect(1, 120779, '\P{^SB:lo}', "");
Expect(0, 120780, '\p{SB:lo}', "");
Expect(1, 120780, '\p{^SB:lo}', "");
Expect(1, 120780, '\P{SB:lo}', "");
Expect(0, 120780, '\P{^SB:lo}', "");
Expect(1, 120779, '\p{SB=	 lo}', "");
Expect(0, 120779, '\p{^SB=	 lo}', "");
Expect(0, 120779, '\P{SB=	 lo}', "");
Expect(1, 120779, '\P{^SB=	 lo}', "");
Expect(0, 120780, '\p{SB=	 lo}', "");
Expect(1, 120780, '\p{^SB=	 lo}', "");
Expect(1, 120780, '\P{SB=	 lo}', "");
Expect(0, 120780, '\P{^SB=	 lo}', "");
Error('\p{Is_Sentence_Break=/a/	Lower}');
Error('\P{Is_Sentence_Break=/a/	Lower}');
Expect(1, 120779, '\p{Is_Sentence_Break=lower}', "");
Expect(0, 120779, '\p{^Is_Sentence_Break=lower}', "");
Expect(0, 120779, '\P{Is_Sentence_Break=lower}', "");
Expect(1, 120779, '\P{^Is_Sentence_Break=lower}', "");
Expect(0, 120780, '\p{Is_Sentence_Break=lower}', "");
Expect(1, 120780, '\p{^Is_Sentence_Break=lower}', "");
Expect(1, 120780, '\P{Is_Sentence_Break=lower}', "");
Expect(0, 120780, '\P{^Is_Sentence_Break=lower}', "");
Expect(1, 120779, '\p{Is_Sentence_Break= 	LOWER}', "");
Expect(0, 120779, '\p{^Is_Sentence_Break= 	LOWER}', "");
Expect(0, 120779, '\P{Is_Sentence_Break= 	LOWER}', "");
Expect(1, 120779, '\P{^Is_Sentence_Break= 	LOWER}', "");
Expect(0, 120780, '\p{Is_Sentence_Break= 	LOWER}', "");
Expect(1, 120780, '\p{^Is_Sentence_Break= 	LOWER}', "");
Expect(1, 120780, '\P{Is_Sentence_Break= 	LOWER}', "");
Expect(0, 120780, '\P{^Is_Sentence_Break= 	LOWER}', "");
Error('\p{Is_SB:_lo/a/}');
Error('\P{Is_SB:_lo/a/}');
Expect(1, 120779, '\p{Is_SB=lo}', "");
Expect(0, 120779, '\p{^Is_SB=lo}', "");
Expect(0, 120779, '\P{Is_SB=lo}', "");
Expect(1, 120779, '\P{^Is_SB=lo}', "");
Expect(0, 120780, '\p{Is_SB=lo}', "");
Expect(1, 120780, '\p{^Is_SB=lo}', "");
Expect(1, 120780, '\P{Is_SB=lo}', "");
Expect(0, 120780, '\P{^Is_SB=lo}', "");
Expect(1, 120779, '\p{Is_SB=	-LO}', "");
Expect(0, 120779, '\p{^Is_SB=	-LO}', "");
Expect(0, 120779, '\P{Is_SB=	-LO}', "");
Expect(1, 120779, '\P{^Is_SB=	-LO}', "");
Expect(0, 120780, '\p{Is_SB=	-LO}', "");
Expect(1, 120780, '\p{^Is_SB=	-LO}', "");
Expect(1, 120780, '\P{Is_SB=	-LO}', "");
Expect(0, 120780, '\P{^Is_SB=	-LO}', "");
Error('\p{Sentence_Break=/a/	 NUMERIC}');
Error('\P{Sentence_Break=/a/	 NUMERIC}');
Expect(1, 120831, '\p{Sentence_Break=numeric}', "");
Expect(0, 120831, '\p{^Sentence_Break=numeric}', "");
Expect(0, 120831, '\P{Sentence_Break=numeric}', "");
Expect(1, 120831, '\P{^Sentence_Break=numeric}', "");
Expect(0, 120832, '\p{Sentence_Break=numeric}', "");
Expect(1, 120832, '\p{^Sentence_Break=numeric}', "");
Expect(1, 120832, '\P{Sentence_Break=numeric}', "");
Expect(0, 120832, '\P{^Sentence_Break=numeric}', "");
Expect(1, 120831, '\p{Sentence_Break=  numeric}', "");
Expect(0, 120831, '\p{^Sentence_Break=  numeric}', "");
Expect(0, 120831, '\P{Sentence_Break=  numeric}', "");
Expect(1, 120831, '\P{^Sentence_Break=  numeric}', "");
Expect(0, 120832, '\p{Sentence_Break=  numeric}', "");
Expect(1, 120832, '\p{^Sentence_Break=  numeric}', "");
Expect(1, 120832, '\P{Sentence_Break=  numeric}', "");
Expect(0, 120832, '\P{^Sentence_Break=  numeric}', "");
Error('\p{SB: :=NU}');
Error('\P{SB: :=NU}');
Expect(1, 120831, '\p{SB=nu}', "");
Expect(0, 120831, '\p{^SB=nu}', "");
Expect(0, 120831, '\P{SB=nu}', "");
Expect(1, 120831, '\P{^SB=nu}', "");
Expect(0, 120832, '\p{SB=nu}', "");
Expect(1, 120832, '\p{^SB=nu}', "");
Expect(1, 120832, '\P{SB=nu}', "");
Expect(0, 120832, '\P{^SB=nu}', "");
Expect(1, 120831, '\p{SB=	_NU}', "");
Expect(0, 120831, '\p{^SB=	_NU}', "");
Expect(0, 120831, '\P{SB=	_NU}', "");
Expect(1, 120831, '\P{^SB=	_NU}', "");
Expect(0, 120832, '\p{SB=	_NU}', "");
Expect(1, 120832, '\p{^SB=	_NU}', "");
Expect(1, 120832, '\P{SB=	_NU}', "");
Expect(0, 120832, '\P{^SB=	_NU}', "");
Error('\p{Is_Sentence_Break=	NUMERIC/a/}');
Error('\P{Is_Sentence_Break=	NUMERIC/a/}');
Expect(1, 120831, '\p{Is_Sentence_Break=numeric}', "");
Expect(0, 120831, '\p{^Is_Sentence_Break=numeric}', "");
Expect(0, 120831, '\P{Is_Sentence_Break=numeric}', "");
Expect(1, 120831, '\P{^Is_Sentence_Break=numeric}', "");
Expect(0, 120832, '\p{Is_Sentence_Break=numeric}', "");
Expect(1, 120832, '\p{^Is_Sentence_Break=numeric}', "");
Expect(1, 120832, '\P{Is_Sentence_Break=numeric}', "");
Expect(0, 120832, '\P{^Is_Sentence_Break=numeric}', "");
Expect(1, 120831, '\p{Is_Sentence_Break=  Numeric}', "");
Expect(0, 120831, '\p{^Is_Sentence_Break=  Numeric}', "");
Expect(0, 120831, '\P{Is_Sentence_Break=  Numeric}', "");
Expect(1, 120831, '\P{^Is_Sentence_Break=  Numeric}', "");
Expect(0, 120832, '\p{Is_Sentence_Break=  Numeric}', "");
Expect(1, 120832, '\p{^Is_Sentence_Break=  Numeric}', "");
Expect(1, 120832, '\P{Is_Sentence_Break=  Numeric}', "");
Expect(0, 120832, '\P{^Is_Sentence_Break=  Numeric}', "");
Error('\p{Is_SB=-/a/NU}');
Error('\P{Is_SB=-/a/NU}');
Expect(1, 120831, '\p{Is_SB:nu}', "");
Expect(0, 120831, '\p{^Is_SB:nu}', "");
Expect(0, 120831, '\P{Is_SB:nu}', "");
Expect(1, 120831, '\P{^Is_SB:nu}', "");
Expect(0, 120832, '\p{Is_SB:nu}', "");
Expect(1, 120832, '\p{^Is_SB:nu}', "");
Expect(1, 120832, '\P{Is_SB:nu}', "");
Expect(0, 120832, '\P{^Is_SB:nu}', "");
Expect(1, 120831, '\p{Is_SB=	-NU}', "");
Expect(0, 120831, '\p{^Is_SB=	-NU}', "");
Expect(0, 120831, '\P{Is_SB=	-NU}', "");
Expect(1, 120831, '\P{^Is_SB=	-NU}', "");
Expect(0, 120832, '\p{Is_SB=	-NU}', "");
Expect(1, 120832, '\p{^Is_SB=	-NU}', "");
Expect(1, 120832, '\P{Is_SB=	-NU}', "");
Expect(0, 120832, '\P{^Is_SB=	-NU}', "");
Error('\p{Sentence_Break:_:=scontinue}');
Error('\P{Sentence_Break:_:=scontinue}');
Expect(1, 65380, '\p{Sentence_Break=scontinue}', "");
Expect(0, 65380, '\p{^Sentence_Break=scontinue}', "");
Expect(0, 65380, '\P{Sentence_Break=scontinue}', "");
Expect(1, 65380, '\P{^Sentence_Break=scontinue}', "");
Expect(0, 65381, '\p{Sentence_Break=scontinue}', "");
Expect(1, 65381, '\p{^Sentence_Break=scontinue}', "");
Expect(1, 65381, '\P{Sentence_Break=scontinue}', "");
Expect(0, 65381, '\P{^Sentence_Break=scontinue}', "");
Expect(1, 65380, '\p{Sentence_Break:   	-SCONTINUE}', "");
Expect(0, 65380, '\p{^Sentence_Break:   	-SCONTINUE}', "");
Expect(0, 65380, '\P{Sentence_Break:   	-SCONTINUE}', "");
Expect(1, 65380, '\P{^Sentence_Break:   	-SCONTINUE}', "");
Expect(0, 65381, '\p{Sentence_Break:   	-SCONTINUE}', "");
Expect(1, 65381, '\p{^Sentence_Break:   	-SCONTINUE}', "");
Expect(1, 65381, '\P{Sentence_Break:   	-SCONTINUE}', "");
Expect(0, 65381, '\P{^Sentence_Break:   	-SCONTINUE}', "");
Error('\p{SB:   _-SC/a/}');
Error('\P{SB:   _-SC/a/}');
Expect(1, 65380, '\p{SB=sc}', "");
Expect(0, 65380, '\p{^SB=sc}', "");
Expect(0, 65380, '\P{SB=sc}', "");
Expect(1, 65380, '\P{^SB=sc}', "");
Expect(0, 65381, '\p{SB=sc}', "");
Expect(1, 65381, '\p{^SB=sc}', "");
Expect(1, 65381, '\P{SB=sc}', "");
Expect(0, 65381, '\P{^SB=sc}', "");
Expect(1, 65380, '\p{SB:	sc}', "");
Expect(0, 65380, '\p{^SB:	sc}', "");
Expect(0, 65380, '\P{SB:	sc}', "");
Expect(1, 65380, '\P{^SB:	sc}', "");
Expect(0, 65381, '\p{SB:	sc}', "");
Expect(1, 65381, '\p{^SB:	sc}', "");
Expect(1, 65381, '\P{SB:	sc}', "");
Expect(0, 65381, '\P{^SB:	sc}', "");
Error('\p{Is_Sentence_Break=/a/ 	SContinue}');
Error('\P{Is_Sentence_Break=/a/ 	SContinue}');
Expect(1, 65380, '\p{Is_Sentence_Break=scontinue}', "");
Expect(0, 65380, '\p{^Is_Sentence_Break=scontinue}', "");
Expect(0, 65380, '\P{Is_Sentence_Break=scontinue}', "");
Expect(1, 65380, '\P{^Is_Sentence_Break=scontinue}', "");
Expect(0, 65381, '\p{Is_Sentence_Break=scontinue}', "");
Expect(1, 65381, '\p{^Is_Sentence_Break=scontinue}', "");
Expect(1, 65381, '\P{Is_Sentence_Break=scontinue}', "");
Expect(0, 65381, '\P{^Is_Sentence_Break=scontinue}', "");
Expect(1, 65380, '\p{Is_Sentence_Break=_scontinue}', "");
Expect(0, 65380, '\p{^Is_Sentence_Break=_scontinue}', "");
Expect(0, 65380, '\P{Is_Sentence_Break=_scontinue}', "");
Expect(1, 65380, '\P{^Is_Sentence_Break=_scontinue}', "");
Expect(0, 65381, '\p{Is_Sentence_Break=_scontinue}', "");
Expect(1, 65381, '\p{^Is_Sentence_Break=_scontinue}', "");
Expect(1, 65381, '\P{Is_Sentence_Break=_scontinue}', "");
Expect(0, 65381, '\P{^Is_Sentence_Break=_scontinue}', "");
Error('\p{Is_SB= /a/SC}');
Error('\P{Is_SB= /a/SC}');
Expect(1, 65380, '\p{Is_SB=sc}', "");
Expect(0, 65380, '\p{^Is_SB=sc}', "");
Expect(0, 65380, '\P{Is_SB=sc}', "");
Expect(1, 65380, '\P{^Is_SB=sc}', "");
Expect(0, 65381, '\p{Is_SB=sc}', "");
Expect(1, 65381, '\p{^Is_SB=sc}', "");
Expect(1, 65381, '\P{Is_SB=sc}', "");
Expect(0, 65381, '\P{^Is_SB=sc}', "");
Expect(1, 65380, '\p{Is_SB=-SC}', "");
Expect(0, 65380, '\p{^Is_SB=-SC}', "");
Expect(0, 65380, '\P{Is_SB=-SC}', "");
Expect(1, 65380, '\P{^Is_SB=-SC}', "");
Expect(0, 65381, '\p{Is_SB=-SC}', "");
Expect(1, 65381, '\p{^Is_SB=-SC}', "");
Expect(1, 65381, '\P{Is_SB=-SC}', "");
Expect(0, 65381, '\P{^Is_SB=-SC}', "");
Error('\p{Sentence_Break=/a/_	Sep}');
Error('\P{Sentence_Break=/a/_	Sep}');
Expect(1, 8233, '\p{Sentence_Break=sep}', "");
Expect(0, 8233, '\p{^Sentence_Break=sep}', "");
Expect(0, 8233, '\P{Sentence_Break=sep}', "");
Expect(1, 8233, '\P{^Sentence_Break=sep}', "");
Expect(0, 8234, '\p{Sentence_Break=sep}', "");
Expect(1, 8234, '\p{^Sentence_Break=sep}', "");
Expect(1, 8234, '\P{Sentence_Break=sep}', "");
Expect(0, 8234, '\P{^Sentence_Break=sep}', "");
Expect(1, 8233, '\p{Sentence_Break=--sep}', "");
Expect(0, 8233, '\p{^Sentence_Break=--sep}', "");
Expect(0, 8233, '\P{Sentence_Break=--sep}', "");
Expect(1, 8233, '\P{^Sentence_Break=--sep}', "");
Expect(0, 8234, '\p{Sentence_Break=--sep}', "");
Expect(1, 8234, '\p{^Sentence_Break=--sep}', "");
Expect(1, 8234, '\P{Sentence_Break=--sep}', "");
Expect(0, 8234, '\P{^Sentence_Break=--sep}', "");
Error('\p{SB=	/a/SE}');
Error('\P{SB=	/a/SE}');
Expect(1, 8233, '\p{SB=se}', "");
Expect(0, 8233, '\p{^SB=se}', "");
Expect(0, 8233, '\P{SB=se}', "");
Expect(1, 8233, '\P{^SB=se}', "");
Expect(0, 8234, '\p{SB=se}', "");
Expect(1, 8234, '\p{^SB=se}', "");
Expect(1, 8234, '\P{SB=se}', "");
Expect(0, 8234, '\P{^SB=se}', "");
Expect(1, 8233, '\p{SB=_SE}', "");
Expect(0, 8233, '\p{^SB=_SE}', "");
Expect(0, 8233, '\P{SB=_SE}', "");
Expect(1, 8233, '\P{^SB=_SE}', "");
Expect(0, 8234, '\p{SB=_SE}', "");
Expect(1, 8234, '\p{^SB=_SE}', "");
Expect(1, 8234, '\P{SB=_SE}', "");
Expect(0, 8234, '\P{^SB=_SE}', "");
Error('\p{Is_Sentence_Break=	sep:=}');
Error('\P{Is_Sentence_Break=	sep:=}');
Expect(1, 8233, '\p{Is_Sentence_Break=sep}', "");
Expect(0, 8233, '\p{^Is_Sentence_Break=sep}', "");
Expect(0, 8233, '\P{Is_Sentence_Break=sep}', "");
Expect(1, 8233, '\P{^Is_Sentence_Break=sep}', "");
Expect(0, 8234, '\p{Is_Sentence_Break=sep}', "");
Expect(1, 8234, '\p{^Is_Sentence_Break=sep}', "");
Expect(1, 8234, '\P{Is_Sentence_Break=sep}', "");
Expect(0, 8234, '\P{^Is_Sentence_Break=sep}', "");
Expect(1, 8233, '\p{Is_Sentence_Break= _SEP}', "");
Expect(0, 8233, '\p{^Is_Sentence_Break= _SEP}', "");
Expect(0, 8233, '\P{Is_Sentence_Break= _SEP}', "");
Expect(1, 8233, '\P{^Is_Sentence_Break= _SEP}', "");
Expect(0, 8234, '\p{Is_Sentence_Break= _SEP}', "");
Expect(1, 8234, '\p{^Is_Sentence_Break= _SEP}', "");
Expect(1, 8234, '\P{Is_Sentence_Break= _SEP}', "");
Expect(0, 8234, '\P{^Is_Sentence_Break= _SEP}', "");
Error('\p{Is_SB=:=	 se}');
Error('\P{Is_SB=:=	 se}');
Expect(1, 8233, '\p{Is_SB=se}', "");
Expect(0, 8233, '\p{^Is_SB=se}', "");
Expect(0, 8233, '\P{Is_SB=se}', "");
Expect(1, 8233, '\P{^Is_SB=se}', "");
Expect(0, 8234, '\p{Is_SB=se}', "");
Expect(1, 8234, '\p{^Is_SB=se}', "");
Expect(1, 8234, '\P{Is_SB=se}', "");
Expect(0, 8234, '\P{^Is_SB=se}', "");
Expect(1, 8233, '\p{Is_SB=- SE}', "");
Expect(0, 8233, '\p{^Is_SB=- SE}', "");
Expect(0, 8233, '\P{Is_SB=- SE}', "");
Expect(1, 8233, '\P{^Is_SB=- SE}', "");
Expect(0, 8234, '\p{Is_SB=- SE}', "");
Expect(1, 8234, '\p{^Is_SB=- SE}', "");
Expect(1, 8234, '\P{Is_SB=- SE}', "");
Expect(0, 8234, '\P{^Is_SB=- SE}', "");
Error('\p{Sentence_Break: 	sp:=}');
Error('\P{Sentence_Break: 	sp:=}');
Expect(1, 12288, '\p{Sentence_Break=sp}', "");
Expect(0, 12288, '\p{^Sentence_Break=sp}', "");
Expect(0, 12288, '\P{Sentence_Break=sp}', "");
Expect(1, 12288, '\P{^Sentence_Break=sp}', "");
Expect(0, 12289, '\p{Sentence_Break=sp}', "");
Expect(1, 12289, '\p{^Sentence_Break=sp}', "");
Expect(1, 12289, '\P{Sentence_Break=sp}', "");
Expect(0, 12289, '\P{^Sentence_Break=sp}', "");
Expect(1, 12288, '\p{Sentence_Break=	sp}', "");
Expect(0, 12288, '\p{^Sentence_Break=	sp}', "");
Expect(0, 12288, '\P{Sentence_Break=	sp}', "");
Expect(1, 12288, '\P{^Sentence_Break=	sp}', "");
Expect(0, 12289, '\p{Sentence_Break=	sp}', "");
Expect(1, 12289, '\p{^Sentence_Break=	sp}', "");
Expect(1, 12289, '\P{Sentence_Break=	sp}', "");
Expect(0, 12289, '\P{^Sentence_Break=	sp}', "");
Error('\p{SB=	:=Sp}');
Error('\P{SB=	:=Sp}');
Expect(1, 12288, '\p{SB=sp}', "");
Expect(0, 12288, '\p{^SB=sp}', "");
Expect(0, 12288, '\P{SB=sp}', "");
Expect(1, 12288, '\P{^SB=sp}', "");
Expect(0, 12289, '\p{SB=sp}', "");
Expect(1, 12289, '\p{^SB=sp}', "");
Expect(1, 12289, '\P{SB=sp}', "");
Expect(0, 12289, '\P{^SB=sp}', "");
Expect(1, 12288, '\p{SB=	Sp}', "");
Expect(0, 12288, '\p{^SB=	Sp}', "");
Expect(0, 12288, '\P{SB=	Sp}', "");
Expect(1, 12288, '\P{^SB=	Sp}', "");
Expect(0, 12289, '\p{SB=	Sp}', "");
Expect(1, 12289, '\p{^SB=	Sp}', "");
Expect(1, 12289, '\P{SB=	Sp}', "");
Expect(0, 12289, '\P{^SB=	Sp}', "");
Error('\p{Is_Sentence_Break=:=	Sp}');
Error('\P{Is_Sentence_Break=:=	Sp}');
Expect(1, 12288, '\p{Is_Sentence_Break=sp}', "");
Expect(0, 12288, '\p{^Is_Sentence_Break=sp}', "");
Expect(0, 12288, '\P{Is_Sentence_Break=sp}', "");
Expect(1, 12288, '\P{^Is_Sentence_Break=sp}', "");
Expect(0, 12289, '\p{Is_Sentence_Break=sp}', "");
Expect(1, 12289, '\p{^Is_Sentence_Break=sp}', "");
Expect(1, 12289, '\P{Is_Sentence_Break=sp}', "");
Expect(0, 12289, '\P{^Is_Sentence_Break=sp}', "");
Expect(1, 12288, '\p{Is_Sentence_Break=	 Sp}', "");
Expect(0, 12288, '\p{^Is_Sentence_Break=	 Sp}', "");
Expect(0, 12288, '\P{Is_Sentence_Break=	 Sp}', "");
Expect(1, 12288, '\P{^Is_Sentence_Break=	 Sp}', "");
Expect(0, 12289, '\p{Is_Sentence_Break=	 Sp}', "");
Expect(1, 12289, '\p{^Is_Sentence_Break=	 Sp}', "");
Expect(1, 12289, '\P{Is_Sentence_Break=	 Sp}', "");
Expect(0, 12289, '\P{^Is_Sentence_Break=	 Sp}', "");
Error('\p{Is_SB=:=	 Sp}');
Error('\P{Is_SB=:=	 Sp}');
Expect(1, 12288, '\p{Is_SB=sp}', "");
Expect(0, 12288, '\p{^Is_SB=sp}', "");
Expect(0, 12288, '\P{Is_SB=sp}', "");
Expect(1, 12288, '\P{^Is_SB=sp}', "");
Expect(0, 12289, '\p{Is_SB=sp}', "");
Expect(1, 12289, '\p{^Is_SB=sp}', "");
Expect(1, 12289, '\P{Is_SB=sp}', "");
Expect(0, 12289, '\P{^Is_SB=sp}', "");
Expect(1, 12288, '\p{Is_SB=	Sp}', "");
Expect(0, 12288, '\p{^Is_SB=	Sp}', "");
Expect(0, 12288, '\P{Is_SB=	Sp}', "");
Expect(1, 12288, '\P{^Is_SB=	Sp}', "");
Expect(0, 12289, '\p{Is_SB=	Sp}', "");
Expect(1, 12289, '\p{^Is_SB=	Sp}', "");
Expect(1, 12289, '\P{Is_SB=	Sp}', "");
Expect(0, 12289, '\P{^Is_SB=	Sp}', "");
Error('\p{Sentence_Break=	-STERM/a/}');
Error('\P{Sentence_Break=	-STERM/a/}');
Expect(1, 113823, '\p{Sentence_Break=sterm}', "");
Expect(0, 113823, '\p{^Sentence_Break=sterm}', "");
Expect(0, 113823, '\P{Sentence_Break=sterm}', "");
Expect(1, 113823, '\P{^Sentence_Break=sterm}', "");
Expect(0, 113824, '\p{Sentence_Break=sterm}', "");
Expect(1, 113824, '\p{^Sentence_Break=sterm}', "");
Expect(1, 113824, '\P{Sentence_Break=sterm}', "");
Expect(0, 113824, '\P{^Sentence_Break=sterm}', "");
Expect(1, 113823, '\p{Sentence_Break=_-STerm}', "");
Expect(0, 113823, '\p{^Sentence_Break=_-STerm}', "");
Expect(0, 113823, '\P{Sentence_Break=_-STerm}', "");
Expect(1, 113823, '\P{^Sentence_Break=_-STerm}', "");
Expect(0, 113824, '\p{Sentence_Break=_-STerm}', "");
Expect(1, 113824, '\p{^Sentence_Break=_-STerm}', "");
Expect(1, 113824, '\P{Sentence_Break=_-STerm}', "");
Expect(0, 113824, '\P{^Sentence_Break=_-STerm}', "");
Error('\p{SB=:=_ST}');
Error('\P{SB=:=_ST}');
Expect(1, 113823, '\p{SB=st}', "");
Expect(0, 113823, '\p{^SB=st}', "");
Expect(0, 113823, '\P{SB=st}', "");
Expect(1, 113823, '\P{^SB=st}', "");
Expect(0, 113824, '\p{SB=st}', "");
Expect(1, 113824, '\p{^SB=st}', "");
Expect(1, 113824, '\P{SB=st}', "");
Expect(0, 113824, '\P{^SB=st}', "");
Expect(1, 113823, '\p{SB=	-ST}', "");
Expect(0, 113823, '\p{^SB=	-ST}', "");
Expect(0, 113823, '\P{SB=	-ST}', "");
Expect(1, 113823, '\P{^SB=	-ST}', "");
Expect(0, 113824, '\p{SB=	-ST}', "");
Expect(1, 113824, '\p{^SB=	-ST}', "");
Expect(1, 113824, '\P{SB=	-ST}', "");
Expect(0, 113824, '\P{^SB=	-ST}', "");
Error('\p{Is_Sentence_Break= /a/STerm}');
Error('\P{Is_Sentence_Break= /a/STerm}');
Expect(1, 113823, '\p{Is_Sentence_Break=sterm}', "");
Expect(0, 113823, '\p{^Is_Sentence_Break=sterm}', "");
Expect(0, 113823, '\P{Is_Sentence_Break=sterm}', "");
Expect(1, 113823, '\P{^Is_Sentence_Break=sterm}', "");
Expect(0, 113824, '\p{Is_Sentence_Break=sterm}', "");
Expect(1, 113824, '\p{^Is_Sentence_Break=sterm}', "");
Expect(1, 113824, '\P{Is_Sentence_Break=sterm}', "");
Expect(0, 113824, '\P{^Is_Sentence_Break=sterm}', "");
Expect(1, 113823, '\p{Is_Sentence_Break=--STerm}', "");
Expect(0, 113823, '\p{^Is_Sentence_Break=--STerm}', "");
Expect(0, 113823, '\P{Is_Sentence_Break=--STerm}', "");
Expect(1, 113823, '\P{^Is_Sentence_Break=--STerm}', "");
Expect(0, 113824, '\p{Is_Sentence_Break=--STerm}', "");
Expect(1, 113824, '\p{^Is_Sentence_Break=--STerm}', "");
Expect(1, 113824, '\P{Is_Sentence_Break=--STerm}', "");
Expect(0, 113824, '\P{^Is_Sentence_Break=--STerm}', "");
Error('\p{Is_SB=	 ST:=}');
Error('\P{Is_SB=	 ST:=}');
Expect(1, 113823, '\p{Is_SB=st}', "");
Expect(0, 113823, '\p{^Is_SB=st}', "");
Expect(0, 113823, '\P{Is_SB=st}', "");
Expect(1, 113823, '\P{^Is_SB=st}', "");
Expect(0, 113824, '\p{Is_SB=st}', "");
Expect(1, 113824, '\p{^Is_SB=st}', "");
Expect(1, 113824, '\P{Is_SB=st}', "");
Expect(0, 113824, '\P{^Is_SB=st}', "");
Expect(1, 113823, '\p{Is_SB=	ST}', "");
Expect(0, 113823, '\p{^Is_SB=	ST}', "");
Expect(0, 113823, '\P{Is_SB=	ST}', "");
Expect(1, 113823, '\P{^Is_SB=	ST}', "");
Expect(0, 113824, '\p{Is_SB=	ST}', "");
Expect(1, 113824, '\p{^Is_SB=	ST}', "");
Expect(1, 113824, '\P{Is_SB=	ST}', "");
Expect(0, 113824, '\P{^Is_SB=	ST}', "");
Error('\p{Sentence_Break=	/a/Upper}');
Error('\P{Sentence_Break=	/a/Upper}');
Expect(1, 127369, '\p{Sentence_Break=upper}', "");
Expect(0, 127369, '\p{^Sentence_Break=upper}', "");
Expect(0, 127369, '\P{Sentence_Break=upper}', "");
Expect(1, 127369, '\P{^Sentence_Break=upper}', "");
Expect(0, 127370, '\p{Sentence_Break=upper}', "");
Expect(1, 127370, '\p{^Sentence_Break=upper}', "");
Expect(1, 127370, '\P{Sentence_Break=upper}', "");
Expect(0, 127370, '\P{^Sentence_Break=upper}', "");
Expect(1, 127369, '\p{Sentence_Break=_UPPER}', "");
Expect(0, 127369, '\p{^Sentence_Break=_UPPER}', "");
Expect(0, 127369, '\P{Sentence_Break=_UPPER}', "");
Expect(1, 127369, '\P{^Sentence_Break=_UPPER}', "");
Expect(0, 127370, '\p{Sentence_Break=_UPPER}', "");
Expect(1, 127370, '\p{^Sentence_Break=_UPPER}', "");
Expect(1, 127370, '\P{Sentence_Break=_UPPER}', "");
Expect(0, 127370, '\P{^Sentence_Break=_UPPER}', "");
Error('\p{SB=/a/UP}');
Error('\P{SB=/a/UP}');
Expect(1, 127369, '\p{SB=up}', "");
Expect(0, 127369, '\p{^SB=up}', "");
Expect(0, 127369, '\P{SB=up}', "");
Expect(1, 127369, '\P{^SB=up}', "");
Expect(0, 127370, '\p{SB=up}', "");
Expect(1, 127370, '\p{^SB=up}', "");
Expect(1, 127370, '\P{SB=up}', "");
Expect(0, 127370, '\P{^SB=up}', "");
Expect(1, 127369, '\p{SB=	-UP}', "");
Expect(0, 127369, '\p{^SB=	-UP}', "");
Expect(0, 127369, '\P{SB=	-UP}', "");
Expect(1, 127369, '\P{^SB=	-UP}', "");
Expect(0, 127370, '\p{SB=	-UP}', "");
Expect(1, 127370, '\p{^SB=	-UP}', "");
Expect(1, 127370, '\P{SB=	-UP}', "");
Expect(0, 127370, '\P{^SB=	-UP}', "");
Error('\p{Is_Sentence_Break=_/a/UPPER}');
Error('\P{Is_Sentence_Break=_/a/UPPER}');
Expect(1, 127369, '\p{Is_Sentence_Break=upper}', "");
Expect(0, 127369, '\p{^Is_Sentence_Break=upper}', "");
Expect(0, 127369, '\P{Is_Sentence_Break=upper}', "");
Expect(1, 127369, '\P{^Is_Sentence_Break=upper}', "");
Expect(0, 127370, '\p{Is_Sentence_Break=upper}', "");
Expect(1, 127370, '\p{^Is_Sentence_Break=upper}', "");
Expect(1, 127370, '\P{Is_Sentence_Break=upper}', "");
Expect(0, 127370, '\P{^Is_Sentence_Break=upper}', "");
Expect(1, 127369, '\p{Is_Sentence_Break=__Upper}', "");
Expect(0, 127369, '\p{^Is_Sentence_Break=__Upper}', "");
Expect(0, 127369, '\P{Is_Sentence_Break=__Upper}', "");
Expect(1, 127369, '\P{^Is_Sentence_Break=__Upper}', "");
Expect(0, 127370, '\p{Is_Sentence_Break=__Upper}', "");
Expect(1, 127370, '\p{^Is_Sentence_Break=__Upper}', "");
Expect(1, 127370, '\P{Is_Sentence_Break=__Upper}', "");
Expect(0, 127370, '\P{^Is_Sentence_Break=__Upper}', "");
Error('\p{Is_SB:/a/--up}');
Error('\P{Is_SB:/a/--up}');
Expect(1, 127369, '\p{Is_SB=up}', "");
Expect(0, 127369, '\p{^Is_SB=up}', "");
Expect(0, 127369, '\P{Is_SB=up}', "");
Expect(1, 127369, '\P{^Is_SB=up}', "");
Expect(0, 127370, '\p{Is_SB=up}', "");
Expect(1, 127370, '\p{^Is_SB=up}', "");
Expect(1, 127370, '\P{Is_SB=up}', "");
Expect(0, 127370, '\P{^Is_SB=up}', "");
Expect(1, 127369, '\p{Is_SB=	-UP}', "");
Expect(0, 127369, '\p{^Is_SB=	-UP}', "");
Expect(0, 127369, '\P{Is_SB=	-UP}', "");
Expect(1, 127369, '\P{^Is_SB=	-UP}', "");
Expect(0, 127370, '\p{Is_SB=	-UP}', "");
Expect(1, 127370, '\p{^Is_SB=	-UP}', "");
Expect(1, 127370, '\P{Is_SB=	-UP}', "");
Expect(0, 127370, '\P{^Is_SB=	-UP}', "");
Error('\p{Sentence_Break=/a/_-other}');
Error('\P{Sentence_Break=/a/_-other}');
Expect(1, 918000, '\p{Sentence_Break=other}', "");
Expect(0, 918000, '\p{^Sentence_Break=other}', "");
Expect(0, 918000, '\P{Sentence_Break=other}', "");
Expect(1, 918000, '\P{^Sentence_Break=other}', "");
Expect(0, 917999, '\p{Sentence_Break=other}', "");
Expect(1, 917999, '\p{^Sentence_Break=other}', "");
Expect(1, 917999, '\P{Sentence_Break=other}', "");
Expect(0, 917999, '\P{^Sentence_Break=other}', "");
Expect(1, 918000, '\p{Sentence_Break=_Other}', "");
Expect(0, 918000, '\p{^Sentence_Break=_Other}', "");
Expect(0, 918000, '\P{Sentence_Break=_Other}', "");
Expect(1, 918000, '\P{^Sentence_Break=_Other}', "");
Expect(0, 917999, '\p{Sentence_Break=_Other}', "");
Expect(1, 917999, '\p{^Sentence_Break=_Other}', "");
Expect(1, 917999, '\P{Sentence_Break=_Other}', "");
Expect(0, 917999, '\P{^Sentence_Break=_Other}', "");
Error('\p{SB=	/a/XX}');
Error('\P{SB=	/a/XX}');
Expect(1, 918000, '\p{SB=xx}', "");
Expect(0, 918000, '\p{^SB=xx}', "");
Expect(0, 918000, '\P{SB=xx}', "");
Expect(1, 918000, '\P{^SB=xx}', "");
Expect(0, 917999, '\p{SB=xx}', "");
Expect(1, 917999, '\p{^SB=xx}', "");
Expect(1, 917999, '\P{SB=xx}', "");
Expect(0, 917999, '\P{^SB=xx}', "");
Expect(1, 918000, '\p{SB=	-XX}', "");
Expect(0, 918000, '\p{^SB=	-XX}', "");
Expect(0, 918000, '\P{SB=	-XX}', "");
Expect(1, 918000, '\P{^SB=	-XX}', "");
Expect(0, 917999, '\p{SB=	-XX}', "");
Expect(1, 917999, '\p{^SB=	-XX}', "");
Expect(1, 917999, '\P{SB=	-XX}', "");
Expect(0, 917999, '\P{^SB=	-XX}', "");
Error('\p{Is_Sentence_Break= :=Other}');
Error('\P{Is_Sentence_Break= :=Other}');
Expect(1, 918000, '\p{Is_Sentence_Break=other}', "");
Expect(0, 918000, '\p{^Is_Sentence_Break=other}', "");
Expect(0, 918000, '\P{Is_Sentence_Break=other}', "");
Expect(1, 918000, '\P{^Is_Sentence_Break=other}', "");
Expect(0, 917999, '\p{Is_Sentence_Break=other}', "");
Expect(1, 917999, '\p{^Is_Sentence_Break=other}', "");
Expect(1, 917999, '\P{Is_Sentence_Break=other}', "");
Expect(0, 917999, '\P{^Is_Sentence_Break=other}', "");
Expect(1, 918000, '\p{Is_Sentence_Break=_OTHER}', "");
Expect(0, 918000, '\p{^Is_Sentence_Break=_OTHER}', "");
Expect(0, 918000, '\P{Is_Sentence_Break=_OTHER}', "");
Expect(1, 918000, '\P{^Is_Sentence_Break=_OTHER}', "");
Expect(0, 917999, '\p{Is_Sentence_Break=_OTHER}', "");
Expect(1, 917999, '\p{^Is_Sentence_Break=_OTHER}', "");
Expect(1, 917999, '\P{Is_Sentence_Break=_OTHER}', "");
Expect(0, 917999, '\P{^Is_Sentence_Break=_OTHER}', "");
Error('\p{Is_SB=/a/_-XX}');
Error('\P{Is_SB=/a/_-XX}');
Expect(1, 918000, '\p{Is_SB=xx}', "");
Expect(0, 918000, '\p{^Is_SB=xx}', "");
Expect(0, 918000, '\P{Is_SB=xx}', "");
Expect(1, 918000, '\P{^Is_SB=xx}', "");
Expect(0, 917999, '\p{Is_SB=xx}', "");
Expect(1, 917999, '\p{^Is_SB=xx}', "");
Expect(1, 917999, '\P{Is_SB=xx}', "");
Expect(0, 917999, '\P{^Is_SB=xx}', "");
Expect(1, 918000, '\p{Is_SB= 	XX}', "");
Expect(0, 918000, '\p{^Is_SB= 	XX}', "");
Expect(0, 918000, '\P{Is_SB= 	XX}', "");
Expect(1, 918000, '\P{^Is_SB= 	XX}', "");
Expect(0, 917999, '\p{Is_SB= 	XX}', "");
Expect(1, 917999, '\p{^Is_SB= 	XX}', "");
Expect(1, 917999, '\P{Is_SB= 	XX}', "");
Expect(0, 917999, '\P{^Is_SB= 	XX}', "");
Error('\p{Soft_Dotted=-_NO/a/}');
Error('\P{Soft_Dotted=-_NO/a/}');
Expect(1, 120468, '\p{Soft_Dotted=no}', "");
Expect(0, 120468, '\p{^Soft_Dotted=no}', "");
Expect(0, 120468, '\P{Soft_Dotted=no}', "");
Expect(1, 120468, '\P{^Soft_Dotted=no}', "");
Expect(0, 120467, '\p{Soft_Dotted=no}', "");
Expect(1, 120467, '\p{^Soft_Dotted=no}', "");
Expect(1, 120467, '\P{Soft_Dotted=no}', "");
Expect(0, 120467, '\P{^Soft_Dotted=no}', "");
Expect(1, 120468, '\p{Soft_Dotted=-no}', "");
Expect(0, 120468, '\p{^Soft_Dotted=-no}', "");
Expect(0, 120468, '\P{Soft_Dotted=-no}', "");
Expect(1, 120468, '\P{^Soft_Dotted=-no}', "");
Expect(0, 120467, '\p{Soft_Dotted=-no}', "");
Expect(1, 120467, '\p{^Soft_Dotted=-no}', "");
Expect(1, 120467, '\P{Soft_Dotted=-no}', "");
Expect(0, 120467, '\P{^Soft_Dotted=-no}', "");
Error('\p{SD=_/a/n}');
Error('\P{SD=_/a/n}');
Expect(1, 120468, '\p{SD=n}', "");
Expect(0, 120468, '\p{^SD=n}', "");
Expect(0, 120468, '\P{SD=n}', "");
Expect(1, 120468, '\P{^SD=n}', "");
Expect(0, 120467, '\p{SD=n}', "");
Expect(1, 120467, '\p{^SD=n}', "");
Expect(1, 120467, '\P{SD=n}', "");
Expect(0, 120467, '\P{^SD=n}', "");
Expect(1, 120468, '\p{SD:	_N}', "");
Expect(0, 120468, '\p{^SD:	_N}', "");
Expect(0, 120468, '\P{SD:	_N}', "");
Expect(1, 120468, '\P{^SD:	_N}', "");
Expect(0, 120467, '\p{SD:	_N}', "");
Expect(1, 120467, '\p{^SD:	_N}', "");
Expect(1, 120467, '\P{SD:	_N}', "");
Expect(0, 120467, '\P{^SD:	_N}', "");
Error('\p{Is_Soft_Dotted=:=F}');
Error('\P{Is_Soft_Dotted=:=F}');
Expect(1, 120468, '\p{Is_Soft_Dotted=f}', "");
Expect(0, 120468, '\p{^Is_Soft_Dotted=f}', "");
Expect(0, 120468, '\P{Is_Soft_Dotted=f}', "");
Expect(1, 120468, '\P{^Is_Soft_Dotted=f}', "");
Expect(0, 120467, '\p{Is_Soft_Dotted=f}', "");
Expect(1, 120467, '\p{^Is_Soft_Dotted=f}', "");
Expect(1, 120467, '\P{Is_Soft_Dotted=f}', "");
Expect(0, 120467, '\P{^Is_Soft_Dotted=f}', "");
Expect(1, 120468, '\p{Is_Soft_Dotted=_	f}', "");
Expect(0, 120468, '\p{^Is_Soft_Dotted=_	f}', "");
Expect(0, 120468, '\P{Is_Soft_Dotted=_	f}', "");
Expect(1, 120468, '\P{^Is_Soft_Dotted=_	f}', "");
Expect(0, 120467, '\p{Is_Soft_Dotted=_	f}', "");
Expect(1, 120467, '\p{^Is_Soft_Dotted=_	f}', "");
Expect(1, 120467, '\P{Is_Soft_Dotted=_	f}', "");
Expect(0, 120467, '\P{^Is_Soft_Dotted=_	f}', "");
Error('\p{Is_SD= /a/FALSE}');
Error('\P{Is_SD= /a/FALSE}');
Expect(1, 120468, '\p{Is_SD=false}', "");
Expect(0, 120468, '\p{^Is_SD=false}', "");
Expect(0, 120468, '\P{Is_SD=false}', "");
Expect(1, 120468, '\P{^Is_SD=false}', "");
Expect(0, 120467, '\p{Is_SD=false}', "");
Expect(1, 120467, '\p{^Is_SD=false}', "");
Expect(1, 120467, '\P{Is_SD=false}', "");
Expect(0, 120467, '\P{^Is_SD=false}', "");
Expect(1, 120468, '\p{Is_SD=	_FALSE}', "");
Expect(0, 120468, '\p{^Is_SD=	_FALSE}', "");
Expect(0, 120468, '\P{Is_SD=	_FALSE}', "");
Expect(1, 120468, '\P{^Is_SD=	_FALSE}', "");
Expect(0, 120467, '\p{Is_SD=	_FALSE}', "");
Expect(1, 120467, '\p{^Is_SD=	_FALSE}', "");
Expect(1, 120467, '\P{Is_SD=	_FALSE}', "");
Expect(0, 120467, '\P{^Is_SD=	_FALSE}', "");
Error('\p{Soft_Dotted=:= yes}');
Error('\P{Soft_Dotted=:= yes}');
Expect(1, 120467, '\p{Soft_Dotted:yes}', "");
Expect(0, 120467, '\p{^Soft_Dotted:yes}', "");
Expect(0, 120467, '\P{Soft_Dotted:yes}', "");
Expect(1, 120467, '\P{^Soft_Dotted:yes}', "");
Expect(0, 120468, '\p{Soft_Dotted:yes}', "");
Expect(1, 120468, '\p{^Soft_Dotted:yes}', "");
Expect(1, 120468, '\P{Soft_Dotted:yes}', "");
Expect(0, 120468, '\P{^Soft_Dotted:yes}', "");
Expect(1, 120467, '\p{Soft_Dotted=		yes}', "");
Expect(0, 120467, '\p{^Soft_Dotted=		yes}', "");
Expect(0, 120467, '\P{Soft_Dotted=		yes}', "");
Expect(1, 120467, '\P{^Soft_Dotted=		yes}', "");
Expect(0, 120468, '\p{Soft_Dotted=		yes}', "");
Expect(1, 120468, '\p{^Soft_Dotted=		yes}', "");
Expect(1, 120468, '\P{Soft_Dotted=		yes}', "");
Expect(0, 120468, '\P{^Soft_Dotted=		yes}', "");
Error('\p{SD:_ y/a/}');
Error('\P{SD:_ y/a/}');
Expect(1, 120467, '\p{SD: y}', "");
Expect(0, 120467, '\p{^SD: y}', "");
Expect(0, 120467, '\P{SD: y}', "");
Expect(1, 120467, '\P{^SD: y}', "");
Expect(0, 120468, '\p{SD: y}', "");
Expect(1, 120468, '\p{^SD: y}', "");
Expect(1, 120468, '\P{SD: y}', "");
Expect(0, 120468, '\P{^SD: y}', "");
Expect(1, 120467, '\p{SD=-Y}', "");
Expect(0, 120467, '\p{^SD=-Y}', "");
Expect(0, 120467, '\P{SD=-Y}', "");
Expect(1, 120467, '\P{^SD=-Y}', "");
Expect(0, 120468, '\p{SD=-Y}', "");
Expect(1, 120468, '\p{^SD=-Y}', "");
Expect(1, 120468, '\P{SD=-Y}', "");
Expect(0, 120468, '\P{^SD=-Y}', "");
Error('\p{Is_Soft_Dotted=:=	t}');
Error('\P{Is_Soft_Dotted=:=	t}');
Expect(1, 120467, '\p{Is_Soft_Dotted=t}', "");
Expect(0, 120467, '\p{^Is_Soft_Dotted=t}', "");
Expect(0, 120467, '\P{Is_Soft_Dotted=t}', "");
Expect(1, 120467, '\P{^Is_Soft_Dotted=t}', "");
Expect(0, 120468, '\p{Is_Soft_Dotted=t}', "");
Expect(1, 120468, '\p{^Is_Soft_Dotted=t}', "");
Expect(1, 120468, '\P{Is_Soft_Dotted=t}', "");
Expect(0, 120468, '\P{^Is_Soft_Dotted=t}', "");
Expect(1, 120467, '\p{Is_Soft_Dotted: 	 T}', "");
Expect(0, 120467, '\p{^Is_Soft_Dotted: 	 T}', "");
Expect(0, 120467, '\P{Is_Soft_Dotted: 	 T}', "");
Expect(1, 120467, '\P{^Is_Soft_Dotted: 	 T}', "");
Expect(0, 120468, '\p{Is_Soft_Dotted: 	 T}', "");
Expect(1, 120468, '\p{^Is_Soft_Dotted: 	 T}', "");
Expect(1, 120468, '\P{Is_Soft_Dotted: 	 T}', "");
Expect(0, 120468, '\P{^Is_Soft_Dotted: 	 T}', "");
Error('\p{Is_SD= 	true:=}');
Error('\P{Is_SD= 	true:=}');
Expect(1, 120467, '\p{Is_SD=true}', "");
Expect(0, 120467, '\p{^Is_SD=true}', "");
Expect(0, 120467, '\P{Is_SD=true}', "");
Expect(1, 120467, '\P{^Is_SD=true}', "");
Expect(0, 120468, '\p{Is_SD=true}', "");
Expect(1, 120468, '\p{^Is_SD=true}', "");
Expect(1, 120468, '\P{Is_SD=true}', "");
Expect(0, 120468, '\P{^Is_SD=true}', "");
Expect(1, 120467, '\p{Is_SD=	-true}', "");
Expect(0, 120467, '\p{^Is_SD=	-true}', "");
Expect(0, 120467, '\P{Is_SD=	-true}', "");
Expect(1, 120467, '\P{^Is_SD=	-true}', "");
Expect(0, 120468, '\p{Is_SD=	-true}', "");
Expect(1, 120468, '\p{^Is_SD=	-true}', "");
Expect(1, 120468, '\P{Is_SD=	-true}', "");
Expect(0, 120468, '\P{^Is_SD=	-true}', "");
Error('\p{STerm=_:=No}');
Error('\P{STerm=_:=No}');
Expect(1, 113824, '\p{STerm=no}', "");
Expect(0, 113824, '\p{^STerm=no}', "");
Expect(0, 113824, '\P{STerm=no}', "");
Expect(1, 113824, '\P{^STerm=no}', "");
Expect(0, 113823, '\p{STerm=no}', "");
Expect(1, 113823, '\p{^STerm=no}', "");
Expect(1, 113823, '\P{STerm=no}', "");
Expect(0, 113823, '\P{^STerm=no}', "");
Expect(1, 113824, '\p{STerm= _No}', "");
Expect(0, 113824, '\p{^STerm= _No}', "");
Expect(0, 113824, '\P{STerm= _No}', "");
Expect(1, 113824, '\P{^STerm= _No}', "");
Expect(0, 113823, '\p{STerm= _No}', "");
Expect(1, 113823, '\p{^STerm= _No}', "");
Expect(1, 113823, '\P{STerm= _No}', "");
Expect(0, 113823, '\P{^STerm= _No}', "");
Error('\p{Is_STerm:		_N/a/}');
Error('\P{Is_STerm:		_N/a/}');
Expect(1, 113824, '\p{Is_STerm=n}', "");
Expect(0, 113824, '\p{^Is_STerm=n}', "");
Expect(0, 113824, '\P{Is_STerm=n}', "");
Expect(1, 113824, '\P{^Is_STerm=n}', "");
Expect(0, 113823, '\p{Is_STerm=n}', "");
Expect(1, 113823, '\p{^Is_STerm=n}', "");
Expect(1, 113823, '\P{Is_STerm=n}', "");
Expect(0, 113823, '\P{^Is_STerm=n}', "");
Expect(1, 113824, '\p{Is_STerm=	_N}', "");
Expect(0, 113824, '\p{^Is_STerm=	_N}', "");
Expect(0, 113824, '\P{Is_STerm=	_N}', "");
Expect(1, 113824, '\P{^Is_STerm=	_N}', "");
Expect(0, 113823, '\p{Is_STerm=	_N}', "");
Expect(1, 113823, '\p{^Is_STerm=	_N}', "");
Expect(1, 113823, '\P{Is_STerm=	_N}', "");
Expect(0, 113823, '\P{^Is_STerm=	_N}', "");
Error('\p{STerm=:=	_F}');
Error('\P{STerm=:=	_F}');
Expect(1, 113824, '\p{STerm=f}', "");
Expect(0, 113824, '\p{^STerm=f}', "");
Expect(0, 113824, '\P{STerm=f}', "");
Expect(1, 113824, '\P{^STerm=f}', "");
Expect(0, 113823, '\p{STerm=f}', "");
Expect(1, 113823, '\p{^STerm=f}', "");
Expect(1, 113823, '\P{STerm=f}', "");
Expect(0, 113823, '\P{^STerm=f}', "");
Expect(1, 113824, '\p{STerm=	_F}', "");
Expect(0, 113824, '\p{^STerm=	_F}', "");
Expect(0, 113824, '\P{STerm=	_F}', "");
Expect(1, 113824, '\P{^STerm=	_F}', "");
Expect(0, 113823, '\p{STerm=	_F}', "");
Expect(1, 113823, '\p{^STerm=	_F}', "");
Expect(1, 113823, '\P{STerm=	_F}', "");
Expect(0, 113823, '\P{^STerm=	_F}', "");
Error('\p{Is_STerm=__false:=}');
Error('\P{Is_STerm=__false:=}');
Expect(1, 113824, '\p{Is_STerm=false}', "");
Expect(0, 113824, '\p{^Is_STerm=false}', "");
Expect(0, 113824, '\P{Is_STerm=false}', "");
Expect(1, 113824, '\P{^Is_STerm=false}', "");
Expect(0, 113823, '\p{Is_STerm=false}', "");
Expect(1, 113823, '\p{^Is_STerm=false}', "");
Expect(1, 113823, '\P{Is_STerm=false}', "");
Expect(0, 113823, '\P{^Is_STerm=false}', "");
Expect(1, 113824, '\p{Is_STerm=  False}', "");
Expect(0, 113824, '\p{^Is_STerm=  False}', "");
Expect(0, 113824, '\P{Is_STerm=  False}', "");
Expect(1, 113824, '\P{^Is_STerm=  False}', "");
Expect(0, 113823, '\p{Is_STerm=  False}', "");
Expect(1, 113823, '\p{^Is_STerm=  False}', "");
Expect(1, 113823, '\P{Is_STerm=  False}', "");
Expect(0, 113823, '\P{^Is_STerm=  False}', "");
Error('\p{STerm=:=	_Yes}');
Error('\P{STerm=:=	_Yes}');
Expect(1, 113823, '\p{STerm=yes}', "");
Expect(0, 113823, '\p{^STerm=yes}', "");
Expect(0, 113823, '\P{STerm=yes}', "");
Expect(1, 113823, '\P{^STerm=yes}', "");
Expect(0, 113824, '\p{STerm=yes}', "");
Expect(1, 113824, '\p{^STerm=yes}', "");
Expect(1, 113824, '\P{STerm=yes}', "");
Expect(0, 113824, '\P{^STerm=yes}', "");
Expect(1, 113823, '\p{STerm=_-Yes}', "");
Expect(0, 113823, '\p{^STerm=_-Yes}', "");
Expect(0, 113823, '\P{STerm=_-Yes}', "");
Expect(1, 113823, '\P{^STerm=_-Yes}', "");
Expect(0, 113824, '\p{STerm=_-Yes}', "");
Expect(1, 113824, '\p{^STerm=_-Yes}', "");
Expect(1, 113824, '\P{STerm=_-Yes}', "");
Expect(0, 113824, '\P{^STerm=_-Yes}', "");
Error('\p{Is_STerm=/a/_Y}');
Error('\P{Is_STerm=/a/_Y}');
Expect(1, 113823, '\p{Is_STerm=y}', "");
Expect(0, 113823, '\p{^Is_STerm=y}', "");
Expect(0, 113823, '\P{Is_STerm=y}', "");
Expect(1, 113823, '\P{^Is_STerm=y}', "");
Expect(0, 113824, '\p{Is_STerm=y}', "");
Expect(1, 113824, '\p{^Is_STerm=y}', "");
Expect(1, 113824, '\P{Is_STerm=y}', "");
Expect(0, 113824, '\P{^Is_STerm=y}', "");
Expect(1, 113823, '\p{Is_STerm=	 y}', "");
Expect(0, 113823, '\p{^Is_STerm=	 y}', "");
Expect(0, 113823, '\P{Is_STerm=	 y}', "");
Expect(1, 113823, '\P{^Is_STerm=	 y}', "");
Expect(0, 113824, '\p{Is_STerm=	 y}', "");
Expect(1, 113824, '\p{^Is_STerm=	 y}', "");
Expect(1, 113824, '\P{Is_STerm=	 y}', "");
Expect(0, 113824, '\P{^Is_STerm=	 y}', "");
Error('\p{STerm=:=	-T}');
Error('\P{STerm=:=	-T}');
Expect(1, 113823, '\p{STerm=t}', "");
Expect(0, 113823, '\p{^STerm=t}', "");
Expect(0, 113823, '\P{STerm=t}', "");
Expect(1, 113823, '\P{^STerm=t}', "");
Expect(0, 113824, '\p{STerm=t}', "");
Expect(1, 113824, '\p{^STerm=t}', "");
Expect(1, 113824, '\P{STerm=t}', "");
Expect(0, 113824, '\P{^STerm=t}', "");
Expect(1, 113823, '\p{STerm=T}', "");
Expect(0, 113823, '\p{^STerm=T}', "");
Expect(0, 113823, '\P{STerm=T}', "");
Expect(1, 113823, '\P{^STerm=T}', "");
Expect(0, 113824, '\p{STerm=T}', "");
Expect(1, 113824, '\p{^STerm=T}', "");
Expect(1, 113824, '\P{STerm=T}', "");
Expect(0, 113824, '\P{^STerm=T}', "");
Error('\p{Is_STerm=-TRUE:=}');
Error('\P{Is_STerm=-TRUE:=}');
Expect(1, 113823, '\p{Is_STerm=true}', "");
Expect(0, 113823, '\p{^Is_STerm=true}', "");
Expect(0, 113823, '\P{Is_STerm=true}', "");
Expect(1, 113823, '\P{^Is_STerm=true}', "");
Expect(0, 113824, '\p{Is_STerm=true}', "");
Expect(1, 113824, '\p{^Is_STerm=true}', "");
Expect(1, 113824, '\P{Is_STerm=true}', "");
Expect(0, 113824, '\P{^Is_STerm=true}', "");
Expect(1, 113823, '\p{Is_STerm=	 true}', "");
Expect(0, 113823, '\p{^Is_STerm=	 true}', "");
Expect(0, 113823, '\P{Is_STerm=	 true}', "");
Expect(1, 113823, '\P{^Is_STerm=	 true}', "");
Expect(0, 113824, '\p{Is_STerm=	 true}', "");
Expect(1, 113824, '\p{^Is_STerm=	 true}', "");
Expect(1, 113824, '\P{Is_STerm=	 true}', "");
Expect(0, 113824, '\P{^Is_STerm=	 true}', "");
Error('\p{Terminal_Punctuation= :=No}');
Error('\P{Terminal_Punctuation= :=No}');
Expect(1, 113824, '\p{Terminal_Punctuation=no}', "");
Expect(0, 113824, '\p{^Terminal_Punctuation=no}', "");
Expect(0, 113824, '\P{Terminal_Punctuation=no}', "");
Expect(1, 113824, '\P{^Terminal_Punctuation=no}', "");
Expect(0, 113823, '\p{Terminal_Punctuation=no}', "");
Expect(1, 113823, '\p{^Terminal_Punctuation=no}', "");
Expect(1, 113823, '\P{Terminal_Punctuation=no}', "");
Expect(0, 113823, '\P{^Terminal_Punctuation=no}', "");
Expect(1, 113824, '\p{Terminal_Punctuation= 	No}', "");
Expect(0, 113824, '\p{^Terminal_Punctuation= 	No}', "");
Expect(0, 113824, '\P{Terminal_Punctuation= 	No}', "");
Expect(1, 113824, '\P{^Terminal_Punctuation= 	No}', "");
Expect(0, 113823, '\p{Terminal_Punctuation= 	No}', "");
Expect(1, 113823, '\p{^Terminal_Punctuation= 	No}', "");
Expect(1, 113823, '\P{Terminal_Punctuation= 	No}', "");
Expect(0, 113823, '\P{^Terminal_Punctuation= 	No}', "");
Error('\p{Term= N/a/}');
Error('\P{Term= N/a/}');
Expect(1, 113824, '\p{Term=n}', "");
Expect(0, 113824, '\p{^Term=n}', "");
Expect(0, 113824, '\P{Term=n}', "");
Expect(1, 113824, '\P{^Term=n}', "");
Expect(0, 113823, '\p{Term=n}', "");
Expect(1, 113823, '\p{^Term=n}', "");
Expect(1, 113823, '\P{Term=n}', "");
Expect(0, 113823, '\P{^Term=n}', "");
Expect(1, 113824, '\p{Term=  N}', "");
Expect(0, 113824, '\p{^Term=  N}', "");
Expect(0, 113824, '\P{Term=  N}', "");
Expect(1, 113824, '\P{^Term=  N}', "");
Expect(0, 113823, '\p{Term=  N}', "");
Expect(1, 113823, '\p{^Term=  N}', "");
Expect(1, 113823, '\P{Term=  N}', "");
Expect(0, 113823, '\P{^Term=  N}', "");
Error('\p{Is_Terminal_Punctuation=:=-_F}');
Error('\P{Is_Terminal_Punctuation=:=-_F}');
Expect(1, 113824, '\p{Is_Terminal_Punctuation=f}', "");
Expect(0, 113824, '\p{^Is_Terminal_Punctuation=f}', "");
Expect(0, 113824, '\P{Is_Terminal_Punctuation=f}', "");
Expect(1, 113824, '\P{^Is_Terminal_Punctuation=f}', "");
Expect(0, 113823, '\p{Is_Terminal_Punctuation=f}', "");
Expect(1, 113823, '\p{^Is_Terminal_Punctuation=f}', "");
Expect(1, 113823, '\P{Is_Terminal_Punctuation=f}', "");
Expect(0, 113823, '\P{^Is_Terminal_Punctuation=f}', "");
Expect(1, 113824, '\p{Is_Terminal_Punctuation= F}', "");
Expect(0, 113824, '\p{^Is_Terminal_Punctuation= F}', "");
Expect(0, 113824, '\P{Is_Terminal_Punctuation= F}', "");
Expect(1, 113824, '\P{^Is_Terminal_Punctuation= F}', "");
Expect(0, 113823, '\p{Is_Terminal_Punctuation= F}', "");
Expect(1, 113823, '\p{^Is_Terminal_Punctuation= F}', "");
Expect(1, 113823, '\P{Is_Terminal_Punctuation= F}', "");
Expect(0, 113823, '\P{^Is_Terminal_Punctuation= F}', "");
Error('\p{Is_Term=-	False/a/}');
Error('\P{Is_Term=-	False/a/}');
Expect(1, 113824, '\p{Is_Term=false}', "");
Expect(0, 113824, '\p{^Is_Term=false}', "");
Expect(0, 113824, '\P{Is_Term=false}', "");
Expect(1, 113824, '\P{^Is_Term=false}', "");
Expect(0, 113823, '\p{Is_Term=false}', "");
Expect(1, 113823, '\p{^Is_Term=false}', "");
Expect(1, 113823, '\P{Is_Term=false}', "");
Expect(0, 113823, '\P{^Is_Term=false}', "");
Expect(1, 113824, '\p{Is_Term:	- False}', "");
Expect(0, 113824, '\p{^Is_Term:	- False}', "");
Expect(0, 113824, '\P{Is_Term:	- False}', "");
Expect(1, 113824, '\P{^Is_Term:	- False}', "");
Expect(0, 113823, '\p{Is_Term:	- False}', "");
Expect(1, 113823, '\p{^Is_Term:	- False}', "");
Expect(1, 113823, '\P{Is_Term:	- False}', "");
Expect(0, 113823, '\P{^Is_Term:	- False}', "");
Error('\p{Terminal_Punctuation=/a/ -yes}');
Error('\P{Terminal_Punctuation=/a/ -yes}');
Expect(1, 113823, '\p{Terminal_Punctuation=yes}', "");
Expect(0, 113823, '\p{^Terminal_Punctuation=yes}', "");
Expect(0, 113823, '\P{Terminal_Punctuation=yes}', "");
Expect(1, 113823, '\P{^Terminal_Punctuation=yes}', "");
Expect(0, 113824, '\p{Terminal_Punctuation=yes}', "");
Expect(1, 113824, '\p{^Terminal_Punctuation=yes}', "");
Expect(1, 113824, '\P{Terminal_Punctuation=yes}', "");
Expect(0, 113824, '\P{^Terminal_Punctuation=yes}', "");
Expect(1, 113823, '\p{Terminal_Punctuation= Yes}', "");
Expect(0, 113823, '\p{^Terminal_Punctuation= Yes}', "");
Expect(0, 113823, '\P{Terminal_Punctuation= Yes}', "");
Expect(1, 113823, '\P{^Terminal_Punctuation= Yes}', "");
Expect(0, 113824, '\p{Terminal_Punctuation= Yes}', "");
Expect(1, 113824, '\p{^Terminal_Punctuation= Yes}', "");
Expect(1, 113824, '\P{Terminal_Punctuation= Yes}', "");
Expect(0, 113824, '\P{^Terminal_Punctuation= Yes}', "");
Error('\p{Term:	  Y/a/}');
Error('\P{Term:	  Y/a/}');
Expect(1, 113823, '\p{Term=y}', "");
Expect(0, 113823, '\p{^Term=y}', "");
Expect(0, 113823, '\P{Term=y}', "");
Expect(1, 113823, '\P{^Term=y}', "");
Expect(0, 113824, '\p{Term=y}', "");
Expect(1, 113824, '\p{^Term=y}', "");
Expect(1, 113824, '\P{Term=y}', "");
Expect(0, 113824, '\P{^Term=y}', "");
Expect(1, 113823, '\p{Term= y}', "");
Expect(0, 113823, '\p{^Term= y}', "");
Expect(0, 113823, '\P{Term= y}', "");
Expect(1, 113823, '\P{^Term= y}', "");
Expect(0, 113824, '\p{Term= y}', "");
Expect(1, 113824, '\p{^Term= y}', "");
Expect(1, 113824, '\P{Term= y}', "");
Expect(0, 113824, '\P{^Term= y}', "");
Error('\p{Is_Terminal_Punctuation:	_:=t}');
Error('\P{Is_Terminal_Punctuation:	_:=t}');
Expect(1, 113823, '\p{Is_Terminal_Punctuation=t}', "");
Expect(0, 113823, '\p{^Is_Terminal_Punctuation=t}', "");
Expect(0, 113823, '\P{Is_Terminal_Punctuation=t}', "");
Expect(1, 113823, '\P{^Is_Terminal_Punctuation=t}', "");
Expect(0, 113824, '\p{Is_Terminal_Punctuation=t}', "");
Expect(1, 113824, '\p{^Is_Terminal_Punctuation=t}', "");
Expect(1, 113824, '\P{Is_Terminal_Punctuation=t}', "");
Expect(0, 113824, '\P{^Is_Terminal_Punctuation=t}', "");
Expect(1, 113823, '\p{Is_Terminal_Punctuation=-T}', "");
Expect(0, 113823, '\p{^Is_Terminal_Punctuation=-T}', "");
Expect(0, 113823, '\P{Is_Terminal_Punctuation=-T}', "");
Expect(1, 113823, '\P{^Is_Terminal_Punctuation=-T}', "");
Expect(0, 113824, '\p{Is_Terminal_Punctuation=-T}', "");
Expect(1, 113824, '\p{^Is_Terminal_Punctuation=-T}', "");
Expect(1, 113824, '\P{Is_Terminal_Punctuation=-T}', "");
Expect(0, 113824, '\P{^Is_Terminal_Punctuation=-T}', "");
Error('\p{Is_Term=_True:=}');
Error('\P{Is_Term=_True:=}');
Expect(1, 113823, '\p{Is_Term=true}', "");
Expect(0, 113823, '\p{^Is_Term=true}', "");
Expect(0, 113823, '\P{Is_Term=true}', "");
Expect(1, 113823, '\P{^Is_Term=true}', "");
Expect(0, 113824, '\p{Is_Term=true}', "");
Expect(1, 113824, '\p{^Is_Term=true}', "");
Expect(1, 113824, '\P{Is_Term=true}', "");
Expect(0, 113824, '\P{^Is_Term=true}', "");
Expect(1, 113823, '\p{Is_Term=	True}', "");
Expect(0, 113823, '\p{^Is_Term=	True}', "");
Expect(0, 113823, '\P{Is_Term=	True}', "");
Expect(1, 113823, '\P{^Is_Term=	True}', "");
Expect(0, 113824, '\p{Is_Term=	True}', "");
Expect(1, 113824, '\p{^Is_Term=	True}', "");
Expect(1, 113824, '\P{Is_Term=	True}', "");
Expect(0, 113824, '\P{^Is_Term=	True}', "");
Error('\p{Unified_Ideograph=/a/ 	No}');
Error('\P{Unified_Ideograph=/a/ 	No}');
Expect(1, 178206, '\p{Unified_Ideograph=no}', "");
Expect(0, 178206, '\p{^Unified_Ideograph=no}', "");
Expect(0, 178206, '\P{Unified_Ideograph=no}', "");
Expect(1, 178206, '\P{^Unified_Ideograph=no}', "");
Expect(0, 178205, '\p{Unified_Ideograph=no}', "");
Expect(1, 178205, '\p{^Unified_Ideograph=no}', "");
Expect(1, 178205, '\P{Unified_Ideograph=no}', "");
Expect(0, 178205, '\P{^Unified_Ideograph=no}', "");
Expect(1, 178206, '\p{Unified_Ideograph=_ No}', "");
Expect(0, 178206, '\p{^Unified_Ideograph=_ No}', "");
Expect(0, 178206, '\P{Unified_Ideograph=_ No}', "");
Expect(1, 178206, '\P{^Unified_Ideograph=_ No}', "");
Expect(0, 178205, '\p{Unified_Ideograph=_ No}', "");
Expect(1, 178205, '\p{^Unified_Ideograph=_ No}', "");
Expect(1, 178205, '\P{Unified_Ideograph=_ No}', "");
Expect(0, 178205, '\P{^Unified_Ideograph=_ No}', "");
Error('\p{UIdeo=/a/N}');
Error('\P{UIdeo=/a/N}');
Expect(1, 178206, '\p{UIdeo=n}', "");
Expect(0, 178206, '\p{^UIdeo=n}', "");
Expect(0, 178206, '\P{UIdeo=n}', "");
Expect(1, 178206, '\P{^UIdeo=n}', "");
Expect(0, 178205, '\p{UIdeo=n}', "");
Expect(1, 178205, '\p{^UIdeo=n}', "");
Expect(1, 178205, '\P{UIdeo=n}', "");
Expect(0, 178205, '\P{^UIdeo=n}', "");
Expect(1, 178206, '\p{UIdeo=	 N}', "");
Expect(0, 178206, '\p{^UIdeo=	 N}', "");
Expect(0, 178206, '\P{UIdeo=	 N}', "");
Expect(1, 178206, '\P{^UIdeo=	 N}', "");
Expect(0, 178205, '\p{UIdeo=	 N}', "");
Expect(1, 178205, '\p{^UIdeo=	 N}', "");
Expect(1, 178205, '\P{UIdeo=	 N}', "");
Expect(0, 178205, '\P{^UIdeo=	 N}', "");
Error('\p{Is_Unified_Ideograph: /a/- f}');
Error('\P{Is_Unified_Ideograph: /a/- f}');
Expect(1, 178206, '\p{Is_Unified_Ideograph=f}', "");
Expect(0, 178206, '\p{^Is_Unified_Ideograph=f}', "");
Expect(0, 178206, '\P{Is_Unified_Ideograph=f}', "");
Expect(1, 178206, '\P{^Is_Unified_Ideograph=f}', "");
Expect(0, 178205, '\p{Is_Unified_Ideograph=f}', "");
Expect(1, 178205, '\p{^Is_Unified_Ideograph=f}', "");
Expect(1, 178205, '\P{Is_Unified_Ideograph=f}', "");
Expect(0, 178205, '\P{^Is_Unified_Ideograph=f}', "");
Expect(1, 178206, '\p{Is_Unified_Ideograph=	f}', "");
Expect(0, 178206, '\p{^Is_Unified_Ideograph=	f}', "");
Expect(0, 178206, '\P{Is_Unified_Ideograph=	f}', "");
Expect(1, 178206, '\P{^Is_Unified_Ideograph=	f}', "");
Expect(0, 178205, '\p{Is_Unified_Ideograph=	f}', "");
Expect(1, 178205, '\p{^Is_Unified_Ideograph=	f}', "");
Expect(1, 178205, '\P{Is_Unified_Ideograph=	f}', "");
Expect(0, 178205, '\P{^Is_Unified_Ideograph=	f}', "");
Error('\p{Is_UIdeo:	_False/a/}');
Error('\P{Is_UIdeo:	_False/a/}');
Expect(1, 178206, '\p{Is_UIdeo=false}', "");
Expect(0, 178206, '\p{^Is_UIdeo=false}', "");
Expect(0, 178206, '\P{Is_UIdeo=false}', "");
Expect(1, 178206, '\P{^Is_UIdeo=false}', "");
Expect(0, 178205, '\p{Is_UIdeo=false}', "");
Expect(1, 178205, '\p{^Is_UIdeo=false}', "");
Expect(1, 178205, '\P{Is_UIdeo=false}', "");
Expect(0, 178205, '\P{^Is_UIdeo=false}', "");
Expect(1, 178206, '\p{Is_UIdeo=-_False}', "");
Expect(0, 178206, '\p{^Is_UIdeo=-_False}', "");
Expect(0, 178206, '\P{Is_UIdeo=-_False}', "");
Expect(1, 178206, '\P{^Is_UIdeo=-_False}', "");
Expect(0, 178205, '\p{Is_UIdeo=-_False}', "");
Expect(1, 178205, '\p{^Is_UIdeo=-_False}', "");
Expect(1, 178205, '\P{Is_UIdeo=-_False}', "");
Expect(0, 178205, '\P{^Is_UIdeo=-_False}', "");
Error('\p{Unified_Ideograph:    Yes:=}');
Error('\P{Unified_Ideograph:    Yes:=}');
Expect(1, 178205, '\p{Unified_Ideograph=yes}', "");
Expect(0, 178205, '\p{^Unified_Ideograph=yes}', "");
Expect(0, 178205, '\P{Unified_Ideograph=yes}', "");
Expect(1, 178205, '\P{^Unified_Ideograph=yes}', "");
Expect(0, 178206, '\p{Unified_Ideograph=yes}', "");
Expect(1, 178206, '\p{^Unified_Ideograph=yes}', "");
Expect(1, 178206, '\P{Unified_Ideograph=yes}', "");
Expect(0, 178206, '\P{^Unified_Ideograph=yes}', "");
Expect(1, 178205, '\p{Unified_Ideograph=	 yes}', "");
Expect(0, 178205, '\p{^Unified_Ideograph=	 yes}', "");
Expect(0, 178205, '\P{Unified_Ideograph=	 yes}', "");
Expect(1, 178205, '\P{^Unified_Ideograph=	 yes}', "");
Expect(0, 178206, '\p{Unified_Ideograph=	 yes}', "");
Expect(1, 178206, '\p{^Unified_Ideograph=	 yes}', "");
Expect(1, 178206, '\P{Unified_Ideograph=	 yes}', "");
Expect(0, 178206, '\P{^Unified_Ideograph=	 yes}', "");
Error('\p{UIdeo=	-y:=}');
Error('\P{UIdeo=	-y:=}');
Expect(1, 178205, '\p{UIdeo=y}', "");
Expect(0, 178205, '\p{^UIdeo=y}', "");
Expect(0, 178205, '\P{UIdeo=y}', "");
Expect(1, 178205, '\P{^UIdeo=y}', "");
Expect(0, 178206, '\p{UIdeo=y}', "");
Expect(1, 178206, '\p{^UIdeo=y}', "");
Expect(1, 178206, '\P{UIdeo=y}', "");
Expect(0, 178206, '\P{^UIdeo=y}', "");
Expect(1, 178205, '\p{UIdeo=	Y}', "");
Expect(0, 178205, '\p{^UIdeo=	Y}', "");
Expect(0, 178205, '\P{UIdeo=	Y}', "");
Expect(1, 178205, '\P{^UIdeo=	Y}', "");
Expect(0, 178206, '\p{UIdeo=	Y}', "");
Expect(1, 178206, '\p{^UIdeo=	Y}', "");
Expect(1, 178206, '\P{UIdeo=	Y}', "");
Expect(0, 178206, '\P{^UIdeo=	Y}', "");
Error('\p{Is_Unified_Ideograph= 	T:=}');
Error('\P{Is_Unified_Ideograph= 	T:=}');
Expect(1, 178205, '\p{Is_Unified_Ideograph=t}', "");
Expect(0, 178205, '\p{^Is_Unified_Ideograph=t}', "");
Expect(0, 178205, '\P{Is_Unified_Ideograph=t}', "");
Expect(1, 178205, '\P{^Is_Unified_Ideograph=t}', "");
Expect(0, 178206, '\p{Is_Unified_Ideograph=t}', "");
Expect(1, 178206, '\p{^Is_Unified_Ideograph=t}', "");
Expect(1, 178206, '\P{Is_Unified_Ideograph=t}', "");
Expect(0, 178206, '\P{^Is_Unified_Ideograph=t}', "");
Expect(1, 178205, '\p{Is_Unified_Ideograph=__T}', "");
Expect(0, 178205, '\p{^Is_Unified_Ideograph=__T}', "");
Expect(0, 178205, '\P{Is_Unified_Ideograph=__T}', "");
Expect(1, 178205, '\P{^Is_Unified_Ideograph=__T}', "");
Expect(0, 178206, '\p{Is_Unified_Ideograph=__T}', "");
Expect(1, 178206, '\p{^Is_Unified_Ideograph=__T}', "");
Expect(1, 178206, '\P{Is_Unified_Ideograph=__T}', "");
Expect(0, 178206, '\P{^Is_Unified_Ideograph=__T}', "");
Error('\p{Is_UIdeo=-true/a/}');
Error('\P{Is_UIdeo=-true/a/}');
Expect(1, 178205, '\p{Is_UIdeo=true}', "");
Expect(0, 178205, '\p{^Is_UIdeo=true}', "");
Expect(0, 178205, '\P{Is_UIdeo=true}', "");
Expect(1, 178205, '\P{^Is_UIdeo=true}', "");
Expect(0, 178206, '\p{Is_UIdeo=true}', "");
Expect(1, 178206, '\p{^Is_UIdeo=true}', "");
Expect(1, 178206, '\P{Is_UIdeo=true}', "");
Expect(0, 178206, '\P{^Is_UIdeo=true}', "");
Expect(1, 178205, '\p{Is_UIdeo=	True}', "");
Expect(0, 178205, '\p{^Is_UIdeo=	True}', "");
Expect(0, 178205, '\P{Is_UIdeo=	True}', "");
Expect(1, 178205, '\P{^Is_UIdeo=	True}', "");
Expect(0, 178206, '\p{Is_UIdeo=	True}', "");
Expect(1, 178206, '\p{^Is_UIdeo=	True}', "");
Expect(1, 178206, '\P{Is_UIdeo=	True}', "");
Expect(0, 178206, '\P{^Is_UIdeo=	True}', "");
Error('\p{Uppercase=_:=No}');
Error('\P{Uppercase=_:=No}');
Expect(1, 127370, '\p{Uppercase=no}', "");
Expect(0, 127370, '\p{^Uppercase=no}', "");
Expect(0, 127370, '\P{Uppercase=no}', "");
Expect(1, 127370, '\P{^Uppercase=no}', "");
Expect(0, 127369, '\p{Uppercase=no}', "");
Expect(1, 127369, '\p{^Uppercase=no}', "");
Expect(1, 127369, '\P{Uppercase=no}', "");
Expect(0, 127369, '\P{^Uppercase=no}', "");
Expect(1, 127370, '\p{Uppercase=NO}', "");
Expect(0, 127370, '\p{^Uppercase=NO}', "");
Expect(0, 127370, '\P{Uppercase=NO}', "");
Expect(1, 127370, '\P{^Uppercase=NO}', "");
Expect(0, 127369, '\p{Uppercase=NO}', "");
Expect(1, 127369, '\p{^Uppercase=NO}', "");
Expect(1, 127369, '\P{Uppercase=NO}', "");
Expect(0, 127369, '\P{^Uppercase=NO}', "");
Error('\p{Upper=/a/-_N}');
Error('\P{Upper=/a/-_N}');
Expect(1, 127370, '\p{Upper=n}', "");
Expect(0, 127370, '\p{^Upper=n}', "");
Expect(0, 127370, '\P{Upper=n}', "");
Expect(1, 127370, '\P{^Upper=n}', "");
Expect(0, 127369, '\p{Upper=n}', "");
Expect(1, 127369, '\p{^Upper=n}', "");
Expect(1, 127369, '\P{Upper=n}', "");
Expect(0, 127369, '\P{^Upper=n}', "");
Expect(1, 127370, '\p{Upper= _N}', "");
Expect(0, 127370, '\p{^Upper= _N}', "");
Expect(0, 127370, '\P{Upper= _N}', "");
Expect(1, 127370, '\P{^Upper= _N}', "");
Expect(0, 127369, '\p{Upper= _N}', "");
Expect(1, 127369, '\p{^Upper= _N}', "");
Expect(1, 127369, '\P{Upper= _N}', "");
Expect(0, 127369, '\P{^Upper= _N}', "");
Error('\p{Is_Uppercase=:=	_F}');
Error('\P{Is_Uppercase=:=	_F}');
Expect(1, 127370, '\p{Is_Uppercase=f}', "");
Expect(0, 127370, '\p{^Is_Uppercase=f}', "");
Expect(0, 127370, '\P{Is_Uppercase=f}', "");
Expect(1, 127370, '\P{^Is_Uppercase=f}', "");
Expect(0, 127369, '\p{Is_Uppercase=f}', "");
Expect(1, 127369, '\p{^Is_Uppercase=f}', "");
Expect(1, 127369, '\P{Is_Uppercase=f}', "");
Expect(0, 127369, '\P{^Is_Uppercase=f}', "");
Expect(1, 127370, '\p{Is_Uppercase=_-f}', "");
Expect(0, 127370, '\p{^Is_Uppercase=_-f}', "");
Expect(0, 127370, '\P{Is_Uppercase=_-f}', "");
Expect(1, 127370, '\P{^Is_Uppercase=_-f}', "");
Expect(0, 127369, '\p{Is_Uppercase=_-f}', "");
Expect(1, 127369, '\p{^Is_Uppercase=_-f}', "");
Expect(1, 127369, '\P{Is_Uppercase=_-f}', "");
Expect(0, 127369, '\P{^Is_Uppercase=_-f}', "");
Error('\p{Is_Upper=_/a/False}');
Error('\P{Is_Upper=_/a/False}');
Expect(1, 127370, '\p{Is_Upper=false}', "");
Expect(0, 127370, '\p{^Is_Upper=false}', "");
Expect(0, 127370, '\P{Is_Upper=false}', "");
Expect(1, 127370, '\P{^Is_Upper=false}', "");
Expect(0, 127369, '\p{Is_Upper=false}', "");
Expect(1, 127369, '\p{^Is_Upper=false}', "");
Expect(1, 127369, '\P{Is_Upper=false}', "");
Expect(0, 127369, '\P{^Is_Upper=false}', "");
Expect(1, 127370, '\p{Is_Upper= 	False}', "");
Expect(0, 127370, '\p{^Is_Upper= 	False}', "");
Expect(0, 127370, '\P{Is_Upper= 	False}', "");
Expect(1, 127370, '\P{^Is_Upper= 	False}', "");
Expect(0, 127369, '\p{Is_Upper= 	False}', "");
Expect(1, 127369, '\p{^Is_Upper= 	False}', "");
Expect(1, 127369, '\P{Is_Upper= 	False}', "");
Expect(0, 127369, '\P{^Is_Upper= 	False}', "");
Error('\p{Uppercase=/a/Yes}');
Error('\P{Uppercase=/a/Yes}');
Expect(1, 127369, '\p{Uppercase=yes}', "");
Expect(0, 127369, '\p{^Uppercase=yes}', "");
Expect(0, 127369, '\P{Uppercase=yes}', "");
Expect(1, 127369, '\P{^Uppercase=yes}', "");
Expect(0, 127370, '\p{Uppercase=yes}', "");
Expect(1, 127370, '\p{^Uppercase=yes}', "");
Expect(1, 127370, '\P{Uppercase=yes}', "");
Expect(0, 127370, '\P{^Uppercase=yes}', "");
Expect(1, 127369, '\p{Uppercase= YES}', "");
Expect(0, 127369, '\p{^Uppercase= YES}', "");
Expect(0, 127369, '\P{Uppercase= YES}', "");
Expect(1, 127369, '\P{^Uppercase= YES}', "");
Expect(0, 127370, '\p{Uppercase= YES}', "");
Expect(1, 127370, '\p{^Uppercase= YES}', "");
Expect(1, 127370, '\P{Uppercase= YES}', "");
Expect(0, 127370, '\P{^Uppercase= YES}', "");
Error('\p{Upper=/a/	Y}');
Error('\P{Upper=/a/	Y}');
Expect(1, 127369, '\p{Upper=y}', "");
Expect(0, 127369, '\p{^Upper=y}', "");
Expect(0, 127369, '\P{Upper=y}', "");
Expect(1, 127369, '\P{^Upper=y}', "");
Expect(0, 127370, '\p{Upper=y}', "");
Expect(1, 127370, '\p{^Upper=y}', "");
Expect(1, 127370, '\P{Upper=y}', "");
Expect(0, 127370, '\P{^Upper=y}', "");
Expect(1, 127369, '\p{Upper=--y}', "");
Expect(0, 127369, '\p{^Upper=--y}', "");
Expect(0, 127369, '\P{Upper=--y}', "");
Expect(1, 127369, '\P{^Upper=--y}', "");
Expect(0, 127370, '\p{Upper=--y}', "");
Expect(1, 127370, '\p{^Upper=--y}', "");
Expect(1, 127370, '\P{Upper=--y}', "");
Expect(0, 127370, '\P{^Upper=--y}', "");
Error('\p{Is_Uppercase=/a/_-t}');
Error('\P{Is_Uppercase=/a/_-t}');
Expect(1, 127369, '\p{Is_Uppercase=t}', "");
Expect(0, 127369, '\p{^Is_Uppercase=t}', "");
Expect(0, 127369, '\P{Is_Uppercase=t}', "");
Expect(1, 127369, '\P{^Is_Uppercase=t}', "");
Expect(0, 127370, '\p{Is_Uppercase=t}', "");
Expect(1, 127370, '\p{^Is_Uppercase=t}', "");
Expect(1, 127370, '\P{Is_Uppercase=t}', "");
Expect(0, 127370, '\P{^Is_Uppercase=t}', "");
Expect(1, 127369, '\p{Is_Uppercase=_ T}', "");
Expect(0, 127369, '\p{^Is_Uppercase=_ T}', "");
Expect(0, 127369, '\P{Is_Uppercase=_ T}', "");
Expect(1, 127369, '\P{^Is_Uppercase=_ T}', "");
Expect(0, 127370, '\p{Is_Uppercase=_ T}', "");
Expect(1, 127370, '\p{^Is_Uppercase=_ T}', "");
Expect(1, 127370, '\P{Is_Uppercase=_ T}', "");
Expect(0, 127370, '\P{^Is_Uppercase=_ T}', "");
Error('\p{Is_Upper=-true:=}');
Error('\P{Is_Upper=-true:=}');
Expect(1, 127369, '\p{Is_Upper=true}', "");
Expect(0, 127369, '\p{^Is_Upper=true}', "");
Expect(0, 127369, '\P{Is_Upper=true}', "");
Expect(1, 127369, '\P{^Is_Upper=true}', "");
Expect(0, 127370, '\p{Is_Upper=true}', "");
Expect(1, 127370, '\p{^Is_Upper=true}', "");
Expect(1, 127370, '\P{Is_Upper=true}', "");
Expect(0, 127370, '\P{^Is_Upper=true}', "");
Expect(1, 127369, '\p{Is_Upper: True}', "");
Expect(0, 127369, '\p{^Is_Upper: True}', "");
Expect(0, 127369, '\P{Is_Upper: True}', "");
Expect(1, 127369, '\P{^Is_Upper: True}', "");
Expect(0, 127370, '\p{Is_Upper: True}', "");
Expect(1, 127370, '\p{^Is_Upper: True}', "");
Expect(1, 127370, '\P{Is_Upper: True}', "");
Expect(0, 127370, '\P{^Is_Upper: True}', "");
Error('\p{Variation_Selector=	 NO:=}');
Error('\P{Variation_Selector=	 NO:=}');
Expect(1, 918000, '\p{Variation_Selector=no}', "");
Expect(0, 918000, '\p{^Variation_Selector=no}', "");
Expect(0, 918000, '\P{Variation_Selector=no}', "");
Expect(1, 918000, '\P{^Variation_Selector=no}', "");
Expect(0, 917999, '\p{Variation_Selector=no}', "");
Expect(1, 917999, '\p{^Variation_Selector=no}', "");
Expect(1, 917999, '\P{Variation_Selector=no}', "");
Expect(0, 917999, '\P{^Variation_Selector=no}', "");
Expect(1, 918000, '\p{Variation_Selector=No}', "");
Expect(0, 918000, '\p{^Variation_Selector=No}', "");
Expect(0, 918000, '\P{Variation_Selector=No}', "");
Expect(1, 918000, '\P{^Variation_Selector=No}', "");
Expect(0, 917999, '\p{Variation_Selector=No}', "");
Expect(1, 917999, '\p{^Variation_Selector=No}', "");
Expect(1, 917999, '\P{Variation_Selector=No}', "");
Expect(0, 917999, '\P{^Variation_Selector=No}', "");
Error('\p{VS= -N:=}');
Error('\P{VS= -N:=}');
Expect(1, 918000, '\p{VS=n}', "");
Expect(0, 918000, '\p{^VS=n}', "");
Expect(0, 918000, '\P{VS=n}', "");
Expect(1, 918000, '\P{^VS=n}', "");
Expect(0, 917999, '\p{VS=n}', "");
Expect(1, 917999, '\p{^VS=n}', "");
Expect(1, 917999, '\P{VS=n}', "");
Expect(0, 917999, '\P{^VS=n}', "");
Expect(1, 918000, '\p{VS=--N}', "");
Expect(0, 918000, '\p{^VS=--N}', "");
Expect(0, 918000, '\P{VS=--N}', "");
Expect(1, 918000, '\P{^VS=--N}', "");
Expect(0, 917999, '\p{VS=--N}', "");
Expect(1, 917999, '\p{^VS=--N}', "");
Expect(1, 917999, '\P{VS=--N}', "");
Expect(0, 917999, '\P{^VS=--N}', "");
Error('\p{Is_Variation_Selector=:=	-F}');
Error('\P{Is_Variation_Selector=:=	-F}');
Expect(1, 918000, '\p{Is_Variation_Selector=f}', "");
Expect(0, 918000, '\p{^Is_Variation_Selector=f}', "");
Expect(0, 918000, '\P{Is_Variation_Selector=f}', "");
Expect(1, 918000, '\P{^Is_Variation_Selector=f}', "");
Expect(0, 917999, '\p{Is_Variation_Selector=f}', "");
Expect(1, 917999, '\p{^Is_Variation_Selector=f}', "");
Expect(1, 917999, '\P{Is_Variation_Selector=f}', "");
Expect(0, 917999, '\P{^Is_Variation_Selector=f}', "");
Expect(1, 918000, '\p{Is_Variation_Selector=	 F}', "");
Expect(0, 918000, '\p{^Is_Variation_Selector=	 F}', "");
Expect(0, 918000, '\P{Is_Variation_Selector=	 F}', "");
Expect(1, 918000, '\P{^Is_Variation_Selector=	 F}', "");
Expect(0, 917999, '\p{Is_Variation_Selector=	 F}', "");
Expect(1, 917999, '\p{^Is_Variation_Selector=	 F}', "");
Expect(1, 917999, '\P{Is_Variation_Selector=	 F}', "");
Expect(0, 917999, '\P{^Is_Variation_Selector=	 F}', "");
Error('\p{Is_VS=- FALSE/a/}');
Error('\P{Is_VS=- FALSE/a/}');
Expect(1, 918000, '\p{Is_VS=false}', "");
Expect(0, 918000, '\p{^Is_VS=false}', "");
Expect(0, 918000, '\P{Is_VS=false}', "");
Expect(1, 918000, '\P{^Is_VS=false}', "");
Expect(0, 917999, '\p{Is_VS=false}', "");
Expect(1, 917999, '\p{^Is_VS=false}', "");
Expect(1, 917999, '\P{Is_VS=false}', "");
Expect(0, 917999, '\P{^Is_VS=false}', "");
Expect(1, 918000, '\p{Is_VS=-_FALSE}', "");
Expect(0, 918000, '\p{^Is_VS=-_FALSE}', "");
Expect(0, 918000, '\P{Is_VS=-_FALSE}', "");
Expect(1, 918000, '\P{^Is_VS=-_FALSE}', "");
Expect(0, 917999, '\p{Is_VS=-_FALSE}', "");
Expect(1, 917999, '\p{^Is_VS=-_FALSE}', "");
Expect(1, 917999, '\P{Is_VS=-_FALSE}', "");
Expect(0, 917999, '\P{^Is_VS=-_FALSE}', "");
Error('\p{Variation_Selector=/a/_yes}');
Error('\P{Variation_Selector=/a/_yes}');
Expect(1, 917999, '\p{Variation_Selector=yes}', "");
Expect(0, 917999, '\p{^Variation_Selector=yes}', "");
Expect(0, 917999, '\P{Variation_Selector=yes}', "");
Expect(1, 917999, '\P{^Variation_Selector=yes}', "");
Expect(0, 918000, '\p{Variation_Selector=yes}', "");
Expect(1, 918000, '\p{^Variation_Selector=yes}', "");
Expect(1, 918000, '\P{Variation_Selector=yes}', "");
Expect(0, 918000, '\P{^Variation_Selector=yes}', "");
Expect(1, 917999, '\p{Variation_Selector=	_yes}', "");
Expect(0, 917999, '\p{^Variation_Selector=	_yes}', "");
Expect(0, 917999, '\P{Variation_Selector=	_yes}', "");
Expect(1, 917999, '\P{^Variation_Selector=	_yes}', "");
Expect(0, 918000, '\p{Variation_Selector=	_yes}', "");
Expect(1, 918000, '\p{^Variation_Selector=	_yes}', "");
Expect(1, 918000, '\P{Variation_Selector=	_yes}', "");
Expect(0, 918000, '\P{^Variation_Selector=	_yes}', "");
Error('\p{VS=_-Y/a/}');
Error('\P{VS=_-Y/a/}');
Expect(1, 917999, '\p{VS=y}', "");
Expect(0, 917999, '\p{^VS=y}', "");
Expect(0, 917999, '\P{VS=y}', "");
Expect(1, 917999, '\P{^VS=y}', "");
Expect(0, 918000, '\p{VS=y}', "");
Expect(1, 918000, '\p{^VS=y}', "");
Expect(1, 918000, '\P{VS=y}', "");
Expect(0, 918000, '\P{^VS=y}', "");
Expect(1, 917999, '\p{VS=	-Y}', "");
Expect(0, 917999, '\p{^VS=	-Y}', "");
Expect(0, 917999, '\P{VS=	-Y}', "");
Expect(1, 917999, '\P{^VS=	-Y}', "");
Expect(0, 918000, '\p{VS=	-Y}', "");
Expect(1, 918000, '\p{^VS=	-Y}', "");
Expect(1, 918000, '\P{VS=	-Y}', "");
Expect(0, 918000, '\P{^VS=	-Y}', "");
Error('\p{Is_Variation_Selector=T/a/}');
Error('\P{Is_Variation_Selector=T/a/}');
Expect(1, 917999, '\p{Is_Variation_Selector=t}', "");
Expect(0, 917999, '\p{^Is_Variation_Selector=t}', "");
Expect(0, 917999, '\P{Is_Variation_Selector=t}', "");
Expect(1, 917999, '\P{^Is_Variation_Selector=t}', "");
Expect(0, 918000, '\p{Is_Variation_Selector=t}', "");
Expect(1, 918000, '\p{^Is_Variation_Selector=t}', "");
Expect(1, 918000, '\P{Is_Variation_Selector=t}', "");
Expect(0, 918000, '\P{^Is_Variation_Selector=t}', "");
Expect(1, 917999, '\p{Is_Variation_Selector=_	T}', "");
Expect(0, 917999, '\p{^Is_Variation_Selector=_	T}', "");
Expect(0, 917999, '\P{Is_Variation_Selector=_	T}', "");
Expect(1, 917999, '\P{^Is_Variation_Selector=_	T}', "");
Expect(0, 918000, '\p{Is_Variation_Selector=_	T}', "");
Expect(1, 918000, '\p{^Is_Variation_Selector=_	T}', "");
Expect(1, 918000, '\P{Is_Variation_Selector=_	T}', "");
Expect(0, 918000, '\P{^Is_Variation_Selector=_	T}', "");
Error('\p{Is_VS:	_TRUE:=}');
Error('\P{Is_VS:	_TRUE:=}');
Expect(1, 917999, '\p{Is_VS=true}', "");
Expect(0, 917999, '\p{^Is_VS=true}', "");
Expect(0, 917999, '\P{Is_VS=true}', "");
Expect(1, 917999, '\P{^Is_VS=true}', "");
Expect(0, 918000, '\p{Is_VS=true}', "");
Expect(1, 918000, '\p{^Is_VS=true}', "");
Expect(1, 918000, '\P{Is_VS=true}', "");
Expect(0, 918000, '\P{^Is_VS=true}', "");
Expect(1, 917999, '\p{Is_VS= 	true}', "");
Expect(0, 917999, '\p{^Is_VS= 	true}', "");
Expect(0, 917999, '\P{Is_VS= 	true}', "");
Expect(1, 917999, '\P{^Is_VS= 	true}', "");
Expect(0, 918000, '\p{Is_VS= 	true}', "");
Expect(1, 918000, '\p{^Is_VS= 	true}', "");
Expect(1, 918000, '\P{Is_VS= 	true}', "");
Expect(0, 918000, '\P{^Is_VS= 	true}', "");
Error('\p{Word_Break=/a/_-cr}');
Error('\P{Word_Break=/a/_-cr}');
Expect(1, 13, '\p{Word_Break=cr}', "");
Expect(0, 13, '\p{^Word_Break=cr}', "");
Expect(0, 13, '\P{Word_Break=cr}', "");
Expect(1, 13, '\P{^Word_Break=cr}', "");
Expect(0, 14, '\p{Word_Break=cr}', "");
Expect(1, 14, '\p{^Word_Break=cr}', "");
Expect(1, 14, '\P{Word_Break=cr}', "");
Expect(0, 14, '\P{^Word_Break=cr}', "");
Expect(1, 13, '\p{Word_Break= cr}', "");
Expect(0, 13, '\p{^Word_Break= cr}', "");
Expect(0, 13, '\P{Word_Break= cr}', "");
Expect(1, 13, '\P{^Word_Break= cr}', "");
Expect(0, 14, '\p{Word_Break= cr}', "");
Expect(1, 14, '\p{^Word_Break= cr}', "");
Expect(1, 14, '\P{Word_Break= cr}', "");
Expect(0, 14, '\P{^Word_Break= cr}', "");
Error('\p{WB= 	cr:=}');
Error('\P{WB= 	cr:=}');
Expect(1, 13, '\p{WB=cr}', "");
Expect(0, 13, '\p{^WB=cr}', "");
Expect(0, 13, '\P{WB=cr}', "");
Expect(1, 13, '\P{^WB=cr}', "");
Expect(0, 14, '\p{WB=cr}', "");
Expect(1, 14, '\p{^WB=cr}', "");
Expect(1, 14, '\P{WB=cr}', "");
Expect(0, 14, '\P{^WB=cr}', "");
Expect(1, 13, '\p{WB:	 CR}', "");
Expect(0, 13, '\p{^WB:	 CR}', "");
Expect(0, 13, '\P{WB:	 CR}', "");
Expect(1, 13, '\P{^WB:	 CR}', "");
Expect(0, 14, '\p{WB:	 CR}', "");
Expect(1, 14, '\p{^WB:	 CR}', "");
Expect(1, 14, '\P{WB:	 CR}', "");
Expect(0, 14, '\P{^WB:	 CR}', "");
Error('\p{Is_Word_Break= CR/a/}');
Error('\P{Is_Word_Break= CR/a/}');
Expect(1, 13, '\p{Is_Word_Break=cr}', "");
Expect(0, 13, '\p{^Is_Word_Break=cr}', "");
Expect(0, 13, '\P{Is_Word_Break=cr}', "");
Expect(1, 13, '\P{^Is_Word_Break=cr}', "");
Expect(0, 14, '\p{Is_Word_Break=cr}', "");
Expect(1, 14, '\p{^Is_Word_Break=cr}', "");
Expect(1, 14, '\P{Is_Word_Break=cr}', "");
Expect(0, 14, '\P{^Is_Word_Break=cr}', "");
Expect(1, 13, '\p{Is_Word_Break=_CR}', "");
Expect(0, 13, '\p{^Is_Word_Break=_CR}', "");
Expect(0, 13, '\P{Is_Word_Break=_CR}', "");
Expect(1, 13, '\P{^Is_Word_Break=_CR}', "");
Expect(0, 14, '\p{Is_Word_Break=_CR}', "");
Expect(1, 14, '\p{^Is_Word_Break=_CR}', "");
Expect(1, 14, '\P{Is_Word_Break=_CR}', "");
Expect(0, 14, '\P{^Is_Word_Break=_CR}', "");
Error('\p{Is_WB=/a/_	cr}');
Error('\P{Is_WB=/a/_	cr}');
Expect(1, 13, '\p{Is_WB=cr}', "");
Expect(0, 13, '\p{^Is_WB=cr}', "");
Expect(0, 13, '\P{Is_WB=cr}', "");
Expect(1, 13, '\P{^Is_WB=cr}', "");
Expect(0, 14, '\p{Is_WB=cr}', "");
Expect(1, 14, '\p{^Is_WB=cr}', "");
Expect(1, 14, '\P{Is_WB=cr}', "");
Expect(0, 14, '\P{^Is_WB=cr}', "");
Expect(1, 13, '\p{Is_WB=_cr}', "");
Expect(0, 13, '\p{^Is_WB=_cr}', "");
Expect(0, 13, '\P{Is_WB=_cr}', "");
Expect(1, 13, '\P{^Is_WB=_cr}', "");
Expect(0, 14, '\p{Is_WB=_cr}', "");
Expect(1, 14, '\p{^Is_WB=_cr}', "");
Expect(1, 14, '\P{Is_WB=_cr}', "");
Expect(0, 14, '\P{^Is_WB=_cr}', "");
Error('\p{Word_Break=:=--Double_quote}');
Error('\P{Word_Break=:=--Double_quote}');
Expect(1, 34, '\p{Word_Break=doublequote}', "");
Expect(0, 34, '\p{^Word_Break=doublequote}', "");
Expect(0, 34, '\P{Word_Break=doublequote}', "");
Expect(1, 34, '\P{^Word_Break=doublequote}', "");
Expect(0, 35, '\p{Word_Break=doublequote}', "");
Expect(1, 35, '\p{^Word_Break=doublequote}', "");
Expect(1, 35, '\P{Word_Break=doublequote}', "");
Expect(0, 35, '\P{^Word_Break=doublequote}', "");
Expect(1, 34, '\p{Word_Break= Double_Quote}', "");
Expect(0, 34, '\p{^Word_Break= Double_Quote}', "");
Expect(0, 34, '\P{Word_Break= Double_Quote}', "");
Expect(1, 34, '\P{^Word_Break= Double_Quote}', "");
Expect(0, 35, '\p{Word_Break= Double_Quote}', "");
Expect(1, 35, '\p{^Word_Break= Double_Quote}', "");
Expect(1, 35, '\P{Word_Break= Double_Quote}', "");
Expect(0, 35, '\P{^Word_Break= Double_Quote}', "");
Error('\p{WB=_dq:=}');
Error('\P{WB=_dq:=}');
Expect(1, 34, '\p{WB=dq}', "");
Expect(0, 34, '\p{^WB=dq}', "");
Expect(0, 34, '\P{WB=dq}', "");
Expect(1, 34, '\P{^WB=dq}', "");
Expect(0, 35, '\p{WB=dq}', "");
Expect(1, 35, '\p{^WB=dq}', "");
Expect(1, 35, '\P{WB=dq}', "");
Expect(0, 35, '\P{^WB=dq}', "");
Expect(1, 34, '\p{WB=- dq}', "");
Expect(0, 34, '\p{^WB=- dq}', "");
Expect(0, 34, '\P{WB=- dq}', "");
Expect(1, 34, '\P{^WB=- dq}', "");
Expect(0, 35, '\p{WB=- dq}', "");
Expect(1, 35, '\p{^WB=- dq}', "");
Expect(1, 35, '\P{WB=- dq}', "");
Expect(0, 35, '\P{^WB=- dq}', "");
Error('\p{Is_Word_Break=	-DOUBLE_quote/a/}');
Error('\P{Is_Word_Break=	-DOUBLE_quote/a/}');
Expect(1, 34, '\p{Is_Word_Break=doublequote}', "");
Expect(0, 34, '\p{^Is_Word_Break=doublequote}', "");
Expect(0, 34, '\P{Is_Word_Break=doublequote}', "");
Expect(1, 34, '\P{^Is_Word_Break=doublequote}', "");
Expect(0, 35, '\p{Is_Word_Break=doublequote}', "");
Expect(1, 35, '\p{^Is_Word_Break=doublequote}', "");
Expect(1, 35, '\P{Is_Word_Break=doublequote}', "");
Expect(0, 35, '\P{^Is_Word_Break=doublequote}', "");
Expect(1, 34, '\p{Is_Word_Break=	double_Quote}', "");
Expect(0, 34, '\p{^Is_Word_Break=	double_Quote}', "");
Expect(0, 34, '\P{Is_Word_Break=	double_Quote}', "");
Expect(1, 34, '\P{^Is_Word_Break=	double_Quote}', "");
Expect(0, 35, '\p{Is_Word_Break=	double_Quote}', "");
Expect(1, 35, '\p{^Is_Word_Break=	double_Quote}', "");
Expect(1, 35, '\P{Is_Word_Break=	double_Quote}', "");
Expect(0, 35, '\P{^Is_Word_Break=	double_Quote}', "");
Error('\p{Is_WB=/a/_ DQ}');
Error('\P{Is_WB=/a/_ DQ}');
Expect(1, 34, '\p{Is_WB=dq}', "");
Expect(0, 34, '\p{^Is_WB=dq}', "");
Expect(0, 34, '\P{Is_WB=dq}', "");
Expect(1, 34, '\P{^Is_WB=dq}', "");
Expect(0, 35, '\p{Is_WB=dq}', "");
Expect(1, 35, '\p{^Is_WB=dq}', "");
Expect(1, 35, '\P{Is_WB=dq}', "");
Expect(0, 35, '\P{^Is_WB=dq}', "");
Expect(1, 34, '\p{Is_WB= -DQ}', "");
Expect(0, 34, '\p{^Is_WB= -DQ}', "");
Expect(0, 34, '\P{Is_WB= -DQ}', "");
Expect(1, 34, '\P{^Is_WB= -DQ}', "");
Expect(0, 35, '\p{Is_WB= -DQ}', "");
Expect(1, 35, '\p{^Is_WB= -DQ}', "");
Expect(1, 35, '\P{Is_WB= -DQ}', "");
Expect(0, 35, '\P{^Is_WB= -DQ}', "");
Error('\p{Word_Break=:=_	ExtendNumLet}');
Error('\P{Word_Break=:=_	ExtendNumLet}');
Expect(1, 65343, '\p{Word_Break=extendnumlet}', "");
Expect(0, 65343, '\p{^Word_Break=extendnumlet}', "");
Expect(0, 65343, '\P{Word_Break=extendnumlet}', "");
Expect(1, 65343, '\P{^Word_Break=extendnumlet}', "");
Expect(0, 65344, '\p{Word_Break=extendnumlet}', "");
Expect(1, 65344, '\p{^Word_Break=extendnumlet}', "");
Expect(1, 65344, '\P{Word_Break=extendnumlet}', "");
Expect(0, 65344, '\P{^Word_Break=extendnumlet}', "");
Expect(1, 65343, '\p{Word_Break=-ExtendNumLet}', "");
Expect(0, 65343, '\p{^Word_Break=-ExtendNumLet}', "");
Expect(0, 65343, '\P{Word_Break=-ExtendNumLet}', "");
Expect(1, 65343, '\P{^Word_Break=-ExtendNumLet}', "");
Expect(0, 65344, '\p{Word_Break=-ExtendNumLet}', "");
Expect(1, 65344, '\p{^Word_Break=-ExtendNumLet}', "");
Expect(1, 65344, '\P{Word_Break=-ExtendNumLet}', "");
Expect(0, 65344, '\P{^Word_Break=-ExtendNumLet}', "");
Error('\p{WB: _	ex/a/}');
Error('\P{WB: _	ex/a/}');
Expect(1, 65343, '\p{WB=ex}', "");
Expect(0, 65343, '\p{^WB=ex}', "");
Expect(0, 65343, '\P{WB=ex}', "");
Expect(1, 65343, '\P{^WB=ex}', "");
Expect(0, 65344, '\p{WB=ex}', "");
Expect(1, 65344, '\p{^WB=ex}', "");
Expect(1, 65344, '\P{WB=ex}', "");
Expect(0, 65344, '\P{^WB=ex}', "");
Expect(1, 65343, '\p{WB:			EX}', "");
Expect(0, 65343, '\p{^WB:			EX}', "");
Expect(0, 65343, '\P{WB:			EX}', "");
Expect(1, 65343, '\P{^WB:			EX}', "");
Expect(0, 65344, '\p{WB:			EX}', "");
Expect(1, 65344, '\p{^WB:			EX}', "");
Expect(1, 65344, '\P{WB:			EX}', "");
Expect(0, 65344, '\P{^WB:			EX}', "");
Error('\p{Is_Word_Break=:= EXTENDNUMLET}');
Error('\P{Is_Word_Break=:= EXTENDNUMLET}');
Expect(1, 65343, '\p{Is_Word_Break=extendnumlet}', "");
Expect(0, 65343, '\p{^Is_Word_Break=extendnumlet}', "");
Expect(0, 65343, '\P{Is_Word_Break=extendnumlet}', "");
Expect(1, 65343, '\P{^Is_Word_Break=extendnumlet}', "");
Expect(0, 65344, '\p{Is_Word_Break=extendnumlet}', "");
Expect(1, 65344, '\p{^Is_Word_Break=extendnumlet}', "");
Expect(1, 65344, '\P{Is_Word_Break=extendnumlet}', "");
Expect(0, 65344, '\P{^Is_Word_Break=extendnumlet}', "");
Expect(1, 65343, '\p{Is_Word_Break=	-ExtendNumLet}', "");
Expect(0, 65343, '\p{^Is_Word_Break=	-ExtendNumLet}', "");
Expect(0, 65343, '\P{Is_Word_Break=	-ExtendNumLet}', "");
Expect(1, 65343, '\P{^Is_Word_Break=	-ExtendNumLet}', "");
Expect(0, 65344, '\p{Is_Word_Break=	-ExtendNumLet}', "");
Expect(1, 65344, '\p{^Is_Word_Break=	-ExtendNumLet}', "");
Expect(1, 65344, '\P{Is_Word_Break=	-ExtendNumLet}', "");
Expect(0, 65344, '\P{^Is_Word_Break=	-ExtendNumLet}', "");
Error('\p{Is_WB=:=	_EX}');
Error('\P{Is_WB=:=	_EX}');
Expect(1, 65343, '\p{Is_WB=ex}', "");
Expect(0, 65343, '\p{^Is_WB=ex}', "");
Expect(0, 65343, '\P{Is_WB=ex}', "");
Expect(1, 65343, '\P{^Is_WB=ex}', "");
Expect(0, 65344, '\p{Is_WB=ex}', "");
Expect(1, 65344, '\p{^Is_WB=ex}', "");
Expect(1, 65344, '\P{Is_WB=ex}', "");
Expect(0, 65344, '\P{^Is_WB=ex}', "");
Expect(1, 65343, '\p{Is_WB=_-EX}', "");
Expect(0, 65343, '\p{^Is_WB=_-EX}', "");
Expect(0, 65343, '\P{Is_WB=_-EX}', "");
Expect(1, 65343, '\P{^Is_WB=_-EX}', "");
Expect(0, 65344, '\p{Is_WB=_-EX}', "");
Expect(1, 65344, '\p{^Is_WB=_-EX}', "");
Expect(1, 65344, '\P{Is_WB=_-EX}', "");
Expect(0, 65344, '\P{^Is_WB=_-EX}', "");
Error('\p{Word_Break=/a/	EXTEND}');
Error('\P{Word_Break=/a/	EXTEND}');
Expect(1, 917999, '\p{Word_Break=extend}', "");
Expect(0, 917999, '\p{^Word_Break=extend}', "");
Expect(0, 917999, '\P{Word_Break=extend}', "");
Expect(1, 917999, '\P{^Word_Break=extend}', "");
Expect(0, 918000, '\p{Word_Break=extend}', "");
Expect(1, 918000, '\p{^Word_Break=extend}', "");
Expect(1, 918000, '\P{Word_Break=extend}', "");
Expect(0, 918000, '\P{^Word_Break=extend}', "");
Expect(1, 917999, '\p{Word_Break= Extend}', "");
Expect(0, 917999, '\p{^Word_Break= Extend}', "");
Expect(0, 917999, '\P{Word_Break= Extend}', "");
Expect(1, 917999, '\P{^Word_Break= Extend}', "");
Expect(0, 918000, '\p{Word_Break= Extend}', "");
Expect(1, 918000, '\p{^Word_Break= Extend}', "");
Expect(1, 918000, '\P{Word_Break= Extend}', "");
Expect(0, 918000, '\P{^Word_Break= Extend}', "");
Error('\p{WB:	-:=Extend}');
Error('\P{WB:	-:=Extend}');
Expect(1, 917999, '\p{WB=extend}', "");
Expect(0, 917999, '\p{^WB=extend}', "");
Expect(0, 917999, '\P{WB=extend}', "");
Expect(1, 917999, '\P{^WB=extend}', "");
Expect(0, 918000, '\p{WB=extend}', "");
Expect(1, 918000, '\p{^WB=extend}', "");
Expect(1, 918000, '\P{WB=extend}', "");
Expect(0, 918000, '\P{^WB=extend}', "");
Expect(1, 917999, '\p{WB=	_extend}', "");
Expect(0, 917999, '\p{^WB=	_extend}', "");
Expect(0, 917999, '\P{WB=	_extend}', "");
Expect(1, 917999, '\P{^WB=	_extend}', "");
Expect(0, 918000, '\p{WB=	_extend}', "");
Expect(1, 918000, '\p{^WB=	_extend}', "");
Expect(1, 918000, '\P{WB=	_extend}', "");
Expect(0, 918000, '\P{^WB=	_extend}', "");
Error('\p{Is_Word_Break:   	/a/Extend}');
Error('\P{Is_Word_Break:   	/a/Extend}');
Expect(1, 917999, '\p{Is_Word_Break=extend}', "");
Expect(0, 917999, '\p{^Is_Word_Break=extend}', "");
Expect(0, 917999, '\P{Is_Word_Break=extend}', "");
Expect(1, 917999, '\P{^Is_Word_Break=extend}', "");
Expect(0, 918000, '\p{Is_Word_Break=extend}', "");
Expect(1, 918000, '\p{^Is_Word_Break=extend}', "");
Expect(1, 918000, '\P{Is_Word_Break=extend}', "");
Expect(0, 918000, '\P{^Is_Word_Break=extend}', "");
Expect(1, 917999, '\p{Is_Word_Break=__EXTEND}', "");
Expect(0, 917999, '\p{^Is_Word_Break=__EXTEND}', "");
Expect(0, 917999, '\P{Is_Word_Break=__EXTEND}', "");
Expect(1, 917999, '\P{^Is_Word_Break=__EXTEND}', "");
Expect(0, 918000, '\p{Is_Word_Break=__EXTEND}', "");
Expect(1, 918000, '\p{^Is_Word_Break=__EXTEND}', "");
Expect(1, 918000, '\P{Is_Word_Break=__EXTEND}', "");
Expect(0, 918000, '\P{^Is_Word_Break=__EXTEND}', "");
Error('\p{Is_WB=Extend/a/}');
Error('\P{Is_WB=Extend/a/}');
Expect(1, 917999, '\p{Is_WB:   extend}', "");
Expect(0, 917999, '\p{^Is_WB:   extend}', "");
Expect(0, 917999, '\P{Is_WB:   extend}', "");
Expect(1, 917999, '\P{^Is_WB:   extend}', "");
Expect(0, 918000, '\p{Is_WB:   extend}', "");
Expect(1, 918000, '\p{^Is_WB:   extend}', "");
Expect(1, 918000, '\P{Is_WB:   extend}', "");
Expect(0, 918000, '\P{^Is_WB:   extend}', "");
Expect(1, 917999, '\p{Is_WB:_	extend}', "");
Expect(0, 917999, '\p{^Is_WB:_	extend}', "");
Expect(0, 917999, '\P{Is_WB:_	extend}', "");
Expect(1, 917999, '\P{^Is_WB:_	extend}', "");
Expect(0, 918000, '\p{Is_WB:_	extend}', "");
Expect(1, 918000, '\p{^Is_WB:_	extend}', "");
Expect(1, 918000, '\P{Is_WB:_	extend}', "");
Expect(0, 918000, '\P{^Is_WB:_	extend}', "");
Error('\p{Word_Break=_:=format}');
Error('\P{Word_Break=_:=format}');
Expect(1, 917631, '\p{Word_Break=format}', "");
Expect(0, 917631, '\p{^Word_Break=format}', "");
Expect(0, 917631, '\P{Word_Break=format}', "");
Expect(1, 917631, '\P{^Word_Break=format}', "");
Expect(0, 917632, '\p{Word_Break=format}', "");
Expect(1, 917632, '\p{^Word_Break=format}', "");
Expect(1, 917632, '\P{Word_Break=format}', "");
Expect(0, 917632, '\P{^Word_Break=format}', "");
Expect(1, 917631, '\p{Word_Break=_FORMAT}', "");
Expect(0, 917631, '\p{^Word_Break=_FORMAT}', "");
Expect(0, 917631, '\P{Word_Break=_FORMAT}', "");
Expect(1, 917631, '\P{^Word_Break=_FORMAT}', "");
Expect(0, 917632, '\p{Word_Break=_FORMAT}', "");
Expect(1, 917632, '\p{^Word_Break=_FORMAT}', "");
Expect(1, 917632, '\P{Word_Break=_FORMAT}', "");
Expect(0, 917632, '\P{^Word_Break=_FORMAT}', "");
Error('\p{WB= :=fo}');
Error('\P{WB= :=fo}');
Expect(1, 917631, '\p{WB:   fo}', "");
Expect(0, 917631, '\p{^WB:   fo}', "");
Expect(0, 917631, '\P{WB:   fo}', "");
Expect(1, 917631, '\P{^WB:   fo}', "");
Expect(0, 917632, '\p{WB:   fo}', "");
Expect(1, 917632, '\p{^WB:   fo}', "");
Expect(1, 917632, '\P{WB:   fo}', "");
Expect(0, 917632, '\P{^WB:   fo}', "");
Expect(1, 917631, '\p{WB= 	FO}', "");
Expect(0, 917631, '\p{^WB= 	FO}', "");
Expect(0, 917631, '\P{WB= 	FO}', "");
Expect(1, 917631, '\P{^WB= 	FO}', "");
Expect(0, 917632, '\p{WB= 	FO}', "");
Expect(1, 917632, '\p{^WB= 	FO}', "");
Expect(1, 917632, '\P{WB= 	FO}', "");
Expect(0, 917632, '\P{^WB= 	FO}', "");
Error('\p{Is_Word_Break=/a/Format}');
Error('\P{Is_Word_Break=/a/Format}');
Expect(1, 917631, '\p{Is_Word_Break=format}', "");
Expect(0, 917631, '\p{^Is_Word_Break=format}', "");
Expect(0, 917631, '\P{Is_Word_Break=format}', "");
Expect(1, 917631, '\P{^Is_Word_Break=format}', "");
Expect(0, 917632, '\p{Is_Word_Break=format}', "");
Expect(1, 917632, '\p{^Is_Word_Break=format}', "");
Expect(1, 917632, '\P{Is_Word_Break=format}', "");
Expect(0, 917632, '\P{^Is_Word_Break=format}', "");
Expect(1, 917631, '\p{Is_Word_Break= Format}', "");
Expect(0, 917631, '\p{^Is_Word_Break= Format}', "");
Expect(0, 917631, '\P{Is_Word_Break= Format}', "");
Expect(1, 917631, '\P{^Is_Word_Break= Format}', "");
Expect(0, 917632, '\p{Is_Word_Break= Format}', "");
Expect(1, 917632, '\p{^Is_Word_Break= Format}', "");
Expect(1, 917632, '\P{Is_Word_Break= Format}', "");
Expect(0, 917632, '\P{^Is_Word_Break= Format}', "");
Error('\p{Is_WB=	_fo:=}');
Error('\P{Is_WB=	_fo:=}');
Expect(1, 917631, '\p{Is_WB:fo}', "");
Expect(0, 917631, '\p{^Is_WB:fo}', "");
Expect(0, 917631, '\P{Is_WB:fo}', "");
Expect(1, 917631, '\P{^Is_WB:fo}', "");
Expect(0, 917632, '\p{Is_WB:fo}', "");
Expect(1, 917632, '\p{^Is_WB:fo}', "");
Expect(1, 917632, '\P{Is_WB:fo}', "");
Expect(0, 917632, '\P{^Is_WB:fo}', "");
Expect(1, 917631, '\p{Is_WB=_ FO}', "");
Expect(0, 917631, '\p{^Is_WB=_ FO}', "");
Expect(0, 917631, '\P{Is_WB=_ FO}', "");
Expect(1, 917631, '\P{^Is_WB=_ FO}', "");
Expect(0, 917632, '\p{Is_WB=_ FO}', "");
Expect(1, 917632, '\p{^Is_WB=_ FO}', "");
Expect(1, 917632, '\P{Is_WB=_ FO}', "");
Expect(0, 917632, '\P{^Is_WB=_ FO}', "");
Error('\p{Word_Break=	-HEBREW_LETTER/a/}');
Error('\P{Word_Break=	-HEBREW_LETTER/a/}');
Expect(1, 64335, '\p{Word_Break=hebrewletter}', "");
Expect(0, 64335, '\p{^Word_Break=hebrewletter}', "");
Expect(0, 64335, '\P{Word_Break=hebrewletter}', "");
Expect(1, 64335, '\P{^Word_Break=hebrewletter}', "");
Expect(0, 64336, '\p{Word_Break=hebrewletter}', "");
Expect(1, 64336, '\p{^Word_Break=hebrewletter}', "");
Expect(1, 64336, '\P{Word_Break=hebrewletter}', "");
Expect(0, 64336, '\P{^Word_Break=hebrewletter}', "");
Expect(1, 64335, '\p{Word_Break= 	HEBREW_LETTER}', "");
Expect(0, 64335, '\p{^Word_Break= 	HEBREW_LETTER}', "");
Expect(0, 64335, '\P{Word_Break= 	HEBREW_LETTER}', "");
Expect(1, 64335, '\P{^Word_Break= 	HEBREW_LETTER}', "");
Expect(0, 64336, '\p{Word_Break= 	HEBREW_LETTER}', "");
Expect(1, 64336, '\p{^Word_Break= 	HEBREW_LETTER}', "");
Expect(1, 64336, '\P{Word_Break= 	HEBREW_LETTER}', "");
Expect(0, 64336, '\P{^Word_Break= 	HEBREW_LETTER}', "");
Error('\p{WB=/a/__HL}');
Error('\P{WB=/a/__HL}');
Expect(1, 64335, '\p{WB=hl}', "");
Expect(0, 64335, '\p{^WB=hl}', "");
Expect(0, 64335, '\P{WB=hl}', "");
Expect(1, 64335, '\P{^WB=hl}', "");
Expect(0, 64336, '\p{WB=hl}', "");
Expect(1, 64336, '\p{^WB=hl}', "");
Expect(1, 64336, '\P{WB=hl}', "");
Expect(0, 64336, '\P{^WB=hl}', "");
Expect(1, 64335, '\p{WB=  HL}', "");
Expect(0, 64335, '\p{^WB=  HL}', "");
Expect(0, 64335, '\P{WB=  HL}', "");
Expect(1, 64335, '\P{^WB=  HL}', "");
Expect(0, 64336, '\p{WB=  HL}', "");
Expect(1, 64336, '\p{^WB=  HL}', "");
Expect(1, 64336, '\P{WB=  HL}', "");
Expect(0, 64336, '\P{^WB=  HL}', "");
Error('\p{Is_Word_Break=:=-Hebrew_Letter}');
Error('\P{Is_Word_Break=:=-Hebrew_Letter}');
Expect(1, 64335, '\p{Is_Word_Break=hebrewletter}', "");
Expect(0, 64335, '\p{^Is_Word_Break=hebrewletter}', "");
Expect(0, 64335, '\P{Is_Word_Break=hebrewletter}', "");
Expect(1, 64335, '\P{^Is_Word_Break=hebrewletter}', "");
Expect(0, 64336, '\p{Is_Word_Break=hebrewletter}', "");
Expect(1, 64336, '\p{^Is_Word_Break=hebrewletter}', "");
Expect(1, 64336, '\P{Is_Word_Break=hebrewletter}', "");
Expect(0, 64336, '\P{^Is_Word_Break=hebrewletter}', "");
Expect(1, 64335, '\p{Is_Word_Break= -Hebrew_Letter}', "");
Expect(0, 64335, '\p{^Is_Word_Break= -Hebrew_Letter}', "");
Expect(0, 64335, '\P{Is_Word_Break= -Hebrew_Letter}', "");
Expect(1, 64335, '\P{^Is_Word_Break= -Hebrew_Letter}', "");
Expect(0, 64336, '\p{Is_Word_Break= -Hebrew_Letter}', "");
Expect(1, 64336, '\p{^Is_Word_Break= -Hebrew_Letter}', "");
Expect(1, 64336, '\P{Is_Word_Break= -Hebrew_Letter}', "");
Expect(0, 64336, '\P{^Is_Word_Break= -Hebrew_Letter}', "");
Error('\p{Is_WB=:= HL}');
Error('\P{Is_WB=:= HL}');
Expect(1, 64335, '\p{Is_WB=hl}', "");
Expect(0, 64335, '\p{^Is_WB=hl}', "");
Expect(0, 64335, '\P{Is_WB=hl}', "");
Expect(1, 64335, '\P{^Is_WB=hl}', "");
Expect(0, 64336, '\p{Is_WB=hl}', "");
Expect(1, 64336, '\p{^Is_WB=hl}', "");
Expect(1, 64336, '\P{Is_WB=hl}', "");
Expect(0, 64336, '\P{^Is_WB=hl}', "");
Expect(1, 64335, '\p{Is_WB=  HL}', "");
Expect(0, 64335, '\p{^Is_WB=  HL}', "");
Expect(0, 64335, '\P{Is_WB=  HL}', "");
Expect(1, 64335, '\P{^Is_WB=  HL}', "");
Expect(0, 64336, '\p{Is_WB=  HL}', "");
Expect(1, 64336, '\p{^Is_WB=  HL}', "");
Expect(1, 64336, '\P{Is_WB=  HL}', "");
Expect(0, 64336, '\P{^Is_WB=  HL}', "");
Error('\p{Word_Break= KATAKANA/a/}');
Error('\P{Word_Break= KATAKANA/a/}');
Expect(1, 110592, '\p{Word_Break=katakana}', "");
Expect(0, 110592, '\p{^Word_Break=katakana}', "");
Expect(0, 110592, '\P{Word_Break=katakana}', "");
Expect(1, 110592, '\P{^Word_Break=katakana}', "");
Expect(0, 110593, '\p{Word_Break=katakana}', "");
Expect(1, 110593, '\p{^Word_Break=katakana}', "");
Expect(1, 110593, '\P{Word_Break=katakana}', "");
Expect(0, 110593, '\P{^Word_Break=katakana}', "");
Expect(1, 110592, '\p{Word_Break=-	katakana}', "");
Expect(0, 110592, '\p{^Word_Break=-	katakana}', "");
Expect(0, 110592, '\P{Word_Break=-	katakana}', "");
Expect(1, 110592, '\P{^Word_Break=-	katakana}', "");
Expect(0, 110593, '\p{Word_Break=-	katakana}', "");
Expect(1, 110593, '\p{^Word_Break=-	katakana}', "");
Expect(1, 110593, '\P{Word_Break=-	katakana}', "");
Expect(0, 110593, '\P{^Word_Break=-	katakana}', "");
Error('\p{WB=:=_KA}');
Error('\P{WB=:=_KA}');
Expect(1, 110592, '\p{WB=ka}', "");
Expect(0, 110592, '\p{^WB=ka}', "");
Expect(0, 110592, '\P{WB=ka}', "");
Expect(1, 110592, '\P{^WB=ka}', "");
Expect(0, 110593, '\p{WB=ka}', "");
Expect(1, 110593, '\p{^WB=ka}', "");
Expect(1, 110593, '\P{WB=ka}', "");
Expect(0, 110593, '\P{^WB=ka}', "");
Expect(1, 110592, '\p{WB=__KA}', "");
Expect(0, 110592, '\p{^WB=__KA}', "");
Expect(0, 110592, '\P{WB=__KA}', "");
Expect(1, 110592, '\P{^WB=__KA}', "");
Expect(0, 110593, '\p{WB=__KA}', "");
Expect(1, 110593, '\p{^WB=__KA}', "");
Expect(1, 110593, '\P{WB=__KA}', "");
Expect(0, 110593, '\P{^WB=__KA}', "");
Error('\p{Is_Word_Break:   _/a/KATAKANA}');
Error('\P{Is_Word_Break:   _/a/KATAKANA}');
Expect(1, 110592, '\p{Is_Word_Break=katakana}', "");
Expect(0, 110592, '\p{^Is_Word_Break=katakana}', "");
Expect(0, 110592, '\P{Is_Word_Break=katakana}', "");
Expect(1, 110592, '\P{^Is_Word_Break=katakana}', "");
Expect(0, 110593, '\p{Is_Word_Break=katakana}', "");
Expect(1, 110593, '\p{^Is_Word_Break=katakana}', "");
Expect(1, 110593, '\P{Is_Word_Break=katakana}', "");
Expect(0, 110593, '\P{^Is_Word_Break=katakana}', "");
Expect(1, 110592, '\p{Is_Word_Break= _katakana}', "");
Expect(0, 110592, '\p{^Is_Word_Break= _katakana}', "");
Expect(0, 110592, '\P{Is_Word_Break= _katakana}', "");
Expect(1, 110592, '\P{^Is_Word_Break= _katakana}', "");
Expect(0, 110593, '\p{Is_Word_Break= _katakana}', "");
Expect(1, 110593, '\p{^Is_Word_Break= _katakana}', "");
Expect(1, 110593, '\P{Is_Word_Break= _katakana}', "");
Expect(0, 110593, '\P{^Is_Word_Break= _katakana}', "");
Error('\p{Is_WB=/a/KA}');
Error('\P{Is_WB=/a/KA}');
Expect(1, 110592, '\p{Is_WB=ka}', "");
Expect(0, 110592, '\p{^Is_WB=ka}', "");
Expect(0, 110592, '\P{Is_WB=ka}', "");
Expect(1, 110592, '\P{^Is_WB=ka}', "");
Expect(0, 110593, '\p{Is_WB=ka}', "");
Expect(1, 110593, '\p{^Is_WB=ka}', "");
Expect(1, 110593, '\P{Is_WB=ka}', "");
Expect(0, 110593, '\P{^Is_WB=ka}', "");
Expect(1, 110592, '\p{Is_WB=	_KA}', "");
Expect(0, 110592, '\p{^Is_WB=	_KA}', "");
Expect(0, 110592, '\P{Is_WB=	_KA}', "");
Expect(1, 110592, '\P{^Is_WB=	_KA}', "");
Expect(0, 110593, '\p{Is_WB=	_KA}', "");
Expect(1, 110593, '\p{^Is_WB=	_KA}', "");
Expect(1, 110593, '\P{Is_WB=	_KA}', "");
Expect(0, 110593, '\P{^Is_WB=	_KA}', "");
Error('\p{Word_Break:   :=	-ALetter}');
Error('\P{Word_Break:   :=	-ALetter}');
Expect(1, 127369, '\p{Word_Break:aletter}', "");
Expect(0, 127369, '\p{^Word_Break:aletter}', "");
Expect(0, 127369, '\P{Word_Break:aletter}', "");
Expect(1, 127369, '\P{^Word_Break:aletter}', "");
Expect(0, 127370, '\p{Word_Break:aletter}', "");
Expect(1, 127370, '\p{^Word_Break:aletter}', "");
Expect(1, 127370, '\P{Word_Break:aletter}', "");
Expect(0, 127370, '\P{^Word_Break:aletter}', "");
Expect(1, 127369, '\p{Word_Break= ALETTER}', "");
Expect(0, 127369, '\p{^Word_Break= ALETTER}', "");
Expect(0, 127369, '\P{Word_Break= ALETTER}', "");
Expect(1, 127369, '\P{^Word_Break= ALETTER}', "");
Expect(0, 127370, '\p{Word_Break= ALETTER}', "");
Expect(1, 127370, '\p{^Word_Break= ALETTER}', "");
Expect(1, 127370, '\P{Word_Break= ALETTER}', "");
Expect(0, 127370, '\P{^Word_Break= ALETTER}', "");
Error('\p{WB:	 LE/a/}');
Error('\P{WB:	 LE/a/}');
Expect(1, 127369, '\p{WB=le}', "");
Expect(0, 127369, '\p{^WB=le}', "");
Expect(0, 127369, '\P{WB=le}', "");
Expect(1, 127369, '\P{^WB=le}', "");
Expect(0, 127370, '\p{WB=le}', "");
Expect(1, 127370, '\p{^WB=le}', "");
Expect(1, 127370, '\P{WB=le}', "");
Expect(0, 127370, '\P{^WB=le}', "");
Error('\p{Is_Word_Break=-:=aletter}');
Error('\P{Is_Word_Break=-:=aletter}');
Expect(1, 127369, '\p{Is_Word_Break=aletter}', "");
Expect(0, 127369, '\p{^Is_Word_Break=aletter}', "");
Expect(0, 127369, '\P{Is_Word_Break=aletter}', "");
Expect(1, 127369, '\P{^Is_Word_Break=aletter}', "");
Expect(0, 127370, '\p{Is_Word_Break=aletter}', "");
Expect(1, 127370, '\p{^Is_Word_Break=aletter}', "");
Expect(1, 127370, '\P{Is_Word_Break=aletter}', "");
Expect(0, 127370, '\P{^Is_Word_Break=aletter}', "");
Expect(1, 127369, '\p{Is_Word_Break=	ALETTER}', "");
Expect(0, 127369, '\p{^Is_Word_Break=	ALETTER}', "");
Expect(0, 127369, '\P{Is_Word_Break=	ALETTER}', "");
Expect(1, 127369, '\P{^Is_Word_Break=	ALETTER}', "");
Expect(0, 127370, '\p{Is_Word_Break=	ALETTER}', "");
Expect(1, 127370, '\p{^Is_Word_Break=	ALETTER}', "");
Expect(1, 127370, '\P{Is_Word_Break=	ALETTER}', "");
Expect(0, 127370, '\P{^Is_Word_Break=	ALETTER}', "");
Error('\p{Is_WB= -le:=}');
Error('\P{Is_WB= -le:=}');
Expect(1, 127369, '\p{Is_WB=le}', "");
Expect(0, 127369, '\p{^Is_WB=le}', "");
Expect(0, 127369, '\P{Is_WB=le}', "");
Expect(1, 127369, '\P{^Is_WB=le}', "");
Expect(0, 127370, '\p{Is_WB=le}', "");
Expect(1, 127370, '\p{^Is_WB=le}', "");
Expect(1, 127370, '\P{Is_WB=le}', "");
Expect(0, 127370, '\P{^Is_WB=le}', "");
Expect(1, 127369, '\p{Is_WB=LE}', "");
Expect(0, 127369, '\p{^Is_WB=LE}', "");
Expect(0, 127369, '\P{Is_WB=LE}', "");
Expect(1, 127369, '\P{^Is_WB=LE}', "");
Expect(0, 127370, '\p{Is_WB=LE}', "");
Expect(1, 127370, '\p{^Is_WB=LE}', "");
Expect(1, 127370, '\P{Is_WB=LE}', "");
Expect(0, 127370, '\P{^Is_WB=LE}', "");
Error('\p{Word_Break= :=LF}');
Error('\P{Word_Break= :=LF}');
Expect(1, 10, '\p{Word_Break=lf}', "");
Expect(0, 10, '\p{^Word_Break=lf}', "");
Expect(0, 10, '\P{Word_Break=lf}', "");
Expect(1, 10, '\P{^Word_Break=lf}', "");
Expect(0, 11, '\p{Word_Break=lf}', "");
Expect(1, 11, '\p{^Word_Break=lf}', "");
Expect(1, 11, '\P{Word_Break=lf}', "");
Expect(0, 11, '\P{^Word_Break=lf}', "");
Expect(1, 10, '\p{Word_Break:_-LF}', "");
Expect(0, 10, '\p{^Word_Break:_-LF}', "");
Expect(0, 10, '\P{Word_Break:_-LF}', "");
Expect(1, 10, '\P{^Word_Break:_-LF}', "");
Expect(0, 11, '\p{Word_Break:_-LF}', "");
Expect(1, 11, '\p{^Word_Break:_-LF}', "");
Expect(1, 11, '\P{Word_Break:_-LF}', "");
Expect(0, 11, '\P{^Word_Break:_-LF}', "");
Error('\p{WB:_ lf/a/}');
Error('\P{WB:_ lf/a/}');
Expect(1, 10, '\p{WB=lf}', "");
Expect(0, 10, '\p{^WB=lf}', "");
Expect(0, 10, '\P{WB=lf}', "");
Expect(1, 10, '\P{^WB=lf}', "");
Expect(0, 11, '\p{WB=lf}', "");
Expect(1, 11, '\p{^WB=lf}', "");
Expect(1, 11, '\P{WB=lf}', "");
Expect(0, 11, '\P{^WB=lf}', "");
Expect(1, 10, '\p{WB=_ LF}', "");
Expect(0, 10, '\p{^WB=_ LF}', "");
Expect(0, 10, '\P{WB=_ LF}', "");
Expect(1, 10, '\P{^WB=_ LF}', "");
Expect(0, 11, '\p{WB=_ LF}', "");
Expect(1, 11, '\p{^WB=_ LF}', "");
Expect(1, 11, '\P{WB=_ LF}', "");
Expect(0, 11, '\P{^WB=_ LF}', "");
Error('\p{Is_Word_Break=_-LF:=}');
Error('\P{Is_Word_Break=_-LF:=}');
Expect(1, 10, '\p{Is_Word_Break=lf}', "");
Expect(0, 10, '\p{^Is_Word_Break=lf}', "");
Expect(0, 10, '\P{Is_Word_Break=lf}', "");
Expect(1, 10, '\P{^Is_Word_Break=lf}', "");
Expect(0, 11, '\p{Is_Word_Break=lf}', "");
Expect(1, 11, '\p{^Is_Word_Break=lf}', "");
Expect(1, 11, '\P{Is_Word_Break=lf}', "");
Expect(0, 11, '\P{^Is_Word_Break=lf}', "");
Expect(1, 10, '\p{Is_Word_Break=__LF}', "");
Expect(0, 10, '\p{^Is_Word_Break=__LF}', "");
Expect(0, 10, '\P{Is_Word_Break=__LF}', "");
Expect(1, 10, '\P{^Is_Word_Break=__LF}', "");
Expect(0, 11, '\p{Is_Word_Break=__LF}', "");
Expect(1, 11, '\p{^Is_Word_Break=__LF}', "");
Expect(1, 11, '\P{Is_Word_Break=__LF}', "");
Expect(0, 11, '\P{^Is_Word_Break=__LF}', "");
Error('\p{Is_WB= LF:=}');
Error('\P{Is_WB= LF:=}');
Expect(1, 10, '\p{Is_WB=lf}', "");
Expect(0, 10, '\p{^Is_WB=lf}', "");
Expect(0, 10, '\P{Is_WB=lf}', "");
Expect(1, 10, '\P{^Is_WB=lf}', "");
Expect(0, 11, '\p{Is_WB=lf}', "");
Expect(1, 11, '\p{^Is_WB=lf}', "");
Expect(1, 11, '\P{Is_WB=lf}', "");
Expect(0, 11, '\P{^Is_WB=lf}', "");
Expect(1, 10, '\p{Is_WB:   	lf}', "");
Expect(0, 10, '\p{^Is_WB:   	lf}', "");
Expect(0, 10, '\P{Is_WB:   	lf}', "");
Expect(1, 10, '\P{^Is_WB:   	lf}', "");
Expect(0, 11, '\p{Is_WB:   	lf}', "");
Expect(1, 11, '\p{^Is_WB:   	lf}', "");
Expect(1, 11, '\P{Is_WB:   	lf}', "");
Expect(0, 11, '\P{^Is_WB:   	lf}', "");
Error('\p{Word_Break=/a/__MidNumLet}');
Error('\P{Word_Break=/a/__MidNumLet}');
Expect(1, 65294, '\p{Word_Break: midnumlet}', "");
Expect(0, 65294, '\p{^Word_Break: midnumlet}', "");
Expect(0, 65294, '\P{Word_Break: midnumlet}', "");
Expect(1, 65294, '\P{^Word_Break: midnumlet}', "");
Expect(0, 65295, '\p{Word_Break: midnumlet}', "");
Expect(1, 65295, '\p{^Word_Break: midnumlet}', "");
Expect(1, 65295, '\P{Word_Break: midnumlet}', "");
Expect(0, 65295, '\P{^Word_Break: midnumlet}', "");
Expect(1, 65294, '\p{Word_Break= -midnumlet}', "");
Expect(0, 65294, '\p{^Word_Break= -midnumlet}', "");
Expect(0, 65294, '\P{Word_Break= -midnumlet}', "");
Expect(1, 65294, '\P{^Word_Break= -midnumlet}', "");
Expect(0, 65295, '\p{Word_Break= -midnumlet}', "");
Expect(1, 65295, '\p{^Word_Break= -midnumlet}', "");
Expect(1, 65295, '\P{Word_Break= -midnumlet}', "");
Expect(0, 65295, '\P{^Word_Break= -midnumlet}', "");
Error('\p{WB=/a/ 	MB}');
Error('\P{WB=/a/ 	MB}');
Expect(1, 65294, '\p{WB=mb}', "");
Expect(0, 65294, '\p{^WB=mb}', "");
Expect(0, 65294, '\P{WB=mb}', "");
Expect(1, 65294, '\P{^WB=mb}', "");
Expect(0, 65295, '\p{WB=mb}', "");
Expect(1, 65295, '\p{^WB=mb}', "");
Expect(1, 65295, '\P{WB=mb}', "");
Expect(0, 65295, '\P{^WB=mb}', "");
Expect(1, 65294, '\p{WB=-MB}', "");
Expect(0, 65294, '\p{^WB=-MB}', "");
Expect(0, 65294, '\P{WB=-MB}', "");
Expect(1, 65294, '\P{^WB=-MB}', "");
Expect(0, 65295, '\p{WB=-MB}', "");
Expect(1, 65295, '\p{^WB=-MB}', "");
Expect(1, 65295, '\P{WB=-MB}', "");
Expect(0, 65295, '\P{^WB=-MB}', "");
Error('\p{Is_Word_Break=--midnumlet:=}');
Error('\P{Is_Word_Break=--midnumlet:=}');
Expect(1, 65294, '\p{Is_Word_Break=midnumlet}', "");
Expect(0, 65294, '\p{^Is_Word_Break=midnumlet}', "");
Expect(0, 65294, '\P{Is_Word_Break=midnumlet}', "");
Expect(1, 65294, '\P{^Is_Word_Break=midnumlet}', "");
Expect(0, 65295, '\p{Is_Word_Break=midnumlet}', "");
Expect(1, 65295, '\p{^Is_Word_Break=midnumlet}', "");
Expect(1, 65295, '\P{Is_Word_Break=midnumlet}', "");
Expect(0, 65295, '\P{^Is_Word_Break=midnumlet}', "");
Error('\p{Is_WB=_mb:=}');
Error('\P{Is_WB=_mb:=}');
Expect(1, 65294, '\p{Is_WB=mb}', "");
Expect(0, 65294, '\p{^Is_WB=mb}', "");
Expect(0, 65294, '\P{Is_WB=mb}', "");
Expect(1, 65294, '\P{^Is_WB=mb}', "");
Expect(0, 65295, '\p{Is_WB=mb}', "");
Expect(1, 65295, '\p{^Is_WB=mb}', "");
Expect(1, 65295, '\P{Is_WB=mb}', "");
Expect(0, 65295, '\P{^Is_WB=mb}', "");
Expect(1, 65294, '\p{Is_WB=__mb}', "");
Expect(0, 65294, '\p{^Is_WB=__mb}', "");
Expect(0, 65294, '\P{Is_WB=__mb}', "");
Expect(1, 65294, '\P{^Is_WB=__mb}', "");
Expect(0, 65295, '\p{Is_WB=__mb}', "");
Expect(1, 65295, '\p{^Is_WB=__mb}', "");
Expect(1, 65295, '\P{Is_WB=__mb}', "");
Expect(0, 65295, '\P{^Is_WB=__mb}', "");
Error('\p{Word_Break=_midletter:=}');
Error('\P{Word_Break=_midletter:=}');
Expect(1, 65306, '\p{Word_Break=midletter}', "");
Expect(0, 65306, '\p{^Word_Break=midletter}', "");
Expect(0, 65306, '\P{Word_Break=midletter}', "");
Expect(1, 65306, '\P{^Word_Break=midletter}', "");
Expect(0, 65307, '\p{Word_Break=midletter}', "");
Expect(1, 65307, '\p{^Word_Break=midletter}', "");
Expect(1, 65307, '\P{Word_Break=midletter}', "");
Expect(0, 65307, '\P{^Word_Break=midletter}', "");
Expect(1, 65306, '\p{Word_Break=	-MidLetter}', "");
Expect(0, 65306, '\p{^Word_Break=	-MidLetter}', "");
Expect(0, 65306, '\P{Word_Break=	-MidLetter}', "");
Expect(1, 65306, '\P{^Word_Break=	-MidLetter}', "");
Expect(0, 65307, '\p{Word_Break=	-MidLetter}', "");
Expect(1, 65307, '\p{^Word_Break=	-MidLetter}', "");
Expect(1, 65307, '\P{Word_Break=	-MidLetter}', "");
Expect(0, 65307, '\P{^Word_Break=	-MidLetter}', "");
Error('\p{WB=ML:=}');
Error('\P{WB=ML:=}');
Expect(1, 65306, '\p{WB=ml}', "");
Expect(0, 65306, '\p{^WB=ml}', "");
Expect(0, 65306, '\P{WB=ml}', "");
Expect(1, 65306, '\P{^WB=ml}', "");
Expect(0, 65307, '\p{WB=ml}', "");
Expect(1, 65307, '\p{^WB=ml}', "");
Expect(1, 65307, '\P{WB=ml}', "");
Expect(0, 65307, '\P{^WB=ml}', "");
Expect(1, 65306, '\p{WB= ml}', "");
Expect(0, 65306, '\p{^WB= ml}', "");
Expect(0, 65306, '\P{WB= ml}', "");
Expect(1, 65306, '\P{^WB= ml}', "");
Expect(0, 65307, '\p{WB= ml}', "");
Expect(1, 65307, '\p{^WB= ml}', "");
Expect(1, 65307, '\P{WB= ml}', "");
Expect(0, 65307, '\P{^WB= ml}', "");
Error('\p{Is_Word_Break=_/a/MidLetter}');
Error('\P{Is_Word_Break=_/a/MidLetter}');
Expect(1, 65306, '\p{Is_Word_Break:	midletter}', "");
Expect(0, 65306, '\p{^Is_Word_Break:	midletter}', "");
Expect(0, 65306, '\P{Is_Word_Break:	midletter}', "");
Expect(1, 65306, '\P{^Is_Word_Break:	midletter}', "");
Expect(0, 65307, '\p{Is_Word_Break:	midletter}', "");
Expect(1, 65307, '\p{^Is_Word_Break:	midletter}', "");
Expect(1, 65307, '\P{Is_Word_Break:	midletter}', "");
Expect(0, 65307, '\P{^Is_Word_Break:	midletter}', "");
Expect(1, 65306, '\p{Is_Word_Break=- MidLetter}', "");
Expect(0, 65306, '\p{^Is_Word_Break=- MidLetter}', "");
Expect(0, 65306, '\P{Is_Word_Break=- MidLetter}', "");
Expect(1, 65306, '\P{^Is_Word_Break=- MidLetter}', "");
Expect(0, 65307, '\p{Is_Word_Break=- MidLetter}', "");
Expect(1, 65307, '\p{^Is_Word_Break=- MidLetter}', "");
Expect(1, 65307, '\P{Is_Word_Break=- MidLetter}', "");
Expect(0, 65307, '\P{^Is_Word_Break=- MidLetter}', "");
Error('\p{Is_WB=/a/-_ML}');
Error('\P{Is_WB=/a/-_ML}');
Expect(1, 65306, '\p{Is_WB: ml}', "");
Expect(0, 65306, '\p{^Is_WB: ml}', "");
Expect(0, 65306, '\P{Is_WB: ml}', "");
Expect(1, 65306, '\P{^Is_WB: ml}', "");
Expect(0, 65307, '\p{Is_WB: ml}', "");
Expect(1, 65307, '\p{^Is_WB: ml}', "");
Expect(1, 65307, '\P{Is_WB: ml}', "");
Expect(0, 65307, '\P{^Is_WB: ml}', "");
Expect(1, 65306, '\p{Is_WB=	ML}', "");
Expect(0, 65306, '\p{^Is_WB=	ML}', "");
Expect(0, 65306, '\P{Is_WB=	ML}', "");
Expect(1, 65306, '\P{^Is_WB=	ML}', "");
Expect(0, 65307, '\p{Is_WB=	ML}', "");
Expect(1, 65307, '\p{^Is_WB=	ML}', "");
Expect(1, 65307, '\P{Is_WB=	ML}', "");
Expect(0, 65307, '\P{^Is_WB=	ML}', "");
Error('\p{Word_Break:-MidNum:=}');
Error('\P{Word_Break:-MidNum:=}');
Expect(1, 65307, '\p{Word_Break:   midnum}', "");
Expect(0, 65307, '\p{^Word_Break:   midnum}', "");
Expect(0, 65307, '\P{Word_Break:   midnum}', "");
Expect(1, 65307, '\P{^Word_Break:   midnum}', "");
Expect(0, 65308, '\p{Word_Break:   midnum}', "");
Expect(1, 65308, '\p{^Word_Break:   midnum}', "");
Expect(1, 65308, '\P{Word_Break:   midnum}', "");
Expect(0, 65308, '\P{^Word_Break:   midnum}', "");
Expect(1, 65307, '\p{Word_Break:   -MidNum}', "");
Expect(0, 65307, '\p{^Word_Break:   -MidNum}', "");
Expect(0, 65307, '\P{Word_Break:   -MidNum}', "");
Expect(1, 65307, '\P{^Word_Break:   -MidNum}', "");
Expect(0, 65308, '\p{Word_Break:   -MidNum}', "");
Expect(1, 65308, '\p{^Word_Break:   -MidNum}', "");
Expect(1, 65308, '\P{Word_Break:   -MidNum}', "");
Expect(0, 65308, '\P{^Word_Break:   -MidNum}', "");
Error('\p{WB=	_MN/a/}');
Error('\P{WB=	_MN/a/}');
Expect(1, 65307, '\p{WB=mn}', "");
Expect(0, 65307, '\p{^WB=mn}', "");
Expect(0, 65307, '\P{WB=mn}', "");
Expect(1, 65307, '\P{^WB=mn}', "");
Expect(0, 65308, '\p{WB=mn}', "");
Expect(1, 65308, '\p{^WB=mn}', "");
Expect(1, 65308, '\P{WB=mn}', "");
Expect(0, 65308, '\P{^WB=mn}', "");
Expect(1, 65307, '\p{WB=-_MN}', "");
Expect(0, 65307, '\p{^WB=-_MN}', "");
Expect(0, 65307, '\P{WB=-_MN}', "");
Expect(1, 65307, '\P{^WB=-_MN}', "");
Expect(0, 65308, '\p{WB=-_MN}', "");
Expect(1, 65308, '\p{^WB=-_MN}', "");
Expect(1, 65308, '\P{WB=-_MN}', "");
Expect(0, 65308, '\P{^WB=-_MN}', "");
Error('\p{Is_Word_Break= MidNum:=}');
Error('\P{Is_Word_Break= MidNum:=}');
Expect(1, 65307, '\p{Is_Word_Break=midnum}', "");
Expect(0, 65307, '\p{^Is_Word_Break=midnum}', "");
Expect(0, 65307, '\P{Is_Word_Break=midnum}', "");
Expect(1, 65307, '\P{^Is_Word_Break=midnum}', "");
Expect(0, 65308, '\p{Is_Word_Break=midnum}', "");
Expect(1, 65308, '\p{^Is_Word_Break=midnum}', "");
Expect(1, 65308, '\P{Is_Word_Break=midnum}', "");
Expect(0, 65308, '\P{^Is_Word_Break=midnum}', "");
Expect(1, 65307, '\p{Is_Word_Break=_midnum}', "");
Expect(0, 65307, '\p{^Is_Word_Break=_midnum}', "");
Expect(0, 65307, '\P{Is_Word_Break=_midnum}', "");
Expect(1, 65307, '\P{^Is_Word_Break=_midnum}', "");
Expect(0, 65308, '\p{Is_Word_Break=_midnum}', "");
Expect(1, 65308, '\p{^Is_Word_Break=_midnum}', "");
Expect(1, 65308, '\P{Is_Word_Break=_midnum}', "");
Expect(0, 65308, '\P{^Is_Word_Break=_midnum}', "");
Error('\p{Is_WB:	_mn/a/}');
Error('\P{Is_WB:	_mn/a/}');
Expect(1, 65307, '\p{Is_WB=mn}', "");
Expect(0, 65307, '\p{^Is_WB=mn}', "");
Expect(0, 65307, '\P{Is_WB=mn}', "");
Expect(1, 65307, '\P{^Is_WB=mn}', "");
Expect(0, 65308, '\p{Is_WB=mn}', "");
Expect(1, 65308, '\p{^Is_WB=mn}', "");
Expect(1, 65308, '\P{Is_WB=mn}', "");
Expect(0, 65308, '\P{^Is_WB=mn}', "");
Expect(1, 65307, '\p{Is_WB: _MN}', "");
Expect(0, 65307, '\p{^Is_WB: _MN}', "");
Expect(0, 65307, '\P{Is_WB: _MN}', "");
Expect(1, 65307, '\P{^Is_WB: _MN}', "");
Expect(0, 65308, '\p{Is_WB: _MN}', "");
Expect(1, 65308, '\p{^Is_WB: _MN}', "");
Expect(1, 65308, '\P{Is_WB: _MN}', "");
Expect(0, 65308, '\P{^Is_WB: _MN}', "");
Error('\p{Word_Break=	_Newline:=}');
Error('\P{Word_Break=	_Newline:=}');
Expect(1, 8233, '\p{Word_Break:   newline}', "");
Expect(0, 8233, '\p{^Word_Break:   newline}', "");
Expect(0, 8233, '\P{Word_Break:   newline}', "");
Expect(1, 8233, '\P{^Word_Break:   newline}', "");
Expect(0, 8234, '\p{Word_Break:   newline}', "");
Expect(1, 8234, '\p{^Word_Break:   newline}', "");
Expect(1, 8234, '\P{Word_Break:   newline}', "");
Expect(0, 8234, '\P{^Word_Break:   newline}', "");
Expect(1, 8233, '\p{Word_Break=-newline}', "");
Expect(0, 8233, '\p{^Word_Break=-newline}', "");
Expect(0, 8233, '\P{Word_Break=-newline}', "");
Expect(1, 8233, '\P{^Word_Break=-newline}', "");
Expect(0, 8234, '\p{Word_Break=-newline}', "");
Expect(1, 8234, '\p{^Word_Break=-newline}', "");
Expect(1, 8234, '\P{Word_Break=-newline}', "");
Expect(0, 8234, '\P{^Word_Break=-newline}', "");
Error('\p{WB=/a/_-NL}');
Error('\P{WB=/a/_-NL}');
Expect(1, 8233, '\p{WB=nl}', "");
Expect(0, 8233, '\p{^WB=nl}', "");
Expect(0, 8233, '\P{WB=nl}', "");
Expect(1, 8233, '\P{^WB=nl}', "");
Expect(0, 8234, '\p{WB=nl}', "");
Expect(1, 8234, '\p{^WB=nl}', "");
Expect(1, 8234, '\P{WB=nl}', "");
Expect(0, 8234, '\P{^WB=nl}', "");
Expect(1, 8233, '\p{WB: 	NL}', "");
Expect(0, 8233, '\p{^WB: 	NL}', "");
Expect(0, 8233, '\P{WB: 	NL}', "");
Expect(1, 8233, '\P{^WB: 	NL}', "");
Expect(0, 8234, '\p{WB: 	NL}', "");
Expect(1, 8234, '\p{^WB: 	NL}', "");
Expect(1, 8234, '\P{WB: 	NL}', "");
Expect(0, 8234, '\P{^WB: 	NL}', "");
Error('\p{Is_Word_Break=	:=newline}');
Error('\P{Is_Word_Break=	:=newline}');
Expect(1, 8233, '\p{Is_Word_Break:	newline}', "");
Expect(0, 8233, '\p{^Is_Word_Break:	newline}', "");
Expect(0, 8233, '\P{Is_Word_Break:	newline}', "");
Expect(1, 8233, '\P{^Is_Word_Break:	newline}', "");
Expect(0, 8234, '\p{Is_Word_Break:	newline}', "");
Expect(1, 8234, '\p{^Is_Word_Break:	newline}', "");
Expect(1, 8234, '\P{Is_Word_Break:	newline}', "");
Expect(0, 8234, '\P{^Is_Word_Break:	newline}', "");
Expect(1, 8233, '\p{Is_Word_Break= NEWLINE}', "");
Expect(0, 8233, '\p{^Is_Word_Break= NEWLINE}', "");
Expect(0, 8233, '\P{Is_Word_Break= NEWLINE}', "");
Expect(1, 8233, '\P{^Is_Word_Break= NEWLINE}', "");
Expect(0, 8234, '\p{Is_Word_Break= NEWLINE}', "");
Expect(1, 8234, '\p{^Is_Word_Break= NEWLINE}', "");
Expect(1, 8234, '\P{Is_Word_Break= NEWLINE}', "");
Expect(0, 8234, '\P{^Is_Word_Break= NEWLINE}', "");
Error('\p{Is_WB=/a/  NL}');
Error('\P{Is_WB=/a/  NL}');
Expect(1, 8233, '\p{Is_WB=nl}', "");
Expect(0, 8233, '\p{^Is_WB=nl}', "");
Expect(0, 8233, '\P{Is_WB=nl}', "");
Expect(1, 8233, '\P{^Is_WB=nl}', "");
Expect(0, 8234, '\p{Is_WB=nl}', "");
Expect(1, 8234, '\p{^Is_WB=nl}', "");
Expect(1, 8234, '\P{Is_WB=nl}', "");
Expect(0, 8234, '\P{^Is_WB=nl}', "");
Expect(1, 8233, '\p{Is_WB=-	NL}', "");
Expect(0, 8233, '\p{^Is_WB=-	NL}', "");
Expect(0, 8233, '\P{Is_WB=-	NL}', "");
Expect(1, 8233, '\P{^Is_WB=-	NL}', "");
Expect(0, 8234, '\p{Is_WB=-	NL}', "");
Expect(1, 8234, '\p{^Is_WB=-	NL}', "");
Expect(1, 8234, '\P{Is_WB=-	NL}', "");
Expect(0, 8234, '\P{^Is_WB=-	NL}', "");
Error('\p{Word_Break=:=Numeric}');
Error('\P{Word_Break=:=Numeric}');
Expect(1, 120831, '\p{Word_Break=numeric}', "");
Expect(0, 120831, '\p{^Word_Break=numeric}', "");
Expect(0, 120831, '\P{Word_Break=numeric}', "");
Expect(1, 120831, '\P{^Word_Break=numeric}', "");
Expect(0, 120832, '\p{Word_Break=numeric}', "");
Expect(1, 120832, '\p{^Word_Break=numeric}', "");
Expect(1, 120832, '\P{Word_Break=numeric}', "");
Expect(0, 120832, '\P{^Word_Break=numeric}', "");
Expect(1, 120831, '\p{Word_Break= numeric}', "");
Expect(0, 120831, '\p{^Word_Break= numeric}', "");
Expect(0, 120831, '\P{Word_Break= numeric}', "");
Expect(1, 120831, '\P{^Word_Break= numeric}', "");
Expect(0, 120832, '\p{Word_Break= numeric}', "");
Expect(1, 120832, '\p{^Word_Break= numeric}', "");
Expect(1, 120832, '\P{Word_Break= numeric}', "");
Expect(0, 120832, '\P{^Word_Break= numeric}', "");
Error('\p{WB=:=- NU}');
Error('\P{WB=:=- NU}');
Expect(1, 120831, '\p{WB=nu}', "");
Expect(0, 120831, '\p{^WB=nu}', "");
Expect(0, 120831, '\P{WB=nu}', "");
Expect(1, 120831, '\P{^WB=nu}', "");
Expect(0, 120832, '\p{WB=nu}', "");
Expect(1, 120832, '\p{^WB=nu}', "");
Expect(1, 120832, '\P{WB=nu}', "");
Expect(0, 120832, '\P{^WB=nu}', "");
Expect(1, 120831, '\p{WB= _NU}', "");
Expect(0, 120831, '\p{^WB= _NU}', "");
Expect(0, 120831, '\P{WB= _NU}', "");
Expect(1, 120831, '\P{^WB= _NU}', "");
Expect(0, 120832, '\p{WB= _NU}', "");
Expect(1, 120832, '\p{^WB= _NU}', "");
Expect(1, 120832, '\P{WB= _NU}', "");
Expect(0, 120832, '\P{^WB= _NU}', "");
Error('\p{Is_Word_Break:/a/_-numeric}');
Error('\P{Is_Word_Break:/a/_-numeric}');
Expect(1, 120831, '\p{Is_Word_Break=numeric}', "");
Expect(0, 120831, '\p{^Is_Word_Break=numeric}', "");
Expect(0, 120831, '\P{Is_Word_Break=numeric}', "");
Expect(1, 120831, '\P{^Is_Word_Break=numeric}', "");
Expect(0, 120832, '\p{Is_Word_Break=numeric}', "");
Expect(1, 120832, '\p{^Is_Word_Break=numeric}', "");
Expect(1, 120832, '\P{Is_Word_Break=numeric}', "");
Expect(0, 120832, '\P{^Is_Word_Break=numeric}', "");
Expect(1, 120831, '\p{Is_Word_Break= -Numeric}', "");
Expect(0, 120831, '\p{^Is_Word_Break= -Numeric}', "");
Expect(0, 120831, '\P{Is_Word_Break= -Numeric}', "");
Expect(1, 120831, '\P{^Is_Word_Break= -Numeric}', "");
Expect(0, 120832, '\p{Is_Word_Break= -Numeric}', "");
Expect(1, 120832, '\p{^Is_Word_Break= -Numeric}', "");
Expect(1, 120832, '\P{Is_Word_Break= -Numeric}', "");
Expect(0, 120832, '\P{^Is_Word_Break= -Numeric}', "");
Error('\p{Is_WB=--NU:=}');
Error('\P{Is_WB=--NU:=}');
Expect(1, 120831, '\p{Is_WB=nu}', "");
Expect(0, 120831, '\p{^Is_WB=nu}', "");
Expect(0, 120831, '\P{Is_WB=nu}', "");
Expect(1, 120831, '\P{^Is_WB=nu}', "");
Expect(0, 120832, '\p{Is_WB=nu}', "");
Expect(1, 120832, '\p{^Is_WB=nu}', "");
Expect(1, 120832, '\P{Is_WB=nu}', "");
Expect(0, 120832, '\P{^Is_WB=nu}', "");
Expect(1, 120831, '\p{Is_WB: _	nu}', "");
Expect(0, 120831, '\p{^Is_WB: _	nu}', "");
Expect(0, 120831, '\P{Is_WB: _	nu}', "");
Expect(1, 120831, '\P{^Is_WB: _	nu}', "");
Expect(0, 120832, '\p{Is_WB: _	nu}', "");
Expect(1, 120832, '\p{^Is_WB: _	nu}', "");
Expect(1, 120832, '\P{Is_WB: _	nu}', "");
Expect(0, 120832, '\P{^Is_WB: _	nu}', "");
Error('\p{Word_Break=- Regional_INDICATOR:=}');
Error('\P{Word_Break=- Regional_INDICATOR:=}');
Expect(1, 127487, '\p{Word_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Word_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Word_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Word_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Word_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Word_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Word_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Word_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Word_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\p{^Word_Break= -Regional_Indicator}', "");
Expect(0, 127487, '\P{Word_Break= -Regional_Indicator}', "");
Expect(1, 127487, '\P{^Word_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\p{Word_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\p{^Word_Break= -Regional_Indicator}', "");
Expect(1, 127488, '\P{Word_Break= -Regional_Indicator}', "");
Expect(0, 127488, '\P{^Word_Break= -Regional_Indicator}', "");
Error('\p{WB=_/a/RI}');
Error('\P{WB=_/a/RI}');
Expect(1, 127487, '\p{WB=ri}', "");
Expect(0, 127487, '\p{^WB=ri}', "");
Expect(0, 127487, '\P{WB=ri}', "");
Expect(1, 127487, '\P{^WB=ri}', "");
Expect(0, 127488, '\p{WB=ri}', "");
Expect(1, 127488, '\p{^WB=ri}', "");
Expect(1, 127488, '\P{WB=ri}', "");
Expect(0, 127488, '\P{^WB=ri}', "");
Expect(1, 127487, '\p{WB=-RI}', "");
Expect(0, 127487, '\p{^WB=-RI}', "");
Expect(0, 127487, '\P{WB=-RI}', "");
Expect(1, 127487, '\P{^WB=-RI}', "");
Expect(0, 127488, '\p{WB=-RI}', "");
Expect(1, 127488, '\p{^WB=-RI}', "");
Expect(1, 127488, '\P{WB=-RI}', "");
Expect(0, 127488, '\P{^WB=-RI}', "");
Error('\p{Is_Word_Break=__regional_indicator:=}');
Error('\P{Is_Word_Break=__regional_indicator:=}');
Expect(1, 127487, '\p{Is_Word_Break=regionalindicator}', "");
Expect(0, 127487, '\p{^Is_Word_Break=regionalindicator}', "");
Expect(0, 127487, '\P{Is_Word_Break=regionalindicator}', "");
Expect(1, 127487, '\P{^Is_Word_Break=regionalindicator}', "");
Expect(0, 127488, '\p{Is_Word_Break=regionalindicator}', "");
Expect(1, 127488, '\p{^Is_Word_Break=regionalindicator}', "");
Expect(1, 127488, '\P{Is_Word_Break=regionalindicator}', "");
Expect(0, 127488, '\P{^Is_Word_Break=regionalindicator}', "");
Expect(1, 127487, '\p{Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(0, 127487, '\p{^Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(0, 127487, '\P{Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(1, 127487, '\P{^Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(0, 127488, '\p{Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(1, 127488, '\p{^Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(1, 127488, '\P{Is_Word_Break=	REGIONAL_INDICATOR}', "");
Expect(0, 127488, '\P{^Is_Word_Break=	REGIONAL_INDICATOR}', "");
Error('\p{Is_WB=-_RI:=}');
Error('\P{Is_WB=-_RI:=}');
Expect(1, 127487, '\p{Is_WB=ri}', "");
Expect(0, 127487, '\p{^Is_WB=ri}', "");
Expect(0, 127487, '\P{Is_WB=ri}', "");
Expect(1, 127487, '\P{^Is_WB=ri}', "");
Expect(0, 127488, '\p{Is_WB=ri}', "");
Expect(1, 127488, '\p{^Is_WB=ri}', "");
Expect(1, 127488, '\P{Is_WB=ri}', "");
Expect(0, 127488, '\P{^Is_WB=ri}', "");
Expect(1, 127487, '\p{Is_WB=- RI}', "");
Expect(0, 127487, '\p{^Is_WB=- RI}', "");
Expect(0, 127487, '\P{Is_WB=- RI}', "");
Expect(1, 127487, '\P{^Is_WB=- RI}', "");
Expect(0, 127488, '\p{Is_WB=- RI}', "");
Expect(1, 127488, '\p{^Is_WB=- RI}', "");
Expect(1, 127488, '\P{Is_WB=- RI}', "");
Expect(0, 127488, '\P{^Is_WB=- RI}', "");
Error('\p{Word_Break: :=-	Single_Quote}');
Error('\P{Word_Break: :=-	Single_Quote}');
Expect(1, 39, '\p{Word_Break=singlequote}', "");
Expect(0, 39, '\p{^Word_Break=singlequote}', "");
Expect(0, 39, '\P{Word_Break=singlequote}', "");
Expect(1, 39, '\P{^Word_Break=singlequote}', "");
Expect(0, 40, '\p{Word_Break=singlequote}', "");
Expect(1, 40, '\p{^Word_Break=singlequote}', "");
Expect(1, 40, '\P{Word_Break=singlequote}', "");
Expect(0, 40, '\P{^Word_Break=singlequote}', "");
Expect(1, 39, '\p{Word_Break=-_Single_quote}', "");
Expect(0, 39, '\p{^Word_Break=-_Single_quote}', "");
Expect(0, 39, '\P{Word_Break=-_Single_quote}', "");
Expect(1, 39, '\P{^Word_Break=-_Single_quote}', "");
Expect(0, 40, '\p{Word_Break=-_Single_quote}', "");
Expect(1, 40, '\p{^Word_Break=-_Single_quote}', "");
Expect(1, 40, '\P{Word_Break=-_Single_quote}', "");
Expect(0, 40, '\P{^Word_Break=-_Single_quote}', "");
Error('\p{WB=:= SQ}');
Error('\P{WB=:= SQ}');
Expect(1, 39, '\p{WB=sq}', "");
Expect(0, 39, '\p{^WB=sq}', "");
Expect(0, 39, '\P{WB=sq}', "");
Expect(1, 39, '\P{^WB=sq}', "");
Expect(0, 40, '\p{WB=sq}', "");
Expect(1, 40, '\p{^WB=sq}', "");
Expect(1, 40, '\P{WB=sq}', "");
Expect(0, 40, '\P{^WB=sq}', "");
Expect(1, 39, '\p{WB=	-SQ}', "");
Expect(0, 39, '\p{^WB=	-SQ}', "");
Expect(0, 39, '\P{WB=	-SQ}', "");
Expect(1, 39, '\P{^WB=	-SQ}', "");
Expect(0, 40, '\p{WB=	-SQ}', "");
Expect(1, 40, '\p{^WB=	-SQ}', "");
Expect(1, 40, '\P{WB=	-SQ}', "");
Expect(0, 40, '\P{^WB=	-SQ}', "");
Error('\p{Is_Word_Break=:= -single_Quote}');
Error('\P{Is_Word_Break=:= -single_Quote}');
Expect(1, 39, '\p{Is_Word_Break=singlequote}', "");
Expect(0, 39, '\p{^Is_Word_Break=singlequote}', "");
Expect(0, 39, '\P{Is_Word_Break=singlequote}', "");
Expect(1, 39, '\P{^Is_Word_Break=singlequote}', "");
Expect(0, 40, '\p{Is_Word_Break=singlequote}', "");
Expect(1, 40, '\p{^Is_Word_Break=singlequote}', "");
Expect(1, 40, '\P{Is_Word_Break=singlequote}', "");
Expect(0, 40, '\P{^Is_Word_Break=singlequote}', "");
Expect(1, 39, '\p{Is_Word_Break=	_Single_Quote}', "");
Expect(0, 39, '\p{^Is_Word_Break=	_Single_Quote}', "");
Expect(0, 39, '\P{Is_Word_Break=	_Single_Quote}', "");
Expect(1, 39, '\P{^Is_Word_Break=	_Single_Quote}', "");
Expect(0, 40, '\p{Is_Word_Break=	_Single_Quote}', "");
Expect(1, 40, '\p{^Is_Word_Break=	_Single_Quote}', "");
Expect(1, 40, '\P{Is_Word_Break=	_Single_Quote}', "");
Expect(0, 40, '\P{^Is_Word_Break=	_Single_Quote}', "");
Error('\p{Is_WB=/a/ SQ}');
Error('\P{Is_WB=/a/ SQ}');
Expect(1, 39, '\p{Is_WB=sq}', "");
Expect(0, 39, '\p{^Is_WB=sq}', "");
Expect(0, 39, '\P{Is_WB=sq}', "");
Expect(1, 39, '\P{^Is_WB=sq}', "");
Expect(0, 40, '\p{Is_WB=sq}', "");
Expect(1, 40, '\p{^Is_WB=sq}', "");
Expect(1, 40, '\P{Is_WB=sq}', "");
Expect(0, 40, '\P{^Is_WB=sq}', "");
Expect(1, 39, '\p{Is_WB= sq}', "");
Expect(0, 39, '\p{^Is_WB= sq}', "");
Expect(0, 39, '\P{Is_WB= sq}', "");
Expect(1, 39, '\P{^Is_WB= sq}', "");
Expect(0, 40, '\p{Is_WB= sq}', "");
Expect(1, 40, '\p{^Is_WB= sq}', "");
Expect(1, 40, '\P{Is_WB= sq}', "");
Expect(0, 40, '\P{^Is_WB= sq}', "");
Error('\p{Word_Break=/a/-other}');
Error('\P{Word_Break=/a/-other}');
Expect(1, 918000, '\p{Word_Break=other}', "");
Expect(0, 918000, '\p{^Word_Break=other}', "");
Expect(0, 918000, '\P{Word_Break=other}', "");
Expect(1, 918000, '\P{^Word_Break=other}', "");
Expect(0, 917999, '\p{Word_Break=other}', "");
Expect(1, 917999, '\p{^Word_Break=other}', "");
Expect(1, 917999, '\P{Word_Break=other}', "");
Expect(0, 917999, '\P{^Word_Break=other}', "");
Expect(1, 918000, '\p{Word_Break=	OTHER}', "");
Expect(0, 918000, '\p{^Word_Break=	OTHER}', "");
Expect(0, 918000, '\P{Word_Break=	OTHER}', "");
Expect(1, 918000, '\P{^Word_Break=	OTHER}', "");
Expect(0, 917999, '\p{Word_Break=	OTHER}', "");
Expect(1, 917999, '\p{^Word_Break=	OTHER}', "");
Expect(1, 917999, '\P{Word_Break=	OTHER}', "");
Expect(0, 917999, '\P{^Word_Break=	OTHER}', "");
Error('\p{WB=_-XX:=}');
Error('\P{WB=_-XX:=}');
Expect(1, 918000, '\p{WB=xx}', "");
Expect(0, 918000, '\p{^WB=xx}', "");
Expect(0, 918000, '\P{WB=xx}', "");
Expect(1, 918000, '\P{^WB=xx}', "");
Expect(0, 917999, '\p{WB=xx}', "");
Expect(1, 917999, '\p{^WB=xx}', "");
Expect(1, 917999, '\P{WB=xx}', "");
Expect(0, 917999, '\P{^WB=xx}', "");
Expect(1, 918000, '\p{WB=	_xx}', "");
Expect(0, 918000, '\p{^WB=	_xx}', "");
Expect(0, 918000, '\P{WB=	_xx}', "");
Expect(1, 918000, '\P{^WB=	_xx}', "");
Expect(0, 917999, '\p{WB=	_xx}', "");
Expect(1, 917999, '\p{^WB=	_xx}', "");
Expect(1, 917999, '\P{WB=	_xx}', "");
Expect(0, 917999, '\P{^WB=	_xx}', "");
Error('\p{Is_Word_Break=:=_-Other}');
Error('\P{Is_Word_Break=:=_-Other}');
Expect(1, 918000, '\p{Is_Word_Break=other}', "");
Expect(0, 918000, '\p{^Is_Word_Break=other}', "");
Expect(0, 918000, '\P{Is_Word_Break=other}', "");
Expect(1, 918000, '\P{^Is_Word_Break=other}', "");
Expect(0, 917999, '\p{Is_Word_Break=other}', "");
Expect(1, 917999, '\p{^Is_Word_Break=other}', "");
Expect(1, 917999, '\P{Is_Word_Break=other}', "");
Expect(0, 917999, '\P{^Is_Word_Break=other}', "");
Expect(1, 918000, '\p{Is_Word_Break=_other}', "");
Expect(0, 918000, '\p{^Is_Word_Break=_other}', "");
Expect(0, 918000, '\P{Is_Word_Break=_other}', "");
Expect(1, 918000, '\P{^Is_Word_Break=_other}', "");
Expect(0, 917999, '\p{Is_Word_Break=_other}', "");
Expect(1, 917999, '\p{^Is_Word_Break=_other}', "");
Expect(1, 917999, '\P{Is_Word_Break=_other}', "");
Expect(0, 917999, '\P{^Is_Word_Break=_other}', "");
Error('\p{Is_WB=:=XX}');
Error('\P{Is_WB=:=XX}');
Expect(1, 918000, '\p{Is_WB=xx}', "");
Expect(0, 918000, '\p{^Is_WB=xx}', "");
Expect(0, 918000, '\P{Is_WB=xx}', "");
Expect(1, 918000, '\P{^Is_WB=xx}', "");
Expect(0, 917999, '\p{Is_WB=xx}', "");
Expect(1, 917999, '\p{^Is_WB=xx}', "");
Expect(1, 917999, '\P{Is_WB=xx}', "");
Expect(0, 917999, '\P{^Is_WB=xx}', "");
Expect(1, 918000, '\p{Is_WB:	 -XX}', "");
Expect(0, 918000, '\p{^Is_WB:	 -XX}', "");
Expect(0, 918000, '\P{Is_WB:	 -XX}', "");
Expect(1, 918000, '\P{^Is_WB:	 -XX}', "");
Expect(0, 917999, '\p{Is_WB:	 -XX}', "");
Expect(1, 917999, '\p{^Is_WB:	 -XX}', "");
Expect(1, 917999, '\P{Is_WB:	 -XX}', "");
Expect(0, 917999, '\P{^Is_WB:	 -XX}', "");
Error('\p{White_Space=-/a/No}');
Error('\P{White_Space=-/a/No}');
Expect(1, 12289, '\p{White_Space=no}', "");
Expect(0, 12289, '\p{^White_Space=no}', "");
Expect(0, 12289, '\P{White_Space=no}', "");
Expect(1, 12289, '\P{^White_Space=no}', "");
Expect(0, 12288, '\p{White_Space=no}', "");
Expect(1, 12288, '\p{^White_Space=no}', "");
Expect(1, 12288, '\P{White_Space=no}', "");
Expect(0, 12288, '\P{^White_Space=no}', "");
Expect(1, 12289, '\p{White_Space=-NO}', "");
Expect(0, 12289, '\p{^White_Space=-NO}', "");
Expect(0, 12289, '\P{White_Space=-NO}', "");
Expect(1, 12289, '\P{^White_Space=-NO}', "");
Expect(0, 12288, '\p{White_Space=-NO}', "");
Expect(1, 12288, '\p{^White_Space=-NO}', "");
Expect(1, 12288, '\P{White_Space=-NO}', "");
Expect(0, 12288, '\P{^White_Space=-NO}', "");
Error('\p{WSpace=_/a/n}');
Error('\P{WSpace=_/a/n}');
Expect(1, 12289, '\p{WSpace=n}', "");
Expect(0, 12289, '\p{^WSpace=n}', "");
Expect(0, 12289, '\P{WSpace=n}', "");
Expect(1, 12289, '\P{^WSpace=n}', "");
Expect(0, 12288, '\p{WSpace=n}', "");
Expect(1, 12288, '\p{^WSpace=n}', "");
Expect(1, 12288, '\P{WSpace=n}', "");
Expect(0, 12288, '\P{^WSpace=n}', "");
Expect(1, 12289, '\p{WSpace:   -	N}', "");
Expect(0, 12289, '\p{^WSpace:   -	N}', "");
Expect(0, 12289, '\P{WSpace:   -	N}', "");
Expect(1, 12289, '\P{^WSpace:   -	N}', "");
Expect(0, 12288, '\p{WSpace:   -	N}', "");
Expect(1, 12288, '\p{^WSpace:   -	N}', "");
Expect(1, 12288, '\P{WSpace:   -	N}', "");
Expect(0, 12288, '\P{^WSpace:   -	N}', "");
Error('\p{Space=/a/_ f}');
Error('\P{Space=/a/_ f}');
Expect(1, 12289, '\p{Space: f}', "");
Expect(0, 12289, '\p{^Space: f}', "");
Expect(0, 12289, '\P{Space: f}', "");
Expect(1, 12289, '\P{^Space: f}', "");
Expect(0, 12288, '\p{Space: f}', "");
Expect(1, 12288, '\p{^Space: f}', "");
Expect(1, 12288, '\P{Space: f}', "");
Expect(0, 12288, '\P{^Space: f}', "");
Expect(1, 12289, '\p{Space=	F}', "");
Expect(0, 12289, '\p{^Space=	F}', "");
Expect(0, 12289, '\P{Space=	F}', "");
Expect(1, 12289, '\P{^Space=	F}', "");
Expect(0, 12288, '\p{Space=	F}', "");
Expect(1, 12288, '\p{^Space=	F}', "");
Expect(1, 12288, '\P{Space=	F}', "");
Expect(0, 12288, '\P{^Space=	F}', "");
Error('\p{Is_White_Space=-:=false}');
Error('\P{Is_White_Space=-:=false}');
Expect(1, 12289, '\p{Is_White_Space:false}', "");
Expect(0, 12289, '\p{^Is_White_Space:false}', "");
Expect(0, 12289, '\P{Is_White_Space:false}', "");
Expect(1, 12289, '\P{^Is_White_Space:false}', "");
Expect(0, 12288, '\p{Is_White_Space:false}', "");
Expect(1, 12288, '\p{^Is_White_Space:false}', "");
Expect(1, 12288, '\P{Is_White_Space:false}', "");
Expect(0, 12288, '\P{^Is_White_Space:false}', "");
Expect(1, 12289, '\p{Is_White_Space=	_False}', "");
Expect(0, 12289, '\p{^Is_White_Space=	_False}', "");
Expect(0, 12289, '\P{Is_White_Space=	_False}', "");
Expect(1, 12289, '\P{^Is_White_Space=	_False}', "");
Expect(0, 12288, '\p{Is_White_Space=	_False}', "");
Expect(1, 12288, '\p{^Is_White_Space=	_False}', "");
Expect(1, 12288, '\P{Is_White_Space=	_False}', "");
Expect(0, 12288, '\P{^Is_White_Space=	_False}', "");
Error('\p{Is_WSpace=	no:=}');
Error('\P{Is_WSpace=	no:=}');
Expect(1, 12289, '\p{Is_WSpace=no}', "");
Expect(0, 12289, '\p{^Is_WSpace=no}', "");
Expect(0, 12289, '\P{Is_WSpace=no}', "");
Expect(1, 12289, '\P{^Is_WSpace=no}', "");
Expect(0, 12288, '\p{Is_WSpace=no}', "");
Expect(1, 12288, '\p{^Is_WSpace=no}', "");
Expect(1, 12288, '\P{Is_WSpace=no}', "");
Expect(0, 12288, '\P{^Is_WSpace=no}', "");
Expect(1, 12289, '\p{Is_WSpace=	-NO}', "");
Expect(0, 12289, '\p{^Is_WSpace=	-NO}', "");
Expect(0, 12289, '\P{Is_WSpace=	-NO}', "");
Expect(1, 12289, '\P{^Is_WSpace=	-NO}', "");
Expect(0, 12288, '\p{Is_WSpace=	-NO}', "");
Expect(1, 12288, '\p{^Is_WSpace=	-NO}', "");
Expect(1, 12288, '\P{Is_WSpace=	-NO}', "");
Expect(0, 12288, '\P{^Is_WSpace=	-NO}', "");
Error('\p{Is_Space=:=N}');
Error('\P{Is_Space=:=N}');
Expect(1, 12289, '\p{Is_Space=n}', "");
Expect(0, 12289, '\p{^Is_Space=n}', "");
Expect(0, 12289, '\P{Is_Space=n}', "");
Expect(1, 12289, '\P{^Is_Space=n}', "");
Expect(0, 12288, '\p{Is_Space=n}', "");
Expect(1, 12288, '\p{^Is_Space=n}', "");
Expect(1, 12288, '\P{Is_Space=n}', "");
Expect(0, 12288, '\P{^Is_Space=n}', "");
Expect(1, 12289, '\p{Is_Space=	 N}', "");
Expect(0, 12289, '\p{^Is_Space=	 N}', "");
Expect(0, 12289, '\P{Is_Space=	 N}', "");
Expect(1, 12289, '\P{^Is_Space=	 N}', "");
Expect(0, 12288, '\p{Is_Space=	 N}', "");
Expect(1, 12288, '\p{^Is_Space=	 N}', "");
Expect(1, 12288, '\P{Is_Space=	 N}', "");
Expect(0, 12288, '\P{^Is_Space=	 N}', "");
Error('\p{White_Space=	yes/a/}');
Error('\P{White_Space=	yes/a/}');
Expect(1, 12288, '\p{White_Space=yes}', "");
Expect(0, 12288, '\p{^White_Space=yes}', "");
Expect(0, 12288, '\P{White_Space=yes}', "");
Expect(1, 12288, '\P{^White_Space=yes}', "");
Expect(0, 12289, '\p{White_Space=yes}', "");
Expect(1, 12289, '\p{^White_Space=yes}', "");
Expect(1, 12289, '\P{White_Space=yes}', "");
Expect(0, 12289, '\P{^White_Space=yes}', "");
Expect(1, 12288, '\p{White_Space=-Yes}', "");
Expect(0, 12288, '\p{^White_Space=-Yes}', "");
Expect(0, 12288, '\P{White_Space=-Yes}', "");
Expect(1, 12288, '\P{^White_Space=-Yes}', "");
Expect(0, 12289, '\p{White_Space=-Yes}', "");
Expect(1, 12289, '\p{^White_Space=-Yes}', "");
Expect(1, 12289, '\P{White_Space=-Yes}', "");
Expect(0, 12289, '\P{^White_Space=-Yes}', "");
Error('\p{WSpace=/a/_Y}');
Error('\P{WSpace=/a/_Y}');
Expect(1, 12288, '\p{WSpace=y}', "");
Expect(0, 12288, '\p{^WSpace=y}', "");
Expect(0, 12288, '\P{WSpace=y}', "");
Expect(1, 12288, '\P{^WSpace=y}', "");
Expect(0, 12289, '\p{WSpace=y}', "");
Expect(1, 12289, '\p{^WSpace=y}', "");
Expect(1, 12289, '\P{WSpace=y}', "");
Expect(0, 12289, '\P{^WSpace=y}', "");
Expect(1, 12288, '\p{WSpace=__Y}', "");
Expect(0, 12288, '\p{^WSpace=__Y}', "");
Expect(0, 12288, '\P{WSpace=__Y}', "");
Expect(1, 12288, '\P{^WSpace=__Y}', "");
Expect(0, 12289, '\p{WSpace=__Y}', "");
Expect(1, 12289, '\p{^WSpace=__Y}', "");
Expect(1, 12289, '\P{WSpace=__Y}', "");
Expect(0, 12289, '\P{^WSpace=__Y}', "");
Error('\p{Space= T:=}');
Error('\P{Space= T:=}');
Expect(1, 12288, '\p{Space:t}', "");
Expect(0, 12288, '\p{^Space:t}', "");
Expect(0, 12288, '\P{Space:t}', "");
Expect(1, 12288, '\P{^Space:t}', "");
Expect(0, 12289, '\p{Space:t}', "");
Expect(1, 12289, '\p{^Space:t}', "");
Expect(1, 12289, '\P{Space:t}', "");
Expect(0, 12289, '\P{^Space:t}', "");
Expect(1, 12288, '\p{Space=	T}', "");
Expect(0, 12288, '\p{^Space=	T}', "");
Expect(0, 12288, '\P{Space=	T}', "");
Expect(1, 12288, '\P{^Space=	T}', "");
Expect(0, 12289, '\p{Space=	T}', "");
Expect(1, 12289, '\p{^Space=	T}', "");
Expect(1, 12289, '\P{Space=	T}', "");
Expect(0, 12289, '\P{^Space=	T}', "");
Error('\p{Is_White_Space=:=	-true}');
Error('\P{Is_White_Space=:=	-true}');
Expect(1, 12288, '\p{Is_White_Space=true}', "");
Expect(0, 12288, '\p{^Is_White_Space=true}', "");
Expect(0, 12288, '\P{Is_White_Space=true}', "");
Expect(1, 12288, '\P{^Is_White_Space=true}', "");
Expect(0, 12289, '\p{Is_White_Space=true}', "");
Expect(1, 12289, '\p{^Is_White_Space=true}', "");
Expect(1, 12289, '\P{Is_White_Space=true}', "");
Expect(0, 12289, '\P{^Is_White_Space=true}', "");
Expect(1, 12288, '\p{Is_White_Space=	-True}', "");
Expect(0, 12288, '\p{^Is_White_Space=	-True}', "");
Expect(0, 12288, '\P{Is_White_Space=	-True}', "");
Expect(1, 12288, '\P{^Is_White_Space=	-True}', "");
Expect(0, 12289, '\p{Is_White_Space=	-True}', "");
Expect(1, 12289, '\p{^Is_White_Space=	-True}', "");
Expect(1, 12289, '\P{Is_White_Space=	-True}', "");
Expect(0, 12289, '\P{^Is_White_Space=	-True}', "");
Error('\p{Is_WSpace=--YES:=}');
Error('\P{Is_WSpace=--YES:=}');
Expect(1, 12288, '\p{Is_WSpace=yes}', "");
Expect(0, 12288, '\p{^Is_WSpace=yes}', "");
Expect(0, 12288, '\P{Is_WSpace=yes}', "");
Expect(1, 12288, '\P{^Is_WSpace=yes}', "");
Expect(0, 12289, '\p{Is_WSpace=yes}', "");
Expect(1, 12289, '\p{^Is_WSpace=yes}', "");
Expect(1, 12289, '\P{Is_WSpace=yes}', "");
Expect(0, 12289, '\P{^Is_WSpace=yes}', "");
Expect(1, 12288, '\p{Is_WSpace= yes}', "");
Expect(0, 12288, '\p{^Is_WSpace= yes}', "");
Expect(0, 12288, '\P{Is_WSpace= yes}', "");
Expect(1, 12288, '\P{^Is_WSpace= yes}', "");
Expect(0, 12289, '\p{Is_WSpace= yes}', "");
Expect(1, 12289, '\p{^Is_WSpace= yes}', "");
Expect(1, 12289, '\P{Is_WSpace= yes}', "");
Expect(0, 12289, '\P{^Is_WSpace= yes}', "");
Error('\p{Is_Space=:=	-Y}');
Error('\P{Is_Space=:=	-Y}');
Expect(1, 12288, '\p{Is_Space=y}', "");
Expect(0, 12288, '\p{^Is_Space=y}', "");
Expect(0, 12288, '\P{Is_Space=y}', "");
Expect(1, 12288, '\P{^Is_Space=y}', "");
Expect(0, 12289, '\p{Is_Space=y}', "");
Expect(1, 12289, '\p{^Is_Space=y}', "");
Expect(1, 12289, '\P{Is_Space=y}', "");
Expect(0, 12289, '\P{^Is_Space=y}', "");
Expect(1, 12288, '\p{Is_Space=--y}', "");
Expect(0, 12288, '\p{^Is_Space=--y}', "");
Expect(0, 12288, '\P{Is_Space=--y}', "");
Expect(1, 12288, '\P{^Is_Space=--y}', "");
Expect(0, 12289, '\p{Is_Space=--y}', "");
Expect(1, 12289, '\p{^Is_Space=--y}', "");
Expect(1, 12289, '\P{Is_Space=--y}', "");
Expect(0, 12289, '\P{^Is_Space=--y}', "");
Error('\p{XID_Continue= _No/a/}');
Error('\P{XID_Continue= _No/a/}');
Expect(1, 918000, '\p{XID_Continue=no}', "");
Expect(0, 918000, '\p{^XID_Continue=no}', "");
Expect(0, 918000, '\P{XID_Continue=no}', "");
Expect(1, 918000, '\P{^XID_Continue=no}', "");
Expect(0, 917999, '\p{XID_Continue=no}', "");
Expect(1, 917999, '\p{^XID_Continue=no}', "");
Expect(1, 917999, '\P{XID_Continue=no}', "");
Expect(0, 917999, '\P{^XID_Continue=no}', "");
Expect(1, 918000, '\p{XID_Continue:		NO}', "");
Expect(0, 918000, '\p{^XID_Continue:		NO}', "");
Expect(0, 918000, '\P{XID_Continue:		NO}', "");
Expect(1, 918000, '\P{^XID_Continue:		NO}', "");
Expect(0, 917999, '\p{XID_Continue:		NO}', "");
Expect(1, 917999, '\p{^XID_Continue:		NO}', "");
Expect(1, 917999, '\P{XID_Continue:		NO}', "");
Expect(0, 917999, '\P{^XID_Continue:		NO}', "");
Error('\p{XIDC=/a/_N}');
Error('\P{XIDC=/a/_N}');
Expect(1, 918000, '\p{XIDC=n}', "");
Expect(0, 918000, '\p{^XIDC=n}', "");
Expect(0, 918000, '\P{XIDC=n}', "");
Expect(1, 918000, '\P{^XIDC=n}', "");
Expect(0, 917999, '\p{XIDC=n}', "");
Expect(1, 917999, '\p{^XIDC=n}', "");
Expect(1, 917999, '\P{XIDC=n}', "");
Expect(0, 917999, '\P{^XIDC=n}', "");
Expect(1, 918000, '\p{XIDC=	N}', "");
Expect(0, 918000, '\p{^XIDC=	N}', "");
Expect(0, 918000, '\P{XIDC=	N}', "");
Expect(1, 918000, '\P{^XIDC=	N}', "");
Expect(0, 917999, '\p{XIDC=	N}', "");
Expect(1, 917999, '\p{^XIDC=	N}', "");
Expect(1, 917999, '\P{XIDC=	N}', "");
Expect(0, 917999, '\P{^XIDC=	N}', "");
Error('\p{Is_XID_Continue=--F:=}');
Error('\P{Is_XID_Continue=--F:=}');
Expect(1, 918000, '\p{Is_XID_Continue=f}', "");
Expect(0, 918000, '\p{^Is_XID_Continue=f}', "");
Expect(0, 918000, '\P{Is_XID_Continue=f}', "");
Expect(1, 918000, '\P{^Is_XID_Continue=f}', "");
Expect(0, 917999, '\p{Is_XID_Continue=f}', "");
Expect(1, 917999, '\p{^Is_XID_Continue=f}', "");
Expect(1, 917999, '\P{Is_XID_Continue=f}', "");
Expect(0, 917999, '\P{^Is_XID_Continue=f}', "");
Expect(1, 918000, '\p{Is_XID_Continue= _F}', "");
Expect(0, 918000, '\p{^Is_XID_Continue= _F}', "");
Expect(0, 918000, '\P{Is_XID_Continue= _F}', "");
Expect(1, 918000, '\P{^Is_XID_Continue= _F}', "");
Expect(0, 917999, '\p{Is_XID_Continue= _F}', "");
Expect(1, 917999, '\p{^Is_XID_Continue= _F}', "");
Expect(1, 917999, '\P{Is_XID_Continue= _F}', "");
Expect(0, 917999, '\P{^Is_XID_Continue= _F}', "");
Error('\p{Is_XIDC:False:=}');
Error('\P{Is_XIDC:False:=}');
Expect(1, 918000, '\p{Is_XIDC:	false}', "");
Expect(0, 918000, '\p{^Is_XIDC:	false}', "");
Expect(0, 918000, '\P{Is_XIDC:	false}', "");
Expect(1, 918000, '\P{^Is_XIDC:	false}', "");
Expect(0, 917999, '\p{Is_XIDC:	false}', "");
Expect(1, 917999, '\p{^Is_XIDC:	false}', "");
Expect(1, 917999, '\P{Is_XIDC:	false}', "");
Expect(0, 917999, '\P{^Is_XIDC:	false}', "");
Expect(1, 918000, '\p{Is_XIDC=-False}', "");
Expect(0, 918000, '\p{^Is_XIDC=-False}', "");
Expect(0, 918000, '\P{Is_XIDC=-False}', "");
Expect(1, 918000, '\P{^Is_XIDC=-False}', "");
Expect(0, 917999, '\p{Is_XIDC=-False}', "");
Expect(1, 917999, '\p{^Is_XIDC=-False}', "");
Expect(1, 917999, '\P{Is_XIDC=-False}', "");
Expect(0, 917999, '\P{^Is_XIDC=-False}', "");
Error('\p{XID_Continue=-	Yes/a/}');
Error('\P{XID_Continue=-	Yes/a/}');
Expect(1, 917999, '\p{XID_Continue: yes}', "");
Expect(0, 917999, '\p{^XID_Continue: yes}', "");
Expect(0, 917999, '\P{XID_Continue: yes}', "");
Expect(1, 917999, '\P{^XID_Continue: yes}', "");
Expect(0, 918000, '\p{XID_Continue: yes}', "");
Expect(1, 918000, '\p{^XID_Continue: yes}', "");
Expect(1, 918000, '\P{XID_Continue: yes}', "");
Expect(0, 918000, '\P{^XID_Continue: yes}', "");
Expect(1, 917999, '\p{XID_Continue= Yes}', "");
Expect(0, 917999, '\p{^XID_Continue= Yes}', "");
Expect(0, 917999, '\P{XID_Continue= Yes}', "");
Expect(1, 917999, '\P{^XID_Continue= Yes}', "");
Expect(0, 918000, '\p{XID_Continue= Yes}', "");
Expect(1, 918000, '\p{^XID_Continue= Yes}', "");
Expect(1, 918000, '\P{XID_Continue= Yes}', "");
Expect(0, 918000, '\P{^XID_Continue= Yes}', "");
Error('\p{XIDC=  Y:=}');
Error('\P{XIDC=  Y:=}');
Expect(1, 917999, '\p{XIDC=y}', "");
Expect(0, 917999, '\p{^XIDC=y}', "");
Expect(0, 917999, '\P{XIDC=y}', "");
Expect(1, 917999, '\P{^XIDC=y}', "");
Expect(0, 918000, '\p{XIDC=y}', "");
Expect(1, 918000, '\p{^XIDC=y}', "");
Expect(1, 918000, '\P{XIDC=y}', "");
Expect(0, 918000, '\P{^XIDC=y}', "");
Expect(1, 917999, '\p{XIDC=  Y}', "");
Expect(0, 917999, '\p{^XIDC=  Y}', "");
Expect(0, 917999, '\P{XIDC=  Y}', "");
Expect(1, 917999, '\P{^XIDC=  Y}', "");
Expect(0, 918000, '\p{XIDC=  Y}', "");
Expect(1, 918000, '\p{^XIDC=  Y}', "");
Expect(1, 918000, '\P{XIDC=  Y}', "");
Expect(0, 918000, '\P{^XIDC=  Y}', "");
Error('\p{Is_XID_Continue= -T/a/}');
Error('\P{Is_XID_Continue= -T/a/}');
Expect(1, 917999, '\p{Is_XID_Continue=t}', "");
Expect(0, 917999, '\p{^Is_XID_Continue=t}', "");
Expect(0, 917999, '\P{Is_XID_Continue=t}', "");
Expect(1, 917999, '\P{^Is_XID_Continue=t}', "");
Expect(0, 918000, '\p{Is_XID_Continue=t}', "");
Expect(1, 918000, '\p{^Is_XID_Continue=t}', "");
Expect(1, 918000, '\P{Is_XID_Continue=t}', "");
Expect(0, 918000, '\P{^Is_XID_Continue=t}', "");
Expect(1, 917999, '\p{Is_XID_Continue=	_t}', "");
Expect(0, 917999, '\p{^Is_XID_Continue=	_t}', "");
Expect(0, 917999, '\P{Is_XID_Continue=	_t}', "");
Expect(1, 917999, '\P{^Is_XID_Continue=	_t}', "");
Expect(0, 918000, '\p{Is_XID_Continue=	_t}', "");
Expect(1, 918000, '\p{^Is_XID_Continue=	_t}', "");
Expect(1, 918000, '\P{Is_XID_Continue=	_t}', "");
Expect(0, 918000, '\P{^Is_XID_Continue=	_t}', "");
Error('\p{Is_XIDC=:=_ True}');
Error('\P{Is_XIDC=:=_ True}');
Expect(1, 917999, '\p{Is_XIDC=true}', "");
Expect(0, 917999, '\p{^Is_XIDC=true}', "");
Expect(0, 917999, '\P{Is_XIDC=true}', "");
Expect(1, 917999, '\P{^Is_XIDC=true}', "");
Expect(0, 918000, '\p{Is_XIDC=true}', "");
Expect(1, 918000, '\p{^Is_XIDC=true}', "");
Expect(1, 918000, '\P{Is_XIDC=true}', "");
Expect(0, 918000, '\P{^Is_XIDC=true}', "");
Expect(1, 917999, '\p{Is_XIDC=_TRUE}', "");
Expect(0, 917999, '\p{^Is_XIDC=_TRUE}', "");
Expect(0, 917999, '\P{Is_XIDC=_TRUE}', "");
Expect(1, 917999, '\P{^Is_XIDC=_TRUE}', "");
Expect(0, 918000, '\p{Is_XIDC=_TRUE}', "");
Expect(1, 918000, '\p{^Is_XIDC=_TRUE}', "");
Expect(1, 918000, '\P{Is_XIDC=_TRUE}', "");
Expect(0, 918000, '\P{^Is_XIDC=_TRUE}', "");
Error('\p{XID_Start=/a/	 NO}');
Error('\P{XID_Start=/a/	 NO}');
Expect(1, 195102, '\p{XID_Start=no}', "");
Expect(0, 195102, '\p{^XID_Start=no}', "");
Expect(0, 195102, '\P{XID_Start=no}', "");
Expect(1, 195102, '\P{^XID_Start=no}', "");
Expect(0, 195101, '\p{XID_Start=no}', "");
Expect(1, 195101, '\p{^XID_Start=no}', "");
Expect(1, 195101, '\P{XID_Start=no}', "");
Expect(0, 195101, '\P{^XID_Start=no}', "");
Expect(1, 195102, '\p{XID_Start=_-No}', "");
Expect(0, 195102, '\p{^XID_Start=_-No}', "");
Expect(0, 195102, '\P{XID_Start=_-No}', "");
Expect(1, 195102, '\P{^XID_Start=_-No}', "");
Expect(0, 195101, '\p{XID_Start=_-No}', "");
Expect(1, 195101, '\p{^XID_Start=_-No}', "");
Expect(1, 195101, '\P{XID_Start=_-No}', "");
Expect(0, 195101, '\P{^XID_Start=_-No}', "");
Error('\p{XIDS=_/a/N}');
Error('\P{XIDS=_/a/N}');
Expect(1, 195102, '\p{XIDS=n}', "");
Expect(0, 195102, '\p{^XIDS=n}', "");
Expect(0, 195102, '\P{XIDS=n}', "");
Expect(1, 195102, '\P{^XIDS=n}', "");
Expect(0, 195101, '\p{XIDS=n}', "");
Expect(1, 195101, '\p{^XIDS=n}', "");
Expect(1, 195101, '\P{XIDS=n}', "");
Expect(0, 195101, '\P{^XIDS=n}', "");
Expect(1, 195102, '\p{XIDS=	N}', "");
Expect(0, 195102, '\p{^XIDS=	N}', "");
Expect(0, 195102, '\P{XIDS=	N}', "");
Expect(1, 195102, '\P{^XIDS=	N}', "");
Expect(0, 195101, '\p{XIDS=	N}', "");
Expect(1, 195101, '\p{^XIDS=	N}', "");
Expect(1, 195101, '\P{XIDS=	N}', "");
Expect(0, 195101, '\P{^XIDS=	N}', "");
Error('\p{Is_XID_Start=--F:=}');
Error('\P{Is_XID_Start=--F:=}');
Expect(1, 195102, '\p{Is_XID_Start=f}', "");
Expect(0, 195102, '\p{^Is_XID_Start=f}', "");
Expect(0, 195102, '\P{Is_XID_Start=f}', "");
Expect(1, 195102, '\P{^Is_XID_Start=f}', "");
Expect(0, 195101, '\p{Is_XID_Start=f}', "");
Expect(1, 195101, '\p{^Is_XID_Start=f}', "");
Expect(1, 195101, '\P{Is_XID_Start=f}', "");
Expect(0, 195101, '\P{^Is_XID_Start=f}', "");
Expect(1, 195102, '\p{Is_XID_Start=__F}', "");
Expect(0, 195102, '\p{^Is_XID_Start=__F}', "");
Expect(0, 195102, '\P{Is_XID_Start=__F}', "");
Expect(1, 195102, '\P{^Is_XID_Start=__F}', "");
Expect(0, 195101, '\p{Is_XID_Start=__F}', "");
Expect(1, 195101, '\p{^Is_XID_Start=__F}', "");
Expect(1, 195101, '\P{Is_XID_Start=__F}', "");
Expect(0, 195101, '\P{^Is_XID_Start=__F}', "");
Error('\p{Is_XIDS= /a/false}');
Error('\P{Is_XIDS= /a/false}');
Expect(1, 195102, '\p{Is_XIDS=false}', "");
Expect(0, 195102, '\p{^Is_XIDS=false}', "");
Expect(0, 195102, '\P{Is_XIDS=false}', "");
Expect(1, 195102, '\P{^Is_XIDS=false}', "");
Expect(0, 195101, '\p{Is_XIDS=false}', "");
Expect(1, 195101, '\p{^Is_XIDS=false}', "");
Expect(1, 195101, '\P{Is_XIDS=false}', "");
Expect(0, 195101, '\P{^Is_XIDS=false}', "");
Expect(1, 195102, '\p{Is_XIDS=--FALSE}', "");
Expect(0, 195102, '\p{^Is_XIDS=--FALSE}', "");
Expect(0, 195102, '\P{Is_XIDS=--FALSE}', "");
Expect(1, 195102, '\P{^Is_XIDS=--FALSE}', "");
Expect(0, 195101, '\p{Is_XIDS=--FALSE}', "");
Expect(1, 195101, '\p{^Is_XIDS=--FALSE}', "");
Expect(1, 195101, '\P{Is_XIDS=--FALSE}', "");
Expect(0, 195101, '\P{^Is_XIDS=--FALSE}', "");
Error('\p{XID_Start=/a/_	Yes}');
Error('\P{XID_Start=/a/_	Yes}');
Expect(1, 195101, '\p{XID_Start=yes}', "");
Expect(0, 195101, '\p{^XID_Start=yes}', "");
Expect(0, 195101, '\P{XID_Start=yes}', "");
Expect(1, 195101, '\P{^XID_Start=yes}', "");
Expect(0, 195102, '\p{XID_Start=yes}', "");
Expect(1, 195102, '\p{^XID_Start=yes}', "");
Expect(1, 195102, '\P{XID_Start=yes}', "");
Expect(0, 195102, '\P{^XID_Start=yes}', "");
Expect(1, 195101, '\p{XID_Start=-	yes}', "");
Expect(0, 195101, '\p{^XID_Start=-	yes}', "");
Expect(0, 195101, '\P{XID_Start=-	yes}', "");
Expect(1, 195101, '\P{^XID_Start=-	yes}', "");
Expect(0, 195102, '\p{XID_Start=-	yes}', "");
Expect(1, 195102, '\p{^XID_Start=-	yes}', "");
Expect(1, 195102, '\P{XID_Start=-	yes}', "");
Expect(0, 195102, '\P{^XID_Start=-	yes}', "");
Error('\p{XIDS= /a/Y}');
Error('\P{XIDS= /a/Y}');
Expect(1, 195101, '\p{XIDS:   y}', "");
Expect(0, 195101, '\p{^XIDS:   y}', "");
Expect(0, 195101, '\P{XIDS:   y}', "");
Expect(1, 195101, '\P{^XIDS:   y}', "");
Expect(0, 195102, '\p{XIDS:   y}', "");
Expect(1, 195102, '\p{^XIDS:   y}', "");
Expect(1, 195102, '\P{XIDS:   y}', "");
Expect(0, 195102, '\P{^XIDS:   y}', "");
Expect(1, 195101, '\p{XIDS=_-Y}', "");
Expect(0, 195101, '\p{^XIDS=_-Y}', "");
Expect(0, 195101, '\P{XIDS=_-Y}', "");
Expect(1, 195101, '\P{^XIDS=_-Y}', "");
Expect(0, 195102, '\p{XIDS=_-Y}', "");
Expect(1, 195102, '\p{^XIDS=_-Y}', "");
Expect(1, 195102, '\P{XIDS=_-Y}', "");
Expect(0, 195102, '\P{^XIDS=_-Y}', "");
Error('\p{Is_XID_Start= T:=}');
Error('\P{Is_XID_Start= T:=}');
Expect(1, 195101, '\p{Is_XID_Start=t}', "");
Expect(0, 195101, '\p{^Is_XID_Start=t}', "");
Expect(0, 195101, '\P{Is_XID_Start=t}', "");
Expect(1, 195101, '\P{^Is_XID_Start=t}', "");
Expect(0, 195102, '\p{Is_XID_Start=t}', "");
Expect(1, 195102, '\p{^Is_XID_Start=t}', "");
Expect(1, 195102, '\P{Is_XID_Start=t}', "");
Expect(0, 195102, '\P{^Is_XID_Start=t}', "");
Expect(1, 195101, '\p{Is_XID_Start=-_t}', "");
Expect(0, 195101, '\p{^Is_XID_Start=-_t}', "");
Expect(0, 195101, '\P{Is_XID_Start=-_t}', "");
Expect(1, 195101, '\P{^Is_XID_Start=-_t}', "");
Expect(0, 195102, '\p{Is_XID_Start=-_t}', "");
Expect(1, 195102, '\p{^Is_XID_Start=-_t}', "");
Expect(1, 195102, '\P{Is_XID_Start=-_t}', "");
Expect(0, 195102, '\P{^Is_XID_Start=-_t}', "");
Error('\p{Is_XIDS=/a/		TRUE}');
Error('\P{Is_XIDS=/a/		TRUE}');
Expect(1, 195101, '\p{Is_XIDS=true}', "");
Expect(0, 195101, '\p{^Is_XIDS=true}', "");
Expect(0, 195101, '\P{Is_XIDS=true}', "");
Expect(1, 195101, '\P{^Is_XIDS=true}', "");
Expect(0, 195102, '\p{Is_XIDS=true}', "");
Expect(1, 195102, '\p{^Is_XIDS=true}', "");
Expect(1, 195102, '\P{Is_XIDS=true}', "");
Expect(0, 195102, '\P{^Is_XIDS=true}', "");
Expect(1, 195101, '\p{Is_XIDS=-True}', "");
Expect(0, 195101, '\p{^Is_XIDS=-True}', "");
Expect(0, 195101, '\P{Is_XIDS=-True}', "");
Expect(1, 195101, '\P{^Is_XIDS=-True}', "");
Expect(0, 195102, '\p{Is_XIDS=-True}', "");
Expect(1, 195102, '\p{^Is_XIDS=-True}', "");
Expect(1, 195102, '\P{Is_XIDS=-True}', "");
Expect(0, 195102, '\P{^Is_XIDS=-True}', "");
Error('\p{Expands_On_NFC=No}');
Error('\P{Expands_On_NFC=No}');
Error('\p{XO_NFC=N}');
Error('\P{XO_NFC=N}');
Error('\p{Is_Expands_On_NFC=F}');
Error('\P{Is_Expands_On_NFC=F}');
Error('\p{Is_XO_NFC=False}');
Error('\P{Is_XO_NFC=False}');
Error('\p{Expands_On_NFC=Yes}');
Error('\P{Expands_On_NFC=Yes}');
Error('\p{XO_NFC=Y}');
Error('\P{XO_NFC=Y}');
Error('\p{Is_Expands_On_NFC=T}');
Error('\P{Is_Expands_On_NFC=T}');
Error('\p{Is_XO_NFC=True}');
Error('\P{Is_XO_NFC=True}');
Error('\p{Expands_On_NFD=No}');
Error('\P{Expands_On_NFD=No}');
Error('\p{XO_NFD=N}');
Error('\P{XO_NFD=N}');
Error('\p{Is_Expands_On_NFD=F}');
Error('\P{Is_Expands_On_NFD=F}');
Error('\p{Is_XO_NFD:   False}');
Error('\P{Is_XO_NFD:   False}');
Error('\p{Expands_On_NFD=Yes}');
Error('\P{Expands_On_NFD=Yes}');
Error('\p{XO_NFD=Y}');
Error('\P{XO_NFD=Y}');
Error('\p{Is_Expands_On_NFD=T}');
Error('\P{Is_Expands_On_NFD=T}');
Error('\p{Is_XO_NFD=True}');
Error('\P{Is_XO_NFD=True}');
Error('\p{Expands_On_NFKC=No}');
Error('\P{Expands_On_NFKC=No}');
Error('\p{XO_NFKC=N}');
Error('\P{XO_NFKC=N}');
Error('\p{Is_Expands_On_NFKC: F}');
Error('\P{Is_Expands_On_NFKC: F}');
Error('\p{Is_XO_NFKC=False}');
Error('\P{Is_XO_NFKC=False}');
Error('\p{Expands_On_NFKC=Yes}');
Error('\P{Expands_On_NFKC=Yes}');
Error('\p{XO_NFKC=Y}');
Error('\P{XO_NFKC=Y}');
Error('\p{Is_Expands_On_NFKC:   T}');
Error('\P{Is_Expands_On_NFKC:   T}');
Error('\p{Is_XO_NFKC=True}');
Error('\P{Is_XO_NFKC=True}');
Error('\p{Expands_On_NFKD=No}');
Error('\P{Expands_On_NFKD=No}');
Error('\p{XO_NFKD: N}');
Error('\P{XO_NFKD: N}');
Error('\p{Is_Expands_On_NFKD=F}');
Error('\P{Is_Expands_On_NFKD=F}');
Error('\p{Is_XO_NFKD=False}');
Error('\P{Is_XO_NFKD=False}');
Error('\p{Expands_On_NFKD=Yes}');
Error('\P{Expands_On_NFKD=Yes}');
Error('\p{XO_NFKD=Y}');
Error('\P{XO_NFKD=Y}');
Error('\p{Is_Expands_On_NFKD=T}');
Error('\P{Is_Expands_On_NFKD=T}');
Error('\p{Is_XO_NFKD=True}');
Error('\P{Is_XO_NFKD=True}');
Error('\p{Age=:=		V1_1}');
Error('\P{Age=:=		V1_1}');
Expect(1, 65533, '\p{Age=v11}', "");
Expect(0, 65533, '\p{^Age=v11}', "");
Expect(0, 65533, '\P{Age=v11}', "");
Expect(1, 65533, '\P{^Age=v11}', "");
Expect(0, 65536, '\p{Age=v11}', "");
Expect(1, 65536, '\p{^Age=v11}', "");
Expect(1, 65536, '\P{Age=v11}', "");
Expect(0, 65536, '\P{^Age=v11}', "");
Expect(1, 65533, '\p{Age=		V1_1}', "");
Expect(0, 65533, '\p{^Age=		V1_1}', "");
Expect(0, 65533, '\P{Age=		V1_1}', "");
Expect(1, 65533, '\P{^Age=		V1_1}', "");
Expect(0, 65536, '\p{Age=		V1_1}', "");
Expect(1, 65536, '\p{^Age=		V1_1}', "");
Expect(1, 65536, '\P{Age=		V1_1}', "");
Expect(0, 65536, '\P{^Age=		V1_1}', "");
Error('\p{Is_Age=/a/  0000001.1}');
Error('\P{Is_Age=/a/  0000001.1}');
Expect(1, 65533, '\p{Is_Age=00001.1}', "");
Expect(0, 65533, '\p{^Is_Age=00001.1}', "");
Expect(0, 65533, '\P{Is_Age=00001.1}', "");
Expect(1, 65533, '\P{^Is_Age=00001.1}', "");
Expect(0, 65536, '\p{Is_Age=00001.1}', "");
Expect(1, 65536, '\p{^Is_Age=00001.1}', "");
Expect(1, 65536, '\P{Is_Age=00001.1}', "");
Expect(0, 65536, '\P{^Is_Age=00001.1}', "");
Error('\p{Age=--V2_0:=}');
Error('\P{Age=--V2_0:=}');
Expect(1, 983040, '\p{Age=v20}', "");
Expect(0, 983040, '\p{^Age=v20}', "");
Expect(0, 983040, '\P{Age=v20}', "");
Expect(1, 983040, '\P{^Age=v20}', "");
Expect(0, 983037, '\p{Age=v20}', "");
Expect(1, 983037, '\p{^Age=v20}', "");
Expect(1, 983037, '\P{Age=v20}', "");
Expect(0, 983037, '\P{^Age=v20}', "");
Expect(1, 983040, '\p{Age=	V2_0}', "");
Expect(0, 983040, '\p{^Age=	V2_0}', "");
Expect(0, 983040, '\P{Age=	V2_0}', "");
Expect(1, 983040, '\P{^Age=	V2_0}', "");
Expect(0, 983037, '\p{Age=	V2_0}', "");
Expect(1, 983037, '\p{^Age=	V2_0}', "");
Expect(1, 983037, '\P{Age=	V2_0}', "");
Expect(0, 983037, '\P{^Age=	V2_0}', "");
Error('\p{Is_Age=/a/-0000002.0}');
Error('\P{Is_Age=/a/-0000002.0}');
Expect(1, 983040, '\p{Is_Age=2.0}', "");
Expect(0, 983040, '\p{^Is_Age=2.0}', "");
Expect(0, 983040, '\P{Is_Age=2.0}', "");
Expect(1, 983040, '\P{^Is_Age=2.0}', "");
Expect(0, 983037, '\p{Is_Age=2.0}', "");
Expect(1, 983037, '\p{^Is_Age=2.0}', "");
Expect(1, 983037, '\P{Is_Age=2.0}', "");
Expect(0, 983037, '\P{^Is_Age=2.0}', "");
Error('\p{Age:   :=_V2_1}');
Error('\P{Age:   :=_V2_1}');
Expect(1, 65532, '\p{Age: v21}', "");
Expect(0, 65532, '\p{^Age: v21}', "");
Expect(0, 65532, '\P{Age: v21}', "");
Expect(1, 65532, '\P{^Age: v21}', "");
Expect(0, 65533, '\p{Age: v21}', "");
Expect(1, 65533, '\p{^Age: v21}', "");
Expect(1, 65533, '\P{Age: v21}', "");
Expect(0, 65533, '\P{^Age: v21}', "");
Expect(1, 65532, '\p{Age=	_V2_1}', "");
Expect(0, 65532, '\p{^Age=	_V2_1}', "");
Expect(0, 65532, '\P{Age=	_V2_1}', "");
Expect(1, 65532, '\P{^Age=	_V2_1}', "");
Expect(0, 65533, '\p{Age=	_V2_1}', "");
Expect(1, 65533, '\p{^Age=	_V2_1}', "");
Expect(1, 65533, '\P{Age=	_V2_1}', "");
Expect(0, 65533, '\P{^Age=	_V2_1}', "");
Error('\p{Is_Age=_ 0002.1:=}');
Error('\P{Is_Age=_ 0002.1:=}');
Expect(1, 65532, '\p{Is_Age=2.1}', "");
Expect(0, 65532, '\p{^Is_Age=2.1}', "");
Expect(0, 65532, '\P{Is_Age=2.1}', "");
Expect(1, 65532, '\P{^Is_Age=2.1}', "");
Expect(0, 65533, '\p{Is_Age=2.1}', "");
Expect(1, 65533, '\p{^Is_Age=2.1}', "");
Expect(1, 65533, '\P{Is_Age=2.1}', "");
Expect(0, 65533, '\P{^Is_Age=2.1}', "");
Error('\p{Age=/a/ -v3_0}');
Error('\P{Age=/a/ -v3_0}');
Expect(1, 65531, '\p{Age=v30}', "");
Expect(0, 65531, '\p{^Age=v30}', "");
Expect(0, 65531, '\P{Age=v30}', "");
Expect(1, 65531, '\P{^Age=v30}', "");
Expect(0, 65532, '\p{Age=v30}', "");
Expect(1, 65532, '\p{^Age=v30}', "");
Expect(1, 65532, '\P{Age=v30}', "");
Expect(0, 65532, '\P{^Age=v30}', "");
Expect(1, 65531, '\p{Age:	V3_0}', "");
Expect(0, 65531, '\p{^Age:	V3_0}', "");
Expect(0, 65531, '\P{Age:	V3_0}', "");
Expect(1, 65531, '\P{^Age:	V3_0}', "");
Expect(0, 65532, '\p{Age:	V3_0}', "");
Expect(1, 65532, '\p{^Age:	V3_0}', "");
Expect(1, 65532, '\P{Age:	V3_0}', "");
Expect(0, 65532, '\P{^Age:	V3_0}', "");
Error('\p{Is_Age=/a/+003.0}');
Error('\P{Is_Age=/a/+003.0}');
Expect(1, 65531, '\p{Is_Age=00_00_00_00_03.0}', "");
Expect(0, 65531, '\p{^Is_Age=00_00_00_00_03.0}', "");
Expect(0, 65531, '\P{Is_Age=00_00_00_00_03.0}', "");
Expect(1, 65531, '\P{^Is_Age=00_00_00_00_03.0}', "");
Expect(0, 65532, '\p{Is_Age=00_00_00_00_03.0}', "");
Expect(1, 65532, '\p{^Is_Age=00_00_00_00_03.0}', "");
Expect(1, 65532, '\P{Is_Age=00_00_00_00_03.0}', "");
Expect(0, 65532, '\P{^Is_Age=00_00_00_00_03.0}', "");
Error('\p{Age=_:=V3_1}');
Error('\P{Age=_:=V3_1}');
Expect(1, 917631, '\p{Age=v31}', "");
Expect(0, 917631, '\p{^Age=v31}', "");
Expect(0, 917631, '\P{Age=v31}', "");
Expect(1, 917631, '\P{^Age=v31}', "");
Expect(0, 917632, '\p{Age=v31}', "");
Expect(1, 917632, '\p{^Age=v31}', "");
Expect(1, 917632, '\P{Age=v31}', "");
Expect(0, 917632, '\P{^Age=v31}', "");
Expect(1, 917631, '\p{Age=__V3_1}', "");
Expect(0, 917631, '\p{^Age=__V3_1}', "");
Expect(0, 917631, '\P{Age=__V3_1}', "");
Expect(1, 917631, '\P{^Age=__V3_1}', "");
Expect(0, 917632, '\p{Age=__V3_1}', "");
Expect(1, 917632, '\p{^Age=__V3_1}', "");
Expect(1, 917632, '\P{Age=__V3_1}', "");
Expect(0, 917632, '\P{^Age=__V3_1}', "");
Error('\p{Is_Age= :=+3.1}');
Error('\P{Is_Age= :=+3.1}');
Expect(1, 917631, '\p{Is_Age=00003.1}', "");
Expect(0, 917631, '\p{^Is_Age=00003.1}', "");
Expect(0, 917631, '\P{Is_Age=00003.1}', "");
Expect(1, 917631, '\P{^Is_Age=00003.1}', "");
Expect(0, 917632, '\p{Is_Age=00003.1}', "");
Expect(1, 917632, '\p{^Is_Age=00003.1}', "");
Expect(1, 917632, '\P{Is_Age=00003.1}', "");
Expect(0, 917632, '\P{^Is_Age=00003.1}', "");
Error('\p{Age=_-V3_2/a/}');
Error('\P{Age=_-V3_2/a/}');
Expect(1, 65376, '\p{Age=v32}', "");
Expect(0, 65376, '\p{^Age=v32}', "");
Expect(0, 65376, '\P{Age=v32}', "");
Expect(1, 65376, '\P{^Age=v32}', "");
Expect(0, 65377, '\p{Age=v32}', "");
Expect(1, 65377, '\p{^Age=v32}', "");
Expect(1, 65377, '\P{Age=v32}', "");
Expect(0, 65377, '\P{^Age=v32}', "");
Expect(1, 65376, '\p{Age= _V3_2}', "");
Expect(0, 65376, '\p{^Age= _V3_2}', "");
Expect(0, 65376, '\P{Age= _V3_2}', "");
Expect(1, 65376, '\P{^Age= _V3_2}', "");
Expect(0, 65377, '\p{Age= _V3_2}', "");
Expect(1, 65377, '\p{^Age= _V3_2}', "");
Expect(1, 65377, '\P{Age= _V3_2}', "");
Expect(0, 65377, '\P{^Age= _V3_2}', "");
Error('\p{Is_Age=:=_	000000003.2}');
Error('\P{Is_Age=:=_	000000003.2}');
Expect(1, 65376, '\p{Is_Age=0_0_0_0_03.2}', "");
Expect(0, 65376, '\p{^Is_Age=0_0_0_0_03.2}', "");
Expect(0, 65376, '\P{Is_Age=0_0_0_0_03.2}', "");
Expect(1, 65376, '\P{^Is_Age=0_0_0_0_03.2}', "");
Expect(0, 65377, '\p{Is_Age=0_0_0_0_03.2}', "");
Expect(1, 65377, '\p{^Is_Age=0_0_0_0_03.2}', "");
Expect(1, 65377, '\P{Is_Age=0_0_0_0_03.2}', "");
Expect(0, 65377, '\P{^Is_Age=0_0_0_0_03.2}', "");
Error('\p{Age:	/a/	_V4_0}');
Error('\P{Age:	/a/	_V4_0}');
Expect(1, 917999, '\p{Age=v40}', "");
Expect(0, 917999, '\p{^Age=v40}', "");
Expect(0, 917999, '\P{Age=v40}', "");
Expect(1, 917999, '\P{^Age=v40}', "");
Expect(0, 918000, '\p{Age=v40}', "");
Expect(1, 918000, '\p{^Age=v40}', "");
Expect(1, 918000, '\P{Age=v40}', "");
Expect(0, 918000, '\P{^Age=v40}', "");
Expect(1, 917999, '\p{Age: _V4_0}', "");
Expect(0, 917999, '\p{^Age: _V4_0}', "");
Expect(0, 917999, '\P{Age: _V4_0}', "");
Expect(1, 917999, '\P{^Age: _V4_0}', "");
Expect(0, 918000, '\p{Age: _V4_0}', "");
Expect(1, 918000, '\p{^Age: _V4_0}', "");
Expect(1, 918000, '\P{Age: _V4_0}', "");
Expect(0, 918000, '\P{^Age: _V4_0}', "");
Error('\p{Is_Age=:=_000004.0}');
Error('\P{Is_Age=:=_000004.0}');
Expect(1, 917999, '\p{Is_Age=+000_000_000_4.0}', "");
Expect(0, 917999, '\p{^Is_Age=+000_000_000_4.0}', "");
Expect(0, 917999, '\P{Is_Age=+000_000_000_4.0}', "");
Expect(1, 917999, '\P{^Is_Age=+000_000_000_4.0}', "");
Expect(0, 918000, '\p{Is_Age=+000_000_000_4.0}', "");
Expect(1, 918000, '\p{^Is_Age=+000_000_000_4.0}', "");
Expect(1, 918000, '\P{Is_Age=+000_000_000_4.0}', "");
Expect(0, 918000, '\P{^Is_Age=+000_000_000_4.0}', "");
Error('\p{Age=	-V4_1/a/}');
Error('\P{Age=	-V4_1/a/}');
Expect(1, 120485, '\p{Age=v41}', "");
Expect(0, 120485, '\p{^Age=v41}', "");
Expect(0, 120485, '\P{Age=v41}', "");
Expect(1, 120485, '\P{^Age=v41}', "");
Expect(0, 120486, '\p{Age=v41}', "");
Expect(1, 120486, '\p{^Age=v41}', "");
Expect(1, 120486, '\P{Age=v41}', "");
Expect(0, 120486, '\P{^Age=v41}', "");
Expect(1, 120485, '\p{Age=-_v4_1}', "");
Expect(0, 120485, '\p{^Age=-_v4_1}', "");
Expect(0, 120485, '\P{Age=-_v4_1}', "");
Expect(1, 120485, '\P{^Age=-_v4_1}', "");
Expect(0, 120486, '\p{Age=-_v4_1}', "");
Expect(1, 120486, '\p{^Age=-_v4_1}', "");
Expect(1, 120486, '\P{Age=-_v4_1}', "");
Expect(0, 120486, '\P{^Age=-_v4_1}', "");
Error('\p{Is_Age:-:=00004.1}');
Error('\P{Is_Age:-:=00004.1}');
Expect(1, 120485, '\p{Is_Age=000_4.1}', "");
Expect(0, 120485, '\p{^Is_Age=000_4.1}', "");
Expect(0, 120485, '\P{Is_Age=000_4.1}', "");
Expect(1, 120485, '\P{^Is_Age=000_4.1}', "");
Expect(0, 120486, '\p{Is_Age=000_4.1}', "");
Expect(1, 120486, '\p{^Is_Age=000_4.1}', "");
Expect(1, 120486, '\P{Is_Age=000_4.1}', "");
Expect(0, 120486, '\P{^Is_Age=000_4.1}', "");
Error('\p{Age=:=	_V5_0}');
Error('\P{Age=:=	_V5_0}');
Expect(1, 120779, '\p{Age=v50}', "");
Expect(0, 120779, '\p{^Age=v50}', "");
Expect(0, 120779, '\P{Age=v50}', "");
Expect(1, 120779, '\P{^Age=v50}', "");
Expect(0, 120780, '\p{Age=v50}', "");
Expect(1, 120780, '\p{^Age=v50}', "");
Expect(1, 120780, '\P{Age=v50}', "");
Expect(0, 120780, '\P{^Age=v50}', "");
Expect(1, 120779, '\p{Age: -V5_0}', "");
Expect(0, 120779, '\p{^Age: -V5_0}', "");
Expect(0, 120779, '\P{Age: -V5_0}', "");
Expect(1, 120779, '\P{^Age: -V5_0}', "");
Expect(0, 120780, '\p{Age: -V5_0}', "");
Expect(1, 120780, '\p{^Age: -V5_0}', "");
Expect(1, 120780, '\P{Age: -V5_0}', "");
Expect(0, 120780, '\P{^Age: -V5_0}', "");
Error('\p{Is_Age=_/a/+00_5.0}');
Error('\P{Is_Age=_/a/+00_5.0}');
Expect(1, 120779, '\p{Is_Age=5.0}', "");
Expect(0, 120779, '\p{^Is_Age=5.0}', "");
Expect(0, 120779, '\P{Is_Age=5.0}', "");
Expect(1, 120779, '\P{^Is_Age=5.0}', "");
Expect(0, 120780, '\p{Is_Age=5.0}', "");
Expect(1, 120780, '\p{^Is_Age=5.0}', "");
Expect(1, 120780, '\P{Is_Age=5.0}', "");
Expect(0, 120780, '\P{^Is_Age=5.0}', "");
Error('\p{Age=	V5_1/a/}');
Error('\P{Age=	V5_1/a/}');
Expect(1, 127123, '\p{Age=v51}', "");
Expect(0, 127123, '\p{^Age=v51}', "");
Expect(0, 127123, '\P{Age=v51}', "");
Expect(1, 127123, '\P{^Age=v51}', "");
Expect(0, 127124, '\p{Age=v51}', "");
Expect(1, 127124, '\p{^Age=v51}', "");
Expect(1, 127124, '\P{Age=v51}', "");
Expect(0, 127124, '\P{^Age=v51}', "");
Expect(1, 127123, '\p{Age=_-V5_1}', "");
Expect(0, 127123, '\p{^Age=_-V5_1}', "");
Expect(0, 127123, '\P{Age=_-V5_1}', "");
Expect(1, 127123, '\P{^Age=_-V5_1}', "");
Expect(0, 127124, '\p{Age=_-V5_1}', "");
Expect(1, 127124, '\p{^Age=_-V5_1}', "");
Expect(1, 127124, '\P{Age=_-V5_1}', "");
Expect(0, 127124, '\P{^Age=_-V5_1}', "");
Error('\p{Is_Age:	:=00005.1}');
Error('\P{Is_Age:	:=00005.1}');
Expect(1, 127123, '\p{Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(0, 127123, '\p{^Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(0, 127123, '\P{Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(1, 127123, '\P{^Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(0, 127124, '\p{Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(1, 127124, '\p{^Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(1, 127124, '\P{Is_Age=0_0_0_0_0_0_05.1}', "");
Expect(0, 127124, '\P{^Is_Age=0_0_0_0_0_0_05.1}', "");
Error('\p{Age=-_V5_2:=}');
Error('\P{Age=-_V5_2:=}');
Expect(1, 177972, '\p{Age=v52}', "");
Expect(0, 177972, '\p{^Age=v52}', "");
Expect(0, 177972, '\P{Age=v52}', "");
Expect(1, 177972, '\P{^Age=v52}', "");
Expect(0, 177973, '\p{Age=v52}', "");
Expect(1, 177973, '\p{^Age=v52}', "");
Expect(1, 177973, '\P{Age=v52}', "");
Expect(0, 177973, '\P{^Age=v52}', "");
Expect(1, 177972, '\p{Age=	 V5_2}', "");
Expect(0, 177972, '\p{^Age=	 V5_2}', "");
Expect(0, 177972, '\P{Age=	 V5_2}', "");
Expect(1, 177972, '\P{^Age=	 V5_2}', "");
Expect(0, 177973, '\p{Age=	 V5_2}', "");
Expect(1, 177973, '\p{^Age=	 V5_2}', "");
Expect(1, 177973, '\P{Age=	 V5_2}', "");
Expect(0, 177973, '\P{^Age=	 V5_2}', "");
Error('\p{Is_Age=-/a/000005.2}');
Error('\P{Is_Age=-/a/000005.2}');
Expect(1, 177972, '\p{Is_Age=+000_000_05.2}', "");
Expect(0, 177972, '\p{^Is_Age=+000_000_05.2}', "");
Expect(0, 177972, '\P{Is_Age=+000_000_05.2}', "");
Expect(1, 177972, '\P{^Is_Age=+000_000_05.2}', "");
Expect(0, 177973, '\p{Is_Age=+000_000_05.2}', "");
Expect(1, 177973, '\p{^Is_Age=+000_000_05.2}', "");
Expect(1, 177973, '\P{Is_Age=+000_000_05.2}', "");
Expect(0, 177973, '\P{^Is_Age=+000_000_05.2}', "");
Error('\p{Age=_/a/V6_0}');
Error('\P{Age=_/a/V6_0}');
Expect(1, 178205, '\p{Age=v60}', "");
Expect(0, 178205, '\p{^Age=v60}', "");
Expect(0, 178205, '\P{Age=v60}', "");
Expect(1, 178205, '\P{^Age=v60}', "");
Expect(0, 178206, '\p{Age=v60}', "");
Expect(1, 178206, '\p{^Age=v60}', "");
Expect(1, 178206, '\P{Age=v60}', "");
Expect(0, 178206, '\P{^Age=v60}', "");
Expect(1, 178205, '\p{Age=	 V6_0}', "");
Expect(0, 178205, '\p{^Age=	 V6_0}', "");
Expect(0, 178205, '\P{Age=	 V6_0}', "");
Expect(1, 178205, '\P{^Age=	 V6_0}', "");
Expect(0, 178206, '\p{Age=	 V6_0}', "");
Expect(1, 178206, '\p{^Age=	 V6_0}', "");
Expect(1, 178206, '\P{Age=	 V6_0}', "");
Expect(0, 178206, '\P{^Age=	 V6_0}', "");
Error('\p{Is_Age=:=-	0_0_0_0_0_006.0}');
Error('\P{Is_Age=:=-	0_0_0_0_0_006.0}');
Expect(1, 178205, '\p{Is_Age=+0000006.0}', "");
Expect(0, 178205, '\p{^Is_Age=+0000006.0}', "");
Expect(0, 178205, '\P{Is_Age=+0000006.0}', "");
Expect(1, 178205, '\P{^Is_Age=+0000006.0}', "");
Expect(0, 178206, '\p{Is_Age=+0000006.0}', "");
Expect(1, 178206, '\p{^Is_Age=+0000006.0}', "");
Expect(1, 178206, '\P{Is_Age=+0000006.0}', "");
Expect(0, 178206, '\P{^Is_Age=+0000006.0}', "");
Error('\p{Age=-/a/V6_1}');
Error('\P{Age=-/a/V6_1}');
Expect(1, 128564, '\p{Age=v61}', "");
Expect(0, 128564, '\p{^Age=v61}', "");
Expect(0, 128564, '\P{Age=v61}', "");
Expect(1, 128564, '\P{^Age=v61}', "");
Expect(0, 128565, '\p{Age=v61}', "");
Expect(1, 128565, '\p{^Age=v61}', "");
Expect(1, 128565, '\P{Age=v61}', "");
Expect(0, 128565, '\P{^Age=v61}', "");
Expect(1, 128564, '\p{Age:	 _V6_1}', "");
Expect(0, 128564, '\p{^Age:	 _V6_1}', "");
Expect(0, 128564, '\P{Age:	 _V6_1}', "");
Expect(1, 128564, '\P{^Age:	 _V6_1}', "");
Expect(0, 128565, '\p{Age:	 _V6_1}', "");
Expect(1, 128565, '\p{^Age:	 _V6_1}', "");
Expect(1, 128565, '\P{Age:	 _V6_1}', "");
Expect(0, 128565, '\P{^Age:	 _V6_1}', "");
Error('\p{Is_Age=_/a/00_00_00_06.1}');
Error('\P{Is_Age=_/a/00_00_00_06.1}');
Expect(1, 128564, '\p{Is_Age=00_00_00_00_06.1}', "");
Expect(0, 128564, '\p{^Is_Age=00_00_00_00_06.1}', "");
Expect(0, 128564, '\P{Is_Age=00_00_00_00_06.1}', "");
Expect(1, 128564, '\P{^Is_Age=00_00_00_00_06.1}', "");
Expect(0, 128565, '\p{Is_Age=00_00_00_00_06.1}', "");
Expect(1, 128565, '\p{^Is_Age=00_00_00_00_06.1}', "");
Expect(1, 128565, '\P{Is_Age=00_00_00_00_06.1}', "");
Expect(0, 128565, '\P{^Is_Age=00_00_00_00_06.1}', "");
Error('\p{Age= 	V6_2/a/}');
Error('\P{Age= 	V6_2/a/}');
Expect(1, 8378, '\p{Age=v62}', "");
Expect(0, 8378, '\p{^Age=v62}', "");
Expect(0, 8378, '\P{Age=v62}', "");
Expect(1, 8378, '\P{^Age=v62}', "");
Expect(0, 8379, '\p{Age=v62}', "");
Expect(1, 8379, '\p{^Age=v62}', "");
Expect(1, 8379, '\P{Age=v62}', "");
Expect(0, 8379, '\P{^Age=v62}', "");
Expect(1, 8378, '\p{Age= _V6_2}', "");
Expect(0, 8378, '\p{^Age= _V6_2}', "");
Expect(0, 8378, '\P{Age= _V6_2}', "");
Expect(1, 8378, '\P{^Age= _V6_2}', "");
Expect(0, 8379, '\p{Age= _V6_2}', "");
Expect(1, 8379, '\p{^Age= _V6_2}', "");
Expect(1, 8379, '\P{Age= _V6_2}', "");
Expect(0, 8379, '\P{^Age= _V6_2}', "");
Error('\p{Is_Age=/a/		+0_0_06.2}');
Error('\P{Is_Age=/a/		+0_0_06.2}');
Expect(1, 8378, '\p{Is_Age=0006.2}', "");
Expect(0, 8378, '\p{^Is_Age=0006.2}', "");
Expect(0, 8378, '\P{Is_Age=0006.2}', "");
Expect(1, 8378, '\P{^Is_Age=0006.2}', "");
Expect(0, 8379, '\p{Is_Age=0006.2}', "");
Expect(1, 8379, '\p{^Is_Age=0006.2}', "");
Expect(1, 8379, '\P{Is_Age=0006.2}', "");
Expect(0, 8379, '\P{^Is_Age=0006.2}', "");
Error('\p{Age:  v6_3:=}');
Error('\P{Age:  v6_3:=}');
Expect(1, 8297, '\p{Age=v63}', "");
Expect(0, 8297, '\p{^Age=v63}', "");
Expect(0, 8297, '\P{Age=v63}', "");
Expect(1, 8297, '\P{^Age=v63}', "");
Expect(0, 8298, '\p{Age=v63}', "");
Expect(1, 8298, '\p{^Age=v63}', "");
Expect(1, 8298, '\P{Age=v63}', "");
Expect(0, 8298, '\P{^Age=v63}', "");
Expect(1, 8297, '\p{Age=	 V6_3}', "");
Expect(0, 8297, '\p{^Age=	 V6_3}', "");
Expect(0, 8297, '\P{Age=	 V6_3}', "");
Expect(1, 8297, '\P{^Age=	 V6_3}', "");
Expect(0, 8298, '\p{Age=	 V6_3}', "");
Expect(1, 8298, '\p{^Age=	 V6_3}', "");
Expect(1, 8298, '\P{Age=	 V6_3}', "");
Expect(0, 8298, '\P{^Age=	 V6_3}', "");
Error('\p{Is_Age=/a/ 	+0_0_0_0_0_006.3}');
Error('\P{Is_Age=/a/ 	+0_0_0_0_0_006.3}');
Expect(1, 8297, '\p{Is_Age=0_0_0_006.3}', "");
Expect(0, 8297, '\p{^Is_Age=0_0_0_006.3}', "");
Expect(0, 8297, '\P{Is_Age=0_0_0_006.3}', "");
Expect(1, 8297, '\P{^Is_Age=0_0_0_006.3}', "");
Expect(0, 8298, '\p{Is_Age=0_0_0_006.3}', "");
Expect(1, 8298, '\p{^Is_Age=0_0_0_006.3}', "");
Expect(1, 8298, '\P{Is_Age=0_0_0_006.3}', "");
Expect(0, 8298, '\P{^Is_Age=0_0_0_006.3}', "");
Error('\p{Age=:=		V7_0}');
Error('\P{Age=:=		V7_0}');
Expect(1, 129197, '\p{Age=v70}', "");
Expect(0, 129197, '\p{^Age=v70}', "");
Expect(0, 129197, '\P{Age=v70}', "");
Expect(1, 129197, '\P{^Age=v70}', "");
Expect(0, 129198, '\p{Age=v70}', "");
Expect(1, 129198, '\p{^Age=v70}', "");
Expect(1, 129198, '\P{Age=v70}', "");
Expect(0, 129198, '\P{^Age=v70}', "");
Expect(1, 129197, '\p{Age=	 V7_0}', "");
Expect(0, 129197, '\p{^Age=	 V7_0}', "");
Expect(0, 129197, '\P{Age=	 V7_0}', "");
Expect(1, 129197, '\P{^Age=	 V7_0}', "");
Expect(0, 129198, '\p{Age=	 V7_0}', "");
Expect(1, 129198, '\p{^Age=	 V7_0}', "");
Expect(1, 129198, '\P{Age=	 V7_0}', "");
Expect(0, 129198, '\P{^Age=	 V7_0}', "");
Error('\p{Is_Age=_0000007.0/a/}');
Error('\P{Is_Age=_0000007.0/a/}');
Expect(1, 129197, '\p{Is_Age=7.0}', "");
Expect(0, 129197, '\p{^Is_Age=7.0}', "");
Expect(0, 129197, '\P{Is_Age=7.0}', "");
Expect(1, 129197, '\P{^Is_Age=7.0}', "");
Expect(0, 129198, '\p{Is_Age=7.0}', "");
Expect(1, 129198, '\p{^Is_Age=7.0}', "");
Expect(1, 129198, '\P{Is_Age=7.0}', "");
Expect(0, 129198, '\P{^Is_Age=7.0}', "");
Error('\p{Age=_:=unassigned}');
Error('\P{Age=_:=unassigned}');
Expect(1, 983037, '\p{Age=unassigned}', "");
Expect(0, 983037, '\p{^Age=unassigned}', "");
Expect(0, 983037, '\P{Age=unassigned}', "");
Expect(1, 983037, '\P{^Age=unassigned}', "");
Expect(0, 983040, '\p{Age=unassigned}', "");
Expect(1, 983040, '\p{^Age=unassigned}', "");
Expect(1, 983040, '\P{Age=unassigned}', "");
Expect(0, 983040, '\P{^Age=unassigned}', "");
Expect(1, 983037, '\p{Age=_unassigned}', "");
Expect(0, 983037, '\p{^Age=_unassigned}', "");
Expect(0, 983037, '\P{Age=_unassigned}', "");
Expect(1, 983037, '\P{^Age=_unassigned}', "");
Expect(0, 983040, '\p{Age=_unassigned}', "");
Expect(1, 983040, '\p{^Age=_unassigned}', "");
Expect(1, 983040, '\P{Age=_unassigned}', "");
Expect(0, 983040, '\P{^Age=_unassigned}', "");
Error('\p{Is_Age=_/a/NA}');
Error('\P{Is_Age=_/a/NA}');
Expect(1, 983037, '\p{Is_Age=na}', "");
Expect(0, 983037, '\p{^Is_Age=na}', "");
Expect(0, 983037, '\P{Is_Age=na}', "");
Expect(1, 983037, '\P{^Is_Age=na}', "");
Expect(0, 983040, '\p{Is_Age=na}', "");
Expect(1, 983040, '\p{^Is_Age=na}', "");
Expect(1, 983040, '\P{Is_Age=na}', "");
Expect(0, 983040, '\P{^Is_Age=na}', "");
Expect(1, 983037, '\p{Is_Age: __NA}', "");
Expect(0, 983037, '\p{^Is_Age: __NA}', "");
Expect(0, 983037, '\P{Is_Age: __NA}', "");
Expect(1, 983037, '\P{^Is_Age: __NA}', "");
Expect(0, 983040, '\p{Is_Age: __NA}', "");
Expect(1, 983040, '\p{^Is_Age: __NA}', "");
Expect(1, 983040, '\P{Is_Age: __NA}', "");
Expect(0, 983040, '\P{^Is_Age: __NA}', "");
Error('\p{Bidi_Class=-	Arabic_Letter/a/}');
Error('\P{Bidi_Class=-	Arabic_Letter/a/}');
Expect(1, 126719, '\p{Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\p{^Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\P{Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\P{^Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\p{Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\p{^Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\P{Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\P{^Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\p{Bidi_Class: _arabic_LETTER}', "");
Expect(0, 126719, '\p{^Bidi_Class: _arabic_LETTER}', "");
Expect(0, 126719, '\P{Bidi_Class: _arabic_LETTER}', "");
Expect(1, 126719, '\P{^Bidi_Class: _arabic_LETTER}', "");
Expect(0, 126720, '\p{Bidi_Class: _arabic_LETTER}', "");
Expect(1, 126720, '\p{^Bidi_Class: _arabic_LETTER}', "");
Expect(1, 126720, '\P{Bidi_Class: _arabic_LETTER}', "");
Expect(0, 126720, '\P{^Bidi_Class: _arabic_LETTER}', "");
Error('\p{Bc=:= AL}');
Error('\P{Bc=:= AL}');
Expect(1, 126719, '\p{Bc=al}', "");
Expect(0, 126719, '\p{^Bc=al}', "");
Expect(0, 126719, '\P{Bc=al}', "");
Expect(1, 126719, '\P{^Bc=al}', "");
Expect(0, 126720, '\p{Bc=al}', "");
Expect(1, 126720, '\p{^Bc=al}', "");
Expect(1, 126720, '\P{Bc=al}', "");
Expect(0, 126720, '\P{^Bc=al}', "");
Expect(1, 126719, '\p{Bc= al}', "");
Expect(0, 126719, '\p{^Bc= al}', "");
Expect(0, 126719, '\P{Bc= al}', "");
Expect(1, 126719, '\P{^Bc= al}', "");
Expect(0, 126720, '\p{Bc= al}', "");
Expect(1, 126720, '\p{^Bc= al}', "");
Expect(1, 126720, '\P{Bc= al}', "");
Expect(0, 126720, '\P{^Bc= al}', "");
Error('\p{Is_Bidi_Class=	:=arabic_letter}');
Error('\P{Is_Bidi_Class=	:=arabic_letter}');
Expect(1, 126719, '\p{Is_Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\p{^Is_Bidi_Class=arabicletter}', "");
Expect(0, 126719, '\P{Is_Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\P{^Is_Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\p{Is_Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\p{^Is_Bidi_Class=arabicletter}', "");
Expect(1, 126720, '\P{Is_Bidi_Class=arabicletter}', "");
Expect(0, 126720, '\P{^Is_Bidi_Class=arabicletter}', "");
Expect(1, 126719, '\p{Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(0, 126719, '\p{^Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(0, 126719, '\P{Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(1, 126719, '\P{^Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(0, 126720, '\p{Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(1, 126720, '\p{^Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(1, 126720, '\P{Is_Bidi_Class=_ARABIC_Letter}', "");
Expect(0, 126720, '\P{^Is_Bidi_Class=_ARABIC_Letter}', "");
Error('\p{Is_Bc= 	al/a/}');
Error('\P{Is_Bc= 	al/a/}');
Expect(1, 126719, '\p{Is_Bc=al}', "");
Expect(0, 126719, '\p{^Is_Bc=al}', "");
Expect(0, 126719, '\P{Is_Bc=al}', "");
Expect(1, 126719, '\P{^Is_Bc=al}', "");
Expect(0, 126720, '\p{Is_Bc=al}', "");
Expect(1, 126720, '\p{^Is_Bc=al}', "");
Expect(1, 126720, '\P{Is_Bc=al}', "");
Expect(0, 126720, '\P{^Is_Bc=al}', "");
Expect(1, 126719, '\p{Is_Bc=_AL}', "");
Expect(0, 126719, '\p{^Is_Bc=_AL}', "");
Expect(0, 126719, '\P{Is_Bc=_AL}', "");
Expect(1, 126719, '\P{^Is_Bc=_AL}', "");
Expect(0, 126720, '\p{Is_Bc=_AL}', "");
Expect(1, 126720, '\p{^Is_Bc=_AL}', "");
Expect(1, 126720, '\P{Is_Bc=_AL}', "");
Expect(0, 126720, '\P{^Is_Bc=_AL}', "");
Error('\p{Bidi_Class=_/a/Arabic_Number}');
Error('\P{Bidi_Class=_/a/Arabic_Number}');
Expect(1, 69246, '\p{Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\p{^Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\P{Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\P{^Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\p{Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\p{^Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\P{Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\P{^Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\p{Bidi_Class=- Arabic_number}', "");
Expect(0, 69246, '\p{^Bidi_Class=- Arabic_number}', "");
Expect(0, 69246, '\P{Bidi_Class=- Arabic_number}', "");
Expect(1, 69246, '\P{^Bidi_Class=- Arabic_number}', "");
Expect(0, 69247, '\p{Bidi_Class=- Arabic_number}', "");
Expect(1, 69247, '\p{^Bidi_Class=- Arabic_number}', "");
Expect(1, 69247, '\P{Bidi_Class=- Arabic_number}', "");
Expect(0, 69247, '\P{^Bidi_Class=- Arabic_number}', "");
Error('\p{Bc=:= -AN}');
Error('\P{Bc=:= -AN}');
Expect(1, 69246, '\p{Bc: an}', "");
Expect(0, 69246, '\p{^Bc: an}', "");
Expect(0, 69246, '\P{Bc: an}', "");
Expect(1, 69246, '\P{^Bc: an}', "");
Expect(0, 69247, '\p{Bc: an}', "");
Expect(1, 69247, '\p{^Bc: an}', "");
Expect(1, 69247, '\P{Bc: an}', "");
Expect(0, 69247, '\P{^Bc: an}', "");
Expect(1, 69246, '\p{Bc= 	an}', "");
Expect(0, 69246, '\p{^Bc= 	an}', "");
Expect(0, 69246, '\P{Bc= 	an}', "");
Expect(1, 69246, '\P{^Bc= 	an}', "");
Expect(0, 69247, '\p{Bc= 	an}', "");
Expect(1, 69247, '\p{^Bc= 	an}', "");
Expect(1, 69247, '\P{Bc= 	an}', "");
Expect(0, 69247, '\P{^Bc= 	an}', "");
Error('\p{Is_Bidi_Class=:=	_arabic_Number}');
Error('\P{Is_Bidi_Class=:=	_arabic_Number}');
Expect(1, 69246, '\p{Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\p{^Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69246, '\P{Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\P{^Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\p{Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\p{^Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69247, '\P{Is_Bidi_Class=arabicnumber}', "");
Expect(0, 69247, '\P{^Is_Bidi_Class=arabicnumber}', "");
Expect(1, 69246, '\p{Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(0, 69246, '\p{^Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(0, 69246, '\P{Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(1, 69246, '\P{^Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(0, 69247, '\p{Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(1, 69247, '\p{^Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(1, 69247, '\P{Is_Bidi_Class=-	arabic_NUMBER}', "");
Expect(0, 69247, '\P{^Is_Bidi_Class=-	arabic_NUMBER}', "");
Error('\p{Is_Bc=/a/_AN}');
Error('\P{Is_Bc=/a/_AN}');
Expect(1, 69246, '\p{Is_Bc=an}', "");
Expect(0, 69246, '\p{^Is_Bc=an}', "");
Expect(0, 69246, '\P{Is_Bc=an}', "");
Expect(1, 69246, '\P{^Is_Bc=an}', "");
Expect(0, 69247, '\p{Is_Bc=an}', "");
Expect(1, 69247, '\p{^Is_Bc=an}', "");
Expect(1, 69247, '\P{Is_Bc=an}', "");
Expect(0, 69247, '\P{^Is_Bc=an}', "");
Expect(1, 69246, '\p{Is_Bc=		AN}', "");
Expect(0, 69246, '\p{^Is_Bc=		AN}', "");
Expect(0, 69246, '\P{Is_Bc=		AN}', "");
Expect(1, 69246, '\P{^Is_Bc=		AN}', "");
Expect(0, 69247, '\p{Is_Bc=		AN}', "");
Expect(1, 69247, '\p{^Is_Bc=		AN}', "");
Expect(1, 69247, '\P{Is_Bc=		AN}', "");
Expect(0, 69247, '\P{^Is_Bc=		AN}', "");
Error('\p{Bidi_Class=  paragraph_SEPARATOR:=}');
Error('\P{Bidi_Class=  paragraph_SEPARATOR:=}');
Expect(1, 8233, '\p{Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\p{^Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\P{Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\P{^Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\p{Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\p{^Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\P{Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\P{^Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\p{Bidi_Class=-Paragraph_Separator}', "");
Expect(0, 8233, '\p{^Bidi_Class=-Paragraph_Separator}', "");
Expect(0, 8233, '\P{Bidi_Class=-Paragraph_Separator}', "");
Expect(1, 8233, '\P{^Bidi_Class=-Paragraph_Separator}', "");
Expect(0, 8234, '\p{Bidi_Class=-Paragraph_Separator}', "");
Expect(1, 8234, '\p{^Bidi_Class=-Paragraph_Separator}', "");
Expect(1, 8234, '\P{Bidi_Class=-Paragraph_Separator}', "");
Expect(0, 8234, '\P{^Bidi_Class=-Paragraph_Separator}', "");
Error('\p{Bc=:=  B}');
Error('\P{Bc=:=  B}');
Expect(1, 8233, '\p{Bc=b}', "");
Expect(0, 8233, '\p{^Bc=b}', "");
Expect(0, 8233, '\P{Bc=b}', "");
Expect(1, 8233, '\P{^Bc=b}', "");
Expect(0, 8234, '\p{Bc=b}', "");
Expect(1, 8234, '\p{^Bc=b}', "");
Expect(1, 8234, '\P{Bc=b}', "");
Expect(0, 8234, '\P{^Bc=b}', "");
Expect(1, 8233, '\p{Bc:	- B}', "");
Expect(0, 8233, '\p{^Bc:	- B}', "");
Expect(0, 8233, '\P{Bc:	- B}', "");
Expect(1, 8233, '\P{^Bc:	- B}', "");
Expect(0, 8234, '\p{Bc:	- B}', "");
Expect(1, 8234, '\p{^Bc:	- B}', "");
Expect(1, 8234, '\P{Bc:	- B}', "");
Expect(0, 8234, '\P{^Bc:	- B}', "");
Error('\p{Is_Bidi_Class=/a/ _PARAGRAPH_separator}');
Error('\P{Is_Bidi_Class=/a/ _PARAGRAPH_separator}');
Expect(1, 8233, '\p{Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\p{^Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8233, '\P{Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\P{^Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\p{Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\p{^Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8234, '\P{Is_Bidi_Class=paragraphseparator}', "");
Expect(0, 8234, '\P{^Is_Bidi_Class=paragraphseparator}', "");
Expect(1, 8233, '\p{Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(0, 8233, '\p{^Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(0, 8233, '\P{Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(1, 8233, '\P{^Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(0, 8234, '\p{Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(1, 8234, '\p{^Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(1, 8234, '\P{Is_Bidi_Class=-_Paragraph_Separator}', "");
Expect(0, 8234, '\P{^Is_Bidi_Class=-_Paragraph_Separator}', "");
Error('\p{Is_Bc=-	B:=}');
Error('\P{Is_Bc=-	B:=}');
Expect(1, 8233, '\p{Is_Bc=b}', "");
Expect(0, 8233, '\p{^Is_Bc=b}', "");
Expect(0, 8233, '\P{Is_Bc=b}', "");
Expect(1, 8233, '\P{^Is_Bc=b}', "");
Expect(0, 8234, '\p{Is_Bc=b}', "");
Expect(1, 8234, '\p{^Is_Bc=b}', "");
Expect(1, 8234, '\P{Is_Bc=b}', "");
Expect(0, 8234, '\P{^Is_Bc=b}', "");
Expect(1, 8233, '\p{Is_Bc=  B}', "");
Expect(0, 8233, '\p{^Is_Bc=  B}', "");
Expect(0, 8233, '\P{Is_Bc=  B}', "");
Expect(1, 8233, '\P{^Is_Bc=  B}', "");
Expect(0, 8234, '\p{Is_Bc=  B}', "");
Expect(1, 8234, '\p{^Is_Bc=  B}', "");
Expect(1, 8234, '\P{Is_Bc=  B}', "");
Expect(0, 8234, '\P{^Is_Bc=  B}', "");
Error('\p{Bidi_Class=:= BOUNDARY_neutral}');
Error('\P{Bidi_Class=:= BOUNDARY_neutral}');
Expect(1, 921599, '\p{Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\p{^Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\P{Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\P{^Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\p{Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\p{^Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\P{Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\P{^Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\p{Bidi_Class=  Boundary_Neutral}', "");
Expect(0, 921599, '\p{^Bidi_Class=  Boundary_Neutral}', "");
Expect(0, 921599, '\P{Bidi_Class=  Boundary_Neutral}', "");
Expect(1, 921599, '\P{^Bidi_Class=  Boundary_Neutral}', "");
Expect(0, 1114109, '\p{Bidi_Class=  Boundary_Neutral}', "");
Expect(1, 1114109, '\p{^Bidi_Class=  Boundary_Neutral}', "");
Expect(1, 1114109, '\P{Bidi_Class=  Boundary_Neutral}', "");
Expect(0, 1114109, '\P{^Bidi_Class=  Boundary_Neutral}', "");
Error('\p{Bc=:=_BN}');
Error('\P{Bc=:=_BN}');
Expect(1, 921599, '\p{Bc=bn}', "");
Expect(0, 921599, '\p{^Bc=bn}', "");
Expect(0, 921599, '\P{Bc=bn}', "");
Expect(1, 921599, '\P{^Bc=bn}', "");
Expect(0, 1114109, '\p{Bc=bn}', "");
Expect(1, 1114109, '\p{^Bc=bn}', "");
Expect(1, 1114109, '\P{Bc=bn}', "");
Expect(0, 1114109, '\P{^Bc=bn}', "");
Expect(1, 921599, '\p{Bc=-	BN}', "");
Expect(0, 921599, '\p{^Bc=-	BN}', "");
Expect(0, 921599, '\P{Bc=-	BN}', "");
Expect(1, 921599, '\P{^Bc=-	BN}', "");
Expect(0, 1114109, '\p{Bc=-	BN}', "");
Expect(1, 1114109, '\p{^Bc=-	BN}', "");
Expect(1, 1114109, '\P{Bc=-	BN}', "");
Expect(0, 1114109, '\P{^Bc=-	BN}', "");
Error('\p{Is_Bidi_Class:	:= -boundary_Neutral}');
Error('\P{Is_Bidi_Class:	:= -boundary_Neutral}');
Expect(1, 921599, '\p{Is_Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\p{^Is_Bidi_Class=boundaryneutral}', "");
Expect(0, 921599, '\P{Is_Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\P{^Is_Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\p{Is_Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\p{^Is_Bidi_Class=boundaryneutral}', "");
Expect(1, 1114109, '\P{Is_Bidi_Class=boundaryneutral}', "");
Expect(0, 1114109, '\P{^Is_Bidi_Class=boundaryneutral}', "");
Expect(1, 921599, '\p{Is_Bidi_Class=__boundary_Neutral}', "");
Expect(0, 921599, '\p{^Is_Bidi_Class=__boundary_Neutral}', "");
Expect(0, 921599, '\P{Is_Bidi_Class=__boundary_Neutral}', "");
Expect(1, 921599, '\P{^Is_Bidi_Class=__boundary_Neutral}', "");
Expect(0, 1114109, '\p{Is_Bidi_Class=__boundary_Neutral}', "");
Expect(1, 1114109, '\p{^Is_Bidi_Class=__boundary_Neutral}', "");
Expect(1, 1114109, '\P{Is_Bidi_Class=__boundary_Neutral}', "");
Expect(0, 1114109, '\P{^Is_Bidi_Class=__boundary_Neutral}', "");
Error('\p{Is_Bc:	bn/a/}');
Error('\P{Is_Bc:	bn/a/}');
Expect(1, 921599, '\p{Is_Bc=bn}', "");
Expect(0, 921599, '\p{^Is_Bc=bn}', "");
Expect(0, 921599, '\P{Is_Bc=bn}', "");
Expect(1, 921599, '\P{^Is_Bc=bn}', "");
Expect(0, 1114109, '\p{Is_Bc=bn}', "");
Expect(1, 1114109, '\p{^Is_Bc=bn}', "");
Expect(1, 1114109, '\P{Is_Bc=bn}', "");
Expect(0, 1114109, '\P{^Is_Bc=bn}', "");
Expect(1, 921599, '\p{Is_Bc:-BN}', "");
Expect(0, 921599, '\p{^Is_Bc:-BN}', "");
Expect(0, 921599, '\P{Is_Bc:-BN}', "");
Expect(1, 921599, '\P{^Is_Bc:-BN}', "");
Expect(0, 1114109, '\p{Is_Bc:-BN}', "");
Expect(1, 1114109, '\p{^Is_Bc:-BN}', "");
Expect(1, 1114109, '\P{Is_Bc:-BN}', "");
Expect(0, 1114109, '\P{^Is_Bc:-BN}', "");
Error('\p{Bidi_Class=-:=common_Separator}');
Error('\P{Bidi_Class=-:=common_Separator}');
Expect(1, 65306, '\p{Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\p{^Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\P{Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\P{^Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\p{Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\p{^Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\P{Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\P{^Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\p{Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(0, 65306, '\p{^Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(0, 65306, '\P{Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(1, 65306, '\P{^Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(0, 65307, '\p{Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(1, 65307, '\p{^Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(1, 65307, '\P{Bidi_Class:	COMMON_SEPARATOR}', "");
Expect(0, 65307, '\P{^Bidi_Class:	COMMON_SEPARATOR}', "");
Error('\p{Bc=- CS/a/}');
Error('\P{Bc=- CS/a/}');
Expect(1, 65306, '\p{Bc=cs}', "");
Expect(0, 65306, '\p{^Bc=cs}', "");
Expect(0, 65306, '\P{Bc=cs}', "");
Expect(1, 65306, '\P{^Bc=cs}', "");
Expect(0, 65307, '\p{Bc=cs}', "");
Expect(1, 65307, '\p{^Bc=cs}', "");
Expect(1, 65307, '\P{Bc=cs}', "");
Expect(0, 65307, '\P{^Bc=cs}', "");
Expect(1, 65306, '\p{Bc= 	CS}', "");
Expect(0, 65306, '\p{^Bc= 	CS}', "");
Expect(0, 65306, '\P{Bc= 	CS}', "");
Expect(1, 65306, '\P{^Bc= 	CS}', "");
Expect(0, 65307, '\p{Bc= 	CS}', "");
Expect(1, 65307, '\p{^Bc= 	CS}', "");
Expect(1, 65307, '\P{Bc= 	CS}', "");
Expect(0, 65307, '\P{^Bc= 	CS}', "");
Error('\p{Is_Bidi_Class:__COMMON_separator:=}');
Error('\P{Is_Bidi_Class:__COMMON_separator:=}');
Expect(1, 65306, '\p{Is_Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\p{^Is_Bidi_Class=commonseparator}', "");
Expect(0, 65306, '\P{Is_Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\P{^Is_Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\p{Is_Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\p{^Is_Bidi_Class=commonseparator}', "");
Expect(1, 65307, '\P{Is_Bidi_Class=commonseparator}', "");
Expect(0, 65307, '\P{^Is_Bidi_Class=commonseparator}', "");
Expect(1, 65306, '\p{Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(0, 65306, '\p{^Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(0, 65306, '\P{Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(1, 65306, '\P{^Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(0, 65307, '\p{Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(1, 65307, '\p{^Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(1, 65307, '\P{Is_Bidi_Class:__Common_SEPARATOR}', "");
Expect(0, 65307, '\P{^Is_Bidi_Class:__Common_SEPARATOR}', "");
Error('\p{Is_Bc: /a/		CS}');
Error('\P{Is_Bc: /a/		CS}');
Expect(1, 65306, '\p{Is_Bc=cs}', "");
Expect(0, 65306, '\p{^Is_Bc=cs}', "");
Expect(0, 65306, '\P{Is_Bc=cs}', "");
Expect(1, 65306, '\P{^Is_Bc=cs}', "");
Expect(0, 65307, '\p{Is_Bc=cs}', "");
Expect(1, 65307, '\p{^Is_Bc=cs}', "");
Expect(1, 65307, '\P{Is_Bc=cs}', "");
Expect(0, 65307, '\P{^Is_Bc=cs}', "");
Expect(1, 65306, '\p{Is_Bc=- CS}', "");
Expect(0, 65306, '\p{^Is_Bc=- CS}', "");
Expect(0, 65306, '\P{Is_Bc=- CS}', "");
Expect(1, 65306, '\P{^Is_Bc=- CS}', "");
Expect(0, 65307, '\p{Is_Bc=- CS}', "");
Expect(1, 65307, '\p{^Is_Bc=- CS}', "");
Expect(1, 65307, '\P{Is_Bc=- CS}', "");
Expect(0, 65307, '\P{^Is_Bc=- CS}', "");
Error('\p{Bidi_Class=	European_Number/a/}');
Error('\P{Bidi_Class=	European_Number/a/}');
Expect(1, 127242, '\p{Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\p{^Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\P{Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\P{^Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\p{Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\p{^Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\P{Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\P{^Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\p{Bidi_Class:_european_NUMBER}', "");
Expect(0, 127242, '\p{^Bidi_Class:_european_NUMBER}', "");
Expect(0, 127242, '\P{Bidi_Class:_european_NUMBER}', "");
Expect(1, 127242, '\P{^Bidi_Class:_european_NUMBER}', "");
Expect(0, 127243, '\p{Bidi_Class:_european_NUMBER}', "");
Expect(1, 127243, '\p{^Bidi_Class:_european_NUMBER}', "");
Expect(1, 127243, '\P{Bidi_Class:_european_NUMBER}', "");
Expect(0, 127243, '\P{^Bidi_Class:_european_NUMBER}', "");
Error('\p{Bc=-:=EN}');
Error('\P{Bc=-:=EN}');
Expect(1, 127242, '\p{Bc=en}', "");
Expect(0, 127242, '\p{^Bc=en}', "");
Expect(0, 127242, '\P{Bc=en}', "");
Expect(1, 127242, '\P{^Bc=en}', "");
Expect(0, 127243, '\p{Bc=en}', "");
Expect(1, 127243, '\p{^Bc=en}', "");
Expect(1, 127243, '\P{Bc=en}', "");
Expect(0, 127243, '\P{^Bc=en}', "");
Expect(1, 127242, '\p{Bc=_-EN}', "");
Expect(0, 127242, '\p{^Bc=_-EN}', "");
Expect(0, 127242, '\P{Bc=_-EN}', "");
Expect(1, 127242, '\P{^Bc=_-EN}', "");
Expect(0, 127243, '\p{Bc=_-EN}', "");
Expect(1, 127243, '\p{^Bc=_-EN}', "");
Expect(1, 127243, '\P{Bc=_-EN}', "");
Expect(0, 127243, '\P{^Bc=_-EN}', "");
Error('\p{Is_Bidi_Class=/a/European_Number}');
Error('\P{Is_Bidi_Class=/a/European_Number}');
Expect(1, 127242, '\p{Is_Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\p{^Is_Bidi_Class=europeannumber}', "");
Expect(0, 127242, '\P{Is_Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\P{^Is_Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\p{Is_Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\p{^Is_Bidi_Class=europeannumber}', "");
Expect(1, 127243, '\P{Is_Bidi_Class=europeannumber}', "");
Expect(0, 127243, '\P{^Is_Bidi_Class=europeannumber}', "");
Expect(1, 127242, '\p{Is_Bidi_Class=	European_Number}', "");
Expect(0, 127242, '\p{^Is_Bidi_Class=	European_Number}', "");
Expect(0, 127242, '\P{Is_Bidi_Class=	European_Number}', "");
Expect(1, 127242, '\P{^Is_Bidi_Class=	European_Number}', "");
Expect(0, 127243, '\p{Is_Bidi_Class=	European_Number}', "");
Expect(1, 127243, '\p{^Is_Bidi_Class=	European_Number}', "");
Expect(1, 127243, '\P{Is_Bidi_Class=	European_Number}', "");
Expect(0, 127243, '\P{^Is_Bidi_Class=	European_Number}', "");
Error('\p{Is_Bc=	EN:=}');
Error('\P{Is_Bc=	EN:=}');
Expect(1, 127242, '\p{Is_Bc=en}', "");
Expect(0, 127242, '\p{^Is_Bc=en}', "");
Expect(0, 127242, '\P{Is_Bc=en}', "");
Expect(1, 127242, '\P{^Is_Bc=en}', "");
Expect(0, 127243, '\p{Is_Bc=en}', "");
Expect(1, 127243, '\p{^Is_Bc=en}', "");
Expect(1, 127243, '\P{Is_Bc=en}', "");
Expect(0, 127243, '\P{^Is_Bc=en}', "");
Expect(1, 127242, '\p{Is_Bc=_en}', "");
Expect(0, 127242, '\p{^Is_Bc=_en}', "");
Expect(0, 127242, '\P{Is_Bc=_en}', "");
Expect(1, 127242, '\P{^Is_Bc=_en}', "");
Expect(0, 127243, '\p{Is_Bc=_en}', "");
Expect(1, 127243, '\p{^Is_Bc=_en}', "");
Expect(1, 127243, '\P{Is_Bc=_en}', "");
Expect(0, 127243, '\P{^Is_Bc=_en}', "");
Error('\p{Bidi_Class=/a/ European_SEPARATOR}');
Error('\P{Bidi_Class=/a/ European_SEPARATOR}');
Expect(1, 65293, '\p{Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\p{^Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\P{Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\P{^Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\p{Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\p{^Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\P{Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\P{^Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\p{Bidi_Class= -european_SEPARATOR}', "");
Expect(0, 65293, '\p{^Bidi_Class= -european_SEPARATOR}', "");
Expect(0, 65293, '\P{Bidi_Class= -european_SEPARATOR}', "");
Expect(1, 65293, '\P{^Bidi_Class= -european_SEPARATOR}', "");
Expect(0, 65294, '\p{Bidi_Class= -european_SEPARATOR}', "");
Expect(1, 65294, '\p{^Bidi_Class= -european_SEPARATOR}', "");
Expect(1, 65294, '\P{Bidi_Class= -european_SEPARATOR}', "");
Expect(0, 65294, '\P{^Bidi_Class= -european_SEPARATOR}', "");
Error('\p{Bc=-:=ES}');
Error('\P{Bc=-:=ES}');
Expect(1, 65293, '\p{Bc=es}', "");
Expect(0, 65293, '\p{^Bc=es}', "");
Expect(0, 65293, '\P{Bc=es}', "");
Expect(1, 65293, '\P{^Bc=es}', "");
Expect(0, 65294, '\p{Bc=es}', "");
Expect(1, 65294, '\p{^Bc=es}', "");
Expect(1, 65294, '\P{Bc=es}', "");
Expect(0, 65294, '\P{^Bc=es}', "");
Expect(1, 65293, '\p{Bc:    es}', "");
Expect(0, 65293, '\p{^Bc:    es}', "");
Expect(0, 65293, '\P{Bc:    es}', "");
Expect(1, 65293, '\P{^Bc:    es}', "");
Expect(0, 65294, '\p{Bc:    es}', "");
Expect(1, 65294, '\p{^Bc:    es}', "");
Expect(1, 65294, '\P{Bc:    es}', "");
Expect(0, 65294, '\P{^Bc:    es}', "");
Error('\p{Is_Bidi_Class=	:=european_Separator}');
Error('\P{Is_Bidi_Class=	:=european_Separator}');
Expect(1, 65293, '\p{Is_Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\p{^Is_Bidi_Class=europeanseparator}', "");
Expect(0, 65293, '\P{Is_Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\P{^Is_Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\p{Is_Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\p{^Is_Bidi_Class=europeanseparator}', "");
Expect(1, 65294, '\P{Is_Bidi_Class=europeanseparator}', "");
Expect(0, 65294, '\P{^Is_Bidi_Class=europeanseparator}', "");
Expect(1, 65293, '\p{Is_Bidi_Class=--European_separator}', "");
Expect(0, 65293, '\p{^Is_Bidi_Class=--European_separator}', "");
Expect(0, 65293, '\P{Is_Bidi_Class=--European_separator}', "");
Expect(1, 65293, '\P{^Is_Bidi_Class=--European_separator}', "");
Expect(0, 65294, '\p{Is_Bidi_Class=--European_separator}', "");
Expect(1, 65294, '\p{^Is_Bidi_Class=--European_separator}', "");
Expect(1, 65294, '\P{Is_Bidi_Class=--European_separator}', "");
Expect(0, 65294, '\P{^Is_Bidi_Class=--European_separator}', "");
Error('\p{Is_Bc= 	es/a/}');
Error('\P{Is_Bc= 	es/a/}');
Expect(1, 65293, '\p{Is_Bc=es}', "");
Expect(0, 65293, '\p{^Is_Bc=es}', "");
Expect(0, 65293, '\P{Is_Bc=es}', "");
Expect(1, 65293, '\P{^Is_Bc=es}', "");
Expect(0, 65294, '\p{Is_Bc=es}', "");
Expect(1, 65294, '\p{^Is_Bc=es}', "");
Expect(1, 65294, '\P{Is_Bc=es}', "");
Expect(0, 65294, '\P{^Is_Bc=es}', "");
Expect(1, 65293, '\p{Is_Bc=	ES}', "");
Expect(0, 65293, '\p{^Is_Bc=	ES}', "");
Expect(0, 65293, '\P{Is_Bc=	ES}', "");
Expect(1, 65293, '\P{^Is_Bc=	ES}', "");
Expect(0, 65294, '\p{Is_Bc=	ES}', "");
Expect(1, 65294, '\p{^Is_Bc=	ES}', "");
Expect(1, 65294, '\P{Is_Bc=	ES}', "");
Expect(0, 65294, '\P{^Is_Bc=	ES}', "");
Error('\p{Bidi_Class: :=European_Terminator}');
Error('\P{Bidi_Class: :=European_Terminator}');
Expect(1, 65510, '\p{Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\p{^Bidi_Class=europeanterminator}', "");
Expect(0, 65510, '\P{Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\P{^Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\p{Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\p{^Bidi_Class=europeanterminator}', "");
Expect(1, 65511, '\P{Bidi_Class=europeanterminator}', "");
Expect(0, 65511, '\P{^Bidi_Class=europeanterminator}', "");
Expect(1, 65510, '\p{Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(0, 65510, '\p{^Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(0, 65510, '\P{Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(1, 65510, '\P{^Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(0, 65511, '\p{Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(1, 65511, '\p{^Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(1, 65511, '\P{Bidi_Class=- EUROPEAN_Terminator}', "");
Expect(0, 65511, '\P{^Bidi_Class=- EUROPEAN_Terminator}', "");
Error('\p{Bc=_/a/ET}');
Error('\P{Bc=_/a/ET}');
Expect(1, 65510, '\p{Bc=et}', "");
Expect(0, 65510, '\p{^Bc=et}', "");
Expect(0, 65510, '\P{Bc=et}', "");
Expect(1, 65510, '\P{^Bc=et}', "");
Expect(0, 65511, '\p{Bc=et}', "");
Expect(1, 65511, '\p{^Bc=et}', "");
Expect(1, 65511, '\P{Bc=et}', "");
Expect(0, 65511, '\P{^Bc=et}', "");
Expect(1, 65510, '\p{Bc=__ET}', "");
Expect(0, 65510, '\p{^Bc=__ET}', "");
Expect(0, 65510, '\P{Bc=__ET}', "");
Expect(1, 65510, '\P{^Bc=__ET}', "");
Expect(0, 65511, '\p{Bc=__ET}', "");
Expect(1, 65511, '\p{^Bc=__ET}', "");
Expect(1, 65511, '\P{Bc=__ET}', "");
Expect(0, 65511, '\P{^Bc=__ET}', "");
Error('\p{Is_Bidi_Class=	_European_Terminator:=}');
Error('\P{Is_Bidi_Class=	_European_Terminator:=}');
Expect(1, 65510, '\p{Is_Bidi_Class:	europeanterminator}', "");
Expect(0, 65510, '\p{^Is_Bidi_Class:	europeanterminator}', "");
Expect(0, 65510, '\P{Is_Bidi_Class:	europeanterminator}', "");
Expect(1, 65510, '\P{^Is_Bidi_Class:	europeanterminator}', "");
Expect(0, 65511, '\p{Is_Bidi_Class:	europeanterminator}', "");
Expect(1, 65511, '\p{^Is_Bidi_Class:	europeanterminator}', "");
Expect(1, 65511, '\P{Is_Bidi_Class:	europeanterminator}', "");
Expect(0, 65511, '\P{^Is_Bidi_Class:	europeanterminator}', "");
Expect(1, 65510, '\p{Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(0, 65510, '\p{^Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(0, 65510, '\P{Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(1, 65510, '\P{^Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(0, 65511, '\p{Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(1, 65511, '\p{^Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(1, 65511, '\P{Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Expect(0, 65511, '\P{^Is_Bidi_Class=_	EUROPEAN_Terminator}', "");
Error('\p{Is_Bc=_:=ET}');
Error('\P{Is_Bc=_:=ET}');
Expect(1, 65510, '\p{Is_Bc=et}', "");
Expect(0, 65510, '\p{^Is_Bc=et}', "");
Expect(0, 65510, '\P{Is_Bc=et}', "");
Expect(1, 65510, '\P{^Is_Bc=et}', "");
Expect(0, 65511, '\p{Is_Bc=et}', "");
Expect(1, 65511, '\p{^Is_Bc=et}', "");
Expect(1, 65511, '\P{Is_Bc=et}', "");
Expect(0, 65511, '\P{^Is_Bc=et}', "");
Expect(1, 65510, '\p{Is_Bc:   --ET}', "");
Expect(0, 65510, '\p{^Is_Bc:   --ET}', "");
Expect(0, 65510, '\P{Is_Bc:   --ET}', "");
Expect(1, 65510, '\P{^Is_Bc:   --ET}', "");
Expect(0, 65511, '\p{Is_Bc:   --ET}', "");
Expect(1, 65511, '\p{^Is_Bc:   --ET}', "");
Expect(1, 65511, '\P{Is_Bc:   --ET}', "");
Expect(0, 65511, '\P{^Is_Bc:   --ET}', "");
Error('\p{Bidi_Class=_/a/First_strong_Isolate}');
Error('\P{Bidi_Class=_/a/First_strong_Isolate}');
Expect(1, 8296, '\p{Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\p{^Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\P{Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\P{^Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\p{Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\p{^Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\P{Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\P{^Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\p{Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(0, 8296, '\p{^Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(0, 8296, '\P{Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(1, 8296, '\P{^Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(0, 8297, '\p{Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(1, 8297, '\p{^Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(1, 8297, '\P{Bidi_Class= 	First_Strong_ISOLATE}', "");
Expect(0, 8297, '\P{^Bidi_Class= 	First_Strong_ISOLATE}', "");
Error('\p{Bc=:=-_FSI}');
Error('\P{Bc=:=-_FSI}');
Expect(1, 8296, '\p{Bc=fsi}', "");
Expect(0, 8296, '\p{^Bc=fsi}', "");
Expect(0, 8296, '\P{Bc=fsi}', "");
Expect(1, 8296, '\P{^Bc=fsi}', "");
Expect(0, 8297, '\p{Bc=fsi}', "");
Expect(1, 8297, '\p{^Bc=fsi}', "");
Expect(1, 8297, '\P{Bc=fsi}', "");
Expect(0, 8297, '\P{^Bc=fsi}', "");
Expect(1, 8296, '\p{Bc=	 fsi}', "");
Expect(0, 8296, '\p{^Bc=	 fsi}', "");
Expect(0, 8296, '\P{Bc=	 fsi}', "");
Expect(1, 8296, '\P{^Bc=	 fsi}', "");
Expect(0, 8297, '\p{Bc=	 fsi}', "");
Expect(1, 8297, '\p{^Bc=	 fsi}', "");
Expect(1, 8297, '\P{Bc=	 fsi}', "");
Expect(0, 8297, '\P{^Bc=	 fsi}', "");
Error('\p{Is_Bidi_Class=/a/First_Strong_Isolate}');
Error('\P{Is_Bidi_Class=/a/First_Strong_Isolate}');
Expect(1, 8296, '\p{Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\p{^Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8296, '\P{Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\P{^Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\p{Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\p{^Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8297, '\P{Is_Bidi_Class=firststrongisolate}', "");
Expect(0, 8297, '\P{^Is_Bidi_Class=firststrongisolate}', "");
Expect(1, 8296, '\p{Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(0, 8296, '\p{^Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(0, 8296, '\P{Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(1, 8296, '\P{^Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(0, 8297, '\p{Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(1, 8297, '\p{^Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(1, 8297, '\P{Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Expect(0, 8297, '\P{^Is_Bidi_Class:- FIRST_strong_Isolate}', "");
Error('\p{Is_Bc=:=-FSI}');
Error('\P{Is_Bc=:=-FSI}');
Expect(1, 8296, '\p{Is_Bc=fsi}', "");
Expect(0, 8296, '\p{^Is_Bc=fsi}', "");
Expect(0, 8296, '\P{Is_Bc=fsi}', "");
Expect(1, 8296, '\P{^Is_Bc=fsi}', "");
Expect(0, 8297, '\p{Is_Bc=fsi}', "");
Expect(1, 8297, '\p{^Is_Bc=fsi}', "");
Expect(1, 8297, '\P{Is_Bc=fsi}', "");
Expect(0, 8297, '\P{^Is_Bc=fsi}', "");
Expect(1, 8296, '\p{Is_Bc:-	FSI}', "");
Expect(0, 8296, '\p{^Is_Bc:-	FSI}', "");
Expect(0, 8296, '\P{Is_Bc:-	FSI}', "");
Expect(1, 8296, '\P{^Is_Bc:-	FSI}', "");
Expect(0, 8297, '\p{Is_Bc:-	FSI}', "");
Expect(1, 8297, '\p{^Is_Bc:-	FSI}', "");
Expect(1, 8297, '\P{Is_Bc:-	FSI}', "");
Expect(0, 8297, '\P{^Is_Bc:-	FSI}', "");
Error('\p{Bidi_Class: :=-LEFT_TO_Right}');
Error('\P{Bidi_Class: :=-LEFT_TO_Right}');
Expect(1, 1114109, '\p{Bidi_Class=lefttoright}', "");
Expect(0, 1114109, '\p{^Bidi_Class=lefttoright}', "");
Expect(0, 1114109, '\P{Bidi_Class=lefttoright}', "");
Expect(1, 1114109, '\P{^Bidi_Class=lefttoright}', "");
Expect(0, 921599, '\p{Bidi_Class=lefttoright}', "");
Expect(1, 921599, '\p{^Bidi_Class=lefttoright}', "");
Expect(1, 921599, '\P{Bidi_Class=lefttoright}', "");
Expect(0, 921599, '\P{^Bidi_Class=lefttoright}', "");
Expect(1, 1114109, '\p{Bidi_Class=		left_to_Right}', "");
Expect(0, 1114109, '\p{^Bidi_Class=		left_to_Right}', "");
Expect(0, 1114109, '\P{Bidi_Class=		left_to_Right}', "");
Expect(1, 1114109, '\P{^Bidi_Class=		left_to_Right}', "");
Expect(0, 921599, '\p{Bidi_Class=		left_to_Right}', "");
Expect(1, 921599, '\p{^Bidi_Class=		left_to_Right}', "");
Expect(1, 921599, '\P{Bidi_Class=		left_to_Right}', "");
Expect(0, 921599, '\P{^Bidi_Class=		left_to_Right}', "");
Error('\p{Bc:_:=L}');
Error('\P{Bc:_:=L}');
Expect(1, 1114109, '\p{Bc=l}', "");
Expect(0, 1114109, '\p{^Bc=l}', "");
Expect(0, 1114109, '\P{Bc=l}', "");
Expect(1, 1114109, '\P{^Bc=l}', "");
Expect(0, 921599, '\p{Bc=l}', "");
Expect(1, 921599, '\p{^Bc=l}', "");
Expect(1, 921599, '\P{Bc=l}', "");
Expect(0, 921599, '\P{^Bc=l}', "");
Expect(1, 1114109, '\p{Bc= 	L}', "");
Expect(0, 1114109, '\p{^Bc= 	L}', "");
Expect(0, 1114109, '\P{Bc= 	L}', "");
Expect(1, 1114109, '\P{^Bc= 	L}', "");
Expect(0, 921599, '\p{Bc= 	L}', "");
Expect(1, 921599, '\p{^Bc= 	L}', "");
Expect(1, 921599, '\P{Bc= 	L}', "");
Expect(0, 921599, '\P{^Bc= 	L}', "");
Error('\p{Is_Bidi_Class=/a/_left_To_Right}');
Error('\P{Is_Bidi_Class=/a/_left_To_Right}');
Expect(1, 1114109, '\p{Is_Bidi_Class=lefttoright}', "");
Expect(0, 1114109, '\p{^Is_Bidi_Class=lefttoright}', "");
Expect(0, 1114109, '\P{Is_Bidi_Class=lefttoright}', "");
Expect(1, 1114109, '\P{^Is_Bidi_Class=lefttoright}', "");
Expect(0, 921599, '\p{Is_Bidi_Class=lefttoright}', "");
Expect(1, 921599, '\p{^Is_Bidi_Class=lefttoright}', "");
Expect(1, 921599, '\P{Is_Bidi_Class=lefttoright}', "");
Expect(0, 921599, '\P{^Is_Bidi_Class=lefttoright}', "");
Expect(1, 1114109, '\p{Is_Bidi_Class=	Left_TO_Right}', "");
Expect(0, 1114109, '\p{^Is_Bidi_Class=	Left_TO_Right}', "");
Expect(0, 1114109, '\P{Is_Bidi_Class=	Left_TO_Right}', "");
Expect(1, 1114109, '\P{^Is_Bidi_Class=	Left_TO_Right}', "");
Expect(0, 921599, '\p{Is_Bidi_Class=	Left_TO_Right}', "");
Expect(1, 921599, '\p{^Is_Bidi_Class=	Left_TO_Right}', "");
Expect(1, 921599, '\P{Is_Bidi_Class=	Left_TO_Right}', "");
Expect(0, 921599, '\P{^Is_Bidi_Class=	Left_TO_Right}', "");
Error('\p{Is_Bc=:=	-L}');
Error('\P{Is_Bc=:=	-L}');
Expect(1, 1114109, '\p{Is_Bc=l}', "");
Expect(0, 1114109, '\p{^Is_Bc=l}', "");
Expect(0, 1114109, '\P{Is_Bc=l}', "");
Expect(1, 1114109, '\P{^Is_Bc=l}', "");
Expect(0, 921599, '\p{Is_Bc=l}', "");
Expect(1, 921599, '\p{^Is_Bc=l}', "");
Expect(1, 921599, '\P{Is_Bc=l}', "");
Expect(0, 921599, '\P{^Is_Bc=l}', "");
Expect(1, 1114109, '\p{Is_Bc: 	L}', "");
Expect(0, 1114109, '\p{^Is_Bc: 	L}', "");
Expect(0, 1114109, '\P{Is_Bc: 	L}', "");
Expect(1, 1114109, '\P{^Is_Bc: 	L}', "");
Expect(0, 921599, '\p{Is_Bc: 	L}', "");
Expect(1, 921599, '\p{^Is_Bc: 	L}', "");
Expect(1, 921599, '\P{Is_Bc: 	L}', "");
Expect(0, 921599, '\P{^Is_Bc: 	L}', "");
Error('\p{Bidi_Class=:= -Left_to_Right_Embedding}');
Error('\P{Bidi_Class=:= -Left_to_Right_Embedding}');
Expect(1, 8234, '\p{Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\p{^Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\P{Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\P{^Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\p{Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\p{^Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\P{Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\P{^Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\p{Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(0, 8234, '\p{^Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(0, 8234, '\P{Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(1, 8234, '\P{^Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(0, 8235, '\p{Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(1, 8235, '\p{^Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(1, 8235, '\P{Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Expect(0, 8235, '\P{^Bidi_Class=_	left_To_RIGHT_EMBEDDING}', "");
Error('\p{Bc=:=- LRE}');
Error('\P{Bc=:=- LRE}');
Expect(1, 8234, '\p{Bc=lre}', "");
Expect(0, 8234, '\p{^Bc=lre}', "");
Expect(0, 8234, '\P{Bc=lre}', "");
Expect(1, 8234, '\P{^Bc=lre}', "");
Expect(0, 8235, '\p{Bc=lre}', "");
Expect(1, 8235, '\p{^Bc=lre}', "");
Expect(1, 8235, '\P{Bc=lre}', "");
Expect(0, 8235, '\P{^Bc=lre}', "");
Expect(1, 8234, '\p{Bc=	lre}', "");
Expect(0, 8234, '\p{^Bc=	lre}', "");
Expect(0, 8234, '\P{Bc=	lre}', "");
Expect(1, 8234, '\P{^Bc=	lre}', "");
Expect(0, 8235, '\p{Bc=	lre}', "");
Expect(1, 8235, '\p{^Bc=	lre}', "");
Expect(1, 8235, '\P{Bc=	lre}', "");
Expect(0, 8235, '\P{^Bc=	lre}', "");
Error('\p{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding/a/}');
Error('\P{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding/a/}');
Expect(1, 8234, '\p{Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8234, '\P{Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\p{Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\p{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8235, '\P{Is_Bidi_Class=lefttorightembedding}', "");
Expect(0, 8235, '\P{^Is_Bidi_Class=lefttorightembedding}', "");
Expect(1, 8234, '\p{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(0, 8234, '\p{^Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(0, 8234, '\P{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(1, 8234, '\P{^Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(0, 8235, '\p{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(1, 8235, '\p{^Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(1, 8235, '\P{Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Expect(0, 8235, '\P{^Is_Bidi_Class=- LEFT_To_RIGHT_Embedding}', "");
Error('\p{Is_Bc=/a/-	LRE}');
Error('\P{Is_Bc=/a/-	LRE}');
Expect(1, 8234, '\p{Is_Bc=lre}', "");
Expect(0, 8234, '\p{^Is_Bc=lre}', "");
Expect(0, 8234, '\P{Is_Bc=lre}', "");
Expect(1, 8234, '\P{^Is_Bc=lre}', "");
Expect(0, 8235, '\p{Is_Bc=lre}', "");
Expect(1, 8235, '\p{^Is_Bc=lre}', "");
Expect(1, 8235, '\P{Is_Bc=lre}', "");
Expect(0, 8235, '\P{^Is_Bc=lre}', "");
Expect(1, 8234, '\p{Is_Bc= LRE}', "");
Expect(0, 8234, '\p{^Is_Bc= LRE}', "");
Expect(0, 8234, '\P{Is_Bc= LRE}', "");
Expect(1, 8234, '\P{^Is_Bc= LRE}', "");
Expect(0, 8235, '\p{Is_Bc= LRE}', "");
Expect(1, 8235, '\p{^Is_Bc= LRE}', "");
Expect(1, 8235, '\P{Is_Bc= LRE}', "");
Expect(0, 8235, '\P{^Is_Bc= LRE}', "");
Error('\p{Bidi_Class=_:=LEFT_to_RIGHT_ISOLATE}');
Error('\P{Bidi_Class=_:=LEFT_to_RIGHT_ISOLATE}');
Expect(1, 8294, '\p{Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\p{^Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\P{Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\P{^Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\p{Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\p{^Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\P{Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\P{^Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\p{Bidi_Class= Left_to_Right_isolate}', "");
Expect(0, 8294, '\p{^Bidi_Class= Left_to_Right_isolate}', "");
Expect(0, 8294, '\P{Bidi_Class= Left_to_Right_isolate}', "");
Expect(1, 8294, '\P{^Bidi_Class= Left_to_Right_isolate}', "");
Expect(0, 8295, '\p{Bidi_Class= Left_to_Right_isolate}', "");
Expect(1, 8295, '\p{^Bidi_Class= Left_to_Right_isolate}', "");
Expect(1, 8295, '\P{Bidi_Class= Left_to_Right_isolate}', "");
Expect(0, 8295, '\P{^Bidi_Class= Left_to_Right_isolate}', "");
Error('\p{Bc=/a/ -lri}');
Error('\P{Bc=/a/ -lri}');
Expect(1, 8294, '\p{Bc=lri}', "");
Expect(0, 8294, '\p{^Bc=lri}', "");
Expect(0, 8294, '\P{Bc=lri}', "");
Expect(1, 8294, '\P{^Bc=lri}', "");
Expect(0, 8295, '\p{Bc=lri}', "");
Expect(1, 8295, '\p{^Bc=lri}', "");
Expect(1, 8295, '\P{Bc=lri}', "");
Expect(0, 8295, '\P{^Bc=lri}', "");
Expect(1, 8294, '\p{Bc=LRI}', "");
Expect(0, 8294, '\p{^Bc=LRI}', "");
Expect(0, 8294, '\P{Bc=LRI}', "");
Expect(1, 8294, '\P{^Bc=LRI}', "");
Expect(0, 8295, '\p{Bc=LRI}', "");
Expect(1, 8295, '\p{^Bc=LRI}', "");
Expect(1, 8295, '\P{Bc=LRI}', "");
Expect(0, 8295, '\P{^Bc=LRI}', "");
Error('\p{Is_Bidi_Class=:=-Left_TO_right_ISOLATE}');
Error('\P{Is_Bidi_Class=:=-Left_TO_right_ISOLATE}');
Expect(1, 8294, '\p{Is_Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
Expect(0, 8294, '\P{Is_Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\p{Is_Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\p{^Is_Bidi_Class=lefttorightisolate}', "");
Expect(1, 8295, '\P{Is_Bidi_Class=lefttorightisolate}', "");
Expect(0, 8295, '\P{^Is_Bidi_Class=lefttorightisolate}', "");
Expect(1, 8294, '\p{Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(0, 8294, '\p{^Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(0, 8294, '\P{Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(1, 8294, '\P{^Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(0, 8295, '\p{Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(1, 8295, '\p{^Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(1, 8295, '\P{Is_Bidi_Class= left_TO_Right_Isolate}', "");
Expect(0, 8295, '\P{^Is_Bidi_Class= left_TO_Right_Isolate}', "");
Error('\p{Is_Bc=	:=LRI}');
Error('\P{Is_Bc=	:=LRI}');
Expect(1, 8294, '\p{Is_Bc=lri}', "");
Expect(0, 8294, '\p{^Is_Bc=lri}', "");
Expect(0, 8294, '\P{Is_Bc=lri}', "");
Expect(1, 8294, '\P{^Is_Bc=lri}', "");
Expect(0, 8295, '\p{Is_Bc=lri}', "");
Expect(1, 8295, '\p{^Is_Bc=lri}', "");
Expect(1, 8295, '\P{Is_Bc=lri}', "");
Expect(0, 8295, '\P{^Is_Bc=lri}', "");
Expect(1, 8294, '\p{Is_Bc=	_lri}', "");
Expect(0, 8294, '\p{^Is_Bc=	_lri}', "");
Expect(0, 8294, '\P{Is_Bc=	_lri}', "");
Expect(1, 8294, '\P{^Is_Bc=	_lri}', "");
Expect(0, 8295, '\p{Is_Bc=	_lri}', "");
Expect(1, 8295, '\p{^Is_Bc=	_lri}', "");
Expect(1, 8295, '\P{Is_Bc=	_lri}', "");
Expect(0, 8295, '\P{^Is_Bc=	_lri}', "");
Error('\p{Bidi_Class=/a/-_Left_To_right_OVERRIDE}');
Error('\P{Bidi_Class=/a/-_Left_To_right_OVERRIDE}');
Expect(1, 8237, '\p{Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\p{^Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\P{Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\P{^Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\p{Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\p{^Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\P{Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\P{^Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\p{Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(0, 8237, '\p{^Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(0, 8237, '\P{Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(1, 8237, '\P{^Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(0, 8238, '\p{Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(1, 8238, '\p{^Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(1, 8238, '\P{Bidi_Class=left_TO_RIGHT_Override}', "");
Expect(0, 8238, '\P{^Bidi_Class=left_TO_RIGHT_Override}', "");
Error('\p{Bc=_/a/LRO}');
Error('\P{Bc=_/a/LRO}');
Expect(1, 8237, '\p{Bc=lro}', "");
Expect(0, 8237, '\p{^Bc=lro}', "");
Expect(0, 8237, '\P{Bc=lro}', "");
Expect(1, 8237, '\P{^Bc=lro}', "");
Expect(0, 8238, '\p{Bc=lro}', "");
Expect(1, 8238, '\p{^Bc=lro}', "");
Expect(1, 8238, '\P{Bc=lro}', "");
Expect(0, 8238, '\P{^Bc=lro}', "");
Expect(1, 8237, '\p{Bc=	_LRO}', "");
Expect(0, 8237, '\p{^Bc=	_LRO}', "");
Expect(0, 8237, '\P{Bc=	_LRO}', "");
Expect(1, 8237, '\P{^Bc=	_LRO}', "");
Expect(0, 8238, '\p{Bc=	_LRO}', "");
Expect(1, 8238, '\p{^Bc=	_LRO}', "");
Expect(1, 8238, '\P{Bc=	_LRO}', "");
Expect(0, 8238, '\P{^Bc=	_LRO}', "");
Error('\p{Is_Bidi_Class: /a/--Left_to_Right_Override}');
Error('\P{Is_Bidi_Class: /a/--Left_to_Right_Override}');
Expect(1, 8237, '\p{Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8237, '\P{Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\p{Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\p{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8238, '\P{Is_Bidi_Class=lefttorightoverride}', "");
Expect(0, 8238, '\P{^Is_Bidi_Class=lefttorightoverride}', "");
Expect(1, 8237, '\p{Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(0, 8237, '\p{^Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(0, 8237, '\P{Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(1, 8237, '\P{^Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(0, 8238, '\p{Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(1, 8238, '\p{^Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(1, 8238, '\P{Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Expect(0, 8238, '\P{^Is_Bidi_Class= LEFT_to_right_OVERRIDE}', "");
Error('\p{Is_Bc: -LRO/a/}');
Error('\P{Is_Bc: -LRO/a/}');
Expect(1, 8237, '\p{Is_Bc=lro}', "");
Expect(0, 8237, '\p{^Is_Bc=lro}', "");
Expect(0, 8237, '\P{Is_Bc=lro}', "");
Expect(1, 8237, '\P{^Is_Bc=lro}', "");
Expect(0, 8238, '\p{Is_Bc=lro}', "");
Expect(1, 8238, '\p{^Is_Bc=lro}', "");
Expect(1, 8238, '\P{Is_Bc=lro}', "");
Expect(0, 8238, '\P{^Is_Bc=lro}', "");
Expect(1, 8237, '\p{Is_Bc=	_LRO}', "");
Expect(0, 8237, '\p{^Is_Bc=	_LRO}', "");
Expect(0, 8237, '\P{Is_Bc=	_LRO}', "");
Expect(1, 8237, '\P{^Is_Bc=	_LRO}', "");
Expect(0, 8238, '\p{Is_Bc=	_LRO}', "");
Expect(1, 8238, '\p{^Is_Bc=	_LRO}', "");
Expect(1, 8238, '\P{Is_Bc=	_LRO}', "");
Expect(0, 8238, '\P{^Is_Bc=	_LRO}', "");
Error('\p{Bidi_Class=/a/ 	NONSPACING_Mark}');
Error('\P{Bidi_Class=/a/ 	NONSPACING_Mark}');
Expect(1, 917999, '\p{Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\p{^Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\P{Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\P{^Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\p{Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\p{^Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\P{Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\P{^Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\p{Bidi_Class=_nonspacing_mark}', "");
Expect(0, 917999, '\p{^Bidi_Class=_nonspacing_mark}', "");
Expect(0, 917999, '\P{Bidi_Class=_nonspacing_mark}', "");
Expect(1, 917999, '\P{^Bidi_Class=_nonspacing_mark}', "");
Expect(0, 918000, '\p{Bidi_Class=_nonspacing_mark}', "");
Expect(1, 918000, '\p{^Bidi_Class=_nonspacing_mark}', "");
Expect(1, 918000, '\P{Bidi_Class=_nonspacing_mark}', "");
Expect(0, 918000, '\P{^Bidi_Class=_nonspacing_mark}', "");
Error('\p{Bc=:=NSM}');
Error('\P{Bc=:=NSM}');
Expect(1, 917999, '\p{Bc:nsm}', "");
Expect(0, 917999, '\p{^Bc:nsm}', "");
Expect(0, 917999, '\P{Bc:nsm}', "");
Expect(1, 917999, '\P{^Bc:nsm}', "");
Expect(0, 918000, '\p{Bc:nsm}', "");
Expect(1, 918000, '\p{^Bc:nsm}', "");
Expect(1, 918000, '\P{Bc:nsm}', "");
Expect(0, 918000, '\P{^Bc:nsm}', "");
Expect(1, 917999, '\p{Bc=-NSM}', "");
Expect(0, 917999, '\p{^Bc=-NSM}', "");
Expect(0, 917999, '\P{Bc=-NSM}', "");
Expect(1, 917999, '\P{^Bc=-NSM}', "");
Expect(0, 918000, '\p{Bc=-NSM}', "");
Expect(1, 918000, '\p{^Bc=-NSM}', "");
Expect(1, 918000, '\P{Bc=-NSM}', "");
Expect(0, 918000, '\P{^Bc=-NSM}', "");
Error('\p{Is_Bidi_Class:		:=NONSPACING_MARK}');
Error('\P{Is_Bidi_Class:		:=NONSPACING_MARK}');
Expect(1, 917999, '\p{Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\p{^Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 917999, '\P{Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\P{^Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\p{Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\p{^Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 918000, '\P{Is_Bidi_Class=nonspacingmark}', "");
Expect(0, 918000, '\P{^Is_Bidi_Class=nonspacingmark}', "");
Expect(1, 917999, '\p{Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(0, 917999, '\p{^Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(0, 917999, '\P{Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(1, 917999, '\P{^Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(0, 918000, '\p{Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(1, 918000, '\p{^Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(1, 918000, '\P{Is_Bidi_Class=_	Nonspacing_Mark}', "");
Expect(0, 918000, '\P{^Is_Bidi_Class=_	Nonspacing_Mark}', "");
Error('\p{Is_Bc=:=	NSM}');
Error('\P{Is_Bc=:=	NSM}');
Expect(1, 917999, '\p{Is_Bc=nsm}', "");
Expect(0, 917999, '\p{^Is_Bc=nsm}', "");
Expect(0, 917999, '\P{Is_Bc=nsm}', "");
Expect(1, 917999, '\P{^Is_Bc=nsm}', "");
Expect(0, 918000, '\p{Is_Bc=nsm}', "");
Expect(1, 918000, '\p{^Is_Bc=nsm}', "");
Expect(1, 918000, '\P{Is_Bc=nsm}', "");
Expect(0, 918000, '\P{^Is_Bc=nsm}', "");
Expect(1, 917999, '\p{Is_Bc=-_NSM}', "");
Expect(0, 917999, '\p{^Is_Bc=-_NSM}', "");
Expect(0, 917999, '\P{Is_Bc=-_NSM}', "");
Expect(1, 917999, '\P{^Is_Bc=-_NSM}', "");
Expect(0, 918000, '\p{Is_Bc=-_NSM}', "");
Expect(1, 918000, '\p{^Is_Bc=-_NSM}', "");
Expect(1, 918000, '\P{Is_Bc=-_NSM}', "");
Expect(0, 918000, '\P{^Is_Bc=-_NSM}', "");
Error('\p{Bidi_Class=	/a/OTHER_Neutral}');
Error('\P{Bidi_Class=	/a/OTHER_Neutral}');
Expect(1, 129197, '\p{Bidi_Class=otherneutral}', "");
Expect(0, 129197, '\p{^Bidi_Class=otherneutral}', "");
Expect(0, 129197, '\P{Bidi_Class=otherneutral}', "");
Expect(1, 129197, '\P{^Bidi_Class=otherneutral}', "");
Expect(0, 129198, '\p{Bidi_Class=otherneutral}', "");
Expect(1, 129198, '\p{^Bidi_Class=otherneutral}', "");
Expect(1, 129198, '\P{Bidi_Class=otherneutral}', "");
Expect(0, 129198, '\P{^Bidi_Class=otherneutral}', "");
Expect(1, 129197, '\p{Bidi_Class= other_Neutral}', "");
Expect(0, 129197, '\p{^Bidi_Class= other_Neutral}', "");
Expect(0, 129197, '\P{Bidi_Class= other_Neutral}', "");
Expect(1, 129197, '\P{^Bidi_Class= other_Neutral}', "");
Expect(0, 129198, '\p{Bidi_Class= other_Neutral}', "");
Expect(1, 129198, '\p{^Bidi_Class= other_Neutral}', "");
Expect(1, 129198, '\P{Bidi_Class= other_Neutral}', "");
Expect(0, 129198, '\P{^Bidi_Class= other_Neutral}', "");
Error('\p{Bc=-:=ON}');
Error('\P{Bc=-:=ON}');
Expect(1, 129197, '\p{Bc=on}', "");
Expect(0, 129197, '\p{^Bc=on}', "");
Expect(0, 129197, '\P{Bc=on}', "");
Expect(1, 129197, '\P{^Bc=on}', "");
Expect(0, 129198, '\p{Bc=on}', "");
Expect(1, 129198, '\p{^Bc=on}', "");
Expect(1, 129198, '\P{Bc=on}', "");
Expect(0, 129198, '\P{^Bc=on}', "");
Expect(1, 129197, '\p{Bc=		ON}', "");
Expect(0, 129197, '\p{^Bc=		ON}', "");
Expect(0, 129197, '\P{Bc=		ON}', "");
Expect(1, 129197, '\P{^Bc=		ON}', "");
Expect(0, 129198, '\p{Bc=		ON}', "");
Expect(1, 129198, '\p{^Bc=		ON}', "");
Expect(1, 129198, '\P{Bc=		ON}', "");
Expect(0, 129198, '\P{^Bc=		ON}', "");
Error('\p{Is_Bidi_Class=/a/	OTHER_Neutral}');
Error('\P{Is_Bidi_Class=/a/	OTHER_Neutral}');
Expect(1, 129197, '\p{Is_Bidi_Class=otherneutral}', "");
Expect(0, 129197, '\p{^Is_Bidi_Class=otherneutral}', "");
Expect(0, 129197, '\P{Is_Bidi_Class=otherneutral}', "");
Expect(1, 129197, '\P{^Is_Bidi_Class=otherneutral}', "");
Expect(0, 129198, '\p{Is_Bidi_Class=otherneutral}', "");
Expect(1, 129198, '\p{^Is_Bidi_Class=otherneutral}', "");
Expect(1, 129198, '\P{Is_Bidi_Class=otherneutral}', "");
Expect(0, 129198, '\P{^Is_Bidi_Class=otherneutral}', "");
Expect(1, 129197, '\p{Is_Bidi_Class:   _-other_Neutral}', "");
Expect(0, 129197, '\p{^Is_Bidi_Class:   _-other_Neutral}', "");
Expect(0, 129197, '\P{Is_Bidi_Class:   _-other_Neutral}', "");
Expect(1, 129197, '\P{^Is_Bidi_Class:   _-other_Neutral}', "");
Expect(0, 129198, '\p{Is_Bidi_Class:   _-other_Neutral}', "");
Expect(1, 129198, '\p{^Is_Bidi_Class:   _-other_Neutral}', "");
Expect(1, 129198, '\P{Is_Bidi_Class:   _-other_Neutral}', "");
Expect(0, 129198, '\P{^Is_Bidi_Class:   _-other_Neutral}', "");
Error('\p{Is_Bc=__ON/a/}');
Error('\P{Is_Bc=__ON/a/}');
Expect(1, 129197, '\p{Is_Bc=on}', "");
Expect(0, 129197, '\p{^Is_Bc=on}', "");
Expect(0, 129197, '\P{Is_Bc=on}', "");
Expect(1, 129197, '\P{^Is_Bc=on}', "");
Expect(0, 129198, '\p{Is_Bc=on}', "");
Expect(1, 129198, '\p{^Is_Bc=on}', "");
Expect(1, 129198, '\P{Is_Bc=on}', "");
Expect(0, 129198, '\P{^Is_Bc=on}', "");
Expect(1, 129197, '\p{Is_Bc= -ON}', "");
Expect(0, 129197, '\p{^Is_Bc= -ON}', "");
Expect(0, 129197, '\P{Is_Bc= -ON}', "");
Expect(1, 129197, '\P{^Is_Bc= -ON}', "");
Expect(0, 129198, '\p{Is_Bc= -ON}', "");
Expect(1, 129198, '\p{^Is_Bc= -ON}', "");
Expect(1, 129198, '\P{Is_Bc= -ON}', "");
Expect(0, 129198, '\P{^Is_Bc= -ON}', "");
Error('\p{Bidi_Class=/a/pop_Directional_format}');
Error('\P{Bidi_Class=/a/pop_Directional_format}');
Expect(1, 8236, '\p{Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\p{^Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\P{Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\P{^Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\p{Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\p{^Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\P{Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\P{^Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\p{Bidi_Class=	_Pop_Directional_format}', "");
Expect(0, 8236, '\p{^Bidi_Class=	_Pop_Directional_format}', "");
Expect(0, 8236, '\P{Bidi_Class=	_Pop_Directional_format}', "");
Expect(1, 8236, '\P{^Bidi_Class=	_Pop_Directional_format}', "");
Expect(0, 8237, '\p{Bidi_Class=	_Pop_Directional_format}', "");
Expect(1, 8237, '\p{^Bidi_Class=	_Pop_Directional_format}', "");
Expect(1, 8237, '\P{Bidi_Class=	_Pop_Directional_format}', "");
Expect(0, 8237, '\P{^Bidi_Class=	_Pop_Directional_format}', "");
Error('\p{Bc=:=PDF}');
Error('\P{Bc=:=PDF}');
Expect(1, 8236, '\p{Bc=pdf}', "");
Expect(0, 8236, '\p{^Bc=pdf}', "");
Expect(0, 8236, '\P{Bc=pdf}', "");
Expect(1, 8236, '\P{^Bc=pdf}', "");
Expect(0, 8237, '\p{Bc=pdf}', "");
Expect(1, 8237, '\p{^Bc=pdf}', "");
Expect(1, 8237, '\P{Bc=pdf}', "");
Expect(0, 8237, '\P{^Bc=pdf}', "");
Expect(1, 8236, '\p{Bc=_PDF}', "");
Expect(0, 8236, '\p{^Bc=_PDF}', "");
Expect(0, 8236, '\P{Bc=_PDF}', "");
Expect(1, 8236, '\P{^Bc=_PDF}', "");
Expect(0, 8237, '\p{Bc=_PDF}', "");
Expect(1, 8237, '\p{^Bc=_PDF}', "");
Expect(1, 8237, '\P{Bc=_PDF}', "");
Expect(0, 8237, '\P{^Bc=_PDF}', "");
Error('\p{Is_Bidi_Class=_	POP_Directional_format:=}');
Error('\P{Is_Bidi_Class=_	POP_Directional_format:=}');
Expect(1, 8236, '\p{Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8236, '\P{Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\p{Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\p{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8237, '\P{Is_Bidi_Class=popdirectionalformat}', "");
Expect(0, 8237, '\P{^Is_Bidi_Class=popdirectionalformat}', "");
Expect(1, 8236, '\p{Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(0, 8236, '\p{^Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(0, 8236, '\P{Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(1, 8236, '\P{^Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(0, 8237, '\p{Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(1, 8237, '\p{^Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(1, 8237, '\P{Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Expect(0, 8237, '\P{^Is_Bidi_Class:   _	Pop_DIRECTIONAL_format}', "");
Error('\p{Is_Bc=:=  pdf}');
Error('\P{Is_Bc=:=  pdf}');
Expect(1, 8236, '\p{Is_Bc=pdf}', "");
Expect(0, 8236, '\p{^Is_Bc=pdf}', "");
Expect(0, 8236, '\P{Is_Bc=pdf}', "");
Expect(1, 8236, '\P{^Is_Bc=pdf}', "");
Expect(0, 8237, '\p{Is_Bc=pdf}', "");
Expect(1, 8237, '\p{^Is_Bc=pdf}', "");
Expect(1, 8237, '\P{Is_Bc=pdf}', "");
Expect(0, 8237, '\P{^Is_Bc=pdf}', "");
Expect(1, 8236, '\p{Is_Bc=	PDF}', "");
Expect(0, 8236, '\p{^Is_Bc=	PDF}', "");
Expect(0, 8236, '\P{Is_Bc=	PDF}', "");
Expect(1, 8236, '\P{^Is_Bc=	PDF}', "");
Expect(0, 8237, '\p{Is_Bc=	PDF}', "");
Expect(1, 8237, '\p{^Is_Bc=	PDF}', "");
Expect(1, 8237, '\P{Is_Bc=	PDF}', "");
Expect(0, 8237, '\P{^Is_Bc=	PDF}', "");
Error('\p{Bidi_Class=/a/- POP_DIRECTIONAL_ISOLATE}');
Error('\P{Bidi_Class=/a/- POP_DIRECTIONAL_ISOLATE}');
Expect(1, 8297, '\p{Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\p{^Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\P{Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\P{^Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\p{Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\p{^Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\P{Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\P{^Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\p{Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(0, 8297, '\p{^Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(0, 8297, '\P{Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(1, 8297, '\P{^Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(0, 8298, '\p{Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(1, 8298, '\p{^Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(1, 8298, '\P{Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Expect(0, 8298, '\P{^Bidi_Class= POP_DIRECTIONAL_ISOLATE}', "");
Error('\p{Bc=	PDI/a/}');
Error('\P{Bc=	PDI/a/}');
Expect(1, 8297, '\p{Bc=pdi}', "");
Expect(0, 8297, '\p{^Bc=pdi}', "");
Expect(0, 8297, '\P{Bc=pdi}', "");
Expect(1, 8297, '\P{^Bc=pdi}', "");
Expect(0, 8298, '\p{Bc=pdi}', "");
Expect(1, 8298, '\p{^Bc=pdi}', "");
Expect(1, 8298, '\P{Bc=pdi}', "");
Expect(0, 8298, '\P{^Bc=pdi}', "");
Expect(1, 8297, '\p{Bc=-_PDI}', "");
Expect(0, 8297, '\p{^Bc=-_PDI}', "");
Expect(0, 8297, '\P{Bc=-_PDI}', "");
Expect(1, 8297, '\P{^Bc=-_PDI}', "");
Expect(0, 8298, '\p{Bc=-_PDI}', "");
Expect(1, 8298, '\p{^Bc=-_PDI}', "");
Expect(1, 8298, '\P{Bc=-_PDI}', "");
Expect(0, 8298, '\P{^Bc=-_PDI}', "");
Error('\p{Is_Bidi_Class=:=__POP_directional_Isolate}');
Error('\P{Is_Bidi_Class=:=__POP_directional_Isolate}');
Expect(1, 8297, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8297, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\p{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\p{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8298, '\P{Is_Bidi_Class=popdirectionalisolate}', "");
Expect(0, 8298, '\P{^Is_Bidi_Class=popdirectionalisolate}', "");
Expect(1, 8297, '\p{Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(0, 8297, '\p{^Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(0, 8297, '\P{Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(1, 8297, '\P{^Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(0, 8298, '\p{Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(1, 8298, '\p{^Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(1, 8298, '\P{Is_Bidi_Class:pop_Directional_Isolate}', "");
Expect(0, 8298, '\P{^Is_Bidi_Class:pop_Directional_Isolate}', "");
Error('\p{Is_Bc=-	PDI/a/}');
Error('\P{Is_Bc=-	PDI/a/}');
Expect(1, 8297, '\p{Is_Bc=pdi}', "");
Expect(0, 8297, '\p{^Is_Bc=pdi}', "");
Expect(0, 8297, '\P{Is_Bc=pdi}', "");
Expect(1, 8297, '\P{^Is_Bc=pdi}', "");
Expect(0, 8298, '\p{Is_Bc=pdi}', "");
Expect(1, 8298, '\p{^Is_Bc=pdi}', "");
Expect(1, 8298, '\P{Is_Bc=pdi}', "");
Expect(0, 8298, '\P{^Is_Bc=pdi}', "");
Expect(1, 8297, '\p{Is_Bc=_-PDI}', "");
Expect(0, 8297, '\p{^Is_Bc=_-PDI}', "");
Expect(0, 8297, '\P{Is_Bc=_-PDI}', "");
Expect(1, 8297, '\P{^Is_Bc=_-PDI}', "");
Expect(0, 8298, '\p{Is_Bc=_-PDI}', "");
Expect(1, 8298, '\p{^Is_Bc=_-PDI}', "");
Expect(1, 8298, '\P{Is_Bc=_-PDI}', "");
Expect(0, 8298, '\P{^Is_Bc=_-PDI}', "");
Error('\p{Bidi_Class=:=-_Right_To_left}');
Error('\P{Bidi_Class=:=-_Right_To_left}');
Expect(1, 126975, '\p{Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\p{^Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\P{Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\P{^Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\p{Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\p{^Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\P{Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\P{^Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\p{Bidi_Class=-right_to_Left}', "");
Expect(0, 126975, '\p{^Bidi_Class=-right_to_Left}', "");
Expect(0, 126975, '\P{Bidi_Class=-right_to_Left}', "");
Expect(1, 126975, '\P{^Bidi_Class=-right_to_Left}', "");
Expect(0, 126976, '\p{Bidi_Class=-right_to_Left}', "");
Expect(1, 126976, '\p{^Bidi_Class=-right_to_Left}', "");
Expect(1, 126976, '\P{Bidi_Class=-right_to_Left}', "");
Expect(0, 126976, '\P{^Bidi_Class=-right_to_Left}', "");
Error('\p{Bc=	:=R}');
Error('\P{Bc=	:=R}');
Expect(1, 126975, '\p{Bc=r}', "");
Expect(0, 126975, '\p{^Bc=r}', "");
Expect(0, 126975, '\P{Bc=r}', "");
Expect(1, 126975, '\P{^Bc=r}', "");
Expect(0, 126976, '\p{Bc=r}', "");
Expect(1, 126976, '\p{^Bc=r}', "");
Expect(1, 126976, '\P{Bc=r}', "");
Expect(0, 126976, '\P{^Bc=r}', "");
Expect(1, 126975, '\p{Bc:   _-R}', "");
Expect(0, 126975, '\p{^Bc:   _-R}', "");
Expect(0, 126975, '\P{Bc:   _-R}', "");
Expect(1, 126975, '\P{^Bc:   _-R}', "");
Expect(0, 126976, '\p{Bc:   _-R}', "");
Expect(1, 126976, '\p{^Bc:   _-R}', "");
Expect(1, 126976, '\P{Bc:   _-R}', "");
Expect(0, 126976, '\P{^Bc:   _-R}', "");
Error('\p{Is_Bidi_Class=	_Right_to_Left/a/}');
Error('\P{Is_Bidi_Class=	_Right_to_Left/a/}');
Expect(1, 126975, '\p{Is_Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\p{^Is_Bidi_Class=righttoleft}', "");
Expect(0, 126975, '\P{Is_Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\P{^Is_Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\p{Is_Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\p{^Is_Bidi_Class=righttoleft}', "");
Expect(1, 126976, '\P{Is_Bidi_Class=righttoleft}', "");
Expect(0, 126976, '\P{^Is_Bidi_Class=righttoleft}', "");
Expect(1, 126975, '\p{Is_Bidi_Class=-right_To_LEFT}', "");
Expect(0, 126975, '\p{^Is_Bidi_Class=-right_To_LEFT}', "");
Expect(0, 126975, '\P{Is_Bidi_Class=-right_To_LEFT}', "");
Expect(1, 126975, '\P{^Is_Bidi_Class=-right_To_LEFT}', "");
Expect(0, 126976, '\p{Is_Bidi_Class=-right_To_LEFT}', "");
Expect(1, 126976, '\p{^Is_Bidi_Class=-right_To_LEFT}', "");
Expect(1, 126976, '\P{Is_Bidi_Class=-right_To_LEFT}', "");
Expect(0, 126976, '\P{^Is_Bidi_Class=-right_To_LEFT}', "");
Error('\p{Is_Bc=-:=R}');
Error('\P{Is_Bc=-:=R}');
Expect(1, 126975, '\p{Is_Bc=r}', "");
Expect(0, 126975, '\p{^Is_Bc=r}', "");
Expect(0, 126975, '\P{Is_Bc=r}', "");
Expect(1, 126975, '\P{^Is_Bc=r}', "");
Expect(0, 126976, '\p{Is_Bc=r}', "");
Expect(1, 126976, '\p{^Is_Bc=r}', "");
Expect(1, 126976, '\P{Is_Bc=r}', "");
Expect(0, 126976, '\P{^Is_Bc=r}', "");
Expect(1, 126975, '\p{Is_Bc:	 _R}', "");
Expect(0, 126975, '\p{^Is_Bc:	 _R}', "");
Expect(0, 126975, '\P{Is_Bc:	 _R}', "");
Expect(1, 126975, '\P{^Is_Bc:	 _R}', "");
Expect(0, 126976, '\p{Is_Bc:	 _R}', "");
Expect(1, 126976, '\p{^Is_Bc:	 _R}', "");
Expect(1, 126976, '\P{Is_Bc:	 _R}', "");
Expect(0, 126976, '\P{^Is_Bc:	 _R}', "");
Error('\p{Bidi_Class=-/a/right_to_LEFT_Embedding}');
Error('\P{Bidi_Class=-/a/right_to_LEFT_Embedding}');
Expect(1, 8235, '\p{Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\p{^Bidi_Class=righttoleftembedding}', "");
Expect(0, 8235, '\P{Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\P{^Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\p{Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\p{^Bidi_Class=righttoleftembedding}', "");
Expect(1, 8236, '\P{Bidi_Class=righttoleftembedding}', "");
Expect(0, 8236, '\P{^Bidi_Class=righttoleftembedding}', "");
Expect(1, 8235, '\p{Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(0, 8235, '\p{^Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(0, 8235, '\P{Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(1, 8235, '\P{^Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(0, 8236, '\p{Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(1, 8236, '\p{^Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(1, 8236, '\P{Bidi_Class=	Right_TO_LEFT_embedding}', "");
Expect(0, 8236, '\P{^Bidi_Class=	Right_TO_LEFT_embedding}', "");
Error('\p{Bc: _-RLE:=}');
Error('\P{Bc: _-RLE:=}');
Expect(1, 8235, '\p{Bc=rle}', "");
Expect(0, 8235, '\p{^Bc=rle}', "");
Expect(0, 8235, '\P{Bc=rle}', "");
Expect(1, 8235, '\P{^Bc=rle}', "");
Expect(0, 8236, '\p{Bc=rle}', "");
Expect(1, 8236, '\p{^Bc=rle}', "");
Expect(1, 8236, '\P{Bc=rle}', "");
Expect(0, 8236, '\P{^Bc=rle}', "");
Expect(1, 8235, '\p{Bc=-	RLE}', "");
Expect(0, 8235, '\p{^Bc=-	RLE}', "");
Expect(0, 8235, '\P{Bc=-	RLE}', "");
Expect(1, 8235, '\P{^Bc=-	RLE}', "");
Expect(0, 8236, '\p{Bc=-	RLE}', "");
Expect(1, 8236, '\p{^Bc=-	RLE}', "");
Expect(1, 8236, '\P{Bc=-	RLE}', "");
Expect(0, 8236, '\P{^Bc=-	RLE}', "");
Error('\p{Is_Bidi_Class=/a/ Right_to_Left_embedding}');
Error('\P{Is_Bidi_Class=/a/ Right_to_Left_embedding}');
Expect(1, 8235, '\p{Is_Bidi_Class: righttoleftembedding}', "");
Expect(0, 8235, '\p{^Is_Bidi_Class: righttoleftembedding}', "");
Expect(0, 8235, '\P{Is_Bidi_Class: righttoleftembedding}', "");
Expect(1, 8235, '\P{^Is_Bidi_Class: righttoleftembedding}', "");
Expect(0, 8236, '\p{Is_Bidi_Class: righttoleftembedding}', "");
Expect(1, 8236, '\p{^Is_Bidi_Class: righttoleftembedding}', "");
Expect(1, 8236, '\P{Is_Bidi_Class: righttoleftembedding}', "");
Expect(0, 8236, '\P{^Is_Bidi_Class: righttoleftembedding}', "");
Expect(1, 8235, '\p{Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(0, 8235, '\p{^Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(0, 8235, '\P{Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(1, 8235, '\P{^Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(0, 8236, '\p{Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(1, 8236, '\p{^Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(1, 8236, '\P{Is_Bidi_Class=--right_To_left_Embedding}', "");
Expect(0, 8236, '\P{^Is_Bidi_Class=--right_To_left_Embedding}', "");
Error('\p{Is_Bc=:=	RLE}');
Error('\P{Is_Bc=:=	RLE}');
Expect(1, 8235, '\p{Is_Bc=rle}', "");
Expect(0, 8235, '\p{^Is_Bc=rle}', "");
Expect(0, 8235, '\P{Is_Bc=rle}', "");
Expect(1, 8235, '\P{^Is_Bc=rle}', "");
Expect(0, 8236, '\p{Is_Bc=rle}', "");
Expect(1, 8236, '\p{^Is_Bc=rle}', "");
Expect(1, 8236, '\P{Is_Bc=rle}', "");
Expect(0, 8236, '\P{^Is_Bc=rle}', "");
Expect(1, 8235, '\p{Is_Bc= _RLE}', "");
Expect(0, 8235, '\p{^Is_Bc= _RLE}', "");
Expect(0, 8235, '\P{Is_Bc= _RLE}', "");
Expect(1, 8235, '\P{^Is_Bc= _RLE}', "");
Expect(0, 8236, '\p{Is_Bc= _RLE}', "");
Expect(1, 8236, '\p{^Is_Bc= _RLE}', "");
Expect(1, 8236, '\P{Is_Bc= _RLE}', "");
Expect(0, 8236, '\P{^Is_Bc= _RLE}', "");
Error('\p{Bidi_Class:   -	right_to_left_Isolate/a/}');
Error('\P{Bidi_Class:   -	right_to_left_Isolate/a/}');
Expect(1, 8295, '\p{Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\p{^Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\P{Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\P{^Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\p{Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\p{^Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\P{Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\P{^Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\p{Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(0, 8295, '\p{^Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(0, 8295, '\P{Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(1, 8295, '\P{^Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(0, 8296, '\p{Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(1, 8296, '\p{^Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(1, 8296, '\P{Bidi_Class=--Right_To_LEFT_isolate}', "");
Expect(0, 8296, '\P{^Bidi_Class=--Right_To_LEFT_isolate}', "");
Error('\p{Bc=-/a/RLI}');
Error('\P{Bc=-/a/RLI}');
Expect(1, 8295, '\p{Bc=rli}', "");
Expect(0, 8295, '\p{^Bc=rli}', "");
Expect(0, 8295, '\P{Bc=rli}', "");
Expect(1, 8295, '\P{^Bc=rli}', "");
Expect(0, 8296, '\p{Bc=rli}', "");
Expect(1, 8296, '\p{^Bc=rli}', "");
Expect(1, 8296, '\P{Bc=rli}', "");
Expect(0, 8296, '\P{^Bc=rli}', "");
Expect(1, 8295, '\p{Bc=--RLI}', "");
Expect(0, 8295, '\p{^Bc=--RLI}', "");
Expect(0, 8295, '\P{Bc=--RLI}', "");
Expect(1, 8295, '\P{^Bc=--RLI}', "");
Expect(0, 8296, '\p{Bc=--RLI}', "");
Expect(1, 8296, '\p{^Bc=--RLI}', "");
Expect(1, 8296, '\P{Bc=--RLI}', "");
Expect(0, 8296, '\P{^Bc=--RLI}', "");
Error('\p{Is_Bidi_Class:  :=right_To_left_isolate}');
Error('\P{Is_Bidi_Class:  :=right_To_left_isolate}');
Expect(1, 8295, '\p{Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8295, '\P{Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\p{Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\p{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8296, '\P{Is_Bidi_Class=righttoleftisolate}', "");
Expect(0, 8296, '\P{^Is_Bidi_Class=righttoleftisolate}', "");
Expect(1, 8295, '\p{Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(0, 8295, '\p{^Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(0, 8295, '\P{Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(1, 8295, '\P{^Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(0, 8296, '\p{Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(1, 8296, '\p{^Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(1, 8296, '\P{Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Expect(0, 8296, '\P{^Is_Bidi_Class= -right_To_left_ISOLATE}', "");
Error('\p{Is_Bc=	RLI:=}');
Error('\P{Is_Bc=	RLI:=}');
Expect(1, 8295, '\p{Is_Bc: rli}', "");
Expect(0, 8295, '\p{^Is_Bc: rli}', "");
Expect(0, 8295, '\P{Is_Bc: rli}', "");
Expect(1, 8295, '\P{^Is_Bc: rli}', "");
Expect(0, 8296, '\p{Is_Bc: rli}', "");
Expect(1, 8296, '\p{^Is_Bc: rli}', "");
Expect(1, 8296, '\P{Is_Bc: rli}', "");
Expect(0, 8296, '\P{^Is_Bc: rli}', "");
Expect(1, 8295, '\p{Is_Bc=	RLI}', "");
Expect(0, 8295, '\p{^Is_Bc=	RLI}', "");
Expect(0, 8295, '\P{Is_Bc=	RLI}', "");
Expect(1, 8295, '\P{^Is_Bc=	RLI}', "");
Expect(0, 8296, '\p{Is_Bc=	RLI}', "");
Expect(1, 8296, '\p{^Is_Bc=	RLI}', "");
Expect(1, 8296, '\P{Is_Bc=	RLI}', "");
Expect(0, 8296, '\P{^Is_Bc=	RLI}', "");
Error('\p{Bidi_Class=:=-Right_to_Left_OVERRIDE}');
Error('\P{Bidi_Class=:=-Right_to_Left_OVERRIDE}');
Expect(1, 8238, '\p{Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\p{^Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\P{Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\P{^Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\p{Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\p{^Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\P{Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\P{^Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\p{Bidi_Class=--Right_To_Left_override}', "");
Expect(0, 8238, '\p{^Bidi_Class=--Right_To_Left_override}', "");
Expect(0, 8238, '\P{Bidi_Class=--Right_To_Left_override}', "");
Expect(1, 8238, '\P{^Bidi_Class=--Right_To_Left_override}', "");
Expect(0, 8239, '\p{Bidi_Class=--Right_To_Left_override}', "");
Expect(1, 8239, '\p{^Bidi_Class=--Right_To_Left_override}', "");
Expect(1, 8239, '\P{Bidi_Class=--Right_To_Left_override}', "");
Expect(0, 8239, '\P{^Bidi_Class=--Right_To_Left_override}', "");
Error('\p{Bc=	RLO:=}');
Error('\P{Bc=	RLO:=}');
Expect(1, 8238, '\p{Bc=rlo}', "");
Expect(0, 8238, '\p{^Bc=rlo}', "");
Expect(0, 8238, '\P{Bc=rlo}', "");
Expect(1, 8238, '\P{^Bc=rlo}', "");
Expect(0, 8239, '\p{Bc=rlo}', "");
Expect(1, 8239, '\p{^Bc=rlo}', "");
Expect(1, 8239, '\P{Bc=rlo}', "");
Expect(0, 8239, '\P{^Bc=rlo}', "");
Expect(1, 8238, '\p{Bc=_ RLO}', "");
Expect(0, 8238, '\p{^Bc=_ RLO}', "");
Expect(0, 8238, '\P{Bc=_ RLO}', "");
Expect(1, 8238, '\P{^Bc=_ RLO}', "");
Expect(0, 8239, '\p{Bc=_ RLO}', "");
Expect(1, 8239, '\p{^Bc=_ RLO}', "");
Expect(1, 8239, '\P{Bc=_ RLO}', "");
Expect(0, 8239, '\P{^Bc=_ RLO}', "");
Error('\p{Is_Bidi_Class=/a/	-RIGHT_TO_Left_Override}');
Error('\P{Is_Bidi_Class=/a/	-RIGHT_TO_Left_Override}');
Expect(1, 8238, '\p{Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8238, '\P{Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\p{Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\p{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8239, '\P{Is_Bidi_Class=righttoleftoverride}', "");
Expect(0, 8239, '\P{^Is_Bidi_Class=righttoleftoverride}', "");
Expect(1, 8238, '\p{Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(0, 8238, '\p{^Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(0, 8238, '\P{Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(1, 8238, '\P{^Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(0, 8239, '\p{Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(1, 8239, '\p{^Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(1, 8239, '\P{Is_Bidi_Class= Right_TO_Left_override}', "");
Expect(0, 8239, '\P{^Is_Bidi_Class= Right_TO_Left_override}', "");
Error('\p{Is_Bc:    /a/RLO}');
Error('\P{Is_Bc:    /a/RLO}');
Expect(1, 8238, '\p{Is_Bc=rlo}', "");
Expect(0, 8238, '\p{^Is_Bc=rlo}', "");
Expect(0, 8238, '\P{Is_Bc=rlo}', "");
Expect(1, 8238, '\P{^Is_Bc=rlo}', "");
Expect(0, 8239, '\p{Is_Bc=rlo}', "");
Expect(1, 8239, '\p{^Is_Bc=rlo}', "");
Expect(1, 8239, '\P{Is_Bc=rlo}', "");
Expect(0, 8239, '\P{^Is_Bc=rlo}', "");
Expect(1, 8238, '\p{Is_Bc=- rlo}', "");
Expect(0, 8238, '\p{^Is_Bc=- rlo}', "");
Expect(0, 8238, '\P{Is_Bc=- rlo}', "");
Expect(1, 8238, '\P{^Is_Bc=- rlo}', "");
Expect(0, 8239, '\p{Is_Bc=- rlo}', "");
Expect(1, 8239, '\p{^Is_Bc=- rlo}', "");
Expect(1, 8239, '\P{Is_Bc=- rlo}', "");
Expect(0, 8239, '\P{^Is_Bc=- rlo}', "");
Error('\p{Bidi_Class=:= Segment_separator}');
Error('\P{Bidi_Class=:= Segment_separator}');
Expect(1, 31, '\p{Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\p{^Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\P{Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\P{^Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\p{Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\p{^Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\P{Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\P{^Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\p{Bidi_Class=		Segment_Separator}', "");
Expect(0, 31, '\p{^Bidi_Class=		Segment_Separator}', "");
Expect(0, 31, '\P{Bidi_Class=		Segment_Separator}', "");
Expect(1, 31, '\P{^Bidi_Class=		Segment_Separator}', "");
Expect(0, 32, '\p{Bidi_Class=		Segment_Separator}', "");
Expect(1, 32, '\p{^Bidi_Class=		Segment_Separator}', "");
Expect(1, 32, '\P{Bidi_Class=		Segment_Separator}', "");
Expect(0, 32, '\P{^Bidi_Class=		Segment_Separator}', "");
Error('\p{Bc=- S:=}');
Error('\P{Bc=- S:=}');
Expect(1, 31, '\p{Bc=s}', "");
Expect(0, 31, '\p{^Bc=s}', "");
Expect(0, 31, '\P{Bc=s}', "");
Expect(1, 31, '\P{^Bc=s}', "");
Expect(0, 32, '\p{Bc=s}', "");
Expect(1, 32, '\p{^Bc=s}', "");
Expect(1, 32, '\P{Bc=s}', "");
Expect(0, 32, '\P{^Bc=s}', "");
Expect(1, 31, '\p{Bc=_S}', "");
Expect(0, 31, '\p{^Bc=_S}', "");
Expect(0, 31, '\P{Bc=_S}', "");
Expect(1, 31, '\P{^Bc=_S}', "");
Expect(0, 32, '\p{Bc=_S}', "");
Expect(1, 32, '\p{^Bc=_S}', "");
Expect(1, 32, '\P{Bc=_S}', "");
Expect(0, 32, '\P{^Bc=_S}', "");
Error('\p{Is_Bidi_Class:/a/	segment_separator}');
Error('\P{Is_Bidi_Class:/a/	segment_separator}');
Expect(1, 31, '\p{Is_Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\p{^Is_Bidi_Class=segmentseparator}', "");
Expect(0, 31, '\P{Is_Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\P{^Is_Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\p{Is_Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\p{^Is_Bidi_Class=segmentseparator}', "");
Expect(1, 32, '\P{Is_Bidi_Class=segmentseparator}', "");
Expect(0, 32, '\P{^Is_Bidi_Class=segmentseparator}', "");
Expect(1, 31, '\p{Is_Bidi_Class=	segment_Separator}', "");
Expect(0, 31, '\p{^Is_Bidi_Class=	segment_Separator}', "");
Expect(0, 31, '\P{Is_Bidi_Class=	segment_Separator}', "");
Expect(1, 31, '\P{^Is_Bidi_Class=	segment_Separator}', "");
Expect(0, 32, '\p{Is_Bidi_Class=	segment_Separator}', "");
Expect(1, 32, '\p{^Is_Bidi_Class=	segment_Separator}', "");
Expect(1, 32, '\P{Is_Bidi_Class=	segment_Separator}', "");
Expect(0, 32, '\P{^Is_Bidi_Class=	segment_Separator}', "");
Error('\p{Is_Bc=_s/a/}');
Error('\P{Is_Bc=_s/a/}');
Expect(1, 31, '\p{Is_Bc=s}', "");
Expect(0, 31, '\p{^Is_Bc=s}', "");
Expect(0, 31, '\P{Is_Bc=s}', "");
Expect(1, 31, '\P{^Is_Bc=s}', "");
Expect(0, 32, '\p{Is_Bc=s}', "");
Expect(1, 32, '\p{^Is_Bc=s}', "");
Expect(1, 32, '\P{Is_Bc=s}', "");
Expect(0, 32, '\P{^Is_Bc=s}', "");
Expect(1, 31, '\p{Is_Bc=_-S}', "");
Expect(0, 31, '\p{^Is_Bc=_-S}', "");
Expect(0, 31, '\P{Is_Bc=_-S}', "");
Expect(1, 31, '\P{^Is_Bc=_-S}', "");
Expect(0, 32, '\p{Is_Bc=_-S}', "");
Expect(1, 32, '\p{^Is_Bc=_-S}', "");
Expect(1, 32, '\P{Is_Bc=_-S}', "");
Expect(0, 32, '\P{^Is_Bc=_-S}', "");
Error('\p{Bidi_Class= :=White_Space}');
Error('\P{Bidi_Class= :=White_Space}');
Expect(1, 12288, '\p{Bidi_Class=whitespace}', "");
Expect(0, 12288, '\p{^Bidi_Class=whitespace}', "");
Expect(0, 12288, '\P{Bidi_Class=whitespace}', "");
Expect(1, 12288, '\P{^Bidi_Class=whitespace}', "");
Expect(0, 12289, '\p{Bidi_Class=whitespace}', "");
Expect(1, 12289, '\p{^Bidi_Class=whitespace}', "");
Expect(1, 12289, '\P{Bidi_Class=whitespace}', "");
Expect(0, 12289, '\P{^Bidi_Class=whitespace}', "");
Expect(1, 12288, '\p{Bidi_Class= -White_Space}', "");
Expect(0, 12288, '\p{^Bidi_Class= -White_Space}', "");
Expect(0, 12288, '\P{Bidi_Class= -White_Space}', "");
Expect(1, 12288, '\P{^Bidi_Class= -White_Space}', "");
Expect(0, 12289, '\p{Bidi_Class= -White_Space}', "");
Expect(1, 12289, '\p{^Bidi_Class= -White_Space}', "");
Expect(1, 12289, '\P{Bidi_Class= -White_Space}', "");
Expect(0, 12289, '\P{^Bidi_Class= -White_Space}', "");
Error('\p{Bc=		WS:=}');
Error('\P{Bc=		WS:=}');
Expect(1, 12288, '\p{Bc=ws}', "");
Expect(0, 12288, '\p{^Bc=ws}', "");
Expect(0, 12288, '\P{Bc=ws}', "");
Expect(1, 12288, '\P{^Bc=ws}', "");
Expect(0, 12289, '\p{Bc=ws}', "");
Expect(1, 12289, '\p{^Bc=ws}', "");
Expect(1, 12289, '\P{Bc=ws}', "");
Expect(0, 12289, '\P{^Bc=ws}', "");
Expect(1, 12288, '\p{Bc= WS}', "");
Expect(0, 12288, '\p{^Bc= WS}', "");
Expect(0, 12288, '\P{Bc= WS}', "");
Expect(1, 12288, '\P{^Bc= WS}', "");
Expect(0, 12289, '\p{Bc= WS}', "");
Expect(1, 12289, '\p{^Bc= WS}', "");
Expect(1, 12289, '\P{Bc= WS}', "");
Expect(0, 12289, '\P{^Bc= WS}', "");
Error('\p{Is_Bidi_Class= 	WHITE_Space/a/}');
Error('\P{Is_Bidi_Class= 	WHITE_Space/a/}');
Expect(1, 12288, '\p{Is_Bidi_Class=whitespace}', "");
Expect(0, 12288, '\p{^Is_Bidi_Class=whitespace}', "");
Expect(0, 12288, '\P{Is_Bidi_Class=whitespace}', "");
Expect(1, 12288, '\P{^Is_Bidi_Class=whitespace}', "");
Expect(0, 12289, '\p{Is_Bidi_Class=whitespace}', "");
Expect(1, 12289, '\p{^Is_Bidi_Class=whitespace}', "");
Expect(1, 12289, '\P{Is_Bidi_Class=whitespace}', "");
Expect(0, 12289, '\P{^Is_Bidi_Class=whitespace}', "");
Expect(1, 12288, '\p{Is_Bidi_Class=_White_Space}', "");
Expect(0, 12288, '\p{^Is_Bidi_Class=_White_Space}', "");
Expect(0, 12288, '\P{Is_Bidi_Class=_White_Space}', "");
Expect(1, 12288, '\P{^Is_Bidi_Class=_White_Space}', "");
Expect(0, 12289, '\p{Is_Bidi_Class=_White_Space}', "");
Expect(1, 12289, '\p{^Is_Bidi_Class=_White_Space}', "");
Expect(1, 12289, '\P{Is_Bidi_Class=_White_Space}', "");
Expect(0, 12289, '\P{^Is_Bidi_Class=_White_Space}', "");
Error('\p{Is_Bc=_:=WS}');
Error('\P{Is_Bc=_:=WS}');
Expect(1, 12288, '\p{Is_Bc=ws}', "");
Expect(0, 12288, '\p{^Is_Bc=ws}', "");
Expect(0, 12288, '\P{Is_Bc=ws}', "");
Expect(1, 12288, '\P{^Is_Bc=ws}', "");
Expect(0, 12289, '\p{Is_Bc=ws}', "");
Expect(1, 12289, '\p{^Is_Bc=ws}', "");
Expect(1, 12289, '\P{Is_Bc=ws}', "");
Expect(0, 12289, '\P{^Is_Bc=ws}', "");
Expect(1, 12288, '\p{Is_Bc= 	WS}', "");
Expect(0, 12288, '\p{^Is_Bc= 	WS}', "");
Expect(0, 12288, '\P{Is_Bc= 	WS}', "");
Expect(1, 12288, '\P{^Is_Bc= 	WS}', "");
Expect(0, 12289, '\p{Is_Bc= 	WS}', "");
Expect(1, 12289, '\p{^Is_Bc= 	WS}', "");
Expect(1, 12289, '\P{Is_Bc= 	WS}', "");
Expect(0, 12289, '\P{^Is_Bc= 	WS}', "");
Error('\p{Block:_BASIC_latin/a/}');
Error('\P{Block:_BASIC_latin/a/}');
Expect(1, 127, '\p{Block:	basiclatin}', "");
Expect(0, 127, '\p{^Block:	basiclatin}', "");
Expect(0, 127, '\P{Block:	basiclatin}', "");
Expect(1, 127, '\P{^Block:	basiclatin}', "");
Expect(0, 128, '\p{Block:	basiclatin}', "");
Expect(1, 128, '\p{^Block:	basiclatin}', "");
Expect(1, 128, '\P{Block:	basiclatin}', "");
Expect(0, 128, '\P{^Block:	basiclatin}', "");
Expect(1, 127, '\p{Block= 	BASIC_Latin}', "");
Expect(0, 127, '\p{^Block= 	BASIC_Latin}', "");
Expect(0, 127, '\P{Block= 	BASIC_Latin}', "");
Expect(1, 127, '\P{^Block= 	BASIC_Latin}', "");
Expect(0, 128, '\p{Block= 	BASIC_Latin}', "");
Expect(1, 128, '\p{^Block= 	BASIC_Latin}', "");
Expect(1, 128, '\P{Block= 	BASIC_Latin}', "");
Expect(0, 128, '\P{^Block= 	BASIC_Latin}', "");
Error('\p{Blk=-	ascii:=}');
Error('\P{Blk=-	ascii:=}');
Expect(1, 127, '\p{Blk=ascii}', "");
Expect(0, 127, '\p{^Blk=ascii}', "");
Expect(0, 127, '\P{Blk=ascii}', "");
Expect(1, 127, '\P{^Blk=ascii}', "");
Expect(0, 128, '\p{Blk=ascii}', "");
Expect(1, 128, '\p{^Blk=ascii}', "");
Expect(1, 128, '\P{Blk=ascii}', "");
Expect(0, 128, '\P{^Blk=ascii}', "");
Expect(1, 127, '\p{Blk:   	ascii}', "");
Expect(0, 127, '\p{^Blk:   	ascii}', "");
Expect(0, 127, '\P{Blk:   	ascii}', "");
Expect(1, 127, '\P{^Blk:   	ascii}', "");
Expect(0, 128, '\p{Blk:   	ascii}', "");
Expect(1, 128, '\p{^Blk:   	ascii}', "");
Expect(1, 128, '\P{Blk:   	ascii}', "");
Expect(0, 128, '\P{^Blk:   	ascii}', "");
Error('\p{Is_Block:   :=	BASIC_Latin}');
Error('\P{Is_Block:   :=	BASIC_Latin}');
Expect(1, 127, '\p{Is_Block=basiclatin}', "");
Expect(0, 127, '\p{^Is_Block=basiclatin}', "");
Expect(0, 127, '\P{Is_Block=basiclatin}', "");
Expect(1, 127, '\P{^Is_Block=basiclatin}', "");
Expect(0, 128, '\p{Is_Block=basiclatin}', "");
Expect(1, 128, '\p{^Is_Block=basiclatin}', "");
Expect(1, 128, '\P{Is_Block=basiclatin}', "");
Expect(0, 128, '\P{^Is_Block=basiclatin}', "");
Expect(1, 127, '\p{Is_Block=	-BASIC_latin}', "");
Expect(0, 127, '\p{^Is_Block=	-BASIC_latin}', "");
Expect(0, 127, '\P{Is_Block=	-BASIC_latin}', "");
Expect(1, 127, '\P{^Is_Block=	-BASIC_latin}', "");
Expect(0, 128, '\p{Is_Block=	-BASIC_latin}', "");
Expect(1, 128, '\p{^Is_Block=	-BASIC_latin}', "");
Expect(1, 128, '\P{Is_Block=	-BASIC_latin}', "");
Expect(0, 128, '\P{^Is_Block=	-BASIC_latin}', "");
Error('\p{Is_Blk=	 ASCII:=}');
Error('\P{Is_Blk=	 ASCII:=}');
Expect(1, 127, '\p{Is_Blk=ascii}', "");
Expect(0, 127, '\p{^Is_Blk=ascii}', "");
Expect(0, 127, '\P{Is_Blk=ascii}', "");
Expect(1, 127, '\P{^Is_Blk=ascii}', "");
Expect(0, 128, '\p{Is_Blk=ascii}', "");
Expect(1, 128, '\p{^Is_Blk=ascii}', "");
Expect(1, 128, '\P{Is_Blk=ascii}', "");
Expect(0, 128, '\P{^Is_Blk=ascii}', "");
Expect(1, 127, '\p{Is_Blk=	ASCII}', "");
Expect(0, 127, '\p{^Is_Blk=	ASCII}', "");
Expect(0, 127, '\P{Is_Blk=	ASCII}', "");
Expect(1, 127, '\P{^Is_Blk=	ASCII}', "");
Expect(0, 128, '\p{Is_Blk=	ASCII}', "");
Expect(1, 128, '\p{^Is_Blk=	ASCII}', "");
Expect(1, 128, '\P{Is_Blk=	ASCII}', "");
Expect(0, 128, '\P{^Is_Blk=	ASCII}', "");
Error('\p{Block=:=-_Aegean_Numbers}');
Error('\P{Block=:=-_Aegean_Numbers}');
Expect(1, 65855, '\p{Block: aegeannumbers}', "");
Expect(0, 65855, '\p{^Block: aegeannumbers}', "");
Expect(0, 65855, '\P{Block: aegeannumbers}', "");
Expect(1, 65855, '\P{^Block: aegeannumbers}', "");
Expect(0, 65856, '\p{Block: aegeannumbers}', "");
Expect(1, 65856, '\p{^Block: aegeannumbers}', "");
Expect(1, 65856, '\P{Block: aegeannumbers}', "");
Expect(0, 65856, '\P{^Block: aegeannumbers}', "");
Expect(1, 65855, '\p{Block=_Aegean_NUMBERS}', "");
Expect(0, 65855, '\p{^Block=_Aegean_NUMBERS}', "");
Expect(0, 65855, '\P{Block=_Aegean_NUMBERS}', "");
Expect(1, 65855, '\P{^Block=_Aegean_NUMBERS}', "");
Expect(0, 65856, '\p{Block=_Aegean_NUMBERS}', "");
Expect(1, 65856, '\p{^Block=_Aegean_NUMBERS}', "");
Expect(1, 65856, '\P{Block=_Aegean_NUMBERS}', "");
Expect(0, 65856, '\P{^Block=_Aegean_NUMBERS}', "");
Error('\p{Blk=_:=Aegean_Numbers}');
Error('\P{Blk=_:=Aegean_Numbers}');
Expect(1, 65855, '\p{Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Blk=aegeannumbers}', "");
Expect(0, 65856, '\p{Blk=aegeannumbers}', "");
Expect(1, 65856, '\p{^Blk=aegeannumbers}', "");
Expect(1, 65856, '\P{Blk=aegeannumbers}', "");
Expect(0, 65856, '\P{^Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Blk=__Aegean_Numbers}', "");
Expect(0, 65855, '\p{^Blk=__Aegean_Numbers}', "");
Expect(0, 65855, '\P{Blk=__Aegean_Numbers}', "");
Expect(1, 65855, '\P{^Blk=__Aegean_Numbers}', "");
Expect(0, 65856, '\p{Blk=__Aegean_Numbers}', "");
Expect(1, 65856, '\p{^Blk=__Aegean_Numbers}', "");
Expect(1, 65856, '\P{Blk=__Aegean_Numbers}', "");
Expect(0, 65856, '\P{^Blk=__Aegean_Numbers}', "");
Error('\p{Is_Block=/a/ Aegean_Numbers}');
Error('\P{Is_Block=/a/ Aegean_Numbers}');
Expect(1, 65855, '\p{Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Block=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Block=aegeannumbers}', "");
Expect(0, 65856, '\p{Is_Block=aegeannumbers}', "");
Expect(1, 65856, '\p{^Is_Block=aegeannumbers}', "");
Expect(1, 65856, '\P{Is_Block=aegeannumbers}', "");
Expect(0, 65856, '\P{^Is_Block=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(0, 65855, '\p{^Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(0, 65855, '\P{Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(1, 65855, '\P{^Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(0, 65856, '\p{Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(1, 65856, '\p{^Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(1, 65856, '\P{Is_Block=_	AEGEAN_NUMBERS}', "");
Expect(0, 65856, '\P{^Is_Block=_	AEGEAN_NUMBERS}', "");
Error('\p{Is_Blk=	Aegean_Numbers:=}');
Error('\P{Is_Blk=	Aegean_Numbers:=}');
Expect(1, 65855, '\p{Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\p{^Is_Blk=aegeannumbers}', "");
Expect(0, 65855, '\P{Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\P{^Is_Blk=aegeannumbers}', "");
Expect(0, 65856, '\p{Is_Blk=aegeannumbers}', "");
Expect(1, 65856, '\p{^Is_Blk=aegeannumbers}', "");
Expect(1, 65856, '\P{Is_Blk=aegeannumbers}', "");
Expect(0, 65856, '\P{^Is_Blk=aegeannumbers}', "");
Expect(1, 65855, '\p{Is_Blk=-Aegean_NUMBERS}', "");
Expect(0, 65855, '\p{^Is_Blk=-Aegean_NUMBERS}', "");
Expect(0, 65855, '\P{Is_Blk=-Aegean_NUMBERS}', "");
Expect(1, 65855, '\P{^Is_Blk=-Aegean_NUMBERS}', "");
Expect(0, 65856, '\p{Is_Blk=-Aegean_NUMBERS}', "");
Expect(1, 65856, '\p{^Is_Blk=-Aegean_NUMBERS}', "");
Expect(1, 65856, '\P{Is_Blk=-Aegean_NUMBERS}', "");
Expect(0, 65856, '\P{^Is_Blk=-Aegean_NUMBERS}', "");
Error('\p{Block=/a/ALCHEMICAL_Symbols}');
Error('\P{Block=/a/ALCHEMICAL_Symbols}');
Expect(1, 128895, '\p{Block=alchemicalsymbols}', "");
Expect(0, 128895, '\p{^Block=alchemicalsymbols}', "");
Expect(0, 128895, '\P{Block=alchemicalsymbols}', "");
Expect(1, 128895, '\P{^Block=alchemicalsymbols}', "");
Expect(0, 128896, '\p{Block=alchemicalsymbols}', "");
Expect(1, 128896, '\p{^Block=alchemicalsymbols}', "");
Expect(1, 128896, '\P{Block=alchemicalsymbols}', "");
Expect(0, 128896, '\P{^Block=alchemicalsymbols}', "");
Expect(1, 128895, '\p{Block=_	alchemical_Symbols}', "");
Expect(0, 128895, '\p{^Block=_	alchemical_Symbols}', "");
Expect(0, 128895, '\P{Block=_	alchemical_Symbols}', "");
Expect(1, 128895, '\P{^Block=_	alchemical_Symbols}', "");
Expect(0, 128896, '\p{Block=_	alchemical_Symbols}', "");
Expect(1, 128896, '\p{^Block=_	alchemical_Symbols}', "");
Expect(1, 128896, '\P{Block=_	alchemical_Symbols}', "");
Expect(0, 128896, '\P{^Block=_	alchemical_Symbols}', "");
Error('\p{Blk=-alchemical/a/}');
Error('\P{Blk=-alchemical/a/}');
Expect(1, 128895, '\p{Blk=alchemical}', "");
Expect(0, 128895, '\p{^Blk=alchemical}', "");
Expect(0, 128895, '\P{Blk=alchemical}', "");
Expect(1, 128895, '\P{^Blk=alchemical}', "");
Expect(0, 128896, '\p{Blk=alchemical}', "");
Expect(1, 128896, '\p{^Blk=alchemical}', "");
Expect(1, 128896, '\P{Blk=alchemical}', "");
Expect(0, 128896, '\P{^Blk=alchemical}', "");
Expect(1, 128895, '\p{Blk=_alchemical}', "");
Expect(0, 128895, '\p{^Blk=_alchemical}', "");
Expect(0, 128895, '\P{Blk=_alchemical}', "");
Expect(1, 128895, '\P{^Blk=_alchemical}', "");
Expect(0, 128896, '\p{Blk=_alchemical}', "");
Expect(1, 128896, '\p{^Blk=_alchemical}', "");
Expect(1, 128896, '\P{Blk=_alchemical}', "");
Expect(0, 128896, '\P{^Blk=_alchemical}', "");
Error('\p{Is_Block=:=- alchemical_Symbols}');
Error('\P{Is_Block=:=- alchemical_Symbols}');
Expect(1, 128895, '\p{Is_Block=alchemicalsymbols}', "");
Expect(0, 128895, '\p{^Is_Block=alchemicalsymbols}', "");
Expect(0, 128895, '\P{Is_Block=alchemicalsymbols}', "");
Expect(1, 128895, '\P{^Is_Block=alchemicalsymbols}', "");
Expect(0, 128896, '\p{Is_Block=alchemicalsymbols}', "");
Expect(1, 128896, '\p{^Is_Block=alchemicalsymbols}', "");
Expect(1, 128896, '\P{Is_Block=alchemicalsymbols}', "");
Expect(0, 128896, '\P{^Is_Block=alchemicalsymbols}', "");
Expect(1, 128895, '\p{Is_Block:	 _Alchemical_Symbols}', "");
Expect(0, 128895, '\p{^Is_Block:	 _Alchemical_Symbols}', "");
Expect(0, 128895, '\P{Is_Block:	 _Alchemical_Symbols}', "");
Expect(1, 128895, '\P{^Is_Block:	 _Alchemical_Symbols}', "");
Expect(0, 128896, '\p{Is_Block:	 _Alchemical_Symbols}', "");
Expect(1, 128896, '\p{^Is_Block:	 _Alchemical_Symbols}', "");
Expect(1, 128896, '\P{Is_Block:	 _Alchemical_Symbols}', "");
Expect(0, 128896, '\P{^Is_Block:	 _Alchemical_Symbols}', "");
Error('\p{Is_Blk=/a/	_Alchemical}');
Error('\P{Is_Blk=/a/	_Alchemical}');
Expect(1, 128895, '\p{Is_Blk=alchemical}', "");
Expect(0, 128895, '\p{^Is_Blk=alchemical}', "");
Expect(0, 128895, '\P{Is_Blk=alchemical}', "");
Expect(1, 128895, '\P{^Is_Blk=alchemical}', "");
Expect(0, 128896, '\p{Is_Blk=alchemical}', "");
Expect(1, 128896, '\p{^Is_Blk=alchemical}', "");
Expect(1, 128896, '\P{Is_Blk=alchemical}', "");
Expect(0, 128896, '\P{^Is_Blk=alchemical}', "");
Expect(1, 128895, '\p{Is_Blk=-ALCHEMICAL}', "");
Expect(0, 128895, '\p{^Is_Blk=-ALCHEMICAL}', "");
Expect(0, 128895, '\P{Is_Blk=-ALCHEMICAL}', "");
Expect(1, 128895, '\P{^Is_Blk=-ALCHEMICAL}', "");
Expect(0, 128896, '\p{Is_Blk=-ALCHEMICAL}', "");
Expect(1, 128896, '\p{^Is_Blk=-ALCHEMICAL}', "");
Expect(1, 128896, '\P{Is_Blk=-ALCHEMICAL}', "");
Expect(0, 128896, '\P{^Is_Blk=-ALCHEMICAL}', "");
Error('\p{Block=-:=Alphabetic_Presentation_FORMS}');
Error('\P{Block=-:=Alphabetic_Presentation_FORMS}');
Expect(1, 64335, '\p{Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\p{Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\p{^Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\P{Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\P{^Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Block= alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\p{^Block= alphabetic_Presentation_forms}', "");
Expect(0, 64335, '\P{Block= alphabetic_Presentation_forms}', "");
Expect(1, 64335, '\P{^Block= alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\p{Block= alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\p{^Block= alphabetic_Presentation_forms}', "");
Expect(1, 64336, '\P{Block= alphabetic_Presentation_forms}', "");
Expect(0, 64336, '\P{^Block= alphabetic_Presentation_forms}', "");
Error('\p{Blk=-_Alphabetic_PF:=}');
Error('\P{Blk=-_Alphabetic_PF:=}');
Expect(1, 64335, '\p{Blk=alphabeticpf}', "");
Expect(0, 64335, '\p{^Blk=alphabeticpf}', "");
Expect(0, 64335, '\P{Blk=alphabeticpf}', "");
Expect(1, 64335, '\P{^Blk=alphabeticpf}', "");
Expect(0, 64336, '\p{Blk=alphabeticpf}', "");
Expect(1, 64336, '\p{^Blk=alphabeticpf}', "");
Expect(1, 64336, '\P{Blk=alphabeticpf}', "");
Expect(0, 64336, '\P{^Blk=alphabeticpf}', "");
Expect(1, 64335, '\p{Blk=	Alphabetic_PF}', "");
Expect(0, 64335, '\p{^Blk=	Alphabetic_PF}', "");
Expect(0, 64335, '\P{Blk=	Alphabetic_PF}', "");
Expect(1, 64335, '\P{^Blk=	Alphabetic_PF}', "");
Expect(0, 64336, '\p{Blk=	Alphabetic_PF}', "");
Expect(1, 64336, '\p{^Blk=	Alphabetic_PF}', "");
Expect(1, 64336, '\P{Blk=	Alphabetic_PF}', "");
Expect(0, 64336, '\P{^Blk=	Alphabetic_PF}', "");
Error('\p{Is_Block=-/a/ALPHABETIC_presentation_FORMS}');
Error('\P{Is_Block=-/a/ALPHABETIC_presentation_FORMS}');
Expect(1, 64335, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64335, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\p{Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\p{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64336, '\P{Is_Block=alphabeticpresentationforms}', "");
Expect(0, 64336, '\P{^Is_Block=alphabeticpresentationforms}', "");
Expect(1, 64335, '\p{Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(0, 64335, '\p{^Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(0, 64335, '\P{Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(1, 64335, '\P{^Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(0, 64336, '\p{Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(1, 64336, '\p{^Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(1, 64336, '\P{Is_Block=  alphabetic_Presentation_Forms}', "");
Expect(0, 64336, '\P{^Is_Block=  alphabetic_Presentation_Forms}', "");
Error('\p{Is_Blk::=-_alphabetic_PF}');
Error('\P{Is_Blk::=-_alphabetic_PF}');
Expect(1, 64335, '\p{Is_Blk=alphabeticpf}', "");
Expect(0, 64335, '\p{^Is_Blk=alphabeticpf}', "");
Expect(0, 64335, '\P{Is_Blk=alphabeticpf}', "");
Expect(1, 64335, '\P{^Is_Blk=alphabeticpf}', "");
Expect(0, 64336, '\p{Is_Blk=alphabeticpf}', "");
Expect(1, 64336, '\p{^Is_Blk=alphabeticpf}', "");
Expect(1, 64336, '\P{Is_Blk=alphabeticpf}', "");
Expect(0, 64336, '\P{^Is_Blk=alphabeticpf}', "");
Expect(1, 64335, '\p{Is_Blk=	_alphabetic_PF}', "");
Expect(0, 64335, '\p{^Is_Blk=	_alphabetic_PF}', "");
Expect(0, 64335, '\P{Is_Blk=	_alphabetic_PF}', "");
Expect(1, 64335, '\P{^Is_Blk=	_alphabetic_PF}', "");
Expect(0, 64336, '\p{Is_Blk=	_alphabetic_PF}', "");
Expect(1, 64336, '\p{^Is_Blk=	_alphabetic_PF}', "");
Expect(1, 64336, '\P{Is_Blk=	_alphabetic_PF}', "");
Expect(0, 64336, '\P{^Is_Blk=	_alphabetic_PF}', "");
Error('\p{Block:	/a/  ancient_Greek_Musical_Notation}');
Error('\P{Block:	/a/  ancient_Greek_Musical_Notation}');
Expect(1, 119375, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\p{Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\p{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\P{Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\P{^Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(0, 119375, '\p{^Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(0, 119375, '\P{Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(1, 119375, '\P{^Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(0, 119376, '\p{Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(1, 119376, '\p{^Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(1, 119376, '\P{Block= 	Ancient_Greek_Musical_Notation}', "");
Expect(0, 119376, '\P{^Block= 	Ancient_Greek_Musical_Notation}', "");
Error('\p{Blk=_ ANCIENT_Greek_music:=}');
Error('\P{Blk=_ ANCIENT_Greek_music:=}');
Expect(1, 119375, '\p{Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\p{^Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\P{Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\P{^Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\p{Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\p{^Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\P{Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\P{^Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\p{Blk=--ANCIENT_GREEK_Music}', "");
Expect(0, 119375, '\p{^Blk=--ANCIENT_GREEK_Music}', "");
Expect(0, 119375, '\P{Blk=--ANCIENT_GREEK_Music}', "");
Expect(1, 119375, '\P{^Blk=--ANCIENT_GREEK_Music}', "");
Expect(0, 119376, '\p{Blk=--ANCIENT_GREEK_Music}', "");
Expect(1, 119376, '\p{^Blk=--ANCIENT_GREEK_Music}', "");
Expect(1, 119376, '\P{Blk=--ANCIENT_GREEK_Music}', "");
Expect(0, 119376, '\P{^Blk=--ANCIENT_GREEK_Music}', "");
Error('\p{Is_Block=_-ancient_Greek_musical_notation/a/}');
Error('\P{Is_Block=_-ancient_Greek_musical_notation/a/}');
Expect(1, 119375, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119375, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\p{Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\p{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119376, '\P{Is_Block=ancientgreekmusicalnotation}', "");
Expect(0, 119376, '\P{^Is_Block=ancientgreekmusicalnotation}', "");
Expect(1, 119375, '\p{Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(0, 119375, '\p{^Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(0, 119375, '\P{Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(1, 119375, '\P{^Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(0, 119376, '\p{Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(1, 119376, '\p{^Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(1, 119376, '\P{Is_Block:		 Ancient_Greek_Musical_notation}', "");
Expect(0, 119376, '\P{^Is_Block:		 Ancient_Greek_Musical_notation}', "");
Error('\p{Is_Blk=:=_ANCIENT_Greek_Music}');
Error('\P{Is_Blk=:=_ANCIENT_Greek_Music}');
Expect(1, 119375, '\p{Is_Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\p{^Is_Blk=ancientgreekmusic}', "");
Expect(0, 119375, '\P{Is_Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\P{^Is_Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\p{Is_Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\p{^Is_Blk=ancientgreekmusic}', "");
Expect(1, 119376, '\P{Is_Blk=ancientgreekmusic}', "");
Expect(0, 119376, '\P{^Is_Blk=ancientgreekmusic}', "");
Expect(1, 119375, '\p{Is_Blk=  ancient_greek_MUSIC}', "");
Expect(0, 119375, '\p{^Is_Blk=  ancient_greek_MUSIC}', "");
Expect(0, 119375, '\P{Is_Blk=  ancient_greek_MUSIC}', "");
Expect(1, 119375, '\P{^Is_Blk=  ancient_greek_MUSIC}', "");
Expect(0, 119376, '\p{Is_Blk=  ancient_greek_MUSIC}', "");
Expect(1, 119376, '\p{^Is_Blk=  ancient_greek_MUSIC}', "");
Expect(1, 119376, '\P{Is_Blk=  ancient_greek_MUSIC}', "");
Expect(0, 119376, '\P{^Is_Blk=  ancient_greek_MUSIC}', "");
Error('\p{Block:		:=ANCIENT_greek_NUMBERS}');
Error('\P{Block:		:=ANCIENT_greek_NUMBERS}');
Expect(1, 65935, '\p{Block: ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Block: ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Block: ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Block: ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Block: ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Block: ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Block: ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Block: ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Block= _Ancient_Greek_numbers}', "");
Expect(0, 65935, '\p{^Block= _Ancient_Greek_numbers}', "");
Expect(0, 65935, '\P{Block= _Ancient_Greek_numbers}', "");
Expect(1, 65935, '\P{^Block= _Ancient_Greek_numbers}', "");
Expect(0, 65936, '\p{Block= _Ancient_Greek_numbers}', "");
Expect(1, 65936, '\p{^Block= _Ancient_Greek_numbers}', "");
Expect(1, 65936, '\P{Block= _Ancient_Greek_numbers}', "");
Expect(0, 65936, '\P{^Block= _Ancient_Greek_numbers}', "");
Error('\p{Blk=	ANCIENT_GREEK_Numbers/a/}');
Error('\P{Blk=	ANCIENT_GREEK_Numbers/a/}');
Expect(1, 65935, '\p{Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Blk=__Ancient_Greek_Numbers}', "");
Expect(0, 65935, '\p{^Blk=__Ancient_Greek_Numbers}', "");
Expect(0, 65935, '\P{Blk=__Ancient_Greek_Numbers}', "");
Expect(1, 65935, '\P{^Blk=__Ancient_Greek_Numbers}', "");
Expect(0, 65936, '\p{Blk=__Ancient_Greek_Numbers}', "");
Expect(1, 65936, '\p{^Blk=__Ancient_Greek_Numbers}', "");
Expect(1, 65936, '\P{Blk=__Ancient_Greek_Numbers}', "");
Expect(0, 65936, '\P{^Blk=__Ancient_Greek_Numbers}', "");
Error('\p{Is_Block=/a/_Ancient_Greek_Numbers}');
Error('\P{Is_Block=/a/_Ancient_Greek_Numbers}');
Expect(1, 65935, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Is_Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Is_Block=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Is_Block=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(0, 65935, '\p{^Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(0, 65935, '\P{Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(1, 65935, '\P{^Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(0, 65936, '\p{Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(1, 65936, '\p{^Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(1, 65936, '\P{Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Expect(0, 65936, '\P{^Is_Block=	-ANCIENT_GREEK_Numbers}', "");
Error('\p{Is_Blk=-	ANCIENT_greek_Numbers/a/}');
Error('\P{Is_Blk=-	ANCIENT_greek_Numbers/a/}');
Expect(1, 65935, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65935, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\p{Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\p{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65936, '\P{Is_Blk=ancientgreeknumbers}', "");
Expect(0, 65936, '\P{^Is_Blk=ancientgreeknumbers}', "");
Expect(1, 65935, '\p{Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(0, 65935, '\p{^Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(0, 65935, '\P{Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(1, 65935, '\P{^Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(0, 65936, '\p{Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(1, 65936, '\p{^Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(1, 65936, '\P{Is_Blk: _ ANCIENT_greek_Numbers}', "");
Expect(0, 65936, '\P{^Is_Blk: _ ANCIENT_greek_Numbers}', "");
Error('\p{Block=/a/Ancient_SYMBOLS}');
Error('\P{Block=/a/Ancient_SYMBOLS}');
Expect(1, 65999, '\p{Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Block=ancientsymbols}', "");
Expect(0, 66000, '\p{Block=ancientsymbols}', "");
Expect(1, 66000, '\p{^Block=ancientsymbols}', "");
Expect(1, 66000, '\P{Block=ancientsymbols}', "");
Expect(0, 66000, '\P{^Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Block= ANCIENT_symbols}', "");
Expect(0, 65999, '\p{^Block= ANCIENT_symbols}', "");
Expect(0, 65999, '\P{Block= ANCIENT_symbols}', "");
Expect(1, 65999, '\P{^Block= ANCIENT_symbols}', "");
Expect(0, 66000, '\p{Block= ANCIENT_symbols}', "");
Expect(1, 66000, '\p{^Block= ANCIENT_symbols}', "");
Expect(1, 66000, '\P{Block= ANCIENT_symbols}', "");
Expect(0, 66000, '\P{^Block= ANCIENT_symbols}', "");
Error('\p{Blk=	ANCIENT_symbols:=}');
Error('\P{Blk=	ANCIENT_symbols:=}');
Expect(1, 65999, '\p{Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Blk=ancientsymbols}', "");
Expect(0, 66000, '\p{Blk=ancientsymbols}', "");
Expect(1, 66000, '\p{^Blk=ancientsymbols}', "");
Expect(1, 66000, '\P{Blk=ancientsymbols}', "");
Expect(0, 66000, '\P{^Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Blk=	_ancient_Symbols}', "");
Expect(0, 65999, '\p{^Blk=	_ancient_Symbols}', "");
Expect(0, 65999, '\P{Blk=	_ancient_Symbols}', "");
Expect(1, 65999, '\P{^Blk=	_ancient_Symbols}', "");
Expect(0, 66000, '\p{Blk=	_ancient_Symbols}', "");
Expect(1, 66000, '\p{^Blk=	_ancient_Symbols}', "");
Expect(1, 66000, '\P{Blk=	_ancient_Symbols}', "");
Expect(0, 66000, '\P{^Blk=	_ancient_Symbols}', "");
Error('\p{Is_Block=:=	 ancient_Symbols}');
Error('\P{Is_Block=:=	 ancient_Symbols}');
Expect(1, 65999, '\p{Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Block=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Block=ancientsymbols}', "");
Expect(0, 66000, '\p{Is_Block=ancientsymbols}', "");
Expect(1, 66000, '\p{^Is_Block=ancientsymbols}', "");
Expect(1, 66000, '\P{Is_Block=ancientsymbols}', "");
Expect(0, 66000, '\P{^Is_Block=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Block= 	Ancient_SYMBOLS}', "");
Expect(0, 65999, '\p{^Is_Block= 	Ancient_SYMBOLS}', "");
Expect(0, 65999, '\P{Is_Block= 	Ancient_SYMBOLS}', "");
Expect(1, 65999, '\P{^Is_Block= 	Ancient_SYMBOLS}', "");
Expect(0, 66000, '\p{Is_Block= 	Ancient_SYMBOLS}', "");
Expect(1, 66000, '\p{^Is_Block= 	Ancient_SYMBOLS}', "");
Expect(1, 66000, '\P{Is_Block= 	Ancient_SYMBOLS}', "");
Expect(0, 66000, '\P{^Is_Block= 	Ancient_SYMBOLS}', "");
Error('\p{Is_Blk=/a/__ANCIENT_symbols}');
Error('\P{Is_Blk=/a/__ANCIENT_symbols}');
Expect(1, 65999, '\p{Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\p{^Is_Blk=ancientsymbols}', "");
Expect(0, 65999, '\P{Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\P{^Is_Blk=ancientsymbols}', "");
Expect(0, 66000, '\p{Is_Blk=ancientsymbols}', "");
Expect(1, 66000, '\p{^Is_Blk=ancientsymbols}', "");
Expect(1, 66000, '\P{Is_Blk=ancientsymbols}', "");
Expect(0, 66000, '\P{^Is_Blk=ancientsymbols}', "");
Expect(1, 65999, '\p{Is_Blk:  _ANCIENT_Symbols}', "");
Expect(0, 65999, '\p{^Is_Blk:  _ANCIENT_Symbols}', "");
Expect(0, 65999, '\P{Is_Blk:  _ANCIENT_Symbols}', "");
Expect(1, 65999, '\P{^Is_Blk:  _ANCIENT_Symbols}', "");
Expect(0, 66000, '\p{Is_Blk:  _ANCIENT_Symbols}', "");
Expect(1, 66000, '\p{^Is_Blk:  _ANCIENT_Symbols}', "");
Expect(1, 66000, '\P{Is_Blk:  _ANCIENT_Symbols}', "");
Expect(0, 66000, '\P{^Is_Blk:  _ANCIENT_Symbols}', "");
Error('\p{Block=	:=Arabic}');
Error('\P{Block=	:=Arabic}');
Expect(1, 1791, '\p{Block=arabic}', "");
Expect(0, 1791, '\p{^Block=arabic}', "");
Expect(0, 1791, '\P{Block=arabic}', "");
Expect(1, 1791, '\P{^Block=arabic}', "");
Expect(0, 1792, '\p{Block=arabic}', "");
Expect(1, 1792, '\p{^Block=arabic}', "");
Expect(1, 1792, '\P{Block=arabic}', "");
Expect(0, 1792, '\P{^Block=arabic}', "");
Expect(1, 1791, '\p{Block= Arabic}', "");
Expect(0, 1791, '\p{^Block= Arabic}', "");
Expect(0, 1791, '\P{Block= Arabic}', "");
Expect(1, 1791, '\P{^Block= Arabic}', "");
Expect(0, 1792, '\p{Block= Arabic}', "");
Expect(1, 1792, '\p{^Block= Arabic}', "");
Expect(1, 1792, '\P{Block= Arabic}', "");
Expect(0, 1792, '\P{^Block= Arabic}', "");
Error('\p{Blk=_Arabic/a/}');
Error('\P{Blk=_Arabic/a/}');
Expect(1, 1791, '\p{Blk=arabic}', "");
Expect(0, 1791, '\p{^Blk=arabic}', "");
Expect(0, 1791, '\P{Blk=arabic}', "");
Expect(1, 1791, '\P{^Blk=arabic}', "");
Expect(0, 1792, '\p{Blk=arabic}', "");
Expect(1, 1792, '\p{^Blk=arabic}', "");
Expect(1, 1792, '\P{Blk=arabic}', "");
Expect(0, 1792, '\P{^Blk=arabic}', "");
Expect(1, 1791, '\p{Blk=	Arabic}', "");
Expect(0, 1791, '\p{^Blk=	Arabic}', "");
Expect(0, 1791, '\P{Blk=	Arabic}', "");
Expect(1, 1791, '\P{^Blk=	Arabic}', "");
Expect(0, 1792, '\p{Blk=	Arabic}', "");
Expect(1, 1792, '\p{^Blk=	Arabic}', "");
Expect(1, 1792, '\P{Blk=	Arabic}', "");
Expect(0, 1792, '\P{^Blk=	Arabic}', "");
Error('\p{Is_Block=-:=Arabic}');
Error('\P{Is_Block=-:=Arabic}');
Expect(1, 1791, '\p{Is_Block=arabic}', "");
Expect(0, 1791, '\p{^Is_Block=arabic}', "");
Expect(0, 1791, '\P{Is_Block=arabic}', "");
Expect(1, 1791, '\P{^Is_Block=arabic}', "");
Expect(0, 1792, '\p{Is_Block=arabic}', "");
Expect(1, 1792, '\p{^Is_Block=arabic}', "");
Expect(1, 1792, '\P{Is_Block=arabic}', "");
Expect(0, 1792, '\P{^Is_Block=arabic}', "");
Expect(1, 1791, '\p{Is_Block=-ARABIC}', "");
Expect(0, 1791, '\p{^Is_Block=-ARABIC}', "");
Expect(0, 1791, '\P{Is_Block=-ARABIC}', "");
Expect(1, 1791, '\P{^Is_Block=-ARABIC}', "");
Expect(0, 1792, '\p{Is_Block=-ARABIC}', "");
Expect(1, 1792, '\p{^Is_Block=-ARABIC}', "");
Expect(1, 1792, '\P{Is_Block=-ARABIC}', "");
Expect(0, 1792, '\P{^Is_Block=-ARABIC}', "");
Error('\p{Is_Blk=_-Arabic:=}');
Error('\P{Is_Blk=_-Arabic:=}');
Expect(1, 1791, '\p{Is_Blk=arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=arabic}', "");
Expect(0, 1791, '\P{Is_Blk=arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=arabic}', "");
Expect(0, 1792, '\p{Is_Blk=arabic}', "");
Expect(1, 1792, '\p{^Is_Blk=arabic}', "");
Expect(1, 1792, '\P{Is_Blk=arabic}', "");
Expect(0, 1792, '\P{^Is_Blk=arabic}', "");
Expect(1, 1791, '\p{Is_Blk=	 arabic}', "");
Expect(0, 1791, '\p{^Is_Blk=	 arabic}', "");
Expect(0, 1791, '\P{Is_Blk=	 arabic}', "");
Expect(1, 1791, '\P{^Is_Blk=	 arabic}', "");
Expect(0, 1792, '\p{Is_Blk=	 arabic}', "");
Expect(1, 1792, '\p{^Is_Blk=	 arabic}', "");
Expect(1, 1792, '\P{Is_Blk=	 arabic}', "");
Expect(0, 1792, '\P{^Is_Blk=	 arabic}', "");
Error('\p{Block=-	Arabic_Extended_a:=}');
Error('\P{Block=-	Arabic_Extended_a:=}');
Expect(1, 2303, '\p{Block=arabicextendeda}', "");
Expect(0, 2303, '\p{^Block=arabicextendeda}', "");
Expect(0, 2303, '\P{Block=arabicextendeda}', "");
Expect(1, 2303, '\P{^Block=arabicextendeda}', "");
Expect(0, 2304, '\p{Block=arabicextendeda}', "");
Expect(1, 2304, '\p{^Block=arabicextendeda}', "");
Expect(1, 2304, '\P{Block=arabicextendeda}', "");
Expect(0, 2304, '\P{^Block=arabicextendeda}', "");
Expect(1, 2303, '\p{Block=_ARABIC_EXTENDED_A}', "");
Expect(0, 2303, '\p{^Block=_ARABIC_EXTENDED_A}', "");
Expect(0, 2303, '\P{Block=_ARABIC_EXTENDED_A}', "");
Expect(1, 2303, '\P{^Block=_ARABIC_EXTENDED_A}', "");
Expect(0, 2304, '\p{Block=_ARABIC_EXTENDED_A}', "");
Expect(1, 2304, '\p{^Block=_ARABIC_EXTENDED_A}', "");
Expect(1, 2304, '\P{Block=_ARABIC_EXTENDED_A}', "");
Expect(0, 2304, '\P{^Block=_ARABIC_EXTENDED_A}', "");
Error('\p{Blk=_ Arabic_ext_A/a/}');
Error('\P{Blk=_ Arabic_ext_A/a/}');
Expect(1, 2303, '\p{Blk:	arabicexta}', "");
Expect(0, 2303, '\p{^Blk:	arabicexta}', "");
Expect(0, 2303, '\P{Blk:	arabicexta}', "");
Expect(1, 2303, '\P{^Blk:	arabicexta}', "");
Expect(0, 2304, '\p{Blk:	arabicexta}', "");
Expect(1, 2304, '\p{^Blk:	arabicexta}', "");
Expect(1, 2304, '\P{Blk:	arabicexta}', "");
Expect(0, 2304, '\P{^Blk:	arabicexta}', "");
Expect(1, 2303, '\p{Blk=--Arabic_EXT_A}', "");
Expect(0, 2303, '\p{^Blk=--Arabic_EXT_A}', "");
Expect(0, 2303, '\P{Blk=--Arabic_EXT_A}', "");
Expect(1, 2303, '\P{^Blk=--Arabic_EXT_A}', "");
Expect(0, 2304, '\p{Blk=--Arabic_EXT_A}', "");
Expect(1, 2304, '\p{^Blk=--Arabic_EXT_A}', "");
Expect(1, 2304, '\P{Blk=--Arabic_EXT_A}', "");
Expect(0, 2304, '\P{^Blk=--Arabic_EXT_A}', "");
Error('\p{Is_Block:/a/_arabic_Extended_a}');
Error('\P{Is_Block:/a/_arabic_Extended_a}');
Expect(1, 2303, '\p{Is_Block=arabicextendeda}', "");
Expect(0, 2303, '\p{^Is_Block=arabicextendeda}', "");
Expect(0, 2303, '\P{Is_Block=arabicextendeda}', "");
Expect(1, 2303, '\P{^Is_Block=arabicextendeda}', "");
Expect(0, 2304, '\p{Is_Block=arabicextendeda}', "");
Expect(1, 2304, '\p{^Is_Block=arabicextendeda}', "");
Expect(1, 2304, '\P{Is_Block=arabicextendeda}', "");
Expect(0, 2304, '\P{^Is_Block=arabicextendeda}', "");
Expect(1, 2303, '\p{Is_Block: -_ARABIC_Extended_A}', "");
Expect(0, 2303, '\p{^Is_Block: -_ARABIC_Extended_A}', "");
Expect(0, 2303, '\P{Is_Block: -_ARABIC_Extended_A}', "");
Expect(1, 2303, '\P{^Is_Block: -_ARABIC_Extended_A}', "");
Expect(0, 2304, '\p{Is_Block: -_ARABIC_Extended_A}', "");
Expect(1, 2304, '\p{^Is_Block: -_ARABIC_Extended_A}', "");
Expect(1, 2304, '\P{Is_Block: -_ARABIC_Extended_A}', "");
Expect(0, 2304, '\P{^Is_Block: -_ARABIC_Extended_A}', "");
Error('\p{Is_Blk=	:=Arabic_EXT_A}');
Error('\P{Is_Blk=	:=Arabic_EXT_A}');
Expect(1, 2303, '\p{Is_Blk=arabicexta}', "");
Expect(0, 2303, '\p{^Is_Blk=arabicexta}', "");
Expect(0, 2303, '\P{Is_Blk=arabicexta}', "");
Expect(1, 2303, '\P{^Is_Blk=arabicexta}', "");
Expect(0, 2304, '\p{Is_Blk=arabicexta}', "");
Expect(1, 2304, '\p{^Is_Blk=arabicexta}', "");
Expect(1, 2304, '\P{Is_Blk=arabicexta}', "");
Expect(0, 2304, '\P{^Is_Blk=arabicexta}', "");
Expect(1, 2303, '\p{Is_Blk=_Arabic_EXT_A}', "");
Expect(0, 2303, '\p{^Is_Blk=_Arabic_EXT_A}', "");
Expect(0, 2303, '\P{Is_Blk=_Arabic_EXT_A}', "");
Expect(1, 2303, '\P{^Is_Blk=_Arabic_EXT_A}', "");
Expect(0, 2304, '\p{Is_Blk=_Arabic_EXT_A}', "");
Expect(1, 2304, '\p{^Is_Blk=_Arabic_EXT_A}', "");
Expect(1, 2304, '\P{Is_Blk=_Arabic_EXT_A}', "");
Expect(0, 2304, '\P{^Is_Blk=_Arabic_EXT_A}', "");
Error('\p{Block= ARABIC_MATHEMATICAL_alphabetic_Symbols/a/}');
Error('\P{Block= ARABIC_MATHEMATICAL_alphabetic_Symbols/a/}');
Expect(1, 126719, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\p{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\p{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\P{Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\P{^Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\p{Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(0, 126719, '\p{^Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(0, 126719, '\P{Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(1, 126719, '\P{^Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(0, 126720, '\p{Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(1, 126720, '\p{^Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(1, 126720, '\P{Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Expect(0, 126720, '\P{^Block:   _Arabic_Mathematical_alphabetic_Symbols}', "");
Error('\p{Blk=/a/	-arabic_MATH}');
Error('\P{Blk=/a/	-arabic_MATH}');
Expect(1, 126719, '\p{Blk:	arabicmath}', "");
Expect(0, 126719, '\p{^Blk:	arabicmath}', "");
Expect(0, 126719, '\P{Blk:	arabicmath}', "");
Expect(1, 126719, '\P{^Blk:	arabicmath}', "");
Expect(0, 126720, '\p{Blk:	arabicmath}', "");
Expect(1, 126720, '\p{^Blk:	arabicmath}', "");
Expect(1, 126720, '\P{Blk:	arabicmath}', "");
Expect(0, 126720, '\P{^Blk:	arabicmath}', "");
Expect(1, 126719, '\p{Blk=arabic_math}', "");
Expect(0, 126719, '\p{^Blk=arabic_math}', "");
Expect(0, 126719, '\P{Blk=arabic_math}', "");
Expect(1, 126719, '\P{^Blk=arabic_math}', "");
Expect(0, 126720, '\p{Blk=arabic_math}', "");
Expect(1, 126720, '\p{^Blk=arabic_math}', "");
Expect(1, 126720, '\P{Blk=arabic_math}', "");
Expect(0, 126720, '\P{^Blk=arabic_math}', "");
Error('\p{Is_Block=-Arabic_Mathematical_Alphabetic_symbols:=}');
Error('\P{Is_Block=-Arabic_Mathematical_Alphabetic_symbols:=}');
Expect(1, 126719, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126719, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\p{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\p{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126720, '\P{Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(0, 126720, '\P{^Is_Block=arabicmathematicalalphabeticsymbols}', "");
Expect(1, 126719, '\p{Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(0, 126719, '\p{^Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(0, 126719, '\P{Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(1, 126719, '\P{^Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(0, 126720, '\p{Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(1, 126720, '\p{^Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(1, 126720, '\P{Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Expect(0, 126720, '\P{^Is_Block= Arabic_MATHEMATICAL_ALPHABETIC_Symbols}', "");
Error('\p{Is_Blk=:=	 Arabic_Math}');
Error('\P{Is_Blk=:=	 Arabic_Math}');
Expect(1, 126719, '\p{Is_Blk=arabicmath}', "");
Expect(0, 126719, '\p{^Is_Blk=arabicmath}', "");
Expect(0, 126719, '\P{Is_Blk=arabicmath}', "");
Expect(1, 126719, '\P{^Is_Blk=arabicmath}', "");
Expect(0, 126720, '\p{Is_Blk=arabicmath}', "");
Expect(1, 126720, '\p{^Is_Blk=arabicmath}', "");
Expect(1, 126720, '\P{Is_Blk=arabicmath}', "");
Expect(0, 126720, '\P{^Is_Blk=arabicmath}', "");
Expect(1, 126719, '\p{Is_Blk: 	 arabic_MATH}', "");
Expect(0, 126719, '\p{^Is_Blk: 	 arabic_MATH}', "");
Expect(0, 126719, '\P{Is_Blk: 	 arabic_MATH}', "");
Expect(1, 126719, '\P{^Is_Blk: 	 arabic_MATH}', "");
Expect(0, 126720, '\p{Is_Blk: 	 arabic_MATH}', "");
Expect(1, 126720, '\p{^Is_Blk: 	 arabic_MATH}', "");
Expect(1, 126720, '\P{Is_Blk: 	 arabic_MATH}', "");
Expect(0, 126720, '\P{^Is_Blk: 	 arabic_MATH}', "");
Error('\p{Block=--Arabic_Presentation_FORMS_a:=}');
Error('\P{Block=--Arabic_Presentation_FORMS_a:=}');
Expect(1, 65023, '\p{Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\p{Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\p{^Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\P{Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\P{^Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Block=	-Arabic_presentation_Forms_a}', "");
Expect(0, 65023, '\p{^Block=	-Arabic_presentation_Forms_a}', "");
Expect(0, 65023, '\P{Block=	-Arabic_presentation_Forms_a}', "");
Expect(1, 65023, '\P{^Block=	-Arabic_presentation_Forms_a}', "");
Expect(0, 65024, '\p{Block=	-Arabic_presentation_Forms_a}', "");
Expect(1, 65024, '\p{^Block=	-Arabic_presentation_Forms_a}', "");
Expect(1, 65024, '\P{Block=	-Arabic_presentation_Forms_a}', "");
Expect(0, 65024, '\P{^Block=	-Arabic_presentation_Forms_a}', "");
Error('\p{Blk: arabic_PF_A:=}');
Error('\P{Blk: arabic_PF_A:=}');
Expect(1, 65023, '\p{Blk:	arabicpfa}', "");
Expect(0, 65023, '\p{^Blk:	arabicpfa}', "");
Expect(0, 65023, '\P{Blk:	arabicpfa}', "");
Expect(1, 65023, '\P{^Blk:	arabicpfa}', "");
Expect(0, 65024, '\p{Blk:	arabicpfa}', "");
Expect(1, 65024, '\p{^Blk:	arabicpfa}', "");
Expect(1, 65024, '\P{Blk:	arabicpfa}', "");
Expect(0, 65024, '\P{^Blk:	arabicpfa}', "");
Expect(1, 65023, '\p{Blk=--ARABIC_pf_A}', "");
Expect(0, 65023, '\p{^Blk=--ARABIC_pf_A}', "");
Expect(0, 65023, '\P{Blk=--ARABIC_pf_A}', "");
Expect(1, 65023, '\P{^Blk=--ARABIC_pf_A}', "");
Expect(0, 65024, '\p{Blk=--ARABIC_pf_A}', "");
Expect(1, 65024, '\p{^Blk=--ARABIC_pf_A}', "");
Expect(1, 65024, '\P{Blk=--ARABIC_pf_A}', "");
Expect(0, 65024, '\P{^Blk=--ARABIC_pf_A}', "");
Error('\p{Is_Block=:= 	ARABIC_Presentation_forms_A}');
Error('\P{Is_Block=:= 	ARABIC_Presentation_forms_A}');
Expect(1, 65023, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65023, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\p{Is_Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\p{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65024, '\P{Is_Block=arabicpresentationformsa}', "");
Expect(0, 65024, '\P{^Is_Block=arabicpresentationformsa}', "");
Expect(1, 65023, '\p{Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(0, 65023, '\p{^Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(0, 65023, '\P{Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(1, 65023, '\P{^Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(0, 65024, '\p{Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(1, 65024, '\p{^Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(1, 65024, '\P{Is_Block=__ARABIC_Presentation_forms_A}', "");
Expect(0, 65024, '\P{^Is_Block=__ARABIC_Presentation_forms_A}', "");
Error('\p{Is_Blk=_/a/ARABIC_PF_a}');
Error('\P{Is_Blk=_/a/ARABIC_PF_a}');
Expect(1, 65023, '\p{Is_Blk=arabicpfa}', "");
Expect(0, 65023, '\p{^Is_Blk=arabicpfa}', "");
Expect(0, 65023, '\P{Is_Blk=arabicpfa}', "");
Expect(1, 65023, '\P{^Is_Blk=arabicpfa}', "");
Expect(0, 65024, '\p{Is_Blk=arabicpfa}', "");
Expect(1, 65024, '\p{^Is_Blk=arabicpfa}', "");
Expect(1, 65024, '\P{Is_Blk=arabicpfa}', "");
Expect(0, 65024, '\P{^Is_Blk=arabicpfa}', "");
Expect(1, 65023, '\p{Is_Blk=- Arabic_PF_A}', "");
Expect(0, 65023, '\p{^Is_Blk=- Arabic_PF_A}', "");
Expect(0, 65023, '\P{Is_Blk=- Arabic_PF_A}', "");
Expect(1, 65023, '\P{^Is_Blk=- Arabic_PF_A}', "");
Expect(0, 65024, '\p{Is_Blk=- Arabic_PF_A}', "");
Expect(1, 65024, '\p{^Is_Blk=- Arabic_PF_A}', "");
Expect(1, 65024, '\P{Is_Blk=- Arabic_PF_A}', "");
Expect(0, 65024, '\P{^Is_Blk=- Arabic_PF_A}', "");
Error('\p{Block=	/a/Arabic_presentation_Forms_b}');
Error('\P{Block=	/a/Arabic_presentation_Forms_b}');
Expect(1, 65279, '\p{Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\p{Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\p{^Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\P{Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\P{^Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Block=- Arabic_presentation_Forms_B}', "");
Expect(0, 65279, '\p{^Block=- Arabic_presentation_Forms_B}', "");
Expect(0, 65279, '\P{Block=- Arabic_presentation_Forms_B}', "");
Expect(1, 65279, '\P{^Block=- Arabic_presentation_Forms_B}', "");
Expect(0, 65280, '\p{Block=- Arabic_presentation_Forms_B}', "");
Expect(1, 65280, '\p{^Block=- Arabic_presentation_Forms_B}', "");
Expect(1, 65280, '\P{Block=- Arabic_presentation_Forms_B}', "");
Expect(0, 65280, '\P{^Block=- Arabic_presentation_Forms_B}', "");
Error('\p{Blk=_ARABIC_pf_b/a/}');
Error('\P{Blk=_ARABIC_pf_b/a/}');
Expect(1, 65279, '\p{Blk=arabicpfb}', "");
Expect(0, 65279, '\p{^Blk=arabicpfb}', "");
Expect(0, 65279, '\P{Blk=arabicpfb}', "");
Expect(1, 65279, '\P{^Blk=arabicpfb}', "");
Expect(0, 65280, '\p{Blk=arabicpfb}', "");
Expect(1, 65280, '\p{^Blk=arabicpfb}', "");
Expect(1, 65280, '\P{Blk=arabicpfb}', "");
Expect(0, 65280, '\P{^Blk=arabicpfb}', "");
Expect(1, 65279, '\p{Blk=	Arabic_PF_B}', "");
Expect(0, 65279, '\p{^Blk=	Arabic_PF_B}', "");
Expect(0, 65279, '\P{Blk=	Arabic_PF_B}', "");
Expect(1, 65279, '\P{^Blk=	Arabic_PF_B}', "");
Expect(0, 65280, '\p{Blk=	Arabic_PF_B}', "");
Expect(1, 65280, '\p{^Blk=	Arabic_PF_B}', "");
Expect(1, 65280, '\P{Blk=	Arabic_PF_B}', "");
Expect(0, 65280, '\P{^Blk=	Arabic_PF_B}', "");
Error('\p{Is_Block:	:=Arabic_Presentation_Forms_B}');
Error('\P{Is_Block:	:=Arabic_Presentation_Forms_B}');
Expect(1, 65279, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65279, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\p{Is_Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\p{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65280, '\P{Is_Block=arabicpresentationformsb}', "");
Expect(0, 65280, '\P{^Is_Block=arabicpresentationformsb}', "");
Expect(1, 65279, '\p{Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(0, 65279, '\p{^Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(0, 65279, '\P{Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(1, 65279, '\P{^Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(0, 65280, '\p{Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(1, 65280, '\p{^Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(1, 65280, '\P{Is_Block:_Arabic_Presentation_Forms_B}', "");
Expect(0, 65280, '\P{^Is_Block:_Arabic_Presentation_Forms_B}', "");
Error('\p{Is_Blk=/a/Arabic_PF_b}');
Error('\P{Is_Blk=/a/Arabic_PF_b}');
Expect(1, 65279, '\p{Is_Blk=arabicpfb}', "");
Expect(0, 65279, '\p{^Is_Blk=arabicpfb}', "");
Expect(0, 65279, '\P{Is_Blk=arabicpfb}', "");
Expect(1, 65279, '\P{^Is_Blk=arabicpfb}', "");
Expect(0, 65280, '\p{Is_Blk=arabicpfb}', "");
Expect(1, 65280, '\p{^Is_Blk=arabicpfb}', "");
Expect(1, 65280, '\P{Is_Blk=arabicpfb}', "");
Expect(0, 65280, '\P{^Is_Blk=arabicpfb}', "");
Expect(1, 65279, '\p{Is_Blk=-arabic_PF_B}', "");
Expect(0, 65279, '\p{^Is_Blk=-arabic_PF_B}', "");
Expect(0, 65279, '\P{Is_Blk=-arabic_PF_B}', "");
Expect(1, 65279, '\P{^Is_Blk=-arabic_PF_B}', "");
Expect(0, 65280, '\p{Is_Blk=-arabic_PF_B}', "");
Expect(1, 65280, '\p{^Is_Blk=-arabic_PF_B}', "");
Expect(1, 65280, '\P{Is_Blk=-arabic_PF_B}', "");
Expect(0, 65280, '\P{^Is_Blk=-arabic_PF_B}', "");
Error('\p{Block=	/a/arabic_supplement}');
Error('\P{Block=	/a/arabic_supplement}');
Expect(1, 1919, '\p{Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Block=arabicsupplement}', "");
Expect(0, 1920, '\p{Block=arabicsupplement}', "");
Expect(1, 1920, '\p{^Block=arabicsupplement}', "");
Expect(1, 1920, '\P{Block=arabicsupplement}', "");
Expect(0, 1920, '\P{^Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Block= Arabic_SUPPLEMENT}', "");
Expect(0, 1919, '\p{^Block= Arabic_SUPPLEMENT}', "");
Expect(0, 1919, '\P{Block= Arabic_SUPPLEMENT}', "");
Expect(1, 1919, '\P{^Block= Arabic_SUPPLEMENT}', "");
Expect(0, 1920, '\p{Block= Arabic_SUPPLEMENT}', "");
Expect(1, 1920, '\p{^Block= Arabic_SUPPLEMENT}', "");
Expect(1, 1920, '\P{Block= Arabic_SUPPLEMENT}', "");
Expect(0, 1920, '\P{^Block= Arabic_SUPPLEMENT}', "");
Error('\p{Blk=:=_arabic_Sup}');
Error('\P{Blk=:=_arabic_Sup}');
Expect(1, 1919, '\p{Blk=arabicsup}', "");
Expect(0, 1919, '\p{^Blk=arabicsup}', "");
Expect(0, 1919, '\P{Blk=arabicsup}', "");
Expect(1, 1919, '\P{^Blk=arabicsup}', "");
Expect(0, 1920, '\p{Blk=arabicsup}', "");
Expect(1, 1920, '\p{^Blk=arabicsup}', "");
Expect(1, 1920, '\P{Blk=arabicsup}', "");
Expect(0, 1920, '\P{^Blk=arabicsup}', "");
Expect(1, 1919, '\p{Blk=	_Arabic_Sup}', "");
Expect(0, 1919, '\p{^Blk=	_Arabic_Sup}', "");
Expect(0, 1919, '\P{Blk=	_Arabic_Sup}', "");
Expect(1, 1919, '\P{^Blk=	_Arabic_Sup}', "");
Expect(0, 1920, '\p{Blk=	_Arabic_Sup}', "");
Expect(1, 1920, '\p{^Blk=	_Arabic_Sup}', "");
Expect(1, 1920, '\P{Blk=	_Arabic_Sup}', "");
Expect(0, 1920, '\P{^Blk=	_Arabic_Sup}', "");
Error('\p{Is_Block:   :=Arabic_Supplement}');
Error('\P{Is_Block:   :=Arabic_Supplement}');
Expect(1, 1919, '\p{Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\p{^Is_Block=arabicsupplement}', "");
Expect(0, 1919, '\P{Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\P{^Is_Block=arabicsupplement}', "");
Expect(0, 1920, '\p{Is_Block=arabicsupplement}', "");
Expect(1, 1920, '\p{^Is_Block=arabicsupplement}', "");
Expect(1, 1920, '\P{Is_Block=arabicsupplement}', "");
Expect(0, 1920, '\P{^Is_Block=arabicsupplement}', "");
Expect(1, 1919, '\p{Is_Block=_-ARABIC_supplement}', "");
Expect(0, 1919, '\p{^Is_Block=_-ARABIC_supplement}', "");
Expect(0, 1919, '\P{Is_Block=_-ARABIC_supplement}', "");
Expect(1, 1919, '\P{^Is_Block=_-ARABIC_supplement}', "");
Expect(0, 1920, '\p{Is_Block=_-ARABIC_supplement}', "");
Expect(1, 1920, '\p{^Is_Block=_-ARABIC_supplement}', "");
Expect(1, 1920, '\P{Is_Block=_-ARABIC_supplement}', "");
Expect(0, 1920, '\P{^Is_Block=_-ARABIC_supplement}', "");
Error('\p{Is_Blk=/a/ -ARABIC_SUP}');
Error('\P{Is_Blk=/a/ -ARABIC_SUP}');
Expect(1, 1919, '\p{Is_Blk=arabicsup}', "");
Expect(0, 1919, '\p{^Is_Blk=arabicsup}', "");
Expect(0, 1919, '\P{Is_Blk=arabicsup}', "");
Expect(1, 1919, '\P{^Is_Blk=arabicsup}', "");
Expect(0, 1920, '\p{Is_Blk=arabicsup}', "");
Expect(1, 1920, '\p{^Is_Blk=arabicsup}', "");
Expect(1, 1920, '\P{Is_Blk=arabicsup}', "");
Expect(0, 1920, '\P{^Is_Blk=arabicsup}', "");
Expect(1, 1919, '\p{Is_Blk=_arabic_Sup}', "");
Expect(0, 1919, '\p{^Is_Blk=_arabic_Sup}', "");
Expect(0, 1919, '\P{Is_Blk=_arabic_Sup}', "");
Expect(1, 1919, '\P{^Is_Blk=_arabic_Sup}', "");
Expect(0, 1920, '\p{Is_Blk=_arabic_Sup}', "");
Expect(1, 1920, '\p{^Is_Blk=_arabic_Sup}', "");
Expect(1, 1920, '\P{Is_Blk=_arabic_Sup}', "");
Expect(0, 1920, '\P{^Is_Blk=_arabic_Sup}', "");
Error('\p{Block=	Armenian/a/}');
Error('\P{Block=	Armenian/a/}');
Expect(1, 1423, '\p{Block=armenian}', "");
Expect(0, 1423, '\p{^Block=armenian}', "");
Expect(0, 1423, '\P{Block=armenian}', "");
Expect(1, 1423, '\P{^Block=armenian}', "");
Expect(0, 1424, '\p{Block=armenian}', "");
Expect(1, 1424, '\p{^Block=armenian}', "");
Expect(1, 1424, '\P{Block=armenian}', "");
Expect(0, 1424, '\P{^Block=armenian}', "");
Expect(1, 1423, '\p{Block: -Armenian}', "");
Expect(0, 1423, '\p{^Block: -Armenian}', "");
Expect(0, 1423, '\P{Block: -Armenian}', "");
Expect(1, 1423, '\P{^Block: -Armenian}', "");
Expect(0, 1424, '\p{Block: -Armenian}', "");
Expect(1, 1424, '\p{^Block: -Armenian}', "");
Expect(1, 1424, '\P{Block: -Armenian}', "");
Expect(0, 1424, '\P{^Block: -Armenian}', "");
Error('\p{Blk= Armenian:=}');
Error('\P{Blk= Armenian:=}');
Expect(1, 1423, '\p{Blk=armenian}', "");
Expect(0, 1423, '\p{^Blk=armenian}', "");
Expect(0, 1423, '\P{Blk=armenian}', "");
Expect(1, 1423, '\P{^Blk=armenian}', "");
Expect(0, 1424, '\p{Blk=armenian}', "");
Expect(1, 1424, '\p{^Blk=armenian}', "");
Expect(1, 1424, '\P{Blk=armenian}', "");
Expect(0, 1424, '\P{^Blk=armenian}', "");
Expect(1, 1423, '\p{Blk=		ARMENIAN}', "");
Expect(0, 1423, '\p{^Blk=		ARMENIAN}', "");
Expect(0, 1423, '\P{Blk=		ARMENIAN}', "");
Expect(1, 1423, '\P{^Blk=		ARMENIAN}', "");
Expect(0, 1424, '\p{Blk=		ARMENIAN}', "");
Expect(1, 1424, '\p{^Blk=		ARMENIAN}', "");
Expect(1, 1424, '\P{Blk=		ARMENIAN}', "");
Expect(0, 1424, '\P{^Blk=		ARMENIAN}', "");
Error('\p{Is_Block=:=		armenian}');
Error('\P{Is_Block=:=		armenian}');
Expect(1, 1423, '\p{Is_Block=armenian}', "");
Expect(0, 1423, '\p{^Is_Block=armenian}', "");
Expect(0, 1423, '\P{Is_Block=armenian}', "");
Expect(1, 1423, '\P{^Is_Block=armenian}', "");
Expect(0, 1424, '\p{Is_Block=armenian}', "");
Expect(1, 1424, '\p{^Is_Block=armenian}', "");
Expect(1, 1424, '\P{Is_Block=armenian}', "");
Expect(0, 1424, '\P{^Is_Block=armenian}', "");
Expect(1, 1423, '\p{Is_Block=_-Armenian}', "");
Expect(0, 1423, '\p{^Is_Block=_-Armenian}', "");
Expect(0, 1423, '\P{Is_Block=_-Armenian}', "");
Expect(1, 1423, '\P{^Is_Block=_-Armenian}', "");
Expect(0, 1424, '\p{Is_Block=_-Armenian}', "");
Expect(1, 1424, '\p{^Is_Block=_-Armenian}', "");
Expect(1, 1424, '\P{Is_Block=_-Armenian}', "");
Expect(0, 1424, '\P{^Is_Block=_-Armenian}', "");
Error('\p{Is_Blk:   _-Armenian:=}');
Error('\P{Is_Blk:   _-Armenian:=}');
Expect(1, 1423, '\p{Is_Blk:   armenian}', "");
Expect(0, 1423, '\p{^Is_Blk:   armenian}', "");
Expect(0, 1423, '\P{Is_Blk:   armenian}', "");
Expect(1, 1423, '\P{^Is_Blk:   armenian}', "");
Expect(0, 1424, '\p{Is_Blk:   armenian}', "");
Expect(1, 1424, '\p{^Is_Blk:   armenian}', "");
Expect(1, 1424, '\P{Is_Blk:   armenian}', "");
Expect(0, 1424, '\P{^Is_Blk:   armenian}', "");
Expect(1, 1423, '\p{Is_Blk=	_Armenian}', "");
Expect(0, 1423, '\p{^Is_Blk=	_Armenian}', "");
Expect(0, 1423, '\P{Is_Blk=	_Armenian}', "");
Expect(1, 1423, '\P{^Is_Blk=	_Armenian}', "");
Expect(0, 1424, '\p{Is_Blk=	_Armenian}', "");
Expect(1, 1424, '\p{^Is_Blk=	_Armenian}', "");
Expect(1, 1424, '\P{Is_Blk=	_Armenian}', "");
Expect(0, 1424, '\P{^Is_Blk=	_Armenian}', "");
Error('\p{Block=/a/Arrows}');
Error('\P{Block=/a/Arrows}');
Expect(1, 8703, '\p{Block=arrows}', "");
Expect(0, 8703, '\p{^Block=arrows}', "");
Expect(0, 8703, '\P{Block=arrows}', "");
Expect(1, 8703, '\P{^Block=arrows}', "");
Expect(0, 8704, '\p{Block=arrows}', "");
Expect(1, 8704, '\p{^Block=arrows}', "");
Expect(1, 8704, '\P{Block=arrows}', "");
Expect(0, 8704, '\P{^Block=arrows}', "");
Expect(1, 8703, '\p{Block=_arrows}', "");
Expect(0, 8703, '\p{^Block=_arrows}', "");
Expect(0, 8703, '\P{Block=_arrows}', "");
Expect(1, 8703, '\P{^Block=_arrows}', "");
Expect(0, 8704, '\p{Block=_arrows}', "");
Expect(1, 8704, '\p{^Block=_arrows}', "");
Expect(1, 8704, '\P{Block=_arrows}', "");
Expect(0, 8704, '\P{^Block=_arrows}', "");
Error('\p{Blk=/a/ _ARROWS}');
Error('\P{Blk=/a/ _ARROWS}');
Expect(1, 8703, '\p{Blk=arrows}', "");
Expect(0, 8703, '\p{^Blk=arrows}', "");
Expect(0, 8703, '\P{Blk=arrows}', "");
Expect(1, 8703, '\P{^Blk=arrows}', "");
Expect(0, 8704, '\p{Blk=arrows}', "");
Expect(1, 8704, '\p{^Blk=arrows}', "");
Expect(1, 8704, '\P{Blk=arrows}', "");
Expect(0, 8704, '\P{^Blk=arrows}', "");
Expect(1, 8703, '\p{Blk=	-arrows}', "");
Expect(0, 8703, '\p{^Blk=	-arrows}', "");
Expect(0, 8703, '\P{Blk=	-arrows}', "");
Expect(1, 8703, '\P{^Blk=	-arrows}', "");
Expect(0, 8704, '\p{Blk=	-arrows}', "");
Expect(1, 8704, '\p{^Blk=	-arrows}', "");
Expect(1, 8704, '\P{Blk=	-arrows}', "");
Expect(0, 8704, '\P{^Blk=	-arrows}', "");
Error('\p{Is_Block=/a/ arrows}');
Error('\P{Is_Block=/a/ arrows}');
Expect(1, 8703, '\p{Is_Block=arrows}', "");
Expect(0, 8703, '\p{^Is_Block=arrows}', "");
Expect(0, 8703, '\P{Is_Block=arrows}', "");
Expect(1, 8703, '\P{^Is_Block=arrows}', "");
Expect(0, 8704, '\p{Is_Block=arrows}', "");
Expect(1, 8704, '\p{^Is_Block=arrows}', "");
Expect(1, 8704, '\P{Is_Block=arrows}', "");
Expect(0, 8704, '\P{^Is_Block=arrows}', "");
Expect(1, 8703, '\p{Is_Block=	arrows}', "");
Expect(0, 8703, '\p{^Is_Block=	arrows}', "");
Expect(0, 8703, '\P{Is_Block=	arrows}', "");
Expect(1, 8703, '\P{^Is_Block=	arrows}', "");
Expect(0, 8704, '\p{Is_Block=	arrows}', "");
Expect(1, 8704, '\p{^Is_Block=	arrows}', "");
Expect(1, 8704, '\P{Is_Block=	arrows}', "");
Expect(0, 8704, '\P{^Is_Block=	arrows}', "");
Error('\p{Is_Blk=/a/Arrows}');
Error('\P{Is_Blk=/a/Arrows}');
Expect(1, 8703, '\p{Is_Blk=arrows}', "");
Expect(0, 8703, '\p{^Is_Blk=arrows}', "");
Expect(0, 8703, '\P{Is_Blk=arrows}', "");
Expect(1, 8703, '\P{^Is_Blk=arrows}', "");
Expect(0, 8704, '\p{Is_Blk=arrows}', "");
Expect(1, 8704, '\p{^Is_Blk=arrows}', "");
Expect(1, 8704, '\P{Is_Blk=arrows}', "");
Expect(0, 8704, '\P{^Is_Blk=arrows}', "");
Expect(1, 8703, '\p{Is_Blk: --Arrows}', "");
Expect(0, 8703, '\p{^Is_Blk: --Arrows}', "");
Expect(0, 8703, '\P{Is_Blk: --Arrows}', "");
Expect(1, 8703, '\P{^Is_Blk: --Arrows}', "");
Expect(0, 8704, '\p{Is_Blk: --Arrows}', "");
Expect(1, 8704, '\p{^Is_Blk: --Arrows}', "");
Expect(1, 8704, '\P{Is_Blk: --Arrows}', "");
Expect(0, 8704, '\P{^Is_Blk: --Arrows}', "");
Error('\p{Block=	/a/avestan}');
Error('\P{Block=	/a/avestan}');
Expect(1, 68415, '\p{Block=avestan}', "");
Expect(0, 68415, '\p{^Block=avestan}', "");
Expect(0, 68415, '\P{Block=avestan}', "");
Expect(1, 68415, '\P{^Block=avestan}', "");
Expect(0, 68416, '\p{Block=avestan}', "");
Expect(1, 68416, '\p{^Block=avestan}', "");
Expect(1, 68416, '\P{Block=avestan}', "");
Expect(0, 68416, '\P{^Block=avestan}', "");
Expect(1, 68415, '\p{Block=-	AVESTAN}', "");
Expect(0, 68415, '\p{^Block=-	AVESTAN}', "");
Expect(0, 68415, '\P{Block=-	AVESTAN}', "");
Expect(1, 68415, '\P{^Block=-	AVESTAN}', "");
Expect(0, 68416, '\p{Block=-	AVESTAN}', "");
Expect(1, 68416, '\p{^Block=-	AVESTAN}', "");
Expect(1, 68416, '\P{Block=-	AVESTAN}', "");
Expect(0, 68416, '\P{^Block=-	AVESTAN}', "");
Error('\p{Blk=-/a/avestan}');
Error('\P{Blk=-/a/avestan}');
Expect(1, 68415, '\p{Blk:	avestan}', "");
Expect(0, 68415, '\p{^Blk:	avestan}', "");
Expect(0, 68415, '\P{Blk:	avestan}', "");
Expect(1, 68415, '\P{^Blk:	avestan}', "");
Expect(0, 68416, '\p{Blk:	avestan}', "");
Expect(1, 68416, '\p{^Blk:	avestan}', "");
Expect(1, 68416, '\P{Blk:	avestan}', "");
Expect(0, 68416, '\P{^Blk:	avestan}', "");
Expect(1, 68415, '\p{Blk= AVESTAN}', "");
Expect(0, 68415, '\p{^Blk= AVESTAN}', "");
Expect(0, 68415, '\P{Blk= AVESTAN}', "");
Expect(1, 68415, '\P{^Blk= AVESTAN}', "");
Expect(0, 68416, '\p{Blk= AVESTAN}', "");
Expect(1, 68416, '\p{^Blk= AVESTAN}', "");
Expect(1, 68416, '\P{Blk= AVESTAN}', "");
Expect(0, 68416, '\P{^Blk= AVESTAN}', "");
Error('\p{Is_Block=:=	-avestan}');
Error('\P{Is_Block=:=	-avestan}');
Expect(1, 68415, '\p{Is_Block=avestan}', "");
Expect(0, 68415, '\p{^Is_Block=avestan}', "");
Expect(0, 68415, '\P{Is_Block=avestan}', "");
Expect(1, 68415, '\P{^Is_Block=avestan}', "");
Expect(0, 68416, '\p{Is_Block=avestan}', "");
Expect(1, 68416, '\p{^Is_Block=avestan}', "");
Expect(1, 68416, '\P{Is_Block=avestan}', "");
Expect(0, 68416, '\P{^Is_Block=avestan}', "");
Expect(1, 68415, '\p{Is_Block=-avestan}', "");
Expect(0, 68415, '\p{^Is_Block=-avestan}', "");
Expect(0, 68415, '\P{Is_Block=-avestan}', "");
Expect(1, 68415, '\P{^Is_Block=-avestan}', "");
Expect(0, 68416, '\p{Is_Block=-avestan}', "");
Expect(1, 68416, '\p{^Is_Block=-avestan}', "");
Expect(1, 68416, '\P{Is_Block=-avestan}', "");
Expect(0, 68416, '\P{^Is_Block=-avestan}', "");
Error('\p{Is_Blk=/a/Avestan}');
Error('\P{Is_Blk=/a/Avestan}');
Expect(1, 68415, '\p{Is_Blk=avestan}', "");
Expect(0, 68415, '\p{^Is_Blk=avestan}', "");
Expect(0, 68415, '\P{Is_Blk=avestan}', "");
Expect(1, 68415, '\P{^Is_Blk=avestan}', "");
Expect(0, 68416, '\p{Is_Blk=avestan}', "");
Expect(1, 68416, '\p{^Is_Blk=avestan}', "");
Expect(1, 68416, '\P{Is_Blk=avestan}', "");
Expect(0, 68416, '\P{^Is_Blk=avestan}', "");
Expect(1, 68415, '\p{Is_Blk= 	Avestan}', "");
Expect(0, 68415, '\p{^Is_Blk= 	Avestan}', "");
Expect(0, 68415, '\P{Is_Blk= 	Avestan}', "");
Expect(1, 68415, '\P{^Is_Blk= 	Avestan}', "");
Expect(0, 68416, '\p{Is_Blk= 	Avestan}', "");
Expect(1, 68416, '\p{^Is_Blk= 	Avestan}', "");
Expect(1, 68416, '\P{Is_Blk= 	Avestan}', "");
Expect(0, 68416, '\P{^Is_Blk= 	Avestan}', "");
Error('\p{Block=_:=BALINESE}');
Error('\P{Block=_:=BALINESE}');
Expect(1, 7039, '\p{Block=balinese}', "");
Expect(0, 7039, '\p{^Block=balinese}', "");
Expect(0, 7039, '\P{Block=balinese}', "");
Expect(1, 7039, '\P{^Block=balinese}', "");
Expect(0, 7040, '\p{Block=balinese}', "");
Expect(1, 7040, '\p{^Block=balinese}', "");
Expect(1, 7040, '\P{Block=balinese}', "");
Expect(0, 7040, '\P{^Block=balinese}', "");
Expect(1, 7039, '\p{Block=_-Balinese}', "");
Expect(0, 7039, '\p{^Block=_-Balinese}', "");
Expect(0, 7039, '\P{Block=_-Balinese}', "");
Expect(1, 7039, '\P{^Block=_-Balinese}', "");
Expect(0, 7040, '\p{Block=_-Balinese}', "");
Expect(1, 7040, '\p{^Block=_-Balinese}', "");
Expect(1, 7040, '\P{Block=_-Balinese}', "");
Expect(0, 7040, '\P{^Block=_-Balinese}', "");
Error('\p{Blk=:=Balinese}');
Error('\P{Blk=:=Balinese}');
Expect(1, 7039, '\p{Blk=balinese}', "");
Expect(0, 7039, '\p{^Blk=balinese}', "");
Expect(0, 7039, '\P{Blk=balinese}', "");
Expect(1, 7039, '\P{^Blk=balinese}', "");
Expect(0, 7040, '\p{Blk=balinese}', "");
Expect(1, 7040, '\p{^Blk=balinese}', "");
Expect(1, 7040, '\P{Blk=balinese}', "");
Expect(0, 7040, '\P{^Blk=balinese}', "");
Expect(1, 7039, '\p{Blk=-BALINESE}', "");
Expect(0, 7039, '\p{^Blk=-BALINESE}', "");
Expect(0, 7039, '\P{Blk=-BALINESE}', "");
Expect(1, 7039, '\P{^Blk=-BALINESE}', "");
Expect(0, 7040, '\p{Blk=-BALINESE}', "");
Expect(1, 7040, '\p{^Blk=-BALINESE}', "");
Expect(1, 7040, '\P{Blk=-BALINESE}', "");
Expect(0, 7040, '\P{^Blk=-BALINESE}', "");
Error('\p{Is_Block=		Balinese/a/}');
Error('\P{Is_Block=		Balinese/a/}');
Expect(1, 7039, '\p{Is_Block=balinese}', "");
Expect(0, 7039, '\p{^Is_Block=balinese}', "");
Expect(0, 7039, '\P{Is_Block=balinese}', "");
Expect(1, 7039, '\P{^Is_Block=balinese}', "");
Expect(0, 7040, '\p{Is_Block=balinese}', "");
Expect(1, 7040, '\p{^Is_Block=balinese}', "");
Expect(1, 7040, '\P{Is_Block=balinese}', "");
Expect(0, 7040, '\P{^Is_Block=balinese}', "");
Expect(1, 7039, '\p{Is_Block:	 -Balinese}', "");
Expect(0, 7039, '\p{^Is_Block:	 -Balinese}', "");
Expect(0, 7039, '\P{Is_Block:	 -Balinese}', "");
Expect(1, 7039, '\P{^Is_Block:	 -Balinese}', "");
Expect(0, 7040, '\p{Is_Block:	 -Balinese}', "");
Expect(1, 7040, '\p{^Is_Block:	 -Balinese}', "");
Expect(1, 7040, '\P{Is_Block:	 -Balinese}', "");
Expect(0, 7040, '\P{^Is_Block:	 -Balinese}', "");
Error('\p{Is_Blk=/a/Balinese}');
Error('\P{Is_Blk=/a/Balinese}');
Expect(1, 7039, '\p{Is_Blk=balinese}', "");
Expect(0, 7039, '\p{^Is_Blk=balinese}', "");
Expect(0, 7039, '\P{Is_Blk=balinese}', "");
Expect(1, 7039, '\P{^Is_Blk=balinese}', "");
Expect(0, 7040, '\p{Is_Blk=balinese}', "");
Expect(1, 7040, '\p{^Is_Blk=balinese}', "");
Expect(1, 7040, '\P{Is_Blk=balinese}', "");
Expect(0, 7040, '\P{^Is_Blk=balinese}', "");
Expect(1, 7039, '\p{Is_Blk= -Balinese}', "");
Expect(0, 7039, '\p{^Is_Blk= -Balinese}', "");
Expect(0, 7039, '\P{Is_Blk= -Balinese}', "");
Expect(1, 7039, '\P{^Is_Blk= -Balinese}', "");
Expect(0, 7040, '\p{Is_Blk= -Balinese}', "");
Expect(1, 7040, '\p{^Is_Blk= -Balinese}', "");
Expect(1, 7040, '\P{Is_Blk= -Balinese}', "");
Expect(0, 7040, '\P{^Is_Blk= -Balinese}', "");
Error('\p{Block=/a/_	BAMUM}');
Error('\P{Block=/a/_	BAMUM}');
Expect(1, 42751, '\p{Block=bamum}', "");
Expect(0, 42751, '\p{^Block=bamum}', "");
Expect(0, 42751, '\P{Block=bamum}', "");
Expect(1, 42751, '\P{^Block=bamum}', "");
Expect(0, 42752, '\p{Block=bamum}', "");
Expect(1, 42752, '\p{^Block=bamum}', "");
Expect(1, 42752, '\P{Block=bamum}', "");
Expect(0, 42752, '\P{^Block=bamum}', "");
Expect(1, 42751, '\p{Block=- Bamum}', "");
Expect(0, 42751, '\p{^Block=- Bamum}', "");
Expect(0, 42751, '\P{Block=- Bamum}', "");
Expect(1, 42751, '\P{^Block=- Bamum}', "");
Expect(0, 42752, '\p{Block=- Bamum}', "");
Expect(1, 42752, '\p{^Block=- Bamum}', "");
Expect(1, 42752, '\P{Block=- Bamum}', "");
Expect(0, 42752, '\P{^Block=- Bamum}', "");
Error('\p{Blk=:=-Bamum}');
Error('\P{Blk=:=-Bamum}');
Expect(1, 42751, '\p{Blk=bamum}', "");
Expect(0, 42751, '\p{^Blk=bamum}', "");
Expect(0, 42751, '\P{Blk=bamum}', "");
Expect(1, 42751, '\P{^Blk=bamum}', "");
Expect(0, 42752, '\p{Blk=bamum}', "");
Expect(1, 42752, '\p{^Blk=bamum}', "");
Expect(1, 42752, '\P{Blk=bamum}', "");
Expect(0, 42752, '\P{^Blk=bamum}', "");
Expect(1, 42751, '\p{Blk= _Bamum}', "");
Expect(0, 42751, '\p{^Blk= _Bamum}', "");
Expect(0, 42751, '\P{Blk= _Bamum}', "");
Expect(1, 42751, '\P{^Blk= _Bamum}', "");
Expect(0, 42752, '\p{Blk= _Bamum}', "");
Expect(1, 42752, '\p{^Blk= _Bamum}', "");
Expect(1, 42752, '\P{Blk= _Bamum}', "");
Expect(0, 42752, '\P{^Blk= _Bamum}', "");
Error('\p{Is_Block=_	Bamum/a/}');
Error('\P{Is_Block=_	Bamum/a/}');
Expect(1, 42751, '\p{Is_Block=bamum}', "");
Expect(0, 42751, '\p{^Is_Block=bamum}', "");
Expect(0, 42751, '\P{Is_Block=bamum}', "");
Expect(1, 42751, '\P{^Is_Block=bamum}', "");
Expect(0, 42752, '\p{Is_Block=bamum}', "");
Expect(1, 42752, '\p{^Is_Block=bamum}', "");
Expect(1, 42752, '\P{Is_Block=bamum}', "");
Expect(0, 42752, '\P{^Is_Block=bamum}', "");
Expect(1, 42751, '\p{Is_Block=--Bamum}', "");
Expect(0, 42751, '\p{^Is_Block=--Bamum}', "");
Expect(0, 42751, '\P{Is_Block=--Bamum}', "");
Expect(1, 42751, '\P{^Is_Block=--Bamum}', "");
Expect(0, 42752, '\p{Is_Block=--Bamum}', "");
Expect(1, 42752, '\p{^Is_Block=--Bamum}', "");
Expect(1, 42752, '\P{Is_Block=--Bamum}', "");
Expect(0, 42752, '\P{^Is_Block=--Bamum}', "");
Error('\p{Is_Blk=-_Bamum:=}');
Error('\P{Is_Blk=-_Bamum:=}');
Expect(1, 42751, '\p{Is_Blk=bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=bamum}', "");
Expect(0, 42751, '\P{Is_Blk=bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=bamum}', "");
Expect(0, 42752, '\p{Is_Blk=bamum}', "");
Expect(1, 42752, '\p{^Is_Blk=bamum}', "");
Expect(1, 42752, '\P{Is_Blk=bamum}', "");
Expect(0, 42752, '\P{^Is_Blk=bamum}', "");
Expect(1, 42751, '\p{Is_Blk=-_Bamum}', "");
Expect(0, 42751, '\p{^Is_Blk=-_Bamum}', "");
Expect(0, 42751, '\P{Is_Blk=-_Bamum}', "");
Expect(1, 42751, '\P{^Is_Blk=-_Bamum}', "");
Expect(0, 42752, '\p{Is_Blk=-_Bamum}', "");
Expect(1, 42752, '\p{^Is_Blk=-_Bamum}', "");
Expect(1, 42752, '\P{Is_Blk=-_Bamum}', "");
Expect(0, 42752, '\P{^Is_Blk=-_Bamum}', "");
Error('\p{Block=	/a/Bamum_Supplement}');
Error('\P{Block=	/a/Bamum_Supplement}');
Expect(1, 92735, '\p{Block=bamumsupplement}', "");
Expect(0, 92735, '\p{^Block=bamumsupplement}', "");
Expect(0, 92735, '\P{Block=bamumsupplement}', "");
Expect(1, 92735, '\P{^Block=bamumsupplement}', "");
Expect(0, 92736, '\p{Block=bamumsupplement}', "");
Expect(1, 92736, '\p{^Block=bamumsupplement}', "");
Expect(1, 92736, '\P{Block=bamumsupplement}', "");
Expect(0, 92736, '\P{^Block=bamumsupplement}', "");
Expect(1, 92735, '\p{Block=  bamum_SUPPLEMENT}', "");
Expect(0, 92735, '\p{^Block=  bamum_SUPPLEMENT}', "");
Expect(0, 92735, '\P{Block=  bamum_SUPPLEMENT}', "");
Expect(1, 92735, '\P{^Block=  bamum_SUPPLEMENT}', "");
Expect(0, 92736, '\p{Block=  bamum_SUPPLEMENT}', "");
Expect(1, 92736, '\p{^Block=  bamum_SUPPLEMENT}', "");
Expect(1, 92736, '\P{Block=  bamum_SUPPLEMENT}', "");
Expect(0, 92736, '\P{^Block=  bamum_SUPPLEMENT}', "");
Error('\p{Blk=	/a/BAMUM_sup}');
Error('\P{Blk=	/a/BAMUM_sup}');
Expect(1, 92735, '\p{Blk=bamumsup}', "");
Expect(0, 92735, '\p{^Blk=bamumsup}', "");
Expect(0, 92735, '\P{Blk=bamumsup}', "");
Expect(1, 92735, '\P{^Blk=bamumsup}', "");
Expect(0, 92736, '\p{Blk=bamumsup}', "");
Expect(1, 92736, '\p{^Blk=bamumsup}', "");
Expect(1, 92736, '\P{Blk=bamumsup}', "");
Expect(0, 92736, '\P{^Blk=bamumsup}', "");
Expect(1, 92735, '\p{Blk=	 bamum_Sup}', "");
Expect(0, 92735, '\p{^Blk=	 bamum_Sup}', "");
Expect(0, 92735, '\P{Blk=	 bamum_Sup}', "");
Expect(1, 92735, '\P{^Blk=	 bamum_Sup}', "");
Expect(0, 92736, '\p{Blk=	 bamum_Sup}', "");
Expect(1, 92736, '\p{^Blk=	 bamum_Sup}', "");
Expect(1, 92736, '\P{Blk=	 bamum_Sup}', "");
Expect(0, 92736, '\P{^Blk=	 bamum_Sup}', "");
Error('\p{Is_Block=-/a/Bamum_Supplement}');
Error('\P{Is_Block=-/a/Bamum_Supplement}');
Expect(1, 92735, '\p{Is_Block=bamumsupplement}', "");
Expect(0, 92735, '\p{^Is_Block=bamumsupplement}', "");
Expect(0, 92735, '\P{Is_Block=bamumsupplement}', "");
Expect(1, 92735, '\P{^Is_Block=bamumsupplement}', "");
Expect(0, 92736, '\p{Is_Block=bamumsupplement}', "");
Expect(1, 92736, '\p{^Is_Block=bamumsupplement}', "");
Expect(1, 92736, '\P{Is_Block=bamumsupplement}', "");
Expect(0, 92736, '\P{^Is_Block=bamumsupplement}', "");
Expect(1, 92735, '\p{Is_Block:	-_BAMUM_Supplement}', "");
Expect(0, 92735, '\p{^Is_Block:	-_BAMUM_Supplement}', "");
Expect(0, 92735, '\P{Is_Block:	-_BAMUM_Supplement}', "");
Expect(1, 92735, '\P{^Is_Block:	-_BAMUM_Supplement}', "");
Expect(0, 92736, '\p{Is_Block:	-_BAMUM_Supplement}', "");
Expect(1, 92736, '\p{^Is_Block:	-_BAMUM_Supplement}', "");
Expect(1, 92736, '\P{Is_Block:	-_BAMUM_Supplement}', "");
Expect(0, 92736, '\P{^Is_Block:	-_BAMUM_Supplement}', "");
Error('\p{Is_Blk=:=- Bamum_Sup}');
Error('\P{Is_Blk=:=- Bamum_Sup}');
Expect(1, 92735, '\p{Is_Blk=bamumsup}', "");
Expect(0, 92735, '\p{^Is_Blk=bamumsup}', "");
Expect(0, 92735, '\P{Is_Blk=bamumsup}', "");
Expect(1, 92735, '\P{^Is_Blk=bamumsup}', "");
Expect(0, 92736, '\p{Is_Blk=bamumsup}', "");
Expect(1, 92736, '\p{^Is_Blk=bamumsup}', "");
Expect(1, 92736, '\P{Is_Blk=bamumsup}', "");
Expect(0, 92736, '\P{^Is_Blk=bamumsup}', "");
Expect(1, 92735, '\p{Is_Blk=	 Bamum_sup}', "");
Expect(0, 92735, '\p{^Is_Blk=	 Bamum_sup}', "");
Expect(0, 92735, '\P{Is_Blk=	 Bamum_sup}', "");
Expect(1, 92735, '\P{^Is_Blk=	 Bamum_sup}', "");
Expect(0, 92736, '\p{Is_Blk=	 Bamum_sup}', "");
Expect(1, 92736, '\p{^Is_Blk=	 Bamum_sup}', "");
Expect(1, 92736, '\P{Is_Blk=	 Bamum_sup}', "");
Expect(0, 92736, '\P{^Is_Blk=	 Bamum_sup}', "");
Error('\p{Block=/a/  Bassa_Vah}');
Error('\P{Block=/a/  Bassa_Vah}');
Expect(1, 92927, '\p{Block=bassavah}', "");
Expect(0, 92927, '\p{^Block=bassavah}', "");
Expect(0, 92927, '\P{Block=bassavah}', "");
Expect(1, 92927, '\P{^Block=bassavah}', "");
Expect(0, 92928, '\p{Block=bassavah}', "");
Expect(1, 92928, '\p{^Block=bassavah}', "");
Expect(1, 92928, '\P{Block=bassavah}', "");
Expect(0, 92928, '\P{^Block=bassavah}', "");
Expect(1, 92927, '\p{Block=__Bassa_Vah}', "");
Expect(0, 92927, '\p{^Block=__Bassa_Vah}', "");
Expect(0, 92927, '\P{Block=__Bassa_Vah}', "");
Expect(1, 92927, '\P{^Block=__Bassa_Vah}', "");
Expect(0, 92928, '\p{Block=__Bassa_Vah}', "");
Expect(1, 92928, '\p{^Block=__Bassa_Vah}', "");
Expect(1, 92928, '\P{Block=__Bassa_Vah}', "");
Expect(0, 92928, '\P{^Block=__Bassa_Vah}', "");
Error('\p{Blk=-/a/Bassa_VAH}');
Error('\P{Blk=-/a/Bassa_VAH}');
Expect(1, 92927, '\p{Blk=bassavah}', "");
Expect(0, 92927, '\p{^Blk=bassavah}', "");
Expect(0, 92927, '\P{Blk=bassavah}', "");
Expect(1, 92927, '\P{^Blk=bassavah}', "");
Expect(0, 92928, '\p{Blk=bassavah}', "");
Expect(1, 92928, '\p{^Blk=bassavah}', "");
Expect(1, 92928, '\P{Blk=bassavah}', "");
Expect(0, 92928, '\P{^Blk=bassavah}', "");
Expect(1, 92927, '\p{Blk=		bassa_vah}', "");
Expect(0, 92927, '\p{^Blk=		bassa_vah}', "");
Expect(0, 92927, '\P{Blk=		bassa_vah}', "");
Expect(1, 92927, '\P{^Blk=		bassa_vah}', "");
Expect(0, 92928, '\p{Blk=		bassa_vah}', "");
Expect(1, 92928, '\p{^Blk=		bassa_vah}', "");
Expect(1, 92928, '\P{Blk=		bassa_vah}', "");
Expect(0, 92928, '\P{^Blk=		bassa_vah}', "");
Error('\p{Is_Block=_	BASSA_vah:=}');
Error('\P{Is_Block=_	BASSA_vah:=}');
Expect(1, 92927, '\p{Is_Block=bassavah}', "");
Expect(0, 92927, '\p{^Is_Block=bassavah}', "");
Expect(0, 92927, '\P{Is_Block=bassavah}', "");
Expect(1, 92927, '\P{^Is_Block=bassavah}', "");
Expect(0, 92928, '\p{Is_Block=bassavah}', "");
Expect(1, 92928, '\p{^Is_Block=bassavah}', "");
Expect(1, 92928, '\P{Is_Block=bassavah}', "");
Expect(0, 92928, '\P{^Is_Block=bassavah}', "");
Expect(1, 92927, '\p{Is_Block=  Bassa_Vah}', "");
Expect(0, 92927, '\p{^Is_Block=  Bassa_Vah}', "");
Expect(0, 92927, '\P{Is_Block=  Bassa_Vah}', "");
Expect(1, 92927, '\P{^Is_Block=  Bassa_Vah}', "");
Expect(0, 92928, '\p{Is_Block=  Bassa_Vah}', "");
Expect(1, 92928, '\p{^Is_Block=  Bassa_Vah}', "");
Expect(1, 92928, '\P{Is_Block=  Bassa_Vah}', "");
Expect(0, 92928, '\P{^Is_Block=  Bassa_Vah}', "");
Error('\p{Is_Blk=	-BASSA_Vah/a/}');
Error('\P{Is_Blk=	-BASSA_Vah/a/}');
Expect(1, 92927, '\p{Is_Blk=bassavah}', "");
Expect(0, 92927, '\p{^Is_Blk=bassavah}', "");
Expect(0, 92927, '\P{Is_Blk=bassavah}', "");
Expect(1, 92927, '\P{^Is_Blk=bassavah}', "");
Expect(0, 92928, '\p{Is_Blk=bassavah}', "");
Expect(1, 92928, '\p{^Is_Blk=bassavah}', "");
Expect(1, 92928, '\P{Is_Blk=bassavah}', "");
Expect(0, 92928, '\P{^Is_Blk=bassavah}', "");
Expect(1, 92927, '\p{Is_Blk= BASSA_Vah}', "");
Expect(0, 92927, '\p{^Is_Blk= BASSA_Vah}', "");
Expect(0, 92927, '\P{Is_Blk= BASSA_Vah}', "");
Expect(1, 92927, '\P{^Is_Blk= BASSA_Vah}', "");
Expect(0, 92928, '\p{Is_Blk= BASSA_Vah}', "");
Expect(1, 92928, '\p{^Is_Blk= BASSA_Vah}', "");
Expect(1, 92928, '\P{Is_Blk= BASSA_Vah}', "");
Expect(0, 92928, '\P{^Is_Blk= BASSA_Vah}', "");
Error('\p{Block=-Batak:=}');
Error('\P{Block=-Batak:=}');
Expect(1, 7167, '\p{Block=batak}', "");
Expect(0, 7167, '\p{^Block=batak}', "");
Expect(0, 7167, '\P{Block=batak}', "");
Expect(1, 7167, '\P{^Block=batak}', "");
Expect(0, 7168, '\p{Block=batak}', "");
Expect(1, 7168, '\p{^Block=batak}', "");
Expect(1, 7168, '\P{Block=batak}', "");
Expect(0, 7168, '\P{^Block=batak}', "");
Expect(1, 7167, '\p{Block:   __BATAK}', "");
Expect(0, 7167, '\p{^Block:   __BATAK}', "");
Expect(0, 7167, '\P{Block:   __BATAK}', "");
Expect(1, 7167, '\P{^Block:   __BATAK}', "");
Expect(0, 7168, '\p{Block:   __BATAK}', "");
Expect(1, 7168, '\p{^Block:   __BATAK}', "");
Expect(1, 7168, '\P{Block:   __BATAK}', "");
Expect(0, 7168, '\P{^Block:   __BATAK}', "");
Error('\p{Blk:   :=	-Batak}');
Error('\P{Blk:   :=	-Batak}');
Expect(1, 7167, '\p{Blk=batak}', "");
Expect(0, 7167, '\p{^Blk=batak}', "");
Expect(0, 7167, '\P{Blk=batak}', "");
Expect(1, 7167, '\P{^Blk=batak}', "");
Expect(0, 7168, '\p{Blk=batak}', "");
Expect(1, 7168, '\p{^Blk=batak}', "");
Expect(1, 7168, '\P{Blk=batak}', "");
Expect(0, 7168, '\P{^Blk=batak}', "");
Expect(1, 7167, '\p{Blk=Batak}', "");
Expect(0, 7167, '\p{^Blk=Batak}', "");
Expect(0, 7167, '\P{Blk=Batak}', "");
Expect(1, 7167, '\P{^Blk=Batak}', "");
Expect(0, 7168, '\p{Blk=Batak}', "");
Expect(1, 7168, '\p{^Blk=Batak}', "");
Expect(1, 7168, '\P{Blk=Batak}', "");
Expect(0, 7168, '\P{^Blk=Batak}', "");
Error('\p{Is_Block= :=BATAK}');
Error('\P{Is_Block= :=BATAK}');
Expect(1, 7167, '\p{Is_Block:batak}', "");
Expect(0, 7167, '\p{^Is_Block:batak}', "");
Expect(0, 7167, '\P{Is_Block:batak}', "");
Expect(1, 7167, '\P{^Is_Block:batak}', "");
Expect(0, 7168, '\p{Is_Block:batak}', "");
Expect(1, 7168, '\p{^Is_Block:batak}', "");
Expect(1, 7168, '\P{Is_Block:batak}', "");
Expect(0, 7168, '\P{^Is_Block:batak}', "");
Expect(1, 7167, '\p{Is_Block=  Batak}', "");
Expect(0, 7167, '\p{^Is_Block=  Batak}', "");
Expect(0, 7167, '\P{Is_Block=  Batak}', "");
Expect(1, 7167, '\P{^Is_Block=  Batak}', "");
Expect(0, 7168, '\p{Is_Block=  Batak}', "");
Expect(1, 7168, '\p{^Is_Block=  Batak}', "");
Expect(1, 7168, '\P{Is_Block=  Batak}', "");
Expect(0, 7168, '\P{^Is_Block=  Batak}', "");
Error('\p{Is_Blk=		Batak:=}');
Error('\P{Is_Blk=		Batak:=}');
Expect(1, 7167, '\p{Is_Blk=batak}', "");
Expect(0, 7167, '\p{^Is_Blk=batak}', "");
Expect(0, 7167, '\P{Is_Blk=batak}', "");
Expect(1, 7167, '\P{^Is_Blk=batak}', "");
Expect(0, 7168, '\p{Is_Blk=batak}', "");
Expect(1, 7168, '\p{^Is_Blk=batak}', "");
Expect(1, 7168, '\P{Is_Blk=batak}', "");
Expect(0, 7168, '\P{^Is_Blk=batak}', "");
Expect(1, 7167, '\p{Is_Blk:   BATAK}', "");
Expect(0, 7167, '\p{^Is_Blk:   BATAK}', "");
Expect(0, 7167, '\P{Is_Blk:   BATAK}', "");
Expect(1, 7167, '\P{^Is_Blk:   BATAK}', "");
Expect(0, 7168, '\p{Is_Blk:   BATAK}', "");
Expect(1, 7168, '\p{^Is_Blk:   BATAK}', "");
Expect(1, 7168, '\P{Is_Blk:   BATAK}', "");
Expect(0, 7168, '\P{^Is_Blk:   BATAK}', "");
Error('\p{Block=/a/	 Bengali}');
Error('\P{Block=/a/	 Bengali}');
Expect(1, 2559, '\p{Block=bengali}', "");
Expect(0, 2559, '\p{^Block=bengali}', "");
Expect(0, 2559, '\P{Block=bengali}', "");
Expect(1, 2559, '\P{^Block=bengali}', "");
Expect(0, 2560, '\p{Block=bengali}', "");
Expect(1, 2560, '\p{^Block=bengali}', "");
Expect(1, 2560, '\P{Block=bengali}', "");
Expect(0, 2560, '\P{^Block=bengali}', "");
Expect(1, 2559, '\p{Block=-Bengali}', "");
Expect(0, 2559, '\p{^Block=-Bengali}', "");
Expect(0, 2559, '\P{Block=-Bengali}', "");
Expect(1, 2559, '\P{^Block=-Bengali}', "");
Expect(0, 2560, '\p{Block=-Bengali}', "");
Expect(1, 2560, '\p{^Block=-Bengali}', "");
Expect(1, 2560, '\P{Block=-Bengali}', "");
Expect(0, 2560, '\P{^Block=-Bengali}', "");
Error('\p{Blk=:=bengali}');
Error('\P{Blk=:=bengali}');
Expect(1, 2559, '\p{Blk=bengali}', "");
Expect(0, 2559, '\p{^Blk=bengali}', "");
Expect(0, 2559, '\P{Blk=bengali}', "");
Expect(1, 2559, '\P{^Blk=bengali}', "");
Expect(0, 2560, '\p{Blk=bengali}', "");
Expect(1, 2560, '\p{^Blk=bengali}', "");
Expect(1, 2560, '\P{Blk=bengali}', "");
Expect(0, 2560, '\P{^Blk=bengali}', "");
Expect(1, 2559, '\p{Blk=	-Bengali}', "");
Expect(0, 2559, '\p{^Blk=	-Bengali}', "");
Expect(0, 2559, '\P{Blk=	-Bengali}', "");
Expect(1, 2559, '\P{^Blk=	-Bengali}', "");
Expect(0, 2560, '\p{Blk=	-Bengali}', "");
Expect(1, 2560, '\p{^Blk=	-Bengali}', "");
Expect(1, 2560, '\P{Blk=	-Bengali}', "");
Expect(0, 2560, '\P{^Blk=	-Bengali}', "");
Error('\p{Is_Block=:=--bengali}');
Error('\P{Is_Block=:=--bengali}');
Expect(1, 2559, '\p{Is_Block=bengali}', "");
Expect(0, 2559, '\p{^Is_Block=bengali}', "");
Expect(0, 2559, '\P{Is_Block=bengali}', "");
Expect(1, 2559, '\P{^Is_Block=bengali}', "");
Expect(0, 2560, '\p{Is_Block=bengali}', "");
Expect(1, 2560, '\p{^Is_Block=bengali}', "");
Expect(1, 2560, '\P{Is_Block=bengali}', "");
Expect(0, 2560, '\P{^Is_Block=bengali}', "");
Expect(1, 2559, '\p{Is_Block=_Bengali}', "");
Expect(0, 2559, '\p{^Is_Block=_Bengali}', "");
Expect(0, 2559, '\P{Is_Block=_Bengali}', "");
Expect(1, 2559, '\P{^Is_Block=_Bengali}', "");
Expect(0, 2560, '\p{Is_Block=_Bengali}', "");
Expect(1, 2560, '\p{^Is_Block=_Bengali}', "");
Expect(1, 2560, '\P{Is_Block=_Bengali}', "");
Expect(0, 2560, '\P{^Is_Block=_Bengali}', "");
Error('\p{Is_Blk= bengali/a/}');
Error('\P{Is_Blk= bengali/a/}');
Expect(1, 2559, '\p{Is_Blk=bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=bengali}', "");
Expect(0, 2559, '\P{Is_Blk=bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=bengali}', "");
Expect(0, 2560, '\p{Is_Blk=bengali}', "");
Expect(1, 2560, '\p{^Is_Blk=bengali}', "");
Expect(1, 2560, '\P{Is_Blk=bengali}', "");
Expect(0, 2560, '\P{^Is_Blk=bengali}', "");
Expect(1, 2559, '\p{Is_Blk=-	Bengali}', "");
Expect(0, 2559, '\p{^Is_Blk=-	Bengali}', "");
Expect(0, 2559, '\P{Is_Blk=-	Bengali}', "");
Expect(1, 2559, '\P{^Is_Blk=-	Bengali}', "");
Expect(0, 2560, '\p{Is_Blk=-	Bengali}', "");
Expect(1, 2560, '\p{^Is_Blk=-	Bengali}', "");
Expect(1, 2560, '\P{Is_Blk=-	Bengali}', "");
Expect(0, 2560, '\P{^Is_Blk=-	Bengali}', "");
Error('\p{Block=_/a/block_elements}');
Error('\P{Block=_/a/block_elements}');
Expect(1, 9631, '\p{Block=blockelements}', "");
Expect(0, 9631, '\p{^Block=blockelements}', "");
Expect(0, 9631, '\P{Block=blockelements}', "");
Expect(1, 9631, '\P{^Block=blockelements}', "");
Expect(0, 9632, '\p{Block=blockelements}', "");
Expect(1, 9632, '\p{^Block=blockelements}', "");
Expect(1, 9632, '\P{Block=blockelements}', "");
Expect(0, 9632, '\P{^Block=blockelements}', "");
Expect(1, 9631, '\p{Block= _BLOCK_ELEMENTS}', "");
Expect(0, 9631, '\p{^Block= _BLOCK_ELEMENTS}', "");
Expect(0, 9631, '\P{Block= _BLOCK_ELEMENTS}', "");
Expect(1, 9631, '\P{^Block= _BLOCK_ELEMENTS}', "");
Expect(0, 9632, '\p{Block= _BLOCK_ELEMENTS}', "");
Expect(1, 9632, '\p{^Block= _BLOCK_ELEMENTS}', "");
Expect(1, 9632, '\P{Block= _BLOCK_ELEMENTS}', "");
Expect(0, 9632, '\P{^Block= _BLOCK_ELEMENTS}', "");
Error('\p{Blk=-_Block_elements:=}');
Error('\P{Blk=-_Block_elements:=}');
Expect(1, 9631, '\p{Blk=blockelements}', "");
Expect(0, 9631, '\p{^Blk=blockelements}', "");
Expect(0, 9631, '\P{Blk=blockelements}', "");
Expect(1, 9631, '\P{^Blk=blockelements}', "");
Expect(0, 9632, '\p{Blk=blockelements}', "");
Expect(1, 9632, '\p{^Blk=blockelements}', "");
Expect(1, 9632, '\P{Blk=blockelements}', "");
Expect(0, 9632, '\P{^Blk=blockelements}', "");
Expect(1, 9631, '\p{Blk=  Block_ELEMENTS}', "");
Expect(0, 9631, '\p{^Blk=  Block_ELEMENTS}', "");
Expect(0, 9631, '\P{Blk=  Block_ELEMENTS}', "");
Expect(1, 9631, '\P{^Blk=  Block_ELEMENTS}', "");
Expect(0, 9632, '\p{Blk=  Block_ELEMENTS}', "");
Expect(1, 9632, '\p{^Blk=  Block_ELEMENTS}', "");
Expect(1, 9632, '\P{Blk=  Block_ELEMENTS}', "");
Expect(0, 9632, '\P{^Blk=  Block_ELEMENTS}', "");
Error('\p{Is_Block:	block_Elements/a/}');
Error('\P{Is_Block:	block_Elements/a/}');
Expect(1, 9631, '\p{Is_Block=blockelements}', "");
Expect(0, 9631, '\p{^Is_Block=blockelements}', "");
Expect(0, 9631, '\P{Is_Block=blockelements}', "");
Expect(1, 9631, '\P{^Is_Block=blockelements}', "");
Expect(0, 9632, '\p{Is_Block=blockelements}', "");
Expect(1, 9632, '\p{^Is_Block=blockelements}', "");
Expect(1, 9632, '\P{Is_Block=blockelements}', "");
Expect(0, 9632, '\P{^Is_Block=blockelements}', "");
Expect(1, 9631, '\p{Is_Block=-_BLOCK_elements}', "");
Expect(0, 9631, '\p{^Is_Block=-_BLOCK_elements}', "");
Expect(0, 9631, '\P{Is_Block=-_BLOCK_elements}', "");
Expect(1, 9631, '\P{^Is_Block=-_BLOCK_elements}', "");
Expect(0, 9632, '\p{Is_Block=-_BLOCK_elements}', "");
Expect(1, 9632, '\p{^Is_Block=-_BLOCK_elements}', "");
Expect(1, 9632, '\P{Is_Block=-_BLOCK_elements}', "");
Expect(0, 9632, '\P{^Is_Block=-_BLOCK_elements}', "");
Error('\p{Is_Blk=_/a/block_Elements}');
Error('\P{Is_Blk=_/a/block_Elements}');
Expect(1, 9631, '\p{Is_Blk=blockelements}', "");
Expect(0, 9631, '\p{^Is_Blk=blockelements}', "");
Expect(0, 9631, '\P{Is_Blk=blockelements}', "");
Expect(1, 9631, '\P{^Is_Blk=blockelements}', "");
Expect(0, 9632, '\p{Is_Blk=blockelements}', "");
Expect(1, 9632, '\p{^Is_Blk=blockelements}', "");
Expect(1, 9632, '\P{Is_Blk=blockelements}', "");
Expect(0, 9632, '\P{^Is_Blk=blockelements}', "");
Expect(1, 9631, '\p{Is_Blk=--BLOCK_Elements}', "");
Expect(0, 9631, '\p{^Is_Blk=--BLOCK_Elements}', "");
Expect(0, 9631, '\P{Is_Blk=--BLOCK_Elements}', "");
Expect(1, 9631, '\P{^Is_Blk=--BLOCK_Elements}', "");
Expect(0, 9632, '\p{Is_Blk=--BLOCK_Elements}', "");
Expect(1, 9632, '\p{^Is_Blk=--BLOCK_Elements}', "");
Expect(1, 9632, '\P{Is_Blk=--BLOCK_Elements}', "");
Expect(0, 9632, '\P{^Is_Blk=--BLOCK_Elements}', "");
Error('\p{Block=	 bopomofo/a/}');
Error('\P{Block=	 bopomofo/a/}');
Expect(1, 12591, '\p{Block=bopomofo}', "");
Expect(0, 12591, '\p{^Block=bopomofo}', "");
Expect(0, 12591, '\P{Block=bopomofo}', "");
Expect(1, 12591, '\P{^Block=bopomofo}', "");
Expect(0, 12592, '\p{Block=bopomofo}', "");
Expect(1, 12592, '\p{^Block=bopomofo}', "");
Expect(1, 12592, '\P{Block=bopomofo}', "");
Expect(0, 12592, '\P{^Block=bopomofo}', "");
Expect(1, 12591, '\p{Block= _BOPOMOFO}', "");
Expect(0, 12591, '\p{^Block= _BOPOMOFO}', "");
Expect(0, 12591, '\P{Block= _BOPOMOFO}', "");
Expect(1, 12591, '\P{^Block= _BOPOMOFO}', "");
Expect(0, 12592, '\p{Block= _BOPOMOFO}', "");
Expect(1, 12592, '\p{^Block= _BOPOMOFO}', "");
Expect(1, 12592, '\P{Block= _BOPOMOFO}', "");
Expect(0, 12592, '\P{^Block= _BOPOMOFO}', "");
Error('\p{Blk=Bopomofo:=}');
Error('\P{Blk=Bopomofo:=}');
Expect(1, 12591, '\p{Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Blk=bopomofo}', "");
Expect(0, 12591, '\P{Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Blk=bopomofo}', "");
Expect(0, 12592, '\p{Blk=bopomofo}', "");
Expect(1, 12592, '\p{^Blk=bopomofo}', "");
Expect(1, 12592, '\P{Blk=bopomofo}', "");
Expect(0, 12592, '\P{^Blk=bopomofo}', "");
Expect(1, 12591, '\p{Blk: 	_Bopomofo}', "");
Expect(0, 12591, '\p{^Blk: 	_Bopomofo}', "");
Expect(0, 12591, '\P{Blk: 	_Bopomofo}', "");
Expect(1, 12591, '\P{^Blk: 	_Bopomofo}', "");
Expect(0, 12592, '\p{Blk: 	_Bopomofo}', "");
Expect(1, 12592, '\p{^Blk: 	_Bopomofo}', "");
Expect(1, 12592, '\P{Blk: 	_Bopomofo}', "");
Expect(0, 12592, '\P{^Blk: 	_Bopomofo}', "");
Error('\p{Is_Block: :=BOPOMOFO}');
Error('\P{Is_Block: :=BOPOMOFO}');
Expect(1, 12591, '\p{Is_Block=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Block=bopomofo}', "");
Expect(0, 12591, '\P{Is_Block=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Block=bopomofo}', "");
Expect(0, 12592, '\p{Is_Block=bopomofo}', "");
Expect(1, 12592, '\p{^Is_Block=bopomofo}', "");
Expect(1, 12592, '\P{Is_Block=bopomofo}', "");
Expect(0, 12592, '\P{^Is_Block=bopomofo}', "");
Expect(1, 12591, '\p{Is_Block=BOPOMOFO}', "");
Expect(0, 12591, '\p{^Is_Block=BOPOMOFO}', "");
Expect(0, 12591, '\P{Is_Block=BOPOMOFO}', "");
Expect(1, 12591, '\P{^Is_Block=BOPOMOFO}', "");
Expect(0, 12592, '\p{Is_Block=BOPOMOFO}', "");
Expect(1, 12592, '\p{^Is_Block=BOPOMOFO}', "");
Expect(1, 12592, '\P{Is_Block=BOPOMOFO}', "");
Expect(0, 12592, '\P{^Is_Block=BOPOMOFO}', "");
Error('\p{Is_Blk= Bopomofo/a/}');
Error('\P{Is_Blk= Bopomofo/a/}');
Expect(1, 12591, '\p{Is_Blk=bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=bopomofo}', "");
Expect(0, 12592, '\p{Is_Blk=bopomofo}', "");
Expect(1, 12592, '\p{^Is_Blk=bopomofo}', "");
Expect(1, 12592, '\P{Is_Blk=bopomofo}', "");
Expect(0, 12592, '\P{^Is_Blk=bopomofo}', "");
Expect(1, 12591, '\p{Is_Blk=-	Bopomofo}', "");
Expect(0, 12591, '\p{^Is_Blk=-	Bopomofo}', "");
Expect(0, 12591, '\P{Is_Blk=-	Bopomofo}', "");
Expect(1, 12591, '\P{^Is_Blk=-	Bopomofo}', "");
Expect(0, 12592, '\p{Is_Blk=-	Bopomofo}', "");
Expect(1, 12592, '\p{^Is_Blk=-	Bopomofo}', "");
Expect(1, 12592, '\P{Is_Blk=-	Bopomofo}', "");
Expect(0, 12592, '\P{^Is_Blk=-	Bopomofo}', "");
Error('\p{Block=		Bopomofo_EXTENDED:=}');
Error('\P{Block=		Bopomofo_EXTENDED:=}');
Expect(1, 12735, '\p{Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Block=bopomofoextended}', "");
Expect(0, 12736, '\p{Block=bopomofoextended}', "");
Expect(1, 12736, '\p{^Block=bopomofoextended}', "");
Expect(1, 12736, '\P{Block=bopomofoextended}', "");
Expect(0, 12736, '\P{^Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Block=_Bopomofo_Extended}', "");
Expect(0, 12735, '\p{^Block=_Bopomofo_Extended}', "");
Expect(0, 12735, '\P{Block=_Bopomofo_Extended}', "");
Expect(1, 12735, '\P{^Block=_Bopomofo_Extended}', "");
Expect(0, 12736, '\p{Block=_Bopomofo_Extended}', "");
Expect(1, 12736, '\p{^Block=_Bopomofo_Extended}', "");
Expect(1, 12736, '\P{Block=_Bopomofo_Extended}', "");
Expect(0, 12736, '\P{^Block=_Bopomofo_Extended}', "");
Error('\p{Blk=:= 	bopomofo_EXT}');
Error('\P{Blk=:= 	bopomofo_EXT}');
Expect(1, 12735, '\p{Blk=bopomofoext}', "");
Expect(0, 12735, '\p{^Blk=bopomofoext}', "");
Expect(0, 12735, '\P{Blk=bopomofoext}', "");
Expect(1, 12735, '\P{^Blk=bopomofoext}', "");
Expect(0, 12736, '\p{Blk=bopomofoext}', "");
Expect(1, 12736, '\p{^Blk=bopomofoext}', "");
Expect(1, 12736, '\P{Blk=bopomofoext}', "");
Expect(0, 12736, '\P{^Blk=bopomofoext}', "");
Expect(1, 12735, '\p{Blk=__BOPOMOFO_Ext}', "");
Expect(0, 12735, '\p{^Blk=__BOPOMOFO_Ext}', "");
Expect(0, 12735, '\P{Blk=__BOPOMOFO_Ext}', "");
Expect(1, 12735, '\P{^Blk=__BOPOMOFO_Ext}', "");
Expect(0, 12736, '\p{Blk=__BOPOMOFO_Ext}', "");
Expect(1, 12736, '\p{^Blk=__BOPOMOFO_Ext}', "");
Expect(1, 12736, '\P{Blk=__BOPOMOFO_Ext}', "");
Expect(0, 12736, '\P{^Blk=__BOPOMOFO_Ext}', "");
Error('\p{Is_Block:/a/-	bopomofo_EXTENDED}');
Error('\P{Is_Block:/a/-	bopomofo_EXTENDED}');
Expect(1, 12735, '\p{Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\p{^Is_Block=bopomofoextended}', "");
Expect(0, 12735, '\P{Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\P{^Is_Block=bopomofoextended}', "");
Expect(0, 12736, '\p{Is_Block=bopomofoextended}', "");
Expect(1, 12736, '\p{^Is_Block=bopomofoextended}', "");
Expect(1, 12736, '\P{Is_Block=bopomofoextended}', "");
Expect(0, 12736, '\P{^Is_Block=bopomofoextended}', "");
Expect(1, 12735, '\p{Is_Block= 	Bopomofo_Extended}', "");
Expect(0, 12735, '\p{^Is_Block= 	Bopomofo_Extended}', "");
Expect(0, 12735, '\P{Is_Block= 	Bopomofo_Extended}', "");
Expect(1, 12735, '\P{^Is_Block= 	Bopomofo_Extended}', "");
Expect(0, 12736, '\p{Is_Block= 	Bopomofo_Extended}', "");
Expect(1, 12736, '\p{^Is_Block= 	Bopomofo_Extended}', "");
Expect(1, 12736, '\P{Is_Block= 	Bopomofo_Extended}', "");
Expect(0, 12736, '\P{^Is_Block= 	Bopomofo_Extended}', "");
Error('\p{Is_Blk=:=-_Bopomofo_Ext}');
Error('\P{Is_Blk=:=-_Bopomofo_Ext}');
Expect(1, 12735, '\p{Is_Blk=bopomofoext}', "");
Expect(0, 12735, '\p{^Is_Blk=bopomofoext}', "");
Expect(0, 12735, '\P{Is_Blk=bopomofoext}', "");
Expect(1, 12735, '\P{^Is_Blk=bopomofoext}', "");
Expect(0, 12736, '\p{Is_Blk=bopomofoext}', "");
Expect(1, 12736, '\p{^Is_Blk=bopomofoext}', "");
Expect(1, 12736, '\P{Is_Blk=bopomofoext}', "");
Expect(0, 12736, '\P{^Is_Blk=bopomofoext}', "");
Expect(1, 12735, '\p{Is_Blk=_-Bopomofo_Ext}', "");
Expect(0, 12735, '\p{^Is_Blk=_-Bopomofo_Ext}', "");
Expect(0, 12735, '\P{Is_Blk=_-Bopomofo_Ext}', "");
Expect(1, 12735, '\P{^Is_Blk=_-Bopomofo_Ext}', "");
Expect(0, 12736, '\p{Is_Blk=_-Bopomofo_Ext}', "");
Expect(1, 12736, '\p{^Is_Blk=_-Bopomofo_Ext}', "");
Expect(1, 12736, '\P{Is_Blk=_-Bopomofo_Ext}', "");
Expect(0, 12736, '\P{^Is_Blk=_-Bopomofo_Ext}', "");
Error('\p{Block=/a/ _BOX_drawing}');
Error('\P{Block=/a/ _BOX_drawing}');
Expect(1, 9599, '\p{Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Block=boxdrawing}', "");
Expect(0, 9599, '\P{Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Block=boxdrawing}', "");
Expect(0, 9600, '\p{Block=boxdrawing}', "");
Expect(1, 9600, '\p{^Block=boxdrawing}', "");
Expect(1, 9600, '\P{Block=boxdrawing}', "");
Expect(0, 9600, '\P{^Block=boxdrawing}', "");
Expect(1, 9599, '\p{Block=_box_drawing}', "");
Expect(0, 9599, '\p{^Block=_box_drawing}', "");
Expect(0, 9599, '\P{Block=_box_drawing}', "");
Expect(1, 9599, '\P{^Block=_box_drawing}', "");
Expect(0, 9600, '\p{Block=_box_drawing}', "");
Expect(1, 9600, '\p{^Block=_box_drawing}', "");
Expect(1, 9600, '\P{Block=_box_drawing}', "");
Expect(0, 9600, '\P{^Block=_box_drawing}', "");
Error('\p{Blk=	/a/Box_DRAWING}');
Error('\P{Blk=	/a/Box_DRAWING}');
Expect(1, 9599, '\p{Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Blk=boxdrawing}', "");
Expect(0, 9600, '\p{Blk=boxdrawing}', "");
Expect(1, 9600, '\p{^Blk=boxdrawing}', "");
Expect(1, 9600, '\P{Blk=boxdrawing}', "");
Expect(0, 9600, '\P{^Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Blk=	Box_drawing}', "");
Expect(0, 9599, '\p{^Blk=	Box_drawing}', "");
Expect(0, 9599, '\P{Blk=	Box_drawing}', "");
Expect(1, 9599, '\P{^Blk=	Box_drawing}', "");
Expect(0, 9600, '\p{Blk=	Box_drawing}', "");
Expect(1, 9600, '\p{^Blk=	Box_drawing}', "");
Expect(1, 9600, '\P{Blk=	Box_drawing}', "");
Expect(0, 9600, '\P{^Blk=	Box_drawing}', "");
Error('\p{Is_Block=:=_ Box_DRAWING}');
Error('\P{Is_Block=:=_ Box_DRAWING}');
Expect(1, 9599, '\p{Is_Block=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Block=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Block=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Block=boxdrawing}', "");
Expect(0, 9600, '\p{Is_Block=boxdrawing}', "");
Expect(1, 9600, '\p{^Is_Block=boxdrawing}', "");
Expect(1, 9600, '\P{Is_Block=boxdrawing}', "");
Expect(0, 9600, '\P{^Is_Block=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Block=_	Box_Drawing}', "");
Expect(0, 9599, '\p{^Is_Block=_	Box_Drawing}', "");
Expect(0, 9599, '\P{Is_Block=_	Box_Drawing}', "");
Expect(1, 9599, '\P{^Is_Block=_	Box_Drawing}', "");
Expect(0, 9600, '\p{Is_Block=_	Box_Drawing}', "");
Expect(1, 9600, '\p{^Is_Block=_	Box_Drawing}', "");
Expect(1, 9600, '\P{Is_Block=_	Box_Drawing}', "");
Expect(0, 9600, '\P{^Is_Block=_	Box_Drawing}', "");
Error('\p{Is_Blk=/a/box_Drawing}');
Error('\P{Is_Blk=/a/box_Drawing}');
Expect(1, 9599, '\p{Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\p{^Is_Blk=boxdrawing}', "");
Expect(0, 9599, '\P{Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\P{^Is_Blk=boxdrawing}', "");
Expect(0, 9600, '\p{Is_Blk=boxdrawing}', "");
Expect(1, 9600, '\p{^Is_Blk=boxdrawing}', "");
Expect(1, 9600, '\P{Is_Blk=boxdrawing}', "");
Expect(0, 9600, '\P{^Is_Blk=boxdrawing}', "");
Expect(1, 9599, '\p{Is_Blk=-Box_DRAWING}', "");
Expect(0, 9599, '\p{^Is_Blk=-Box_DRAWING}', "");
Expect(0, 9599, '\P{Is_Blk=-Box_DRAWING}', "");
Expect(1, 9599, '\P{^Is_Blk=-Box_DRAWING}', "");
Expect(0, 9600, '\p{Is_Blk=-Box_DRAWING}', "");
Expect(1, 9600, '\p{^Is_Blk=-Box_DRAWING}', "");
Expect(1, 9600, '\P{Is_Blk=-Box_DRAWING}', "");
Expect(0, 9600, '\P{^Is_Blk=-Box_DRAWING}', "");
Error('\p{Block: /a/ -brahmi}');
Error('\P{Block: /a/ -brahmi}');
Expect(1, 69759, '\p{Block=brahmi}', "");
Expect(0, 69759, '\p{^Block=brahmi}', "");
Expect(0, 69759, '\P{Block=brahmi}', "");
Expect(1, 69759, '\P{^Block=brahmi}', "");
Expect(0, 69760, '\p{Block=brahmi}', "");
Expect(1, 69760, '\p{^Block=brahmi}', "");
Expect(1, 69760, '\P{Block=brahmi}', "");
Expect(0, 69760, '\P{^Block=brahmi}', "");
Expect(1, 69759, '\p{Block=--BRAHMI}', "");
Expect(0, 69759, '\p{^Block=--BRAHMI}', "");
Expect(0, 69759, '\P{Block=--BRAHMI}', "");
Expect(1, 69759, '\P{^Block=--BRAHMI}', "");
Expect(0, 69760, '\p{Block=--BRAHMI}', "");
Expect(1, 69760, '\p{^Block=--BRAHMI}', "");
Expect(1, 69760, '\P{Block=--BRAHMI}', "");
Expect(0, 69760, '\P{^Block=--BRAHMI}', "");
Error('\p{Blk=/a/--BRAHMI}');
Error('\P{Blk=/a/--BRAHMI}');
Expect(1, 69759, '\p{Blk=brahmi}', "");
Expect(0, 69759, '\p{^Blk=brahmi}', "");
Expect(0, 69759, '\P{Blk=brahmi}', "");
Expect(1, 69759, '\P{^Blk=brahmi}', "");
Expect(0, 69760, '\p{Blk=brahmi}', "");
Expect(1, 69760, '\p{^Blk=brahmi}', "");
Expect(1, 69760, '\P{Blk=brahmi}', "");
Expect(0, 69760, '\P{^Blk=brahmi}', "");
Expect(1, 69759, '\p{Blk= 	Brahmi}', "");
Expect(0, 69759, '\p{^Blk= 	Brahmi}', "");
Expect(0, 69759, '\P{Blk= 	Brahmi}', "");
Expect(1, 69759, '\P{^Blk= 	Brahmi}', "");
Expect(0, 69760, '\p{Blk= 	Brahmi}', "");
Expect(1, 69760, '\p{^Blk= 	Brahmi}', "");
Expect(1, 69760, '\P{Blk= 	Brahmi}', "");
Expect(0, 69760, '\P{^Blk= 	Brahmi}', "");
Error('\p{Is_Block=	_brahmi/a/}');
Error('\P{Is_Block=	_brahmi/a/}');
Expect(1, 69759, '\p{Is_Block=brahmi}', "");
Expect(0, 69759, '\p{^Is_Block=brahmi}', "");
Expect(0, 69759, '\P{Is_Block=brahmi}', "");
Expect(1, 69759, '\P{^Is_Block=brahmi}', "");
Expect(0, 69760, '\p{Is_Block=brahmi}', "");
Expect(1, 69760, '\p{^Is_Block=brahmi}', "");
Expect(1, 69760, '\P{Is_Block=brahmi}', "");
Expect(0, 69760, '\P{^Is_Block=brahmi}', "");
Expect(1, 69759, '\p{Is_Block=- Brahmi}', "");
Expect(0, 69759, '\p{^Is_Block=- Brahmi}', "");
Expect(0, 69759, '\P{Is_Block=- Brahmi}', "");
Expect(1, 69759, '\P{^Is_Block=- Brahmi}', "");
Expect(0, 69760, '\p{Is_Block=- Brahmi}', "");
Expect(1, 69760, '\p{^Is_Block=- Brahmi}', "");
Expect(1, 69760, '\P{Is_Block=- Brahmi}', "");
Expect(0, 69760, '\P{^Is_Block=- Brahmi}', "");
Error('\p{Is_Blk=_	brahmi:=}');
Error('\P{Is_Blk=_	brahmi:=}');
Expect(1, 69759, '\p{Is_Blk=brahmi}', "");
Expect(0, 69759, '\p{^Is_Blk=brahmi}', "");
Expect(0, 69759, '\P{Is_Blk=brahmi}', "");
Expect(1, 69759, '\P{^Is_Blk=brahmi}', "");
Expect(0, 69760, '\p{Is_Blk=brahmi}', "");
Expect(1, 69760, '\p{^Is_Blk=brahmi}', "");
Expect(1, 69760, '\P{Is_Blk=brahmi}', "");
Expect(0, 69760, '\P{^Is_Blk=brahmi}', "");
Expect(1, 69759, '\p{Is_Blk=	brahmi}', "");
Expect(0, 69759, '\p{^Is_Blk=	brahmi}', "");
Expect(0, 69759, '\P{Is_Blk=	brahmi}', "");
Expect(1, 69759, '\P{^Is_Blk=	brahmi}', "");
Expect(0, 69760, '\p{Is_Blk=	brahmi}', "");
Expect(1, 69760, '\p{^Is_Blk=	brahmi}', "");
Expect(1, 69760, '\P{Is_Blk=	brahmi}', "");
Expect(0, 69760, '\P{^Is_Blk=	brahmi}', "");
Error('\p{Block=:=	braille_Patterns}');
Error('\P{Block=:=	braille_Patterns}');
Expect(1, 10495, '\p{Block:braillepatterns}', "");
Expect(0, 10495, '\p{^Block:braillepatterns}', "");
Expect(0, 10495, '\P{Block:braillepatterns}', "");
Expect(1, 10495, '\P{^Block:braillepatterns}', "");
Expect(0, 10496, '\p{Block:braillepatterns}', "");
Expect(1, 10496, '\p{^Block:braillepatterns}', "");
Expect(1, 10496, '\P{Block:braillepatterns}', "");
Expect(0, 10496, '\P{^Block:braillepatterns}', "");
Expect(1, 10495, '\p{Block=  Braille_Patterns}', "");
Expect(0, 10495, '\p{^Block=  Braille_Patterns}', "");
Expect(0, 10495, '\P{Block=  Braille_Patterns}', "");
Expect(1, 10495, '\P{^Block=  Braille_Patterns}', "");
Expect(0, 10496, '\p{Block=  Braille_Patterns}', "");
Expect(1, 10496, '\p{^Block=  Braille_Patterns}', "");
Expect(1, 10496, '\P{Block=  Braille_Patterns}', "");
Expect(0, 10496, '\P{^Block=  Braille_Patterns}', "");
Error('\p{Blk=/a/ Braille}');
Error('\P{Blk=/a/ Braille}');
Expect(1, 10495, '\p{Blk:   braille}', "");
Expect(0, 10495, '\p{^Blk:   braille}', "");
Expect(0, 10495, '\P{Blk:   braille}', "");
Expect(1, 10495, '\P{^Blk:   braille}', "");
Expect(0, 10496, '\p{Blk:   braille}', "");
Expect(1, 10496, '\p{^Blk:   braille}', "");
Expect(1, 10496, '\P{Blk:   braille}', "");
Expect(0, 10496, '\P{^Blk:   braille}', "");
Expect(1, 10495, '\p{Blk=_braille}', "");
Expect(0, 10495, '\p{^Blk=_braille}', "");
Expect(0, 10495, '\P{Blk=_braille}', "");
Expect(1, 10495, '\P{^Blk=_braille}', "");
Expect(0, 10496, '\p{Blk=_braille}', "");
Expect(1, 10496, '\p{^Blk=_braille}', "");
Expect(1, 10496, '\P{Blk=_braille}', "");
Expect(0, 10496, '\P{^Blk=_braille}', "");
Error('\p{Is_Block=_BRAILLE_Patterns:=}');
Error('\P{Is_Block=_BRAILLE_Patterns:=}');
Expect(1, 10495, '\p{Is_Block=braillepatterns}', "");
Expect(0, 10495, '\p{^Is_Block=braillepatterns}', "");
Expect(0, 10495, '\P{Is_Block=braillepatterns}', "");
Expect(1, 10495, '\P{^Is_Block=braillepatterns}', "");
Expect(0, 10496, '\p{Is_Block=braillepatterns}', "");
Expect(1, 10496, '\p{^Is_Block=braillepatterns}', "");
Expect(1, 10496, '\P{Is_Block=braillepatterns}', "");
Expect(0, 10496, '\P{^Is_Block=braillepatterns}', "");
Expect(1, 10495, '\p{Is_Block:	Braille_patterns}', "");
Expect(0, 10495, '\p{^Is_Block:	Braille_patterns}', "");
Expect(0, 10495, '\P{Is_Block:	Braille_patterns}', "");
Expect(1, 10495, '\P{^Is_Block:	Braille_patterns}', "");
Expect(0, 10496, '\p{Is_Block:	Braille_patterns}', "");
Expect(1, 10496, '\p{^Is_Block:	Braille_patterns}', "");
Expect(1, 10496, '\P{Is_Block:	Braille_patterns}', "");
Expect(0, 10496, '\P{^Is_Block:	Braille_patterns}', "");
Error('\p{Is_Blk=__Braille:=}');
Error('\P{Is_Blk=__Braille:=}');
Expect(1, 10495, '\p{Is_Blk=braille}', "");
Expect(0, 10495, '\p{^Is_Blk=braille}', "");
Expect(0, 10495, '\P{Is_Blk=braille}', "");
Expect(1, 10495, '\P{^Is_Blk=braille}', "");
Expect(0, 10496, '\p{Is_Blk=braille}', "");
Expect(1, 10496, '\p{^Is_Blk=braille}', "");
Expect(1, 10496, '\P{Is_Blk=braille}', "");
Expect(0, 10496, '\P{^Is_Blk=braille}', "");
Expect(1, 10495, '\p{Is_Blk=	BRAILLE}', "");
Expect(0, 10495, '\p{^Is_Blk=	BRAILLE}', "");
Expect(0, 10495, '\P{Is_Blk=	BRAILLE}', "");
Expect(1, 10495, '\P{^Is_Blk=	BRAILLE}', "");
Expect(0, 10496, '\p{Is_Blk=	BRAILLE}', "");
Expect(1, 10496, '\p{^Is_Blk=	BRAILLE}', "");
Expect(1, 10496, '\P{Is_Blk=	BRAILLE}', "");
Expect(0, 10496, '\P{^Is_Blk=	BRAILLE}', "");
Error('\p{Block=-_Buginese/a/}');
Error('\P{Block=-_Buginese/a/}');
Expect(1, 6687, '\p{Block=buginese}', "");
Expect(0, 6687, '\p{^Block=buginese}', "");
Expect(0, 6687, '\P{Block=buginese}', "");
Expect(1, 6687, '\P{^Block=buginese}', "");
Expect(0, 6688, '\p{Block=buginese}', "");
Expect(1, 6688, '\p{^Block=buginese}', "");
Expect(1, 6688, '\P{Block=buginese}', "");
Expect(0, 6688, '\P{^Block=buginese}', "");
Expect(1, 6687, '\p{Block=__Buginese}', "");
Expect(0, 6687, '\p{^Block=__Buginese}', "");
Expect(0, 6687, '\P{Block=__Buginese}', "");
Expect(1, 6687, '\P{^Block=__Buginese}', "");
Expect(0, 6688, '\p{Block=__Buginese}', "");
Expect(1, 6688, '\p{^Block=__Buginese}', "");
Expect(1, 6688, '\P{Block=__Buginese}', "");
Expect(0, 6688, '\P{^Block=__Buginese}', "");
Error('\p{Blk=_:=buginese}');
Error('\P{Blk=_:=buginese}');
Expect(1, 6687, '\p{Blk=buginese}', "");
Expect(0, 6687, '\p{^Blk=buginese}', "");
Expect(0, 6687, '\P{Blk=buginese}', "");
Expect(1, 6687, '\P{^Blk=buginese}', "");
Expect(0, 6688, '\p{Blk=buginese}', "");
Expect(1, 6688, '\p{^Blk=buginese}', "");
Expect(1, 6688, '\P{Blk=buginese}', "");
Expect(0, 6688, '\P{^Blk=buginese}', "");
Expect(1, 6687, '\p{Blk=	buginese}', "");
Expect(0, 6687, '\p{^Blk=	buginese}', "");
Expect(0, 6687, '\P{Blk=	buginese}', "");
Expect(1, 6687, '\P{^Blk=	buginese}', "");
Expect(0, 6688, '\p{Blk=	buginese}', "");
Expect(1, 6688, '\p{^Blk=	buginese}', "");
Expect(1, 6688, '\P{Blk=	buginese}', "");
Expect(0, 6688, '\P{^Blk=	buginese}', "");
Error('\p{Is_Block=-	buginese/a/}');
Error('\P{Is_Block=-	buginese/a/}');
Expect(1, 6687, '\p{Is_Block=buginese}', "");
Expect(0, 6687, '\p{^Is_Block=buginese}', "");
Expect(0, 6687, '\P{Is_Block=buginese}', "");
Expect(1, 6687, '\P{^Is_Block=buginese}', "");
Expect(0, 6688, '\p{Is_Block=buginese}', "");
Expect(1, 6688, '\p{^Is_Block=buginese}', "");
Expect(1, 6688, '\P{Is_Block=buginese}', "");
Expect(0, 6688, '\P{^Is_Block=buginese}', "");
Expect(1, 6687, '\p{Is_Block=	 BUGINESE}', "");
Expect(0, 6687, '\p{^Is_Block=	 BUGINESE}', "");
Expect(0, 6687, '\P{Is_Block=	 BUGINESE}', "");
Expect(1, 6687, '\P{^Is_Block=	 BUGINESE}', "");
Expect(0, 6688, '\p{Is_Block=	 BUGINESE}', "");
Expect(1, 6688, '\p{^Is_Block=	 BUGINESE}', "");
Expect(1, 6688, '\P{Is_Block=	 BUGINESE}', "");
Expect(0, 6688, '\P{^Is_Block=	 BUGINESE}', "");
Error('\p{Is_Blk=:=		BUGINESE}');
Error('\P{Is_Blk=:=		BUGINESE}');
Expect(1, 6687, '\p{Is_Blk=buginese}', "");
Expect(0, 6687, '\p{^Is_Blk=buginese}', "");
Expect(0, 6687, '\P{Is_Blk=buginese}', "");
Expect(1, 6687, '\P{^Is_Blk=buginese}', "");
Expect(0, 6688, '\p{Is_Blk=buginese}', "");
Expect(1, 6688, '\p{^Is_Blk=buginese}', "");
Expect(1, 6688, '\P{Is_Blk=buginese}', "");
Expect(0, 6688, '\P{^Is_Blk=buginese}', "");
Expect(1, 6687, '\p{Is_Blk=	-Buginese}', "");
Expect(0, 6687, '\p{^Is_Blk=	-Buginese}', "");
Expect(0, 6687, '\P{Is_Blk=	-Buginese}', "");
Expect(1, 6687, '\P{^Is_Blk=	-Buginese}', "");
Expect(0, 6688, '\p{Is_Blk=	-Buginese}', "");
Expect(1, 6688, '\p{^Is_Blk=	-Buginese}', "");
Expect(1, 6688, '\P{Is_Blk=	-Buginese}', "");
Expect(0, 6688, '\P{^Is_Blk=	-Buginese}', "");
Error('\p{Block=/a/Buhid}');
Error('\P{Block=/a/Buhid}');
Expect(1, 5983, '\p{Block=buhid}', "");
Expect(0, 5983, '\p{^Block=buhid}', "");
Expect(0, 5983, '\P{Block=buhid}', "");
Expect(1, 5983, '\P{^Block=buhid}', "");
Expect(0, 5984, '\p{Block=buhid}', "");
Expect(1, 5984, '\p{^Block=buhid}', "");
Expect(1, 5984, '\P{Block=buhid}', "");
Expect(0, 5984, '\P{^Block=buhid}', "");
Expect(1, 5983, '\p{Block=-_BUHID}', "");
Expect(0, 5983, '\p{^Block=-_BUHID}', "");
Expect(0, 5983, '\P{Block=-_BUHID}', "");
Expect(1, 5983, '\P{^Block=-_BUHID}', "");
Expect(0, 5984, '\p{Block=-_BUHID}', "");
Expect(1, 5984, '\p{^Block=-_BUHID}', "");
Expect(1, 5984, '\P{Block=-_BUHID}', "");
Expect(0, 5984, '\P{^Block=-_BUHID}', "");
Error('\p{Blk=_:=buhid}');
Error('\P{Blk=_:=buhid}');
Expect(1, 5983, '\p{Blk=buhid}', "");
Expect(0, 5983, '\p{^Blk=buhid}', "");
Expect(0, 5983, '\P{Blk=buhid}', "");
Expect(1, 5983, '\P{^Blk=buhid}', "");
Expect(0, 5984, '\p{Blk=buhid}', "");
Expect(1, 5984, '\p{^Blk=buhid}', "");
Expect(1, 5984, '\P{Blk=buhid}', "");
Expect(0, 5984, '\P{^Blk=buhid}', "");
Expect(1, 5983, '\p{Blk=_buhid}', "");
Expect(0, 5983, '\p{^Blk=_buhid}', "");
Expect(0, 5983, '\P{Blk=_buhid}', "");
Expect(1, 5983, '\P{^Blk=_buhid}', "");
Expect(0, 5984, '\p{Blk=_buhid}', "");
Expect(1, 5984, '\p{^Blk=_buhid}', "");
Expect(1, 5984, '\P{Blk=_buhid}', "");
Expect(0, 5984, '\P{^Blk=_buhid}', "");
Error('\p{Is_Block=BUHID/a/}');
Error('\P{Is_Block=BUHID/a/}');
Expect(1, 5983, '\p{Is_Block=buhid}', "");
Expect(0, 5983, '\p{^Is_Block=buhid}', "");
Expect(0, 5983, '\P{Is_Block=buhid}', "");
Expect(1, 5983, '\P{^Is_Block=buhid}', "");
Expect(0, 5984, '\p{Is_Block=buhid}', "");
Expect(1, 5984, '\p{^Is_Block=buhid}', "");
Expect(1, 5984, '\P{Is_Block=buhid}', "");
Expect(0, 5984, '\P{^Is_Block=buhid}', "");
Expect(1, 5983, '\p{Is_Block=_	Buhid}', "");
Expect(0, 5983, '\p{^Is_Block=_	Buhid}', "");
Expect(0, 5983, '\P{Is_Block=_	Buhid}', "");
Expect(1, 5983, '\P{^Is_Block=_	Buhid}', "");
Expect(0, 5984, '\p{Is_Block=_	Buhid}', "");
Expect(1, 5984, '\p{^Is_Block=_	Buhid}', "");
Expect(1, 5984, '\P{Is_Block=_	Buhid}', "");
Expect(0, 5984, '\P{^Is_Block=_	Buhid}', "");
Error('\p{Is_Blk=	Buhid/a/}');
Error('\P{Is_Blk=	Buhid/a/}');
Expect(1, 5983, '\p{Is_Blk=buhid}', "");
Expect(0, 5983, '\p{^Is_Blk=buhid}', "");
Expect(0, 5983, '\P{Is_Blk=buhid}', "");
Expect(1, 5983, '\P{^Is_Blk=buhid}', "");
Expect(0, 5984, '\p{Is_Blk=buhid}', "");
Expect(1, 5984, '\p{^Is_Blk=buhid}', "");
Expect(1, 5984, '\P{Is_Blk=buhid}', "");
Expect(0, 5984, '\P{^Is_Blk=buhid}', "");
Expect(1, 5983, '\p{Is_Blk:	Buhid}', "");
Expect(0, 5983, '\p{^Is_Blk:	Buhid}', "");
Expect(0, 5983, '\P{Is_Blk:	Buhid}', "");
Expect(1, 5983, '\P{^Is_Blk:	Buhid}', "");
Expect(0, 5984, '\p{Is_Blk:	Buhid}', "");
Expect(1, 5984, '\p{^Is_Blk:	Buhid}', "");
Expect(1, 5984, '\P{Is_Blk:	Buhid}', "");
Expect(0, 5984, '\P{^Is_Blk:	Buhid}', "");
Error('\p{Block=/a/ -byzantine_Musical_Symbols}');
Error('\P{Block=/a/ -byzantine_Musical_Symbols}');
Expect(1, 119039, '\p{Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\p{Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\p{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\P{Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\P{^Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Block=		byzantine_musical_Symbols}', "");
Expect(0, 119039, '\p{^Block=		byzantine_musical_Symbols}', "");
Expect(0, 119039, '\P{Block=		byzantine_musical_Symbols}', "");
Expect(1, 119039, '\P{^Block=		byzantine_musical_Symbols}', "");
Expect(0, 119040, '\p{Block=		byzantine_musical_Symbols}', "");
Expect(1, 119040, '\p{^Block=		byzantine_musical_Symbols}', "");
Expect(1, 119040, '\P{Block=		byzantine_musical_Symbols}', "");
Expect(0, 119040, '\P{^Block=		byzantine_musical_Symbols}', "");
Error('\p{Blk=/a/_Byzantine_Music}');
Error('\P{Blk=/a/_Byzantine_Music}');
Expect(1, 119039, '\p{Blk=byzantinemusic}', "");
Expect(0, 119039, '\p{^Blk=byzantinemusic}', "");
Expect(0, 119039, '\P{Blk=byzantinemusic}', "");
Expect(1, 119039, '\P{^Blk=byzantinemusic}', "");
Expect(0, 119040, '\p{Blk=byzantinemusic}', "");
Expect(1, 119040, '\p{^Blk=byzantinemusic}', "");
Expect(1, 119040, '\P{Blk=byzantinemusic}', "");
Expect(0, 119040, '\P{^Blk=byzantinemusic}', "");
Expect(1, 119039, '\p{Blk=--BYZANTINE_Music}', "");
Expect(0, 119039, '\p{^Blk=--BYZANTINE_Music}', "");
Expect(0, 119039, '\P{Blk=--BYZANTINE_Music}', "");
Expect(1, 119039, '\P{^Blk=--BYZANTINE_Music}', "");
Expect(0, 119040, '\p{Blk=--BYZANTINE_Music}', "");
Expect(1, 119040, '\p{^Blk=--BYZANTINE_Music}', "");
Expect(1, 119040, '\P{Blk=--BYZANTINE_Music}', "");
Expect(0, 119040, '\P{^Blk=--BYZANTINE_Music}', "");
Error('\p{Is_Block=/a/ _Byzantine_Musical_Symbols}');
Error('\P{Is_Block=/a/ _Byzantine_Musical_Symbols}');
Expect(1, 119039, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119039, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\p{Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\p{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119040, '\P{Is_Block=byzantinemusicalsymbols}', "");
Expect(0, 119040, '\P{^Is_Block=byzantinemusicalsymbols}', "");
Expect(1, 119039, '\p{Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119039, '\p{^Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119039, '\P{Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119039, '\P{^Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119040, '\p{Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119040, '\p{^Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(1, 119040, '\P{Is_Block=	_Byzantine_Musical_Symbols}', "");
Expect(0, 119040, '\P{^Is_Block=	_Byzantine_Musical_Symbols}', "");
Error('\p{Is_Blk=-	byzantine_music:=}');
Error('\P{Is_Blk=-	byzantine_music:=}');
Expect(1, 119039, '\p{Is_Blk=byzantinemusic}', "");
Expect(0, 119039, '\p{^Is_Blk=byzantinemusic}', "");
Expect(0, 119039, '\P{Is_Blk=byzantinemusic}', "");
Expect(1, 119039, '\P{^Is_Blk=byzantinemusic}', "");
Expect(0, 119040, '\p{Is_Blk=byzantinemusic}', "");
Expect(1, 119040, '\p{^Is_Blk=byzantinemusic}', "");
Expect(1, 119040, '\P{Is_Blk=byzantinemusic}', "");
Expect(0, 119040, '\P{^Is_Blk=byzantinemusic}', "");
Expect(1, 119039, '\p{Is_Blk=-_Byzantine_MUSIC}', "");
Expect(0, 119039, '\p{^Is_Blk=-_Byzantine_MUSIC}', "");
Expect(0, 119039, '\P{Is_Blk=-_Byzantine_MUSIC}', "");
Expect(1, 119039, '\P{^Is_Blk=-_Byzantine_MUSIC}', "");
Expect(0, 119040, '\p{Is_Blk=-_Byzantine_MUSIC}', "");
Expect(1, 119040, '\p{^Is_Blk=-_Byzantine_MUSIC}', "");
Expect(1, 119040, '\P{Is_Blk=-_Byzantine_MUSIC}', "");
Expect(0, 119040, '\P{^Is_Blk=-_Byzantine_MUSIC}', "");
Error('\p{Block=-:=CJK_UNIFIED_IDEOGRAPHS}');
Error('\P{Block=-:=CJK_UNIFIED_IDEOGRAPHS}');
Expect(1, 40959, '\p{Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\p{Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\p{^Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\P{Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\P{^Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(0, 40959, '\p{^Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(0, 40959, '\P{Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(1, 40959, '\P{^Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(0, 40960, '\p{Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(1, 40960, '\p{^Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(1, 40960, '\P{Block=	-CJK_Unified_IDEOGRAPHS}', "");
Expect(0, 40960, '\P{^Block=	-CJK_Unified_IDEOGRAPHS}', "");
Error('\p{Blk=_	CJK:=}');
Error('\P{Blk=_	CJK:=}');
Expect(1, 40959, '\p{Blk=cjk}', "");
Expect(0, 40959, '\p{^Blk=cjk}', "");
Expect(0, 40959, '\P{Blk=cjk}', "");
Expect(1, 40959, '\P{^Blk=cjk}', "");
Expect(0, 40960, '\p{Blk=cjk}', "");
Expect(1, 40960, '\p{^Blk=cjk}', "");
Expect(1, 40960, '\P{Blk=cjk}', "");
Expect(0, 40960, '\P{^Blk=cjk}', "");
Expect(1, 40959, '\p{Blk= cjk}', "");
Expect(0, 40959, '\p{^Blk= cjk}', "");
Expect(0, 40959, '\P{Blk= cjk}', "");
Expect(1, 40959, '\P{^Blk= cjk}', "");
Expect(0, 40960, '\p{Blk= cjk}', "");
Expect(1, 40960, '\p{^Blk= cjk}', "");
Expect(1, 40960, '\P{Blk= cjk}', "");
Expect(0, 40960, '\P{^Blk= cjk}', "");
Error('\p{Is_Block=-	CJK_Unified_Ideographs:=}');
Error('\P{Is_Block=-	CJK_Unified_Ideographs:=}');
Expect(1, 40959, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40959, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\p{Is_Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\p{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40960, '\P{Is_Block=cjkunifiedideographs}', "");
Expect(0, 40960, '\P{^Is_Block=cjkunifiedideographs}', "");
Expect(1, 40959, '\p{Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(0, 40959, '\p{^Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(0, 40959, '\P{Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(1, 40959, '\P{^Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(0, 40960, '\p{Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(1, 40960, '\p{^Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(1, 40960, '\P{Is_Block=_cjk_UNIFIED_Ideographs}', "");
Expect(0, 40960, '\P{^Is_Block=_cjk_UNIFIED_Ideographs}', "");
Error('\p{Is_Blk=--CJK/a/}');
Error('\P{Is_Blk=--CJK/a/}');
Expect(1, 40959, '\p{Is_Blk: cjk}', "");
Expect(0, 40959, '\p{^Is_Blk: cjk}', "");
Expect(0, 40959, '\P{Is_Blk: cjk}', "");
Expect(1, 40959, '\P{^Is_Blk: cjk}', "");
Expect(0, 40960, '\p{Is_Blk: cjk}', "");
Expect(1, 40960, '\p{^Is_Blk: cjk}', "");
Expect(1, 40960, '\P{Is_Blk: cjk}', "");
Expect(0, 40960, '\P{^Is_Blk: cjk}', "");
Expect(1, 40959, '\p{Is_Blk=	_CJK}', "");
Expect(0, 40959, '\p{^Is_Blk=	_CJK}', "");
Expect(0, 40959, '\P{Is_Blk=	_CJK}', "");
Expect(1, 40959, '\P{^Is_Blk=	_CJK}', "");
Expect(0, 40960, '\p{Is_Blk=	_CJK}', "");
Expect(1, 40960, '\p{^Is_Blk=	_CJK}', "");
Expect(1, 40960, '\P{Is_Blk=	_CJK}', "");
Expect(0, 40960, '\P{^Is_Blk=	_CJK}', "");
Error('\p{Block:	/a/ -CJK_Compatibility}');
Error('\P{Block:	/a/ -CJK_Compatibility}');
Expect(1, 13311, '\p{Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Block=cjkcompatibility}', "");
Expect(0, 13312, '\p{Block=cjkcompatibility}', "");
Expect(1, 13312, '\p{^Block=cjkcompatibility}', "");
Expect(1, 13312, '\P{Block=cjkcompatibility}', "");
Expect(0, 13312, '\P{^Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Block=__CJK_Compatibility}', "");
Expect(0, 13311, '\p{^Block=__CJK_Compatibility}', "");
Expect(0, 13311, '\P{Block=__CJK_Compatibility}', "");
Expect(1, 13311, '\P{^Block=__CJK_Compatibility}', "");
Expect(0, 13312, '\p{Block=__CJK_Compatibility}', "");
Expect(1, 13312, '\p{^Block=__CJK_Compatibility}', "");
Expect(1, 13312, '\P{Block=__CJK_Compatibility}', "");
Expect(0, 13312, '\P{^Block=__CJK_Compatibility}', "");
Error('\p{Blk=:= 	CJK_Compat}');
Error('\P{Blk=:= 	CJK_Compat}');
Expect(1, 13311, '\p{Blk=cjkcompat}', "");
Expect(0, 13311, '\p{^Blk=cjkcompat}', "");
Expect(0, 13311, '\P{Blk=cjkcompat}', "");
Expect(1, 13311, '\P{^Blk=cjkcompat}', "");
Expect(0, 13312, '\p{Blk=cjkcompat}', "");
Expect(1, 13312, '\p{^Blk=cjkcompat}', "");
Expect(1, 13312, '\P{Blk=cjkcompat}', "");
Expect(0, 13312, '\P{^Blk=cjkcompat}', "");
Expect(1, 13311, '\p{Blk= -CJK_compat}', "");
Expect(0, 13311, '\p{^Blk= -CJK_compat}', "");
Expect(0, 13311, '\P{Blk= -CJK_compat}', "");
Expect(1, 13311, '\P{^Blk= -CJK_compat}', "");
Expect(0, 13312, '\p{Blk= -CJK_compat}', "");
Expect(1, 13312, '\p{^Blk= -CJK_compat}', "");
Expect(1, 13312, '\P{Blk= -CJK_compat}', "");
Expect(0, 13312, '\P{^Blk= -CJK_compat}', "");
Error('\p{Is_Block=/a/-CJK_Compatibility}');
Error('\P{Is_Block=/a/-CJK_Compatibility}');
Expect(1, 13311, '\p{Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\p{^Is_Block=cjkcompatibility}', "");
Expect(0, 13311, '\P{Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\P{^Is_Block=cjkcompatibility}', "");
Expect(0, 13312, '\p{Is_Block=cjkcompatibility}', "");
Expect(1, 13312, '\p{^Is_Block=cjkcompatibility}', "");
Expect(1, 13312, '\P{Is_Block=cjkcompatibility}', "");
Expect(0, 13312, '\P{^Is_Block=cjkcompatibility}', "");
Expect(1, 13311, '\p{Is_Block=  CJK_Compatibility}', "");
Expect(0, 13311, '\p{^Is_Block=  CJK_Compatibility}', "");
Expect(0, 13311, '\P{Is_Block=  CJK_Compatibility}', "");
Expect(1, 13311, '\P{^Is_Block=  CJK_Compatibility}', "");
Expect(0, 13312, '\p{Is_Block=  CJK_Compatibility}', "");
Expect(1, 13312, '\p{^Is_Block=  CJK_Compatibility}', "");
Expect(1, 13312, '\P{Is_Block=  CJK_Compatibility}', "");
Expect(0, 13312, '\P{^Is_Block=  CJK_Compatibility}', "");
Error('\p{Is_Blk=/a/cjk_COMPAT}');
Error('\P{Is_Blk=/a/cjk_COMPAT}');
Expect(1, 13311, '\p{Is_Blk=cjkcompat}', "");
Expect(0, 13311, '\p{^Is_Blk=cjkcompat}', "");
Expect(0, 13311, '\P{Is_Blk=cjkcompat}', "");
Expect(1, 13311, '\P{^Is_Blk=cjkcompat}', "");
Expect(0, 13312, '\p{Is_Blk=cjkcompat}', "");
Expect(1, 13312, '\p{^Is_Blk=cjkcompat}', "");
Expect(1, 13312, '\P{Is_Blk=cjkcompat}', "");
Expect(0, 13312, '\P{^Is_Blk=cjkcompat}', "");
Expect(1, 13311, '\p{Is_Blk=CJK_Compat}', "");
Expect(0, 13311, '\p{^Is_Blk=CJK_Compat}', "");
Expect(0, 13311, '\P{Is_Blk=CJK_Compat}', "");
Expect(1, 13311, '\P{^Is_Blk=CJK_Compat}', "");
Expect(0, 13312, '\p{Is_Blk=CJK_Compat}', "");
Expect(1, 13312, '\p{^Is_Blk=CJK_Compat}', "");
Expect(1, 13312, '\P{Is_Blk=CJK_Compat}', "");
Expect(0, 13312, '\P{^Is_Blk=CJK_Compat}', "");
Error('\p{Block::= 	CJK_Compatibility_Forms}');
Error('\P{Block::= 	CJK_Compatibility_Forms}');
Expect(1, 65103, '\p{Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\p{Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\p{^Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\P{Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\P{^Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Block=CJK_Compatibility_Forms}', "");
Expect(0, 65103, '\p{^Block=CJK_Compatibility_Forms}', "");
Expect(0, 65103, '\P{Block=CJK_Compatibility_Forms}', "");
Expect(1, 65103, '\P{^Block=CJK_Compatibility_Forms}', "");
Expect(0, 65104, '\p{Block=CJK_Compatibility_Forms}', "");
Expect(1, 65104, '\p{^Block=CJK_Compatibility_Forms}', "");
Expect(1, 65104, '\P{Block=CJK_Compatibility_Forms}', "");
Expect(0, 65104, '\P{^Block=CJK_Compatibility_Forms}', "");
Error('\p{Blk=__CJK_Compat_Forms:=}');
Error('\P{Blk=__CJK_Compat_Forms:=}');
Expect(1, 65103, '\p{Blk:   cjkcompatforms}', "");
Expect(0, 65103, '\p{^Blk:   cjkcompatforms}', "");
Expect(0, 65103, '\P{Blk:   cjkcompatforms}', "");
Expect(1, 65103, '\P{^Blk:   cjkcompatforms}', "");
Expect(0, 65104, '\p{Blk:   cjkcompatforms}', "");
Expect(1, 65104, '\p{^Blk:   cjkcompatforms}', "");
Expect(1, 65104, '\P{Blk:   cjkcompatforms}', "");
Expect(0, 65104, '\P{^Blk:   cjkcompatforms}', "");
Expect(1, 65103, '\p{Blk=_ CJK_Compat_FORMS}', "");
Expect(0, 65103, '\p{^Blk=_ CJK_Compat_FORMS}', "");
Expect(0, 65103, '\P{Blk=_ CJK_Compat_FORMS}', "");
Expect(1, 65103, '\P{^Blk=_ CJK_Compat_FORMS}', "");
Expect(0, 65104, '\p{Blk=_ CJK_Compat_FORMS}', "");
Expect(1, 65104, '\p{^Blk=_ CJK_Compat_FORMS}', "");
Expect(1, 65104, '\P{Blk=_ CJK_Compat_FORMS}', "");
Expect(0, 65104, '\P{^Blk=_ CJK_Compat_FORMS}', "");
Error('\p{Is_Block=_-cjk_Compatibility_Forms/a/}');
Error('\P{Is_Block=_-cjk_Compatibility_Forms/a/}');
Expect(1, 65103, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65103, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\p{Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\p{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65104, '\P{Is_Block=cjkcompatibilityforms}', "");
Expect(0, 65104, '\P{^Is_Block=cjkcompatibilityforms}', "");
Expect(1, 65103, '\p{Is_Block=	_CJK_Compatibility_forms}', "");
Expect(0, 65103, '\p{^Is_Block=	_CJK_Compatibility_forms}', "");
Expect(0, 65103, '\P{Is_Block=	_CJK_Compatibility_forms}', "");
Expect(1, 65103, '\P{^Is_Block=	_CJK_Compatibility_forms}', "");
Expect(0, 65104, '\p{Is_Block=	_CJK_Compatibility_forms}', "");
Expect(1, 65104, '\p{^Is_Block=	_CJK_Compatibility_forms}', "");
Expect(1, 65104, '\P{Is_Block=	_CJK_Compatibility_forms}', "");
Expect(0, 65104, '\P{^Is_Block=	_CJK_Compatibility_forms}', "");
Error('\p{Is_Blk=:=_CJK_compat_FORMS}');
Error('\P{Is_Blk=:=_CJK_compat_FORMS}');
Expect(1, 65103, '\p{Is_Blk=cjkcompatforms}', "");
Expect(0, 65103, '\p{^Is_Blk=cjkcompatforms}', "");
Expect(0, 65103, '\P{Is_Blk=cjkcompatforms}', "");
Expect(1, 65103, '\P{^Is_Blk=cjkcompatforms}', "");
Expect(0, 65104, '\p{Is_Blk=cjkcompatforms}', "");
Expect(1, 65104, '\p{^Is_Blk=cjkcompatforms}', "");
Expect(1, 65104, '\P{Is_Blk=cjkcompatforms}', "");
Expect(0, 65104, '\P{^Is_Blk=cjkcompatforms}', "");
Expect(1, 65103, '\p{Is_Blk= CJK_Compat_forms}', "");
Expect(0, 65103, '\p{^Is_Blk= CJK_Compat_forms}', "");
Expect(0, 65103, '\P{Is_Blk= CJK_Compat_forms}', "");
Expect(1, 65103, '\P{^Is_Blk= CJK_Compat_forms}', "");
Expect(0, 65104, '\p{Is_Blk= CJK_Compat_forms}', "");
Expect(1, 65104, '\p{^Is_Blk= CJK_Compat_forms}', "");
Expect(1, 65104, '\P{Is_Blk= CJK_Compat_forms}', "");
Expect(0, 65104, '\P{^Is_Blk= CJK_Compat_forms}', "");
Error('\p{Block=	CJK_Compatibility_IDEOGRAPHS/a/}');
Error('\P{Block=	CJK_Compatibility_IDEOGRAPHS/a/}');
Expect(1, 64255, '\p{Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\p{Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\p{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\P{Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\P{^Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(0, 64255, '\p{^Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(0, 64255, '\P{Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(1, 64255, '\P{^Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(0, 64256, '\p{Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(1, 64256, '\p{^Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(1, 64256, '\P{Block=		CJK_COMPATIBILITY_ideographs}', "");
Expect(0, 64256, '\P{^Block=		CJK_COMPATIBILITY_ideographs}', "");
Error('\p{Blk:   	_CJK_Compat_Ideographs:=}');
Error('\P{Blk:   	_CJK_Compat_Ideographs:=}');
Expect(1, 64255, '\p{Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\p{^Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\P{Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\P{^Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\p{Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\p{^Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\P{Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\P{^Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\p{Blk=_ CJK_Compat_Ideographs}', "");
Expect(0, 64255, '\p{^Blk=_ CJK_Compat_Ideographs}', "");
Expect(0, 64255, '\P{Blk=_ CJK_Compat_Ideographs}', "");
Expect(1, 64255, '\P{^Blk=_ CJK_Compat_Ideographs}', "");
Expect(0, 64256, '\p{Blk=_ CJK_Compat_Ideographs}', "");
Expect(1, 64256, '\p{^Blk=_ CJK_Compat_Ideographs}', "");
Expect(1, 64256, '\P{Blk=_ CJK_Compat_Ideographs}', "");
Expect(0, 64256, '\P{^Blk=_ CJK_Compat_Ideographs}', "");
Error('\p{Is_Block=_ cjk_Compatibility_Ideographs:=}');
Error('\P{Is_Block=_ cjk_Compatibility_Ideographs:=}');
Expect(1, 64255, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64255, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\p{Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\p{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64256, '\P{Is_Block=cjkcompatibilityideographs}', "");
Expect(0, 64256, '\P{^Is_Block=cjkcompatibilityideographs}', "");
Expect(1, 64255, '\p{Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(0, 64255, '\p{^Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(0, 64255, '\P{Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(1, 64255, '\P{^Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(0, 64256, '\p{Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(1, 64256, '\p{^Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(1, 64256, '\P{Is_Block=	_CJK_Compatibility_Ideographs}', "");
Expect(0, 64256, '\P{^Is_Block=	_CJK_Compatibility_Ideographs}', "");
Error('\p{Is_Blk=_:=cjk_Compat_Ideographs}');
Error('\P{Is_Blk=_:=cjk_Compat_Ideographs}');
Expect(1, 64255, '\p{Is_Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=cjkcompatideographs}', "");
Expect(0, 64255, '\P{Is_Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\p{Is_Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\p{^Is_Blk=cjkcompatideographs}', "");
Expect(1, 64256, '\P{Is_Blk=cjkcompatideographs}', "");
Expect(0, 64256, '\P{^Is_Blk=cjkcompatideographs}', "");
Expect(1, 64255, '\p{Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(0, 64255, '\p{^Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(0, 64255, '\P{Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(1, 64255, '\P{^Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(0, 64256, '\p{Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(1, 64256, '\p{^Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(1, 64256, '\P{Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Expect(0, 64256, '\P{^Is_Blk=-	CJK_COMPAT_Ideographs}', "");
Error('\p{Block= CJK_compatibility_Ideographs_Supplement/a/}');
Error('\P{Block= CJK_compatibility_Ideographs_Supplement/a/}');
Expect(1, 195103, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\p{Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\p{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\P{Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\P{^Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\p{^Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(0, 195103, '\P{Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(1, 195103, '\P{^Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(0, 195104, '\p{Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(1, 195104, '\p{^Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(1, 195104, '\P{Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Expect(0, 195104, '\P{^Block=__CJK_compatibility_ideographs_SUPPLEMENT}', "");
Error('\p{Blk= :=CJK_compat_ideographs_sup}');
Error('\P{Blk= :=CJK_compat_ideographs_sup}');
Expect(1, 195103, '\p{Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\p{^Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\P{Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\P{^Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\p{Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\p{^Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\P{Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\P{^Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\p{Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(0, 195103, '\p{^Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(0, 195103, '\P{Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(1, 195103, '\P{^Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(0, 195104, '\p{Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(1, 195104, '\p{^Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(1, 195104, '\P{Blk= CJK_Compat_Ideographs_Sup}', "");
Expect(0, 195104, '\P{^Blk= CJK_Compat_Ideographs_Sup}', "");
Error('\p{Is_Block=:=	CJK_COMPATIBILITY_ideographs_supplement}');
Error('\P{Is_Block=:=	CJK_COMPATIBILITY_ideographs_supplement}');
Expect(1, 195103, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195103, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\p{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\p{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195104, '\P{Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(0, 195104, '\P{^Is_Block=cjkcompatibilityideographssupplement}', "");
Expect(1, 195103, '\p{Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(0, 195103, '\p{^Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(0, 195103, '\P{Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(1, 195103, '\P{^Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(0, 195104, '\p{Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(1, 195104, '\p{^Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(1, 195104, '\P{Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Expect(0, 195104, '\P{^Is_Block=-CJK_Compatibility_IDEOGRAPHS_SUPPLEMENT}', "");
Error('\p{Is_Blk=:=_ CJK_COMPAT_ideographs_Sup}');
Error('\P{Is_Blk=:=_ CJK_COMPAT_ideographs_Sup}');
Expect(1, 195103, '\p{Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\p{^Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195103, '\P{Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\P{^Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\p{Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\p{^Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195104, '\P{Is_Blk=cjkcompatideographssup}', "");
Expect(0, 195104, '\P{^Is_Blk=cjkcompatideographssup}', "");
Expect(1, 195103, '\p{Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(0, 195103, '\p{^Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(0, 195103, '\P{Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(1, 195103, '\P{^Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(0, 195104, '\p{Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(1, 195104, '\p{^Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(1, 195104, '\P{Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Expect(0, 195104, '\P{^Is_Blk=_ CJK_compat_Ideographs_SUP}', "");
Error('\p{Block=--CJK_Unified_ideographs_Extension_A/a/}');
Error('\P{Block=--CJK_Unified_ideographs_Extension_A/a/}');
Expect(1, 19903, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\p{Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\p{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\P{Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\P{^Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(0, 19903, '\p{^Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(0, 19903, '\P{Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(1, 19903, '\P{^Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(0, 19904, '\p{Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(1, 19904, '\p{^Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(1, 19904, '\P{Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Expect(0, 19904, '\P{^Block:		CJK_Unified_IDEOGRAPHS_EXTENSION_A}', "");
Error('\p{Blk= 	CJK_EXT_A:=}');
Error('\P{Blk= 	CJK_EXT_A:=}');
Expect(1, 19903, '\p{Blk=cjkexta}', "");
Expect(0, 19903, '\p{^Blk=cjkexta}', "");
Expect(0, 19903, '\P{Blk=cjkexta}', "");
Expect(1, 19903, '\P{^Blk=cjkexta}', "");
Expect(0, 19904, '\p{Blk=cjkexta}', "");
Expect(1, 19904, '\p{^Blk=cjkexta}', "");
Expect(1, 19904, '\P{Blk=cjkexta}', "");
Expect(0, 19904, '\P{^Blk=cjkexta}', "");
Expect(1, 19903, '\p{Blk=__CJK_EXT_A}', "");
Expect(0, 19903, '\p{^Blk=__CJK_EXT_A}', "");
Expect(0, 19903, '\P{Blk=__CJK_EXT_A}', "");
Expect(1, 19903, '\P{^Blk=__CJK_EXT_A}', "");
Expect(0, 19904, '\p{Blk=__CJK_EXT_A}', "");
Expect(1, 19904, '\p{^Blk=__CJK_EXT_A}', "");
Expect(1, 19904, '\P{Blk=__CJK_EXT_A}', "");
Expect(0, 19904, '\P{^Blk=__CJK_EXT_A}', "");
Error('\p{Is_Block=-:=CJK_unified_Ideographs_Extension_a}');
Error('\P{Is_Block=-:=CJK_unified_Ideographs_Extension_a}');
Expect(1, 19903, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19903, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\p{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\p{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19904, '\P{Is_Block=cjkunifiedideographsextensiona}', "");
Expect(0, 19904, '\P{^Is_Block=cjkunifiedideographsextensiona}', "");
Expect(1, 19903, '\p{Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(0, 19903, '\p{^Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(0, 19903, '\P{Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(1, 19903, '\P{^Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(0, 19904, '\p{Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(1, 19904, '\p{^Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(1, 19904, '\P{Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Expect(0, 19904, '\P{^Is_Block=  CJK_Unified_IDEOGRAPHS_Extension_A}', "");
Error('\p{Is_Blk=	 cjk_EXT_A/a/}');
Error('\P{Is_Blk=	 cjk_EXT_A/a/}');
Expect(1, 19903, '\p{Is_Blk:   cjkexta}', "");
Expect(0, 19903, '\p{^Is_Blk:   cjkexta}', "");
Expect(0, 19903, '\P{Is_Blk:   cjkexta}', "");
Expect(1, 19903, '\P{^Is_Blk:   cjkexta}', "");
Expect(0, 19904, '\p{Is_Blk:   cjkexta}', "");
Expect(1, 19904, '\p{^Is_Blk:   cjkexta}', "");
Expect(1, 19904, '\P{Is_Blk:   cjkexta}', "");
Expect(0, 19904, '\P{^Is_Blk:   cjkexta}', "");
Expect(1, 19903, '\p{Is_Blk=	CJK_Ext_A}', "");
Expect(0, 19903, '\p{^Is_Blk=	CJK_Ext_A}', "");
Expect(0, 19903, '\P{Is_Blk=	CJK_Ext_A}', "");
Expect(1, 19903, '\P{^Is_Blk=	CJK_Ext_A}', "");
Expect(0, 19904, '\p{Is_Blk=	CJK_Ext_A}', "");
Expect(1, 19904, '\p{^Is_Blk=	CJK_Ext_A}', "");
Expect(1, 19904, '\P{Is_Blk=	CJK_Ext_A}', "");
Expect(0, 19904, '\P{^Is_Blk=	CJK_Ext_A}', "");
Error('\p{Block= 	CJK_unified_ideographs_EXTENSION_B:=}');
Error('\P{Block= 	CJK_unified_ideographs_EXTENSION_B:=}');
Expect(1, 173791, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\p{Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\p{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\P{Block=cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\P{^Block=cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(0, 173791, '\p{^Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(0, 173791, '\P{Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(1, 173791, '\P{^Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(0, 173792, '\p{Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(1, 173792, '\p{^Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(1, 173792, '\P{Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Expect(0, 173792, '\P{^Block=CJK_Unified_IDEOGRAPHS_extension_B}', "");
Error('\p{Blk=:=_	cjk_Ext_B}');
Error('\P{Blk=:=_	cjk_Ext_B}');
Expect(1, 173791, '\p{Blk=cjkextb}', "");
Expect(0, 173791, '\p{^Blk=cjkextb}', "");
Expect(0, 173791, '\P{Blk=cjkextb}', "");
Expect(1, 173791, '\P{^Blk=cjkextb}', "");
Expect(0, 173792, '\p{Blk=cjkextb}', "");
Expect(1, 173792, '\p{^Blk=cjkextb}', "");
Expect(1, 173792, '\P{Blk=cjkextb}', "");
Expect(0, 173792, '\P{^Blk=cjkextb}', "");
Expect(1, 173791, '\p{Blk:   --cjk_ext_b}', "");
Expect(0, 173791, '\p{^Blk:   --cjk_ext_b}', "");
Expect(0, 173791, '\P{Blk:   --cjk_ext_b}', "");
Expect(1, 173791, '\P{^Blk:   --cjk_ext_b}', "");
Expect(0, 173792, '\p{Blk:   --cjk_ext_b}', "");
Expect(1, 173792, '\p{^Blk:   --cjk_ext_b}', "");
Expect(1, 173792, '\P{Blk:   --cjk_ext_b}', "");
Expect(0, 173792, '\P{^Blk:   --cjk_ext_b}', "");
Error('\p{Is_Block=:=-_cjk_unified_ideographs_Extension_b}');
Error('\P{Is_Block=:=-_cjk_unified_ideographs_Extension_b}');
Expect(1, 173791, '\p{Is_Block: cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\p{^Is_Block: cjkunifiedideographsextensionb}', "");
Expect(0, 173791, '\P{Is_Block: cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\P{^Is_Block: cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\p{Is_Block: cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\p{^Is_Block: cjkunifiedideographsextensionb}', "");
Expect(1, 173792, '\P{Is_Block: cjkunifiedideographsextensionb}', "");
Expect(0, 173792, '\P{^Is_Block: cjkunifiedideographsextensionb}', "");
Expect(1, 173791, '\p{Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(0, 173791, '\p{^Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(0, 173791, '\P{Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(1, 173791, '\P{^Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(0, 173792, '\p{Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(1, 173792, '\p{^Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(1, 173792, '\P{Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Expect(0, 173792, '\P{^Is_Block=	_CJK_UNIFIED_IDEOGRAPHS_extension_B}', "");
Error('\p{Is_Blk=:= _cjk_Ext_B}');
Error('\P{Is_Blk=:= _cjk_Ext_B}');
Expect(1, 173791, '\p{Is_Blk=cjkextb}', "");
Expect(0, 173791, '\p{^Is_Blk=cjkextb}', "");
Expect(0, 173791, '\P{Is_Blk=cjkextb}', "");
Expect(1, 173791, '\P{^Is_Blk=cjkextb}', "");
Expect(0, 173792, '\p{Is_Blk=cjkextb}', "");
Expect(1, 173792, '\p{^Is_Blk=cjkextb}', "");
Expect(1, 173792, '\P{Is_Blk=cjkextb}', "");
Expect(0, 173792, '\P{^Is_Blk=cjkextb}', "");
Expect(1, 173791, '\p{Is_Blk=	_cjk_ext_B}', "");
Expect(0, 173791, '\p{^Is_Blk=	_cjk_ext_B}', "");
Expect(0, 173791, '\P{Is_Blk=	_cjk_ext_B}', "");
Expect(1, 173791, '\P{^Is_Blk=	_cjk_ext_B}', "");
Expect(0, 173792, '\p{Is_Blk=	_cjk_ext_B}', "");
Expect(1, 173792, '\p{^Is_Blk=	_cjk_ext_B}', "");
Expect(1, 173792, '\P{Is_Blk=	_cjk_ext_B}', "");
Expect(0, 173792, '\P{^Is_Blk=	_cjk_ext_B}', "");
Error('\p{Block=:= cjk_Unified_Ideographs_Extension_C}');
Error('\P{Block=:= cjk_Unified_Ideographs_Extension_C}');
Expect(1, 177983, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\p{Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\p{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\P{Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\P{^Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(0, 177983, '\p{^Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(0, 177983, '\P{Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(1, 177983, '\P{^Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(0, 177984, '\p{Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(1, 177984, '\p{^Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(1, 177984, '\P{Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Expect(0, 177984, '\P{^Block=-_CJK_UNIFIED_ideographs_Extension_C}', "");
Error('\p{Blk=-:=CJK_ext_C}');
Error('\P{Blk=-:=CJK_ext_C}');
Expect(1, 177983, '\p{Blk=cjkextc}', "");
Expect(0, 177983, '\p{^Blk=cjkextc}', "");
Expect(0, 177983, '\P{Blk=cjkextc}', "");
Expect(1, 177983, '\P{^Blk=cjkextc}', "");
Expect(0, 177984, '\p{Blk=cjkextc}', "");
Expect(1, 177984, '\p{^Blk=cjkextc}', "");
Expect(1, 177984, '\P{Blk=cjkextc}', "");
Expect(0, 177984, '\P{^Blk=cjkextc}', "");
Expect(1, 177983, '\p{Blk:	- CJK_ext_C}', "");
Expect(0, 177983, '\p{^Blk:	- CJK_ext_C}', "");
Expect(0, 177983, '\P{Blk:	- CJK_ext_C}', "");
Expect(1, 177983, '\P{^Blk:	- CJK_ext_C}', "");
Expect(0, 177984, '\p{Blk:	- CJK_ext_C}', "");
Expect(1, 177984, '\p{^Blk:	- CJK_ext_C}', "");
Expect(1, 177984, '\P{Blk:	- CJK_ext_C}', "");
Expect(0, 177984, '\P{^Blk:	- CJK_ext_C}', "");
Error('\p{Is_Block=-/a/CJK_unified_IDEOGRAPHS_Extension_C}');
Error('\P{Is_Block=-/a/CJK_unified_IDEOGRAPHS_Extension_C}');
Expect(1, 177983, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177983, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\p{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\p{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177984, '\P{Is_Block=cjkunifiedideographsextensionc}', "");
Expect(0, 177984, '\P{^Is_Block=cjkunifiedideographsextensionc}', "");
Expect(1, 177983, '\p{Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(0, 177983, '\p{^Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(0, 177983, '\P{Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(1, 177983, '\P{^Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(0, 177984, '\p{Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(1, 177984, '\p{^Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(1, 177984, '\P{Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Expect(0, 177984, '\P{^Is_Block:	_	CJK_Unified_IDEOGRAPHS_EXTENSION_C}', "");
Error('\p{Is_Blk=/a/	CJK_Ext_c}');
Error('\P{Is_Blk=/a/	CJK_Ext_c}');
Expect(1, 177983, '\p{Is_Blk=cjkextc}', "");
Expect(0, 177983, '\p{^Is_Blk=cjkextc}', "");
Expect(0, 177983, '\P{Is_Blk=cjkextc}', "");
Expect(1, 177983, '\P{^Is_Blk=cjkextc}', "");
Expect(0, 177984, '\p{Is_Blk=cjkextc}', "");
Expect(1, 177984, '\p{^Is_Blk=cjkextc}', "");
Expect(1, 177984, '\P{Is_Blk=cjkextc}', "");
Expect(0, 177984, '\P{^Is_Blk=cjkextc}', "");
Expect(1, 177983, '\p{Is_Blk=_	CJK_EXT_C}', "");
Expect(0, 177983, '\p{^Is_Blk=_	CJK_EXT_C}', "");
Expect(0, 177983, '\P{Is_Blk=_	CJK_EXT_C}', "");
Expect(1, 177983, '\P{^Is_Blk=_	CJK_EXT_C}', "");
Expect(0, 177984, '\p{Is_Blk=_	CJK_EXT_C}', "");
Expect(1, 177984, '\p{^Is_Blk=_	CJK_EXT_C}', "");
Expect(1, 177984, '\P{Is_Blk=_	CJK_EXT_C}', "");
Expect(0, 177984, '\P{^Is_Blk=_	CJK_EXT_C}', "");
Error('\p{Block=/a/-	CJK_Unified_Ideographs_extension_d}');
Error('\P{Block=/a/-	CJK_Unified_Ideographs_extension_d}');
Expect(1, 178207, '\p{Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\p{^Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\P{Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\P{^Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\p{Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\p{^Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\P{Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\P{^Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\p{Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(0, 178207, '\p{^Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(0, 178207, '\P{Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(1, 178207, '\P{^Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(0, 178208, '\p{Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(1, 178208, '\p{^Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(1, 178208, '\P{Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Expect(0, 178208, '\P{^Block=	_CJK_UNIFIED_IDEOGRAPHS_Extension_D}', "");
Error('\p{Blk=		CJK_ext_d/a/}');
Error('\P{Blk=		CJK_ext_d/a/}');
Expect(1, 178207, '\p{Blk=cjkextd}', "");
Expect(0, 178207, '\p{^Blk=cjkextd}', "");
Expect(0, 178207, '\P{Blk=cjkextd}', "");
Expect(1, 178207, '\P{^Blk=cjkextd}', "");
Expect(0, 178208, '\p{Blk=cjkextd}', "");
Expect(1, 178208, '\p{^Blk=cjkextd}', "");
Expect(1, 178208, '\P{Blk=cjkextd}', "");
Expect(0, 178208, '\P{^Blk=cjkextd}', "");
Expect(1, 178207, '\p{Blk=  cjk_Ext_D}', "");
Expect(0, 178207, '\p{^Blk=  cjk_Ext_D}', "");
Expect(0, 178207, '\P{Blk=  cjk_Ext_D}', "");
Expect(1, 178207, '\P{^Blk=  cjk_Ext_D}', "");
Expect(0, 178208, '\p{Blk=  cjk_Ext_D}', "");
Expect(1, 178208, '\p{^Blk=  cjk_Ext_D}', "");
Expect(1, 178208, '\P{Blk=  cjk_Ext_D}', "");
Expect(0, 178208, '\P{^Blk=  cjk_Ext_D}', "");
Error('\p{Is_Block=_-CJK_Unified_Ideographs_Extension_D:=}');
Error('\P{Is_Block=_-CJK_Unified_Ideographs_Extension_D:=}');
Expect(1, 178207, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178207, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\p{Is_Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\p{^Is_Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178208, '\P{Is_Block=cjkunifiedideographsextensiond}', "");
Expect(0, 178208, '\P{^Is_Block=cjkunifiedideographsextensiond}', "");
Expect(1, 178207, '\p{Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(0, 178207, '\p{^Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(0, 178207, '\P{Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(1, 178207, '\P{^Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(0, 178208, '\p{Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(1, 178208, '\p{^Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(1, 178208, '\P{Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Expect(0, 178208, '\P{^Is_Block= CJK_Unified_Ideographs_Extension_d}', "");
Error('\p{Is_Blk=	:=CJK_EXT_D}');
Error('\P{Is_Blk=	:=CJK_EXT_D}');
Expect(1, 178207, '\p{Is_Blk=cjkextd}', "");
Expect(0, 178207, '\p{^Is_Blk=cjkextd}', "");
Expect(0, 178207, '\P{Is_Blk=cjkextd}', "");
Expect(1, 178207, '\P{^Is_Blk=cjkextd}', "");
Expect(0, 178208, '\p{Is_Blk=cjkextd}', "");
Expect(1, 178208, '\p{^Is_Blk=cjkextd}', "");
Expect(1, 178208, '\P{Is_Blk=cjkextd}', "");
Expect(0, 178208, '\P{^Is_Blk=cjkextd}', "");
Expect(1, 178207, '\p{Is_Blk:	--CJK_ext_d}', "");
Expect(0, 178207, '\p{^Is_Blk:	--CJK_ext_d}', "");
Expect(0, 178207, '\P{Is_Blk:	--CJK_ext_d}', "");
Expect(1, 178207, '\P{^Is_Blk:	--CJK_ext_d}', "");
Expect(0, 178208, '\p{Is_Blk:	--CJK_ext_d}', "");
Expect(1, 178208, '\p{^Is_Blk:	--CJK_ext_d}', "");
Expect(1, 178208, '\P{Is_Blk:	--CJK_ext_d}', "");
Expect(0, 178208, '\P{^Is_Blk:	--CJK_ext_d}', "");
Error('\p{Block=--CJK_radicals_Supplement:=}');
Error('\P{Block=--CJK_radicals_Supplement:=}');
Expect(1, 12031, '\p{Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Block=cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Block=cjkradicalssupplement}', "");
Expect(0, 12032, '\p{Block=cjkradicalssupplement}', "");
Expect(1, 12032, '\p{^Block=cjkradicalssupplement}', "");
Expect(1, 12032, '\P{Block=cjkradicalssupplement}', "");
Expect(0, 12032, '\P{^Block=cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(0, 12031, '\p{^Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(0, 12031, '\P{Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(1, 12031, '\P{^Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(0, 12032, '\p{Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(1, 12032, '\p{^Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(1, 12032, '\P{Block:    -cjk_radicals_SUPPLEMENT}', "");
Expect(0, 12032, '\P{^Block:    -cjk_radicals_SUPPLEMENT}', "");
Error('\p{Blk=	-CJK_Radicals_sup:=}');
Error('\P{Blk=	-CJK_Radicals_sup:=}');
Expect(1, 12031, '\p{Blk=cjkradicalssup}', "");
Expect(0, 12031, '\p{^Blk=cjkradicalssup}', "");
Expect(0, 12031, '\P{Blk=cjkradicalssup}', "");
Expect(1, 12031, '\P{^Blk=cjkradicalssup}', "");
Expect(0, 12032, '\p{Blk=cjkradicalssup}', "");
Expect(1, 12032, '\p{^Blk=cjkradicalssup}', "");
Expect(1, 12032, '\P{Blk=cjkradicalssup}', "");
Expect(0, 12032, '\P{^Blk=cjkradicalssup}', "");
Expect(1, 12031, '\p{Blk=_ CJK_Radicals_sup}', "");
Expect(0, 12031, '\p{^Blk=_ CJK_Radicals_sup}', "");
Expect(0, 12031, '\P{Blk=_ CJK_Radicals_sup}', "");
Expect(1, 12031, '\P{^Blk=_ CJK_Radicals_sup}', "");
Expect(0, 12032, '\p{Blk=_ CJK_Radicals_sup}', "");
Expect(1, 12032, '\p{^Blk=_ CJK_Radicals_sup}', "");
Expect(1, 12032, '\P{Blk=_ CJK_Radicals_sup}', "");
Expect(0, 12032, '\P{^Blk=_ CJK_Radicals_sup}', "");
Error('\p{Is_Block=/a/ _CJK_radicals_Supplement}');
Error('\P{Is_Block=/a/ _CJK_radicals_Supplement}');
Expect(1, 12031, '\p{Is_Block:   cjkradicalssupplement}', "");
Expect(0, 12031, '\p{^Is_Block:   cjkradicalssupplement}', "");
Expect(0, 12031, '\P{Is_Block:   cjkradicalssupplement}', "");
Expect(1, 12031, '\P{^Is_Block:   cjkradicalssupplement}', "");
Expect(0, 12032, '\p{Is_Block:   cjkradicalssupplement}', "");
Expect(1, 12032, '\p{^Is_Block:   cjkradicalssupplement}', "");
Expect(1, 12032, '\P{Is_Block:   cjkradicalssupplement}', "");
Expect(0, 12032, '\P{^Is_Block:   cjkradicalssupplement}', "");
Expect(1, 12031, '\p{Is_Block=	 CJK_radicals_supplement}', "");
Expect(0, 12031, '\p{^Is_Block=	 CJK_radicals_supplement}', "");
Expect(0, 12031, '\P{Is_Block=	 CJK_radicals_supplement}', "");
Expect(1, 12031, '\P{^Is_Block=	 CJK_radicals_supplement}', "");
Expect(0, 12032, '\p{Is_Block=	 CJK_radicals_supplement}', "");
Expect(1, 12032, '\p{^Is_Block=	 CJK_radicals_supplement}', "");
Expect(1, 12032, '\P{Is_Block=	 CJK_radicals_supplement}', "");
Expect(0, 12032, '\P{^Is_Block=	 CJK_radicals_supplement}', "");
Error('\p{Is_Blk=	cjk_RADICALS_Sup:=}');
Error('\P{Is_Blk=	cjk_RADICALS_Sup:=}');
Expect(1, 12031, '\p{Is_Blk=cjkradicalssup}', "");
Expect(0, 12031, '\p{^Is_Blk=cjkradicalssup}', "");
Expect(0, 12031, '\P{Is_Blk=cjkradicalssup}', "");
Expect(1, 12031, '\P{^Is_Blk=cjkradicalssup}', "");
Expect(0, 12032, '\p{Is_Blk=cjkradicalssup}', "");
Expect(1, 12032, '\p{^Is_Blk=cjkradicalssup}', "");
Expect(1, 12032, '\P{Is_Blk=cjkradicalssup}', "");
Expect(0, 12032, '\P{^Is_Blk=cjkradicalssup}', "");
Expect(1, 12031, '\p{Is_Blk=	CJK_Radicals_SUP}', "");
Expect(0, 12031, '\p{^Is_Blk=	CJK_Radicals_SUP}', "");
Expect(0, 12031, '\P{Is_Blk=	CJK_Radicals_SUP}', "");
Expect(1, 12031, '\P{^Is_Blk=	CJK_Radicals_SUP}', "");
Expect(0, 12032, '\p{Is_Blk=	CJK_Radicals_SUP}', "");
Expect(1, 12032, '\p{^Is_Blk=	CJK_Radicals_SUP}', "");
Expect(1, 12032, '\P{Is_Blk=	CJK_Radicals_SUP}', "");
Expect(0, 12032, '\P{^Is_Blk=	CJK_Radicals_SUP}', "");
Error('\p{Block=_-CJK_Strokes/a/}');
Error('\P{Block=_-CJK_Strokes/a/}');
Expect(1, 12783, '\p{Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Block=cjkstrokes}', "");
Expect(0, 12784, '\p{Block=cjkstrokes}', "");
Expect(1, 12784, '\p{^Block=cjkstrokes}', "");
Expect(1, 12784, '\P{Block=cjkstrokes}', "");
Expect(0, 12784, '\P{^Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Block=- CJK_STROKES}', "");
Expect(0, 12783, '\p{^Block=- CJK_STROKES}', "");
Expect(0, 12783, '\P{Block=- CJK_STROKES}', "");
Expect(1, 12783, '\P{^Block=- CJK_STROKES}', "");
Expect(0, 12784, '\p{Block=- CJK_STROKES}', "");
Expect(1, 12784, '\p{^Block=- CJK_STROKES}', "");
Expect(1, 12784, '\P{Block=- CJK_STROKES}', "");
Expect(0, 12784, '\P{^Block=- CJK_STROKES}', "");
Error('\p{Blk=:=  CJK_Strokes}');
Error('\P{Blk=:=  CJK_Strokes}');
Expect(1, 12783, '\p{Blk=cjkstrokes}', "");
Expect(0, 12783, '\p{^Blk=cjkstrokes}', "");
Expect(0, 12783, '\P{Blk=cjkstrokes}', "");
Expect(1, 12783, '\P{^Blk=cjkstrokes}', "");
Expect(0, 12784, '\p{Blk=cjkstrokes}', "");
Expect(1, 12784, '\p{^Blk=cjkstrokes}', "");
Expect(1, 12784, '\P{Blk=cjkstrokes}', "");
Expect(0, 12784, '\P{^Blk=cjkstrokes}', "");
Expect(1, 12783, '\p{Blk: - CJK_Strokes}', "");
Expect(0, 12783, '\p{^Blk: - CJK_Strokes}', "");
Expect(0, 12783, '\P{Blk: - CJK_Strokes}', "");
Expect(1, 12783, '\P{^Blk: - CJK_Strokes}', "");
Expect(0, 12784, '\p{Blk: - CJK_Strokes}', "");
Expect(1, 12784, '\p{^Blk: - CJK_Strokes}', "");
Expect(1, 12784, '\P{Blk: - CJK_Strokes}', "");
Expect(0, 12784, '\P{^Blk: - CJK_Strokes}', "");
Error('\p{Is_Block=/a/ _CJK_Strokes}');
Error('\P{Is_Block=/a/ _CJK_Strokes}');
Expect(1, 12783, '\p{Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Block=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Block=cjkstrokes}', "");
Expect(0, 12784, '\p{Is_Block=cjkstrokes}', "");
Expect(1, 12784, '\p{^Is_Block=cjkstrokes}', "");
Expect(1, 12784, '\P{Is_Block=cjkstrokes}', "");
Expect(0, 12784, '\P{^Is_Block=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Block=	_CJK_Strokes}', "");
Expect(0, 12783, '\p{^Is_Block=	_CJK_Strokes}', "");
Expect(0, 12783, '\P{Is_Block=	_CJK_Strokes}', "");
Expect(1, 12783, '\P{^Is_Block=	_CJK_Strokes}', "");
Expect(0, 12784, '\p{Is_Block=	_CJK_Strokes}', "");
Expect(1, 12784, '\p{^Is_Block=	_CJK_Strokes}', "");
Expect(1, 12784, '\P{Is_Block=	_CJK_Strokes}', "");
Expect(0, 12784, '\P{^Is_Block=	_CJK_Strokes}', "");
Error('\p{Is_Blk=:=-_CJK_Strokes}');
Error('\P{Is_Blk=:=-_CJK_Strokes}');
Expect(1, 12783, '\p{Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\p{^Is_Blk=cjkstrokes}', "");
Expect(0, 12783, '\P{Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\P{^Is_Blk=cjkstrokes}', "");
Expect(0, 12784, '\p{Is_Blk=cjkstrokes}', "");
Expect(1, 12784, '\p{^Is_Blk=cjkstrokes}', "");
Expect(1, 12784, '\P{Is_Blk=cjkstrokes}', "");
Expect(0, 12784, '\P{^Is_Blk=cjkstrokes}', "");
Expect(1, 12783, '\p{Is_Blk=_-CJK_Strokes}', "");
Expect(0, 12783, '\p{^Is_Blk=_-CJK_Strokes}', "");
Expect(0, 12783, '\P{Is_Blk=_-CJK_Strokes}', "");
Expect(1, 12783, '\P{^Is_Blk=_-CJK_Strokes}', "");
Expect(0, 12784, '\p{Is_Blk=_-CJK_Strokes}', "");
Expect(1, 12784, '\p{^Is_Blk=_-CJK_Strokes}', "");
Expect(1, 12784, '\P{Is_Blk=_-CJK_Strokes}', "");
Expect(0, 12784, '\P{^Is_Blk=_-CJK_Strokes}', "");
Error('\p{Block=/a/- CJK_Symbols_AND_PUNCTUATION}');
Error('\P{Block=/a/- CJK_Symbols_AND_PUNCTUATION}');
Expect(1, 12351, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(0, 12352, '\p{Block=cjksymbolsandpunctuation}', "");
Expect(1, 12352, '\p{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12352, '\P{Block=cjksymbolsandpunctuation}', "");
Expect(0, 12352, '\P{^Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(0, 12351, '\p{^Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(0, 12351, '\P{Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(1, 12351, '\P{^Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(0, 12352, '\p{Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(1, 12352, '\p{^Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(1, 12352, '\P{Block= 	CJK_Symbols_and_Punctuation}', "");
Expect(0, 12352, '\P{^Block= 	CJK_Symbols_and_Punctuation}', "");
Error('\p{Blk:   :=-CJK_SYMBOLS}');
Error('\P{Blk:   :=-CJK_SYMBOLS}');
Expect(1, 12351, '\p{Blk=cjksymbols}', "");
Expect(0, 12351, '\p{^Blk=cjksymbols}', "");
Expect(0, 12351, '\P{Blk=cjksymbols}', "");
Expect(1, 12351, '\P{^Blk=cjksymbols}', "");
Expect(0, 12352, '\p{Blk=cjksymbols}', "");
Expect(1, 12352, '\p{^Blk=cjksymbols}', "");
Expect(1, 12352, '\P{Blk=cjksymbols}', "");
Expect(0, 12352, '\P{^Blk=cjksymbols}', "");
Expect(1, 12351, '\p{Blk=-CJK_Symbols}', "");
Expect(0, 12351, '\p{^Blk=-CJK_Symbols}', "");
Expect(0, 12351, '\P{Blk=-CJK_Symbols}', "");
Expect(1, 12351, '\P{^Blk=-CJK_Symbols}', "");
Expect(0, 12352, '\p{Blk=-CJK_Symbols}', "");
Expect(1, 12352, '\p{^Blk=-CJK_Symbols}', "");
Expect(1, 12352, '\P{Blk=-CJK_Symbols}', "");
Expect(0, 12352, '\P{^Blk=-CJK_Symbols}', "");
Error('\p{Is_Block:   -:=CJK_Symbols_AND_punctuation}');
Error('\P{Is_Block:   -:=CJK_Symbols_AND_punctuation}');
Expect(1, 12351, '\p{Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12351, '\P{Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12352, '\p{Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12352, '\p{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12352, '\P{Is_Block=cjksymbolsandpunctuation}', "");
Expect(0, 12352, '\P{^Is_Block=cjksymbolsandpunctuation}', "");
Expect(1, 12351, '\p{Is_Block=CJK_symbols_And_punctuation}', "");
Expect(0, 12351, '\p{^Is_Block=CJK_symbols_And_punctuation}', "");
Expect(0, 12351, '\P{Is_Block=CJK_symbols_And_punctuation}', "");
Expect(1, 12351, '\P{^Is_Block=CJK_symbols_And_punctuation}', "");
Expect(0, 12352, '\p{Is_Block=CJK_symbols_And_punctuation}', "");
Expect(1, 12352, '\p{^Is_Block=CJK_symbols_And_punctuation}', "");
Expect(1, 12352, '\P{Is_Block=CJK_symbols_And_punctuation}', "");
Expect(0, 12352, '\P{^Is_Block=CJK_symbols_And_punctuation}', "");
Error('\p{Is_Blk:	_/a/cjk_Symbols}');
Error('\P{Is_Blk:	_/a/cjk_Symbols}');
Expect(1, 12351, '\p{Is_Blk=cjksymbols}', "");
Expect(0, 12351, '\p{^Is_Blk=cjksymbols}', "");
Expect(0, 12351, '\P{Is_Blk=cjksymbols}', "");
Expect(1, 12351, '\P{^Is_Blk=cjksymbols}', "");
Expect(0, 12352, '\p{Is_Blk=cjksymbols}', "");
Expect(1, 12352, '\p{^Is_Blk=cjksymbols}', "");
Expect(1, 12352, '\P{Is_Blk=cjksymbols}', "");
Expect(0, 12352, '\P{^Is_Blk=cjksymbols}', "");
Expect(1, 12351, '\p{Is_Blk= CJK_Symbols}', "");
Expect(0, 12351, '\p{^Is_Blk= CJK_Symbols}', "");
Expect(0, 12351, '\P{Is_Blk= CJK_Symbols}', "");
Expect(1, 12351, '\P{^Is_Blk= CJK_Symbols}', "");
Expect(0, 12352, '\p{Is_Blk= CJK_Symbols}', "");
Expect(1, 12352, '\p{^Is_Blk= CJK_Symbols}', "");
Expect(1, 12352, '\P{Is_Blk= CJK_Symbols}', "");
Expect(0, 12352, '\P{^Is_Blk= CJK_Symbols}', "");
Error('\p{Block=__carian/a/}');
Error('\P{Block=__carian/a/}');
Expect(1, 66271, '\p{Block=carian}', "");
Expect(0, 66271, '\p{^Block=carian}', "");
Expect(0, 66271, '\P{Block=carian}', "");
Expect(1, 66271, '\P{^Block=carian}', "");
Expect(0, 66272, '\p{Block=carian}', "");
Expect(1, 66272, '\p{^Block=carian}', "");
Expect(1, 66272, '\P{Block=carian}', "");
Expect(0, 66272, '\P{^Block=carian}', "");
Expect(1, 66271, '\p{Block= -CARIAN}', "");
Expect(0, 66271, '\p{^Block= -CARIAN}', "");
Expect(0, 66271, '\P{Block= -CARIAN}', "");
Expect(1, 66271, '\P{^Block= -CARIAN}', "");
Expect(0, 66272, '\p{Block= -CARIAN}', "");
Expect(1, 66272, '\p{^Block= -CARIAN}', "");
Expect(1, 66272, '\P{Block= -CARIAN}', "");
Expect(0, 66272, '\P{^Block= -CARIAN}', "");
Error('\p{Blk=-carian/a/}');
Error('\P{Blk=-carian/a/}');
Expect(1, 66271, '\p{Blk=carian}', "");
Expect(0, 66271, '\p{^Blk=carian}', "");
Expect(0, 66271, '\P{Blk=carian}', "");
Expect(1, 66271, '\P{^Blk=carian}', "");
Expect(0, 66272, '\p{Blk=carian}', "");
Expect(1, 66272, '\p{^Blk=carian}', "");
Expect(1, 66272, '\P{Blk=carian}', "");
Expect(0, 66272, '\P{^Blk=carian}', "");
Expect(1, 66271, '\p{Blk=	Carian}', "");
Expect(0, 66271, '\p{^Blk=	Carian}', "");
Expect(0, 66271, '\P{Blk=	Carian}', "");
Expect(1, 66271, '\P{^Blk=	Carian}', "");
Expect(0, 66272, '\p{Blk=	Carian}', "");
Expect(1, 66272, '\p{^Blk=	Carian}', "");
Expect(1, 66272, '\P{Blk=	Carian}', "");
Expect(0, 66272, '\P{^Blk=	Carian}', "");
Error('\p{Is_Block= Carian:=}');
Error('\P{Is_Block= Carian:=}');
Expect(1, 66271, '\p{Is_Block:carian}', "");
Expect(0, 66271, '\p{^Is_Block:carian}', "");
Expect(0, 66271, '\P{Is_Block:carian}', "");
Expect(1, 66271, '\P{^Is_Block:carian}', "");
Expect(0, 66272, '\p{Is_Block:carian}', "");
Expect(1, 66272, '\p{^Is_Block:carian}', "");
Expect(1, 66272, '\P{Is_Block:carian}', "");
Expect(0, 66272, '\P{^Is_Block:carian}', "");
Expect(1, 66271, '\p{Is_Block=	_carian}', "");
Expect(0, 66271, '\p{^Is_Block=	_carian}', "");
Expect(0, 66271, '\P{Is_Block=	_carian}', "");
Expect(1, 66271, '\P{^Is_Block=	_carian}', "");
Expect(0, 66272, '\p{Is_Block=	_carian}', "");
Expect(1, 66272, '\p{^Is_Block=	_carian}', "");
Expect(1, 66272, '\P{Is_Block=	_carian}', "");
Expect(0, 66272, '\P{^Is_Block=	_carian}', "");
Error('\p{Is_Blk=-_carian:=}');
Error('\P{Is_Blk=-_carian:=}');
Expect(1, 66271, '\p{Is_Blk=carian}', "");
Expect(0, 66271, '\p{^Is_Blk=carian}', "");
Expect(0, 66271, '\P{Is_Blk=carian}', "");
Expect(1, 66271, '\P{^Is_Blk=carian}', "");
Expect(0, 66272, '\p{Is_Blk=carian}', "");
Expect(1, 66272, '\p{^Is_Blk=carian}', "");
Expect(1, 66272, '\P{Is_Blk=carian}', "");
Expect(0, 66272, '\P{^Is_Blk=carian}', "");
Expect(1, 66271, '\p{Is_Blk:  -Carian}', "");
Expect(0, 66271, '\p{^Is_Blk:  -Carian}', "");
Expect(0, 66271, '\P{Is_Blk:  -Carian}', "");
Expect(1, 66271, '\P{^Is_Blk:  -Carian}', "");
Expect(0, 66272, '\p{Is_Blk:  -Carian}', "");
Expect(1, 66272, '\p{^Is_Blk:  -Carian}', "");
Expect(1, 66272, '\P{Is_Blk:  -Carian}', "");
Expect(0, 66272, '\P{^Is_Blk:  -Carian}', "");
Error('\p{Block=/a/_CAUCASIAN_albanian}');
Error('\P{Block=/a/_CAUCASIAN_albanian}');
Expect(1, 66927, '\p{Block=caucasianalbanian}', "");
Expect(0, 66927, '\p{^Block=caucasianalbanian}', "");
Expect(0, 66927, '\P{Block=caucasianalbanian}', "");
Expect(1, 66927, '\P{^Block=caucasianalbanian}', "");
Expect(0, 66928, '\p{Block=caucasianalbanian}', "");
Expect(1, 66928, '\p{^Block=caucasianalbanian}', "");
Expect(1, 66928, '\P{Block=caucasianalbanian}', "");
Expect(0, 66928, '\P{^Block=caucasianalbanian}', "");
Expect(1, 66927, '\p{Block=-caucasian_Albanian}', "");
Expect(0, 66927, '\p{^Block=-caucasian_Albanian}', "");
Expect(0, 66927, '\P{Block=-caucasian_Albanian}', "");
Expect(1, 66927, '\P{^Block=-caucasian_Albanian}', "");
Expect(0, 66928, '\p{Block=-caucasian_Albanian}', "");
Expect(1, 66928, '\p{^Block=-caucasian_Albanian}', "");
Expect(1, 66928, '\P{Block=-caucasian_Albanian}', "");
Expect(0, 66928, '\P{^Block=-caucasian_Albanian}', "");
Error('\p{Blk=/a/-	Caucasian_ALBANIAN}');
Error('\P{Blk=/a/-	Caucasian_ALBANIAN}');
Expect(1, 66927, '\p{Blk=caucasianalbanian}', "");
Expect(0, 66927, '\p{^Blk=caucasianalbanian}', "");
Expect(0, 66927, '\P{Blk=caucasianalbanian}', "");
Expect(1, 66927, '\P{^Blk=caucasianalbanian}', "");
Expect(0, 66928, '\p{Blk=caucasianalbanian}', "");
Expect(1, 66928, '\p{^Blk=caucasianalbanian}', "");
Expect(1, 66928, '\P{Blk=caucasianalbanian}', "");
Expect(0, 66928, '\P{^Blk=caucasianalbanian}', "");
Expect(1, 66927, '\p{Blk=_-caucasian_Albanian}', "");
Expect(0, 66927, '\p{^Blk=_-caucasian_Albanian}', "");
Expect(0, 66927, '\P{Blk=_-caucasian_Albanian}', "");
Expect(1, 66927, '\P{^Blk=_-caucasian_Albanian}', "");
Expect(0, 66928, '\p{Blk=_-caucasian_Albanian}', "");
Expect(1, 66928, '\p{^Blk=_-caucasian_Albanian}', "");
Expect(1, 66928, '\P{Blk=_-caucasian_Albanian}', "");
Expect(0, 66928, '\P{^Blk=_-caucasian_Albanian}', "");
Error('\p{Is_Block=-Caucasian_Albanian/a/}');
Error('\P{Is_Block=-Caucasian_Albanian/a/}');
Expect(1, 66927, '\p{Is_Block=caucasianalbanian}', "");
Expect(0, 66927, '\p{^Is_Block=caucasianalbanian}', "");
Expect(0, 66927, '\P{Is_Block=caucasianalbanian}', "");
Expect(1, 66927, '\P{^Is_Block=caucasianalbanian}', "");
Expect(0, 66928, '\p{Is_Block=caucasianalbanian}', "");
Expect(1, 66928, '\p{^Is_Block=caucasianalbanian}', "");
Expect(1, 66928, '\P{Is_Block=caucasianalbanian}', "");
Expect(0, 66928, '\P{^Is_Block=caucasianalbanian}', "");
Expect(1, 66927, '\p{Is_Block= _caucasian_Albanian}', "");
Expect(0, 66927, '\p{^Is_Block= _caucasian_Albanian}', "");
Expect(0, 66927, '\P{Is_Block= _caucasian_Albanian}', "");
Expect(1, 66927, '\P{^Is_Block= _caucasian_Albanian}', "");
Expect(0, 66928, '\p{Is_Block= _caucasian_Albanian}', "");
Expect(1, 66928, '\p{^Is_Block= _caucasian_Albanian}', "");
Expect(1, 66928, '\P{Is_Block= _caucasian_Albanian}', "");
Expect(0, 66928, '\P{^Is_Block= _caucasian_Albanian}', "");
Error('\p{Is_Blk=/a/_-Caucasian_ALBANIAN}');
Error('\P{Is_Blk=/a/_-Caucasian_ALBANIAN}');
Expect(1, 66927, '\p{Is_Blk=caucasianalbanian}', "");
Expect(0, 66927, '\p{^Is_Blk=caucasianalbanian}', "");
Expect(0, 66927, '\P{Is_Blk=caucasianalbanian}', "");
Expect(1, 66927, '\P{^Is_Blk=caucasianalbanian}', "");
Expect(0, 66928, '\p{Is_Blk=caucasianalbanian}', "");
Expect(1, 66928, '\p{^Is_Blk=caucasianalbanian}', "");
Expect(1, 66928, '\P{Is_Blk=caucasianalbanian}', "");
Expect(0, 66928, '\P{^Is_Blk=caucasianalbanian}', "");
Expect(1, 66927, '\p{Is_Blk=		Caucasian_Albanian}', "");
Expect(0, 66927, '\p{^Is_Blk=		Caucasian_Albanian}', "");
Expect(0, 66927, '\P{Is_Blk=		Caucasian_Albanian}', "");
Expect(1, 66927, '\P{^Is_Blk=		Caucasian_Albanian}', "");
Expect(0, 66928, '\p{Is_Blk=		Caucasian_Albanian}', "");
Expect(1, 66928, '\p{^Is_Blk=		Caucasian_Albanian}', "");
Expect(1, 66928, '\P{Is_Blk=		Caucasian_Albanian}', "");
Expect(0, 66928, '\P{^Is_Blk=		Caucasian_Albanian}', "");
Error('\p{Block=_ Chakma/a/}');
Error('\P{Block=_ Chakma/a/}');
Expect(1, 69967, '\p{Block=chakma}', "");
Expect(0, 69967, '\p{^Block=chakma}', "");
Expect(0, 69967, '\P{Block=chakma}', "");
Expect(1, 69967, '\P{^Block=chakma}', "");
Expect(0, 69968, '\p{Block=chakma}', "");
Expect(1, 69968, '\p{^Block=chakma}', "");
Expect(1, 69968, '\P{Block=chakma}', "");
Expect(0, 69968, '\P{^Block=chakma}', "");
Expect(1, 69967, '\p{Block=_-chakma}', "");
Expect(0, 69967, '\p{^Block=_-chakma}', "");
Expect(0, 69967, '\P{Block=_-chakma}', "");
Expect(1, 69967, '\P{^Block=_-chakma}', "");
Expect(0, 69968, '\p{Block=_-chakma}', "");
Expect(1, 69968, '\p{^Block=_-chakma}', "");
Expect(1, 69968, '\P{Block=_-chakma}', "");
Expect(0, 69968, '\P{^Block=_-chakma}', "");
Error('\p{Blk=_/a/Chakma}');
Error('\P{Blk=_/a/Chakma}');
Expect(1, 69967, '\p{Blk=chakma}', "");
Expect(0, 69967, '\p{^Blk=chakma}', "");
Expect(0, 69967, '\P{Blk=chakma}', "");
Expect(1, 69967, '\P{^Blk=chakma}', "");
Expect(0, 69968, '\p{Blk=chakma}', "");
Expect(1, 69968, '\p{^Blk=chakma}', "");
Expect(1, 69968, '\P{Blk=chakma}', "");
Expect(0, 69968, '\P{^Blk=chakma}', "");
Expect(1, 69967, '\p{Blk=CHAKMA}', "");
Expect(0, 69967, '\p{^Blk=CHAKMA}', "");
Expect(0, 69967, '\P{Blk=CHAKMA}', "");
Expect(1, 69967, '\P{^Blk=CHAKMA}', "");
Expect(0, 69968, '\p{Blk=CHAKMA}', "");
Expect(1, 69968, '\p{^Blk=CHAKMA}', "");
Expect(1, 69968, '\P{Blk=CHAKMA}', "");
Expect(0, 69968, '\P{^Blk=CHAKMA}', "");
Error('\p{Is_Block=:=-Chakma}');
Error('\P{Is_Block=:=-Chakma}');
Expect(1, 69967, '\p{Is_Block:	chakma}', "");
Expect(0, 69967, '\p{^Is_Block:	chakma}', "");
Expect(0, 69967, '\P{Is_Block:	chakma}', "");
Expect(1, 69967, '\P{^Is_Block:	chakma}', "");
Expect(0, 69968, '\p{Is_Block:	chakma}', "");
Expect(1, 69968, '\p{^Is_Block:	chakma}', "");
Expect(1, 69968, '\P{Is_Block:	chakma}', "");
Expect(0, 69968, '\P{^Is_Block:	chakma}', "");
Expect(1, 69967, '\p{Is_Block=-CHAKMA}', "");
Expect(0, 69967, '\p{^Is_Block=-CHAKMA}', "");
Expect(0, 69967, '\P{Is_Block=-CHAKMA}', "");
Expect(1, 69967, '\P{^Is_Block=-CHAKMA}', "");
Expect(0, 69968, '\p{Is_Block=-CHAKMA}', "");
Expect(1, 69968, '\p{^Is_Block=-CHAKMA}', "");
Expect(1, 69968, '\P{Is_Block=-CHAKMA}', "");
Expect(0, 69968, '\P{^Is_Block=-CHAKMA}', "");
Error('\p{Is_Blk=Chakma/a/}');
Error('\P{Is_Blk=Chakma/a/}');
Expect(1, 69967, '\p{Is_Blk=chakma}', "");
Expect(0, 69967, '\p{^Is_Blk=chakma}', "");
Expect(0, 69967, '\P{Is_Blk=chakma}', "");
Expect(1, 69967, '\P{^Is_Blk=chakma}', "");
Expect(0, 69968, '\p{Is_Blk=chakma}', "");
Expect(1, 69968, '\p{^Is_Blk=chakma}', "");
Expect(1, 69968, '\P{Is_Blk=chakma}', "");
Expect(0, 69968, '\P{^Is_Blk=chakma}', "");
Expect(1, 69967, '\p{Is_Blk:	 chakma}', "");
Expect(0, 69967, '\p{^Is_Blk:	 chakma}', "");
Expect(0, 69967, '\P{Is_Blk:	 chakma}', "");
Expect(1, 69967, '\P{^Is_Blk:	 chakma}', "");
Expect(0, 69968, '\p{Is_Blk:	 chakma}', "");
Expect(1, 69968, '\p{^Is_Blk:	 chakma}', "");
Expect(1, 69968, '\P{Is_Blk:	 chakma}', "");
Expect(0, 69968, '\P{^Is_Blk:	 chakma}', "");
Error('\p{Block= /a/Cham}');
Error('\P{Block= /a/Cham}');
Expect(1, 43615, '\p{Block=cham}', "");
Expect(0, 43615, '\p{^Block=cham}', "");
Expect(0, 43615, '\P{Block=cham}', "");
Expect(1, 43615, '\P{^Block=cham}', "");
Expect(0, 43616, '\p{Block=cham}', "");
Expect(1, 43616, '\p{^Block=cham}', "");
Expect(1, 43616, '\P{Block=cham}', "");
Expect(0, 43616, '\P{^Block=cham}', "");
Expect(1, 43615, '\p{Block=  Cham}', "");
Expect(0, 43615, '\p{^Block=  Cham}', "");
Expect(0, 43615, '\P{Block=  Cham}', "");
Expect(1, 43615, '\P{^Block=  Cham}', "");
Expect(0, 43616, '\p{Block=  Cham}', "");
Expect(1, 43616, '\p{^Block=  Cham}', "");
Expect(1, 43616, '\P{Block=  Cham}', "");
Expect(0, 43616, '\P{^Block=  Cham}', "");
Error('\p{Blk=:= _cham}');
Error('\P{Blk=:= _cham}');
Expect(1, 43615, '\p{Blk=cham}', "");
Expect(0, 43615, '\p{^Blk=cham}', "");
Expect(0, 43615, '\P{Blk=cham}', "");
Expect(1, 43615, '\P{^Blk=cham}', "");
Expect(0, 43616, '\p{Blk=cham}', "");
Expect(1, 43616, '\p{^Blk=cham}', "");
Expect(1, 43616, '\P{Blk=cham}', "");
Expect(0, 43616, '\P{^Blk=cham}', "");
Expect(1, 43615, '\p{Blk=-cham}', "");
Expect(0, 43615, '\p{^Blk=-cham}', "");
Expect(0, 43615, '\P{Blk=-cham}', "");
Expect(1, 43615, '\P{^Blk=-cham}', "");
Expect(0, 43616, '\p{Blk=-cham}', "");
Expect(1, 43616, '\p{^Blk=-cham}', "");
Expect(1, 43616, '\P{Blk=-cham}', "");
Expect(0, 43616, '\P{^Blk=-cham}', "");
Error('\p{Is_Block=/a/cham}');
Error('\P{Is_Block=/a/cham}');
Expect(1, 43615, '\p{Is_Block=cham}', "");
Expect(0, 43615, '\p{^Is_Block=cham}', "");
Expect(0, 43615, '\P{Is_Block=cham}', "");
Expect(1, 43615, '\P{^Is_Block=cham}', "");
Expect(0, 43616, '\p{Is_Block=cham}', "");
Expect(1, 43616, '\p{^Is_Block=cham}', "");
Expect(1, 43616, '\P{Is_Block=cham}', "");
Expect(0, 43616, '\P{^Is_Block=cham}', "");
Expect(1, 43615, '\p{Is_Block=  Cham}', "");
Expect(0, 43615, '\p{^Is_Block=  Cham}', "");
Expect(0, 43615, '\P{Is_Block=  Cham}', "");
Expect(1, 43615, '\P{^Is_Block=  Cham}', "");
Expect(0, 43616, '\p{Is_Block=  Cham}', "");
Expect(1, 43616, '\p{^Is_Block=  Cham}', "");
Expect(1, 43616, '\P{Is_Block=  Cham}', "");
Expect(0, 43616, '\P{^Is_Block=  Cham}', "");
Error('\p{Is_Blk=	_cham/a/}');
Error('\P{Is_Blk=	_cham/a/}');
Expect(1, 43615, '\p{Is_Blk=cham}', "");
Expect(0, 43615, '\p{^Is_Blk=cham}', "");
Expect(0, 43615, '\P{Is_Blk=cham}', "");
Expect(1, 43615, '\P{^Is_Blk=cham}', "");
Expect(0, 43616, '\p{Is_Blk=cham}', "");
Expect(1, 43616, '\p{^Is_Blk=cham}', "");
Expect(1, 43616, '\P{Is_Blk=cham}', "");
Expect(0, 43616, '\P{^Is_Blk=cham}', "");
Expect(1, 43615, '\p{Is_Blk= -Cham}', "");
Expect(0, 43615, '\p{^Is_Blk= -Cham}', "");
Expect(0, 43615, '\P{Is_Blk= -Cham}', "");
Expect(1, 43615, '\P{^Is_Blk= -Cham}', "");
Expect(0, 43616, '\p{Is_Blk= -Cham}', "");
Expect(1, 43616, '\p{^Is_Blk= -Cham}', "");
Expect(1, 43616, '\P{Is_Blk= -Cham}', "");
Expect(0, 43616, '\P{^Is_Blk= -Cham}', "");
Error('\p{Block:	:=cherokee}');
Error('\P{Block:	:=cherokee}');
Expect(1, 5119, '\p{Block=cherokee}', "");
Expect(0, 5119, '\p{^Block=cherokee}', "");
Expect(0, 5119, '\P{Block=cherokee}', "");
Expect(1, 5119, '\P{^Block=cherokee}', "");
Expect(0, 5120, '\p{Block=cherokee}', "");
Expect(1, 5120, '\p{^Block=cherokee}', "");
Expect(1, 5120, '\P{Block=cherokee}', "");
Expect(0, 5120, '\P{^Block=cherokee}', "");
Expect(1, 5119, '\p{Block=_CHEROKEE}', "");
Expect(0, 5119, '\p{^Block=_CHEROKEE}', "");
Expect(0, 5119, '\P{Block=_CHEROKEE}', "");
Expect(1, 5119, '\P{^Block=_CHEROKEE}', "");
Expect(0, 5120, '\p{Block=_CHEROKEE}', "");
Expect(1, 5120, '\p{^Block=_CHEROKEE}', "");
Expect(1, 5120, '\P{Block=_CHEROKEE}', "");
Expect(0, 5120, '\P{^Block=_CHEROKEE}', "");
Error('\p{Blk=_ CHEROKEE:=}');
Error('\P{Blk=_ CHEROKEE:=}');
Expect(1, 5119, '\p{Blk=cherokee}', "");
Expect(0, 5119, '\p{^Blk=cherokee}', "");
Expect(0, 5119, '\P{Blk=cherokee}', "");
Expect(1, 5119, '\P{^Blk=cherokee}', "");
Expect(0, 5120, '\p{Blk=cherokee}', "");
Expect(1, 5120, '\p{^Blk=cherokee}', "");
Expect(1, 5120, '\P{Blk=cherokee}', "");
Expect(0, 5120, '\P{^Blk=cherokee}', "");
Expect(1, 5119, '\p{Blk=-_Cherokee}', "");
Expect(0, 5119, '\p{^Blk=-_Cherokee}', "");
Expect(0, 5119, '\P{Blk=-_Cherokee}', "");
Expect(1, 5119, '\P{^Blk=-_Cherokee}', "");
Expect(0, 5120, '\p{Blk=-_Cherokee}', "");
Expect(1, 5120, '\p{^Blk=-_Cherokee}', "");
Expect(1, 5120, '\P{Blk=-_Cherokee}', "");
Expect(0, 5120, '\P{^Blk=-_Cherokee}', "");
Error('\p{Is_Block=	:=Cherokee}');
Error('\P{Is_Block=	:=Cherokee}');
Expect(1, 5119, '\p{Is_Block=cherokee}', "");
Expect(0, 5119, '\p{^Is_Block=cherokee}', "");
Expect(0, 5119, '\P{Is_Block=cherokee}', "");
Expect(1, 5119, '\P{^Is_Block=cherokee}', "");
Expect(0, 5120, '\p{Is_Block=cherokee}', "");
Expect(1, 5120, '\p{^Is_Block=cherokee}', "");
Expect(1, 5120, '\P{Is_Block=cherokee}', "");
Expect(0, 5120, '\P{^Is_Block=cherokee}', "");
Expect(1, 5119, '\p{Is_Block= cherokee}', "");
Expect(0, 5119, '\p{^Is_Block= cherokee}', "");
Expect(0, 5119, '\P{Is_Block= cherokee}', "");
Expect(1, 5119, '\P{^Is_Block= cherokee}', "");
Expect(0, 5120, '\p{Is_Block= cherokee}', "");
Expect(1, 5120, '\p{^Is_Block= cherokee}', "");
Expect(1, 5120, '\P{Is_Block= cherokee}', "");
Expect(0, 5120, '\P{^Is_Block= cherokee}', "");
Error('\p{Is_Blk= 	Cherokee/a/}');
Error('\P{Is_Blk= 	Cherokee/a/}');
Expect(1, 5119, '\p{Is_Blk=cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk=cherokee}', "");
Expect(0, 5119, '\P{Is_Blk=cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk=cherokee}', "");
Expect(0, 5120, '\p{Is_Blk=cherokee}', "");
Expect(1, 5120, '\p{^Is_Blk=cherokee}', "");
Expect(1, 5120, '\P{Is_Blk=cherokee}', "");
Expect(0, 5120, '\P{^Is_Blk=cherokee}', "");
Expect(1, 5119, '\p{Is_Blk=	cherokee}', "");
Expect(0, 5119, '\p{^Is_Blk=	cherokee}', "");
Expect(0, 5119, '\P{Is_Blk=	cherokee}', "");
Expect(1, 5119, '\P{^Is_Blk=	cherokee}', "");
Expect(0, 5120, '\p{Is_Blk=	cherokee}', "");
Expect(1, 5120, '\p{^Is_Blk=	cherokee}', "");
Expect(1, 5120, '\P{Is_Blk=	cherokee}', "");
Expect(0, 5120, '\P{^Is_Blk=	cherokee}', "");
Error('\p{Block:	-hangul_Compatibility_Jamo/a/}');
Error('\P{Block:	-hangul_Compatibility_Jamo/a/}');
Expect(1, 12687, '\p{Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(0, 12688, '\p{Block=hangulcompatibilityjamo}', "");
Expect(1, 12688, '\p{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12688, '\P{Block=hangulcompatibilityjamo}', "");
Expect(0, 12688, '\P{^Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Block=	hangul_Compatibility_jamo}', "");
Expect(0, 12687, '\p{^Block=	hangul_Compatibility_jamo}', "");
Expect(0, 12687, '\P{Block=	hangul_Compatibility_jamo}', "");
Expect(1, 12687, '\P{^Block=	hangul_Compatibility_jamo}', "");
Expect(0, 12688, '\p{Block=	hangul_Compatibility_jamo}', "");
Expect(1, 12688, '\p{^Block=	hangul_Compatibility_jamo}', "");
Expect(1, 12688, '\P{Block=	hangul_Compatibility_jamo}', "");
Expect(0, 12688, '\P{^Block=	hangul_Compatibility_jamo}', "");
Error('\p{Blk=_:=Compat_JAMO}');
Error('\P{Blk=_:=Compat_JAMO}');
Expect(1, 12687, '\p{Blk:	compatjamo}', "");
Expect(0, 12687, '\p{^Blk:	compatjamo}', "");
Expect(0, 12687, '\P{Blk:	compatjamo}', "");
Expect(1, 12687, '\P{^Blk:	compatjamo}', "");
Expect(0, 12688, '\p{Blk:	compatjamo}', "");
Expect(1, 12688, '\p{^Blk:	compatjamo}', "");
Expect(1, 12688, '\P{Blk:	compatjamo}', "");
Expect(0, 12688, '\P{^Blk:	compatjamo}', "");
Expect(1, 12687, '\p{Blk=_Compat_Jamo}', "");
Expect(0, 12687, '\p{^Blk=_Compat_Jamo}', "");
Expect(0, 12687, '\P{Blk=_Compat_Jamo}', "");
Expect(1, 12687, '\P{^Blk=_Compat_Jamo}', "");
Expect(0, 12688, '\p{Blk=_Compat_Jamo}', "");
Expect(1, 12688, '\p{^Blk=_Compat_Jamo}', "");
Expect(1, 12688, '\P{Blk=_Compat_Jamo}', "");
Expect(0, 12688, '\P{^Blk=_Compat_Jamo}', "");
Error('\p{Is_Block=-	HANGUL_Compatibility_jamo/a/}');
Error('\P{Is_Block=-	HANGUL_Compatibility_jamo/a/}');
Expect(1, 12687, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12687, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12688, '\p{Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12688, '\p{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12688, '\P{Is_Block=hangulcompatibilityjamo}', "");
Expect(0, 12688, '\P{^Is_Block=hangulcompatibilityjamo}', "");
Expect(1, 12687, '\p{Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(0, 12687, '\p{^Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(0, 12687, '\P{Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(1, 12687, '\P{^Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(0, 12688, '\p{Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(1, 12688, '\p{^Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(1, 12688, '\P{Is_Block=	-Hangul_Compatibility_Jamo}', "");
Expect(0, 12688, '\P{^Is_Block=	-Hangul_Compatibility_Jamo}', "");
Error('\p{Is_Blk=:=_Compat_JAMO}');
Error('\P{Is_Blk=:=_Compat_JAMO}');
Expect(1, 12687, '\p{Is_Blk:	compatjamo}', "");
Expect(0, 12687, '\p{^Is_Blk:	compatjamo}', "");
Expect(0, 12687, '\P{Is_Blk:	compatjamo}', "");
Expect(1, 12687, '\P{^Is_Blk:	compatjamo}', "");
Expect(0, 12688, '\p{Is_Blk:	compatjamo}', "");
Expect(1, 12688, '\p{^Is_Blk:	compatjamo}', "");
Expect(1, 12688, '\P{Is_Blk:	compatjamo}', "");
Expect(0, 12688, '\P{^Is_Blk:	compatjamo}', "");
Expect(1, 12687, '\p{Is_Blk=_Compat_jamo}', "");
Expect(0, 12687, '\p{^Is_Blk=_Compat_jamo}', "");
Expect(0, 12687, '\P{Is_Blk=_Compat_jamo}', "");
Expect(1, 12687, '\P{^Is_Blk=_Compat_jamo}', "");
Expect(0, 12688, '\p{Is_Blk=_Compat_jamo}', "");
Expect(1, 12688, '\p{^Is_Blk=_Compat_jamo}', "");
Expect(1, 12688, '\P{Is_Blk=_Compat_jamo}', "");
Expect(0, 12688, '\P{^Is_Blk=_Compat_jamo}', "");
Error('\p{Block=_CONTROL_Pictures:=}');
Error('\P{Block=_CONTROL_Pictures:=}');
Expect(1, 9279, '\p{Block=controlpictures}', "");
Expect(0, 9279, '\p{^Block=controlpictures}', "");
Expect(0, 9279, '\P{Block=controlpictures}', "");
Expect(1, 9279, '\P{^Block=controlpictures}', "");
Expect(0, 9280, '\p{Block=controlpictures}', "");
Expect(1, 9280, '\p{^Block=controlpictures}', "");
Expect(1, 9280, '\P{Block=controlpictures}', "");
Expect(0, 9280, '\P{^Block=controlpictures}', "");
Expect(1, 9279, '\p{Block=-control_PICTURES}', "");
Expect(0, 9279, '\p{^Block=-control_PICTURES}', "");
Expect(0, 9279, '\P{Block=-control_PICTURES}', "");
Expect(1, 9279, '\P{^Block=-control_PICTURES}', "");
Expect(0, 9280, '\p{Block=-control_PICTURES}', "");
Expect(1, 9280, '\p{^Block=-control_PICTURES}', "");
Expect(1, 9280, '\P{Block=-control_PICTURES}', "");
Expect(0, 9280, '\P{^Block=-control_PICTURES}', "");
Error('\p{Blk=  Control_PICTURES/a/}');
Error('\P{Blk=  Control_PICTURES/a/}');
Expect(1, 9279, '\p{Blk=controlpictures}', "");
Expect(0, 9279, '\p{^Blk=controlpictures}', "");
Expect(0, 9279, '\P{Blk=controlpictures}', "");
Expect(1, 9279, '\P{^Blk=controlpictures}', "");
Expect(0, 9280, '\p{Blk=controlpictures}', "");
Expect(1, 9280, '\p{^Blk=controlpictures}', "");
Expect(1, 9280, '\P{Blk=controlpictures}', "");
Expect(0, 9280, '\P{^Blk=controlpictures}', "");
Expect(1, 9279, '\p{Blk=  control_PICTURES}', "");
Expect(0, 9279, '\p{^Blk=  control_PICTURES}', "");
Expect(0, 9279, '\P{Blk=  control_PICTURES}', "");
Expect(1, 9279, '\P{^Blk=  control_PICTURES}', "");
Expect(0, 9280, '\p{Blk=  control_PICTURES}', "");
Expect(1, 9280, '\p{^Blk=  control_PICTURES}', "");
Expect(1, 9280, '\P{Blk=  control_PICTURES}', "");
Expect(0, 9280, '\P{^Blk=  control_PICTURES}', "");
Error('\p{Is_Block=-:=control_PICTURES}');
Error('\P{Is_Block=-:=control_PICTURES}');
Expect(1, 9279, '\p{Is_Block=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Block=controlpictures}', "");
Expect(0, 9279, '\P{Is_Block=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Block=controlpictures}', "");
Expect(0, 9280, '\p{Is_Block=controlpictures}', "");
Expect(1, 9280, '\p{^Is_Block=controlpictures}', "");
Expect(1, 9280, '\P{Is_Block=controlpictures}', "");
Expect(0, 9280, '\P{^Is_Block=controlpictures}', "");
Expect(1, 9279, '\p{Is_Block= -Control_Pictures}', "");
Expect(0, 9279, '\p{^Is_Block= -Control_Pictures}', "");
Expect(0, 9279, '\P{Is_Block= -Control_Pictures}', "");
Expect(1, 9279, '\P{^Is_Block= -Control_Pictures}', "");
Expect(0, 9280, '\p{Is_Block= -Control_Pictures}', "");
Expect(1, 9280, '\p{^Is_Block= -Control_Pictures}', "");
Expect(1, 9280, '\P{Is_Block= -Control_Pictures}', "");
Expect(0, 9280, '\P{^Is_Block= -Control_Pictures}', "");
Error('\p{Is_Blk=--control_Pictures/a/}');
Error('\P{Is_Blk=--control_Pictures/a/}');
Expect(1, 9279, '\p{Is_Blk=controlpictures}', "");
Expect(0, 9279, '\p{^Is_Blk=controlpictures}', "");
Expect(0, 9279, '\P{Is_Blk=controlpictures}', "");
Expect(1, 9279, '\P{^Is_Blk=controlpictures}', "");
Expect(0, 9280, '\p{Is_Blk=controlpictures}', "");
Expect(1, 9280, '\p{^Is_Blk=controlpictures}', "");
Expect(1, 9280, '\P{Is_Blk=controlpictures}', "");
Expect(0, 9280, '\P{^Is_Blk=controlpictures}', "");
Expect(1, 9279, '\p{Is_Blk=-Control_Pictures}', "");
Expect(0, 9279, '\p{^Is_Blk=-Control_Pictures}', "");
Expect(0, 9279, '\P{Is_Blk=-Control_Pictures}', "");
Expect(1, 9279, '\P{^Is_Blk=-Control_Pictures}', "");
Expect(0, 9280, '\p{Is_Blk=-Control_Pictures}', "");
Expect(1, 9280, '\p{^Is_Blk=-Control_Pictures}', "");
Expect(1, 9280, '\P{Is_Blk=-Control_Pictures}', "");
Expect(0, 9280, '\P{^Is_Blk=-Control_Pictures}', "");
Error('\p{Block=-_Coptic:=}');
Error('\P{Block=-_Coptic:=}');
Expect(1, 11519, '\p{Block:	coptic}', "");
Expect(0, 11519, '\p{^Block:	coptic}', "");
Expect(0, 11519, '\P{Block:	coptic}', "");
Expect(1, 11519, '\P{^Block:	coptic}', "");
Expect(0, 11520, '\p{Block:	coptic}', "");
Expect(1, 11520, '\p{^Block:	coptic}', "");
Expect(1, 11520, '\P{Block:	coptic}', "");
Expect(0, 11520, '\P{^Block:	coptic}', "");
Expect(1, 11519, '\p{Block=		coptic}', "");
Expect(0, 11519, '\p{^Block=		coptic}', "");
Expect(0, 11519, '\P{Block=		coptic}', "");
Expect(1, 11519, '\P{^Block=		coptic}', "");
Expect(0, 11520, '\p{Block=		coptic}', "");
Expect(1, 11520, '\p{^Block=		coptic}', "");
Expect(1, 11520, '\P{Block=		coptic}', "");
Expect(0, 11520, '\P{^Block=		coptic}', "");
Error('\p{Blk=:=-Coptic}');
Error('\P{Blk=:=-Coptic}');
Expect(1, 11519, '\p{Blk=coptic}', "");
Expect(0, 11519, '\p{^Blk=coptic}', "");
Expect(0, 11519, '\P{Blk=coptic}', "");
Expect(1, 11519, '\P{^Blk=coptic}', "");
Expect(0, 11520, '\p{Blk=coptic}', "");
Expect(1, 11520, '\p{^Blk=coptic}', "");
Expect(1, 11520, '\P{Blk=coptic}', "");
Expect(0, 11520, '\P{^Blk=coptic}', "");
Expect(1, 11519, '\p{Blk=-	coptic}', "");
Expect(0, 11519, '\p{^Blk=-	coptic}', "");
Expect(0, 11519, '\P{Blk=-	coptic}', "");
Expect(1, 11519, '\P{^Blk=-	coptic}', "");
Expect(0, 11520, '\p{Blk=-	coptic}', "");
Expect(1, 11520, '\p{^Blk=-	coptic}', "");
Expect(1, 11520, '\P{Blk=-	coptic}', "");
Expect(0, 11520, '\P{^Blk=-	coptic}', "");
Error('\p{Is_Block=	 coptic:=}');
Error('\P{Is_Block=	 coptic:=}');
Expect(1, 11519, '\p{Is_Block=coptic}', "");
Expect(0, 11519, '\p{^Is_Block=coptic}', "");
Expect(0, 11519, '\P{Is_Block=coptic}', "");
Expect(1, 11519, '\P{^Is_Block=coptic}', "");
Expect(0, 11520, '\p{Is_Block=coptic}', "");
Expect(1, 11520, '\p{^Is_Block=coptic}', "");
Expect(1, 11520, '\P{Is_Block=coptic}', "");
Expect(0, 11520, '\P{^Is_Block=coptic}', "");
Expect(1, 11519, '\p{Is_Block= coptic}', "");
Expect(0, 11519, '\p{^Is_Block= coptic}', "");
Expect(0, 11519, '\P{Is_Block= coptic}', "");
Expect(1, 11519, '\P{^Is_Block= coptic}', "");
Expect(0, 11520, '\p{Is_Block= coptic}', "");
Expect(1, 11520, '\p{^Is_Block= coptic}', "");
Expect(1, 11520, '\P{Is_Block= coptic}', "");
Expect(0, 11520, '\P{^Is_Block= coptic}', "");
Error('\p{Is_Blk= /a/COPTIC}');
Error('\P{Is_Blk= /a/COPTIC}');
Expect(1, 11519, '\p{Is_Blk=coptic}', "");
Expect(0, 11519, '\p{^Is_Blk=coptic}', "");
Expect(0, 11519, '\P{Is_Blk=coptic}', "");
Expect(1, 11519, '\P{^Is_Blk=coptic}', "");
Expect(0, 11520, '\p{Is_Blk=coptic}', "");
Expect(1, 11520, '\p{^Is_Blk=coptic}', "");
Expect(1, 11520, '\P{Is_Blk=coptic}', "");
Expect(0, 11520, '\P{^Is_Blk=coptic}', "");
Expect(1, 11519, '\p{Is_Blk=_	Coptic}', "");
Expect(0, 11519, '\p{^Is_Blk=_	Coptic}', "");
Expect(0, 11519, '\P{Is_Blk=_	Coptic}', "");
Expect(1, 11519, '\P{^Is_Blk=_	Coptic}', "");
Expect(0, 11520, '\p{Is_Blk=_	Coptic}', "");
Expect(1, 11520, '\p{^Is_Blk=_	Coptic}', "");
Expect(1, 11520, '\P{Is_Blk=_	Coptic}', "");
Expect(0, 11520, '\P{^Is_Blk=_	Coptic}', "");
Error('\p{Block:/a/ -COPTIC_EPACT_Numbers}');
Error('\P{Block:/a/ -COPTIC_EPACT_Numbers}');
Expect(1, 66303, '\p{Block=copticepactnumbers}', "");
Expect(0, 66303, '\p{^Block=copticepactnumbers}', "");
Expect(0, 66303, '\P{Block=copticepactnumbers}', "");
Expect(1, 66303, '\P{^Block=copticepactnumbers}', "");
Expect(0, 66304, '\p{Block=copticepactnumbers}', "");
Expect(1, 66304, '\p{^Block=copticepactnumbers}', "");
Expect(1, 66304, '\P{Block=copticepactnumbers}', "");
Expect(0, 66304, '\P{^Block=copticepactnumbers}', "");
Expect(1, 66303, '\p{Block=	-COPTIC_EPACT_numbers}', "");
Expect(0, 66303, '\p{^Block=	-COPTIC_EPACT_numbers}', "");
Expect(0, 66303, '\P{Block=	-COPTIC_EPACT_numbers}', "");
Expect(1, 66303, '\P{^Block=	-COPTIC_EPACT_numbers}', "");
Expect(0, 66304, '\p{Block=	-COPTIC_EPACT_numbers}', "");
Expect(1, 66304, '\p{^Block=	-COPTIC_EPACT_numbers}', "");
Expect(1, 66304, '\P{Block=	-COPTIC_EPACT_numbers}', "");
Expect(0, 66304, '\P{^Block=	-COPTIC_EPACT_numbers}', "");
Error('\p{Blk= :=Coptic_EPACT_Numbers}');
Error('\P{Blk= :=Coptic_EPACT_Numbers}');
Expect(1, 66303, '\p{Blk=copticepactnumbers}', "");
Expect(0, 66303, '\p{^Blk=copticepactnumbers}', "");
Expect(0, 66303, '\P{Blk=copticepactnumbers}', "");
Expect(1, 66303, '\P{^Blk=copticepactnumbers}', "");
Expect(0, 66304, '\p{Blk=copticepactnumbers}', "");
Expect(1, 66304, '\p{^Blk=copticepactnumbers}', "");
Expect(1, 66304, '\P{Blk=copticepactnumbers}', "");
Expect(0, 66304, '\P{^Blk=copticepactnumbers}', "");
Expect(1, 66303, '\p{Blk=-COPTIC_Epact_numbers}', "");
Expect(0, 66303, '\p{^Blk=-COPTIC_Epact_numbers}', "");
Expect(0, 66303, '\P{Blk=-COPTIC_Epact_numbers}', "");
Expect(1, 66303, '\P{^Blk=-COPTIC_Epact_numbers}', "");
Expect(0, 66304, '\p{Blk=-COPTIC_Epact_numbers}', "");
Expect(1, 66304, '\p{^Blk=-COPTIC_Epact_numbers}', "");
Expect(1, 66304, '\P{Blk=-COPTIC_Epact_numbers}', "");
Expect(0, 66304, '\P{^Blk=-COPTIC_Epact_numbers}', "");
Error('\p{Is_Block=/a/_	coptic_Epact_Numbers}');
Error('\P{Is_Block=/a/_	coptic_Epact_Numbers}');
Expect(1, 66303, '\p{Is_Block=copticepactnumbers}', "");
Expect(0, 66303, '\p{^Is_Block=copticepactnumbers}', "");
Expect(0, 66303, '\P{Is_Block=copticepactnumbers}', "");
Expect(1, 66303, '\P{^Is_Block=copticepactnumbers}', "");
Expect(0, 66304, '\p{Is_Block=copticepactnumbers}', "");
Expect(1, 66304, '\p{^Is_Block=copticepactnumbers}', "");
Expect(1, 66304, '\P{Is_Block=copticepactnumbers}', "");
Expect(0, 66304, '\P{^Is_Block=copticepactnumbers}', "");
Expect(1, 66303, '\p{Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(0, 66303, '\p{^Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(0, 66303, '\P{Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(1, 66303, '\P{^Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(0, 66304, '\p{Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(1, 66304, '\p{^Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(1, 66304, '\P{Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Expect(0, 66304, '\P{^Is_Block=_COPTIC_EPACT_NUMBERS}', "");
Error('\p{Is_Blk:   /a/_	Coptic_Epact_Numbers}');
Error('\P{Is_Blk:   /a/_	Coptic_Epact_Numbers}');
Expect(1, 66303, '\p{Is_Blk=copticepactnumbers}', "");
Expect(0, 66303, '\p{^Is_Blk=copticepactnumbers}', "");
Expect(0, 66303, '\P{Is_Blk=copticepactnumbers}', "");
Expect(1, 66303, '\P{^Is_Blk=copticepactnumbers}', "");
Expect(0, 66304, '\p{Is_Blk=copticepactnumbers}', "");
Expect(1, 66304, '\p{^Is_Blk=copticepactnumbers}', "");
Expect(1, 66304, '\P{Is_Blk=copticepactnumbers}', "");
Expect(0, 66304, '\P{^Is_Blk=copticepactnumbers}', "");
Expect(1, 66303, '\p{Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(0, 66303, '\p{^Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(0, 66303, '\P{Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(1, 66303, '\P{^Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(0, 66304, '\p{Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(1, 66304, '\p{^Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(1, 66304, '\P{Is_Blk=	 COPTIC_Epact_Numbers}', "");
Expect(0, 66304, '\P{^Is_Blk=	 COPTIC_Epact_Numbers}', "");
Error('\p{Block:	/a/ counting_ROD_Numerals}');
Error('\P{Block:	/a/ counting_ROD_Numerals}');
Expect(1, 119679, '\p{Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Block=countingrodnumerals}', "");
Expect(0, 119680, '\p{Block=countingrodnumerals}', "");
Expect(1, 119680, '\p{^Block=countingrodnumerals}', "");
Expect(1, 119680, '\P{Block=countingrodnumerals}', "");
Expect(0, 119680, '\P{^Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Block=- Counting_ROD_Numerals}', "");
Expect(0, 119679, '\p{^Block=- Counting_ROD_Numerals}', "");
Expect(0, 119679, '\P{Block=- Counting_ROD_Numerals}', "");
Expect(1, 119679, '\P{^Block=- Counting_ROD_Numerals}', "");
Expect(0, 119680, '\p{Block=- Counting_ROD_Numerals}', "");
Expect(1, 119680, '\p{^Block=- Counting_ROD_Numerals}', "");
Expect(1, 119680, '\P{Block=- Counting_ROD_Numerals}', "");
Expect(0, 119680, '\P{^Block=- Counting_ROD_Numerals}', "");
Error('\p{Blk=-_Counting_ROD/a/}');
Error('\P{Blk=-_Counting_ROD/a/}');
Expect(1, 119679, '\p{Blk=countingrod}', "");
Expect(0, 119679, '\p{^Blk=countingrod}', "");
Expect(0, 119679, '\P{Blk=countingrod}', "");
Expect(1, 119679, '\P{^Blk=countingrod}', "");
Expect(0, 119680, '\p{Blk=countingrod}', "");
Expect(1, 119680, '\p{^Blk=countingrod}', "");
Expect(1, 119680, '\P{Blk=countingrod}', "");
Expect(0, 119680, '\P{^Blk=countingrod}', "");
Expect(1, 119679, '\p{Blk=__Counting_ROD}', "");
Expect(0, 119679, '\p{^Blk=__Counting_ROD}', "");
Expect(0, 119679, '\P{Blk=__Counting_ROD}', "");
Expect(1, 119679, '\P{^Blk=__Counting_ROD}', "");
Expect(0, 119680, '\p{Blk=__Counting_ROD}', "");
Expect(1, 119680, '\p{^Blk=__Counting_ROD}', "");
Expect(1, 119680, '\P{Blk=__Counting_ROD}', "");
Expect(0, 119680, '\P{^Blk=__Counting_ROD}', "");
Error('\p{Is_Block= -Counting_Rod_numerals:=}');
Error('\P{Is_Block= -Counting_Rod_numerals:=}');
Expect(1, 119679, '\p{Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\p{^Is_Block=countingrodnumerals}', "");
Expect(0, 119679, '\P{Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\P{^Is_Block=countingrodnumerals}', "");
Expect(0, 119680, '\p{Is_Block=countingrodnumerals}', "");
Expect(1, 119680, '\p{^Is_Block=countingrodnumerals}', "");
Expect(1, 119680, '\P{Is_Block=countingrodnumerals}', "");
Expect(0, 119680, '\P{^Is_Block=countingrodnumerals}', "");
Expect(1, 119679, '\p{Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(0, 119679, '\p{^Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(0, 119679, '\P{Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(1, 119679, '\P{^Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(0, 119680, '\p{Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(1, 119680, '\p{^Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(1, 119680, '\P{Is_Block= 	Counting_rod_NUMERALS}', "");
Expect(0, 119680, '\P{^Is_Block= 	Counting_rod_NUMERALS}', "");
Error('\p{Is_Blk=:=-counting_Rod}');
Error('\P{Is_Blk=:=-counting_Rod}');
Expect(1, 119679, '\p{Is_Blk=countingrod}', "");
Expect(0, 119679, '\p{^Is_Blk=countingrod}', "");
Expect(0, 119679, '\P{Is_Blk=countingrod}', "");
Expect(1, 119679, '\P{^Is_Blk=countingrod}', "");
Expect(0, 119680, '\p{Is_Blk=countingrod}', "");
Expect(1, 119680, '\p{^Is_Blk=countingrod}', "");
Expect(1, 119680, '\P{Is_Blk=countingrod}', "");
Expect(0, 119680, '\P{^Is_Blk=countingrod}', "");
Expect(1, 119679, '\p{Is_Blk=_ Counting_Rod}', "");
Expect(0, 119679, '\p{^Is_Blk=_ Counting_Rod}', "");
Expect(0, 119679, '\P{Is_Blk=_ Counting_Rod}', "");
Expect(1, 119679, '\P{^Is_Blk=_ Counting_Rod}', "");
Expect(0, 119680, '\p{Is_Blk=_ Counting_Rod}', "");
Expect(1, 119680, '\p{^Is_Blk=_ Counting_Rod}', "");
Expect(1, 119680, '\P{Is_Blk=_ Counting_Rod}', "");
Expect(0, 119680, '\P{^Is_Blk=_ Counting_Rod}', "");
Error('\p{Block=--Cuneiform/a/}');
Error('\P{Block=--Cuneiform/a/}');
Expect(1, 74751, '\p{Block=cuneiform}', "");
Expect(0, 74751, '\p{^Block=cuneiform}', "");
Expect(0, 74751, '\P{Block=cuneiform}', "");
Expect(1, 74751, '\P{^Block=cuneiform}', "");
Expect(0, 74752, '\p{Block=cuneiform}', "");
Expect(1, 74752, '\p{^Block=cuneiform}', "");
Expect(1, 74752, '\P{Block=cuneiform}', "");
Expect(0, 74752, '\P{^Block=cuneiform}', "");
Expect(1, 74751, '\p{Block=-Cuneiform}', "");
Expect(0, 74751, '\p{^Block=-Cuneiform}', "");
Expect(0, 74751, '\P{Block=-Cuneiform}', "");
Expect(1, 74751, '\P{^Block=-Cuneiform}', "");
Expect(0, 74752, '\p{Block=-Cuneiform}', "");
Expect(1, 74752, '\p{^Block=-Cuneiform}', "");
Expect(1, 74752, '\P{Block=-Cuneiform}', "");
Expect(0, 74752, '\P{^Block=-Cuneiform}', "");
Error('\p{Blk:_:=Cuneiform}');
Error('\P{Blk:_:=Cuneiform}');
Expect(1, 74751, '\p{Blk:   cuneiform}', "");
Expect(0, 74751, '\p{^Blk:   cuneiform}', "");
Expect(0, 74751, '\P{Blk:   cuneiform}', "");
Expect(1, 74751, '\P{^Blk:   cuneiform}', "");
Expect(0, 74752, '\p{Blk:   cuneiform}', "");
Expect(1, 74752, '\p{^Blk:   cuneiform}', "");
Expect(1, 74752, '\P{Blk:   cuneiform}', "");
Expect(0, 74752, '\P{^Blk:   cuneiform}', "");
Expect(1, 74751, '\p{Blk=-Cuneiform}', "");
Expect(0, 74751, '\p{^Blk=-Cuneiform}', "");
Expect(0, 74751, '\P{Blk=-Cuneiform}', "");
Expect(1, 74751, '\P{^Blk=-Cuneiform}', "");
Expect(0, 74752, '\p{Blk=-Cuneiform}', "");
Expect(1, 74752, '\p{^Blk=-Cuneiform}', "");
Expect(1, 74752, '\P{Blk=-Cuneiform}', "");
Expect(0, 74752, '\P{^Blk=-Cuneiform}', "");
Error('\p{Is_Block: _cuneiform/a/}');
Error('\P{Is_Block: _cuneiform/a/}');
Expect(1, 74751, '\p{Is_Block=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Block=cuneiform}', "");
Expect(0, 74751, '\P{Is_Block=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Block=cuneiform}', "");
Expect(0, 74752, '\p{Is_Block=cuneiform}', "");
Expect(1, 74752, '\p{^Is_Block=cuneiform}', "");
Expect(1, 74752, '\P{Is_Block=cuneiform}', "");
Expect(0, 74752, '\P{^Is_Block=cuneiform}', "");
Expect(1, 74751, '\p{Is_Block=	-cuneiform}', "");
Expect(0, 74751, '\p{^Is_Block=	-cuneiform}', "");
Expect(0, 74751, '\P{Is_Block=	-cuneiform}', "");
Expect(1, 74751, '\P{^Is_Block=	-cuneiform}', "");
Expect(0, 74752, '\p{Is_Block=	-cuneiform}', "");
Expect(1, 74752, '\p{^Is_Block=	-cuneiform}', "");
Expect(1, 74752, '\P{Is_Block=	-cuneiform}', "");
Expect(0, 74752, '\P{^Is_Block=	-cuneiform}', "");
Error('\p{Is_Blk:	/a/ -Cuneiform}');
Error('\P{Is_Blk:	/a/ -Cuneiform}');
Expect(1, 74751, '\p{Is_Blk=cuneiform}', "");
Expect(0, 74751, '\p{^Is_Blk=cuneiform}', "");
Expect(0, 74751, '\P{Is_Blk=cuneiform}', "");
Expect(1, 74751, '\P{^Is_Blk=cuneiform}', "");
Expect(0, 74752, '\p{Is_Blk=cuneiform}', "");
Expect(1, 74752, '\p{^Is_Blk=cuneiform}', "");
Expect(1, 74752, '\P{Is_Blk=cuneiform}', "");
Expect(0, 74752, '\P{^Is_Blk=cuneiform}', "");
Expect(1, 74751, '\p{Is_Blk=CUNEIFORM}', "");
Expect(0, 74751, '\p{^Is_Blk=CUNEIFORM}', "");
Expect(0, 74751, '\P{Is_Blk=CUNEIFORM}', "");
Expect(1, 74751, '\P{^Is_Blk=CUNEIFORM}', "");
Expect(0, 74752, '\p{Is_Blk=CUNEIFORM}', "");
Expect(1, 74752, '\p{^Is_Blk=CUNEIFORM}', "");
Expect(1, 74752, '\P{Is_Blk=CUNEIFORM}', "");
Expect(0, 74752, '\P{^Is_Blk=CUNEIFORM}', "");
Error('\p{Block=-/a/Cuneiform_Numbers_And_punctuation}');
Error('\P{Block=-/a/Cuneiform_Numbers_And_punctuation}');
Expect(1, 74879, '\p{Block:cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Block:cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Block:cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Block:cuneiformnumbersandpunctuation}', "");
Expect(0, 74880, '\p{Block:cuneiformnumbersandpunctuation}', "");
Expect(1, 74880, '\p{^Block:cuneiformnumbersandpunctuation}', "");
Expect(1, 74880, '\P{Block:cuneiformnumbersandpunctuation}', "");
Expect(0, 74880, '\P{^Block:cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(0, 74879, '\p{^Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(0, 74879, '\P{Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(1, 74879, '\P{^Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(0, 74880, '\p{Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(1, 74880, '\p{^Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(1, 74880, '\P{Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Expect(0, 74880, '\P{^Block=_	CUNEIFORM_Numbers_AND_punctuation}', "");
Error('\p{Blk=:=--Cuneiform_NUMBERS}');
Error('\P{Blk=:=--Cuneiform_NUMBERS}');
Expect(1, 74879, '\p{Blk=cuneiformnumbers}', "");
Expect(0, 74879, '\p{^Blk=cuneiformnumbers}', "");
Expect(0, 74879, '\P{Blk=cuneiformnumbers}', "");
Expect(1, 74879, '\P{^Blk=cuneiformnumbers}', "");
Expect(0, 74880, '\p{Blk=cuneiformnumbers}', "");
Expect(1, 74880, '\p{^Blk=cuneiformnumbers}', "");
Expect(1, 74880, '\P{Blk=cuneiformnumbers}', "");
Expect(0, 74880, '\P{^Blk=cuneiformnumbers}', "");
Expect(1, 74879, '\p{Blk=-	Cuneiform_Numbers}', "");
Expect(0, 74879, '\p{^Blk=-	Cuneiform_Numbers}', "");
Expect(0, 74879, '\P{Blk=-	Cuneiform_Numbers}', "");
Expect(1, 74879, '\P{^Blk=-	Cuneiform_Numbers}', "");
Expect(0, 74880, '\p{Blk=-	Cuneiform_Numbers}', "");
Expect(1, 74880, '\p{^Blk=-	Cuneiform_Numbers}', "");
Expect(1, 74880, '\P{Blk=-	Cuneiform_Numbers}', "");
Expect(0, 74880, '\P{^Blk=-	Cuneiform_Numbers}', "");
Error('\p{Is_Block=/a/_-Cuneiform_NUMBERS_and_Punctuation}');
Error('\P{Is_Block=/a/_-Cuneiform_NUMBERS_and_Punctuation}');
Expect(1, 74879, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74879, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74880, '\p{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74880, '\p{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74880, '\P{Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(0, 74880, '\P{^Is_Block=cuneiformnumbersandpunctuation}', "");
Expect(1, 74879, '\p{Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(0, 74879, '\p{^Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(0, 74879, '\P{Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(1, 74879, '\P{^Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(0, 74880, '\p{Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(1, 74880, '\p{^Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(1, 74880, '\P{Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Expect(0, 74880, '\P{^Is_Block=-cuneiform_numbers_and_Punctuation}', "");
Error('\p{Is_Blk= :=cuneiform_Numbers}');
Error('\P{Is_Blk= :=cuneiform_Numbers}');
Expect(1, 74879, '\p{Is_Blk=cuneiformnumbers}', "");
Expect(0, 74879, '\p{^Is_Blk=cuneiformnumbers}', "");
Expect(0, 74879, '\P{Is_Blk=cuneiformnumbers}', "");
Expect(1, 74879, '\P{^Is_Blk=cuneiformnumbers}', "");
Expect(0, 74880, '\p{Is_Blk=cuneiformnumbers}', "");
Expect(1, 74880, '\p{^Is_Blk=cuneiformnumbers}', "");
Expect(1, 74880, '\P{Is_Blk=cuneiformnumbers}', "");
Expect(0, 74880, '\P{^Is_Blk=cuneiformnumbers}', "");
Expect(1, 74879, '\p{Is_Blk=	-Cuneiform_Numbers}', "");
Expect(0, 74879, '\p{^Is_Blk=	-Cuneiform_Numbers}', "");
Expect(0, 74879, '\P{Is_Blk=	-Cuneiform_Numbers}', "");
Expect(1, 74879, '\P{^Is_Blk=	-Cuneiform_Numbers}', "");
Expect(0, 74880, '\p{Is_Blk=	-Cuneiform_Numbers}', "");
Expect(1, 74880, '\p{^Is_Blk=	-Cuneiform_Numbers}', "");
Expect(1, 74880, '\P{Is_Blk=	-Cuneiform_Numbers}', "");
Expect(0, 74880, '\P{^Is_Blk=	-Cuneiform_Numbers}', "");
Error('\p{Block=-CURRENCY_symbols/a/}');
Error('\P{Block=-CURRENCY_symbols/a/}');
Expect(1, 8399, '\p{Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Block=currencysymbols}', "");
Expect(0, 8399, '\P{Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Block=currencysymbols}', "");
Expect(0, 8400, '\p{Block=currencysymbols}', "");
Expect(1, 8400, '\p{^Block=currencysymbols}', "");
Expect(1, 8400, '\P{Block=currencysymbols}', "");
Expect(0, 8400, '\P{^Block=currencysymbols}', "");
Expect(1, 8399, '\p{Block=		currency_SYMBOLS}', "");
Expect(0, 8399, '\p{^Block=		currency_SYMBOLS}', "");
Expect(0, 8399, '\P{Block=		currency_SYMBOLS}', "");
Expect(1, 8399, '\P{^Block=		currency_SYMBOLS}', "");
Expect(0, 8400, '\p{Block=		currency_SYMBOLS}', "");
Expect(1, 8400, '\p{^Block=		currency_SYMBOLS}', "");
Expect(1, 8400, '\P{Block=		currency_SYMBOLS}', "");
Expect(0, 8400, '\P{^Block=		currency_SYMBOLS}', "");
Error('\p{Blk=:=-_Currency_Symbols}');
Error('\P{Blk=:=-_Currency_Symbols}');
Expect(1, 8399, '\p{Blk=currencysymbols}', "");
Expect(0, 8399, '\p{^Blk=currencysymbols}', "");
Expect(0, 8399, '\P{Blk=currencysymbols}', "");
Expect(1, 8399, '\P{^Blk=currencysymbols}', "");
Expect(0, 8400, '\p{Blk=currencysymbols}', "");
Expect(1, 8400, '\p{^Blk=currencysymbols}', "");
Expect(1, 8400, '\P{Blk=currencysymbols}', "");
Expect(0, 8400, '\P{^Blk=currencysymbols}', "");
Expect(1, 8399, '\p{Blk=Currency_Symbols}', "");
Expect(0, 8399, '\p{^Blk=Currency_Symbols}', "");
Expect(0, 8399, '\P{Blk=Currency_Symbols}', "");
Expect(1, 8399, '\P{^Blk=Currency_Symbols}', "");
Expect(0, 8400, '\p{Blk=Currency_Symbols}', "");
Expect(1, 8400, '\p{^Blk=Currency_Symbols}', "");
Expect(1, 8400, '\P{Blk=Currency_Symbols}', "");
Expect(0, 8400, '\P{^Blk=Currency_Symbols}', "");
Error('\p{Is_Block=/a/--CURRENCY_Symbols}');
Error('\P{Is_Block=/a/--CURRENCY_Symbols}');
Expect(1, 8399, '\p{Is_Block=currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Block=currencysymbols}', "");
Expect(0, 8399, '\P{Is_Block=currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Block=currencysymbols}', "");
Expect(0, 8400, '\p{Is_Block=currencysymbols}', "");
Expect(1, 8400, '\p{^Is_Block=currencysymbols}', "");
Expect(1, 8400, '\P{Is_Block=currencysymbols}', "");
Expect(0, 8400, '\P{^Is_Block=currencysymbols}', "");
Expect(1, 8399, '\p{Is_Block=_	Currency_Symbols}', "");
Expect(0, 8399, '\p{^Is_Block=_	Currency_Symbols}', "");
Expect(0, 8399, '\P{Is_Block=_	Currency_Symbols}', "");
Expect(1, 8399, '\P{^Is_Block=_	Currency_Symbols}', "");
Expect(0, 8400, '\p{Is_Block=_	Currency_Symbols}', "");
Expect(1, 8400, '\p{^Is_Block=_	Currency_Symbols}', "");
Expect(1, 8400, '\P{Is_Block=_	Currency_Symbols}', "");
Expect(0, 8400, '\P{^Is_Block=_	Currency_Symbols}', "");
Error('\p{Is_Blk=/a/-Currency_SYMBOLS}');
Error('\P{Is_Blk=/a/-Currency_SYMBOLS}');
Expect(1, 8399, '\p{Is_Blk=currencysymbols}', "");
Expect(0, 8399, '\p{^Is_Blk=currencysymbols}', "");
Expect(0, 8399, '\P{Is_Blk=currencysymbols}', "");
Expect(1, 8399, '\P{^Is_Blk=currencysymbols}', "");
Expect(0, 8400, '\p{Is_Blk=currencysymbols}', "");
Expect(1, 8400, '\p{^Is_Blk=currencysymbols}', "");
Expect(1, 8400, '\P{Is_Blk=currencysymbols}', "");
Expect(0, 8400, '\P{^Is_Blk=currencysymbols}', "");
Expect(1, 8399, '\p{Is_Blk=-_Currency_SYMBOLS}', "");
Expect(0, 8399, '\p{^Is_Blk=-_Currency_SYMBOLS}', "");
Expect(0, 8399, '\P{Is_Blk=-_Currency_SYMBOLS}', "");
Expect(1, 8399, '\P{^Is_Blk=-_Currency_SYMBOLS}', "");
Expect(0, 8400, '\p{Is_Blk=-_Currency_SYMBOLS}', "");
Expect(1, 8400, '\p{^Is_Blk=-_Currency_SYMBOLS}', "");
Expect(1, 8400, '\P{Is_Blk=-_Currency_SYMBOLS}', "");
Expect(0, 8400, '\P{^Is_Blk=-_Currency_SYMBOLS}', "");
Error('\p{Block= _Cypriot_Syllabary:=}');
Error('\P{Block= _Cypriot_Syllabary:=}');
Expect(1, 67647, '\p{Block: cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Block: cypriotsyllabary}', "");
Expect(0, 67647, '\P{Block: cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Block: cypriotsyllabary}', "");
Expect(0, 67648, '\p{Block: cypriotsyllabary}', "");
Expect(1, 67648, '\p{^Block: cypriotsyllabary}', "");
Expect(1, 67648, '\P{Block: cypriotsyllabary}', "");
Expect(0, 67648, '\P{^Block: cypriotsyllabary}', "");
Expect(1, 67647, '\p{Block= CYPRIOT_Syllabary}', "");
Expect(0, 67647, '\p{^Block= CYPRIOT_Syllabary}', "");
Expect(0, 67647, '\P{Block= CYPRIOT_Syllabary}', "");
Expect(1, 67647, '\P{^Block= CYPRIOT_Syllabary}', "");
Expect(0, 67648, '\p{Block= CYPRIOT_Syllabary}', "");
Expect(1, 67648, '\p{^Block= CYPRIOT_Syllabary}', "");
Expect(1, 67648, '\P{Block= CYPRIOT_Syllabary}', "");
Expect(0, 67648, '\P{^Block= CYPRIOT_Syllabary}', "");
Error('\p{Blk:/a/ CYPRIOT_syllabary}');
Error('\P{Blk:/a/ CYPRIOT_syllabary}');
Expect(1, 67647, '\p{Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Blk=cypriotsyllabary}', "");
Expect(0, 67648, '\p{Blk=cypriotsyllabary}', "");
Expect(1, 67648, '\p{^Blk=cypriotsyllabary}', "");
Expect(1, 67648, '\P{Blk=cypriotsyllabary}', "");
Expect(0, 67648, '\P{^Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Blk=- cypriot_SYLLABARY}', "");
Expect(0, 67647, '\p{^Blk=- cypriot_SYLLABARY}', "");
Expect(0, 67647, '\P{Blk=- cypriot_SYLLABARY}', "");
Expect(1, 67647, '\P{^Blk=- cypriot_SYLLABARY}', "");
Expect(0, 67648, '\p{Blk=- cypriot_SYLLABARY}', "");
Expect(1, 67648, '\p{^Blk=- cypriot_SYLLABARY}', "");
Expect(1, 67648, '\P{Blk=- cypriot_SYLLABARY}', "");
Expect(0, 67648, '\P{^Blk=- cypriot_SYLLABARY}', "");
Error('\p{Is_Block=/a/cypriot_syllabary}');
Error('\P{Is_Block=/a/cypriot_syllabary}');
Expect(1, 67647, '\p{Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(0, 67648, '\p{Is_Block=cypriotsyllabary}', "");
Expect(1, 67648, '\p{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67648, '\P{Is_Block=cypriotsyllabary}', "");
Expect(0, 67648, '\P{^Is_Block=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(0, 67647, '\p{^Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(0, 67647, '\P{Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(1, 67647, '\P{^Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(0, 67648, '\p{Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(1, 67648, '\p{^Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(1, 67648, '\P{Is_Block=_	Cypriot_SYLLABARY}', "");
Expect(0, 67648, '\P{^Is_Block=_	Cypriot_SYLLABARY}', "");
Error('\p{Is_Blk=	:=CYPRIOT_SYLLABARY}');
Error('\P{Is_Blk=	:=CYPRIOT_SYLLABARY}');
Expect(1, 67647, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67647, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(0, 67648, '\p{Is_Blk=cypriotsyllabary}', "");
Expect(1, 67648, '\p{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67648, '\P{Is_Blk=cypriotsyllabary}', "");
Expect(0, 67648, '\P{^Is_Blk=cypriotsyllabary}', "");
Expect(1, 67647, '\p{Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(0, 67647, '\p{^Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(0, 67647, '\P{Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(1, 67647, '\P{^Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(0, 67648, '\p{Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(1, 67648, '\p{^Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(1, 67648, '\P{Is_Blk=  CYPRIOT_Syllabary}', "");
Expect(0, 67648, '\P{^Is_Blk=  CYPRIOT_Syllabary}', "");
Error('\p{Block=:=_	Cyrillic}');
Error('\P{Block=:=_	Cyrillic}');
Expect(1, 1279, '\p{Block=cyrillic}', "");
Expect(0, 1279, '\p{^Block=cyrillic}', "");
Expect(0, 1279, '\P{Block=cyrillic}', "");
Expect(1, 1279, '\P{^Block=cyrillic}', "");
Expect(0, 1280, '\p{Block=cyrillic}', "");
Expect(1, 1280, '\p{^Block=cyrillic}', "");
Expect(1, 1280, '\P{Block=cyrillic}', "");
Expect(0, 1280, '\P{^Block=cyrillic}', "");
Expect(1, 1279, '\p{Block=__Cyrillic}', "");
Expect(0, 1279, '\p{^Block=__Cyrillic}', "");
Expect(0, 1279, '\P{Block=__Cyrillic}', "");
Expect(1, 1279, '\P{^Block=__Cyrillic}', "");
Expect(0, 1280, '\p{Block=__Cyrillic}', "");
Expect(1, 1280, '\p{^Block=__Cyrillic}', "");
Expect(1, 1280, '\P{Block=__Cyrillic}', "");
Expect(0, 1280, '\P{^Block=__Cyrillic}', "");
Error('\p{Blk: -CYRILLIC:=}');
Error('\P{Blk: -CYRILLIC:=}');
Expect(1, 1279, '\p{Blk=cyrillic}', "");
Expect(0, 1279, '\p{^Blk=cyrillic}', "");
Expect(0, 1279, '\P{Blk=cyrillic}', "");
Expect(1, 1279, '\P{^Blk=cyrillic}', "");
Expect(0, 1280, '\p{Blk=cyrillic}', "");
Expect(1, 1280, '\p{^Blk=cyrillic}', "");
Expect(1, 1280, '\P{Blk=cyrillic}', "");
Expect(0, 1280, '\P{^Blk=cyrillic}', "");
Expect(1, 1279, '\p{Blk= 	CYRILLIC}', "");
Expect(0, 1279, '\p{^Blk= 	CYRILLIC}', "");
Expect(0, 1279, '\P{Blk= 	CYRILLIC}', "");
Expect(1, 1279, '\P{^Blk= 	CYRILLIC}', "");
Expect(0, 1280, '\p{Blk= 	CYRILLIC}', "");
Expect(1, 1280, '\p{^Blk= 	CYRILLIC}', "");
Expect(1, 1280, '\P{Blk= 	CYRILLIC}', "");
Expect(0, 1280, '\P{^Blk= 	CYRILLIC}', "");
Error('\p{Is_Block= :=Cyrillic}');
Error('\P{Is_Block= :=Cyrillic}');
Expect(1, 1279, '\p{Is_Block: cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block: cyrillic}', "");
Expect(0, 1279, '\P{Is_Block: cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block: cyrillic}', "");
Expect(0, 1280, '\p{Is_Block: cyrillic}', "");
Expect(1, 1280, '\p{^Is_Block: cyrillic}', "");
Expect(1, 1280, '\P{Is_Block: cyrillic}', "");
Expect(0, 1280, '\P{^Is_Block: cyrillic}', "");
Expect(1, 1279, '\p{Is_Block=--Cyrillic}', "");
Expect(0, 1279, '\p{^Is_Block=--Cyrillic}', "");
Expect(0, 1279, '\P{Is_Block=--Cyrillic}', "");
Expect(1, 1279, '\P{^Is_Block=--Cyrillic}', "");
Expect(0, 1280, '\p{Is_Block=--Cyrillic}', "");
Expect(1, 1280, '\p{^Is_Block=--Cyrillic}', "");
Expect(1, 1280, '\P{Is_Block=--Cyrillic}', "");
Expect(0, 1280, '\P{^Is_Block=--Cyrillic}', "");
Error('\p{Is_Blk= /a/CYRILLIC}');
Error('\P{Is_Blk= /a/CYRILLIC}');
Expect(1, 1279, '\p{Is_Blk:cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk:cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk:cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk:cyrillic}', "");
Expect(0, 1280, '\p{Is_Blk:cyrillic}', "");
Expect(1, 1280, '\p{^Is_Blk:cyrillic}', "");
Expect(1, 1280, '\P{Is_Blk:cyrillic}', "");
Expect(0, 1280, '\P{^Is_Blk:cyrillic}', "");
Expect(1, 1279, '\p{Is_Blk=-Cyrillic}', "");
Expect(0, 1279, '\p{^Is_Blk=-Cyrillic}', "");
Expect(0, 1279, '\P{Is_Blk=-Cyrillic}', "");
Expect(1, 1279, '\P{^Is_Blk=-Cyrillic}', "");
Expect(0, 1280, '\p{Is_Blk=-Cyrillic}', "");
Expect(1, 1280, '\p{^Is_Blk=-Cyrillic}', "");
Expect(1, 1280, '\P{Is_Blk=-Cyrillic}', "");
Expect(0, 1280, '\P{^Is_Blk=-Cyrillic}', "");
Error('\p{Block=_	Cyrillic_EXTENDED_A/a/}');
Error('\P{Block=_	Cyrillic_EXTENDED_A/a/}');
Expect(1, 11775, '\p{Block:   cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Block:   cyrillicextendeda}', "");
Expect(0, 11775, '\P{Block:   cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Block:   cyrillicextendeda}', "");
Expect(0, 11776, '\p{Block:   cyrillicextendeda}', "");
Expect(1, 11776, '\p{^Block:   cyrillicextendeda}', "");
Expect(1, 11776, '\P{Block:   cyrillicextendeda}', "");
Expect(0, 11776, '\P{^Block:   cyrillicextendeda}', "");
Expect(1, 11775, '\p{Block=_CYRILLIC_Extended_a}', "");
Expect(0, 11775, '\p{^Block=_CYRILLIC_Extended_a}', "");
Expect(0, 11775, '\P{Block=_CYRILLIC_Extended_a}', "");
Expect(1, 11775, '\P{^Block=_CYRILLIC_Extended_a}', "");
Expect(0, 11776, '\p{Block=_CYRILLIC_Extended_a}', "");
Expect(1, 11776, '\p{^Block=_CYRILLIC_Extended_a}', "");
Expect(1, 11776, '\P{Block=_CYRILLIC_Extended_a}', "");
Expect(0, 11776, '\P{^Block=_CYRILLIC_Extended_a}', "");
Error('\p{Blk=/a/	CYRILLIC_Ext_A}');
Error('\P{Blk=/a/	CYRILLIC_Ext_A}');
Expect(1, 11775, '\p{Blk=cyrillicexta}', "");
Expect(0, 11775, '\p{^Blk=cyrillicexta}', "");
Expect(0, 11775, '\P{Blk=cyrillicexta}', "");
Expect(1, 11775, '\P{^Blk=cyrillicexta}', "");
Expect(0, 11776, '\p{Blk=cyrillicexta}', "");
Expect(1, 11776, '\p{^Blk=cyrillicexta}', "");
Expect(1, 11776, '\P{Blk=cyrillicexta}', "");
Expect(0, 11776, '\P{^Blk=cyrillicexta}', "");
Expect(1, 11775, '\p{Blk=-	CYRILLIC_Ext_A}', "");
Expect(0, 11775, '\p{^Blk=-	CYRILLIC_Ext_A}', "");
Expect(0, 11775, '\P{Blk=-	CYRILLIC_Ext_A}', "");
Expect(1, 11775, '\P{^Blk=-	CYRILLIC_Ext_A}', "");
Expect(0, 11776, '\p{Blk=-	CYRILLIC_Ext_A}', "");
Expect(1, 11776, '\p{^Blk=-	CYRILLIC_Ext_A}', "");
Expect(1, 11776, '\P{Blk=-	CYRILLIC_Ext_A}', "");
Expect(0, 11776, '\P{^Blk=-	CYRILLIC_Ext_A}', "");
Error('\p{Is_Block=/a/ Cyrillic_EXTENDED_A}');
Error('\P{Is_Block=/a/ Cyrillic_EXTENDED_A}');
Expect(1, 11775, '\p{Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11775, '\P{Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(0, 11776, '\p{Is_Block=cyrillicextendeda}', "");
Expect(1, 11776, '\p{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11776, '\P{Is_Block=cyrillicextendeda}', "");
Expect(0, 11776, '\P{^Is_Block=cyrillicextendeda}', "");
Expect(1, 11775, '\p{Is_Block= -CYRILLIC_extended_A}', "");
Expect(0, 11775, '\p{^Is_Block= -CYRILLIC_extended_A}', "");
Expect(0, 11775, '\P{Is_Block= -CYRILLIC_extended_A}', "");
Expect(1, 11775, '\P{^Is_Block= -CYRILLIC_extended_A}', "");
Expect(0, 11776, '\p{Is_Block= -CYRILLIC_extended_A}', "");
Expect(1, 11776, '\p{^Is_Block= -CYRILLIC_extended_A}', "");
Expect(1, 11776, '\P{Is_Block= -CYRILLIC_extended_A}', "");
Expect(0, 11776, '\P{^Is_Block= -CYRILLIC_extended_A}', "");
Error('\p{Is_Blk=__cyrillic_ext_A/a/}');
Error('\P{Is_Blk=__cyrillic_ext_A/a/}');
Expect(1, 11775, '\p{Is_Blk=cyrillicexta}', "");
Expect(0, 11775, '\p{^Is_Blk=cyrillicexta}', "");
Expect(0, 11775, '\P{Is_Blk=cyrillicexta}', "");
Expect(1, 11775, '\P{^Is_Blk=cyrillicexta}', "");
Expect(0, 11776, '\p{Is_Blk=cyrillicexta}', "");
Expect(1, 11776, '\p{^Is_Blk=cyrillicexta}', "");
Expect(1, 11776, '\P{Is_Blk=cyrillicexta}', "");
Expect(0, 11776, '\P{^Is_Blk=cyrillicexta}', "");
Expect(1, 11775, '\p{Is_Blk: _Cyrillic_EXT_A}', "");
Expect(0, 11775, '\p{^Is_Blk: _Cyrillic_EXT_A}', "");
Expect(0, 11775, '\P{Is_Blk: _Cyrillic_EXT_A}', "");
Expect(1, 11775, '\P{^Is_Blk: _Cyrillic_EXT_A}', "");
Expect(0, 11776, '\p{Is_Blk: _Cyrillic_EXT_A}', "");
Expect(1, 11776, '\p{^Is_Blk: _Cyrillic_EXT_A}', "");
Expect(1, 11776, '\P{Is_Blk: _Cyrillic_EXT_A}', "");
Expect(0, 11776, '\P{^Is_Blk: _Cyrillic_EXT_A}', "");
Error('\p{Block= /a/Cyrillic_Extended_B}');
Error('\P{Block= /a/Cyrillic_Extended_B}');
Expect(1, 42655, '\p{Block=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Block=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Block=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Block=cyrillicextendedb}', "");
Expect(0, 42656, '\p{Block=cyrillicextendedb}', "");
Expect(1, 42656, '\p{^Block=cyrillicextendedb}', "");
Expect(1, 42656, '\P{Block=cyrillicextendedb}', "");
Expect(0, 42656, '\P{^Block=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Block=	 CYRILLIC_Extended_B}', "");
Expect(0, 42655, '\p{^Block=	 CYRILLIC_Extended_B}', "");
Expect(0, 42655, '\P{Block=	 CYRILLIC_Extended_B}', "");
Expect(1, 42655, '\P{^Block=	 CYRILLIC_Extended_B}', "");
Expect(0, 42656, '\p{Block=	 CYRILLIC_Extended_B}', "");
Expect(1, 42656, '\p{^Block=	 CYRILLIC_Extended_B}', "");
Expect(1, 42656, '\P{Block=	 CYRILLIC_Extended_B}', "");
Expect(0, 42656, '\P{^Block=	 CYRILLIC_Extended_B}', "");
Error('\p{Blk=__Cyrillic_EXT_B:=}');
Error('\P{Blk=__Cyrillic_EXT_B:=}');
Expect(1, 42655, '\p{Blk=cyrillicextb}', "");
Expect(0, 42655, '\p{^Blk=cyrillicextb}', "");
Expect(0, 42655, '\P{Blk=cyrillicextb}', "");
Expect(1, 42655, '\P{^Blk=cyrillicextb}', "");
Expect(0, 42656, '\p{Blk=cyrillicextb}', "");
Expect(1, 42656, '\p{^Blk=cyrillicextb}', "");
Expect(1, 42656, '\P{Blk=cyrillicextb}', "");
Expect(0, 42656, '\P{^Blk=cyrillicextb}', "");
Expect(1, 42655, '\p{Blk= CYRILLIC_ext_B}', "");
Expect(0, 42655, '\p{^Blk= CYRILLIC_ext_B}', "");
Expect(0, 42655, '\P{Blk= CYRILLIC_ext_B}', "");
Expect(1, 42655, '\P{^Blk= CYRILLIC_ext_B}', "");
Expect(0, 42656, '\p{Blk= CYRILLIC_ext_B}', "");
Expect(1, 42656, '\p{^Blk= CYRILLIC_ext_B}', "");
Expect(1, 42656, '\P{Blk= CYRILLIC_ext_B}', "");
Expect(0, 42656, '\P{^Blk= CYRILLIC_ext_B}', "");
Error('\p{Is_Block=:=	Cyrillic_EXTENDED_b}');
Error('\P{Is_Block=:=	Cyrillic_EXTENDED_b}');
Expect(1, 42655, '\p{Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42655, '\P{Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(0, 42656, '\p{Is_Block=cyrillicextendedb}', "");
Expect(1, 42656, '\p{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42656, '\P{Is_Block=cyrillicextendedb}', "");
Expect(0, 42656, '\P{^Is_Block=cyrillicextendedb}', "");
Expect(1, 42655, '\p{Is_Block:		_cyrillic_Extended_B}', "");
Expect(0, 42655, '\p{^Is_Block:		_cyrillic_Extended_B}', "");
Expect(0, 42655, '\P{Is_Block:		_cyrillic_Extended_B}', "");
Expect(1, 42655, '\P{^Is_Block:		_cyrillic_Extended_B}', "");
Expect(0, 42656, '\p{Is_Block:		_cyrillic_Extended_B}', "");
Expect(1, 42656, '\p{^Is_Block:		_cyrillic_Extended_B}', "");
Expect(1, 42656, '\P{Is_Block:		_cyrillic_Extended_B}', "");
Expect(0, 42656, '\P{^Is_Block:		_cyrillic_Extended_B}', "");
Error('\p{Is_Blk:  /a/Cyrillic_ext_B}');
Error('\P{Is_Blk:  /a/Cyrillic_ext_B}');
Expect(1, 42655, '\p{Is_Blk=cyrillicextb}', "");
Expect(0, 42655, '\p{^Is_Blk=cyrillicextb}', "");
Expect(0, 42655, '\P{Is_Blk=cyrillicextb}', "");
Expect(1, 42655, '\P{^Is_Blk=cyrillicextb}', "");
Expect(0, 42656, '\p{Is_Blk=cyrillicextb}', "");
Expect(1, 42656, '\p{^Is_Blk=cyrillicextb}', "");
Expect(1, 42656, '\P{Is_Blk=cyrillicextb}', "");
Expect(0, 42656, '\P{^Is_Blk=cyrillicextb}', "");
Expect(1, 42655, '\p{Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(0, 42655, '\p{^Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(0, 42655, '\P{Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(1, 42655, '\P{^Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(0, 42656, '\p{Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(1, 42656, '\p{^Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(1, 42656, '\P{Is_Blk=_-Cyrillic_Ext_B}', "");
Expect(0, 42656, '\P{^Is_Blk=_-Cyrillic_Ext_B}', "");
Error('\p{Block=-Cyrillic_SUPPLEMENT/a/}');
Error('\P{Block=-Cyrillic_SUPPLEMENT/a/}');
Expect(1, 1327, '\p{Block=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Block=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Block=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Block=cyrillicsupplement}', "");
Expect(0, 1328, '\p{Block=cyrillicsupplement}', "");
Expect(1, 1328, '\p{^Block=cyrillicsupplement}', "");
Expect(1, 1328, '\P{Block=cyrillicsupplement}', "");
Expect(0, 1328, '\P{^Block=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Block=	Cyrillic_supplement}', "");
Expect(0, 1327, '\p{^Block=	Cyrillic_supplement}', "");
Expect(0, 1327, '\P{Block=	Cyrillic_supplement}', "");
Expect(1, 1327, '\P{^Block=	Cyrillic_supplement}', "");
Expect(0, 1328, '\p{Block=	Cyrillic_supplement}', "");
Expect(1, 1328, '\p{^Block=	Cyrillic_supplement}', "");
Expect(1, 1328, '\P{Block=	Cyrillic_supplement}', "");
Expect(0, 1328, '\P{^Block=	Cyrillic_supplement}', "");
Error('\p{Blk= cyrillic_Sup:=}');
Error('\P{Blk= cyrillic_Sup:=}');
Expect(1, 1327, '\p{Blk=cyrillicsup}', "");
Expect(0, 1327, '\p{^Blk=cyrillicsup}', "");
Expect(0, 1327, '\P{Blk=cyrillicsup}', "");
Expect(1, 1327, '\P{^Blk=cyrillicsup}', "");
Expect(0, 1328, '\p{Blk=cyrillicsup}', "");
Expect(1, 1328, '\p{^Blk=cyrillicsup}', "");
Expect(1, 1328, '\P{Blk=cyrillicsup}', "");
Expect(0, 1328, '\P{^Blk=cyrillicsup}', "");
Expect(1, 1327, '\p{Blk=_-CYRILLIC_sup}', "");
Expect(0, 1327, '\p{^Blk=_-CYRILLIC_sup}', "");
Expect(0, 1327, '\P{Blk=_-CYRILLIC_sup}', "");
Expect(1, 1327, '\P{^Blk=_-CYRILLIC_sup}', "");
Expect(0, 1328, '\p{Blk=_-CYRILLIC_sup}', "");
Expect(1, 1328, '\p{^Blk=_-CYRILLIC_sup}', "");
Expect(1, 1328, '\P{Blk=_-CYRILLIC_sup}', "");
Expect(0, 1328, '\P{^Blk=_-CYRILLIC_sup}', "");
Error('\p{Is_Block=/a/ _cyrillic_Supplementary}');
Error('\P{Is_Block=/a/ _cyrillic_Supplementary}');
Expect(1, 1327, '\p{Is_Block=cyrillicsupplementary}', "");
Expect(0, 1327, '\p{^Is_Block=cyrillicsupplementary}', "");
Expect(0, 1327, '\P{Is_Block=cyrillicsupplementary}', "");
Expect(1, 1327, '\P{^Is_Block=cyrillicsupplementary}', "");
Expect(0, 1328, '\p{Is_Block=cyrillicsupplementary}', "");
Expect(1, 1328, '\p{^Is_Block=cyrillicsupplementary}', "");
Expect(1, 1328, '\P{Is_Block=cyrillicsupplementary}', "");
Expect(0, 1328, '\P{^Is_Block=cyrillicsupplementary}', "");
Expect(1, 1327, '\p{Is_Block=	Cyrillic_Supplementary}', "");
Expect(0, 1327, '\p{^Is_Block=	Cyrillic_Supplementary}', "");
Expect(0, 1327, '\P{Is_Block=	Cyrillic_Supplementary}', "");
Expect(1, 1327, '\P{^Is_Block=	Cyrillic_Supplementary}', "");
Expect(0, 1328, '\p{Is_Block=	Cyrillic_Supplementary}', "");
Expect(1, 1328, '\p{^Is_Block=	Cyrillic_Supplementary}', "");
Expect(1, 1328, '\P{Is_Block=	Cyrillic_Supplementary}', "");
Expect(0, 1328, '\P{^Is_Block=	Cyrillic_Supplementary}', "");
Error('\p{Is_Blk=-:=Cyrillic_SUPPLEMENT}');
Error('\P{Is_Blk=-:=Cyrillic_SUPPLEMENT}');
Expect(1, 1327, '\p{Is_Blk=cyrillicsupplement}', "");
Expect(0, 1327, '\p{^Is_Blk=cyrillicsupplement}', "");
Expect(0, 1327, '\P{Is_Blk=cyrillicsupplement}', "");
Expect(1, 1327, '\P{^Is_Blk=cyrillicsupplement}', "");
Expect(0, 1328, '\p{Is_Blk=cyrillicsupplement}', "");
Expect(1, 1328, '\p{^Is_Blk=cyrillicsupplement}', "");
Expect(1, 1328, '\P{Is_Blk=cyrillicsupplement}', "");
Expect(0, 1328, '\P{^Is_Blk=cyrillicsupplement}', "");
Expect(1, 1327, '\p{Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(0, 1327, '\p{^Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(0, 1327, '\P{Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(1, 1327, '\P{^Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(0, 1328, '\p{Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(1, 1328, '\p{^Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(1, 1328, '\P{Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Expect(0, 1328, '\P{^Is_Blk=_CYRILLIC_SUPPLEMENT}', "");
Error('\p{Block=:=	deseret}');
Error('\P{Block=:=	deseret}');
Expect(1, 66639, '\p{Block=deseret}', "");
Expect(0, 66639, '\p{^Block=deseret}', "");
Expect(0, 66639, '\P{Block=deseret}', "");
Expect(1, 66639, '\P{^Block=deseret}', "");
Expect(0, 66640, '\p{Block=deseret}', "");
Expect(1, 66640, '\p{^Block=deseret}', "");
Expect(1, 66640, '\P{Block=deseret}', "");
Expect(0, 66640, '\P{^Block=deseret}', "");
Expect(1, 66639, '\p{Block=-Deseret}', "");
Expect(0, 66639, '\p{^Block=-Deseret}', "");
Expect(0, 66639, '\P{Block=-Deseret}', "");
Expect(1, 66639, '\P{^Block=-Deseret}', "");
Expect(0, 66640, '\p{Block=-Deseret}', "");
Expect(1, 66640, '\p{^Block=-Deseret}', "");
Expect(1, 66640, '\P{Block=-Deseret}', "");
Expect(0, 66640, '\P{^Block=-Deseret}', "");
Error('\p{Blk= _Deseret/a/}');
Error('\P{Blk= _Deseret/a/}');
Expect(1, 66639, '\p{Blk: deseret}', "");
Expect(0, 66639, '\p{^Blk: deseret}', "");
Expect(0, 66639, '\P{Blk: deseret}', "");
Expect(1, 66639, '\P{^Blk: deseret}', "");
Expect(0, 66640, '\p{Blk: deseret}', "");
Expect(1, 66640, '\p{^Blk: deseret}', "");
Expect(1, 66640, '\P{Blk: deseret}', "");
Expect(0, 66640, '\P{^Blk: deseret}', "");
Expect(1, 66639, '\p{Blk=	Deseret}', "");
Expect(0, 66639, '\p{^Blk=	Deseret}', "");
Expect(0, 66639, '\P{Blk=	Deseret}', "");
Expect(1, 66639, '\P{^Blk=	Deseret}', "");
Expect(0, 66640, '\p{Blk=	Deseret}', "");
Expect(1, 66640, '\p{^Blk=	Deseret}', "");
Expect(1, 66640, '\P{Blk=	Deseret}', "");
Expect(0, 66640, '\P{^Blk=	Deseret}', "");
Error('\p{Is_Block=-	deseret:=}');
Error('\P{Is_Block=-	deseret:=}');
Expect(1, 66639, '\p{Is_Block=deseret}', "");
Expect(0, 66639, '\p{^Is_Block=deseret}', "");
Expect(0, 66639, '\P{Is_Block=deseret}', "");
Expect(1, 66639, '\P{^Is_Block=deseret}', "");
Expect(0, 66640, '\p{Is_Block=deseret}', "");
Expect(1, 66640, '\p{^Is_Block=deseret}', "");
Expect(1, 66640, '\P{Is_Block=deseret}', "");
Expect(0, 66640, '\P{^Is_Block=deseret}', "");
Expect(1, 66639, '\p{Is_Block=	deseret}', "");
Expect(0, 66639, '\p{^Is_Block=	deseret}', "");
Expect(0, 66639, '\P{Is_Block=	deseret}', "");
Expect(1, 66639, '\P{^Is_Block=	deseret}', "");
Expect(0, 66640, '\p{Is_Block=	deseret}', "");
Expect(1, 66640, '\p{^Is_Block=	deseret}', "");
Expect(1, 66640, '\P{Is_Block=	deseret}', "");
Expect(0, 66640, '\P{^Is_Block=	deseret}', "");
Error('\p{Is_Blk=:=-_Deseret}');
Error('\P{Is_Blk=:=-_Deseret}');
Expect(1, 66639, '\p{Is_Blk=deseret}', "");
Expect(0, 66639, '\p{^Is_Blk=deseret}', "");
Expect(0, 66639, '\P{Is_Blk=deseret}', "");
Expect(1, 66639, '\P{^Is_Blk=deseret}', "");
Expect(0, 66640, '\p{Is_Blk=deseret}', "");
Expect(1, 66640, '\p{^Is_Blk=deseret}', "");
Expect(1, 66640, '\P{Is_Blk=deseret}', "");
Expect(0, 66640, '\P{^Is_Blk=deseret}', "");
Expect(1, 66639, '\p{Is_Blk=	deseret}', "");
Expect(0, 66639, '\p{^Is_Blk=	deseret}', "");
Expect(0, 66639, '\P{Is_Blk=	deseret}', "");
Expect(1, 66639, '\P{^Is_Blk=	deseret}', "");
Expect(0, 66640, '\p{Is_Blk=	deseret}', "");
Expect(1, 66640, '\p{^Is_Blk=	deseret}', "");
Expect(1, 66640, '\P{Is_Blk=	deseret}', "");
Expect(0, 66640, '\P{^Is_Blk=	deseret}', "");
Error('\p{Block=	Devanagari/a/}');
Error('\P{Block=	Devanagari/a/}');
Expect(1, 2431, '\p{Block=devanagari}', "");
Expect(0, 2431, '\p{^Block=devanagari}', "");
Expect(0, 2431, '\P{Block=devanagari}', "");
Expect(1, 2431, '\P{^Block=devanagari}', "");
Expect(0, 2432, '\p{Block=devanagari}', "");
Expect(1, 2432, '\p{^Block=devanagari}', "");
Expect(1, 2432, '\P{Block=devanagari}', "");
Expect(0, 2432, '\P{^Block=devanagari}', "");
Expect(1, 2431, '\p{Block:   -devanagari}', "");
Expect(0, 2431, '\p{^Block:   -devanagari}', "");
Expect(0, 2431, '\P{Block:   -devanagari}', "");
Expect(1, 2431, '\P{^Block:   -devanagari}', "");
Expect(0, 2432, '\p{Block:   -devanagari}', "");
Expect(1, 2432, '\p{^Block:   -devanagari}', "");
Expect(1, 2432, '\P{Block:   -devanagari}', "");
Expect(0, 2432, '\P{^Block:   -devanagari}', "");
Error('\p{Blk=:=	_Devanagari}');
Error('\P{Blk=:=	_Devanagari}');
Expect(1, 2431, '\p{Blk=devanagari}', "");
Expect(0, 2431, '\p{^Blk=devanagari}', "");
Expect(0, 2431, '\P{Blk=devanagari}', "");
Expect(1, 2431, '\P{^Blk=devanagari}', "");
Expect(0, 2432, '\p{Blk=devanagari}', "");
Expect(1, 2432, '\p{^Blk=devanagari}', "");
Expect(1, 2432, '\P{Blk=devanagari}', "");
Expect(0, 2432, '\P{^Blk=devanagari}', "");
Expect(1, 2431, '\p{Blk=		DEVANAGARI}', "");
Expect(0, 2431, '\p{^Blk=		DEVANAGARI}', "");
Expect(0, 2431, '\P{Blk=		DEVANAGARI}', "");
Expect(1, 2431, '\P{^Blk=		DEVANAGARI}', "");
Expect(0, 2432, '\p{Blk=		DEVANAGARI}', "");
Expect(1, 2432, '\p{^Blk=		DEVANAGARI}', "");
Expect(1, 2432, '\P{Blk=		DEVANAGARI}', "");
Expect(0, 2432, '\P{^Blk=		DEVANAGARI}', "");
Error('\p{Is_Block=	:=devanagari}');
Error('\P{Is_Block=	:=devanagari}');
Expect(1, 2431, '\p{Is_Block=devanagari}', "");
Expect(0, 2431, '\p{^Is_Block=devanagari}', "");
Expect(0, 2431, '\P{Is_Block=devanagari}', "");
Expect(1, 2431, '\P{^Is_Block=devanagari}', "");
Expect(0, 2432, '\p{Is_Block=devanagari}', "");
Expect(1, 2432, '\p{^Is_Block=devanagari}', "");
Expect(1, 2432, '\P{Is_Block=devanagari}', "");
Expect(0, 2432, '\P{^Is_Block=devanagari}', "");
Expect(1, 2431, '\p{Is_Block=_DEVANAGARI}', "");
Expect(0, 2431, '\p{^Is_Block=_DEVANAGARI}', "");
Expect(0, 2431, '\P{Is_Block=_DEVANAGARI}', "");
Expect(1, 2431, '\P{^Is_Block=_DEVANAGARI}', "");
Expect(0, 2432, '\p{Is_Block=_DEVANAGARI}', "");
Expect(1, 2432, '\p{^Is_Block=_DEVANAGARI}', "");
Expect(1, 2432, '\P{Is_Block=_DEVANAGARI}', "");
Expect(0, 2432, '\P{^Is_Block=_DEVANAGARI}', "");
Error('\p{Is_Blk=-	devanagari/a/}');
Error('\P{Is_Blk=-	devanagari/a/}');
Expect(1, 2431, '\p{Is_Blk=devanagari}', "");
Expect(0, 2431, '\p{^Is_Blk=devanagari}', "");
Expect(0, 2431, '\P{Is_Blk=devanagari}', "");
Expect(1, 2431, '\P{^Is_Blk=devanagari}', "");
Expect(0, 2432, '\p{Is_Blk=devanagari}', "");
Expect(1, 2432, '\p{^Is_Blk=devanagari}', "");
Expect(1, 2432, '\P{Is_Blk=devanagari}', "");
Expect(0, 2432, '\P{^Is_Blk=devanagari}', "");
Expect(1, 2431, '\p{Is_Blk=	Devanagari}', "");
Expect(0, 2431, '\p{^Is_Blk=	Devanagari}', "");
Expect(0, 2431, '\P{Is_Blk=	Devanagari}', "");
Expect(1, 2431, '\P{^Is_Blk=	Devanagari}', "");
Expect(0, 2432, '\p{Is_Blk=	Devanagari}', "");
Expect(1, 2432, '\p{^Is_Blk=	Devanagari}', "");
Expect(1, 2432, '\P{Is_Blk=	Devanagari}', "");
Expect(0, 2432, '\P{^Is_Blk=	Devanagari}', "");
Error('\p{Block=_	Devanagari_Extended/a/}');
Error('\P{Block=_	Devanagari_Extended/a/}');
Expect(1, 43263, '\p{Block=devanagariextended}', "");
Expect(0, 43263, '\p{^Block=devanagariextended}', "");
Expect(0, 43263, '\P{Block=devanagariextended}', "");
Expect(1, 43263, '\P{^Block=devanagariextended}', "");
Expect(0, 43264, '\p{Block=devanagariextended}', "");
Expect(1, 43264, '\p{^Block=devanagariextended}', "");
Expect(1, 43264, '\P{Block=devanagariextended}', "");
Expect(0, 43264, '\P{^Block=devanagariextended}', "");
Expect(1, 43263, '\p{Block=_ Devanagari_Extended}', "");
Expect(0, 43263, '\p{^Block=_ Devanagari_Extended}', "");
Expect(0, 43263, '\P{Block=_ Devanagari_Extended}', "");
Expect(1, 43263, '\P{^Block=_ Devanagari_Extended}', "");
Expect(0, 43264, '\p{Block=_ Devanagari_Extended}', "");
Expect(1, 43264, '\p{^Block=_ Devanagari_Extended}', "");
Expect(1, 43264, '\P{Block=_ Devanagari_Extended}', "");
Expect(0, 43264, '\P{^Block=_ Devanagari_Extended}', "");
Error('\p{Blk=-DEVANAGARI_Ext/a/}');
Error('\P{Blk=-DEVANAGARI_Ext/a/}');
Expect(1, 43263, '\p{Blk=devanagariext}', "");
Expect(0, 43263, '\p{^Blk=devanagariext}', "");
Expect(0, 43263, '\P{Blk=devanagariext}', "");
Expect(1, 43263, '\P{^Blk=devanagariext}', "");
Expect(0, 43264, '\p{Blk=devanagariext}', "");
Expect(1, 43264, '\p{^Blk=devanagariext}', "");
Expect(1, 43264, '\P{Blk=devanagariext}', "");
Expect(0, 43264, '\P{^Blk=devanagariext}', "");
Expect(1, 43263, '\p{Blk=devanagari_Ext}', "");
Expect(0, 43263, '\p{^Blk=devanagari_Ext}', "");
Expect(0, 43263, '\P{Blk=devanagari_Ext}', "");
Expect(1, 43263, '\P{^Blk=devanagari_Ext}', "");
Expect(0, 43264, '\p{Blk=devanagari_Ext}', "");
Expect(1, 43264, '\p{^Blk=devanagari_Ext}', "");
Expect(1, 43264, '\P{Blk=devanagari_Ext}', "");
Expect(0, 43264, '\P{^Blk=devanagari_Ext}', "");
Error('\p{Is_Block=/a/_ Devanagari_extended}');
Error('\P{Is_Block=/a/_ Devanagari_extended}');
Expect(1, 43263, '\p{Is_Block=devanagariextended}', "");
Expect(0, 43263, '\p{^Is_Block=devanagariextended}', "");
Expect(0, 43263, '\P{Is_Block=devanagariextended}', "");
Expect(1, 43263, '\P{^Is_Block=devanagariextended}', "");
Expect(0, 43264, '\p{Is_Block=devanagariextended}', "");
Expect(1, 43264, '\p{^Is_Block=devanagariextended}', "");
Expect(1, 43264, '\P{Is_Block=devanagariextended}', "");
Expect(0, 43264, '\P{^Is_Block=devanagariextended}', "");
Expect(1, 43263, '\p{Is_Block=	-DEVANAGARI_Extended}', "");
Expect(0, 43263, '\p{^Is_Block=	-DEVANAGARI_Extended}', "");
Expect(0, 43263, '\P{Is_Block=	-DEVANAGARI_Extended}', "");
Expect(1, 43263, '\P{^Is_Block=	-DEVANAGARI_Extended}', "");
Expect(0, 43264, '\p{Is_Block=	-DEVANAGARI_Extended}', "");
Expect(1, 43264, '\p{^Is_Block=	-DEVANAGARI_Extended}', "");
Expect(1, 43264, '\P{Is_Block=	-DEVANAGARI_Extended}', "");
Expect(0, 43264, '\P{^Is_Block=	-DEVANAGARI_Extended}', "");
Error('\p{Is_Blk=/a/- Devanagari_ext}');
Error('\P{Is_Blk=/a/- Devanagari_ext}');
Expect(1, 43263, '\p{Is_Blk=devanagariext}', "");
Expect(0, 43263, '\p{^Is_Blk=devanagariext}', "");
Expect(0, 43263, '\P{Is_Blk=devanagariext}', "");
Expect(1, 43263, '\P{^Is_Blk=devanagariext}', "");
Expect(0, 43264, '\p{Is_Blk=devanagariext}', "");
Expect(1, 43264, '\p{^Is_Blk=devanagariext}', "");
Expect(1, 43264, '\P{Is_Blk=devanagariext}', "");
Expect(0, 43264, '\P{^Is_Blk=devanagariext}', "");
Expect(1, 43263, '\p{Is_Blk= _devanagari_ext}', "");
Expect(0, 43263, '\p{^Is_Blk= _devanagari_ext}', "");
Expect(0, 43263, '\P{Is_Blk= _devanagari_ext}', "");
Expect(1, 43263, '\P{^Is_Blk= _devanagari_ext}', "");
Expect(0, 43264, '\p{Is_Blk= _devanagari_ext}', "");
Expect(1, 43264, '\p{^Is_Blk= _devanagari_ext}', "");
Expect(1, 43264, '\P{Is_Blk= _devanagari_ext}', "");
Expect(0, 43264, '\P{^Is_Blk= _devanagari_ext}', "");
Error('\p{Block=:=Combining_DIACRITICAL_Marks}');
Error('\P{Block=:=Combining_DIACRITICAL_Marks}');
Expect(1, 879, '\p{Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(0, 880, '\p{Block=combiningdiacriticalmarks}', "");
Expect(1, 880, '\p{^Block=combiningdiacriticalmarks}', "");
Expect(1, 880, '\P{Block=combiningdiacriticalmarks}', "");
Expect(0, 880, '\P{^Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Block=		COMBINING_diacritical_MARKS}', "");
Expect(0, 879, '\p{^Block=		COMBINING_diacritical_MARKS}', "");
Expect(0, 879, '\P{Block=		COMBINING_diacritical_MARKS}', "");
Expect(1, 879, '\P{^Block=		COMBINING_diacritical_MARKS}', "");
Expect(0, 880, '\p{Block=		COMBINING_diacritical_MARKS}', "");
Expect(1, 880, '\p{^Block=		COMBINING_diacritical_MARKS}', "");
Expect(1, 880, '\P{Block=		COMBINING_diacritical_MARKS}', "");
Expect(0, 880, '\P{^Block=		COMBINING_diacritical_MARKS}', "");
Error('\p{Blk=-/a/DIACRITICALS}');
Error('\P{Blk=-/a/DIACRITICALS}');
Expect(1, 879, '\p{Blk:	diacriticals}', "");
Expect(0, 879, '\p{^Blk:	diacriticals}', "");
Expect(0, 879, '\P{Blk:	diacriticals}', "");
Expect(1, 879, '\P{^Blk:	diacriticals}', "");
Expect(0, 880, '\p{Blk:	diacriticals}', "");
Expect(1, 880, '\p{^Blk:	diacriticals}', "");
Expect(1, 880, '\P{Blk:	diacriticals}', "");
Expect(0, 880, '\P{^Blk:	diacriticals}', "");
Expect(1, 879, '\p{Blk=-	diacriticals}', "");
Expect(0, 879, '\p{^Blk=-	diacriticals}', "");
Expect(0, 879, '\P{Blk=-	diacriticals}', "");
Expect(1, 879, '\P{^Blk=-	diacriticals}', "");
Expect(0, 880, '\p{Blk=-	diacriticals}', "");
Expect(1, 880, '\p{^Blk=-	diacriticals}', "");
Expect(1, 880, '\P{Blk=-	diacriticals}', "");
Expect(0, 880, '\P{^Blk=-	diacriticals}', "");
Error('\p{Is_Block=/a/-	COMBINING_diacritical_Marks}');
Error('\P{Is_Block=/a/-	COMBINING_diacritical_Marks}');
Expect(1, 879, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 879, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 880, '\p{Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 880, '\p{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 880, '\P{Is_Block=combiningdiacriticalmarks}', "");
Expect(0, 880, '\P{^Is_Block=combiningdiacriticalmarks}', "");
Expect(1, 879, '\p{Is_Block=	Combining_Diacritical_marks}', "");
Expect(0, 879, '\p{^Is_Block=	Combining_Diacritical_marks}', "");
Expect(0, 879, '\P{Is_Block=	Combining_Diacritical_marks}', "");
Expect(1, 879, '\P{^Is_Block=	Combining_Diacritical_marks}', "");
Expect(0, 880, '\p{Is_Block=	Combining_Diacritical_marks}', "");
Expect(1, 880, '\p{^Is_Block=	Combining_Diacritical_marks}', "");
Expect(1, 880, '\P{Is_Block=	Combining_Diacritical_marks}', "");
Expect(0, 880, '\P{^Is_Block=	Combining_Diacritical_marks}', "");
Error('\p{Is_Blk: - Diacriticals/a/}');
Error('\P{Is_Blk: - Diacriticals/a/}');
Expect(1, 879, '\p{Is_Blk:   diacriticals}', "");
Expect(0, 879, '\p{^Is_Blk:   diacriticals}', "");
Expect(0, 879, '\P{Is_Blk:   diacriticals}', "");
Expect(1, 879, '\P{^Is_Blk:   diacriticals}', "");
Expect(0, 880, '\p{Is_Blk:   diacriticals}', "");
Expect(1, 880, '\p{^Is_Blk:   diacriticals}', "");
Expect(1, 880, '\P{Is_Blk:   diacriticals}', "");
Expect(0, 880, '\P{^Is_Blk:   diacriticals}', "");
Expect(1, 879, '\p{Is_Blk=_Diacriticals}', "");
Expect(0, 879, '\p{^Is_Blk=_Diacriticals}', "");
Expect(0, 879, '\P{Is_Blk=_Diacriticals}', "");
Expect(1, 879, '\P{^Is_Blk=_Diacriticals}', "");
Expect(0, 880, '\p{Is_Blk=_Diacriticals}', "");
Expect(1, 880, '\p{^Is_Blk=_Diacriticals}', "");
Expect(1, 880, '\P{Is_Blk=_Diacriticals}', "");
Expect(0, 880, '\P{^Is_Blk=_Diacriticals}', "");
Error('\p{Block=_Combining_diacritical_Marks_EXTENDED/a/}');
Error('\P{Block=_Combining_diacritical_Marks_EXTENDED/a/}');
Expect(1, 6911, '\p{Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6911, '\p{^Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6911, '\P{Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6911, '\P{^Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6912, '\p{Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6912, '\p{^Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6912, '\P{Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6912, '\P{^Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6911, '\p{Block=- combining_diacritical_Marks_Extended}', "");
Expect(0, 6911, '\p{^Block=- combining_diacritical_Marks_Extended}', "");
Expect(0, 6911, '\P{Block=- combining_diacritical_Marks_Extended}', "");
Expect(1, 6911, '\P{^Block=- combining_diacritical_Marks_Extended}', "");
Expect(0, 6912, '\p{Block=- combining_diacritical_Marks_Extended}', "");
Expect(1, 6912, '\p{^Block=- combining_diacritical_Marks_Extended}', "");
Expect(1, 6912, '\P{Block=- combining_diacritical_Marks_Extended}', "");
Expect(0, 6912, '\P{^Block=- combining_diacritical_Marks_Extended}', "");
Error('\p{Blk=	_diacriticals_Ext/a/}');
Error('\P{Blk=	_diacriticals_Ext/a/}');
Expect(1, 6911, '\p{Blk=diacriticalsext}', "");
Expect(0, 6911, '\p{^Blk=diacriticalsext}', "");
Expect(0, 6911, '\P{Blk=diacriticalsext}', "");
Expect(1, 6911, '\P{^Blk=diacriticalsext}', "");
Expect(0, 6912, '\p{Blk=diacriticalsext}', "");
Expect(1, 6912, '\p{^Blk=diacriticalsext}', "");
Expect(1, 6912, '\P{Blk=diacriticalsext}', "");
Expect(0, 6912, '\P{^Blk=diacriticalsext}', "");
Expect(1, 6911, '\p{Blk=		Diacriticals_Ext}', "");
Expect(0, 6911, '\p{^Blk=		Diacriticals_Ext}', "");
Expect(0, 6911, '\P{Blk=		Diacriticals_Ext}', "");
Expect(1, 6911, '\P{^Blk=		Diacriticals_Ext}', "");
Expect(0, 6912, '\p{Blk=		Diacriticals_Ext}', "");
Expect(1, 6912, '\p{^Blk=		Diacriticals_Ext}', "");
Expect(1, 6912, '\P{Blk=		Diacriticals_Ext}', "");
Expect(0, 6912, '\P{^Blk=		Diacriticals_Ext}', "");
Error('\p{Is_Block=:=  COMBINING_DIACRITICAL_MARKS_Extended}');
Error('\P{Is_Block=:=  COMBINING_DIACRITICAL_MARKS_Extended}');
Expect(1, 6911, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6911, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6911, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6911, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6912, '\p{Is_Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6912, '\p{^Is_Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6912, '\P{Is_Block=combiningdiacriticalmarksextended}', "");
Expect(0, 6912, '\P{^Is_Block=combiningdiacriticalmarksextended}', "");
Expect(1, 6911, '\p{Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(0, 6911, '\p{^Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(0, 6911, '\P{Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(1, 6911, '\P{^Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(0, 6912, '\p{Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(1, 6912, '\p{^Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(1, 6912, '\P{Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Expect(0, 6912, '\P{^Is_Block=-	Combining_diacritical_Marks_EXTENDED}', "");
Error('\p{Is_Blk=:=-_diacriticals_Ext}');
Error('\P{Is_Blk=:=-_diacriticals_Ext}');
Expect(1, 6911, '\p{Is_Blk=diacriticalsext}', "");
Expect(0, 6911, '\p{^Is_Blk=diacriticalsext}', "");
Expect(0, 6911, '\P{Is_Blk=diacriticalsext}', "");
Expect(1, 6911, '\P{^Is_Blk=diacriticalsext}', "");
Expect(0, 6912, '\p{Is_Blk=diacriticalsext}', "");
Expect(1, 6912, '\p{^Is_Blk=diacriticalsext}', "");
Expect(1, 6912, '\P{Is_Blk=diacriticalsext}', "");
Expect(0, 6912, '\P{^Is_Blk=diacriticalsext}', "");
Expect(1, 6911, '\p{Is_Blk=	-Diacriticals_Ext}', "");
Expect(0, 6911, '\p{^Is_Blk=	-Diacriticals_Ext}', "");
Expect(0, 6911, '\P{Is_Blk=	-Diacriticals_Ext}', "");
Expect(1, 6911, '\P{^Is_Blk=	-Diacriticals_Ext}', "");
Expect(0, 6912, '\p{Is_Blk=	-Diacriticals_Ext}', "");
Expect(1, 6912, '\p{^Is_Blk=	-Diacriticals_Ext}', "");
Expect(1, 6912, '\P{Is_Blk=	-Diacriticals_Ext}', "");
Expect(0, 6912, '\P{^Is_Blk=	-Diacriticals_Ext}', "");
Error('\p{Block= :=Combining_Diacritical_Marks_for_symbols}');
Error('\P{Block= :=Combining_Diacritical_Marks_for_symbols}');
Expect(1, 8447, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8448, '\p{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8448, '\p{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8448, '\P{Block=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8448, '\P{^Block=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(0, 8447, '\p{^Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(0, 8447, '\P{Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(1, 8447, '\P{^Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(0, 8448, '\p{Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(1, 8448, '\p{^Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(1, 8448, '\P{Block=- Combining_diacritical_Marks_for_symbols}', "");
Expect(0, 8448, '\P{^Block=- Combining_diacritical_Marks_for_symbols}', "");
Error('\p{Blk=/a/ Diacriticals_For_symbols}');
Error('\P{Blk=/a/ Diacriticals_For_symbols}');
Expect(1, 8447, '\p{Blk=diacriticalsforsymbols}', "");
Expect(0, 8447, '\p{^Blk=diacriticalsforsymbols}', "");
Expect(0, 8447, '\P{Blk=diacriticalsforsymbols}', "");
Expect(1, 8447, '\P{^Blk=diacriticalsforsymbols}', "");
Expect(0, 8448, '\p{Blk=diacriticalsforsymbols}', "");
Expect(1, 8448, '\p{^Blk=diacriticalsforsymbols}', "");
Expect(1, 8448, '\P{Blk=diacriticalsforsymbols}', "");
Expect(0, 8448, '\P{^Blk=diacriticalsforsymbols}', "");
Expect(1, 8447, '\p{Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(0, 8447, '\p{^Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(0, 8447, '\P{Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(1, 8447, '\P{^Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(0, 8448, '\p{Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(1, 8448, '\p{^Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(1, 8448, '\P{Blk=-	DIACRITICALS_For_Symbols}', "");
Expect(0, 8448, '\P{^Blk=-	DIACRITICALS_For_Symbols}', "");
Error('\p{Is_Block= :=Combining_MARKS_For_SYMBOLS}');
Error('\P{Is_Block= :=Combining_MARKS_For_SYMBOLS}');
Expect(1, 8447, '\p{Is_Block=combiningmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Block=combiningmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Block=combiningmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Block=combiningmarksforsymbols}', "");
Expect(0, 8448, '\p{Is_Block=combiningmarksforsymbols}', "");
Expect(1, 8448, '\p{^Is_Block=combiningmarksforsymbols}', "");
Expect(1, 8448, '\P{Is_Block=combiningmarksforsymbols}', "");
Expect(0, 8448, '\P{^Is_Block=combiningmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(0, 8447, '\p{^Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(0, 8447, '\P{Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(1, 8447, '\P{^Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(0, 8448, '\p{Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(1, 8448, '\p{^Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(1, 8448, '\P{Is_Block=-_Combining_Marks_for_Symbols}', "");
Expect(0, 8448, '\P{^Is_Block=-_Combining_Marks_for_Symbols}', "");
Error('\p{Is_Blk=:=Combining_Diacritical_Marks_for_symbols}');
Error('\P{Is_Blk=:=Combining_Diacritical_Marks_for_symbols}');
Expect(1, 8447, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8447, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8448, '\p{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8448, '\p{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8448, '\P{Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(0, 8448, '\P{^Is_Blk=combiningdiacriticalmarksforsymbols}', "");
Expect(1, 8447, '\p{Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(0, 8447, '\p{^Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(0, 8447, '\P{Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(1, 8447, '\P{^Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(0, 8448, '\p{Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(1, 8448, '\p{^Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(1, 8448, '\P{Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Expect(0, 8448, '\P{^Is_Blk=_combining_DIACRITICAL_marks_FOR_symbols}', "");
Error('\p{Block=/a/-Combining_diacritical_marks_Supplement}');
Error('\P{Block=/a/-Combining_diacritical_marks_Supplement}');
Expect(1, 7679, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7680, '\p{Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7680, '\p{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7680, '\P{Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7680, '\P{^Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7679, '\p{^Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7679, '\P{Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7679, '\P{^Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7680, '\p{Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7680, '\p{^Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7680, '\P{Block=		combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7680, '\P{^Block=		combining_Diacritical_MARKS_Supplement}', "");
Error('\p{Blk=	_Diacriticals_sup/a/}');
Error('\P{Blk=	_Diacriticals_sup/a/}');
Expect(1, 7679, '\p{Blk=diacriticalssup}', "");
Expect(0, 7679, '\p{^Blk=diacriticalssup}', "");
Expect(0, 7679, '\P{Blk=diacriticalssup}', "");
Expect(1, 7679, '\P{^Blk=diacriticalssup}', "");
Expect(0, 7680, '\p{Blk=diacriticalssup}', "");
Expect(1, 7680, '\p{^Blk=diacriticalssup}', "");
Expect(1, 7680, '\P{Blk=diacriticalssup}', "");
Expect(0, 7680, '\P{^Blk=diacriticalssup}', "");
Expect(1, 7679, '\p{Blk=_-Diacriticals_SUP}', "");
Expect(0, 7679, '\p{^Blk=_-Diacriticals_SUP}', "");
Expect(0, 7679, '\P{Blk=_-Diacriticals_SUP}', "");
Expect(1, 7679, '\P{^Blk=_-Diacriticals_SUP}', "");
Expect(0, 7680, '\p{Blk=_-Diacriticals_SUP}', "");
Expect(1, 7680, '\p{^Blk=_-Diacriticals_SUP}', "");
Expect(1, 7680, '\P{Blk=_-Diacriticals_SUP}', "");
Expect(0, 7680, '\P{^Blk=_-Diacriticals_SUP}', "");
Error('\p{Is_Block=/a/  COMBINING_Diacritical_marks_Supplement}');
Error('\P{Is_Block=/a/  COMBINING_Diacritical_marks_Supplement}');
Expect(1, 7679, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7679, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7680, '\p{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7680, '\p{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7680, '\P{Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(0, 7680, '\P{^Is_Block=combiningdiacriticalmarkssupplement}', "");
Expect(1, 7679, '\p{Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7679, '\p{^Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7679, '\P{Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7679, '\P{^Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7680, '\p{Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7680, '\p{^Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(1, 7680, '\P{Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Expect(0, 7680, '\P{^Is_Block=- combining_Diacritical_MARKS_Supplement}', "");
Error('\p{Is_Blk=-	DIACRITICALS_sup/a/}');
Error('\P{Is_Blk=-	DIACRITICALS_sup/a/}');
Expect(1, 7679, '\p{Is_Blk=diacriticalssup}', "");
Expect(0, 7679, '\p{^Is_Blk=diacriticalssup}', "");
Expect(0, 7679, '\P{Is_Blk=diacriticalssup}', "");
Expect(1, 7679, '\P{^Is_Blk=diacriticalssup}', "");
Expect(0, 7680, '\p{Is_Blk=diacriticalssup}', "");
Expect(1, 7680, '\p{^Is_Blk=diacriticalssup}', "");
Expect(1, 7680, '\P{Is_Blk=diacriticalssup}', "");
Expect(0, 7680, '\P{^Is_Blk=diacriticalssup}', "");
Expect(1, 7679, '\p{Is_Blk=  DIACRITICALS_SUP}', "");
Expect(0, 7679, '\p{^Is_Blk=  DIACRITICALS_SUP}', "");
Expect(0, 7679, '\P{Is_Blk=  DIACRITICALS_SUP}', "");
Expect(1, 7679, '\P{^Is_Blk=  DIACRITICALS_SUP}', "");
Expect(0, 7680, '\p{Is_Blk=  DIACRITICALS_SUP}', "");
Expect(1, 7680, '\p{^Is_Blk=  DIACRITICALS_SUP}', "");
Expect(1, 7680, '\P{Is_Blk=  DIACRITICALS_SUP}', "");
Expect(0, 7680, '\P{^Is_Blk=  DIACRITICALS_SUP}', "");
Error('\p{Block=		Dingbats/a/}');
Error('\P{Block=		Dingbats/a/}');
Expect(1, 10175, '\p{Block=dingbats}', "");
Expect(0, 10175, '\p{^Block=dingbats}', "");
Expect(0, 10175, '\P{Block=dingbats}', "");
Expect(1, 10175, '\P{^Block=dingbats}', "");
Expect(0, 10176, '\p{Block=dingbats}', "");
Expect(1, 10176, '\p{^Block=dingbats}', "");
Expect(1, 10176, '\P{Block=dingbats}', "");
Expect(0, 10176, '\P{^Block=dingbats}', "");
Expect(1, 10175, '\p{Block:	 DINGBATS}', "");
Expect(0, 10175, '\p{^Block:	 DINGBATS}', "");
Expect(0, 10175, '\P{Block:	 DINGBATS}', "");
Expect(1, 10175, '\P{^Block:	 DINGBATS}', "");
Expect(0, 10176, '\p{Block:	 DINGBATS}', "");
Expect(1, 10176, '\p{^Block:	 DINGBATS}', "");
Expect(1, 10176, '\P{Block:	 DINGBATS}', "");
Expect(0, 10176, '\P{^Block:	 DINGBATS}', "");
Error('\p{Blk=:=-dingbats}');
Error('\P{Blk=:=-dingbats}');
Expect(1, 10175, '\p{Blk=dingbats}', "");
Expect(0, 10175, '\p{^Blk=dingbats}', "");
Expect(0, 10175, '\P{Blk=dingbats}', "");
Expect(1, 10175, '\P{^Blk=dingbats}', "");
Expect(0, 10176, '\p{Blk=dingbats}', "");
Expect(1, 10176, '\p{^Blk=dingbats}', "");
Expect(1, 10176, '\P{Blk=dingbats}', "");
Expect(0, 10176, '\P{^Blk=dingbats}', "");
Expect(1, 10175, '\p{Blk= -Dingbats}', "");
Expect(0, 10175, '\p{^Blk= -Dingbats}', "");
Expect(0, 10175, '\P{Blk= -Dingbats}', "");
Expect(1, 10175, '\P{^Blk= -Dingbats}', "");
Expect(0, 10176, '\p{Blk= -Dingbats}', "");
Expect(1, 10176, '\p{^Blk= -Dingbats}', "");
Expect(1, 10176, '\P{Blk= -Dingbats}', "");
Expect(0, 10176, '\P{^Blk= -Dingbats}', "");
Error('\p{Is_Block=_:=DINGBATS}');
Error('\P{Is_Block=_:=DINGBATS}');
Expect(1, 10175, '\p{Is_Block:dingbats}', "");
Expect(0, 10175, '\p{^Is_Block:dingbats}', "");
Expect(0, 10175, '\P{Is_Block:dingbats}', "");
Expect(1, 10175, '\P{^Is_Block:dingbats}', "");
Expect(0, 10176, '\p{Is_Block:dingbats}', "");
Expect(1, 10176, '\p{^Is_Block:dingbats}', "");
Expect(1, 10176, '\P{Is_Block:dingbats}', "");
Expect(0, 10176, '\P{^Is_Block:dingbats}', "");
Expect(1, 10175, '\p{Is_Block=--DINGBATS}', "");
Expect(0, 10175, '\p{^Is_Block=--DINGBATS}', "");
Expect(0, 10175, '\P{Is_Block=--DINGBATS}', "");
Expect(1, 10175, '\P{^Is_Block=--DINGBATS}', "");
Expect(0, 10176, '\p{Is_Block=--DINGBATS}', "");
Expect(1, 10176, '\p{^Is_Block=--DINGBATS}', "");
Expect(1, 10176, '\P{Is_Block=--DINGBATS}', "");
Expect(0, 10176, '\P{^Is_Block=--DINGBATS}', "");
Error('\p{Is_Blk=/a/	-dingbats}');
Error('\P{Is_Blk=/a/	-dingbats}');
Expect(1, 10175, '\p{Is_Blk=dingbats}', "");
Expect(0, 10175, '\p{^Is_Blk=dingbats}', "");
Expect(0, 10175, '\P{Is_Blk=dingbats}', "");
Expect(1, 10175, '\P{^Is_Blk=dingbats}', "");
Expect(0, 10176, '\p{Is_Blk=dingbats}', "");
Expect(1, 10176, '\p{^Is_Blk=dingbats}', "");
Expect(1, 10176, '\P{Is_Blk=dingbats}', "");
Expect(0, 10176, '\P{^Is_Blk=dingbats}', "");
Expect(1, 10175, '\p{Is_Blk:    _dingbats}', "");
Expect(0, 10175, '\p{^Is_Blk:    _dingbats}', "");
Expect(0, 10175, '\P{Is_Blk:    _dingbats}', "");
Expect(1, 10175, '\P{^Is_Blk:    _dingbats}', "");
Expect(0, 10176, '\p{Is_Blk:    _dingbats}', "");
Expect(1, 10176, '\p{^Is_Blk:    _dingbats}', "");
Expect(1, 10176, '\P{Is_Blk:    _dingbats}', "");
Expect(0, 10176, '\P{^Is_Blk:    _dingbats}', "");
Error('\p{Block=_:=Domino_Tiles}');
Error('\P{Block=_:=Domino_Tiles}');
Expect(1, 127135, '\p{Block=dominotiles}', "");
Expect(0, 127135, '\p{^Block=dominotiles}', "");
Expect(0, 127135, '\P{Block=dominotiles}', "");
Expect(1, 127135, '\P{^Block=dominotiles}', "");
Expect(0, 127136, '\p{Block=dominotiles}', "");
Expect(1, 127136, '\p{^Block=dominotiles}', "");
Expect(1, 127136, '\P{Block=dominotiles}', "");
Expect(0, 127136, '\P{^Block=dominotiles}', "");
Expect(1, 127135, '\p{Block= -DOMINO_Tiles}', "");
Expect(0, 127135, '\p{^Block= -DOMINO_Tiles}', "");
Expect(0, 127135, '\P{Block= -DOMINO_Tiles}', "");
Expect(1, 127135, '\P{^Block= -DOMINO_Tiles}', "");
Expect(0, 127136, '\p{Block= -DOMINO_Tiles}', "");
Expect(1, 127136, '\p{^Block= -DOMINO_Tiles}', "");
Expect(1, 127136, '\P{Block= -DOMINO_Tiles}', "");
Expect(0, 127136, '\P{^Block= -DOMINO_Tiles}', "");
Error('\p{Blk=	/a/Domino}');
Error('\P{Blk=	/a/Domino}');
Expect(1, 127135, '\p{Blk=domino}', "");
Expect(0, 127135, '\p{^Blk=domino}', "");
Expect(0, 127135, '\P{Blk=domino}', "");
Expect(1, 127135, '\P{^Blk=domino}', "");
Expect(0, 127136, '\p{Blk=domino}', "");
Expect(1, 127136, '\p{^Blk=domino}', "");
Expect(1, 127136, '\P{Blk=domino}', "");
Expect(0, 127136, '\P{^Blk=domino}', "");
Expect(1, 127135, '\p{Blk= DOMINO}', "");
Expect(0, 127135, '\p{^Blk= DOMINO}', "");
Expect(0, 127135, '\P{Blk= DOMINO}', "");
Expect(1, 127135, '\P{^Blk= DOMINO}', "");
Expect(0, 127136, '\p{Blk= DOMINO}', "");
Expect(1, 127136, '\p{^Blk= DOMINO}', "");
Expect(1, 127136, '\P{Blk= DOMINO}', "");
Expect(0, 127136, '\P{^Blk= DOMINO}', "");
Error('\p{Is_Block=/a/_	DOMINO_Tiles}');
Error('\P{Is_Block=/a/_	DOMINO_Tiles}');
Expect(1, 127135, '\p{Is_Block=dominotiles}', "");
Expect(0, 127135, '\p{^Is_Block=dominotiles}', "");
Expect(0, 127135, '\P{Is_Block=dominotiles}', "");
Expect(1, 127135, '\P{^Is_Block=dominotiles}', "");
Expect(0, 127136, '\p{Is_Block=dominotiles}', "");
Expect(1, 127136, '\p{^Is_Block=dominotiles}', "");
Expect(1, 127136, '\P{Is_Block=dominotiles}', "");
Expect(0, 127136, '\P{^Is_Block=dominotiles}', "");
Expect(1, 127135, '\p{Is_Block=-Domino_tiles}', "");
Expect(0, 127135, '\p{^Is_Block=-Domino_tiles}', "");
Expect(0, 127135, '\P{Is_Block=-Domino_tiles}', "");
Expect(1, 127135, '\P{^Is_Block=-Domino_tiles}', "");
Expect(0, 127136, '\p{Is_Block=-Domino_tiles}', "");
Expect(1, 127136, '\p{^Is_Block=-Domino_tiles}', "");
Expect(1, 127136, '\P{Is_Block=-Domino_tiles}', "");
Expect(0, 127136, '\P{^Is_Block=-Domino_tiles}', "");
Error('\p{Is_Blk=_	DOMINO:=}');
Error('\P{Is_Blk=_	DOMINO:=}');
Expect(1, 127135, '\p{Is_Blk=domino}', "");
Expect(0, 127135, '\p{^Is_Blk=domino}', "");
Expect(0, 127135, '\P{Is_Blk=domino}', "");
Expect(1, 127135, '\P{^Is_Blk=domino}', "");
Expect(0, 127136, '\p{Is_Blk=domino}', "");
Expect(1, 127136, '\p{^Is_Blk=domino}', "");
Expect(1, 127136, '\P{Is_Blk=domino}', "");
Expect(0, 127136, '\P{^Is_Blk=domino}', "");
Expect(1, 127135, '\p{Is_Blk=_ DOMINO}', "");
Expect(0, 127135, '\p{^Is_Blk=_ DOMINO}', "");
Expect(0, 127135, '\P{Is_Blk=_ DOMINO}', "");
Expect(1, 127135, '\P{^Is_Blk=_ DOMINO}', "");
Expect(0, 127136, '\p{Is_Blk=_ DOMINO}', "");
Expect(1, 127136, '\p{^Is_Blk=_ DOMINO}', "");
Expect(1, 127136, '\P{Is_Blk=_ DOMINO}', "");
Expect(0, 127136, '\P{^Is_Blk=_ DOMINO}', "");
Error('\p{Block=:=_ Duployan}');
Error('\P{Block=:=_ Duployan}');
Expect(1, 113823, '\p{Block=duployan}', "");
Expect(0, 113823, '\p{^Block=duployan}', "");
Expect(0, 113823, '\P{Block=duployan}', "");
Expect(1, 113823, '\P{^Block=duployan}', "");
Expect(0, 113824, '\p{Block=duployan}', "");
Expect(1, 113824, '\p{^Block=duployan}', "");
Expect(1, 113824, '\P{Block=duployan}', "");
Expect(0, 113824, '\P{^Block=duployan}', "");
Expect(1, 113823, '\p{Block=_ duployan}', "");
Expect(0, 113823, '\p{^Block=_ duployan}', "");
Expect(0, 113823, '\P{Block=_ duployan}', "");
Expect(1, 113823, '\P{^Block=_ duployan}', "");
Expect(0, 113824, '\p{Block=_ duployan}', "");
Expect(1, 113824, '\p{^Block=_ duployan}', "");
Expect(1, 113824, '\P{Block=_ duployan}', "");
Expect(0, 113824, '\P{^Block=_ duployan}', "");
Error('\p{Blk=/a/Duployan}');
Error('\P{Blk=/a/Duployan}');
Expect(1, 113823, '\p{Blk=duployan}', "");
Expect(0, 113823, '\p{^Blk=duployan}', "");
Expect(0, 113823, '\P{Blk=duployan}', "");
Expect(1, 113823, '\P{^Blk=duployan}', "");
Expect(0, 113824, '\p{Blk=duployan}', "");
Expect(1, 113824, '\p{^Blk=duployan}', "");
Expect(1, 113824, '\P{Blk=duployan}', "");
Expect(0, 113824, '\P{^Blk=duployan}', "");
Expect(1, 113823, '\p{Blk=_ DUPLOYAN}', "");
Expect(0, 113823, '\p{^Blk=_ DUPLOYAN}', "");
Expect(0, 113823, '\P{Blk=_ DUPLOYAN}', "");
Expect(1, 113823, '\P{^Blk=_ DUPLOYAN}', "");
Expect(0, 113824, '\p{Blk=_ DUPLOYAN}', "");
Expect(1, 113824, '\p{^Blk=_ DUPLOYAN}', "");
Expect(1, 113824, '\P{Blk=_ DUPLOYAN}', "");
Expect(0, 113824, '\P{^Blk=_ DUPLOYAN}', "");
Error('\p{Is_Block=:=_ DUPLOYAN}');
Error('\P{Is_Block=:=_ DUPLOYAN}');
Expect(1, 113823, '\p{Is_Block=duployan}', "");
Expect(0, 113823, '\p{^Is_Block=duployan}', "");
Expect(0, 113823, '\P{Is_Block=duployan}', "");
Expect(1, 113823, '\P{^Is_Block=duployan}', "");
Expect(0, 113824, '\p{Is_Block=duployan}', "");
Expect(1, 113824, '\p{^Is_Block=duployan}', "");
Expect(1, 113824, '\P{Is_Block=duployan}', "");
Expect(0, 113824, '\P{^Is_Block=duployan}', "");
Expect(1, 113823, '\p{Is_Block=-	Duployan}', "");
Expect(0, 113823, '\p{^Is_Block=-	Duployan}', "");
Expect(0, 113823, '\P{Is_Block=-	Duployan}', "");
Expect(1, 113823, '\P{^Is_Block=-	Duployan}', "");
Expect(0, 113824, '\p{Is_Block=-	Duployan}', "");
Expect(1, 113824, '\p{^Is_Block=-	Duployan}', "");
Expect(1, 113824, '\P{Is_Block=-	Duployan}', "");
Expect(0, 113824, '\P{^Is_Block=-	Duployan}', "");
Error('\p{Is_Blk= :=Duployan}');
Error('\P{Is_Blk= :=Duployan}');
Expect(1, 113823, '\p{Is_Blk=duployan}', "");
Expect(0, 113823, '\p{^Is_Blk=duployan}', "");
Expect(0, 113823, '\P{Is_Blk=duployan}', "");
Expect(1, 113823, '\P{^Is_Blk=duployan}', "");
Expect(0, 113824, '\p{Is_Blk=duployan}', "");
Expect(1, 113824, '\p{^Is_Blk=duployan}', "");
Expect(1, 113824, '\P{Is_Blk=duployan}', "");
Expect(0, 113824, '\P{^Is_Blk=duployan}', "");
Expect(1, 113823, '\p{Is_Blk=_ duployan}', "");
Expect(0, 113823, '\p{^Is_Blk=_ duployan}', "");
Expect(0, 113823, '\P{Is_Blk=_ duployan}', "");
Expect(1, 113823, '\P{^Is_Blk=_ duployan}', "");
Expect(0, 113824, '\p{Is_Blk=_ duployan}', "");
Expect(1, 113824, '\p{^Is_Blk=_ duployan}', "");
Expect(1, 113824, '\P{Is_Blk=_ duployan}', "");
Expect(0, 113824, '\P{^Is_Blk=_ duployan}', "");
Error('\p{Block=-	EGYPTIAN_HIEROGLYPHS/a/}');
Error('\P{Block=-	EGYPTIAN_HIEROGLYPHS/a/}');
Expect(1, 78895, '\p{Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Block=egyptianhieroglyphs}', "");
Expect(0, 78896, '\p{Block=egyptianhieroglyphs}', "");
Expect(1, 78896, '\p{^Block=egyptianhieroglyphs}', "");
Expect(1, 78896, '\P{Block=egyptianhieroglyphs}', "");
Expect(0, 78896, '\P{^Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Block=_	Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\p{^Block=_	Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\P{Block=_	Egyptian_Hieroglyphs}', "");
Expect(1, 78895, '\P{^Block=_	Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\p{Block=_	Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\p{^Block=_	Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\P{Block=_	Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\P{^Block=_	Egyptian_Hieroglyphs}', "");
Error('\p{Blk=:= Egyptian_hieroglyphs}');
Error('\P{Blk=:= Egyptian_hieroglyphs}');
Expect(1, 78895, '\p{Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Blk=egyptianhieroglyphs}', "");
Expect(0, 78896, '\p{Blk=egyptianhieroglyphs}', "");
Expect(1, 78896, '\p{^Blk=egyptianhieroglyphs}', "");
Expect(1, 78896, '\P{Blk=egyptianhieroglyphs}', "");
Expect(0, 78896, '\P{^Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Blk:_ Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\p{^Blk:_ Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\P{Blk:_ Egyptian_Hieroglyphs}', "");
Expect(1, 78895, '\P{^Blk:_ Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\p{Blk:_ Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\p{^Blk:_ Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\P{Blk:_ Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\P{^Blk:_ Egyptian_Hieroglyphs}', "");
Error('\p{Is_Block:/a/	_Egyptian_hieroglyphs}');
Error('\P{Is_Block:/a/	_Egyptian_hieroglyphs}');
Expect(1, 78895, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78896, '\p{Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78896, '\p{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78896, '\P{Is_Block=egyptianhieroglyphs}', "");
Expect(0, 78896, '\P{^Is_Block=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Block= Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Block= Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\P{Is_Block= Egyptian_Hieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Block= Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\p{Is_Block= Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\p{^Is_Block= Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\P{Is_Block= Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\P{^Is_Block= Egyptian_Hieroglyphs}', "");
Error('\p{Is_Blk=_/a/Egyptian_hieroglyphs}');
Error('\P{Is_Blk=_/a/Egyptian_hieroglyphs}');
Expect(1, 78895, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78895, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78896, '\p{Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78896, '\p{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78896, '\P{Is_Blk=egyptianhieroglyphs}', "");
Expect(0, 78896, '\P{^Is_Blk=egyptianhieroglyphs}', "");
Expect(1, 78895, '\p{Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\p{^Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(0, 78895, '\P{Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(1, 78895, '\P{^Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\p{Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\p{^Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(1, 78896, '\P{Is_Blk=	Egyptian_Hieroglyphs}', "");
Expect(0, 78896, '\P{^Is_Blk=	Egyptian_Hieroglyphs}', "");
Error('\p{Block=	_Elbasan/a/}');
Error('\P{Block=	_Elbasan/a/}');
Expect(1, 66863, '\p{Block=elbasan}', "");
Expect(0, 66863, '\p{^Block=elbasan}', "");
Expect(0, 66863, '\P{Block=elbasan}', "");
Expect(1, 66863, '\P{^Block=elbasan}', "");
Expect(0, 66864, '\p{Block=elbasan}', "");
Expect(1, 66864, '\p{^Block=elbasan}', "");
Expect(1, 66864, '\P{Block=elbasan}', "");
Expect(0, 66864, '\P{^Block=elbasan}', "");
Expect(1, 66863, '\p{Block=-Elbasan}', "");
Expect(0, 66863, '\p{^Block=-Elbasan}', "");
Expect(0, 66863, '\P{Block=-Elbasan}', "");
Expect(1, 66863, '\P{^Block=-Elbasan}', "");
Expect(0, 66864, '\p{Block=-Elbasan}', "");
Expect(1, 66864, '\p{^Block=-Elbasan}', "");
Expect(1, 66864, '\P{Block=-Elbasan}', "");
Expect(0, 66864, '\P{^Block=-Elbasan}', "");
Error('\p{Blk=  elbasan:=}');
Error('\P{Blk=  elbasan:=}');
Expect(1, 66863, '\p{Blk=elbasan}', "");
Expect(0, 66863, '\p{^Blk=elbasan}', "");
Expect(0, 66863, '\P{Blk=elbasan}', "");
Expect(1, 66863, '\P{^Blk=elbasan}', "");
Expect(0, 66864, '\p{Blk=elbasan}', "");
Expect(1, 66864, '\p{^Blk=elbasan}', "");
Expect(1, 66864, '\P{Blk=elbasan}', "");
Expect(0, 66864, '\P{^Blk=elbasan}', "");
Expect(1, 66863, '\p{Blk=_Elbasan}', "");
Expect(0, 66863, '\p{^Blk=_Elbasan}', "");
Expect(0, 66863, '\P{Blk=_Elbasan}', "");
Expect(1, 66863, '\P{^Blk=_Elbasan}', "");
Expect(0, 66864, '\p{Blk=_Elbasan}', "");
Expect(1, 66864, '\p{^Blk=_Elbasan}', "");
Expect(1, 66864, '\P{Blk=_Elbasan}', "");
Expect(0, 66864, '\P{^Blk=_Elbasan}', "");
Error('\p{Is_Block=/a/ -ELBASAN}');
Error('\P{Is_Block=/a/ -ELBASAN}');
Expect(1, 66863, '\p{Is_Block=elbasan}', "");
Expect(0, 66863, '\p{^Is_Block=elbasan}', "");
Expect(0, 66863, '\P{Is_Block=elbasan}', "");
Expect(1, 66863, '\P{^Is_Block=elbasan}', "");
Expect(0, 66864, '\p{Is_Block=elbasan}', "");
Expect(1, 66864, '\p{^Is_Block=elbasan}', "");
Expect(1, 66864, '\P{Is_Block=elbasan}', "");
Expect(0, 66864, '\P{^Is_Block=elbasan}', "");
Expect(1, 66863, '\p{Is_Block=_Elbasan}', "");
Expect(0, 66863, '\p{^Is_Block=_Elbasan}', "");
Expect(0, 66863, '\P{Is_Block=_Elbasan}', "");
Expect(1, 66863, '\P{^Is_Block=_Elbasan}', "");
Expect(0, 66864, '\p{Is_Block=_Elbasan}', "");
Expect(1, 66864, '\p{^Is_Block=_Elbasan}', "");
Expect(1, 66864, '\P{Is_Block=_Elbasan}', "");
Expect(0, 66864, '\P{^Is_Block=_Elbasan}', "");
Error('\p{Is_Blk= /a/Elbasan}');
Error('\P{Is_Blk= /a/Elbasan}');
Expect(1, 66863, '\p{Is_Blk=elbasan}', "");
Expect(0, 66863, '\p{^Is_Blk=elbasan}', "");
Expect(0, 66863, '\P{Is_Blk=elbasan}', "");
Expect(1, 66863, '\P{^Is_Blk=elbasan}', "");
Expect(0, 66864, '\p{Is_Blk=elbasan}', "");
Expect(1, 66864, '\p{^Is_Blk=elbasan}', "");
Expect(1, 66864, '\P{Is_Blk=elbasan}', "");
Expect(0, 66864, '\P{^Is_Blk=elbasan}', "");
Expect(1, 66863, '\p{Is_Blk= -ELBASAN}', "");
Expect(0, 66863, '\p{^Is_Blk= -ELBASAN}', "");
Expect(0, 66863, '\P{Is_Blk= -ELBASAN}', "");
Expect(1, 66863, '\P{^Is_Blk= -ELBASAN}', "");
Expect(0, 66864, '\p{Is_Blk= -ELBASAN}', "");
Expect(1, 66864, '\p{^Is_Blk= -ELBASAN}', "");
Expect(1, 66864, '\P{Is_Blk= -ELBASAN}', "");
Expect(0, 66864, '\P{^Is_Blk= -ELBASAN}', "");
Error('\p{Block=	:=Emoticons}');
Error('\P{Block=	:=Emoticons}');
Expect(1, 128591, '\p{Block=emoticons}', "");
Expect(0, 128591, '\p{^Block=emoticons}', "");
Expect(0, 128591, '\P{Block=emoticons}', "");
Expect(1, 128591, '\P{^Block=emoticons}', "");
Expect(0, 128592, '\p{Block=emoticons}', "");
Expect(1, 128592, '\p{^Block=emoticons}', "");
Expect(1, 128592, '\P{Block=emoticons}', "");
Expect(0, 128592, '\P{^Block=emoticons}', "");
Expect(1, 128591, '\p{Block=	Emoticons}', "");
Expect(0, 128591, '\p{^Block=	Emoticons}', "");
Expect(0, 128591, '\P{Block=	Emoticons}', "");
Expect(1, 128591, '\P{^Block=	Emoticons}', "");
Expect(0, 128592, '\p{Block=	Emoticons}', "");
Expect(1, 128592, '\p{^Block=	Emoticons}', "");
Expect(1, 128592, '\P{Block=	Emoticons}', "");
Expect(0, 128592, '\P{^Block=	Emoticons}', "");
Error('\p{Blk=/a/-emoticons}');
Error('\P{Blk=/a/-emoticons}');
Expect(1, 128591, '\p{Blk=emoticons}', "");
Expect(0, 128591, '\p{^Blk=emoticons}', "");
Expect(0, 128591, '\P{Blk=emoticons}', "");
Expect(1, 128591, '\P{^Blk=emoticons}', "");
Expect(0, 128592, '\p{Blk=emoticons}', "");
Expect(1, 128592, '\p{^Blk=emoticons}', "");
Expect(1, 128592, '\P{Blk=emoticons}', "");
Expect(0, 128592, '\P{^Blk=emoticons}', "");
Expect(1, 128591, '\p{Blk=_Emoticons}', "");
Expect(0, 128591, '\p{^Blk=_Emoticons}', "");
Expect(0, 128591, '\P{Blk=_Emoticons}', "");
Expect(1, 128591, '\P{^Blk=_Emoticons}', "");
Expect(0, 128592, '\p{Blk=_Emoticons}', "");
Expect(1, 128592, '\p{^Blk=_Emoticons}', "");
Expect(1, 128592, '\P{Blk=_Emoticons}', "");
Expect(0, 128592, '\P{^Blk=_Emoticons}', "");
Error('\p{Is_Block=	Emoticons:=}');
Error('\P{Is_Block=	Emoticons:=}');
Expect(1, 128591, '\p{Is_Block=emoticons}', "");
Expect(0, 128591, '\p{^Is_Block=emoticons}', "");
Expect(0, 128591, '\P{Is_Block=emoticons}', "");
Expect(1, 128591, '\P{^Is_Block=emoticons}', "");
Expect(0, 128592, '\p{Is_Block=emoticons}', "");
Expect(1, 128592, '\p{^Is_Block=emoticons}', "");
Expect(1, 128592, '\P{Is_Block=emoticons}', "");
Expect(0, 128592, '\P{^Is_Block=emoticons}', "");
Expect(1, 128591, '\p{Is_Block= _EMOTICONS}', "");
Expect(0, 128591, '\p{^Is_Block= _EMOTICONS}', "");
Expect(0, 128591, '\P{Is_Block= _EMOTICONS}', "");
Expect(1, 128591, '\P{^Is_Block= _EMOTICONS}', "");
Expect(0, 128592, '\p{Is_Block= _EMOTICONS}', "");
Expect(1, 128592, '\p{^Is_Block= _EMOTICONS}', "");
Expect(1, 128592, '\P{Is_Block= _EMOTICONS}', "");
Expect(0, 128592, '\P{^Is_Block= _EMOTICONS}', "");
Error('\p{Is_Blk=/a/_-emoticons}');
Error('\P{Is_Blk=/a/_-emoticons}');
Expect(1, 128591, '\p{Is_Blk=emoticons}', "");
Expect(0, 128591, '\p{^Is_Blk=emoticons}', "");
Expect(0, 128591, '\P{Is_Blk=emoticons}', "");
Expect(1, 128591, '\P{^Is_Blk=emoticons}', "");
Expect(0, 128592, '\p{Is_Blk=emoticons}', "");
Expect(1, 128592, '\p{^Is_Blk=emoticons}', "");
Expect(1, 128592, '\P{Is_Blk=emoticons}', "");
Expect(0, 128592, '\P{^Is_Blk=emoticons}', "");
Expect(1, 128591, '\p{Is_Blk=	-emoticons}', "");
Expect(0, 128591, '\p{^Is_Blk=	-emoticons}', "");
Expect(0, 128591, '\P{Is_Blk=	-emoticons}', "");
Expect(1, 128591, '\P{^Is_Blk=	-emoticons}', "");
Expect(0, 128592, '\p{Is_Blk=	-emoticons}', "");
Expect(1, 128592, '\p{^Is_Blk=	-emoticons}', "");
Expect(1, 128592, '\P{Is_Blk=	-emoticons}', "");
Expect(0, 128592, '\P{^Is_Blk=	-emoticons}', "");
Error('\p{Block=_	Enclosed_Alphanumerics/a/}');
Error('\P{Block=_	Enclosed_Alphanumerics/a/}');
Expect(1, 9471, '\p{Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Block=enclosedalphanumerics}', "");
Expect(0, 9472, '\p{Block=enclosedalphanumerics}', "");
Expect(1, 9472, '\p{^Block=enclosedalphanumerics}', "");
Expect(1, 9472, '\P{Block=enclosedalphanumerics}', "");
Expect(0, 9472, '\P{^Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(0, 9471, '\p{^Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(0, 9471, '\P{Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(1, 9471, '\P{^Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(0, 9472, '\p{Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(1, 9472, '\p{^Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(1, 9472, '\P{Block= 	Enclosed_ALPHANUMERICS}', "");
Expect(0, 9472, '\P{^Block= 	Enclosed_ALPHANUMERICS}', "");
Error('\p{Blk=	/a/Enclosed_ALPHANUM}');
Error('\P{Blk=	/a/Enclosed_ALPHANUM}');
Expect(1, 9471, '\p{Blk=enclosedalphanum}', "");
Expect(0, 9471, '\p{^Blk=enclosedalphanum}', "");
Expect(0, 9471, '\P{Blk=enclosedalphanum}', "");
Expect(1, 9471, '\P{^Blk=enclosedalphanum}', "");
Expect(0, 9472, '\p{Blk=enclosedalphanum}', "");
Expect(1, 9472, '\p{^Blk=enclosedalphanum}', "");
Expect(1, 9472, '\P{Blk=enclosedalphanum}', "");
Expect(0, 9472, '\P{^Blk=enclosedalphanum}', "");
Expect(1, 9471, '\p{Blk=  enclosed_Alphanum}', "");
Expect(0, 9471, '\p{^Blk=  enclosed_Alphanum}', "");
Expect(0, 9471, '\P{Blk=  enclosed_Alphanum}', "");
Expect(1, 9471, '\P{^Blk=  enclosed_Alphanum}', "");
Expect(0, 9472, '\p{Blk=  enclosed_Alphanum}', "");
Expect(1, 9472, '\p{^Blk=  enclosed_Alphanum}', "");
Expect(1, 9472, '\P{Blk=  enclosed_Alphanum}', "");
Expect(0, 9472, '\P{^Blk=  enclosed_Alphanum}', "");
Error('\p{Is_Block=/a/-_ENCLOSED_Alphanumerics}');
Error('\P{Is_Block=/a/-_ENCLOSED_Alphanumerics}');
Expect(1, 9471, '\p{Is_Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\p{^Is_Block=enclosedalphanumerics}', "");
Expect(0, 9471, '\P{Is_Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\P{^Is_Block=enclosedalphanumerics}', "");
Expect(0, 9472, '\p{Is_Block=enclosedalphanumerics}', "");
Expect(1, 9472, '\p{^Is_Block=enclosedalphanumerics}', "");
Expect(1, 9472, '\P{Is_Block=enclosedalphanumerics}', "");
Expect(0, 9472, '\P{^Is_Block=enclosedalphanumerics}', "");
Expect(1, 9471, '\p{Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(0, 9471, '\p{^Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(0, 9471, '\P{Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(1, 9471, '\P{^Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(0, 9472, '\p{Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(1, 9472, '\p{^Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(1, 9472, '\P{Is_Block:__Enclosed_ALPHANUMERICS}', "");
Expect(0, 9472, '\P{^Is_Block:__Enclosed_ALPHANUMERICS}', "");
Error('\p{Is_Blk:/a/	Enclosed_ALPHANUM}');
Error('\P{Is_Blk:/a/	Enclosed_ALPHANUM}');
Expect(1, 9471, '\p{Is_Blk:enclosedalphanum}', "");
Expect(0, 9471, '\p{^Is_Blk:enclosedalphanum}', "");
Expect(0, 9471, '\P{Is_Blk:enclosedalphanum}', "");
Expect(1, 9471, '\P{^Is_Blk:enclosedalphanum}', "");
Expect(0, 9472, '\p{Is_Blk:enclosedalphanum}', "");
Expect(1, 9472, '\p{^Is_Blk:enclosedalphanum}', "");
Expect(1, 9472, '\P{Is_Blk:enclosedalphanum}', "");
Expect(0, 9472, '\P{^Is_Blk:enclosedalphanum}', "");
Expect(1, 9471, '\p{Is_Blk=Enclosed_Alphanum}', "");
Expect(0, 9471, '\p{^Is_Blk=Enclosed_Alphanum}', "");
Expect(0, 9471, '\P{Is_Blk=Enclosed_Alphanum}', "");
Expect(1, 9471, '\P{^Is_Blk=Enclosed_Alphanum}', "");
Expect(0, 9472, '\p{Is_Blk=Enclosed_Alphanum}', "");
Expect(1, 9472, '\p{^Is_Blk=Enclosed_Alphanum}', "");
Expect(1, 9472, '\P{Is_Blk=Enclosed_Alphanum}', "");
Expect(0, 9472, '\P{^Is_Blk=Enclosed_Alphanum}', "");
Error('\p{Block=_ENCLOSED_ALPHANUMERIC_SUPPLEMENT/a/}');
Error('\P{Block=_ENCLOSED_ALPHANUMERIC_SUPPLEMENT/a/}');
Expect(1, 127487, '\p{Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Block=enclosedalphanumericsupplement}', "");
Expect(0, 127488, '\p{Block=enclosedalphanumericsupplement}', "");
Expect(1, 127488, '\p{^Block=enclosedalphanumericsupplement}', "");
Expect(1, 127488, '\P{Block=enclosedalphanumericsupplement}', "");
Expect(0, 127488, '\P{^Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(0, 127487, '\p{^Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(0, 127487, '\P{Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(1, 127487, '\P{^Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(0, 127488, '\p{Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(1, 127488, '\p{^Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(1, 127488, '\P{Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Expect(0, 127488, '\P{^Block=		ENCLOSED_Alphanumeric_Supplement}', "");
Error('\p{Blk=_enclosed_Alphanum_sup:=}');
Error('\P{Blk=_enclosed_Alphanum_sup:=}');
Expect(1, 127487, '\p{Blk=enclosedalphanumsup}', "");
Expect(0, 127487, '\p{^Blk=enclosedalphanumsup}', "");
Expect(0, 127487, '\P{Blk=enclosedalphanumsup}', "");
Expect(1, 127487, '\P{^Blk=enclosedalphanumsup}', "");
Expect(0, 127488, '\p{Blk=enclosedalphanumsup}', "");
Expect(1, 127488, '\p{^Blk=enclosedalphanumsup}', "");
Expect(1, 127488, '\P{Blk=enclosedalphanumsup}', "");
Expect(0, 127488, '\P{^Blk=enclosedalphanumsup}', "");
Expect(1, 127487, '\p{Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(0, 127487, '\p{^Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(0, 127487, '\P{Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(1, 127487, '\P{^Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(0, 127488, '\p{Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(1, 127488, '\p{^Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(1, 127488, '\P{Blk=- enclosed_ALPHANUM_Sup}', "");
Expect(0, 127488, '\P{^Blk=- enclosed_ALPHANUM_Sup}', "");
Error('\p{Is_Block=-/a/Enclosed_Alphanumeric_Supplement}');
Error('\P{Is_Block=-/a/Enclosed_Alphanumeric_Supplement}');
Expect(1, 127487, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127487, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127488, '\p{Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127488, '\p{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127488, '\P{Is_Block=enclosedalphanumericsupplement}', "");
Expect(0, 127488, '\P{^Is_Block=enclosedalphanumericsupplement}', "");
Expect(1, 127487, '\p{Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(0, 127487, '\p{^Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(0, 127487, '\P{Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(1, 127487, '\P{^Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(0, 127488, '\p{Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(1, 127488, '\p{^Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(1, 127488, '\P{Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Expect(0, 127488, '\P{^Is_Block=-_Enclosed_ALPHANUMERIC_Supplement}', "");
Error('\p{Is_Blk=/a/ 	Enclosed_ALPHANUM_Sup}');
Error('\P{Is_Blk=/a/ 	Enclosed_ALPHANUM_Sup}');
Expect(1, 127487, '\p{Is_Blk=enclosedalphanumsup}', "");
Expect(0, 127487, '\p{^Is_Blk=enclosedalphanumsup}', "");
Expect(0, 127487, '\P{Is_Blk=enclosedalphanumsup}', "");
Expect(1, 127487, '\P{^Is_Blk=enclosedalphanumsup}', "");
Expect(0, 127488, '\p{Is_Blk=enclosedalphanumsup}', "");
Expect(1, 127488, '\p{^Is_Blk=enclosedalphanumsup}', "");
Expect(1, 127488, '\P{Is_Blk=enclosedalphanumsup}', "");
Expect(0, 127488, '\P{^Is_Blk=enclosedalphanumsup}', "");
Expect(1, 127487, '\p{Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(0, 127487, '\p{^Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(0, 127487, '\P{Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(1, 127487, '\P{^Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(0, 127488, '\p{Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(1, 127488, '\p{^Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(1, 127488, '\P{Is_Blk=_ enclosed_alphanum_Sup}', "");
Expect(0, 127488, '\P{^Is_Blk=_ enclosed_alphanum_Sup}', "");
Error('\p{Block=-:=Enclosed_CJK_Letters_And_months}');
Error('\P{Block=-:=Enclosed_CJK_Letters_And_months}');
Expect(1, 13055, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(0, 13056, '\p{Block=enclosedcjklettersandmonths}', "");
Expect(1, 13056, '\p{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 13056, '\P{Block=enclosedcjklettersandmonths}', "");
Expect(0, 13056, '\P{^Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(0, 13055, '\p{^Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(0, 13055, '\P{Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(1, 13055, '\P{^Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(0, 13056, '\p{Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(1, 13056, '\p{^Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(1, 13056, '\P{Block=-Enclosed_CJK_letters_And_Months}', "");
Expect(0, 13056, '\P{^Block=-Enclosed_CJK_letters_And_Months}', "");
Error('\p{Blk=-Enclosed_CJK:=}');
Error('\P{Blk=-Enclosed_CJK:=}');
Expect(1, 13055, '\p{Blk: enclosedcjk}', "");
Expect(0, 13055, '\p{^Blk: enclosedcjk}', "");
Expect(0, 13055, '\P{Blk: enclosedcjk}', "");
Expect(1, 13055, '\P{^Blk: enclosedcjk}', "");
Expect(0, 13056, '\p{Blk: enclosedcjk}', "");
Expect(1, 13056, '\p{^Blk: enclosedcjk}', "");
Expect(1, 13056, '\P{Blk: enclosedcjk}', "");
Expect(0, 13056, '\P{^Blk: enclosedcjk}', "");
Expect(1, 13055, '\p{Blk=- Enclosed_CJK}', "");
Expect(0, 13055, '\p{^Blk=- Enclosed_CJK}', "");
Expect(0, 13055, '\P{Blk=- Enclosed_CJK}', "");
Expect(1, 13055, '\P{^Blk=- Enclosed_CJK}', "");
Expect(0, 13056, '\p{Blk=- Enclosed_CJK}', "");
Expect(1, 13056, '\p{^Blk=- Enclosed_CJK}', "");
Expect(1, 13056, '\P{Blk=- Enclosed_CJK}', "");
Expect(0, 13056, '\P{^Blk=- Enclosed_CJK}', "");
Error('\p{Is_Block:	:=	-Enclosed_CJK_letters_And_MONTHS}');
Error('\P{Is_Block:	:=	-Enclosed_CJK_letters_And_MONTHS}');
Expect(1, 13055, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13055, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13056, '\p{Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13056, '\p{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13056, '\P{Is_Block=enclosedcjklettersandmonths}', "");
Expect(0, 13056, '\P{^Is_Block=enclosedcjklettersandmonths}', "");
Expect(1, 13055, '\p{Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(0, 13055, '\p{^Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(0, 13055, '\P{Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(1, 13055, '\P{^Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(0, 13056, '\p{Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(1, 13056, '\p{^Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(1, 13056, '\P{Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Expect(0, 13056, '\P{^Is_Block=-Enclosed_cjk_Letters_And_Months}', "");
Error('\p{Is_Blk=	/a/ENCLOSED_CJK}');
Error('\P{Is_Blk=	/a/ENCLOSED_CJK}');
Expect(1, 13055, '\p{Is_Blk=enclosedcjk}', "");
Expect(0, 13055, '\p{^Is_Blk=enclosedcjk}', "");
Expect(0, 13055, '\P{Is_Blk=enclosedcjk}', "");
Expect(1, 13055, '\P{^Is_Blk=enclosedcjk}', "");
Expect(0, 13056, '\p{Is_Blk=enclosedcjk}', "");
Expect(1, 13056, '\p{^Is_Blk=enclosedcjk}', "");
Expect(1, 13056, '\P{Is_Blk=enclosedcjk}', "");
Expect(0, 13056, '\P{^Is_Blk=enclosedcjk}', "");
Expect(1, 13055, '\p{Is_Blk: 	-enclosed_cjk}', "");
Expect(0, 13055, '\p{^Is_Blk: 	-enclosed_cjk}', "");
Expect(0, 13055, '\P{Is_Blk: 	-enclosed_cjk}', "");
Expect(1, 13055, '\P{^Is_Blk: 	-enclosed_cjk}', "");
Expect(0, 13056, '\p{Is_Blk: 	-enclosed_cjk}', "");
Expect(1, 13056, '\p{^Is_Blk: 	-enclosed_cjk}', "");
Expect(1, 13056, '\P{Is_Blk: 	-enclosed_cjk}', "");
Expect(0, 13056, '\P{^Is_Blk: 	-enclosed_cjk}', "");
Error('\p{Block=:=_ Enclosed_Ideographic_SUPPLEMENT}');
Error('\P{Block=:=_ Enclosed_Ideographic_SUPPLEMENT}');
Expect(1, 127743, '\p{Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Block=enclosedideographicsupplement}', "");
Expect(0, 127744, '\p{Block=enclosedideographicsupplement}', "");
Expect(1, 127744, '\p{^Block=enclosedideographicsupplement}', "");
Expect(1, 127744, '\P{Block=enclosedideographicsupplement}', "");
Expect(0, 127744, '\P{^Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(0, 127743, '\p{^Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(0, 127743, '\P{Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(1, 127743, '\P{^Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(0, 127744, '\p{Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(1, 127744, '\p{^Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(1, 127744, '\P{Block=	-ENCLOSED_ideographic_Supplement}', "");
Expect(0, 127744, '\P{^Block=	-ENCLOSED_ideographic_Supplement}', "");
Error('\p{Blk=/a/ Enclosed_IDEOGRAPHIC_Sup}');
Error('\P{Blk=/a/ Enclosed_IDEOGRAPHIC_Sup}');
Expect(1, 127743, '\p{Blk=enclosedideographicsup}', "");
Expect(0, 127743, '\p{^Blk=enclosedideographicsup}', "");
Expect(0, 127743, '\P{Blk=enclosedideographicsup}', "");
Expect(1, 127743, '\P{^Blk=enclosedideographicsup}', "");
Expect(0, 127744, '\p{Blk=enclosedideographicsup}', "");
Expect(1, 127744, '\p{^Blk=enclosedideographicsup}', "");
Expect(1, 127744, '\P{Blk=enclosedideographicsup}', "");
Expect(0, 127744, '\P{^Blk=enclosedideographicsup}', "");
Expect(1, 127743, '\p{Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(0, 127743, '\p{^Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(0, 127743, '\P{Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(1, 127743, '\P{^Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(0, 127744, '\p{Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(1, 127744, '\p{^Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(1, 127744, '\P{Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Expect(0, 127744, '\P{^Blk= Enclosed_IDEOGRAPHIC_sup}', "");
Error('\p{Is_Block=:=-_Enclosed_Ideographic_SUPPLEMENT}');
Error('\P{Is_Block=:=-_Enclosed_Ideographic_SUPPLEMENT}');
Expect(1, 127743, '\p{Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\p{^Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127743, '\P{Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\P{^Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127744, '\p{Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127744, '\p{^Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127744, '\P{Is_Block=enclosedideographicsupplement}', "");
Expect(0, 127744, '\P{^Is_Block=enclosedideographicsupplement}', "");
Expect(1, 127743, '\p{Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(0, 127743, '\p{^Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(0, 127743, '\P{Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(1, 127743, '\P{^Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(0, 127744, '\p{Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(1, 127744, '\p{^Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(1, 127744, '\P{Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Expect(0, 127744, '\P{^Is_Block=- enclosed_IDEOGRAPHIC_SUPPLEMENT}', "");
Error('\p{Is_Blk=:=Enclosed_Ideographic_Sup}');
Error('\P{Is_Blk=:=Enclosed_Ideographic_Sup}');
Expect(1, 127743, '\p{Is_Blk=enclosedideographicsup}', "");
Expect(0, 127743, '\p{^Is_Blk=enclosedideographicsup}', "");
Expect(0, 127743, '\P{Is_Blk=enclosedideographicsup}', "");
Expect(1, 127743, '\P{^Is_Blk=enclosedideographicsup}', "");
Expect(0, 127744, '\p{Is_Blk=enclosedideographicsup}', "");
Expect(1, 127744, '\p{^Is_Blk=enclosedideographicsup}', "");
Expect(1, 127744, '\P{Is_Blk=enclosedideographicsup}', "");
Expect(0, 127744, '\P{^Is_Blk=enclosedideographicsup}', "");
Expect(1, 127743, '\p{Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(0, 127743, '\p{^Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(0, 127743, '\P{Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(1, 127743, '\P{^Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(0, 127744, '\p{Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(1, 127744, '\p{^Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(1, 127744, '\P{Is_Blk:		Enclosed_Ideographic_Sup}', "");
Expect(0, 127744, '\P{^Is_Blk:		Enclosed_Ideographic_Sup}', "");
Error('\p{Block=/a/ Ethiopic}');
Error('\P{Block=/a/ Ethiopic}');
Expect(1, 4991, '\p{Block=ethiopic}', "");
Expect(0, 4991, '\p{^Block=ethiopic}', "");
Expect(0, 4991, '\P{Block=ethiopic}', "");
Expect(1, 4991, '\P{^Block=ethiopic}', "");
Expect(0, 4992, '\p{Block=ethiopic}', "");
Expect(1, 4992, '\p{^Block=ethiopic}', "");
Expect(1, 4992, '\P{Block=ethiopic}', "");
Expect(0, 4992, '\P{^Block=ethiopic}', "");
Expect(1, 4991, '\p{Block=_	ethiopic}', "");
Expect(0, 4991, '\p{^Block=_	ethiopic}', "");
Expect(0, 4991, '\P{Block=_	ethiopic}', "");
Expect(1, 4991, '\P{^Block=_	ethiopic}', "");
Expect(0, 4992, '\p{Block=_	ethiopic}', "");
Expect(1, 4992, '\p{^Block=_	ethiopic}', "");
Expect(1, 4992, '\P{Block=_	ethiopic}', "");
Expect(0, 4992, '\P{^Block=_	ethiopic}', "");
Error('\p{Blk=- Ethiopic/a/}');
Error('\P{Blk=- Ethiopic/a/}');
Expect(1, 4991, '\p{Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Blk=ethiopic}', "");
Expect(0, 4991, '\P{Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Blk=ethiopic}', "");
Expect(0, 4992, '\p{Blk=ethiopic}', "");
Expect(1, 4992, '\p{^Blk=ethiopic}', "");
Expect(1, 4992, '\P{Blk=ethiopic}', "");
Expect(0, 4992, '\P{^Blk=ethiopic}', "");
Expect(1, 4991, '\p{Blk= ethiopic}', "");
Expect(0, 4991, '\p{^Blk= ethiopic}', "");
Expect(0, 4991, '\P{Blk= ethiopic}', "");
Expect(1, 4991, '\P{^Blk= ethiopic}', "");
Expect(0, 4992, '\p{Blk= ethiopic}', "");
Expect(1, 4992, '\p{^Blk= ethiopic}', "");
Expect(1, 4992, '\P{Blk= ethiopic}', "");
Expect(0, 4992, '\P{^Blk= ethiopic}', "");
Error('\p{Is_Block=/a/_Ethiopic}');
Error('\P{Is_Block=/a/_Ethiopic}');
Expect(1, 4991, '\p{Is_Block=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block=ethiopic}', "");
Expect(0, 4991, '\P{Is_Block=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block=ethiopic}', "");
Expect(0, 4992, '\p{Is_Block=ethiopic}', "");
Expect(1, 4992, '\p{^Is_Block=ethiopic}', "");
Expect(1, 4992, '\P{Is_Block=ethiopic}', "");
Expect(0, 4992, '\P{^Is_Block=ethiopic}', "");
Expect(1, 4991, '\p{Is_Block=	Ethiopic}', "");
Expect(0, 4991, '\p{^Is_Block=	Ethiopic}', "");
Expect(0, 4991, '\P{Is_Block=	Ethiopic}', "");
Expect(1, 4991, '\P{^Is_Block=	Ethiopic}', "");
Expect(0, 4992, '\p{Is_Block=	Ethiopic}', "");
Expect(1, 4992, '\p{^Is_Block=	Ethiopic}', "");
Expect(1, 4992, '\P{Is_Block=	Ethiopic}', "");
Expect(0, 4992, '\P{^Is_Block=	Ethiopic}', "");
Error('\p{Is_Blk::=-_Ethiopic}');
Error('\P{Is_Blk::=-_Ethiopic}');
Expect(1, 4991, '\p{Is_Blk=ethiopic}', "");
Expect(0, 4991, '\p{^Is_Blk=ethiopic}', "");
Expect(0, 4991, '\P{Is_Blk=ethiopic}', "");
Expect(1, 4991, '\P{^Is_Blk=ethiopic}', "");
Expect(0, 4992, '\p{Is_Blk=ethiopic}', "");
Expect(1, 4992, '\p{^Is_Blk=ethiopic}', "");
Expect(1, 4992, '\P{Is_Blk=ethiopic}', "");
Expect(0, 4992, '\P{^Is_Blk=ethiopic}', "");
Expect(1, 4991, '\p{Is_Blk=-Ethiopic}', "");
Expect(0, 4991, '\p{^Is_Blk=-Ethiopic}', "");
Expect(0, 4991, '\P{Is_Blk=-Ethiopic}', "");
Expect(1, 4991, '\P{^Is_Blk=-Ethiopic}', "");
Expect(0, 4992, '\p{Is_Blk=-Ethiopic}', "");
Expect(1, 4992, '\p{^Is_Blk=-Ethiopic}', "");
Expect(1, 4992, '\P{Is_Blk=-Ethiopic}', "");
Expect(0, 4992, '\P{^Is_Blk=-Ethiopic}', "");
Error('\p{Block=_:=ethiopic_EXTENDED}');
Error('\P{Block=_:=ethiopic_EXTENDED}');
Expect(1, 11743, '\p{Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Block=ethiopicextended}', "");
Expect(0, 11744, '\p{Block=ethiopicextended}', "");
Expect(1, 11744, '\p{^Block=ethiopicextended}', "");
Expect(1, 11744, '\P{Block=ethiopicextended}', "");
Expect(0, 11744, '\P{^Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Block=	Ethiopic_Extended}', "");
Expect(0, 11743, '\p{^Block=	Ethiopic_Extended}', "");
Expect(0, 11743, '\P{Block=	Ethiopic_Extended}', "");
Expect(1, 11743, '\P{^Block=	Ethiopic_Extended}', "");
Expect(0, 11744, '\p{Block=	Ethiopic_Extended}', "");
Expect(1, 11744, '\p{^Block=	Ethiopic_Extended}', "");
Expect(1, 11744, '\P{Block=	Ethiopic_Extended}', "");
Expect(0, 11744, '\P{^Block=	Ethiopic_Extended}', "");
Error('\p{Blk=_:=ETHIOPIC_ext}');
Error('\P{Blk=_:=ETHIOPIC_ext}');
Expect(1, 11743, '\p{Blk:	ethiopicext}', "");
Expect(0, 11743, '\p{^Blk:	ethiopicext}', "");
Expect(0, 11743, '\P{Blk:	ethiopicext}', "");
Expect(1, 11743, '\P{^Blk:	ethiopicext}', "");
Expect(0, 11744, '\p{Blk:	ethiopicext}', "");
Expect(1, 11744, '\p{^Blk:	ethiopicext}', "");
Expect(1, 11744, '\P{Blk:	ethiopicext}', "");
Expect(0, 11744, '\P{^Blk:	ethiopicext}', "");
Expect(1, 11743, '\p{Blk=_-ethiopic_Ext}', "");
Expect(0, 11743, '\p{^Blk=_-ethiopic_Ext}', "");
Expect(0, 11743, '\P{Blk=_-ethiopic_Ext}', "");
Expect(1, 11743, '\P{^Blk=_-ethiopic_Ext}', "");
Expect(0, 11744, '\p{Blk=_-ethiopic_Ext}', "");
Expect(1, 11744, '\p{^Blk=_-ethiopic_Ext}', "");
Expect(1, 11744, '\P{Blk=_-ethiopic_Ext}', "");
Expect(0, 11744, '\P{^Blk=_-ethiopic_Ext}', "");
Error('\p{Is_Block=	 Ethiopic_Extended/a/}');
Error('\P{Is_Block=	 Ethiopic_Extended/a/}');
Expect(1, 11743, '\p{Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\p{^Is_Block=ethiopicextended}', "");
Expect(0, 11743, '\P{Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\P{^Is_Block=ethiopicextended}', "");
Expect(0, 11744, '\p{Is_Block=ethiopicextended}', "");
Expect(1, 11744, '\p{^Is_Block=ethiopicextended}', "");
Expect(1, 11744, '\P{Is_Block=ethiopicextended}', "");
Expect(0, 11744, '\P{^Is_Block=ethiopicextended}', "");
Expect(1, 11743, '\p{Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(0, 11743, '\p{^Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(0, 11743, '\P{Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(1, 11743, '\P{^Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(0, 11744, '\p{Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(1, 11744, '\p{^Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(1, 11744, '\P{Is_Block=	ETHIOPIC_EXTENDED}', "");
Expect(0, 11744, '\P{^Is_Block=	ETHIOPIC_EXTENDED}', "");
Error('\p{Is_Blk=/a/-ETHIOPIC_ext}');
Error('\P{Is_Blk=/a/-ETHIOPIC_ext}');
Expect(1, 11743, '\p{Is_Blk=ethiopicext}', "");
Expect(0, 11743, '\p{^Is_Blk=ethiopicext}', "");
Expect(0, 11743, '\P{Is_Blk=ethiopicext}', "");
Expect(1, 11743, '\P{^Is_Blk=ethiopicext}', "");
Expect(0, 11744, '\p{Is_Blk=ethiopicext}', "");
Expect(1, 11744, '\p{^Is_Blk=ethiopicext}', "");
Expect(1, 11744, '\P{Is_Blk=ethiopicext}', "");
Expect(0, 11744, '\P{^Is_Blk=ethiopicext}', "");
Expect(1, 11743, '\p{Is_Blk: -_ETHIOPIC_ext}', "");
Expect(0, 11743, '\p{^Is_Blk: -_ETHIOPIC_ext}', "");
Expect(0, 11743, '\P{Is_Blk: -_ETHIOPIC_ext}', "");
Expect(1, 11743, '\P{^Is_Blk: -_ETHIOPIC_ext}', "");
Expect(0, 11744, '\p{Is_Blk: -_ETHIOPIC_ext}', "");
Expect(1, 11744, '\p{^Is_Blk: -_ETHIOPIC_ext}', "");
Expect(1, 11744, '\P{Is_Blk: -_ETHIOPIC_ext}', "");
Expect(0, 11744, '\P{^Is_Blk: -_ETHIOPIC_ext}', "");
Error('\p{Block=-_Ethiopic_EXTENDED_A:=}');
Error('\P{Block=-_Ethiopic_EXTENDED_A:=}');
Expect(1, 43823, '\p{Block=ethiopicextendeda}', "");
Expect(0, 43823, '\p{^Block=ethiopicextendeda}', "");
Expect(0, 43823, '\P{Block=ethiopicextendeda}', "");
Expect(1, 43823, '\P{^Block=ethiopicextendeda}', "");
Expect(0, 43824, '\p{Block=ethiopicextendeda}', "");
Expect(1, 43824, '\p{^Block=ethiopicextendeda}', "");
Expect(1, 43824, '\P{Block=ethiopicextendeda}', "");
Expect(0, 43824, '\P{^Block=ethiopicextendeda}', "");
Expect(1, 43823, '\p{Block=		ETHIOPIC_extended_a}', "");
Expect(0, 43823, '\p{^Block=		ETHIOPIC_extended_a}', "");
Expect(0, 43823, '\P{Block=		ETHIOPIC_extended_a}', "");
Expect(1, 43823, '\P{^Block=		ETHIOPIC_extended_a}', "");
Expect(0, 43824, '\p{Block=		ETHIOPIC_extended_a}', "");
Expect(1, 43824, '\p{^Block=		ETHIOPIC_extended_a}', "");
Expect(1, 43824, '\P{Block=		ETHIOPIC_extended_a}', "");
Expect(0, 43824, '\P{^Block=		ETHIOPIC_extended_a}', "");
Error('\p{Blk=	Ethiopic_EXT_a/a/}');
Error('\P{Blk=	Ethiopic_EXT_a/a/}');
Expect(1, 43823, '\p{Blk=ethiopicexta}', "");
Expect(0, 43823, '\p{^Blk=ethiopicexta}', "");
Expect(0, 43823, '\P{Blk=ethiopicexta}', "");
Expect(1, 43823, '\P{^Blk=ethiopicexta}', "");
Expect(0, 43824, '\p{Blk=ethiopicexta}', "");
Expect(1, 43824, '\p{^Blk=ethiopicexta}', "");
Expect(1, 43824, '\P{Blk=ethiopicexta}', "");
Expect(0, 43824, '\P{^Blk=ethiopicexta}', "");
Expect(1, 43823, '\p{Blk: -ethiopic_ext_A}', "");
Expect(0, 43823, '\p{^Blk: -ethiopic_ext_A}', "");
Expect(0, 43823, '\P{Blk: -ethiopic_ext_A}', "");
Expect(1, 43823, '\P{^Blk: -ethiopic_ext_A}', "");
Expect(0, 43824, '\p{Blk: -ethiopic_ext_A}', "");
Expect(1, 43824, '\p{^Blk: -ethiopic_ext_A}', "");
Expect(1, 43824, '\P{Blk: -ethiopic_ext_A}', "");
Expect(0, 43824, '\P{^Blk: -ethiopic_ext_A}', "");
Error('\p{Is_Block:		:=ETHIOPIC_Extended_A}');
Error('\P{Is_Block:		:=ETHIOPIC_Extended_A}');
Expect(1, 43823, '\p{Is_Block=ethiopicextendeda}', "");
Expect(0, 43823, '\p{^Is_Block=ethiopicextendeda}', "");
Expect(0, 43823, '\P{Is_Block=ethiopicextendeda}', "");
Expect(1, 43823, '\P{^Is_Block=ethiopicextendeda}', "");
Expect(0, 43824, '\p{Is_Block=ethiopicextendeda}', "");
Expect(1, 43824, '\p{^Is_Block=ethiopicextendeda}', "");
Expect(1, 43824, '\P{Is_Block=ethiopicextendeda}', "");
Expect(0, 43824, '\P{^Is_Block=ethiopicextendeda}', "");
Expect(1, 43823, '\p{Is_Block=	Ethiopic_extended_A}', "");
Expect(0, 43823, '\p{^Is_Block=	Ethiopic_extended_A}', "");
Expect(0, 43823, '\P{Is_Block=	Ethiopic_extended_A}', "");
Expect(1, 43823, '\P{^Is_Block=	Ethiopic_extended_A}', "");
Expect(0, 43824, '\p{Is_Block=	Ethiopic_extended_A}', "");
Expect(1, 43824, '\p{^Is_Block=	Ethiopic_extended_A}', "");
Expect(1, 43824, '\P{Is_Block=	Ethiopic_extended_A}', "");
Expect(0, 43824, '\P{^Is_Block=	Ethiopic_extended_A}', "");
Error('\p{Is_Blk=_/a/Ethiopic_EXT_A}');
Error('\P{Is_Blk=_/a/Ethiopic_EXT_A}');
Expect(1, 43823, '\p{Is_Blk=ethiopicexta}', "");
Expect(0, 43823, '\p{^Is_Blk=ethiopicexta}', "");
Expect(0, 43823, '\P{Is_Blk=ethiopicexta}', "");
Expect(1, 43823, '\P{^Is_Blk=ethiopicexta}', "");
Expect(0, 43824, '\p{Is_Blk=ethiopicexta}', "");
Expect(1, 43824, '\p{^Is_Blk=ethiopicexta}', "");
Expect(1, 43824, '\P{Is_Blk=ethiopicexta}', "");
Expect(0, 43824, '\P{^Is_Blk=ethiopicexta}', "");
Expect(1, 43823, '\p{Is_Blk=	_ethiopic_EXT_A}', "");
Expect(0, 43823, '\p{^Is_Blk=	_ethiopic_EXT_A}', "");
Expect(0, 43823, '\P{Is_Blk=	_ethiopic_EXT_A}', "");
Expect(1, 43823, '\P{^Is_Blk=	_ethiopic_EXT_A}', "");
Expect(0, 43824, '\p{Is_Blk=	_ethiopic_EXT_A}', "");
Expect(1, 43824, '\p{^Is_Blk=	_ethiopic_EXT_A}', "");
Expect(1, 43824, '\P{Is_Blk=	_ethiopic_EXT_A}', "");
Expect(0, 43824, '\P{^Is_Blk=	_ethiopic_EXT_A}', "");
Error('\p{Block=	/a/ETHIOPIC_supplement}');
Error('\P{Block=	/a/ETHIOPIC_supplement}');
Expect(1, 5023, '\p{Block=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Block=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Block=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Block=ethiopicsupplement}', "");
Expect(0, 5024, '\p{Block=ethiopicsupplement}', "");
Expect(1, 5024, '\p{^Block=ethiopicsupplement}', "");
Expect(1, 5024, '\P{Block=ethiopicsupplement}', "");
Expect(0, 5024, '\P{^Block=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Block: _ ethiopic_Supplement}', "");
Expect(0, 5023, '\p{^Block: _ ethiopic_Supplement}', "");
Expect(0, 5023, '\P{Block: _ ethiopic_Supplement}', "");
Expect(1, 5023, '\P{^Block: _ ethiopic_Supplement}', "");
Expect(0, 5024, '\p{Block: _ ethiopic_Supplement}', "");
Expect(1, 5024, '\p{^Block: _ ethiopic_Supplement}', "");
Expect(1, 5024, '\P{Block: _ ethiopic_Supplement}', "");
Expect(0, 5024, '\P{^Block: _ ethiopic_Supplement}', "");
Error('\p{Blk=_ethiopic_sup/a/}');
Error('\P{Blk=_ethiopic_sup/a/}');
Expect(1, 5023, '\p{Blk=ethiopicsup}', "");
Expect(0, 5023, '\p{^Blk=ethiopicsup}', "");
Expect(0, 5023, '\P{Blk=ethiopicsup}', "");
Expect(1, 5023, '\P{^Blk=ethiopicsup}', "");
Expect(0, 5024, '\p{Blk=ethiopicsup}', "");
Expect(1, 5024, '\p{^Blk=ethiopicsup}', "");
Expect(1, 5024, '\P{Blk=ethiopicsup}', "");
Expect(0, 5024, '\P{^Blk=ethiopicsup}', "");
Expect(1, 5023, '\p{Blk=--ethiopic_SUP}', "");
Expect(0, 5023, '\p{^Blk=--ethiopic_SUP}', "");
Expect(0, 5023, '\P{Blk=--ethiopic_SUP}', "");
Expect(1, 5023, '\P{^Blk=--ethiopic_SUP}', "");
Expect(0, 5024, '\p{Blk=--ethiopic_SUP}', "");
Expect(1, 5024, '\p{^Blk=--ethiopic_SUP}', "");
Expect(1, 5024, '\P{Blk=--ethiopic_SUP}', "");
Expect(0, 5024, '\P{^Blk=--ethiopic_SUP}', "");
Error('\p{Is_Block=-:=ETHIOPIC_SUPPLEMENT}');
Error('\P{Is_Block=-:=ETHIOPIC_SUPPLEMENT}');
Expect(1, 5023, '\p{Is_Block=ethiopicsupplement}', "");
Expect(0, 5023, '\p{^Is_Block=ethiopicsupplement}', "");
Expect(0, 5023, '\P{Is_Block=ethiopicsupplement}', "");
Expect(1, 5023, '\P{^Is_Block=ethiopicsupplement}', "");
Expect(0, 5024, '\p{Is_Block=ethiopicsupplement}', "");
Expect(1, 5024, '\p{^Is_Block=ethiopicsupplement}', "");
Expect(1, 5024, '\P{Is_Block=ethiopicsupplement}', "");
Expect(0, 5024, '\P{^Is_Block=ethiopicsupplement}', "");
Expect(1, 5023, '\p{Is_Block=	_Ethiopic_Supplement}', "");
Expect(0, 5023, '\p{^Is_Block=	_Ethiopic_Supplement}', "");
Expect(0, 5023, '\P{Is_Block=	_Ethiopic_Supplement}', "");
Expect(1, 5023, '\P{^Is_Block=	_Ethiopic_Supplement}', "");
Expect(0, 5024, '\p{Is_Block=	_Ethiopic_Supplement}', "");
Expect(1, 5024, '\p{^Is_Block=	_Ethiopic_Supplement}', "");
Expect(1, 5024, '\P{Is_Block=	_Ethiopic_Supplement}', "");
Expect(0, 5024, '\P{^Is_Block=	_Ethiopic_Supplement}', "");
Error('\p{Is_Blk=:=-	Ethiopic_sup}');
Error('\P{Is_Blk=:=-	Ethiopic_sup}');
Expect(1, 5023, '\p{Is_Blk=ethiopicsup}', "");
Expect(0, 5023, '\p{^Is_Blk=ethiopicsup}', "");
Expect(0, 5023, '\P{Is_Blk=ethiopicsup}', "");
Expect(1, 5023, '\P{^Is_Blk=ethiopicsup}', "");
Expect(0, 5024, '\p{Is_Blk=ethiopicsup}', "");
Expect(1, 5024, '\p{^Is_Blk=ethiopicsup}', "");
Expect(1, 5024, '\P{Is_Blk=ethiopicsup}', "");
Expect(0, 5024, '\P{^Is_Blk=ethiopicsup}', "");
Expect(1, 5023, '\p{Is_Blk=		Ethiopic_sup}', "");
Expect(0, 5023, '\p{^Is_Blk=		Ethiopic_sup}', "");
Expect(0, 5023, '\P{Is_Blk=		Ethiopic_sup}', "");
Expect(1, 5023, '\P{^Is_Blk=		Ethiopic_sup}', "");
Expect(0, 5024, '\p{Is_Blk=		Ethiopic_sup}', "");
Expect(1, 5024, '\p{^Is_Blk=		Ethiopic_sup}', "");
Expect(1, 5024, '\P{Is_Blk=		Ethiopic_sup}', "");
Expect(0, 5024, '\P{^Is_Blk=		Ethiopic_sup}', "");
Error('\p{Block=/a/--Geometric_shapes}');
Error('\P{Block=/a/--Geometric_shapes}');
Expect(1, 9727, '\p{Block: geometricshapes}', "");
Expect(0, 9727, '\p{^Block: geometricshapes}', "");
Expect(0, 9727, '\P{Block: geometricshapes}', "");
Expect(1, 9727, '\P{^Block: geometricshapes}', "");
Expect(0, 9728, '\p{Block: geometricshapes}', "");
Expect(1, 9728, '\p{^Block: geometricshapes}', "");
Expect(1, 9728, '\P{Block: geometricshapes}', "");
Expect(0, 9728, '\P{^Block: geometricshapes}', "");
Expect(1, 9727, '\p{Block=  Geometric_Shapes}', "");
Expect(0, 9727, '\p{^Block=  Geometric_Shapes}', "");
Expect(0, 9727, '\P{Block=  Geometric_Shapes}', "");
Expect(1, 9727, '\P{^Block=  Geometric_Shapes}', "");
Expect(0, 9728, '\p{Block=  Geometric_Shapes}', "");
Expect(1, 9728, '\p{^Block=  Geometric_Shapes}', "");
Expect(1, 9728, '\P{Block=  Geometric_Shapes}', "");
Expect(0, 9728, '\P{^Block=  Geometric_Shapes}', "");
Error('\p{Blk= :=Geometric_shapes}');
Error('\P{Blk= :=Geometric_shapes}');
Expect(1, 9727, '\p{Blk:   geometricshapes}', "");
Expect(0, 9727, '\p{^Blk:   geometricshapes}', "");
Expect(0, 9727, '\P{Blk:   geometricshapes}', "");
Expect(1, 9727, '\P{^Blk:   geometricshapes}', "");
Expect(0, 9728, '\p{Blk:   geometricshapes}', "");
Expect(1, 9728, '\p{^Blk:   geometricshapes}', "");
Expect(1, 9728, '\P{Blk:   geometricshapes}', "");
Expect(0, 9728, '\P{^Blk:   geometricshapes}', "");
Expect(1, 9727, '\p{Blk=_Geometric_Shapes}', "");
Expect(0, 9727, '\p{^Blk=_Geometric_Shapes}', "");
Expect(0, 9727, '\P{Blk=_Geometric_Shapes}', "");
Expect(1, 9727, '\P{^Blk=_Geometric_Shapes}', "");
Expect(0, 9728, '\p{Blk=_Geometric_Shapes}', "");
Expect(1, 9728, '\p{^Blk=_Geometric_Shapes}', "");
Expect(1, 9728, '\P{Blk=_Geometric_Shapes}', "");
Expect(0, 9728, '\P{^Blk=_Geometric_Shapes}', "");
Error('\p{Is_Block=	:=GEOMETRIC_shapes}');
Error('\P{Is_Block=	:=GEOMETRIC_shapes}');
Expect(1, 9727, '\p{Is_Block=geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Block=geometricshapes}', "");
Expect(0, 9727, '\P{Is_Block=geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Block=geometricshapes}', "");
Expect(0, 9728, '\p{Is_Block=geometricshapes}', "");
Expect(1, 9728, '\p{^Is_Block=geometricshapes}', "");
Expect(1, 9728, '\P{Is_Block=geometricshapes}', "");
Expect(0, 9728, '\P{^Is_Block=geometricshapes}', "");
Expect(1, 9727, '\p{Is_Block=_ Geometric_Shapes}', "");
Expect(0, 9727, '\p{^Is_Block=_ Geometric_Shapes}', "");
Expect(0, 9727, '\P{Is_Block=_ Geometric_Shapes}', "");
Expect(1, 9727, '\P{^Is_Block=_ Geometric_Shapes}', "");
Expect(0, 9728, '\p{Is_Block=_ Geometric_Shapes}', "");
Expect(1, 9728, '\p{^Is_Block=_ Geometric_Shapes}', "");
Expect(1, 9728, '\P{Is_Block=_ Geometric_Shapes}', "");
Expect(0, 9728, '\P{^Is_Block=_ Geometric_Shapes}', "");
Error('\p{Is_Blk= :=GEOMETRIC_Shapes}');
Error('\P{Is_Blk= :=GEOMETRIC_Shapes}');
Expect(1, 9727, '\p{Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\p{^Is_Blk=geometricshapes}', "");
Expect(0, 9727, '\P{Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\P{^Is_Blk=geometricshapes}', "");
Expect(0, 9728, '\p{Is_Blk=geometricshapes}', "");
Expect(1, 9728, '\p{^Is_Blk=geometricshapes}', "");
Expect(1, 9728, '\P{Is_Blk=geometricshapes}', "");
Expect(0, 9728, '\P{^Is_Blk=geometricshapes}', "");
Expect(1, 9727, '\p{Is_Blk=--Geometric_Shapes}', "");
Expect(0, 9727, '\p{^Is_Blk=--Geometric_Shapes}', "");
Expect(0, 9727, '\P{Is_Blk=--Geometric_Shapes}', "");
Expect(1, 9727, '\P{^Is_Blk=--Geometric_Shapes}', "");
Expect(0, 9728, '\p{Is_Blk=--Geometric_Shapes}', "");
Expect(1, 9728, '\p{^Is_Blk=--Geometric_Shapes}', "");
Expect(1, 9728, '\P{Is_Blk=--Geometric_Shapes}', "");
Expect(0, 9728, '\P{^Is_Blk=--Geometric_Shapes}', "");
Error('\p{Block=:=--Geometric_shapes_EXTENDED}');
Error('\P{Block=:=--Geometric_shapes_EXTENDED}');
Expect(1, 129023, '\p{Block=geometricshapesextended}', "");
Expect(0, 129023, '\p{^Block=geometricshapesextended}', "");
Expect(0, 129023, '\P{Block=geometricshapesextended}', "");
Expect(1, 129023, '\P{^Block=geometricshapesextended}', "");
Expect(0, 129024, '\p{Block=geometricshapesextended}', "");
Expect(1, 129024, '\p{^Block=geometricshapesextended}', "");
Expect(1, 129024, '\P{Block=geometricshapesextended}', "");
Expect(0, 129024, '\P{^Block=geometricshapesextended}', "");
Expect(1, 129023, '\p{Block=-geometric_SHAPES_Extended}', "");
Expect(0, 129023, '\p{^Block=-geometric_SHAPES_Extended}', "");
Expect(0, 129023, '\P{Block=-geometric_SHAPES_Extended}', "");
Expect(1, 129023, '\P{^Block=-geometric_SHAPES_Extended}', "");
Expect(0, 129024, '\p{Block=-geometric_SHAPES_Extended}', "");
Expect(1, 129024, '\p{^Block=-geometric_SHAPES_Extended}', "");
Expect(1, 129024, '\P{Block=-geometric_SHAPES_Extended}', "");
Expect(0, 129024, '\P{^Block=-geometric_SHAPES_Extended}', "");
Error('\p{Blk=_:=Geometric_SHAPES_ext}');
Error('\P{Blk=_:=Geometric_SHAPES_ext}');
Expect(1, 129023, '\p{Blk=geometricshapesext}', "");
Expect(0, 129023, '\p{^Blk=geometricshapesext}', "");
Expect(0, 129023, '\P{Blk=geometricshapesext}', "");
Expect(1, 129023, '\P{^Blk=geometricshapesext}', "");
Expect(0, 129024, '\p{Blk=geometricshapesext}', "");
Expect(1, 129024, '\p{^Blk=geometricshapesext}', "");
Expect(1, 129024, '\P{Blk=geometricshapesext}', "");
Expect(0, 129024, '\P{^Blk=geometricshapesext}', "");
Expect(1, 129023, '\p{Blk= 	Geometric_SHAPES_EXT}', "");
Expect(0, 129023, '\p{^Blk= 	Geometric_SHAPES_EXT}', "");
Expect(0, 129023, '\P{Blk= 	Geometric_SHAPES_EXT}', "");
Expect(1, 129023, '\P{^Blk= 	Geometric_SHAPES_EXT}', "");
Expect(0, 129024, '\p{Blk= 	Geometric_SHAPES_EXT}', "");
Expect(1, 129024, '\p{^Blk= 	Geometric_SHAPES_EXT}', "");
Expect(1, 129024, '\P{Blk= 	Geometric_SHAPES_EXT}', "");
Expect(0, 129024, '\P{^Blk= 	Geometric_SHAPES_EXT}', "");
Error('\p{Is_Block=:=-_GEOMETRIC_SHAPES_extended}');
Error('\P{Is_Block=:=-_GEOMETRIC_SHAPES_extended}');
Expect(1, 129023, '\p{Is_Block=geometricshapesextended}', "");
Expect(0, 129023, '\p{^Is_Block=geometricshapesextended}', "");
Expect(0, 129023, '\P{Is_Block=geometricshapesextended}', "");
Expect(1, 129023, '\P{^Is_Block=geometricshapesextended}', "");
Expect(0, 129024, '\p{Is_Block=geometricshapesextended}', "");
Expect(1, 129024, '\p{^Is_Block=geometricshapesextended}', "");
Expect(1, 129024, '\P{Is_Block=geometricshapesextended}', "");
Expect(0, 129024, '\P{^Is_Block=geometricshapesextended}', "");
Expect(1, 129023, '\p{Is_Block=	Geometric_Shapes_Extended}', "");
Expect(0, 129023, '\p{^Is_Block=	Geometric_Shapes_Extended}', "");
Expect(0, 129023, '\P{Is_Block=	Geometric_Shapes_Extended}', "");
Expect(1, 129023, '\P{^Is_Block=	Geometric_Shapes_Extended}', "");
Expect(0, 129024, '\p{Is_Block=	Geometric_Shapes_Extended}', "");
Expect(1, 129024, '\p{^Is_Block=	Geometric_Shapes_Extended}', "");
Expect(1, 129024, '\P{Is_Block=	Geometric_Shapes_Extended}', "");
Expect(0, 129024, '\P{^Is_Block=	Geometric_Shapes_Extended}', "");
Error('\p{Is_Blk=_ Geometric_Shapes_Ext:=}');
Error('\P{Is_Blk=_ Geometric_Shapes_Ext:=}');
Expect(1, 129023, '\p{Is_Blk=geometricshapesext}', "");
Expect(0, 129023, '\p{^Is_Blk=geometricshapesext}', "");
Expect(0, 129023, '\P{Is_Blk=geometricshapesext}', "");
Expect(1, 129023, '\P{^Is_Blk=geometricshapesext}', "");
Expect(0, 129024, '\p{Is_Blk=geometricshapesext}', "");
Expect(1, 129024, '\p{^Is_Blk=geometricshapesext}', "");
Expect(1, 129024, '\P{Is_Blk=geometricshapesext}', "");
Expect(0, 129024, '\P{^Is_Blk=geometricshapesext}', "");
Expect(1, 129023, '\p{Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(0, 129023, '\p{^Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(0, 129023, '\P{Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(1, 129023, '\P{^Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(0, 129024, '\p{Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(1, 129024, '\p{^Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(1, 129024, '\P{Is_Blk=_Geometric_Shapes_EXT}', "");
Expect(0, 129024, '\P{^Is_Blk=_Geometric_Shapes_EXT}', "");
Error('\p{Block=	:=Georgian}');
Error('\P{Block=	:=Georgian}');
Expect(1, 4351, '\p{Block=georgian}', "");
Expect(0, 4351, '\p{^Block=georgian}', "");
Expect(0, 4351, '\P{Block=georgian}', "");
Expect(1, 4351, '\P{^Block=georgian}', "");
Expect(0, 4352, '\p{Block=georgian}', "");
Expect(1, 4352, '\p{^Block=georgian}', "");
Expect(1, 4352, '\P{Block=georgian}', "");
Expect(0, 4352, '\P{^Block=georgian}', "");
Expect(1, 4351, '\p{Block: Georgian}', "");
Expect(0, 4351, '\p{^Block: Georgian}', "");
Expect(0, 4351, '\P{Block: Georgian}', "");
Expect(1, 4351, '\P{^Block: Georgian}', "");
Expect(0, 4352, '\p{Block: Georgian}', "");
Expect(1, 4352, '\p{^Block: Georgian}', "");
Expect(1, 4352, '\P{Block: Georgian}', "");
Expect(0, 4352, '\P{^Block: Georgian}', "");
Error('\p{Blk=:=	Georgian}');
Error('\P{Blk=:=	Georgian}');
Expect(1, 4351, '\p{Blk=georgian}', "");
Expect(0, 4351, '\p{^Blk=georgian}', "");
Expect(0, 4351, '\P{Blk=georgian}', "");
Expect(1, 4351, '\P{^Blk=georgian}', "");
Expect(0, 4352, '\p{Blk=georgian}', "");
Expect(1, 4352, '\p{^Blk=georgian}', "");
Expect(1, 4352, '\P{Blk=georgian}', "");
Expect(0, 4352, '\P{^Blk=georgian}', "");
Expect(1, 4351, '\p{Blk=	georgian}', "");
Expect(0, 4351, '\p{^Blk=	georgian}', "");
Expect(0, 4351, '\P{Blk=	georgian}', "");
Expect(1, 4351, '\P{^Blk=	georgian}', "");
Expect(0, 4352, '\p{Blk=	georgian}', "");
Expect(1, 4352, '\p{^Blk=	georgian}', "");
Expect(1, 4352, '\P{Blk=	georgian}', "");
Expect(0, 4352, '\P{^Blk=	georgian}', "");
Error('\p{Is_Block=	/a/georgian}');
Error('\P{Is_Block=	/a/georgian}');
Expect(1, 4351, '\p{Is_Block:   georgian}', "");
Expect(0, 4351, '\p{^Is_Block:   georgian}', "");
Expect(0, 4351, '\P{Is_Block:   georgian}', "");
Expect(1, 4351, '\P{^Is_Block:   georgian}', "");
Expect(0, 4352, '\p{Is_Block:   georgian}', "");
Expect(1, 4352, '\p{^Is_Block:   georgian}', "");
Expect(1, 4352, '\P{Is_Block:   georgian}', "");
Expect(0, 4352, '\P{^Is_Block:   georgian}', "");
Expect(1, 4351, '\p{Is_Block:	-georgian}', "");
Expect(0, 4351, '\p{^Is_Block:	-georgian}', "");
Expect(0, 4351, '\P{Is_Block:	-georgian}', "");
Expect(1, 4351, '\P{^Is_Block:	-georgian}', "");
Expect(0, 4352, '\p{Is_Block:	-georgian}', "");
Expect(1, 4352, '\p{^Is_Block:	-georgian}', "");
Expect(1, 4352, '\P{Is_Block:	-georgian}', "");
Expect(0, 4352, '\P{^Is_Block:	-georgian}', "");
Error('\p{Is_Blk=_:=Georgian}');
Error('\P{Is_Blk=_:=Georgian}');
Expect(1, 4351, '\p{Is_Blk=georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=georgian}', "");
Expect(0, 4351, '\P{Is_Blk=georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=georgian}', "");
Expect(0, 4352, '\p{Is_Blk=georgian}', "");
Expect(1, 4352, '\p{^Is_Blk=georgian}', "");
Expect(1, 4352, '\P{Is_Blk=georgian}', "");
Expect(0, 4352, '\P{^Is_Blk=georgian}', "");
Expect(1, 4351, '\p{Is_Blk=	-Georgian}', "");
Expect(0, 4351, '\p{^Is_Blk=	-Georgian}', "");
Expect(0, 4351, '\P{Is_Blk=	-Georgian}', "");
Expect(1, 4351, '\P{^Is_Blk=	-Georgian}', "");
Expect(0, 4352, '\p{Is_Blk=	-Georgian}', "");
Expect(1, 4352, '\p{^Is_Blk=	-Georgian}', "");
Expect(1, 4352, '\P{Is_Blk=	-Georgian}', "");
Expect(0, 4352, '\P{^Is_Blk=	-Georgian}', "");
Error('\p{Block=/a/_	Georgian_SUPPLEMENT}');
Error('\P{Block=/a/_	Georgian_SUPPLEMENT}');
Expect(1, 11567, '\p{Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Block=georgiansupplement}', "");
Expect(0, 11568, '\p{Block=georgiansupplement}', "");
Expect(1, 11568, '\p{^Block=georgiansupplement}', "");
Expect(1, 11568, '\P{Block=georgiansupplement}', "");
Expect(0, 11568, '\P{^Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Block=	_Georgian_Supplement}', "");
Expect(0, 11567, '\p{^Block=	_Georgian_Supplement}', "");
Expect(0, 11567, '\P{Block=	_Georgian_Supplement}', "");
Expect(1, 11567, '\P{^Block=	_Georgian_Supplement}', "");
Expect(0, 11568, '\p{Block=	_Georgian_Supplement}', "");
Expect(1, 11568, '\p{^Block=	_Georgian_Supplement}', "");
Expect(1, 11568, '\P{Block=	_Georgian_Supplement}', "");
Expect(0, 11568, '\P{^Block=	_Georgian_Supplement}', "");
Error('\p{Blk=	 GEORGIAN_Sup/a/}');
Error('\P{Blk=	 GEORGIAN_Sup/a/}');
Expect(1, 11567, '\p{Blk=georgiansup}', "");
Expect(0, 11567, '\p{^Blk=georgiansup}', "");
Expect(0, 11567, '\P{Blk=georgiansup}', "");
Expect(1, 11567, '\P{^Blk=georgiansup}', "");
Expect(0, 11568, '\p{Blk=georgiansup}', "");
Expect(1, 11568, '\p{^Blk=georgiansup}', "");
Expect(1, 11568, '\P{Blk=georgiansup}', "");
Expect(0, 11568, '\P{^Blk=georgiansup}', "");
Expect(1, 11567, '\p{Blk=--Georgian_SUP}', "");
Expect(0, 11567, '\p{^Blk=--Georgian_SUP}', "");
Expect(0, 11567, '\P{Blk=--Georgian_SUP}', "");
Expect(1, 11567, '\P{^Blk=--Georgian_SUP}', "");
Expect(0, 11568, '\p{Blk=--Georgian_SUP}', "");
Expect(1, 11568, '\p{^Blk=--Georgian_SUP}', "");
Expect(1, 11568, '\P{Blk=--Georgian_SUP}', "");
Expect(0, 11568, '\P{^Blk=--Georgian_SUP}', "");
Error('\p{Is_Block=-:=georgian_SUPPLEMENT}');
Error('\P{Is_Block=-:=georgian_SUPPLEMENT}');
Expect(1, 11567, '\p{Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\p{^Is_Block=georgiansupplement}', "");
Expect(0, 11567, '\P{Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\P{^Is_Block=georgiansupplement}', "");
Expect(0, 11568, '\p{Is_Block=georgiansupplement}', "");
Expect(1, 11568, '\p{^Is_Block=georgiansupplement}', "");
Expect(1, 11568, '\P{Is_Block=georgiansupplement}', "");
Expect(0, 11568, '\P{^Is_Block=georgiansupplement}', "");
Expect(1, 11567, '\p{Is_Block:   _georgian_Supplement}', "");
Expect(0, 11567, '\p{^Is_Block:   _georgian_Supplement}', "");
Expect(0, 11567, '\P{Is_Block:   _georgian_Supplement}', "");
Expect(1, 11567, '\P{^Is_Block:   _georgian_Supplement}', "");
Expect(0, 11568, '\p{Is_Block:   _georgian_Supplement}', "");
Expect(1, 11568, '\p{^Is_Block:   _georgian_Supplement}', "");
Expect(1, 11568, '\P{Is_Block:   _georgian_Supplement}', "");
Expect(0, 11568, '\P{^Is_Block:   _georgian_Supplement}', "");
Error('\p{Is_Blk=	/a/georgian_Sup}');
Error('\P{Is_Blk=	/a/georgian_Sup}');
Expect(1, 11567, '\p{Is_Blk=georgiansup}', "");
Expect(0, 11567, '\p{^Is_Blk=georgiansup}', "");
Expect(0, 11567, '\P{Is_Blk=georgiansup}', "");
Expect(1, 11567, '\P{^Is_Blk=georgiansup}', "");
Expect(0, 11568, '\p{Is_Blk=georgiansup}', "");
Expect(1, 11568, '\p{^Is_Blk=georgiansup}', "");
Expect(1, 11568, '\P{Is_Blk=georgiansup}', "");
Expect(0, 11568, '\P{^Is_Blk=georgiansup}', "");
Expect(1, 11567, '\p{Is_Blk=_Georgian_SUP}', "");
Expect(0, 11567, '\p{^Is_Blk=_Georgian_SUP}', "");
Expect(0, 11567, '\P{Is_Blk=_Georgian_SUP}', "");
Expect(1, 11567, '\P{^Is_Blk=_Georgian_SUP}', "");
Expect(0, 11568, '\p{Is_Blk=_Georgian_SUP}', "");
Expect(1, 11568, '\p{^Is_Blk=_Georgian_SUP}', "");
Expect(1, 11568, '\P{Is_Blk=_Georgian_SUP}', "");
Expect(0, 11568, '\P{^Is_Blk=_Georgian_SUP}', "");
Error('\p{Block=:=--Glagolitic}');
Error('\P{Block=:=--Glagolitic}');
Expect(1, 11359, '\p{Block=glagolitic}', "");
Expect(0, 11359, '\p{^Block=glagolitic}', "");
Expect(0, 11359, '\P{Block=glagolitic}', "");
Expect(1, 11359, '\P{^Block=glagolitic}', "");
Expect(0, 11360, '\p{Block=glagolitic}', "");
Expect(1, 11360, '\p{^Block=glagolitic}', "");
Expect(1, 11360, '\P{Block=glagolitic}', "");
Expect(0, 11360, '\P{^Block=glagolitic}', "");
Expect(1, 11359, '\p{Block=	Glagolitic}', "");
Expect(0, 11359, '\p{^Block=	Glagolitic}', "");
Expect(0, 11359, '\P{Block=	Glagolitic}', "");
Expect(1, 11359, '\P{^Block=	Glagolitic}', "");
Expect(0, 11360, '\p{Block=	Glagolitic}', "");
Expect(1, 11360, '\p{^Block=	Glagolitic}', "");
Expect(1, 11360, '\P{Block=	Glagolitic}', "");
Expect(0, 11360, '\P{^Block=	Glagolitic}', "");
Error('\p{Blk=_/a/GLAGOLITIC}');
Error('\P{Blk=_/a/GLAGOLITIC}');
Expect(1, 11359, '\p{Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Blk=glagolitic}', "");
Expect(0, 11359, '\P{Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Blk=glagolitic}', "");
Expect(0, 11360, '\p{Blk=glagolitic}', "");
Expect(1, 11360, '\p{^Blk=glagolitic}', "");
Expect(1, 11360, '\P{Blk=glagolitic}', "");
Expect(0, 11360, '\P{^Blk=glagolitic}', "");
Expect(1, 11359, '\p{Blk= _Glagolitic}', "");
Expect(0, 11359, '\p{^Blk= _Glagolitic}', "");
Expect(0, 11359, '\P{Blk= _Glagolitic}', "");
Expect(1, 11359, '\P{^Blk= _Glagolitic}', "");
Expect(0, 11360, '\p{Blk= _Glagolitic}', "");
Expect(1, 11360, '\p{^Blk= _Glagolitic}', "");
Expect(1, 11360, '\P{Blk= _Glagolitic}', "");
Expect(0, 11360, '\P{^Blk= _Glagolitic}', "");
Error('\p{Is_Block=/a/ 	glagolitic}');
Error('\P{Is_Block=/a/ 	glagolitic}');
Expect(1, 11359, '\p{Is_Block=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block=glagolitic}', "");
Expect(0, 11359, '\P{Is_Block=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block=glagolitic}', "");
Expect(0, 11360, '\p{Is_Block=glagolitic}', "");
Expect(1, 11360, '\p{^Is_Block=glagolitic}', "");
Expect(1, 11360, '\P{Is_Block=glagolitic}', "");
Expect(0, 11360, '\P{^Is_Block=glagolitic}', "");
Expect(1, 11359, '\p{Is_Block= glagolitic}', "");
Expect(0, 11359, '\p{^Is_Block= glagolitic}', "");
Expect(0, 11359, '\P{Is_Block= glagolitic}', "");
Expect(1, 11359, '\P{^Is_Block= glagolitic}', "");
Expect(0, 11360, '\p{Is_Block= glagolitic}', "");
Expect(1, 11360, '\p{^Is_Block= glagolitic}', "");
Expect(1, 11360, '\P{Is_Block= glagolitic}', "");
Expect(0, 11360, '\P{^Is_Block= glagolitic}', "");
Error('\p{Is_Blk=	_GLAGOLITIC:=}');
Error('\P{Is_Blk=	_GLAGOLITIC:=}');
Expect(1, 11359, '\p{Is_Blk=glagolitic}', "");
Expect(0, 11359, '\p{^Is_Blk=glagolitic}', "");
Expect(0, 11359, '\P{Is_Blk=glagolitic}', "");
Expect(1, 11359, '\P{^Is_Blk=glagolitic}', "");
Expect(0, 11360, '\p{Is_Blk=glagolitic}', "");
Expect(1, 11360, '\p{^Is_Blk=glagolitic}', "");
Expect(1, 11360, '\P{Is_Blk=glagolitic}', "");
Expect(0, 11360, '\P{^Is_Blk=glagolitic}', "");
Expect(1, 11359, '\p{Is_Blk=_Glagolitic}', "");
Expect(0, 11359, '\p{^Is_Blk=_Glagolitic}', "");
Expect(0, 11359, '\P{Is_Blk=_Glagolitic}', "");
Expect(1, 11359, '\P{^Is_Blk=_Glagolitic}', "");
Expect(0, 11360, '\p{Is_Blk=_Glagolitic}', "");
Expect(1, 11360, '\p{^Is_Blk=_Glagolitic}', "");
Expect(1, 11360, '\P{Is_Blk=_Glagolitic}', "");
Expect(0, 11360, '\P{^Is_Blk=_Glagolitic}', "");
Error('\p{Block:    :=GOTHIC}');
Error('\P{Block:    :=GOTHIC}');
Expect(1, 66383, '\p{Block:gothic}', "");
Expect(0, 66383, '\p{^Block:gothic}', "");
Expect(0, 66383, '\P{Block:gothic}', "");
Expect(1, 66383, '\P{^Block:gothic}', "");
Expect(0, 66384, '\p{Block:gothic}', "");
Expect(1, 66384, '\p{^Block:gothic}', "");
Expect(1, 66384, '\P{Block:gothic}', "");
Expect(0, 66384, '\P{^Block:gothic}', "");
Expect(1, 66383, '\p{Block=	_GOTHIC}', "");
Expect(0, 66383, '\p{^Block=	_GOTHIC}', "");
Expect(0, 66383, '\P{Block=	_GOTHIC}', "");
Expect(1, 66383, '\P{^Block=	_GOTHIC}', "");
Expect(0, 66384, '\p{Block=	_GOTHIC}', "");
Expect(1, 66384, '\p{^Block=	_GOTHIC}', "");
Expect(1, 66384, '\P{Block=	_GOTHIC}', "");
Expect(0, 66384, '\P{^Block=	_GOTHIC}', "");
Error('\p{Blk=/a/_Gothic}');
Error('\P{Blk=/a/_Gothic}');
Expect(1, 66383, '\p{Blk=gothic}', "");
Expect(0, 66383, '\p{^Blk=gothic}', "");
Expect(0, 66383, '\P{Blk=gothic}', "");
Expect(1, 66383, '\P{^Blk=gothic}', "");
Expect(0, 66384, '\p{Blk=gothic}', "");
Expect(1, 66384, '\p{^Blk=gothic}', "");
Expect(1, 66384, '\P{Blk=gothic}', "");
Expect(0, 66384, '\P{^Blk=gothic}', "");
Expect(1, 66383, '\p{Blk=-	gothic}', "");
Expect(0, 66383, '\p{^Blk=-	gothic}', "");
Expect(0, 66383, '\P{Blk=-	gothic}', "");
Expect(1, 66383, '\P{^Blk=-	gothic}', "");
Expect(0, 66384, '\p{Blk=-	gothic}', "");
Expect(1, 66384, '\p{^Blk=-	gothic}', "");
Expect(1, 66384, '\P{Blk=-	gothic}', "");
Expect(0, 66384, '\P{^Blk=-	gothic}', "");
Error('\p{Is_Block=/a/GOTHIC}');
Error('\P{Is_Block=/a/GOTHIC}');
Expect(1, 66383, '\p{Is_Block:   gothic}', "");
Expect(0, 66383, '\p{^Is_Block:   gothic}', "");
Expect(0, 66383, '\P{Is_Block:   gothic}', "");
Expect(1, 66383, '\P{^Is_Block:   gothic}', "");
Expect(0, 66384, '\p{Is_Block:   gothic}', "");
Expect(1, 66384, '\p{^Is_Block:   gothic}', "");
Expect(1, 66384, '\P{Is_Block:   gothic}', "");
Expect(0, 66384, '\P{^Is_Block:   gothic}', "");
Expect(1, 66383, '\p{Is_Block=	_Gothic}', "");
Expect(0, 66383, '\p{^Is_Block=	_Gothic}', "");
Expect(0, 66383, '\P{Is_Block=	_Gothic}', "");
Expect(1, 66383, '\P{^Is_Block=	_Gothic}', "");
Expect(0, 66384, '\p{Is_Block=	_Gothic}', "");
Expect(1, 66384, '\p{^Is_Block=	_Gothic}', "");
Expect(1, 66384, '\P{Is_Block=	_Gothic}', "");
Expect(0, 66384, '\P{^Is_Block=	_Gothic}', "");
Error('\p{Is_Blk=-:=Gothic}');
Error('\P{Is_Blk=-:=Gothic}');
Expect(1, 66383, '\p{Is_Blk=gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=gothic}', "");
Expect(0, 66383, '\P{Is_Blk=gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=gothic}', "");
Expect(0, 66384, '\p{Is_Blk=gothic}', "");
Expect(1, 66384, '\p{^Is_Blk=gothic}', "");
Expect(1, 66384, '\P{Is_Blk=gothic}', "");
Expect(0, 66384, '\P{^Is_Blk=gothic}', "");
Expect(1, 66383, '\p{Is_Blk=	 Gothic}', "");
Expect(0, 66383, '\p{^Is_Blk=	 Gothic}', "");
Expect(0, 66383, '\P{Is_Blk=	 Gothic}', "");
Expect(1, 66383, '\P{^Is_Blk=	 Gothic}', "");
Expect(0, 66384, '\p{Is_Blk=	 Gothic}', "");
Expect(1, 66384, '\p{^Is_Blk=	 Gothic}', "");
Expect(1, 66384, '\P{Is_Blk=	 Gothic}', "");
Expect(0, 66384, '\P{^Is_Blk=	 Gothic}', "");
Error('\p{Block= _Grantha:=}');
Error('\P{Block= _Grantha:=}');
Expect(1, 70527, '\p{Block:	grantha}', "");
Expect(0, 70527, '\p{^Block:	grantha}', "");
Expect(0, 70527, '\P{Block:	grantha}', "");
Expect(1, 70527, '\P{^Block:	grantha}', "");
Expect(0, 70528, '\p{Block:	grantha}', "");
Expect(1, 70528, '\p{^Block:	grantha}', "");
Expect(1, 70528, '\P{Block:	grantha}', "");
Expect(0, 70528, '\P{^Block:	grantha}', "");
Expect(1, 70527, '\p{Block=	GRANTHA}', "");
Expect(0, 70527, '\p{^Block=	GRANTHA}', "");
Expect(0, 70527, '\P{Block=	GRANTHA}', "");
Expect(1, 70527, '\P{^Block=	GRANTHA}', "");
Expect(0, 70528, '\p{Block=	GRANTHA}', "");
Expect(1, 70528, '\p{^Block=	GRANTHA}', "");
Expect(1, 70528, '\P{Block=	GRANTHA}', "");
Expect(0, 70528, '\P{^Block=	GRANTHA}', "");
Error('\p{Blk=_:=Grantha}');
Error('\P{Blk=_:=Grantha}');
Expect(1, 70527, '\p{Blk=grantha}', "");
Expect(0, 70527, '\p{^Blk=grantha}', "");
Expect(0, 70527, '\P{Blk=grantha}', "");
Expect(1, 70527, '\P{^Blk=grantha}', "");
Expect(0, 70528, '\p{Blk=grantha}', "");
Expect(1, 70528, '\p{^Blk=grantha}', "");
Expect(1, 70528, '\P{Blk=grantha}', "");
Expect(0, 70528, '\P{^Blk=grantha}', "");
Expect(1, 70527, '\p{Blk=__Grantha}', "");
Expect(0, 70527, '\p{^Blk=__Grantha}', "");
Expect(0, 70527, '\P{Blk=__Grantha}', "");
Expect(1, 70527, '\P{^Blk=__Grantha}', "");
Expect(0, 70528, '\p{Blk=__Grantha}', "");
Expect(1, 70528, '\p{^Blk=__Grantha}', "");
Expect(1, 70528, '\P{Blk=__Grantha}', "");
Expect(0, 70528, '\P{^Blk=__Grantha}', "");
Error('\p{Is_Block:	 /a/Grantha}');
Error('\P{Is_Block:	 /a/Grantha}');
Expect(1, 70527, '\p{Is_Block=grantha}', "");
Expect(0, 70527, '\p{^Is_Block=grantha}', "");
Expect(0, 70527, '\P{Is_Block=grantha}', "");
Expect(1, 70527, '\P{^Is_Block=grantha}', "");
Expect(0, 70528, '\p{Is_Block=grantha}', "");
Expect(1, 70528, '\p{^Is_Block=grantha}', "");
Expect(1, 70528, '\P{Is_Block=grantha}', "");
Expect(0, 70528, '\P{^Is_Block=grantha}', "");
Expect(1, 70527, '\p{Is_Block:    -Grantha}', "");
Expect(0, 70527, '\p{^Is_Block:    -Grantha}', "");
Expect(0, 70527, '\P{Is_Block:    -Grantha}', "");
Expect(1, 70527, '\P{^Is_Block:    -Grantha}', "");
Expect(0, 70528, '\p{Is_Block:    -Grantha}', "");
Expect(1, 70528, '\p{^Is_Block:    -Grantha}', "");
Expect(1, 70528, '\P{Is_Block:    -Grantha}', "");
Expect(0, 70528, '\P{^Is_Block:    -Grantha}', "");
Error('\p{Is_Blk=-_grantha:=}');
Error('\P{Is_Blk=-_grantha:=}');
Expect(1, 70527, '\p{Is_Blk=grantha}', "");
Expect(0, 70527, '\p{^Is_Blk=grantha}', "");
Expect(0, 70527, '\P{Is_Blk=grantha}', "");
Expect(1, 70527, '\P{^Is_Blk=grantha}', "");
Expect(0, 70528, '\p{Is_Blk=grantha}', "");
Expect(1, 70528, '\p{^Is_Blk=grantha}', "");
Expect(1, 70528, '\P{Is_Blk=grantha}', "");
Expect(0, 70528, '\P{^Is_Blk=grantha}', "");
Expect(1, 70527, '\p{Is_Blk=	 Grantha}', "");
Expect(0, 70527, '\p{^Is_Blk=	 Grantha}', "");
Expect(0, 70527, '\P{Is_Blk=	 Grantha}', "");
Expect(1, 70527, '\P{^Is_Blk=	 Grantha}', "");
Expect(0, 70528, '\p{Is_Blk=	 Grantha}', "");
Expect(1, 70528, '\p{^Is_Blk=	 Grantha}', "");
Expect(1, 70528, '\P{Is_Blk=	 Grantha}', "");
Expect(0, 70528, '\P{^Is_Blk=	 Grantha}', "");
Error('\p{Block=_:=Greek_And_Coptic}');
Error('\P{Block=_:=Greek_And_Coptic}');
Expect(1, 1023, '\p{Block=greekandcoptic}', "");
Expect(0, 1023, '\p{^Block=greekandcoptic}', "");
Expect(0, 1023, '\P{Block=greekandcoptic}', "");
Expect(1, 1023, '\P{^Block=greekandcoptic}', "");
Expect(0, 1024, '\p{Block=greekandcoptic}', "");
Expect(1, 1024, '\p{^Block=greekandcoptic}', "");
Expect(1, 1024, '\P{Block=greekandcoptic}', "");
Expect(0, 1024, '\P{^Block=greekandcoptic}', "");
Expect(1, 1023, '\p{Block: 	GREEK_And_coptic}', "");
Expect(0, 1023, '\p{^Block: 	GREEK_And_coptic}', "");
Expect(0, 1023, '\P{Block: 	GREEK_And_coptic}', "");
Expect(1, 1023, '\P{^Block: 	GREEK_And_coptic}', "");
Expect(0, 1024, '\p{Block: 	GREEK_And_coptic}', "");
Expect(1, 1024, '\p{^Block: 	GREEK_And_coptic}', "");
Expect(1, 1024, '\P{Block: 	GREEK_And_coptic}', "");
Expect(0, 1024, '\P{^Block: 	GREEK_And_coptic}', "");
Error('\p{Blk= greek:=}');
Error('\P{Blk= greek:=}');
Expect(1, 1023, '\p{Blk=greek}', "");
Expect(0, 1023, '\p{^Blk=greek}', "");
Expect(0, 1023, '\P{Blk=greek}', "");
Expect(1, 1023, '\P{^Blk=greek}', "");
Expect(0, 1024, '\p{Blk=greek}', "");
Expect(1, 1024, '\p{^Blk=greek}', "");
Expect(1, 1024, '\P{Blk=greek}', "");
Expect(0, 1024, '\P{^Blk=greek}', "");
Expect(1, 1023, '\p{Blk=-	GREEK}', "");
Expect(0, 1023, '\p{^Blk=-	GREEK}', "");
Expect(0, 1023, '\P{Blk=-	GREEK}', "");
Expect(1, 1023, '\P{^Blk=-	GREEK}', "");
Expect(0, 1024, '\p{Blk=-	GREEK}', "");
Expect(1, 1024, '\p{^Blk=-	GREEK}', "");
Expect(1, 1024, '\P{Blk=-	GREEK}', "");
Expect(0, 1024, '\P{^Blk=-	GREEK}', "");
Error('\p{Is_Block= _Greek_And_Coptic:=}');
Error('\P{Is_Block= _Greek_And_Coptic:=}');
Expect(1, 1023, '\p{Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\p{^Is_Block=greekandcoptic}', "");
Expect(0, 1023, '\P{Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\P{^Is_Block=greekandcoptic}', "");
Expect(0, 1024, '\p{Is_Block=greekandcoptic}', "");
Expect(1, 1024, '\p{^Is_Block=greekandcoptic}', "");
Expect(1, 1024, '\P{Is_Block=greekandcoptic}', "");
Expect(0, 1024, '\P{^Is_Block=greekandcoptic}', "");
Expect(1, 1023, '\p{Is_Block=__Greek_AND_Coptic}', "");
Expect(0, 1023, '\p{^Is_Block=__Greek_AND_Coptic}', "");
Expect(0, 1023, '\P{Is_Block=__Greek_AND_Coptic}', "");
Expect(1, 1023, '\P{^Is_Block=__Greek_AND_Coptic}', "");
Expect(0, 1024, '\p{Is_Block=__Greek_AND_Coptic}', "");
Expect(1, 1024, '\p{^Is_Block=__Greek_AND_Coptic}', "");
Expect(1, 1024, '\P{Is_Block=__Greek_AND_Coptic}', "");
Expect(0, 1024, '\P{^Is_Block=__Greek_AND_Coptic}', "");
Error('\p{Is_Blk=-/a/Greek}');
Error('\P{Is_Blk=-/a/Greek}');
Expect(1, 1023, '\p{Is_Blk: greek}', "");
Expect(0, 1023, '\p{^Is_Blk: greek}', "");
Expect(0, 1023, '\P{Is_Blk: greek}', "");
Expect(1, 1023, '\P{^Is_Blk: greek}', "");
Expect(0, 1024, '\p{Is_Blk: greek}', "");
Expect(1, 1024, '\p{^Is_Blk: greek}', "");
Expect(1, 1024, '\P{Is_Blk: greek}', "");
Expect(0, 1024, '\P{^Is_Blk: greek}', "");
Expect(1, 1023, '\p{Is_Blk=	greek}', "");
Expect(0, 1023, '\p{^Is_Blk=	greek}', "");
Expect(0, 1023, '\P{Is_Blk=	greek}', "");
Expect(1, 1023, '\P{^Is_Blk=	greek}', "");
Expect(0, 1024, '\p{Is_Blk=	greek}', "");
Expect(1, 1024, '\p{^Is_Blk=	greek}', "");
Expect(1, 1024, '\P{Is_Blk=	greek}', "");
Expect(0, 1024, '\P{^Is_Blk=	greek}', "");
Error('\p{Block=/a/-Greek_EXTENDED}');
Error('\P{Block=/a/-Greek_EXTENDED}');
Expect(1, 8191, '\p{Block=greekextended}', "");
Expect(0, 8191, '\p{^Block=greekextended}', "");
Expect(0, 8191, '\P{Block=greekextended}', "");
Expect(1, 8191, '\P{^Block=greekextended}', "");
Expect(0, 8192, '\p{Block=greekextended}', "");
Expect(1, 8192, '\p{^Block=greekextended}', "");
Expect(1, 8192, '\P{Block=greekextended}', "");
Expect(0, 8192, '\P{^Block=greekextended}', "");
Expect(1, 8191, '\p{Block= GREEK_EXTENDED}', "");
Expect(0, 8191, '\p{^Block= GREEK_EXTENDED}', "");
Expect(0, 8191, '\P{Block= GREEK_EXTENDED}', "");
Expect(1, 8191, '\P{^Block= GREEK_EXTENDED}', "");
Expect(0, 8192, '\p{Block= GREEK_EXTENDED}', "");
Expect(1, 8192, '\p{^Block= GREEK_EXTENDED}', "");
Expect(1, 8192, '\P{Block= GREEK_EXTENDED}', "");
Expect(0, 8192, '\P{^Block= GREEK_EXTENDED}', "");
Error('\p{Blk=	-Greek_Ext:=}');
Error('\P{Blk=	-Greek_Ext:=}');
Expect(1, 8191, '\p{Blk=greekext}', "");
Expect(0, 8191, '\p{^Blk=greekext}', "");
Expect(0, 8191, '\P{Blk=greekext}', "");
Expect(1, 8191, '\P{^Blk=greekext}', "");
Expect(0, 8192, '\p{Blk=greekext}', "");
Expect(1, 8192, '\p{^Blk=greekext}', "");
Expect(1, 8192, '\P{Blk=greekext}', "");
Expect(0, 8192, '\P{^Blk=greekext}', "");
Expect(1, 8191, '\p{Blk=-Greek_Ext}', "");
Expect(0, 8191, '\p{^Blk=-Greek_Ext}', "");
Expect(0, 8191, '\P{Blk=-Greek_Ext}', "");
Expect(1, 8191, '\P{^Blk=-Greek_Ext}', "");
Expect(0, 8192, '\p{Blk=-Greek_Ext}', "");
Expect(1, 8192, '\p{^Blk=-Greek_Ext}', "");
Expect(1, 8192, '\P{Blk=-Greek_Ext}', "");
Expect(0, 8192, '\P{^Blk=-Greek_Ext}', "");
Error('\p{Is_Block=-/a/greek_EXTENDED}');
Error('\P{Is_Block=-/a/greek_EXTENDED}');
Expect(1, 8191, '\p{Is_Block:   greekextended}', "");
Expect(0, 8191, '\p{^Is_Block:   greekextended}', "");
Expect(0, 8191, '\P{Is_Block:   greekextended}', "");
Expect(1, 8191, '\P{^Is_Block:   greekextended}', "");
Expect(0, 8192, '\p{Is_Block:   greekextended}', "");
Expect(1, 8192, '\p{^Is_Block:   greekextended}', "");
Expect(1, 8192, '\P{Is_Block:   greekextended}', "");
Expect(0, 8192, '\P{^Is_Block:   greekextended}', "");
Expect(1, 8191, '\p{Is_Block= Greek_Extended}', "");
Expect(0, 8191, '\p{^Is_Block= Greek_Extended}', "");
Expect(0, 8191, '\P{Is_Block= Greek_Extended}', "");
Expect(1, 8191, '\P{^Is_Block= Greek_Extended}', "");
Expect(0, 8192, '\p{Is_Block= Greek_Extended}', "");
Expect(1, 8192, '\p{^Is_Block= Greek_Extended}', "");
Expect(1, 8192, '\P{Is_Block= Greek_Extended}', "");
Expect(0, 8192, '\P{^Is_Block= Greek_Extended}', "");
Error('\p{Is_Blk=:= _greek_Ext}');
Error('\P{Is_Blk=:= _greek_Ext}');
Expect(1, 8191, '\p{Is_Blk=greekext}', "");
Expect(0, 8191, '\p{^Is_Blk=greekext}', "");
Expect(0, 8191, '\P{Is_Blk=greekext}', "");
Expect(1, 8191, '\P{^Is_Blk=greekext}', "");
Expect(0, 8192, '\p{Is_Blk=greekext}', "");
Expect(1, 8192, '\p{^Is_Blk=greekext}', "");
Expect(1, 8192, '\P{Is_Blk=greekext}', "");
Expect(0, 8192, '\P{^Is_Blk=greekext}', "");
Expect(1, 8191, '\p{Is_Blk=- Greek_ext}', "");
Expect(0, 8191, '\p{^Is_Blk=- Greek_ext}', "");
Expect(0, 8191, '\P{Is_Blk=- Greek_ext}', "");
Expect(1, 8191, '\P{^Is_Blk=- Greek_ext}', "");
Expect(0, 8192, '\p{Is_Blk=- Greek_ext}', "");
Expect(1, 8192, '\p{^Is_Blk=- Greek_ext}', "");
Expect(1, 8192, '\P{Is_Blk=- Greek_ext}', "");
Expect(0, 8192, '\P{^Is_Blk=- Greek_ext}', "");
Error('\p{Block=-_Gujarati:=}');
Error('\P{Block=-_Gujarati:=}');
Expect(1, 2815, '\p{Block=gujarati}', "");
Expect(0, 2815, '\p{^Block=gujarati}', "");
Expect(0, 2815, '\P{Block=gujarati}', "");
Expect(1, 2815, '\P{^Block=gujarati}', "");
Expect(0, 2816, '\p{Block=gujarati}', "");
Expect(1, 2816, '\p{^Block=gujarati}', "");
Expect(1, 2816, '\P{Block=gujarati}', "");
Expect(0, 2816, '\P{^Block=gujarati}', "");
Expect(1, 2815, '\p{Block: 	_Gujarati}', "");
Expect(0, 2815, '\p{^Block: 	_Gujarati}', "");
Expect(0, 2815, '\P{Block: 	_Gujarati}', "");
Expect(1, 2815, '\P{^Block: 	_Gujarati}', "");
Expect(0, 2816, '\p{Block: 	_Gujarati}', "");
Expect(1, 2816, '\p{^Block: 	_Gujarati}', "");
Expect(1, 2816, '\P{Block: 	_Gujarati}', "");
Expect(0, 2816, '\P{^Block: 	_Gujarati}', "");
Error('\p{Blk=/a/_Gujarati}');
Error('\P{Blk=/a/_Gujarati}');
Expect(1, 2815, '\p{Blk=gujarati}', "");
Expect(0, 2815, '\p{^Blk=gujarati}', "");
Expect(0, 2815, '\P{Blk=gujarati}', "");
Expect(1, 2815, '\P{^Blk=gujarati}', "");
Expect(0, 2816, '\p{Blk=gujarati}', "");
Expect(1, 2816, '\p{^Blk=gujarati}', "");
Expect(1, 2816, '\P{Blk=gujarati}', "");
Expect(0, 2816, '\P{^Blk=gujarati}', "");
Expect(1, 2815, '\p{Blk=	 Gujarati}', "");
Expect(0, 2815, '\p{^Blk=	 Gujarati}', "");
Expect(0, 2815, '\P{Blk=	 Gujarati}', "");
Expect(1, 2815, '\P{^Blk=	 Gujarati}', "");
Expect(0, 2816, '\p{Blk=	 Gujarati}', "");
Expect(1, 2816, '\p{^Blk=	 Gujarati}', "");
Expect(1, 2816, '\P{Blk=	 Gujarati}', "");
Expect(0, 2816, '\P{^Blk=	 Gujarati}', "");
Error('\p{Is_Block= :=Gujarati}');
Error('\P{Is_Block= :=Gujarati}');
Expect(1, 2815, '\p{Is_Block=gujarati}', "");
Expect(0, 2815, '\p{^Is_Block=gujarati}', "");
Expect(0, 2815, '\P{Is_Block=gujarati}', "");
Expect(1, 2815, '\P{^Is_Block=gujarati}', "");
Expect(0, 2816, '\p{Is_Block=gujarati}', "");
Expect(1, 2816, '\p{^Is_Block=gujarati}', "");
Expect(1, 2816, '\P{Is_Block=gujarati}', "");
Expect(0, 2816, '\P{^Is_Block=gujarati}', "");
Expect(1, 2815, '\p{Is_Block=-Gujarati}', "");
Expect(0, 2815, '\p{^Is_Block=-Gujarati}', "");
Expect(0, 2815, '\P{Is_Block=-Gujarati}', "");
Expect(1, 2815, '\P{^Is_Block=-Gujarati}', "");
Expect(0, 2816, '\p{Is_Block=-Gujarati}', "");
Expect(1, 2816, '\p{^Is_Block=-Gujarati}', "");
Expect(1, 2816, '\P{Is_Block=-Gujarati}', "");
Expect(0, 2816, '\P{^Is_Block=-Gujarati}', "");
Error('\p{Is_Blk=/a/--Gujarati}');
Error('\P{Is_Blk=/a/--Gujarati}');
Expect(1, 2815, '\p{Is_Blk=gujarati}', "");
Expect(0, 2815, '\p{^Is_Blk=gujarati}', "");
Expect(0, 2815, '\P{Is_Blk=gujarati}', "");
Expect(1, 2815, '\P{^Is_Blk=gujarati}', "");
Expect(0, 2816, '\p{Is_Blk=gujarati}', "");
Expect(1, 2816, '\p{^Is_Blk=gujarati}', "");
Expect(1, 2816, '\P{Is_Blk=gujarati}', "");
Expect(0, 2816, '\P{^Is_Blk=gujarati}', "");
Expect(1, 2815, '\p{Is_Blk=		gujarati}', "");
Expect(0, 2815, '\p{^Is_Blk=		gujarati}', "");
Expect(0, 2815, '\P{Is_Blk=		gujarati}', "");
Expect(1, 2815, '\P{^Is_Blk=		gujarati}', "");
Expect(0, 2816, '\p{Is_Blk=		gujarati}', "");
Expect(1, 2816, '\p{^Is_Blk=		gujarati}', "");
Expect(1, 2816, '\P{Is_Blk=		gujarati}', "");
Expect(0, 2816, '\P{^Is_Blk=		gujarati}', "");
Error('\p{Block=:= Gurmukhi}');
Error('\P{Block=:= Gurmukhi}');
Expect(1, 2687, '\p{Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Block=gurmukhi}', "");
Expect(0, 2687, '\P{Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Block=gurmukhi}', "");
Expect(0, 2688, '\p{Block=gurmukhi}', "");
Expect(1, 2688, '\p{^Block=gurmukhi}', "");
Expect(1, 2688, '\P{Block=gurmukhi}', "");
Expect(0, 2688, '\P{^Block=gurmukhi}', "");
Expect(1, 2687, '\p{Block=__gurmukhi}', "");
Expect(0, 2687, '\p{^Block=__gurmukhi}', "");
Expect(0, 2687, '\P{Block=__gurmukhi}', "");
Expect(1, 2687, '\P{^Block=__gurmukhi}', "");
Expect(0, 2688, '\p{Block=__gurmukhi}', "");
Expect(1, 2688, '\p{^Block=__gurmukhi}', "");
Expect(1, 2688, '\P{Block=__gurmukhi}', "");
Expect(0, 2688, '\P{^Block=__gurmukhi}', "");
Error('\p{Blk=		GURMUKHI:=}');
Error('\P{Blk=		GURMUKHI:=}');
Expect(1, 2687, '\p{Blk=gurmukhi}', "");
Expect(0, 2687, '\p{^Blk=gurmukhi}', "");
Expect(0, 2687, '\P{Blk=gurmukhi}', "");
Expect(1, 2687, '\P{^Blk=gurmukhi}', "");
Expect(0, 2688, '\p{Blk=gurmukhi}', "");
Expect(1, 2688, '\p{^Blk=gurmukhi}', "");
Expect(1, 2688, '\P{Blk=gurmukhi}', "");
Expect(0, 2688, '\P{^Blk=gurmukhi}', "");
Expect(1, 2687, '\p{Blk=_	Gurmukhi}', "");
Expect(0, 2687, '\p{^Blk=_	Gurmukhi}', "");
Expect(0, 2687, '\P{Blk=_	Gurmukhi}', "");
Expect(1, 2687, '\P{^Blk=_	Gurmukhi}', "");
Expect(0, 2688, '\p{Blk=_	Gurmukhi}', "");
Expect(1, 2688, '\p{^Blk=_	Gurmukhi}', "");
Expect(1, 2688, '\P{Blk=_	Gurmukhi}', "");
Expect(0, 2688, '\P{^Blk=_	Gurmukhi}', "");
Error('\p{Is_Block=:=	_Gurmukhi}');
Error('\P{Is_Block=:=	_Gurmukhi}');
Expect(1, 2687, '\p{Is_Block=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block=gurmukhi}', "");
Expect(0, 2688, '\p{Is_Block=gurmukhi}', "");
Expect(1, 2688, '\p{^Is_Block=gurmukhi}', "");
Expect(1, 2688, '\P{Is_Block=gurmukhi}', "");
Expect(0, 2688, '\P{^Is_Block=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Block=_-Gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Block=_-Gurmukhi}', "");
Expect(0, 2687, '\P{Is_Block=_-Gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Block=_-Gurmukhi}', "");
Expect(0, 2688, '\p{Is_Block=_-Gurmukhi}', "");
Expect(1, 2688, '\p{^Is_Block=_-Gurmukhi}', "");
Expect(1, 2688, '\P{Is_Block=_-Gurmukhi}', "");
Expect(0, 2688, '\P{^Is_Block=_-Gurmukhi}', "");
Error('\p{Is_Blk=--Gurmukhi/a/}');
Error('\P{Is_Blk=--Gurmukhi/a/}');
Expect(1, 2687, '\p{Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\p{^Is_Blk=gurmukhi}', "");
Expect(0, 2687, '\P{Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\P{^Is_Blk=gurmukhi}', "");
Expect(0, 2688, '\p{Is_Blk=gurmukhi}', "");
Expect(1, 2688, '\p{^Is_Blk=gurmukhi}', "");
Expect(1, 2688, '\P{Is_Blk=gurmukhi}', "");
Expect(0, 2688, '\P{^Is_Blk=gurmukhi}', "");
Expect(1, 2687, '\p{Is_Blk=- GURMUKHI}', "");
Expect(0, 2687, '\p{^Is_Blk=- GURMUKHI}', "");
Expect(0, 2687, '\P{Is_Blk=- GURMUKHI}', "");
Expect(1, 2687, '\P{^Is_Blk=- GURMUKHI}', "");
Expect(0, 2688, '\p{Is_Blk=- GURMUKHI}', "");
Expect(1, 2688, '\p{^Is_Blk=- GURMUKHI}', "");
Expect(1, 2688, '\P{Is_Blk=- GURMUKHI}', "");
Expect(0, 2688, '\P{^Is_Blk=- GURMUKHI}', "");
Error('\p{Block=/a/halfwidth_And_Fullwidth_Forms}');
Error('\P{Block=/a/halfwidth_And_Fullwidth_Forms}');
Expect(1, 65519, '\p{Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Block=halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Block=halfwidthandfullwidthforms}', "");
Expect(0, 65520, '\p{Block=halfwidthandfullwidthforms}', "");
Expect(1, 65520, '\p{^Block=halfwidthandfullwidthforms}', "");
Expect(1, 65520, '\P{Block=halfwidthandfullwidthforms}', "");
Expect(0, 65520, '\P{^Block=halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Block= -halfwidth_And_fullwidth_forms}', "");
Expect(0, 65519, '\p{^Block= -halfwidth_And_fullwidth_forms}', "");
Expect(0, 65519, '\P{Block= -halfwidth_And_fullwidth_forms}', "");
Expect(1, 65519, '\P{^Block= -halfwidth_And_fullwidth_forms}', "");
Expect(0, 65520, '\p{Block= -halfwidth_And_fullwidth_forms}', "");
Expect(1, 65520, '\p{^Block= -halfwidth_And_fullwidth_forms}', "");
Expect(1, 65520, '\P{Block= -halfwidth_And_fullwidth_forms}', "");
Expect(0, 65520, '\P{^Block= -halfwidth_And_fullwidth_forms}', "");
Error('\p{Blk=- HALF_and_Full_forms:=}');
Error('\P{Blk=- HALF_and_Full_forms:=}');
Expect(1, 65519, '\p{Blk: halfandfullforms}', "");
Expect(0, 65519, '\p{^Blk: halfandfullforms}', "");
Expect(0, 65519, '\P{Blk: halfandfullforms}', "");
Expect(1, 65519, '\P{^Blk: halfandfullforms}', "");
Expect(0, 65520, '\p{Blk: halfandfullforms}', "");
Expect(1, 65520, '\p{^Blk: halfandfullforms}', "");
Expect(1, 65520, '\P{Blk: halfandfullforms}', "");
Expect(0, 65520, '\P{^Blk: halfandfullforms}', "");
Expect(1, 65519, '\p{Blk=_ Half_And_FULL_forms}', "");
Expect(0, 65519, '\p{^Blk=_ Half_And_FULL_forms}', "");
Expect(0, 65519, '\P{Blk=_ Half_And_FULL_forms}', "");
Expect(1, 65519, '\P{^Blk=_ Half_And_FULL_forms}', "");
Expect(0, 65520, '\p{Blk=_ Half_And_FULL_forms}', "");
Expect(1, 65520, '\p{^Blk=_ Half_And_FULL_forms}', "");
Expect(1, 65520, '\P{Blk=_ Half_And_FULL_forms}', "");
Expect(0, 65520, '\P{^Blk=_ Half_And_FULL_forms}', "");
Error('\p{Is_Block=:=Halfwidth_And_Fullwidth_forms}');
Error('\P{Is_Block=:=Halfwidth_And_Fullwidth_forms}');
Expect(1, 65519, '\p{Is_Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\p{^Is_Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65519, '\P{Is_Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\P{^Is_Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65520, '\p{Is_Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65520, '\p{^Is_Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65520, '\P{Is_Block:   halfwidthandfullwidthforms}', "");
Expect(0, 65520, '\P{^Is_Block:   halfwidthandfullwidthforms}', "");
Expect(1, 65519, '\p{Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(0, 65519, '\p{^Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(0, 65519, '\P{Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(1, 65519, '\P{^Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(0, 65520, '\p{Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(1, 65520, '\p{^Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(1, 65520, '\P{Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Expect(0, 65520, '\P{^Is_Block= 	Halfwidth_and_Fullwidth_Forms}', "");
Error('\p{Is_Blk=	-HALF_And_Full_Forms:=}');
Error('\P{Is_Blk=	-HALF_And_Full_Forms:=}');
Expect(1, 65519, '\p{Is_Blk=halfandfullforms}', "");
Expect(0, 65519, '\p{^Is_Blk=halfandfullforms}', "");
Expect(0, 65519, '\P{Is_Blk=halfandfullforms}', "");
Expect(1, 65519, '\P{^Is_Blk=halfandfullforms}', "");
Expect(0, 65520, '\p{Is_Blk=halfandfullforms}', "");
Expect(1, 65520, '\p{^Is_Blk=halfandfullforms}', "");
Expect(1, 65520, '\P{Is_Blk=halfandfullforms}', "");
Expect(0, 65520, '\P{^Is_Blk=halfandfullforms}', "");
Expect(1, 65519, '\p{Is_Blk=- half_and_full_FORMS}', "");
Expect(0, 65519, '\p{^Is_Blk=- half_and_full_FORMS}', "");
Expect(0, 65519, '\P{Is_Blk=- half_and_full_FORMS}', "");
Expect(1, 65519, '\P{^Is_Blk=- half_and_full_FORMS}', "");
Expect(0, 65520, '\p{Is_Blk=- half_and_full_FORMS}', "");
Expect(1, 65520, '\p{^Is_Blk=- half_and_full_FORMS}', "");
Expect(1, 65520, '\P{Is_Blk=- half_and_full_FORMS}', "");
Expect(0, 65520, '\P{^Is_Blk=- half_and_full_FORMS}', "");
Error('\p{Block=-:=Combining_HALF_marks}');
Error('\P{Block=-:=Combining_HALF_marks}');
Expect(1, 65071, '\p{Block:combininghalfmarks}', "");
Expect(0, 65071, '\p{^Block:combininghalfmarks}', "");
Expect(0, 65071, '\P{Block:combininghalfmarks}', "");
Expect(1, 65071, '\P{^Block:combininghalfmarks}', "");
Expect(0, 65072, '\p{Block:combininghalfmarks}', "");
Expect(1, 65072, '\p{^Block:combininghalfmarks}', "");
Expect(1, 65072, '\P{Block:combininghalfmarks}', "");
Expect(0, 65072, '\P{^Block:combininghalfmarks}', "");
Expect(1, 65071, '\p{Block= _Combining_Half_MARKS}', "");
Expect(0, 65071, '\p{^Block= _Combining_Half_MARKS}', "");
Expect(0, 65071, '\P{Block= _Combining_Half_MARKS}', "");
Expect(1, 65071, '\P{^Block= _Combining_Half_MARKS}', "");
Expect(0, 65072, '\p{Block= _Combining_Half_MARKS}', "");
Expect(1, 65072, '\p{^Block= _Combining_Half_MARKS}', "");
Expect(1, 65072, '\P{Block= _Combining_Half_MARKS}', "");
Expect(0, 65072, '\P{^Block= _Combining_Half_MARKS}', "");
Error('\p{Blk=half_marks/a/}');
Error('\P{Blk=half_marks/a/}');
Expect(1, 65071, '\p{Blk=halfmarks}', "");
Expect(0, 65071, '\p{^Blk=halfmarks}', "");
Expect(0, 65071, '\P{Blk=halfmarks}', "");
Expect(1, 65071, '\P{^Blk=halfmarks}', "");
Expect(0, 65072, '\p{Blk=halfmarks}', "");
Expect(1, 65072, '\p{^Blk=halfmarks}', "");
Expect(1, 65072, '\P{Blk=halfmarks}', "");
Expect(0, 65072, '\P{^Blk=halfmarks}', "");
Expect(1, 65071, '\p{Blk=_ HALF_Marks}', "");
Expect(0, 65071, '\p{^Blk=_ HALF_Marks}', "");
Expect(0, 65071, '\P{Blk=_ HALF_Marks}', "");
Expect(1, 65071, '\P{^Blk=_ HALF_Marks}', "");
Expect(0, 65072, '\p{Blk=_ HALF_Marks}', "");
Expect(1, 65072, '\p{^Blk=_ HALF_Marks}', "");
Expect(1, 65072, '\P{Blk=_ HALF_Marks}', "");
Expect(0, 65072, '\P{^Blk=_ HALF_Marks}', "");
Error('\p{Is_Block=-	Combining_HALF_MARKS:=}');
Error('\P{Is_Block=-	Combining_HALF_MARKS:=}');
Expect(1, 65071, '\p{Is_Block=combininghalfmarks}', "");
Expect(0, 65071, '\p{^Is_Block=combininghalfmarks}', "");
Expect(0, 65071, '\P{Is_Block=combininghalfmarks}', "");
Expect(1, 65071, '\P{^Is_Block=combininghalfmarks}', "");
Expect(0, 65072, '\p{Is_Block=combininghalfmarks}', "");
Expect(1, 65072, '\p{^Is_Block=combininghalfmarks}', "");
Expect(1, 65072, '\P{Is_Block=combininghalfmarks}', "");
Expect(0, 65072, '\P{^Is_Block=combininghalfmarks}', "");
Expect(1, 65071, '\p{Is_Block=-Combining_half_marks}', "");
Expect(0, 65071, '\p{^Is_Block=-Combining_half_marks}', "");
Expect(0, 65071, '\P{Is_Block=-Combining_half_marks}', "");
Expect(1, 65071, '\P{^Is_Block=-Combining_half_marks}', "");
Expect(0, 65072, '\p{Is_Block=-Combining_half_marks}', "");
Expect(1, 65072, '\p{^Is_Block=-Combining_half_marks}', "");
Expect(1, 65072, '\P{Is_Block=-Combining_half_marks}', "");
Expect(0, 65072, '\P{^Is_Block=-Combining_half_marks}', "");
Error('\p{Is_Blk=	:=Half_marks}');
Error('\P{Is_Blk=	:=Half_marks}');
Expect(1, 65071, '\p{Is_Blk=halfmarks}', "");
Expect(0, 65071, '\p{^Is_Blk=halfmarks}', "");
Expect(0, 65071, '\P{Is_Blk=halfmarks}', "");
Expect(1, 65071, '\P{^Is_Blk=halfmarks}', "");
Expect(0, 65072, '\p{Is_Blk=halfmarks}', "");
Expect(1, 65072, '\p{^Is_Blk=halfmarks}', "");
Expect(1, 65072, '\P{Is_Blk=halfmarks}', "");
Expect(0, 65072, '\P{^Is_Blk=halfmarks}', "");
Expect(1, 65071, '\p{Is_Blk=_-Half_Marks}', "");
Expect(0, 65071, '\p{^Is_Blk=_-Half_Marks}', "");
Expect(0, 65071, '\P{Is_Blk=_-Half_Marks}', "");
Expect(1, 65071, '\P{^Is_Blk=_-Half_Marks}', "");
Expect(0, 65072, '\p{Is_Blk=_-Half_Marks}', "");
Expect(1, 65072, '\p{^Is_Blk=_-Half_Marks}', "");
Expect(1, 65072, '\P{Is_Blk=_-Half_Marks}', "");
Expect(0, 65072, '\P{^Is_Blk=_-Half_Marks}', "");
Error('\p{Block= HANGUL_Syllables:=}');
Error('\P{Block= HANGUL_Syllables:=}');
Expect(1, 55215, '\p{Block=hangulsyllables}', "");
Expect(0, 55215, '\p{^Block=hangulsyllables}', "");
Expect(0, 55215, '\P{Block=hangulsyllables}', "");
Expect(1, 55215, '\P{^Block=hangulsyllables}', "");
Expect(0, 55216, '\p{Block=hangulsyllables}', "");
Expect(1, 55216, '\p{^Block=hangulsyllables}', "");
Expect(1, 55216, '\P{Block=hangulsyllables}', "");
Expect(0, 55216, '\P{^Block=hangulsyllables}', "");
Expect(1, 55215, '\p{Block=_-Hangul_syllables}', "");
Expect(0, 55215, '\p{^Block=_-Hangul_syllables}', "");
Expect(0, 55215, '\P{Block=_-Hangul_syllables}', "");
Expect(1, 55215, '\P{^Block=_-Hangul_syllables}', "");
Expect(0, 55216, '\p{Block=_-Hangul_syllables}', "");
Expect(1, 55216, '\p{^Block=_-Hangul_syllables}', "");
Expect(1, 55216, '\P{Block=_-Hangul_syllables}', "");
Expect(0, 55216, '\P{^Block=_-Hangul_syllables}', "");
Error('\p{Blk::=_-Hangul}');
Error('\P{Blk::=_-Hangul}');
Expect(1, 55215, '\p{Blk=hangul}', "");
Expect(0, 55215, '\p{^Blk=hangul}', "");
Expect(0, 55215, '\P{Blk=hangul}', "");
Expect(1, 55215, '\P{^Blk=hangul}', "");
Expect(0, 55216, '\p{Blk=hangul}', "");
Expect(1, 55216, '\p{^Blk=hangul}', "");
Expect(1, 55216, '\P{Blk=hangul}', "");
Expect(0, 55216, '\P{^Blk=hangul}', "");
Expect(1, 55215, '\p{Blk:	 Hangul}', "");
Expect(0, 55215, '\p{^Blk:	 Hangul}', "");
Expect(0, 55215, '\P{Blk:	 Hangul}', "");
Expect(1, 55215, '\P{^Blk:	 Hangul}', "");
Expect(0, 55216, '\p{Blk:	 Hangul}', "");
Expect(1, 55216, '\p{^Blk:	 Hangul}', "");
Expect(1, 55216, '\P{Blk:	 Hangul}', "");
Expect(0, 55216, '\P{^Blk:	 H