#include <iostream>

#include "hash.hh"
#include "shared.hh"

/* #include "help.txt.hh" */
static unsigned char helpText[] = {0x55, 0x73, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x6e, 0x69, 0x78, 0x2d, 0x68, 0x61, 0x73, 0x68, 0x20, 0x5b, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x2e, 0x2e, 0x2e, 0x5d, 0x20, 0x5b, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x2e, 0x2e, 0x2e, 0x5d, 0x0a, 0x0a, 0x60, 0x6e, 0x69, 0x78, 0x2d, 0x68, 0x61, 0x73, 0x68, 0x27, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x20, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x20, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2e, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x66, 0x6c, 0x61, 0x74, 0x3a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x62, 0x61, 0x73, 0x65, 0x33, 0x32, 0x3a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x69, 0x6e, 0x20, 0x62, 0x61, 0x73, 0x65, 0x2d, 0x33, 0x32, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x65, 0x78, 0x61, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x20, 0x48, 0x41, 0x53, 0x48, 0x3a, 0x20, 0x75, 0x73, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x48, 0x41, 0x53, 0x48, 0x20, 0x28, 0x22, 0x6d, 0x64, 0x35, 0x22, 0x20, 0x28, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x29, 0x2c, 0x20, 0x22, 0x73, 0x68, 0x61, 0x31, 0x22, 0x2c, 0x20, 0x22, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x29, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x3a, 0x20, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x74, 0x6f, 0x20, 0x31, 0x36, 0x30, 0x20, 0x62, 0x69, 0x74, 0x73, 0x0a, };


using namespace nix;


void printHelp()
{
    std::cout << string((char *) helpText, sizeof helpText);
}


void run(Strings args)
{
    HashType ht = htMD5;
    bool flat = false;
    bool base32 = false;
    bool truncate = false;
    enum { opHash, opTo32, opTo16 } op = opHash;

    Strings ss;

    for (Strings::iterator i = args.begin();
         i != args.end(); i++)
    {
        if (*i == "--flat") flat = true;
        else if (*i == "--base32") base32 = true;
        else if (*i == "--truncate") truncate = true;
        else if (*i == "--type") {
            ++i;
            if (i == args.end()) throw UsageError("`--type' requires an argument");
            ht = parseHashType(*i);
            if (ht == htUnknown)
                throw UsageError(format("unknown hash type `%1%'") % *i);
        }
        else if (*i == "--to-base16") op = opTo16;
        else if (*i == "--to-base32") op = opTo32;
        else ss.push_back(*i);
    }

    if (op == opHash) {
        for (Strings::iterator i = ss.begin(); i != ss.end(); ++i) {
            Hash h = flat ? hashFile(ht, *i) : hashPath(ht, *i);
            if (truncate && h.hashSize > 20) h = compressHash(h, 20);
            std::cout << format("%1%\n") %
                (base32 ? printHash32(h) : printHash(h));
        }
    }

    else {
        for (Strings::iterator i = ss.begin(); i != ss.end(); ++i) {
            Hash h = op == opTo16 ? parseHash32(ht, *i) : parseHash(ht, *i);
            std::cout << format("%1%\n") %
                (op == opTo16 ? printHash(h) : printHash32(h));
        }
    }
}


string programId = "nix-hash";

