/*
 * Lua 5.2 compatibility
 * (c) Reuben Thomas (maintainer) <rrt@sc3d.org> 2010-2012
 * This file is in the public domain.
 *
 * Include this file after Lua headers
*/

#if LUA_VERSION_NUM == 502 || defined(LUA_COMPAT_5_2)
LUA_GNUC_NORETURN
static int luaL_typerror(lua_State *L, int narg, const char *tname)
{
        const char *msg = lua_pushfstring(L, "%s expected, got %s",
                                          tname, luaL_typename(L, narg));
#if     !(__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4))
        return
#endif
	luaL_argerror(L, narg, msg);
}

#if !defined(LUA_COMPAT_5_2)
#define lua_objlen lua_rawlen
#define lua_strlen lua_rawlen
#define luaL_openlib(L,n,l,nup) luaL_setfuncs((L),(l),(nup))
#define luaL_register(L,n,l) (luaL_newlib(L,l))
#endif

#endif
