/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#include "signalRClient/Reconnection.h"
#include "signalRClient/Connection.h"

using Poco::TimerCallback;

//#include <iostream>
//using namespace std;

namespace signalRClient {

Reconnection::Reconnection(Connection* pConnection) 
: pConnection(pConnection)
, waitTime(RECONNECT_TIMEOUT) {

}

Reconnection::Reconnection(Connection* pConnection, long waitTime)
: pConnection(pConnection)
, waitTime(waitTime) {

}

Reconnection::~Reconnection() {
    timer.stop();
}

void Reconnection::setWaitTime(long waitTime) {
    this->waitTime = waitTime;
}

long Reconnection::getWaitTime() {
    return this->waitTime;
}

void Reconnection::onExpire(Timer&) {
    //cout << "Restarting connection" << endl;
    timer.restart(0);
    pConnection->start();

}

void Reconnection::run() {
    timer.stop();
    TimerCallback<Reconnection> callback(*(this), &Reconnection::onExpire);
    //cout << "Waiting for " << waitTime << "ms before restarting connection" << endl;
    timer.setStartInterval(waitTime);
    timer.setPeriodicInterval(waitTime);
    timer.start(callback);
}

}
