/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#include "signalRClient/DiagnosticLogger.h"
#include "signalRClient/Defaults.h"

namespace signalRClient  {

DiagnosticLogger::DiagnosticLogger(const string& name) 
: name(name) 
, level(DIAG_FATAL) 
, logger(Logger::get(name))
, pSplitter(new SplitterChannel)
, LogStream(Logger::get(name)) {

    pCons = new ConsoleChannel;
    pSplitter->addChannel(pCons);

    logger.setChannel(pSplitter);
}

DiagnosticLogger::~DiagnosticLogger() {
    pSplitter->close();
}

DiagnosticLogger& DiagnosticLogger::post(const DIAG_TYPE& type) {
    
    switch (type) {

        case DIAG_FATAL:
            this->fatal() << SIGNALR_DIAG_PREFIX << " (F) ";
        break;
        case DIAG_ERROR:
            this->error() << SIGNALR_DIAG_PREFIX << " (E) ";
        break;
        case DIAG_WARNING:
            this->warning() << SIGNALR_DIAG_PREFIX << " (W) ";
        break;
        case DIAG_INFORMATION:
            this->information() << SIGNALR_DIAG_PREFIX << " (I) ";
        break;
        case DIAG_DEBUG:
            this->debug() << SIGNALR_DIAG_PREFIX << " (D) ";
        break;
        case DIAG_NONE:
        default:
             throw SignalRException("<type> is unknown");
    }

    return *this;
}

void DiagnosticLogger::setFile(const string& filename) {
    this->filename = filename;
    if (pCons)
        pSplitter->removeChannel(pCons);
    AutoPtr<SimpleFileChannel> pFile(new SimpleFileChannel(this->filename));
    pSplitter->addChannel(pFile);
}

}
