/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/
#include "Poco/Net/HTTPSClientSession.h"
#include "signalRClient/ClientSession.h"

using Poco::Net::HTTPSClientSession;

#include <iostream>
using namespace std;

namespace signalRClient {

ClientSession::ClientSession(const string& host, unsigned short port, bool secure) {
    if (secure) {
        pContext = new Context(Context::CLIENT_USE, "", "", "", Context::VERIFY_NONE, 9, false, "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH");
        pSession = new HTTPSClientSession(host, port, pContext);
    } else {
        pSession = new HTTPClientSession(host, port);
    }
}

ClientSession::~ClientSession() {
    delete pSession;
}

HTTPClientSession* ClientSession::getSession() {
    return pSession;
}

}
