/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#ifndef _WEBSOCKETSTRANSPORT
#define _WEBSOCKETSTRANSPORT

#include <string>
#include "Poco/Net/WebSocket.h"

using std::string;
using Poco::Net::WebSocket;

namespace signalRClient {

enum ServerTerminationType {
    stNone = 0,
    stNormal,
    stAbnormal
};

class ConnectionLife;

class WebSocketsTransport : public Transport {

public:
    WebSocketsTransport(Connection* pConnection);
    ~WebSocketsTransport();

    bool doConnect();
    void doDisconnect();
    void doSend(const string& message);

protected:

    void doReceive();
    void doReconnect(const int& serverInitiatedClose);

private:
    WebSocket* pWebSocket;
    ConnectionLife* pConnectionLife;
    bool clientClose;

    string assembleFrames(ServerTerminationType& close);
    bool isKeepAlive(const string& mesg);
};

}

#endif
