/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#ifndef _TRANSPORT
#define _TRANSPORT

#include <string>
#include "Poco/ActiveMethod.h"
#include "Poco/Activity.h"
#include "Poco/JSON/Array.h"
#include "signalRClient/Util.h"

using std::string;
using Poco::ActiveMethod;
using Poco::Activity;
using namespace Poco::JSON;

namespace signalRClient {

class Connection;

enum TransportType {
    tAuto = 0,
    tWebSockets,
    tLongPolling
};

class Transport {

public:
    Transport(const string& name, Connection* pConnection);  
    ~Transport();

    const string& getName() const {
        return this->name;
    }

    virtual bool doConnect() = 0;
    virtual void doDisconnect() = 0;
    virtual void doSend(const string& message) = 0;

    Activity<Transport> asyncReceive;
    ActiveMethod<void, int, Transport> asyncReconnect;

protected:

    virtual void doReceive() = 0;
    virtual void doReconnect(const int& serverInitiatedClose) { }

    Connection* pConnection;
    volatile bool cancel;
    long tId;
    string messageId;
    long initialized;
    Array message;


private:
    const string name;

    friend string createQuery(const Connection* pConnection, const QueryType& queryType);
    friend void processQueryResponse(Connection* pConnection, const QueryType& queryType, istream& data);
    friend void processDataReceived(Transport* pTransport, istream& data);
};

}

#endif
