/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/
#ifndef _SIGREXCEPTION
#define _SIGREXCEPTION

#include <exception>
#include <string>

using std::exception;
using std::string;

namespace signalRClient  {

class SignalRException : public exception {
public:
    SignalRException() {}
    SignalRException(const string& message) : message(message) {}
    ~SignalRException() throw() {}

    void setMessage(const string& message) {
        this->message = message;
    }

    const string& getMessage() const {
        return this->message;
    }

private:
    string message;
};

}

#endif
