/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com


*/

#ifndef _RECONNECTION
#define _RECONNECTION

#include "Poco/Timer.h"
#include "signalRClient/Defaults.h"

using Poco::Timer;

namespace signalRClient {

class Connection;

class Reconnection {

public:
    Reconnection(Connection* pConnection);
    Reconnection(Connection* pConnection, long waitTime);
    ~Reconnection();

    void setWaitTime(long waitTime);
    long getWaitTime();
    virtual void onExpire(Timer&);
    virtual void run();

protected:
    Connection* pConnection;

private:
    long waitTime;
    Timer timer;
};

}

#endif
