/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#ifndef _LONGPOLLINGTRANSPORT
#define _LONGPOLLINGTRANSPORT

#include <string>

#include "Poco/Net/HTTPClientSession.h"
#include "Poco/Activity.h"
#include "Poco/Thread.h"

#include "signalRClient/DiagnosticLogger.h"

using std::string;
using Poco::Net::HTTPClientSession;
using Poco::Thread;
using Poco::Activity;

namespace signalRClient {

class LongPollingTransport : public Transport {

public:
    LongPollingTransport(Connection* pConnection);
    ~LongPollingTransport();

    bool doConnect();
    void doDisconnect();
    void doSend(const string& message);

protected:

    void doReceive();
    bool doReconnect();

private:

    DiagnosticLogger& logger;
};

}

#endif
