/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#ifndef _DIAGLOGGER
#define _DIAGLOGGER

#include <string>
#include <iostream>
#include "Poco/Message.h"
#include "Poco/LogStream.h"
#include "Poco/Logger.h"
#include "Poco/SplitterChannel.h"
#include "Poco/ConsoleChannel.h"
#include "Poco/SimpleFileChannel.h"
#include "Poco/AutoPtr.h"
#include "signalRClient/SignalRException.h"

using std::string;
using std::istream;
using Poco::Message;
using Poco::LogStream;
using Poco::Logger;
using Poco::ConsoleChannel;
using Poco::SimpleFileChannel;
using Poco::SplitterChannel;
using Poco::AutoPtr;

#define DIAG_LEVEL unsigned short
#define DIAG_TYPE DIAG_LEVEL
#define DIAG_NONE 0
#define DIAG_FATAL Message::PRIO_FATAL
#define DIAG_ERROR Message::PRIO_ERROR
#define DIAG_WARNING Message::PRIO_WARNING
#define DIAG_INFORMATION Message::PRIO_INFORMATION
#define DIAG_DEBUG Message::PRIO_DEBUG

namespace signalRClient {

class DiagnosticLogger : public LogStream {

public:
    DiagnosticLogger(const string& name);
    ~DiagnosticLogger();

    void setLevel(const DIAG_LEVEL& level) {
        try {
            switch (level) {
                case DIAG_NONE:
                case DIAG_FATAL:
                case DIAG_ERROR:
                case DIAG_WARNING:
                case DIAG_INFORMATION:
                case DIAG_DEBUG:
                {
                    this->level = level;
                    logger.setLevel(this->level);
                }
                break;
                default:
                   throw SignalRException("<level> is unknown");
            }
        } catch (Poco::Exception& pocoEx) {
            throw SignalRException(pocoEx.displayText());
        }
    }

    const DIAG_LEVEL& getLevel() {
        return level;
    }

    DiagnosticLogger& post(const DIAG_TYPE& type);

    void setFile(const string& filename);

private:
    string name;
    string filename;
    DIAG_LEVEL level;
    Logger& logger;
    AutoPtr<SplitterChannel> pSplitter;
    AutoPtr<ConsoleChannel> pCons;
};

}

#endif
