/*

Copyright 2015, Mentor Graphics Corporation
http://www.mentor.com

*/

#ifndef _CONNECTIONLIFE
#define _CONNECTIONLIFE

#include "Poco/AutoPtr.h"
#include "Poco/Timer.h"
#include "Poco/Timestamp.h"
#include "Poco/Notification.h"
#include "signalRClient/Defaults.h"

using Poco::Timer;
using Poco::Timestamp;
using Poco::AutoPtr;
using Poco::Notification;

namespace signalRClient {

class Connection;

class KeepAliveEvent : public Notification {

};

class ConnectionLife {

public:
    ConnectionLife(Connection* pConnection);
    ~ConnectionLife();

    void start();
    void onCheckLife(Timer&);
    void onKeepAlive(const AutoPtr<KeepAliveEvent>& event);

private:
    Timestamp lastKeepAlive;
    double warnTimeout;
    double checkTimeout;

    Timer timer;
    Connection* pConnection;
    bool slowReported;
};

}

#endif
