/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.28 from the
 * contents of APItest.xs. Do not edit this file, edit APItest.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "APItest.xs"
#define PERL_IN_XS_APITEST

/* We want to be able to test things that aren't API yet. */
#define PERL_EXT

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "fakesdio.h"   /* Causes us to use PerlIO below */

typedef SV *SVREF;
typedef PTR_TBL_t *XS__APItest__PtrTable;

#define croak_fail() croak("fail at " __FILE__ " line %d", __LINE__)
#define croak_fail_ne(h, w) croak("fail %p!=%p at " __FILE__ " line %d", (h), (w), __LINE__)

/* for my_cxt tests */

#define MY_CXT_KEY "XS::APItest::_guts" XS_VERSION

typedef struct {
    int i;
    SV *sv;
    GV *cscgv;
    AV *cscav;
    AV *bhkav;
    bool bhk_record;
    peep_t orig_peep;
    peep_t orig_rpeep;
    int peep_recording;
    AV *peep_recorder;
    AV *rpeep_recorder;
    AV *xop_record;
} my_cxt_t;

START_MY_CXT

MGVTBL vtbl_foo, vtbl_bar;

/* indirect functions to test the [pa]MY_CXT macros */

int
my_cxt_getint_p(pMY_CXT)
{
    return MY_CXT.i;
}

void
my_cxt_setint_p(pMY_CXT_ int i)
{
    MY_CXT.i = i;
}

SV*
my_cxt_getsv_interp_context(void)
{
    dTHX;
    dMY_CXT_INTERP(my_perl);
    return MY_CXT.sv;
}

SV*
my_cxt_getsv_interp(void)
{
    dMY_CXT;
    return MY_CXT.sv;
}

void
my_cxt_setsv_p(SV* sv _pMY_CXT)
{
    MY_CXT.sv = sv;
}


/* from exception.c */
int apitest_exception(int);

/* from core_or_not.inc */
bool sv_setsv_cow_hashkey_core(void);
bool sv_setsv_cow_hashkey_notcore(void);

/* A routine to test hv_delayfree_ent
   (which itself is tested by testing on hv_free_ent  */

typedef void (freeent_function)(pTHX_ HV *, HE *);

void
test_freeent(freeent_function *f) {
    dSP;
    HV *test_hash = newHV();
    HE *victim;
    SV *test_scalar;
    U32 results[4];
    int i;

#ifdef PURIFY
    victim = (HE*)safemalloc(sizeof(HE));
#else
    /* Storing then deleting something should ensure that a hash entry is
       available.  */
    (void) hv_store(test_hash, "", 0, &PL_sv_yes, 0);
    (void) hv_delete(test_hash, "", 0, 0);

    /* We need to "inline" new_he here as it's static, and the functions we
       test expect to be able to call del_HE on the HE  */
    if (!PL_body_roots[HE_SVSLOT])
	croak("PL_he_root is 0");
    victim = (HE*) PL_body_roots[HE_SVSLOT];
    PL_body_roots[HE_SVSLOT] = HeNEXT(victim);
#endif

    victim->hent_hek = Perl_share_hek(aTHX_ "", 0, 0);

    test_scalar = newSV(0);
    SvREFCNT_inc(test_scalar);
    HeVAL(victim) = test_scalar;

    /* Need this little game else we free the temps on the return stack.  */
    results[0] = SvREFCNT(test_scalar);
    SAVETMPS;
    results[1] = SvREFCNT(test_scalar);
    f(aTHX_ test_hash, victim);
    results[2] = SvREFCNT(test_scalar);
    FREETMPS;
    results[3] = SvREFCNT(test_scalar);

    i = 0;
    do {
	mPUSHu(results[i]);
    } while (++i < (int)(sizeof(results)/sizeof(results[0])));

    /* Goodbye to our extra reference.  */
    SvREFCNT_dec(test_scalar);
}


static I32
bitflip_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
	STRLEN len;
	const char *p = SvPV(keysv, len);

	if (len) {
	    SV *newkey = newSV(len);
	    char *new_p = SvPVX(newkey);

	    if (SvUTF8(keysv)) {
		const char *const end = p + len;
		while (p < end) {
		    STRLEN len;
		    UV chr = utf8_to_uvchr_buf((U8 *)p, (U8 *) end, &len);
		    new_p = (char *)uvchr_to_utf8((U8 *)new_p, chr ^ 32);
		    p += len;
		}
		SvUTF8_on(newkey);
	    } else {
		while (len--)
		    *new_p++ = *p++ ^ 32;
	    }
	    *new_p = '\0';
	    SvCUR_set(newkey, SvCUR(keysv));
	    SvPOK_on(newkey);

	    mg->mg_obj = newkey;
	}
    }
    return 0;
}

static I32
rot13_key(pTHX_ IV action, SV *field) {
    MAGIC *mg = mg_find(field, PERL_MAGIC_uvar);
    SV *keysv;
    PERL_UNUSED_ARG(action);
    if (mg && (keysv = mg->mg_obj)) {
	STRLEN len;
	const char *p = SvPV(keysv, len);

	if (len) {
	    SV *newkey = newSV(len);
	    char *new_p = SvPVX(newkey);

	    /* There's a deliberate fencepost error here to loop len + 1 times
	       to copy the trailing \0  */
	    do {
		char new_c = *p++;
		/* Try doing this cleanly and clearly in EBCDIC another way: */
		switch (new_c) {
		case 'A': new_c = 'N'; break;
		case 'B': new_c = 'O'; break;
		case 'C': new_c = 'P'; break;
		case 'D': new_c = 'Q'; break;
		case 'E': new_c = 'R'; break;
		case 'F': new_c = 'S'; break;
		case 'G': new_c = 'T'; break;
		case 'H': new_c = 'U'; break;
		case 'I': new_c = 'V'; break;
		case 'J': new_c = 'W'; break;
		case 'K': new_c = 'X'; break;
		case 'L': new_c = 'Y'; break;
		case 'M': new_c = 'Z'; break;
		case 'N': new_c = 'A'; break;
		case 'O': new_c = 'B'; break;
		case 'P': new_c = 'C'; break;
		case 'Q': new_c = 'D'; break;
		case 'R': new_c = 'E'; break;
		case 'S': new_c = 'F'; break;
		case 'T': new_c = 'G'; break;
		case 'U': new_c = 'H'; break;
		case 'V': new_c = 'I'; break;
		case 'W': new_c = 'J'; break;
		case 'X': new_c = 'K'; break;
		case 'Y': new_c = 'L'; break;
		case 'Z': new_c = 'M'; break;
		case 'a': new_c = 'n'; break;
		case 'b': new_c = 'o'; break;
		case 'c': new_c = 'p'; break;
		case 'd': new_c = 'q'; break;
		case 'e': new_c = 'r'; break;
		case 'f': new_c = 's'; break;
		case 'g': new_c = 't'; break;
		case 'h': new_c = 'u'; break;
		case 'i': new_c = 'v'; break;
		case 'j': new_c = 'w'; break;
		case 'k': new_c = 'x'; break;
		case 'l': new_c = 'y'; break;
		case 'm': new_c = 'z'; break;
		case 'n': new_c = 'a'; break;
		case 'o': new_c = 'b'; break;
		case 'p': new_c = 'c'; break;
		case 'q': new_c = 'd'; break;
		case 'r': new_c = 'e'; break;
		case 's': new_c = 'f'; break;
		case 't': new_c = 'g'; break;
		case 'u': new_c = 'h'; break;
		case 'v': new_c = 'i'; break;
		case 'w': new_c = 'j'; break;
		case 'x': new_c = 'k'; break;
		case 'y': new_c = 'l'; break;
		case 'z': new_c = 'm'; break;
		}
		*new_p++ = new_c;
	    } while (len--);
	    SvCUR_set(newkey, SvCUR(keysv));
	    SvPOK_on(newkey);
	    if (SvUTF8(keysv))
		SvUTF8_on(newkey);

	    mg->mg_obj = newkey;
	}
    }
    return 0;
}

STATIC I32
rmagical_a_dummy(pTHX_ IV idx, SV *sv) {
    PERL_UNUSED_ARG(idx);
    PERL_UNUSED_ARG(sv);
    return 0;
}

/* We could do "= { 0 };" but some versions of gcc do warn
 * (with -Wextra) about missing initializer, this is probably gcc
 * being a bit too paranoid.  But since this is file-static, we can
 * just have it without initializer, since it should get
 * zero-initialized. */
STATIC MGVTBL rmagical_b;

STATIC void
blockhook_csc_start(pTHX_ int full)
{
    dMY_CXT;
    AV *const cur = GvAV(MY_CXT.cscgv);

    PERL_UNUSED_ARG(full);
    SAVEGENERICSV(GvAV(MY_CXT.cscgv));

    if (cur) {
        I32 i;
        AV *const new_av = newAV();

        for (i = 0; i <= av_tindex(cur); i++) {
            av_store(new_av, i, newSVsv(*av_fetch(cur, i, 0)));
        }

        GvAV(MY_CXT.cscgv) = new_av;
    }
}

STATIC void
blockhook_csc_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    /* if we hit the end of a scope we missed the start of, we need to
     * unconditionally clear @CSC */
    if (GvAV(MY_CXT.cscgv) == MY_CXT.cscav && MY_CXT.cscav) {
        av_clear(MY_CXT.cscav);
    }

}

STATIC void
blockhook_test_start(pTHX_ int full)
{
    dMY_CXT;
    AV *av;
    
    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("start"));
        av_push(av, newSViv(full));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC void
blockhook_test_pre_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("pre_end"));
}

STATIC void
blockhook_test_post_end(pTHX_ OP **o)
{
    dMY_CXT;

    PERL_UNUSED_ARG(o);
    if (MY_CXT.bhk_record)
        av_push(MY_CXT.bhkav, newSVpvs("post_end"));
}

STATIC void
blockhook_test_eval(pTHX_ OP *const o)
{
    dMY_CXT;
    AV *av;

    if (MY_CXT.bhk_record) {
        av = newAV();
        av_push(av, newSVpvs("eval"));
        av_push(av, newSVpv(OP_NAME(o), 0));
        av_push(MY_CXT.bhkav, newRV_noinc(MUTABLE_SV(av)));
    }
}

STATIC BHK bhk_csc, bhk_test;

STATIC void
my_peep (pTHX_ OP *o)
{
    dMY_CXT;

    if (!o)
	return;

    MY_CXT.orig_peep(aTHX_ o);

    if (!MY_CXT.peep_recording)
	return;

    for (; o; o = o->op_next) {
	if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
	    av_push(MY_CXT.peep_recorder, newSVsv(cSVOPx_sv(o)));
	}
    }
}

STATIC void
my_rpeep (pTHX_ OP *o)
{
    dMY_CXT;

    if (!o)
	return;

    MY_CXT.orig_rpeep(aTHX_ o);

    if (!MY_CXT.peep_recording)
	return;

    for (; o; o = o->op_next) {
	if (o->op_type == OP_CONST && cSVOPx_sv(o) && SvPOK(cSVOPx_sv(o))) {
	    av_push(MY_CXT.rpeep_recorder, newSVsv(cSVOPx_sv(o)));
	}
    }
}

STATIC OP *
THX_ck_entersub_args_lists(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    return ck_entersub_args_list(entersubop);
}

STATIC OP *
THX_ck_entersub_args_scalars(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *aop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(aop))
	aop = cUNOPx(aop)->op_first;
    for (aop = OpSIBLING(aop); OpHAS_SIBLING(aop); aop = OpSIBLING(aop)) {
	op_contextualize(aop, G_SCALAR);
    }
    return entersubop;
}

STATIC OP *
THX_ck_entersub_multi_sum(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *sumop = NULL;
    OP *parent = entersubop;
    OP *pushop = cUNOPx(entersubop)->op_first;
    PERL_UNUSED_ARG(namegv);
    PERL_UNUSED_ARG(ckobj);
    if (!OpHAS_SIBLING(pushop)) {
        parent = pushop;
	pushop = cUNOPx(pushop)->op_first;
    }
    while (1) {
	OP *aop = OpSIBLING(pushop);
	if (!OpHAS_SIBLING(aop))
	    break;
        /* cut out first arg */
        op_sibling_splice(parent, pushop, 1, NULL);
	op_contextualize(aop, G_SCALAR);
	if (sumop) {
	    sumop = newBINOP(OP_ADD, 0, sumop, aop);
	} else {
	    sumop = aop;
	}
    }
    if (!sumop)
	sumop = newSVOP(OP_CONST, 0, newSViv(0));
    op_free(entersubop);
    return sumop;
}

STATIC void test_op_list_describe_part(SV *res, OP *o);
STATIC void
test_op_list_describe_part(SV *res, OP *o)
{
    sv_catpv(res, PL_op_name[o->op_type]);
    switch (o->op_type) {
	case OP_CONST: {
	    sv_catpvf(res, "(%d)", (int)SvIV(cSVOPx(o)->op_sv));
	} break;
    }
    if (o->op_flags & OPf_KIDS) {
	OP *k;
	sv_catpvs(res, "[");
	for (k = cUNOPx(o)->op_first; k; k = OpSIBLING(k))
	    test_op_list_describe_part(res, k);
	sv_catpvs(res, "]");
    } else {
	sv_catpvs(res, ".");
    }
}

STATIC char *
test_op_list_describe(OP *o)
{
    SV *res = sv_2mortal(newSVpvs(""));
    if (o)
	test_op_list_describe_part(res, o);
    return SvPVX(res);
}

/* the real new*OP functions have a tendency to call fold_constants, and
 * other such unhelpful things, so we need our own versions for testing */

#define mkUNOP(t, f) THX_mkUNOP(aTHX_ (t), (f))
static OP *
THX_mkUNOP(pTHX_ U32 type, OP *first)
{
    UNOP *unop;
    NewOp(1103, unop, 1, UNOP);
    unop->op_type   = (OPCODE)type;
    op_sibling_splice((OP*)unop, NULL, 0, first);
    return (OP *)unop;
}

#define mkBINOP(t, f, l) THX_mkBINOP(aTHX_ (t), (f), (l))
static OP *
THX_mkBINOP(pTHX_ U32 type, OP *first, OP *last)
{
    BINOP *binop;
    NewOp(1103, binop, 1, BINOP);
    binop->op_type      = (OPCODE)type;
    op_sibling_splice((OP*)binop, NULL, 0, last);
    op_sibling_splice((OP*)binop, NULL, 0, first);
    return (OP *)binop;
}

#define mkLISTOP(t, f, s, l) THX_mkLISTOP(aTHX_ (t), (f), (s), (l))
static OP *
THX_mkLISTOP(pTHX_ U32 type, OP *first, OP *sib, OP *last)
{
    LISTOP *listop;
    NewOp(1103, listop, 1, LISTOP);
    listop->op_type     = (OPCODE)type;
    op_sibling_splice((OP*)listop, NULL, 0, last);
    op_sibling_splice((OP*)listop, NULL, 0, sib);
    op_sibling_splice((OP*)listop, NULL, 0, first);
    return (OP *)listop;
}

static char *
test_op_linklist_describe(OP *start)
{
    SV *rv = sv_2mortal(newSVpvs(""));
    OP *o;
    o = start = LINKLIST(start);
    do {
        sv_catpvs(rv, ".");
        sv_catpv(rv, OP_NAME(o));
        if (o->op_type == OP_CONST)
            sv_catsv(rv, cSVOPo->op_sv);
        o = o->op_next;
    } while (o && o != start);
    return SvPVX(rv);
}

/** establish_cleanup operator, ripped off from Scope::Cleanup **/

STATIC void
THX_run_cleanup(pTHX_ void *cleanup_code_ref)
{
    dSP;
    PUSHSTACK;
    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    call_sv((SV*)cleanup_code_ref, G_VOID|G_DISCARD);
    FREETMPS;
    LEAVE;
    POPSTACK;
}

STATIC OP *
THX_pp_establish_cleanup(pTHX)
{
    dSP;
    SV *cleanup_code_ref;
    cleanup_code_ref = newSVsv(POPs);
    SAVEFREESV(cleanup_code_ref);
    SAVEDESTRUCTOR_X(THX_run_cleanup, cleanup_code_ref);
    if(GIMME_V != G_VOID) PUSHs(&PL_sv_undef);
    RETURN;
}

STATIC OP *
THX_ck_entersub_establish_cleanup(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop, *estop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    /* extract out first arg, then delete the rest of the tree */
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);

    estop = mkUNOP(OP_RAND, argop);
    estop->op_ppaddr = THX_pp_establish_cleanup;
    PL_hints |= HINT_BLOCK_SCOPE;
    return estop;
}

STATIC OP *
THX_ck_entersub_postinc(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *parent, *pushop, *argop;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    parent = entersubop;
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop)) {
        parent = pushop;
        pushop = cUNOPx(pushop)->op_first;
    }
    argop = OpSIBLING(pushop);
    op_sibling_splice(parent, pushop, 1, NULL);
    op_free(entersubop);
    return newUNOP(OP_POSTINC, 0,
	op_lvalue(op_contextualize(argop, G_SCALAR), OP_POSTINC));
}

STATIC OP *
THX_ck_entersub_pad_scalar(pTHX_ OP *entersubop, GV *namegv, SV *ckobj)
{
    OP *pushop, *argop;
    PADOFFSET padoff = NOT_IN_PAD;
    SV *a0, *a1;
    ck_entersub_args_proto(entersubop, namegv, ckobj);
    pushop = cUNOPx(entersubop)->op_first;
    if(!OpHAS_SIBLING(pushop))
        pushop = cUNOPx(pushop)->op_first;
    argop = OpSIBLING(pushop);
    if(argop->op_type != OP_CONST || OpSIBLING(argop)->op_type != OP_CONST)
	croak("bad argument expression type for pad_scalar()");
    a0 = cSVOPx_sv(argop);
    a1 = cSVOPx_sv(OpSIBLING(argop));
    switch(SvIV(a0)) {
	case 1: {
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    padoff = pad_findmy_sv(namesv, 0);
	} break;
	case 2: {
	    char *namepv;
	    STRLEN namelen;
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    namepv = SvPV(namesv, namelen);
	    padoff = pad_findmy_pvn(namepv, namelen, SvUTF8(namesv));
	} break;
	case 3: {
	    char *namepv;
	    SV *namesv = sv_2mortal(newSVpvs("$"));
	    sv_catsv(namesv, a1);
	    namepv = SvPV_nolen(namesv);
	    padoff = pad_findmy_pv(namepv, SvUTF8(namesv));
	} break;
	case 4: {
	    padoff = pad_findmy_pvs("$foo", 0);
	} break;
	default: croak("bad type value for pad_scalar()");
    }
    op_free(entersubop);
    if(padoff == NOT_IN_PAD) {
	return newSVOP(OP_CONST, 0, newSVpvs("NOT_IN_PAD"));
    } else if(PAD_COMPNAME_FLAGS_isOUR(padoff)) {
	return newSVOP(OP_CONST, 0, newSVpvs("NOT_MY"));
    } else {
	OP *padop = newOP(OP_PADSV, 0);
	padop->op_targ = padoff;
	return padop;
    }
}

/** RPN keyword parser **/

#define sv_is_glob(sv) (SvTYPE(sv) == SVt_PVGV)
#define sv_is_regexp(sv) (SvTYPE(sv) == SVt_REGEXP)
#define sv_is_string(sv) \
    (!sv_is_glob(sv) && !sv_is_regexp(sv) && \
     (SvFLAGS(sv) & (SVf_IOK|SVf_NOK|SVf_POK|SVp_IOK|SVp_NOK|SVp_POK)))

static SV *hintkey_rpn_sv, *hintkey_calcrpn_sv, *hintkey_stufftest_sv;
static SV *hintkey_swaptwostmts_sv, *hintkey_looprest_sv;
static SV *hintkey_scopelessblock_sv;
static SV *hintkey_stmtasexpr_sv, *hintkey_stmtsasexpr_sv;
static SV *hintkey_loopblock_sv, *hintkey_blockasexpr_sv;
static SV *hintkey_swaplabel_sv, *hintkey_labelconst_sv;
static SV *hintkey_arrayfullexpr_sv, *hintkey_arraylistexpr_sv;
static SV *hintkey_arraytermexpr_sv, *hintkey_arrayarithexpr_sv;
static SV *hintkey_arrayexprflags_sv;
static SV *hintkey_DEFSV_sv;
static SV *hintkey_with_vars_sv;
static SV *hintkey_join_with_space_sv;
static int (*next_keyword_plugin)(pTHX_ char *, STRLEN, OP **);

/* low-level parser helpers */

#define PL_bufptr (PL_parser->bufptr)
#define PL_bufend (PL_parser->bufend)

/* RPN parser */

#define parse_var() THX_parse_var(aTHX)
static OP *THX_parse_var(pTHX)
{
    char *s = PL_bufptr;
    char *start = s;
    PADOFFSET varpos;
    OP *padop;
    if(*s != '$') croak("RPN syntax error");
    while(1) {
	char c = *++s;
	if(!isALNUM(c)) break;
    }
    if(s-start < 2) croak("RPN syntax error");
    lex_read_to(s);
    varpos = pad_findmy_pvn(start, s-start, 0);
    if(varpos == NOT_IN_PAD || PAD_COMPNAME_FLAGS_isOUR(varpos))
	croak("RPN only supports \"my\" variables");
    padop = newOP(OP_PADSV, 0);
    padop->op_targ = varpos;
    return padop;
}

#define push_rpn_item(o) \
    op_sibling_splice(parent, NULL, 0, o);
#define pop_rpn_item() ( \
    (tmpop = op_sibling_splice(parent, NULL, 1, NULL)) \
        ? tmpop : (croak("RPN stack underflow"), (OP*)NULL))

#define parse_rpn_expr() THX_parse_rpn_expr(aTHX)
static OP *THX_parse_rpn_expr(pTHX)
{
    OP *tmpop;
    /* fake parent for splice to mess with */
    OP *parent = mkBINOP(OP_NULL, NULL, NULL);

    while(1) {
	I32 c;
	lex_read_space(0);
	c = lex_peek_unichar(0);
	switch(c) {
	    case /*(*/')': case /*{*/'}': {
		OP *result = pop_rpn_item();
		if(cLISTOPx(parent)->op_first)
                    croak("RPN expression must return a single value");
                op_free(parent);
		return result;
	    } break;
	    case '0': case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7': case '8': case '9': {
		UV val = 0;
		do {
		    lex_read_unichar(0);
		    val = 10*val + (c - '0');
		    c = lex_peek_unichar(0);
		} while(c >= '0' && c <= '9');
		push_rpn_item(newSVOP(OP_CONST, 0, newSVuv(val)));
	    } break;
	    case '$': {
		push_rpn_item(parse_var());
	    } break;
	    case '+': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_ADD, 0, a, b));
	    } break;
	    case '-': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_SUBTRACT, 0, a, b));
	    } break;
	    case '*': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_MULTIPLY, 0, a, b));
	    } break;
	    case '/': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_DIVIDE, 0, a, b));
	    } break;
	    case '%': {
		OP *b = pop_rpn_item();
		OP *a = pop_rpn_item();
		lex_read_unichar(0);
		push_rpn_item(newBINOP(OP_I_MODULO, 0, a, b));
	    } break;
	    default: {
		croak("RPN syntax error");
	    } break;
	}
    }
}

#define parse_keyword_rpn() THX_parse_keyword_rpn(aTHX)
static OP *THX_parse_keyword_rpn(pTHX)
{
    OP *op;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '('/*)*/)
	croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    op = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*(*/')')
	croak("RPN expression must be parenthesised");
    lex_read_unichar(0);
    return op;
}

#define parse_keyword_calcrpn() THX_parse_keyword_calcrpn(aTHX)
static OP *THX_parse_keyword_calcrpn(pTHX)
{
    OP *varop, *exprop;
    lex_read_space(0);
    varop = parse_var();
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/)
	croak("RPN expression must be braced");
    lex_read_unichar(0);
    exprop = parse_rpn_expr();
    if(lex_peek_unichar(0) != /*{*/'}')
	croak("RPN expression must be braced");
    lex_read_unichar(0);
    return newASSIGNOP(OPf_STACKED, varop, 0, exprop);
}

#define parse_keyword_stufftest() THX_parse_keyword_stufftest(aTHX)
static OP *THX_parse_keyword_stufftest(pTHX)
{
    I32 c;
    bool do_stuff;
    lex_read_space(0);
    do_stuff = lex_peek_unichar(0) == '+';
    if(do_stuff) {
	lex_read_unichar(0);
	lex_read_space(0);
    }
    c = lex_peek_unichar(0);
    if(c == ';') {
	lex_read_unichar(0);
    } else if(c != /*{*/'}') {
	croak("syntax error");
    }
    if(do_stuff) lex_stuff_pvs(" ", 0);
    return newOP(OP_NULL, 0);
}

#define parse_keyword_swaptwostmts() THX_parse_keyword_swaptwostmts(aTHX)
static OP *THX_parse_keyword_swaptwostmts(pTHX)
{
    OP *a, *b;
    a = parse_fullstmt(0);
    b = parse_fullstmt(0);
    if(a && b)
	PL_hints |= HINT_BLOCK_SCOPE;
    return op_append_list(OP_LINESEQ, b, a);
}

#define parse_keyword_looprest() THX_parse_keyword_looprest(aTHX)
static OP *THX_parse_keyword_looprest(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
			parse_stmtseq(0), NULL, 1);
}

#define parse_keyword_scopelessblock() THX_parse_keyword_scopelessblock(aTHX)
static OP *THX_parse_keyword_scopelessblock(pTHX)
{
    I32 c;
    OP *body;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    body = parse_stmtseq(0);
    c = lex_peek_unichar(0);
    if(c != /*{*/'}' && c != /*[*/']' && c != /*(*/')') croak("syntax error");
    lex_read_unichar(0);
    return body;
}

#define parse_keyword_stmtasexpr() THX_parse_keyword_stmtasexpr(aTHX)
static OP *THX_parse_keyword_stmtasexpr(pTHX)
{
    OP *o = parse_barestmt(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_stmtsasexpr() THX_parse_keyword_stmtsasexpr(aTHX)
static OP *THX_parse_keyword_stmtsasexpr(pTHX)
{
    OP *o;
    lex_read_space(0);
    if(lex_peek_unichar(0) != '{'/*}*/) croak("syntax error");
    lex_read_unichar(0);
    o = parse_stmtseq(0);
    lex_read_space(0);
    if(lex_peek_unichar(0) != /*{*/'}') croak("syntax error");
    lex_read_unichar(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_loopblock() THX_parse_keyword_loopblock(aTHX)
static OP *THX_parse_keyword_loopblock(pTHX)
{
    return newWHILEOP(0, 1, NULL, newSVOP(OP_CONST, 0, &PL_sv_yes),
			parse_block(0), NULL, 1);
}

#define parse_keyword_blockasexpr() THX_parse_keyword_blockasexpr(aTHX)
static OP *THX_parse_keyword_blockasexpr(pTHX)
{
    OP *o = parse_block(0);
    if (!o) o = newOP(OP_STUB, 0);
    if (PL_hints & HINT_BLOCK_SCOPE) o->op_flags |= OPf_PARENS;
    return op_scope(o);
}

#define parse_keyword_swaplabel() THX_parse_keyword_swaplabel(aTHX)
static OP *THX_parse_keyword_swaplabel(pTHX)
{
    OP *sop = parse_barestmt(0);
    SV *label = parse_label(PARSE_OPTIONAL);
    if (label) sv_2mortal(label);
    return newSTATEOP(label ? SvUTF8(label) : 0,
                      label ? savepv(SvPVX(label)) : NULL,
                      sop);
}

#define parse_keyword_labelconst() THX_parse_keyword_labelconst(aTHX)
static OP *THX_parse_keyword_labelconst(pTHX)
{
    return newSVOP(OP_CONST, 0, parse_label(0));
}

#define parse_keyword_arrayfullexpr() THX_parse_keyword_arrayfullexpr(aTHX)
static OP *THX_parse_keyword_arrayfullexpr(pTHX)
{
    return newANONLIST(parse_fullexpr(0));
}

#define parse_keyword_arraylistexpr() THX_parse_keyword_arraylistexpr(aTHX)
static OP *THX_parse_keyword_arraylistexpr(pTHX)
{
    return newANONLIST(parse_listexpr(0));
}

#define parse_keyword_arraytermexpr() THX_parse_keyword_arraytermexpr(aTHX)
static OP *THX_parse_keyword_arraytermexpr(pTHX)
{
    return newANONLIST(parse_termexpr(0));
}

#define parse_keyword_arrayarithexpr() THX_parse_keyword_arrayarithexpr(aTHX)
static OP *THX_parse_keyword_arrayarithexpr(pTHX)
{
    return newANONLIST(parse_arithexpr(0));
}

#define parse_keyword_arrayexprflags() THX_parse_keyword_arrayexprflags(aTHX)
static OP *THX_parse_keyword_arrayexprflags(pTHX)
{
    U32 flags = 0;
    I32 c;
    OP *o;
    lex_read_space(0);
    c = lex_peek_unichar(0);
    if (c != '!' && c != '?') croak("syntax error");
    lex_read_unichar(0);
    if (c == '?') flags |= PARSE_OPTIONAL;
    o = parse_listexpr(flags);
    return o ? newANONLIST(o) : newANONHASH(newOP(OP_STUB, 0));
}

#define parse_keyword_DEFSV() THX_parse_keyword_DEFSV(aTHX)
static OP *THX_parse_keyword_DEFSV(pTHX)
{
    return newDEFSVOP();
}

#define sv_cat_c(a,b) THX_sv_cat_c(aTHX_ a, b)
static void THX_sv_cat_c(pTHX_ SV *sv, U32 c) {
    char ds[UTF8_MAXBYTES + 1], *d;
    d = (char *)uvchr_to_utf8((U8 *)ds, c);
    if (d - ds > 1) {
        sv_utf8_upgrade(sv);
    }
    sv_catpvn(sv, ds, d - ds);
}

#define parse_keyword_with_vars() THX_parse_keyword_with_vars(aTHX)
static OP *THX_parse_keyword_with_vars(pTHX)
{
    I32 c;
    IV count;
    int save_ix;
    OP *vardeclseq, *body;

    save_ix = block_start(TRUE);
    vardeclseq = NULL;

    count = 0;

    lex_read_space(0);
    c = lex_peek_unichar(0);
    while (c != '{') {
        SV *varname;
        PADOFFSET padoff;

        if (c == -1) {
            croak("unexpected EOF; expecting '{'");
        }

        if (!isIDFIRST_uni(c)) {
            croak("unexpected '%c'; expecting an identifier", (int)c);
        }

        varname = newSVpvs("$");
        if (lex_bufutf8()) {
            SvUTF8_on(varname);
        }

        sv_cat_c(varname, c);
        lex_read_unichar(0);

        while (c = lex_peek_unichar(0), c != -1 && isIDCONT_uni(c)) {
            sv_cat_c(varname, c);
            lex_read_unichar(0);
        }

        padoff = pad_add_name_sv(varname, padadd_NO_DUP_CHECK, NULL, NULL);

        {
            OP *my_var = newOP(OP_PADSV, OPf_MOD | (OPpLVAL_INTRO << 8));
            my_var->op_targ = padoff;

            vardeclseq = op_append_list(
                OP_LINESEQ,
                vardeclseq,
                newSTATEOP(
                    0, NULL,
                    newASSIGNOP(
                        OPf_STACKED,
                        my_var, 0,
                        newSVOP(
                            OP_CONST, 0,
                            newSViv(++count)
                        )
                    )
                )
            );
        }

        lex_read_space(0);
        c = lex_peek_unichar(0);
    }

    intro_my();

    body = parse_block(0);

    return block_end(save_ix, op_append_list(OP_LINESEQ, vardeclseq, body));
}

#define parse_join_with_space() THX_parse_join_with_space(aTHX)
static OP *THX_parse_join_with_space(pTHX)
{
    OP *delim, *args;

    args = parse_listexpr(0);
    delim = newSVOP(OP_CONST, 0, newSVpvs(" "));
    return op_convert_list(OP_JOIN, 0, op_prepend_elem(OP_LIST, delim, args));
}

/* plugin glue */

#define keyword_active(hintkey_sv) THX_keyword_active(aTHX_ hintkey_sv)
static int THX_keyword_active(pTHX_ SV *hintkey_sv)
{
    HE *he;
    if(!GvHV(PL_hintgv)) return 0;
    he = hv_fetch_ent(GvHV(PL_hintgv), hintkey_sv, 0,
		SvSHARED_HASH(hintkey_sv));
    return he && SvTRUE(HeVAL(he));
}

static int my_keyword_plugin(pTHX_
    char *keyword_ptr, STRLEN keyword_len, OP **op_ptr)
{
    if(keyword_len == 3 && strnEQ(keyword_ptr, "rpn", 3) &&
		    keyword_active(hintkey_rpn_sv)) {
	*op_ptr = parse_keyword_rpn();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 7 && strnEQ(keyword_ptr, "calcrpn", 7) &&
		    keyword_active(hintkey_calcrpn_sv)) {
	*op_ptr = parse_keyword_calcrpn();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 9 && strnEQ(keyword_ptr, "stufftest", 9) &&
		    keyword_active(hintkey_stufftest_sv)) {
	*op_ptr = parse_keyword_stufftest();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 12 &&
		    strnEQ(keyword_ptr, "swaptwostmts", 12) &&
		    keyword_active(hintkey_swaptwostmts_sv)) {
	*op_ptr = parse_keyword_swaptwostmts();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 8 && strnEQ(keyword_ptr, "looprest", 8) &&
		    keyword_active(hintkey_looprest_sv)) {
	*op_ptr = parse_keyword_looprest();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 14 && strnEQ(keyword_ptr, "scopelessblock", 14) &&
		    keyword_active(hintkey_scopelessblock_sv)) {
	*op_ptr = parse_keyword_scopelessblock();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 10 && strnEQ(keyword_ptr, "stmtasexpr", 10) &&
		    keyword_active(hintkey_stmtasexpr_sv)) {
	*op_ptr = parse_keyword_stmtasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 11 && strnEQ(keyword_ptr, "stmtsasexpr", 11) &&
		    keyword_active(hintkey_stmtsasexpr_sv)) {
	*op_ptr = parse_keyword_stmtsasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 9 && strnEQ(keyword_ptr, "loopblock", 9) &&
		    keyword_active(hintkey_loopblock_sv)) {
	*op_ptr = parse_keyword_loopblock();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 11 && strnEQ(keyword_ptr, "blockasexpr", 11) &&
		    keyword_active(hintkey_blockasexpr_sv)) {
	*op_ptr = parse_keyword_blockasexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 9 && strnEQ(keyword_ptr, "swaplabel", 9) &&
		    keyword_active(hintkey_swaplabel_sv)) {
	*op_ptr = parse_keyword_swaplabel();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 10 && strnEQ(keyword_ptr, "labelconst", 10) &&
		    keyword_active(hintkey_labelconst_sv)) {
	*op_ptr = parse_keyword_labelconst();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 13 && strnEQ(keyword_ptr, "arrayfullexpr", 13) &&
		    keyword_active(hintkey_arrayfullexpr_sv)) {
	*op_ptr = parse_keyword_arrayfullexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 13 && strnEQ(keyword_ptr, "arraylistexpr", 13) &&
		    keyword_active(hintkey_arraylistexpr_sv)) {
	*op_ptr = parse_keyword_arraylistexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 13 && strnEQ(keyword_ptr, "arraytermexpr", 13) &&
		    keyword_active(hintkey_arraytermexpr_sv)) {
	*op_ptr = parse_keyword_arraytermexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 14 && strnEQ(keyword_ptr, "arrayarithexpr", 14) &&
		    keyword_active(hintkey_arrayarithexpr_sv)) {
	*op_ptr = parse_keyword_arrayarithexpr();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 14 && strnEQ(keyword_ptr, "arrayexprflags", 14) &&
		    keyword_active(hintkey_arrayexprflags_sv)) {
	*op_ptr = parse_keyword_arrayexprflags();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 5 && strnEQ(keyword_ptr, "DEFSV", 5) &&
		    keyword_active(hintkey_DEFSV_sv)) {
	*op_ptr = parse_keyword_DEFSV();
	return KEYWORD_PLUGIN_EXPR;
    } else if(keyword_len == 9 && strnEQ(keyword_ptr, "with_vars", 9) &&
		    keyword_active(hintkey_with_vars_sv)) {
	*op_ptr = parse_keyword_with_vars();
	return KEYWORD_PLUGIN_STMT;
    } else if(keyword_len == 15 && strnEQ(keyword_ptr, "join_with_space", 15) &&
		    keyword_active(hintkey_join_with_space_sv)) {
	*op_ptr = parse_join_with_space();
	return KEYWORD_PLUGIN_EXPR;
    } else {
	return next_keyword_plugin(aTHX_ keyword_ptr, keyword_len, op_ptr);
    }
}

static XOP my_xop;

static OP *
pp_xop(pTHX)
{
    return PL_op->op_next;
}

static void
peep_xop(pTHX_ OP *o, OP *oldop)
{
    dMY_CXT;
    av_push(MY_CXT.xop_record, newSVpvf("peep:%"UVxf, PTR2UV(o)));
    av_push(MY_CXT.xop_record, newSVpvf("oldop:%"UVxf, PTR2UV(oldop)));
}

static I32
filter_call(pTHX_ int idx, SV *buf_sv, int maxlen)
{
    char *p;
    char *end;
    int n = FILTER_READ(idx + 1, buf_sv, maxlen);

    if (n<=0) return n;

    p = SvPV_force_nolen(buf_sv);
    end = p + SvCUR(buf_sv);
    while (p < end) {
	if (*p == 'o') *p = 'e';
	p++;
    }
    return SvCUR(buf_sv);
}

static AV *
myget_linear_isa(pTHX_ HV *stash, U32 level) {
    GV **gvp = (GV **)hv_fetchs(stash, "ISA", 0);
    PERL_UNUSED_ARG(level);
    return gvp && *gvp && GvAV(*gvp)
	 ? GvAV(*gvp)
	 : (AV *)sv_2mortal((SV *)newAV());
}


XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_undef);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_VERSION_empty);
XS_EXTERNAL(XS_XS__APItest__XSUB_XS_APIVERSION_invalid);

static struct mro_alg mymro;

static Perl_check_t addissub_nxck_add;

static OP *
addissub_myck_add(pTHX_ OP *op)
{
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addissub", 0);
    OP *aop, *bop;
    U8 flags;
    if (!(flag_svp && SvTRUE(*flag_svp) && (op->op_flags & OPf_KIDS) &&
	    (aop = cBINOPx(op)->op_first) && (bop = OpSIBLING(aop)) &&
	    !OpHAS_SIBLING(bop)))
	return addissub_nxck_add(aTHX_ op);
    flags = op->op_flags;
    op_sibling_splice(op, NULL, 1, NULL); /* excise aop */
    op_sibling_splice(op, NULL, 1, NULL); /* excise bop */
    op_free(op); /* free the empty husk */
    flags &= ~OPf_KIDS;
    return newBINOP(OP_SUBTRACT, flags, aop, bop);
}

static Perl_check_t old_ck_rv2cv;

static OP *
my_ck_rv2cv(pTHX_ OP *o)
{
    SV *ref;
    SV **flag_svp = hv_fetchs(GvHV(PL_hintgv), "XS::APItest/addunder", 0);
    OP *aop;

    if (flag_svp && SvTRUE(*flag_svp) && (o->op_flags & OPf_KIDS)
     && (aop = cUNOPx(o)->op_first) && aop->op_type == OP_CONST
     && aop->op_private & (OPpCONST_ENTERED|OPpCONST_BARE)
     && (ref = cSVOPx(aop)->op_sv) && SvPOK(ref) && SvCUR(ref)
     && *(SvEND(ref)-1) == 'o')
    {
	SvGROW(ref, SvCUR(ref)+2);
	*SvEND(ref) = '_';
	SvCUR(ref)++;
	*SvEND(ref) = '\0';
    }
    return old_ck_rv2cv(aTHX_ o);
}

#include "const-c.inc"

#line 1272 "APItest.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1416 "APItest.c"

/* INCLUDE:  Including 'const-xs.inc' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 233 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined XS::APItest macro %" SVf
			  ", used", sv);
	} else
#endif
	{
	    sv = newSVpvf("%"SVf" is not a valid XS::APItest macro",
			  sv);
	}
	PUSHs(sv_2mortal(sv));
#line 1451 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'const-xs.inc' */


/* INCLUDE:  Including 'numeric.xs' from 'APItest.xs' */


XS_EUPXS(XS_XS__APItest__numeric_grok_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "number");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
#line 7 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1480 "APItest.c"
#line 12 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number(pv, len, &value);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1487 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_number_flags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	U32	flags = (unsigned long)SvUV(ST(1))
;
#line 23 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value;
	int result;
#line 1512 "APItest.c"
#line 28 "./numeric.xs"
	EXTEND(SP,2);
	result = grok_number_flags(pv, len, &value, flags);
	PUSHs(sv_2mortal(newSViv(result)));
	if (result & IS_NUMBER_IN_UV)
	    PUSHs(sv_2mortal(newSVuv(value)));
#line 1519 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_grok_atoUV)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, endsv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	number = ST(0)
;
	SV *	endsv = ST(1)
;
#line 39 "./numeric.xs"
	STRLEN len;
	const char *pv = SvPV(number, len);
	UV value = 0xdeadbeef;
	bool result;
	const char* endptr;
#line 1545 "APItest.c"
#line 45 "./numeric.xs"
	EXTEND(SP,2);
	if (endsv == &PL_sv_undef) {
          result = grok_atoUV(pv, &value, NULL);
        } else {
          result = grok_atoUV(pv, &value, &endptr);
        }
	PUSHs(result ? &PL_sv_yes : &PL_sv_no);
	PUSHs(sv_2mortal(newSVuv(value)));
	if (endsv == &PL_sv_undef) {
          PUSHs(sv_2mortal(newSVpvn(NULL, 0)));
	} else {
	  if (endptr) {
	    PUSHs(sv_2mortal(newSViv(endptr - pv)));
	  } else {
	    PUSHs(sv_2mortal(newSViv(0)));
	  }
	}
#line 1564 "APItest.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'APItest.xs' from 'numeric.xs' */


XS_EUPXS(XS_XS__APItest__numeric_assertx); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__numeric_assertx)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	int	x = (int)SvIV(ST(0))
;
#line 1271 "APItest.xs"
        /* this only needs to compile and checks that assert() can be
           used this way syntactically */
	(void)(assert(x), 1);
	(void)(x);
#line 1588 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_bytes_cmp_utf8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "bytes, utf8");
    {
	SV *	bytes = ST(0)
;
	SV *	utf8 = ST(1)
;
#line 1283 "APItest.xs"
	const U8 *b;
	STRLEN blen;
	const U8 *u;
	STRLEN ulen;
#line 1610 "APItest.c"
	int	RETVAL;
	dXSTARG;
#line 1288 "APItest.xs"
	b = (const U8 *)SvPVbyte(bytes, blen);
	u = (const U8 *)SvPVbyte(utf8, ulen);
	RETVAL = bytes_cmp_utf8(b, blen, u, ulen);
#line 1617 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__utf8_test_utf8n_to_uvchr)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "s, len, flags");
    {
	SV *	s = ST(0)
;
	SV *	len = ST(1)
;
	SV *	flags = ST(2)
;
#line 1301 "APItest.xs"
        STRLEN retlen;
        UV ret;
        STRLEN slen;

#line 1642 "APItest.c"
	AV *	RETVAL;
#line 1306 "APItest.xs"
        /* Call utf8n_to_uvchr() with the inputs.  It always asks for the
         * actual length to be returned
         *
         * Length to assume <s> is; not checked, so could have buffer overflow
         */
        RETVAL = newAV();
        sv_2mortal((SV*)RETVAL);

        ret
         = utf8n_to_uvchr((U8*) SvPV(s, slen), SvUV(len), &retlen, SvUV(flags));

        /* Returns the return value in [0]; <retlen> in [1] */
        av_push(RETVAL, newSVuv(ret));
        if (retlen == (STRLEN) -1) {
            av_push(RETVAL, newSViv(-1));
        }
        else {
            av_push(RETVAL, newSVuv(retlen));
        }

#line 1665 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_amagic_deref_call)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1336 "APItest.xs"
	/* The reference is owned by something else.  */
	PUSHs(amagic_deref_call(sv, what));
#line 1693 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Overload_tryAMAGICunDEREF_var)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, what");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	int	what = (int)SvIV(ST(1))
;
#line 1347 "APItest.xs"
	{
	    SV **sp = &sv;
	    switch(what) {
	    case to_av_amg:
		tryAMAGICunDEREF(to_av);
		break;
	    case to_cv_amg:
		tryAMAGICunDEREF(to_cv);
		break;
	    case to_gv_amg:
		tryAMAGICunDEREF(to_gv);
		break;
	    case to_hv_amg:
		tryAMAGICunDEREF(to_hv);
		break;
	    case to_sv_amg:
		tryAMAGICunDEREF(to_sv);
		break;
	    default:
		croak("Invalid value %d passed to tryAMAGICunDEREF_var", what);
	    }
	}
	/* The reference is owned by something else.  */
	PUSHs(sv);
#line 1738 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_VERSION_defined)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1382 "APItest.xs"
        XS_VERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 1756 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__XSUB_XS_APIVERSION_valid)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1388 "APItest.xs"
        XS_APIVERSION_BOOTCHECK;
        XSRETURN_EMPTY;
#line 1774 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_rot13_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_rot13_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::rot13_hash",
				"hash");
		}
	} STMT_END
;
#line 1397 "APItest.xs"
	{
	    struct ufuncs uf;
	    uf.uf_val = rot13_key;
	    uf.uf_set = 0;
	    uf.uf_index = 0;

	    sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
	}
#line 1812 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_bitflip_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hash");
    {
	HV *	hash;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::bitflip_hash",
				"hash");
		}
	} STMT_END
;
#line 1410 "APItest.xs"
	{
	    struct ufuncs uf;
	    uf.uf_val = bitflip_key;
	    uf.uf_set = 0;
	    uf.uf_index = 0;

	    sv_magic((SV*)hash, NULL, PERL_MAGIC_uvar, (char*)&uf, sizeof(uf));
	}
#line 1849 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#define UTF8KLEN(sv, len)   (SvUTF8(sv) ? -(I32)len : (I32)len)

XS_EUPXS(XS_XS__APItest__Hash_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1424 "APItest.xs"
	STRLEN len;
	const char *key;
#line 1866 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists",
				"hash");
		}
	} STMT_END
;
#line 1430 "APItest.xs"
	key = SvPV(key_sv, len);
	RETVAL = hv_exists(hash, key, UTF8KLEN(key_sv, len));
#line 1888 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_exists_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_exists_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1438 "APItest.xs"
#line 1903 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	bool	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::exists_ent",
				"hash");
		}
	} STMT_END
;
#line 1442 "APItest.xs"
	RETVAL = hv_exists_ent(hash, key_sv, 0);
#line 1924 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
#line 1449 "APItest.xs"
	STRLEN len;
	const char *key;
#line 1941 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1456 "APItest.xs"
	key = SvPV(key_sv, len);
	/* It's already mortal, so need to increase reference count.  */
	RETVAL
	    = SvREFCNT_inc(hv_delete(hash, key, UTF8KLEN(key_sv, len), flags));
#line 1973 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_delete_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_delete_ent)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "hash, key_sv, flags = 0");
    {
	HV *	hash;
	SV *	key_sv = ST(1)
;
	I32	flags;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::delete_ent",
				"hash");
		}
	} STMT_END
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (I32)SvIV(ST(2))
;
	}
#line 1470 "APItest.xs"
	/* It's already mortal, so need to increase reference count.  */
	RETVAL = SvREFCNT_inc(hv_delete_ent(hash, key_sv, flags, 0));
#line 2017 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store_ent)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key, value");
    {
#line 1478 "APItest.xs"
	SV *copy;
	HE *result;
#line 2035 "APItest.c"
	HV *	hash;
	SV *	key = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store_ent",
				"hash");
		}
	} STMT_END
;
#line 1485 "APItest.xs"
	copy = newSV(0);
	result = hv_store_ent(hash, key, copy, 0);
	SvSetMagicSV(copy, value);
	if (!result) {
	    SvREFCNT_dec(copy);
	    XSRETURN_EMPTY;
	}
	/* It's about to become mortal, so need to increase reference count.
	 */
	RETVAL = SvREFCNT_inc(HeVAL(result));
#line 2067 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "hash, key_sv, value");
    {
#line 1501 "APItest.xs"
	STRLEN len;
	const char *key;
	SV *copy;
	SV **result;
#line 2087 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	value = ST(2)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::store",
				"hash");
		}
	} STMT_END
;
#line 1510 "APItest.xs"
	key = SvPV(key_sv, len);
	copy = newSV(0);
	result = hv_store(hash, key, UTF8KLEN(key_sv, len), copy, 0);
	SvSetMagicSV(copy, value);
	if (!result) {
	    SvREFCNT_dec(copy);
	    XSRETURN_EMPTY;
	}
	/* It's about to become mortal, so need to increase reference count.
	 */
	RETVAL = SvREFCNT_inc(*result);
#line 2120 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch_ent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1527 "APItest.xs"
	HE *result;
#line 2137 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch_ent",
				"hash");
		}
	} STMT_END
;
#line 1532 "APItest.xs"
	result = hv_fetch_ent(hash, key_sv, 0, 0);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(HeVAL(result));
#line 2163 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "hash, key_sv");
    {
#line 1544 "APItest.xs"
	STRLEN len;
	const char *key;
	SV **result;
#line 2182 "APItest.c"
	HV *	hash;
	SV *	key_sv = ST(1)
;
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::fetch",
				"hash");
		}
	} STMT_END
;
#line 1551 "APItest.xs"
	key = SvPV(key_sv, len);
	result = hv_fetch(hash, key, UTF8KLEN(key_sv, len), 0);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(*result);
#line 2209 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#if defined (hv_common)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_XS__APItest__Hash_common); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_common)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "params");
    {
	HV *	params;
#line 1568 "APItest.xs"
	HE *result;
	HV *hv = NULL;
	SV *keysv = NULL;
	const char *key = NULL;
	STRLEN klen = 0;
	int flags = 0;
	int action = 0;
	SV *val = NULL;
	U32 hash = 0;
	SV **svp;
#line 2239 "APItest.c"
	SV *	RETVAL;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    params = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::common",
				"params");
		}
	} STMT_END
;
#line 1579 "APItest.xs"
	if ((svp = hv_fetchs(params, "hv", 0))) {
	    SV *const rv = *svp;
	    if (!SvROK(rv))
		croak("common passed a non-reference for parameter hv");
	    hv = (HV *)SvRV(rv);
	}
	if ((svp = hv_fetchs(params, "keysv", 0)))
	    keysv = *svp;
	if ((svp = hv_fetchs(params, "keypv", 0))) {
	    key = SvPV_const(*svp, klen);
	    if (SvUTF8(*svp))
		flags = HVhek_UTF8;
	}
	if ((svp = hv_fetchs(params, "action", 0)))
	    action = SvIV(*svp);
	if ((svp = hv_fetchs(params, "val", 0)))
	    val = newSVsv(*svp);
	if ((svp = hv_fetchs(params, "hash", 0)))
	    hash = SvUV(*svp);

	if (hv_fetchs(params, "hash_pv", 0)) {
            assert(key);
	    PERL_HASH(hash, key, klen);
	}
	if (hv_fetchs(params, "hash_sv", 0)) {
            assert(keysv);
            {
              STRLEN len;
              const char *const p = SvPV(keysv, len);
              PERL_HASH(hash, p, len);
            }
	}

	result = (HE *)hv_common(hv, keysv, key, klen, flags, action, val, hash);
	if (!result) {
	    XSRETURN_EMPTY;
	}
	/* Force mg_get  */
	RETVAL = newSVsv(HeVAL(result));
#line 2295 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_free_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1626 "APItest.xs"
	test_freeent(&Perl_hv_free_ent);
	XSRETURN(4);
#line 2316 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_hv_delayfree_ent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1632 "APItest.xs"
	test_freeent(&Perl_hv_delayfree_ent);
	XSRETURN(4);
#line 2335 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_share_unshare_pvn)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "input");
    {
#line 1638 "APItest.xs"
	STRLEN len;
	U32 hash;
	char *pvx;
	char *p;
#line 2354 "APItest.c"
	SV *	input = ST(0)
;
	SV *	RETVAL;
#line 1645 "APItest.xs"
	pvx = SvPV(input, len);
	PERL_HASH(hash, pvx, len);
	p = sharepvn(pvx, len, hash);
	RETVAL = newSVpvn(p, len);
	unsharepvn(p, len, hash);
#line 2364 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#if PERL_VERSION >= 9
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_exists)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	bool	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 1660 "APItest.xs"
	if (level) {
	    croak("level must be zero, not %"IVdf, level);
	}
	RETVAL = (cop_hints_fetch_sv(PL_curcop, key, 0, 0) != &PL_sv_placeholder);
#line 2398 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_refcounted_he_fetch)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "key, level=0");
    {
	SV *	key = ST(0)
;
	IV	level;
	SV *	RETVAL;

	if (items < 2)
	    level = 0;
	else {
	    level = (IV)SvIV(ST(1))
;
	}
#line 1672 "APItest.xs"
	if (level) {
	    croak("level must be zero, not %"IVdf, level);
	}
	RETVAL = cop_hints_fetch_sv(PL_curcop, key, 0, 0);
	SvREFCNT_inc(RETVAL);
#line 2429 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest__Hash_test_force_keys); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Hash_test_force_keys)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1685 "APItest.xs"
        HE *he;
	STRLEN count = 0;
#line 2450 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::Hash::test_force_keys",
				"hv");
		}
	} STMT_END
;
#line 1688 "APItest.xs"
        hv_iterinit(hv);
        he = hv_iternext(hv);
        while (he) {
	    SV *sv = HeSVKEY_force(he);
	    ++count;
	    EXTEND(SP, count);
	    PUSHs(sv_mortalcopy(sv));
            he = hv_iternext(hv);
        }
#line 2476 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__TempLv_make_temp_mg_lv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
#line 1717 "APItest.xs"
	SV * const lv = newSV_type(SVt_PVLV);
	STRLEN len;
#line 2497 "APItest.c"
#line 1720 "APItest.xs"
        SvPV(sv, len);

	sv_magic(lv, NULL, PERL_MAGIC_substr, NULL, 0);
	LvTYPE(lv) = 'x';
	LvTARG(lv) = SvREFCNT_inc_simple(sv);
	LvTARGOFF(lv) = len == 0 ? 0 : 1;
	LvTARGLEN(lv) = len < 2 ? 0 : len-2;

	EXTEND(SP, 1);
	ST(0) = sv_2mortal(lv);
	XSRETURN(1);
#line 2510 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "classname");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	classname = (const char *)SvPV_nolen(ST(0))
;
#line 1739 "APItest.xs"
    PUSHs(sv_setref_pv(sv_newmortal(), classname, (void*)ptr_table_new()));
#line 2530 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"XS::APItest::PtrTable::DESTROY",
			"table")
;
#line 1745 "APItest.xs"
    ptr_table_free(table);
#line 2557 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_store); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_store)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "table, from, to");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	SVREF	to;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::store",
			"table", "XS::APItest::PtrTable")
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"from");
		}
	} STMT_END
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(2);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    to = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::store",
				"to");
		}
	} STMT_END
;
#line 1753 "APItest.xs"
   ptr_table_store(table, from, to);
#line 2613 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_fetch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_fetch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "table, from");
    {
	XS__APItest__PtrTable	table;
	SVREF	from;
	UV	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::fetch",
			"table", "XS::APItest::PtrTable")
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    from = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::PtrTable::fetch",
				"from");
		}
	} STMT_END
;
#line 1760 "APItest.xs"
   RETVAL = PTR2UV(ptr_table_fetch(table, from));
#line 2656 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__PtrTable_split); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_split)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::split",
			"table", "XS::APItest::PtrTable")
;

	ptr_table_split(table);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__PtrTable_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__PtrTable_clear)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	XS__APItest__PtrTable	table;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "XS::APItest::PtrTable")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    table = INT2PTR(XS__APItest__PtrTable,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"XS::APItest::PtrTable::clear",
			"table", "XS::APItest::PtrTable")
;

	ptr_table_clear(table);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOAD)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 1777 "APItest.xs"
	RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 2723 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AutoLoader_AUTOLOADp)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	RETVAL;
#line 1785 "APItest.xs"
        PERL_UNUSED_ARG(items);
	RETVAL = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SvUTF8(cv));
#line 2741 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_ops); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_ops)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 1806 "APItest.xs"
        RETVAL = PL_custom_ops;
#line 2759 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_names)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 1813 "APItest.xs"
        PL_custom_op_names = newHV();
        RETVAL = PL_custom_op_names;
#line 2782 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_custom_op_descs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_custom_op_descs)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 1821 "APItest.xs"
        PL_custom_op_descs = newHV();
        RETVAL = PL_custom_op_descs;
#line 2805 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_register)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1829 "APItest.xs"
        XopENTRY_set(&my_xop, xop_name, "my_xop");
        XopENTRY_set(&my_xop, xop_desc, "XOP for testing");
        XopENTRY_set(&my_xop, xop_class, OA_UNOP);
        XopENTRY_set(&my_xop, xop_peep, peep_xop);
        Perl_custom_op_register(aTHX_ pp_xop, &my_xop);
#line 2830 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_clear)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1838 "APItest.xs"
        XopDISABLE(&my_xop, xop_name);
        XopDISABLE(&my_xop, xop_desc);
        XopDISABLE(&my_xop, xop_class);
        XopDISABLE(&my_xop, xop_peep);
#line 2848 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_xop_my_xop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_my_xop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 1846 "APItest.xs"
        RETVAL = PTR2IV(&my_xop);
#line 2865 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_ppaddr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_ppaddr)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 1853 "APItest.xs"
        RETVAL = PTR2IV(pp_xop);
#line 2883 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_OA_UNOP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_OA_UNOP)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 1860 "APItest.xs"
        RETVAL = OA_UNOP;
#line 2901 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_build_optree); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_build_optree)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	AV *	RETVAL;
#line 1867 "APItest.xs"
        dMY_CXT;
        UNOP *unop;
        OP *kid;

        MY_CXT.xop_record = newAV();

        kid = newSVOP(OP_CONST, 0, newSViv(42));

        unop = (UNOP*)mkUNOP(OP_CUSTOM, kid);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;
        kid->op_next        = (OP*)unop;

        av_push(MY_CXT.xop_record, newSVpvf("unop:%"UVxf, PTR2UV(unop)));
        av_push(MY_CXT.xop_record, newSVpvf("kid:%"UVxf, PTR2UV(kid)));

        av_push(MY_CXT.xop_record, newSVpvf("NAME:%s", OP_NAME((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("DESC:%s", OP_DESC((OP*)unop)));
        av_push(MY_CXT.xop_record, newSVpvf("CLASS:%d", (int)OP_CLASS((OP*)unop)));

        PL_rpeepp(aTHX_ kid);

        FreeOp(kid);
        FreeOp(unop);

        RETVAL = MY_CXT.xop_record;
        MY_CXT.xop_record = NULL;
#line 2945 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xop_from_custom_op); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xop_from_custom_op)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 1901 "APItest.xs"
/* author note: this test doesn't imply Perl_custom_op_xop is or isn't public
   API or that Perl_custom_op_xop is known to be used outside the core */
        UNOP *unop;
        XOP *xop;

        unop = (UNOP*)mkUNOP(OP_CUSTOM, NULL);
        unop->op_ppaddr     = pp_xop;
        unop->op_private    = 0;
        unop->op_next       = NULL;

        xop = Perl_custom_op_xop(aTHX_ (OP *)unop);
        FreeOp(unop);
        RETVAL = PTR2IV(xop);
#line 2980 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 1953 "APItest.xs"
    MY_CXT_CLONE;
    PERL_UNUSED_VAR(items);
    MY_CXT.sv = newSVpv("initial_clone",0);
    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = NULL;
    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;
    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();
#line 3004 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_double)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	double	val = (double)SvNV(ST(0))
;
#line 1968 "APItest.xs"
        printf("%5.3f\n",val);
#line 3021 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_have_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_have_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1973 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 3042 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_print_long_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long_double)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1984 "APItest.xs"
#ifdef HAS_LONG_DOUBLE
#   if defined(PERL_PRIfldbl) && (LONG_DOUBLESIZE > DOUBLESIZE)
        long double val = 7.0;
        printf("%5.3" PERL_PRIfldbl "\n",val);
#   else
        double val = 7.0;
        printf("%5.3f\n",val);
#   endif
#endif
#line 3066 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_int)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	int	val = (int)SvIV(ST(0))
;
#line 1998 "APItest.xs"
        printf("%d\n",val);
#line 3083 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_long); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_long)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	long	val = (long)SvIV(ST(0))
;
#line 2004 "APItest.xs"
        printf("%ld\n",val);
#line 3100 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_float); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_float)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "val");
    {
	float	val = (float)SvNV(ST(0))
;
#line 2010 "APItest.xs"
        printf("%5.3f\n",val);
#line 3117 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_print_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_print_flush)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2015 "APItest.xs"
	fflush(stdout);
#line 3132 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_mpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2020 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHp("one", 3);
	mPUSHp("two", 3);
	mPUSHp("three", 5);
	XSRETURN(3);
#line 3153 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2029 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHn(0.5);
	mPUSHn(-0.25);
	mPUSHn(0.125);
	XSRETURN(3);
#line 3175 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2038 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHi(-1);
	mPUSHi(2);
	mPUSHi(-3);
	XSRETURN(3);
#line 3197 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2047 "APItest.xs"
	EXTEND(SP, 3);
	mPUSHu(1);
	mPUSHu(2);
	mPUSHu(3);
	XSRETURN(3);
#line 3219 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushp)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2056 "APItest.xs"
	mXPUSHp("one", 3);
	mXPUSHp("two", 3);
	mXPUSHp("three", 5);
	XSRETURN(3);
#line 3240 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushn)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2064 "APItest.xs"
	mXPUSHn(0.5);
	mXPUSHn(-0.25);
	mXPUSHn(0.125);
	XSRETURN(3);
#line 3261 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushi); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushi)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2072 "APItest.xs"
	mXPUSHi(-1);
	mXPUSHi(2);
	mXPUSHi(-3);
	XSRETURN(3);
#line 3282 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_mxpushu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mxpushu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2080 "APItest.xs"
	mXPUSHu(1);
	mXPUSHu(2);
	mXPUSHu(3);
	XSRETURN(3);
#line 3303 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_sv_C); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv_C)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2088 "APItest.xs"
    CV * i_sub;
    GV * i_gv;
    I32 retcnt;
    SV * errsv;
    char * errstr;
    SV * miscsv = sv_newmortal();
    HV * hv = (HV*)sv_2mortal((SV*)newHV());
#line 3325 "APItest.c"
#line 2096 "APItest.xs"
    i_sub = get_cv("i", 0);
    PUSHMARK(SP);
    /* PUTBACK not needed since this sub was called with 0 args, and is calling
      0 args, so global SP doesn't need to be moved before a call_* */
    retcnt = call_sv((SV*)i_sub, 0); /* try a CV* */
    SPAGAIN;
    SP -= retcnt; /* dont care about return count, wipe everything off */
    sv_setpvs(miscsv, "i");
    PUSHMARK(SP);
    retcnt = call_sv(miscsv, 0); /* try a PV */
    SPAGAIN;
    SP -= retcnt;
    /* no add and SVt_NULL are intentional, sub i should be defined already */
    i_gv = gv_fetchpvn_flags("i", sizeof("i")-1, 0, SVt_NULL);
    PUSHMARK(SP);
    retcnt = call_sv((SV*)i_gv, 0); /* try a GV* */
    SPAGAIN;
    SP -= retcnt;
    /* the tests below are not declaring this being public API behavior,
       only current internal behavior, these tests can be changed in the
       future if necessery */
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_yes, 0); /* does nothing */
    SPAGAIN;
    SP -= retcnt;
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_no, G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV_nolen(errsv);
    if(strnEQ(errstr, "Undefined subroutine &main:: called at",
              sizeof("Undefined subroutine &main:: called at") - 1)) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv(&PL_sv_undef,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV_nolen(errsv);
    if(strnEQ(errstr, "Can't use an undefined value as a subroutine reference at",
              sizeof("Can't use an undefined value as a subroutine reference at") - 1)) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
    PUSHMARK(SP);
    retcnt = call_sv((SV*)hv,  G_EVAL);
    SPAGAIN;
    SP -= retcnt;
    errsv = ERRSV;
    errstr = SvPV_nolen(errsv);
    if(strnEQ(errstr, "Not a CODE reference at",
              sizeof("Not a CODE reference at") - 1)) {
        PUSHMARK(SP);
        retcnt = call_sv((SV*)i_sub, 0); /* call again to increase counter */
        SPAGAIN;
        SP -= retcnt;
    }
#line 3391 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_call_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_sv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "sv, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2166 "APItest.xs"
	I32 i;
#line 3412 "APItest.c"
#line 2168 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_sv(sv, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 3423 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_pv)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "subname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	subname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2183 "APItest.xs"
	I32 i;
#line 3445 "APItest.c"
#line 2185 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_pv(subname, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 3456 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_call_method); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_call_method)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "methname, flags, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char*	methname = (char *)SvPV_nolen(ST(0))
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2200 "APItest.xs"
	I32 i;
#line 3478 "APItest.c"
#line 2202 "APItest.xs"
	for (i=0; i<items-2; i++)
	    ST(i) = ST(i+2); /* pop first two args */
	PUSHMARK(SP);
	SP += items - 2;
	PUTBACK;
	i = call_method(methname, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 3489 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_newCONSTSUB); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newCONSTSUB)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 4)
       croak_xs_usage(cv,  "stash, name, flags, sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	name = ST(1)
;
	I32	flags = (I32)SvIV(ST(2))
;
	SV*	sv = ST(3)
;
#line 2221 "APItest.xs"
	CV* mycv = NULL;
	STRLEN len;
	const char *pv = SvPV(name, len);
#line 3517 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				GvNAME(CvGV(cv)),
				"stash");
		}
	} STMT_END
;
#line 2225 "APItest.xs"
        switch (ix) {
           case 0:
               mycv = newCONSTSUB(stash, pv, SvOK(sv) ? SvREFCNT_inc(sv) : NULL);
               break;
           case 1:
               mycv = newCONSTSUB_flags(
                 stash, pv, len, flags | SvUTF8(name), SvOK(sv) ? SvREFCNT_inc(sv) : NULL
               );
               break;
        }
        EXTEND(SP, 2);
        assert(mycv);
        PUSHs( CvCONST(mycv) ? &PL_sv_yes : &PL_sv_no );
        PUSHs((SV*)CvGV(mycv));
#line 3547 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_init_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_init_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "namesv, multi, flags, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	multi = (int)SvIV(ST(1))
;
	I32	flags = (I32)SvIV(ST(2))
;
	int	type = (int)SvIV(ST(3))
;
#line 2247 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        GV *gv = *(GV**)hv_fetch(PL_defstash, name, len, TRUE);
#line 3575 "APItest.c"
#line 2251 "APItest.xs"
        if (SvTYPE(gv) == SVt_PVGV)
            Perl_croak(aTHX_ "GV is already a PVGV");
        if (multi) flags |= GV_ADDMULTI;
        switch (type) {
           case 0:
	       gv_init(gv, PL_defstash, name, len, multi);
               break;
           case 1:
               gv_init_sv(gv, PL_defstash, namesv, flags);
               break;
           case 2:
               gv_init_pv(gv, PL_defstash, name, flags | SvUTF8(namesv));
               break;
           case 3:
               gv_init_pvn(gv, PL_defstash, name, len, flags | SvUTF8(namesv));
               break;
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 3595 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2278 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
#line 3624 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_type",
				"stash");
		}
	} STMT_END
;
#line 2282 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmeth(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 3655 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmeth_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "stash, methname, type, level, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	level = (I32)SvIV(ST(3))
;
	I32	flags = (I32)SvIV(ST(4))
;
#line 2306 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
#line 3684 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmeth_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2310 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmeth_autoload(stash, name, len, level);
               break;
           case 1:
               gv = gv_fetchmeth_sv_autoload(stash, methname, level, flags);
               break;
           case 2:
               gv = gv_fetchmeth_pv_autoload(stash, name, level, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_fetchmeth_pvn_autoload(stash, name, len, level, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? MUTABLE_SV(gv) : &PL_sv_undef );
#line 3715 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_fetchmethod_flags_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	flags = (I32)SvIV(ST(3))
;
#line 2333 "APItest.xs"
	GV* gv = NULL;
#line 3740 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_fetchmethod_flags_type",
				"stash");
		}
	} STMT_END
;
#line 2335 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_fetchmethod_flags(stash, SvPVX_const(methname), flags);
               break;
           case 1:
               gv = gv_fetchmethod_sv_flags(stash, methname, flags);
               break;
           case 2:
               gv = gv_fetchmethod_pv_flags(stash, SvPV_nolen(methname), flags | SvUTF8(methname));
               break;
           case 3: {
               STRLEN len;
               const char * const name = SvPV_const(methname, len);
               gv = gv_fetchmethod_pvn_flags(stash, name, len, flags | SvUTF8(methname));
               break;
            }
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 3774 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_autoload_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_autoload_type)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "stash, methname, type, method");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HV*	stash;
	SV*	methname = ST(1)
;
	int	type = (int)SvIV(ST(2))
;
	I32	method = (I32)SvIV(ST(3))
;
#line 2361 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(methname, len);
	GV* gv = NULL;
	I32 flags = method ? GV_AUTOLOAD_ISMETHOD : 0;
#line 3802 "APItest.c"

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    stash = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::gv_autoload_type",
				"stash");
		}
	} STMT_END
;
#line 2366 "APItest.xs"
        switch (type) {
           case 0:
	       gv = gv_autoload4(stash, name, len, method);
               break;
           case 1:
               gv = gv_autoload_sv(stash, methname, flags);
               break;
           case 2:
               gv = gv_autoload_pv(stash, name, flags | SvUTF8(methname));
               break;
           case 3:
               gv = gv_autoload_pvn(stash, name, len, flags | SvUTF8(methname));
               break;
        }
	XPUSHs( gv ? (SV*)gv : &PL_sv_undef);
#line 3833 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_gv_const_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_gv_const_sv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
#line 2385 "APItest.xs"
        GV *gv;
#line 3849 "APItest.c"
	SV *	RETVAL;
	SV *	name = ST(0)
;
#line 2387 "APItest.xs"
        if (SvPOK(name)) {
	    HV *stash = gv_stashpv("main",0);
	    HE *he = hv_fetch_ent(stash, name, 0, 0);
	    gv = (GV *)HeVAL(he);
        }
	else {
	    gv = (GV *)name;
        }
        RETVAL = gv_const_sv(gv);
        if (!RETVAL)
            XSRETURN_EMPTY;
	RETVAL = newSVsv(RETVAL);
#line 3866 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_whichsig_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_whichsig_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "namesv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	namesv = ST(0)
;
	int	type = (int)SvIV(ST(1))
;
#line 2407 "APItest.xs"
        STRLEN len;
        const char * const name = SvPV_const(namesv, len);
        I32 i = 0;
#line 3891 "APItest.c"
#line 2411 "APItest.xs"
        switch (type) {
           case 0:
              i = whichsig(name);
               break;
           case 1:
               i = whichsig_sv(namesv);
               break;
           case 2:
               i = whichsig_pv(name);
               break;
           case 3:
               i = whichsig_pvn(name, len);
               break;
        }
        XPUSHs(sv_2mortal(newSViv(i)));
#line 3908 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_sv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_sv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, flags");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	sv = ST(0)
;
	I32	flags = (I32)SvIV(ST(1))
;
#line 2432 "APItest.xs"
    	I32 i;
#line 3930 "APItest.c"
#line 2434 "APItest.xs"
	PUTBACK;
	i = eval_sv(sv, flags);
	SPAGAIN;
	EXTEND(SP, 1);
	PUSHs(sv_2mortal(newSViv(i)));
#line 3937 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_eval_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_eval_pv)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "p, croak_on_error");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	p = (const char *)SvPV_nolen(ST(0))
;
	I32	croak_on_error = (I32)SvIV(ST(1))
;
#line 2445 "APItest.xs"
	PUTBACK;
	EXTEND(SP, 1);
	PUSHs(eval_pv(p, croak_on_error));
#line 3961 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_require_pv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_require_pv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	pv = (const char *)SvPV_nolen(ST(0))
;
#line 2453 "APItest.xs"
	PUTBACK;
	require_pv(pv);
#line 3982 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_apitest_exception); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_apitest_exception)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "throw_e");
    {
	int	throw_e = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = apitest_exception(throw_e);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_mycroak); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_mycroak)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV*	sv = ST(0)
;
#line 2466 "APItest.xs"
    if (SvOK(sv)) {
        Perl_croak(aTHX_ "%s", SvPV_nolen(sv));
    }
    else {
	Perl_croak(aTHX_ NULL);
    }
#line 4024 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_strtab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_strtab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 2476 "APItest.xs"
   RETVAL = newRV_inc((SV*)PL_strtab);
#line 4040 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_getint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getint)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 2483 "APItest.xs"
	dMY_CXT;
	RETVAL = my_cxt_getint_p(aMY_CXT);
#line 4060 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_cxt_setint); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setint)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "i");
    {
	int	i = (int)SvIV(ST(0))
;
#line 2492 "APItest.xs"
	dMY_CXT;
	my_cxt_setint_p(aMY_CXT_ i);
#line 4079 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_my_cxt_getsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_getsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "how");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	bool	how = (bool)SvTRUE(ST(0))
;
#line 2499 "APItest.xs"
	EXTEND(SP, 1);
	ST(0) = how ? my_cxt_getsv_interp_context() : my_cxt_getsv_interp();
	XSRETURN(1);
#line 4100 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_cxt_setsv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_cxt_setsv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 2507 "APItest.xs"
	dMY_CXT;
	SvREFCNT_dec(MY_CXT.sv);
	my_cxt_setsv_p(sv _aMY_CXT);
	SvREFCNT_inc(sv);
#line 4121 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_core)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_core();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_setsv_cow_hashkey_notcore)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;

	RETVAL = sv_setsv_cow_hashkey_notcore();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_set_deref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_set_deref)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sv, sv2, which");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
	int	which = (int)SvIV(ST(2))
;
#line 2521 "APItest.xs"
    {
	STRLEN len;
	const char *pv = SvPV(sv2,len);
	if (!SvROK(sv)) croak("Not a ref");
	sv = SvRV(sv);
	switch (which) {
	    case 0: sv_setsv(sv,sv2); break;
	    case 1: sv_setpv(sv,pv); break;
	    case 2: sv_setpvn(sv,pv,len); break;
	}
    }
#line 4184 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_rmagical_cast); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_cast)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, type");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
	SV *	type = ST(1)
;
#line 2538 "APItest.xs"
	struct ufuncs uf;
#line 4205 "APItest.c"
#line 2540 "APItest.xs"
	if (!SvOK(sv) || !SvROK(sv) || !SvOK(type)) { XSRETURN_UNDEF; }
	sv = SvRV(sv);
	if (SvTYPE(sv) != SVt_PVHV) { XSRETURN_UNDEF; }
	uf.uf_val = rmagical_a_dummy;
	uf.uf_set = NULL;
	uf.uf_index = 0;
	if (SvTRUE(type)) { /* b */
	    sv_magicext(sv, NULL, PERL_MAGIC_ext, &rmagical_b, NULL, 0);
	} else { /* a */
	    sv_magic(sv, NULL, PERL_MAGIC_uvar, (char *) &uf, sizeof(uf));
	}
	XSRETURN_YES;
#line 4219 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_rmagical_flags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rmagical_flags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 2557 "APItest.xs"
	if (!SvOK(sv) || !SvROK(sv)) { XSRETURN_UNDEF; }
	sv = SvRV(sv);
        EXTEND(SP, 3); 
	mXPUSHu(SvFLAGS(sv) & SVs_GMG);
	mXPUSHu(SvFLAGS(sv) & SVs_SMG);
	mXPUSHu(SvFLAGS(sv) & SVs_RMG);
        XSRETURN(3);
#line 4245 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_my_caller); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_caller)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "level");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	I32	level = (I32)SvIV(ST(0))
;
#line 2569 "APItest.xs"
        const PERL_CONTEXT *cx, *dbcx;
        const char *pv;
        const GV *gv;
        HV *hv;
#line 4268 "APItest.c"
#line 2574 "APItest.xs"
        cx = caller_cx(level, &dbcx);
        EXTEND(SP, 8);

        pv = CopSTASHPV(cx->blk_oldcop);
        ST(0) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(cx->blk_sub.cv);
        ST(1) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        pv = CopSTASHPV(dbcx->blk_oldcop);
        ST(2) = pv ? sv_2mortal(newSVpv(pv, 0)) : &PL_sv_undef;
        gv = CvGV(dbcx->blk_sub.cv);
        ST(3) = isGV(gv) ? sv_2mortal(newSVpv(GvNAME(gv), 0)) : &PL_sv_undef;

        ST(4) = cop_hints_fetch_pvs(cx->blk_oldcop, "foo", 0);
        ST(5) = cop_hints_fetch_pvn(cx->blk_oldcop, "foo", 3, 0, 0);
        ST(6) = cop_hints_fetch_sv(cx->blk_oldcop, 
                sv_2mortal(newSVpvs("foo")), 0, 0);

        hv = cop_hints_2hv(cx->blk_oldcop, 0);
        ST(7) = hv ? sv_2mortal(newRV_noinc((SV *)hv)) : &PL_sv_undef;

        XSRETURN(8);
#line 4292 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_DPeek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_DPeek)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0)
;
#line 2602 "APItest.xs"
    ST (0) = newSVpv (Perl_sv_peek (aTHX_ sv), 0);
    XSRETURN (1);
#line 4313 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_BEGIN); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_BEGIN)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2608 "APItest.xs"
	sv_inc(get_sv("XS::APItest::BEGIN_called", GV_ADD|GV_ADDMULTI));
#line 4329 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_CHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_CHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2613 "APItest.xs"
	sv_inc(get_sv("XS::APItest::CHECK_called", GV_ADD|GV_ADDMULTI));
#line 4344 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_UNITCHECK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_UNITCHECK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2618 "APItest.xs"
	sv_inc(get_sv("XS::APItest::UNITCHECK_called", GV_ADD|GV_ADDMULTI));
#line 4359 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_INIT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_INIT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2623 "APItest.xs"
	sv_inc(get_sv("XS::APItest::INIT_called", GV_ADD|GV_ADDMULTI));
#line 4374 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_END); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_END)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2628 "APItest.xs"
	sv_inc(get_sv("XS::APItest::END_called", GV_ADD|GV_ADDMULTI));
#line 4389 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_utf16_to_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_utf16_to_utf8)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "sv, ...");
    {
	SV*	sv = ST(0)
;
#line 2636 "APItest.xs"
        STRLEN len;
	U8 *source;
	SV *dest;
	I32 got; /* Gah, badly thought out APIs */
#line 4410 "APItest.c"
#line 2641 "APItest.xs"
	if (ix) (void)SvPV_force_nolen(sv);
	source = (U8 *)SvPVbyte(sv, len);
	/* Optionally only convert part of the buffer.  */ 	
	if (items > 1) {
	    len = SvUV(ST(1));
 	}
	/* Mortalise this right now, as we'll be testing croak()s  */
	dest = sv_2mortal(newSV(len * 3 / 2 + 1));
	if (ix) {
	    utf16_to_utf8_reversed(source, (U8 *)SvPVX(dest), len, &got);
	} else {
	    utf16_to_utf8(source, (U8 *)SvPVX(dest), len, &got);
	}
	SvCUR_set(dest, got);
	SvPVX(dest)[got] = '\0';
	SvPOK_on(dest);
 	ST(0) = dest;
	XSRETURN(1);
#line 4430 "APItest.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_my_exit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_my_exit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "exitcode");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	exitcode = (int)SvIV(ST(0))
;
#line 2663 "APItest.xs"
        my_exit(exitcode);
#line 4449 "APItest.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XS__APItest_first_byte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_first_byte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
	U8	RETVAL;
	dXSTARG;
#line 2669 "APItest.xs"
    char *s;
    STRLEN len;
	s = SvPVbyte(sv, len);
	RETVAL = s[0];
#line 4472 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_count)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	I32	RETVAL;
	dXSTARG;
#line 2679 "APItest.xs"
	    RETVAL = PL_sv_count;
#line 4490 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_bhk_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_bhk_record)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "on");
    {
	bool	on = (bool)SvTRUE(ST(0))
;
#line 2686 "APItest.xs"
        dMY_CXT;
        MY_CXT.bhk_record = on;
        if (on)
            av_clear(MY_CXT.bhkav);
#line 4511 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_magic_chain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_magic_chain)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2694 "APItest.xs"
	SV *sv;
	MAGIC *callmg, *uvarmg;
#line 4527 "APItest.c"
#line 2697 "APItest.xs"
	sv = sv_2mortal(newSV(0));
	if (SvTYPE(sv) >= SVt_PVMG) croak_fail();
	if (SvMAGICAL(sv)) croak_fail();
	sv_magic(sv, &PL_sv_yes, PERL_MAGIC_checkcall, (char*)&callmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
	callmg = mg_find(sv, PERL_MAGIC_checkcall);
	if (!callmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	uvarmg = mg_find(sv, PERL_MAGIC_uvar);
	if (!uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_vec);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_uvar);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	sv_magic(sv, &PL_sv_no, PERL_MAGIC_uvar, (char*)&uvarmg, 0);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall) != callmg) croak_fail();
	uvarmg = mg_find(sv, PERL_MAGIC_uvar);
	if (!uvarmg) croak_fail();
	if (callmg->mg_obj != &PL_sv_yes || callmg->mg_ptr != (char*)&callmg)
	    croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_checkcall);
	if (SvTYPE(sv) < SVt_PVMG) croak_fail();
	if (!SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar) != uvarmg) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
	if (uvarmg->mg_obj != &PL_sv_no || uvarmg->mg_ptr != (char*)&uvarmg)
	    croak_fail();
	mg_free_type(sv, PERL_MAGIC_uvar);
	if (SvMAGICAL(sv)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_checkcall)) croak_fail();
	if (mg_find(sv, PERL_MAGIC_uvar)) croak_fail();
#line 4587 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_contextualize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_contextualize)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2759 "APItest.xs"
	OP *o;
#line 4602 "APItest.c"
#line 2761 "APItest.xs"
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_SCALAR);
	if (o->op_type != OP_CONST ||
		(o->op_flags & OPf_WANT) != OPf_WANT_SCALAR)
	    croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_ARRAY);
	if (o->op_type != OP_CONST ||
		(o->op_flags & OPf_WANT) != OPf_WANT_LIST)
	    croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSViv(0));
	o->op_flags &= ~OPf_WANT;
	o = op_contextualize(o, G_VOID);
	if (o->op_type != OP_NULL) croak_fail();
	op_free(o);
#line 4623 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_rv2cv_op_cv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2785 "APItest.xs"
	GV *troc_gv;
	CV *troc_cv;
	OP *o;
#line 4640 "APItest.c"
#line 2789 "APItest.xs"
	troc_gv = gv_fetchpv("XS::APItest::test_rv2cv_op_cv", 0, SVt_PVGV);
	troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
	o = newCVREF(0, newGVOP(OP_GV, 0, troc_gv));
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newSVOP(OP_CONST, 0, newSVpv("XS::APItest::test_rv2cv_op_cv", 0));
	o->op_private = OPpCONST_BARE;
	o = newCVREF(0, o);
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	op_free(o);
	o = newCVREF(0, newSVOP(OP_CONST, 0, newRV_inc((SV*)troc_cv)));
	if (rv2cv_op_cv(o, 0) != troc_cv) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV) != (CV*)troc_gv)
	    croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY) != troc_cv) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newCVREF(0, newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0))));
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private |= OPpENTERSUB_AMPER;
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	o->op_private &= ~OPpENTERSUB_AMPER;
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_MARK_EARLY)) croak_fail();
	if (cUNOPx(o)->op_first->op_private & OPpEARLY_CV) croak_fail();
	op_free(o);
	o = newUNOP(OP_RAND, 0, newSVOP(OP_CONST, 0, newSViv(0)));
	if (rv2cv_op_cv(o, 0)) croak_fail();
	if (rv2cv_op_cv(o, RV2CVOPCV_RETURN_NAME_GV)) croak_fail();
	op_free(o);
#line 4693 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cv_getset_call_checker)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2844 "APItest.xs"
	CV *troc_cv, *tsh_cv;
	Perl_call_checker ckfun;
	SV *ckobj;
#line 4710 "APItest.c"
#line 2848 "APItest.xs"
#define check_cc(cv, xckfun, xckobj) \
    do { \
	cv_get_call_checker((cv), &ckfun, &ckobj); \
	if (ckfun != (xckfun)) croak_fail_ne(FPTR2DPTR(void *, ckfun), xckfun); \
	if (ckobj != (xckobj)) croak_fail_ne(FPTR2DPTR(void *, ckobj), xckobj); \
    } while(0)
	troc_cv = get_cv("XS::APItest::test_rv2cv_op_cv", 0);
	tsh_cv = get_cv("XS::APItest::test_savehints", 0);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv);
	cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    &PL_sv_yes);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes);
	cv_set_call_checker(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no);
	check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, &PL_sv_yes);
	cv_set_call_checker(tsh_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)tsh_cv);
	check_cc(troc_cv, THX_ck_entersub_args_scalars, &PL_sv_no);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv);
	cv_set_call_checker(troc_cv, Perl_ck_entersub_args_proto_or_list,
				    (SV*)troc_cv);
	check_cc(troc_cv, Perl_ck_entersub_args_proto_or_list, (SV*)troc_cv);
	check_cc(tsh_cv, Perl_ck_entersub_args_proto_or_list, (SV*)tsh_cv);
	if (SvMAGICAL((SV*)troc_cv) || SvMAGIC((SV*)troc_cv)) croak_fail();
	if (SvMAGICAL((SV*)tsh_cv) || SvMAGIC((SV*)tsh_cv)) croak_fail();
#undef check_cc
#line 4740 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_lists)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_lists",
				"cv");
		}
	} STMT_END
;
#line 2880 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_args_lists, &PL_sv_undef);
#line 4770 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_scalars)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_scalars",
				"cv");
		}
	} STMT_END
;
#line 2885 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_args_scalars, &PL_sv_undef);
#line 4800 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto",
				"cv");
		}
	} STMT_END
;
#line 2890 "APItest.xs"
	if (SvROK(proto))
	    proto = SvRV(proto);
	cv_set_call_checker(cv, Perl_ck_entersub_args_proto, proto);
#line 4834 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_proto_or_list)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cv, proto");
    {
	CV *	cv;
	SV *	proto = ST(1)
;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_proto_or_list",
				"cv");
		}
	} STMT_END
;
#line 2897 "APItest.xs"
	if (SvROK(proto))
	    proto = SvRV(proto);
	cv_set_call_checker(cv, Perl_ck_entersub_args_proto_or_list, proto);
#line 4868 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_set_call_checker_multi_sum)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::cv_set_call_checker_multi_sum",
				"cv");
		}
	} STMT_END
;
#line 2904 "APItest.xs"
	cv_set_call_checker(cv, THX_ck_entersub_multi_sum, &PL_sv_undef);
#line 4898 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_cophh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_cophh)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2909 "APItest.xs"
	COPHH *a, *b;
#line 4913 "APItest.c"
#line 2911 "APItest.xs"
#define check_ph(EXPR) \
    	    do { if((EXPR) != &PL_sv_placeholder) croak("fail"); } while(0)
#define check_iv(EXPR, EXPECT) \
    	    do { if(SvIV(EXPR) != (EXPECT)) croak("fail"); } while(0)
#define msvpvs(STR) sv_2mortal(newSVpvs(STR))
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
	a = cophh_new_empty();
	check_ph(cophh_fetch_pvn(a, "foo_1", 5, 0, 0));
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pv(a, "foo_1", 0, 0));
	check_ph(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0));
	a = cophh_store_pvn(a, "foo_1abc", 5, 0, msviv(111), 0);
	a = cophh_store_pvs(a, "foo_2", msviv(222), 0);
	a = cophh_store_pv(a, "foo_3", 0, msviv(333), 0);
	a = cophh_store_sv(a, msvpvs("foo_4"), 0, msviv(444), 0);
	check_iv(cophh_fetch_pvn(a, "foo_1xyz", 5, 0, 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
	check_iv(cophh_fetch_pv(a, "foo_1", 0, 0), 111);
	check_iv(cophh_fetch_sv(a, msvpvs("foo_1"), 0, 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	b = cophh_copy(a);
	b = cophh_store_pvs(b, "foo_1", msviv(1111), 0);
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 111);
	check_iv(cophh_fetch_pvs(a, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_iv(cophh_fetch_pvs(b, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(b, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	a = cophh_delete_pvn(a, "foo_1abc", 5, 0, 0);
	a = cophh_delete_pvs(a, "foo_2", 0);
	b = cophh_delete_pv(b, "foo_3", 0, 0);
	b = cophh_delete_sv(b, msvpvs("foo_4"), 0, 0);
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pvs(a, "foo_2", 0));
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_ph(cophh_fetch_pvs(b, "foo_3", 0));
	check_ph(cophh_fetch_pvs(b, "foo_4", 0));
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	b = cophh_delete_pvs(b, "foo_3", 0);
	b = cophh_delete_pvs(b, "foo_5", 0);
	check_iv(cophh_fetch_pvs(b, "foo_1", 0), 1111);
	check_iv(cophh_fetch_pvs(b, "foo_2", 0), 222);
	check_ph(cophh_fetch_pvs(b, "foo_3", 0));
	check_ph(cophh_fetch_pvs(b, "foo_4", 0));
	check_ph(cophh_fetch_pvs(b, "foo_5", 0));
	cophh_free(b);
	check_ph(cophh_fetch_pvs(a, "foo_1", 0));
	check_ph(cophh_fetch_pvs(a, "foo_2", 0));
	check_iv(cophh_fetch_pvs(a, "foo_3", 0), 333);
	check_iv(cophh_fetch_pvs(a, "foo_4", 0), 444);
	check_ph(cophh_fetch_pvs(a, "foo_5", 0));
	a = cophh_store_pvs(a, "foo_1", msviv(11111), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
	a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
	check_iv(cophh_fetch_pvs(a, "foo_1", 0), 11111);
	check_iv(cophh_fetch_pvs(a, "foo_1", COPHH_KEY_UTF8), 11111);
	check_iv(cophh_fetch_pvs(a, "foo_\xaa", 0), 123);
	check_iv(cophh_fetch_pvs(a, "foo_\xc2\xaa", COPHH_KEY_UTF8), 123);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\xaa", 0));
	check_iv(cophh_fetch_pvs(a, "foo_\xbb", 0), 456);
	check_iv(cophh_fetch_pvs(a, "foo_\xc2\xbb", COPHH_KEY_UTF8), 456);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\xbb", 0));
	check_iv(cophh_fetch_pvs(a, "foo_\xcc", 0), 789);
	check_iv(cophh_fetch_pvs(a, "foo_\xc3\x8c", COPHH_KEY_UTF8), 789);
	check_ph(cophh_fetch_pvs(a, "foo_\xc2\x8c", 0));
	check_iv(cophh_fetch_pvs(a, "foo_\xd9\xa6", COPHH_KEY_UTF8), 666);
	check_ph(cophh_fetch_pvs(a, "foo_\xd9\xa6", 0));
	ENTER;
	SAVEFREECOPHH(a);
	LEAVE;
#undef check_ph
#undef check_iv
#undef msvpvs
#undef msviv
#line 5002 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_coplabel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_coplabel)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3002 "APItest.xs"
        COP *cop;
        const char *label;
        STRLEN len;
        U32 utf8;
#line 5020 "APItest.c"
#line 3007 "APItest.xs"
        cop = &PL_compiling;
        Perl_cop_store_label(aTHX_ cop, "foo", 3, 0);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strcmp(label,"foo")) croak("fail # cop_fetch_label label");
        if (len != 3) croak("fail # cop_fetch_label len");
        if (utf8) croak("fail # cop_fetch_label utf8");
        /* SMALL GERMAN UMLAUT A */
        Perl_cop_store_label(aTHX_ cop, "fo\xc3\xa4", 4, SVf_UTF8);
        label = Perl_cop_fetch_label(aTHX_ cop, &len, &utf8);
        if (strcmp(label,"fo\xc3\xa4")) croak("fail # cop_fetch_label label");
        if (len != 4) croak("fail # cop_fetch_label len");
        if (!utf8) croak("fail # cop_fetch_label utf8");
#line 5034 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_example_cophh_2hv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_example_cophh_2hv)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3024 "APItest.xs"
	COPHH *a;
#line 5049 "APItest.c"
	HV *	RETVAL;
#line 3026 "APItest.xs"
#define msviv(VALUE) sv_2mortal(newSViv(VALUE))
	a = cophh_new_empty();
	a = cophh_store_pvs(a, "foo_0", msviv(999), 0);
	a = cophh_store_pvs(a, "foo_1", msviv(111), 0);
	a = cophh_store_pvs(a, "foo_\xaa", msviv(123), 0);
	a = cophh_store_pvs(a, "foo_\xc2\xbb", msviv(456), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xc3\x8c", msviv(789), COPHH_KEY_UTF8);
	a = cophh_store_pvs(a, "foo_\xd9\xa6", msviv(666), COPHH_KEY_UTF8);
	a = cophh_delete_pvs(a, "foo_0", 0);
	a = cophh_delete_pvs(a, "foo_2", 0);
	RETVAL = cophh_2hv(a, 0);
	cophh_free(a);
#undef msviv
#line 5065 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_test_savehints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_savehints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3045 "APItest.xs"
	SV **svp, *sv;
#line 5086 "APItest.c"
#line 3047 "APItest.xs"
#define store_hint(KEY, VALUE) \
		sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), KEY, 1), (VALUE))
#define hint_ok(KEY, EXPECT) \
		((svp = hv_fetchs(GvHV(PL_hintgv), KEY, 0)) && \
		    (sv = *svp) && SvIV(sv) == (EXPECT) && \
		    (sv = cop_hints_fetch_pvs(&PL_compiling, KEY, 0)) && \
		    SvIV(sv) == (EXPECT))
#define check_hint(KEY, EXPECT) \
		do { if (!hint_ok(KEY, EXPECT)) croak_fail(); } while(0)
	PL_hints |= HINT_LOCALIZE_HH;
	ENTER;
	SAVEHINTS();
	PL_hints &= HINT_INTEGER;
	store_hint("t0", 123);
	store_hint("t1", 456);
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	ENTER;
	SAVEHINTS();
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	PL_hints |= HINT_INTEGER;
	store_hint("t0", 321);
	if (!(PL_hints & HINT_INTEGER)) croak_fail();
	check_hint("t0", 321); check_hint("t1", 456);
	LEAVE;
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	ENTER;
	SAVEHINTS();
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	store_hint("t1", 654);
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 654);
	LEAVE;
	if (PL_hints & HINT_INTEGER) croak_fail();
	check_hint("t0", 123); check_hint("t1", 456);
	LEAVE;
#undef store_hint
#undef hint_ok
#undef check_hint
#line 5130 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_copyhints); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_copyhints)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3093 "APItest.xs"
	HV *a, *b;
#line 5145 "APItest.c"
#line 3095 "APItest.xs"
	PL_hints |= HINT_LOCALIZE_HH;
	ENTER;
	SAVEHINTS();
	sv_setiv_mg(*hv_fetchs(GvHV(PL_hintgv), "t0", 1), 123);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
	    croak_fail();
	a = newHVhv(GvHV(PL_hintgv));
	sv_2mortal((SV*)a);
	sv_setiv_mg(*hv_fetchs(a, "t0", 1), 456);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 123)
	    croak_fail();
	b = hv_copy_hints_hv(a);
	sv_2mortal((SV*)b);
	sv_setiv_mg(*hv_fetchs(b, "t0", 1), 789);
	if (SvIV(cop_hints_fetch_pvs(&PL_compiling, "t0", 0)) != 789)
	    croak_fail();
	LEAVE;
#line 5164 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_list); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_list)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3116 "APItest.xs"
	OP *a;
#line 5179 "APItest.c"
#line 3118 "APItest.xs"
#define iv_op(iv) newSVOP(OP_CONST, 0, newSViv(iv))
#define check_op(o, expect) \
    do { \
	if (strcmp(test_op_list_describe(o), (expect))) \
	    croak("fail %s %s", test_op_list_describe(o), (expect)); \
    } while(0)
	a = op_append_elem(OP_LIST, NULL, NULL);
	check_op(a, "");
	a = op_append_elem(OP_LIST, iv_op(1), a);
	check_op(a, "const(1).");
	a = op_append_elem(OP_LIST, NULL, a);
	check_op(a, "const(1).");
	a = op_append_elem(OP_LIST, a, iv_op(2));
	check_op(a, "list[pushmark.const(1).const(2).]");
	a = op_append_elem(OP_LIST, a, iv_op(3));
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, a, NULL);
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, NULL, a);
	check_op(a, "list[pushmark.const(1).const(2).const(3).]");
	a = op_append_elem(OP_LIST, iv_op(4), a);
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]]");
	a = op_append_elem(OP_LIST, a, iv_op(5));
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]const(5).]");
	a = op_append_elem(OP_LIST, a, 
		op_append_elem(OP_LIST, iv_op(7), iv_op(6)));
	check_op(a, "list[pushmark.const(4)."
		"list[pushmark.const(1).const(2).const(3).]const(5)."
		"list[pushmark.const(7).const(6).]]");
	op_free(a);
	a = op_append_elem(OP_LINESEQ, iv_op(1), iv_op(2));
	check_op(a, "lineseq[const(1).const(2).]");
	a = op_append_elem(OP_LINESEQ, a, iv_op(3));
	check_op(a, "lineseq[const(1).const(2).const(3).]");
	op_free(a);
	a = op_append_elem(OP_LINESEQ,
		op_append_elem(OP_LIST, iv_op(1), iv_op(2)),
		iv_op(3));
	check_op(a, "lineseq[list[pushmark.const(1).const(2).]const(3).]");
	op_free(a);
	a = op_prepend_elem(OP_LIST, NULL, NULL);
	check_op(a, "");
	a = op_prepend_elem(OP_LIST, a, iv_op(1));
	check_op(a, "const(1).");
	a = op_prepend_elem(OP_LIST, a, NULL);
	check_op(a, "const(1).");
	a = op_prepend_elem(OP_LIST, iv_op(2), a);
	check_op(a, "list[pushmark.const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, iv_op(3), a);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, NULL, a);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, a, NULL);
	check_op(a, "list[pushmark.const(3).const(2).const(1).]");
	a = op_prepend_elem(OP_LIST, a, iv_op(4));
	check_op(a, "list[pushmark."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	a = op_prepend_elem(OP_LIST, iv_op(5), a);
	check_op(a, "list[pushmark.const(5)."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	a = op_prepend_elem(OP_LIST,
		op_prepend_elem(OP_LIST, iv_op(6), iv_op(7)), a);
	check_op(a, "list[pushmark.list[pushmark.const(6).const(7).]const(5)."
		"list[pushmark.const(3).const(2).const(1).]const(4).]");
	op_free(a);
	a = op_prepend_elem(OP_LINESEQ, iv_op(2), iv_op(1));
	check_op(a, "lineseq[const(2).const(1).]");
	a = op_prepend_elem(OP_LINESEQ, iv_op(3), a);
	check_op(a, "lineseq[const(3).const(2).const(1).]");
	op_free(a);
	a = op_prepend_elem(OP_LINESEQ, iv_op(3),
		op_prepend_elem(OP_LIST, iv_op(2), iv_op(1)));
	check_op(a, "lineseq[const(3).list[pushmark.const(2).const(1).]]");
	op_free(a);
	a = op_append_list(OP_LINESEQ, NULL, NULL);
	check_op(a, "");
	a = op_append_list(OP_LINESEQ, iv_op(1), a);
	check_op(a, "const(1).");
	a = op_append_list(OP_LINESEQ, NULL, a);
	check_op(a, "const(1).");
	a = op_append_list(OP_LINESEQ, a, iv_op(2));
	check_op(a, "lineseq[const(1).const(2).]");
	a = op_append_list(OP_LINESEQ, a, iv_op(3));
	check_op(a, "lineseq[const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, iv_op(4), a);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, a, NULL);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, NULL, a);
	check_op(a, "lineseq[const(4).const(1).const(2).const(3).]");
	a = op_append_list(OP_LINESEQ, a,
		op_append_list(OP_LINESEQ, iv_op(5), iv_op(6)));
	check_op(a, "lineseq[const(4).const(1).const(2).const(3)."
		"const(5).const(6).]");
	op_free(a);
	a = op_append_list(OP_LINESEQ,
		op_append_list(OP_LINESEQ, iv_op(1), iv_op(2)),
		op_append_list(OP_LIST, iv_op(3), iv_op(4)));
	check_op(a, "lineseq[const(1).const(2)."
		"list[pushmark.const(3).const(4).]]");
	op_free(a);
	a = op_append_list(OP_LINESEQ,
		op_append_list(OP_LIST, iv_op(1), iv_op(2)),
		op_append_list(OP_LINESEQ, iv_op(3), iv_op(4)));
	check_op(a, "lineseq[list[pushmark.const(1).const(2).]"
		"const(3).const(4).]");
	op_free(a);
#undef check_op
#line 5291 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_op_linklist); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_op_linklist)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3232 "APItest.xs"
        OP *o;
#line 5306 "APItest.c"
#line 3234 "APItest.xs"
#define check_ll(o, expect) \
    STMT_START { \
	if (strNE(test_op_linklist_describe(o), (expect))) \
	    croak("fail %s %s", test_op_linklist_describe(o), (expect)); \
    } STMT_END
        o = iv_op(1);
        check_ll(o, ".const1");
        op_free(o);

        o = mkUNOP(OP_NOT, iv_op(1));
        check_ll(o, ".const1.not");
        op_free(o);

        o = mkUNOP(OP_NOT, mkUNOP(OP_NEGATE, iv_op(1)));
        check_ll(o, ".const1.negate.not");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        check_ll(o, ".const1.const2.add");
        op_free(o);

        o = mkBINOP(OP_ADD, mkUNOP(OP_NOT, iv_op(1)), iv_op(2));
        check_ll(o, ".const1.not.const2.add");
        op_free(o);

        o = mkUNOP(OP_NOT, mkBINOP(OP_ADD, iv_op(1), iv_op(2)));
        check_ll(o, ".const1.const2.add.not");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ, iv_op(1), iv_op(2), iv_op(3));
        check_ll(o, ".const1.const2.const3.lineseq");
        op_free(o);

        o = mkLISTOP(OP_LINESEQ,
                mkBINOP(OP_ADD, iv_op(1), iv_op(2)),
                mkUNOP(OP_NOT, iv_op(3)),
                mkLISTOP(OP_SUBSTR, iv_op(4), iv_op(5), iv_op(6)));
        check_ll(o, ".const1.const2.add.const3.not"
                    ".const4.const5.const6.substr.lineseq");
        op_free(o);

        o = mkBINOP(OP_ADD, iv_op(1), iv_op(2));
        LINKLIST(o);
        o = mkBINOP(OP_SUBTRACT, o, iv_op(3));
        check_ll(o, ".const1.const2.add.const3.subtract");
        op_free(o);
#undef check_ll
#undef iv_op
#line 5356 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_enable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_enable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3286 "APItest.xs"
	dMY_CXT;
#line 5371 "APItest.c"
#line 3288 "APItest.xs"
	av_clear(MY_CXT.peep_recorder);
	av_clear(MY_CXT.rpeep_recorder);
	MY_CXT.peep_recording = 1;
#line 5376 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_disable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_disable)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3295 "APItest.xs"
	dMY_CXT;
#line 5391 "APItest.c"
#line 3297 "APItest.xs"
	MY_CXT.peep_recording = 0;
#line 5394 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_peep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_peep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3302 "APItest.xs"
	dMY_CXT;
#line 5409 "APItest.c"
	SV *	RETVAL;
#line 3304 "APItest.xs"
	RETVAL = newRV_inc((SV *)MY_CXT.peep_recorder);
#line 5413 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_rpeep_record); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_rpeep_record)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3311 "APItest.xs"
	dMY_CXT;
#line 5430 "APItest.c"
	SV *	RETVAL;
#line 3313 "APItest.xs"
	RETVAL = newRV_inc((SV *)MY_CXT.rpeep_recorder);
#line 5434 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_multicall_each); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_multicall_each)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "block, ...");
    {
	SV *	block = ST(0)
;
#line 3328 "APItest.xs"
{
    dMULTICALL;
    int index;
    GV *gv;
    HV *stash;
    I32 gimme = G_SCALAR;
    SV **args = &PL_stack_base[ax];
    CV *cv;

    if(items <= 1) {
	XSRETURN_UNDEF;
    }
    cv = sv_2cv(block, &stash, &gv, 0);
    if (cv == Nullcv) {
       croak("multicall_each: not a subroutine reference");
    }
    PUSH_MULTICALL(cv);
    SAVESPTR(GvSV(PL_defgv));

    for(index = 1 ; index < items ; index++) {
	GvSV(PL_defgv) = args[index];
	MULTICALL;
    }
    POP_MULTICALL;
    PERL_UNUSED_VAR(newsp);
    XSRETURN_UNDEF;
}
#line 5479 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_XS__APItest_clone_with_stack); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_clone_with_stack)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3361 "APItest.xs"
{
    PerlInterpreter *interp = aTHX; /* The original interpreter */
    PerlInterpreter *interp_dup;    /* The duplicate interpreter */
    int oldscope = 1; /* We are responsible for all scopes */

    interp_dup = perl_clone(interp, CLONEf_COPY_STACKS | CLONEf_CLONE_HOST );

    /* destroy old perl */
    PERL_SET_CONTEXT(interp);

    POPSTACK_TO(PL_mainstack);
    dounwind(-1);
    LEAVE_SCOPE(0);

    while (interp->Iscopestack_ix > 1)
        LEAVE;
    FREETMPS;

    perl_destruct(interp);
    perl_free(interp);

    /* switch to new perl */
    PERL_SET_CONTEXT(interp_dup);

    /* continue after 'clone_with_stack' */
    if (interp_dup->Iop)
	interp_dup->Iop = interp_dup->Iop->op_next;

    /* run with new perl */
    Perl_runops_standard(interp_dup);

    /* We may have additional unclosed scopes if fork() was called
     * from within a BEGIN block.  See perlfork.pod for more details.
     * We cannot clean up these other scopes because they belong to a
     * different interpreter, but we also cannot leave PL_scopestack_ix
     * dangling because that can trigger an assertion in perl_destruct().
     */
    if (PL_scopestack_ix > oldscope) {
        PL_scopestack[oldscope-1] = PL_scopestack[PL_scopestack_ix-1];
        PL_scopestack_ix = oldscope;
    }

    perl_destruct(interp_dup);
    perl_free(interp_dup);

    /* call the real 'exit' not PerlProc_exit */
#undef exit
    exit(0);
}
#line 5545 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#endif /* USE_ITHREDS */

XS_EUPXS(XS_XS__APItest_take_svref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_svref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SVREF	sv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    sv = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::take_svref",
				"sv");
		}
	} STMT_END
;
#line 3416 "APItest.xs"
    RETVAL = newRV_inc(sv);
#line 5577 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_avref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_avref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "av");
    {
	SV *	RETVAL;
	AV*	av;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::take_avref",
				"av");
		}
	} STMT_END
;
#line 3423 "APItest.xs"
    RETVAL = newRV_inc((SV*)av);
#line 5610 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_hvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_hvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV*	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::take_hvref",
				"hv");
		}
	} STMT_END
;
#line 3430 "APItest.xs"
    RETVAL = newRV_inc((SV*)hv);
#line 5643 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_take_cvref); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_take_cvref)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	SV *	RETVAL;
	CV*	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::take_cvref",
				"cv");
		}
	} STMT_END
;
#line 3438 "APItest.xs"
    RETVAL = newRV_inc((SV*)cv);
#line 5676 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_establish_cleanup); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_establish_cleanup)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 3487 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("establish_cleanup called as a function");
#line 5693 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_postinc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_postinc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 3500 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("postinc called as a function");
#line 5708 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_filter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_filter)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3506 "APItest.xs"
    filter_add(filter_call, NULL);
#line 5723 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_lv_temp_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lv_temp_object)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SV *	RETVAL;
#line 3517 "APItest.xs"
    RETVAL =
	  sv_bless(
	    newRV_noinc(newSV(0)),
	    gv_stashpvs("XS::APItest::TempObj",GV_ADD)
	  );             /* Package defined in test script */
#line 5743 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fill_hash_with_nulls)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
#line 3528 "APItest.xs"
    UV i = 0;
#line 5760 "APItest.c"
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::fill_hash_with_nulls",
				"hv");
		}
	} STMT_END
;
#line 3530 "APItest.xs"
    for(; i < 1000; ++i) {
	HE *entry = hv_fetch_ent(hv, sv_2mortal(newSVuv(i)), 1, 0);
	SvREFCNT_dec(HeVAL(entry));
	HeVAL(entry) = NULL;
    }
#line 5782 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_newHVhv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newHVhv)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	HV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::newHVhv",
				"hv");
		}
	} STMT_END
;
#line 3539 "APItest.xs"
    RETVAL = newHVhv(hv);
#line 5813 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvIsCOW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvIsCOW)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	U32	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 3546 "APItest.xs"
    RETVAL = SvIsCOW(sv);
#line 5838 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_pad_scalar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_pad_scalar)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 3554 "APItest.xs"
    PERL_UNUSED_VAR(items);
    croak("pad_scalar called as a function");
#line 5854 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_fetch_pad_names); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_fetch_pad_names)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cv");
    {
	CV*	cv;
#line 3567 "APItest.xs"
  I32 i;
  PADNAMELIST *pad_namelist;
  AV *retav = newAV();
#line 5872 "APItest.c"
	SV *	RETVAL;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::fetch_pad_names",
				"cv");
		}
	} STMT_END
;
#line 3571 "APItest.xs"
  pad_namelist = PadlistNAMES(CvPADLIST(cv));

  for ( i = PadnamelistMAX(pad_namelist); i >= 0; i-- ) {
    PADNAME* name = PadnamelistARRAY(pad_namelist)[i];

    if (PadnameLEN(name)) {
        av_push(retav, newSVpadname(name));
    }
  }
  RETVAL = newRV_noinc((SV*)retav);
#line 5899 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_underscore_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_underscore_length)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3588 "APItest.xs"
    SV *u;
    U8 *pv;
    STRLEN bytelen;
#line 5918 "APItest.c"
	STRLEN	RETVAL;
	dXSTARG;
#line 3592 "APItest.xs"
    u = find_rundefsv();
    pv = (U8*)SvPV(u, bytelen);
    RETVAL = SvUTF8(u) ? utf8_length(pv, pv+bytelen) : bytelen;
#line 5925 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_stringify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_stringify)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 3601 "APItest.xs"
    (void)SvPV_nolen(sv);
#line 5943 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_HvENAME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_HvENAME)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "hv");
    {
	SV *	RETVAL;
	HV *	hv;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
		    hv = (HV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a HASH reference",
				"XS::APItest::HvENAME",
				"hv");
		}
	} STMT_END
;
#line 3606 "APItest.xs"
    RETVAL = hv && HvENAME(hv)
	      ? newSVpvn_flags(
		  HvENAME(hv),HvENAMELEN(hv),
		  (HvENAMEUTF8(hv) ? SVf_UTF8 : 0)
		)
	      : NULL;
#line 5979 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	int	RETVAL;
	dXSTARG;
	int	a = (int)SvIV(ST(0))
;
	int	b = (int)SvIV(ST(1))
;
#line 3618 "APItest.xs"
    /* Odd sorting (odd numbers first), to make sure we are actually
       being called */
    RETVAL = a % 2 != b % 2
	       ? a % 2 ? -1 : 1
	       : a < b ? -1 : a == b ? 0 : 1;
#line 6006 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_xs_cmp_undef); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_xs_cmp_undef)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "a, b");
    {
	SV *	RETVAL;
	SV *	a = ST(0)
;
	SV *	b = ST(1)
;
#line 3629 "APItest.xs"
    PERL_UNUSED_ARG(a);
    PERL_UNUSED_ARG(b);
    RETVAL = &PL_sv_undef;
#line 6029 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVbyte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVbyte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 3638 "APItest.xs"
    RETVAL = SvPVbyte_nolen(sv);
#line 6050 "APItest.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_SvPVutf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_SvPVutf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	char *	RETVAL;
	dXSTARG;
	SV *	sv = ST(0)
;
#line 3645 "APItest.xs"
    RETVAL = SvPVutf8_nolen(sv);
#line 6070 "APItest.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_setup_addissub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_addissub)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3652 "APItest.xs"
    wrap_op_checker(OP_ADD, addissub_myck_add, &addissub_nxck_add);
#line 6086 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_setup_rv2cv_addunderbar)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3657 "APItest.xs"
    wrap_op_checker(OP_RV2CV, my_ck_rv2cv, &old_ck_rv2cv);
#line 6101 "APItest.c"
    }
    XSRETURN_EMPTY;
}

#ifdef USE_ITHREADS
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_XS__APItest_test_alloccopstash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_alloccopstash)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 3664 "APItest.xs"
    RETVAL = PL_stashpad[alloccopstash(PL_defstash)] == PL_defstash;
#line 6120 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newFOROP_without_slab)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 3673 "APItest.xs"
    {
	const I32 floor = start_subparse(0,0);
	OP *o;
	/* The slab allocator does not like CvROOT being set. */
	CvROOT(PL_compcv) = (OP *)1;
	o = newFOROP(0, 0, newOP(OP_PUSHMARK, 0), 0, 0);
#ifdef PERL_OP_PARENT
	if (cLOOPx(cUNOPo->op_first)->op_last->op_sibparent
		!= cUNOPo->op_first)
	{
	    Perl_warn(aTHX_ "Op parent pointer is stale");
	    RETVAL = FALSE;
	}
	else
#endif
	    /* If we do not crash before returning, the test passes. */
	    RETVAL = TRUE;
	op_free(o);
	CvROOT(PL_compcv) = NULL;
	SvREFCNT_dec(PL_compcv);
	LEAVE_SCOPE(floor);
    }
#line 6159 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_callregexec); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_callregexec)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "prog, stringarg, strend, minend, sv, nosave");
    {
	I32	RETVAL;
	dXSTARG;
	SV *	prog = ST(0)
;
	STRLEN	stringarg = (STRLEN)SvUV(ST(1))
;
	STRLEN	strend = (STRLEN)SvUV(ST(2))
;
	I32	minend = (I32)SvIV(ST(3))
;
	SV *	sv = ST(4)
;
	U32	nosave = (unsigned long)SvUV(ST(5))
;
#line 3704 "APItest.xs"
    {
	STRLEN len;
	char *strbeg;
	if (SvROK(prog))
	    prog = SvRV(prog);
	strbeg = SvPV_force(sv, len);
	RETVAL = CALLREGEXEC((REGEXP *)prog,
			    strbeg + stringarg,
			    strbeg + strend,
			    strbeg,
			    minend,
			    sv,
			    NULL, /* data */
			    nosave);
    }
#line 6203 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_lexical_import); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_lexical_import)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, cv");
    {
	SV *	name = ST(0)
;
	CV *	cv;

	STMT_START {
                HV *st;
                GV *gvp;
		SV * const xsub_tmp_sv = ST(1);
		SvGETMAGIC(xsub_tmp_sv);
                cv = sv_2cv(xsub_tmp_sv, &st, &gvp, 0);
		if (!cv) {
		    Perl_croak_nocontext("%s: %s is not a CODE reference",
				"XS::APItest::lexical_import",
				"cv");
		}
	} STMT_END
;
#line 3725 "APItest.xs"
    {
	PADLIST *pl;
	PADOFFSET off;
	if (!PL_compcv)
	    Perl_croak(aTHX_
		      "lexical_import can only be called at compile time");
	pl = CvPADLIST(PL_compcv);
	ENTER;
	SAVESPTR(PL_comppad_name); PL_comppad_name = PadlistNAMES(pl);
	SAVESPTR(PL_comppad);	   PL_comppad	   = PadlistARRAY(pl)[1];
	SAVESPTR(PL_curpad);	   PL_curpad	   = PadARRAY(PL_comppad);
	off = pad_add_name_sv(sv_2mortal(newSVpvf("&%"SVf,name)),
			      padadd_STATE, 0, 0);
	SvREFCNT_dec(PL_curpad[off]);
	PL_curpad[off] = SvREFCNT_inc(cv);
	LEAVE;
    }
#line 6252 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_sv_mortalcopy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_mortalcopy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 3746 "APItest.xs"
	RETVAL = SvREFCNT_inc(sv_mortalcopy(sv));
#line 6270 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_newRV); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_newRV)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;

	RETVAL = newRV(sv);
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_alias_av); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_alias_av)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "av, ix, sv");
    {
	AV *	av;
	IV	ix = (IV)SvIV(ST(1))
;
	SV *	sv = ST(2)
;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    av = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				"XS::APItest::alias_av",
				"av");
		}
	} STMT_END
;
#line 3756 "APItest.xs"
	av_store(av, ix, SvREFCNT_inc(sv));
#line 6325 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_cv_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_cv_name)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "ref, ...");
    {
	SV *	RETVAL;
	SVREF	ref;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv)){
		    ref = SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak_nocontext("%s: %s is not a reference",
				"XS::APItest::cv_name",
				"ref");
		}
	} STMT_END
;
#line 3761 "APItest.xs"
	RETVAL = SvREFCNT_inc(cv_name((CV *)ref,
				      items>1 && ST(1) != &PL_sv_undef
					? ST(1)
					: NULL,
				      items>2 ? SvUV(ST(2)) : 0));
#line 6360 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest_sv_catpvn); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_sv_catpvn)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, sv2");
    {
	SV *	sv = ST(0)
;
	SV *	sv2 = ST(1)
;
#line 3772 "APItest.xs"
    {
	STRLEN len;
	const char *s = SvPV(sv2,len);
	sv_catpvn_flags(sv,s,len, SvUTF8(sv2) ? SV_CATUTF8 : SV_CATBYTES);
    }
#line 6385 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest_test_newOP_CUSTOM)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	bool	RETVAL;
#line 3781 "APItest.xs"
    {
	OP *o = newLISTOP(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newOP(OP_CUSTOM, 0);
	op_free(o);
	o = newUNOP(OP_CUSTOM, 0, NULL);
	op_free(o);
	o = newUNOP_AUX(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newMETHOP(OP_CUSTOM, 0, newOP(OP_NULL,0));
	op_free(o);
	o = newMETHOP_named(OP_CUSTOM, 0, newSV(0));
	op_free(o);
	o = newBINOP(OP_CUSTOM, 0, NULL, NULL);
	op_free(o);
	o = newPMOP(OP_CUSTOM, 0);
	op_free(o);
	o = newSVOP(OP_CUSTOM, 0, newSV(0));
	op_free(o);
#ifdef USE_ITHREADS
	ENTER;
	lex_start(NULL, NULL, 0);
	{
	    I32 ix = start_subparse(FALSE,0);
	    o = newPADOP(OP_CUSTOM, 0, newSV(0));
	    op_free(o);
	    LEAVE_SCOPE(ix);
	}
	LEAVE;
#endif
	o = newPVOP(OP_CUSTOM, 0, NULL);
	op_free(o);
	o = newLOGOP(OP_CUSTOM, 0, newOP(OP_NULL,0), newOP(OP_NULL,0));
	op_free(o);
	o = newLOOPEX(OP_CUSTOM, newOP(OP_NULL,0));
	op_free(o);
	RETVAL = TRUE;
    }
#line 6438 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__AUTOLOADtest_AUTOLOAD)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	RETVAL;
	dXSTARG;
#line 3827 "APItest.xs"
    SV* comms;
    SV* class_and_method;
#line 6456 "APItest.c"
#line 3830 "APItest.xs"
    PERL_UNUSED_ARG(items);
    class_and_method = GvSV(CvGV(cv));
    comms = get_sv("main::the_method", 1);
    if (class_and_method == NULL) {
      RETVAL = 1;
    } else if (!SvOK(class_and_method)) {
      RETVAL = 2;
    } else if (!SvPOK(class_and_method)) {
      RETVAL = 3;
    } else {
      sv_setsv(comms, class_and_method);
      RETVAL = 0;
    }
#line 6471 "APItest.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 3855 "APItest.xs"
    sv_magicext(SvRV(sv), NULL, PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo, (const char *)thingy, 0);
#line 6492 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_mg_find_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 3862 "APItest.xs"
    MAGIC *mg = mg_findext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
    RETVAL = mg ? SvREFCNT_inc((SV *)mg->mg_ptr) : &PL_sv_undef;
#line 6512 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_unmagic_foo)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 3872 "APItest.xs"
    sv_unmagicext(SvRV(sv), PERL_MAGIC_ext, ix ? &vtbl_bar : &vtbl_foo);
#line 6532 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_sv_magic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_sv_magic)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sv, thingy");
    {
	SV *	sv = ST(0)
;
	SV *	thingy = ST(1)
;
#line 3877 "APItest.xs"
    sv_magic(SvRV(sv), NULL, PERL_MAGIC_ext, (const char *)thingy, 0);
#line 6551 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_get_vtbl)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 3882 "APItest.xs"
	MGVTBL *have;
	MGVTBL *want;
#line 6567 "APItest.c"
	UV	RETVAL;
	dXSTARG;
#line 3885 "APItest.xs"
#define test_get_this_vtable(name) \
	want = (MGVTBL*)CAT2(&PL_vtbl_, name); \
	have = get_vtbl(CAT2(want_vtbl_, name)); \
	if (have != want) \
	    croak("fail %p!=%p for get_vtbl(want_vtbl_" STRINGIFY(name) ") at " __FILE__ " line %d", have, want, __LINE__)

	test_get_this_vtable(sv);
	test_get_this_vtable(env);
	test_get_this_vtable(envelem);
	test_get_this_vtable(sigelem);
	test_get_this_vtable(pack);
	test_get_this_vtable(packelem);
	test_get_this_vtable(dbline);
	test_get_this_vtable(isa);
	test_get_this_vtable(isaelem);
	test_get_this_vtable(arylen);
	test_get_this_vtable(mglob);
	test_get_this_vtable(nkeys);
	test_get_this_vtable(taint);
	test_get_this_vtable(substr);
	test_get_this_vtable(vec);
	test_get_this_vtable(pos);
	test_get_this_vtable(bm);
	test_get_this_vtable(fm);
	test_get_this_vtable(uvar);
	test_get_this_vtable(defelem);
	test_get_this_vtable(regexp);
	test_get_this_vtable(regdata);
	test_get_this_vtable(regdatum);
#ifdef USE_LOCALE_COLLATE
	test_get_this_vtable(collxfrm);
#endif
	test_get_this_vtable(backref);
	test_get_this_vtable(utf8);

	RETVAL = PTR2UV(get_vtbl(-1));
#line 6607 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3927 "APItest.xs"
        RETVAL = isBLANK_uni(ord);
#line 6626 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3934 "APItest.xs"
        RETVAL = isBLANK_LC_uvchr(ord);
#line 6645 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3941 "APItest.xs"
        RETVAL = isBLANK_A(ord);
#line 6664 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3948 "APItest.xs"
        RETVAL = isBLANK_L1(ord);
#line 6683 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3955 "APItest.xs"
        RETVAL = isBLANK_LC(ord);
#line 6702 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 3962 "APItest.xs"
        RETVAL = isBLANK_utf8(p);
#line 6721 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isBLANK_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 3969 "APItest.xs"
        RETVAL = isBLANK_LC_utf8(p);
#line 6740 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3976 "APItest.xs"
        RETVAL = isVERTWS_uni(ord);
#line 6759 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isVERTWS_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 3983 "APItest.xs"
        RETVAL = isVERTWS_utf8(p);
#line 6778 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3990 "APItest.xs"
        RETVAL = isUPPER_uni(ord);
#line 6797 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 3997 "APItest.xs"
        RETVAL = isUPPER_LC_uvchr(ord);
#line 6816 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4004 "APItest.xs"
        RETVAL = isUPPER_A(ord);
#line 6835 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4011 "APItest.xs"
        RETVAL = isUPPER_L1(ord);
#line 6854 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4018 "APItest.xs"
        RETVAL = isUPPER_LC(ord);
#line 6873 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4025 "APItest.xs"
        RETVAL = isUPPER_utf8( p);
#line 6892 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isUPPER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4032 "APItest.xs"
        RETVAL = isUPPER_LC_utf8( p);
#line 6911 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4039 "APItest.xs"
        RETVAL = isLOWER_uni(ord);
#line 6930 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4046 "APItest.xs"
        RETVAL = isLOWER_LC_uvchr(ord);
#line 6949 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4053 "APItest.xs"
        RETVAL = isLOWER_A(ord);
#line 6968 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4060 "APItest.xs"
        RETVAL = isLOWER_L1(ord);
#line 6987 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4067 "APItest.xs"
        RETVAL = isLOWER_LC(ord);
#line 7006 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4074 "APItest.xs"
        RETVAL = isLOWER_utf8( p);
#line 7025 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isLOWER_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4081 "APItest.xs"
        RETVAL = isLOWER_LC_utf8( p);
#line 7044 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4088 "APItest.xs"
        RETVAL = isALPHA_uni(ord);
#line 7063 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4095 "APItest.xs"
        RETVAL = isALPHA_LC_uvchr(ord);
#line 7082 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4102 "APItest.xs"
        RETVAL = isALPHA_A(ord);
#line 7101 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4109 "APItest.xs"
        RETVAL = isALPHA_L1(ord);
#line 7120 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4116 "APItest.xs"
        RETVAL = isALPHA_LC(ord);
#line 7139 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4123 "APItest.xs"
        RETVAL = isALPHA_utf8( p);
#line 7158 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHA_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4130 "APItest.xs"
        RETVAL = isALPHA_LC_utf8( p);
#line 7177 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4137 "APItest.xs"
        RETVAL = isWORDCHAR_uni(ord);
#line 7196 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4144 "APItest.xs"
        RETVAL = isWORDCHAR_LC_uvchr(ord);
#line 7215 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4151 "APItest.xs"
        RETVAL = isWORDCHAR_A(ord);
#line 7234 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4158 "APItest.xs"
        RETVAL = isWORDCHAR_L1(ord);
#line 7253 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4165 "APItest.xs"
        RETVAL = isWORDCHAR_LC(ord);
#line 7272 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4172 "APItest.xs"
        RETVAL = isWORDCHAR_utf8( p);
#line 7291 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4179 "APItest.xs"
        RETVAL = isWORDCHAR_LC_utf8( p);
#line 7310 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4186 "APItest.xs"
        RETVAL = isALPHANUMERIC_uni(ord);
#line 7329 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4193 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC_uvchr(ord);
#line 7348 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4200 "APItest.xs"
        RETVAL = isALPHANUMERIC_A(ord);
#line 7367 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4207 "APItest.xs"
        RETVAL = isALPHANUMERIC_L1(ord);
#line 7386 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4214 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC(ord);
#line 7405 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4221 "APItest.xs"
        RETVAL = isALPHANUMERIC_utf8( p);
#line 7424 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4228 "APItest.xs"
        RETVAL = isALPHANUMERIC_LC_utf8( p);
#line 7443 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4235 "APItest.xs"
        RETVAL = isALNUM_uni(ord);
#line 7462 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4242 "APItest.xs"
        RETVAL = isALNUM_LC_uvchr(ord);
#line 7481 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4249 "APItest.xs"
        RETVAL = isALNUM_LC(ord);
#line 7500 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4256 "APItest.xs"
        RETVAL = isALNUM_utf8( p);
#line 7519 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isALNUM_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4263 "APItest.xs"
        RETVAL = isALNUM_LC_utf8( p);
#line 7538 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4270 "APItest.xs"
        RETVAL = isDIGIT_uni(ord);
#line 7557 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4277 "APItest.xs"
        RETVAL = isDIGIT_LC_uvchr(ord);
#line 7576 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4284 "APItest.xs"
        RETVAL = isDIGIT_utf8( p);
#line 7595 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4291 "APItest.xs"
        RETVAL = isDIGIT_LC_utf8( p);
#line 7614 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4298 "APItest.xs"
        RETVAL = isDIGIT_A(ord);
#line 7633 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4305 "APItest.xs"
        RETVAL = isDIGIT_L1(ord);
#line 7652 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4312 "APItest.xs"
        RETVAL = isDIGIT_LC(ord);
#line 7671 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4319 "APItest.xs"
        RETVAL = isIDFIRST_uni(ord);
#line 7690 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4326 "APItest.xs"
        RETVAL = isIDFIRST_LC_uvchr(ord);
#line 7709 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4333 "APItest.xs"
        RETVAL = isIDFIRST_A(ord);
#line 7728 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4340 "APItest.xs"
        RETVAL = isIDFIRST_L1(ord);
#line 7747 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4347 "APItest.xs"
        RETVAL = isIDFIRST_LC(ord);
#line 7766 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4354 "APItest.xs"
        RETVAL = isIDFIRST_utf8( p);
#line 7785 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4361 "APItest.xs"
        RETVAL = isIDFIRST_LC_utf8( p);
#line 7804 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4368 "APItest.xs"
        RETVAL = isIDCONT_uni(ord);
#line 7823 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4375 "APItest.xs"
        RETVAL = isIDCONT_LC_uvchr(ord);
#line 7842 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4382 "APItest.xs"
        RETVAL = isIDCONT_A(ord);
#line 7861 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4389 "APItest.xs"
        RETVAL = isIDCONT_L1(ord);
#line 7880 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4396 "APItest.xs"
        RETVAL = isIDCONT_LC(ord);
#line 7899 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4403 "APItest.xs"
        RETVAL = isIDCONT_utf8( p);
#line 7918 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isIDCONT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4410 "APItest.xs"
        RETVAL = isIDCONT_LC_utf8( p);
#line 7937 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4417 "APItest.xs"
        RETVAL = isSPACE_uni(ord);
#line 7956 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4424 "APItest.xs"
        RETVAL = isSPACE_LC_uvchr(ord);
#line 7975 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4431 "APItest.xs"
        RETVAL = isSPACE_A(ord);
#line 7994 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4438 "APItest.xs"
        RETVAL = isSPACE_L1(ord);
#line 8013 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4445 "APItest.xs"
        RETVAL = isSPACE_LC(ord);
#line 8032 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4452 "APItest.xs"
        RETVAL = isSPACE_utf8( p);
#line 8051 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isSPACE_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4459 "APItest.xs"
        RETVAL = isSPACE_LC_utf8( p);
#line 8070 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4466 "APItest.xs"
        RETVAL = isASCII_uni(ord);
#line 8089 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4473 "APItest.xs"
        RETVAL = isASCII_LC_uvchr(ord);
#line 8108 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4480 "APItest.xs"
        RETVAL = isASCII_A(ord);
#line 8127 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4487 "APItest.xs"
        RETVAL = isASCII_L1(ord);
#line 8146 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4494 "APItest.xs"
        RETVAL = isASCII_LC(ord);
#line 8165 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4501 "APItest.xs"
        RETVAL = isASCII_utf8( p);
#line 8184 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isASCII_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4508 "APItest.xs"
        RETVAL = isASCII_LC_utf8( p);
#line 8203 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4515 "APItest.xs"
        RETVAL = isCNTRL_uni(ord);
#line 8222 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4522 "APItest.xs"
        RETVAL = isCNTRL_LC_uvchr(ord);
#line 8241 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4529 "APItest.xs"
        RETVAL = isCNTRL_A(ord);
#line 8260 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4536 "APItest.xs"
        RETVAL = isCNTRL_L1(ord);
#line 8279 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4543 "APItest.xs"
        RETVAL = isCNTRL_LC(ord);
#line 8298 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4550 "APItest.xs"
        RETVAL = isCNTRL_utf8( p);
#line 8317 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isCNTRL_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4557 "APItest.xs"
        RETVAL = isCNTRL_LC_utf8( p);
#line 8336 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4564 "APItest.xs"
        RETVAL = isPRINT_uni(ord);
#line 8355 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4571 "APItest.xs"
        RETVAL = isPRINT_LC_uvchr(ord);
#line 8374 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4578 "APItest.xs"
        RETVAL = isPRINT_A(ord);
#line 8393 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4585 "APItest.xs"
        RETVAL = isPRINT_L1(ord);
#line 8412 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4592 "APItest.xs"
        RETVAL = isPRINT_LC(ord);
#line 8431 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4599 "APItest.xs"
        RETVAL = isPRINT_utf8( p);
#line 8450 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPRINT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4606 "APItest.xs"
        RETVAL = isPRINT_LC_utf8( p);
#line 8469 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4613 "APItest.xs"
        RETVAL = isGRAPH_uni(ord);
#line 8488 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4620 "APItest.xs"
        RETVAL = isGRAPH_LC_uvchr(ord);
#line 8507 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4627 "APItest.xs"
        RETVAL = isGRAPH_A(ord);
#line 8526 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4634 "APItest.xs"
        RETVAL = isGRAPH_L1(ord);
#line 8545 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4641 "APItest.xs"
        RETVAL = isGRAPH_LC(ord);
#line 8564 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4648 "APItest.xs"
        RETVAL = isGRAPH_utf8( p);
#line 8583 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isGRAPH_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4655 "APItest.xs"
        RETVAL = isGRAPH_LC_utf8( p);
#line 8602 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4662 "APItest.xs"
        RETVAL = isPUNCT_uni(ord);
#line 8621 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4669 "APItest.xs"
        RETVAL = isPUNCT_LC_uvchr(ord);
#line 8640 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4676 "APItest.xs"
        RETVAL = isPUNCT_A(ord);
#line 8659 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4683 "APItest.xs"
        RETVAL = isPUNCT_L1(ord);
#line 8678 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4690 "APItest.xs"
        RETVAL = isPUNCT_LC(ord);
#line 8697 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4697 "APItest.xs"
        RETVAL = isPUNCT_utf8( p);
#line 8716 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPUNCT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4704 "APItest.xs"
        RETVAL = isPUNCT_LC_utf8( p);
#line 8735 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4711 "APItest.xs"
        RETVAL = isXDIGIT_uni(ord);
#line 8754 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4718 "APItest.xs"
        RETVAL = isXDIGIT_LC_uvchr(ord);
#line 8773 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4725 "APItest.xs"
        RETVAL = isXDIGIT_A(ord);
#line 8792 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4732 "APItest.xs"
        RETVAL = isXDIGIT_L1(ord);
#line 8811 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4739 "APItest.xs"
        RETVAL = isXDIGIT_LC(ord);
#line 8830 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4746 "APItest.xs"
        RETVAL = isXDIGIT_utf8( p);
#line 8849 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4753 "APItest.xs"
        RETVAL = isXDIGIT_LC_utf8( p);
#line 8868 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4760 "APItest.xs"
        RETVAL = isPSXSPC_uni(ord);
#line 8887 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4767 "APItest.xs"
        RETVAL = isPSXSPC_LC_uvchr(ord);
#line 8906 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_A); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_A)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4774 "APItest.xs"
        RETVAL = isPSXSPC_A(ord);
#line 8925 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4781 "APItest.xs"
        RETVAL = isPSXSPC_L1(ord);
#line 8944 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4788 "APItest.xs"
        RETVAL = isPSXSPC_LC(ord);
#line 8963 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4795 "APItest.xs"
        RETVAL = isPSXSPC_utf8( p);
#line 8982 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
	bool	RETVAL;
	unsigned char *	p = (unsigned char *)SvPV_nolen(ST(0))
;
#line 4802 "APItest.xs"
        RETVAL = isPSXSPC_LC_utf8( p);
#line 9001 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_isQUOTEMETA); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_isQUOTEMETA)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	bool	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4809 "APItest.xs"
        RETVAL = _isQUOTEMETA(ord);
#line 9020 "APItest.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4816 "APItest.xs"
        RETVAL = toLOWER(ord);
#line 9040 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_L1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_L1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4823 "APItest.xs"
        RETVAL = toLOWER_L1(ord);
#line 9060 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4830 "APItest.xs"
        RETVAL = toLOWER_LC(ord);
#line 9080 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 4837 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9099 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4842 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toLOWER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9113 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toLOWER_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
#line 4857 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9138 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
#line 4863 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        av_push(av, newSVuv(toLOWER_utf8(input, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9153 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4879 "APItest.xs"
        RETVAL = toFOLD(ord);
#line 9178 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4886 "APItest.xs"
        RETVAL = toFOLD_LC(ord);
#line 9198 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 4893 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9217 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4898 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toFOLD_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9231 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toFOLD_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
#line 4913 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9256 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
#line 4919 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        av_push(av, newSVuv(toFOLD_utf8(input, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9271 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4935 "APItest.xs"
        RETVAL = toUPPER(ord);
#line 9296 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_LC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_LC)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4942 "APItest.xs"
        RETVAL = toUPPER_LC(ord);
#line 9316 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 4949 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9335 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4954 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toUPPER_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9349 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toUPPER_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
#line 4969 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9374 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
#line 4975 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        av_push(av, newSVuv(toUPPER_utf8(input, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9389 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
	UV	RETVAL;
	dXSTARG;
	UV	ord = (UV)SvUV(ST(0))
;
#line 4991 "APItest.xs"
        RETVAL = toTITLE(ord);
#line 9414 "APItest.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uni); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_uni)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ord");
    {
#line 4998 "APItest.xs"
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9433 "APItest.c"
	AV *	RETVAL;
	UV	ord = (UV)SvUV(ST(0))
;
#line 5003 "APItest.xs"
        av = newAV();
        av_push(av, newSVuv(toTITLE_uni(ord, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9447 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_utf8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_toTITLE_utf8)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "p");
    {
#line 5018 "APItest.xs"
        U8 *input;
        U8 s[UTF8_MAXBYTES_CASE + 1];
        STRLEN len;
        AV *av;
        SV *utf8;
#line 9472 "APItest.c"
	AV *	RETVAL;
	SV *	p = ST(0)
;
#line 5024 "APItest.xs"
        input = (U8 *) SvPV(p, len);
        av = newAV();
        av_push(av, newSVuv(toTITLE_utf8(input, s, &len)));

        utf8 = newSVpvn((char *) s, len);
        SvUTF8_on(utf8);
        av_push(av, utf8);

        av_push(av, newSVuv(len));
        RETVAL = av;
#line 9487 "APItest.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newRV((SV*)RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Magic_test_Gconvert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Magic_test_Gconvert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "number, num_digits");
    {
#line 5040 "APItest.xs"
        char buffer[100];
        int len;
#line 9509 "APItest.c"
	SV *	RETVAL;
	SV *	number = ST(0)
;
	SV *	num_digits = ST(1)
;
#line 5043 "APItest.xs"
        len = (int) SvIV(num_digits);
        if (len > 99) croak("Too long a number for test_Gconvert");
        PERL_UNUSED_RESULT(Gconvert(SvNV(number), len,
                 0,    /* No trailing zeroes */
                 buffer));
        RETVAL = newSVpv(buffer, 0);
#line 9522 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_apitest_weaken)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 5058 "APItest.xs"
        sv_rvweaken(sv);
#line 9541 "APItest.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XS__APItest__Backrefs_has_backrefs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	RETVAL;
	SV *	sv = ST(0)
;
#line 5063 "APItest.xs"
        if (SvROK(sv) && sv_get_backrefs(SvRV(sv)))
            RETVAL = &PL_sv_yes;
        else
            RETVAL = &PL_sv_no;
#line 9562 "APItest.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_XS__APItest); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_XS__APItest)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("XS::APItest::constant", XS_XS__APItest_constant);
        newXS_deffile("XS::APItest::numeric::grok_number", XS_XS__APItest__numeric_grok_number);
        newXS_deffile("XS::APItest::numeric::grok_number_flags", XS_XS__APItest__numeric_grok_number_flags);
        newXS_deffile("XS::APItest::numeric::grok_atoUV", XS_XS__APItest__numeric_grok_atoUV);
        newXS_deffile("XS::APItest::numeric::assertx", XS_XS__APItest__numeric_assertx);
        newXS_deffile("XS::APItest::utf8::bytes_cmp_utf8", XS_XS__APItest__utf8_bytes_cmp_utf8);
        newXS_deffile("XS::APItest::utf8::test_utf8n_to_uvchr", XS_XS__APItest__utf8_test_utf8n_to_uvchr);
        newXS_deffile("XS::APItest::Overload::amagic_deref_call", XS_XS__APItest__Overload_amagic_deref_call);
        newXS_deffile("XS::APItest::Overload::tryAMAGICunDEREF_var", XS_XS__APItest__Overload_tryAMAGICunDEREF_var);
        newXS_deffile("XS::APItest::XSUB::XS_VERSION_defined", XS_XS__APItest__XSUB_XS_VERSION_defined);
        newXS_deffile("XS::APItest::XSUB::XS_APIVERSION_valid", XS_XS__APItest__XSUB_XS_APIVERSION_valid);
        newXS_deffile("XS::APItest::Hash::rot13_hash", XS_XS__APItest__Hash_rot13_hash);
        newXS_deffile("XS::APItest::Hash::bitflip_hash", XS_XS__APItest__Hash_bitflip_hash);
        newXS_deffile("XS::APItest::Hash::exists", XS_XS__APItest__Hash_exists);
        newXS_deffile("XS::APItest::Hash::exists_ent", XS_XS__APItest__Hash_exists_ent);
        newXS_deffile("XS::APItest::Hash::delete", XS_XS__APItest__Hash_delete);
        newXS_deffile("XS::APItest::Hash::delete_ent", XS_XS__APItest__Hash_delete_ent);
        newXS_deffile("XS::APItest::Hash::store_ent", XS_XS__APItest__Hash_store_ent);
        newXS_deffile("XS::APItest::Hash::store", XS_XS__APItest__Hash_store);
        newXS_deffile("XS::APItest::Hash::fetch_ent", XS_XS__APItest__Hash_fetch_ent);
        newXS_deffile("XS::APItest::Hash::fetch", XS_XS__APItest__Hash_fetch);
#if XSubPPtmpAAAA
        newXS_deffile("XS::APItest::Hash::common", XS_XS__APItest__Hash_common);
#endif
        newXS_deffile("XS::APItest::Hash::test_hv_free_ent", XS_XS__APItest__Hash_test_hv_free_ent);
        newXS_deffile("XS::APItest::Hash::test_hv_delayfree_ent", XS_XS__APItest__Hash_test_hv_delayfree_ent);
        newXS_deffile("XS::APItest::Hash::test_share_unshare_pvn", XS_XS__APItest__Hash_test_share_unshare_pvn);
#if XSubPPtmpAAAB
        newXS_deffile("XS::APItest::Hash::refcounted_he_exists", XS_XS__APItest__Hash_refcounted_he_exists);
        newXS_deffile("XS::APItest::Hash::refcounted_he_fetch", XS_XS__APItest__Hash_refcounted_he_fetch);
#endif
        newXS_deffile("XS::APItest::Hash::test_force_keys", XS_XS__APItest__Hash_test_force_keys);
        newXS_deffile("XS::APItest::TempLv::make_temp_mg_lv", XS_XS__APItest__TempLv_make_temp_mg_lv);
        newXS_deffile("XS::APItest::PtrTable::new", XS_XS__APItest__PtrTable_new);
        newXS_deffile("XS::APItest::PtrTable::DESTROY", XS_XS__APItest__PtrTable_DESTROY);
        newXS_deffile("XS::APItest::PtrTable::store", XS_XS__APItest__PtrTable_store);
        newXS_deffile("XS::APItest::PtrTable::fetch", XS_XS__APItest__PtrTable_fetch);
        newXS_deffile("XS::APItest::PtrTable::split", XS_XS__APItest__PtrTable_split);
        newXS_deffile("XS::APItest::PtrTable::clear", XS_XS__APItest__PtrTable_clear);
        newXS_deffile("XS::APItest::AutoLoader::AUTOLOAD", XS_XS__APItest__AutoLoader_AUTOLOAD);
        (void)newXSproto_portable("XS::APItest::AutoLoader::AUTOLOADp", XS_XS__APItest__AutoLoader_AUTOLOADp, file, "*$");
        newXS_deffile("XS::APItest::xop_custom_ops", XS_XS__APItest_xop_custom_ops);
        newXS_deffile("XS::APItest::xop_custom_op_names", XS_XS__APItest_xop_custom_op_names);
        newXS_deffile("XS::APItest::xop_custom_op_descs", XS_XS__APItest_xop_custom_op_descs);
        newXS_deffile("XS::APItest::xop_register", XS_XS__APItest_xop_register);
        newXS_deffile("XS::APItest::xop_clear", XS_XS__APItest_xop_clear);
        newXS_deffile("XS::APItest::xop_my_xop", XS_XS__APItest_xop_my_xop);
        newXS_deffile("XS::APItest::xop_ppaddr", XS_XS__APItest_xop_ppaddr);
        newXS_deffile("XS::APItest::xop_OA_UNOP", XS_XS__APItest_xop_OA_UNOP);
        newXS_deffile("XS::APItest::xop_build_optree", XS_XS__APItest_xop_build_optree);
        newXS_deffile("XS::APItest::xop_from_custom_op", XS_XS__APItest_xop_from_custom_op);
        newXS_deffile("XS::APItest::CLONE", XS_XS__APItest_CLONE);
        newXS_deffile("XS::APItest::print_double", XS_XS__APItest_print_double);
        newXS_deffile("XS::APItest::have_long_double", XS_XS__APItest_have_long_double);
        newXS_deffile("XS::APItest::print_long_double", XS_XS__APItest_print_long_double);
        newXS_deffile("XS::APItest::print_int", XS_XS__APItest_print_int);
        newXS_deffile("XS::APItest::print_long", XS_XS__APItest_print_long);
        newXS_deffile("XS::APItest::print_float", XS_XS__APItest_print_float);
        newXS_deffile("XS::APItest::print_flush", XS_XS__APItest_print_flush);
        newXS_deffile("XS::APItest::mpushp", XS_XS__APItest_mpushp);
        newXS_deffile("XS::APItest::mpushn", XS_XS__APItest_mpushn);
        newXS_deffile("XS::APItest::mpushi", XS_XS__APItest_mpushi);
        newXS_deffile("XS::APItest::mpushu", XS_XS__APItest_mpushu);
        newXS_deffile("XS::APItest::mxpushp", XS_XS__APItest_mxpushp);
        newXS_deffile("XS::APItest::mxpushn", XS_XS__APItest_mxpushn);
        newXS_deffile("XS::APItest::mxpushi", XS_XS__APItest_mxpushi);
        newXS_deffile("XS::APItest::mxpushu", XS_XS__APItest_mxpushu);
        newXS_deffile("XS::APItest::call_sv_C", XS_XS__APItest_call_sv_C);
        newXS_deffile("XS::APItest::call_sv", XS_XS__APItest_call_sv);
        newXS_deffile("XS::APItest::call_pv", XS_XS__APItest_call_pv);
        newXS_deffile("XS::APItest::call_method", XS_XS__APItest_call_method);
        cv = newXS_deffile("XS::APItest::newCONSTSUB", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::newCONSTSUB_flags", XS_XS__APItest_newCONSTSUB);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::gv_init_type", XS_XS__APItest_gv_init_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_type", XS_XS__APItest_gv_fetchmeth_type);
        newXS_deffile("XS::APItest::gv_fetchmeth_autoload_type", XS_XS__APItest_gv_fetchmeth_autoload_type);
        newXS_deffile("XS::APItest::gv_fetchmethod_flags_type", XS_XS__APItest_gv_fetchmethod_flags_type);
        newXS_deffile("XS::APItest::gv_autoload_type", XS_XS__APItest_gv_autoload_type);
        newXS_deffile("XS::APItest::gv_const_sv", XS_XS__APItest_gv_const_sv);
        newXS_deffile("XS::APItest::whichsig_type", XS_XS__APItest_whichsig_type);
        newXS_deffile("XS::APItest::eval_sv", XS_XS__APItest_eval_sv);
        newXS_deffile("XS::APItest::eval_pv", XS_XS__APItest_eval_pv);
        newXS_deffile("XS::APItest::require_pv", XS_XS__APItest_require_pv);
        newXS_deffile("XS::APItest::apitest_exception", XS_XS__APItest_apitest_exception);
        newXS_deffile("XS::APItest::mycroak", XS_XS__APItest_mycroak);
        newXS_deffile("XS::APItest::strtab", XS_XS__APItest_strtab);
        newXS_deffile("XS::APItest::my_cxt_getint", XS_XS__APItest_my_cxt_getint);
        newXS_deffile("XS::APItest::my_cxt_setint", XS_XS__APItest_my_cxt_setint);
        newXS_deffile("XS::APItest::my_cxt_getsv", XS_XS__APItest_my_cxt_getsv);
        newXS_deffile("XS::APItest::my_cxt_setsv", XS_XS__APItest_my_cxt_setsv);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_core", XS_XS__APItest_sv_setsv_cow_hashkey_core);
        newXS_deffile("XS::APItest::sv_setsv_cow_hashkey_notcore", XS_XS__APItest_sv_setsv_cow_hashkey_notcore);
        newXS_deffile("XS::APItest::sv_set_deref", XS_XS__APItest_sv_set_deref);
        newXS_deffile("XS::APItest::rmagical_cast", XS_XS__APItest_rmagical_cast);
        newXS_deffile("XS::APItest::rmagical_flags", XS_XS__APItest_rmagical_flags);
        newXS_deffile("XS::APItest::my_caller", XS_XS__APItest_my_caller);
        newXS_deffile("XS::APItest::DPeek", XS_XS__APItest_DPeek);
        newXS_deffile("XS::APItest::BEGIN", XS_XS__APItest_BEGIN);
        newXS_deffile("XS::APItest::CHECK", XS_XS__APItest_CHECK);
        newXS_deffile("XS::APItest::UNITCHECK", XS_XS__APItest_UNITCHECK);
        newXS_deffile("XS::APItest::INIT", XS_XS__APItest_INIT);
        newXS_deffile("XS::APItest::END", XS_XS__APItest_END);
        cv = newXS_deffile("XS::APItest::utf16_to_utf8", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::utf16_to_utf8_reversed", XS_XS__APItest_utf16_to_utf8);
        XSANY.any_i32 = 1;
        newXS_deffile("XS::APItest::my_exit", XS_XS__APItest_my_exit);
        newXS_deffile("XS::APItest::first_byte", XS_XS__APItest_first_byte);
        newXS_deffile("XS::APItest::sv_count", XS_XS__APItest_sv_count);
        newXS_deffile("XS::APItest::bhk_record", XS_XS__APItest_bhk_record);
        newXS_deffile("XS::APItest::test_magic_chain", XS_XS__APItest_test_magic_chain);
        newXS_deffile("XS::APItest::test_op_contextualize", XS_XS__APItest_test_op_contextualize);
        (void)newXSproto_portable("XS::APItest::test_rv2cv_op_cv", XS_XS__APItest_test_rv2cv_op_cv, file, "");
        newXS_deffile("XS::APItest::test_cv_getset_call_checker", XS_XS__APItest_test_cv_getset_call_checker);
        newXS_deffile("XS::APItest::cv_set_call_checker_lists", XS_XS__APItest_cv_set_call_checker_lists);
        newXS_deffile("XS::APItest::cv_set_call_checker_scalars", XS_XS__APItest_cv_set_call_checker_scalars);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto", XS_XS__APItest_cv_set_call_checker_proto);
        newXS_deffile("XS::APItest::cv_set_call_checker_proto_or_list", XS_XS__APItest_cv_set_call_checker_proto_or_list);
        newXS_deffile("XS::APItest::cv_set_call_checker_multi_sum", XS_XS__APItest_cv_set_call_checker_multi_sum);
        newXS_deffile("XS::APItest::test_cophh", XS_XS__APItest_test_cophh);
        newXS_deffile("XS::APItest::test_coplabel", XS_XS__APItest_test_coplabel);
        newXS_deffile("XS::APItest::example_cophh_2hv", XS_XS__APItest_example_cophh_2hv);
        newXS_deffile("XS::APItest::test_savehints", XS_XS__APItest_test_savehints);
        newXS_deffile("XS::APItest::test_copyhints", XS_XS__APItest_test_copyhints);
        newXS_deffile("XS::APItest::test_op_list", XS_XS__APItest_test_op_list);
        newXS_deffile("XS::APItest::test_op_linklist", XS_XS__APItest_test_op_linklist);
        newXS_deffile("XS::APItest::peep_enable", XS_XS__APItest_peep_enable);
        newXS_deffile("XS::APItest::peep_disable", XS_XS__APItest_peep_disable);
        newXS_deffile("XS::APItest::peep_record", XS_XS__APItest_peep_record);
        newXS_deffile("XS::APItest::rpeep_record", XS_XS__APItest_rpeep_record);
        (void)newXSproto_portable("XS::APItest::multicall_each", XS_XS__APItest_multicall_each, file, "&@");
#if XSubPPtmpAAAC
        newXS_deffile("XS::APItest::clone_with_stack", XS_XS__APItest_clone_with_stack);
#endif
        newXS_deffile("XS::APItest::take_svref", XS_XS__APItest_take_svref);
        newXS_deffile("XS::APItest::take_avref", XS_XS__APItest_take_avref);
        newXS_deffile("XS::APItest::take_hvref", XS_XS__APItest_take_hvref);
        newXS_deffile("XS::APItest::take_cvref", XS_XS__APItest_take_cvref);
        (void)newXSproto_portable("XS::APItest::establish_cleanup", XS_XS__APItest_establish_cleanup, file, "$");
        (void)newXSproto_portable("XS::APItest::postinc", XS_XS__APItest_postinc, file, "$");
        newXS_deffile("XS::APItest::filter", XS_XS__APItest_filter);
        newXS_deffile("XS::APItest::lv_temp_object", XS_XS__APItest_lv_temp_object);
        newXS_deffile("XS::APItest::fill_hash_with_nulls", XS_XS__APItest_fill_hash_with_nulls);
        newXS_deffile("XS::APItest::newHVhv", XS_XS__APItest_newHVhv);
        newXS_deffile("XS::APItest::SvIsCOW", XS_XS__APItest_SvIsCOW);
        (void)newXSproto_portable("XS::APItest::pad_scalar", XS_XS__APItest_pad_scalar, file, "$$");
        newXS_deffile("XS::APItest::fetch_pad_names", XS_XS__APItest_fetch_pad_names);
        (void)newXSproto_portable("XS::APItest::underscore_length", XS_XS__APItest_underscore_length, file, "");
        newXS_deffile("XS::APItest::stringify", XS_XS__APItest_stringify);
        newXS_deffile("XS::APItest::HvENAME", XS_XS__APItest_HvENAME);
        newXS_deffile("XS::APItest::xs_cmp", XS_XS__APItest_xs_cmp);
        newXS_deffile("XS::APItest::xs_cmp_undef", XS_XS__APItest_xs_cmp_undef);
        newXS_deffile("XS::APItest::SvPVbyte", XS_XS__APItest_SvPVbyte);
        newXS_deffile("XS::APItest::SvPVutf8", XS_XS__APItest_SvPVutf8);
        newXS_deffile("XS::APItest::setup_addissub", XS_XS__APItest_setup_addissub);
        newXS_deffile("XS::APItest::setup_rv2cv_addunderbar", XS_XS__APItest_setup_rv2cv_addunderbar);
#if XSubPPtmpAAAD
        newXS_deffile("XS::APItest::test_alloccopstash", XS_XS__APItest_test_alloccopstash);
#endif
        newXS_deffile("XS::APItest::test_newFOROP_without_slab", XS_XS__APItest_test_newFOROP_without_slab);
        newXS_deffile("XS::APItest::callregexec", XS_XS__APItest_callregexec);
        newXS_deffile("XS::APItest::lexical_import", XS_XS__APItest_lexical_import);
        newXS_deffile("XS::APItest::sv_mortalcopy", XS_XS__APItest_sv_mortalcopy);
        newXS_deffile("XS::APItest::newRV", XS_XS__APItest_newRV);
        newXS_deffile("XS::APItest::alias_av", XS_XS__APItest_alias_av);
        newXS_deffile("XS::APItest::cv_name", XS_XS__APItest_cv_name);
        newXS_deffile("XS::APItest::sv_catpvn", XS_XS__APItest_sv_catpvn);
        newXS_deffile("XS::APItest::test_newOP_CUSTOM", XS_XS__APItest_test_newOP_CUSTOM);
        newXS_deffile("XS::APItest::AUTOLOADtest::AUTOLOAD", XS_XS__APItest__AUTOLOADtest_AUTOLOAD);
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_bar", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_magic_foo", XS_XS__APItest__Magic_sv_magic_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_bar", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::mg_find_foo", XS_XS__APItest__Magic_mg_find_foo);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_bar", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XS::APItest::Magic::sv_unmagic_foo", XS_XS__APItest__Magic_sv_unmagic_foo);
        XSANY.any_i32 = 0;
        newXS_deffile("XS::APItest::Magic::sv_magic", XS_XS__APItest__Magic_sv_magic);
        newXS_deffile("XS::APItest::Magic::test_get_vtbl", XS_XS__APItest__Magic_test_get_vtbl);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_uni", XS_XS__APItest__Magic_test_isBLANK_uni);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC_uvchr", XS_XS__APItest__Magic_test_isBLANK_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_A", XS_XS__APItest__Magic_test_isBLANK_A);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_L1", XS_XS__APItest__Magic_test_isBLANK_L1);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC", XS_XS__APItest__Magic_test_isBLANK_LC);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_utf8", XS_XS__APItest__Magic_test_isBLANK_utf8);
        newXS_deffile("XS::APItest::Magic::test_isBLANK_LC_utf8", XS_XS__APItest__Magic_test_isBLANK_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isVERTWS_uni", XS_XS__APItest__Magic_test_isVERTWS_uni);
        newXS_deffile("XS::APItest::Magic::test_isVERTWS_utf8", XS_XS__APItest__Magic_test_isVERTWS_utf8);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_uni", XS_XS__APItest__Magic_test_isUPPER_uni);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC_uvchr", XS_XS__APItest__Magic_test_isUPPER_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_A", XS_XS__APItest__Magic_test_isUPPER_A);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_L1", XS_XS__APItest__Magic_test_isUPPER_L1);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC", XS_XS__APItest__Magic_test_isUPPER_LC);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_utf8", XS_XS__APItest__Magic_test_isUPPER_utf8);
        newXS_deffile("XS::APItest::Magic::test_isUPPER_LC_utf8", XS_XS__APItest__Magic_test_isUPPER_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_uni", XS_XS__APItest__Magic_test_isLOWER_uni);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC_uvchr", XS_XS__APItest__Magic_test_isLOWER_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_A", XS_XS__APItest__Magic_test_isLOWER_A);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_L1", XS_XS__APItest__Magic_test_isLOWER_L1);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC", XS_XS__APItest__Magic_test_isLOWER_LC);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_utf8", XS_XS__APItest__Magic_test_isLOWER_utf8);
        newXS_deffile("XS::APItest::Magic::test_isLOWER_LC_utf8", XS_XS__APItest__Magic_test_isLOWER_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_uni", XS_XS__APItest__Magic_test_isALPHA_uni);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC_uvchr", XS_XS__APItest__Magic_test_isALPHA_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_A", XS_XS__APItest__Magic_test_isALPHA_A);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_L1", XS_XS__APItest__Magic_test_isALPHA_L1);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC", XS_XS__APItest__Magic_test_isALPHA_LC);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_utf8", XS_XS__APItest__Magic_test_isALPHA_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHA_LC_utf8", XS_XS__APItest__Magic_test_isALPHA_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_uni", XS_XS__APItest__Magic_test_isWORDCHAR_uni);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC_uvchr", XS_XS__APItest__Magic_test_isWORDCHAR_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_A", XS_XS__APItest__Magic_test_isWORDCHAR_A);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_L1", XS_XS__APItest__Magic_test_isWORDCHAR_L1);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC", XS_XS__APItest__Magic_test_isWORDCHAR_LC);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_utf8", XS_XS__APItest__Magic_test_isWORDCHAR_utf8);
        newXS_deffile("XS::APItest::Magic::test_isWORDCHAR_LC_utf8", XS_XS__APItest__Magic_test_isWORDCHAR_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_uni", XS_XS__APItest__Magic_test_isALPHANUMERIC_uni);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC_uvchr", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_A", XS_XS__APItest__Magic_test_isALPHANUMERIC_A);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_L1", XS_XS__APItest__Magic_test_isALPHANUMERIC_L1);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_utf8", XS_XS__APItest__Magic_test_isALPHANUMERIC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALPHANUMERIC_LC_utf8", XS_XS__APItest__Magic_test_isALPHANUMERIC_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_uni", XS_XS__APItest__Magic_test_isALNUM_uni);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC_uvchr", XS_XS__APItest__Magic_test_isALNUM_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC", XS_XS__APItest__Magic_test_isALNUM_LC);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_utf8", XS_XS__APItest__Magic_test_isALNUM_utf8);
        newXS_deffile("XS::APItest::Magic::test_isALNUM_LC_utf8", XS_XS__APItest__Magic_test_isALNUM_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_uni", XS_XS__APItest__Magic_test_isDIGIT_uni);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC_uvchr", XS_XS__APItest__Magic_test_isDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_utf8", XS_XS__APItest__Magic_test_isDIGIT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC_utf8", XS_XS__APItest__Magic_test_isDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_A", XS_XS__APItest__Magic_test_isDIGIT_A);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_L1", XS_XS__APItest__Magic_test_isDIGIT_L1);
        newXS_deffile("XS::APItest::Magic::test_isDIGIT_LC", XS_XS__APItest__Magic_test_isDIGIT_LC);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_uni", XS_XS__APItest__Magic_test_isIDFIRST_uni);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC_uvchr", XS_XS__APItest__Magic_test_isIDFIRST_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_A", XS_XS__APItest__Magic_test_isIDFIRST_A);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_L1", XS_XS__APItest__Magic_test_isIDFIRST_L1);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC", XS_XS__APItest__Magic_test_isIDFIRST_LC);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_utf8", XS_XS__APItest__Magic_test_isIDFIRST_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDFIRST_LC_utf8", XS_XS__APItest__Magic_test_isIDFIRST_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_uni", XS_XS__APItest__Magic_test_isIDCONT_uni);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC_uvchr", XS_XS__APItest__Magic_test_isIDCONT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_A", XS_XS__APItest__Magic_test_isIDCONT_A);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_L1", XS_XS__APItest__Magic_test_isIDCONT_L1);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC", XS_XS__APItest__Magic_test_isIDCONT_LC);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_utf8", XS_XS__APItest__Magic_test_isIDCONT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isIDCONT_LC_utf8", XS_XS__APItest__Magic_test_isIDCONT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_uni", XS_XS__APItest__Magic_test_isSPACE_uni);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC_uvchr", XS_XS__APItest__Magic_test_isSPACE_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_A", XS_XS__APItest__Magic_test_isSPACE_A);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_L1", XS_XS__APItest__Magic_test_isSPACE_L1);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC", XS_XS__APItest__Magic_test_isSPACE_LC);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_utf8", XS_XS__APItest__Magic_test_isSPACE_utf8);
        newXS_deffile("XS::APItest::Magic::test_isSPACE_LC_utf8", XS_XS__APItest__Magic_test_isSPACE_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isASCII_uni", XS_XS__APItest__Magic_test_isASCII_uni);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC_uvchr", XS_XS__APItest__Magic_test_isASCII_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isASCII_A", XS_XS__APItest__Magic_test_isASCII_A);
        newXS_deffile("XS::APItest::Magic::test_isASCII_L1", XS_XS__APItest__Magic_test_isASCII_L1);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC", XS_XS__APItest__Magic_test_isASCII_LC);
        newXS_deffile("XS::APItest::Magic::test_isASCII_utf8", XS_XS__APItest__Magic_test_isASCII_utf8);
        newXS_deffile("XS::APItest::Magic::test_isASCII_LC_utf8", XS_XS__APItest__Magic_test_isASCII_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_uni", XS_XS__APItest__Magic_test_isCNTRL_uni);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC_uvchr", XS_XS__APItest__Magic_test_isCNTRL_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_A", XS_XS__APItest__Magic_test_isCNTRL_A);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_L1", XS_XS__APItest__Magic_test_isCNTRL_L1);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC", XS_XS__APItest__Magic_test_isCNTRL_LC);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_utf8", XS_XS__APItest__Magic_test_isCNTRL_utf8);
        newXS_deffile("XS::APItest::Magic::test_isCNTRL_LC_utf8", XS_XS__APItest__Magic_test_isCNTRL_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_uni", XS_XS__APItest__Magic_test_isPRINT_uni);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC_uvchr", XS_XS__APItest__Magic_test_isPRINT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_A", XS_XS__APItest__Magic_test_isPRINT_A);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_L1", XS_XS__APItest__Magic_test_isPRINT_L1);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC", XS_XS__APItest__Magic_test_isPRINT_LC);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_utf8", XS_XS__APItest__Magic_test_isPRINT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPRINT_LC_utf8", XS_XS__APItest__Magic_test_isPRINT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_uni", XS_XS__APItest__Magic_test_isGRAPH_uni);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC_uvchr", XS_XS__APItest__Magic_test_isGRAPH_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_A", XS_XS__APItest__Magic_test_isGRAPH_A);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_L1", XS_XS__APItest__Magic_test_isGRAPH_L1);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC", XS_XS__APItest__Magic_test_isGRAPH_LC);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_utf8", XS_XS__APItest__Magic_test_isGRAPH_utf8);
        newXS_deffile("XS::APItest::Magic::test_isGRAPH_LC_utf8", XS_XS__APItest__Magic_test_isGRAPH_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_uni", XS_XS__APItest__Magic_test_isPUNCT_uni);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC_uvchr", XS_XS__APItest__Magic_test_isPUNCT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_A", XS_XS__APItest__Magic_test_isPUNCT_A);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_L1", XS_XS__APItest__Magic_test_isPUNCT_L1);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC", XS_XS__APItest__Magic_test_isPUNCT_LC);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_utf8", XS_XS__APItest__Magic_test_isPUNCT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPUNCT_LC_utf8", XS_XS__APItest__Magic_test_isPUNCT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_uni", XS_XS__APItest__Magic_test_isXDIGIT_uni);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC_uvchr", XS_XS__APItest__Magic_test_isXDIGIT_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_A", XS_XS__APItest__Magic_test_isXDIGIT_A);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_L1", XS_XS__APItest__Magic_test_isXDIGIT_L1);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC", XS_XS__APItest__Magic_test_isXDIGIT_LC);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_utf8", XS_XS__APItest__Magic_test_isXDIGIT_utf8);
        newXS_deffile("XS::APItest::Magic::test_isXDIGIT_LC_utf8", XS_XS__APItest__Magic_test_isXDIGIT_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_uni", XS_XS__APItest__Magic_test_isPSXSPC_uni);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC_uvchr", XS_XS__APItest__Magic_test_isPSXSPC_LC_uvchr);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_A", XS_XS__APItest__Magic_test_isPSXSPC_A);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_L1", XS_XS__APItest__Magic_test_isPSXSPC_L1);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC", XS_XS__APItest__Magic_test_isPSXSPC_LC);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_utf8", XS_XS__APItest__Magic_test_isPSXSPC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isPSXSPC_LC_utf8", XS_XS__APItest__Magic_test_isPSXSPC_LC_utf8);
        newXS_deffile("XS::APItest::Magic::test_isQUOTEMETA", XS_XS__APItest__Magic_test_isQUOTEMETA);
        newXS_deffile("XS::APItest::Magic::test_toLOWER", XS_XS__APItest__Magic_test_toLOWER);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_L1", XS_XS__APItest__Magic_test_toLOWER_L1);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_LC", XS_XS__APItest__Magic_test_toLOWER_LC);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_uni", XS_XS__APItest__Magic_test_toLOWER_uni);
        newXS_deffile("XS::APItest::Magic::test_toLOWER_utf8", XS_XS__APItest__Magic_test_toLOWER_utf8);
        newXS_deffile("XS::APItest::Magic::test_toFOLD", XS_XS__APItest__Magic_test_toFOLD);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_LC", XS_XS__APItest__Magic_test_toFOLD_LC);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_uni", XS_XS__APItest__Magic_test_toFOLD_uni);
        newXS_deffile("XS::APItest::Magic::test_toFOLD_utf8", XS_XS__APItest__Magic_test_toFOLD_utf8);
        newXS_deffile("XS::APItest::Magic::test_toUPPER", XS_XS__APItest__Magic_test_toUPPER);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_LC", XS_XS__APItest__Magic_test_toUPPER_LC);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_uni", XS_XS__APItest__Magic_test_toUPPER_uni);
        newXS_deffile("XS::APItest::Magic::test_toUPPER_utf8", XS_XS__APItest__Magic_test_toUPPER_utf8);
        newXS_deffile("XS::APItest::Magic::test_toTITLE", XS_XS__APItest__Magic_test_toTITLE);
        newXS_deffile("XS::APItest::Magic::test_toTITLE_uni", XS_XS__APItest__Magic_test_toTITLE_uni);
        newXS_deffile("XS::APItest::Magic::test_toTITLE_utf8", XS_XS__APItest__Magic_test_toTITLE_utf8);
        newXS_deffile("XS::APItest::Magic::test_Gconvert", XS_XS__APItest__Magic_test_Gconvert);
        (void)newXSproto_portable("XS::APItest::Backrefs::apitest_weaken", XS_XS__APItest__Backrefs_apitest_weaken, file, "$");
        newXS_deffile("XS::APItest::Backrefs::has_backrefs", XS_XS__APItest__Backrefs_has_backrefs);

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#ifdef dTHX
    dTHX;
#endif
    HV *symbol_table = get_hv("XS::APItest::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef HV_DELETE
        { "HV_DELETE", 9, HV_DELETE },
#endif
#ifdef HV_DISABLE_UVAR_XKEY
        { "HV_DISABLE_UVAR_XKEY", 20, HV_DISABLE_UVAR_XKEY },
#endif
#ifdef HV_FETCH_ISSTORE
        { "HV_FETCH_ISSTORE", 16, HV_FETCH_ISSTORE },
#endif
#ifdef HV_FETCH_ISEXISTS
        { "HV_FETCH_ISEXISTS", 17, HV_FETCH_ISEXISTS },
#endif
#ifdef HV_FETCH_LVALUE
        { "HV_FETCH_LVALUE", 15, HV_FETCH_LVALUE },
#endif
#ifdef HV_FETCH_JUST_SV
        { "HV_FETCH_JUST_SV", 16, HV_FETCH_JUST_SV },
#endif
#ifdef G_SCALAR
        { "G_SCALAR", 8, G_SCALAR },
#endif
#ifdef G_ARRAY
        { "G_ARRAY", 7, G_ARRAY },
#endif
#ifdef G_VOID
        { "G_VOID", 6, G_VOID },
#endif
#ifdef G_DISCARD
        { "G_DISCARD", 9, G_DISCARD },
#endif
#ifdef G_EVAL
        { "G_EVAL", 6, G_EVAL },
#endif
#ifdef G_NOARGS
        { "G_NOARGS", 8, G_NOARGS },
#endif
#ifdef G_KEEPERR
        { "G_KEEPERR", 9, G_KEEPERR },
#endif
#ifdef G_NODEBUG
        { "G_NODEBUG", 9, G_NODEBUG },
#endif
#ifdef G_METHOD
        { "G_METHOD", 8, G_METHOD },
#endif
#ifdef G_FAKINGEVAL
        { "G_FAKINGEVAL", 12, G_FAKINGEVAL },
#endif
#ifdef IS_NUMBER_IN_UV
        { "IS_NUMBER_IN_UV", 15, IS_NUMBER_IN_UV },
#endif
#ifdef IS_NUMBER_GREATER_THAN_UV_MAX
        { "IS_NUMBER_GREATER_THAN_UV_MAX", 29, IS_NUMBER_GREATER_THAN_UV_MAX },
#endif
#ifdef IS_NUMBER_NOT_INT
        { "IS_NUMBER_NOT_INT", 17, IS_NUMBER_NOT_INT },
#endif
#ifdef IS_NUMBER_NEG
        { "IS_NUMBER_NEG", 13, IS_NUMBER_NEG },
#endif
#ifdef IS_NUMBER_INFINITY
        { "IS_NUMBER_INFINITY", 18, IS_NUMBER_INFINITY },
#endif
#ifdef IS_NUMBER_NAN
        { "IS_NUMBER_NAN", 13, IS_NUMBER_NAN },
#endif
#ifdef IS_NUMBER_TRAILING
        { "IS_NUMBER_TRAILING", 18, IS_NUMBER_TRAILING },
#endif
#ifdef PERL_SCAN_TRAILING
        { "PERL_SCAN_TRAILING", 18, PERL_SCAN_TRAILING },
#endif
#ifdef G_WANT
        { "G_WANT", 6, G_WANT },
#endif
        { "fallback_amg", 12, fallback_amg },
        { "to_sv_amg", 9, to_sv_amg },
        { "to_av_amg", 9, to_av_amg },
        { "to_hv_amg", 9, to_hv_amg },
        { "to_gv_amg", 9, to_gv_amg },
        { "to_cv_amg", 9, to_cv_amg },
        { "inc_amg", 7, inc_amg },
        { "dec_amg", 7, dec_amg },
        { "bool__amg", 9, bool__amg },
        { "numer_amg", 9, numer_amg },
        { "string_amg", 10, string_amg },
        { "not_amg", 7, not_amg },
        { "copy_amg", 8, copy_amg },
        { "abs_amg", 7, abs_amg },
        { "neg_amg", 7, neg_amg },
        { "iter_amg", 8, iter_amg },
        { "int_amg", 7, int_amg },
        { "lt_amg", 6, lt_amg },
        { "le_amg", 6, le_amg },
        { "gt_amg", 6, gt_amg },
        { "ge_amg", 6, ge_amg },
        { "eq_amg", 6, eq_amg },
        { "ne_amg", 6, ne_amg },
        { "slt_amg", 7, slt_amg },
        { "sle_amg", 7, sle_amg },
        { "sgt_amg", 7, sgt_amg },
        { "sge_amg", 7, sge_amg },
        { "seq_amg", 7, seq_amg },
        { "sne_amg", 7, sne_amg },
        { "nomethod_amg", 12, nomethod_amg },
        { "add_amg", 7, add_amg },
        { "add_ass_amg", 11, add_ass_amg },
        { "subtr_amg", 9, subtr_amg },
        { "subtr_ass_amg", 13, subtr_ass_amg },
        { "mult_amg", 8, mult_amg },
        { "mult_ass_amg", 12, mult_ass_amg },
        { "div_amg", 7, div_amg },
        { "div_ass_amg", 11, div_ass_amg },
        { "modulo_amg", 10, modulo_amg },
        { "modulo_ass_amg", 14, modulo_ass_amg },
        { "pow_amg", 7, pow_amg },
        { "pow_ass_amg", 11, pow_ass_amg },
        { "lshift_amg", 10, lshift_amg },
        { "lshift_ass_amg", 14, lshift_ass_amg },
        { "rshift_amg", 10, rshift_amg },
        { "rshift_ass_amg", 14, rshift_ass_amg },
        { "band_amg", 8, band_amg },
        { "band_ass_amg", 12, band_ass_amg },
        { "sband_amg", 9, sband_amg },
        { "sband_ass_amg", 13, sband_ass_amg },
        { "bor_amg", 7, bor_amg },
        { "bor_ass_amg", 11, bor_ass_amg },
        { "sbor_amg", 8, sbor_amg },
        { "sbor_ass_amg", 12, sbor_ass_amg },
        { "bxor_amg", 8, bxor_amg },
        { "bxor_ass_amg", 12, bxor_ass_amg },
        { "sbxor_amg", 9, sbxor_amg },
        { "sbxor_ass_amg", 13, sbxor_ass_amg },
        { "ncmp_amg", 8, ncmp_amg },
        { "scmp_amg", 8, scmp_amg },
        { "compl_amg", 9, compl_amg },
        { "scompl_amg", 10, scompl_amg },
        { "atan2_amg", 9, atan2_amg },
        { "cos_amg", 7, cos_amg },
        { "sin_amg", 7, sin_amg },
        { "exp_amg", 7, exp_amg },
        { "log_amg", 7, log_amg },
        { "sqrt_amg", 8, sqrt_amg },
        { "repeat_amg", 10, repeat_amg },
        { "repeat_ass_amg", 14, repeat_ass_amg },
        { "concat_amg", 10, concat_amg },
        { "concat_ass_amg", 14, concat_ass_amg },
        { "smart_amg", 9, smart_amg },
        { "ftest_amg", 9, ftest_amg },
        { "regexp_amg", 10, regexp_amg },
#ifndef G_WANT
        /* This is the default value: */
        { "G_WANT", 6, G_ARRAY|G_VOID },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    Perl_croak(aTHX_ 
			       "Couldn't add key '%s' to %%XS::APItest::",
			       value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    Perl_croak(aTHX_  "Couldn't add key '%s' to missing_hash",
			       value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 1375 "APItest.xs"
    newXS("XS::APItest::XSUB::XS_VERSION_undef", XS_XS__APItest__XSUB_XS_VERSION_undef, __FILE__);
    newXS("XS::APItest::XSUB::XS_VERSION_empty", XS_XS__APItest__XSUB_XS_VERSION_empty, __FILE__);
    newXS("XS::APItest::XSUB::XS_APIVERSION_invalid", XS_XS__APItest__XSUB_XS_APIVERSION_invalid, __FILE__);

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#line 1796 "APItest.xs"
    mymro.resolve = myget_linear_isa;
    mymro.name    = "justisa";
    mymro.length  = 7;
    mymro.kflags  = 0;
    mymro.hash    = 0;
    Perl_mro_register(aTHX_ &mymro);

#line 1918 "APItest.xs"
{
    MY_CXT_INIT;

    MY_CXT.i  = 99;
    MY_CXT.sv = newSVpv("initial",0);

    MY_CXT.bhkav = get_av("XS::APItest::bhkav", GV_ADDMULTI);
    MY_CXT.bhk_record = 0;

    BhkENTRY_set(&bhk_test, bhk_start, blockhook_test_start);
    BhkENTRY_set(&bhk_test, bhk_pre_end, blockhook_test_pre_end);
    BhkENTRY_set(&bhk_test, bhk_post_end, blockhook_test_post_end);
    BhkENTRY_set(&bhk_test, bhk_eval, blockhook_test_eval);
    Perl_blockhook_register(aTHX_ &bhk_test);

    MY_CXT.cscgv = gv_fetchpvs("XS::APItest::COMPILE_SCOPE_CONTAINER",
        GV_ADDMULTI, SVt_PVAV);
    MY_CXT.cscav = GvAV(MY_CXT.cscgv);

    BhkENTRY_set(&bhk_csc, bhk_start, blockhook_csc_start);
    BhkENTRY_set(&bhk_csc, bhk_pre_end, blockhook_csc_pre_end);
    Perl_blockhook_register(aTHX_ &bhk_csc);

    MY_CXT.peep_recorder = newAV();
    MY_CXT.rpeep_recorder = newAV();

    MY_CXT.orig_peep = PL_peepp;
    MY_CXT.orig_rpeep = PL_rpeepp;
    PL_peepp = my_peep;
    PL_rpeepp = my_rpeep;
}

#if XSubPPtmpAAAC
#endif
#line 3444 "APItest.xs"
	{
	HV* stash;
	SV** meth = NULL;
	CV* cv;
	stash = gv_stashpv("XS::APItest::TempLv", 0);
	if (stash)
	    meth = hv_fetchs(stash, "make_temp_mg_lv", 0);
	if (!meth)
	    croak("lost method 'make_temp_mg_lv'");
	cv = GvCV(*meth);
	CvLVALUE_on(cv);
	}

#line 3458 "APItest.xs"
{
    hintkey_rpn_sv = newSVpvs_share("XS::APItest/rpn");
    hintkey_calcrpn_sv = newSVpvs_share("XS::APItest/calcrpn");
    hintkey_stufftest_sv = newSVpvs_share("XS::APItest/stufftest");
    hintkey_swaptwostmts_sv = newSVpvs_share("XS::APItest/swaptwostmts");
    hintkey_looprest_sv = newSVpvs_share("XS::APItest/looprest");
    hintkey_scopelessblock_sv = newSVpvs_share("XS::APItest/scopelessblock");
    hintkey_stmtasexpr_sv = newSVpvs_share("XS::APItest/stmtasexpr");
    hintkey_stmtsasexpr_sv = newSVpvs_share("XS::APItest/stmtsasexpr");
    hintkey_loopblock_sv = newSVpvs_share("XS::APItest/loopblock");
    hintkey_blockasexpr_sv = newSVpvs_share("XS::APItest/blockasexpr");
    hintkey_swaplabel_sv = newSVpvs_share("XS::APItest/swaplabel");
    hintkey_labelconst_sv = newSVpvs_share("XS::APItest/labelconst");
    hintkey_arrayfullexpr_sv = newSVpvs_share("XS::APItest/arrayfullexpr");
    hintkey_arraylistexpr_sv = newSVpvs_share("XS::APItest/arraylistexpr");
    hintkey_arraytermexpr_sv = newSVpvs_share("XS::APItest/arraytermexpr");
    hintkey_arrayarithexpr_sv = newSVpvs_share("XS::APItest/arrayarithexpr");
    hintkey_arrayexprflags_sv = newSVpvs_share("XS::APItest/arrayexprflags");
    hintkey_DEFSV_sv = newSVpvs_share("XS::APItest/DEFSV");
    hintkey_with_vars_sv = newSVpvs_share("XS::APItest/with_vars");
    hintkey_join_with_space_sv = newSVpvs_share("XS::APItest/join_with_space");
    next_keyword_plugin = PL_keyword_plugin;
    PL_keyword_plugin = my_keyword_plugin;
}

#line 3491 "APItest.xs"
{
    CV *estcv = get_cv("XS::APItest::establish_cleanup", 0);
    cv_set_call_checker(estcv, THX_ck_entersub_establish_cleanup, (SV*)estcv);
}

#line 3509 "APItest.xs"
{
    CV *asscv = get_cv("XS::APItest::postinc", 0);
    cv_set_call_checker(asscv, THX_ck_entersub_postinc, (SV*)asscv);
}

#line 3558 "APItest.xs"
{
    CV *pscv = get_cv("XS::APItest::pad_scalar", 0);
    cv_set_call_checker(pscv, THX_ck_entersub_pad_scalar, (SV*)pscv);
}

#if XSubPPtmpAAAD
#endif
#line 10270 "APItest.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

