#!/bin/sh

VERSION="4.7"
OUT="$1"

# get the absolute path for the OUT file
OUT_NAME=$(basename ${OUT})
OUT_DIR=$(cd $(dirname ${OUT}); pwd)
OUT="${OUT_DIR}/${OUT_NAME}"

# the version check should be under the source directory
# where this script is located, instead of the currect directory
# where this script is excuted.
SRC_DIR=$(dirname $0)
SRC_DIR=$(cd ${SRC_DIR}; pwd)
cd "${SRC_DIR}"

v="$VERSION"

echo '#include "iw.h"' > "$OUT"
echo "const char iw_version[] = \"$v\";" >> "$OUT"
