/**
 * <copyright>
 * </copyright>
 *
 */
package org.opendds.modeling.sdk.model.GeneratorSpecification.Provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.opendds.modeling.sdk.model.GeneratorSpecification.GeneratorPackage;

import org.opendds.modeling.sdk.model.GeneratorSpecification.Util.GeneratorAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GeneratorItemProviderAdapterFactory extends GeneratorAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
			GeneratorEditPlugin.INSTANCE, GeneratorPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GeneratorItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(ITableItemLabelProvider.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.CodeGen} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeGenItemProvider codeGenItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.CodeGen}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeGenAdapter() {
		if (codeGenItemProvider == null) {
			codeGenItemProvider = new CodeGenItemProvider(this);
		}

		return codeGenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.genspec} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected genspecItemProvider genspecItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.genspec}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter creategenspecAdapter() {
		if (genspecItemProvider == null) {
			genspecItemProvider = new genspecItemProvider(this);
		}

		return genspecItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ModelFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelFileItemProvider modelFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ModelFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelFileAdapter() {
		if (modelFileItemProvider == null) {
			modelFileItemProvider = new ModelFileItemProvider(this);
		}

		return modelFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TargetDir} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetDirItemProvider targetDirItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TargetDir}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetDirAdapter() {
		if (targetDirItemProvider == null) {
			targetDirItemProvider = new TargetDirItemProvider(this);
		}

		return targetDirItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SearchPaths} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SearchPathsItemProvider searchPathsItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SearchPaths}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSearchPathsAdapter() {
		if (searchPathsItemProvider == null) {
			searchPathsItemProvider = new SearchPathsItemProvider(this);
		}

		return searchPathsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SearchLocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SearchLocationItemProvider searchLocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SearchLocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSearchLocationAdapter() {
		if (searchLocationItemProvider == null) {
			searchLocationItemProvider = new SearchLocationItemProvider(this);
		}

		return searchLocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocationVariable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocationVariableItemProvider locationVariableItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocationVariable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocationVariableAdapter() {
		if (locationVariableItemProvider == null) {
			locationVariableItemProvider = new LocationVariableItemProvider(this);
		}

		return locationVariableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocationPath} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocationPathItemProvider locationPathItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocationPath}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocationPathAdapter() {
		if (locationPathItemProvider == null) {
			locationPathItemProvider = new LocationPathItemProvider(this);
		}

		return locationPathItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Instances} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstancesItemProvider instancesItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Instances}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstancesAdapter() {
		if (instancesItemProvider == null) {
			instancesItemProvider = new InstancesItemProvider(this);
		}

		return instancesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Instance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceItemProvider instanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Instance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceAdapter() {
		if (instanceItemProvider == null) {
			instanceItemProvider = new InstanceItemProvider(this);
		}

		return instanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SwapBytes} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwapBytesItemProvider swapBytesItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SwapBytes}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwapBytesAdapter() {
		if (swapBytesItemProvider == null) {
			swapBytesItemProvider = new SwapBytesItemProvider(this);
		}

		return swapBytesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.QueueMessagesPerPool} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueueMessagesPerPoolItemProvider queueMessagesPerPoolItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.QueueMessagesPerPool}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueueMessagesPerPoolAdapter() {
		if (queueMessagesPerPoolItemProvider == null) {
			queueMessagesPerPoolItemProvider = new QueueMessagesPerPoolItemProvider(this);
		}

		return queueMessagesPerPoolItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.QueueInitialPool} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueueInitialPoolItemProvider queueInitialPoolItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.QueueInitialPool}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueueInitialPoolAdapter() {
		if (queueInitialPoolItemProvider == null) {
			queueInitialPoolItemProvider = new QueueInitialPoolItemProvider(this);
		}

		return queueInitialPoolItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxPacketSize} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaxPacketSizeItemProvider maxPacketSizeItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxPacketSize}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaxPacketSizeAdapter() {
		if (maxPacketSizeItemProvider == null) {
			maxPacketSizeItemProvider = new MaxPacketSizeItemProvider(this);
		}

		return maxPacketSizeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxSamplesPerPacket} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaxSamplesPerPacketItemProvider maxSamplesPerPacketItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxSamplesPerPacket}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaxSamplesPerPacketAdapter() {
		if (maxSamplesPerPacketItemProvider == null) {
			maxSamplesPerPacketItemProvider = new MaxSamplesPerPacketItemProvider(this);
		}

		return maxSamplesPerPacketItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.OptimumPacketSize} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OptimumPacketSizeItemProvider optimumPacketSizeItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.OptimumPacketSize}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOptimumPacketSizeAdapter() {
		if (optimumPacketSizeItemProvider == null) {
			optimumPacketSizeItemProvider = new OptimumPacketSizeItemProvider(this);
		}

		return optimumPacketSizeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ThreadPerConnection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThreadPerConnectionItemProvider threadPerConnectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ThreadPerConnection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThreadPerConnectionAdapter() {
		if (threadPerConnectionItemProvider == null) {
			threadPerConnectionItemProvider = new ThreadPerConnectionItemProvider(this);
		}

		return threadPerConnectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DatalinkReleaseDelay} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DatalinkReleaseDelayItemProvider datalinkReleaseDelayItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DatalinkReleaseDelay}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatalinkReleaseDelayAdapter() {
		if (datalinkReleaseDelayItemProvider == null) {
			datalinkReleaseDelayItemProvider = new DatalinkReleaseDelayItemProvider(this);
		}

		return datalinkReleaseDelayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DatalinkControlChunks} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DatalinkControlChunksItemProvider datalinkControlChunksItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DatalinkControlChunks}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatalinkControlChunksAdapter() {
		if (datalinkControlChunksItemProvider == null) {
			datalinkControlChunksItemProvider = new DatalinkControlChunksItemProvider(this);
		}

		return datalinkControlChunksItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocalAddressString} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocalAddressStringItemProvider localAddressStringItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.LocalAddressString}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLocalAddressStringAdapter() {
		if (localAddressStringItemProvider == null) {
			localAddressStringItemProvider = new LocalAddressStringItemProvider(this);
		}

		return localAddressStringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.EnableNagleAlgorithm} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnableNagleAlgorithmItemProvider enableNagleAlgorithmItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.EnableNagleAlgorithm}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnableNagleAlgorithmAdapter() {
		if (enableNagleAlgorithmItemProvider == null) {
			enableNagleAlgorithmItemProvider = new EnableNagleAlgorithmItemProvider(this);
		}

		return enableNagleAlgorithmItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryInitialDelay} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnRetryInitialDelayItemProvider connRetryInitialDelayItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryInitialDelay}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnRetryInitialDelayAdapter() {
		if (connRetryInitialDelayItemProvider == null) {
			connRetryInitialDelayItemProvider = new ConnRetryInitialDelayItemProvider(this);
		}

		return connRetryInitialDelayItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryBackoffMultiplier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnRetryBackoffMultiplierItemProvider connRetryBackoffMultiplierItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryBackoffMultiplier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnRetryBackoffMultiplierAdapter() {
		if (connRetryBackoffMultiplierItemProvider == null) {
			connRetryBackoffMultiplierItemProvider = new ConnRetryBackoffMultiplierItemProvider(this);
		}

		return connRetryBackoffMultiplierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryAttempts} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnRetryAttemptsItemProvider connRetryAttemptsItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.ConnRetryAttempts}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnRetryAttemptsAdapter() {
		if (connRetryAttemptsItemProvider == null) {
			connRetryAttemptsItemProvider = new ConnRetryAttemptsItemProvider(this);
		}

		return connRetryAttemptsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxOutputPausePeriod} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaxOutputPausePeriodItemProvider maxOutputPausePeriodItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MaxOutputPausePeriod}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaxOutputPausePeriodAdapter() {
		if (maxOutputPausePeriodItemProvider == null) {
			maxOutputPausePeriodItemProvider = new MaxOutputPausePeriodItemProvider(this);
		}

		return maxOutputPausePeriodItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PassiveReconnectDuration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PassiveReconnectDurationItemProvider passiveReconnectDurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PassiveReconnectDuration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPassiveReconnectDurationAdapter() {
		if (passiveReconnectDurationItemProvider == null) {
			passiveReconnectDurationItemProvider = new PassiveReconnectDurationItemProvider(this);
		}

		return passiveReconnectDurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PassiveConnectDuration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PassiveConnectDurationItemProvider passiveConnectDurationItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PassiveConnectDuration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPassiveConnectDurationAdapter() {
		if (passiveConnectDurationItemProvider == null) {
			passiveConnectDurationItemProvider = new PassiveConnectDurationItemProvider(this);
		}

		return passiveConnectDurationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DefaultToIPv6} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultToIPv6ItemProvider defaultToIPv6ItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.DefaultToIPv6}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultToIPv6Adapter() {
		if (defaultToIPv6ItemProvider == null) {
			defaultToIPv6ItemProvider = new DefaultToIPv6ItemProvider(this);
		}

		return defaultToIPv6ItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PortOffset} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PortOffsetItemProvider portOffsetItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.PortOffset}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPortOffsetAdapter() {
		if (portOffsetItemProvider == null) {
			portOffsetItemProvider = new PortOffsetItemProvider(this);
		}

		return portOffsetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.GroupAddress} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupAddressItemProvider groupAddressItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.GroupAddress}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupAddressAdapter() {
		if (groupAddressItemProvider == null) {
			groupAddressItemProvider = new GroupAddressItemProvider(this);
		}

		return groupAddressItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Reliable} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReliableItemProvider reliableItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Reliable}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReliableAdapter() {
		if (reliableItemProvider == null) {
			reliableItemProvider = new ReliableItemProvider(this);
		}

		return reliableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynBackoff} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynBackoffItemProvider synBackoffItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynBackoff}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynBackoffAdapter() {
		if (synBackoffItemProvider == null) {
			synBackoffItemProvider = new SynBackoffItemProvider(this);
		}

		return synBackoffItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynIntervalItemProvider synIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynIntervalAdapter() {
		if (synIntervalItemProvider == null) {
			synIntervalItemProvider = new SynIntervalItemProvider(this);
		}

		return synIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynTimeout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynTimeoutItemProvider synTimeoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.SynTimeout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynTimeoutAdapter() {
		if (synTimeoutItemProvider == null) {
			synTimeoutItemProvider = new SynTimeoutItemProvider(this);
		}

		return synTimeoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakDepth} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NakDepthItemProvider nakDepthItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakDepth}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNakDepthAdapter() {
		if (nakDepthItemProvider == null) {
			nakDepthItemProvider = new NakDepthItemProvider(this);
		}

		return nakDepthItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakInterval} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NakIntervalItemProvider nakIntervalItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakInterval}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNakIntervalAdapter() {
		if (nakIntervalItemProvider == null) {
			nakIntervalItemProvider = new NakIntervalItemProvider(this);
		}

		return nakIntervalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakMax} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NakMaxItemProvider nakMaxItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakMax}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNakMaxAdapter() {
		if (nakMaxItemProvider == null) {
			nakMaxItemProvider = new NakMaxItemProvider(this);
		}

		return nakMaxItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakTimeout} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NakTimeoutItemProvider nakTimeoutItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.NakTimeout}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNakTimeoutAdapter() {
		if (nakTimeoutItemProvider == null) {
			nakTimeoutItemProvider = new NakTimeoutItemProvider(this);
		}

		return nakTimeoutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TTL} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TTLItemProvider ttlItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TTL}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTTLAdapter() {
		if (ttlItemProvider == null) {
			ttlItemProvider = new TTLItemProvider(this);
		}

		return ttlItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.RcvBufferSIze} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RcvBufferSIzeItemProvider rcvBufferSIzeItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.RcvBufferSIze}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRcvBufferSIzeAdapter() {
		if (rcvBufferSIzeItemProvider == null) {
			rcvBufferSIzeItemProvider = new RcvBufferSIzeItemProvider(this);
		}

		return rcvBufferSIzeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TransportConfig} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransportConfigItemProvider transportConfigItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TransportConfig}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransportConfigAdapter() {
		if (transportConfigItemProvider == null) {
			transportConfigItemProvider = new TransportConfigItemProvider(this);
		}

		return transportConfigItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.UdpTransport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UdpTransportItemProvider udpTransportItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.UdpTransport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUdpTransportAdapter() {
		if (udpTransportItemProvider == null) {
			udpTransportItemProvider = new UdpTransportItemProvider(this);
		}

		return udpTransportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TcpTransport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TcpTransportItemProvider tcpTransportItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TcpTransport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTcpTransportAdapter() {
		if (tcpTransportItemProvider == null) {
			tcpTransportItemProvider = new TcpTransportItemProvider(this);
		}

		return tcpTransportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MulticastTransport} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MulticastTransportItemProvider multicastTransportItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.MulticastTransport}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMulticastTransportAdapter() {
		if (multicastTransportItemProvider == null) {
			multicastTransportItemProvider = new MulticastTransportItemProvider(this);
		}

		return multicastTransportItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Transports} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransportsItemProvider transportsItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.Transports}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransportsAdapter() {
		if (transportsItemProvider == null) {
			transportsItemProvider = new TransportsItemProvider(this);
		}

		return transportsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TransportRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransportRefItemProvider transportRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.opendds.modeling.sdk.model.GeneratorSpecification.TransportRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransportRefAdapter() {
		if (transportRefItemProvider == null) {
			transportRefItemProvider = new TransportRefItemProvider(this);
		}

		return transportRefItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (codeGenItemProvider != null)
			codeGenItemProvider.dispose();
		if (genspecItemProvider != null)
			genspecItemProvider.dispose();
		if (modelFileItemProvider != null)
			modelFileItemProvider.dispose();
		if (targetDirItemProvider != null)
			targetDirItemProvider.dispose();
		if (searchPathsItemProvider != null)
			searchPathsItemProvider.dispose();
		if (searchLocationItemProvider != null)
			searchLocationItemProvider.dispose();
		if (locationVariableItemProvider != null)
			locationVariableItemProvider.dispose();
		if (locationPathItemProvider != null)
			locationPathItemProvider.dispose();
		if (instancesItemProvider != null)
			instancesItemProvider.dispose();
		if (instanceItemProvider != null)
			instanceItemProvider.dispose();
		if (swapBytesItemProvider != null)
			swapBytesItemProvider.dispose();
		if (queueMessagesPerPoolItemProvider != null)
			queueMessagesPerPoolItemProvider.dispose();
		if (queueInitialPoolItemProvider != null)
			queueInitialPoolItemProvider.dispose();
		if (maxPacketSizeItemProvider != null)
			maxPacketSizeItemProvider.dispose();
		if (maxSamplesPerPacketItemProvider != null)
			maxSamplesPerPacketItemProvider.dispose();
		if (optimumPacketSizeItemProvider != null)
			optimumPacketSizeItemProvider.dispose();
		if (threadPerConnectionItemProvider != null)
			threadPerConnectionItemProvider.dispose();
		if (datalinkReleaseDelayItemProvider != null)
			datalinkReleaseDelayItemProvider.dispose();
		if (datalinkControlChunksItemProvider != null)
			datalinkControlChunksItemProvider.dispose();
		if (localAddressStringItemProvider != null)
			localAddressStringItemProvider.dispose();
		if (enableNagleAlgorithmItemProvider != null)
			enableNagleAlgorithmItemProvider.dispose();
		if (connRetryInitialDelayItemProvider != null)
			connRetryInitialDelayItemProvider.dispose();
		if (connRetryBackoffMultiplierItemProvider != null)
			connRetryBackoffMultiplierItemProvider.dispose();
		if (connRetryAttemptsItemProvider != null)
			connRetryAttemptsItemProvider.dispose();
		if (maxOutputPausePeriodItemProvider != null)
			maxOutputPausePeriodItemProvider.dispose();
		if (passiveReconnectDurationItemProvider != null)
			passiveReconnectDurationItemProvider.dispose();
		if (passiveConnectDurationItemProvider != null)
			passiveConnectDurationItemProvider.dispose();
		if (defaultToIPv6ItemProvider != null)
			defaultToIPv6ItemProvider.dispose();
		if (portOffsetItemProvider != null)
			portOffsetItemProvider.dispose();
		if (groupAddressItemProvider != null)
			groupAddressItemProvider.dispose();
		if (reliableItemProvider != null)
			reliableItemProvider.dispose();
		if (synBackoffItemProvider != null)
			synBackoffItemProvider.dispose();
		if (synIntervalItemProvider != null)
			synIntervalItemProvider.dispose();
		if (synTimeoutItemProvider != null)
			synTimeoutItemProvider.dispose();
		if (nakDepthItemProvider != null)
			nakDepthItemProvider.dispose();
		if (nakIntervalItemProvider != null)
			nakIntervalItemProvider.dispose();
		if (nakMaxItemProvider != null)
			nakMaxItemProvider.dispose();
		if (nakTimeoutItemProvider != null)
			nakTimeoutItemProvider.dispose();
		if (ttlItemProvider != null)
			ttlItemProvider.dispose();
		if (rcvBufferSIzeItemProvider != null)
			rcvBufferSIzeItemProvider.dispose();
		if (transportConfigItemProvider != null)
			transportConfigItemProvider.dispose();
		if (udpTransportItemProvider != null)
			udpTransportItemProvider.dispose();
		if (tcpTransportItemProvider != null)
			tcpTransportItemProvider.dispose();
		if (multicastTransportItemProvider != null)
			multicastTransportItemProvider.dispose();
		if (transportsItemProvider != null)
			transportsItemProvider.dispose();
		if (transportRefItemProvider != null)
			transportRefItemProvider.dispose();
	}

}
