Before you create an Issue...
=============================

There are better Places for Support
-----------------------------------
We want your question to be answered, so it is important that you ask at the right place. Be aware that an issue tracker is not the best place to ask for support. An issue tracker is used to track issues (bugs or feature requests).
Instead, please use [stackoverflow.com](http://stackoverflow.com/questions/tagged/greenrobot-eventbus?sort=frequent) and use the tag [greenrobot-eventbus](http://stackoverflow.com/tags/greenrobot-eventbus/info) for your question.

If you want professional support, check http://greenrobot.org/contact-support/.

Examples for support questions that are more likely to be answered on StackOverflow:

* Asking how something works
* Asking how to use EventBus in a specific scenario
* Your app crashes/misbehaves and you are not sure why

The perfect Issue Report
------------------------
A couple of simple steps can save time for everyone.

Check before reporting:

* It's not a support inquiry
* You have read the docs
* You searched the web and stackoverflow
* You searched existing issues to avoid duplicates

Reporting bugs:

 * Please investigate if is the bug is really caused by the library. Isolate the issue: what's the minimal code to reproduce the bug?
 * Bonus steps to gain extra karma points: once you isolated and identified the issue, you can prepare an push request. Submit an unit test causing the bug, and ideally a fix for the bug.

Requesting features:

 * Ask yourself: is the feature useful for a majority users? One of our major goals is to keep the API simple and concise. We do not want to cover all possible use cases, but those that make 80% of users happy.

A Note on Pull Requests
=======================
Pull requests (and issues) may queue up up a bit. Usually, pull requests and issues are checked when new releases are planned.

For bigger pull requests, it's a good idea to check with the maintainer upfront about the idea and the implementation outline.

Thanks for reading!
===================
It's your contributions and feedback that makes maintaining this library fun.
